/*****************************************************************************
 *============================================================================
 *                               HISTORY
 * Below this line, this part is controlled by PVCS VM. DO NOT MODIFY!!
 *------------------------------------------------------------------------------
 * $Log$
 *
 *------------------------------------------------------------------------------
 * Upper this line, this part is controlled by PVCS VM. DO NOT MODIFY!!
 *============================================================================
 ****************************************************************************/
/*****************************************************************************
 *
 * Filename:
 * ---------
 *    linux_socket.c
 *
 * Project:
 * --------
 *    Audio Route
 *
 * Description:
 * ------------
 *    This is a proprietary linux socket interface for bt agent to communicate each other.
 *
 * Author:
 * -------
 *    Iverson Hsieh
 *
 *============================================================================
 ****************************************************************************/


/*****************************************************************/
/*                       INCLUDE FILES                           */
/*****************************************************************/
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stddef.h>
#include <errno.h>
#include <unistd.h>

#include <sys/time.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <fcntl.h>

#include <sys/un.h>

#include "sys_debug.h"

/*****************************************************************/
/*                     MACROS & CONTSTANTS                       */
/*****************************************************************/

/*****************************************************************/
/*                      DATA STRUCTURE                           */
/*****************************************************************/


/*****************************************************************/
/*                      FUNCTION PROTOTYPE                       */
/*****************************************************************/

/*****************************************************************/
/*                      EXTERNAL VARIABLE                        */
/*****************************************************************/

/*****************************************************************/
/*              VARIABLE DECLARATION (GLOBAL & LOCAL)            */
/*****************************************************************/

/*****************************************************************/
/*                 LOCAL FUNTION IMPLEMENTATION                  */
/*****************************************************************/

/*
 *  Datagram socket server implementation.
 */
int socket_gram_srv_create(const char *name)
{
    int sock;
    struct sockaddr_un un_addr;

    /* Create socket from which to read. */
    sock = socket(AF_UNIX, SOCK_DGRAM, 0);
    if (sock < 0) {        
        SYS_Loge("socket srv [%s]: opening datagram socket fail!\n", name);
        exit(1);
    }

    /* Create name. */
    unlink(name);
    un_addr.sun_family = AF_UNIX;
    strcpy(un_addr.sun_path, name);

    /* Bind the UNIX domain address to the created socket */
    if (bind(sock, (struct sockaddr *)&un_addr, sizeof(struct sockaddr_un)))
    {
        SYS_Loge("socket srv [%s]: binding name to datagram socket fail!\n", name);
        exit(1);
    }

    return sock;
}

void socket_gram_srv_close(int sock, const char *name)
{
    close(sock);
    unlink(name);  
}

ssize_t socket_gram_srv_recv(int sock, char *buf, int len)
{
    ssize_t ret;

    if ((ret = recv(sock, buf, len, 0)) < 0)
    {
        SYS_Loge("socket srv [%d]: receiving datagram packet fail!\n", sock);
        perror("\n");
        return -1;
    }

    return ret;
}

ssize_t socket_gram_srv_recvfrom(int sock, char *buf, int len, struct sockaddr_un *cli_addr, socklen_t *sock_len)
//ssize_t socket_gram_srv_recvfrom(int sock, char *buf, int len, struct sockaddr_un *cli_addr)
{
	ssize_t ret;

	if ((ret = recvfrom(sock, buf, len, 0, (struct sockaddr *)cli_addr, sock_len)) < 0)
	{
		SYS_Loge("SOCK_GRAM server [%d]: receiving data stream packet fail!\n", sock);
		perror("\n");
		return -1;
	}
	SYS_Logd("SOCK_GRAM server [%d]: reciveing %ld bytes from [%s]", sock, ret, cli_addr->sun_path);

	return ret;
}

ssize_t socket_gram_srv_send(int sock, char *data, int len)
{
    ssize_t ret;

    if((ret = send(sock, data, len, 0)) <= 0)
    {
        SYS_Loge("socket srv [%d]: sending datagram packet fail!\n", sock);
        perror("\n");
        return -1;
    }

    return ret;
}

ssize_t socket_gram_srv_sendto(int sock, char *data, ssize_t len, struct sockaddr *cli_addr, socklen_t sock_len)
{
	ssize_t ret;
	ret = sendto(sock, data, len, 0, (struct sockaddr *) cli_addr, sock_len);
	if (ret != len){
		SYS_Loge("Sock [%d] sending datagram packet fail!\n", sock);
		perror("\n");
		return -1;
	}

	return ret;
}

/*
 *  Datagram socket client implementation.
 */
int socket_gram_clnt_create(void)
{
    int sock;

    /* Create socket on which to send. */
    sock = socket(AF_UNIX, SOCK_DGRAM, 0);
    if (sock < 0)
    {
        SYS_Loge("socket client: open datagram packet fail!\n");
        exit(1);
    }

    return sock;
}

void socket_gram_clnt_close(int sock)
{
    close(sock);
}

ssize_t socket_gram_clnt_recv(int sock, char *buf, int len)
{
    ssize_t ret;

    ret = recv(sock, buf, len, 0);
    if (ret < 0)
    {
        SYS_Loge("socket client [%d]: receiving datagram packet fail!\n", sock);
        perror("\n");
        return -1;
    }

    return ret;
}

ssize_t socket_gram_clnt_sendto(int sock, char *name, char *data, int len)
{
	struct sockaddr_un un_addr;
	ssize_t ret;

	/* Construct name of socket to send to. */
	un_addr.sun_family = AF_UNIX;
	strcpy(un_addr.sun_path, name);

	/* Send message. */
	ret = sendto(sock, data, len, 0, (struct sockaddr *)&un_addr, sizeof(struct sockaddr_un));
	if (ret < 0)
	{
		SYS_Loge("socket client [%d]: sending datagram packet fail!\n", sock);
		perror("\n");
	}

	return ret;
}

/*
 *  Data stream socket server implementation.
 */
int socket_stream_srv_create(const char *name)
{
    int sock;    
    struct sockaddr_un un_addr;
    
    sock = socket(AF_UNIX, SOCK_STREAM, 0);
    if (sock < 0)
    {        
        SYS_Loge("socket srv [%s]: opening data stream socket fail!\n", name);
        exit(1);
    }

    /* Create name. */
    unlink(name);
    un_addr.sun_family = AF_UNIX;
    strcpy(un_addr.sun_path, name);    

    /* Bind the UNIX domain address to the created socket */
    if (bind(sock, (struct sockaddr *)&un_addr, sizeof(struct sockaddr_un)))
    {
        SYS_Loge("socket srv [%s]: binding name to data stream socket fail!\n", name);
        exit(1);
    }

    return sock;
}

void socket_stream_srv_close(int sock, const char *name)
{
    close(sock);
    unlink(name);  
}

void socket_stream_srv_accept_clnt_close(int sock)
{
    close(sock);
}

int socket_stream_srv_listen(int sock)
{
    int ret;

    if ((ret = listen(sock, 5)) < 0)
    {        
        SYS_Loge("socket srv [%s]: listening data stream socket fail!\n", sock);
        perror("\n");
        exit(1);
    }

    return ret;
}

int socket_stream_srv_accept(int sock)
{
    int client_sockfd;
    socklen_t client_len;
    struct sockaddr_un client_addr;


    client_len = sizeof(client_addr);
    client_sockfd = accept(sock,  (struct sockaddr *)&client_addr, &client_len);
    if(client_sockfd < 0)
    {
        SYS_Loge("socket srv [%d]: accept data stream packet fail!\n", sock);
        perror("\n");
        return -1;
    }

    return client_sockfd;
}

int socket_stream_srv_set_timeout(int sock, int s, int ms)
{
    struct timeval tv;

    tv.tv_sec = s;
    tv.tv_usec = 0;

    setsockopt(sock, SOL_SOCKET, SO_RCVTIMEO, (char *)&tv,sizeof(struct timeval));

    return 0;
}

int socket_stream_srv_recv(int sock, char *buf, int len)
{
    int ret;

    if ((ret = recv(sock, buf, len, 0)) < 0)
    {
        SYS_Loge("socket srv [%d]: receiving data stream packet fail!\n", sock);
        perror("\n");
        return -1;
    }

    return ret;
}

int socket_stream_srv_send(int sock, char *data, int len)
{
    int ret;

    if((ret = send(sock, data, len, 0)) <= 0)
    {
        SYS_Loge("socket srv [%d]: sending data stream packet fail!\n", sock);
        perror("\n");
        return -1;
    }

    return ret;
}

/*
 *  Data stream socket client implementation.
 */
int socket_stream_clnt_create(const char *name)
{
    int sock;
    int ret;
    struct sockaddr_un un_addr;

    sock = socket(AF_UNIX, SOCK_STREAM, 0);
    if (sock < 0)
    {
        SYS_Loge("socket client: open stream packet fail!\n");
        exit(1);
    }

    un_addr.sun_family = AF_UNIX;
    strcpy(un_addr.sun_path, name);  

    if ((ret = connect(sock, (struct sockaddr *)&un_addr, sizeof(struct sockaddr_un))) < 0)
    {
        SYS_Loge("socket client [%s]: connecting data stream socket fail!\n", name);
        perror("\n");
        exit(1);
    }

    return sock;
}

void socket_stream_clnt_close(int sock)
{
    close(sock);
}

int socket_stream_clnt_recv(int sock, char *buf, int len)
{
    int ret;

    if ((ret = recv(sock, buf, len, 0)) < 0)
    {
        SYS_Loge("socket client [%d]: receiving data stream packet fail!\n", sock);
        perror("\n");
        return -1;
    }

    return ret;
}

int socket_stream_clnt_send(int sock, char *data, int len)
{
    int ret;

    if((ret = send(sock, data, len, 0)) < 0)
    {
        SYS_Loge("socket client [%d]: sending data stream packet fail!\n", sock);
        perror("\n");
        return -1;
    }

    return ret;
}


