/**
 * For WPS page
 */
(function ($) {

	"use strict";

	
	$(function () {
		/*******************************************************************************************
		 * 
		 * Setup wizard init  page
		 *
		 *******************************************************************************************/
		var handler = null;

		$.clear_timeout = function() {
			if ( typeof(parent.t1) != "undefined" )
				clearTimeout(parent.t1);
			if ( typeof(parent.t2) != "undefined" )
				clearTimeout(parent.t2);
		};

		$.clear_timeout();

		$.get_wps_result = function() {
			handler = $.getData('wps_get_status.htm', function(json) {
				if ( json.wps_status == "2" ) {
					parent.t1 = setTimeout('$.get_wps_result();', 1000);
				} else if ( json.wps_status == "1" ) {
					setTimeout(function() {
						$.getData('wps_get_status.htm', function(json) {
						$.clear_timeout();
						$('.failure').hide();
						$('.process').hide();
						$('.success').show();
						if(wps_endis_configured == "1" && json.wps_now_configured == "5")
							$('.wpssuccess').html(wps_success_message_three);
						$("body,html").animate({scrollTop:0}, 200);
						$(window).trigger("resize");
						});
					}, 2000);
				} else {
					$.clear_timeout();
					$('.process').hide();
					$('.success').hide();
					$('.failure').show();
					if(json.wps_status == "4")
						$('.wpsfail').html(wps_pin_error);
					else if(json.wps_status == "5")
						$('.wpsfail').html(wps_fail_cancel);
					else if(json.wps_status == "6")
						$('.wpsfail').html(wps_add_failure_text3);
					else
						$('.wpsfail').html(wps_add_failure_text1);
					$("body,html").animate({scrollTop:0}, 200);
					$(window).trigger("resize");
				}
			});
		};

		$.count_down = function(max, count) {
			var left_time, minutes, seconds;

			minutes = parseInt(count / 60 );
			seconds = count % 60 >= 10 ? count % 60 : ("0" +  count % 60);
			left_time = minutes + ":" + seconds;
			$('.timeLabel:first').html(left_time);
			count--;

			if ( count >= 0 )
				parent.t2 = setTimeout('$.count_down('+max+', '+count+');', 1000);
			else {
				$.clear_timeout();
				$('.wpsfail').html(wps_add_failure_text1);
				$('.process').hide();
				$('.success').hide();
				$('.failure').show();
				$(window).trigger("resize");
			}
		}

		var totalTime = 0, count = 0;
		if ( $('.timeLabel', '.setup').length ) {
			totalTime = parseInt($('.timeLabel:first').html()) * 60;
			count = totalTime;
			$.count_down(totalTime, count);
			$.get_wps_result();
		}

		$.wpsPinShow = function() {
			if($('#pbc').is(':checked')) {
				$('#wps_note').show();
				$('#pin_note').hide();
			} else if($('#pin').is(':checked')) {
				$('#wps_note').hide();
				$('#pin_note').show();
			}
		}

		$.checkPinNum = function() {
			var i = 0,
			lpin = $('#pinNum').val(),
			accum = 0,
			tmp = "";

			for( i = 0; i < lpin.length; i++) {
				if( lpin.charAt(i) == ' ' || lpin.charAt(i) == '-' )
					continue;
				else
					tmp=tmp+lpin.charAt(i);
			}
			lpin =tmp;
			$('#hidden_PIN').val(lpin);
			if (lpin.length != 4 && lpin.length != 8) {
				$.addErrMsgAfter('pinNum', error_4or8);
				return false;
			}
			if ( !$.REG_NUM.test(lpin) ) {
				$.addErrMsgAfter('pinNum', error_wps_pin);
				return false;
			}
			if (lpin.length == 8) {
				lpin = parseFloat($('#hidden_PIN').val());
				accum += 3 * parseInt(lpin / 10000000) % 10;
				accum += 1 * parseInt(lpin / 1000000) % 10;
				accum += 3 * parseInt(lpin / 100000) % 10;
				accum += 1 * parseInt(lpin / 10000) % 10;
				accum += 3 * parseInt(lpin / 1000) % 10;
				accum += 1 * parseInt(lpin / 100) % 10;
				accum += 3 * parseInt(lpin / 10) % 10;
				accum += 1 * parseInt(lpin / 1) % 10;
				if (0 != (accum % 10)) {
					$.addErrMsgAfter('pinNum', error_wps_pin);
					return false;
				}
			}
			return true;
		}

		if ( $('#clientWpsForm', '.setup').length ) {
			$('#wpsBt').click(function() {
				$('input[name=submit_flag]', '#clientWpsForm').val("wps");
				$.postForm('#clientWpsForm', '', function(json) {
					location.href = "/wps.htm";
				});
			});
		}

		if ( $('#clientCancelWpsForm', '.setup').length ) {
			$('#backBt').click(function() {
				$("input[name='submit_flag']").val("stop_wps_status");
				$.postForm('#clientCancelWpsForm', '', function(json) {
					location.href = "/ca_extender.htm";
				});
			});

			$('#retryBt').click(function() {
				$("input[name='submit_flag']").val("wps");
				$.postForm('#clientCancelWpsForm', '', function(json) {
					totalTime = count = 120;
					$.clear_timeout();
					$.count_down(totalTime, count);
					$('.success').hide();
					$('.failure').hide();
					$('.process').show();
					$.get_wps_result();
				});
			});

			$('#nextBt').click(function() {
				location.href = "/registerInfo.htm";
			});
		}

		/*******************************************************************************************
		 * 
		 * WPS page
		 *
		 *******************************************************************************************/
		$.post_setup_wps_retry = function (time) {
			totalTime = count = time;
			$('.sliderWrap').hide();
			$('#content').show();
			$('#fixedFooter').show();
			$('.success').hide();
			$('.failure').hide();
			$('.process').hide();
			if(time == 120) {
				$('.process_wps').show();
			} else {
				$('.process_pin').show();
				$('#showPINNum').html($('#pinNum').val());
			}
			$('.timeLabel').show();
			$('#backBt').show();
			$.count_down(totalTime, count);
			$.get_wps_result();
			$("body,html").animate({scrollTop:0}, 100);
		};
		if ( $('#clientWpsForm', '.postSetup').length ) {
			if(WPSenable == '0') {
				$('#wpsBt').css({"background-color": "gray"});
				$('#wpsBt').prop('disabled', true);
				$('#nextStep').css({"background-color": "gray"});
				$('#nextStep').prop('disabled', true);
			}
			$('#wpsBt').click(function() {
				if(WPSenable == '1')
				{
					$('input[name=submit_flag]', '#clientWpsForm').val("wps");
					$.postForm('#clientWpsForm', '', function(json) {
					if( json.status == '1')
					{
						$.clear_timeout();
						$.post_setup_wps_retry(120);
					}
					else
					{
						$.alertBox(json.msg);
					}
					});
				}
			});
			$('#nextStep').click(function() {
				$('.errorMsg').remove();
				$.checkPinNum();
				$('input[name=submit_flag]', '#clientWpsForm').val("wps_pin");
				if ( !$('.errorMsg').length ) {
					$.postForm('#clientWpsForm', '', function(json) {
						if( json.status == '1'){
							$.clear_timeout();
							$.post_setup_wps_retry(240);
						}else {
							$.alertBox(json.msg);
						}
					});
				}
			});
		}


		if ( $('#clientCancelWpsForm', '.postSetup').length ) {
			$('#backBt').click(function() {
				$("input[name='submit_flag']", '#clientCancelWpsForm').val("stop_wps_status");
				$.postForm('#clientCancelWpsForm', $('#clientWpsForm').attr("action"), function(json) {
					if (handler)
						handler.abort();
					$('.process').hide();
					$('.success').hide();
					$('.failure').show();
					$('.wpsfail').html(wps_fail_cancel);
					$(window).trigger("resize");
					$.clear_timeout();
				});
			});

			$('#backWpsBt').click(function() {
				$('#content').hide();
				$('#fixedFooter').hide();
				$('.sliderWrap').show();
				$.clear_timeout();
			});

			$('#retryBt').click(function() {
				if($('#pin').is(':checked'))
				{
					$("input[name='submit_flag']", '#clientCancelWpsForm').val("wps_pin");
					$('#pinRetry').val("1");
				}
				else
				{
					$("input[name='submit_flag']", '#clientCancelWpsForm').val("wps");
					$('#pinRetry').val("0");
				}
				$.postForm('#clientCancelWpsForm', $('#clientWpsForm').attr("action"), function(json) {
					$.clear_timeout();
					if($('#pin').is(':checked'))
						$.post_setup_wps_retry(240);
					else
						$.post_setup_wps_retry(120);
				});
			});

			$('#nextBt').click(function() {
				$.getData('wps_get_status.htm', function(json) {
					if(json.wps_status == "1" && wps_endis_configured == "1" &&  json.wps_now_configured == "5") {
						location.href = "/wifiSettings.htm"+$.ID_2;
					} else {
						$.clear_timeout();
						$('#content').hide();
						$('#fixedFooter').hide();
						$('.sliderWrap').show();
					}
				});
			});
		}
	}); // end ready function

}(jQuery));
