/**
 * For WiFi Settings page
 */
(function ($) {

	"use strict";
	
	var checkNum = 0;
	var modeArray = new Array();
	var modeValue = new Array();
	var modeArray5g = new Array();
	var modeValue5g = new Array();
	var ht20_array = new Array(
		//0 -> Africa:36-48 52-64 100-112 116-128 132-140
		  new Array ( "36", "40", "44", "48" ), //0 -> Africa
		  //1 -> Asia:36-48 52-64 100-112 116-128 132-140 149-165
		  new Array ( "36", "40", "44", "48", "149", "153", "157", "161", "165" ), //1 -> Asia
		  //2 -> Australia:36-48 52-64 100-112 116 132-140 149-165
		  new Array ( "36", "40", "44", "48", "52(DFS)", "56(DFS)", "60(DFS)", "64(DFS)", "100(DFS)", "104(DFS)", "108(DFS)", "112(DFS)", "116(DFS)", "132(DFS)", "136(DFS)", "140(DFS)", "149", "153", "157", "161", "165" ), //2 -> Australia
		  //3 -> Canada:   36-48 52-64 100-112 116 132-144 149-165
		  new Array ( "36", "40", "44", "48", "52(DFS)", "56(DFS)", "60(DFS)", "64(DFS)", "100(DFS)", "104(DFS)", "108(DFS)", "112(DFS)", "116(DFS)", "132(DFS)", "136(DFS)", "140(DFS)", "144(DFS)", "149", "153", "157", "161", "165", "169", "173", "177" ), //3 -> Canada
		  //4 -> Europe:36-48 52-64 100-112 116-128 132-140
		  new Array ( "36", "40", "44", "48", "52(DFS)", "56(DFS)", "60(DFS)", "64(DFS)", "100(DFS)", "104(DFS)", "108(DFS)", "112(DFS)", "116(DFS)", "120(DFS)", "124(DFS)", "128(DFS)", "132(DFS)", "136(DFS)", "140(DFS)" ), //4 -> Europe
		  //5 -> Israel:36-48 52-64
		  new Array ( "36", "40", "44", "48", "52(DFS)", "56(DFS)", "60(DFS)", "64(DFS)" ), //5 -> Israel
		  //6 -> Japan:36-48 52-64 100-112 116-128 132-144
		  new Array ( "36", "40", "44", "48", "52(DFS)", "56(DFS)", "60(DFS)", "64(DFS)", "100(DFS)", "104(DFS)", "108(DFS)", "112(DFS)", "116(DFS)", "120(DFS)", "124(DFS)", "128(DFS)", "132(DFS)", "136(DFS)", "140(DFS)" ), //6 -> Japan
		  //7 -> Korea:36-48 52-64 100-112 116-128 149-165
		  new Array ( "36", "40", "44", "48","149", "153", "157", "161" ), //7 -> Korea
		  //8 -> Mexico:36-48 52-64 100-112 116 132-140 149-165
		  new Array ( "36", "40", "44", "48","149", "153", "157", "161", "165" ), //8 -> Mexico
		  //9 -> South America:36-48 52-64 100-112 116-128 132-140 149-165
		  new Array ( "36", "40", "44", "48", "149", "153", "157", "161", "165" ), //9 -> South America
		  //10 -> North America:36-48 149-165
		  new Array ( "36", "40", "44", "48", "52(DFS)", "56(DFS)", "60(DFS)", "64(DFS)", "100(DFS)", "104(DFS)", "108(DFS)", "112(DFS)", "116(DFS)", "120(DFS)", "124(DFS)", "128(DFS)", "132(DFS)", "136(DFS)", "140(DFS)", "144(DFS)", "149", "153", "157", "161", "165", "169", "173", "177"), //10 -> North America
		  //11 -> China:36-48 52-64 149-165
		  new Array ("36", "40", "44", "48", "52(DFS)", "56(DFS)", "60(DFS)", "64(DFS)", "149", "153", "157", "161", "165" ), //11 -> China
		  //12 -> India:36-48 52-64 149-165
		  new Array ( "36", "40", "44", "48","149", "153", "157", "161", "165" ), //12 -> India
		  //13 -> Malaysia:36-48 52-64 100-112 116-128 149-165
		  new Array ( "36", "40", "44", "48","149", "153", "157", "161", "165" ), //13 -> Malaysia
		  //14 -> Middle East (Yemen):
		  new Array ( "" ), //14 -> Middle East (Yemen)
		  //15 -> Middle East (Qatar):149-165
		  new Array ( "149", "153", "157", "161", "165" ), //15 -> Middle East (Qatar)
		  //16 -> Middle East(Turkey):36-48 52-64 
		  new Array ( "36", "40", "44", "48" ), //16 -> Middle East(Kuwait)
		  //17 -> Middle East (Saudi Arabia):36-48 52-64 100-112 116-128 132-140 149-165
		  new Array ( "36", "40", "44", "48", "149", "153", "157", "161", "165" ), //17 -> Middle East (Saudi Arabia)
		  //18 -> Middle East (United Arab Emirates):
		  new Array ( "36", "40", "44", "48"), //18 -> Middle East (United Arab Emirates)
		  //19 -> Russia:36-48 52-64 132-140 149-165
		  new Array ( "36", "40", "44", "48", "52", "56", "60", "64", "132", "136", "140", "149", "153", "157", "161", "165"), //19 -> Russia
		  //20 -> Singapore:36-48 52-64 100-112 116-128 132-140 149-165
		  new Array ( "36", "40", "44", "48", "149", "153", "157", "161", "165" ), //20 -> Singapore
		  //21 -> Taiwan:   36-48 52-64 100-112 116-128 132-144 149-165
		  new Array ("56", "60", "64", "149", "153", "157", "161", "165" ), //21 -> Taiwan
		  //22 -> Middle East
		  new Array ( "36", "40", "44", "48", "52(DFS)", "56(DFS)", "60(DFS)", "64(DFS)" ), //22 -> Middle East
		  new Array ( "" ), //23
		  new Array(""), //24
		  new Array ( "36", "40", "44", "48", "52(DFS)", "56(DFS)", "60(DFS)", "64(DFS)", "100(DFS)", "104(DFS)", "108(DFS)", "112(DFS)", "116(DFS)", "120(DFS)", "124(DFS)", "128(DFS)", "132(DFS)", "136(DFS)", "140(DFS)", "149", "153", "157", "161", "165") //25 -> Hong Kong
		  );
	  var ht40_array = new Array(
		//0 -> Africa:36-48 52-64 100-112 116-128 132-140
		  new Array ( "" ), //0 -> Africa
		  //1 -> Asia:36-48 52-64 100-112 116-128 132-140 149-165
		  new Array ( "36", "40", "44", "48","149", "153", "157", "161" ), //1 -> Asia
		  //2 -> Australia:36-48 52-64 100-112 116 132-140 149-165
		  new Array ( "36", "40", "44", "48", "52(DFS)", "56(DFS)", "60(DFS)", "64(DFS)", "100(DFS)", "104(DFS)", "108(DFS)", "112(DFS)", "132(DFS)", "136(DFS)", "149", "153", "157", "161"), //2 -> Australia
		  //3 -> Canada:   36-48 52-64 100-112 116 132-144 149-165
		  new Array ( "36", "40", "44", "48", "52(DFS)", "56(DFS)", "60(DFS)", "64(DFS)", "100(DFS)", "104(DFS)", "108(DFS)", "112(DFS)", "132(DFS)", "136(DFS)", "140(DFS)", "144(DFS)", "149", "153", "157", "161", "165", "169", "173", "177" ), //3 -> Canada
		  //4 -> Europe:36-48 52-64 100-112 116-128 132-140
		  new Array ( "36", "40", "44", "48", "52(DFS)", "56(DFS)", "60(DFS)", "64(DFS)", "100(DFS)", "104(DFS)", "108(DFS)", "112(DFS)", "116(DFS)", "120(DFS)", "124(DFS)", "128(DFS)", "132(DFS)", "136(DFS)" ), //4 -> Europe
		  //5 -> Israel:36-48 52-64
		  new Array ( "36", "40", "44", "48", "52(DFS)", "56(DFS)", "60(DFS)", "64(DFS)" ), //5 -> Israel
		  //6 -> Japan:36-48 52-64 100-112 116-128 132-144
		  new Array ( "36", "40", "44", "48", "52(DFS)", "56(DFS)", "60(DFS)", "64(DFS)", "100(DFS)", "104(DFS)", "108(DFS)", "112(DFS)", "116(DFS)", "120(DFS)", "124(DFS)", "128(DFS)", "132(DFS)", "136(DFS)"), //6 -> Japan
		  //7 -> Korea:36-48 52-64 100-112 116-128 149-165
		  new Array ( "36", "40", "44", "48", "149", "153", "157", "161" ), //7 -> Korea
		  //8 -> Mexico:36-48 52-64 100-112 116 132-140 149-165
		  new Array ( "36", "40", "44", "48", "149", "153", "157", "161" ), //8 -> Mexico
		  //9 -> South America:36-48 52-64 100-112 116-128 132-140 149-165
		  new Array ( "36", "40", "44", "48", "149", "153", "157", "161" ), //9 -> South America
		  //10 -> North America:36-48 149-165
		  new Array ( "36", "40", "44", "48", "52(DFS)", "56(DFS)", "60(DFS)", "64(DFS)", "100(DFS)", "104(DFS)", "108(DFS)", "112(DFS)", "116(DFS)", "120(DFS)", "124(DFS)", "128(DFS)", "132(DFS)", "136(DFS)", "140(DFS)", "144(DFS)", "149", "153", "157", "161", "165", "169", "173", "177"), //10 -> North America
		  //11 -> China:36-48 52-64 149-165
		  new Array ("36", "40", "44", "48", "52(DFS)", "56(DFS)", "60(DFS)", "64(DFS)", "149", "153", "157", "161" ), //11 -> China
		  //12 -> India:36-48 52-64 149-165
		  new Array ( "36", "40", "44", "48", "149", "153", "157", "161" ), //12 -> India
		  //13 -> Malaysia:36-48 52-64 100-112 116-128 149-165
		  new Array ( "36", "40", "44", "48", "149", "153", "157", "161" ), //13 -> Malaysia
		  //14 -> Middle East (Yemen):
		  new Array ( "" ), //14 -> Middle East (Yemen)
		  //15 -> Middle East (Qatar):149-165
		  new Array ( "149", "153", "157", "161" ), //15 -> Middle East (Qatar)
		  //16 -> Middle East(Kuwait):36-48 52-64 
		  new Array ( "" ), //16 -> Middle East(Kuwait)
		  //17 -> Middle East (Saudi Arabia):36-48 52-64 100-112 116-128 132-140 149-165
		  new Array ( "" ), //17 -> Middle East (Saudi Arabia)
		  //18 -> Middle East (United Arab Emirates):
		  new Array ( "36", "40", "44", "48"), //18 -> Middle East (United Arab Emirates)
		  //19 -> Russia:36-48 52-64 132-140 149-165
		  new Array ( "36", "40", "44", "48", "52", "56", "60", "64", "132", "136", "149", "153", "157", "161"), //19 -> Russia
		  //20 -> Singapore:36-48 52-64 100-112 116-128 132-140 149-165
		  new Array ( "36", "40", "44", "48", "149", "153", "157", "161"), //20 -> Singapore
		  //21 -> Taiwan:   36-48 52-64 100-112 116-128 132-144 149-165
		  new Array ("60", "64", "149", "153", "157", "161" ), //21 -> Taiwan
		  //22 -> Middle East
		  new Array("36", "40", "44", "48", "52(DFS)", "56(DFS)", "60(DFS)", "64(DFS)"), //22 -> Middle East
		  new Array ( "" ), //23
		  new Array(""), //24
		  new Array ( "36", "40", "44", "48", "52(DFS)", "56(DFS)", "60(DFS)", "64(DFS)", "100(DFS)", "104(DFS)", "108(DFS)", "112(DFS)", "116(DFS)", "120(DFS)", "124(DFS)", "128(DFS)", "132(DFS)", "136(DFS)", "149", "153", "157", "161") //25 -> Hong Kong
		  );
	  var ht80_array = new Array(
		//0 -> Africa:36-48 52-64 100-112 116-128 132-140
		  new Array ( "" ), //0 -> Africa
		  //1 -> Asia:36-48 52-64 100-112 116-128 132-140 149-165
		  new Array ( "36", "40", "44", "48","149", "153", "157", "161" ), //1 -> Asia
		  //2 -> Australia:36-48 52-64 100-112 116 132-140 149-165
		  new Array ( "36", "40", "44", "48", "52(DFS)", "56(DFS)", "60(DFS)", "64(DFS)", "100(DFS)", "104(DFS)", "108(DFS)", "112(DFS)", "149", "153", "157", "161"), //2 -> Australia
		  //3 -> Canada:   36-48 52-64 100-112 116 132-144 149-165
		  new Array ( "36", "40", "44", "48", "52(DFS)", "56(DFS)", "60(DFS)", "64(DFS)", "100(DFS)", "104(DFS)", "108(DFS)", "112(DFS)", "149", "153", "157", "161", "165", "169", "173", "177" ), //3 -> Canada
		  //4 -> Europe:36-48 52-64 100-112 116-128 132-140
		  new Array ( "36", "40", "44", "48", "52(DFS)", "56(DFS)", "60(DFS)", "64(DFS)", "100(DFS)", "104(DFS)", "108(DFS)", "112(DFS)", "116(DFS)", "120(DFS)", "124(DFS)", "128(DFS)" ), //4 -> Europe
		  //5 -> Israel:36-48 52-64
		  new Array ( "36", "40", "44", "48", "52(DFS)", "56(DFS)", "60(DFS)", "64(DFS)" ), //5 -> Israel
		  //6 -> Japan:36-48 52-64 100-112 116-128 132-144
		  new Array ( "36", "40", "44", "48", "52(DFS)", "56(DFS)", "60(DFS)", "64(DFS)", "100(DFS)", "104(DFS)", "108(DFS)", "112(DFS)", "116(DFS)", "120(DFS)", "124(DFS)", "128(DFS)"), //6 -> Japan
		  //7 -> Korea:36-48 52-64 100-112 116-128 149-165
		  new Array ( "36", "40", "44", "48","149", "153", "157", "161" ), //7 -> Korea
		  //8 -> Mexico:36-48 52-64 100-112 116 132-140 149-165
		  new Array ( "36", "40", "44", "48","149", "153", "157", "161" ), //8 -> Mexico
		  //9 -> South America:36-48 52-64 100-112 116-128 132-140 149-165
		  new Array ( "36", "40", "44", "48", "149", "153", "157", "161" ), //9 -> South America
		  //10 -> North America:36-48 149-165
		  new Array ( "36", "40", "44", "48", "52(DFS)", "56(DFS)", "60(DFS)", "64(DFS)", "100(DFS)", "104(DFS)", "108(DFS)", "112(DFS)", "116(DFS)", "120(DFS)", "124(DFS)", "128(DFS)", "132(DFS)", "136(DFS)", "140(DFS)", "144(DFS)", "149", "153", "157", "161", "165", "169", "173", "177"), //10 -> North America
		  //11 -> China:36-48 52-64 149-165
		  new Array ("36", "40", "44", "48", "52(DFS)", "56(DFS)", "60(DFS)", "64(DFS)", "149", "153", "157", "161" ), //11 -> China
		  //12 -> India:36-48 52-64 149-165
		  new Array ( "36", "40", "44", "48", "149", "153", "157", "161" ), //12 -> India
		  //13 -> Malaysia:36-48 52-64 100-112 116-128 149-165
		  new Array ( "36", "40", "44", "48","149", "153", "157", "161" ), //13 -> Malaysia
		  //14 -> Middle East (Yemen):
		  new Array ( "" ), //14 -> Middle East (Yemen)
		  //15 -> Middle East (Qatar):149-165
		  new Array ( "149", "153", "157", "161" ), //15 -> Middle East (Qatar)
		  //16 -> Middle East(Turkey):36-48 52-64 
		  new Array ( "" ), //16 -> Middle East(Turkey)
		  //17 -> Middle East (Saudi Arabia):36-48 52-64 100-112 116-128 132-140 149-165
		  new Array ( "" ), //17 -> Middle East (Saudi Arabia)
		  //18 -> Middle East (United Arab Emirates):
		  new Array ( "36", "40", "44", "48" ), //18 -> Middle East (United Arab Emirates)
		  //19 -> Russia:36-48 52-64 132-140 149-165
		  new Array ( "36", "40", "44", "48", "52", "56", "60", "64", "149", "153", "157", "161"), //19 -> Russia
		  //20 -> Singapore:36-48 52-64 100-112 116-128 132-140 149-165
		  new Array ( "36", "40", "44", "48", "149", "153", "157", "161"), //20 -> Singapore
		  //21 -> Taiwan:   36-48 52-64 100-112 116-128 132-144 149-165
		  new Array ("149", "153", "157", "161" ), //21 -> Taiwan
		  //22 -> Middle East
		  new Array ( "36", "40", "44", "48", "52(DFS)", "56(DFS)", "60(DFS)", "64(DFS)" ), //22 -> Middle East
		  new Array ( "" ), //23
		  new Array(""), //24
		  new Array ( "36", "40", "44", "48", "52(DFS)", "56(DFS)", "60(DFS)", "64(DFS)", "100(DFS)", "104(DFS)", "108(DFS)", "112(DFS)", "116(DFS)", "120(DFS)", "124(DFS)", "128(DFS)", "149", "153", "157", "161") //25 -> Hong Kong
		  );
	  var ht160_array = new Array(
		//0 -> Africa:36-48 52-64 100-112 116-128 132-140
		  new Array ( "" ), //0 -> Africa
		  //1 -> Asia:36-48 52-64 100-112 116-128 132-140 149-165
		  new Array ( "36", "40", "44", "48","149", "153", "157", "161" ), //1 -> Asia
		  //2 -> Australia:36-48 52-64 100-112 116 132-140 149-165
		  new Array ( "36", "40", "44", "48", "52(DFS)", "56(DFS)", "60(DFS)", "64(DFS)"), //2 -> Australia
		  //3 -> Canada:   36-48 52-64 100-112 116 132-144 149-165
		  new Array ( "36", "40", "44", "48", "52(DFS)", "56(DFS)", "60(DFS)", "64(DFS)", "149", "153", "157", "161", "165", "169", "173", "177" ), //3 -> Canada
		  //4 -> Europe:36-48 52-64 100-112 116-128 132-140
		  new Array ( "36", "40", "44", "48", "52(DFS)", "56(DFS)", "60(DFS)", "64(DFS)", "100(DFS)", "104(DFS)", "108(DFS)", "112(DFS)", "116(DFS)", "120(DFS)", "124(DFS)", "128(DFS)" ), //4 -> Europe
		  //5 -> Israel:36-48 52-64
		  new Array ( "36", "40", "44", "48", "52(DFS)", "56(DFS)", "60(DFS)", "64(DFS)" ), //5 -> Israel
		  //6 -> Japan:36-48 52-64 100-112 116-128 132-144
		  new Array ( "36", "40", "44", "48", "52(DFS)", "56(DFS)", "60(DFS)", "64(DFS)", "100(DFS)", "104(DFS)", "108(DFS)", "112(DFS)", "116(DFS)", "120(DFS)", "124(DFS)", "128(DFS)"), //6 -> Japan
		  //7 -> Korea:36-48 52-64 100-112 116-128 149-165
		  new Array ( "36", "40", "44", "48","149", "153", "157", "161" ), //7 -> Korea
		  //8 -> Mexico:36-48 52-64 100-112 116 132-140 149-165
		  new Array ( "36", "40", "44", "48","149", "153", "157", "161" ), //8 -> Mexico
		  //9 -> South America:36-48 52-64 100-112 116-128 132-140 149-165
		  new Array ( "36", "40", "44", "48", "149", "153", "157", "161" ), //9 -> South America
		  //10 -> North America:36-48 149-165
		  new Array ( "36", "40", "44", "48", "52(DFS)", "56(DFS)", "60(DFS)", "64(DFS)", "100(DFS)", "104(DFS)", "108(DFS)", "112(DFS)", "116(DFS)", "120(DFS)", "124(DFS)", "128(DFS)", "149", "153", "157", "161", "165", "169", "173", "177"), //10 -> North America
		  //11 -> China:36-48 52-64 149-165
		  new Array ("36", "40", "44", "48", "52(DFS)", "56(DFS)", "60(DFS)", "64(DFS)"), //11 -> China
		  //12 -> India:36-48 52-64 149-165
		  new Array ( "36", "40", "44", "48", "149", "153", "157", "161" ), //12 -> India
		  //13 -> Malaysia:36-48 52-64 100-112 116-128 149-165
		  new Array ( "36", "40", "44", "48","149", "153", "157", "161" ), //13 -> Malaysia
		  //14 -> Middle East (Yemen):
		  new Array ( "" ), //14 -> Middle East (Yemen)
		  //15 -> Middle East (Qatar):149-165
		  new Array ( "149", "153", "157", "161" ), //15 -> Middle East (Qatar)
		  //16 -> Middle East(Turkey):36-48 52-64 
		  new Array ( "" ), //16 -> Middle East(Turkey)
		  //17 -> Middle East (Saudi Arabia):36-48 52-64 100-112 116-128 132-140 149-165
		  new Array ( "" ), //17 -> Middle East (Saudi Arabia)
		  //18 -> Middle East (United Arab Emirates):
		  new Array ( "36", "40", "44", "48" ), //18 -> Middle East (United Arab Emirates)
		  //19 -> Russia:36-48 52-64 132-140 149-165
		  new Array ( "36", "40", "44", "48", "52", "56", "60", "64"), //19 -> Russia
		  //20 -> Singapore:36-48 52-64 100-112 116-128 132-140 149-165
		  new Array ( "36", "40", "44", "48", "149", "153", "157", "161"), //20 -> Singapore
		  //21 -> Taiwan:   36-48 52-64 100-112 116-128 132-144 149-165
		  new Array ("149", "153", "157", "161" ), //21 -> Taiwan
		  //22 -> Middle East
		  new Array ( "36", "40", "44", "48", "52(DFS)", "56(DFS)", "60(DFS)", "64(DFS)"), //22 -> Middle East
		  new Array ( "" ), //23
		  new Array(""), //24
		  new Array ( "36", "40", "44", "48", "52(DFS)", "56(DFS)", "60(DFS)", "64(DFS)", "100(DFS)", "104(DFS)", "108(DFS)", "112(DFS)", "116(DFS)", "120(DFS)", "124(DFS)", "128(DFS)") //25 -> Hong Kong
		  );
  
	$(function () {
		/*******************************************************************************************
		*
		*	WiFi Settings page
		*
		******************************************************************************************/

		if ($('#wifiSettingsForm').length) {

			// toggle the various settings panes
			$('.sectionWrap').find('.expand').on('touchclick', function () {
				if ($(this).parents('.sectionWrap').hasClass('open')) {
					$(this)
						.find('i')
						.removeClass('dnintg-expanded')
						.addClass('dnintg-collapsed')
						.parents('.sectionWrap')
						.removeClass('open')
						.find('.sectionDetails')
						.slideUp();
				} else {
					$(this)
						.find('i')
						.removeClass('dnintg-collapsed')
						.addClass('dnintg-expanded')
						.parents('.sectionWrap')
						.addClass('open')
						.find('.sectionDetails')
						.slideDown();
				}
			});

			var opmode = document.getElementById('opMode');
			opmode.options[0].text = wlan_mode_1;
			opmode.options[1].text = wlan_mode_2;
			opmode.options[2].text = wlan_mode_3;
			opmode.options[3].text = wlan_mode_4;

			if (wifi6Enable) {
				opmode.options[1].value = "16";
			} else {
				opmode.options[1].value = "15";
				opmode.options[3].value = "17";
				opmode.options[3].text = "$$wlan_mode_400";
			}

            if(axmodel == "AX1800")
            {
                if (!opmodeSupport300M)
                {
                    $("#opMode option[value='7']").remove();
                }
            }
            else if(axmodel == "AX3000" || axmodel == "AX2400" )
            {
                if (!opmodeSupport300M)
                {
                    $("#opMode option[value='7']").remove();
                }
            }
            else if(axmodel == "AX1600")
            {
                if(wifi6Enable)
                {
                    if (!opmodeSupport300M)
                    {
                        $("#opMode option[value='7']").remove();
                    }
                    if (opmodeSupport400M)
                    {
                        opmode.options[2].value = "17";
                    }
                }
                else
                {
                    if (!opmodeSupport300M)
                    {
                        $("#opMode option[value='17']").remove();
                    }
                    if (opmodeSupport400M)
                    {
                        opmode.options[2].value = "7";
                    }
                }
            }

			if ( have_wireless_an == "1" ) {
				var opmode5g = document.getElementById('opMode5g');
				opmode5g.options[0].text = wlan_mode_1;
				opmode5g.options[1].text = an_wlan_mode_1;
				opmode5g.options[2].text = an_wlan_mode_2;
				opmode5g.options[3].text = an_wlan_mode_3;
				if (axmodel == "AX3000" || axmodel == "AX2400")
				{
				     opmode5g.options[4].text = an_wlan_mode_4;
				}
				if (wifi6Enable) {
					opmode5g.options[1].value = "16";
					opmode5g.options[2].value = "8";
				    opmode5g.options[3].value = "10";
					if (axmodel == "AX3000")
					{
						opmode5g.options[4].value = "20";
					}
					else if (axmodel == "AX2400")
					{
						opmode5g.options[4].value = "21";
					}
				} else {
					opmode5g.options[1].value = "15";
					opmode5g.options[2].value = "17";
					opmode5g.options[3].value = "18";
					if (axmodel == "AX3000" || axmodel == "AX2400")
					{
						opmode5g.options[4].value = "19";
					}
				}
			}

		} // end wifi settings
		
		/*******************************************************************************************
		*
		*	IP Address
		*
		******************************************************************************************/
		if ( $("input[name='ip_assign']").length) {
			$("input[name='ip_assign']").on('click', function(){
				if ($(this).val() == "1"){
					$('input', '.ipAddressInput').prop("disabled", true);
				} else {
					$('input', '.ipAddressInput').prop("disabled", false);
				}
			});
		}
		
		if ($('#autoDisablePIN').length){
			$('#autoDisablePIN').on('change', function () {
				if($(this).prop('checked')) {
					$('#numberOfEntries').prop("disabled", false);
				} else {
					$('#numberOfEntries').prop("disabled", true);
				}
			});
		}

		$.checkBoxs = function(id) {
			if($('#'+id).is(':checked') == true) {
				$('#'+id).prop('checked', true);
				$('#'+id).addClass('checked');
			} else {
				$('#'+id).prop('checked', false);
				$('#'+id).removeClass('checked');
			}
		}
/*
		$.wpsWarning = function(id) {
			if($('#'+id).is(':checked') == false) {
				$.confirmBox(wps_warning1, null, null, null, function(){
					$('#'+id).prop('checked', true);
					$('#'+id).addClass('checked');
				});
			}
		}
*/
		$.setChannel = function() {
			var wChannel = document.getElementById("channel");
			
			if($('#wRegion').val() == 8 || $('#wRegion').val() == 10 || $('#wRegion').val() == 3)
				wChannel.options.length = 12;
			else
				wChannel.options.length = 14;

			for(var i=1; i<wChannel.options.length; i++) {
				wChannel.options[i].value = i;
				wChannel.options[i].text = (i < 10)? "0" + i : i;
			}
		}

		$.setChannel5g = function(from) {
			var cf = document.forms["wifiSettingsForm"];
			if (from == 2) {
				$.setAChannel(cf.channel_5g);
			} else {
				$.setAwlan_mode();
				$.setAChannel(cf.channel_5g);
			}
		}

		$.setAwlan_mode = function() {
			if (ac_router_flag == 1) {
				$.setACwlan_mode();
			} else {
				$.setANwlan_mode();
			}
		};

		$.setACwlan_mode = function() {
			var cf = document.forms["wifiSettingsForm"];
			var index = cf.wregion.value;
			var currentMode = cf.opmode_5g.selectedIndex;

			// bug 34916, change index number to region name, make the code easy to read and change.
			if (index == "0" || index == "5" || index == "16" || index == "17")
			{ //Israel,Middle East(Turkey/Egypt/Tunisia/Kuwait) Middle East(Saudi Arabia) Africa
				cf.opmode_5g.options.length = 2;
				cf.opmode_5g.options[0].text = wlan_mode_1;
				cf.opmode_5g.options[1].text = an_wlan_mode_1;
				//cf.opmode_5g.options[2].text = an_wlan_mode_2;
				//cf.opmode_5g.options[3].text = an_wlan_mode_3;
				cf.opmode_5g.options[0].value = "1";
				cf.opmode_5g.options[1].value = "7";
				//cf.opmode_5g.options[2].value = "8";
				//cf.opmode_5g.options[3].value = "9";
				//cf.opmode_5g.selectedIndex = 0;
				if(link_status_5g == '1' && confMode == '2')
				{
				    cf.opmode_5g.disabled=true;
				    $('#opMode5g').css({'background-color':'#ebebe4'});
				}
				else
				{
				    cf.opmode_5g.disabled=false;// bug 34916, grey out mode, this region not support both HT20 and HT40
				    //$('#opMode5g').css({'background-color':'#fff'});
				}
			}
			else if ( index == "14" )
			{           // Middle East(Algeria/Syria/Yemen), this country do not support HT20 HT40,grayout channel
				cf.channel_5g.selectedIndex=0;
				cf.opmode_5g.selectedIndex=0;
				cf.channel_5g.disabled=true;
				$('#channel5g').css({'background-color':'#ebebe4'});
				cf.opmode_5g.options.length = 4;
				cf.opmode_5g.options[0].text = wlan_mode_1;
				cf.opmode_5g.options[1].text = an_wlan_mode_1;
				cf.opmode_5g.options[2].text = an_wlan_mode_2;
				cf.opmode_5g.options[3].text = an_wlan_mode_3;
				cf.opmode_5g.options[0].value = "1";
				cf.opmode_5g.options[1].value = "7";
				cf.opmode_5g.options[2].value = "8";
				cf.opmode_5g.options[3].value = "10";
				cf.opmode_5g.disabled=true;// bug 34916, grey out mode, this region not support both HT20 and HT40
				$('#opMode5g').css({'background-color':'#ebebe4'});
			}
			else{
				if (axmodel == "AX3000" || axmodel == "AX2400")
				{
					cf.opmode_5g.options.length = 5;
				}
				else
				{
					cf.opmode_5g.options.length = 4;
				}
				cf.opmode_5g.options[0].text = wlan_mode_1;
				cf.opmode_5g.options[1].text = an_wlan_mode_1;
				cf.opmode_5g.options[2].text = an_wlan_mode_2;
				cf.opmode_5g.options[3].text = an_wlan_mode_3;
				if (axmodel == "AX3000" || axmodel == "AX2400")
				{
					cf.opmode_5g.options[4].text = an_wlan_mode_4;
				}
				cf.opmode_5g.options[0].value = "1";
				if (wifi6Enable) {
					cf.opmode_5g.options[1].value = "16";
					cf.opmode_5g.options[2].value = "8";
					cf.opmode_5g.options[3].value = "10";
					if (axmodel == "AX3000")
					{
						cf.opmode_5g.options[4].value = "20";
						
						if ( mode5g == '1' )
							cf.opmode_5g.selectedIndex = 0;
						else if ( mode5g == '16' )
							cf.opmode_5g.selectedIndex = 1;
						else if ( mode5g == '8' )
							cf.opmode_5g.selectedIndex = 2;
						else if ( mode5g == '10' )
							cf.opmode_5g.selectedIndex = 3;
						else 
							cf.opmode_5g.selectedIndex = 4;
					}
					else if (axmodel == "AX2400")
					{
						cf.opmode_5g.options[4].value = "21";
						
						if ( mode5g == '1' )
							cf.opmode_5g.selectedIndex = 0;
						else if ( mode5g == '16' )
							cf.opmode_5g.selectedIndex = 1;
						else if ( mode5g == '8' )
							cf.opmode_5g.selectedIndex = 2;
						else if ( mode5g == '10' )
							cf.opmode_5g.selectedIndex = 3;
						else 
							cf.opmode_5g.selectedIndex = 4;
					}
					else
					{
						if ( mode5g == '1' )
							cf.opmode_5g.selectedIndex = 0;
						else if ( mode5g == '16' )
							cf.opmode_5g.selectedIndex = 1;
						else if ( mode5g == '8' )
							cf.opmode_5g.selectedIndex = 2;
						else
							cf.opmode_5g.selectedIndex = 3;
					}
		        } 
				else {
					cf.opmode_5g.options[1].value = "15";
					cf.opmode_5g.options[2].value = "17";
					cf.opmode_5g.options[3].value = "18";
					if (axmodel == "AX3000" || axmodel == "AX2400")
					{
						cf.opmode_5g.options[4].value = "19";
						if ( mode5g == '1' )
							cf.opmode_5g.selectedIndex = 0;
						else if ( mode5g == '15' )
							cf.opmode_5g.selectedIndex = 1;
						else if ( mode5g == '17' )
							cf.opmode_5g.selectedIndex = 2;
						else if ( mode5g == '18' )
							cf.opmode_5g.selectedIndex = 3;
						else 
							cf.opmode_5g.selectedIndex = 4;
					}
					else
					{
						if ( mode5g == '1' )
							cf.opmode_5g.selectedIndex = 0;
						else if ( mode5g == '15' )
							cf.opmode_5g.selectedIndex = 1;
						else if ( mode5g == '17' )
							cf.opmode_5g.selectedIndex = 2;
						else
							cf.opmode_5g.selectedIndex = 3;
					}
				}
				
				//if ( mode5g == '1' )
				//	cf.opmode_5g.selectedIndex = 0;
				//else if ( mode5g == '7' )
				//	cf.opmode_5g.selectedIndex = 1;
				//else if ( mode5g == '8' )
				//	cf.opmode_5g.selectedIndex = 2;
				//else // mode_an == '3' '5' '6' '9'
				//	cf.opmode_5g.selectedIndex = 3;
				if(link_status_5g == '1' && confMode == '2')
				{
				    cf.opmode_5g.disabled=true;
				    $('#opMode5g').css({'background-color':'#ebebe4'});
				}
				else
				{
				    cf.opmode_5g.disabled=false;
				    //$('#opMode5g').css({'background-color':'#fff'});
				}
			}
			$('#opMode5g').trigger('change');
		};

		$.setANwlan_mode = function() {
			var cf = document.forms["wifiSettingsForm"];
			var index = cf.wregion.value;
			var currentMode = cf.opmode_5g.selectedIndex;

			// bug 34916, change index number to region name, make the code easy to read and change.
			if (index == "0" || index == "5" || index == "16" || index == "17")
			{ //Israel,Middle East(Turkey/Egypt/Tunisia/Kuwait) Middle East(Saudi Arabia) Africa
				if (axmodel == "AX3000" || axmodel == "AX2400")
				{
					cf.opmode_5g.options.length = 4;
				}
				else
			 	{
					cf.opmode_5g.options.length = 3;
				}
				cf.opmode_5g.options[0].text = an_wlan_mode_1;
				cf.opmode_5g.options[1].text = an_wlan_mode_2;
				cf.opmode_5g.options[2].text = an_wlan_mode_3;
				if (axmodel == "AX3000" || axmodel == "AX2400")
				{
					cf.opmode_5g.options[3].text = an_wlan_mode_4;
				}
				cf.opmode_5g.options[0].value = "1";
				cf.opmode_5g.options[1].value = "2";
				cf.opmode_5g.options[2].value = "3";
				if (axmodel == "AX3000" || axmodel == "AX2400")
				{
					cf.opmode_5g.options[3].value = "4";
				}
				cf.opmode_5g.selectedIndex = 0;
				cf.opmode_5g.disabled=true;// bug 34916, grey out mode, this region not support both HT20 and HT40
				$('#opMode5g').css({'background-color':'#ebebe4'});
			}
			else if ( index == "14" )
			{               // Middle East(Algeria/Syria/Yemen), this country do not support HT20 HT40,grayout channel
				cf.channel_5g.selectedIndex=0;
				cf.opmode_5g.selectedIndex=0;
				cf.channel_5g.disabled=true;
				$('#channel5g').css({'background-color':'#ebebe4'});
				cf.opmode_5g.options.length = 3;
				cf.opmode_5g.options[0].text = an_wlan_mode_1;
				cf.opmode_5g.options[1].text = an_wlan_mode_2;
				cf.opmode_5g.options[2].text = an_wlan_mode_3;
				cf.opmode_5g.options[0].value = "1";
				cf.opmode_5g.options[1].value = "2";
				cf.opmode_5g.options[2].value = "3";
				cf.opmode_5g.disabled=true;// bug 34916, grey out mode, this region not support both HT20 and HT40
				$('#opMode5g').css({'background-color':'#ebebe4'});
			}

			else{
				if (axmodel == "AX3000" || axmodel == "AX2400")
				{
					cf.opmode_5g.options.length = 4;
				}
				else
				{
					cf.opmode_5g.options.length = 3;
				}
				cf.opmode_5g.options[0].text = an_wlan_mode_1;
				cf.opmode_5g.options[1].text = an_wlan_mode_2;
				cf.opmode_5g.options[2].text = an_wlan_mode_3;
				if (axmodel == "AX3000" || axmodel == "AX2400")
				{
					cf.opmode_5g.options[3].text = an_wlan_mode_4;
				}
				cf.opmode_5g.options[0].value = "1";
				cf.opmode_5g.options[1].value = "2";
				cf.opmode_5g.options[2].value = "3";
				if (axmodel == "AX3000" || axmodel == "AX2400")
				{
					cf.opmode_5g.options[3].value = "4";
				}
				if (axmodel == "AX3000" || axmodel == "AX2400")
				{
					if ( mode5g == '1' || mode5g == '7' )
						cf.opmode_5g.selectedIndex = 0;
					else if ( mode5g == '2' || mode5g == '8' )
						cf.opmode_5g.selectedIndex = 1;
					else if ( mode5g == '10' || mode5g == '18' )
						cf.opmode_5g.selectedIndex = 2;
					else 
						cf.opmode_5g.selectedIndex = 3;
				}
				else
				{
					if ( mode5g == '1' || mode5g == '7' )
						cf.opmode_5g.selectedIndex = 0;
					else if ( mode5g == '2' || mode5g == '8' )
						cf.opmode_5g.selectedIndex = 1;
					else
						cf.opmode_5g.selectedIndex = 2;
				}
				if(link_status_5g == '1' && confMode == '2')
				{
				    cf.opmode_5g.disabled=true;
					$('#opMode5g').css({'background-color':'#ebebe4'});
				}
				else
				{
				    cf.opmode_5g.disabled=false;
				    //$('#opMode5g').css({'background-color':'#fff'});
				}
			}
			$('#opMode5g').trigger('change');
		};

		$.setAChannel = function(channel) {
			var index = document.getElementById("wRegion").value;
			var currentMode = document.getElementById("opMode5g").value;
			var option_array = document.getElementById("channel5g").options;
			var chValue = channel5g;
			var find_value = 0;
			var i, j = 0, val;
			var tmp_array = ht40_array[index];

            if ("" == index)
            {
                return;
            }

			if ( 1 == currentMode || 2 == currentMode || 7 == currentMode || 16 == currentMode || 15 == currentMode)
			{
				tmp_array = ht20_array[index];
			}
			else if( 9 == currentMode || 10 == currentMode || 18 == currentMode)
			{
				tmp_array = ht80_array[index];
			}
			else if (19 == currentMode || 20 == currentMode || 21 == currentMode)//21 ax2400 160M
			{
				tmp_array = ht160_array[index];
			}

			channel.options.length = tmp_array.length+1;
/*
			if ( dfs_channel_router_flag == 1 ) //Australia, Canada, Europe
			{
				channel.options[j].value = 0;
				channel.options[j].text = Auto;
				j++;
			}
*/
			for ( i = 0; i < tmp_array.length; i++ )
			{
				var isHT20Mode = (1 == currentMode || 2 == currentMode || 7 == currentMode || 16 == currentMode || 15 == currentMode);
				if (!isHT20Mode && (axmodel === "AX1800" || axmodel === "AX1600") && (parseInt(tmp_array[i].split('(')[0], 10) >= 165 && parseInt(tmp_array[i].split('(')[0], 10) <= 177)) {
					continue;
				}
				if (isHT20Mode && (axmodel === "AX1800" || axmodel === "AX1600") && parseInt(tmp_array[i].split('(')[0], 10) > 165 && parseInt(tmp_array[i].split('(')[0], 10) <= 177) {
					continue;
				}
				if ( 0 == hidden_dfs_channel && ( 1 == dfs_channel_router_flag ||
					( dfs_channel2_router_flag == 1 &&  index == 4 ) //Australia, Canada, Europe
								) ) //Japan, United States
				{
					if(currentMode == 9 && index == 21)//50244
						if(tmp_array[i] == "60" || tmp_array[i] == "64")
							continue;
					//if( index == 17 && (tmp_array[i] == "149" || tmp_array[i] == "153" || //tmp_array[i] == "157" || tmp_array[i] == "161") )//53381
					//	  continue;
					if ( tmp_array[i].indexOf("(DFS)") > -1 )
					{
						val =  tmp_array[i].split("(DFS)")[0];
						channel.options[j].value = val;
						channel.options[j].text = tmp_array[i];
						j++;
					}
					else
					{
						channel.options[j].value = channel.options[j].text = tmp_array[i];
						j++;
					}
				}
				else
				{
					if ( tmp_array[i].indexOf("(DFS)") > -1 )
						continue;
					if(currentMode == 9 && index == 21)//50244
						if(tmp_array[i] == "60" || tmp_array[i] == "64")
							continue;
					//if( index == 17 && (tmp_array[i] == "149" || tmp_array[i] == "153" || tmp_array[i] == "157" || tmp_array[i] == "161") )//53381
					//	continue;
					channel.options[j].value = channel.options[j].text = tmp_array[i];
					j++;
				}
			}
			channel.options.length = j;

			for(i=0; i<option_array.length; i++)
			{
				if(option_array[i].value == chValue)
				{
					find_value = 1;
					channel.selectedIndex = i;
					break
				}
			}
			if (find_value == 0)
			{/* to fix bug 27403 */
				for(i=0;i<option_array.length;i++)
				{
					if(option_array[i].value == wla_get_channel)
					{
						find_value = 1;
						channel.selectedIndex = i;
						break;
					}
				}
			}
			if(find_value == 0)
				channel.selectedIndex = 0;

		};

		$.changeWEPShowHidden = function() {
			return;
			var secOptions = document.getElementById('secType'),
			sel = secOptions.value;
			if ($('#opMode').val() != '1'){
				$("#secType option[value='2']").remove();
				if ( sel == '2' )
					sel = '0';
				$('#secType').val(sel);
			} else {
				if ( confMode == "0" ) {
					secOptions.options[2].value = '2';
					secOptions.options[2].text = sec_wep_phrase;
					secOptions.options[3].value = '6';
					secOptions.options[3].text = sec_wpa2_phrase;
					secOptions.options[4] = new Option(sec_wpas_phrase, '7');
				} else {
					secOptions.options[1].value = '2';
					secOptions.options[1].text = sec_wep_phrase;
					secOptions.options[2].value = '6';
					secOptions.options[2].text = sec_wpa2_phrase;
					secOptions.options[3] = new Option(sec_wpas_phrase, '7');
				}
				$('#secType').val(sel);
			}
			$('#secType').trigger('change');
		};

		$.changeWEPShowHidden5g = function() {
			return;
			var secOptions = document.getElementById('secType5g'),
			sel = secOptions.value;
			if ($('#opMode5g').val() != '1')
				$("#secType5g option[value='2']").remove();
			else {
				if ( confMode == "0" ) {
					secOptions.options[2].value = '2';
					secOptions.options[2].text = sec_wep_phrase;
					secOptions.options[3].value = '6';
					secOptions.options[3].text = sec_wpa2_phrase;
					secOptions.options[4] = new Option(sec_wpas_phrase, '7');
				} else {
					secOptions.options[1].value = '2';
					secOptions.options[1].text = sec_wep_phrase;
					secOptions.options[2].value = '6';
					secOptions.options[2].text = sec_wpa2_phrase;
					secOptions.options[3] = new Option(sec_wpas_phrase, '7');
				}
				$('#secType5g').val(sel);
			}
			$('#secType5g').trigger('change');
		};

		$.changeModeShowHidden = function(id) {
			var options = $('#opMode option').length,
			i = 0,
			selectMode = $('#opMode').val();
			if($('#'+id).val() == '2' && ($('#whatPwd').val() == 'Different' || confMode == "0")) {
				options = 1;
			}
			$('#opMode').empty();
			for ( ; i < options; i++ ) {
				if ( selectMode == modeValue[i] )
					$('<option value="'+modeValue[i]+'" selected>'+modeArray[i]+'</option>').appendTo('#opMode');
				else
					$('<option value="'+modeValue[i]+'">'+modeArray[i]+'</option>').appendTo('#opMode');
			}
		};

		$.changeModeShowHidden5g = function(id) {
			var wRegion = document.getElementById('wRegion');
			var index = wRegion.value;
			if (index == "0" || index == "5" || index == "16" || index == "17")
			{		
				var options = 2;
			}
			else
			{
				if (axmodel == "AX3000" || axmodel == "AX2400")
			 	{
			 		var options = 5;
			 	}
				else
				{
					var options = 4;	
				}
			}
			var i = 0,
			selectMode5g = $('#opMode5g').val();
			if($('#'+id).val() == '2' && ($('#whatPwd5g').val() == 'Different' || confMode == "0")) {
				options = 1;
			}
			$('#opMode5g').empty();
			for ( ; i < options; i++ ) {
				if ( selectMode5g == modeValue5g[i] )
					$('<option value="'+modeValue5g[i]+'" selected>'+modeArray5g[i]+'</option>').appendTo('#opMode5g');
				else
					$('<option value="'+modeValue5g[i]+'">'+modeArray5g[i]+'</option>').appendTo('#opMode5g');
			}
		};

		$.dfsRadarDetect = function() {
			var cf = document.forms["wifiSettingsForm"];
			var index = cf.wregion.value;
			var currentMode = document.getElementById("opMode5g").value;

			var each_info = dfs_info.split(':');
			var channel_info;
			var channel = cf.channel5g;
			var ch_index = channel.selectedIndex;
			var ch_name = channel.options[ch_index].text;
			var ch_value = channel.options[ch_index].value;
			var ht160_enabled= (support_ht160_flag == 1 && enable_ht160 == "1" && ((index == 10 || index == 4) && (currentMode != 1 && currentMode != 2 && currentMode != 7 && currentMode != 8)))

			if(dfs_radar_detect_flag == 1){
				var tmp_array;
				if(ht160_enabled)
				{
					if(dfs_radar_160 == undefined)
						return true;
					tmp_array = dfs_radar_160;
				}
				else if ( 1 == currentMode || 2 == currentMode || 7 == currentMode )
				{
					if(dfs_radar_20 == undefined)
						return true;

					tmp_array = dfs_radar_20;
				}
				else if( 9 == currentMode)
				{
					if(dfs_radar_80 == undefined)
						return true;

					tmp_array = dfs_radar_80;
				}
				else
				{
					if(dfs_radar_40 == undefined)
						return true;
					tmp_array = dfs_radar_40;
				}
				for( var i=0; i<tmp_array.length-1; i++)
				{
					var channel = tmp_array[i].channel;
					var min = tmp_array[i].expire/60;
					var sec = tmp_array[i].expire%60;
					if( channel == ch_value)
					{
						$.alertBox(dfs_radar_1 + "&nbsp;" + min.toFixed(0) + "&nbsp;" + dfs_radar_2 + sec + "&nbsp;" + dfs_radar_3);
						return false;
					}
				}
			}else{
				for ( i=0; i<each_info.length; i++ )
				{
					channel_info = each_info[i].split(' '); //channel; channel_flag; channe_priflag; left_time
					var sec = channel_info[3]%60;           //change left time format
					var min = parseInt(channel_info[3]/60);
					if( (5000 + 5*(parseInt(ch_value, 10))) == parseInt(channel_info[0], 10) )
					{
						$.alertBox(dfs_radar_1 + "&nbsp;" + min + "&nbsp;" + dfs_radar_2 + sec + "&nbsp;" + dfs_radar_3);
						return false;
					}
				}
			}
		}

		$.check_wizard_dhcp = function(check) {
			if(check == 1)
				$('#runTestFlag').val('test');
			else
				$('#runTestFlag').val('no');
			return true;
		}
 
		$.check_static_ip_mask_gtw = function() {
			var ipAddr = $('#ethr1').val()+'.'+$('#ethr2').val()+'.'+$('#ethr3').val()+'.'+$('#ethr4').val(),
			maskAddr = $('#mask1').val()+'.'+$('#mask2').val()+'.'+$('#mask3').val()+'.'+$('#mask4').val(),
			gatewayAddr = $('#gateway1').val()+'.'+$('#gateway2').val()+'.'+$('#gateway3').val()+'.'+$('#gateway4').val(),
			dnsAddr = $('#priAddr1').val()+'.'+$('#priAddr2').val()+'.'+$('#priAddr3').val()+'.'+$('#priAddr4').val();
			if($.checkipaddr(ipAddr) == false || $.is_sub_or_broad(ipAddr, ipAddr, maskAddr) == false) {
				$.addErrMsgAfter('ethr4', ip_invalid);
				return false;
			}
			if((maskAddr == "0.0.0.0") || (maskAddr == "255.255.255.255")) {
				$.addErrMsgAfter('mask4', subnet_invalid);
				return false;
			}
			if($.checksubnet(maskAddr) == false) {
				$.addErrMsgAfter('mask4', subnet_invalid);
				return false;
			}
			if($.checkgateway(gatewayAddr) == false) {
				$.addErrMsgAfter('gateway4', gateway_invalid);
				return false;
			}
			if($.isGateway(ipAddr,maskAddr,gatewayAddr) == false) {
				$.addErrMsgAfter('gateway4', gateway_invalid);
				return false;
			}
			if($.isSameIp(ipAddr, gatewayAddr) == true) {
				$.addErrMsgAfter('gateway4', gateway_invalid);
				return false;
			}
			if($.isSameSubNet(ipAddr,maskAddr,gatewayAddr,maskAddr) == false) {
				$.addErrMsgAfter('gateway4', same_subnet_ip_gtw);
				return false;
			}
			if($.checkdnsAddr(dnsAddr) == false) {
				$.addErrMsgAfter('priAddr4', primary_dns_invalid);
				return false;
			}
			if($.check_wizard_dhcp(0) == false)
				return false;
			return true;
		}

		$.setAble = function(flag) {
			if ( flag == "0" ) {
				$('#ipStart4').prop("disabled", false);
				$('#ipEnd4').prop("disabled", false);
			} else if ( flag == "1" ) {
				$('#ipStart4').prop("disabled", true);
				$('#ipEnd4').prop("disabled", true);
			}
		};

		$.returnTop = function(id_flag) {
			var mao = $(id_flag);
			if(mao.length > 0) {
				var pos = mao.offset();
				$("body,html").animate({scrollTop:pos.top}, 1000);
			}
		}

		$.wpsDisplay = function(id) {
			$.checkBoxs(id);
			if(wps_protect_pin_flag == '1') {
				if(($('#enablePIN').is(':checked') == false) || ($('#enablePIN').prop('disabled') == true))
					$('#wladv_appin_cfg').hide();
				else
					$('#wladv_appin_cfg').show();
				if($('#autoDisablePIN').prop('checked'))
					$('#numberOfEntries').prop("disabled", false);
				else
					$('#numberOfEntries').prop("disabled", true);
			} else {
				$('#wladv_appin_cfg').hide();
			}
		}

		$.expandedAllSection = function() {
			$('.sectionWrap').find('.expand')
				.find('i')
				.removeClass('dnintg-collapsed')
				.addClass('dnintg-expanded')
				.parents('.sectionWrap')
				.addClass('open')
				.find('.sectionDetails')
				.slideDown();
		}

		function enableSsidPwd () {
			$('#ssid').prop('disabled', false);
                        $('#ssid5g').prop('disabled', false);
                        $('#whatPwd').prop('disabled', false);
                        $('#whatPwd5g').prop('disabled', false);
                        //$('#whatPwd').css({'background-color':''});
                        //$('#whatPwd5g').css({'background-color':''});
		}

		function disableSsidPwd () {
			$('#ssid').prop('disabled', true);
			$('#ssid5g').prop('disabled', true);
			$('#whatPwd').prop('disabled', true);
			$('#whatPwd5g').prop('disabled', true);
			$('#whatPwd').css({'background-color':'#ebebe4'});
			$('#whatPwd5g').css({'background-color':'#ebebe4'});
		}

        function oneWifi() {
            disableSsidPwd();
            if (rootOption == "1" && rootOption5g == "0") {
                $('#ssid').val(rootSsid);
                $('#ssid5g').val(rootSsid);
                $('#secType').val($.convertSecTypeToText(rootSecurity));
                $('#secType5g').val($.convertSecTypeToText(rootSecurity));
                $('#passphrase').val(rootPassword);
                $('#passphrase5g').val(rootPassword);
                $('#verifyPwd').val(rootPassword);
                $('#verifyPwd5g').val(rootPassword);
            } else if (rootOption == "0" && rootOption5g == "1") {
                $('#ssid').val(rootSsid5g);
                $('#ssid5g').val(rootSsid5g);
                $('#secType').val($.convertSecTypeToText(rootSecurity5g));
                $('#secType5g').val($.convertSecTypeToText(rootSecurity5g));
                $('#passphrase').val(root5gPassword);
                $('#passphrase5g').val(root5gPassword);
                $('#verifyPwd').val(root5gPassword);
                $('#verifyPwd5g').val(root5gPassword);
            } else {
                $('#ssid').val(rootSsid);
                $('#ssid5g').val(rootSsid5g);
                $('#secType').val($.convertSecTypeToText(rootSecurity5g));
                $('#secType5g').val($.convertSecTypeToText(rootSecurity5g));
                $('#passphrase').val(rootPassword);
                $('#passphrase5g').val(root5gPassword);
                $('#verifyPwd').val(rootPassword);
                $('#verifyPwd5g').val(root5gPassword);
            }
            $('.column.first.wifi').find('.securityOptionsWrap').hide();
            $('.column.second.wifi').find('.securityOptionsWrap').hide();
            $('.column.first.wifi').find('.pwdInput').hide();
            $('.column.second.wifi').find('.pwdInput').hide();
            $('#whatPwd').val('Same');
            $('#whatPwd5g').val('Same');
            $('#whatPwd5g2').val('Same');
        }

		function differentWifi () {
                        enableSsidPwd();
                        if ( rootOption == "1" && rootOption5g == "0"){
                                $('#ssid').val(rootSsid.substring(0, 26) + '_2GEXT');
                                $('#ssid5g').val(rootSsid.substring(0, 26) + '_5GEXT');
                        }else if ( rootOption == "0" && rootOption5g == "1" ){
                                $('#ssid').val(rootSsid5g.substring(0, 26) + '_2GEXT');
                                $('#ssid5g').val(rootSsid5g.substring(0, 26) + '_5GEXT');
                        }else{
                                $('#ssid').val(rootSsid.substring(0, 26) + '_2GEXT');
                                $('#ssid5g').val(rootSsid5g.substring(0, 26) + '_5GEXT');
			}
		}

		function sameAp () {
             $('#ssid').val($('#ssid5g').val());
             $('.securityOptionsWrap').slideDown();
             $.sameSecurity('', '', '5g', '');
             rootPassword = root5gPassword;
            if($('#secType5g').val() != "None")
            {
                $('#passphrase').val($('#passphrase5g').val());
                $('#verifyPwd').val($('#verifyPwd5g').val());
                $('#secType').val($('#secType5g').val());
            }
            $('#secType').trigger('change');
        }

		function sameAp5g () {
                        $('#ssid').val($('#ssid5g').val());
                        $('#whatPwd').val($('#whatPwd5g').val());
                        var whatPwd = document.getElementById('whatPwd5g'),
                        what = whatPwd.value;
                        var secOptions = document.getElementById('secType5g'),
                        sel = secOptions.value;
                        if(rootOption == "1" && rootOption5g == "1" && what == "Same"){
                            if(rootSecurity5g == "1"){
                                $('#whatPwd').val("None");
                                $('#whatPwd5g').val("None");
                                what = "None";
                            }else if($('#whatPwd5g').val() != "Same"){
                                $('#whatPwd').val("Different");
                                $('#whatPwd5g').val("Different");
                                what = "Different";
                            }
                            $('#secType5g').val($.convertSecTypeToText(rootSecurity5g));

                        }else{
                            $('#whatPwd').val($('#whatPwd5g').val());
                        }
                        if(what == "Same" || what == "None"){
                                $('.wep').slideUp();
                                $('.wpa').slideUp();
                                $('.securityOptionsWrap').slideUp();
                        }else{
                                $('.securityOptionsWrap').slideDown();
                                $.sameSecurity('', '', '5g', '');
                        }
                        $('#smartConnectYes').prop('checked', true);
                        if(what == "Different")
                        {
                            $('#passphrase').val($('#passphrase5g').val());
                            $('#verifyPwd').val($('#verifyPwd5g').val());
                            $('#secType').val($('#secType5g').val());
                        }
                        $('#secType').trigger('change');
                }

		if ($('#wifiSettingsForm').length) {
			if( GUI_Region == "German")
				$('#wifiNote').addClass("German");
			else
				$('#wifiNote').removeClass("German");

			if(rootSecurity == '8' || rootSecurity == "3" || rootSecurity == "4" || rootSecurity == "5")
				rootSecurity = '7';

			if ( confMode != "2" ) {
				$('.whatPwdLi').hide();
				$('option:first', '#secType').after('<option value="None">'+none+'</option>');
				$('.ethernet').hide();
			}else{
				if(!(link_status == "1" && link_status_5g == "1"))
					$('.ethernet').hide();
			}

			if( ntgr_router == "1" && (link_status == "1" || link_status_5g == "1")){
                                $('.sync').show();
                        }else{
                                $('.sync').hide();
                        }

			if( confMode == "2" && support_seamless_roaming == "1" && ntgr_router == "1" && (link_status == "1" || link_status_5g == "1"))
                        {
                                disableSsidPwd();
                        }else{
                                enableSsidPwd();
                        }

			$('#autoSyncNo').click(function() {
                                $('.errorMsg').remove();
                                enableSsidPwd();
                                $.alertBox(disable_sr);
                        });

            $('#autoSyncYes').click(function() {
                                $('.errorMsg').remove();
                                $('#oneWifiYes').trigger('click');
                                disableSsidPwd();
                                $.alertBox(sync_yes);
                        });

            $.detectSsid = function () {
                if (rootOption == "1" && rootOption5g == "0") {
                    if ($('#ssid').val() == rootSsid && $('#ssid5g').val() == rootSsid)
                        return true;
                    else
                        return false;
                } else if (rootOption == "0" && rootOption5g == "1") {
                    if ($('#ssid').val() == rootSsid5g && $('#ssid5g').val() == rootSsid5g)
                        return true;
                    else
                        return false;
                } else if (rootOption == "1" && rootOption5g == "1") {
                    if ($('#ssid').val() == rootSsid && $('#ssid5g').val() == rootSsid5g)
                        return true;
                    else
                        return false;
                } else {
                    return false;
                }
            }

            $.detectPwd = function () {
                if ($('#whatPwd').val() == "Same") {
                    return true;
                } else if ($('#whatPwd').val() == "None" && rootSecurity == '1') {
                    return true;
                } else if ($('#whatPwd').val() == "Different") {
                    if ($('#secType').val() == "2" && rootSecurity == "2" && $('#wepAuth').val() == rootAuthType && $('#wepEnc').val() == rootEncrLen) {
                        for (var i = 1; i <= 4; i++) {
                            var password = eval("root" + "Key" + i);
                            if (rootKeyNum == i && $('#wepKeyNo' + i).is(':checked') == true && $('#key' + i).val() == password)
                                return true;
                        }
                    } else if ($('#secType').val() == "4" && rootSecurity == "4" && $('#passphrase').val() == rootPassword) {
                        return true;
                    } else if ($('#secType').val() == "5" && rootSecurity == "5" && $('#passphrase').val() == rootPassword) {
                        return true;
                    }
                    else if($('#secType').val() == "WPA2-PSK" && rootSecurity == "6" && $('#passphrase').val() == rootPassword){
                        return true;
                    }
                    else if($('#secType').val() == "WPA/WPA2" && rootSecurity == "7" && $('#passphrase').val() == rootPassword){
                        return true;
                    }
                    else if($('#secType').val() == "WPA3" && rootSecurity == "10" && $('#passphrase').val() == rootPassword){
                        return true;
                    }
                    else if($('#secType').val() == "WPA2/WPA3" && rootSecurity == "11" && $('#passphrase').val() == rootPassword){
                        return true;
                    }
                    else if ($('#secType').val() == "11" && rootSecurity == "11" && $('#passphrase').val() == rootPassword) {
                        return true;
                    }
                }
            }

            $.detectPwd5g = function () {
                if ($('#whatPwd5g').val() == "Same") {
                    return true;
                } else if ($('#whatPwd5g').val() == "None" && root5gSecurity == '1') {
                    return true;
                } else if ($('#whatPwd5g').val() == "Different") {
                    if ($('#secType5g').val() == "2" && root5gSecurity == "2" && $('#wepAuth5g').val() == root5gAuthType && $('#wepEnc5g').val() == root5gEncrLen) {
                        for (var i = 1; i <= 4; i++) {
                            var password = eval("root5g" + "Key" + i);
                            if (root5gKeyNum == i && $('#wepKeyNo5g' + i).is(':checked') == true && $('#key5g' + i).val() == password)
                                return true;
                        }
                    } else if ($('#secType5g').val() == "4" && root5gSecurity == "4" && $('#passphrase5g').val() == root5gPassword) {
                        return true;
                    } else if ($('#secType5g').val() == "5" && root5gSecurity == "5" && $('#passphrase5g').val() == root5gPassword) {
                        return true;
                    }
                    else if($('#secType5g').val() == "WPA2-PSK" && root5gSecurity == "6" && $('#passphrase5g').val() == root5gPassword){
                        return true;
                    }
                    else if($('#secType5g').val() == "WPA/WPA2" && root5gSecurity == "7" && $('#passphrase5g').val() == root5gPassword){
                        return true;
                    }
                    else if($('#secType5g').val() == "WPA3" && root5gSecurity == "10" && $('#passphrase5g').val() == root5gPassword){
                        return true;
                    }
                    else if($('#secType').val() == "WPA2/WPA3" && rootSecurity == "11" && $('#passphrase').val() == rootPassword){
                        return true;
                    }
                    else if ($('#secType5g').val() == "11" && root5gSecurity == "11" && $('#passphrase5g').val() == root5gPassword) {
                        return true;
                    }
                }
            }

			$('#oneWifiYes').click(function() {
                                $('.errorMsg').remove();
                                if(rootSsid == "12345678NETGEAR" && rootSsid5g == "12345678NETGEAR-5G"){
                                        $.alertBox(run_smart_setup);
                                        return false;
                                }else{
                                        $('#oneWifiYes').prop('checked', true);
                                        oneWifi();
                                        $('.sectionWrap.withBottomShadow').trigger('keyup');
					if($.detectAp() != true)
                                                $('#smartConnectNo').prop('checked', true);
                                }
                        });

			$('#oneWifiNo').click(function() {
                                if( ntgr_router == "1" && (link_status == "1" || link_status_5g == "1") && $('#autoSyncYes').is(':checked') == true){
                                        $('#oneWifiYes').prop('checked', true);
                                        return false;
                                }else{
                                        $('#oneWifiNo').prop('checked', true);
                                        differentWifi();
                                        $('.sectionWrap.withBottomShadow').trigger('keyup');
                                        if($.detectAp() != true)
                                                $('#smartConnectNo').prop('checked', true);
                                }
                        });

			//if (region == '12')
				//$('#wRegion').val('4');
			//else
			$('#wRegion').val(region);
			
			$('#ssid').val(SSID);

			if(APEnable == '1')
				$('#enableAp').prop('checked', true);
			else
				$('#enableAp').prop('checked', false);

			if(broadcast == '1')
				$('#ssidBc').prop('checked', true);
			else
				$('#ssidBc').prop('checked', false);

			if(disCoext == '0')
				$('#enableCoexist').prop('checked', true);
			else
				$('#enableCoexist').prop('checked', false);

			$('#channel').val(channel);
			$.setChannel();

			var setmode = '0';
			if ( wifi6Enable ) {
				if (mode == '3' || mode == '5' || mode == '6'){
					setmode = '3';
					$('#opMode').val(setmode);
				} else if(mode == '1' || mode == '2' || mode == '7' || mode == '16' ){
					setmode = mode;
					$('#opMode').val(setmode);
				} else if ((mode == '8') && (opmodeSupport600M || opmodeSupport400M)){
					setmode = '8';
					$('#opMode').val(setmode);
				} else if (opmodeSupport600M){
					setmode = '8';
					$('#opMode').val(setmode);
				} 
				else if (opmodeSupport400M){
					setmode = '17';
					$('#opMode').val(setmode);
				} 
				else {
					setmode = '1';
					$('#opMode').val(setmode);
				}
			} else {
				if (mode == '3' || mode == '5' || mode == '6'){
					setmode = '3';
					$('#opMode').val(setmode);
				} else if(mode == '1' || mode == '2' || mode == '15' || mode == '17'){
					setmode = mode;
					$('#opMode').val(setmode);
				} else if ((mode == '8') && (opmodeSupport600M || opmodeSupport400M)){
					setmode = '8';
					$('#opMode').val(setmode);
				}
				else if (opmodeSupport400M){
					setmode = '7';
					$('#opMode').val(setmode);
				} 
				else {
					setmode = '17';
					$('#opMode').val(setmode);
				}
			}
			if ( setmode != $('#opMode').val() ){
				$('#opMode').val($('#opMode option:last').val());
			}

			$.changeWEPShowHidden();

			if(link_status == '1' && confMode == '2') {
				//$('#enableCoexistRow').addClass('hide');
				$('#channel').prop("disabled", true);
				$('#channel').css({'background-color':'#ebebe4'});
				$('#opMode').prop("disabled", true);
				$('#opMode').css({'background-color':'#ebebe4'});
			} else {
				$('#enableCoexistRow').removeClass('hide');
				$('#channel').prop("disabled", false);
				$('#opMode').prop("disabled", false);
			}

			if(confMode == '2'){
				if( have_wireless_an == "1" && fastlane_type == "1" ){
					$('.ethernet').hide();
					if( furfing_mode_type == "2.4G" ){
						$('.column.first.wifi').hide();
						$('.column.first.continue').hide();
					}
					else{
						$('.column.second.wifi').hide();
						$('.column.second.continue').hide();
					}
				}
			}

			var securityOptionsWrap_obj;
			if( have_wireless_an == "1" )
				securityOptionsWrap_obj = $('.securityOptionsWrap.first');
			else
				securityOptionsWrap_obj = $('.securityOptionsWrap');
			if(sameSec == '0' && security == "1" && confMode == "2"){
				$('#whatPwd').val('None');
				securityOptionsWrap_obj.hide();
				$('#secType').val('0');
			} else if(sameSec == '0' || confMode != "2" ) {
				securityOptionsWrap_obj.show();
				$('#whatPwd').val('Different');
				if(security == "2") {
					$('#secType').val('2');
					$('#wepAuth').val(authType);
					$('#wepEnc').val(encrLen);
					$('#wepEnc').trigger('change');
					if(keyNum == '1')
						$('#wepKeyNo1').attr('checked', 'checked');
					else if(keyNum == '2')
						$('#wepKeyNo2').attr('checked', 'checked');
					else if(keyNum == '3')
						$('#wepKeyNo3').attr('checked', 'checked');
					else
						$('#wepKeyNo4').attr('checked', 'checked');
					$('#key1').val(key1);
					$('#key2').val(key2);
					$('#key3').val(key3);
					$('#key4').val(".");
				} else if(security == "3" || security == "6" || security == "7" || security == "10" || security == "11") {
					$('#secType').val($.convertSecTypeToText(security));
					$('#passphrase').val(password);
					$('#verifyPwd').val(password);
					if(password.length >= $.MIN_PWD_CHARACTERS)
						$('#verifyPwd').prop('disabled', false);
					else
						$('#verifyPwd').prop('disabled', true);
				} else if ( confMode != "2" && security == "1" ) {
					$('#secType').val('None');
				} else {
					$('#secType').val('0');
				}
			} else {
				$('#secType').val('0');
				securityOptionsWrap_obj.hide();
				$('#whatPwd').val('Same');
			}
			$('#secType').trigger('change');

			$.checkPass();

			setTimeout(function() {
				if(security == "2") {
					$('#key4').val(key4);
					$('#passphrase').val("");
					$('#verifyPwd').val("");
				} else if(security == "3" || security == "6" || security == "7" || security == "10" || security == "11") {
					$('#key4').val("");
					$('#passphrase').val(password);
					$('#verifyPwd').val(password);
				} else {
					$('#key4').val("");
					$('#passphrase').val("");
					$('#verifyPwd').val("");
				}
				$('#key4').removeAttr('style');
			}, $.chromeTimer);

			$('option', '#opMode').each(function(i, ele){
				modeArray[i] = $(ele).html();
				modeValue[i] = $(ele).attr("value");
			});
			$.changeModeShowHidden("secType");

			if ( have_wireless_an == "1" ) {
				if(root5gSecurity == '8' || root5gSecurity == "3" || root5gSecurity == "4" || root5gSecurity == "5")
					root5gSecurity = '7';
	
				if ( confMode != "2" )
				{
					$('.whatPwdLi5g').hide();
					$('option:first', '#secType5g').after('<option value="None">'+none+'</option>');
				}
				$('#ssid5g').val(SSID5g);
				if(APEnable5g == '1')
					$('#enableAp5g').prop('checked', true);
				else
					$('#enableAp5g').prop('checked', false);
	
				if(broadcast5g == '1')
					$('#ssidBc5g').prop('checked', true);
				else
					$('#ssidBc5g').prop('checked', false);
	
				$.setChannel5g(1, channel5g);
	

				var setmode5g = '0';
				if ( wifi6Enable ) {
				    if (mode5g == '1' || mode5g == '7' || mode5g == '8' || mode5g == '10' || mode5g == '20' || mode5g == '16' || mode5g == '21') {
						setmode5g = mode5g;
						$('#opMode5g').val(setmode5g);
					}else{
						setmode5g = '10';
						$('#opMode5g').val(setmode5g);
				    }
				} else {
					if (mode5g == '1' || mode5g == '7' || mode5g == '8' || mode5g == '15'|| mode5g == '17' || mode5g == '18' || mode5g == '19') {
						setmode5g = mode5g;
						$('#opMode5g').val(setmode5g);
					}else{
						setmode5g = '18';
						$('#opMode5g').val(setmode5g);
				    }
				}

				if ( setmode5g != $('#opMode5g').val() ){
					$('#opMode5g').val($('#opMode5g option:last').val());
				}

				$.changeWEPShowHidden5g();
	
				if(link_status_5g == '1' && confMode == '2') {
					$('#enableCoexistRow5g').addClass('hide');
					$('#channel5g').prop("disabled", true);
					$('#channel5g').css({'background-color':'#ebebe4'});
					$('#opMode5g').prop("disabled", true);
					$('#opMode5g').css({'background-color':'#ebebe4'});
				} else if( link_status_5g == "0" && (region == "0" || region == "5" || region == "14" || region == "16" || region == "17")){//bug 59191:5G wifi speed is error when wireless region is Israel
					$('#enableCoexistRow5g').removeClass('hide');
					$('#channel5g').prop("disabled", false);
				}else{
					$('#enableCoexistRow5g').removeClass('hide');
					$('#channel5g').prop("disabled", false);
					$('#opMode5g').prop("disabled", false);
				}
	
				if(sameSec5g == '0' && security5g == "1" && confMode == "2"){
					$('#whatPwd5g').val('None');
					$('.securityOptionsWrap.second').hide();
					$('#secType5g').val('0');
				} else if(sameSec5g == '0' || confMode != "2" ) {
					$('.securityOptionsWrap.second').show();
					$('#whatPwd5g').val('Different');
					if(security5g == "2" || security5g == "8") {
						$('#secType5g').val('2');
						$('#wepAuth5g').val(authType5g);
						$('#wepEnc5g').val(encrLen5g);
						$('#wepEnc5g').trigger('change');
						if(keyNum5g == '1')
							$('#wepKeyNo5g1').attr('checked', 'checked');
						else if(keyNum5g == '2')
							$('#wepKeyNo5g2').attr('checked', 'checked');
						else if(keyNum5g == '3')
							$('#wepKeyNo5g3').attr('checked', 'checked');
						else
							$('#wepKeyNo5g4').attr('checked', 'checked');
						$('#key5g1').val(key5g1);
						$('#key5g2').val(key5g2);
						$('#key5g3').val(key5g3);
						$('#key5g4').val(".");
					} else if(security5g == "3" || security5g == "6" || security5g == "5" || security5g == "7" || security5g == "10" || security5g == "11") {
						$('#secType5g').val($.convertSecTypeToText(security5g));
						$('#passphrase5g').val(password5g);
						$('#verifyPwd5g').val(password5g);
						if(password5g.length >= $.MIN_PWD_CHARACTERS)
							$('#verifyPwd5g').prop('disabled', false);
						else
							$('#verifyPwd5g').prop('disabled', true);
					} else if ( confMode != "2" && security5g == "1" ) {
						$('#secType5g').val('None');
					} else {
						$('#secType5g').val('0');
					}
				} else {
					$('#secType5g').val('0');
					$('.securityOptionsWrap.second').hide();
					$('#whatPwd5g').val('Same');
				}
				$('#secType5g').trigger('change');
	
				$.checkPass5g();
	
				setTimeout(function() {
					if(security5g == "2") {
						$('#key5g4').val(key5g4);
						$('#passphrase5g').val("");
						$('#verifyPwd5g').val("");
					} else if(security5g == "3" || security5g == "6" || security5g == "5" || security5g == "7" || security5g == "10" || security5g == "11") {
						$('#key5g4').val("");
						$('#passphrase5g').val(password5g);
						$('#verifyPwd5g').val(password5g);
					} else {
						$('#key5g4').val("");
						$('#passphrase5g').val("");
						$('#verifyPwd5g').val("");
					}
					$('#key5g4').removeAttr('style');
				}, $.chromeTimer);

				$('option', '#opMode5g').each(function(i, ele){
					modeArray5g[i] = $(ele).html();
					modeValue5g[i] = $(ele).attr("value");
				});
				$.changeModeShowHidden5g("secType5g");
				$('#deviceName').val(deviceName);
			}

			if(enable_ext == "0" && confMode == "2" && fastlane_type == "0"){
				if(rootSsid == "12345678NETGEAR" && rootSsid5g == "12345678NETGEAR-5G"){
					$('#oneWifiNo').prop('checked', true);
				}else{
					oneWifi();
				}
			}

			if(fastlane_type == "1"){
                                //$('.oneWifi').hide();
				$('.smartConnect').hide();
                        }

            $.detectAp = function () {
                if (confMode == "0") {
                    if ($('#ssid').val() == $('#ssid5g').val()) {
                        if ($('#secType').val() == $('#secType5g').val()) {
                            if($('#secType').val() == "WPA2-PSK" || $('#secType').val() == "WPA/WPA2" || $('#secType').val() == "WPA3" || $('#secType').val() == "WPA2/WPA3"){
                                if ($('#passphrase').val() == $('#passphrase5g').val())
                                    return true;
                            } else if ($('#secType').val() == "2") {
                                if ($('#wepAuth').val() == $('#wepAuth5g').val() && $('#wepEnc').val() == $('#wepEnc5g').val()) {
                                    for (var i = 1; i <= 4; i++) {
                                        if ($('#wepKeyNo' + i).is(':checked') == true && $('#wepKeyNo5g' + i).is(':checked') == true && $('#wepKeyNo5g' + i + '2').is(':checked') == true && $('#key' + i).val() == $('#key5g' + i).val() && $('#key5g' + i).val() == $('#key5g' + i + '2').val())
                                            return true;
                                    }
                                }
                            } else {
                                return true;
                            }
                        }
                    }
                } else {
                    if ($('#ssid').val() == $('#ssid5g').val()) {
                        if ($('#whatPwd').val() == $('#whatPwd5g').val()) {
                            if( ($('#whatPwd').val() == "Same")|| ($('#whatPwd').val() == "None")){
                                return true;
                            } else if ($('#whatPwd').val() == "Different") {
                                if ($('#secType').val() == $('#secType5g').val()) {
                                    if(($('#secType').val() == "WPA2-PSK" || $('#secType').val() == "WPA/WPA2" || $('#secType').val() == "WPA3" || $('#secType').val() == "WPA2/WPA3") && ($('#passphrase').val() == $('#passphrase5g').val())){
                                        return true;
                                    } else if ($('#secType').val() == "2") {
                                        if ($('#wepAuth').val() == $('#wepAuth5g').val() && $('#wepEnc').val() == $('#wepEnc5g').val()) {
                                            for (var i = 1; i <= 4; i++) {
                                                if ($('#wepKeyNo' + i).is(':checked') == true && $('#wepKeyNo5g' + i).is(':checked') == true && $('#key' + i).val() == $('#key5g' + i).val())
                                                    return true;
                                            }
                                        }
                                    }
                                }
                            }
                            else if (($('#whatPwd').val() == "Same")){
                                if (rootOption == '1' && rootOption5g == '1'){
                                    if ((rootSecurity == rootSecurity5g) && ($('#passphrase').val() == $('#passphrase5g').val()))
                                        return true;
                                }else{
                                    if ($('#passphrase').val() == $('#passphrase5g').val())
                                    {
                                        return true;
                                    }
                                }
                            }
                        }
                    }
                }
            }

			if($.detectAp() != true)
				$('#smartConnectNo').prop('checked', true);

			if(confMode == "0"){
                                $('.sync').hide();
                                $('.oneWifi').hide();
                        }

            $('#smartConnectYes').click(function () {
                $('#enableAp5g').prop('checked', true);
                $('#enableAp').prop('checked', true);
                $('.errorMsg').remove();
                if (confMode == "2") {
                    $.confirmBox(smart_yes_alert, null, function () {
                        sameAp5g();
                        $('.sectionWrap.withBottomShadow').trigger('keyup');
                        if ($.detectSsid() == true && $.detectPwd() == true && $.detectPwd5g() == true) {
                            $('#oneWifiYes').prop('checked', true);
                            oneWifi();
                        } else {
                            $('#oneWifiNo').prop('checked', true);
                            enableSsidPwd();
                        }
                    }, null, function () {
                        $('#smartConnectNo').prop('checked', true);
                    });
                }
                else if (confMode == "0") {
                    sameAp();
                    $('#ssid').prop('disabled', true);
                    $('.first.wifi').find('#secType').prop('disabled', true);
                    //$('.first.wifi .pwdInput input').prop('disabled', true);
                    $('.first.wifi .pwdInput select').prop('disabled', true);
                    $('.first.wifi .first select').css({ 'background-color': '#ebebe4' });
                    $('.first.wifi .pwdInput input').css({ 'background-color': '#ebebe4' });
                }
            });

            $('#smartConnectNo').click(function () {
                if (confMode == "0") {
                    $('#ssid').prop('disabled', false);
                    $('.first.wifi').find('#secType').prop('disabled', false);
                    $('.first.wifi .pwdInput input').prop('disabled', false);
                    $('.first.wifi .pwdInput select').prop('disabled', false);
                    $('.first.wifi .first select').css({ 'background-color': '' });
                    $('.first.wifi .pwdInput input').css({ 'background-color': '' });
                    if ($("#passphrase").val().length < $.MIN_PWD_CHARACTERS) {
                      $("#verifyPwd").prop('disabled', true);
                    }
                    if ($("#passphrase5g").val().length < $.MIN_PWD_CHARACTERS) {
                      $("#verifyPwd5g").prop('disabled', true);
                    }
                }
            });

		    $('#wifi6_yes').click(function () {
				//wifi6 enable, 2.4g rate: 54M,286M,600M 5g rate:54M,286M,600M,1200M,2400M
				var opmode = document.getElementById('opMode');
				opmode.options.length=0;
				if(axmodel == "AX1600")
				{
					wlan_mode_2 = "$$wlan_mode_229"
					wlan_mode_3 = "$$wlan_mode_400"
				}
				else if(axmodel == "AX1500")
				{
					wlan_mode_2 = "$$wlan_mode_216"
					wlan_mode_3 = "$$wlan_mode_600"
				}
				else
				{
					wlan_mode_2 = "$$wlan_mode_286"
					wlan_mode_3 = "$$wlan_mode_600"
				}

				opmode.options.add(new Option(wlan_mode_1, '1'));
				opmode.options.add(new Option(wlan_mode_2, '16'));
				if(axmodel == "AX1600")
				{
					opmode.options.add(new Option(wlan_mode_3, '17'));
				}
				else
				{
					opmode.options.add(new Option(wlan_mode_3, '8'));
				}
				if ( wifi6Enable ) {
					if ( mode == '1') {
						opmode.selectedIndex = 0;
					} else if ( mode == '16'){
						opmode.selectedIndex = 1;
					} else {
						opmode.selectedIndex = 2;
			    	}
			    } else {
					opmode.selectedIndex = 2;
				}
				if ( have_wireless_an == "1" ) {
					var opmode5g = document.getElementById('opMode5g');
					opmode5g.options.length=0; 
				    an_wlan_mode_1="$$wlan_mode_286"
					an_wlan_mode_2="$$wlan_mode_600"
					an_wlan_mode_3="$$wlan_mode_1200"
					if (axmodel == "AX3000")
				 	{
						an_wlan_mode_4="$$wlan_mode_2400"
				 	}
					else if (axmodel == "AX2400")
					{
						an_wlan_mode_4="$$wlan_mode_1800"
					}
					opmode5g.options.add(new Option(wlan_mode_1, '1'));
				    opmode5g.options.add(new Option(an_wlan_mode_1, '16'));
				    opmode5g.options.add(new Option(an_wlan_mode_2, '8'));
					opmode5g.options.add(new Option(an_wlan_mode_3, '10'));
					if (axmodel == "AX3000")
					{
						opmode5g.options.add(new Option(an_wlan_mode_4, '20'));
					}
					else if (axmodel == "AX2400")
					{
						opmode5g.options.add(new Option(an_wlan_mode_4, '21'));
					}
					if ( wifi6Enable ) {
						if (axmodel == "AX3000" || axmodel == "AX2400")
						{
							if ( mode5g == '1' )
								opmode5g.selectedIndex = 0;
							else if ( mode5g == '16' )
								opmode5g.selectedIndex = 1;
							else if ( mode5g == '8' )
								opmode5g.selectedIndex = 2;
							else if ( mode5g == '10' )
								opmode5g.selectedIndex = 3;
							else // mode_an == '3' '5' '6' '9'
					    		opmode5g.selectedIndex = 4;
						}
						else
						{
							if ( mode5g == '1' )
								opmode5g.selectedIndex = 0;
							else if ( mode5g == '16' )
								opmode5g.selectedIndex = 1;
							else if ( mode5g == '8' )
								opmode5g.selectedIndex = 2;
							else // mode_an == '3' '5' '6' '9'
					    		opmode5g.selectedIndex = 3;
						}
				    } 
					else 
					{
						if (axmodel == "AX3000" || axmodel == "AX2400")
						{
							opmode5g.selectedIndex = 4;
						}
						else
						{
							opmode5g.selectedIndex = 3;
						}
					}
				}
			});

			$('#wifi6_no').click(function () {
			    //wifi6 disable, 2.4g rate: 54M,173M,400M 5g rate:54M,173M,400M,867M
				var opmode = document.getElementById('opMode');
				opmode.options.length=0;
				if(axmodel == "AX1600")
				{
					wlan_mode_2 = "$$wlan_mode_150"
					wlan_mode_3 = "$$wlan_mode_300"
				}
				else if(axmodel == "AX1500")
				{
					wlan_mode_2 = "$$wlan_mode_173"
					wlan_mode_3 = "$$wlan_mode_400"
				}
				else
				{
					wlan_mode_2 = "$$wlan_mode_173"
					wlan_mode_3 = "$$wlan_mode_400"
				}
				opmode.options.add(new Option(wlan_mode_1, '1'));
				opmode.options.add(new Option(wlan_mode_2, '15'));
				if(axmodel == "AX1600")
				{
					opmode.options.add(new Option(wlan_mode_3, '7'));
				}
				else
				{
					opmode.options.add(new Option(wlan_mode_3, '17'));
				}
				if ( !wifi6Enable ) {
					if ( mode == '1'){
						opmode.selectedIndex = 0;
					} else if ( mode == '15'){
						opmode.selectedIndex = 1;
					} else {
						opmode.selectedIndex = 2;
				    }
				} else {
					opmode.selectedIndex = 2;
				}
				if ( have_wireless_an == "1" ) {
					var opmode5g = document.getElementById('opMode5g');
					opmode5g.options.length=0;
				    an_wlan_mode_1="$$wlan_mode_173"
					an_wlan_mode_2="$$wlan_mode_400"
					an_wlan_mode_3="$$wlan_mode_867"
					if (axmodel == "AX3000" || axmodel == "AX2400")
					{
						an_wlan_mode_4="$$wlan_mode_1733"
					}
					opmode5g.options.add(new Option(wlan_mode_1, '1'));
				    opmode5g.options.add(new Option(an_wlan_mode_1, '15'));
				    opmode5g.options.add(new Option(an_wlan_mode_2, '17'));
					opmode5g.options.add(new Option(an_wlan_mode_3, '18'));
					if (axmodel == "AX3000" || axmodel == "AX2400")
					{
						opmode5g.options.add(new Option(an_wlan_mode_4, '19'));
					}
					if (axmodel == "AX3000" || axmodel == "AX2400")
					{
						if ( !wifi6Enable ) {
							if ( mode5g == '1' )
								opmode5g.selectedIndex = 0;
							else if ( mode5g == '15' )
								opmode5g.selectedIndex = 1;
							else if ( mode5g == '17' )
								opmode5g.selectedIndex = 2;
							else if ( mode5g == '18' )
								opmode5g.selectedIndex = 3;
							else 
						    	opmode5g.selectedIndex = 4;
					    } else {
							opmode5g.selectedIndex = 4;
						}
					}
					else
					{
						if ( !wifi6Enable ) {
							if ( mode5g == '1' )
								opmode5g.selectedIndex = 0;
							else if ( mode5g == '15' )
								opmode5g.selectedIndex = 1;
							else if ( mode5g == '17' )
								opmode5g.selectedIndex = 2;
							else 
						    	opmode5g.selectedIndex = 3;
					    } else {
							opmode5g.selectedIndex = 3;
						}
					}
				}
			});

			if(confMode == "0"){
				if($("#smartConnectYes").is(":checked") == true){
					$('#smartConnectYes').trigger('click');
				}
			}

            function onSectionDetailsGeneralChange() {
                if ($("#smartConnectNo").is(":checked") == true || confMode == "2") {
                    if($.detectAp() == true && $("#enableAp5g").is(":checked") == true && $("#enableAp").is(":checked") == true){
                        $('.errorMsg').remove();
                        $('#smartConnectYes').prop('checked', true);
                        if (confMode != "2")
                            $('#smartConnectYes').trigger('click');
                    } else {
                        $('#smartConnectNo').prop('checked', true);
                        $('#smartConnectNo').trigger('click');
                    }
                }

                if (confMode == "2" && fastlane_type == "0") {
                    if ($.detectSsid() == true && $.detectPwd() == true && $.detectPwd5g() == true) {
                        $('#oneWifiYes').prop('checked', true);
                        oneWifi();
                    } else {
                        $('#oneWifiNo').prop('checked', true);
                    }
                }
            }

            $('.sectionDetails.general').change(onSectionDetailsGeneralChange);
            $('.sectionDetails.general').keyup(onSectionDetailsGeneralChange);

            if (confMode == "0") {
                $('.column.second.wifi').change(function () {
                    if ($("#smartConnectYes").is(":checked") == true)
                        sameAp();
                });
                $('.column.second.wifi').keyup(function () {
                    if ($("#smartConnectYes").is(":checked") == true)
                        sameAp();
                });
                //$('#smartConnectYes').trigger('click');
            }

			if(lanTypeOpt == '0') {
				$('input', '.ipAddressInput').prop("disabled", false);
				$('#staticAssign').attr('checked', 'checked');
			} else {
				$('input', '.ipAddressInput').prop("disabled", true);
				$('#dhcpAssign').attr('checked', 'checked');
			}

			if(ether_get_ip != "") {
				var ip_array = ether_get_ip.split('.');
				$('#ethr1').val(ip_array[0]);
				$('#ethr2').val(ip_array[1]);
				$('#ethr3').val(ip_array[2]);
				$('#ethr4').val(ip_array[3]);
			}

			if(ether_get_subnet != "") {
				var mask_array=ether_get_subnet.split('.');
				$('#mask1').val(mask_array[0]);
				$('#mask2').val(mask_array[1]);
				$('#mask3').val(mask_array[2]);
				$('#mask4').val(mask_array[3]);
			}

			if(ether_get_gateway != "") {
				var gtw_array=ether_get_gateway.split('.');
				$('#gateway1').val(gtw_array[0]);
				$('#gateway2').val(gtw_array[1]);
				$('#gateway3').val(gtw_array[2]);
				$('#gateway4').val(gtw_array[3]);
			}

			if(ether_get_dns1 != "") {
				var dns_array=ether_get_dns1.split('.');
				$('#priAddr1').val(dns_array[0]);
				$('#priAddr2').val(dns_array[1]);
				$('#priAddr3').val(dns_array[2]);
				$('#priAddr4').val(dns_array[3]);
			}

			if(dhcpTypeOpt == '1') {
				$('input', '.dhcpAddressInput').prop("disabled", false);

				$('#enableAssign').attr('checked', 'checked');
				$.setAble("0");
			} else {
				$('input', '.dhcpAddressInput').prop("disabled", true);
				$('#disableAssign').attr('checked', 'checked');
				$.setAble("1");
			}
			if(ether_get_ip != "") {
				var ip_array = ether_get_ip.split('.');
				$('#ipStart1').val(ip_array[0]);
				$('#ipStart2').val(ip_array[1]);
				$('#ipStart3').val(ip_array[2]);
				$('#ipEnd1').val(ip_array[0]);
				$('#ipEnd2').val(ip_array[1]);
				$('#ipEnd3').val(ip_array[2]);
			}
			if(dhcpStart != "")
				$('#ipStart4').val(dhcpStart.split('.')[3]);
			if(dhcpEnd != "")
				$('#ipEnd4').val(dhcpEnd.split('.')[3]);
			if(liveboxDetect == '1')
				$("#dhcp_able").show();
			else
				$("#dhcp_able").hide();

			if(wps_protect_pin_flag == '1') {
				$('#wladv_enable_wps').show();
			} else {
				$('#wladv_enable_wps').hide();
			}

			if(WPSenable == '0') {
				$('#wladv_pin').css({"color": "gray"});
				$('#wladv_enable_wps').css({"color": "gray"});
				$('#wladv_appin_cfg').css({"color": "gray"});
				$('#enablePIN').prop("disabled", true);
				$('#autoDisablePIN').prop("disabled", true);
				$('#numberOfEntries').prop("disabled", true);
			}

			if((enableToggle == '1') || (lockDown == '1')) {
				$('#enablePIN').prop('checked', false);
				$('.pinWrap').css({"background-color": "gray"});
				$('#attack_detected').append(temporarily_mark_v11);
			} else {
				$('#enablePIN').prop('checked', true);
			}

			if(wps_protect_pin_flag == '1') {
				if(WPSProtect == '0')
					$('#autoDisablePIN').prop('checked', false);
				else
					$('#autoDisablePIN').prop('checked', true);
			}

			$.wpsDisplay();

			$('#opMode').change(function() {
				$.changeWEPShowHidden();
			});
			$('#opMode5g').change(function() {
				$.changeWEPShowHidden5g();
			});

			$('.secondary').click(function() {
				top.location.href = "wifiSettings.htm" + $.ID_2;
			});

			var ul_selector;
			if ( have_wireless_an == "1" )
				ul_selector = '.column.first ul';
			else
				ul_selector = 'ul';
			$('.primary[id!=continueBt]').click(function(){
				$('.errorMsg').remove();

				if(ntgr_router == "1"){
                                        if($("#autoSyncYes").is(":checked") == true)
                                                $('#autoSync').val("1");
                                        if($("#autoSyncNo").is(":checked") == true)
                                                $('#autoSync').val("0");
                                }
				if($("#smartConnectYes").is(":checked") == true)
					$('#smartConnect').val("1");

				if($("#smartConnectNo").is(":checked") == true)
                    $('#smartConnect').val("0");
				if($("#muMimoYes").is(":checked") == true)
					$('#mumimo').val("1");
				if($("#muMimoNo").is(":checked") == true)
					$('#mumimo').val("0");

				if($("#wifi6_yes").is(":checked") == true)
					$('#wifi6').val("1");
				if($("#wifi6_no").is(":checked") == true)
					$('#wifi6').val("0");

                if($("#oneWifiYes").is(":checked") == true)
                    $('#enableExt').val("0");
                if($("#oneWifiNo").is(":checked") == true)
                    $('#enableExt').val("1");

				//if( wps_progress_status == "2" ) {
				//	$.alertBox(wps_in_progress);
				//	return false;
				//}

				if ( !$.REG_SSID.test($('#ssid').val()) ) {
					if ($('#ssid').val().length == 0) {
						$.addErrMsgAfter('ssid',ssid_null, false, 'error_info_2');
					} else {
						$.addErrMsgAfter('ssid',ssid_invalid, false, 'error_info_2');
					}
					$.returnTop("#fixedtop");
					return false;
				}
				else
				{
					var testMainSSID = $('#ssid').val();
					if ((guestAPEnable && testMainSSID == guestSSID) || (guestAPEnable5g && testMainSSID == guestSSID5g)) {
						alert(ssid_dup);
						return false;
					}
				}

				if ( have_wireless_an && !$.REG_SSID.test($('#ssid5g').val()) ) {
					if ($('#ssid5g').val().length == 0) {
						$.addErrMsgAfter('ssid5g',ssid_null, false, 'error_info_5');
					} else {
						$.addErrMsgAfter('ssid5g',ssid_invalid, false, 'error_info_5');
					}
					$.returnTop("#fixedtop");
					return false;
				}
				else
				{
					var testMainSSID = $('#ssid5g').val();
					if ((guestAPEnable && testMainSSID == guestSSID) || (guestAPEnable5g && testMainSSID == guestSSID5g)) {
						alert(ssid_dup);
						$.returnTop("#fixedtop");
						return false;
					}					
				}

				$.checkSecurity('secType', 'wepEnc', 'passphrase');

				$('#wifiRegion').val($('#wRegion').val());
				$('#wifi2GHzSSID').val($.do_xss_ssid($('#ssid').val()));
				if($('#ssidBc').prop('checked'))
					$('#wifiSSIDBroadcast').val('1');
				else
					$('#wifiSSIDBroadcast').val('0');
				if($('#enableAp').prop('checked'))
					$('#wifiAPMode').val('1');
				else
					$('#wifiAPMode').val('0');
				if($('#enableCoexist').prop('checked'))
					$('#wifiCoext').val('0');
				else
					$('#wifiCoext').val('1');
				$('#wifiChannel').val($('#channel').val());
				if($('#secType').val() == '2')
					$('#clientMode').val(1);
				else
					$('#clientMode').val($('#opMode').val());

				if ( have_wireless_an == "1" ) {
					$.checkSecurity5g('secType5g', 'wepEnc5g', 'passphrase5g');
					$('#wifi5GHzSSID').val($.do_xss_ssid($('#ssid5g').val()));
					if($('#ssidBc5g').prop('checked'))
						$('#wifiSSIDBroadcast5g').val('1');
					else
						$('#wifiSSIDBroadcast5g').val('0');
					if($('#enableAp5g').prop('checked'))
						$('#wifiAPMode5g').val('1');
					else
						$('#wifiAPMode5g').val('0');
					$('#wifiCoext5g').val('0');
					$('#wifiChannel5g').val($('#channel5g').val());
					if($('#secType5g').val() == '2') {
						/*if (ac_router_flag == 1)
							$('#clientMode5g').val(7);
						else*/
							$('#clientMode5g').val(1);
					} else {
						$('#clientMode5g').val($('#opMode5g').val());
					}
				}
				if($('#whatPwd').val() == 'None') {
					$('#wifiPwd').val('2');
					$('#wifiSecOptions').val('1');
				} else if($('#whatPwd').val() == 'Different') {
					$('#wifiPwd').val('0');
					if($('#secType').val() == '2') {
						$('#wifiSecOptions').val('2');
						if($('#wepAuth').val() == '1')
							$('#wifiWEPAuthType').val('1');
						else
							$('#wifiWEPAuthType').val('2');
						if($('#wepEnc').val() == '5')
							$('#wifiWEPEncrStr').val('5');
						else
							$('#wifiWEPEncrStr').val('13');
						$('#wifi2GHzKeyNum').val($('input:radio[name="wep_key_no"]:checked').val());
						$('#wifiWEPKey1').val($('#key1').val());
						$('#wifiWEPKey2').val($('#key2').val());
						$('#wifiWEPKey3').val($('#key3').val());
						$('#wifiWEPKey4').val($('#key4').val());
						$(ul_selector + ' strong:last', '#continue').html($.xss_format($('#key'+$('#wifi2GHzKeyNum').val()).val()));
					} else {
						if($('#secType').val() == '3')
							$('#wifiSecOptions').val('3');
						else if($('#secType').val() == 'WPA2-PSK')
							$('#wifiSecOptions').val('6');
						else if ( confMode != "2" && $('#secType').val() == 'None')
							$('#wifiSecOptions').val('1');
						else if($('#secType').val() == '9')
							$('#wifiSecOptions').val('9');
						else if($('#secType').val() == 'WPA3')
							$('#wifiSecOptions').val('10');
						else if($('#secType').val() == 'WPA2/WPA3')
							$('#wifiSecOptions').val('11');
						else
							$('#wifiSecOptions').val('7');
						if($('#verifyPwd').val() != $('#passphrase').val() && $('#passphrase').val().length >= $.MIN_PWD_CHARACTERS) {
							$('#verifyPwd').addClass('alert');
							$.addErrMsgAfter('verifyPwd', error_not_same_pwd, false, 'errPwdSame');
							$.returnTop("#ssid");
							return false;
						}
						$('#wifi2GHzPassword').val($.do_xss_pass($('#passphrase').val()));
						$(ul_selector + ' strong:last', '#continue').html($.xss_ssid_format($('#passphrase').val()));
					}
				} else {
					$('#wifiPwd').val('1');
					if(installBywps == "1" && rootSecurity == "0" && security != "0")
					{
					    $('#wifiSecOptions').val(security);
					}
					else
					{
					   $('#wifiSecOptions').val(rootSecurity);
					}

					if(rootSecurity == "2") {
						$('#wifiWEPAuthType').val(rootAuthType);
						$('#wifiWEPEncrStr').val(rootEncrLen);
						$('#wifi2GHzKeyNum').val(rootKeyNum);
						$('#wifiWEPKey1').val(rootKey1);
						$('#wifiWEPKey2').val(rootKey2);
						$('#wifiWEPKey3').val(rootKey3);
						$('#wifiWEPKey4').val(rootKey4);
						$('#clientMode').val(1);
					} else if(rootSecurity != "1") {
						if (fastlane_type == '1' || rootOption == '0') {
							$('#wifiSecOptions').val(root5gSecurity);
							$('#wifi2GHzPassword').val($.do_xss_pass(root5gPassword));
							$(ul_selector + ' strong:last', '#continue').html($.xss_format($.showPassKey(rootSecurity, rootKeyNum, "root5g")));
						}
						else {
							$('#wifiSecOptions').val(rootSecurity);
							$('#wifi2GHzPassword').val($.do_xss_pass(rootPassword));
							$(ul_selector + ' strong:last', '#continue').html($.xss_format($.showPassKey(rootSecurity, rootKeyNum, "root")));
						}
					}
				}
				if( have_wireless_an == "1" ) {
					if($('#whatPwd5g').val() == 'None') {
						$('#wifiPwd5g').val('2');
						$('#wifiSecOptions5g').val('1');
					} else if($('#whatPwd5g').val() == 'Different') {
						$('#wifiPwd5g').val('0');
						if($('#secType5g').val() == '2') {
							$('#wifiSecOptions5g').val('2');
							if($('#wepAuth5g').val() == 'Shared Key')
								$('#wifiWEPAuthType5g').val('1');
							else
								$('#wifiWEPAuthType5g').val('2');
							if($('#wepEnc5g').val() == '64')
								$('#wifiWEPEncrStr5g').val('5');
							else
								$('#wifiWEPEncrStr5g').val('13');
							$('#wifi5GHzKeyNum').val($('input:radio[name="wep_key_no_5g"]:checked').val());
							$('#wifiWEPKey5g1').val($('#key5g1').val());
							$('#wifiWEPKey5g2').val($('#key5g2').val());
							$('#wifiWEPKey5g3').val($('#key5g3').val());
							$('#wifiWEPKey5g4').val($('#key5g4').val());
							$('.column.second ul strong:last', '#continue').html($.xss_format($('#key5g'+$('#wifi5GHzKeyNum').val()).val()));
						} else {
							if($('#secType5g').val() == '3')
								$('#wifiSecOptions5g').val('3');
							else if($('#secType5g').val() == 'WPA2-PSK')
								$('#wifiSecOptions5g').val('6');
							else if ( confMode != "2" && $('#secType5g').val() == 'None')
								$('#wifiSecOptions5g').val('1');
							else if($('#secType5g').val() == '9')
								$('#wifiSecOptions5g').val('9');
							else if($('#secType5g').val() == 'WPA3')
								$('#wifiSecOptions5g').val('10');
							else if($('#secType5g').val() == 'WPA2/WPA3')
								$('#wifiSecOptions5g').val('11');
							else
								$('#wifiSecOptions5g').val('7');
							if($('#verifyPwd5g').val() != $('#passphrase5g').val() && $('#passphrase5g').val().length >= $.MIN_PWD_CHARACTERS) {
								$('#verifyPwd5g').addClass('alert');
								$.addErrMsgAfter('verifyPwd5g', error_not_same_pwd, false, 'errPwdSame');
								$.returnTop("#ssid5g");
								return false;
							}
							$('#wifi5GHzPassword').val($.do_xss_pass($('#passphrase5g').val()));
							$('.column.second ul strong:last', '#continue').html($.xss_ssid_format($('#passphrase5g').val()));
						}
					} else {
						$('#wifiPwd5g').val('1');
						if(installBywps == "1" && root5gSecurity == "0" && security5g != "0")
						{
						$('#wifiSecOptions5g').val(security5g);
						}
						else
						{
							$('#wifiSecOptions5g').val(root5gSecurity);
						}

						if(root5gSecurity == "2") {
							$('#wifiWEPAuthType5g').val(root5gAuthType);
							$('#wifiWEPEncrStr5g').val(root5gEncrLen);
							$('#wifi2GHzKeyNum5g').val(root5gKeyNum);
							$('#wifiWEPKey5g1').val(root5gKey1);
							$('#wifiWEPKey5g2').val(root5gKey2);
							$('#wifiWEPKey5g3').val(root5gKey3);
							$('#wifiWEPKey5g4').val(root5gKey4);
							$('#clientMode5g').val(1);
						} else if(root5gSecurity != "1") {
							if (fastlane_type == '1' || rootOption5g == '0') {
								$('#wifiSecOptions5g').val(rootSecurity);
								$('#wifi5GHzPassword').val($.do_xss_pass(rootPassword));
								$('.column.second ul strong:last', '#continue').html($.xss_format($.showPassKey(root5gSecurity, root5gKeyNum, "root")));
							}
							else {
								$('#wifiSecOptions5g').val(root5gSecurity);
								$('#wifi5GHzPassword').val($.do_xss_pass(root5gPassword));
								$('.column.second ul strong:last', '#continue').html($.xss_format($.showPassKey(root5gSecurity, root5gKeyNum, "root5g")));
							}
						}
					}
				}
				if ($("#deviceName").val() == "")
				{
					$.addErrMsgAfter('deviceName', dev_namenull);
					return false;
				}
				if ( $('#staticAssign').is(':checked') ) {
					if($.check_static_ip_mask_gtw() == false) {
						$.expandedAllSection();
						$.returnTop("#ipAddressSection");
						return false;
					}
				}

				$('#devName').val($.do_xss_ssid($('#deviceName').val()));
				$('#etherIPAddr').val(parseInt($('#ethr1').val())+'.'+parseInt($('#ethr2').val())+'.'+parseInt($('#ethr3').val())+'.'+parseInt($('#ethr4').val()));
				$('#etherSubnet').val(parseInt($('#mask1').val())+'.'+parseInt($('#mask2').val())+'.'+parseInt($('#mask3').val())+'.'+parseInt($('#mask4').val()));
				$('#etherGateway').val(parseInt($('#gateway1').val())+'.'+parseInt($('#gateway2').val())+'.'+parseInt($('#gateway3').val())+'.'+parseInt($('#gateway4').val()));
				$('#etherDNSAddr1').val(parseInt($('#priAddr1').val())+'.'+parseInt($('#priAddr2').val())+'.'+parseInt($('#priAddr3').val())+'.'+parseInt($('#priAddr4').val()));

				if ( $('#enableAssign').is(':checked') )
					$('#etherDHCPAssign').val('1');
				else
					$('#etherDHCPAssign').val('0');

				$('#etherDHCPStart').val($('#ipStart1').val()+'.'+$('#ipStart2').val()+'.'+$('#ipStart3').val()+'.'+$('#ipStart4').val());
				$('#etherDHCPEnd').val($('#ipEnd1').val()+'.'+$('#ipEnd2').val()+'.'+$('#ipEnd3').val()+'.'+$('#ipEnd4').val());

				if(protectPINFlag == 1) {
					if($('#enablePIN').prop('checked'))
						$('#wifiEnablePIN').val('0');
					else
						$('#wifiEnablePIN').val('1');
					if($('#autoDisablePIN').prop('checked'))
						$('#wifiDisablePIN').val('1');
					else
						$('#wifiDisablePIN').val('0');
					if($('#numberOfEntries').val() == '')
						$('#numOfEntries').val('3');
					else
						$('#numOfEntries').val($('#numberOfEntries').val());
				}

				if ( !$('.errorMsg').length ) {
					if ( !$('#ssidBc').prop('checked') || have_wireless_an == "1" && !$('#ssidBc5g').prop('checked') ){
						$.confirmBox(wps_warning1, null, function(){
							$.confirmSecOptions1();
						}, null, null);
					}else{
						$.confirmSecOptions1();
					}
				} else {
					$.returnTop("#ssid");
					return false;
				}
			});

			$.confirmSecOptions1 = function() {
				if($('#wifiSecOptions').val() == '1' || have_wireless_an == "1" && $('#wifiSecOptions5g').val() == '1') {
					$.confirmBox(wps_warning3, null, function(){
						$.confirmSecOptions23();
					}, null, null);
				} else {
					$.confirmSecOptions23();
				}
			}

			$.confirmSecOptions23 = function() {
				if($('#wifiSecOptions').val() == '2' || $('#wifiSecOptions').val() == '3' || have_wireless_an == "1" && ($('#wifiSecOptions5g').val() == '2' || $('#wifiSecOptions5g').val() == '3') ) {
					if( (fastlane_type == "1" && furfing_mode_type == "2.4G" && $('#wifiSecOptions5g').val() != '2' && $('#wifiSecOptions5g').val() != '3') || (fastlane_type == "1" && furfing_mode_type == "5G" && $('#wifiSecOptions').val() != '2' && $('#wifiSecOptions').val() != '3')){
						$.confirmSecOptions7();
					}else {
						$.confirmBox(wps_warning2, null, function(){
							$.confirmSecOptions7();
						}, null, null);
					}
				} else {
					$.confirmSecOptions7();
				}
			}

			$.confirmSecOptions7 = function() {
				if($('#wifiSecOptions').val() == '7' || $('#wifiSecOptions5g').val() == '7') {				
					$.confirmBox(wpa_tkip_pop_message,null, function(){
						$.confirmDfs();
					}, null, null);
				} else {
					$.confirmDfs();
				}
			}

			$.confirmDfs = function() {
				var cf = document.forms["wifiSettingsForm"];
				var ch_index = cf.channel5g.selectedIndex;
				var ch_name = cf.channel5g.options[ch_index].text;
				if ($.dfsRadarDetect() != false){
				if( ch_name.indexOf("(DFS)") > -1){
					$.confirmBox(select_dfs,null, function(){
						$.submitSameIP();
					}, null, null);
				} else {
					$.submitSameIP();
				}
				}
			}

			$.submitSameIP = function() {
				if($('#staticAssign').is(':checked')) {
					if($.isSameIp($('#etherIPAddr').val(), old_lan_ip) == false) {
						$.confirmBox(changelanip + $('#etherIPAddr').val() + " ?", null, function() {
							$.alertBox(changelanip_renew, apply_mark, function() {
								$('#changeIPFlag').val('1');
								$.submitApply();
							});
						}, null, null);
					} else {
						$('#changeIPFlag').val('0');
						$.submitApply();
					}
				} else {
					$('#changeIPFlag').val('0');
					$.submitApply();
				}
			}

			$.submitApply = function() {
				$.submit_wait('.main:first', $.PAGE_APPLYING_DIV);
				$.returnTop("#fixedtop");
				$('input[name=submit_flag]', '#wifiSettingsForm').val("wifi_settings");
				$.postForm('#wifiSettingsForm', '', function(json) {
					if ( json.status == '1' ) {
						var time = parseInt(json.wait) * 1000;
						setTimeout(function() {
							$('#slider').hide();
							$('.running').remove();
							$('#continue').show();
							if ( have_wireless_an == "0" ) {
								if(!$('#enableAp').prop('checked')){
									$('.continue').hide();
								}
							} else {
								if(!$('#enableAp').prop('checked')){
									$('.first.continue').hide();
								}
								if(have_wireless_an == "1" && !$('#enableAp5g').prop('checked')){
									$('.second.continue').hide();
									$('.first.continue').css({'margin-left':'4%'});
								}
							}
							if(confMode == '2') {
								$('.extender').show();
								$('.accesspoint').hide();
							} else {
								$('.extender').hide();
								$('.accesspoint').show();
							}
							$('#continueBt').show();
							$('#continueBt').click(function() {
								location.href = json.url+$.ID_2;
							});
						}, time);
					} else {
						$('.running').remove();
						$.alertBox(json.msg);
					}
				});
				$(ul_selector + ' strong:first', '#continue').html($.xss_ssid_format($('#ssid').val()));
				$(ul_selector + ' strong:eq(1)', '#continue').html($.formatSecType2($('#wifiSecOptions').val()));

				if(installBywps == "1" && rootSecurity == "0" && security != "0")
				{
				    $('#wifi2GHzPassword').val($.do_xss_pass($('#passphrase').val()));
				    $(ul_selector + ' strong:last', '#continue').html($.xss_format($('#passphrase').val()));
				}

				if($('#wifiSecOptions').val() == "1" || $('#wifi2GHzPassword').val() == ""){
					$('.column.first ul li:last', '#continue').hide();
				}

				if (have_wireless_an == "1") {
					$('.column.second ul strong:first', '#continue').html($.xss_ssid_format($('#ssid5g').val()));
					$('.column.second ul strong:eq(1)', '#continue').html($.formatSecType2($('#wifiSecOptions5g').val()));
					if($('#wifiSecOptions5g').val() == "1" || $('#wifi5GHzPassword').val() == "")
						$('.column.second ul li:last', '#continue').hide();
				}
			}
		}

		/*******************************************************************************************
		*
		*    support own style of checkbox.
		*
		*******************************************************************************************/
		$('body').find(':checkbox').each(function () {
			if($(this).is(':checked')) {
				$(this).addClass('checked');
			} else {
				$(this).removeClass('checked');
			}
		});
		$('body').find(':radio,:checkbox').each(function() {
			$(this).change(function() {
				$('.first').prop('disabled', false);
			});
		});
		$('body').find('select').each(function() {
			$(this).change(function() {
				$('.first').prop('disabled', false);
			});
		});
		$('body').find(':text,:password').each(function() {
			$(this).keyup(function() {
				$('.first').prop('disabled', false);
			});
		});

	}); // end ready function

}(jQuery));
