/**
 * For setup flow
 */
(function ($) {

  "use strict";

  var checkNum = 0,
    chooseSSID = new Array(),
    chooseSecurity = new Array(),
    chooseSectype = new Array(),
    chooseMode = new Array(),
    chooseVie = new Array(),
    chooseVie5g = new Array(),
    chooseMac = new Array(),
    chooseMac5g = new Array(),
    chooseChannel = new Array(),
    chooseChannel5g = new Array(),
    chooseSSID5g = new Array(),
    chooseSecurity5g = new Array(),
    chooseSectype5g = new Array(),
    chooseMode5g = new Array(),
    rootSSID = "",
    securityType = "",
    secType = "",
    simpleMode = "",
    rootSSID5g = "",
    securityType5g = "",
    secType5g = "",
    simpleMode5g = "",
    rootVie = "",
    rootVie5g = "",
    rootMac = "",
    rootMac5g = "",
    len = "",
    len_5g = "";

  $.selectWepEncrStr = function (encrStr) {
    var thisParents = $('#' + encrStr).parents('.formElements');
    thisParents.find('#err_wep').remove();
    thisParents.find('.wepPwd').attr('maxlength', $('#' + encrStr).val() * 2);
    thisParents.find('.wepPwd').val('');
  };

  $(function () {
		/*******************************************************************************************
		*
		*	select networks page
		*
		******************************************************************************************/

    $.checkMode = function (mode, security) {
      var modeType = "";
      if (mode == "G") {
        modeType = "1";
      } else if (mode == "GN20") {
        modeType = "2";
      } else if (mode == "GN40P") {
        modeType = "3";
      } else if (mode == "GN40M") {
        modeType = "5";
      } else if (mode == "GN40") {
        modeType = "6";
      } else {
        modeType = "2";
      }
      return modeType;
    }

    $.chooseExist = function (num) {
      $("#manualSsid").css('display', 'none');
      var selectItem = $('tr:eq(' + num + ')', '#availableNetworks'),
        security = $('td:eq(2)', selectItem).html(),
        channel = $('td:eq(3)', selectItem).html();
      if (/WEP/.test(chooseSecurity[num])) {
        return $.wepAlert(num);
      } else if (/Enterprise/.test(chooseSecurity[num])) {
        return $.enterpriseAlert(num);
      }
      rootSSID = chooseSSID[num];
      secType = chooseSectype[num];
      securityType = chooseSecurity[num];
      simpleMode = $.checkMode(chooseMode[num], chooseSecurity[num]);
      rootMac = chooseMac[num];
      rootVie = chooseVie[num].substring(31, 33);

      $('#2GHzSecurity').val(security);
      $('#2GHzChannel').val(channel);
      $('#2GHzSectype').val(secType);
      $('#2GHzMode').val(simpleMode);
      $('#2GHzMac').val(rootMac);
      $('#2GHzVie').val(rootVie);

      if (have_wireless_an == "1") {
        $('.column.first').val("checked");

        if ($("#ap5g").is(":checked") == false || ($("#ap5g").is(":checked") == true && ($(".column.second").val() == "checked" || $("#manualNetwork5g").is(":checked") == true)))
          $.enableButton('nextStep', '#selectNetworkForm', 0, true);
        else
          $.enableButton('nextStep', '#selectNetworkForm', 0, false);
      } else
        $.enableButton('nextStep', '#selectNetworkForm', 0, true);
    }

    $.enterpriseAlert = function (num) {
      $.alertBox(no_enterprise);
      $("#selNetwork" + (num + 1) + "").removeAttr("checked");
      return false;
    }

    $.enterpriseAlert5g = function (num) {
      $.alertBox(no_enterprise);
      $("#selNetwork" + (num + 1) + "5g").removeAttr("checked");
      return false;
    }
    $.wepAlert = function (num) {
      $.alertBox(no_wep);
      $("#selNetwork" + (num + 1) + "").removeAttr("checked");
      return false;
    }

    $.wepAlert5g = function (num) {
      $.alertBox(no_wep);
      $("#selNetwork" + (num + 1) + "5g").removeAttr("checked");
      return false;
    }

    function sortJSON(bef, aft) {
      return aft.signal - bef.signal;
    }

    var MaxRetryCnt = 5;
    var retryCnt2G = 0;
    function generateList() {
      var nextTimeDiff = 5000;
      if (retryCnt2G < MaxRetryCnt) {
        $.getData2('ca_available_network.aspx', function (json) {
          if (json && (json.list instanceof Array)) {
            $('#availableNetworks').empty();
            json.list.sort(sortJSON);
            len = json.list.length;
            if (len <= 0) {
              retryCnt2G++;
            } else {
              retryCnt2G = MaxRetryCnt;
              var scanResult = json.list.map(function (val) {
                return {
                  ssid: val.ssid,
                  channel: val.channel,
                  signal: val.signal,
                  security: val.security,
                  sectype: val.sectype,
                  mode: val.mode,
                  mac: val.mac,
                  vie: val.vie
                }
              });

              $(scanResult).each(function (i, ele) {
                chooseSSID[i] = ele.ssid;
                chooseSectype[i] = ele.sectype;
                chooseSecurity[i] = ele.security;
                chooseMode[i] = ele.mode;
                chooseMac[i] = ele.mac;
                chooseVie[i] = ele.vie;
                chooseChannel[i] = ele.channel;
                var item = "<tr>"
                  + "<td><label title='"
                  + "'><input type='radio' name='sel_network' id='selNetwork" + (i + 1) + "' value='"
                  + "' onclick='$.chooseExist(" + i + ");' />"
                  + "<span class='phoneLabel'>" + network_name + "</span>"
                  + $.xss_ssid_format(ele.ssid) + "</label></td>"
                  + "<td><span class='phoneLabel'>" + signal_strength + "</span>"
                  + "<i class='signalStrength " + $.getSignalType(ele.signal)
                  + "'></i> <span class='largeScreenOnly'>" + ele.signal + "%</span></td>"
                  + "<td title='" + ele.security + "'>" + ele.security + "</td>"
                  + "<td>" + ele.channel + "</td></tr>";

                item = $(item);
                $("td:first label", item).attr("title", ele.ssid);
                $("td:first input", item).val(ele.ssid);
                if (ele.ssid != "" && ele.signal != "" && ele.channel != "" && ele.security != "")
                  $('#availableNetworks').append(item);
              });
              nextTimeDiff = 1;
            }
          }
          setTimeout(function () { generateList(); }, nextTimeDiff);
        }, function () { retryCnt2G++; setTimeout(function () { console.log("network error when getting scan result of 2g."); generateList(); }, nextTimeDiff); });
      } else {
        if (have_wireless_an == "1") {
          $('.wait2g').hide();
          $('#scanning_bg').hide();
        }
      }
    }

    $.chooseExist5g = function (num) {
      $("#manualSsid5g").css('display', 'none');
      var selectItem = $('tr:eq(' + num + ')', '#availableNetworks5g'),
        security5g = $('td:eq(2)', selectItem).html(),
        channel5g = $('td:eq(3)', selectItem).html();
      if (/WEP/.test(chooseSecurity5g[num])) {
        return $.wepAlert5g(num);
      } else if (/Enterprise/.test(chooseSecurity5g[num])) {
        return $.enterpriseAlert5g(num);
      }
      rootSSID5g = chooseSSID5g[num];
      secType5g = chooseSectype5g[num];
      securityType5g = chooseSecurity5g[num];
      simpleMode5g = $.checkMode(chooseMode5g[num], chooseSecurity5g[num]);
      rootMac5g = chooseMac5g[num];
      rootVie5g = chooseVie5g[num].substring(31, 33);

      $('#5GHzSecurity').val(security5g);
      $('#5GHzChannel').val(channel5g);
      $('#5GHzSectype').val(secType5g);
      $('#5GHzMode').val("9");
      $('#5GHzMac').val(rootMac5g);
      $('#5GHzVie').val(rootVie5g);


      $('.column.second').val("checked");

      if ($("#ap").is(":checked") == false || ($("#ap").is(":checked") == true && ($(".column.first").val() == "checked" || $("#manualNetwork").is(":checked") == true)))
        $.enableButton('nextStep', '#selectNetworkForm', 0, true);
      else
        $.enableButton('nextStep', '#selectNetworkForm', 0, false);
    }


    var retryCnt5G = 0;
    function generateList5g() {
      var nextTimeDiff = 5000;
      if (retryCnt5G < MaxRetryCnt) {
        $.getData2('ca_available_network_5g.aspx', function (json) {
          if (json && (json.list instanceof Array)) {
            $('#availableNetworks5g').empty();
            json.list.sort(sortJSON);
            len_5g = json.list.length;
            if (len_5g <= 0) {
              retryCnt5G++;
            } else {
              retryCnt5G = MaxRetryCnt;
              var scanResult = json.list.map(function (val) {
                return {
                  ssid: val.ssid,
                  channel: val.channel,
                  signal: val.signal,
                  security: val.security,
                  sectype: val.sectype,
                  mode: val.mode,
                  mac: val.mac,
                  vie: val.vie
                }
              });
              // var scanResult = '[';
              // for (var j = 0; j < len_5g - 1; j++) {
              //   scanResult = scanResult + '{"ssid":"' + json.list[j].ssid.replace(/&nbsp;/g, ' ') + '","channel":"' + json.list[j].channel + '","signal":"' + json.list[j].signal + '","security":"' + json.list[j].security + '","sectype":"' + json.list[j].sectype + '","mode":"' + json.list[j].mode + '","mac":"' + json.list[j].mac + '", "vie":"' + json.list[j].vie + '"},';
              // }
              // scanResult = scanResult + '{"ssid":"' + json.list[len_5g - 1].ssid.replace(/&nbsp;/g, ' ') + '","channel":"' + json.list[len_5g - 1].channel + '","signal":"' + json.list[len_5g - 1].signal + '","security":"' + json.list[len_5g - 1].security + '","sectype":"' + json.list[len_5g - 1].sectype + '","mode":"' + json.list[len_5g - 1].mode + '","mac":"' + json.list[len_5g - 1].mac + '", "vie":"' + json.list[len_5g - 1].vie + '"}]';
              $(scanResult).each(function (i, ele) {
                chooseSSID5g[i] = ele.ssid;
                chooseSectype5g[i] = ele.sectype;
                chooseSecurity5g[i] = ele.security;
                chooseMode5g[i] = ele.mode;
                chooseMac5g[i] = ele.mac;
                chooseVie5g[i] = ele.vie;
                chooseChannel5g[i] = ele.channel;
                var item = "<tr>"
                  + "<td><label title='"
                  + "'><input type='radio' name='sel_network_5g' id='selNetwork" + (i + 1) + "5g' value='"
                  + "' onclick='$.chooseExist5g(" + i + ");' />"
                  + "<span class='phoneLabel'>" + network_name + "</span>"
                  + $.xss_ssid_format(ele.ssid) + "</label></td>"
                  + "<td><span class='phoneLabel'>" + signal_strength + "</span>"
                  + "<i class='signalStrength " + $.getSignalType(ele.signal)
                  + "'></i> <span class='largeScreenOnly'>" + ele.signal + "%</span></td>"
                  + "<td title='" + ele.security + "'>" + ele.security + "</td>"
                  + "<td>" + ele.channel + "</td></tr>";

                item = $(item);
                $("td:first label", item).attr("title", ele.ssid)
                $("td:first input", item).val(ele.ssid)
                if (ele.ssid != "" && ele.signal != "" && ele.channel != "" && ele.security != "")
                  $('#availableNetworks5g').append(item);
              });
              nextTimeDiff = 1;
            }
          }
          setTimeout(function () { generateList5g(); }, nextTimeDiff);

        }, function () { retryCnt5G++; setTimeout(function () { console.log("network error when getting scan result of 2g."); generateList5g(); }, nextTimeDiff); });
      } else {
        $('.wait5g').hide();
        $('#scanning_bg').hide();
      }
    }

    if ($('#countryForm').length) {
      $('#wRegion').val(wlan_get_country);
      $('#nextStep').click(function () {
        $.submit_wait('body', $.WAITING_DIV);
        $.postForm('#countryForm', '', function (json) {
          if (json.status == '1') {
            location.href = json.url + $.ID_2;
          } else {
            setTimeout(function () {
              location.href = "ca_country.htm" + $.ID_2;
            }, 3 * 1000);
          }
        });
      });
    }

    if ($('#welcomeForm').length) {
      if (hardware_switch == "1") {
        $("#hardware_switch_mode").css('display', 'block');
        $("#gui_switch_mode").css('display', 'none');
        $("#fixedFooter").css('display', 'block');
      }
      else {
        $("#gui_switch_mode").css('display', 'block');
      }
      if (conf_mode == "2") {
        $('#nextStep').click(function () {
          $.submit_wait('body', $.WAITING_DIV);
          $.postForm('#welcomeForm', '', function (json) {
            if (json.status == '1') {
              location.href = json.url + $.ID_2;
            } else {
              $('.running').remove();
              $.alertBox(json.msg);
            }
          });
        });
      }

		$('#extenderBt').click(function() {
			$.submit_wait('body', $.WAITING_DIV);
			$.postForm('#welcomeForm', '', function(json) {
				if ( json.status == '1' ) {
					location.href = json.url+$.ID_2;
				} else {
					$('.running').remove();
					$.alertBox(json.msg);
				}
			});
		});
    }

    $.checkManualSSID = function (ssid) {
      if (ssid == "5g") {
        var temp_ssid_5g = document.getElementsByName("sel_network_5g");
        for (var j = 0; j < len_5g; j++) {
          if (rootSSID5g == temp_ssid_5g[j].value) {
            rootVie5g = chooseVie5g[j].substring(31, 33);
            $('#5GHzChannel').val(chooseChannel5g[j]);
            $('#5GHzMode').val(chooseMode5g[j]);
            $('#5GHzMac').val(chooseMac5g[j]);
            $('#5GHzVie').val(rootVie5g);
            break;
          }
        }
      } else {
        var temp_ssid = document.getElementsByName("sel_network");
        for (var j = 0; j < len; j++) {
          if (rootSSID == temp_ssid[j].value) {
            rootVie = chooseVie[j].substring(31, 33);
            $('#2GHzChannel').val(chooseChannel[j]);
            $('#2GHzMode').val(chooseMode[j]);
            $('#2GHzMac').val(chooseMac[j]);
            $('#2GHzVie').val(rootVie);
            break;
          }
        }
      }
    };

    if ($('#selectNetworkForm').length) {
      if (have_wireless_an == "1") {
        $('.largeScreenOnly').show();
        if (fastlane_type == '1' && furfing_mode_type == '2.4G') {
          $('.column.first').show();
          $('.column.second').hide();
          $('.column.first').css({ 'margin-left': '24%' });
          $("#ap").prop('checked', true);
          $("#ap5g").prop('checked', false);
          $('.largeScreenOnly').hide();
        }
        else if (fastlane_type == '1' && furfing_mode_type == '5G') {
          $('.column.first').hide();
          $('.column.second').show();
          $('.column.second').css({ 'margin-left': '24%' });
          $("#ap").prop('checked', false);
          $("#ap5g").prop('checked', true);
          $('.largeScreenOnly').hide();
        }
      }
      checkNum = 3;
      $('#refreshBtLink').click(function () {
        if (have_wireless_an == "1") {
          $('.wait2g').show();
          $('#scanning_bg').show();
        } else
          $('.scanning').show();
          $.getData2('ca_searching_network.aspx?band=2g', function (json) {
          if ($.reset_login(json))
            return false;
          setTimeout(function () {
            retryCnt2G = 0;
            generateList();
          }, (json.waitTime || 19) * 1000);
        });
      });

      $('#refreshBtLink5g').click(function () {
        $('.wait5g').show(); $('#scanning_bg').show();
        $.getData2('ca_searching_network.aspx?band=5g', function (json) {
          if ($.reset_login(json))
            return false;
          setTimeout(function () {
            retryCnt5G = 0;
            generateList5g();
          }, (json.waitTime || 19) * 1000);
        });
      });

      $('#manualNetwork').click(function () {
        $("#manualSsid").css('display', 'block');
        if (have_wireless_an == "1" && $("#ap5g").is(":checked") == true && $(".column.second").val() != "checked" && $("#manualNetwork5g").is(":checked") == false)
          $.enableButton('nextStep', '#selectNetworkForm', 0, false);
        else
          $.enableButton('nextStep', '#selectNetworkForm', 0, true);
      });

      $('#manualNetwork5g').click(function () {
        $("#manualSsid5g").css('display', 'block');
        if ($("#ap").is(":checked") == true && $(".column.first").val() != "checked" && $("#manualNetwork").is(":checked") == false)
          $.enableButton('nextStep', '#selectNetworkForm', 0, false);
        else
          $.enableButton('nextStep', '#selectNetworkForm', 0, true);
      });

      $('#ap').click(function () {
        if ($("#ap").is(":checked") == false) {
          $(".column.first").val("");
          if ($(".column.second").val() == "checked" || $("#manualNetwork5g").is(":checked") == true)
            $.enableButton('nextStep', '#selectNetworkForm', 0, true);
          else
            $.enableButton('nextStep', '#selectNetworkForm', 0, false);
        } else
          $.enableButton('nextStep', '#selectNetworkForm', 0, false);
      });

      $('#ap5g').click(function () {
        if ($("#ap5g").is(":checked") == false) {
          $(".column.second").val("");
          if ($(".column.first").val() == "checked" || $("#manualNetwork").is(":checked") == true)
            $.enableButton('nextStep', '#selectNetworkForm', 0, true);
          else
            $.enableButton('nextStep', '#selectNetworkForm', 0, false);
          $.alertBox(clear_5g);
        } else
          $.enableButton('nextStep', '#selectNetworkForm', 0, false);
      });

      if (have_wireless_an == "1") {
        $('.wait2g').show();
        $('.wait5g').show();
        $('#scanning_bg').show();
      } else
        $('.scanning').show();

        var band_param = "?band=";
        if (fastlane_type == '1' && furfing_mode_type == '2.4G')
        {
            band_param = "?band=2g"
        }
        else if(fastlane_type == '1' && furfing_mode_type == '5G')
        {
            band_param = "?band=5g"
        }

        $.getData2('ca_searching_network.aspx' + band_param, function (json) {
            if ($.reset_login(json))
                return false;

            setTimeout(function () {
              if (fastlane_type == '' || fastlane_type == '0' || furfing_mode_type == '2.4G') {
                retryCnt2G = 0;
                generateList();
              }
              if (have_wireless_an == "1" && (fastlane_type == '' || fastlane_type == '0' || furfing_mode_type == '5G')) {
                retryCnt5G = 0;
                generateList5g();
              }
            }, (json.waitTime || 19) * 1000);
        });

      $('#nextStep').click(function () {
        if ($("input[type='radio']:checked").val() != "") {
          if ($("#ap").is(":checked") == true) {
            $('#2GHzOption').val(1);
            if ($('#manualNetwork').is(":checked") == true) {
              $('#2GHzRadio').val("manual");
              if (!$.REG_SSID.test($('#manualSsid').val())) {
                if ($('#manualSsid').val().length == 0) {
                  $.addErrMsgAfter('manualSsid', ssid_null, false, 'error_info_2');
                } else {
                  $.addErrMsgAfter('manualSsid', ssid_invalid, false, 'error_info_2');
                }
                return false;
              } else {
                rootSSID = $('#manualSsid').val();
                $.checkManualSSID("2.4g");
              }
            } else {
              $('#2GHzRadio').val("");
            }
            if ((rootSSID).length > 28)
              $('#client2GHzSSID').val($.do_xss_ssid((rootSSID).substring(0, 26)));
            else
              $('#client2GHzSSID').val($.do_xss_ssid((rootSSID)));
            $('#root2GHzSSID').val($.do_xss_ssid((rootSSID)));
          } else {
            $('#2GHzOption').val(0);
            $('#2GHzRadio').val("");
            $('#root2GHzSSID').val("12345678NETGEAR");
          }
          if ($("#ap5g").is(":checked") == true) {
            $('#5GHzOption').val(1);
            if ($('#manualNetwork5g').is(":checked") == true) {
              $('#5GHzRadio').val("manual");
              if (!$.REG_SSID.test($('#manualSsid5g').val())) {
                if ($('#manualSsid5g').val().length == 0) {
                  $.addErrMsgAfter('manualSsid5g', ssid_null, false, 'error_info_5');
                } else {
                  $.addErrMsgAfter('manualSsid5g', ssid_invalid, false, 'error_info_5');
                }
                return false;
              } else {
                rootSSID5g = $('#manualSsid5g').val();
                $.checkManualSSID("5g");
              }
              $('#5GHzRadio').val("manual");
            } else {
              $('#5GHzRadio').val("");
            }
            if ((rootSSID5g).length > 28)
              $('#client5GHzSSID').val($.do_xss_ssid((rootSSID5g).substring(0, 26)));
            else
              $('#client5GHzSSID').val($.do_xss_ssid((rootSSID5g)));
            $('#root5GHzSSID').val($.do_xss_ssid((rootSSID5g)));
          } else {
            $('#5GHzOption').val(0);
            $('#5GHzRadio').val("");
            $('#root5GHzSSID').val("12345678NETGEAR-5G");
          }

          if (($("#ap5g").is(":checked") == true && rootVie5g == "08" && $("#ap").is(":checked") == false) || ($("#ap5g").is(":checked") == false && rootVie == "08") || ($("#ap5g").is(":checked") == true && rootVie5g == "08" && $("#ap").is(":checked") == true && rootVie == "08")) {
            $('#NtgrRouter').val("1");
          } else {
            $('#NtgrRouter').val("0");
          }

          if (($("#ap").is(":checked") == true && securityType == "OFF" && $("#ap5g").is(":checked") == true && securityType5g == "OFF") || ($("#ap").is(":checked") == true && securityType == "OFF" && $("#ap5g").is(":checked") == false) || ($("#ap").is(":checked") == false && $("#ap5g").is(":checked") == true && securityType5g == "OFF")) {
            $.submit_wait('body', $.APPLYING_DIV);
            $.postForm('#selectNetworkForm', '', function (json) {
              if (json.status == '1') {
                if (fastlane_type != '1' && (($("#ap5g").is(":checked") == true && rootVie5g == "08" && $("#ap").is(":checked") == false) || ($("#ap5g").is(":checked") == false && rootVie == "08" && $("#ap").is(":checked") == true) || ($("#ap5g").is(":checked") == true && rootVie5g == "08" && $("#ap").is(":checked") == true && rootVie == "08"))) {
                  location.href = "ca_extender_vie.htm" + $.ID_2;
                }
                else {
                  location.href = "ca_extender_bgn.htm" + $.ID_2;
                }
              } else {
                $.alertBox(json.msg);
              }
            });
          } else {
            $('#selectNetworkForm').attr('method', 'post');
            $.submit_wait('body', $.APPLYING_DIV);
            $.postForm('#selectNetworkForm', '', function (json) {
              if (json.status == '1') {
                if (fastlane_type != '1' && ((($("#ap5g").is(":checked") == true || $('#manualNetwork5g').is(":checked") == true) && rootVie5g == "08" && rootVie5g != "" && ($("#ap").is(":checked") == false && $('#manualNetwork').is(":checked") == false)) || ($("#ap5g").is(":checked") == false && $('#manualNetwork5g').is(":checked") == false && ($("#ap").is(":checked") == true || $('#manualNetwork').is(":checked") == true) && rootVie == "08" && rootVie != "") || (($("#ap5g").is(":checked") == true || $('#manualNetwork5g').is(":checked") == true) && rootVie5g == "08" && rootVie5g != "" && ($("#ap").is(":checked") == true || $('#manualNetwork').is(":checked") == true) && rootVie == "08" && rootVie != ""))) {
                  location.href = "ca_extender_vie.htm" + $.ID_2;
                }
                else {
                  location.href = json.url + $.ID_2;
                }
              } else {
                $.alertBox(json.msg);
              }
            });
          }
        } else {
          $.submit_wait('body', $.APPLYING_DIV);
          $.postForm('#selectNetworkForm', '', function (json) {
            if (json.status == '1') {
              if (fastlane_type != '1' && ((($("#ap5g").is(":checked") == true || $('#manualNetwork5g').is(":checked") == true) && rootVie5g == "08" && rootVie5g != "" && ($("#ap").is(":checked") == false && $('#manualNetwork').is(":checked") == false)) || ($("#ap5g").is(":checked") == false && $('#manualNetwork5g').is(":checked") == false && ($("#ap").is(":checked") == true || $('#manualNetwork').is(":checked") == true) && rootVie == "08" && rootVie != "") || (($("#ap5g").is(":checked") == true || $('#manualNetwork5g').is(":checked") == true) && rootVie5g == "08" && rootVie5g != "" && ($("#ap").is(":checked") == true || $('#manualNetwork').is(":checked") == true) && rootVie == "08" && rootVie != "")))
                location.href = "ca_extender_vie.htm" + $.ID_2;
              else
                location.href = json.url + $.ID_2;
            } else {
              $.alertBox(json.msg);
            }
          });
        }
      });
    } // end $('#selectNetworkForm').length


    if ($('#vieForm').length) {
      $('#nextStep').click(function () {
        $.submit_wait('body', $.WAITING_DIV);
        $.postForm('#vieForm', '', function (json) {
          if (json.status == '1') {
            if ((existOption == "1" && existSecurity == "OFF" && existOption5g == "0" && existSecurity5g != "OFF") || (existOption == "0" && existSecurity != "OFF" && existOption5g == "1" && existSecurity5g == "OFF") || (existOption == "1" && existSecurity == "OFF" && existOption5g == "1" && existSecurity5g == "OFF"))
              location.href = "/ca_extender_bgn.htm" + $.ID_2;
            else
              location.href = json.url + $.ID_2;
          } else {
            $('.running').remove();
            $.alertBox(json.msg);
          }
        });
      });
    } // end $('#vieNetworkForm').length

		/*******************************************************************************************
		*
		*	2.4GHz Existing Network page
		*
		******************************************************************************************/
    $.checkNextBtn_exist = function () {
      var formId = 'bgnExistingNetworkForm';
      if (!$('#' + formId).length) {
        return;
      }
      var isEnable = true,
        isEnable2g = true,
        isEnable5g = true;
      if (existOption == "1" && existRadio == "manual") {
        if ($('#securityTypeMan').val() == '0') {
          isEnable2g = false;
        } else if ($('#securityTypeMan').val() == 'None') {
          isEnable2g = true;
        } else if ($('#securityTypeMan').val() == 'WEP') {
          var len1 = $.convertWEPAuthLenToSetVal($('#wepEncManual').val());
          var len2 = len1 * 2;
          isEnable2g = $('#keyManual').val().length == len1 || $('#keyManual').val().length == len2;
        } else {
          isEnable2g = $('#pwdMan').val().length >= 8 && $('#pwdMan').val().length <= 64;
        }
      } else if (existOption == "1") {
        if (existSecurity == "OFF") {
          isEnable2g = true;
        } else if (existSecurity == "WEP") {
          var len1 = $.convertWEPAuthLenToSetVal($('#encrStr').val());
          var len2 = len1 * 2;
          isEnable2g = $('#password').val().length == len1 || $('#password').val().length == len2;
        } else {
          isEnable2g = $('#pwd').val().length >= 8 && $('#pwd').val().length <= 64;
        }
      }

      if (have_wireless_an == "1" && existOption5g == "1" && existRadio5g == "manual") {
        if ($('#securityTypeMan5g').val() == '0') {
          isEnable5g = false;
        } else if ($('#securityTypeMan5g').val() == 'None') {
          isEnable5g = true;
        } else if ($('#securityTypeMan5g').val() == 'WEP') {
          var len1 = $.convertWEPAuthLenToSetVal($('#wepEncManual5g').val());
          var len2 = len1 * 2;
          isEnable5g = $('#keyManual5g').val().length == len1 || $('#keyManual5g').val().length == len2;
        } else {
          isEnable5g = $('#pwdMan5g').val().length >= 8 && $('#pwdMan5g').val().length <= 64;
        }
      } else if (have_wireless_an == "1" && existOption5g == "1") {
        if (existSecurity5g == "OFF") {
          isEnable5g = true;
        } else if (existSecurity5g == "WEP") {
          var len1 = $.convertWEPAuthLenToSetVal($('#encrStr5g').val());
          var len2 = len1 * 2;
          isEnable5g = $('#password5g').val().length == len1 || $('#password5g').val().length == len2;
        } else {
          isEnable5g = $('#pwd5g').val().length >= 8 && $('#pwd5g').val().length <= 64;
        }
      }
      isEnable = isEnable2g && isEnable5g;
      $.enableButton('nextStep', '#' + formId, 0, isEnable);
    };

    $.checkManualInput = function () {
      if ($('#securityTypeMan').val() != 0) {
        var sec_type = $('#securityTypeMan').val();
        switch (sec_type) {
          case 'None': //None
            break;
          case 'WEP': //WEP
            var reg = $.REG_KEY_64,
              msg = wep_64;
            if ($('#wepEncManual').val() == '128') {
              reg = $.REG_KEY_128;
              msg = wep_128;
            }
            if (!reg.test($('#keyManual').val())) {
              $.addErrMsgAfter('keyManual', msg, false, 'err_wep');
            }
            break;
          case '3': // WPA-PSK [TKIP]
          case 'WPA2-PSK': // WPA2-PSK [AES]
          case 'WPA/WPA2': // WPA-PSK [TKIP] + WPA2-PSK [AES]
					case 'WPA3': // WPA3-Personal
          case 'WPA2/WPA3': // WPA2/WPA3-Personal
            if (!$.REG_WPA_PWD.test($('#pwdMan').val())) {
              $.addErrMsgAfter('pwdMan', wpa_phrase, false, 'err_pripass');
            }
            break;
          default:
            $.addErrMsgAfter('securityTypeMan', no_security);
        }
      } else {
        $.addErrMsgAfter('securityTypeMan', no_security);
      }
    }

    $.checkManualInput5g = function () {
      if ($('#securityTypeMan5g').val() != 0) {
        var sec_type = $('#securityTypeMan5g').val();
        switch (sec_type) {
          case 'None': //None
            break;
          case 'WEP': //WEP
            var reg = $.REG_KEY_64,
              msg = wep_64;
            if ($('#wepEncManual5g').val() == '13') {
              reg = $.REG_KEY_128;
              msg = wep_128;
            }
            if (!reg.test($('#keyManual5g').val())) {
              $.addErrMsgAfter('keyManual5g', msg, false, 'err_wep_5g');
            }
            break;
          case '3': // WPA-PSK [TKIP]
          case 'WPA2-PSK': // WPA2-PSK [AES]
          case 'WPA/WPA2': // WPA-PSK [TKIP] + WPA2-PSK [AES]
					case 'WPA3': // WPA3-Personal
          case 'WPA2/WPA3': // WPA2/WPA3-Personal
            if (!$.REG_WPA_PWD.test($('#pwdMan5g').val())) {
              $.addErrMsgAfter('pwdMan5g', wpa_phrase, false, 'err_pripass_5g');
            }
            break;
          default:
            $.addErrMsgAfter('securityTypeMan5g', no_security);
        }
      } else {
        $.addErrMsgAfter('securityTypeMan5g', no_security);
      }
    }

    $.setMaxLen = function () {
      if (existRadio != "manual") {
        return;
      }
      if ($('#securityTypeMan').val() == 'WEP') {
        $('#keyManual').attr('maxlength', $.convertWEPAuthLenToSetVal($('#wepEncManual').val())*2);
        $('#keyManual').val('');
      } else if ($('#securityTypeMan').val() != '0' && $('#securityTypeMan').val() != 'None') {
        $('#pwdMan').attr('maxlength', 64);
        $('#pwdMan').val('');
      }
    }

    $.setMaxLen5g = function () {
      if (existRadio5g != "manual") {
        return;
      }
      if ($('#securityTypeMan5g').val() == 'WEP') {
        $('#keyManual5g').attr('maxlength', $.convertWEPAuthLenToSetVal($('#wepEncManual5g').val())*2);
        $('#keyManual5g').val('');
      } else if ($('#securityTypeMan5g').val() != '0' && $('#securityTypeMan5g').val() != 'None') {
        $('#pwdMan5g').attr('maxlength', 64);
        $('#pwdMan5g').val('');
      }
    }

    $.checkExistInput = function (existSecurity) {
      if (existSecurity == "OFF" || existSecurity == "1") {
      } else if (existSecurity == "WEP" || existSecurity == "2") {
        var reg = $.REG_KEY_64,
          msg = wep_64;
	if ( $('#encrStr').val() == '128' ) {
          reg = $.REG_KEY_128;
          msg = wep_128;
        }
        if (!reg.test($('#password').val())) {
          $.addErrMsgAfter('password', msg);
        }
      } else {
        if (!$.REG_WPA_PWD.test($('#pwd').val())) {
          $.addErrMsgAfter('pwd', wpa_phrase, false, 'err_pripass');
        }
      }
    };

    $.checkExistInput5g = function (existSecurity) {
      if (existSecurity == "OFF" || existSecurity == "1") {
      } else if (existSecurity == "WEP" || existSecurity == "2") {
        var reg = $.REG_KEY_64,
          msg = wep_64;
	if ( $('#encrStr5g').val() == '128' ) {
          reg = $.REG_KEY_128;
          msg = wep_128;
        }
        if (!reg.test($('#password5g').val())) {
          $.addErrMsgAfter('password5g', msg);
        }
      } else {
        if (!$.REG_WPA_PWD.test($('#pwd5g').val())) {
          $.addErrMsgAfter('pwd5g', wpa_phrase, false, 'err_pripass_5g');
        }
      }
    };

    $.showExistSecInfo = function (existSecurity, existSectype, id) {
      if (existSecurity == "OFF")
        $('#' + id).html(none);
      else if (existSecurity == "WEP")
        $('#' + id).html(sec_wep_phrase);
      else if (existSecurity == "WPA/WPA2-PSK")
        $('#' + id).html(sec_wpas_phrase);
      else
        $('#' + id).html(existSecurity + "[" + existSectype + "]");
    };

    $.showExistInfo = function (existSecurity, existSectype) {
      var parent_obj;
      if (have_wireless_an == "1") {
        $.showExistSecInfo(existSecurity, existSectype, "2GHzSecurityShow");
        parent_obj = $('.first.existing');
      } else {
        parent_obj = $('.formElements');
      }
      if (existSecurity == "OFF") {
        parent_obj.find('.wep').hide();
        parent_obj.find('.wepwpa').hide();
        parent_obj.find('.wpa').hide();
      } else if (existSecurity == "WEP") {
        parent_obj.find('.wep').show();
        parent_obj.find('.wepwpa').show();
        parent_obj.find('.wpa').hide();
        $('#password').attr('maxlength', $.convertWEPAuthLenToSetVal($('#encrStr').val())*2);
        $('#encrStr').trigger('change');
      } else {
        parent_obj.find('.wep').hide();
        parent_obj.find('.wepwpa').show();
        parent_obj.find('.wpa').show();
      }
    };

    $.showExistInfo5g = function (existSecurity, existSectype) {
      $.showExistSecInfo(existSecurity, existSectype, "5GHzSecurityShow");

      if (existSecurity == "OFF") {
        $('.second.existing').find('.wep').hide();
        $('.second.existing').find('.wepwpa').hide();
        $('.second.existing').find('.wpa').hide();
      } else if (existSecurity == "WEP") {
        $('.second.existing').find('.wep').show();
        $('.second.existing').find('.wepwpa').show();
        $('.second.existing').find('.wpa').hide();
        $('#password5g').attr('maxlength', $('#encrStr5g').val() * 2);
        $('#encrStr5g').trigger('change');
      } else {
        $('.second.existing').find('.wep').hide();
        $('.second.existing').find('.wepwpa').show();
        $('.second.existing').find('.wpa').show();
      }
    };

    if ($('#bgnExistingNetworkForm').length) {
      $('.container').keyup(function () { $.checkNextBtn_exist(); });
      $('.container').keydown(function () { $.checkNextBtn_exist(); });
      $('.container').change(function () { $.checkNextBtn_exist(); });
      //setting the ssid and security according to url query
      if (have_wireless_an == "1") {
        $('#2GHzOption').val(existOption);
        $('#5GHzOption').val(existOption5g);
      }

      if (have_wireless_an == "0" || have_wireless_an == "1" && existOption == "1") {
        if (existRadio == "manual") {
          if (have_wireless_an == "1")
            $('.column.first.manual').show();
          $('#2GHzSSIDShow2').html($.xss_ssid_format(existSSID));
        } else {
          // existSSID = existSSID.replace(/%20/g, ' ');

          if (have_wireless_an == "1" && existSecurity != "OFF")
            $('.column.first.existing').show();

          $('#2GHzSecurity').val($.setSecurityType(existSecurity, existSectype));
          $('#2GHzChannel').val($.getUrlParam('2GHzChannel'));
          $('#2GHzMode').val($.getUrlParam('2GHzMode'));
          $('#2GHzSSIDShow').html($.xss_ssid_format(existSSID));

          $.showExistInfo(existSecurity, existSectype);
        }

        $('#root2GHzSSID').val($.do_xss_ssid(existSSID));
        if (existSSID.length > 28) {
          if (have_wireless_an == "1")
            $('#client2GHzSSID').val($.do_xss_ssid(existSSID.substring(0, 26)));
          else
            $('#client2GHzSSID').val($.do_xss_ssid(existSSID.substring(0, 28)));
        } else
          $('#client2GHzSSID').val($.do_xss_ssid(existSSID));

      } else {
        $('.column.first.manual').hide();
        $('.column.first.existing').hide();
        $('#root2GHzSSID').val("12345678NETGEAR");
        $('#2GHzSecurity').val($.setSecurityType(existSecurity5g, existSectype5g));
        if (existOption5g == "1") {
          if (existRadio5g == "manual") {
            $('.column.second.manual').css({ 'margin-left': '24%' });
          } else {
            $('.column.second.existing').css({ 'margin-left': '24%' });
          }
        }
      }

      if (have_wireless_an == "1" && existOption5g == "1") {
        if (existRadio5g == "manual") {
          $('.column.second.manual').show();
          $('#5GHzSSIDShow2').html($.xss_ssid_format(existSSID5g));
        } else {
          // existSSID5g = existSSID5g.replace(/%20/g, ' ');
          if (existSecurity5g != "OFF")
            $('.column.second.existing').show();

          $('#5GHzSecurity').val($.setSecurityType(existSecurity5g, existSectype5g));
          $('#5GHzChannel').val($.getUrlParam('5GHzChannel'));
          $('#5GHzMode').val($.getUrlParam('5GHzMode'));
          $('#5GHzSSIDShow').html($.xss_ssid_format(existSSID5g));

          $.showExistInfo5g(existSecurity5g, existSectype5g);
        }

        $('#root5GHzSSID').val($.do_xss_ssid(existSSID5g));
        if (existSSID5g.length > 28)
          $('#client5GHzSSID').val($.do_xss_ssid(existSSID5g.substring(0, 26)));
        else
          $('#client5GHzSSID').val($.do_xss_ssid(existSSID5g));

      }
      else if (have_wireless_an == "1") {
        $('.column.second.manual').hide();
        $('.column.second.existing').hide();
        $('#root5GHzSSID').val("12345678NETGEAR-5G");
        $('#5GHzSecurity').val($.setSecurityType(existSecurity, existSectype));
        if (existOption == "1") {
          if (existRadio == "manual") {
            $('.column.first.manual').css({ 'margin-left': '24%' });
          } else {
            $('.column.first.existing').css({ 'margin-left': '24%' });
          }
        }
      }

      if (existOption == "1" && existOption5g == "1" && existRadio != "manual" && existRadio5g != "manual" && existSecurity == existSecurity5g && existSectype == existSectype5g && existSecurity != "OFF" && existSecurity != "WEP") {
        $('.samePwd').show();
        $('#pwd5g').prop('disabled', true);
        $.triggerFirstExisting = function () {
          if ($("#enablePwd").is(":checked") == true) {
            $('#pwd5g').val($('#pwd').val());
          }
        };
        $('.column.first.existing').change(function () { $.triggerFirstExisting(); });
        $('.column.first.existing').keyup(function () { $.triggerFirstExisting(); });
        $('.column.first.existing').keydown(function () { $.triggerFirstExisting(); });

        $('#enablePwd').click(function () {
          if ($("#enablePwd").is(":checked") == true) {
            $('#pwd5g').prop('disabled', true);
            $('#pwd5g').val($('#pwd').val());
          } else {
            $('#pwd5g').prop('disabled', false);
            $('#pwd5g').val("");
          }
        });
      }

      if ($('.manual2GHzSecurity').length) {
        $('.manual2GHzSecurity').on('change', function () {
          var thisParent = $(this).parents('.formElements');
          if ($.convertSecTypeToNum($(this).val()) != 0)
            $('.errorMsg').remove();
          if ($.convertSecTypeToNum($(this).val()) > 2) {
            thisParent.find('.wep').slideUp();
            thisParent.find('.wpa').slideDown();
            thisParent.find('.wepwpa').slideDown();
            thisParent.find('.wepwpa').find(':password').val('');
          } else if ($.convertSecTypeToNum($(this).val()) > 1) {
            thisParent.find('.wep').slideDown();
            thisParent.find('.wpa').slideUp();
            thisParent.find('.wepwpa').slideDown();
            thisParent.find('.wepwpa').find(':password').val('');
          } else {
            thisParent.find('.pwdInput').slideUp();
            thisParent.find('.pwdInput').find(':password').val('');
          }
        });
        $('.manual2GHzSecurity').trigger('change');
      }

      $('#nextStep').click(function () {
        $('.errorMsg').remove();
        if (have_wireless_an == "0" || have_wireless_an == "1" && existOption == "1") {
          if (existRadio == "manual") {
            $.checkManualInput();

	    $('#2GHzSecurity').val($.convertSecTypeToNum($('#securityTypeMan').val()));

	    if ( $('#securityTypeMan').val() == 'WEP' ) {
              $('#2GHzEncrLen').val($.convertWEPAuthLenToSetVal($('#wepEncManual').val()));
              $('#2GHzKeyNo').val($('#wepKeyNoManual').val());
              $('#2GHzAuthType').val($.convertWEPAuthTypeToNum($('#wepAuthManual').val()));
              $('#2GHzWepPass').val($('#keyManual').val());
            } else if ($('#securityTypeMan').val() != 0) {
              $('#2GHzPassword').val($.do_xss_pass($('#pwdMan').val()));
            }
          } else {
            $.checkExistInput(existSecurity);
            if (existSecurity == "WEP") {
              $('#2GHzEncrLen').val($.convertWEPAuthLenToSetVal($('#encrStr').val()));
              $('#2GHzKeyNo').val($('#keyNum').val());
			  $('#2GHzAuthType').val($.convertWEPAuthTypeToNum($('#authType').val()));
              $('#2GHzWepPass').val($('#password').val());
            } else if (existSecurity != "OFF") {
              $('#2GHzPassword').val($.do_xss_pass($('#pwd').val()));
            }
          }
        }

        if (have_wireless_an == "1" && existOption5g == "1") {
          if (existRadio5g == "manual") {
            $.checkManualInput5g();
	    $('#5GHzSecurity').val($.convertSecTypeToNum($('#securityTypeMan5g').val()));

	    if ( $('#securityTypeMan5g').val() == 'WEP' ) {
	      $('#5GHzEncrLen').val($.convertWEPAuthLenToSetVal($('#wepEncManual5g').val()));
              $('#5GHzKeyNo').val($('#wepKeyNoManual5g').val());
	      $('#5GHzAuthType').val($.convertWEPAuthTypeToNum($('#wepAuthManual5g').val()));
              $('#5GHzWepPass').val($('#keyManual5g').val());
            } else if ($('#securityTypeMan5g').val() != 0) {
              $('#5GHzPassword').val($.do_xss_pass($('#pwdMan5g').val()));
            }
          } else {
            $.checkExistInput5g(existSecurity5g);
            if (existSecurity5g == "WEP") {
	      $('#5GHzEncrLen').val($.convertWEPAuthLenToSetVal($('#encrStr5g').val()));
              $('#5GHzKeyNo').val($('#keyNum5g').val());
	      $('#5GHzAuthType').val($.convertWEPAuthTypeToNum($('#authType5g').val()));
              $('#5GHzWepPass').val($('#password5g').val());
            } else if (existSecurity5g != "OFF") {
              $('#5GHzPassword').val($.do_xss_pass($('#pwd5g').val()));
            }
          }
        }

        if (!$('.errorMsg').length) {
          $('.running').remove();
          $.submit_wait('body', $.APPLYING_DIV);
          $.postForm('#bgnExistingNetworkForm', '', function (json) {
            if (json.status == '1') {
              var time = parseInt(json.wait) * 1000;
              setTimeout(function () {
                location.href = json.url + $.ID_2;
              }, time);
            } else {
              $.alertBox(json.msg);
            }
          });
        }
      });
    }
		/*******************************************************************************************
		*
		*       Failure! Continue Setting page
		*
		******************************************************************************************/
    $.checkContinueInput = function (existSecurity) {
      if (existSecurity == "OFF" || existSecurity == "1") {
      } else if (existSecurity == "WEP" || existSecurity == "2") {
        var reg = $.REG_KEY_64,
          msg = wep_64;
	if ( $('#encrStrFail').val() == '128' ) {
          reg = $.REG_KEY_128;
          msg = wep_128;
        }
        if (!reg.test($('#wepPassFail').val())) {
          $.addErrMsgAfter('wepPassFail', msg);
        }
      } else {
        if (!$.REG_WPA_PWD.test($('#passphrase').val())) {
          $.addErrMsgAfter('passphrase', wpa_phrase, false, 'err_pripass');
        }
      }
    };

    $.checkContinueInput5g = function (existSecurity) {
      if (existSecurity == "OFF" || existSecurity == "1") {
      } else if (existSecurity == "WEP" || existSecurity == "2") {
        var reg = $.REG_KEY_64,
          msg = wep_64;
	if ( $('#encrStrFail5g').val() == '128' ) {
          reg = $.REG_KEY_128;
          msg = wep_128;
        }
        if (!reg.test($('#wepPassFail5g').val())) {
          $.addErrMsgAfter('wepPassFail5g', msg);
        }
      } else {
        if (!$.REG_WPA_PWD.test($('#passphrase5g').val())) {
          $.addErrMsgAfter('passphrase5g', wpa_phrase, false, 'err_pripass_5g');
        }
      }
    };

    if ($('#continueNetworkForm').length) {
      var formElement_obj;
      if (have_wireless_an == "1")
        formElement_obj = $('.column.first').find('.formElements');
      else
        formElement_obj = $('.formElements');

      if (have_wireless_an == "1" && rootOption == "1" && rootOption5g == "1" && linkStatus == "0" && linkStatus5g == "0")
        $('#show_mac').html(ca_retry_mac + "&nbsp;" + lan_mac_2g + "," + lan_mac_5g + "." + adapter_macaddr + lan_mac + "." + ca_cancel);
      else if (rootOption5g == "1" && linkStatus5g == "0")
        $('#show_mac').html(ca_retry_mac1 + "&nbsp;" + lan_mac_5g + "." + adapter_macaddr + lan_mac + "." + ca_cancel);
      else
        $('#show_mac').html(ca_retry_mac1 + "&nbsp;" + lan_mac_2g + "." + adapter_macaddr + lan_mac + "." + ca_cancel);

      if (have_wireless_an == "0"
        || have_wireless_an == "1" && (rootOption == "1" && linkStatus == "0")) {
        if (have_wireless_an == "1")
          $('.column.first').show();
      }
      $('#2GHzSSIDShow').text(rootSSIDShow);

      if (rootSecurity == "7" || rootSecurity == "8")
        $('#2GHzSecurityShow').html(sec_wpas_phrase);
      else
        $('#2GHzSecurityShow').html($.formatSecType2(rootSecurity));

      if (rootSecurity == "1") {
        formElement_obj.find('.wep').hide();
        formElement_obj.find('.wepwpa').hide();
        formElement_obj.find('.wpa').hide();
        $.enableButton('continueBt', '#continueNetworkForm', 0, true);
      } else if (rootSecurity == "2") {
        formElement_obj.find('.wep').show();
        formElement_obj.find('.wepwpa').show();
        formElement_obj.find('.wpa').hide();
        $('#encrStrFail').val($.convertWEPAuthLength(rootEncrLen));
	$('#authTypeFail').val($.convertWEPAuthTypeToText(rootAuthType));
        $('#keyNumFail').val(rootKeyNum);
	$('#wepPassFail').attr('maxlength', $.convertWEPAuthLenToSetVal($('#encrStrFail').val())*2);
        $('#encrStrFail').trigger('change');
        if (rootKeyNum == '1')
          $('#wepPassFail').val(rootKey1);
        else if (rootKeyNum == '2')
          $('#wepPassFail').val(rootKey2);
        else if (rootKeyNum == '3')
          $('#wepPassFail').val(rootKey3);
        else
          $('#wepPassFail').val(rootKey4);
        $('#wepPassFail').keyup(function () {
	  var len1 = $.convertWEPAuthLenToSetVal($('#encrStrFail').val());
          var len2 = len1 * 2;
          if ($(this).val().length == len1 || $(this).val().length == len2) {
            $.enableButton('continueBt', '#continueNetworkForm', 0, true);
          } else {
            $.enableButton('continueBt', '#continueNetworkForm', 0, false);
          }
        });
        $('#wepPassFail').trigger('keyup');
        $('#wepPassFail').change(function () {
          var len1 = $.convertWEPAuthLenToSetVal($('#encrStrFail').val());
          var len2 = len1 * 2;
          if ($(this).val().length == len1 || $(this).val().length == len2) {
            $.enableButton('continueBt', '#continueNetworkForm', 0, true);
          } else {
            $.enableButton('continueBt', '#continueNetworkForm', 0, false);
          }
        });
        $('#wepPassFail').trigger('change');
      } else {
        formElement_obj.find('.wep').hide();
        formElement_obj.find('.wepwpa').show();
        formElement_obj.find('.wpa').show();
        $('#passphrase').attr('maxlength', 64);
        $('#passphrase').val(rootPassword);
        $('#passphrase').keyup(function () {
          if ($(this).val().length >= 8) {
            $.enableButton('continueBt', '#continueNetworkForm', 0, true);
          } else {
            $.enableButton('continueBt', '#continueNetworkForm', 0, false);
          }
        });
        $('#passphrase').trigger('keyup');
        $('#passphrase').change(function () {
          if ($(this).val().length >= 8) {
            $.enableButton('continueBt', '#continueNetworkForm', 0, true);
          } else {
            $.enableButton('continueBt', '#continueNetworkForm', 0, false);
          }
        });
        $('#passphrase').trigger('change');
      }

      if (have_wireless_an == "1" && (rootOption5g == "1" && linkStatus5g == "0")) {
        $('.column.second').show();
      }
      $('#5GHzSSIDShow').text(rootSSIDShow5g);

      if (rootSecurity5g == "7" || rootSecurity5g == "8")
        $('#5GHzSecurityShow').html(sec_wpas_phrase);
      else
        $('#5GHzSecurityShow').html($.formatSecType2(rootSecurity5g));

      if (rootSecurity5g == "1") {
        $('.column.second').find('.formElements').find('.wep').hide();
        $('.column.second').find('.formElements').find('.wepwpa').hide();
        $('.column.second').find('.formElements').find('.wpa').hide();
        $.enableButton('continueBt', '#continueNetworkForm', 0, true);
      } else if (rootSecurity5g == "2") {
        $('.column.second').find('.formElements').find('.wep').show();
        $('.column.second').find('.formElements').find('.wepwpa').show();
        $('.column.second').find('.formElements').find('.wpa').hide();
	$('#encrStrFail5g').val($.convertWEPAuthLength(rootEncrLen5g));
	$('#authTypeFail5g').val($.convertWEPAuthTypeToText(rootAuthType5g));
        $('#keyNumFail5g').val(rootKeyNum5g);
	$('#wepPassFail5g').attr('maxlength', $.convertWEPAuthLenToSetVal($('#encrStrFail5g').val())*2);
        $('#encrStrFail5g').trigger('change');
        if (rootKeyNum5g == '1')
          $('#wepPassFail5g').val(rootKey5g1);
        else if (rootKeyNum5g == '2')
          $('#wepPassFail5g').val(rootKey5g2);
        else if (rootKeyNum5g == '3')
          $('#wepPassFail5g').val(rootKey5g3);
        else
          $('#wepPassFail5g').val(rootKey5g4);
        $('#wepPassFail5g').keyup(function () {
	  var len1 = $.convertWEPAuthLenToSetVal($('#encrStrFail5g').val());
          var len2 = len1 * 2;
          if ($(this).val().length == len1 || $(this).val().length == len2) {
            $.enableButton('continueBt', '#continueNetworkForm', 0, true);
          } else {
            $.enableButton('continueBt', '#continueNetworkForm', 0, false);
          }
        });
        $('#wepPassFail5g').trigger('keyup');
        $('#wepPassFail5g').change(function () {
	  var len1 = $.convertWEPAuthLenToSetVal($('#encrStrFail5g').val());
          var len2 = len1 * 2;
          if ($(this).val().length == len1 || $(this).val().length == len2) {
            $.enableButton('continueBt', '#continueNetworkForm', 0, true);
          } else {
            $.enableButton('continueBt', '#continueNetworkForm', 0, false);
          }
        });
        $('#wepPassFail5g').trigger('change');
      } else {
        $('.column.second').find('.formElements').find('.wep').hide();
        $('.column.second').find('.formElements').find('.wepwpa').show();
        $('.column.second').find('.formElements').find('.wpa').show();
        $('#passphrase5g').attr('maxlength', 64);
        $('#passphrase5g').val(rootPassword5g);
        $('#passphrase5g').keyup(function () {
          if ($(this).val().length >= 8) {
            $.enableButton('continueBt', '#continueNetworkForm', 0, true);
          } else {
            $.enableButton('continueBt', '#continueNetworkForm', 0, false);
          }
        });
        $('#passphrase5g').trigger('keyup');
        $('#passphrase5g').change(function () {
          if ($(this).val().length >= 8) {
            $.enableButton('continueBt', '#continueNetworkForm', 0, true);
          } else {
            $.enableButton('continueBt', '#continueNetworkForm', 0, false);
          }
        });
        $('#passphrase5g').trigger('change');
      }

      $('#continueBt').click(function () {
        $('.errorMsg').remove();
        if (have_wireless_an == "0" || have_wireless_an == "1" && rootOption == "1") {
          $('#2GHzOption').val(rootOption);
          $('#root2GHzSSID').val($.special_xss(rootSSIDShow));
          $('#client2GHzSSID').val($.do_xss_ssid(clientSSID));
          $('#2GHzSecurity').val(rootSecurity);
          $('#2GHzChannel').val(channel);
          $('#2GHzMode').val(mode);
          $.checkContinueInput(rootSecurity);
          if (rootSecurity == "2") {
	    $('#2GHzEncrLen').val($.convertWEPAuthLenToSetVal($('#encrStrFail').val()));
            $('#2GHzKeyNo').val($('#keyNumFail').val());
	    $('#2GHzAuthType').val($.convertWEPAuthTypeToNum($('#authTypeFail').val()));
            $('#2GHzWepPass').val($('#wepPassFail').val());
          } else if (rootSecurity != "1" && rootSecurity != "0") {
            $('#2GHzPassword').val($.do_xss_pass($('#passphrase').val()));
          }
        } else {
          $('#2GHzOption').val(0);
          $('#root2GHzSSID').val("12345678NETGEAR");
          $('#2GHzSecurity').val('1');
        }
        if (have_wireless_an == "1" && rootOption5g == "1") {
          $('#5GHzOption').val(rootOption5g);
          $('#root5GHzSSID').val($.special_xss(rootSSIDShow5g));
          $('#client5GHzSSID').val($.do_xss_ssid(clientSSID5g));
          $('#5GHzSecurity').val(rootSecurity5g);
          $('#5GHzChannel').val(channel5g);
          $('#5GHzMode').val(mode5g);
          $.checkContinueInput5g(rootSecurity5g);
          if (rootSecurity5g == "2") {
	    $('#5GHzEncrLen').val($.convertWEPAuthLenToSetVal($('#encrStrFail5g').val()));
            $('#5GHzKeyNo').val($('#keyNumFail5g').val());
	    $('#5GHzAuthType').val($.convertWEPAuthTypeToNum($('#authTypeFail5g').val()));
            $('#5GHzWepPass').val($('#wepPassFail5g').val());
          } else if (rootSecurity5g != "1" && rootSecurity5g != "0") {
            $('#5GHzPassword').val($.do_xss_pass($('#passphrase5g').val()));
          }
        } else if (have_wireless_an == "1") {
          $('#5GHzOption').val(0);
          $('#root5GHzSSID').val("12345678NETGEAR-5G");
          $('#5GHzSecurity').val('1');
        }
        if (!$('.errorMsg').length) {
          $('.running').remove();
          $.submit_wait('body', $.APPLYING_DIV);
          $.postForm('#continueNetworkForm', '', function (json) {
            if (json.status == '1') {
              var time = parseInt(json.wait) * 1000;
              setTimeout(function () {
                location.href = json.url + $.ID_2;
              }, time);
            } else {
              $.alertBox(json.msg);
            }
          });
        }
      });

      if ($('#cancelBt', '#continueNetworkForm').length) {
        $('#cancelBt').attr('href', 'ca_extender_setup.htm' + $.ID_2);
      }
      if ($('#skipBt', '#continueNetworkForm').length) {
        $('#skipBt').attr('href', 'status.htm' + $.ID_2);
      }
    }

		/*******************************************************************************************
		*
		*	Extender Bgn Page. ca_extender_bgn.htm
		*
		******************************************************************************************/
    $.showPass = function () {
      var parent_obj;
      if (have_wireless_an == "1") {
        parent_obj = $('.column.first.bgn');
      } else {
        parent_obj = $('body');
      }
      if (rootSecurity == "8" || rootSecurity == "3" || rootSecurity == "4" || rootSecurity == "5")
        rootSecurity = "7";
      if (rootSamesec == '0') {
        parent_obj.find('.securityOptionsWrap').hide();
        parent_obj.find('.pwdInput').hide();
        parent_obj.find('#whatPwd').val('Same');
      } else {
        parent_obj.find('.securityOptionsWrap').show();
        parent_obj.find('.whatPwd').val('Different');
	parent_obj.find('.securityOptions').val($.convertSecTypeToText(rootSecurity));
        if (rootSecurity == '2') {
          parent_obj.find('.wep').show();
          parent_obj.find('.wpa').hide();
	  $('#wepEnc').val($.convertWEPAuthLength(rootEncrLen));
	  $('#wepAuth').val($.convertWEPAuthTypeToText(rootAuthType));
          $('#wepEnc').trigger('change');
          if (rootKeyNum == '1')
            $('#wepKeyNo1').prop('checked', true);
          else if (rootKeyNum == '2')
            $('#wepKeyNo2').prop('checked', true);
          else if (rootKeyNum == '3')
            $('#wepKeyNo3').prop('checked', true);
          else
            $('#wepKeyNo4').prop('checked', true);
          $('#key1').val(rootKey1);
          $('#key2').val(rootKey2);
          $('#key3').val(rootKey3);
          $('#key4').val(rootKey4);
        } else {
          parent_obj.find('.wep').hide();
          parent_obj.find('.wpa').show();
          $('#pwd').val(rootPassword);
          $('#verifyPwd').val(rootPassword);
          $('#pwd').trigger('change');
        }
      }
    }

    $.showPass5g = function () {
      if (rootSecurity5g == "8" || rootSecurity5g == "3" || rootSecurity5g == "4" || rootSecurity5g == "5")
        rootSecurity5g = "7";
      if (rootSamesec5g == '0') {
        $('.column.second.bgn').find('.securityOptionsWrap').hide();
        $('.column.second.bgn').find('.pwdInput').hide();
        $('#whatPwd5g').val('Same');
      } else {
        $('.column.second.bgn').find('.securityOptionsWrap').show();
        $('.column.second.bgn').find('.whatPwd').val('Different');
        $('.column.second.bgn').find('.securityOptions').val($.convertSecTypeToText(rootSecurity5g));
        if (rootSecurity5g == '2') {
          $('.column.second.bgn').find('.wep').show();
          $('.column.second.bgn').find('.wpa').hide();
          $('#wepEnc5g').val($.convertWEPAuthLength(rootEncrLen5g));
          $('#wepAuth5g').val($.convertWEPAuthTypeToText(rootAuthType5g));
          $('#wepEnc5g').trigger('change');
          if (rootKeyNum5g == '1')
            $('#wepKeyNo5g1').prop('checked', true);
          else if (rootKeyNum5g == '2')
            $('#wepKeyNo5g2').prop('checked', true);
          else if (rootKeyNum5g == '3')
            $('#wepKeyNo5g3').prop('checked', true);
          else
            $('#wepKeyNo5g4').prop('checked', true);
          $('#key5g1').val(rootKey5g1);
          $('#key5g2').val(rootKey5g2);
          $('#key5g3').val(rootKey5g3);
          $('#key5g4').val(rootKey5g4);
        } else {
          $('.column.second.bgn').find('.wep').hide();
          $('.column.second.bgn').find('.wpa').show();
          $('#pwd5g').val(rootPassword5g);
          $('#verifyPwd5g').val(rootPassword5g);
          $('#pwd5g').trigger('change');
        }
      }
    }

    function oneWifi() {
      $('#ssid').prop('disabled', true);
      $('#ssid5g').prop('disabled', true);
      $('#whatPwd').prop('disabled', true);
      $('#whatPwd5g').prop('disabled', true);
      $('#whatPwd').css({ 'background-color': '#ebebe4' });
      $('#whatPwd5g').css({ 'background-color': '#ebebe4' });
      if (rootOption == "1" && rootOption5g == "0") {
        $('#ssid').val(rootSSIDShow);
        $('#ssid5g').val(rootSSIDShow);
        $('#securityOptions').val(rootSecurity);
        $('#securityOptions5g').val(rootSecurity);
        $('#pwd').val(rootPassword);
        $('#pwd5g').val(rootPassword);
        $('#verifyPwd').val(rootPassword);
        $('#verifyPwd5g').val(rootPassword);
      } else if (rootOption == "0" && rootOption5g == "1") {
        $('#ssid').val(rootSSIDShow5g);
        $('#ssid5g').val(rootSSIDShow5g);
        $('#securityOptions').val(rootSecurity5g);
        $('#securityOptions5g').val(rootSecurity5g);
        $('#pwd').val(rootPassword5g);
        $('#pwd5g').val(rootPassword5g);
        $('#verifyPwd').val(rootPassword5g);
        $('#verifyPwd5g').val(rootPassword5g);
      } else {
        $('#ssid').val(rootSSIDShow);
        $('#ssid5g').val(rootSSIDShow5g);
        $('#securityOptions').val(rootSecurity);
        $('#securityOptions5g').val(rootSecurity5g);
        $('#pwd').val(rootPassword);
        $('#pwd5g').val(rootPassword5g);
        $('#verifyPwd').val(rootPassword);
        $('#verifyPwd5g').val(rootPassword5g);
      }
      $('.column.first.bgn').find('.securityOptionsWrap').hide();
      $('.column.first.bgn').find('.pwdInput').hide();
      $('.column.second.bgn').find('.securityOptionsWrap').hide();
      $('.column.second.bgn').find('.pwdInput').hide();
      $('#whatPwd').val('Same');
      $('#whatPwd5g').val('Same');
    }

    function differentWifi() {
      $('#ssid').prop('disabled', false);
      $('#ssid5g').prop('disabled', false);
      $('#whatPwd').prop('disabled', false);
      $('#whatPwd5g').prop('disabled', false);
      $('#whatPwd').css({ 'background-color':'#fff'});
      $('#whatPwd5g').css({ 'background-color':'#fff'});
      if (rootOption == "1" && rootOption5g == "0") {
        $('#ssid').val(rootSSIDShow.substring(0, 26) + '_2GEXT');
        $('#ssid5g').val(rootSSIDShow.substring(0, 26) + '_5GEXT');
      } else if (rootOption == "0" && rootOption5g == "1") {
        $('#ssid').val(rootSSIDShow5g.substring(0, 26) + '_2GEXT');
        $('#ssid5g').val(rootSSIDShow5g.substring(0, 26) + '_5GEXT');
      } else {
        $('#ssid').val(rootSSIDShow.substring(0, 26) + '_2GEXT');
        $('#ssid5g').val(rootSSIDShow5g.substring(0, 26) + '_5GEXT');
      }
    }

    if ($('#networkSettingsForm').length) {
      var continue_obj1, continue_obj2, continue_obj3, continue_obj4;
      if (have_wireless_an == "1") {
        continue_obj1 = $('.column.first ul strong:first', '#continue');
        continue_obj2 = $('.column.first ul strong:eq(1)', '#continue');
        continue_obj3 = $('.column.first ul li:last', '#continue');
        continue_obj4 = $('.column.first ul strong:last', '#continue');
      } else {
        continue_obj1 = $('ul strong:first', '#continue');
        continue_obj2 = $('ul strong:eq(1)', '#continue');
        continue_obj3 = $('ul li:last', '#continue');
        continue_obj4 = $('ul strong:last', '#continue');
      }

      if (fastlane_type == '1' && furfing_mode_type == '2.4G') {
        $('.column.first').hide();
        $('.column.second').show();
        $('.column.second').css({ 'margin-left': '24%' });
      }
      else if (fastlane_type == '1' && furfing_mode_type == '5G') {
        $('.column.first').show();
        $('.column.second').hide();
        $('.column.first').css({ 'margin-left': '24%' });
      }

      if (rootOption == "1" && rootOption5g == "0") {
        $('#ssid').val(rootSSIDShow.substring(0, 26) + '_2GEXT');
        $('#ssid5g').val(rootSSIDShow.substring(0, 26) + '_5GEXT');
      } else if (rootOption == "0" && rootOption5g == "1") {
        $('#ssid').val(rootSSIDShow5g.substring(0, 26) + '_2GEXT');
        $('#ssid5g').val(rootSSIDShow5g.substring(0, 26) + '_5GEXT');
      } else {
        $('#ssid').val(rootSSIDShow.substring(0, 26) + '_2GEXT');
        $('#ssid5g').val(rootSSIDShow5g.substring(0, 26) + '_5GEXT');
      }

      if (fastlane_type != '1') {
        if (ntgr_router != "1" || (ntgr_router == "1" && support_seamless_roaming == "1")) {
          $('#enableOneWifiName').prop('checked', true);
          oneWifi();
        } else {
          if (support_seamless_roaming != "1") {
            $(".sameSsid").css('display', 'none');
            differentWifi();
            $('#enableOneWifiName').prop('checked', false);
          }
        }
      } else {
        //$('.sameSsid').hide();
        oneWifi();
      }

      $.detectAp = function () {
        if ($('#ssid').val() == $('#ssid5g').val()) {
          if ($('#whatPwd').val() == $('#whatPwd5g').val()) {
            if ($('#whatPwd').val() == "None") {
              return true;
            } else if (($('#whatPwd').val() == "Different") || ($('#whatPwd').val() == "Same")) {
              if ($('#securityOptions').val() == $('#securityOptions5g').val()) {
                if ($('#securityOptions').val() == "WPA2-PSK" || $('#securityOptions').val() == "WPA/WPA2" || $('#securityOptions').val() == "WPA3" || $('#securityOptions').val() == "WPA2/WPA3") {
                  if ($('#pwd').val() == $('#pwd5g').val()) {
                    return true;
                  }
                } else if ($('#securityOptions').val() == "WEP") {
                  if ($('#wepAuth').val() == $('#wepAuth5g').val() && $('#wepEnc').val() == $('#wepEnc5g').val()) {
                    for (var i = 1; i <= 4; i++) {
                      if ($('#wepKeyNo' + i).is(':checked') == true && $('#wepKeyNo5g' + i).is(':checked') == true && $('#key' + i).val() == $('#key5g' + i).val())
                        return true;
                    }
                  }
                } else {
                  return true;
                }
              }
            }
          }
        }
        return false;
      }

      $.detectSsid = function () {
        if (rootOption == "1" && rootOption5g == "0") {
          if ($('#ssid').val() == rootSSIDShow && $('#ssid5g').val() == rootSSIDShow)
            return true;
          else
            return false;
        } else if (rootOption == "0" && rootOption5g == "1") {
          if ($('#ssid').val() == rootSSIDShow5g && $('#ssid5g').val() == rootSSIDShow5g)
            return true;
          else
            return false;
        } else if (rootOption == "1" && rootOption5g == "1") {
          if ($('#ssid').val() == rootSSIDShow && $('#ssid5g').val() == rootSSIDShow5g)
            return true;
          else
            return false;
        } else {
          return false;
        }
      }

      $.detectPwd = function () {
        if ($('#whatPwd').val() == "Same") {
          return true;
        } else if ($('#whatPwd').val() == "None" && rootSecurity == '1') {
          return true;
        } else if ($('#whatPwd').val() == "Different") {
			if($('#securityOptions').val() == "WEP" && rootSecurity == "2" && $('#wepAuth').val() == $.convertWEPAuthTypeToText(rootAuthType) && $('#wepEnc').val() == $.convertWEPAuthLength(rootEncrLen)){
            if (rootKeyNum == "1" && $('#wepKeyNo1').is(':checked') == true && $('#key1').val() == rootKey1) {
              return true;
            } else if (rootKeyNum == "2" && $('#wepKeyNo2').is(':checked') == true && $('#key2').val() == rootKey2) {
              return true;
            } else if (rootKeyNum == "3" && $('#wepKeyNo3').is(':checked') == true && $('#key3').val() == rootKey3) {
              return true;
            } else if (rootKeyNum == "4" && $('#wepKeyNo4').is(':checked') == true && $('#key4').val() == rootKey4) {
              return true;
            }
          } else if ($('#securityOptions').val() == "4" && rootSecurity == "4" && $('#pwd').val() == rootPassword) {
            return true;
          } else if ($('#securityOptions').val() == "5" && rootSecurity == "5" && $('#pwd').val() == rootPassword) {
            return true;
          }
          else if($('#securityOptions').val() == "WPA2-PSK" && rootSecurity == "6" && $('#pwd').val() == rootPassword){
            return true;
          }
          else if($('#securityOptions').val() == "WPA/WPA2" && rootSecurity == "7" && $('#pwd').val() == rootPassword){
            return true;
          }
          else if($('#securityOptions').val() == "WPA3" && rootSecurity == "10" && $('#pwd').val() == rootPassword){
            return true;
          }
          else if($('#securityOptions').val() == "WPA2/WPA3" && rootSecurity == "11" && $('#pwd').val() == rootPassword){
            return true;
          }
        } else {
          return false;
        }
      }

      $.detectPwd5g = function () {
        if ($('#whatPwd5g').val() == "Same") {
          return true;
        } else if ($('#whatPwd5g').val() == "None" && rootSecurity5g == '1') {
          return true;
        } else if ($('#whatPwd5g').val() == "Different") {
          if ($('#securityOptions5g').val() == "2" && rootSecurity5g == "2" && $('#wepAuth5g').val() == rootAuthType5g && $('#wepEnc5g').val() == rootEncrLen5g) {
            if (rootKeyNum5g == "1" && $('#wepKeyNo5g1').is(':checked') == true && $('#key5g1').val() == rootKey5g1) {
              return true;
            } else if (rootKeyNum5g == "2" && $('#wepKeyNo5g2').is(':checked') == true && $('#key5g2').val() == rootKey5g2) {
              return true;
            } else if (rootKeyNum5g == "3" && $('#wepKeyNo5g3').is(':checked') == true && $('#key5g3').val() == rootKey5g3) {
              return true;
            } else if (rootKeyNum5g == "4" && $('#wepKeyNo5g4').is(':checked') == true && $('#key5g4').val() == rootKey5g4) {
              return true;
            }
          } else if ($('#securityOptions5g').val() == "4" && rootSecurity5g == "4" && $('#pwd5g').val() == rootPassword5g) {
            return true;
          } else if ($('#securityOptions5g').val() == "5" && rootSecurity5g == "5" && $('#pwd5g').val() == rootPassword5g) {
            return true;
          }
          else if($('#securityOptions5g').val() == "WPA2-PSK" && rootSecurity5g == "6" && $('#pwd5g').val() == rootPassword5g){
            return true;
          }
          else if($('#securityOptions5g').val() == "WPA/WPA2" && rootSecurity5g == "7" && $('#pwd5g').val() == rootPassword5g){
            return true;
          }
          else if($('#securityOptions5g').val() == "WPA3" && rootSecurity5g == "10" && $('#pwd5g').val() == rootPassword5g){
            return true;
          }
          else if($('#securityOptions5g').val() == "WPA2/WPA3" && rootSecurity5g == "11" && $('#pwd5g').val() == rootPassword5g){
            return true;
          }
        } else {
          return false;
        }
      }

      if (ntgr_router != "1") {
        $('.main').change(function () {
          if ($.detectSsid() == true && $.detectPwd() == true && $.detectPwd5g() == true) {
            $('#enableOneWifiName').prop('checked', true);
            oneWifi();
          }
        });

        $('.networkName').keyup(function () {
          if ($.detectSsid() == true && $.detectPwd() == true && $.detectPwd5g() == true) {
            $('#enableOneWifiName').prop('checked', true);
            oneWifi();
          }
        });
      }

      $('#enableOneWifiName').click(function () {
        if ($("#enableOneWifiName").is(":checked") == false) {
          differentWifi();
        } else {
          oneWifi();
          $.enableButton('nextStep', '#selectNetworkForm', 0, true);
        }
      });

      $.showPass();
      $.checkPass();
      setTimeout(function () {
        if (rootSecurity == '2') {
          $('#key4').val(rootKey4);
          $('#pwd').val("");
          $('#verifyPwd').val("");
        } else {
          $('#key4').val("");
          $('#pwd').val(rootPassword);
          $('#verifyPwd').val(rootPassword);
        }
        $('#key4').removeAttr("style");
        if (have_wireless_an == "1") {
          $('#key5g4').removeAttr("style");
        }
      }, $.chromeTimer);
      if (have_wireless_an == "1") {
        $.showPass5g();
        $.checkPass5g();
        setTimeout(function () {
          if (rootSecurity5g == '2') {
            $('#key5g4').val(rootKey5g4);
            $('#pwd5g').val("");
            $('#verifyPwd5g').val("");
          } else {
            $('#key5g4').val("");
            $('#pwd5g').val(rootPassword5g);
            $('#verifyPwd5g').val(rootPassword5g);
          }
        }, $.chromeTimer);
      }
      $('#whatPwd').change(function () {
        if (($('#whatPwd').val() == 'Different' && ($('#securityOptions').val() == 'None' || $('#securityOptions').val() == 0)) || have_wireless_an == "1" && ($('#whatPwd5g').val() == 'Different' && ($('#securityOptions5g').val() == 0 || $('#securityOptions5g').val() == 'None')))
          $('#nextStep').prop('disabled', true);
        else
          $('#nextStep').prop('disabled', false);
      });
      $('#securityOptions').change(function () {
        if (($('#securityOptions').val() == 0 || $('#securityOptions').val() == 'None') || have_wireless_an == "1" && ($('#whatPwd5g').val() == 'Different' && ($('#securityOptions5g').val() == 0 || $('#securityOptions5g').val() == 'None'))) {
          $('#nextStep').prop('disabled', true);
        } else
          $('#nextStep').prop('disabled', false);
      });

      $('#whatPwd5g').change(function () {
        if (($('#whatPwd').val() == 'Different' && ($('#securityOptions').val() == 0 || $('#securityOptions').val() == 'None')) || ($('#whatPwd5g').val() == 'Different' && ($('#securityOptions5g').val() == 0 || $('#securityOptions5g').val() == 'None')))
          $('#nextStep').prop('disabled', true);
        else
          $('#nextStep').prop('disabled', false);
      });
      $('#securityOptions5g').change(function () {
        if (($('#whatPwd').val() == 'Different' && ($('#securityOptions').val() == 0 || $('#securityOptions').val() == 'None')) || ($('#securityOptions5g').val() == 0 || $('#securityOptions5g').val() == 'None'))
          $('#nextStep').prop('disabled', true);
        else
          $('#nextStep').prop('disabled', false);
      });

      $('#nextStep').click(function () {
        $('.errorMsg').remove();
        if (!$.REG_SSID.test($("#ssid").val())) {
          if ($("#ssid").val().length == 0) {
            $.addErrMsgAfter("ssid", ssid_null, false, "error_info_2");
          } else {
            $.addErrMsgAfter("ssid", ssid_invalid, false, "error_info_2");
          }
        } else {
          var testMainSSID = $("#ssid").val();
          if ((guestAPEnable && testMainSSID == guestSSID) || (guestAPEnable5g && testMainSSID == guestSSID5g)) {
            alert(ssid_dup);
            return;
          }
        }
        $.checkSecurity('securityOptions', 'wepEnc', 'pwd');
        $('#client2GHzSSID').val($.do_xss_ssid($('#ssid').val()));
        if ($("#enableOneWifiName").is(":checked") == true || ($.detectSsid() == true && $.detectPwd() == true && $.detectPwd5g() == true))
          $('#enableExt').val("0");
        else
          $('#enableExt').val("1");

		if (enable_wifi6 == "0") {
			$('#clientMode').val('17');
			if (axmodel == "AX3000" || axmodel == "AX2400")
		 	{
				$('#clientMode5g').val('19');
		 	}
			else
			{
				$('#clientMode5g').val('19');
			}
		} else {
			$('#clientMode').val('8');
			if (axmodel == "AX3000")
			{
				$('#clientMode5g').val('20');
			}
			else if (axmodel == "AX2400")
			{
				$('#clientMode5g').val('21');
			}
			else
			{
				$('#clientMode5g').val('10');
			}
		}

        if ($('#whatPwd').val() == 'None') {
	      $('#client2GHzSameSec').val('0');
          $('#client2GHzSecurity').val('1');
        } else if ($('#whatPwd').val() == 'Different') {
          $('#client2GHzSameSec').val('0');
	  if($('#securityOptions').val() == 'WEP') {
            $('#client2GHzSecurity').val('2');
	    if($('#wepAuth').val() == 'Shared Key')
              $('#client2GHzAuthType').val('1');
            else
              $('#client2GHzAuthType').val('2');
	    if($('#wepEnc').val() == '64')
              $('#client2GHzEncrLen').val('5');
            else
              $('#client2GHzEncrLen').val('13');
            $('#client2GHzKeyNum').val($('input:radio[name="wep_key_no"]:checked').val());
            $('#client2GHzKey1').val($('#key1').val());
            $('#client2GHzKey2').val($('#key2').val());
            $('#client2GHzKey3').val($('#key3').val());
            $('#client2GHzKey4').val($('#key4').val());
            continue_obj4.html($.xss_ssid_format($('#key' + $('#client2GHzKeyNum').val()).val()));
          } else {
            if ($('#verifyPwd').val() != $('#pwd').val() && $('#pwd').val().length >= $.MIN_PWD_CHARACTERS) {
              $('#verifyPwd').addClass('alert');
              $.addErrMsgAfter('verifyPwd', error_not_same_pwd, false, 'errPwdSame');
            }
            if (have_wireless_an == "1" && $('#verifyPwd5g').val() != $('#pwd5g').val() && $('#pwd5g').val().length >= $.MIN_PWD_CHARACTERS) {
              $('#verifyPwd5g').addClass('alert');
              $.addErrMsgAfter('verifyPwd5g', error_not_same_pwd, false, 'errPwdSame');
            }
            if($('#securityOptions').val() == 'WPA2-PSK')
              $('#client2GHzSecurity').val('6');
            else if($('#securityOptions').val() == 'WPA/WPA2')
              $('#client2GHzSecurity').val('7');
            else if($('#securityOptions').val() == 'WPA3')
              $('#client2GHzSecurity').val('10');
            else if($('#securityOptions').val() == 'WPA2/WPA3')
              $('#client2GHzSecurity').val('11');
            else
              $('#client2GHzSecurity').val('7');
            $('#client2GHzPassword').val($.do_xss_pass($('#pwd').val()));
            continue_obj4.html($.xss_ssid_format($('#pwd').val()));
          }
        } else {
          $('#client2GHzSameSec').val('1');
          $('#client2GHzSecurity').val(rootSecurity);
          if (rootSecurity == "2") {
            $('#client2GHzAuthType').val(rootAuthType);
            $('#client2GHzEncrLen').val(rootEncrLen);
            $('#client2GHzKeyNum').val(rootKeyNum);
            $('#client2GHzKey1').val(rootKey1);
            $('#client2GHzKey2').val(rootKey2);
            $('#client2GHzKey3').val(rootKey3);
            $('#client2GHzKey4').val(rootKey4);
          } else {
            $('#client2GHzPassword').val($.do_xss_pass(rootPassword));
          }
          continue_obj4.html($.xss_ssid_format($.showPassKey(rootSecurity, rootKeyNum, "root")));
        }
        if (have_wireless_an == "1") {
          if (!$.REG_SSID.test($('#ssid5g').val())) {
            if ($('#ssid5g').val().length == 0) {
              $.addErrMsgAfter('ssid5g', ssid_null, false, 'error_info_5');
            } else {
              $.addErrMsgAfter('ssid5g', ssid_invalid, false, 'error_info_5');
            }
          } else {
            var testMainSSID = $('#ssid5g').val();
            if ((guestAPEnable && testMainSSID == guestSSID) || (guestAPEnable5g && testMainSSID == guestSSID5g)) {
              alert(ssid_dup);
              return;
            }
          }
          $.checkSecurity5g('securityOptions5g', 'wepEnc5g', 'pwd5g');
          $('#client5GHzSSID').val($.do_xss_ssid($('#ssid5g').val()));
          $('#wifiChannel5g').val(rootChannel5g);
          if ($('#whatPwd5g').val() == 'None') {
            $('#client5GHzSameSec').val('2');
            $('#client5GHzSecurity').val('1');
          } else if ($('#whatPwd5g').val() == 'Different') {
            $('#client5GHzSameSec').val('0');
	    if($('#securityOptions5g').val() == 'WEP') {
              $('#client5GHzSecurity').val('2');
	      if($('#wepAuth5g').val() == 'Shared Key')
                $('#client5GHzAuthType').val('1');
              else
                $('#client5GHzAuthType').val('2');
	      if($('#wepEnc5g').val() == '64')
                $('#client5GHzEncrLen').val('5');
              else
                $('#client5GHzEncrLen').val('13');
              $('#client5GHzKeyNum').val($('input:radio[name="wep_key_no_5g"]:checked').val());
              $('#client5GHzKey1').val($('#key5g1').val());
              $('#client5GHzKey2').val($('#key5g2').val());
              $('#client5GHzKey3').val($('#key5g3').val());
              $('#client5GHzKey4').val($('#key5g4').val());
              $('.column.second ul strong:last', '#continue').html($.xss_ssid_format($('#key5g' + $('#client5GHzKeyNum').val()).val()));
            } else {
              if ($('#verifyPwd5g').val() != $('#pwd5g').val() && $('#pwd5g').val().length >= $.MIN_PWD_CHARACTERS) {
                $('#verifyPwd5g').addClass('alert');
                $.addErrMsgAfter('verifyPwd5g', error_not_same_pwd, false, 'errPwdSame');
              }
              if($('#securityOptions5g').val() == 'WPA2-PSK')
                $('#client5GHzSecurity').val('6');
              else if($('#securityOptions5g').val() == 'WPA/WPA2')
                $('#client5GHzSecurity').val('7');
              else if($('#securityOptions5g').val() == 'WPA3')
                $('#client5GHzSecurity').val('10');
              else if($('#securityOptions5g').val() == 'WPA2/WPA3')
                $('#client5GHzSecurity').val('11');
              else
                $('#client5GHzSecurity').val('7');
              $('#client5GHzPassword').val($.do_xss_pass($('#pwd5g').val()));
              $('.column.second ul strong:last', '#continue').html($.xss_ssid_format($('#pwd5g').val()));
            }
          } else {
            $('#client5GHzSameSec').val('1');
            $('#client5GHzSecurity').val(rootSecurity5g);
            if (rootSecurity5g == "2") {
              $('#client5GHzAuthType').val(rootAuthType5g);
              $('#client5GHzEncrLen').val(rootEncrLen5g);
              $('#client5GHzKeyNum').val(rootKeyNum5g);
              $('#client5GHzKey1').val(rootKey5g1);
              $('#client5GHzKey2').val(rootKey5g2);
              $('#client5GHzKey3').val(rootKey5g3);
              $('#client5GHzKey4').val(rootKey5g4);
            } else {
              $('#client5GHzPassword').val($.do_xss_pass(rootPassword5g));
            }
            $('.column.second ul strong:last', '#continue').html($.xss_ssid_format($.showPassKey5g(rootSecurity5g, rootKeyNum5g, "root")));
          }
        }

        if ($.detectAp() == true) {
          $('#smartConnect').val("1");
        } else {
          $('#smartConnect').val("0");
        }
        if (!$('.errorMsg').length) {
          $.submit_wait('body', $.APPLYING_DIV);
          $.postForm('#networkSettingsForm', '', function (json) {
            if (json.status == '1') {
              var time = parseInt(json.wait) * 1000;
              setTimeout(function () {
                var dm = top.location.origin;
                if (/mywifiext.com/.test(dm)) {
                  dm = top.location.protocol + "//mywifiext.net";
                } else if (/mywifiext.net/.test(dm)) {
                  dm = top.location.protocol + "//mywifiext.com";
                } else if ("mywifiext" == top.location.hostname) {
                  dm = top.location.protocol + "//mywifiext";
                } else {
                  dm = top.location.protocol + "//mywifiext.com";
                }

                $.ajax({
                  url:dm + "/js/get_extender_status.js",
                  type: "GET",
                  dataType: "jsonp",
                  jsonp:'callback',
                  jsonpCallback: "$.showHostIp",
                  data: {
                    ts: Date.now(),
                    token: csrfToken
                  },
                  error: function () {
                    console.log("httphost " + httphost)
                    $.showHostIp({hostIp: httphost});
                  }
                });
                $("#hostIP").text($("#hostIP").text().replace(/\(extender ip\)/g, httphost));
                $('#networkSettingsDiv').hide();
                $('.running').remove();
                $('.secondary', '#fixedFooter').hide();
                $('#nextStep', '#fixedFooter').hide();
                $('#continueBt', '#fixedFooter').show();
                $('#continueBt').click(function () {
                  if ($("#enableOneWifiName").is(":checked") == true) {
                    $.change_domain2(json.url, httphost);
                  } else {
                    $.change_domain(json.url, httphost);
                  }
                });
                $('#continue').show();
              }, time);
            } else {
              $.alertBox(json.msg);
            }
          });

          continue_obj1.html($.xss_ssid_format($('#ssid').val()));
          continue_obj2.html($.formatSecType2($('#client2GHzSecurity').val()));
          if ($('#client2GHzSecurity').val() == "1")
            continue_obj3.hide();
          if (have_wireless_an == "1") {
            $('.column.second ul strong:first', '#continue').html($.xss_ssid_format($('#ssid5g').val()));
            $('.column.second ul strong:eq(1)', '#continue').html($.formatSecType2($('#client5GHzSecurity').val()));
            if ($('#client5GHzSecurity').val() == "1")
              $('.column.second ul li:last', '#continue').hide();
          }
        }
      });

      if (support_seamless_roaming == "1" && ntgr_router == "1") {
        $('#networkSettingsDiv').hide();
        $('#nextStep').trigger('click');
      }

      $.showHostIp = function(data) {
        var reg = new RegExp(httphost, 'g')
        $("#hostIP").text($("#hostIP").text().replace(reg, data.hostIp || httphost));
        if (data.hostIp) {
          httphost = data.hostIp;
        }
      }
    }

		/*******************************************************************************************
		 * 
		 * Setup Success page
		 *
		 *******************************************************************************************/

    $.displayLinkStatus = function () {
			/* 
			 * 0: disabled 
			 * 1: green 
			 * 2: amber 
			 * 3: red 
			 * 4: not connected 
			 */

      var client_link_status_2g_tmp = client_link_status_2g;
      var client_link_status_5g_tmp = client_link_status_5g;

      if (rootap_link_status_2g == "0")
        rootap_2g_on = 0; // interface with 2g root ap is off

      if (rootap_link_status_5g == "0")
        rootap_5g_on = 0; // interface with 5g root ap is off

      if (client_link_status_2g == "0")
        client_2g_on = 0; //fastlane mode or 2g ap radio is off
      else
        $("#networkStatus_2g").css('display', 'block');

      if (client_link_status_5g == "0")
        client_5g_on = 0; //fastlane mode or 5g ap radio is off
      else
        $("#networkStatus_5g").css('display', 'block');

      if (access_point_mode != "0") {
				/*
				if (rootap_link_status_2g != "0" || rootap_link_status_5g != "0") {
					if (rootap_link_status_2g == "0")
					{
						rootap_link_status_2g = rootap_link_status_5g;
						client_link_status_2g = rootap_link_status_5g;
						client_link_status_5g = rootap_link_status_5g;
					}
					else if (rootap_link_status_5g == "0"){
						rootap_link_status_5g = rootap_link_status_2g;
						client_link_status_2g = rootap_link_status_2g;
						client_link_status_5g = rootap_link_status_2g;
					}else{
						client_link_status_2g = rootap_link_status_2g;
						client_link_status_5g = rootap_link_status_5g;
					}
				}
				
				if(fastlane_type == "1"){
					if(furfing_mode_type == "2.4G"){
						client_link_status_2g = rootap_link_status_2g;
						client_link_status_5g = rootap_link_status_2g;
					}
					else{
						client_link_status_5g = rootap_link_status_5g;
                                                client_link_status_2g = rootap_link_status_5g;
					}
				}
				*/
        //	client_link_status_2g = rootap_link_status_2g;
        //	client_link_status_5g = rootap_link_status_5g;

        if (rootap_link_status_2g == "3") {
          $("#cc_blackshade").addClass('smallMarkImage');
          $("#cc_blackshade").addClass('blackShade');

          $("#cc_icon1").addClass('smallMarkImage');
          $("#cc_icon1").addClass('whiteCircleTop');
          $("#cc_icon2").addClass('smallMarkImage');
          if (rootap_2g_on == 1)
            $("#cc_icon2").addClass('linkRate24g_top');
          else
            $("#cc_icon2").addClass('linkRate5g_right'); //to be improved

          $("#cc_text1").addClass('letters_green_topLine');
          $("#cc_text1").html(best_connection);

          if (rootap_2g_on == 1 && rootap_5g_on == 1) {
            $("#cc_icon3").addClass('smallMarkImage');
            $("#cc_icon3").addClass('whiteCircleBottom');
            $("#cc_icon4").addClass('smallMarkImage');
            $("#cc_icon4").addClass('linkRate5g_bottom');
            if (rootap_link_status_5g == "3") {
              $("#cc_text2").addClass('letters_green_bottomLine');
              $("#cc_text2").html(best_connection);
            }
            else if (rootap_link_status_5g == "2") {
              $("#cc_text2").addClass('letters_bottomLine');
              $("#cc_text2").html(good_connection);
            }
            else {
              $("#cc_text2").addClass('letters_bottomLine');
              $("#cc_text2").html(poor_connection);
            }
          }
        } else if (rootap_link_status_2g == "2" || rootap_link_status_2g == "1") {
          $("#cc_blackshade").addClass('smallMarkImage');
          $("#cc_blackshade").addClass('blackShade');

          $("#cc_icon1").addClass('smallMarkImage');
          $("#cc_icon1").addClass('whiteCircleTop');
          $("#cc_icon2").addClass('smallMarkImage');
          $("#cc_icon2").addClass('linkRate24g_top');
          $("#cc_text1").addClass('letters_topLine');
          if (rootap_link_status_2g == "2")
            $("#cc_text1").html(good_connection);
          else
            $("#cc_text1").html(poor_connection);
          if (rootap_2g_on == 1 && rootap_5g_on == 1) {
            $("#cc_icon3").addClass('smallMarkImage');
            $("#cc_icon3").addClass('whiteCircleBottom');
            $("#cc_icon4").addClass('smallMarkImage');
            $("#cc_icon4").addClass('linkRate5g_bottom');
            if (rootap_link_status_5g == "3") {
              $("#cc_text2").addClass('letters_green_bottomLine');
              $("#cc_text2").html(best_connection);
            }
            else if (rootap_link_status_5g == "2") {
              $("#cc_text2").addClass('letters_bottomLine');
              $("#cc_text2").html(good_connection);
            }
            else {
              $("#cc_text2").addClass('letters_bottomLine');
              $("#cc_text2").html(poor_connection);
            }
          }
        } else {
          $("#cc_blackshade").addClass('smallMarkImage');
          $("#cc_blackshade").addClass('blackShade');
          $("#cc_icon1").addClass('smallMarkImage');
          $("#cc_icon1").addClass('whiteCircleTop');
          $("#cc_icon2").addClass('smallMarkImage');
          $("#cc_icon2").addClass('linkRate5g_right');
          $("#cc_text1").addClass('letters_green_topLine');
          if (rootap_link_status_5g == "3")
            $("#cc_text1").html(best_connection);
          else {
            $("#cc_text2").addClass('letters_bottomLine');
            $("#cc_text2").html(move_to_extender);
            if (rootap_link_status_5g == "2")
              $("#cc_text1").html(good_connection);
            else
              $("#cc_text1").html(poor_connection);
          }
        }
        if (host_name != 'EX6200v2') {
          $("#cc_icon2").removeClass('linkRate24g_top').removeClass('linkRate5g_right');
          $("#cc_text1").removeClass();
          if (rootap_link_status_2g == '3' || rootap_link_status_5g == '3') {
            $("#cc_icon2").addClass('green_routerSideImage');
            $("#cc_text1").addClass('letters_green_topLine');
            $("#cc_text1").html(best_connection);
          } else if (rootap_link_status_2g == '2' || rootap_link_status_5g == '2') {
            $("#cc_icon2").addClass('amber_routerSideImage');
            $("#cc_text1").addClass('letters_topLine');
            $("#cc_text1").html(good_connection);
          } else {
            $("#cc_icon2").addClass('red_routerSideImage');
            $("#cc_text1").addClass('letters_topLine');
            $("#cc_text1").html(poor_connection);
          }

          $("#cc_icon3").removeClass();
          $("#cc_icon3").addClass('smallMarkImage');
          $("#cc_icon3").addClass('whiteCircleBottom');

          $("#cc_icon4").removeClass();
          $("#cc_icon4").addClass('smallMarkImage');
          $("#cc_text2").removeClass();
          $("#cc_text2").html("");
          if (client_link_status_2g_tmp == '3' || client_link_status_5g_tmp == '3') {
            $("#cc_icon4").addClass('green_deviceSideImage');
            $("#cc_text2").addClass('letters_green_bottomLine');
            $("#cc_text2").html(best_connection);
          } else if (client_link_status_2g_tmp == '2' || client_link_status_5g_tmp == '2') {
            $("#cc_icon4").addClass('amber_deviceSideImage');
            $("#cc_text2").addClass('letters_bottomLine');
            $("#cc_text2").html(good_connection);
          } else if (client_link_status_2g_tmp == '1' || client_link_status_5g_tmp == '1') {
            $("#cc_icon4").addClass('red_deviceSideImage');
            $("#cc_text2").addClass('letters_bottomLine');
            $("#cc_text2").html(poor_connection);
          } else {
            $("#cc_icon3").removeClass();
            $("#cc_icon4").removeClass();
          }
        }
      }

      if (access_point_mode == "0") {
        client_link_status_2g = rootap_link_status_2g;
        client_link_status_5g = rootap_link_status_5g;
      }

      if (access_point_mode != "0") { //repeater mode
        if (rootap_link_status_2g == "1" || rootap_link_status_5g == "1"
          || rootap_link_status_2g == "2" || rootap_link_status_5g == "2"
          || rootap_link_status_2g == "3" || rootap_link_status_5g == "3") {
          $("#title_string").html("Your extender has successfully connected to your existing WiFi network");
        } else {
          $("#title_string").append("You have created an access point but we did not detect an Internet connection.");
        }
      } else { //access point
        if (client_link_status_2g == "1" || client_link_status_5g == "1"
          || client_link_status_2g == "2" || client_link_status_5g == "2"
          || client_link_status_2g == "3" || client_link_status_5g == "3") {
          $("#title_string").html("You have successfully created an access point.");
        } else {
          $("#title_string").html("You have created an access point but we did not detect an Internet connection.");
        }
      }

    // sta band 2.4G link status
	$("#ccLocation1").addClass('confirmation');
	$("#ccLocation1").addClass('location12');

	if (confMode == "2" && fastlane_type == "1" && furfing_mode_type == "2.4G" ){
		$("#ccLocation1").addClass('best1');
		$("#ccLocation4").addClass('best4');
	}else{
			$("#ccLocation1").addClass('best1');
	}

	// sta band 5G link status
	$("#ccLocation4").addClass('confirmation');
	$("#ccLocation4").addClass('location34');
	if (confMode == "2" && fastlane_type == "1" && furfing_mode_type == "5G" ){
		$("#ccLocation1").addClass('best1');
		$("#ccLocation4").addClass('best4');
	} else {
			$("#ccLocation4").addClass('best4');
	}

	// ap band 2.4G link status
	$("#ccLocation2").addClass('confirmation');
	$("#ccLocation2").addClass('location12');
	if (confMode == "2" && fastlane_type == "1" && furfing_mode_type == "2.4G" ){
		$("#ccLocation2").addClass('best2');
		$("#ccLocation3").addClass('best3');
	}else {
			$("#ccLocation2").addClass('best2');
	}

	// ap band 2.4G link status
	$("#ccLocation3").addClass('confirmation');
	$("#ccLocation3").addClass('location34');
	if (confMode == "2" && fastlane_type == "1" && furfing_mode_type == "5G" ){
		$("#ccLocation2").addClass('best2');
		$("#ccLocation3").addClass('best3');
	} else {
			$("#ccLocation3").addClass('best3');
    };
};

    if ($('#successForm').length) {
      var ul_obj;
      if (have_wireless_an == "1") {
        $.displayLinkStatus();
        ul_obj = $('.first ul');
      } else {
        ul_obj = $('ul');
      }

      ul_obj.find('strong:first').html(clientSSID.replace(/ /g, '&nbsp;'));
      ul_obj.find('strong:eq(1)').html($.formatSecType2(clientSecType));
      if (clientSecType == "1")
        ul_obj.find('li:last').hide();
      else
        ul_obj.find('strong:last').html($.xss_ssid_format($.showPassKey(clientSecType, clientKeyNum, "client")));
      if (have_wireless_an == "1") {
        $('.second ul strong:first').html(client5gSSID.replace(/ /g, '&nbsp;'));
        $('.second ul strong:eq(1)').html($.formatSecType2(client5gSecType));
        if (client5gSecType == "1")
          $('.second ul li:last').hide();
        else
          $('.second ul strong:last').html($.xss_ssid_format($.showPassKey(client5gSecType, client5gKeyNum, "client5g")));

        if (confMode == "2") {
          if (fastlane_type == "1" && furfing_mode_type == "2.4G") {
            $('.first.networkStatus_2g').hide();
          }
          if (fastlane_type == "1" && furfing_mode_type == "5G") {
            $('.second.networkStatus_5g').hide();
          }
        }
      }
      $.getData2('ping_result.html', function (json) {
        ping_result = json.ping_result;
      });
      if (have_wireless_an == "0" && $('.extender.gray', '#successForm').length
        || have_wireless_an == "1" && (wl_conf_mode == "2" && ((rootOption == "1" && root5gOption == "0" && (link_status == "0" || link_status == "")) || (rootOption == "0" && root5gOption == "1" && (link_status_5g == "0" || link_status_5g == "")) || (rootOption == "1" && root5gOption == "1" && (link_status == "0" || link_status == "" || link_status_5g == "0" || link_status_5g == ""))))) {
        $('a.btn.primary').html(retry_mark);
        $('a.btn.primary').attr('href', 'ca_extender_continue.htm' + $.ID_2);
      } else if (have_wireless_an == "0" && $('.accesspoint.gray', '#successForm').length
        || have_wireless_an == "1" && (wl_conf_mode == "0" && (ip_status == "0" || ip_status == ""))) {
        $('a.btn.primary').html(retry_mark);
        $('a.btn.primary').attr('href', 'ca_access_checking.htm' + $.ID_2);
      } else {
        $('a.btn.primary').click(function () {
          $.submit_wait('body', $.WAITING_DIV);
          $('input[name=submit_flag]', '#successForm').val("finish");
          $.postForm('#successForm', '', function (json) {
            if (have_reg == "1" || serialNumber == "N/A")
              location.href = "/status.htm" + $.ID_2;
            else {
              if (register_flag != "1" && ping_result == "1")
                location.href = 'http://www.netgear.com/success/' + moduleName + '.aspx?sn=' + serialNumber + '';
              else
                location.href = "/status.htm" + $.ID_2;
            }
          });
        });
      }

      if ($('.title.accesspoint', '#successForm').length) {
        $('a.btn.secondary').attr('href', 'ca_access_connect.htm' + $.ID_2);
      } else if ($('.title.extender', '#successForm').length) {
        $('a.btn.secondary').attr('href', 'ca_welcome.htm' + $.ID_2);
      }
    }

		/*******************************************************************************************
                *
                *    support own style of checkbox.
                *
                *******************************************************************************************/
    $('body').find(':checkbox').each(function () {
      if ($(this).is(':checked')) {
        $(this).addClass('checked');
      } else {
        $(this).removeClass('checked');
      }
    });

  }); // end ready function

}(jQuery));
