/**
 * For web service management page
 */
(function ($) {

	"use strict";

	$(function () {
		if ($('.serviceManagementClass').length) {

			$("#cancelBt").on('click', function () {
				location.href = 'serviceManagement.htm';
			});

			$("#saveBt").on('click', function () {
				if ($('#https_redirect_check').is(':checked')) {
					$('#https_redirect').val("1");
				} else {
					$('#https_redirect').val("0");
				}
				$.submitApply();
				return true;
			});
		}

		$.submitApply = function () {
			$.submit_wait('.main:first', $.PAGE_WAITING_DIV);
			$('input[name=submit_flag]', '#serviceManagementForm').val("service_management");
			$('input[name=https_redirect]', '#serviceManagementForm').val($('#https_redirect').val());
			$.postForm('#serviceManagementForm', '', function (json) {
				if ( json.status == '1' ) {
					setTimeout("document.location.reload();", parseInt(json.wait, 10) * 1000 );
				} else {
					$('.running').remove();
					$.alertBox(json.msg, '', function(){document.location.reload();});
				}
			});
		}
	});

}(jQuery));
