/**
 * For Access Schedule page
 */
(function ($) {

	"use strict";

	
	$(function () {
		$.MAX_RULE = 21;

        if ($('.datePicker').length) {
            Date.format = 'mm/dd/yyyy';
            $('.datePicker').datePicker({
                startDate: '01/01/1970',
                endDate: new Date(),
                clickInput:true,
                createButton:false
            });
            $('.datePicker').dpSetOffset(25, 0);
        }

        var timeZoneMap = {
            '-12': 'GMT+12',
            '-11': 'GMT+11',
            '-10': 'GMT+10',
            '-9': 'GMT+9',
            '-8': 'GMT+8',
            '-7 Arizona': 'GMT+7',
            '-7 Mountain': 'GMT+7',
            '-6 Central': 'GMT+6',
            '-6 Guadalajara': 'GMT+6',
            '-5 Bogota': 'GMT+5',
            '-5 Eastern': 'GMT+5',
            '-5 Indiana': 'GMT+5',
            '-4': 'GMT+4',
            '-3.5': 'GMT+3:30',
            '-3': 'GMT+3',
            '-2': 'GMT+2',
            '-1': 'GMT+1',
            '0 Casablanca': 'GMT-0',
            '0 Greenwich': 'GMT-0',
            '1 Amsterdam': 'GMT-1',
            '1 Belgrade': 'GMT-1',
            '1 Brussels': 'GMT-1',
            '1 Sarajevo': 'GMT-1',
            '2 Athens': 'GMT-2',
            '2 Bucharest': 'GMT-2',
            '2 Helsinki': 'GMT-2',
            '3': 'GMT-3',
            '4 Moscow': 'GMT-4',
            '4 Abu': 'GMT-4',
            '5': 'GMT-5',
            '5.5': 'GMT-5:30',
            '6': 'GMT-6',
            '7': 'GMT-7',
            '8 Beijing': 'GMT-8',
            '8 Ulaan': 'GMT-8',
            '9': 'GMT-9',
            '9.5': 'GMT-9',
            '10 Brisbane': 'GMT-10',
            '10 Yakutsk': 'GMT-10',
            '10 Guam': 'GMT-10',
            '11 Vladivostok': 'GMT-11',
            '11 Magadan': 'GMT-11',
            '12 Fiji': 'GMT-12',
            '12 Kamchatka': 'GMT-12',
            '13': 'GMT-13',
        };

        var findTimeZoneValue = function(GMTValue) {
            for(var key in timeZoneMap) {
                if (timeZoneMap[key] == GMTValue) {
                    return key;
                }
            }
        }

		if ($('.timePicker').length) {
			if ( is_europe_region == '1' ) {
				$('.timePicker').timepicker({
					disableTouchKeyboard: true,
					disableTextInput: true,
					timeFormat: 'H:i',
					minTime: '00:00',
					maxTime: '23:59',
					step: 1
				});
			} else {
				$('.timePicker').timepicker({
					disableTouchKeyboard: true,
					disableTextInput: true,
					timeFormat: 'h:ia',
					step: 1,
					lang: { am: am_mark, pm: pm_mark }
				});
			}
                }
		function show_schedules() {
			if ( wireless_schedule_num >= $.MAX_RULE ){
				$('#addBt').prop('disabled', true).css({'background-color':'#ebebe4'});
			} else {
				$('#addBt').prop('disabled', false).css({'background-color':''});
			}
			$('.scheduleList').find('tbody').empty();
			var i;
			for ( i = 0; i < wireless_schedule_num; i++ ) {
				var item = eval("wireless_schedule_array["+i+"]"),
				array = item.split('-');
				var row = "<tr>";
				row += "<td><span class='tdLabel'>"+from_mark+"</span>"+get_time(array[0])+"</td>";
				row += "<td><span class='tdLabel'>"+to_mark+"</span>"+get_time(array[1])+"</td>";
				row += "<td><span class='tdLabel'>"+days+"</span>"+get_days(array[2])+"</td>";
				row += "<td class='editAction'><span class='tdLabel'>"+del_mark;
				row += "</span><a class='cancelDevice'><i class='dnintg-cancel' id='del"+(i+1)+"'></i></a></td>";
				row += "</tr>";
				$('.scheduleList').find('tbody').append(row);
				$('#del'+(i+1)).click(function() {
					$('input[name=submit_flag]','#accessScheduleForm').val('del_schedule');
					var num = $(this).attr('id').split("del")[1];
					$('#delItem').val(num);
					$.submit_wait('.main:first', $.PAGE_WAITING_DIV);
					$.postForm('#accessScheduleForm', '', function(json){
						if ( json.status == '1' ) {
							$.refresh_schedules();
						} else {
							$('.running').remove();
							$.alertBox(json.msg, '', $.refresh_schedules);
						}
					});
				});
			}
			if ( wireless_schedule_num > 10 ) {
				$('#schListDiv').addClass('limitSchHeight');
			} else {
				$('#schListDiv').removeClass('limitSchHeight');
			}
		};

		function get_time(str) {
			var num = parseInt(str, 10);
			if ( num < 0 || isNaN(num) )
				num = 0;
			if ( num > 47 )
				return is_europe_region == '1' ? "23:59" : "11:59"+pm_mark;
			return timeListOptions[num].text;
		}
		function get_days(str) {
			var hash = {};
			var array = str.split(","),
			i = 0,
			num = 0,
			list = [];
			for ( i = 0; i < array.length; i++ ) {
				if( array[i] == "Daily" ) {
					return everyday;
				}
				num = parseInt(array[i]);
				if( array[i].length == 1 && num >= 0 && num <= 6 ) {
					hash[array[i]] = true;
				}
			}
			for(var h in hash ) {
				list.push(selectdays[h]);
			}
			return list.length == 7 ? everyday : (list.join(", ") || '--');
		}

		if ($('#accessScheduleAlertForm').length) {
                        $('#alertBt').click(function() {
                                $.submit_wait('body', $.WAITING_DIV);
                                $.postForm('#accessScheduleAlertForm', '', function(json) {
                                        if ( json.status == '1' ) {
						location.href = json.url+$.ID_2;
                                        } else {
                                                $('.running').remove();
                                                $.alertBox(json.msg);
                                        }
                                });
                        });
                }

		if ($('.accessSchedule').length) {

			var selectDays     = $('.selectDays'),
			allDays        = selectDays.find('li'),
			weekDays       = selectDays.find('.weekday'),
			weekEnd        = selectDays.find('.weekend'),
			selectTimes    = $('.timeSelection'),
			scheduledTimes = $('#scheduledTimes'),
			timesPerDay    = $('.timesPerDay'),
			timeListOptions = document.getElementById("allFromTime").options,
			wireless_schedule_num = 0,
			wireless_schedule_array = [],
			syncTime       = 0;

			$('.timeList').each(function(i, ele) {
//				$('<option value="-1"> </option>').appendTo($(ele));
				var j, hour, minutes, time;
				time = (is_europe_region == '1') ? 0 * 3600 : 12 * 3600;
				for(j=0; j < 48; j++ )
				{
					if (is_europe_region == '1') {
						hour = parseInt(time / 3600) < 10 ? '0' + parseInt(time / 3600) : parseInt(time / 3600);
						minutes = (time % 3600)/ 60 < 10 ? '0'+ (time % 3600)/60 : (time % 3600)/60;
						$('<option value='+j+'>'+hour+':'+minutes+'</option>').appendTo($(ele));
						time += 30 * 60;
					} else {
						hour = parseInt(time / 3600) < 10 ? '0' + parseInt(time / 3600) : parseInt(time / 3600);
						minutes = (time % 3600)/ 60 < 10 ? '0'+ (time % 3600)/60 : (time % 3600)/60;
						if ( j < 24 )
							$('<option value='+j+'>'+hour+':'+minutes+am_mark+'</option>').appendTo($(ele));
						else
							$('<option value='+j+'>'+hour+':'+minutes+pm_mark+'</option>').appendTo($(ele));
						time += 30 * 60;
						if ( time >= 13 * 3600)
							time -= 12 * 3600;
					}
				}
			});

			// show/hide the access schedule settings
			$("input[name='onoff']").on('change', function () {
				if ( $('#asOn').is(':checked') ) {
					$('#scheduleWrap').slideDown();
					if ( $('#allDays').is(':checked') ){
						$('#allDays').parents('li').find('select').prop('disabled', true);
						$('#allDays').parents('li').find('select').css({'background-color':'#ebebe4'});
					}
				} else {
					$('#scheduleWrap').slideUp();
				}

			});
			$("input[name='onoff']").trigger('change');

			//select Extender Clock type
			$("input[name='sys_clock']").on('change', function () {
				if ( $('#autoClock').is(':checked') ) {
					$('.clockManual').hide();
					$('.clockAuto').show();
					$.enableButton('saveBt','#accessScheduleForm', 0, true);
				} else {
					$('.clockAuto').hide();
					$('.clockManual').show();
					if ( $('#synchDate').val() == "" 
						|| (!/^((0[1-9])|(1[0-2])):([0-5][0-9])(a|p)m$/.test($('#synchTime').val()) && is_europe_region == '0') 
						|| (!/^(([0-1][0-9])|(2[0-3])):([0-5][0-9])$/.test($('#synchTime').val()) && is_europe_region == '1'))
						$.enableButton('saveBt','#accessScheduleForm', 0, false);
					else
						$.enableButton('saveBt','#accessScheduleForm', 0, true);
				}
			});
			$('#autoClock').trigger('change');

			$.same_time_show = function(flag) {
				if ( flag ) {
					selectDays.find('.alldays').show();
					selectDays.find('.alldays').find('.timeSelection').find('input').prop('disabled', false);
					selectDays.find('.alldays').find('.timeSelection').find('input').trigger('change');
					selectDays.find('.alldays').find('select').prop('disabled', false);
				} else {
					selectDays.find('.alldays').hide();
					selectDays.find('.alldays').find('.timeSelection').find('input').prop('disabled', true);
					selectDays.find('.alldays').find('select').prop('disabled', true);
				}
			};
			$.weekday_time_show = function(flag) {
				if ( flag ) {
					weekDays.find('.timeSelection').css('visibility', 'visible');
					weekDays.find('.timeSelection').find('input').prop('disabled', false);
					weekDays.find('input').trigger('change');
					weekDays.find('select').prop('disabled', false);
				} else {
					weekDays.find('.timeSelection').css('visibility', 'hidden');
					weekDays.find('.timeSelection').find('input').prop('disabled', true);
					weekDays.find('select').prop('disabled', true);
				}
			};
			$.weekend_time_show = function(flag) {
				if ( flag ) {
					weekEnd.find('.timeSelection').css('visibility', 'visible');
					weekEnd.find('.timeSelection').find('input').prop('disabled', false);
					weekEnd.find('input').trigger('change');
					weekEnd.find('select').prop('disabled', false);
				} else {
					weekEnd.find('.timeSelection').css('visibility', 'hidden');
					weekEnd.find('.timeSelection').find('input').prop('disabled', true);
					weekEnd.find('select').prop('disabled', true);
				}
			};
			// days selections
			$('#scheduledDays').on('change', function () {
			var selectIndex = $(this).val();

			$('.errorMsg').remove();
			switch (selectIndex) {

				case '0':
					// reset and disable days select
					scheduledTimes.prop('selectedIndex', 0);
					scheduledTimes.prop('disabled', true);
					scheduledTimes.css({'background-color':'#ebebe4'});
					// reset all elements and hide the days checkboxes
					weekDays.hide();
					$.weekday_time_show(false);
					weekEnd.hide();
					$.weekend_time_show(false);
					$.same_time_show(true);
					break;

				case '1':
					scheduledTimes.prop('disabled', false);
					scheduledTimes.css({'background-color':''});
					allDays.show();
					if (scheduledTimes.val() === '1') {
						$.same_time_show(false);
						$.weekday_time_show(true);
						$.weekend_time_show(true);
					} else {
						$.same_time_show(true);
						$.weekday_time_show(false);
						$.weekend_time_show(false);
					}
					break;

				case '2':
					// enable the days select
					scheduledTimes.prop('disabled', false);
					scheduledTimes.css({'background-color':''});
					weekDays.show();
					weekEnd.hide();
					$.weekend_time_show(false);
					if (scheduledTimes.val() === '1') {
						$.same_time_show(false);
						$.weekday_time_show(true);
					} else {
						$.same_time_show(true);
						$.weekday_time_show(false);
					}
					break;

				case '3':
					// enable the days select
					scheduledTimes.prop('disabled', false);
					scheduledTimes.css({'background-color':''});
					weekEnd.show();
					weekDays.hide();
					$.weekday_time_show(false);
					if (scheduledTimes.val() === '1') {
						$.same_time_show(false);
						$.weekend_time_show(true);
					} else {
						$.same_time_show(true);
						$.weekend_time_show(false);
					}
					break;
				}
			});

			// enable the times select for selected days
			// this will be only active if select times for selected days is active
			selectDays.find(':checkbox').each( function (i) {
				//In iPad Safari touchstart events from checkboxes, the checkbox state has 
				// not yet been updated when the event fires. Ergo we use click here

				$(this).on('change', function () {
					$('.errorMsg').remove();
					// check the days selection
					if (scheduledTimes.val() === '1') {
						// show the associated times seletion
						if (this.checked) {
							$(this).parents('li').find('.timeSelection').css('visibility', 'visible'); 
							$(this).parents('li').find('.timeSelection').find('input').prop('disabled', false);
							//$(this).parents('li').find('.timeSelection').find('input').trigger('change');
							$(this).parents('li').find('select').prop('disabled', false);
						} else {
							// we deselect a checkbox, reset the associated times selection
							$(this).parents('li').find('select').prop('disabled', true);
							$(this).parents('li').find('.timeSelection').find('input').prop('disabled', true);
							$(this).parents('li').find('.timeSelection').css('visibility', 'hidden'); 
						}
					}  
				});
			});  

			// update selected times select if days selection changes
			scheduledTimes.on('change', function () {
				$('#scheduledDays').trigger('change');
			});


			// select time for selected days input pairs
			// click 24 Hours resets the times selection inputs
			$('.selectTimesForDay').on('change', function () {
				if ( $(this).is(':checked') ) {
					$(this).parents('li').find('select').prop('disabled', false).css({'background-color':''});
				}
			});
			$('.allDay').on('change', function () {
				if ( $(this).is(':checked') ) {
					$(this).parents('li').find('select').prop('disabled', true).css({'background-color':'#ebebe4'});
				}
			});

			$('.timeList').on('click', function() {
				$(this).parents('li').find('.selectTimesForDay').prop('checked', true);
				$(this).parents('li').find('.selectTimesForDay').trigger('change');
			});

			$('#syncClock').click(function() {
				$('#synchDate').dpSetSelected($.getDate(new Date()));
				$('#synchTime').timepicker('setTime', new Date());
				if( cur_timezone < 0 ){
					$('#timeZone').val(findTimeZoneValue('GMT'+ cur_timezone));
				}else if( cur_timezone >0 ){
					$('#timeZone').val(findTimeZoneValue('GMT+'+ cur_timezone));
				}else
					$('#timeZone').val(findTimeZoneValue('GMT-'+ cur_timezone));//fix the bug 62248
				$.enableButton('saveBt','#accessScheduleForm', 0, true);
				syncTime = 1;
			});
			$('.synchDateTime').on('change', function() {
				if ( $('#synchDate').val() == ""
                                                || (!/^((0[1-9])|(1[0-2])):([0-5][0-9])(a|p)m$/.test($('#synchTime').val()) && is_europe_region == '0')
                                                || (!/^(([0-1][0-9])|(2[0-3])):([0-5][0-9])$/.test($('#synchTime').val()) && is_europe_region == '1'))
					$.enableButton('saveBt','#accessScheduleForm', 0, false);
				else
					$.enableButton('saveBt','#accessScheduleForm', 0, true);
			});
			$('.synchDateTime').keydown(function(){ $('.synchDateTime').trigger('change'); });
			$('.synchDateTime').keyup(function(){ $('.synchDateTime').trigger('change'); });
			$('.synchDateTime').on('click', function() {
				syncTime = 2;
			});

			if ( is_europe_region == '1' ) {
				$('#synchTime').keydown(function(e) {
					var s = $(this).val();
					if ( e.which == 8 || e.which == 46 )
						return true;

					if ( !/^(4[8-9])|(5[0-7])|(9[6-9])|(10[0-5])|(186)$/.test(e.which) )//0-9 :
						return false;
					if ( s.length == 0 && !( e.shiftKey == false && ((e.which > 47 && e.which < 51) || (e.which > 95 && e.which < 99)) ) )// begin with 0-2
						return false;
					if ( /^([0-1])$/.test(s) && !( e.shiftKey == false && /^(4[8-9])|(5[0-7])|(9[6-9])|(10[0-5])$/.test(e.which)) )
						return false;
					if ( s == "2" && !( e.shiftKey == false && /^(4[8-9])|(5[0-1])|(9[6-9])$/.test(e.which)) )
						return false;
					if ( /^((2[0-3])|([0-1][0-9]))$/.test(s) && !( e.shiftKey == true && e.which == 186) )
						return false;
					if ( /^((2[0-3])|([0-1][0-9])):$/.test(s) && !( e.shiftKey == false && /^(4[8-9])|(5[0-3])|(9[6-9])|(10[0-1])$/.test(e.which)) )
						return false;
					if ( /^((2[0-3])|([0-1][0-9])):([0-5])$/.test(s) && !( e.shiftKey == false && /^(4[8-9])|(5[0-7])|(9[6-9])|(10[0-5])$/.test(e.which)))
						return false;
					if ( /^(((2[0-3])|([0-1][0-9])):[0-5][0-9])$/.test(s) )
						return false;

					return true;
				});
			} else {
				$('#synchTime').keydown(function(e) {
					var s = $(this).val();
					if ( e.which == 8 || e.which == 46 )
						return true;

					if ( !/^(4[8-9])|(5[0-7])|(9[6-9])|(10[0-5])|(186)|(65)|(80)|(77)$/.test(e.which) )//0-9 : &nbsp; a p m
						return false;
					if ( s.length == 0 && !( e.shiftKey == false && ((e.which > 47 && e.which < 50) || (e.which > 95 && e.which < 98))) )// begin with 0-1
						return false;
					if ( s == "0" && (!( e.shiftKey == false && /^(49)|(5[0-7])|(9[7-9])|(10[0-5])$/.test(e.which))))
						return false;
					if ( s == "1" && (!( e.shiftKey == false && /^(4[8-9])|(50)|9[6-8]$/.test(e.which))))
						return false;
					if ( /^((0[1-9])|(1[0-2]))$/.test(s) && !( e.shiftKey == true && e.which == 186 ) )//:
						return false;
					if ( /^((0[1-9])|(1[0-2])):$/.test(s) && !( e.shiftKey == false && /^(4[8-9])|(5[0-3])|(9[6-9])|(10[0-1])$/.test(e.which)) )// should be 0-5
						return false;
					if ( /^((0[1-9])|(1[0-2])):([0-5])$/.test(s) && !( e.shiftKey == false && /^(4[8-9])|(5[0-7])|(9[6-9])|(10[0-5])$/.test(e.which)))// should be 0-9
						return false;
					if ( /^((0[1-9])|(1[0-2])):([0-5][0-9])$/.test(s) && !( e.shiftKey == false && /^(65)|(80)$/.test(e.which) ) )//a,p
						return false;
					if ( /^((0[1-9])|(1[0-2])):([0-5][0-9])(a|p)$/.test(s) && !( e.shiftKey == false && e.which == 77 ) )//m
						return false;
					if ( /^((0[1-9])|(1[0-2])):([0-5][0-9])(a|p)m$/.test(s) )
						return false;

					return true;
				});
			}

			$.refresh_schedules = function() {
				$.getData('schedule_info.aspx', function(json){
					wireless_schedule_array = json.list;
					wireless_schedule_num = json.list.length;
					show_schedules();
					$('.running').remove();
				});
			};
			$.refresh_schedules();
			$('#scheduledDays').trigger('change');
			if ( !(($('#autoClock').is(':checked') && auto) || $('#manualClock').is(':checked') && manual) ) {
				$('.schedule').find('input, select').prop('disabled', true);
				$('#scheduleWrap').hide();
				$('#addBt').prop('disabled', true);
			} else if ( $('#manualClock').is(':checked') && manual ) {
				$('#synchDate').dpSetSelected($.getDate(new Date(cur_time)));
				$('#synchTime').timepicker('setTime', new Date(cur_time));
				$.enableButton('saveBt','#accessScheduleForm', 0, true);
			}
			$('option:eq('+sel_tz+')', '#timeZone').prop('selected', true);

			$.apply = function() {
				$('#hidden_select').val($('#timeZone').find('option:selected').index());
				if ( $('#adjust').is(':checked') ) {
					$('#ntpadjust').val("1");
				} else {
					$('#ntpadjust').val("0");
				}
				$('#hidden_ntpserver').val($('#timeZone').val());
				$.submit_wait('.main:first', $.PAGE_WAITING_DIV);
				$('input[name=submit_flag]','#accessScheduleForm').val('wireless_schedule');
				$.postForm('#accessScheduleForm', '', function(json){
					if ( json.status == '1' ) {
						setTimeout("document.location.reload();", parseInt(json.wait, 10) * 1000 );
					} else {
						$('.running').remove();
						$.alertBox(json.msg, '', function(){document.location.reload();});
					}
				});
			};
			$('#addBt').click(function() {
				if ( $(this).prop('disabled') == true || !$('#asOn').is(':checked') ) {
					$('#addBt').prop('disabled', true).css({'background-color':'#ebebe4'});
					return false;
				}
				$('.errorMsg').remove();
				if ( $('#asOn').is(':checked')) {
					if ( ($('#scheduledDays').val() == "1" && allDays.find(':checkbox:checked').length == 0)
						|| ($('#scheduledDays').val() == "2" && weekDays.find(':checkbox:checked').length == 0)
						|| ($('#scheduledDays').val() == "3" && weekEnd.find(':checkbox:checked').length == 0) ) {
						$.alertBox(invalid_noday);
						return false;
					}
					var allflag = document.getElementById('allFromTime').disabled
					$('select[name*=_from_time]').each( function(i, ele) {
						var flag = document.getElementById($(ele).parent().find('select[name*=_from_time]').attr('id')).disabled
						if ( $(ele).parent().find('.selectTimesForDay').is(':checked') && !flag) {
							var toTime = $(ele).parent().find('select[name*=_to_time]').first();
							if ( $(ele).val() == null || toTime.val() == null
								|| $(ele).val() < 0 || toTime.val() < 0 ) {
								$.addErrMsgAfter($(ele).attr("id"), invalid_time_sel);
								return;
							}
							if ( parseInt($(ele).val(), 10) == parseInt(toTime.val(), 10) ) {
								$.addErrMsgAfter($(ele).attr("id"), same_time);
							}
							if ( parseInt($(ele).val(), 10) > parseInt(toTime.val(), 10) ) {
								$.addErrMsgAfter($(ele).attr("id"), invalid_time_sel);
							}
						}
					});
				}
				if ( $('.errorMsg').length)
					return false;


				var list = "",
				container = null;
				switch($('#scheduledDays').val()) {
					case '0':
						if ( $('#allDays').is(':checked') ) {
							list = "0-48-Daily";
						} else {
							list = $('#allFromTime').val()+"-"+$('#allToTime').val()+"-Daily";
						}
						break;
					case '1':
						container = allDays;
						break;
					case '2':
						container = weekDays;
						break;
					case '3':
						container = weekEnd;
						break;
				}

				if ( container != null ) {
					if ( $('#scheduledTimes').val() == '1' ) {
						container.find(':checkbox').each(function(i, ele) {
							if ( container == weekEnd ) {
								i += 5;
							}
							if ( $(ele).is(':checked') ) {
								var timeSelection = $(ele).parent().parent().find('.timeSelection').first(),
								radio = timeSelection.find('input[type=radio]').first(),
								day = (i+1) % 7;
								if ( radio.is(':checked') ) {
									list += "0-48-" + day + ";";
								} else {
									var from = timeSelection.find('select[name*=_from_time]').first().val(),
									to = timeSelection.find('select[name*=_to_time]').first().val();
									list += from+"-"+to+"-"+day + ";";
								}
							}
						});
						if ( list != "" )
							list = list.substring(0, list.length - 1);
					} else {
						if ( $('#allDays').is(':checked') ) {
							list += "0-48-";
						} else {
							list = $('#allFromTime').val()+"-"+$('#allToTime').val()+"-";
						}
						if ( container.find(':checkbox:checked').length == 7 ) {
							list += 'Daily';
						} else {
							container.find(':checkbox').each(function(i, ele) {
								if ( container == weekEnd ) {
									i += 5;
								}
								if ( $(ele).is(':checked') ) {
									var day = (i+1) % 7;
									list += day + ",";
								}
							});
							list = list.substring(0, list.length - 1);
						}
					}
				}
				if ( list.split(";").length + wireless_schedule_num > $.MAX_RULE ) {
					$.alertBox(sch_reach_limt);
					return false;
				}
				//check rule is duplicate or not;
				var i = 0, j,
				array = list.split(";");
				for ( i = 0; i < array.length; i++ ){
					for ( j = 0; j < wireless_schedule_num; j++ )
					{
						if ( array[i] == eval("wireless_schedule_array["+j+"]") ) {
							$.alertBox(service_rule_dup);
							return false;
						}
					}
				}
				$('#scheduleList').val(list);
				$.submit_wait('.main:first', $.PAGE_WAITING_DIV);
				$('input[name=submit_flag]','#accessScheduleForm').val('add_schedule');
				$.postForm('#accessScheduleForm', '', function(json){
					if ( json.status == '1' ) {
						$.refresh_schedules();
					} else {
						$('.running').remove();
						$.alertBox(json.msg, '', $.refresh_schedules);
					}
				});


			});
			$('#saveBt').click(function() {
				$('.errorMsg').remove();
				$('#pcTime').val("");

				if ( syncTime || $('#manualClock').is(':checked')) {
					if( $('#autoClock').is(':checked') ) {
						$('#synchDate').dpSetSelected($.getDate(new Date(cur_time)));
						$('#synchTime').timepicker('setTime', new Date(cur_time));
					}
					$.confirmBox(change_time_to+$('#synchDate').val()+" "+$('#synchTime').val(),
						yes_mark, function() {
							var dates = $('#synchDate').val().split('/'),
							time = $('#synchTime').val(),
							array = new Array();
							
							time = (is_europe_region == '0') ? time.substring(0, time.length - 2) : time;
							array = time.split(':');
							if ( is_europe_region == '0' ) {
								if ( $('#synchTime').val().indexOf("pm") != -1 ) {
									if ( parseInt(array[0], 10) !== 12 )
										array[0] = parseInt(array[0], 10) + 12;
								} else {
									if ( parseInt(array[0], 10) === 12 )
										array[0] = "00";
								}
							}
							$('#pcTime').val("'"+dates[2]+"-"+dates[0]+"-"+dates[1]+" "+array[0]+":"+array[1]+"'");
							$.apply();
						}, no_mark, function(){
							$.apply();
						});
					syncTime = 0;
				} else if ( $('#autoClock').is(':checked') ) {
					$('#pcTime').remove();
					$.apply();
				} else {
					$.apply();
				}
			});
			$('#cancelBt').click(function () {
				document.location.reload();
			});


		} // end page accessSchedule

	}); // end ready function

}(jQuery));
