/**
 * For setup flow
 */
(function ($) {

	"use strict";
	
	var checkNum = 4;

	$(function () {
		/*******************************************************************************************
		 * 
		 * Register page
		 *
		 *******************************************************************************************/
		$.checkBookmark = function() {
			if($('#bookmark').is(':checked') == true) {
				$.addBookmark();
			}else{
				$.checkFinish();
			}
		}
		if ( typeof(have_reg_info) != "undefined" && have_reg_info == "1" )
			top.location.href = "status.htm"+$.ID_2;

		if ( $('#registerForm').length ) {
			var FIRST_NAME     = 0x80,
			LAST_NAME        = 0x40,
			EMAIL            = 0x20,
			PURCHASE_DATE    = 0x10,
			SERIAL_NUMBER    = 0x08,
			status           = 0x00,
			ALL_SET          = 0xf8;

			// checkbox for Bookmark NETGEAR Genie and Send me email are preset

			$("#product").val(host_name);
			if(registerName == ""){
				if(disable_pwd == "1")
					$("#email").val();
				else
					$("#email").val(httpName);
			}else{
				$("#email").val(registerName);
			}
			if( $.isIE() )
			{
				$(":checkbox[value='bookmark']").prop('disabled', false);
				$(":checkbox[value='bookmark']").prop('checked', true);
			}else{
				$(":checkbox[value='bookmark']").prop('disabled', true);
			}
			$(":checkbox[value='sendEmail']").prop('checked', true);

			if ( $.isAndroid ) {
				$('#androidInstall').show();
			}

			$('#firstName').keyup(function () {
				var str = $('#firstName').val();
				if ($.trim(str).length > 0) {
					$(this).addClass("activeElement");
				} else {
					$(this).removeClass("activeElement");
				}
				$.enableButton('finishBt', '#registerForm', checkNum);
			});
			$('#firstName').trigger('keyup');

			$('#lastName').keyup(function () {
				var str = $('#lastName').val();
				if ($.trim(str).length > 0) {
					$(this).addClass("activeElement");
				} else {
					$(this).removeClass("activeElement");
				}
				$.enableButton('finishBt', '#registerForm', checkNum);
			});
			$('#lastName').trigger('keyup');

			$('#email').change(function() {
				var str = $('#email').val();
				$(this).removeClass("activeElement");
				if ($.trim(str).length > 0) {
					if ( $.REG_EMAIL.test(str) ){
						$('#err_email').remove();
						$(this).addClass("activeElement");
					}
				} else {
					$(this).removeClass("activeElement");
				}
				$.enableButton('finishBt', '#registerForm', checkNum);
			});
			$('#email').trigger('change');

			$('#email').blur(function() {
				var str = $('#email').val();
				$('#err_email').remove();
				if (!$.REG_EMAIL.test(str) && str.length != 0)
					$.addErrMsgAfter('email', invalid_username, false, 'err_email');
			});

			$('#email').keyup(function() {
				var str = $('#email').val();
				$(this).removeClass("activeElement");
				if ($.trim(str).length > 0) {
					if ( $.REG_EMAIL.test(str) ){
						$('#err_email').remove();
						$(this).addClass("activeElement");
					}
				} else {
					$(this).removeClass("activeElement");
				}
				$.enableButton('finishBt', '#registerForm', checkNum);
			});

			$('#purchaseDate').change(function () {
				var str = $('#purchaseDate').val();
				if ($.trim(str).length > 0) {
					$(this).addClass("activeElement");
				} else {
					$(this).removeClass("activeElement");
				}
				$.enableButton('finishBt', '#registerForm', checkNum);
			});
			if ( typeof(cur_time) != "undefined" )
				$('#purchaseDate').dpSetSelected($.getDate(new Date()));
			$('#purchaseDate').trigger('change');

			if ( $('#serialNumber').val() == "N/A" ) {
				$('#refurbished').prop('checked', true);
				$("input[type='text']").not("#serialNumber").prop('disabled', true);
				$("select").prop('disabled', true);
				$("select").css({'background-color':'#ebebe4'});
				$("#sendEmail").prop('disabled', true);
				$("#sendEmail").prop('checked', false);
				$("#finishBt").prop('disabled', false);
			} else {
				$('#refurbished').prop('checked', false);
			}

			$('#refurbished').click(function() {
				if( $("#refurbished").is(":checked") == true ){
					$("input[type='text']").not("#serialNumber").prop('disabled', true);
					$("select").prop('disabled', true);
					$("select").css({'background-color':'#ebebe4'});
					$("#sendEmail").prop('disabled', true);
					$("#sendEmail").prop('checked', false);
					$("#finishBt").prop('disabled', false);
				}else{
					$("input[type='text']").not("#serialNumber").prop('disabled', false);
					$("select").prop('disabled', false);
					$("select").css({'background-color':''});
					$("#sendEmail").prop('disabled', false);
					$("#sendEmail").prop('checked', true);
					$.enableButton('finishBt', '#registerForm', checkNum);
				}
			});

			$(':checkbox').each(function(){
				if ( $(this).is(':checked'))
					$(this).addClass('checked');
			});
			$('#finishBt').click(function() {
				$.checkBookmark();
			});
			$.checkFinish = function(){
				$('#err_email').remove();
				if( $("#refurbished").is(":checked") == true ){
					location.href = "/status.htm"+$.ID_2;
				}else{
				if ( !$.REG_EMAIL.test($('#email').val()) ) {
					$.addErrMsgAfter('email', invalid_username, false, 'err_email');
					return false;
				}
				var arr_date = $("#purchaseDate").val().split("/");
				if ( arr_date.length < 3 )
				{
					$.alertBox(msg_408);
					return false;
				}
				var firstusedate = arr_date[2]+"-"+arr_date[0]+"-"+arr_date[1];
				$.submit_wait('body', $.WAITING_DIV);
				$.ajax({
					url: registerUrl + "registerProduct",
					jsonp: "callback",
					dataType: "jsonp",
					data: {
						first_name: $("#firstName").val(),
						last_name: $("#lastName").val(),
						firstusedate: firstusedate,
						mailprogram: ($('#sendEmail').is(':checked')?1:0),
						iso_country: $( "#country option:selected" ).val(),
						email: $("#email").val(),
						serial_number: $("#serialNumber").val(),
						installq2: "0", //assume unrated for this call - essentially have a star rating of 1 to 5 and pass the value here, 0 for unrated.
						product: host_name,
						telephone: "",
						source: "SmartWizard Registraiton",
						returnjsonp: "on"
					},
					timeout: 30000,
					// work with the response
					success: function( response ) {
						$('.running').remove();
						if(response.errorCode==200)
						{
							if(response.registration_id > 0)
							{
								if(response.customer_id>0 && response.new_customer=="1")
								{
									$.postForm('#registerForm', '', function(json) {
										location.href = "/status.htm"+$.ID_2;
									});
								}
								else
								{
									$.postForm('#registerForm', '', function(json) {
										location.href = "/status.htm"+$.ID_2;
									});
								}
							}
							else
							{
								$.alertBox(res_402, null, function(){
									$.postForm('#registerForm', '', function(){
										location.href = "/status.htm"+$.ID_2;
									});
								});
							}
						}
						else
						{
							var msg = eval("res_"+response.errorCode);
							$.alertBox(msg, null, function(){
								if ( response.errorCode == 402 ) {
									$.postForm('#registerForm', '', function(){
										location.href = "/status.htm"+$.ID_2;
									});
								} else
									return false;
							});
						}
					},

					error: function() {
						$('.running').remove();
						$.alertBox(reg_failed, null, function(){
							location.href = "/status.htm"+$.ID_2;
						});
					}

				});
				}
			}
		}

	}); // end ready function

}(jQuery));
 
