/**
 * For setup flow
 */
(function ($) {

	"use strict";

	var checkNum = 0;
	var newWin;

	$(function () {
		/*******************************************************************************************
		 * 
		 * init login button action
		 *
		 *******************************************************************************************/
		if (typeof (no_auth) != 'undefined' && no_auth == "1") {
			location.href = "start.htm" + $.ID_2;
		}

		function postLoginForm(json) {
			if (json.status == '1') {
				if (first_smart_setup == 1 && register_flag != "1" && ping_result == "1")
					newWin.location.href = 'http://www.netgear.com/success/' + moduleName + '.aspx?sn=' + serialNumber + '';
				location.href = json.url;
			} else {
				if (first_smart_setup == 1 && register_flag != "1" && ping_result == "1")
					newWin.close();
				if (typeof (json.confirm) != 'undefined') {
					$('.running').remove();
					$.confirmBox(json.confirm, null, function () {
						$.submit_wait('body', $.WAITING_DIV);
						$.ajax({
							url: $('#loginForm').attr("action"),
							type: "POST",
							data: $.generatePostData($.param({
								"submit_flag": "login",
								"email": $.base64.encode($('#userId').val()),
								"password": $.base64.encode($('#password').val()),
								"hid_remember_me": $('#hid_remember_me').val(),
								"multiLogin": "1",
								"anticsrf": csrfToken
							})),
							dataType: 'json',
							contentType: "application/x-www-form-urlencoded; charset=utf-8",
							success: postLoginForm
						});
					}, null, function () {
						location.href = "goodbye.html";
					});
				} 
				else if (typeof (json.msg) != 'undefined') {
					$('.running').remove();
					$.addErrMsgAfter('password', json.msg);
					if (json.redirect == "1")
					{
						location.href = json.url;
					}
				}
			}
		}
		if ($('#loginForm').length) {
			var str = $.cookie("session") ? $.base64.decode($.cookie("session")) : '';

			if (sess) {
				var str2 = sess.substring(1).replace(/%3D/g, '=');
				str = str2 ? $.base64.decode(str2) : '';
			}
			if (remember_me == 1 && str) {
				setTimeout(function () {
					$('#userId').removeAttr("style");
					$('#userId').val(str);
					$('#password').val("");
					$('#rememberMe').prop('checked', true);
					$('#rememberMe').addClass('checked');
				}, $.chromeTimer);
			} else {
				setTimeout(function () {
					if ('placeholder' in document.createElement('input')) {
						$('#userId').val("");
						$('#password').val("");
					}
					$('#userId').removeAttr("style");
				}, $.chromeTimer);
			}
			$.enterSubmit("#loginForm", "loginBt");
			$("#loginForm").attr("onsubmit", "return false");

			$("html").attr('style', 'height:100%;width:100%');
			$.getData2('ping_result.html', function (json) {
				ping_result = json.ping_result;
			});
			$('#newExtSetup').click(function () {
				if (tnc_request_flag == "1") {
					if ((tc_new != "2" && set_simple_TC != "1") || (tc_new == "2" && agree_collect_TC != "1")) {
						if (tc_new != "2")
							location.href = "simple_conditions.html";
						else
							location.href = "BRS_full_conditions.html";
					} else {
						location.href = "new_extender_setup.html";
					}
				} else {
					top.location.href = "new_extender_setup.html";
				}
			});

			$('#loginBt').click(function () {
				$('.errorMsg').remove();
				if (!$.REG_EMAIL.test($('#userId').val())) {
					$.addErrMsgAfter('userId', invalid_username);
				}
				if (!$.REG_PASSWORD.test($('#password').val())) {
					$.addErrMsgAfter('password', error_password_format);
				}
				if ($('#rememberMe').is(':checked')) {
					$('#hid_remember_me').val("on");
				} else {
					$('#hid_remember_me').val("off");
				}
				if (!$('.errorMsg').length) {
					$.removeCookie('interim');
					$.removeCookie('session');
					$.submit_wait('body', $.WAITING_DIV);
					$("#loginBt").prop('disabled', true);
					if (location.pathname != "/login.html")
						$('#loginForm').attr("action", $('#loginForm').attr("action").replace(/\/start.htm/g, location.pathname));
					if (first_smart_setup == 1 && register_flag != "1" && ping_result == "1")
						newWin = window.open("/register_loading.htm");
					$.ajax({
						url: $('#loginForm').attr("action"),
						type: "POST",
						data: $.generatePostData($.param({
							"submit_flag": "login",
							"email": $.base64.encode($('#userId').val()),
							"password": $.base64.encode($('#password').val()),
							"hid_remember_me": $('#hid_remember_me').val(),
							"anticsrf": csrfToken
						})),
						dataType: 'json',
						contentType: "application/x-www-form-urlencoded; charset=utf-8",
						success: postLoginForm,
						error: function () {
							window.location.reload(true);
						},
						complete: function() {
							$("#loginBt").prop('disabled', false);
						}
					});
				}
			});
		}

		/*******************************************************************************************
		 * 
		 * Username & Password Help
		 *
		 *******************************************************************************************/
		if ($('#pwdHelpForm').length) {
			$.checkButton = function () {
				$.enableButton('nextStep', '#pwdHelpForm', 0, $('#answer1').val() && $('#answer2').val());
			};
			$('.answer').change($.checkButton);
			$('.answer').keyup($.checkButton);

			$('#nextStep').click(function () {
				$("#nextStep").prop('disabled', true);
				$('.errorMsg').remove();
				$.submit_wait('body', $.WAITING_DIV);
				$.postForm('#pwdHelpForm', '', function (json) {
					$("#nextStep").prop('disabled', false);
					$('.running').remove();
					if (json.status == '1') {
						if (json.url == "passwd_reset.html") {
							location.href = json.url;
						} else {
							$('#email').text($.base64.decode(json.email));
							$('#password').text($.base64.decode(json.password));
							$('.answerElements').removeClass('answerElements');
							$('.quesElements').hide();
							$('#nextStep').hide();
						}
					} else {
						$('.running').remove();
						$.alertBox(json.msg);
						$('.answer').val('');
					}
				});
			});
		}

		$.validatepassword = function (passwd) {
			var disabled = "img/checkbox-selected-gry.svg";
			var enabled = "img/checkbox-selected.svg";
			var meet_complex = 0, meet_len = 0, no_same = 0;
			var re = new RegExp("[a-z]");
			var len = re.test(passwd);
			if (len) {
				$('#pwd_complex2').attr('src', enabled);
				meet_complex++;
			} else {
				$('#pwd_complex2').attr('src', disabled);
			}
			re = new RegExp("[A-Z]");
			len = re.test(passwd);
			if (len) {
				$('#pwd_complex1').attr('src', enabled);
				meet_complex++;
			} else {
				$('#pwd_complex1').attr('src', disabled);
			}
			re = new RegExp("[0-9]");
			len = re.test(passwd);
			if (len) {
				$('#pwd_complex3').attr('src', enabled);
				meet_complex++;
			} else {
				$('#pwd_complex3').attr('src', disabled);
			}
			re = new RegExp("((?=[\x21-\x7e]+)[^A-Za-z0-9])");
			len = re.test(passwd);
			if (len) {
				$('#pwd_complex4').attr('src', enabled);
				meet_complex++;
			} else {
				$('#pwd_complex4').attr('src', disabled);
			}
			if (meet_complex > 2)
				$('#pwd_complex').attr('src', enabled);
			else
				$('#pwd_complex').attr('src', disabled);
			if (passwd.length >= 6 && passwd.length <= 32) {
				$('#pwd_len').attr('src', enabled);
				meet_len = 1
			} else {
				$('#pwd_len').attr('src', disabled);
			}
			re = new RegExp("^.*(.)\\1{2}.*$");
			len = re.test(passwd);
			if (!len) {
				$('#pwd_identical').attr('src', enabled);
				no_same = 1;
			} else {
				$('#pwd_identical').attr('src', disabled);
			}
			if (meet_complex > 2 && meet_len && no_same) {
				$('#passwd_hint').css('display', 'none');
				$('#pwd_warn').attr('src', 'img/check.jpg');
				$('#pwd_sucess').attr('src',enabled);
			} else {
				$('#passwd_hint').css('display', '');
				$('#pwd_warn').attr('src', 'img/warning_flag.jpg');
				$('#pwd_sucess').attr('src',disabled);
			}
		}

		/*******************************************************************************************
                 *
                 * PASSWORD Reset page
                 *
                 *******************************************************************************************/
		function postResetForm(json) {
			if (json.status == '1') {
				$('.running').remove();
				$('.start').hide();
				$('#continue').show();
			} else {
				$('.running').remove();
				$.alertBox(json.msg);
			}
		}

		if ($('#resetPwdForm').length) {
			checkNum = 7;

			$('#resetName').change(function () {
				var str = $('#resetName').val();
				if ($.trim(str).length > 0) {
					if ($.REG_EMAIL.test(str)) {
						$(this).removeClass('alert');
						$('#err_email').remove();
					}
				}
			});

			$('#resetName').trigger('change');

			$('#resetName').blur(function () {
				var str = $('#resetName').val();
				$('#err_email').remove();
				if (!$.REG_EMAIL.test(str) && str.length != 0) {
					$(this).addClass('alert');
					$.addErrMsgAfter('resetName', invalid_username, false, 'err_email');
				} else {
					$(this).removeClass('alert');
				}
			});

			$('#resetName').keyup(function () {
				var str = $('#resetName').val();
				if ($.trim(str).length > 0) {
					if ($.REG_EMAIL.test(str)) {
						$(this).removeClass('alert');
						$('#err_email').remove();
					}
				}
			});

			$('#resetPwd').keyup(function () {
				var pwd = $(this).val(),
					pwd2 = $('#resetPwdVerify').val();
				if (security_enhance_flag == "1") {
					var wait = 1000;
					var timeoutID = null;
					clearTimeout(timeoutID);
					timeoutID = setTimeout(function () { $.validatepassword(pwd); }, wait);
				}

				if (pwd.length > 0) {
					$('#resetPwdVerify').prop('disabled', false);
				} else {
					$('#resetPwdVerify').prop('disabled', true);
				}
				if (pwd2 != '' && pwd != pwd2) {
					if (!$('#resetPwdVerify').hasClass('alert'))
						$('#resetPwdVerify').addClass('alert');
					if (!$('#repass').length)
						$.addErrMsgAfter('resetPwdVerify', error_not_same_pwd, false, 'repass');
				} else if (pwd == pwd2) {
					$('#resetPwdVerify').removeClass('alert');
					$('#repass').remove();
				}

			});

			$('#resetPwd').keydown(function () {
				if (security_enhance_flag == "1") {
					$('#pwd_warn').css('display', '');
					$('#passwd_hint').css('display', 'none');
				}
			});

			$('#resetPwdVerify').keyup(function () {
				var pwd = $('#resetPwd').val(),
					pwd2 = $(this).val();
				if ($.trim(pwd) == $.trim(pwd2) && pwd2.length != 0) {
					$(this).removeClass('alert');
					$('#repass').remove();
				}
			});

			$('#resetPwdVerify').blur(function () {
				var pwd = $('#resetPwd').val(),
					pwd2 = $(this).val();
				$('#repass').remove();
				if ($.trim(pwd) != $.trim(pwd2) && pwd2.length != 0) {
					$(this).addClass('alert');
					$.addErrMsgAfter('resetPwdVerify', error_not_same_pwd, false, 'repass');
				} else {
					$(this).removeClass('alert');
					$('#repass').remove();
				}
			});

			$('input:not([type="button"])', '#resetPwdForm').each(function (i, ele) {
				$(ele).keyup(function () {
					if ($(this).val().length > 0) {
						$(this).addClass('activeElement');
					} else {
						$(this).removeClass('activeElement');
					}
					$.enableButton('nextStep', '#resetPwdForm', checkNum);
				});
			});

			$('#resetQue1').change(function () {
				if ($(this).val() != -1) {
					$(this).addClass('activeElement');
				} else {
					$(this).removeClass('activeElement');
				}
				$.enableButton('nextStep', '#resetPwdForm', checkNum);
				$('#securityQuestion1').html($(this).find('option:selected').text() + '<span class=downArrow></span>').css({ 'color': '#7D706C', 'font-weight': 'bold' });
			});

			$('#resetQue2').change(function () {
				if ($(this).val() != -1) {
					$(this).addClass('activeElement');
				} else {
					$(this).removeClass('activeElement');
				}
				$.enableButton('nextStep', '#resetPwdForm', checkNum);
				$('#securityQuestion2').html($(this).find('option:selected').text() + '<span class=downArrow></span>').css({ 'color': '#7D706C', 'font-weight': 'bold' })
			});

			setTimeout(function () {
				if ('placeholder' in document.createElement('input')) {
					$('#resetName').val("");
					$('#resetPwd').val("");
				}
				$('#resetName').removeAttr("style");
			}, $.chromeTimer);

			$('#nextStep').click(function () {
				$('.errorMsg').remove();
				if ($('#resetPwd').val() != $('#resetPwdVerify').val()) {
					$('#resetPwdVerify').addClass('alert');
					$.addErrMsgAfter('resetPwdVerify', error_not_same_pwd, false, 'repass');
					return;
				}
				if ($('#resetPwd').val() == "password") {
					$('#resetPwd').addClass('alert');
					$.addErrMsgAfter('resetPwd', not_password, false, 'repass');
				}
				if (!$.REG_PASSWORD.test($('#resetPwd').val())) {
					$('#resetPwd').addClass('alert');
					$.addErrMsgAfter('resetPwd', pwd_should + " 6-32 " + characters, false, 'repass');
				}
				if (!$.REG_PASSWORD.test($('#resetPwdVerify').val())) {
					$('#resetPwdVerify').addClass('alert');
					$.addErrMsgAfter('resetPwdVerify', pwd_should + " 6-32 " + characters, false, 'repass');
				}
				if ($('#resetQue1').val() == -1) {
					$.addErrMsgAfter('resetQue1', error_no_question);
				}
				if ($('#resetAn1').val().length == 0) {
					$.addErrMsgAfter('resetAn1', error_no_answer);
				}
				if (!$.REG_ANSWER.test($('#resetAn1').val())) {
					$.addErrMsgAfter('resetAn1', invalid_answer);
				}
				if ($('#resetQue2').val() == -1) {
					$.addErrMsgAfter('resetQue2', error_no_question);
				}
				if ($('#resetAn2').val().length == 0) {
					$.addErrMsgAfter('resetAn2', error_no_answer);
				}
				if (!$.REG_ANSWER.test($('#resetAn2').val())) {
					$.addErrMsgAfter('resetAn2', invalid_answer);
				}

				if (!$('.errorMsg').length) {
					$.submit_wait('body', $.WAITING_DIV);
					$.ajax({
						url: $('#resetPwdForm').attr("action"),
						type: "POST",
						data: $.generatePostData($.param({
							"submit_flag": "passwd_reset",
							"new_username": $.base64.encode($('#resetName').val()),
							"new_pwd": $.base64.encode($('#resetPwd').val()),
							"answer1": $('#resetAn1').val(),
							"question1": $('#resetQue1').val(),
							"answer2": $('#resetAn2').val(),
							"question2": $('#resetQue2').val(),
							"anticsrf": csrfToken
						})),
						dataType: 'json',
						contentType: "application/x-www-form-urlencoded; charset=utf-8",
						success: postResetForm
					});
				}
			});
		}

		/*******************************************************************************************
                 *
                 * SECURE YOUR PASSWORD page
                 *
                 *******************************************************************************************/
		if ($('#securePwdForm').length) {
			if (must_secure == "1") {
				$("#skipStep").css('display', 'none');
				$("#disRemindTd").css('display', 'none');
			}
			checkNum = 7;

			$('#securePwd').keyup(function () {
				var pwd = $(this).val(),
					pwd2 = $('#securePwdVerify').val();
				if (security_enhance_flag == "1") {
					var wait = 1000;
					var timeoutID = null;
					clearTimeout(timeoutID);
					timeoutID = setTimeout(function () { $.validatepassword(pwd); }, wait);
				}

				if (pwd.length > 0) {
					$('#securePwdVerify').prop('disabled', false);
				} else {
					$('#securePwdVerify').prop('disabled', true);
				}
				if (pwd2 != '' && pwd != pwd2) {
					if (!$('#securePwdVerify').hasClass('alert'))
						$('#securePwdVerify').addClass('alert');
					if (!$('#repass').length)
						$.addErrMsgAfter('securePwdVerify', error_not_same_pwd, false, 'repass');
				} else if (pwd == pwd2) {
					$('#securePwdVerify').removeClass('alert');
					$('#repass').remove();
				}

			});

			$('#securePwd').keydown(function () {
				if (security_enhance_flag == "1") {
					$('#pwd_warn').css('display', '');
					$('#passwd_hint').css('display', 'none');
				}
			});

			$('#securePwdVerify').keyup(function () {
				var pwd = $('#securePwd').val(),
					pwd2 = $(this).val();
				if ($.trim(pwd) == $.trim(pwd2) && pwd2.length != 0) {
					$(this).removeClass('alert');
					$('#repass').remove();
				}
			});

			$('#securePwdVerify').blur(function () {
				var pwd = $('#securePwd').val(),
					pwd2 = $(this).val();
				$('#repass').remove();
				if ($.trim(pwd) != $.trim(pwd2) && pwd2.length != 0) {
					$(this).addClass('alert');
					$.addErrMsgAfter('securePwdVerify', error_not_same_pwd, false, 'repass');
				} else {
					$(this).removeClass('alert');
					$('#repass').remove();
				}
			});

			$('input:not([type="button"])', '#securePwdForm').each(function (i, ele) {
				$(ele).keyup(function () {
					if ($(this).val().length > 0) {
						$(this).addClass('activeElement');
					} else {
						$(this).removeClass('activeElement');
					}
					$.enableButton('nextStep', '#securePwdForm', checkNum);
				});
			});

			$('#secureQue1').change(function () {
				if ($(this).val() != -1) {
					$(this).addClass('activeElement');
				} else {
					$(this).removeClass('activeElement');
				}
				$.enableButton('nextStep', '#securePwdForm', checkNum);
				$('#securityQuestion1').html($(this).find('option:selected').text() + '<span class=downArrow></span>').css({ 'color': '#7D706C', 'font-weight': 'bold' });
			});

			$('#secureQue2').change(function () {
				if ($(this).val() != -1) {
					$(this).addClass('activeElement');
				} else {
					$(this).removeClass('activeElement');
				}
				$.enableButton('nextStep', '#securePwdForm', checkNum);
				$('#securityQuestion2').html($(this).find('option:selected').text() + '<span class=downArrow></span>').css({ 'color': '#7D706C', 'font-weight': 'bold' })
			});

			setTimeout(function () {
				if ('placeholder' in document.createElement('input')) {
					$('#secureName').val("");
					$('#securePwd').val("");
				}
				$('#secureName').removeAttr("style");
			}, $.chromeTimer);

			$('#skipStep').click(function () {
				if ($("#disRemind").is(":checked") == false) {
					location.href = "status.htm";
				} else {
					if ($('#disRemind').prop('checked'))
						$('#hid_disable_remind').val('1');
					else
						$('#hid_disable_remind').val('0');

					$("input[name='submit_flag']").val("secure_pwd_remind");
					$.postForm('#securePwdForm', '', function (json) {
						location.href = "status.htm";
					});
				}
			});

			$('#nextStep').click(function () {
				if (!$.REG_PASSWORD.test($('#securePwd').val())) {
					$('#securePwd').addClass('alert');
					$.addErrMsgAfter('securePwd', pwd_should + " 6-32 " + characters, false, 'repass');
				}

				if ($('#securePwd').val() == "password") {
					$('#securePwd').addClass('alert');
					$.addErrMsgAfter('securePwd', not_password, false, 'repass');
				}
				if (!$.REG_PASSWORD.test($('#securePwdVerify').val())) {
					$('#securePwdVerify').addClass('alert');
					$.addErrMsgAfter('securePwdVerify', pwd_should + " 6-32 " + characters, false, 'repass');
				} else if ($('#securePwd').val() != $('#securePwdVerify').val()) {
					$('#securePwdVerify').addClass('alert');
					$.addErrMsgAfter('securePwdVerify', error_not_same_pwd, false, 'repass');
				}
				if ($('#secureQue1').val() == -1) {
					$.addErrMsgAfter('secureQue1', error_no_question);
				}
				if ($('#secureAn1').val().length == 0) {
					$.addErrMsgAfter('secureAn1', error_no_answer);
				}
				if (!$.REG_ANSWER.test($('#secureAn1').val())) {
					$.addErrMsgAfter('secureAn1', invalid_answer);
				}
				if ($('#secureQue2').val() == -1) {
					$.addErrMsgAfter('secureQue2', error_no_question);
				}
				if ($('#secureAn2').val().length == 0) {
					$.addErrMsgAfter('secureAn2', error_no_answer);
				}
				if (!$.REG_ANSWER.test($('#secureAn2').val())) {
					$.addErrMsgAfter('secureAn2', invalid_answer);
				}

				if ($('#disRemind').prop('checked'))
					$('#hid_disable_remind').val('1');
				else
					$('#hid_disable_remind').val('0');

				if (!$('.errorMsg').length) {
					$.submit_wait('body', $.WAITING_DIV);
					$.postForm('#securePwdForm', '', function (json) {
						if (json.status == '1') {
							$.removeCookie('dsessid');
							$.removeCookie('session');
							location.href = json.url;
						} else {
							$.removeCookie('dsessid');
							$.removeCookie('session');
							$('.running').remove();
							$.alertBox(json.msg);
						}
					});
				}
			});
		}

		/*******************************************************************************************
		* 
		* NEW EXTENDER SETUP page
		*
		*******************************************************************************************/
		if ($('#newExtendSetupForm').length) {
			/*checkNum = 8;
			$('#acceptCheckbox').click( function() {
				if ( $(this).is(':checked') ) {
					$(this).addClass('activeElement');
				} else {
					$(this).removeClass('activeElement');
				}
				$.enableButton('nextStep', '#newExtendSetupForm', checkNum);
			});*/
			checkNum = 7;

			$('.infoIcon.email').click(function () {
				$.alertBox(EXT_STR0844);
			});

			$('.infoIcon.passwd').click(function () {
				$.alertBox(choose_passwd);
			});

			$('.infoIcon.question').click(function () {
				$.alertBox(securityQuestionNote);
			});

			$('#newPwd').blur(function () {
				var pwd = $(this).val();
				$('#newPwd').removeClass('alert');
				$('#repass').remove();
				if ( pwd == '' ) {
					$('#newPwd').addClass('alert');
					$.addErrMsgAfter('newPwd', pwd_should +" 6-32 "+ characters, false, 'repass');
				} else {
					$('.verifyPwd').prop('disabled', false);
				}
			});

			$('#newPwd').keyup(function () {
				var pwd = $(this).val(),
					pwd2 = $('#newPwdVerify').val();
				if (security_enhance_flag == "1") {
					var wait = 1000;
					var timeoutID = null;
					clearTimeout(timeoutID);
					timeoutID = setTimeout(function () { $.validatepassword(pwd); }, wait);
				}

				if (pwd.length > 0) {
					$('#newPwdVerify').prop('disabled', false);
				} else {
					$('#newPwdVerify').prop('disabled', true);
				}
				if (pwd2 != '' && pwd != pwd2) {
					if (!$('#newPwdVerify').hasClass('alert'))
						$('#newPwdVerify').addClass('alert');
					if (!$('#repass').length)
						$.addErrMsgAfter('newPwdVerify', error_not_same_pwd, false, 'repass');
				} else if (pwd == pwd2) {
					$('#newPwdVerify').removeClass('alert');
					$('#repass').remove();
				}

			});

			$('#newPwd').keydown(function () {
				if (security_enhance_flag == "1") {
					$('#pwd_warn').css('display', '');
					$('#passwd_hint').css('display', 'none');
				}
			});

			/*$('#newPwd').focus(function () {
				var pwd = $(this).val();
				$('#newPwdVerify').val('').removeClass('alert').removeClass('activeElement');
				$('#repass').remove();
			});*/

			$('#newPwdVerify').keyup(function () {
				var pwd = $('#newPwd').val(),
					pwd2 = $(this).val();
				if ($.trim(pwd) == $.trim(pwd2) && pwd2.length != 0) {
					$(this).removeClass('alert');
					$('#repass').remove();
				}
			});

			$('#newPwdVerify').blur(function () {
				var pwd = $('#newPwd').val(),
					pwd2 = $(this).val();
				$('#repass').remove();
				if ($.trim(pwd) != $.trim(pwd2) && pwd2.length != 0) {
					$(this).addClass('alert');
					$.addErrMsgAfter('newPwdVerify', error_not_same_pwd, false, 'repass');
				} else {
					$(this).removeClass('alert');
					$('#repass').remove();
				}
			});

			$('input:not([type="button"])', '#newExtendSetupForm').each(function (i, ele) {
				$(ele).keyup(function () {
					if ($(this).val().length > 0) {
						$(this).addClass('activeElement');
					} else {
						$(this).removeClass('activeElement');
					}
					$.enableButton('nextStep', '#newExtendSetupForm', checkNum);
				});
			});

			$('#newUserName').change(function () {
				var str = $('#newUserName').val();
				if ($.trim(str).length > 0) {
					$(this).addClass('activeElement');
					if ($.REG_EMAIL.test(str)) {
						$(this).removeClass('alert');
						$('#err_email').remove();
					}
				} else {
					$(this).removeClass('activeElement');
				}
				$.enableButton('nextStep', '#newExtendSetupForm', checkNum);
			});
			$('#newUserName').trigger('change');

			$('#newUserName').blur(function () {
				var str = $('#newUserName').val();
				$('#err_email').remove();
				if (!$.REG_EMAIL.test(str) && str.length != 0) {
					$(this).addClass('alert');
					$.addErrMsgAfter('newUserName', invalid_emaill, false, 'err_email');
				} else {
					$(this).removeClass('alert');
				}
			});

			$('#newUserName').keyup(function () {
				var str = $('#newUserName').val();
				if ($.trim(str).length > 0) {
					$(this).addClass("activeElement");
					if ($.REG_EMAIL.test(str)) {
						$(this).removeClass('alert');
						$('#err_email').remove();
					}
				} else {
					$(this).removeClass("activeElement");
				}
				$.enableButton('nextStep', '#newExtendSetupForm', checkNum);
			});

			$('#newPwd').change(function () {
				if (security_enhance_flag != "1") {
					if ($(this).val().length > 0) {
						$(this).addClass('activeElement');
						$('#newPwdVerify').prop('disabled', false);
						if ($.REG_PASSWORD.test($('#newPwd').val())) {
							$(this).removeClass('alert');
							$('#repass').remove();
						}
					} else {
						$(this).removeClass('activeElement');
						$('#newPwdVerify').prop('disabled', true);
					}
					$.enableButton('nextStep', '#newExtendSetupForm', checkNum);
				}
			});
			$('#newPwd').trigger('change');

			$('#newPwd').blur(function () {
				if (security_enhance_flag != "1") {
					$('#repass').remove();
					if (!$.REG_PASSWORD.test($('#newPwd').val()) && ($.REG_PASSWORD.test($('#newPwd').val())).length != 0) {
						$(this).addClass('alert');
						$.addErrMsgAfter('newPwd', pwd_should + " 6-32 " + characters, false, 'repass');
					} else {
						$(this).removeClass('alert');
					}
				}
			});
			$('#newPwd').keyup(function () {
				if (security_enhance_flag != "1") {
					if ($(this).val().length > 0) {
						$(this).addClass('activeElement');
						$('#newPwdVerify').prop('disabled', false);
						if (!$.REG_PASSWORD.test($('#newPwd').val())) {
							$(this).removeClass('alert');
							$('#repass').remove();
						}
					} else {
						$(this).removeClass('activeElement');
						$('#newPwdVerify').prop('disabled', true);
					}
					$.enableButton('nextStep', '#newExtendSetupForm', checkNum);
				}
			});
			/*$('body').mouseover( function() {
				$('#newPwd').trigger('change');
			});*/

			//for fix bug 64793-cannot choose first question on page.(so can trigger "change" function of #que1 and #que2)
			var cf = document.forms["newExtendSetupForm"];
			cf.question1.selectedIndex = 15;
			cf.question2.selectedIndex = 15;

			$('#que1').change(function () {
				if ($(this).val() != -1) {
					$(this).addClass('activeElement');
				} else {
					$(this).removeClass('activeElement');
				}
				$.enableButton('nextStep', '#newExtendSetupForm', checkNum);
				$('#securityQuestion1').html($(this).find('option:selected').text() + '<span class=downArrow></span>').css({ 'color': '#7D706C', 'font-weight': 'bold' });
			});

			$('#que2').change(function () {
				if ($(this).val() != -1) {
					$(this).addClass('activeElement');
				} else {
					$(this).removeClass('activeElement');
				}
				$.enableButton('nextStep', '#newExtendSetupForm', checkNum);
				$('#securityQuestion2').html($(this).find('option:selected').text() + '<span class=downArrow></span>').css({ 'color': '#7D706C', 'font-weight': 'bold' })
			});

			$('#newUserName').removeClass('activeElement');
			setTimeout(function () {
				if ('placeholder' in document.createElement('input')) {
					$('#newUserName').val("");
					$('#newPwd').val("");
				}
				$('#newUserName').removeAttr("style");
			}, $.chromeTimer);
			$('#nextStep').click(function () {
				if( $.check_running() )
					return;
				$('.errorMsg').remove();
				if (!$.REG_EMAIL.test($('#newUserName').val())) {
					$('#newUserName').addClass('alert');
					$.addErrMsgAfter('newUserName', invalid_emaill, false, 'err_email');
				}
				if (!$.REG_PASSWORD.test($('#newPwd').val())) {
					$('#newPwd').addClass('alert');
					$.addErrMsgAfter('newPwd', pwd_should + " 6-32 " + characters, false, 'repass');
				}
				if ($('#newPwd').val() == "password") {
					$('#newPwd').addClass('alert');
					$.addErrMsgAfter('newPwd', not_password, false, 'repass');
				}
				if (!$.REG_PASSWORD.test($('#newPwdVerify').val())) {
					$('#newPwdVerify').addClass('alert');
					$.addErrMsgAfter('newPwdVerify', pwd_should + " 6-32 " + characters, false, 'repass');
				} else if ($('#newPwd').val() != $('#newPwdVerify').val()) {
					$('#newPwdVerify').addClass('alert');
					$.addErrMsgAfter('newPwdVerify', error_not_same_pwd, false, 'repass');
				}
				if ($('#que1').val() == -1) {
					$.addErrMsgAfter('que1', error_no_question);
				}
				if ($('#ans1').val().length == 0) {
					$.addErrMsgAfter('ans1', error_no_answer);
				}
				if (!$.REG_ANSWER.test($('#ans1').val())) {
					$.addErrMsgAfter('ans1', invalid_answer);
				}
				if ($('#que2').val() == -1) {
					$.addErrMsgAfter('que2', error_no_question);
				}
				if ($('#ans2').val().length == 0) {
					$.addErrMsgAfter('ans2', error_no_answer);
				}
				if (!$.REG_ANSWER.test($('#ans2').val())) {
					$.addErrMsgAfter('ans2', invalid_answer);
				}
				if (!$('.errorMsg').length) {
					$.submit_wait('body', $.WAITING_DIV);
					$.ajax({
						url: $('#newExtendSetupForm').attr("action"),
						type: "POST",
						data: $.generatePostData($.param({
							"submit_flag": "register",
							"new_username": $.base64.encode($('#newUserName').val()),
							"new_pwd": $.base64.encode($('#newPwd').val()),
							"verify_pwd": $.base64.encode($('#newPwdVerify').val()),
							"question1": $('#que1').val(),
							"question2": $('#que2').val(),
							"answer1": $('#ans1').val(),
							"answer2": $('#ans2').val(),
							"anticsrf": csrfToken
						})),
						dataType: 'json',
						contentType: "application/x-www-form-urlencoded; charset=utf-8",
						success: function (json) {
							if (json.status == '1') {
								location.href = json.url;
							} else {
								$('.running').remove();
								$.alertBox(json.msg);
							}
						}
					});
				}
			});
		}

		if ($('#multiLoginForm').length) {
			$('#nextStep').click(function () {
				$.submit_wait('body', $.WAITING_DIV);
				$.postForm('#multiLoginForm', '', function (json) {
					location.href = json.url;
				});
			});
		}

	}); // end ready function

}(jQuery));
