(function ($) {
	"use strict";


	$(function () {
		/*******************************************************************************************
		 *
		 * init  page
		 *
		 *******************************************************************************************/
		function show_schedules() {
			$.update_addBt_state();
			scheduledDays.trigger('change');
			$('#schListDiv').find('tbody').empty();
			var i;
			for (i = 0; i < led_schedule_num; i++) {
				var item = led_schedule_array[i],
					array = item.split('-');
				var row = "<tr>";
				row += "<td><span class='tdLabel'>" + from_mark + "</span>" + get_time(array[0]) + "</td>";
				row += "<td><span class='tdLabel'>" + to_mark + "</span>" + get_time(array[1]) + "</td>";
				row += "<td><span class='tdLabel'>" + days + "</span>" + get_days(array[2]) + "</td>";
				row += "<td><span class='tdLabel'>light_brightness</span>" + array[3] + "% </td>";
				row += "<td class='editAction'><span class='tdLabel'>" + del_mark;
				row += "</span><a class='cancelDevice'><i class='dnintg-cancel' id='del" + (i + 1) + "'></i></a></td>";
				row += "</tr>";
				$('#schListDiv').find('tbody').append(row);
				$('#del' + (i + 1)).click(function () {
					if (!led_schedule_enabled) {
						return;
					}
					$('input[name=submit_flag]', '#ledForm').val('del_led_schedule');
					var num = $(this).attr('id').split("del")[1];
					$('#hid_del_item').val(num);
					$.submit_wait('.main:first', $.PAGE_WAITING_DIV);
					$.postForm('#ledForm', '', function (json) {
						if (json.status == '1') {
							$.refresh_schedules();
						} else {
							$('.running').remove();
							$.alertBox(json.msg, '', $.refresh_schedules);
						}
					});
				});
			}
			if (led_schedule_num > 10) {
				$('#schListDiv').addClass('limitSchHeight');
			} else {
				$('#schListDiv').removeClass('limitSchHeight');
			}
		};
		function checkTimeFromTo(id, from_time, to_time) {
			var isValid = true;
			from_time = parseInt(from_time, 10);
			to_time = parseInt(to_time, 10);
			if (isNaN(from_time) || from_time < 0 || from_time > 48
				|| isNaN(to_time) || to_time < 0 || to_time > 48) {
				$.addErrMsgAfter(id, invalid_time_sel);
				isValid = false;
			} else if (0 == from_time || 0 == to_time) {
				isValid = true;
			} else if (from_time == to_time) {
				$.addErrMsgAfter(id, same_time);
				isValid = false;
			} else if (from_time > to_time) {
				$.addErrMsgAfter(id, led_tm_err1);
				isValid = false;
			}
			return isValid;
		};
		function checkTimeDuplicated(id, str) {
			var isValid = true;
			if ($.inArray(str, led_schedule_array) != -1) {
				$.addErrMsgAfter(id, service_rule_dup);
				isValid = false;
			}
			return isValid;
		};
		function checkTimeOverlapped(id, str) {
			var arr = str.split("-"),
				cur_from = time2numHash[arr[0]],
				cur_to = time2numHash[arr[1]],
				cur_day = arr[2],
				cur_day_arr = cur_day.split(","),
				arr2, from, to, day, day_arr, sameDay,
				isValid = true;
			for (var j = 0; j < led_schedule_num; j++) {
				arr2 = led_schedule_array[j].split("-");
				day = arr2[2];
				day_arr = day.split(",");
				sameDay = 'Daily' == day || 'Daily' == cur_day;
				if (!sameDay) {
					for (var i = 0; i < cur_day_arr.length; i++) {
						if ($.inArray(cur_day_arr[i], day_arr) != -1) {
							sameDay = true;
							break;
						}
					}
				}
				if (sameDay) {
					from = time2numHash[arr2[0]];
					to = time2numHash[arr2[1]];
					if (cur_from < to && cur_to > from) {
						$.addErrMsgAfter(id, led_confilct);
						isValid = false;
						break;
					}
				}
			}
			return isValid;
		};
		var timeHash = {},
			timeHash2 = {},
			time2numHash = {};
		function generateTimeHash() {
			timeHash = {};
			timeHash2 = {};
			time2numHash = {};
			var hour, minutes, time = 0, time2 = 12 * 3600;
			for (var j = 0; j < 48; j++) {
				hour = parseInt(time / 3600) < 10 ? '0' + parseInt(time / 3600) : parseInt(time / 3600);
				minutes = (time % 3600) / 60 < 10 ? '0' + (time % 3600) / 60 : (time % 3600) / 60;
				time += 30 * 60;
				timeHash[j] = hour + ':' + minutes;
				time2numHash[hour + ':' + minutes] = j;

				hour = parseInt(time2 / 3600) < 10 ? '0' + parseInt(time2 / 3600) : parseInt(time2 / 3600);
				minutes = (time2 % 3600) / 60 < 10 ? '0' + (time2 % 3600) / 60 : (time2 % 3600) / 60;
				if (j < 24)
					timeHash2[j] = +hour + ':' + minutes + am_mark;
				else
					timeHash2[j] = +hour + ':' + minutes + pm_mark;
				time2 += 30 * 60;
				if (time2 >= 13 * 3600)
					time2 -= 12 * 3600;
			}
			time2numHash['24:00'] = 48;
			timeHash[48] = '24:00';
			timeHash2[48] = '12:00' + am_mark;
		};
		generateTimeHash();

		function get_time(str) {
			if (!str) {
				return '--';
			}
			if (1 == is_europe_region) {
				if (time2numHash[str] != undefined) {
					return str;
				}
				var arr = str.split(':'),
					hour = parseInt(arr[0], 10),
					minute = parseInt(arr[1], 10);
				if (isNaN(hour) || hour <= 0) {
					hour = '00';
				} else if (hour > 0 && hour < 10) {
					hour = '0' + hour;
				} else if (hour > 23) {
					return '24:00';
				}
				if (isNaN(minute) || minute <= 0) {
					minute = '00';
				} else if (minute > 0 && minute < 10) {
					minute = '0' + minute;
				} else if (minute > 59) {
					minute = '59';
				}
				return hour + ':' + minute;
			}
			if (timeHash2[time2numHash[str]]) {
				return timeHash2[time2numHash[str]];
			}
			var arr = str.split(':'),
				hour = parseInt(arr[0], 10),
				minute = parseInt(arr[1], 10),
				mark = am_mark;
			if (isNaN(hour) || hour < 0) {
				hour = '0';
			} else if (hour == 12) {
				mark = pm_mark;
			} else if (hour > 12 && hour <= 23) {
				mark = pm_mark;
				hour -= 12;
			} else if (hour > 23) {
				return '12:00' + am_mark;
			}
			if (isNaN(minute) || minute <= 0) {
				minute = '00';
			} else if (minute > 0 && minute < 10) {
				minute = '0' + minute;
			} else if (minute > 59) {
				minute = '59';
			}
			return hour + ':' + minute + mark;
		};
		function get_days(str) {
			var hash = {};
			var array = (str || '').split(","),
				i = 0,
				num = 0,
				list = [];
			for (i = 0; i < array.length; i++) {
				if (array[i] == "Daily") {
					return everyday;
				}
				num = parseInt(array[i]);
				if (array[i].length == 1 && num >= 0 && num <= 6) {
					hash[array[i]] = true;
				}
			}
			for (var h in hash) {
				list.push(selectdays[h]);
			}
			return list.length == 7 ? everyday : (list.join(", ") || '--');
		};
		if ($('#ledForm').length) {
			$.MAX_RULE = 20;
			$('#saveBt').click(function () {
				if ($.check_running())
					return;
				if ($('#ledOn').is(':checked')) {
					$('#hid_led_on').val("1");
				} else {
					$('#ledOff').prop('checked', true);
					$('#hid_led_on').val("0");
				}
				if (have_location == "1" && confMode == "2") {
					$('#hid_led_light').val($('#led_light').val());
					if ($('#led_schedule_lighting').is(':checked')) {
						$('#hid_led_schedule').val("1");
					} else {
						$('#hid_led_schedule').val("0");
					}
					if ($('#syncOn').is(':checked')) {
						$('#hid_sync_btn').val("1");
					} else {
						$('#syncOff').prop('checked', true);
						$('#hid_sync_btn').val("0");
					}
				}
				$.submit_wait('.main:first', $.PAGE_WAITING_DIV);
				$('input[name=submit_flag]', '#ledForm').val('led');
				$.postForm('#ledForm', '', function (json) {
					if (json.status == "1") {
						if (have_location == "1" && confMode == "2") {
							setTimeout("document.location.reload();", parseInt(json.wait, 10) * 1000);
						} else {
							setTimeout('$(".running").remove();', parseInt(json.wait, 10) * 1000);
						}
					} else {
						$.alertBox(json.msg);
					}
				});
			});
			$('#cancelBt').click(function () {
				if ($.check_running())
					return;
				document.location.reload();
			});
			$('#addBt').click(function () {
				if ($.check_running())
					return;
				if (have_location != "1" && confMode != "2" || !led_schedule_enabled) {
					return;
				}
				if ($(this).prop('disabled') == true) {
					$(this).css({ 'background-color': '#ebebe4' });
					return;
				}
				$('.errorMsg').remove();
				if ((scheduledDays.val() == "1" && everyDay.find(':checkbox:checked').length == 0)
					|| (scheduledDays.val() == "2" && weekDays.find(':checkbox:checked').length == 0)
					|| (scheduledDays.val() == "3" && weekEnd.find(':checkbox:checked').length == 0)) {
					$.alertBox(invalid_noday);
					return false;
				}
				var list = "",
					this_list = "",
					container = null;
				switch (scheduledDays.val()) {
					case '0':
						var from = '0', to = '48';
						if (!$('#allDays').is(':checked')) {
							from = $('#allFromTime').val();
							to = $('#allToTime').val();
							to = '0' == to ? '48' : to;
						}
						list = timeHash[from] + "-" + timeHash[to] + "-Daily";
						list += '-' + $('#all_light').val() + '-Default';
						checkTimeFromTo('allToTime', from, to)
							&& checkTimeDuplicated('allToTime', list)
							&& checkTimeOverlapped('allToTime', list);
						break;
					case '1':
						container = everyDay;
						break;
					case '2':
						container = weekDays;
						break;
					case '3':
						container = weekEnd;
						break;
				}
				if (container != null) {
					if (scheduledTimes.val() == '1') {
						container.find(':checkbox').each(function (i, ele) {
							if (container == weekEnd) {
								i += 5;
							}
							if ($(ele).is(':checked')) {
								var timeSelection = $(ele).parent().parent().find('.timeSelection').first(),
									radio = timeSelection.find('input[type=radio]').first(),
									day = (i + 1) % 7;
								var from = '0', to = '48';
								if (!radio.is(':checked')) {
									from = timeSelection.find('select[name*=_from_time]').first().val();
									to = timeSelection.find('select[name*=_to_time]').first().val();
									to = '0' == to ? '48' : to;
								}
								this_list = timeHash[from] + "-" + timeHash[to] + "-" + day;
								var lightSelection = $(ele).parent().parent().find('.lightSelection').first(),
									selectLight = lightSelection.find('.lightList');
								this_list += '-' + selectLight.val() + '-Default';
								var id = timeSelection.find('select[name*=_to_time]').first().attr("id");
								checkTimeFromTo(id, from, to)
									&& checkTimeDuplicated(id, this_list)
									&& checkTimeOverlapped(id, this_list);
								list += this_list + ';'
							}
						});
						if (list != "")
							list = list.substring(0, list.length - 1);
					} else {
						var from = '0', to = '48';
						if (!$('#allDays').is(':checked')) {
							from = $('#allFromTime').val();
							to = $('#allToTime').val();
							to = '0' == to ? '48' : to;
						}
						list = timeHash[from] + "-" + timeHash[to] + "-";
						if (container.find(':checkbox:checked').length == 7) {
							list += 'Daily';
						} else {
							container.find(':checkbox').each(function (i, ele) {
								if (container == weekEnd) {
									i += 5;
								}
								if ($(ele).is(':checked')) {
									var day = (i + 1) % 7;
									list += day + ",";
								}
							});
							list = list.substring(0, list.length - 1);
						}
						list += '-' + $('#all_light').val() + '-Default';
						checkTimeFromTo('allToTime', from, to)
							&& checkTimeDuplicated('allToTime', list)
							&& checkTimeOverlapped('allToTime', list);
					}
				}
				if (list.split(";").length + led_schedule_num > $.MAX_RULE) {
					$.alertBox(led_max_rules);
					return false;
				}
				if ($('.errorMsg').length || !list)
					return false;
				$('#hid_schedule_list').val(list);
				$.submit_wait('.main:first', $.PAGE_WAITING_DIV);
				$('input[name=submit_flag]', '#ledForm').val('add_led_schedule');
				$.postForm('#ledForm', '', function (json) {
					if (json.status == '1') {
						$.refresh_schedules();
					} else {
						$('.running').remove();
						$.alertBox(json.msg, '', $.refresh_schedules);
					}
				});
			});
			$.update_led_value = function (led_on, led_light, led_light3) {
				var lights = ['100', '75', '50', '25'];
				if (led_on == "1") {
					$('#ledOn').prop('checked', true).trigger('click');
					if ($.inArray(led_light, lights) != -1) {
						$('#led_light').val(led_light);
					} else {
						$('#led_light').val('100');
					}
				} else {
					$('#ledOff').prop('checked', true).trigger('click');
					if ($.inArray(led_light3, lights) != -1) {
						$('#led_light').val(led_light3);
					} else {
						$('#led_light').val('100');
					}
				}
			};
			$.update_addBt_state = function () {
				if (!led_schedule_enabled) {
					$('#addBt').prop('disabled', true).css({ 'background-color': '#ebebe4' });
				} else {
					$('#addBt').prop('disabled', false).css({ 'background-color': '' });
				}
			};
			$.update_led_state = function () {
				if (!led_schedule_enabled) {
					$('#led_schedule_info').show();
					$('#led_schedule_lighting').prop('disabled', true).css({ 'background-color': '#ebebe4' });
				} else {
					$('#led_schedule_info').hide();
					$('#led_schedule_lighting').prop('disabled', false).css({ 'background-color': '' });
				}
				scheduledDays.trigger('change');
				$.update_addBt_state();
			};
			var timeout;
			$.refresh_led_state = function () {
				$.getData('refresh_led_state.aspx', function (json) {
					var led_state = json.led_state,
						update_led_light = '0',
						change_flag = false;
					if ('255' == led_state) {
						update_led_light = '100';
					} else if ('191' == led_state) {
						update_led_light = '75';
					} else if ('127' == led_state) {
						update_led_light = '50';
					} else if ('63' == led_state) {
						update_led_light = '25';
					}
					if (update_led_light == '0') {
						if ($('#ledOn').is(':checked')) {
							$('#hid_led_on').val("0");
							$('#hid_led_light').val('0');
							led_on = '0';
							led_light = '0';
							led_light3 = json.led_light3;
							change_flag = true;
						}
					} else {
						if ($('#ledOff').is(':checked')
							|| ($('#ledOn').is(':checked') && $('#led_light').val() != update_led_light)) {
							change_flag = 1;
							$('#hid_led_on').val("1");
							$('#hid_led_light').val(update_led_light);
							led_on = '1';
							led_light = update_led_light;
							led_light3 = json.led_light3;
							change_flag = true;
						}
					}
					timeout = setTimeout('$.refresh_led_state();', 5 * 1000);
					if (!change_flag) {
						return;
					}
					$('input[name=submit_flag]', '#ledForm').val('refresh_led');
					$.postForm('#ledForm', '', function (json) {
						if (json.status == '1') {
							$.update_led_value(led_on, led_light, led_light3);
						}
					});
				});
			};
			$.refresh_schedules = function () {
				$.getData('refresh_led_schedules.aspx', function (json) {
					led_schedule_array = json.list;
					led_schedule_num = json.list.length;
					show_schedules();
					$('.running').remove();
				});
			};
			if (have_location == "1" && confMode == "2") {
				var selectDays = $('.selectDays'),
					everyDay = selectDays.find('li'),
					allDays = selectDays.find('.alldays'),
					weekDays = selectDays.find('.weekday'),
					weekEnd = selectDays.find('.weekend'),
					selectTimes = $('.timeSelection'),
					scheduledDays = $('#scheduledDays'),
					scheduledTimes = $('#scheduledTimes'),
					timesPerDay = $('.timesPerDay'),
					timeListOptions = document.getElementById("allFromTime").options,
					led_schedule_num = 0,
					led_schedule_array = [];

				$('.timeList').each(function (i, ele) {
					$('<option value="-1"> </option>').appendTo($(ele));
					var j, hour, minutes, time;
					time = (is_europe_region == '1') ? 0 * 3600 : 12 * 3600;
					for (j = 0; j < 48; j++) {
						if (is_europe_region == '1') {
							$('<option value=' + j + '>' + timeHash[j] + '</option>').appendTo($(ele));
						} else {
							$('<option value=' + j + '>' + timeHash2[j] + '</option>').appendTo($(ele));
						}
					}
				});

				$.change_led_state = function () {
					if (!(have_location == "1" && confMode == "2")) {
						return;
					}
					if ($('#ledOn').is(':checked')) {
						$('#hid_led_on').val("1");
					} else {
						$('#ledOff').prop('checked', true);
						$('#hid_led_on').val("0");
					}
					$('#hid_led_light').val($('#led_light').val());
					$('input[name=submit_flag]', '#ledForm').val('change_led_state');
					clearTimeout(timeout);
					$.postForm('#ledForm', '', function (json) {
						timeout = setTimeout('$.refresh_led_state();', 5 * 1000);
						if (json.status == "1") {
							setTimeout('$(".running").remove();', parseInt(json.wait, 10) * 1000);
						} else {
							$.alertBox(json.msg, '', function () { document.location.reload(); });
						}
					});
				};
				$('#led_light').on('change', $.change_led_state);
				$("input[name='onoff']").on('change', $.change_led_state);
				$("input[name='onoff']").on('click', function () {
					if ($('#ledOn').is(':checked')) {
						$('#led_light').prop('disabled', false).css({ 'background-color': '' });
					} else {
						$('#led_light').prop('disabled', true).css({ 'background-color': '#ebebe4' });
					}
				});

				$("input[name='syncOnoff']").on('change', function () {
					if ($('#syncOn').is(':checked')) {
						$('#syncInfo').show();
					} else {
						$('#syncInfo').hide();
					}
				});
				$.day_time_show = function (container, flag) {
					if (flag) {
						container.show();
					} else {
						container.hide();
					}
					if (container.find('.daySelection').length == 0) {
						container.find('.timeSelection').find('input').trigger('change');
						if (flag) {
							container.find('.lightSelection').find('select').prop('disabled', false).css({ 'background-color': '' });
						} else {
							container.find('.lightSelection').find('select').prop('disabled', true).css({ 'background-color': '#ebebe4' });
						}
					} else {
						container.find('.daySelection').find('input').trigger('change');
					}
				};
				scheduledDays.on('change', function () {
					$(this).prop('disabled', false).css({ 'background-color': '' });
					var sche_days = scheduledDays.val(),
						sche_time = scheduledTimes.val();
					if (sche_days == '0') {
						sche_time = '0';
						scheduledTimes.prop('selectedIndex', 0);
						scheduledTimes.prop('disabled', true).css({ 'background-color': '#ebebe4' });
					} else {
						scheduledTimes.prop('disabled', false).css({ 'background-color': '' });
					}
					$.day_time_show(allDays, sche_time == '0');
					$.day_time_show(weekDays, sche_days == '1' || sche_days == '2');
					$.day_time_show(weekEnd, sche_days == '1' || sche_days == '3');
					if (!led_schedule_enabled) {
						$('#scheduleWrap').find('input, select').prop('disabled', true).css({ 'background-color': '#ebebe4' });
					}
				});
				scheduledTimes.on('change', function () { scheduledDays.trigger('change'); });
				// checked eachday to show eachday time
				selectDays.find(':checkbox').each(function (i) {
					$(this).on('change', function () {
						$(this).prop('disabled', false).css({ 'background-color': '' });
						if (scheduledTimes.val() == '1' && this.checked) {
							$(this).parents('li').find('.timeSelection').css('visibility', 'visible');
							$(this).parents('li').find('.lightSelection').css('visibility', 'visible');
							$(this).parents('li').find('.lightSelection').find('select').prop('disabled', false).css({ 'background-color': '' });
						} else {
							$(this).parents('li').find('.timeSelection').css('visibility', 'hidden');
							$(this).parents('li').find('.lightSelection').css('visibility', 'hidden');
							$(this).parents('li').find('.lightSelection').find('select').prop('disabled', true).css({ 'background-color': '#ebebe4' });
						}
						$(this).parents('li').find('.timeSelection').find('input').trigger('change');
					});
				});
				// checed eachday time radio > 24H / From
				$('.selectTimesForDay').on('change', function () {
					$(this).prop('disabled', false).css({ 'background-color': '' });
					if ($(this).is(':checked')) {
						$(this).parents('li').find('.timeList').prop('disabled', false).css({ 'background-color': '' });
					}
				});
				$('.allDay').on('change', function () {
					$(this).prop('disabled', false).css({ 'background-color': '' });
					if ($(this).is(':checked')) {
						$(this).parents('li').find('.timeList').prop('disabled', true).css({ 'background-color': '#ebebe4' });
						$(this).parents('li').find('.timeList').prop('disabled', false);
					}
				});

				$('.timeList').on('mousedown', function () {
					$(this).prop('disabled', false).css({ 'background-color': '' });
					$(this).parents('li').find('.selectTimesForDay').prop('checked', true);
					$(this).parents('li').find('.selectTimesForDay').trigger('change');
				});

				// Initial
				$('#location_content').show();
				$.update_led_value(led_on, led_light, led_light3);

				$('#led_schedule_lighting').prop('checked', led_schedule == "1");

				scheduledDays.trigger('change');
				$("input[name='syncOnoff']").trigger('change');
				$.update_led_state();
				$.refresh_schedules();
				timeout = setTimeout('$.refresh_led_state();', 5 * 1000);
				if (('0' == link_status || !link_status) && ('0' == link_status_5g || !link_status_5g)) {
					$("input[name='onoff']").prop('disabled', true).css({ 'background-color': '#ebebe4' });
					$('#led_light').prop('disabled', true).css({ 'background-color': '#ebebe4' });
				}
			}
		}
	}); // end ready function

}(jQuery));
