/**
 * For FastLane Settings page
 */
(function ($) {

	"use strict";
	
	var checkNum = 0;
	
	$(function () {
		/*******************************************************************************************
		*
		*	FastLane Settings page
		*
		******************************************************************************************/
		$.checkMode = function() {
			var current_value;
			if ( $('#fl').is(":checked") ) {
				$('#fl2G').prop('disabled', false);
				$('#fl5G').prop('disabled', false);

				if ( $('#fl5G').is(":checked") )
					current_value = "2";
				else {
					$('#fl2G').attr('checked', 'checked');
					current_value = "1";
				}
			} else if ( $('#flBasic').is(":checked") ) {
				current_value = "0";
				$('#fl2G').prop('disabled', true);
				$('#fl5G').prop('disabled', true);
			} else {
				current_value = "3";
			}

			if ( current_value == $("#save_status").val() ) {
				$('#saveBt').prop('disabled', true);
			} else {
				$('#saveBt').removeAttr('disabled');
			}
		};

		if ($('#fastLaneForm').length) {

			if ( confMode == "0" ) { //Access Point
				$('#fl').parents('ul').find('.secondaryOptions').hide();
				$('#flBasic').removeAttr('checked');
				$('#flBasic').prop('disabled', true);
				$('#fl').removeAttr('checked');
				$('#fl').prop('disabled', true);
			} else { //Extender
				if ( apMode == "1" ) {//FastLane
					$('#fl').parents('ul').find('.secondaryOptions').show();
					$('#fl').attr('checked', 'checked');
					if ( apBand == "5G" ) {
						$('#fl5G').attr('checked', 'checked');
						$('#save_status').val("2");
					} else {
						$('#fl2G').attr('checked', 'checked');
						$('#save_status').val("1");
					}
				} else if ( apMode == "0" ) { //Surfing
					$('#fl').parents('ul').find('.secondaryOptions').hide();
					$('#flBasic').attr('checked', 'checked');
					$('#save_status').val("0");
				} else {
					$('#fl').parents('ul').find('.secondaryOptions').hide();
					$('#save_status').val("3");
				}
			}

			$.checkMode();

			$('.btn.secondary').click(function() {
				top.location.href = "fastLane.htm" + $.ID_2;
			});

			$('.btn.primary').click(function(){
				$('.errorMsg').remove();

				if ( $('#flBasic').is(":checked") )
					$('#fastlane_surfing_type').val("0");
				else {
					$('#fastlane_surfing_type').val("1");
					if ( $('#fl2G').is(":checked") )
						$('#furfing_mode_type').val("2.4G");
					else
						$('#furfing_mode_type').val("5G");
				}

				if ( !$('.errorMsg').length ) {
					$.submit_wait('.main:first', $.PAGE_APPLYING_DIV);
					$.postForm('#fastLaneForm', '', function(json) {
						if ( json.status == '1' ) {
							var time = parseInt(json.wait) * 1000;
							setTimeout(function() {
								location.href = json.url + $.ID_2;
							}, time);
						} else {
							$(".running").remove();
							$.alertBox(json.msg);
						}
					});
				}
			});
		}
	}); // end ready function

}(jQuery));
