/**
 * For Connected Devices page.
 **/
(function ($) {

	"use strict";

	var checkNum = 0;
	var thisSegment = "";
	var checkDev = new Array();
	var name_ssid = new Array();
	var ip_address = new Array();
	var mac_address = new Array();
	var vmac_address = new Array();
	var checkDev_guest = new Array();
	var name_ssid_guest = new Array();
	var ip_address_guest = new Array();
	var mac_address_guest = new Array();
	var vmac_address_guest = new Array();
	var number = 0;
	var number_guest = 0;
	var count = 0;
	var count_guest = 0;

	$.MAX_ACL_NUM = 64;

	$(function () {
		/*******************************************************************************************
		*
		*       Connected Devices page
		*
		******************************************************************************************/

		$.checkBoxs = function (id) {
			if ($('#' + id).is(':checked') == true) {
				$('#' + id).prop('checked', true);
				$('#' + id).addClass('checked');
			} else {
				$('#' + id).prop('checked', false);
				$('#' + id).removeClass('checked');
			}
		}

		$.refreshAttachedDevices = function () {
			if (!$('.running').length) {
				$.submit_wait('.main:first', $.PAGE_WAITING_DIV);
			}
			$.getData("update_dev.aspx", function (json) {
				if (json.status == "1") {
					$.getData2("refresh_dev.aspx", function (json) {
						var newRow = "",
							i = 0,
							ip;
						accessCtrlOn = json.acl_on;
						if (accessCtrlOn == "0") {
							$('#wifiTable').addClass("disAcl");
							$('#accessControl').prop('checked', false);
							$('#deny_mark').hide();
						} else {
							$('#wifiTable').removeClass("disAcl");
							$('#accessControl').prop('checked', true);
							$('#deny_mark').show();
						}

						if ("1" == have_guest_network) {
							accessCtrlOn_guest = json.acl_on_guest;
							if (accessCtrlOn_guest == "0") {
								$('#guestWifiTable').addClass("disAcl");
								$('#accessControlGuest').prop('checked', false);
								$('#deny_mark_guest').hide();
							} else {
								$('#guestWifiTable').removeClass("disAcl");
								$('#accessControlGuest').prop('checked', true);
								$('#deny_mark_guest').show();
							}
						}

						$('tbody', '#extenderTable').html("");
						if ((json.extender || []).length > 0) {
							for (i = 0; i < json.extender.length; i++) {
								newRow = '<tr>';
								newRow += '<td><span class="tdLabel">' + lan_mark_ip + '</span>' + json.extender[i].ip + '</td>';
								newRow += '<td><span class="tdLabel">' + lan_mark_name + '</span>' + $.xss_ssid_format(json.extender[i].name) + '</td>';
								newRow += '<td><span class="tdLabel">' + qos_mac + '</span>' + json.extender[i].mac.toUpperCase() + '</td>';
								if (have_virtual_mac != "0" && confMode == "2" && (link_status == "1" || link_status_5g == "1")) {
									newRow += '<td><span class="tdLabel">' + virtual_macaddr + '</span>' + json.extender[i].vmac.toUpperCase() + '</td>';
								}
								newRow += '</tr>';
								$('tbody', '#extenderTable').append(newRow);
							}
						}

						$('tbody', '#guestExtenderTable').html("");
						if ("1" == have_guest_network && (json.extender_guest || []).length > 0) {
							for (i = 0; i < json.extender_guest.length; i++) {
								newRow = '<tr>';
								newRow += '<td><span class="tdLabel">' + lan_mark_ip + '</span>' + json.extender_guest[i].ip + '</td>';
								newRow += '<td><span class="tdLabel">' + lan_mark_name + '</span>' + $.xss_ssid_format(json.extender_guest[i].name) + '</td>';
								newRow += '<td><span class="tdLabel">' + qos_mac + '</span>' + json.extender_guest[i].mac.toUpperCase() + '</td>';
								if (have_virtual_mac != "0" && confMode == "2" && (link_status == "1" || link_status_5g == "1")) {
									newRow += '<td><span class="tdLabel">'+virtual_macaddr+'</span>' + json.extender_guest[i].vmac.toUpperCase() + '</td>';
								}
								newRow += '</tr>';
								$('tbody', '#guestExtenderTable').append(newRow);
							}
						}

						$('tbody', '#wiredTable').html("");
						if ("1" != have_location && (json.wired || []).length > 0) {
							for (i = 0; i < json.wired.length; i++) {
								newRow = '<tr>';
								newRow += '<td><span class="tdLabel">' + lan_mark_ip + '</span>' + json.wired[i].ip + '</td>';
								newRow += '<td><span class="tdLabel">' + lan_mark_name + '</span>' + $.xss_format(json.wired[i].name) + '</td>';
								newRow += '<td><span class="tdLabel">' + qos_mac + '</span>' + json.wired[i].mac.toUpperCase() + '</td>';
								if (have_virtual_mac != "0" && confMode == "2" && (link_status == "1" || link_status_5g == "1")) {
									newRow += '<td><span class="tdLabel">' + virtual_macaddr + '</span>' + json.wired[i].vmac.toUpperCase() + '</td>';
								}
								newRow += '</tr>';
								$('tbody', '#wiredTable').append(newRow);
							}
						}
						$('tbody', '#wifiTable').html("");
						if ((json.wifi || []).length > 0) {
							for (i = 0; i < json.wifi.length; i++) {
								if (json.wifi[i].ip == "") {
									ip = block_mark;
								} else {
									ip = json.wifi[i].ip;
								}
								name_ssid[i] = json.wifi[i].name;
								ip_address[i] = ip;
								mac_address[i] = json.wifi[i].mac.toUpperCase();
								vmac_address[i] = json.wifi[i].vmac.toUpperCase();

								if (accessCtrlOn == "0" && json.wifi[i].ip == "") {
									continue;
								}

								newRow = '<tr>';
								newRow += '<td><span class="tdLabel">' + lan_mark_ip + '</span>' + ip + '</td>';
								newRow += '<td><span class="tdLabel">' + network_name + '</span>' + $.xss_format(json.wifi[i].name) + '</td>';
								newRow += '<td><span class="tdLabel">' + qos_mac + '</span>' + json.wifi[i].mac.toUpperCase() + '</td>';
								if (have_virtual_mac != "0" && confMode == "2" && (link_status == "1" || link_status_5g == "1")) {
									newRow += '<td><span class="tdLabel">' + virtual_macaddr + '</span>' + json.wifi[i].vmac.toUpperCase() + '</td>';
								}
								newRow += '<td><span class="tdLabel">' + info_channel + '</span>' + json.wifi[i].channel + '</td>';
								newRow += '<td><span class="tdLabel">' + signal_strength + '</span>' + json.wifi[i].signal + '</td>';
								newRow += '<td><span class="tdLabel">' + info_link_rate + '</span>' + json.wifi[i].rate + '</td>';
								if (accessCtrlOn == "1") {
									newRow += '<td style="text-align:center;"><span class="tdLabel">' + deny_mark + '</span>';
									if (json.wifi[i].block == "1") {
										newRow += '<input type="checkbox" id="wifiDev' + i + '" onClick="$.checkBoxs(this.id);" class="checked" checked /><label class="wifidev" for="wifiDev' + i + '"></label></td>';
									} else {
										newRow += '<input type="checkbox" id="wifiDev' + i + '" onClick="$.checkBoxs(this.id);" /><label class="wifidev" for="wifiDev' + i + '"></label></td>';
									}
								}
								newRow += '</tr>';
								newRow += '<input type="hidden" name="wifiNewItem' + i + '" id="wifiNewItem' + i + '" value="" />';
								$('tbody', '#wifiTable').append(newRow);
								//$('<input type="hidden" name="wifiNewItem' + i + '" id="wifiNewItem' + i + '" value="" />').appendTo('tbody');

							}
							if ($('tbody', '#wifiTable').find('tr').length > 10) {
								$('#wifiDevicesDiv').addClass('limitDevicesHeight');
							} else {
								$('#wifiDevicesDiv').removeClass('limitDevicesHeight');
							}
							number = json.wifi.length;
						}

						$('tbody', '#guestWifiTable').html("");
						if ("1" == have_guest_network && (json.wifi_guest || []).length > 0) {
							for (i = 0; i < json.wifi_guest.length; i++) {
								if (json.wifi_guest[i].ip == "") {
									ip = block_mark;
								} else {
									ip = json.wifi_guest[i].ip;
								}
								name_ssid_guest[i] = json.wifi_guest[i].name;
								ip_address_guest[i] = ip;
								mac_address_guest[i] = json.wifi_guest[i].mac.toUpperCase();
								vmac_address_guest[i] = json.wifi_guest[i].vmac.toUpperCase();

								if (accessCtrlOn_guest == "0" && json.wifi_guest[i].ip == "") {
									continue;
								}

								newRow = '<tr>';
								newRow += '<td><span class="tdLabel">' + lan_mark_ip + '</span>' + ip + '</td>';
								newRow += '<td><span class="tdLabel">' + lan_mark_name + '</span>' + $.xss_format(json.wifi_guest[i].name) + '</td>';
								newRow += '<td><span class="tdLabel">' + qos_mac + '</span>' + json.wifi_guest[i].mac.toUpperCase() + '</td>';
								if (have_virtual_mac != "0" && confMode == "2" && (link_status == "1" || link_status_5g == "1")) {
									newRow += '<td><span class="tdLabel">'+virtual_macaddr+'</span>' + json.wifi_guest[i].vmac.toUpperCase() + '</td>';
								}
								newRow += '<td><span class="tdLabel">' + info_channel + '</span>' + json.wifi_guest[i].channel + '</td>';
								newRow += '<td><span class="tdLabel">' + signal_strength + '</span>' + json.wifi_guest[i].signal + '</td>';
								newRow += '<td><span class="tdLabel">' + info_link_rate + '</span>' + json.wifi_guest[i].rate + '</td>';
								if (accessCtrlOn_guest == "1") {
									newRow += '<td style="text-align:center;"><span class="tdLabel">' + deny_mark + '</span>';
									if (json.wifi_guest[i].block == "1") {
										newRow += '<input type="checkbox" id="wifiGuestDev' + i + '" onClick="$.checkBoxs(this.id);" class="checked" checked /><label class="wifidev" for="wifiGuestDev' + i + '"></label></td>';
									} else {
										newRow += '<input type="checkbox" id="wifiGuestDev' + i + '" onClick="$.checkBoxs(this.id);" /><label class="wifidev" for="wifiGuestDev' + i + '"></label></td>';
									}
								}
								newRow += '</tr>';
								newRow += '<input type="hidden" name="wifiNewItemGuest' + i + '" id="wifiNewItemGuest' + i + '" value="" />';
								$('tbody', '#guestWifiTable').append(newRow);
								//$('<input type="hidden" name="wifiNewItemGuest' + i + '" id="wifiNewItemGuest' + i + '" value="" />').appendTo('tbody');

							}
							if ($('tbody', '#guestWifiTable').find('tr').length > 10) {
								$('#wifiGuestDevicesDiv').addClass('limitDevicesHeight');
							} else {
								$('#wifiGuestDevicesDiv').removeClass('limitDevicesHeight');
							}
							number_guest = json.wifi_guest.length;
						}

						$('.running').remove();
					}, function () { setTimeout(function () { $('.running').remove(); }, 3 * 1000); });
				}
			});
		}
		$.checkSaveBtn = function () {
			var is_enabled = $('#accessControl').is(':checked') || ("1" == have_guest_network && $('#accessControlGuest').is(':checked'));
			$('#saveBt').prop('disabled', !is_enabled);
		};

		if ($('#connectDevicesForm').length) {
			if ("1" == have_location) {
				$('#wiredInfo').remove();
			}
			$('#accessControl').prop('checked', "1" == accessCtrlOn);

			if ("1" == have_guest_network) {
				$('#accessControlGuest').prop('checked', "1" == accessCtrlOn_guest);
				$('#guestExtenderInfo').show();
				$('#guestWifiInfo').show();
				$('#no_guest').remove();
			} else {
				$('#guestExtenderInfo').remove();
				$('#guestWifiInfo').remove();
				$('#have_guest').remove();
			}
			$.checkSaveBtn();

			$('#accessControl').change(function () {
				$('#accessCtrlToggle').val($('#accessControl').is(':checked') ? '1' : '0');
				$('#accessCtrlToggleGuest').val($('#accessControlGuest').is(':checked') ? '1' : '0');
				$.checkSaveBtn();
				$.submit_wait('.main:first', $.PAGE_WAITING_DIV);
				$('input[name=submit_flag]', '#connectDevicesForm').val("wlacl_ctl");
				$.postForm('#connectDevicesForm', '', function (json) {
					if (json.status == '1') {
						setTimeout(function () {
							$.refreshAttachedDevices();
						}, parseInt(json.wait, 10) * 1000);
					} else {
						$('.running').remove();
						$.alertBox(json.msg);
					}
				});
			});

			$('#accessControlGuest').change(function () {
				if ("1" != have_guest_network) return;
				$('#accessCtrlToggleGuest').val($('#accessControlGuest').is(':checked') ? '1' : '0');
				$('#accessCtrlToggle').val($('#accessControl').is(':checked') ? '1' : '0');
				$.checkSaveBtn();
				$.submit_wait('.main:first', $.PAGE_WAITING_DIV);
				$('input[name=submit_flag]', '#connectDevicesForm').val("wlacl_ctl_guest");
				$.postForm('#connectDevicesForm', '', function (json) {
					if (json.status == '1') {
						setTimeout(function () {
							$.refreshAttachedDevices();
						}, parseInt(json.wait, 10) * 1000);
					} else {
						$('.running').remove();
						$.alertBox(json.msg);
					}
				});
			});

			$('#cancelBt').click(function () {
				if ($.check_running()) return;
				top.location.href = "connectDevices.htm" + $.ID_2;
			});

			$('#saveBt').click(function () {
				if ($.check_running()) return;
				$('.errorMsg').remove();
				if (wps_progress_status == "2") {
					$.alertBox(wps_in_progress);
					return false;
				}
				$('#devTotalNum').val(number);
				for (var i = 0; i < $('#devTotalNum').val(); i++) {
					if ($('#wifiDev' + i).prop('checked')) {
						checkDev[i] = 1;
						count++;
					} else {
						checkDev[i] = 0;
					}
					$('#wifiNewItem' + i).val(checkDev[i] + ' ' + mac_address[i] + ' ' + name_ssid[i].replace(/ /g, '&nbsp;'));
				}
				if (count >= 64) {
					$.addErrMsgAfter('err_msg', acl_length_64);
					return false;
				}

				if ("1" == have_guest_network) {
					$('#devTotalNumGuest').val(number_guest);
					for (var i = 0; i < $('#devTotalNumGuest').val(); i++) {
						if ($('#wifiGuestDev' + i).prop('checked')) {
							checkDev_guest[i] = 1;
							count_guest++;
						} else {
							checkDev_guest[i] = 0;
						}
						$('#wifiNewItemGuest' + i).val(checkDev_guest[i] + ' ' + mac_address_guest[i] + ' ' + name_ssid_guest[i]);
					}
					if (count_guest >= 64) {
						$.addErrMsgAfter('err_msg', acl_length_64);
						return false;
					}
				}


				if (!$('.errorMsg').length) {
					$.submit_wait('.main:first', $.PAGE_WAITING_DIV);
					$('input[name=submit_flag]', '#connectDevicesForm').val("wifi_devices");
					$.postForm('#connectDevicesForm', '', function (json) {
						if (json.status == '1') {
							setTimeout(function () {
								$.refreshAttachedDevices();
							}, parseInt(json.wait, 10) * 1000);
						} else {
							$('.running').remove();
							$.alertBox(json.msg);
						}
					});
				}
			});
			$.refreshAttachedDevices();
		}

		/*******************************************************************************************
                *
                *    support own style of checkbox.
                *
                *******************************************************************************************/
		$('body').find(':checkbox').each(function () {
			if ($(this).is(':checked')) {
				$(this).addClass('checked');
			} else {
				$(this).removeClass('checked');
			}
		});
	});
}(jQuery));
