/**
 * For backup Settings page
 */
(function ($) {

	"use strict";

	$(function () {
		/*******************************************************************************************
		 * 
		 * init  page
		 *
		 *******************************************************************************************/
		if ( $('#backupForm').length ) {
			if ($('#backupBt').length) {
				$('#backupForm').attr("action", '/backup.cgi?submit_url=backUpSettings.htm&timestamp='+ ts );
				$('#backupBt').click(function() {
					$('#backupForm').submit();
				});
			}
		}
		if ( $('#restoreForm').length ) {
			if ($('#restoreFile_file').length) {
				$('#restoreFile_file').on('change', function () {
					if ($.check_filesize(this, 4, 'M'))
						$('#restoreBt').prop("disabled", false);
					else
						$('#restoreBt').prop("disabled", true);
				});
			}

			if ($('#restoreYesBt').length ) {
				$('#restoreForm').attr("action", '/restore.cgi?submit_url=backUpSettingsUpdate.htm&timestamp='+ ts + $.ID_1);
				$('#restoreYesBt').click(function() {
					$('#restoreForm').submit();
				});
			}
			if ($('#restoreNoBt').length ) {
				$('#restoreNoBt').click(function() {
					$('#restoreNote').hide();
					$('input[type=text]', '.fileInputWidget').val("");
					$('input[type=file]', '.fileInputWidget').val("");
					$('#restoreBt').prop("disabled", true);
					$('.backupSettingsOptions').show();
				});
			}
			$('#restoreBt').click(function() {
				$('.backupSettingsOptions').hide();
				$('#restoreNote').show();
				window.scroll(0,0);
			});
		}

		if ( $('#resetYesBt').length ) {
			$('#resetYesBt').click(function() {
				$.submit_wait('body', $.UPDATEING_DIV);
				$.postForm('#resetForm', '', function(json) {
					$.removeCookie('interim');
					setTimeout('$.processing( 0, '+$.REBOOT_TIME +', '+one_wifi+');', 1000 );
				});
			});
		}
		if ( $('#resetNoBt').length ) {
			$('#resetNoBt').click(function() {
				$('#loadingFactory').hide();
				$('.backupSettingsOptions').show();
			});
		}
		$('#resetBt').click(function() {
			$('.backupSettingsOptions').hide();
			$('#loadingFactory').show();
			window.scrollTo(0,0);
		});
		if ($('#okBt').length) {
			$('#okBt').click(function() {
				location.href="backUpSettings.htm"+$.ID_2;
			});
		}

		if ( $('#restartYesBt').length ) {
			$('#restartYesBt').click(function() {
				$.submit_wait('body', $.WAITING_DIV);
				$.postForm('#restartForm', '', function(json) {
					$.removeCookie('interim');
					$.removeCookie('session');
					setTimeout('$.processing( 0, '+$.REBOOT_TIME +', '+one_wifi+');', 1000 );
				});
			});
		}
		if ( $('#restartNoBt').length ) {
			$('#restartNoBt').click(function() {
				$('#restartNote').hide();
				$('.backupSettingsOptions').show();
			});
		}
		$('#restartBt').click(function() {
			$('.backupSettingsOptions').hide();
			$('#restartNote').show();
			window.scrollTo(0,0);
		});

		$.get_status = function() {
			$.getData2('get_restore_status.htm', function(json){
				if (json.restore_status == "1") {
					$(".running").remove();
					$.submit_wait('body', $.WAITING_DIV);
					setTimeout("$.get_status();", 2 * 1000);
				} else if (json.restore_status == "2") {
					$(".running").remove();
					$('.backupSettingsOptions').hide();
					$('#pageMsg').html(restore_select_correct);
					$('#backupMsg').show();
				} else {
					$(".running").remove();
					$.submit_wait('body', $.UPDATEING_DIV);
					setTimeout('$.processing( 0, ' + $.REBOOT_TIME + ', ' + one_wifi + ');', 1000);
				}
			}, function() {
					$(".running").remove();
					$.submit_wait('body', $.UPDATEING_DIV);
					setTimeout('$.processing( 0, ' + $.REBOOT_TIME + ', ' + one_wifi + ');', 1000);
			});
		}
		if (typeof(restore_status) != 'undefined') {
			if ( restore_status == "2" ) {
				$(".running").remove();
				$('.backupSettingsOptions').hide();
				$('#pageMsg').html(restore_select_correct);
				$('#backupMsg').show();
			} else if ( restore_status == "3" ) {
				$(".running").remove();
				$.submit_wait('body', $.UPDATEING_DIV);
				setTimeout('$.processing( 0, '+$.REBOOT_TIME +', '+one_wifi+');', 1000 );
			} else {
				$.submit_wait('body', $.WAITING_DIV);
				$.get_status();
			}
		}
	}); // end ready function

}(jQuery));
