/**
 * For AP Mode Flow
 */
(function ($) {

	"use strict";

	var checkNum = 0,
		times = 0,
		max = 10;
	var ht20_array = new Array(
		  //0 -> Africa:36-48 52-64 100-112 116-128 132-140
			new Array ( "36", "40", "44", "48" ), //0 -> Africa
			//1 -> Asia:36-48 52-64 100-112 116-128 132-140 149-165
			new Array ( "36", "40", "44", "48", "149", "153", "157", "161", "165" ), //1 -> Asia
			//2 -> Australia:36-48 52-64 100-112 116 132-140 149-165
			new Array ( "36", "40", "44", "48", "52(DFS)", "56(DFS)", "60(DFS)", "64(DFS)", "100(DFS)", "104(DFS)", "108(DFS)", "112(DFS)", "116(DFS)", "132(DFS)", "136(DFS)", "140(DFS)", "149", "153", "157", "161", "165" ), //2 -> Australia
			//3 -> Canada:	 36-48 52-64 100-112 116 132-144 149-165
			  new Array ( "36", "40", "44", "48", "52(DFS)", "56(DFS)", "60(DFS)", "64(DFS)", "100(DFS)", "104(DFS)", "108(DFS)", "112(DFS)", "116(DFS)", "132(DFS)", "136(DFS)", "140(DFS)", "144(DFS)", "149", "153", "157", "161", "165", "169", "173", "177" ), //3 -> Canada
			//4 -> Europe:36-48 52-64 100-112 116-128 132-140
			new Array ( "36", "40", "44", "48", "52(DFS)", "56(DFS)", "60(DFS)", "64(DFS)", "100(DFS)", "104(DFS)", "108(DFS)", "112(DFS)", "116(DFS)", "120(DFS)", "124(DFS)", "128(DFS)", "132(DFS)", "136(DFS)", "140(DFS)" ), //4 -> Europe
			//5 -> Israel:36-48 52-64
			new Array ( "36", "40", "44", "48", "52(DFS)", "56(DFS)", "60(DFS)", "64(DFS)" ), //5 -> Israel
			//6 -> Japan:36-48 52-64 100-112 116-128 132-144
			new Array ( "36", "40", "44", "48", "52(DFS)", "56(DFS)", "60(DFS)", "64(DFS)", "100(DFS)", "104(DFS)", "108(DFS)", "112(DFS)", "116(DFS)", "120(DFS)", "124(DFS)", "128(DFS)", "132(DFS)", "136(DFS)", "140(DFS)" ), //6 -> Japan
			//7 -> Korea:36-48 52-64 100-112 116-128 149-165
			new Array ( "36", "40", "44", "48","149", "153", "157", "161" ), //7 -> Korea
			//8 -> Mexico:36-48 52-64 100-112 116 132-140 149-165
			new Array ( "36", "40", "44", "48","149", "153", "157", "161", "165" ), //8 -> Mexico
			//9 -> South America:36-48 52-64 100-112 116-128 132-140 149-165
			new Array ( "36", "40", "44", "48", "149", "153", "157", "161", "165" ), //9 -> South America
			//10 -> North America:36-48 149-165
			  new Array ( "36", "40", "44", "48", "52(DFS)", "56(DFS)", "60(DFS)", "64(DFS)", "100(DFS)", "104(DFS)", "108(DFS)", "112(DFS)", "116(DFS)", "120(DFS)", "124(DFS)", "128(DFS)", "132(DFS)", "136(DFS)", "140(DFS)", "144(DFS)", "149", "153", "157", "161", "165", "169", "173", "177"), //10 -> North America
			//11 -> China:36-48 52-64 149-165
			new Array ("36", "40", "44", "48", "52(DFS)", "56(DFS)", "60(DFS)", "64(DFS)", "149", "153", "157", "161", "165" ), //11 -> China
			//12 -> India:36-48 52-64 149-165
			new Array ( "36", "40", "44", "48","149", "153", "157", "161", "165" ), //12 -> India
			//13 -> Malaysia:36-48 52-64 100-112 116-128 149-165
			new Array ( "36", "40", "44", "48","149", "153", "157", "161", "165" ), //13 -> Malaysia
			//14 -> Middle East (Yemen):
			new Array ( "" ), //14 -> Middle East (Yemen)
			//15 -> Middle East (Qatar):149-165
			new Array ( "149", "153", "157", "161", "165" ), //15 -> Middle East (Qatar)
			//16 -> Middle East(Turkey):36-48 52-64
			new Array ( "36", "40", "44", "48" ), //16 -> Middle East(Kuwait)
			//17 -> Middle East (Saudi Arabia):36-48 52-64 100-112 116-128 132-140 149-165
			new Array ( "36", "40", "44", "48", "149", "153", "157", "161", "165" ), //17 -> Middle East (Saudi Arabia)
			//18 -> Middle East (United Arab Emirates):
			new Array ( "36", "40", "44", "48"), //18 -> Middle East (United Arab Emirates)
			//19 -> Russia:36-48 52-64 132-140 149-165
			new Array ( "36", "40", "44", "48", "52", "56", "60", "64", "132", "136", "140", "149", "153", "157", "161", "165"), //19 -> Russia
			//20 -> Singapore:36-48 52-64 100-112 116-128 132-140 149-165
			new Array ( "36", "40", "44", "48", "149", "153", "157", "161", "165" ), //20 -> Singapore
			//21 -> Taiwan:   36-48 52-64 100-112 116-128 132-144 149-165
			  new Array ("56", "60", "64", "149", "153", "157", "161", "165" ), //21 -> Taiwan
			//22 -> Middle East
			new Array ( "36", "40", "44", "48", "52(DFS)", "56(DFS)", "60(DFS)", "64(DFS)" ), //22 -> Middle East
			//23
			new Array ( "" ),
			//24
			new Array ( "" ),
			//25 -> Hong Kong:   36-48 52-64 100-112 116-128 132-140 149-165
			new Array ("36","40","44","48","52(DFS)","56(DFS)", "60(DFS)", "64(DFS)", "100(DFS)","104(DFS)","108(DFS)","112(DFS)","116(DFS)","120(DFS)","124(DFS)","128(DFS)","132(DFS)","136(DFS)","140(DFS)","149", "153", "157", "161", "165") //25 -> Hong Kong
			);
		var ht40_array = new Array(
		  //0 -> Africa:36-48 52-64 100-112 116-128 132-140
			new Array ( "" ), //0 -> Africa
			//1 -> Asia:36-48 52-64 100-112 116-128 132-140 149-165
			new Array ( "36", "40", "44", "48","149", "153", "157", "161" ), //1 -> Asia
			//2 -> Australia:36-48 52-64 100-112 116 132-140 149-165
			new Array ( "36", "40", "44", "48", "52(DFS)", "56(DFS)", "60(DFS)", "64(DFS)", "100(DFS)", "104(DFS)", "108(DFS)", "112(DFS)", "132(DFS)", "136(DFS)", "149", "153", "157", "161"), //2 -> Australia
			//3 -> Canada:	 36-48 52-64 100-112 116 132-144 149-165
			new Array ( "36", "40", "44", "48", "52(DFS)", "56(DFS)", "60(DFS)", "64(DFS)", "100(DFS)", "104(DFS)", "108(DFS)", "112(DFS)", "132(DFS)", "136(DFS)", "140(DFS)", "144(DFS)", "149", "153", "157", "161", "165", "169", "173", "177" ), //3 -> Canada
			//4 -> Europe:36-48 52-64 100-112 116-128 132-140
			new Array ( "36", "40", "44", "48", "52(DFS)", "56(DFS)", "60(DFS)", "64(DFS)", "100(DFS)", "104(DFS)", "108(DFS)", "112(DFS)", "116(DFS)", "120(DFS)", "124(DFS)", "128(DFS)", "132(DFS)", "136(DFS)" ), //4 -> Europe
			//5 -> Israel:36-48 52-64
			new Array ( "36", "40", "44", "48", "52(DFS)", "56(DFS)", "60(DFS)", "64(DFS)" ), //5 -> Israel
			//6 -> Japan:36-48 52-64 100-112 116-128 132-144
			new Array ( "36", "40", "44", "48", "52(DFS)", "56(DFS)", "60(DFS)", "64(DFS)", "100(DFS)", "104(DFS)", "108(DFS)", "112(DFS)", "116(DFS)", "120(DFS)", "124(DFS)", "128(DFS)", "132(DFS)", "136(DFS)"), //6 -> Japan
			//7 -> Korea:36-48 52-64 100-112 116-128 149-165
			new Array ( "36", "40", "44", "48", "149", "153", "157", "161" ), //7 -> Korea
			//8 -> Mexico:36-48 52-64 100-112 116 132-140 149-165
			new Array ( "36", "40", "44", "48", "149", "153", "157", "161" ), //8 -> Mexico
			//9 -> South America:36-48 52-64 100-112 116-128 132-140 149-165
			new Array ( "36", "40", "44", "48", "149", "153", "157", "161" ), //9 -> South America
			//10 -> North America:36-48 149-165
			  new Array ( "36", "40", "44", "48", "52(DFS)", "56(DFS)", "60(DFS)", "64(DFS)", "100(DFS)", "104(DFS)", "108(DFS)", "112(DFS)", "116(DFS)", "120(DFS)", "124(DFS)", "128(DFS)", "132(DFS)", "136(DFS)", "140(DFS)", "144(DFS)", "149", "153", "157", "161", "165", "169", "173", "177"), //10 -> North America
			//11 -> China:36-48 52-64 149-165
			new Array ("36", "40", "44", "48", "52(DFS)", "56(DFS)", "60(DFS)", "64(DFS)", "149", "153", "157", "161" ), //11 -> China
			//12 -> India:36-48 52-64 149-165
			new Array ( "36", "40", "44", "48", "149", "153", "157", "161" ), //12 -> India
			//13 -> Malaysia:36-48 52-64 100-112 116-128 149-165
			new Array ( "36", "40", "44", "48", "149", "153", "157", "161" ), //13 -> Malaysia
			//14 -> Middle East (Yemen):
			new Array ( "" ), //14 -> Middle East (Yemen)
			//15 -> Middle East (Qatar):149-165
			new Array ( "149", "153", "157", "161" ), //15 -> Middle East (Qatar)
			//16 -> Middle East(Kuwait):36-48 52-64
			new Array ( "" ), //16 -> Middle East(Kuwait)
			//17 -> Middle East (Saudi Arabia):36-48 52-64 100-112 116-128 132-140 149-165
			new Array ( "" ), //17 -> Middle East (Saudi Arabia)
			//18 -> Middle East (United Arab Emirates):
			new Array ( "36", "40", "44", "48"), //18 -> Middle East (United Arab Emirates)
			//19 -> Russia:36-48 52-64 132-140 149-165
			new Array ( "36", "40", "44", "48", "52", "56", "60", "64", "132", "136", "149", "153", "157", "161"), //19 -> Russia
			//20 -> Singapore:36-48 52-64 100-112 116-128 132-140 149-165
			new Array ( "36", "40", "44", "48", "149", "153", "157", "161"), //20 -> Singapore
			//21 -> Taiwan:   36-48 52-64 100-112 116-128
			new Array ("36", "40", "44", "48","52(DFS)", "56(DFS)", "60(DFS)", "64(DFS)","100(DFS)", "104(DFS)", "108(DFS)", "112(DFS)", "116(DFS)", "120(DFS)", "124(DFS)", "128(DFS)", "132(DFS)", "136(DFS)", "140(DFS)", "144(DFS)", "149", "153", "157", "161" ), //21
			//22 -> Middle East
			new Array ( "36", "40", "44", "48", "52(DFS)", "56(DFS)", "60(DFS)", "64(DFS)" ), //22 -> Middle East
			//23
			new Array ( "" ),
			//24
			new Array ( "" ),
			//25 -> Hong Kong:   36-48 52-64 100-112 116-128 132-140 149-165
			new Array ("36","40","44","48","52(DFS)","56(DFS)", "60(DFS)", "64(DFS)", "100(DFS)","104(DFS)","108(DFS)","112(DFS)","116(DFS)","120(DFS)","124(DFS)","128(DFS)","132(DFS)","136(DFS)","149", "153", "157", "161") //25 -> Hong Kong
			);
		var ht80_array = new Array(
		  //0 -> Africa:36-48 52-64 100-112 116-128 132-140
			new Array ( "" ), //0 -> Africa
			//1 -> Asia:36-48 52-64 100-112 116-128 132-140 149-165
			new Array ( "36", "40", "44", "48","149", "153", "157", "161" ), //1 -> Asia
			//2 -> Australia:36-48 52-64 100-112 116 132-140 149-165
			new Array ( "36", "40", "44", "48", "52(DFS)", "56(DFS)", "60(DFS)", "64(DFS)", "100(DFS)", "104(DFS)", "108(DFS)", "112(DFS)", "149", "153", "157", "161"), //2 -> Australia
			//3 -> Canada:	 36-48 52-64 100-112 116 132-144 149-165
			  new Array ( "36", "40", "44", "48", "52(DFS)", "56(DFS)", "60(DFS)", "64(DFS)", "100(DFS)", "104(DFS)", "108(DFS)", "112(DFS)", "149", "153", "157", "161", "165", "169", "173", "177" ), //3 -> Canada
			//4 -> Europe:36-48 52-64 100-112 116-128 132-140
			new Array ( "36", "40", "44", "48", "52(DFS)", "56(DFS)", "60(DFS)", "64(DFS)", "100(DFS)", "104(DFS)", "108(DFS)", "112(DFS)", "116(DFS)", "120(DFS)", "124(DFS)", "128(DFS)" ), //4 -> Europe
			//5 -> Israel:36-48 52-64
			new Array ( "36", "40", "44", "48", "52(DFS)", "56(DFS)", "60(DFS)", "64(DFS)" ), //5 -> Israel
			//6 -> Japan:36-48 52-64 100-112 116-128 132-144
			new Array ( "36", "40", "44", "48", "52(DFS)", "56(DFS)", "60(DFS)", "64(DFS)", "100(DFS)", "104(DFS)", "108(DFS)", "112(DFS)", "116(DFS)", "120(DFS)", "124(DFS)", "128(DFS)"), //6 -> Japan
			//7 -> Korea:36-48 52-64 100-112 116-128 149-165
			new Array ( "36", "40", "44", "48","149", "153", "157", "161" ), //7 -> Korea
			//8 -> Mexico:36-48 52-64 100-112 116 132-140 149-165
			new Array ( "36", "40", "44", "48","149", "153", "157", "161" ), //8 -> Mexico
			//9 -> South America:36-48 52-64 100-112 116-128 132-140 149-165
			new Array ( "36", "40", "44", "48", "149", "153", "157", "161" ), //9 -> South America
			//10 -> North America:36-48 149-165
			  new Array ( "36", "40", "44", "48", "52(DFS)", "56(DFS)", "60(DFS)", "64(DFS)", "100(DFS)", "104(DFS)", "108(DFS)", "112(DFS)", "116(DFS)", "120(DFS)", "124(DFS)", "128(DFS)", "132(DFS)", "136(DFS)", "140(DFS)", "144(DFS)", "149", "153", "157", "161", "165", "169", "173", "177"), //10 -> North America
			//11 -> China:36-48 52-64 149-165
			new Array ("36", "40", "44", "48", "52(DFS)", "56(DFS)", "60(DFS)", "64(DFS)", "149", "153", "157", "161" ), //11 -> China
			//12 -> India:36-48 52-64 149-165
			new Array ( "36", "40", "44", "48", "149", "153", "157", "161" ), //12 -> India
			//13 -> Malaysia:36-48 52-64 100-112 116-128 149-165
			new Array ( "36", "40", "44", "48","149", "153", "157", "161" ), //13 -> Malaysia
			//14 -> Middle East (Yemen):
			new Array ( "" ), //14 -> Middle East (Yemen)
			//15 -> Middle East (Qatar):149-165
			new Array ( "149", "153", "157", "161" ), //15 -> Middle East (Qatar)
			//16 -> Middle East(Turkey):36-48 52-64
			new Array ( "" ), //16 -> Middle East(Turkey)
			//17 -> Middle East (Saudi Arabia):36-48 52-64 100-112 116-128 132-140 149-165
			new Array ( "" ), //17 -> Middle East (Saudi Arabia)
			//18 -> Middle East (United Arab Emirates):
			new Array ( "36", "40", "44", "48" ), //18 -> Middle East (United Arab Emirates)
			//19 -> Russia:36-48 52-64 132-140 149-165
			new Array ( "36", "40", "44", "48", "52", "56", "60", "64", "149", "153", "157", "161"), //19 -> Russia
			//20 -> Singapore:36-48 52-64 100-112 116-128 132-140 149-165
			new Array ( "36", "40", "44", "48", "149", "153", "157", "161"), //20 -> Singapore
			//21 -> Taiwan:   36-48 52-64 100-112 116-128 132-144 149-161
			new Array ("36", "40", "44", "48", "52(DFS)", "56(DFS)", "60(DFS)", "64(DFS)", "100(DFS)", "104(DFS)", "108(DFS)", "112(DFS)", "116(DFS)", "120(DFS)", "124(DFS)", "128(DFS)" ), //21 -> Taiwan
			//22 -> Middle East
			new Array ( "36", "40", "44", "48", "52(DFS)", "56(DFS)", "60(DFS)", "64(DFS)" ), //22 -> Middle East
			//23
			new Array ( "" ),
			//24
			new Array ( "" ),
			//25 -> Hong Kong:   36-48 52-64 100-112 116-128 132-140 149-165
			new Array ("36", "40", "44", "48", "52(DFS)", "56(DFS)", "60(DFS)", "64(DFS)", "100(DFS)", "104(DFS)", "108(DFS)", "112(DFS)", "116(DFS)", "120(DFS)", "124(DFS)", "128(DFS)", "149", "153", "157", "161" ) //25 -> Hong Kong
			);
		  var ht160_array = new Array(
			//0 -> Africa:36-48 52-64 100-112 116-128 132-140
			  new Array ( "" ), //0 -> Africa
			  //1 -> Asia:36-48 52-64 100-112 116-128 132-140 149-165
			  new Array ( "36", "40", "44", "48","149", "153", "157", "161" ), //1 -> Asia
			  //2 -> Australia:36-48 52-64 100-112 116 132-140 149-165
			  new Array ( "36", "40", "44", "48", "52(DFS)", "56(DFS)", "60(DFS)", "64(DFS)"), //2 -> Australia
			  //3 -> Canada:   36-48 52-64 100-112 116 132-144 149-165
			  new Array ( "36", "40", "44", "48", "52(DFS)", "56(DFS)", "60(DFS)", "64(DFS)", "149", "153", "157", "161", "165", "169", "173", "177"), //3 -> Canada
			  //4 -> Europe:36-48 52-64 100-112 116-128 132-140
			  new Array ( "36", "40", "44", "48", "52(DFS)", "56(DFS)", "60(DFS)", "64(DFS)", "100(DFS)", "104(DFS)", "108(DFS)", "112(DFS)", "116(DFS)", "120(DFS)", "124(DFS)", "128(DFS)" ), //4 -> Europe
			  //5 -> Israel:36-48 52-64
			  new Array ( "36", "40", "44", "48", "52(DFS)", "56(DFS)", "60(DFS)", "64(DFS)" ), //5 -> Israel
			  //6 -> Japan:36-48 52-64 100-112 116-128 132-144
			  new Array ( "36", "40", "44", "48", "52(DFS)", "56(DFS)", "60(DFS)", "64(DFS)", "100(DFS)", "104(DFS)", "108(DFS)", "112(DFS)", "116(DFS)", "120(DFS)", "124(DFS)", "128(DFS)"), //6 -> Japan
			  //7 -> Korea:36-48 52-64 100-112 116-128 149-165
			  new Array ( "36", "40", "44", "48","149", "153", "157", "161" ), //7 -> Korea
			  //8 -> Mexico:36-48 52-64 100-112 116 132-140 149-165
			  new Array ( "36", "40", "44", "48","149", "153", "157", "161" ), //8 -> Mexico
			  //9 -> South America:36-48 52-64 100-112 116-128 132-140 149-165
			  new Array ( "36", "40", "44", "48", "149", "153", "157", "161" ), //9 -> South America
			  //10 -> North America:36-48 149-165
			  new Array ( "36", "40", "44", "48", "52(DFS)", "56(DFS)", "60(DFS)", "64(DFS)", "100(DFS)", "104(DFS)", "108(DFS)", "112(DFS)", "116(DFS)", "120(DFS)", "124(DFS)", "128(DFS)", "149", "153", "157", "161", "165", "169", "173", "177"), //10 -> North America
			  //11 -> China:36-48 52-64 149-165
			  new Array ("36", "40", "44", "48", "52(DFS)", "56(DFS)", "60(DFS)", "64(DFS)"), //11 -> China
			  //12 -> India:36-48 52-64 149-165
			  new Array ( "36", "40", "44", "48", "149", "153", "157", "161" ), //12 -> India
			  //13 -> Malaysia:36-48 52-64 100-112 116-128 149-165
			  new Array ( "36", "40", "44", "48","149", "153", "157", "161" ), //13 -> Malaysia
			  //14 -> Middle East (Yemen):
			  new Array ( "" ), //14 -> Middle East (Yemen)
			  //15 -> Middle East (Qatar):149-165
			  new Array ( "149", "153", "157", "161" ), //15 -> Middle East (Qatar)
			  //16 -> Middle East(Turkey):36-48 52-64 
			  new Array ( "" ), //16 -> Middle East(Turkey)
			  //17 -> Middle East (Saudi Arabia):36-48 52-64 100-112 116-128 132-140 149-165
			  new Array ( "" ), //17 -> Middle East (Saudi Arabia)
			  //18 -> Middle East (United Arab Emirates):
			  new Array ( "36", "40", "44", "48" ), //18 -> Middle East (United Arab Emirates)
			  //19 -> Russia:36-48 52-64 132-140 149-165
			  new Array ( "36", "40", "44", "48", "52", "56", "60", "64"), //19 -> Russia
			  //20 -> Singapore:36-48 52-64 100-112 116-128 132-140 149-165
			  new Array ( "36", "40", "44", "48", "149", "153", "157", "161"), //20 -> Singapore
			  //21 -> Taiwan:   36-48 52-64 100-112 116-128 132-144 149-165
			  new Array ("149", "153", "157", "161" ), //21 -> Taiwan
			  //22 -> Middle East
			  new Array ( "36", "40", "44", "48", "52(DFS)", "56(DFS)", "60(DFS)", "64(DFS)"), //22 -> Middle East
			  new Array ( "" ), //23
			  new Array(""), //24
			  new Array ( "36", "40", "44", "48", "52(DFS)", "56(DFS)", "60(DFS)", "64(DFS)", "100(DFS)", "104(DFS)", "108(DFS)", "112(DFS)", "116(DFS)", "120(DFS)", "124(DFS)", "128(DFS)") //25 -> Hong Kong
			  );

	$(function () {
		/*******************************************************************************************
		*
		*       ap access checking
		*
		******************************************************************************************/

		if ($('#accessPointForm').length) {
			var opmode = document.getElementById('opMode');
			opmode.options[0].text = wlan_mode_1;
			opmode.options[1].text = wlan_mode_2;
			opmode.options[2].text = wlan_mode_4;
			//opmode.options[3].text = wlan_mode_4;

            if (!wifi6Enable)
            {
                opmode.options[1].value = "15";
                opmode.options[3].value = "17";
                opmode.options[1].text = "$$wlan_mode_173";
                opmode.options[3].text = "$$wlan_mode_400";
            }

            if(axmodel == "AX1800")
            {
                if (!opmodeSupport400M)
                {
                    $("#opmode option[value='3']").remove();
                }
            }
            else if (axmodel == "AX1600")
            {
                if (!opmodeSupport600M)
                {
                    $("#opmode option[value='3']").remove();
                }
            }
            else if (axmodel == "AX3000" || axmodel == "AX2400")
            {
                if (!opmodeSupport300M)
                {
                    $("#opmode option[value='3']").remove();
                }
            }

			if (have_wireless_an == "1")
			{
				var opmode = document.getElementById('opMode5g');
				opmode.options[0].text = wlan_mode_1;
				opmode.options[1].text = an_wlan_mode_1;
				opmode.options[2].text = an_wlan_mode_2;
				opmode.options[3].text = an_wlan_mode_3;
				if (axmodel == "AX3000" || axmodel == "AX2400")
				{
				    opmode.options[4].text = an_wlan_mode_4;
				}

                if (!wifi6Enable)
                {
                    opmode.options[1].value = "15";
                    opmode.options[2].value = "17";
                    opmode.options[3].value = "18";
                    if (axmodel == "AX3000" || axmodel == "AX2400")
                    {
                        opmode.options[4].value = "19";
                    }
                    opmode.options[1].text = "$$wlan_mode_173";
                    opmode.options[2].text = "$$wlan_mode_400";
                    opmode.options[3].text = "$$wlan_mode_867";
                    if (axmodel == "AX3000" || axmodel == "AX2400")
                    {
                        opmode.options[4].text = "$$wlan_mode_1733";
                    }
                }
		   }
		}

		$.checkingInternet = function () {
			times++;
			$.getData('ca_access_checking_result.htm', function (json) {
				if (json.ap_conn_status.indexOf("0") > -1)
					top.location.href = "ca_access_connect.htm" + $.ID_2;
				else if (json.ap_conn_status.indexOf("1") > -1 || times > max)
					top.location.href = "ca_access_continue.htm" + $.ID_2;
				else if (times < max)
					setTimeout('$.checkingInternet();', 5 * 1000);
			});
		}

		if ($('#apCheckingForm').length) {
			checkNum = 1;
			$('#checking').hide();
			if (lan_status == "0")
				top.location.href = "ca_access_no_connect.htm" + $.ID_2;
			else {
				$('#checking').show();
				setTimeout(function () {
					$.checkingInternet();
				}, 5 * 1000);
			}
		}

		/*******************************************************************************************
		*
		*       access no connect
		*
		******************************************************************************************/
		if ($('#apNoConnectForm').length) {
			checkNum = 2;
			$('#nextStep').click(function () {
				top.location.href = "ca_access_checking.htm" + $.ID_2;
			});
		}

		/*******************************************************************************************
		*
		*       access connect, input security page
		*
		******************************************************************************************/

		$.checkAPInput = function () {
			if ($('#securityOptions').val() != 0) {
				var sec_type = $('#securityOptions').val();
				switch (sec_type) {
					case 'None': //None
						break;
					case 'WEP': //WEP
						var key_obj;
						if (have_wireless_an == "1")
							key_obj = $('.first.access').find('.formElements').find('.key');
						else
							key_obj = $('.key');
						key_obj.each(function (i, ele) {
							var reg = $.REG_KEY_64,
								msg = wep_64;
							if ( $('#wepEnc').val() == '128' ) {
								reg = $.REG_KEY_128;
								msg = wep_128;
							}
							if (($(ele).val() != '' && !reg.test($(ele).val()))
								|| ($(ele).parent().find('input[type=radio]').is(':checked') && !reg.test($(ele).val()))) {
								$.addErrMsgAfter($(ele).attr('id'), msg);
							}
						});
						break;
					case '3': // WPA-PSK [TKIP]
					case 'WPA2-PSK': // WPA2-PSK [AES]
					case 'WPA/WPA2': // WPA-PSK [TKIP] + WPA2-PSK [AES]
					case 'WPA3': // WPA3-Personal
					case 'WPA2/WPA3': // WPA2WPA3-Personal
						if (!$.REG_WPA_PWD.test($('#pwd').val())) {
							$.addErrMsgAfter('pwd', wpa_phrase, false, 'err_pripass');
						}
						break;
					default:
						$.addErrMsgAfter('securityOptions', no_security);
				}
			} else {
				$.addErrMsgAfter('securityOptions', no_security);
			}
		};

		$.checkAPInput5g = function () {
			if ($('#securityOptions5g').val() != 0) {
				var sec_type = $('#securityOptions5g').val();
				switch (sec_type) {
					case 'None': //None
						break;
					case 'WEP': //WEP
						$('.second.access').find('.formElements').find('.key').each(function (i, ele) {
							var reg = $.REG_KEY_64,
								msg = wep_64;
							if ( $('#wepEnc5g').val() == '128' ) {
								reg = $.REG_KEY_128;
								msg = wep_128;
							}
							if (($(ele).val() != '' && !reg.test($(ele).val()))
								|| ($(ele).parent().find('input[type=radio]').is(':checked') && !reg.test($(ele).val()))) {
								$.addErrMsgAfter($(ele).attr('id'), msg);
							}
						});
						break;
					case '3': // WPA-PSK [TKIP]
					case 'WPA2-PSK': // WPA2-PSK [AES]
					case 'WPA/WPA2': // WPA-PSK [TKIP] + WPA2-PSK [AES]
					case 'WPA3': // WPA3-Personal
					case 'WPA2/WPA3': // WPA2WPA3-Personal
						if (!$.REG_WPA_PWD.test($('#pwd5g').val())) {
							$.addErrMsgAfter('pwd5g', wpa_phrase, false, 'err_pripass');
						}
						break;
					default:
						$.addErrMsgAfter('securityOptions5g', no_security);
				}
			} else {
				$.addErrMsgAfter('securityOptions5g', no_security);
			}
		};

		if ($('#securityOptions').length) {
			$('#securityOptions').on('change', function () {
				var thisParent = $(this).parents('.formElements');
				if ($.convertSecTypeToNum($(this).val()) != 0)
					$('.errorMsg').remove();
			if ($.convertSecTypeToNum($(this).val()) > 2) {
					thisParent.find('.wep').slideUp();
					thisParent.find('.wpa').slideDown();
			} else if ($.convertSecTypeToNum($(this).val()) > 1) {
					thisParent.find('.wep').slideDown();
					thisParent.find('.wpa').slideUp();
				} else {
					// hide the password pane
					thisParent.find('.pwdInput').slideUp();
					// reset the password fields
					thisParent.find('.pwdInput').find(':password').val('');
				}
			});
		}

		if ($('#securityOptions5g').length) {
			$('#securityOptions5g').on('change', function () {
				var thisParent = $(this).parents('.formElements');
				if ($.convertSecTypeToNum($(this).val()) != 0)
					$('.errorMsg').remove();
				if ($.convertSecTypeToNum($(this).val()) > 2) {
					thisParent.find('.wep').slideUp();
					thisParent.find('.wpa').slideDown();
				} else if ($(this).val() > 1) {
					thisParent.find('.wep').slideDown();
					thisParent.find('.wpa').slideUp();
				} else {
					// hide the password pane
					thisParent.find('.pwdInput').slideUp();
					// reset the password fields
					thisParent.find('.pwdInput').find(':password').val('');
				}
			});
		}
        $.setAChannel = function(_channel5g)
        {
            var channel = document.getElementById("channel5g");
            var currentMode = document.getElementById("opMode5g").value;
            var option_array = document.getElementById("channel5g").options;
            var chValue = _channel5g;
            var find_value = 0;
            var i, j = 0, val;
            var tmp_array = ht40_array[wl_country];


            if ( 1 == currentMode || 2 == currentMode || 7 == currentMode || 16 == currentMode || 15 == currentMode)
            {
                tmp_array = ht20_array[wl_country];
            }
            else if( 9 == currentMode || 10 == currentMode || 18 == currentMode)
            {
                tmp_array = ht80_array[wl_country];
            }
            else if (19 == currentMode || 20 == currentMode || 21 == currentMode)//21: ax2400 160m
            {
                tmp_array = ht160_array[wl_country];
            }

            channel.options.length = tmp_array.length+1;
            /*
            if ( dfs_channel_router_flag == 1 ) //Australia, Canada, Europe
            {
                channel.options[j].value = 0;
                channel.options[j].text = Auto;
                j++;
            }
            */
            for ( i = 0; i < tmp_array.length; i++ )
            {
                var isHT20Mode = (1 == currentMode || 2 == currentMode || 7 == currentMode || 16 == currentMode || 15 == currentMode);
                if (!isHT20Mode && (axmodel === "AX1800" || axmodel === "AX1600") && (parseInt(tmp_array[i].split('(')[0], 10) >= 165 && parseInt(tmp_array[i].split('(')[0], 10) <= 177)) {
                    continue;
                }
               if (isHT20Mode && (axmodel === "AX1800" || axmodel === "AX1600") && parseInt(tmp_array[i].split('(')[0], 10) > 165 && parseInt(tmp_array[i].split('(')[0], 10) <= 177) {
                   continue;
                }
                if ( 0 == hidden_dfs_channel && ( 1 == dfs_channel_router_flag ||
                ( dfs_channel2_router_flag == 1 &&	wl_country == 4 ) //Australia, Canada, Europe
                ) ) //Japan, United States
                {
                    if(currentMode == 9 && wl_country == 21)//50244
                    if(tmp_array[i] == "60" || tmp_array[i] == "64")
                        continue;
                    //if( index == 17 && (tmp_array[i] == "149" || tmp_array[i] == "153" || //tmp_array[i] == "157" || tmp_array[i] == "161") )//53381
                    //	  continue;
                    if ( tmp_array[i].indexOf("(DFS)") > -1 )
                    {
                        val =  tmp_array[i].split("(DFS)")[0];
                        channel.options[j].value = val;
                        channel.options[j].text = tmp_array[i];
                        j++;
                    }
                    else
                    {
                        channel.options[j].value = channel.options[j].text = tmp_array[i];
                        j++;
                    }
                }
                else
                {
                    if ( tmp_array[i].indexOf("(DFS)") > -1 )
                        continue;
                    if(currentMode == 9 && wl_country == 21)//50244
                        if(tmp_array[i] == "60" || tmp_array[i] == "64")
                            continue;
                            //if( index == 17 && (tmp_array[i] == "149" || tmp_array[i] == "153" || tmp_array[i] == "157" || tmp_array[i] == "161") )//53381
                            //	continue;
                            channel.options[j].value = channel.options[j].text = tmp_array[i];
                            j++;
                }
            }
            channel.options.length = j;

            for(i=0; i<option_array.length; i++)
            {
                if(option_array[i].value == chValue)
                {
                    find_value = 1;
                    channel.selectedIndex = i;
                    break
                }
            }
            if (find_value == 0)
            {/* to fix bug 27403 */
                for(i=0;i<option_array.length;i++)
                {
                    if(option_array[i].value == _channel5g)
                    {
                        find_value = 1;
                        channel.selectedIndex = i;
                        break;
                    }
                }
            }
            if(find_value == 0)
            channel.selectedIndex = 0;
        };

/*
		$.setAPChannel = function () {
			var wChannel = document.getElementById("channel");
			if (wl_country == "8" || wl_country == "10")
				wChannel.options.length = 12;
			else
				wChannel.options.length = 14;
			for (var i = 1; i < wChannel.options.length; i++) {
				wChannel.options[i].value = i;
				wChannel.options[i].text = (i < 10) ? "0" + i : i;
			}
		}

		$.setAPChannel5g = function (from, channel) {
			if (from != 2) {
				$.setAwlan_mode();
			}
			$.setAChannel('channel5g', wl_country, $("#opMode5g").val(), channel);
		}
*/

        $.setAPChannel = function(_channel)
        {
            var wChannel = document.getElementById("channel");
            var optionLen = (wl_country == "3" || wl_country == "10" || wl_country == "8") ? 12 : 14;
            wChannel.options.length = optionLen;
            for(var i=1; i<optionLen; i++)
            {
                wChannel.options[i].value = i;
                wChannel.options[i].text = (i < 10)? "0" + i : i;
            }
            if( !_channel || _channel < 0 || _channel >= optionLen )
            {
                $('#channel').val(0);
            }
            else
            {
                $('#channel').val(_channel);
            }
        }

        $.setAPChannel5g = function(from, channel)
        {
            if (from == 2)
            {
                $.setAChannel(channel);
            }
            else
            {
                $.setAwlan_mode();
                $.setAChannel(channel);
            }
        }

		$.setAwlan_mode = function () {
			if (ac_router_flag == 1) {
				$.setACwlan_mode();
			} else {
				$.setANwlan_mode();
			}
		};

		$.setACwlan_mode = function () {
			var cf = document.forms["accessPointForm"];
			var currentMode = cf.opmode5g.selectedIndex;

			// bug 34916, change index number to region name, make the code easy to read and change.
			if (wl_country == "0" || wl_country == "5" || wl_country == "16" || wl_country == "17") { //Israel,Middle East(Turkey/Egypt/Tunisia/Kuwait) Middle East(Saudi Arabia) Africa
				cf.opmode5g.options.length = 1;
				cf.opmode5g.options[0].text = an_wlan_mode_1;
				cf.opmode5g.options[0].value = "7";
				cf.opmode5g.selectedIndex = 0;
				cf.opmode5g.disabled = true;// bug 34916, grey out mode, this region not support both HT20 and HT40
				$('#opMode5g').css({ 'background-color': '#ebebe4' });
			}
			else if (wl_country == "14") {           // Middle East(Algeria/Syria/Yemen), this country do not support HT20 HT40,grayout channel
				cf.channel5g.selectedIndex = 0;
				cf.opmode5g.selectedIndex = 0;
				cf.channel5g.disabled = true;
				$('#channel5g').css({ 'background-color': '#ebebe4' });
				cf.opmode5g.options.length = 4;
				cf.opmode5g.options[0].text = wlan_mode_1;
				cf.opmode5g.options[1].text = an_wlan_mode_1;
				cf.opmode5g.options[2].text = an_wlan_mode_2;
				cf.opmode5g.options[3].text = an_wlan_mode_3;
				cf.opmode5g.options[0].value = "1";
				cf.opmode5g.options[1].value = "7";
				cf.opmode5g.options[2].value = "8";
				cf.opmode5g.options[3].value = "10";
				cf.opmode5g.disabled = true;// bug 34916, grey out mode, this region not support both HT20 and HT40
				$('#opMode5g').css({ 'background-color': '#ebebe4' });
			}
			else {
			 	if (axmodel == "AX3000" || axmodel == "AX2400")
			 	{
			 	    cf.opmode5g.options.length = 5;
			 	}
			 	else
			 	{
			 	    cf.opmode5g.options.length = 4;
			 	}
				cf.opmode5g.options[0].text = wlan_mode_1;
				cf.opmode5g.options[1].text = an_wlan_mode_1;
				cf.opmode5g.options[2].text = an_wlan_mode_2;
				cf.opmode5g.options[3].text = an_wlan_mode_3;
				if (axmodel == "AX3000" || axmodel == "AX2400")
				{
			 	    cf.opmode5g.options[4].text = an_wlan_mode_4;
				}
				cf.opmode5g.options[0].value = "1";

                if (wifi6Enable)
                {
                    cf.opmode5g.options[1].value = "16";
                    cf.opmode5g.options[2].value = "8";
                    cf.opmode5g.options[3].value = "10";
                    if (axmodel == "AX3000")
                    {
                        cf.opmode5g.options[4].value = "20";
                    }
                    else if (axmodel == "AX2400")
                    {
						cf.opmode5g.options[4].value = "21";
                    }
                    if (axmodel == "AX3000" || axmodel == "AX2400")
                    {
	                    if ( mode5g == '1' )
	                        cf.opmode5g.selectedIndex = 0;
	                    else if ( mode5g == '16' )
	                        cf.opmode5g.selectedIndex = 1;
	                    else if ( mode5g == '8' )
	                        cf.opmode5g.selectedIndex = 2;
	                    else if ( mode5g == '10' )
	                        cf.opmode5g.selectedIndex = 3;
	                    else 
	                        cf.opmode5g.selectedIndex = 4;
					}
                    else
                    {
						if ( mode5g == '1' )
	                        cf.opmode5g.selectedIndex = 0;
	                    else if ( mode5g == '16' )
	                        cf.opmode5g.selectedIndex = 1;
	                    else if ( mode5g == '8' )
	                        cf.opmode5g.selectedIndex = 2;
	                    else 
	                        cf.opmode5g.selectedIndex = 3;
                    }
                }
                else
                {
                    cf.opmode5g.options[1].value = "15";
                    cf.opmode5g.options[2].value = "17";
                    cf.opmode5g.options[3].value = "18";
					if (axmodel == "AX3000" || axmodel == "AX2400")
					{
	                    cf.opmode5g.options[4].value = "19";
					}
					if (axmodel == "AX3000" || axmodel == "AX2400")
					{
	                    if (mode5g == '1')
	                        cf.opmode5g.selectedIndex = 0;
	                    else if (mode5g == '15')
	                        cf.opmode5g.selectedIndex = 1;
	                    else if (mode5g == '17')
	                        cf.opmode5g.selectedIndex = 2;
	                    else if (mode5g == '18')
	                        cf.opmode5g.selectedIndex = 3;
	                    else 
	                        cf.opmode5g.selectedIndex = 4;
					}
					else
					{
						if (mode5g == '1')
							cf.opmode5g.selectedIndex = 0;
						else if (mode5g == '15')
							cf.opmode5g.selectedIndex = 1;
						else if (mode5g == '17')
							cf.opmode5g.selectedIndex = 2;
						else 
							cf.opmode5g.selectedIndex = 4;
					}
               }

				cf.opmode5g.disabled = false;
				$('#opMode5g').css({ 'background-color': '#fff' });
			}
			$('#opMode5g').trigger('change');
		};

		$.setANwlan_mode = function () {
			var cf = document.forms["accessPoiontForm"];
			var currentMode = cf.opmode5g.selectedIndex;

			// bug 34916, change index number to region name, make the code easy to read and change.
			if (wl_country == "0" || wl_country == "5" || wl_country == "16" || wl_country == "17") { //Israel,Middle East(Turkey/Egypt/Tunisia/Kuwait) Middle East(Saudi Arabia) Africa
				cf.opmode5g.options.length = 2;
				cf.opmode5g.options[0].text = an_wlan_mode_1;
				cf.opmode5g.options[1].text = an_wlan_mode_2;
				cf.opmode5g.options[0].value = "1";
				cf.opmode5g.options[1].value = "2";
				cf.opmode5g.selectedIndex = 1;
				cf.opmode5g.disabled = true;// bug 34916, grey out mode, this region not support both HT20 and HT40
				$('#opMode5g').css({ 'background-color': '#ebebe4' });
			}
			else if (wl_country == "14") {               // Middle East(Algeria/Syria/Yemen), this country do not support HT20 HT40,grayout channel
				cf.channel5g.selectedIndex = 0;
				cf.opmode5g.selectedIndex = 0;
				cf.channel5g.disabled = true;
				$('#channel5g').css({ 'background-color': '#ebebe4' });
				cf.opmode5g.options.length = 3;
				cf.opmode5g.options[0].text = an_wlan_mode_1;
				cf.opmode5g.options[1].text = an_wlan_mode_2;
				cf.opmode5g.options[2].text = an_wlan_mode_3;
				cf.opmode5g.options[0].value = "1";
				cf.opmode5g.options[1].value = "2";
				cf.opmode5g.options[2].value = "3";
				cf.opmode5g.disabled = true;// bug 34916, grey out mode, this region not support both HT20 and HT40
				$('#opMode5g').css({ 'background-color': '#ebebe4' });
			}
			else {
				cf.opmode5g.options.length = 3;
				cf.opmode5g.options[0].text = an_wlan_mode_1;
				cf.opmode5g.options[1].text = an_wlan_mode_2;
				cf.opmode5g.options[2].text = an_wlan_mode_3;
				cf.opmode5g.options[0].value = "1";
				cf.opmode5g.options[1].value = "2";
				cf.opmode5g.options[2].value = "3";
				if (mode5g == '1' || mode5g == '7')
					cf.opmode5g.selectedIndex = 0;
				else if (mode5g == '2' || mode5g == '8')
					cf.opmode5g.selectedIndex = 1;
				else // mode_an == '3' '5' '6' '9'
					cf.opmode5g.selectedIndex = 2;
				cf.opmode5g.disabled = false;
				$('#opMode5g').css({ 'background-color': '#fff' });
			}
			$('#opMode5g').trigger('change');
		};

		$.setSecurity = function (num) {
			$('#securityOptions').val(num);

			var wep_obj, wpa_obj;
			if (have_wireless_an == "1") {
				wep_obj = $('.first.access').find('.formElements').find('.wep');
				wpa_obj = $('.first.access').find('.formElements').find('.wpa');
			} else {
				wep_obj = $('.wep');
				wpa_obj = $('.wpa');
			}
			if(num == "None") {
				wep_obj.hide();
				wep_obj.hide();
				$('#securityOptions').val('None');
			} else if(num == "WEP") {
				wep_obj.show();
				wpa_obj.hide();
				$('#wepAuth').val($.convertWEPAuthTypeToText(authType));
				$('#wepEnc').val($.convertWEPAuthLength(key_length));
				$('#wepEnc').trigger('change');
				if (keyno == '1')
					$('#wepKeyNo1').attr('checked', 'checked');
				else if (keyno == '2')
					$('#wepKeyNo2').attr('checked', 'checked');
				else if (keyno == '3')
					$('#wepKeyNo3').attr('checked', 'checked');
				else
					$('#wepKeyNo4').attr('checked', 'checked');
				$('#key1').val(ap_wl_key1);
				$('#key2').val(ap_wl_key2);
				$('#key3').val(ap_wl_key3);
				$('#key4').val(".");
			} else if(num == "3" || num == "WPA2-PSK" || num == "WPA/WPA2" || num == "WPA3" || num == "WPA2/WPA3"){
				wep_obj.hide();
				wpa_obj.show();
				$('#pwd').val(ap_wl_password);
				$('#verifyPwd').val(ap_wl_password);
				if (ap_wl_password.length >= $.MIN_PWD_CHARACTERS)
					$('#verifyPwd').prop('disabled', false);
			} else {
				wep_obj.hide();
				wpa_obj.hide();
				$('#securityOptions').val('None');
			}
		}

		$.setSecurity5g = function (num) {
			$('#securityOptions5g').val(num);
			if(num == "None") {
				$('.second.access').find('.formElements').find('.wep').hide();
				$('.second.access').find('.formElements').find('.wpa').hide();
				$('#securityOptions5g').val('None');
			} else if(num == "WEP") {
				$('.second.access').find('.formElements').find('.wep').show();
				$('.second.access').find('.formElements').find('.wpa').hide();
				$('#wepAuth5g').val($.convertWEPAuthTypeToText(authType5g));
				$('#wepEnc5g').val($.convertWEPAuthLength(key_length_5g));
				$('#wepEnc5g').trigger('change');
				if (keyno5g == '1')
					$('#wepKeyNo5g1').attr('checked', 'checked');
				else if (keyno5g == '2')
					$('#wepKeyNo5g2').attr('checked', 'checked');
				else if (keyno5g == '3')
					$('#wepKeyNo5g3').attr('checked', 'checked');
				else
					$('#wepKeyNo5g4').attr('checked', 'checked');
				$('#key5g1').val(ap_wla_key1);
				$('#key5g2').val(ap_wla_key2);
				$('#key5g3').val(ap_wla_key3);
				$('#key5g4').val(".");
			} else if(num == "3" || num == "WPA2-PSK" || num == "WPA/WPA2" || num == "WPA3" || num == "WPA2/WPA3"){
				$('.second.access').find('.formElements').find('.wep').hide();
				$('.second.access').find('.formElements').find('.wpa').show();
				$('#pwd5g').val(ap_wla_password);
				$('#verifyPwd5g').val(ap_wla_password);
				if (ap_wla_password.length >= $.MIN_PWD_CHARACTERS)
					$('#verifyPwd5g').prop('disabled', false);
			} else {
				$('.second.access').find('.formElements').find('.wep').hide();
				$('.second.access').find('.formElements').find('.wpa').hide();
				$('#securityOptions5g').val('None');
			}
		}

		$.checkPass();
		if (typeof (wl_sectype) != "undefined") {
			setTimeout(function () {
				if (wl_sectype == "2") {
					$('#key4').val(ap_wl_key4);
					$('#pwd').val("");
					$('#verifyPwd').val("");
				} else if (wl_sectype == "3" || wl_sectype == "6" || wl_sectype == "7" || wl_sectype == "10" || wl_sectype == "11") {
					$('#key4').val("");
					$('#pwd').val(ap_wl_password);
					$('#verifyPwd').val(ap_wl_password);
				} else {
					$('#key4').val("");
					$('#pwd').val("");
					$('#verifyPwd').val("");
				}
				$('#key4').removeAttr('style');
			}, $.chromeTimer);
		}

		if (have_wireless_an == "1") {
			$.checkPass5g();
			if (typeof (wla_sectype) != "undefined") {
				setTimeout(function () {
					if (wla_sectype == "2") {
						$('#key5g4').val(ap_wla_key4);
						$('#pwd5g').val("");
						$('#verifyPwd5g').val("");
					} else if (wla_sectype == "3" || wla_sectype == "6" || wla_sectype == "7" || wla_sectype == "10" || wla_sectype == "11") {
						$('#key5g4').val("");
						$('#pwd5g').val(ap_wla_password);
						$('#verifyPwd5g').val(ap_wla_password);
					} else {
						$('#key5g4').val("");
						$('#pwd5g').val("");
						$('#verifyPwd5g').val("");
					}
					$('#key5g4').removeAttr('style');
				}, $.chromeTimer);
			}
		}
		$.apWEPShowHidden = function () {
			return true;
			var secOptions = document.getElementById('securityOptions'),
				sel = secOptions.value;
			if ($('#opMode').val() != '1') {
				$("#securityOptions option[value='WEP']").remove();
			} else {
				if ( sel == 'WEP' )
					sel = '0';
				secOptions.options[2].value = 'WEP';
				secOptions.options[2].text = sec_wep_phrase;
				secOptions.options[3].value = 'WPA2-PSK';
				secOptions.options[3].text = sec_wpa2_phrase;
				secOptions.options[4] = new Option(sec_wpas_phrase, 'WPA/WPA2');
			}
			$('#securityOptions').val(sel);
			$('#securityOptions').trigger('change');
		};

		$.apWEPShowHidden5g = function () {
			$.setAPChannel5g(2, parseInt(get_channel_5g));
			return true;
			var secOptions = document.getElementById('securityOptions5g'),
				sel = secOptions.value;
			if ($('#opMode5g').val() != '1') {
				$("#securityOptions5g option[value='WEP']").remove();
			} else {
				if ( sel == 'WEP' )
					sel = '0';
				secOptions.options[2].value = 'WEP';
				secOptions.options[2].text = sec_wep_phrase;
				secOptions.options[3].value = 'WPA2-PSK';
				secOptions.options[3].text = sec_wpa2_phrase;
				secOptions.options[4] = new Option(sec_wpas_phrase, 'WPA/WPA2');
			}
			$('#securityOptions5g').val(sel);
			$('#securityOptions5g').trigger('change');
		};

		var modeArray = new Array(),
			modeValue = new Array(),
			selectMode = $('#opMode').val();

		$('option', '#opMode').each(function (i, ele) {
			modeArray[i] = $(ele).html();
			modeValue[i] = $(ele).attr("value");
		});

		$.apModeShowHidden = function () {
			var options = $('#opMode option').length,
				i = 0;
			selectMode = $('#opMode').val();
			if ($('#securityOptions').val() == '2') {
				options = 1;
			}
			$('#opMode').empty();
			for (; i < options; i++) {
				if (selectMode == modeValue[i])
					$('<option value="' + modeValue[i] + '" selected>' + modeArray[i] + '</option>').appendTo('#opMode');
				else
					$('<option value="' + modeValue[i] + '">' + modeArray[i] + '</option>').appendTo('#opMode');
			}
		};

		if (have_wireless_an == "1") {
			var modeArray5g = new Array(),
				modeValue5g = new Array(),
				selectMode5g = $('#opMode5g').val();

			$('option', '#opMode5g').each(function (i, ele) {
				modeArray5g[i] = $(ele).html();
				modeValue5g[i] = $(ele).attr("value");
			});
		}

		$.apModeShowHidden5g = function () {
			var options = $('#opMode5g option').length,
				i = 0;
			selectMode = $('#opMode5g').val();
			if ($('#securityOptions5g').val() == '2') {
				options = 1;
			}
			$('#opMode5g').empty();
			for (; i < options; i++) {
				if (selectMode == modeValue5g[i])
					$('<option value="' + modeValue5g[i] + '" selected>' + modeArray5g[i] + '</option>').appendTo('#opMode5g');
				else
					$('<option value="' + modeValue5g[i] + '">' + modeArray5g[i] + '</option>').appendTo('#opMode5g');
			}
		};

		function sameAp() {
			$('#ssid').val($('#ssid5g').val());
			var secOptions = document.getElementById('securityOptions5g'),
				sel = secOptions.value;
			if( sel == "WEP" ) {
				$('#opMode').val('1');
				$.setSecurity("2");
				var secOptions5g = document.getElementById('securityOptions');
				secOptions5g.options[2].value = '2';
				secOptions5g.options[2].text = sec_wep_phrase;
				secOptions5g.options[3].value = '6';
				secOptions5g.options[3].text = sec_wpa2_phrase;
				secOptions5g.options[4] = new Option(sec_wpas_phrase, '7');
			}
			$('#securityOptions').val(sel);
			if(sel == "WPA2-PSK" || sel == "WPA/WPA2" || sel == "WPA3" || sel == "WPA2/WPA3"){
				$('#pwd').val($('#pwd5g').val());
				$('#verifyPwd').val($('#verifyPwd5g').val());
				$('.wep').slideUp();
				$('.wpa').slideDown();
			} else if (sel == "WEP") {
				$.setSecurity("1");
				$('#securityOptions').val('1');
				$('.wep').slideUp();
				$('.wpa').slideUp();
			} else if (sel == "None") {
				$('.wep').slideUp();
				$('.wpa').slideUp();
			} else if (sel == "2") {
				$('#wepAuth').val($('#wepAuth5g').val());
				$('#wepEnc').val($('#wepEnc5g').val());
				if ($('#wepKeyNo5g1').is(':checked') == true) {
					$('#wepKeyNo1').attr('checked', 'checked');
				} else if ($('#wepKeyNo5g2').is(':checked') == true) {
					$('#wepKeyNo2').attr('checked', 'checked');
				} else if ($('#wepKeyNo5g3').is(':checked') == true) {
					$('#wepKeyNo3').attr('checked', 'checked');
				} else if ($('#wepKeyNo5g4').is(':checked') == true) {
					$('#wepKeyNo4').attr('checked', 'checked');
				}
				$('#key1').val($('#key5g1').val());
				$('#key2').val($('#key5g2').val());
				$('#key3').val($('#key5g3').val());
				$('#key4').val($('#key5g4').val());
			}
			$('#smartConnectYes').prop('checked', true);
		}

		if ($('#accessPointForm').length) {
			$('#ssid').val(wl_ssid.replace(/&nbsp;/g, " "));
			$.setAPChannel(parseInt(get_channel));
/*
			if (mode == '3' || mode == '5' || mode == '6')
				$('#opMode').val('3');
			else if (mode == '2')
				$('#opMode').val('2');
			else if (mode == '1')
				$('#opMode').val('1');
			else if ((mode == '8') && (opmodeSupport600M || opmodeSupport400M))
				$('#opMode').val('8');
			else
				$('#opMode').val('3');
			//$('#opMode').val('3');
*/
			var setmode = '0';
			if ( wifi6Enable ) {
				if (mode == '3' || mode == '5' || mode == '6'){
					setmode = '3';
					$('#opMode').val(setmode);
				} else if(mode == '1' || mode == '2' || mode == '16' ){
					setmode = mode;
					$('#opMode').val(setmode);
				} else if ((mode == '8') && (opmodeSupport600M || opmodeSupport400M)){
					setmode = '8';
					$('#opMode').val(setmode);
				} else if (opmodeSupport600M){
					setmode = '8';
					$('#opMode').val(setmode);
				} 
				else if (opmodeSupport400M){
					setmode = '17';
					$('#opMode').val(setmode);
				} else {
					setmode = '1';
					$('#opMode').val(setmode);
				}
			} else {
				if (mode == '3' || mode == '5' || mode == '6'){
					setmode = '3';
					$('#opMode').val(setmode);
				} else if(mode == '1' || mode == '2' || mode == '15' || mode == '17'){
					setmode = mode;
					$('#opMode').val(setmode);
				} else if ((mode == '8') && (opmodeSupport600M || opmodeSupport400M)){
					setmode = '8';
					$('#opMode').val(setmode);
				} 
				else if (opmodeSupport400M){
					setmode = '7';
					$('#opMode').val(setmode);
				} else {
					setmode = '17';
					$('#opMode').val(setmode);
				}
			}
			if ( setmode != $('#opMode').val() ){
				$('#opMode').val($('#opmode option:last').val());
			}

			$('#channel').val(get_channel);
			$.apWEPShowHidden();
			$.setSecurity($.convertSecTypeToText(wl_sectype));
			$.apModeShowHidden();

			if (have_wireless_an == "1") {
				$('#ssid5g').val(wla_ssid.replace(/&nbsp;/g, " "));
/*
				if (mode5g == '1')
					$('#opMode5g').val('1');
				else if (mode5g == '8')
					$('#opMode5g').val('8');
				else if (mode5g == '7')
					$('#opMode5g').val('16');
				else
					$('#opMode5g').val('10');
				//$('#opMode5g').val('3');
*/
				var setmode5g = '0';
				if ( wifi6Enable ) {
				    if (mode5g == '1' || mode5g == '7' || mode5g == '8' || mode5g == '10' || mode5g == '16') {
						setmode5g = mode5g;
						$('#opMode5g').val(setmode5g);
					}else{
						setmode5g = '10';
						$('#opMode5g').val(setmode5g);
				    }
				} else {
					if (mode5g == '1' || mode5g == '7' || mode5g == '8' || mode5g == '15'|| mode5g == '17' || mode5g == '18') {
						setmode5g = mode5g;
						$('#opMode5g').val(setmode5g);
					}else{
						setmode5g = '18';
						$('#opMode5g').val(setmode5g);
				    }
				}

				if ( setmode5g != $('#opMode5g').val() ){
					$('#opMode5g').val($('#opMode5g option:last').val());
				}

				$.setAPChannel5g(1, parseInt(get_channel_5g));
				$.apWEPShowHidden5g();
				$.setSecurity5g($.convertSecTypeToText(wla_sectype));
				$.apModeShowHidden5g();
			}

			$.detectAp = function () {
				if ($('#ssid').val() == $('#ssid5g').val()) {
					if ($('#securityOptions').val() == $('#securityOptions5g').val()) {
						if(($('#securityOptions').val() == "WPA2-PSK" || $('#securityOptions').val() == "WPA/WPA2") && ($('#pwd').val() == $('#pwd5g').val())){
							return true;
						}else if($('#securityOptions').val() == "None"){
							return true;
						} else if ($('#securityOptions').val() == "0") {
							return true;
						}else if($('#securityOptions').val() == "WEP"){
							if ($('#wepAuth').val() == $('#wepAuth5g').val() && $('#wepEnc').val() == $('#wepEnc5g').val()) {
								for (var i = 1; i <= 4; i++) {
									if ($('#wepKeyNo' + i).is(':checked') == true && $('#wepKeyNo5g' + i).is(':checked') == true && $('#key' + i).val() == $('#key5g' + i).val() && $('#key5g' + i).val())
										return true;
								}
							}
						}
					}
				}
			}

			$('#smartConnectYes').click(function () {
				$('.errorMsg').remove();

				sameAp();
				$('#ssid').prop('disabled', true);
				$('.first.access').find('#securityOptions').prop('disabled', true);
				//$('.first.access .pwdInput input').prop('disabled', true);
				$('.first.access .pwdInput select').prop('disabled', true);
				$('.first.access .securityOptionsSelect select').css({ 'background-color': '#ebebe4' });
				$('.first.access .pwdInput select').css({ 'background-color': '#ebebe4' });
				$('.first.access .pwdInput input').css({ 'background-color': '#ebebe4' });
			});

			$('#smartConnectNo').click(function () {
				$('.errorMsg').remove();
				$('#ssid').prop('disabled', false);
				$('.first.access').find('#securityOptions').prop('disabled', false);
				$('.first.access .pwdInput input').prop('disabled', false);
				$('.first.access .pwdInput select').prop('disabled', false);
				$('.first.access .securityOptionsSelect select').css({ 'background-color': '' });
				$('.first.access .pwdInput select').css({ 'background-color': '' });
				$('.first.access .pwdInput input').css({ 'background-color': '' });
				if ($("#pwd").val().length < $.MIN_PWD_CHARACTERS) {
					$("#verifyPwd").prop('disabled', true);
				}
				if ($("#pwd5g").val().length < $.MIN_PWD_CHARACTERS) {
					$("#verifyPwd5g").prop('disabled', true);
				}
			});

			$('#smartConnectYes').trigger('click');

			$('.main').change(function () {
				if ($("#smartConnectNo").is(":checked") == true) {
					if ($.detectAp() == true) {
						$('.errorMsg').remove();
						$('#smartConnectYes').prop('checked', true);
						$('#smartConnectYes').trigger('click');
					} else {
						$('#smartConnectNo').prop('checked', true);
						$('#smartConnectNo').trigger('click');
					}
				}
			});

			$('.main').keyup(function () {
				if ($("#smartConnectNo").is(":checked") == true) {
					if ($.detectAp() == true) {
						$('.errorMsg').remove();
						$('#smartConnectYes').prop('checked', true);
						$('#smartConnectYes').trigger('click');
					} else {
						$('#smartConnectNo').prop('checked', true);
						$('#smartConnectNo').trigger('click');
					}
				}
			});

			$('.column.second.access').change(function () {
				if ($("#smartConnectYes").is(":checked") == true)
					sameAp();
			});

			$('.column.second.access').keyup(function () {
				if ($("#smartConnectYes").is(":checked") == true)
					sameAp();
			});

			$('#nextStep').click(function () {
				$('.errorMsg').remove();
				if (!$.REG_SSID.test($('#ssid').val())) {
					if ($('#ssid').val().length == 0) {
						$.addErrMsgAfter('ssid', ssid_null, false, 'error_info_2');
					} else {
						$.addErrMsgAfter('ssid', ssid_invalid, false, 'error_info_2');
					}
				} else {
					var testMainSSID = $('#ssid').val();
					if ((guestAPEnable && testMainSSID == guestSSID) || (guestAPEnable5g && testMainSSID == guestSSID5g)) {
					  alert(ssid_dup);
					  return;
					}
				  }
				$.checkAPInput();
				if ($("#smartConnectYes").is(":checked") == true)
					$('#smartConnect').val("1");
				if ($("#smartConnectNo").is(":checked") == true)
					$('#smartConnect').val("0");

				if (have_wireless_an == "1") {
					if (!$.REG_SSID.test($('#ssid5g').val())) {
						if ($('#ssid5g').val().length == 0) {
							$.addErrMsgAfter('ssid5g', ssid_null, false, 'error_info_5');
						} else {
							$.addErrMsgAfter('ssid5g', ssid_invalid, false, 'error_info_5');
						}
					} else {
						var testMainSSID = $('#ssid5g').val();
						if ((guestAPEnable && testMainSSID == guestSSID) || (guestAPEnable5g && testMainSSID == guestSSID5g)) {
						  alert(ssid_dup);
						  return;
						}
					  }
					$.checkAPInput5g();
				}
				$('#confMode').val('0');
				$('#client2GHzSSID').val($.do_xss_ssid($('#ssid').val()));
				$('#wifiChannel').val($('#channel').val());
				$('#client2GHzSameSec').val('0');

				var continue_obj;
				if (have_wireless_an == "1")
					continue_obj = $('.column.first ul strong:last', '#continue');
				else
					continue_obj = $('ul strong:last', '#continue');
				if($('#securityOptions').val() == 'None') {
					$('#client2GHzSecurity').val('1');
					$('#clientMode').val($('#opMode').val());
				} else if($('#securityOptions').val() == 'WEP') {
					$('#client2GHzSecurity').val('2');
					$('#clientMode').val('1');
					if($('#wepAuth').val() == 'Shared Key')
						$('#client2GHzAuthType').val('1');
					else
						$('#client2GHzAuthType').val('2');
					if($('#wepEnc').val() == '64')
						$('#client2GHzEncrLen').val('5');
					else
						$('#client2GHzEncrLen').val('13');
					$('#client2GHzKeyNum').val($('input:radio[name="wep_key_no"]:checked').val());
					$('#client2GHzKey1').val($.do_xss_pass($('#key1').val()));
					$('#client2GHzKey2').val($.do_xss_pass($('#key2').val()));
					$('#client2GHzKey3').val($.do_xss_pass($('#key3').val()));
					$('#client2GHzKey4').val($.do_xss_pass($('#key4').val()));
					continue_obj.html($('#key' + $('#client2GHzKeyNum').val()).val().replace(/ /g, '&nbsp;'));
				} else {
					if ($('#verifyPwd').val() != $('#pwd').val() && $('#pwd').val().length >= $.MIN_PWD_CHARACTERS) {
						$('#verifyPwd').addClass('alert');
						$.addErrMsgAfter('verifyPwd', error_not_same_pwd, false, 'errPwdSame');
						return false;
					}
					$('#clientMode').val($('#opMode').val());
					if($('#securityOptions').val() == 'WPA2-PSK')
						$('#client2GHzSecurity').val('6');
					else if($('#securityOptions').val() == 'WPA3')
						$('#client2GHzSecurity').val('10');
					else if($('#securityOptions').val() == 'WPA2/WPA3')
						$('#client2GHzSecurity').val('11');
					else
						$('#client2GHzSecurity').val('7');
					$('#client2GHzPassword').val($.do_xss_pass($('#pwd').val()));
					continue_obj.html($('#pwd').val().replace(/ /g, '&nbsp;'));
				}
				if (have_wireless_an == "1") {
					$('#client5GHzSSID').val($.do_xss_ssid($('#ssid5g').val()));
					$('#wifiChannel5g').val($('#channel5g').val());
					$('#client5GHzSameSec').val('0');
					if($('#securityOptions5g').val() == 'None') {
						$('#client5GHzSecurity').val('1');
						$('#clientMode5g').val($('#opMode5g').val());
					} else if($('#securityOptions5g').val() == 'WEP') {
						$('#client5GHzSecurity').val('2');
						$('#clientMode5g').val('1');
						if($('#wepAuth5g').val() == 'Shared Key')
							$('#client5GHzAuthType').val('1');
						else
							$('#client5GHzAuthType').val('2');
						if($('#wepEnc5g').val() == '64')
							$('#client5GHzEncrLen').val('5');
						else
							$('#client5GHzEncrLen').val('13');
						$('#client5GHzKeyNum').val($('input:radio[name="wep_key_no_5g"]:checked').val());
						$('#client5GHzKey1').val($.do_xss_pass($('#key5g1').val()));
						$('#client5GHzKey2').val($.do_xss_pass($('#key5g2').val()));
						$('#client5GHzKey3').val($.do_xss_pass($('#key5g3').val()));
						$('#client5GHzKey4').val($.do_xss_pass($('#key5g4').val()));
						$('.column.second ul strong:last', '#continue').html($('#key5g' + $('#client5GHzKeyNum').val()).val().replace(/ /g, '&nbsp;'));
					} else {
						if ($('#verifyPwd5g').val() != $('#pwd5g').val() && $('#pwd5g').val().length >= $.MIN_PWD_CHARACTERS) {
							$('#verifyPwd5g').addClass('alert');
							$.addErrMsgAfter('verifyPwd5g', error_not_same_pwd, false, 'errPwdSame');
							return false;
						}
						$('#clientMode5g').val($('#opMode5g').val());
						if($('#securityOptions5g').val() == 'WPA2-PSK')
							$('#client5GHzSecurity').val('6');
						else if($('#securityOptions5g').val() == 'WPA3')
							$('#client5GHzSecurity').val('10');
						else if($('#securityOptions5g').val() == 'WPA2/WPA3')
							$('#client5GHzSecurity').val('11');
						else
							$('#client5GHzSecurity').val('7');
						$('#client5GHzPassword').val($.do_xss_pass($('#pwd5g').val()));
						$('.column.second ul strong:last', '#continue').html($('#pwd5g').val().replace(/ /g, '&nbsp;'));
					}
				}
				if (!$('.errorMsg').length) {
					if ($('#client2GHzSecurity').val() == '1' || (have_wireless_an == "1" && $('#client5GHzSecurity').val() == '1')) {
						$.confirmBox(wps_warning3, null, function () {
							$.submitApply();
						}, null, null);
					} else {
						$.submitApply();
					}
				}
			});
			$.submitApply = function () {
				var continue_obj1, continue_obj2, continue_obj3;
				if (have_wireless_an == "1") {
					continue_obj1 = $('.column.first ul strong:first', '#continue');
					continue_obj2 = $('.column.first ul strong:eq(1)', '#continue');
					continue_obj3 = $('.column.first ul li:last', '#continue');
				} else {
					continue_obj1 = $('ul strong:first', '#continue');
					continue_obj2 = $('ul strong:eq(1)', '#continue');
					continue_obj3 = $('ul li:last', '#continue');
				}
				$.submit_wait('body', $.APPLYING_DIV);

				continue_obj1.html($('#ssid').val().replace(/ /g, '&nbsp;'));
				continue_obj2.html($.formatSecType2($.convertSecTypeToNum($('#securityOptions').val())));
				if ($('#securityOptions').val() == "None")
					continue_obj3.hide();

				if (have_wireless_an == "1") {
					$('.column.second ul strong:first', '#continue').html($('#ssid5g').val().replace(/ /g, '&nbsp;'));
					$('.column.second ul strong:eq(1)', '#continue').html($.formatSecType2($.convertSecTypeToNum($('#securityOptions5g').val())));
					if ($('#securityOptions5g').val() == "None")
						$('.column.second ul li:last', '#continue').hide();
				}

				$.postForm('#accessPointForm', '', function (json) {
					if (json.status == '1') {
						var time = parseInt(json.wait) * 1000;
						setTimeout(function () {
							$('#accessPointDiv').hide();
							$('.running').remove();
							$('.secondary', '#fixedFooter').hide();
							$('#nextStep', '#fixedFooter').hide();
							$('#continueBt', '#fixedFooter').show();
							$('.continueInfo').show();
							$('#continueBt').click(function () {
								$.change_domain(json.url);
							});
							$('#continue').show();
						}, time);
					} else {
						$.alertBox(json.msg);
					}
				});
			}
		}

		/*******************************************************************************************
		*
		*       apRetryForm, failure and continue page.
		*
		******************************************************************************************/

		if ($("input[name='try_again']").length) {
			$("input[name='try_again']").on('click', function () {
				if ($(this).val() == "0") {
					$('.sectionIPAddr').show();
				} else {
					$('.sectionIPAddr').hide();
				}
			});
		}

		if ($("input[name='configure']").length) {
			$("input[name='configure']").on('click', function () {
				if ($(this).val() == "0") {
					$('input', '.ipAddressInput').prop("disabled", false);
				} else {
					$('input', '.ipAddressInput').prop("disabled", true);
				}
			});
		}

		$.check_static_ip_mask_gtw = function () {
			var ipAddr = $('#ethr1').val() + '.' + $('#ethr2').val() + '.' + $('#ethr3').val() + '.' + $('#ethr4').val(),
				maskAddr = $('#mask1').val() + '.' + $('#mask2').val() + '.' + $('#mask3').val() + '.' + $('#mask4').val(),
				gatewayAddr = $('#gateway1').val() + '.' + $('#gateway2').val() + '.' + $('#gateway3').val() + '.' + $('#gateway4').val(),
				dnsAddr = $('#priAddr1').val() + '.' + $('#priAddr2').val() + '.' + $('#priAddr3').val() + '.' + $('#priAddr4').val(),
				secDnsAddr = $('#secAddr1').val() + '.' + $('#secAddr2').val() + '.' + $('#secAddr3').val() + '.' + $('#secAddr4').val();
			if ($.checkipaddr(ipAddr) == false || $.is_sub_or_broad(ipAddr, ipAddr, maskAddr) == false) {
				$.addErrMsgAfter('ethr4', ip_invalid);
				return false;
			}
			if ((maskAddr == "0.0.0.0") || (maskAddr == "255.255.255.255")) {
				$.addErrMsgAfter('mask4', subnet_invalid);
				return false;
			}
			if ($.checksubnet(maskAddr) == false) {
				$.addErrMsgAfter('mask4', subnet_invalid);
				return false;
			}
			if ($.checkgateway(gatewayAddr) == false) {
				$.addErrMsgAfter('gateway4', gateway_invalid);
				return false;
			}
			if ($.isGateway(ipAddr, maskAddr, gatewayAddr) == false) {
				$.addErrMsgAfter('gateway4', gateway_invalid);
				return false;
			}
			if ($.isSameIp(ipAddr, gatewayAddr) == true) {
				$.addErrMsgAfter('gateway4', gateway_invalid);
				return false;
			}
			if ($.isSameSubNet(ipAddr, maskAddr, gatewayAddr, maskAddr) == false) {
				$.addErrMsgAfter('gateway4', same_subnet_ip_gtw);
				return false;
			}
			if ($.checkipaddr(dnsAddr) == false) {
				$.addErrMsgAfter('priAddr4', primary_dns_invalid);
				return false;
			}
			if (secDnsAddr == '...')
				secDnsAddr = "";
			if (secDnsAddr != "") {
				if ($.checkipaddr(secDnsAddr) == false) {
					$.addErrMsgAfter('secAddr4', invalid_second_dns);
					return false;
				}
			}
			return true;
		}

		if ($('#apRetryForm').length) {

			if (ether_get_ip != "") {
				var ip_array = ether_get_ip.split('.');
				$('#ethr1').val(ip_array[0]);
				$('#ethr2').val(ip_array[1]);
				$('#ethr3').val(ip_array[2]);
				$('#ethr4').val(ip_array[3]);
			}
			if (ether_get_subnet != "") {
				var mask_array = ether_get_subnet.split('.');
				$('#mask1').val(mask_array[0]);
				$('#mask2').val(mask_array[1]);
				$('#mask3').val(mask_array[2]);
				$('#mask4').val(mask_array[3]);
			}
			if (ether_get_gateway != "") {
				var gtw_array = ether_get_gateway.split('.');
				$('#gateway1').val(gtw_array[0]);
				$('#gateway2').val(gtw_array[1]);
				$('#gateway3').val(gtw_array[2]);
				$('#gateway4').val(gtw_array[3]);
			}
			if (ether_get_dns1 != "") {
				var dns_array = ether_get_dns1.split('.');
				$('#priAddr1').val(dns_array[0]);
				$('#priAddr2').val(dns_array[1]);
				$('#priAddr3').val(dns_array[2]);
				$('#priAddr4').val(dns_array[3]);
			}
			if (ether_get_dns2 != "") {
				var dns_array = ether_get_dns2.split('.');
				$('#secAddr1').val(dns_array[0]);
				$('#secAddr2').val(dns_array[1]);
				$('#secAddr3').val(dns_array[2]);
				$('#secAddr4').val(dns_array[3]);
			}

			$('.primary').click(function () {
				$('.errorMsg').remove();

				if ($('#retry').is(':checked')) {
					top.location.href = "ca_welcome.htm" + $.ID_2;
					return false;
				} else {
					if ($('#configSelf').is(':checked')) {
						top.location.href = "status.htm" + $.ID_2;
						return false;
					} else {
						$('#etherIPAddr').val($('#ethr1').val() + '.' + $('#ethr2').val() + '.' + $('#ethr3').val() + '.' + $('#ethr4').val());
						$('#etherSubnet').val($('#mask1').val() + '.' + $('#mask2').val() + '.' + $('#mask3').val() + '.' + $('#mask4').val());
						$('#etherGateway').val($('#gateway1').val() + '.' + $('#gateway2').val() + '.' + $('#gateway3').val() + '.' + $('#gateway4').val());
						$('#etherDNSAddr1').val($('#priAddr1').val() + '.' + $('#priAddr2').val() + '.' + $('#priAddr3').val() + '.' + $('#priAddr4').val());
						$('#etherDNSAddr2').val($('#secAddr1').val() + '.' + $('#secAddr2').val() + '.' + $('#secAddr3').val() + '.' + $('#secAddr4').val());
						if ($.check_static_ip_mask_gtw() == false) {
							return false;
						}
					}
				}

				if (!$('.errorMsg').length) {
					$.submit_wait('body', $.APPLYING_DIV);
					$.postForm('#apRetryForm', '', function (json) {
						if (json.status == '1') {
							var time = parseInt(json.wait) * 1000;
							setTimeout(function () {
								location.href = json.url + $.ID_2;
							}, time);
						} else {
							$.alertBox(json.msg);
						}
					});
				}
			});
		}

	});//end ready function

}(jQuery));

