#!/bin/sh

bs20_name='bs20'
log_dir='/tmp/log/netgear/'
band_log='/tmp/log/netgear/bandsteering.txt'

bs20_log='/tmp/log/netgear/bs20.txt'
bs20_log_bak='/tmp/log/netgear/bs20.txt.old'
bs20_log_max=8000

mapd_log='/tmp/log/netgear/mapd.txt'
mapd_log_bak='/tmp/log/netgear/mapd.txt.old'
mapd_log_max=8000

num=0

bs20_run=`uci get wireless.2g_5g.mapMode`

debug_print_time()
{
	uptime=`cat /proc/uptime | awk '{print $1}'`
	datetime=`date +"%Y-%m-%d %H:%M:%S"`
	echo "#" >> /dev/console
	echo "# TTTTWWWW: uptime[$uptime] date[$datetime] $1, circle $num" >> /dev/console
	echo "#" >> /dev/console
	echo "#" >> $bs20_log
	echo "# TTTTWWWW: uptime[$uptime] date[$datetime] $1, circle $num" >> $bs20_log
	echo "#" >> $bs20_log
	echo "#" >> $mapd_log
	echo "# TTTTWWWW: uptime[$uptime] date[$datetime] $1, circle $num" >> $mapd_log
	echo "#" >> $mapd_log
	let num++
}

debug_start()
{
	mkdir -p $log_dir
	rm -rf $band_log
	echo "# `date +"%Y-%m-%d %H:%M:%S"`" >> $band_log

	rm -rf $bs20_log $bs20_log_bak
	rm -rf $mapd_log $mapd_log_bak

	if [ $bs20_run = '2' ]; then
		debug_print_time "Start bs20, begin to collect log"

		bs20_pid=`ps | grep -w $bs20_name | grep -v grep | awk '{print $1}'`
		kill -9 $bs20_pid
		echo "# kill -9 $bs20_pid" >> $band_log	

		$bs20_name >> $bs20_log &
		echo "# $bs20_name >> $bs20_log &" >> $band_log
		bs20_pid=`ps | grep -w $bs20_name | grep -v grep | awk '{print $1}'`
		echo "# launch $bs20_name pid $bs20_pid" >> $band_log

		echo "# mapd_cli /tmp/mapd_ctrl set log_level 2" >> $band_log
		mapd_cli /tmp/mapd_ctrl set log_level 2
	fi

	while :
	do
		if [ $bs20_run != '2' ];
		then
			echo "not in bandsteering mode, current mapMode is $bs20_run" >> $band_log
			sleep 30
			continue
		fi

		debug_print_time "collect mapd log"

		bs20_log_size=`du -k $bs20_log | awk '{print $1}'`
		if [ $bs20_log_size -ge $bs20_log_max ];
		then
			debug_print_time "Restart bs20, begin to collect log"

			echo "#" >> $band_log
			echo "# `date +"%Y-%m-%d %H:%M:%S"`" >> $band_log
			echo "bs20 log file size $bs20_log_size >= max size $bs20_log_max, so rename to $bs20_log_bak and relaunch $bs20_name" >> $band_log
			bs20_pid=`ps | grep -w $bs20_name | grep -v grep | awk '{print $1}'`
			kill -9 $bs20_pid
			echo "# kill -9 $bs20_pid" >> $band_log

			rm -rf $bs20_log_bak
			mv $bs20_log $bs20_log_bak

			$bs20_name >> $bs20_log &
			echo "# $bs20_name >> $bs20_log &" >> $band_log
			bs20_pid=`ps | grep -w $bs20_name | grep -v grep | awk '{print $1}'`
			echo "# launch $bs20_name pid $bs20_pid" >> $band_log

			echo "# mapd_cli /tmp/mapd_ctrl set log_level 2" >> $band_log
			mapd_cli /tmp/mapd_ctrl set log_level 2
		fi

		echo "# mapd_cli /tmp/mapd_ctrl mib bl_list" >> $mapd_log
		mapd_cli /tmp/mapd_ctrl mib bl_list >> $mapd_log
		echo "#" >> $mapd_log

		echo "# mapd_cli /tmp/mapd_ctrl mib bss_info" >> $mapd_log
		mapd_cli /tmp/mapd_ctrl mib bss_info >> $mapd_log
		echo "#" >> $mapd_log

		echo "# mapd_cli /tmp/mapd_ctrl mib" >> $mapd_log
		mapd_cli /tmp/mapd_ctrl mib >> $mapd_log
		echo "#" >> $mapd_log

		mapd_log_size=`du -k $mapd_log | awk '{print $1}'`
		if [ $mapd_log_size -ge $mapd_log_max ];
		then
			echo "mapd log file size $mapd_log_size >= max size $mapd_log_max, so rename to $mapd_log_bak" >> $band_log
			rm -rf $mapd_log_bak
			mv $mapd_log $mapd_log_bak
		fi

		sleep 30
	done
}

debug_stop()
{
	bs20_pid=`ps | grep -w $bs20_name | grep -v grep | awk '{print $1}'`
	echo "#" >> $band_log
	echo "# `date +"%Y-%m-%d %H:%M:%S"`" >> $band_log
	kill -9 $bs20_pid
	echo "# kill -9 $bs20_pid" >> $band_log

	if [ $bs20_run = '2' ];
	then
		$bs20_name &
		echo "# $bs20_name >> $bs20_log &" >> $band_log
		
		bs20_pid=`ps | grep -w $bs20_name | grep -v grep | awk '{print $1}'`
		echo "# launch $bs20_name pid $bs20_pid" >> $band_log
	fi
}

if [ $1 = 'start' ]; then
	debug_start
elif [ $1 = 'stop' ]; then
	debug_stop
fi
