
/* Python wrapper functions auto-generated by pidl */
#include <Python.h>
#include "includes.h"
#include <pytalloc.h>
#include "librpc/rpc/pyrpc.h"
#include "librpc/rpc/pyrpc_util.h"
#include "autoconf/librpc/gen_ndr/ndr_dcom.h"
#include "autoconf/librpc/gen_ndr/ndr_dcom_c.h"

#include "librpc/gen_ndr/orpc.h"
#include "librpc/gen_ndr/misc.h"
staticforward PyTypeObject dcom_Unknown_InterfaceType;

staticforward PyTypeObject IUnknown_InterfaceType;

staticforward PyTypeObject IClassFactory_InterfaceType;

staticforward PyTypeObject REMQIRESULT_Type;
staticforward PyTypeObject REMINTERFACEREF_Type;
staticforward PyTypeObject IRemUnknown_InterfaceType;

staticforward PyTypeObject IClassActivator_InterfaceType;

staticforward PyTypeObject ISCMLocalActivator_InterfaceType;

staticforward PyTypeObject IMachineLocalActivator_InterfaceType;

staticforward PyTypeObject ILocalObjectExporter_InterfaceType;

staticforward PyTypeObject ISystemActivator_InterfaceType;

staticforward PyTypeObject IRemUnknown2_InterfaceType;

staticforward PyTypeObject REF_ITypeInfo_Type;
staticforward PyTypeObject VARIANT_Type;
staticforward PyTypeObject DISPPARAMS_Type;
staticforward PyTypeObject EXCEPINFO_Type;
staticforward PyTypeObject IDispatch_InterfaceType;

staticforward PyTypeObject IMarshal_InterfaceType;

staticforward PyTypeObject ICoffeeMachine_InterfaceType;

staticforward PyTypeObject IStream_InterfaceType;

void initdcom(void);static PyTypeObject *ClientConnection_Type;
static PyTypeObject *GUID_Type;
static PyTypeObject *Object_Type;

static bool pack_py_UseProtSeq_args_in(PyObject *args, PyObject *kwargs, struct UseProtSeq *r)
{
	const char *kwnames[] = {
		NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":UseProtSeq", discard_const_p(char *, kwnames))) {
		return false;
	}

	return true;
}

static PyObject *unpack_py_UseProtSeq_args_out(struct UseProtSeq *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	return result;
}

static bool pack_py_GetCustomProtseqInfo_args_in(PyObject *args, PyObject *kwargs, struct GetCustomProtseqInfo *r)
{
	const char *kwnames[] = {
		NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":GetCustomProtseqInfo", discard_const_p(char *, kwnames))) {
		return false;
	}

	return true;
}

static PyObject *unpack_py_GetCustomProtseqInfo_args_out(struct GetCustomProtseqInfo *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	return result;
}

static bool pack_py_UpdateResolverBindings_args_in(PyObject *args, PyObject *kwargs, struct UpdateResolverBindings *r)
{
	const char *kwnames[] = {
		NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":UpdateResolverBindings", discard_const_p(char *, kwnames))) {
		return false;
	}

	return true;
}

static PyObject *unpack_py_UpdateResolverBindings_args_out(struct UpdateResolverBindings *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	return result;
}

const struct PyNdrRpcMethodDef py_ndr_dcom_Unknown_methods[] = {
	{ "UseProtSeq", "S.UseProtSeq() -> None", (py_dcerpc_call_fn)dcerpc_UseProtSeq_r, (py_data_pack_fn)pack_py_UseProtSeq_args_in, (py_data_unpack_fn)unpack_py_UseProtSeq_args_out, 0, &ndr_table_dcom_Unknown },
	{ "GetCustomProtseqInfo", "S.GetCustomProtseqInfo() -> None", (py_dcerpc_call_fn)dcerpc_GetCustomProtseqInfo_r, (py_data_pack_fn)pack_py_GetCustomProtseqInfo_args_in, (py_data_unpack_fn)unpack_py_GetCustomProtseqInfo_args_out, 1, &ndr_table_dcom_Unknown },
	{ "UpdateResolverBindings", "S.UpdateResolverBindings() -> None", (py_dcerpc_call_fn)dcerpc_UpdateResolverBindings_r, (py_data_pack_fn)pack_py_UpdateResolverBindings_args_in, (py_data_unpack_fn)unpack_py_UpdateResolverBindings_args_out, 2, &ndr_table_dcom_Unknown },
	{ NULL }
};

static PyObject *interface_dcom_Unknown_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_interface_init_helper(type, args, kwargs, &ndr_table_dcom_Unknown);
}

static PyTypeObject dcom_Unknown_InterfaceType = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcom.dcom_Unknown",
	.tp_basicsize = sizeof(dcerpc_InterfaceObject),
	.tp_doc = "dcom_Unknown(binding, lp_ctx=None, credentials=None) -> connection\n"
"\n"
"binding should be a DCE/RPC binding string (for example: ncacn_ip_tcp:127.0.0.1)\n"
"lp_ctx should be a path to a smb.conf file or a param.LoadParm object\n"
"credentials should be a credentials.Credentials object.\n\n",
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = interface_dcom_Unknown_new,
};


static bool pack_py_QueryInterface_args_in(PyObject *args, PyObject *kwargs, struct QueryInterface *r)
{
	PyObject *py_ORPCthis;
	PyObject *py_iid;
	const char *kwnames[] = {
		"ORPCthis", "iid", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:QueryInterface", discard_const_p(char *, kwnames), &py_ORPCthis, &py_iid)) {
		return false;
	}

	PyErr_SetString(PyExc_TypeError, "Can not convert C Type struct ORPCTHIS from Python");
	if (py_iid == Py_None) {
		r->in.iid = NULL;
	} else {
		r->in.iid = NULL;
		PY_CHECK_TYPE(GUID_Type, py_iid, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_iid)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.iid = (struct GUID *)pytalloc_get_ptr(py_iid);
	}
	return true;
}

static PyObject *unpack_py_QueryInterface_args_out(struct QueryInterface *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	PyObject *py_data;
	result = PyTuple_New(2);
	py_ORPCthat = NULL;
	PyTuple_SetItem(result, 0, py_ORPCthat);
	if (*r->out.data == NULL) {
		py_data = Py_None;
		Py_INCREF(py_data);
	} else {
		py_data = NULL;
	}
	PyTuple_SetItem(result, 1, py_data);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_AddRef_args_in(PyObject *args, PyObject *kwargs, struct AddRef *r)
{
	PyObject *py_ORPCthis;
	const char *kwnames[] = {
		"ORPCthis", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:AddRef", discard_const_p(char *, kwnames), &py_ORPCthis)) {
		return false;
	}

	PyErr_SetString(PyExc_TypeError, "Can not convert C Type struct ORPCTHIS from Python");
	return true;
}

static PyObject *unpack_py_AddRef_args_out(struct AddRef *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	result = PyTuple_New(2);
	py_ORPCthat = NULL;
	PyTuple_SetItem(result, 0, py_ORPCthat);
	PyTuple_SetItem(result, 1, PyInt_FromLong(r->out.result));
	return result;
}

static bool pack_py_Release_args_in(PyObject *args, PyObject *kwargs, struct Release *r)
{
	PyObject *py_ORPCthis;
	const char *kwnames[] = {
		"ORPCthis", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:Release", discard_const_p(char *, kwnames), &py_ORPCthis)) {
		return false;
	}

	PyErr_SetString(PyExc_TypeError, "Can not convert C Type struct ORPCTHIS from Python");
	return true;
}

static PyObject *unpack_py_Release_args_out(struct Release *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	result = PyTuple_New(2);
	py_ORPCthat = NULL;
	PyTuple_SetItem(result, 0, py_ORPCthat);
	PyTuple_SetItem(result, 1, PyInt_FromLong(r->out.result));
	return result;
}

const struct PyNdrRpcMethodDef py_ndr_IUnknown_methods[] = {
	{ "QueryInterface", "S.QueryInterface(ORPCthis, iid) -> (ORPCthat, data)", (py_dcerpc_call_fn)dcerpc_QueryInterface_r, (py_data_pack_fn)pack_py_QueryInterface_args_in, (py_data_unpack_fn)unpack_py_QueryInterface_args_out, 0, &ndr_table_IUnknown },
	{ "AddRef", "S.AddRef(ORPCthis) -> (ORPCthat, result)", (py_dcerpc_call_fn)dcerpc_AddRef_r, (py_data_pack_fn)pack_py_AddRef_args_in, (py_data_unpack_fn)unpack_py_AddRef_args_out, 1, &ndr_table_IUnknown },
	{ "Release", "S.Release(ORPCthis) -> (ORPCthat, result)", (py_dcerpc_call_fn)dcerpc_Release_r, (py_data_pack_fn)pack_py_Release_args_in, (py_data_unpack_fn)unpack_py_Release_args_out, 2, &ndr_table_IUnknown },
	{ NULL }
};

static PyObject *interface_IUnknown_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_interface_init_helper(type, args, kwargs, &ndr_table_IUnknown);
}

#define PY_DOC_IUNKNOWN "Base interface for all COM interfaces"
static PyTypeObject IUnknown_InterfaceType = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcom.IUnknown",
	.tp_basicsize = sizeof(dcerpc_InterfaceObject),
	.tp_doc = "IUnknown(binding, lp_ctx=None, credentials=None) -> connection\n"
"\n"
"binding should be a DCE/RPC binding string (for example: ncacn_ip_tcp:127.0.0.1)\n"
"lp_ctx should be a path to a smb.conf file or a param.LoadParm object\n"
"credentials should be a credentials.Credentials object.\n\n"PY_DOC_IUNKNOWN,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = interface_IUnknown_new,
};


static bool pack_py_CreateInstance_args_in(PyObject *args, PyObject *kwargs, struct CreateInstance *r)
{
	PyObject *py_ORPCthis;
	PyObject *py_pUnknown;
	PyObject *py_iid;
	const char *kwnames[] = {
		"ORPCthis", "pUnknown", "iid", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:CreateInstance", discard_const_p(char *, kwnames), &py_ORPCthis, &py_pUnknown, &py_iid)) {
		return false;
	}

	PyErr_SetString(PyExc_TypeError, "Can not convert C Type struct ORPCTHIS from Python");
	if (py_pUnknown == Py_None) {
		r->in.pUnknown = NULL;
	} else {
		r->in.pUnknown = NULL;
		PyErr_SetString(PyExc_TypeError, "Can not convert C Type struct MInterfacePointer from Python");
	}
	if (py_iid == Py_None) {
		r->in.iid = NULL;
	} else {
		r->in.iid = NULL;
		PY_CHECK_TYPE(GUID_Type, py_iid, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_iid)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.iid = (struct GUID *)pytalloc_get_ptr(py_iid);
	}
	return true;
}

static PyObject *unpack_py_CreateInstance_args_out(struct CreateInstance *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	PyObject *py_ppv;
	result = PyTuple_New(2);
	py_ORPCthat = NULL;
	PyTuple_SetItem(result, 0, py_ORPCthat);
	if (r->out.ppv == NULL) {
		py_ppv = Py_None;
		Py_INCREF(py_ppv);
	} else {
		py_ppv = NULL;
	}
	PyTuple_SetItem(result, 1, py_ppv);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_RemoteCreateInstance_args_in(PyObject *args, PyObject *kwargs, struct RemoteCreateInstance *r)
{
	PyObject *py_ORPCthis;
	const char *kwnames[] = {
		"ORPCthis", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:RemoteCreateInstance", discard_const_p(char *, kwnames), &py_ORPCthis)) {
		return false;
	}

	PyErr_SetString(PyExc_TypeError, "Can not convert C Type struct ORPCTHIS from Python");
	return true;
}

static PyObject *unpack_py_RemoteCreateInstance_args_out(struct RemoteCreateInstance *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	py_ORPCthat = NULL;
	result = py_ORPCthat;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_LockServer_args_in(PyObject *args, PyObject *kwargs, struct LockServer *r)
{
	PyObject *py_ORPCthis;
	PyObject *py_lock;
	const char *kwnames[] = {
		"ORPCthis", "lock", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:LockServer", discard_const_p(char *, kwnames), &py_ORPCthis, &py_lock)) {
		return false;
	}

	PyErr_SetString(PyExc_TypeError, "Can not convert C Type struct ORPCTHIS from Python");
	PY_CHECK_TYPE(&PyInt_Type, py_lock, return false;);
	r->in.lock = PyInt_AsLong(py_lock);
	return true;
}

static PyObject *unpack_py_LockServer_args_out(struct LockServer *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	py_ORPCthat = NULL;
	result = py_ORPCthat;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_RemoteLockServer_args_in(PyObject *args, PyObject *kwargs, struct RemoteLockServer *r)
{
	PyObject *py_ORPCthis;
	const char *kwnames[] = {
		"ORPCthis", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:RemoteLockServer", discard_const_p(char *, kwnames), &py_ORPCthis)) {
		return false;
	}

	PyErr_SetString(PyExc_TypeError, "Can not convert C Type struct ORPCTHIS from Python");
	return true;
}

static PyObject *unpack_py_RemoteLockServer_args_out(struct RemoteLockServer *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	py_ORPCthat = NULL;
	result = py_ORPCthat;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

const struct PyNdrRpcMethodDef py_ndr_IClassFactory_methods[] = {
	{ "CreateInstance", "S.CreateInstance(ORPCthis, pUnknown, iid) -> (ORPCthat, ppv)", (py_dcerpc_call_fn)dcerpc_CreateInstance_r, (py_data_pack_fn)pack_py_CreateInstance_args_in, (py_data_unpack_fn)unpack_py_CreateInstance_args_out, 0, &ndr_table_IClassFactory },
	{ "RemoteCreateInstance", "S.RemoteCreateInstance(ORPCthis) -> ORPCthat", (py_dcerpc_call_fn)dcerpc_RemoteCreateInstance_r, (py_data_pack_fn)pack_py_RemoteCreateInstance_args_in, (py_data_unpack_fn)unpack_py_RemoteCreateInstance_args_out, 1, &ndr_table_IClassFactory },
	{ "LockServer", "S.LockServer(ORPCthis, lock) -> ORPCthat", (py_dcerpc_call_fn)dcerpc_LockServer_r, (py_data_pack_fn)pack_py_LockServer_args_in, (py_data_unpack_fn)unpack_py_LockServer_args_out, 2, &ndr_table_IClassFactory },
	{ "RemoteLockServer", "S.RemoteLockServer(ORPCthis) -> ORPCthat", (py_dcerpc_call_fn)dcerpc_RemoteLockServer_r, (py_data_pack_fn)pack_py_RemoteLockServer_args_in, (py_data_unpack_fn)unpack_py_RemoteLockServer_args_out, 3, &ndr_table_IClassFactory },
	{ NULL }
};

static PyObject *interface_IClassFactory_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_interface_init_helper(type, args, kwargs, &ndr_table_IClassFactory);
}

static PyTypeObject IClassFactory_InterfaceType = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcom.IClassFactory",
	.tp_basicsize = sizeof(dcerpc_InterfaceObject),
	.tp_doc = "IClassFactory(binding, lp_ctx=None, credentials=None) -> connection\n"
"\n"
"binding should be a DCE/RPC binding string (for example: ncacn_ip_tcp:127.0.0.1)\n"
"lp_ctx should be a path to a smb.conf file or a param.LoadParm object\n"
"credentials should be a credentials.Credentials object.\n\n",
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = interface_IClassFactory_new,
};


static PyObject *py_REMQIRESULT_get_hResult(PyObject *obj, void *closure)
{
	struct REMQIRESULT *object = (struct REMQIRESULT *)pytalloc_get_ptr(obj);
	PyObject *py_hResult;
	py_hResult = PyErr_FromWERROR(object->hResult);
	return py_hResult;
}

static int py_REMQIRESULT_set_hResult(PyObject *py_obj, PyObject *value, void *closure)
{
	struct REMQIRESULT *object = (struct REMQIRESULT *)pytalloc_get_ptr(py_obj);
	object->hResult = W_ERROR(PyInt_AsLong(value));
	return 0;
}

static PyObject *py_REMQIRESULT_get_std(PyObject *obj, void *closure)
{
	struct REMQIRESULT *object = (struct REMQIRESULT *)pytalloc_get_ptr(obj);
	PyObject *py_std;
	py_std = NULL;
	return py_std;
}

static int py_REMQIRESULT_set_std(PyObject *py_obj, PyObject *value, void *closure)
{
	struct REMQIRESULT *object = (struct REMQIRESULT *)pytalloc_get_ptr(py_obj);
	PyErr_SetString(PyExc_TypeError, "Can not convert C Type struct STDOBJREF from Python");
	return 0;
}

static PyGetSetDef py_REMQIRESULT_getsetters[] = {
	{ discard_const_p(char, "hResult"), py_REMQIRESULT_get_hResult, py_REMQIRESULT_set_hResult },
	{ discard_const_p(char, "std"), py_REMQIRESULT_get_std, py_REMQIRESULT_set_std },
	{ NULL }
};

static PyObject *py_REMQIRESULT_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct REMQIRESULT, type);
}

static PyObject *py_REMQIRESULT_ndr_pack(PyObject *py_obj)
{
	struct REMQIRESULT *object = (struct REMQIRESULT *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_REMQIRESULT);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_REMQIRESULT_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct REMQIRESULT *object = (struct REMQIRESULT *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_REMQIRESULT);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_REMQIRESULT);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_REMQIRESULT_ndr_print(PyObject *py_obj)
{
	struct REMQIRESULT *object = (struct REMQIRESULT *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_REMQIRESULT, "REMQIRESULT", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_REMQIRESULT_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_REMQIRESULT_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_REMQIRESULT_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_REMQIRESULT_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject REMQIRESULT_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcom.REMQIRESULT",
	.tp_getset = py_REMQIRESULT_getsetters,
	.tp_methods = py_REMQIRESULT_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_REMQIRESULT_new,
};


static PyObject *py_REMINTERFACEREF_get_ipid(PyObject *obj, void *closure)
{
	struct REMINTERFACEREF *object = (struct REMINTERFACEREF *)pytalloc_get_ptr(obj);
	PyObject *py_ipid;
	py_ipid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->ipid);
	return py_ipid;
}

static int py_REMINTERFACEREF_set_ipid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct REMINTERFACEREF *object = (struct REMINTERFACEREF *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->ipid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_REMINTERFACEREF_get_cPublicRefs(PyObject *obj, void *closure)
{
	struct REMINTERFACEREF *object = (struct REMINTERFACEREF *)pytalloc_get_ptr(obj);
	PyObject *py_cPublicRefs;
	py_cPublicRefs = PyInt_FromLong(object->cPublicRefs);
	return py_cPublicRefs;
}

static int py_REMINTERFACEREF_set_cPublicRefs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct REMINTERFACEREF *object = (struct REMINTERFACEREF *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->cPublicRefs = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_REMINTERFACEREF_get_cPrivateRefs(PyObject *obj, void *closure)
{
	struct REMINTERFACEREF *object = (struct REMINTERFACEREF *)pytalloc_get_ptr(obj);
	PyObject *py_cPrivateRefs;
	py_cPrivateRefs = PyInt_FromLong(object->cPrivateRefs);
	return py_cPrivateRefs;
}

static int py_REMINTERFACEREF_set_cPrivateRefs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct REMINTERFACEREF *object = (struct REMINTERFACEREF *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->cPrivateRefs = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_REMINTERFACEREF_getsetters[] = {
	{ discard_const_p(char, "ipid"), py_REMINTERFACEREF_get_ipid, py_REMINTERFACEREF_set_ipid },
	{ discard_const_p(char, "cPublicRefs"), py_REMINTERFACEREF_get_cPublicRefs, py_REMINTERFACEREF_set_cPublicRefs },
	{ discard_const_p(char, "cPrivateRefs"), py_REMINTERFACEREF_get_cPrivateRefs, py_REMINTERFACEREF_set_cPrivateRefs },
	{ NULL }
};

static PyObject *py_REMINTERFACEREF_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct REMINTERFACEREF, type);
}


static PyTypeObject REMINTERFACEREF_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcom.REMINTERFACEREF",
	.tp_getset = py_REMINTERFACEREF_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_REMINTERFACEREF_new,
};


static bool pack_py_RemQueryInterface_args_in(PyObject *args, PyObject *kwargs, struct RemQueryInterface *r)
{
	PyObject *py_ORPCthis;
	PyObject *py_ripid;
	PyObject *py_cRefs;
	PyObject *py_iids;
	const char *kwnames[] = {
		"ORPCthis", "ripid", "cRefs", "iids", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:RemQueryInterface", discard_const_p(char *, kwnames), &py_ORPCthis, &py_ripid, &py_cRefs, &py_iids)) {
		return false;
	}

	PyErr_SetString(PyExc_TypeError, "Can not convert C Type struct ORPCTHIS from Python");
	if (py_ripid == Py_None) {
		r->in.ripid = NULL;
	} else {
		r->in.ripid = NULL;
		PY_CHECK_TYPE(GUID_Type, py_ripid, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_ripid)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.ripid = (struct GUID *)pytalloc_get_ptr(py_ripid);
	}
	PY_CHECK_TYPE(&PyInt_Type, py_cRefs, return false;);
	r->in.cRefs = PyInt_AsLong(py_cRefs);
	PY_CHECK_TYPE(&PyList_Type, py_iids, return false;);
	r->in.cIids = PyList_GET_SIZE(py_iids);
	if (py_iids == Py_None) {
		r->in.iids = NULL;
	} else {
		r->in.iids = NULL;
		PY_CHECK_TYPE(&PyList_Type, py_iids, return false;);
		{
			int iids_cntr_1;
			r->in.iids = talloc_array_ptrtype(r, r->in.iids, PyList_GET_SIZE(py_iids));
			if (!r->in.iids) { return false;; }
			talloc_set_name_const(r->in.iids, "ARRAY: r->in.iids");
			for (iids_cntr_1 = 0; iids_cntr_1 < PyList_GET_SIZE(py_iids); iids_cntr_1++) {
				PY_CHECK_TYPE(GUID_Type, PyList_GET_ITEM(py_iids, iids_cntr_1), return false;);
				if (talloc_reference(r->in.iids, pytalloc_get_mem_ctx(PyList_GET_ITEM(py_iids, iids_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return false;
				}
				r->in.iids[iids_cntr_1] = *(struct GUID *)pytalloc_get_ptr(PyList_GET_ITEM(py_iids, iids_cntr_1));
			}
		}
	}
	return true;
}

static PyObject *unpack_py_RemQueryInterface_args_out(struct RemQueryInterface *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	PyObject *py_ip;
	result = PyTuple_New(2);
	py_ORPCthat = NULL;
	PyTuple_SetItem(result, 0, py_ORPCthat);
	if (r->out.ip == NULL) {
		py_ip = Py_None;
		Py_INCREF(py_ip);
	} else {
		py_ip = PyList_New(r->in.cIids);
		if (py_ip == NULL) {
			return NULL;
		}
		{
			int ip_cntr_1;
			for (ip_cntr_1 = 0; ip_cntr_1 < r->in.cIids; ip_cntr_1++) {
				PyObject *py_ip_1;
				py_ip_1 = NULL;
				PyList_SetItem(py_ip, ip_cntr_1, py_ip_1);
			}
		}
	}
	PyTuple_SetItem(result, 1, py_ip);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_RemAddRef_args_in(PyObject *args, PyObject *kwargs, struct RemAddRef *r)
{
	PyObject *py_ORPCthis;
	PyObject *py_InterfaceRefs;
	const char *kwnames[] = {
		"ORPCthis", "InterfaceRefs", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:RemAddRef", discard_const_p(char *, kwnames), &py_ORPCthis, &py_InterfaceRefs)) {
		return false;
	}

	PyErr_SetString(PyExc_TypeError, "Can not convert C Type struct ORPCTHIS from Python");
	PY_CHECK_TYPE(&PyList_Type, py_InterfaceRefs, return false;);
	r->in.cInterfaceRefs = PyList_GET_SIZE(py_InterfaceRefs);
	PY_CHECK_TYPE(&PyList_Type, py_InterfaceRefs, return false;);
	{
		int InterfaceRefs_cntr_0;
		r->in.InterfaceRefs = talloc_array_ptrtype(r, r->in.InterfaceRefs, PyList_GET_SIZE(py_InterfaceRefs));
		if (!r->in.InterfaceRefs) { return false;; }
		talloc_set_name_const(r->in.InterfaceRefs, "ARRAY: r->in.InterfaceRefs");
		for (InterfaceRefs_cntr_0 = 0; InterfaceRefs_cntr_0 < PyList_GET_SIZE(py_InterfaceRefs); InterfaceRefs_cntr_0++) {
			PY_CHECK_TYPE(&REMINTERFACEREF_Type, PyList_GET_ITEM(py_InterfaceRefs, InterfaceRefs_cntr_0), return false;);
			if (talloc_reference(r->in.InterfaceRefs, pytalloc_get_mem_ctx(PyList_GET_ITEM(py_InterfaceRefs, InterfaceRefs_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.InterfaceRefs[InterfaceRefs_cntr_0] = *(struct REMINTERFACEREF *)pytalloc_get_ptr(PyList_GET_ITEM(py_InterfaceRefs, InterfaceRefs_cntr_0));
		}
	}
	return true;
}

static PyObject *unpack_py_RemAddRef_args_out(struct RemAddRef *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	PyObject *py_pResults;
	result = PyTuple_New(2);
	py_ORPCthat = NULL;
	PyTuple_SetItem(result, 0, py_ORPCthat);
	if (r->out.pResults == NULL) {
		py_pResults = Py_None;
		Py_INCREF(py_pResults);
	} else {
		py_pResults = PyList_New(r->in.cInterfaceRefs);
		if (py_pResults == NULL) {
			return NULL;
		}
		{
			int pResults_cntr_1;
			for (pResults_cntr_1 = 0; pResults_cntr_1 < r->in.cInterfaceRefs; pResults_cntr_1++) {
				PyObject *py_pResults_1;
				py_pResults_1 = PyErr_FromWERROR(r->out.pResults[pResults_cntr_1]);
				PyList_SetItem(py_pResults, pResults_cntr_1, py_pResults_1);
			}
		}
	}
	PyTuple_SetItem(result, 1, py_pResults);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_RemRelease_args_in(PyObject *args, PyObject *kwargs, struct RemRelease *r)
{
	PyObject *py_ORPCthis;
	PyObject *py_InterfaceRefs;
	const char *kwnames[] = {
		"ORPCthis", "InterfaceRefs", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:RemRelease", discard_const_p(char *, kwnames), &py_ORPCthis, &py_InterfaceRefs)) {
		return false;
	}

	PyErr_SetString(PyExc_TypeError, "Can not convert C Type struct ORPCTHIS from Python");
	PY_CHECK_TYPE(&PyList_Type, py_InterfaceRefs, return false;);
	r->in.cInterfaceRefs = PyList_GET_SIZE(py_InterfaceRefs);
	PY_CHECK_TYPE(&PyList_Type, py_InterfaceRefs, return false;);
	{
		int InterfaceRefs_cntr_0;
		r->in.InterfaceRefs = talloc_array_ptrtype(r, r->in.InterfaceRefs, PyList_GET_SIZE(py_InterfaceRefs));
		if (!r->in.InterfaceRefs) { return false;; }
		talloc_set_name_const(r->in.InterfaceRefs, "ARRAY: r->in.InterfaceRefs");
		for (InterfaceRefs_cntr_0 = 0; InterfaceRefs_cntr_0 < PyList_GET_SIZE(py_InterfaceRefs); InterfaceRefs_cntr_0++) {
			PY_CHECK_TYPE(&REMINTERFACEREF_Type, PyList_GET_ITEM(py_InterfaceRefs, InterfaceRefs_cntr_0), return false;);
			if (talloc_reference(r->in.InterfaceRefs, pytalloc_get_mem_ctx(PyList_GET_ITEM(py_InterfaceRefs, InterfaceRefs_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.InterfaceRefs[InterfaceRefs_cntr_0] = *(struct REMINTERFACEREF *)pytalloc_get_ptr(PyList_GET_ITEM(py_InterfaceRefs, InterfaceRefs_cntr_0));
		}
	}
	return true;
}

static PyObject *unpack_py_RemRelease_args_out(struct RemRelease *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	py_ORPCthat = NULL;
	result = py_ORPCthat;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

const struct PyNdrRpcMethodDef py_ndr_IRemUnknown_methods[] = {
	{ "RemQueryInterface", "S.RemQueryInterface(ORPCthis, ripid, cRefs, iids) -> (ORPCthat, ip)", (py_dcerpc_call_fn)dcerpc_RemQueryInterface_r, (py_data_pack_fn)pack_py_RemQueryInterface_args_in, (py_data_unpack_fn)unpack_py_RemQueryInterface_args_out, 0, &ndr_table_IRemUnknown },
	{ "RemAddRef", "S.RemAddRef(ORPCthis, InterfaceRefs) -> (ORPCthat, pResults)", (py_dcerpc_call_fn)dcerpc_RemAddRef_r, (py_data_pack_fn)pack_py_RemAddRef_args_in, (py_data_unpack_fn)unpack_py_RemAddRef_args_out, 1, &ndr_table_IRemUnknown },
	{ "RemRelease", "S.RemRelease(ORPCthis, InterfaceRefs) -> ORPCthat", (py_dcerpc_call_fn)dcerpc_RemRelease_r, (py_data_pack_fn)pack_py_RemRelease_args_in, (py_data_unpack_fn)unpack_py_RemRelease_args_out, 2, &ndr_table_IRemUnknown },
	{ NULL }
};

static PyObject *interface_IRemUnknown_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_interface_init_helper(type, args, kwargs, &ndr_table_IRemUnknown);
}

#define PY_DOC_IREMUNKNOWN "Remote version of IUnknown"
static PyTypeObject IRemUnknown_InterfaceType = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcom.IRemUnknown",
	.tp_basicsize = sizeof(dcerpc_InterfaceObject),
	.tp_doc = "IRemUnknown(binding, lp_ctx=None, credentials=None) -> connection\n"
"\n"
"binding should be a DCE/RPC binding string (for example: ncacn_ip_tcp:127.0.0.1)\n"
"lp_ctx should be a path to a smb.conf file or a param.LoadParm object\n"
"credentials should be a credentials.Credentials object.\n\n"PY_DOC_IREMUNKNOWN,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = interface_IRemUnknown_new,
};


static bool pack_py_GetClassObject_args_in(PyObject *args, PyObject *kwargs, struct GetClassObject *r)
{
	PyObject *py_ORPCthis;
	PyObject *py_clsid;
	PyObject *py_context;
	PyObject *py_locale;
	PyObject *py_iid;
	const char *kwnames[] = {
		"ORPCthis", "clsid", "context", "locale", "iid", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:GetClassObject", discard_const_p(char *, kwnames), &py_ORPCthis, &py_clsid, &py_context, &py_locale, &py_iid)) {
		return false;
	}

	PyErr_SetString(PyExc_TypeError, "Can not convert C Type struct ORPCTHIS from Python");
	PY_CHECK_TYPE(GUID_Type, py_clsid, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_clsid)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.clsid = *(struct GUID *)pytalloc_get_ptr(py_clsid);
	PY_CHECK_TYPE(&PyInt_Type, py_context, return false;);
	r->in.context = PyInt_AsLong(py_context);
	PY_CHECK_TYPE(&PyInt_Type, py_locale, return false;);
	r->in.locale = PyInt_AsLong(py_locale);
	PY_CHECK_TYPE(GUID_Type, py_iid, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_iid)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.iid = *(struct GUID *)pytalloc_get_ptr(py_iid);
	return true;
}

static PyObject *unpack_py_GetClassObject_args_out(struct GetClassObject *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	PyObject *py_data;
	result = PyTuple_New(2);
	py_ORPCthat = NULL;
	PyTuple_SetItem(result, 0, py_ORPCthat);
	py_data = NULL;
	PyTuple_SetItem(result, 1, py_data);
	return result;
}

const struct PyNdrRpcMethodDef py_ndr_IClassActivator_methods[] = {
	{ "GetClassObject", "S.GetClassObject(ORPCthis, clsid, context, locale, iid) -> (ORPCthat, data)", (py_dcerpc_call_fn)dcerpc_GetClassObject_r, (py_data_pack_fn)pack_py_GetClassObject_args_in, (py_data_unpack_fn)unpack_py_GetClassObject_args_out, 0, &ndr_table_IClassActivator },
	{ NULL }
};

static PyObject *interface_IClassActivator_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_interface_init_helper(type, args, kwargs, &ndr_table_IClassActivator);
}

static PyTypeObject IClassActivator_InterfaceType = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcom.IClassActivator",
	.tp_basicsize = sizeof(dcerpc_InterfaceObject),
	.tp_doc = "IClassActivator(binding, lp_ctx=None, credentials=None) -> connection\n"
"\n"
"binding should be a DCE/RPC binding string (for example: ncacn_ip_tcp:127.0.0.1)\n"
"lp_ctx should be a path to a smb.conf file or a param.LoadParm object\n"
"credentials should be a credentials.Credentials object.\n\n",
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = interface_IClassActivator_new,
};


static bool pack_py_ISCMLocalActivator_CreateInstance_args_in(PyObject *args, PyObject *kwargs, struct ISCMLocalActivator_CreateInstance *r)
{
	PyObject *py_ORPCthis;
	const char *kwnames[] = {
		"ORPCthis", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:ISCMLocalActivator_CreateInstance", discard_const_p(char *, kwnames), &py_ORPCthis)) {
		return false;
	}

	PyErr_SetString(PyExc_TypeError, "Can not convert C Type struct ORPCTHIS from Python");
	return true;
}

static PyObject *unpack_py_ISCMLocalActivator_CreateInstance_args_out(struct ISCMLocalActivator_CreateInstance *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	py_ORPCthat = NULL;
	result = py_ORPCthat;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

const struct PyNdrRpcMethodDef py_ndr_ISCMLocalActivator_methods[] = {
	{ "CreateInstance", "S.CreateInstance(ORPCthis) -> ORPCthat", (py_dcerpc_call_fn)dcerpc_ISCMLocalActivator_CreateInstance_r, (py_data_pack_fn)pack_py_ISCMLocalActivator_CreateInstance_args_in, (py_data_unpack_fn)unpack_py_ISCMLocalActivator_CreateInstance_args_out, 0, &ndr_table_ISCMLocalActivator },
	{ NULL }
};

static PyObject *interface_ISCMLocalActivator_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_interface_init_helper(type, args, kwargs, &ndr_table_ISCMLocalActivator);
}

static PyTypeObject ISCMLocalActivator_InterfaceType = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcom.ISCMLocalActivator",
	.tp_basicsize = sizeof(dcerpc_InterfaceObject),
	.tp_doc = "ISCMLocalActivator(binding, lp_ctx=None, credentials=None) -> connection\n"
"\n"
"binding should be a DCE/RPC binding string (for example: ncacn_ip_tcp:127.0.0.1)\n"
"lp_ctx should be a path to a smb.conf file or a param.LoadParm object\n"
"credentials should be a credentials.Credentials object.\n\n",
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = interface_ISCMLocalActivator_new,
};


static bool pack_py_IMachineLocalActivator_foo_args_in(PyObject *args, PyObject *kwargs, struct IMachineLocalActivator_foo *r)
{
	const char *kwnames[] = {
		NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":IMachineLocalActivator_foo", discard_const_p(char *, kwnames))) {
		return false;
	}

	return true;
}

static PyObject *unpack_py_IMachineLocalActivator_foo_args_out(struct IMachineLocalActivator_foo *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

const struct PyNdrRpcMethodDef py_ndr_IMachineLocalActivator_methods[] = {
	{ "foo", "S.foo() -> None", (py_dcerpc_call_fn)dcerpc_IMachineLocalActivator_foo_r, (py_data_pack_fn)pack_py_IMachineLocalActivator_foo_args_in, (py_data_unpack_fn)unpack_py_IMachineLocalActivator_foo_args_out, 0, &ndr_table_IMachineLocalActivator },
	{ NULL }
};

static PyObject *interface_IMachineLocalActivator_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_interface_init_helper(type, args, kwargs, &ndr_table_IMachineLocalActivator);
}

static PyTypeObject IMachineLocalActivator_InterfaceType = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcom.IMachineLocalActivator",
	.tp_basicsize = sizeof(dcerpc_InterfaceObject),
	.tp_doc = "IMachineLocalActivator(binding, lp_ctx=None, credentials=None) -> connection\n"
"\n"
"binding should be a DCE/RPC binding string (for example: ncacn_ip_tcp:127.0.0.1)\n"
"lp_ctx should be a path to a smb.conf file or a param.LoadParm object\n"
"credentials should be a credentials.Credentials object.\n\n",
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = interface_IMachineLocalActivator_new,
};


static bool pack_py_ILocalObjectExporter_Foo_args_in(PyObject *args, PyObject *kwargs, struct ILocalObjectExporter_Foo *r)
{
	const char *kwnames[] = {
		NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":ILocalObjectExporter_Foo", discard_const_p(char *, kwnames))) {
		return false;
	}

	return true;
}

static PyObject *unpack_py_ILocalObjectExporter_Foo_args_out(struct ILocalObjectExporter_Foo *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

const struct PyNdrRpcMethodDef py_ndr_ILocalObjectExporter_methods[] = {
	{ "Foo", "S.Foo() -> None", (py_dcerpc_call_fn)dcerpc_ILocalObjectExporter_Foo_r, (py_data_pack_fn)pack_py_ILocalObjectExporter_Foo_args_in, (py_data_unpack_fn)unpack_py_ILocalObjectExporter_Foo_args_out, 0, &ndr_table_ILocalObjectExporter },
	{ NULL }
};

static PyObject *interface_ILocalObjectExporter_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_interface_init_helper(type, args, kwargs, &ndr_table_ILocalObjectExporter);
}

static PyTypeObject ILocalObjectExporter_InterfaceType = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcom.ILocalObjectExporter",
	.tp_basicsize = sizeof(dcerpc_InterfaceObject),
	.tp_doc = "ILocalObjectExporter(binding, lp_ctx=None, credentials=None) -> connection\n"
"\n"
"binding should be a DCE/RPC binding string (for example: ncacn_ip_tcp:127.0.0.1)\n"
"lp_ctx should be a path to a smb.conf file or a param.LoadParm object\n"
"credentials should be a credentials.Credentials object.\n\n",
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = interface_ILocalObjectExporter_new,
};


static bool pack_py_ISystemActivatorRemoteCreateInstance_args_in(PyObject *args, PyObject *kwargs, struct ISystemActivatorRemoteCreateInstance *r)
{
	PyObject *py_ORPCthis;
	PyObject *py_unknown1;
	PyObject *py_iface1;
	PyObject *py_unknown2;
	const char *kwnames[] = {
		"ORPCthis", "unknown1", "iface1", "unknown2", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:ISystemActivatorRemoteCreateInstance", discard_const_p(char *, kwnames), &py_ORPCthis, &py_unknown1, &py_iface1, &py_unknown2)) {
		return false;
	}

	PyErr_SetString(PyExc_TypeError, "Can not convert C Type struct ORPCTHIS from Python");
	if (PyLong_Check(py_unknown1)) {
		r->in.unknown1 = PyLong_AsLongLong(py_unknown1);
	} else if (PyInt_Check(py_unknown1)) {
		r->in.unknown1 = PyInt_AsLong(py_unknown1);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	PyErr_SetString(PyExc_TypeError, "Can not convert C Type struct MInterfacePointer from Python");
	if (PyLong_Check(py_unknown2)) {
		r->in.unknown2 = PyLong_AsLongLong(py_unknown2);
	} else if (PyInt_Check(py_unknown2)) {
		r->in.unknown2 = PyInt_AsLong(py_unknown2);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	return true;
}

static PyObject *unpack_py_ISystemActivatorRemoteCreateInstance_args_out(struct ISystemActivatorRemoteCreateInstance *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	PyObject *py_unknown3;
	PyObject *py_iface2;
	result = PyTuple_New(3);
	py_ORPCthat = NULL;
	PyTuple_SetItem(result, 0, py_ORPCthat);
	py_unknown3 = PyInt_FromLong(*r->out.unknown3);
	PyTuple_SetItem(result, 1, py_unknown3);
	py_iface2 = NULL;
	PyTuple_SetItem(result, 2, py_iface2);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

const struct PyNdrRpcMethodDef py_ndr_ISystemActivator_methods[] = {
	{ "ISystemActivatorRemoteCreateInstance", "S.ISystemActivatorRemoteCreateInstance(ORPCthis, unknown1, iface1, unknown2) -> (ORPCthat, unknown3, iface2)", (py_dcerpc_call_fn)dcerpc_ISystemActivatorRemoteCreateInstance_r, (py_data_pack_fn)pack_py_ISystemActivatorRemoteCreateInstance_args_in, (py_data_unpack_fn)unpack_py_ISystemActivatorRemoteCreateInstance_args_out, 0, &ndr_table_ISystemActivator },
	{ NULL }
};

static PyObject *interface_ISystemActivator_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_interface_init_helper(type, args, kwargs, &ndr_table_ISystemActivator);
}

static PyTypeObject ISystemActivator_InterfaceType = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcom.ISystemActivator",
	.tp_basicsize = sizeof(dcerpc_InterfaceObject),
	.tp_doc = "ISystemActivator(binding, lp_ctx=None, credentials=None) -> connection\n"
"\n"
"binding should be a DCE/RPC binding string (for example: ncacn_ip_tcp:127.0.0.1)\n"
"lp_ctx should be a path to a smb.conf file or a param.LoadParm object\n"
"credentials should be a credentials.Credentials object.\n\n",
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = interface_ISystemActivator_new,
};


static bool pack_py_RemQueryInterface2_args_in(PyObject *args, PyObject *kwargs, struct RemQueryInterface2 *r)
{
	PyObject *py_ORPCthis;
	PyObject *py_ripid;
	PyObject *py_iids;
	const char *kwnames[] = {
		"ORPCthis", "ripid", "iids", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:RemQueryInterface2", discard_const_p(char *, kwnames), &py_ORPCthis, &py_ripid, &py_iids)) {
		return false;
	}

	PyErr_SetString(PyExc_TypeError, "Can not convert C Type struct ORPCTHIS from Python");
	if (py_ripid == Py_None) {
		r->in.ripid = NULL;
	} else {
		r->in.ripid = NULL;
		PY_CHECK_TYPE(GUID_Type, py_ripid, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_ripid)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.ripid = (struct GUID *)pytalloc_get_ptr(py_ripid);
	}
	PY_CHECK_TYPE(&PyList_Type, py_iids, return false;);
	r->in.cIids = PyList_GET_SIZE(py_iids);
	if (py_iids == Py_None) {
		r->in.iids = NULL;
	} else {
		r->in.iids = NULL;
		PY_CHECK_TYPE(&PyList_Type, py_iids, return false;);
		{
			int iids_cntr_1;
			r->in.iids = talloc_array_ptrtype(r, r->in.iids, PyList_GET_SIZE(py_iids));
			if (!r->in.iids) { return false;; }
			talloc_set_name_const(r->in.iids, "ARRAY: r->in.iids");
			for (iids_cntr_1 = 0; iids_cntr_1 < PyList_GET_SIZE(py_iids); iids_cntr_1++) {
				PY_CHECK_TYPE(GUID_Type, PyList_GET_ITEM(py_iids, iids_cntr_1), return false;);
				if (talloc_reference(r->in.iids, pytalloc_get_mem_ctx(PyList_GET_ITEM(py_iids, iids_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return false;
				}
				r->in.iids[iids_cntr_1] = *(struct GUID *)pytalloc_get_ptr(PyList_GET_ITEM(py_iids, iids_cntr_1));
			}
		}
	}
	return true;
}

static PyObject *unpack_py_RemQueryInterface2_args_out(struct RemQueryInterface2 *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	PyObject *py_phr;
	PyObject *py_ppMIF;
	result = PyTuple_New(3);
	py_ORPCthat = NULL;
	PyTuple_SetItem(result, 0, py_ORPCthat);
	if (r->out.phr == NULL) {
		py_phr = Py_None;
		Py_INCREF(py_phr);
	} else {
		py_phr = PyList_New(r->in.cIids);
		if (py_phr == NULL) {
			return NULL;
		}
		{
			int phr_cntr_1;
			for (phr_cntr_1 = 0; phr_cntr_1 < r->in.cIids; phr_cntr_1++) {
				PyObject *py_phr_1;
				py_phr_1 = PyErr_FromWERROR(r->out.phr[phr_cntr_1]);
				PyList_SetItem(py_phr, phr_cntr_1, py_phr_1);
			}
		}
	}
	PyTuple_SetItem(result, 1, py_phr);
	if (r->out.ppMIF == NULL) {
		py_ppMIF = Py_None;
		Py_INCREF(py_ppMIF);
	} else {
		py_ppMIF = PyList_New(r->in.cIids);
		if (py_ppMIF == NULL) {
			return NULL;
		}
		{
			int ppMIF_cntr_1;
			for (ppMIF_cntr_1 = 0; ppMIF_cntr_1 < r->in.cIids; ppMIF_cntr_1++) {
				PyObject *py_ppMIF_1;
				py_ppMIF_1 = NULL;
				PyList_SetItem(py_ppMIF, ppMIF_cntr_1, py_ppMIF_1);
			}
		}
	}
	PyTuple_SetItem(result, 2, py_ppMIF);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

const struct PyNdrRpcMethodDef py_ndr_IRemUnknown2_methods[] = {
	{ "RemQueryInterface2", "S.RemQueryInterface2(ORPCthis, ripid, iids) -> (ORPCthat, phr, ppMIF)", (py_dcerpc_call_fn)dcerpc_RemQueryInterface2_r, (py_data_pack_fn)pack_py_RemQueryInterface2_args_in, (py_data_unpack_fn)unpack_py_RemQueryInterface2_args_out, 0, &ndr_table_IRemUnknown2 },
	{ NULL }
};

static PyObject *interface_IRemUnknown2_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_interface_init_helper(type, args, kwargs, &ndr_table_IRemUnknown2);
}

static PyTypeObject IRemUnknown2_InterfaceType = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcom.IRemUnknown2",
	.tp_basicsize = sizeof(dcerpc_InterfaceObject),
	.tp_doc = "IRemUnknown2(binding, lp_ctx=None, credentials=None) -> connection\n"
"\n"
"binding should be a DCE/RPC binding string (for example: ncacn_ip_tcp:127.0.0.1)\n"
"lp_ctx should be a path to a smb.conf file or a param.LoadParm object\n"
"credentials should be a credentials.Credentials object.\n\n",
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = interface_IRemUnknown2_new,
};


static PyObject *py_REF_ITypeInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct REF_ITypeInfo, type);
}


static PyTypeObject REF_ITypeInfo_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcom.REF_ITypeInfo",
	.tp_getset = NULL,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_REF_ITypeInfo_new,
};


static PyObject *py_VARIANT_get_vartype(PyObject *obj, void *closure)
{
	struct VARIANT *object = (struct VARIANT *)pytalloc_get_ptr(obj);
	PyObject *py_vartype;
	py_vartype = PyInt_FromLong(object->vartype);
	return py_vartype;
}

static int py_VARIANT_set_vartype(PyObject *py_obj, PyObject *value, void *closure)
{
	struct VARIANT *object = (struct VARIANT *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->vartype = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_VARIANT_get_FIXME(PyObject *obj, void *closure)
{
	struct VARIANT *object = (struct VARIANT *)pytalloc_get_ptr(obj);
	PyObject *py_FIXME;
	py_FIXME = PyInt_FromLong(object->FIXME);
	return py_FIXME;
}

static int py_VARIANT_set_FIXME(PyObject *py_obj, PyObject *value, void *closure)
{
	struct VARIANT *object = (struct VARIANT *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->FIXME = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_VARIANT_getsetters[] = {
	{ discard_const_p(char, "vartype"), py_VARIANT_get_vartype, py_VARIANT_set_vartype },
	{ discard_const_p(char, "FIXME"), py_VARIANT_get_FIXME, py_VARIANT_set_FIXME },
	{ NULL }
};

static PyObject *py_VARIANT_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct VARIANT, type);
}


static PyTypeObject VARIANT_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcom.VARIANT",
	.tp_getset = py_VARIANT_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_VARIANT_new,
};


static PyObject *py_DISPPARAMS_get_FIXME(PyObject *obj, void *closure)
{
	struct DISPPARAMS *object = (struct DISPPARAMS *)pytalloc_get_ptr(obj);
	PyObject *py_FIXME;
	py_FIXME = PyInt_FromLong(object->FIXME);
	return py_FIXME;
}

static int py_DISPPARAMS_set_FIXME(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DISPPARAMS *object = (struct DISPPARAMS *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->FIXME = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_DISPPARAMS_getsetters[] = {
	{ discard_const_p(char, "FIXME"), py_DISPPARAMS_get_FIXME, py_DISPPARAMS_set_FIXME },
	{ NULL }
};

static PyObject *py_DISPPARAMS_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DISPPARAMS, type);
}


static PyTypeObject DISPPARAMS_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcom.DISPPARAMS",
	.tp_getset = py_DISPPARAMS_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_DISPPARAMS_new,
};


static PyObject *py_EXCEPINFO_get_FIXME(PyObject *obj, void *closure)
{
	struct EXCEPINFO *object = (struct EXCEPINFO *)pytalloc_get_ptr(obj);
	PyObject *py_FIXME;
	py_FIXME = PyInt_FromLong(object->FIXME);
	return py_FIXME;
}

static int py_EXCEPINFO_set_FIXME(PyObject *py_obj, PyObject *value, void *closure)
{
	struct EXCEPINFO *object = (struct EXCEPINFO *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->FIXME = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_EXCEPINFO_getsetters[] = {
	{ discard_const_p(char, "FIXME"), py_EXCEPINFO_get_FIXME, py_EXCEPINFO_set_FIXME },
	{ NULL }
};

static PyObject *py_EXCEPINFO_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct EXCEPINFO, type);
}


static PyTypeObject EXCEPINFO_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcom.EXCEPINFO",
	.tp_getset = py_EXCEPINFO_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_EXCEPINFO_new,
};


static bool pack_py_GetTypeInfoCount_args_in(PyObject *args, PyObject *kwargs, struct GetTypeInfoCount *r)
{
	PyObject *py_ORPCthis;
	const char *kwnames[] = {
		"ORPCthis", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:GetTypeInfoCount", discard_const_p(char *, kwnames), &py_ORPCthis)) {
		return false;
	}

	PyErr_SetString(PyExc_TypeError, "Can not convert C Type struct ORPCTHIS from Python");
	return true;
}

static PyObject *unpack_py_GetTypeInfoCount_args_out(struct GetTypeInfoCount *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	PyObject *py_pctinfo;
	result = PyTuple_New(2);
	py_ORPCthat = NULL;
	PyTuple_SetItem(result, 0, py_ORPCthat);
	if (r->out.pctinfo == NULL) {
		py_pctinfo = Py_None;
		Py_INCREF(py_pctinfo);
	} else {
		py_pctinfo = PyInt_FromLong(*r->out.pctinfo);
	}
	PyTuple_SetItem(result, 1, py_pctinfo);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_GetTypeInfo_args_in(PyObject *args, PyObject *kwargs, struct GetTypeInfo *r)
{
	PyObject *py_ORPCthis;
	PyObject *py_iTInfo;
	PyObject *py_lcid;
	const char *kwnames[] = {
		"ORPCthis", "iTInfo", "lcid", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:GetTypeInfo", discard_const_p(char *, kwnames), &py_ORPCthis, &py_iTInfo, &py_lcid)) {
		return false;
	}

	PyErr_SetString(PyExc_TypeError, "Can not convert C Type struct ORPCTHIS from Python");
	PY_CHECK_TYPE(&PyInt_Type, py_iTInfo, return false;);
	r->in.iTInfo = PyInt_AsLong(py_iTInfo);
	PY_CHECK_TYPE(&PyInt_Type, py_lcid, return false;);
	r->in.lcid = PyInt_AsLong(py_lcid);
	return true;
}

static PyObject *unpack_py_GetTypeInfo_args_out(struct GetTypeInfo *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	PyObject *py_ppTInfo;
	result = PyTuple_New(2);
	py_ORPCthat = NULL;
	PyTuple_SetItem(result, 0, py_ORPCthat);
	if (r->out.ppTInfo == NULL) {
		py_ppTInfo = Py_None;
		Py_INCREF(py_ppTInfo);
	} else {
		py_ppTInfo = pytalloc_reference_ex(&REF_ITypeInfo_Type, r->out.ppTInfo, r->out.ppTInfo);
	}
	PyTuple_SetItem(result, 1, py_ppTInfo);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_GetIDsOfNames_args_in(PyObject *args, PyObject *kwargs, struct GetIDsOfNames *r)
{
	PyObject *py_ORPCthis;
	PyObject *py_riid;
	PyObject *py_cNames;
	PyObject *py_lcid;
	const char *kwnames[] = {
		"ORPCthis", "riid", "cNames", "lcid", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:GetIDsOfNames", discard_const_p(char *, kwnames), &py_ORPCthis, &py_riid, &py_cNames, &py_lcid)) {
		return false;
	}

	PyErr_SetString(PyExc_TypeError, "Can not convert C Type struct ORPCTHIS from Python");
	if (py_riid == Py_None) {
		r->in.riid = NULL;
	} else {
		r->in.riid = NULL;
		PY_CHECK_TYPE(GUID_Type, py_riid, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_riid)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.riid = (struct GUID *)pytalloc_get_ptr(py_riid);
	}
	PY_CHECK_TYPE(&PyInt_Type, py_cNames, return false;);
	r->in.cNames = PyInt_AsLong(py_cNames);
	PY_CHECK_TYPE(&PyInt_Type, py_lcid, return false;);
	r->in.lcid = PyInt_AsLong(py_lcid);
	return true;
}

static PyObject *unpack_py_GetIDsOfNames_args_out(struct GetIDsOfNames *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	PyObject *py_rgDispId;
	result = PyTuple_New(2);
	py_ORPCthat = NULL;
	PyTuple_SetItem(result, 0, py_ORPCthat);
	if (r->out.rgDispId == NULL) {
		py_rgDispId = Py_None;
		Py_INCREF(py_rgDispId);
	} else {
		py_rgDispId = PyList_New(r->in.cNames);
		if (py_rgDispId == NULL) {
			return NULL;
		}
		{
			int rgDispId_cntr_1;
			for (rgDispId_cntr_1 = 0; rgDispId_cntr_1 < r->in.cNames; rgDispId_cntr_1++) {
				PyObject *py_rgDispId_1;
				py_rgDispId_1 = PyInt_FromLong(r->out.rgDispId[rgDispId_cntr_1]);
				PyList_SetItem(py_rgDispId, rgDispId_cntr_1, py_rgDispId_1);
			}
		}
	}
	PyTuple_SetItem(result, 1, py_rgDispId);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_Invoke_args_in(PyObject *args, PyObject *kwargs, struct Invoke *r)
{
	PyObject *py_ORPCthis;
	PyObject *py_dispIdMember;
	PyObject *py_riid;
	PyObject *py_lcid;
	PyObject *py_wFlags;
	PyObject *py_pDispParams;
	const char *kwnames[] = {
		"ORPCthis", "dispIdMember", "riid", "lcid", "wFlags", "pDispParams", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOO:Invoke", discard_const_p(char *, kwnames), &py_ORPCthis, &py_dispIdMember, &py_riid, &py_lcid, &py_wFlags, &py_pDispParams)) {
		return false;
	}

	PyErr_SetString(PyExc_TypeError, "Can not convert C Type struct ORPCTHIS from Python");
	PY_CHECK_TYPE(&PyInt_Type, py_dispIdMember, return false;);
	r->in.dispIdMember = PyInt_AsLong(py_dispIdMember);
	if (py_riid == Py_None) {
		r->in.riid = NULL;
	} else {
		r->in.riid = NULL;
		PY_CHECK_TYPE(GUID_Type, py_riid, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_riid)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.riid = (struct GUID *)pytalloc_get_ptr(py_riid);
	}
	PY_CHECK_TYPE(&PyInt_Type, py_lcid, return false;);
	r->in.lcid = PyInt_AsLong(py_lcid);
	PY_CHECK_TYPE(&PyInt_Type, py_wFlags, return false;);
	r->in.wFlags = PyInt_AsLong(py_wFlags);
	if (py_pDispParams == Py_None) {
		r->in.pDispParams = NULL;
	} else {
		r->in.pDispParams = NULL;
		PY_CHECK_TYPE(&DISPPARAMS_Type, py_pDispParams, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_pDispParams)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.pDispParams = (struct DISPPARAMS *)pytalloc_get_ptr(py_pDispParams);
	}
	return true;
}

static PyObject *unpack_py_Invoke_args_out(struct Invoke *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	PyObject *py_pDispParams;
	PyObject *py_pVarResult;
	PyObject *py_pExcepInfo;
	PyObject *py_puArgErr;
	result = PyTuple_New(5);
	py_ORPCthat = NULL;
	PyTuple_SetItem(result, 0, py_ORPCthat);
	if (r->out.pDispParams == NULL) {
		py_pDispParams = Py_None;
		Py_INCREF(py_pDispParams);
	} else {
		py_pDispParams = pytalloc_reference_ex(&DISPPARAMS_Type, r->out.pDispParams, r->out.pDispParams);
	}
	PyTuple_SetItem(result, 1, py_pDispParams);
	if (r->out.pVarResult == NULL) {
		py_pVarResult = Py_None;
		Py_INCREF(py_pVarResult);
	} else {
		py_pVarResult = pytalloc_reference_ex(&VARIANT_Type, r->out.pVarResult, r->out.pVarResult);
	}
	PyTuple_SetItem(result, 2, py_pVarResult);
	if (r->out.pExcepInfo == NULL) {
		py_pExcepInfo = Py_None;
		Py_INCREF(py_pExcepInfo);
	} else {
		py_pExcepInfo = pytalloc_reference_ex(&EXCEPINFO_Type, r->out.pExcepInfo, r->out.pExcepInfo);
	}
	PyTuple_SetItem(result, 3, py_pExcepInfo);
	if (r->out.puArgErr == NULL) {
		py_puArgErr = Py_None;
		Py_INCREF(py_puArgErr);
	} else {
		py_puArgErr = PyInt_FromLong(*r->out.puArgErr);
	}
	PyTuple_SetItem(result, 4, py_puArgErr);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

const struct PyNdrRpcMethodDef py_ndr_IDispatch_methods[] = {
	{ "GetTypeInfoCount", "S.GetTypeInfoCount(ORPCthis) -> (ORPCthat, pctinfo)", (py_dcerpc_call_fn)dcerpc_GetTypeInfoCount_r, (py_data_pack_fn)pack_py_GetTypeInfoCount_args_in, (py_data_unpack_fn)unpack_py_GetTypeInfoCount_args_out, 0, &ndr_table_IDispatch },
	{ "GetTypeInfo", "S.GetTypeInfo(ORPCthis, iTInfo, lcid) -> (ORPCthat, ppTInfo)", (py_dcerpc_call_fn)dcerpc_GetTypeInfo_r, (py_data_pack_fn)pack_py_GetTypeInfo_args_in, (py_data_unpack_fn)unpack_py_GetTypeInfo_args_out, 1, &ndr_table_IDispatch },
	{ "GetIDsOfNames", "S.GetIDsOfNames(ORPCthis, riid, cNames, lcid) -> (ORPCthat, rgDispId)", (py_dcerpc_call_fn)dcerpc_GetIDsOfNames_r, (py_data_pack_fn)pack_py_GetIDsOfNames_args_in, (py_data_unpack_fn)unpack_py_GetIDsOfNames_args_out, 2, &ndr_table_IDispatch },
	{ "Invoke", "S.Invoke(ORPCthis, dispIdMember, riid, lcid, wFlags, pDispParams) -> (ORPCthat, pDispParams, pVarResult, pExcepInfo, puArgErr)", (py_dcerpc_call_fn)dcerpc_Invoke_r, (py_data_pack_fn)pack_py_Invoke_args_in, (py_data_unpack_fn)unpack_py_Invoke_args_out, 3, &ndr_table_IDispatch },
	{ NULL }
};

static PyObject *interface_IDispatch_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_interface_init_helper(type, args, kwargs, &ndr_table_IDispatch);
}

static PyTypeObject IDispatch_InterfaceType = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcom.IDispatch",
	.tp_basicsize = sizeof(dcerpc_InterfaceObject),
	.tp_doc = "IDispatch(binding, lp_ctx=None, credentials=None) -> connection\n"
"\n"
"binding should be a DCE/RPC binding string (for example: ncacn_ip_tcp:127.0.0.1)\n"
"lp_ctx should be a path to a smb.conf file or a param.LoadParm object\n"
"credentials should be a credentials.Credentials object.\n\n",
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = interface_IDispatch_new,
};


static bool pack_py_MarshalInterface_args_in(PyObject *args, PyObject *kwargs, struct MarshalInterface *r)
{
	PyObject *py_ORPCthis;
	const char *kwnames[] = {
		"ORPCthis", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:MarshalInterface", discard_const_p(char *, kwnames), &py_ORPCthis)) {
		return false;
	}

	PyErr_SetString(PyExc_TypeError, "Can not convert C Type struct ORPCTHIS from Python");
	return true;
}

static PyObject *unpack_py_MarshalInterface_args_out(struct MarshalInterface *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	py_ORPCthat = NULL;
	result = py_ORPCthat;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_UnMarshalInterface_args_in(PyObject *args, PyObject *kwargs, struct UnMarshalInterface *r)
{
	PyObject *py_ORPCthis;
	const char *kwnames[] = {
		"ORPCthis", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:UnMarshalInterface", discard_const_p(char *, kwnames), &py_ORPCthis)) {
		return false;
	}

	PyErr_SetString(PyExc_TypeError, "Can not convert C Type struct ORPCTHIS from Python");
	return true;
}

static PyObject *unpack_py_UnMarshalInterface_args_out(struct UnMarshalInterface *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	py_ORPCthat = NULL;
	result = py_ORPCthat;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

const struct PyNdrRpcMethodDef py_ndr_IMarshal_methods[] = {
	{ "MarshalInterface", "S.MarshalInterface(ORPCthis) -> ORPCthat", (py_dcerpc_call_fn)dcerpc_MarshalInterface_r, (py_data_pack_fn)pack_py_MarshalInterface_args_in, (py_data_unpack_fn)unpack_py_MarshalInterface_args_out, 0, &ndr_table_IMarshal },
	{ "UnMarshalInterface", "S.UnMarshalInterface(ORPCthis) -> ORPCthat", (py_dcerpc_call_fn)dcerpc_UnMarshalInterface_r, (py_data_pack_fn)pack_py_UnMarshalInterface_args_in, (py_data_unpack_fn)unpack_py_UnMarshalInterface_args_out, 1, &ndr_table_IMarshal },
	{ NULL }
};

static PyObject *interface_IMarshal_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_interface_init_helper(type, args, kwargs, &ndr_table_IMarshal);
}

static PyTypeObject IMarshal_InterfaceType = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcom.IMarshal",
	.tp_basicsize = sizeof(dcerpc_InterfaceObject),
	.tp_doc = "IMarshal(binding, lp_ctx=None, credentials=None) -> connection\n"
"\n"
"binding should be a DCE/RPC binding string (for example: ncacn_ip_tcp:127.0.0.1)\n"
"lp_ctx should be a path to a smb.conf file or a param.LoadParm object\n"
"credentials should be a credentials.Credentials object.\n\n",
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = interface_IMarshal_new,
};


static bool pack_py_MakeCoffee_args_in(PyObject *args, PyObject *kwargs, struct MakeCoffee *r)
{
	PyObject *py_ORPCthis;
	PyObject *py_flavor;
	const char *kwnames[] = {
		"ORPCthis", "flavor", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:MakeCoffee", discard_const_p(char *, kwnames), &py_ORPCthis, &py_flavor)) {
		return false;
	}

	PyErr_SetString(PyExc_TypeError, "Can not convert C Type struct ORPCTHIS from Python");
	r->in.flavor = talloc_ptrtype(r, r->in.flavor);
	if (PyUnicode_Check(py_flavor)) {
		r->in.flavor = PyString_AS_STRING(PyUnicode_AsEncodedString(py_flavor, "utf-8", "ignore"));
	} else if (PyString_Check(py_flavor)) {
		r->in.flavor = PyString_AS_STRING(py_flavor);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_flavor)->tp_name);
		return false;
	}
	return true;
}

static PyObject *unpack_py_MakeCoffee_args_out(struct MakeCoffee *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	py_ORPCthat = NULL;
	result = py_ORPCthat;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

const struct PyNdrRpcMethodDef py_ndr_ICoffeeMachine_methods[] = {
	{ "MakeCoffee", "S.MakeCoffee(ORPCthis, flavor) -> ORPCthat", (py_dcerpc_call_fn)dcerpc_MakeCoffee_r, (py_data_pack_fn)pack_py_MakeCoffee_args_in, (py_data_unpack_fn)unpack_py_MakeCoffee_args_out, 0, &ndr_table_ICoffeeMachine },
	{ NULL }
};

static PyObject *interface_ICoffeeMachine_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_interface_init_helper(type, args, kwargs, &ndr_table_ICoffeeMachine);
}

#define PY_DOC_ICOFFEEMACHINE "ICoffeeMachine Interface"
static PyTypeObject ICoffeeMachine_InterfaceType = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcom.ICoffeeMachine",
	.tp_basicsize = sizeof(dcerpc_InterfaceObject),
	.tp_doc = "ICoffeeMachine(binding, lp_ctx=None, credentials=None) -> connection\n"
"\n"
"binding should be a DCE/RPC binding string (for example: ncacn_ip_tcp:127.0.0.1)\n"
"lp_ctx should be a path to a smb.conf file or a param.LoadParm object\n"
"credentials should be a credentials.Credentials object.\n\n"PY_DOC_ICOFFEEMACHINE,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = interface_ICoffeeMachine_new,
};


static bool pack_py_Read_args_in(PyObject *args, PyObject *kwargs, struct Read *r)
{
	PyObject *py_ORPCthis;
	PyObject *py_num_requested;
	PyObject *py_num_readx;
	const char *kwnames[] = {
		"ORPCthis", "num_requested", "num_readx", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:Read", discard_const_p(char *, kwnames), &py_ORPCthis, &py_num_requested, &py_num_readx)) {
		return false;
	}

	PyErr_SetString(PyExc_TypeError, "Can not convert C Type struct ORPCTHIS from Python");
	PY_CHECK_TYPE(&PyInt_Type, py_num_requested, return false;);
	r->in.num_requested = PyInt_AsLong(py_num_requested);
	if (py_num_readx == Py_None) {
		r->in.num_readx = NULL;
	} else {
		r->in.num_readx = talloc_ptrtype(r, r->in.num_readx);
		PY_CHECK_TYPE(&PyInt_Type, py_num_readx, return false;);
		*r->in.num_readx = PyInt_AsLong(py_num_readx);
	}
	return true;
}

static PyObject *unpack_py_Read_args_out(struct Read *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	PyObject *py_pv;
	result = PyTuple_New(2);
	py_ORPCthat = NULL;
	PyTuple_SetItem(result, 0, py_ORPCthat);
	py_pv = PyList_New(*r->out.num_read);
	if (py_pv == NULL) {
		return NULL;
	}
	{
		int pv_cntr_0;
		for (pv_cntr_0 = 0; pv_cntr_0 < *r->out.num_read; pv_cntr_0++) {
			PyObject *py_pv_0;
			py_pv_0 = PyInt_FromLong(r->out.pv[pv_cntr_0]);
			PyList_SetItem(py_pv, pv_cntr_0, py_pv_0);
		}
	}
	PyTuple_SetItem(result, 1, py_pv);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_Write_args_in(PyObject *args, PyObject *kwargs, struct Write *r)
{
	PyObject *py_ORPCthis;
	PyObject *py_data;
	const char *kwnames[] = {
		"ORPCthis", "data", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:Write", discard_const_p(char *, kwnames), &py_ORPCthis, &py_data)) {
		return false;
	}

	PyErr_SetString(PyExc_TypeError, "Can not convert C Type struct ORPCTHIS from Python");
	if (py_data == Py_None) {
		r->in.data = NULL;
	} else {
		r->in.data = NULL;
		PY_CHECK_TYPE(&PyList_Type, py_data, return false;);
		{
			int data_cntr_1;
			r->in.data = talloc_array_ptrtype(r, r->in.data, PyList_GET_SIZE(py_data));
			if (!r->in.data) { return false;; }
			talloc_set_name_const(r->in.data, "ARRAY: r->in.data");
			for (data_cntr_1 = 0; data_cntr_1 < PyList_GET_SIZE(py_data); data_cntr_1++) {
				PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(py_data, data_cntr_1), return false;);
				r->in.data[data_cntr_1] = PyInt_AsLong(PyList_GET_ITEM(py_data, data_cntr_1));
			}
		}
	}
	PY_CHECK_TYPE(&PyList_Type, py_data, return false;);
	r->in.num_requested = PyList_GET_SIZE(py_data);
	return true;
}

static PyObject *unpack_py_Write_args_out(struct Write *r)
{
	PyObject *result;
	PyObject *py_ORPCthat;
	PyObject *py_num_written;
	result = PyTuple_New(2);
	py_ORPCthat = NULL;
	PyTuple_SetItem(result, 0, py_ORPCthat);
	py_num_written = PyInt_FromLong(*r->out.num_written);
	PyTuple_SetItem(result, 1, py_num_written);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

const struct PyNdrRpcMethodDef py_ndr_IStream_methods[] = {
	{ "Read", "S.Read(ORPCthis, num_requested, num_readx) -> (ORPCthat, pv)", (py_dcerpc_call_fn)dcerpc_Read_r, (py_data_pack_fn)pack_py_Read_args_in, (py_data_unpack_fn)unpack_py_Read_args_out, 0, &ndr_table_IStream },
	{ "Write", "S.Write(ORPCthis, data) -> (ORPCthat, num_written)", (py_dcerpc_call_fn)dcerpc_Write_r, (py_data_pack_fn)pack_py_Write_args_in, (py_data_unpack_fn)unpack_py_Write_args_out, 1, &ndr_table_IStream },
	{ NULL }
};

static PyObject *interface_IStream_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_interface_init_helper(type, args, kwargs, &ndr_table_IStream);
}

#define PY_DOC_ISTREAM "Stream"
static PyTypeObject IStream_InterfaceType = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcom.IStream",
	.tp_basicsize = sizeof(dcerpc_InterfaceObject),
	.tp_doc = "IStream(binding, lp_ctx=None, credentials=None) -> connection\n"
"\n"
"binding should be a DCE/RPC binding string (for example: ncacn_ip_tcp:127.0.0.1)\n"
"lp_ctx should be a path to a smb.conf file or a param.LoadParm object\n"
"credentials should be a credentials.Credentials object.\n\n"PY_DOC_ISTREAM,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = interface_IStream_new,
};

static PyMethodDef dcom_methods[] = {
	{ NULL, NULL, 0, NULL }
};

void initdcom(void)
{
	PyObject *m;
	PyObject *dep_talloc;
	PyObject *dep_samba_dcerpc_orpc;
	PyObject *dep_samba_dcerpc_base;
	PyObject *dep_samba_dcerpc_misc;

	dep_talloc = PyImport_ImportModule("talloc");
	if (dep_talloc == NULL)
		return;

	dep_samba_dcerpc_orpc = PyImport_ImportModule("samba.dcerpc.orpc");
	if (dep_samba_dcerpc_orpc == NULL)
		return;

	dep_samba_dcerpc_base = PyImport_ImportModule("samba.dcerpc.base");
	if (dep_samba_dcerpc_base == NULL)
		return;

	dep_samba_dcerpc_misc = PyImport_ImportModule("samba.dcerpc.misc");
	if (dep_samba_dcerpc_misc == NULL)
		return;

	ClientConnection_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_base, "ClientConnection");
	if (ClientConnection_Type == NULL)
		return;

	GUID_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_misc, "GUID");
	if (GUID_Type == NULL)
		return;

	Object_Type = (PyTypeObject *)PyObject_GetAttrString(dep_talloc, "Object");
	if (Object_Type == NULL)
		return;

	dcom_Unknown_InterfaceType.tp_base = ClientConnection_Type;

	IUnknown_InterfaceType.tp_base = ClientConnection_Type;

	IClassFactory_InterfaceType.tp_base = ClientConnection_Type;

	REMQIRESULT_Type.tp_base = Object_Type;

	REMINTERFACEREF_Type.tp_base = Object_Type;

	IRemUnknown_InterfaceType.tp_base = ClientConnection_Type;

	IClassActivator_InterfaceType.tp_base = ClientConnection_Type;

	ISCMLocalActivator_InterfaceType.tp_base = ClientConnection_Type;

	IMachineLocalActivator_InterfaceType.tp_base = ClientConnection_Type;

	ILocalObjectExporter_InterfaceType.tp_base = ClientConnection_Type;

	ISystemActivator_InterfaceType.tp_base = ClientConnection_Type;

	IRemUnknown2_InterfaceType.tp_base = ClientConnection_Type;

	REF_ITypeInfo_Type.tp_base = Object_Type;

	VARIANT_Type.tp_base = Object_Type;

	DISPPARAMS_Type.tp_base = Object_Type;

	EXCEPINFO_Type.tp_base = Object_Type;

	IDispatch_InterfaceType.tp_base = ClientConnection_Type;

	IMarshal_InterfaceType.tp_base = ClientConnection_Type;

	ICoffeeMachine_InterfaceType.tp_base = ClientConnection_Type;

	IStream_InterfaceType.tp_base = ClientConnection_Type;

	if (PyType_Ready(&dcom_Unknown_InterfaceType) < 0)
		return;
	if (PyType_Ready(&IUnknown_InterfaceType) < 0)
		return;
	if (PyType_Ready(&IClassFactory_InterfaceType) < 0)
		return;
	if (PyType_Ready(&REMQIRESULT_Type) < 0)
		return;
	if (PyType_Ready(&REMINTERFACEREF_Type) < 0)
		return;
	if (PyType_Ready(&IRemUnknown_InterfaceType) < 0)
		return;
	if (PyType_Ready(&IClassActivator_InterfaceType) < 0)
		return;
	if (PyType_Ready(&ISCMLocalActivator_InterfaceType) < 0)
		return;
	if (PyType_Ready(&IMachineLocalActivator_InterfaceType) < 0)
		return;
	if (PyType_Ready(&ILocalObjectExporter_InterfaceType) < 0)
		return;
	if (PyType_Ready(&ISystemActivator_InterfaceType) < 0)
		return;
	if (PyType_Ready(&IRemUnknown2_InterfaceType) < 0)
		return;
	if (PyType_Ready(&REF_ITypeInfo_Type) < 0)
		return;
	if (PyType_Ready(&VARIANT_Type) < 0)
		return;
	if (PyType_Ready(&DISPPARAMS_Type) < 0)
		return;
	if (PyType_Ready(&EXCEPINFO_Type) < 0)
		return;
	if (PyType_Ready(&IDispatch_InterfaceType) < 0)
		return;
	if (PyType_Ready(&IMarshal_InterfaceType) < 0)
		return;
	if (PyType_Ready(&ICoffeeMachine_InterfaceType) < 0)
		return;
	if (PyType_Ready(&IStream_InterfaceType) < 0)
		return;
	if (!PyInterface_AddNdrRpcMethods(&dcom_Unknown_InterfaceType, py_ndr_dcom_Unknown_methods))
		return;

	if (!PyInterface_AddNdrRpcMethods(&IUnknown_InterfaceType, py_ndr_IUnknown_methods))
		return;

	if (!PyInterface_AddNdrRpcMethods(&IClassFactory_InterfaceType, py_ndr_IClassFactory_methods))
		return;

	if (!PyInterface_AddNdrRpcMethods(&IRemUnknown_InterfaceType, py_ndr_IRemUnknown_methods))
		return;

	if (!PyInterface_AddNdrRpcMethods(&IClassActivator_InterfaceType, py_ndr_IClassActivator_methods))
		return;

	if (!PyInterface_AddNdrRpcMethods(&ISCMLocalActivator_InterfaceType, py_ndr_ISCMLocalActivator_methods))
		return;

	if (!PyInterface_AddNdrRpcMethods(&IMachineLocalActivator_InterfaceType, py_ndr_IMachineLocalActivator_methods))
		return;

	if (!PyInterface_AddNdrRpcMethods(&ILocalObjectExporter_InterfaceType, py_ndr_ILocalObjectExporter_methods))
		return;

	if (!PyInterface_AddNdrRpcMethods(&ISystemActivator_InterfaceType, py_ndr_ISystemActivator_methods))
		return;

	if (!PyInterface_AddNdrRpcMethods(&IRemUnknown2_InterfaceType, py_ndr_IRemUnknown2_methods))
		return;

	if (!PyInterface_AddNdrRpcMethods(&IDispatch_InterfaceType, py_ndr_IDispatch_methods))
		return;

	if (!PyInterface_AddNdrRpcMethods(&IMarshal_InterfaceType, py_ndr_IMarshal_methods))
		return;

	if (!PyInterface_AddNdrRpcMethods(&ICoffeeMachine_InterfaceType, py_ndr_ICoffeeMachine_methods))
		return;

	if (!PyInterface_AddNdrRpcMethods(&IStream_InterfaceType, py_ndr_IStream_methods))
		return;

#ifdef PY_DCOM_UNKNOWN_PATCH
	PY_DCOM_UNKNOWN_PATCH(&dcom_Unknown_InterfaceType);
#endif
#ifdef PY_IUNKNOWN_PATCH
	PY_IUNKNOWN_PATCH(&IUnknown_InterfaceType);
#endif
#ifdef PY_ICLASSFACTORY_PATCH
	PY_ICLASSFACTORY_PATCH(&IClassFactory_InterfaceType);
#endif
#ifdef PY_REMQIRESULT_PATCH
	PY_REMQIRESULT_PATCH(&REMQIRESULT_Type);
#endif
#ifdef PY_REMINTERFACEREF_PATCH
	PY_REMINTERFACEREF_PATCH(&REMINTERFACEREF_Type);
#endif
#ifdef PY_IREMUNKNOWN_PATCH
	PY_IREMUNKNOWN_PATCH(&IRemUnknown_InterfaceType);
#endif
#ifdef PY_ICLASSACTIVATOR_PATCH
	PY_ICLASSACTIVATOR_PATCH(&IClassActivator_InterfaceType);
#endif
#ifdef PY_ISCMLOCALACTIVATOR_PATCH
	PY_ISCMLOCALACTIVATOR_PATCH(&ISCMLocalActivator_InterfaceType);
#endif
#ifdef PY_IMACHINELOCALACTIVATOR_PATCH
	PY_IMACHINELOCALACTIVATOR_PATCH(&IMachineLocalActivator_InterfaceType);
#endif
#ifdef PY_ILOCALOBJECTEXPORTER_PATCH
	PY_ILOCALOBJECTEXPORTER_PATCH(&ILocalObjectExporter_InterfaceType);
#endif
#ifdef PY_ISYSTEMACTIVATOR_PATCH
	PY_ISYSTEMACTIVATOR_PATCH(&ISystemActivator_InterfaceType);
#endif
#ifdef PY_IREMUNKNOWN2_PATCH
	PY_IREMUNKNOWN2_PATCH(&IRemUnknown2_InterfaceType);
#endif
#ifdef PY_REF_ITYPEINFO_PATCH
	PY_REF_ITYPEINFO_PATCH(&REF_ITypeInfo_Type);
#endif
#ifdef PY_VARIANT_PATCH
	PY_VARIANT_PATCH(&VARIANT_Type);
#endif
#ifdef PY_DISPPARAMS_PATCH
	PY_DISPPARAMS_PATCH(&DISPPARAMS_Type);
#endif
#ifdef PY_EXCEPINFO_PATCH
	PY_EXCEPINFO_PATCH(&EXCEPINFO_Type);
#endif
#ifdef PY_IDISPATCH_PATCH
	PY_IDISPATCH_PATCH(&IDispatch_InterfaceType);
#endif
#ifdef PY_IMARSHAL_PATCH
	PY_IMARSHAL_PATCH(&IMarshal_InterfaceType);
#endif
#ifdef PY_ICOFFEEMACHINE_PATCH
	PY_ICOFFEEMACHINE_PATCH(&ICoffeeMachine_InterfaceType);
#endif
#ifdef PY_ISTREAM_PATCH
	PY_ISTREAM_PATCH(&IStream_InterfaceType);
#endif

	m = Py_InitModule3("dcom", dcom_methods, "dcom DCE/RPC");
	if (m == NULL)
		return;

	Py_INCREF((PyObject *)(void *)&dcom_Unknown_InterfaceType);
	PyModule_AddObject(m, "dcom_Unknown", (PyObject *)(void *)&dcom_Unknown_InterfaceType);
	Py_INCREF((PyObject *)(void *)&IUnknown_InterfaceType);
	PyModule_AddObject(m, "IUnknown", (PyObject *)(void *)&IUnknown_InterfaceType);
	Py_INCREF((PyObject *)(void *)&IClassFactory_InterfaceType);
	PyModule_AddObject(m, "IClassFactory", (PyObject *)(void *)&IClassFactory_InterfaceType);
	Py_INCREF((PyObject *)(void *)&REMQIRESULT_Type);
	PyModule_AddObject(m, "REMQIRESULT", (PyObject *)(void *)&REMQIRESULT_Type);
	Py_INCREF((PyObject *)(void *)&REMINTERFACEREF_Type);
	PyModule_AddObject(m, "REMINTERFACEREF", (PyObject *)(void *)&REMINTERFACEREF_Type);
	Py_INCREF((PyObject *)(void *)&IRemUnknown_InterfaceType);
	PyModule_AddObject(m, "IRemUnknown", (PyObject *)(void *)&IRemUnknown_InterfaceType);
	Py_INCREF((PyObject *)(void *)&IClassActivator_InterfaceType);
	PyModule_AddObject(m, "IClassActivator", (PyObject *)(void *)&IClassActivator_InterfaceType);
	Py_INCREF((PyObject *)(void *)&ISCMLocalActivator_InterfaceType);
	PyModule_AddObject(m, "ISCMLocalActivator", (PyObject *)(void *)&ISCMLocalActivator_InterfaceType);
	Py_INCREF((PyObject *)(void *)&IMachineLocalActivator_InterfaceType);
	PyModule_AddObject(m, "IMachineLocalActivator", (PyObject *)(void *)&IMachineLocalActivator_InterfaceType);
	Py_INCREF((PyObject *)(void *)&ILocalObjectExporter_InterfaceType);
	PyModule_AddObject(m, "ILocalObjectExporter", (PyObject *)(void *)&ILocalObjectExporter_InterfaceType);
	Py_INCREF((PyObject *)(void *)&ISystemActivator_InterfaceType);
	PyModule_AddObject(m, "ISystemActivator", (PyObject *)(void *)&ISystemActivator_InterfaceType);
	Py_INCREF((PyObject *)(void *)&IRemUnknown2_InterfaceType);
	PyModule_AddObject(m, "IRemUnknown2", (PyObject *)(void *)&IRemUnknown2_InterfaceType);
	Py_INCREF((PyObject *)(void *)&REF_ITypeInfo_Type);
	PyModule_AddObject(m, "REF_ITypeInfo", (PyObject *)(void *)&REF_ITypeInfo_Type);
	Py_INCREF((PyObject *)(void *)&VARIANT_Type);
	PyModule_AddObject(m, "VARIANT", (PyObject *)(void *)&VARIANT_Type);
	Py_INCREF((PyObject *)(void *)&DISPPARAMS_Type);
	PyModule_AddObject(m, "DISPPARAMS", (PyObject *)(void *)&DISPPARAMS_Type);
	Py_INCREF((PyObject *)(void *)&EXCEPINFO_Type);
	PyModule_AddObject(m, "EXCEPINFO", (PyObject *)(void *)&EXCEPINFO_Type);
	Py_INCREF((PyObject *)(void *)&IDispatch_InterfaceType);
	PyModule_AddObject(m, "IDispatch", (PyObject *)(void *)&IDispatch_InterfaceType);
	Py_INCREF((PyObject *)(void *)&IMarshal_InterfaceType);
	PyModule_AddObject(m, "IMarshal", (PyObject *)(void *)&IMarshal_InterfaceType);
	Py_INCREF((PyObject *)(void *)&ICoffeeMachine_InterfaceType);
	PyModule_AddObject(m, "ICoffeeMachine", (PyObject *)(void *)&ICoffeeMachine_InterfaceType);
	Py_INCREF((PyObject *)(void *)&IStream_InterfaceType);
	PyModule_AddObject(m, "IStream", (PyObject *)(void *)&IStream_InterfaceType);
#ifdef PY_MOD_DCOM_PATCH
	PY_MOD_DCOM_PATCH(m);
#endif

}
