/* server functions auto-generated by pidl */
#include "autoconf/librpc/gen_ndr/ndr_samr.h"

NTSTATUS dcerpc_server_samr_init(void);

/* samr - dcerpc server boilerplate generated by pidl */


static NTSTATUS samr__op_bind(struct dcesrv_call_state *dce_call, const struct dcesrv_interface *iface, uint32_t if_version)
{
#ifdef DCESRV_INTERFACE_SAMR_BIND
	return DCESRV_INTERFACE_SAMR_BIND(dce_call,iface);
#else
	return NT_STATUS_OK;
#endif
}

static void samr__op_unbind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_SAMR_UNBIND
	DCESRV_INTERFACE_SAMR_UNBIND(context, iface);
#else
	return;
#endif
}

static NTSTATUS samr__op_ndr_pull(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_pull *pull, void **r)
{
	enum ndr_err_code ndr_err;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	dce_call->fault_code = 0;

	if (opnum >= ndr_table_samr.num_calls) {
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	*r = talloc_named(mem_ctx,
			  ndr_table_samr.calls[opnum].struct_size,
			  "struct %s",
			  ndr_table_samr.calls[opnum].name);
	NT_STATUS_HAVE_NO_MEMORY(*r);

        /* unravel the NDR for the packet */
	ndr_err = ndr_table_samr.calls[opnum].ndr_pull(pull, NDR_IN, *r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		dcerpc_log_packet(dce_call->conn->packet_log_dir, 
				  &ndr_table_samr, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS samr__op_dispatch(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: {
		struct samr_Connect *r2 = (struct samr_Connect *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_Connect, NDR_IN, r2);
		}
		r2->out.result = dcesrv_samr_Connect(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_Connect will reply async\n"));
		}
		break;
	}
	case 1: {
		struct samr_Close *r2 = (struct samr_Close *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_Close, NDR_IN, r2);
		}
		r2->out.result = dcesrv_samr_Close(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_Close will reply async\n"));
		}
		break;
	}
	case 2: {
		struct samr_SetSecurity *r2 = (struct samr_SetSecurity *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_SetSecurity, NDR_IN, r2);
		}
		r2->out.result = dcesrv_samr_SetSecurity(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_SetSecurity will reply async\n"));
		}
		break;
	}
	case 3: {
		struct samr_QuerySecurity *r2 = (struct samr_QuerySecurity *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_QuerySecurity, NDR_IN, r2);
		}
		r2->out.result = dcesrv_samr_QuerySecurity(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_QuerySecurity will reply async\n"));
		}
		break;
	}
	case 4: {
		struct samr_Shutdown *r2 = (struct samr_Shutdown *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_Shutdown, NDR_IN, r2);
		}
		r2->out.result = dcesrv_samr_Shutdown(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_Shutdown will reply async\n"));
		}
		break;
	}
	case 5: {
		struct samr_LookupDomain *r2 = (struct samr_LookupDomain *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_LookupDomain, NDR_IN, r2);
		}
		r2->out.result = dcesrv_samr_LookupDomain(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_LookupDomain will reply async\n"));
		}
		break;
	}
	case 6: {
		struct samr_EnumDomains *r2 = (struct samr_EnumDomains *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_EnumDomains, NDR_IN, r2);
		}
		r2->out.result = dcesrv_samr_EnumDomains(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_EnumDomains will reply async\n"));
		}
		break;
	}
	case 7: {
		struct samr_OpenDomain *r2 = (struct samr_OpenDomain *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_OpenDomain, NDR_IN, r2);
		}
		r2->out.result = dcesrv_samr_OpenDomain(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_OpenDomain will reply async\n"));
		}
		break;
	}
	case 8: {
		struct samr_QueryDomainInfo *r2 = (struct samr_QueryDomainInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_QueryDomainInfo, NDR_IN, r2);
		}
		r2->out.result = dcesrv_samr_QueryDomainInfo(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_QueryDomainInfo will reply async\n"));
		}
		break;
	}
	case 9: {
		struct samr_SetDomainInfo *r2 = (struct samr_SetDomainInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_SetDomainInfo, NDR_IN, r2);
		}
		r2->out.result = dcesrv_samr_SetDomainInfo(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_SetDomainInfo will reply async\n"));
		}
		break;
	}
	case 10: {
		struct samr_CreateDomainGroup *r2 = (struct samr_CreateDomainGroup *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_CreateDomainGroup, NDR_IN, r2);
		}
		r2->out.result = dcesrv_samr_CreateDomainGroup(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_CreateDomainGroup will reply async\n"));
		}
		break;
	}
	case 11: {
		struct samr_EnumDomainGroups *r2 = (struct samr_EnumDomainGroups *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_EnumDomainGroups, NDR_IN, r2);
		}
		r2->out.result = dcesrv_samr_EnumDomainGroups(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_EnumDomainGroups will reply async\n"));
		}
		break;
	}
	case 12: {
		struct samr_CreateUser *r2 = (struct samr_CreateUser *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_CreateUser, NDR_IN, r2);
		}
		r2->out.result = dcesrv_samr_CreateUser(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_CreateUser will reply async\n"));
		}
		break;
	}
	case 13: {
		struct samr_EnumDomainUsers *r2 = (struct samr_EnumDomainUsers *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_EnumDomainUsers, NDR_IN, r2);
		}
		r2->out.result = dcesrv_samr_EnumDomainUsers(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_EnumDomainUsers will reply async\n"));
		}
		break;
	}
	case 14: {
		struct samr_CreateDomAlias *r2 = (struct samr_CreateDomAlias *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_CreateDomAlias, NDR_IN, r2);
		}
		r2->out.result = dcesrv_samr_CreateDomAlias(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_CreateDomAlias will reply async\n"));
		}
		break;
	}
	case 15: {
		struct samr_EnumDomainAliases *r2 = (struct samr_EnumDomainAliases *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_EnumDomainAliases, NDR_IN, r2);
		}
		r2->out.result = dcesrv_samr_EnumDomainAliases(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_EnumDomainAliases will reply async\n"));
		}
		break;
	}
	case 16: {
		struct samr_GetAliasMembership *r2 = (struct samr_GetAliasMembership *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_GetAliasMembership, NDR_IN, r2);
		}
		r2->out.result = dcesrv_samr_GetAliasMembership(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_GetAliasMembership will reply async\n"));
		}
		break;
	}
	case 17: {
		struct samr_LookupNames *r2 = (struct samr_LookupNames *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_LookupNames, NDR_IN, r2);
		}
		r2->out.result = dcesrv_samr_LookupNames(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_LookupNames will reply async\n"));
		}
		break;
	}
	case 18: {
		struct samr_LookupRids *r2 = (struct samr_LookupRids *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_LookupRids, NDR_IN, r2);
		}
		r2->out.result = dcesrv_samr_LookupRids(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_LookupRids will reply async\n"));
		}
		break;
	}
	case 19: {
		struct samr_OpenGroup *r2 = (struct samr_OpenGroup *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_OpenGroup, NDR_IN, r2);
		}
		r2->out.result = dcesrv_samr_OpenGroup(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_OpenGroup will reply async\n"));
		}
		break;
	}
	case 20: {
		struct samr_QueryGroupInfo *r2 = (struct samr_QueryGroupInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_QueryGroupInfo, NDR_IN, r2);
		}
		r2->out.result = dcesrv_samr_QueryGroupInfo(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_QueryGroupInfo will reply async\n"));
		}
		break;
	}
	case 21: {
		struct samr_SetGroupInfo *r2 = (struct samr_SetGroupInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_SetGroupInfo, NDR_IN, r2);
		}
		r2->out.result = dcesrv_samr_SetGroupInfo(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_SetGroupInfo will reply async\n"));
		}
		break;
	}
	case 22: {
		struct samr_AddGroupMember *r2 = (struct samr_AddGroupMember *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_AddGroupMember, NDR_IN, r2);
		}
		r2->out.result = dcesrv_samr_AddGroupMember(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_AddGroupMember will reply async\n"));
		}
		break;
	}
	case 23: {
		struct samr_DeleteDomainGroup *r2 = (struct samr_DeleteDomainGroup *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_DeleteDomainGroup, NDR_IN, r2);
		}
		r2->out.result = dcesrv_samr_DeleteDomainGroup(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_DeleteDomainGroup will reply async\n"));
		}
		break;
	}
	case 24: {
		struct samr_DeleteGroupMember *r2 = (struct samr_DeleteGroupMember *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_DeleteGroupMember, NDR_IN, r2);
		}
		r2->out.result = dcesrv_samr_DeleteGroupMember(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_DeleteGroupMember will reply async\n"));
		}
		break;
	}
	case 25: {
		struct samr_QueryGroupMember *r2 = (struct samr_QueryGroupMember *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_QueryGroupMember, NDR_IN, r2);
		}
		r2->out.result = dcesrv_samr_QueryGroupMember(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_QueryGroupMember will reply async\n"));
		}
		break;
	}
	case 26: {
		struct samr_SetMemberAttributesOfGroup *r2 = (struct samr_SetMemberAttributesOfGroup *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_SetMemberAttributesOfGroup, NDR_IN, r2);
		}
		r2->out.result = dcesrv_samr_SetMemberAttributesOfGroup(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_SetMemberAttributesOfGroup will reply async\n"));
		}
		break;
	}
	case 27: {
		struct samr_OpenAlias *r2 = (struct samr_OpenAlias *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_OpenAlias, NDR_IN, r2);
		}
		r2->out.result = dcesrv_samr_OpenAlias(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_OpenAlias will reply async\n"));
		}
		break;
	}
	case 28: {
		struct samr_QueryAliasInfo *r2 = (struct samr_QueryAliasInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_QueryAliasInfo, NDR_IN, r2);
		}
		r2->out.result = dcesrv_samr_QueryAliasInfo(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_QueryAliasInfo will reply async\n"));
		}
		break;
	}
	case 29: {
		struct samr_SetAliasInfo *r2 = (struct samr_SetAliasInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_SetAliasInfo, NDR_IN, r2);
		}
		r2->out.result = dcesrv_samr_SetAliasInfo(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_SetAliasInfo will reply async\n"));
		}
		break;
	}
	case 30: {
		struct samr_DeleteDomAlias *r2 = (struct samr_DeleteDomAlias *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_DeleteDomAlias, NDR_IN, r2);
		}
		r2->out.result = dcesrv_samr_DeleteDomAlias(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_DeleteDomAlias will reply async\n"));
		}
		break;
	}
	case 31: {
		struct samr_AddAliasMember *r2 = (struct samr_AddAliasMember *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_AddAliasMember, NDR_IN, r2);
		}
		r2->out.result = dcesrv_samr_AddAliasMember(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_AddAliasMember will reply async\n"));
		}
		break;
	}
	case 32: {
		struct samr_DeleteAliasMember *r2 = (struct samr_DeleteAliasMember *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_DeleteAliasMember, NDR_IN, r2);
		}
		r2->out.result = dcesrv_samr_DeleteAliasMember(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_DeleteAliasMember will reply async\n"));
		}
		break;
	}
	case 33: {
		struct samr_GetMembersInAlias *r2 = (struct samr_GetMembersInAlias *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_GetMembersInAlias, NDR_IN, r2);
		}
		r2->out.result = dcesrv_samr_GetMembersInAlias(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_GetMembersInAlias will reply async\n"));
		}
		break;
	}
	case 34: {
		struct samr_OpenUser *r2 = (struct samr_OpenUser *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_OpenUser, NDR_IN, r2);
		}
		r2->out.result = dcesrv_samr_OpenUser(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_OpenUser will reply async\n"));
		}
		break;
	}
	case 35: {
		struct samr_DeleteUser *r2 = (struct samr_DeleteUser *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_DeleteUser, NDR_IN, r2);
		}
		r2->out.result = dcesrv_samr_DeleteUser(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_DeleteUser will reply async\n"));
		}
		break;
	}
	case 36: {
		struct samr_QueryUserInfo *r2 = (struct samr_QueryUserInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_QueryUserInfo, NDR_IN, r2);
		}
		r2->out.result = dcesrv_samr_QueryUserInfo(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_QueryUserInfo will reply async\n"));
		}
		break;
	}
	case 37: {
		struct samr_SetUserInfo *r2 = (struct samr_SetUserInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_SetUserInfo, NDR_IN, r2);
		}
		r2->out.result = dcesrv_samr_SetUserInfo(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_SetUserInfo will reply async\n"));
		}
		break;
	}
	case 38: {
		struct samr_ChangePasswordUser *r2 = (struct samr_ChangePasswordUser *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_ChangePasswordUser, NDR_IN, r2);
		}
		r2->out.result = dcesrv_samr_ChangePasswordUser(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_ChangePasswordUser will reply async\n"));
		}
		break;
	}
	case 39: {
		struct samr_GetGroupsForUser *r2 = (struct samr_GetGroupsForUser *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_GetGroupsForUser, NDR_IN, r2);
		}
		r2->out.result = dcesrv_samr_GetGroupsForUser(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_GetGroupsForUser will reply async\n"));
		}
		break;
	}
	case 40: {
		struct samr_QueryDisplayInfo *r2 = (struct samr_QueryDisplayInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_QueryDisplayInfo, NDR_IN, r2);
		}
		r2->out.result = dcesrv_samr_QueryDisplayInfo(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_QueryDisplayInfo will reply async\n"));
		}
		break;
	}
	case 41: {
		struct samr_GetDisplayEnumerationIndex *r2 = (struct samr_GetDisplayEnumerationIndex *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_GetDisplayEnumerationIndex, NDR_IN, r2);
		}
		r2->out.result = dcesrv_samr_GetDisplayEnumerationIndex(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_GetDisplayEnumerationIndex will reply async\n"));
		}
		break;
	}
	case 42: {
		struct samr_TestPrivateFunctionsDomain *r2 = (struct samr_TestPrivateFunctionsDomain *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_TestPrivateFunctionsDomain, NDR_IN, r2);
		}
		r2->out.result = dcesrv_samr_TestPrivateFunctionsDomain(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_TestPrivateFunctionsDomain will reply async\n"));
		}
		break;
	}
	case 43: {
		struct samr_TestPrivateFunctionsUser *r2 = (struct samr_TestPrivateFunctionsUser *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_TestPrivateFunctionsUser, NDR_IN, r2);
		}
		r2->out.result = dcesrv_samr_TestPrivateFunctionsUser(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_TestPrivateFunctionsUser will reply async\n"));
		}
		break;
	}
	case 44: {
		struct samr_GetUserPwInfo *r2 = (struct samr_GetUserPwInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_GetUserPwInfo, NDR_IN, r2);
		}
		r2->out.result = dcesrv_samr_GetUserPwInfo(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_GetUserPwInfo will reply async\n"));
		}
		break;
	}
	case 45: {
		struct samr_RemoveMemberFromForeignDomain *r2 = (struct samr_RemoveMemberFromForeignDomain *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_RemoveMemberFromForeignDomain, NDR_IN, r2);
		}
		r2->out.result = dcesrv_samr_RemoveMemberFromForeignDomain(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_RemoveMemberFromForeignDomain will reply async\n"));
		}
		break;
	}
	case 46: {
		struct samr_QueryDomainInfo2 *r2 = (struct samr_QueryDomainInfo2 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_QueryDomainInfo2, NDR_IN, r2);
		}
		r2->out.result = dcesrv_samr_QueryDomainInfo2(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_QueryDomainInfo2 will reply async\n"));
		}
		break;
	}
	case 47: {
		struct samr_QueryUserInfo2 *r2 = (struct samr_QueryUserInfo2 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_QueryUserInfo2, NDR_IN, r2);
		}
		r2->out.result = dcesrv_samr_QueryUserInfo2(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_QueryUserInfo2 will reply async\n"));
		}
		break;
	}
	case 48: {
		struct samr_QueryDisplayInfo2 *r2 = (struct samr_QueryDisplayInfo2 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_QueryDisplayInfo2, NDR_IN, r2);
		}
		r2->out.result = dcesrv_samr_QueryDisplayInfo2(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_QueryDisplayInfo2 will reply async\n"));
		}
		break;
	}
	case 49: {
		struct samr_GetDisplayEnumerationIndex2 *r2 = (struct samr_GetDisplayEnumerationIndex2 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_GetDisplayEnumerationIndex2, NDR_IN, r2);
		}
		r2->out.result = dcesrv_samr_GetDisplayEnumerationIndex2(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_GetDisplayEnumerationIndex2 will reply async\n"));
		}
		break;
	}
	case 50: {
		struct samr_CreateUser2 *r2 = (struct samr_CreateUser2 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_CreateUser2, NDR_IN, r2);
		}
		r2->out.result = dcesrv_samr_CreateUser2(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_CreateUser2 will reply async\n"));
		}
		break;
	}
	case 51: {
		struct samr_QueryDisplayInfo3 *r2 = (struct samr_QueryDisplayInfo3 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_QueryDisplayInfo3, NDR_IN, r2);
		}
		r2->out.result = dcesrv_samr_QueryDisplayInfo3(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_QueryDisplayInfo3 will reply async\n"));
		}
		break;
	}
	case 52: {
		struct samr_AddMultipleMembersToAlias *r2 = (struct samr_AddMultipleMembersToAlias *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_AddMultipleMembersToAlias, NDR_IN, r2);
		}
		r2->out.result = dcesrv_samr_AddMultipleMembersToAlias(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_AddMultipleMembersToAlias will reply async\n"));
		}
		break;
	}
	case 53: {
		struct samr_RemoveMultipleMembersFromAlias *r2 = (struct samr_RemoveMultipleMembersFromAlias *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_RemoveMultipleMembersFromAlias, NDR_IN, r2);
		}
		r2->out.result = dcesrv_samr_RemoveMultipleMembersFromAlias(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_RemoveMultipleMembersFromAlias will reply async\n"));
		}
		break;
	}
	case 54: {
		struct samr_OemChangePasswordUser2 *r2 = (struct samr_OemChangePasswordUser2 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_OemChangePasswordUser2, NDR_IN, r2);
		}
		r2->out.result = dcesrv_samr_OemChangePasswordUser2(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_OemChangePasswordUser2 will reply async\n"));
		}
		break;
	}
	case 55: {
		struct samr_ChangePasswordUser2 *r2 = (struct samr_ChangePasswordUser2 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_ChangePasswordUser2, NDR_IN, r2);
		}
		r2->out.result = dcesrv_samr_ChangePasswordUser2(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_ChangePasswordUser2 will reply async\n"));
		}
		break;
	}
	case 56: {
		struct samr_GetDomPwInfo *r2 = (struct samr_GetDomPwInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_GetDomPwInfo, NDR_IN, r2);
		}
		r2->out.result = dcesrv_samr_GetDomPwInfo(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_GetDomPwInfo will reply async\n"));
		}
		break;
	}
	case 57: {
		struct samr_Connect2 *r2 = (struct samr_Connect2 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_Connect2, NDR_IN, r2);
		}
		r2->out.result = dcesrv_samr_Connect2(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_Connect2 will reply async\n"));
		}
		break;
	}
	case 58: {
		struct samr_SetUserInfo2 *r2 = (struct samr_SetUserInfo2 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_SetUserInfo2, NDR_IN, r2);
		}
		r2->out.result = dcesrv_samr_SetUserInfo2(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_SetUserInfo2 will reply async\n"));
		}
		break;
	}
	case 59: {
		struct samr_SetBootKeyInformation *r2 = (struct samr_SetBootKeyInformation *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_SetBootKeyInformation, NDR_IN, r2);
		}
		r2->out.result = dcesrv_samr_SetBootKeyInformation(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_SetBootKeyInformation will reply async\n"));
		}
		break;
	}
	case 60: {
		struct samr_GetBootKeyInformation *r2 = (struct samr_GetBootKeyInformation *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_GetBootKeyInformation, NDR_IN, r2);
		}
		r2->out.result = dcesrv_samr_GetBootKeyInformation(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_GetBootKeyInformation will reply async\n"));
		}
		break;
	}
	case 61: {
		struct samr_Connect3 *r2 = (struct samr_Connect3 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_Connect3, NDR_IN, r2);
		}
		r2->out.result = dcesrv_samr_Connect3(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_Connect3 will reply async\n"));
		}
		break;
	}
	case 62: {
		struct samr_Connect4 *r2 = (struct samr_Connect4 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_Connect4, NDR_IN, r2);
		}
		r2->out.result = dcesrv_samr_Connect4(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_Connect4 will reply async\n"));
		}
		break;
	}
	case 63: {
		struct samr_ChangePasswordUser3 *r2 = (struct samr_ChangePasswordUser3 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_ChangePasswordUser3, NDR_IN, r2);
		}
		r2->out.result = dcesrv_samr_ChangePasswordUser3(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_ChangePasswordUser3 will reply async\n"));
		}
		break;
	}
	case 64: {
		struct samr_Connect5 *r2 = (struct samr_Connect5 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_Connect5, NDR_IN, r2);
		}
		r2->out.result = dcesrv_samr_Connect5(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_Connect5 will reply async\n"));
		}
		break;
	}
	case 65: {
		struct samr_RidToSid *r2 = (struct samr_RidToSid *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_RidToSid, NDR_IN, r2);
		}
		r2->out.result = dcesrv_samr_RidToSid(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_RidToSid will reply async\n"));
		}
		break;
	}
	case 66: {
		struct samr_SetDsrmPassword *r2 = (struct samr_SetDsrmPassword *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_SetDsrmPassword, NDR_IN, r2);
		}
		r2->out.result = dcesrv_samr_SetDsrmPassword(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_SetDsrmPassword will reply async\n"));
		}
		break;
	}
	case 67: {
		struct samr_ValidatePassword *r2 = (struct samr_ValidatePassword *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_ValidatePassword, NDR_IN, r2);
		}
		r2->out.result = dcesrv_samr_ValidatePassword(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_ValidatePassword will reply async\n"));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		dcerpc_log_packet(dce_call->conn->packet_log_dir, 
		          &ndr_table_samr, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS samr__op_reply(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: {
		struct samr_Connect *r2 = (struct samr_Connect *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_Connect replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_Connect, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in samr_Connect\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 1: {
		struct samr_Close *r2 = (struct samr_Close *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_Close replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_Close, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in samr_Close\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 2: {
		struct samr_SetSecurity *r2 = (struct samr_SetSecurity *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_SetSecurity replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_SetSecurity, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in samr_SetSecurity\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 3: {
		struct samr_QuerySecurity *r2 = (struct samr_QuerySecurity *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_QuerySecurity replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_QuerySecurity, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in samr_QuerySecurity\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 4: {
		struct samr_Shutdown *r2 = (struct samr_Shutdown *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_Shutdown replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_Shutdown, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in samr_Shutdown\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 5: {
		struct samr_LookupDomain *r2 = (struct samr_LookupDomain *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_LookupDomain replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_LookupDomain, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in samr_LookupDomain\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 6: {
		struct samr_EnumDomains *r2 = (struct samr_EnumDomains *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_EnumDomains replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_EnumDomains, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in samr_EnumDomains\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 7: {
		struct samr_OpenDomain *r2 = (struct samr_OpenDomain *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_OpenDomain replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_OpenDomain, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in samr_OpenDomain\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 8: {
		struct samr_QueryDomainInfo *r2 = (struct samr_QueryDomainInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_QueryDomainInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_QueryDomainInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in samr_QueryDomainInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 9: {
		struct samr_SetDomainInfo *r2 = (struct samr_SetDomainInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_SetDomainInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_SetDomainInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in samr_SetDomainInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 10: {
		struct samr_CreateDomainGroup *r2 = (struct samr_CreateDomainGroup *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_CreateDomainGroup replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_CreateDomainGroup, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in samr_CreateDomainGroup\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 11: {
		struct samr_EnumDomainGroups *r2 = (struct samr_EnumDomainGroups *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_EnumDomainGroups replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_EnumDomainGroups, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in samr_EnumDomainGroups\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 12: {
		struct samr_CreateUser *r2 = (struct samr_CreateUser *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_CreateUser replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_CreateUser, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in samr_CreateUser\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 13: {
		struct samr_EnumDomainUsers *r2 = (struct samr_EnumDomainUsers *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_EnumDomainUsers replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_EnumDomainUsers, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in samr_EnumDomainUsers\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 14: {
		struct samr_CreateDomAlias *r2 = (struct samr_CreateDomAlias *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_CreateDomAlias replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_CreateDomAlias, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in samr_CreateDomAlias\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 15: {
		struct samr_EnumDomainAliases *r2 = (struct samr_EnumDomainAliases *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_EnumDomainAliases replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_EnumDomainAliases, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in samr_EnumDomainAliases\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 16: {
		struct samr_GetAliasMembership *r2 = (struct samr_GetAliasMembership *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_GetAliasMembership replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_GetAliasMembership, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in samr_GetAliasMembership\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 17: {
		struct samr_LookupNames *r2 = (struct samr_LookupNames *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_LookupNames replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_LookupNames, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in samr_LookupNames\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 18: {
		struct samr_LookupRids *r2 = (struct samr_LookupRids *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_LookupRids replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_LookupRids, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in samr_LookupRids\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 19: {
		struct samr_OpenGroup *r2 = (struct samr_OpenGroup *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_OpenGroup replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_OpenGroup, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in samr_OpenGroup\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 20: {
		struct samr_QueryGroupInfo *r2 = (struct samr_QueryGroupInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_QueryGroupInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_QueryGroupInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in samr_QueryGroupInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 21: {
		struct samr_SetGroupInfo *r2 = (struct samr_SetGroupInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_SetGroupInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_SetGroupInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in samr_SetGroupInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 22: {
		struct samr_AddGroupMember *r2 = (struct samr_AddGroupMember *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_AddGroupMember replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_AddGroupMember, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in samr_AddGroupMember\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 23: {
		struct samr_DeleteDomainGroup *r2 = (struct samr_DeleteDomainGroup *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_DeleteDomainGroup replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_DeleteDomainGroup, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in samr_DeleteDomainGroup\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 24: {
		struct samr_DeleteGroupMember *r2 = (struct samr_DeleteGroupMember *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_DeleteGroupMember replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_DeleteGroupMember, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in samr_DeleteGroupMember\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 25: {
		struct samr_QueryGroupMember *r2 = (struct samr_QueryGroupMember *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_QueryGroupMember replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_QueryGroupMember, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in samr_QueryGroupMember\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 26: {
		struct samr_SetMemberAttributesOfGroup *r2 = (struct samr_SetMemberAttributesOfGroup *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_SetMemberAttributesOfGroup replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_SetMemberAttributesOfGroup, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in samr_SetMemberAttributesOfGroup\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 27: {
		struct samr_OpenAlias *r2 = (struct samr_OpenAlias *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_OpenAlias replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_OpenAlias, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in samr_OpenAlias\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 28: {
		struct samr_QueryAliasInfo *r2 = (struct samr_QueryAliasInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_QueryAliasInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_QueryAliasInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in samr_QueryAliasInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 29: {
		struct samr_SetAliasInfo *r2 = (struct samr_SetAliasInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_SetAliasInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_SetAliasInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in samr_SetAliasInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 30: {
		struct samr_DeleteDomAlias *r2 = (struct samr_DeleteDomAlias *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_DeleteDomAlias replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_DeleteDomAlias, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in samr_DeleteDomAlias\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 31: {
		struct samr_AddAliasMember *r2 = (struct samr_AddAliasMember *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_AddAliasMember replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_AddAliasMember, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in samr_AddAliasMember\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 32: {
		struct samr_DeleteAliasMember *r2 = (struct samr_DeleteAliasMember *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_DeleteAliasMember replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_DeleteAliasMember, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in samr_DeleteAliasMember\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 33: {
		struct samr_GetMembersInAlias *r2 = (struct samr_GetMembersInAlias *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_GetMembersInAlias replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_GetMembersInAlias, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in samr_GetMembersInAlias\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 34: {
		struct samr_OpenUser *r2 = (struct samr_OpenUser *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_OpenUser replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_OpenUser, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in samr_OpenUser\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 35: {
		struct samr_DeleteUser *r2 = (struct samr_DeleteUser *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_DeleteUser replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_DeleteUser, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in samr_DeleteUser\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 36: {
		struct samr_QueryUserInfo *r2 = (struct samr_QueryUserInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_QueryUserInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_QueryUserInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in samr_QueryUserInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 37: {
		struct samr_SetUserInfo *r2 = (struct samr_SetUserInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_SetUserInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_SetUserInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in samr_SetUserInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 38: {
		struct samr_ChangePasswordUser *r2 = (struct samr_ChangePasswordUser *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_ChangePasswordUser replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_ChangePasswordUser, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in samr_ChangePasswordUser\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 39: {
		struct samr_GetGroupsForUser *r2 = (struct samr_GetGroupsForUser *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_GetGroupsForUser replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_GetGroupsForUser, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in samr_GetGroupsForUser\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 40: {
		struct samr_QueryDisplayInfo *r2 = (struct samr_QueryDisplayInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_QueryDisplayInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_QueryDisplayInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in samr_QueryDisplayInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 41: {
		struct samr_GetDisplayEnumerationIndex *r2 = (struct samr_GetDisplayEnumerationIndex *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_GetDisplayEnumerationIndex replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_GetDisplayEnumerationIndex, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in samr_GetDisplayEnumerationIndex\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 42: {
		struct samr_TestPrivateFunctionsDomain *r2 = (struct samr_TestPrivateFunctionsDomain *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_TestPrivateFunctionsDomain replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_TestPrivateFunctionsDomain, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in samr_TestPrivateFunctionsDomain\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 43: {
		struct samr_TestPrivateFunctionsUser *r2 = (struct samr_TestPrivateFunctionsUser *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_TestPrivateFunctionsUser replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_TestPrivateFunctionsUser, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in samr_TestPrivateFunctionsUser\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 44: {
		struct samr_GetUserPwInfo *r2 = (struct samr_GetUserPwInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_GetUserPwInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_GetUserPwInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in samr_GetUserPwInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 45: {
		struct samr_RemoveMemberFromForeignDomain *r2 = (struct samr_RemoveMemberFromForeignDomain *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_RemoveMemberFromForeignDomain replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_RemoveMemberFromForeignDomain, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in samr_RemoveMemberFromForeignDomain\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 46: {
		struct samr_QueryDomainInfo2 *r2 = (struct samr_QueryDomainInfo2 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_QueryDomainInfo2 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_QueryDomainInfo2, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in samr_QueryDomainInfo2\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 47: {
		struct samr_QueryUserInfo2 *r2 = (struct samr_QueryUserInfo2 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_QueryUserInfo2 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_QueryUserInfo2, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in samr_QueryUserInfo2\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 48: {
		struct samr_QueryDisplayInfo2 *r2 = (struct samr_QueryDisplayInfo2 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_QueryDisplayInfo2 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_QueryDisplayInfo2, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in samr_QueryDisplayInfo2\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 49: {
		struct samr_GetDisplayEnumerationIndex2 *r2 = (struct samr_GetDisplayEnumerationIndex2 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_GetDisplayEnumerationIndex2 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_GetDisplayEnumerationIndex2, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in samr_GetDisplayEnumerationIndex2\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 50: {
		struct samr_CreateUser2 *r2 = (struct samr_CreateUser2 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_CreateUser2 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_CreateUser2, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in samr_CreateUser2\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 51: {
		struct samr_QueryDisplayInfo3 *r2 = (struct samr_QueryDisplayInfo3 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_QueryDisplayInfo3 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_QueryDisplayInfo3, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in samr_QueryDisplayInfo3\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 52: {
		struct samr_AddMultipleMembersToAlias *r2 = (struct samr_AddMultipleMembersToAlias *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_AddMultipleMembersToAlias replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_AddMultipleMembersToAlias, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in samr_AddMultipleMembersToAlias\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 53: {
		struct samr_RemoveMultipleMembersFromAlias *r2 = (struct samr_RemoveMultipleMembersFromAlias *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_RemoveMultipleMembersFromAlias replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_RemoveMultipleMembersFromAlias, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in samr_RemoveMultipleMembersFromAlias\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 54: {
		struct samr_OemChangePasswordUser2 *r2 = (struct samr_OemChangePasswordUser2 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_OemChangePasswordUser2 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_OemChangePasswordUser2, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in samr_OemChangePasswordUser2\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 55: {
		struct samr_ChangePasswordUser2 *r2 = (struct samr_ChangePasswordUser2 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_ChangePasswordUser2 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_ChangePasswordUser2, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in samr_ChangePasswordUser2\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 56: {
		struct samr_GetDomPwInfo *r2 = (struct samr_GetDomPwInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_GetDomPwInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_GetDomPwInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in samr_GetDomPwInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 57: {
		struct samr_Connect2 *r2 = (struct samr_Connect2 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_Connect2 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_Connect2, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in samr_Connect2\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 58: {
		struct samr_SetUserInfo2 *r2 = (struct samr_SetUserInfo2 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_SetUserInfo2 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_SetUserInfo2, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in samr_SetUserInfo2\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 59: {
		struct samr_SetBootKeyInformation *r2 = (struct samr_SetBootKeyInformation *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_SetBootKeyInformation replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_SetBootKeyInformation, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in samr_SetBootKeyInformation\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 60: {
		struct samr_GetBootKeyInformation *r2 = (struct samr_GetBootKeyInformation *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_GetBootKeyInformation replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_GetBootKeyInformation, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in samr_GetBootKeyInformation\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 61: {
		struct samr_Connect3 *r2 = (struct samr_Connect3 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_Connect3 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_Connect3, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in samr_Connect3\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 62: {
		struct samr_Connect4 *r2 = (struct samr_Connect4 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_Connect4 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_Connect4, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in samr_Connect4\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 63: {
		struct samr_ChangePasswordUser3 *r2 = (struct samr_ChangePasswordUser3 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_ChangePasswordUser3 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_ChangePasswordUser3, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in samr_ChangePasswordUser3\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 64: {
		struct samr_Connect5 *r2 = (struct samr_Connect5 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_Connect5 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_Connect5, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in samr_Connect5\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 65: {
		struct samr_RidToSid *r2 = (struct samr_RidToSid *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_RidToSid replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_RidToSid, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in samr_RidToSid\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 66: {
		struct samr_SetDsrmPassword *r2 = (struct samr_SetDsrmPassword *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_SetDsrmPassword replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_SetDsrmPassword, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in samr_SetDsrmPassword\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 67: {
		struct samr_ValidatePassword *r2 = (struct samr_ValidatePassword *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_ValidatePassword replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_ValidatePassword, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in samr_ValidatePassword\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		dcerpc_log_packet(dce_call->conn->packet_log_dir,
		          &ndr_table_samr, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS samr__op_ndr_push(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_push *push, const void *r)
{
	enum ndr_err_code ndr_err;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	ndr_err = ndr_table_samr.calls[opnum].ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

const struct dcesrv_interface dcesrv_samr_interface = {
	.name		= "samr",
	.syntax_id  = {{0x12345778,0x1234,0xabcd,{0xef,0x00},{0x01,0x23,0x45,0x67,0x89,0xac}},1.0},
	.bind		= samr__op_bind,
	.unbind		= samr__op_unbind,
	.ndr_pull	= samr__op_ndr_pull,
	.dispatch	= samr__op_dispatch,
	.reply		= samr__op_reply,
	.ndr_push	= samr__op_ndr_push
};


static NTSTATUS samr__op_init_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	int i;

	for (i=0;i<ndr_table_samr.endpoints->count;i++) {
		NTSTATUS ret;
		const char *name = ndr_table_samr.endpoints->names[i];

		ret = dcesrv_interface_register(dce_ctx, name, &dcesrv_samr_interface, NULL);
		if (!NT_STATUS_IS_OK(ret)) {
			DEBUG(1,("samr_op_init_server: failed to register endpoint '%s'\n",name));
			return ret;
		}
	}

	return NT_STATUS_OK;
}

static bool samr__op_interface_by_uuid(struct dcesrv_interface *iface, const struct GUID *uuid, uint32_t if_version)
{
	if (dcesrv_samr_interface.syntax_id.if_version == if_version &&
		GUID_equal(&dcesrv_samr_interface.syntax_id.uuid, uuid)) {
		memcpy(iface,&dcesrv_samr_interface, sizeof(*iface));
		return true;
	}

	return false;
}

static bool samr__op_interface_by_name(struct dcesrv_interface *iface, const char *name)
{
	if (strcmp(dcesrv_samr_interface.name, name)==0) {
		memcpy(iface, &dcesrv_samr_interface, sizeof(*iface));
		return true;
	}

	return false;
}

NTSTATUS dcerpc_server_samr_init(void)
{
	NTSTATUS ret;
	struct dcesrv_endpoint_server ep_server;

	/* fill in our name */
	ep_server.name = "samr";

	/* fill in all the operations */
	ep_server.init_server = samr__op_init_server;

	ep_server.interface_by_uuid = samr__op_interface_by_uuid;
	ep_server.interface_by_name = samr__op_interface_by_name;

	/* register ourselves with the DCERPC subsystem. */
	ret = dcerpc_register_ep_server(&ep_server);

	if (!NT_STATUS_IS_OK(ret)) {
		DEBUG(0,("Failed to register 'samr' endpoint server!\n"));
		return ret;
	}

	return ret;
}

