/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein is
 * confidential and proprietary to MediaTek Inc. and/or its licensors. Without
 * the prior written permission of MediaTek inc. and/or its licensors, any
 * reproduction, modification, use or disclosure of MediaTek Software, and
 * information contained herein, in whole or in part, shall be strictly
 * prohibited.
 *
 * Copyright  (C) 2019-2020  MediaTek Inc. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER
 * ON AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL
 * WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NONINFRINGEMENT. NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH
 * RESPECT TO THE SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY,
 * INCORPORATED IN, OR SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES
 * TO LOOK ONLY TO SUCH THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO.
 * RECEIVER EXPRESSLY ACKNOWLEDGES THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO
 * OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES CONTAINED IN MEDIATEK
 * SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK SOFTWARE
 * RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S
 * ENTIRE AND CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE
 * RELEASED HEREUNDER WILL BE, AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE
 * MEDIATEK SOFTWARE AT ISSUE, OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE
 * CHARGE PAID BY RECEIVER TO MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek
 * Software") have been modified by MediaTek Inc. All revisions are subject to
 * any receiver's applicable license agreements with MediaTek Inc.
 */

#ifndef __WAPP_USR_INTF_H__
#define __WAPP_USR_INTF_H__
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <syslog.h>
#include <errno.h>
#include <assert.h>
#include <fcntl.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <sys/ipc.h>
#include <sys/types.h>
#include <sys/sem.h>
#include <stddef.h>

#include "list.h"

#include "interface.h"
#include "os.h"
/*
 * NOTE: if made any changes in "struct set_config_bss_info",
 * Then Please compute the MACRO again.
 */
#define WAPP_MAP_REPLY_SIZE_BSS_INFO (MAX_SET_BSS_INFO_NUM * sizeof(struct set_config_bss_info))
#define WAPP_MAP_REPLY_BUFFER (WAPP_MAP_REPLY_SIZE_BSS_INFO + sizeof(struct evt) + 4)
#define WAPP_CMD_LIST_TIMEOUT 60

struct wapp_usr_intf_cmd
{
	struct dl_list list;
	unsigned char* content;
};

struct wapp_usr_intf_cli
{
	struct dl_list list;
	/*client daemon name*/
	char daemon_name[32];
	/*client sock addr*/
	struct sockaddr_un addr;
	socklen_t addrlen;
	/*cmd list from client*/
	struct dl_list cmd_list;
	/*registered event which need to be sent to deamon, total support 256 different events*/
	unsigned char registerd_event_bitmap[32];
	int errors;
};
struct wapp_usr_intf_cli_ctrl
{
	/*wapp interface face ctrl socket, server*/
	int sock;
	/*sock addr*/
	struct sockaddr_un addr;
	/*peer client list*/
	struct dl_list daemon_cli_list;
};

struct client_cmd
{
	struct dl_list list;
	struct os_time cmd_time;
	struct cmd_to_wapp* cmd_buf;
};
int retry_socket_send(int sock);

#endif
