/*
 * Copyright (c) [2020], MediaTek Inc. All rights reserved.
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws.
 * The information contained herein is confidential and proprietary to
 * MediaTek Inc. and/or its licensors.
 * Except as otherwise provided in the applicable licensing terms with
 * MediaTek Inc. and/or its licensors, any reproduction, modification, use or
 * disclosure of MediaTek Software, and information contained herein, in whole
 * or in part, shall be strictly prohibited.
*/
//[File]            : wf_wfdma_ext_wrap_csr.h
//[Revision time]   : Fri Mar  8 23:43:03 2019
//[Description]     : This file is auto generated by CODA
//[Copyright]       : Copyright (C) 2019 Mediatek Incorportion. All rights reserved.

#ifndef __WF_WFDMA_EXT_WRAP_CSR_REGS_H__
#define __WF_WFDMA_EXT_WRAP_CSR_REGS_H__

#include "hal_common.h"

#ifdef __cplusplus
extern "C" {
#endif


//****************************************************************************
//
//                     WF_WFDMA_EXT_WRAP_CSR CR Definitions                     
//
//****************************************************************************

#define WF_WFDMA_EXT_WRAP_CSR_BASE                             (0x18027000 + CONN_INFRA_REMAPPING_OFFSET)

#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_TOP_CTRL_CR_ADDR           (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x00) // 7000
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_PREFETCH_SRAM_MBIST_CTRL0_ADDR (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x04) // 7004
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_PREFETCH_SRAM_MBIST_CTRL1_ADDR (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x08) // 7008
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_PREFETCH_SRAM_MBIST_STATUS_ADDR (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x0C) // 700C
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_ADDR          (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x10) // 7010
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_ADDR          (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x14) // 7014
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_TOP_DBG_IN0_ADDR           (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x20) // 7020
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_TOP_DBG_IN1_ADDR           (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x24) // 7024
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_TOP_DBG_IN2_ADDR           (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x28) // 7028
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_TOP_DBG_IN3_ADDR           (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x2C) // 702C
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_CONFIG_ADDR           (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x30) // 7030
#define WF_WFDMA_EXT_WRAP_CSR_WED_RING_CONTROL_IDX_ADDR        (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x34) // 7034
#define WF_WFDMA_EXT_WRAP_CSR_DLY_INT_TICK_THRES_ADDR          (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x38) // 7038
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_SW_RST_ADDR                (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x3C) // 703C
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_DBG_SEL_ADDR               (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x40) // 7040
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HIF_MISC_ADDR              (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x44) // 7044
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_SLPPROT_CTRL_ADDR      (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x50) // 7050
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_SLPPROT_VIO_ADDR_ADDR (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x54) // 7054
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_SLPPROT_VIO_ADDR_ADDR (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x58) // 7058
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_MBIST_FUSE_CTRL_ADDR       (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x5C) // 705C
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_MBIST_PREFUSE_D_ADDR       (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x60) // 7060
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_MTR_TICK_CNT_ADDR      (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x64) // 7064
#define WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_STA_ADDR          (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x88) // 7088
#define WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_ENA_ADDR          (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x8C) // 708C
#define WF_WFDMA_EXT_WRAP_CSR_PCIE_RECOGNITION_ID_ADDR         (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x90) // 7090
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_MTR_CTRL_ADDR         (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x100) // 7100
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_MTR_CTRL_ADDR         (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x104) // 7104
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_MTR_W_CH_STS_0_ADDR   (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x108) // 7108
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_MTR_W_CH_STS_1_ADDR   (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x10C) // 710C
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_MTR_W_CH_STS_2_ADDR   (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x110) // 7110
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_MTR_W_CH_STS_3_ADDR   (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x114) // 7114
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_MTR_R_CH_STS_0_ADDR   (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x118) // 7118
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_MTR_R_CH_STS_1_ADDR   (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x11C) // 711C
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_MTR_R_CH_STS_2_ADDR   (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x120) // 7120
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_MTR_R_CH_STS_3_ADDR   (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x124) // 7124
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_MTR_DBGOUT_0_ADDR     (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x128) // 7128
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_MTR_DBGOUT_1_ADDR     (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x12C) // 712C
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_MTR_DBGOUT_2_ADDR     (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x130) // 7130
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_MTR_DBGOUT_3_ADDR     (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x134) // 7134
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_MTR_DBGOUT_4_ADDR     (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x138) // 7138
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_MTR_W_CH_STS_0_ADDR   (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x13C) // 713C
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_MTR_W_CH_STS_1_ADDR   (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x140) // 7140
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_MTR_W_CH_STS_2_ADDR   (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x144) // 7144
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_MTR_W_CH_STS_3_ADDR   (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x148) // 7148
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_MTR_R_CH_STS_0_ADDR   (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x14C) // 714C
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_MTR_R_CH_STS_1_ADDR   (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x150) // 7150
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_MTR_R_CH_STS_2_ADDR   (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x154) // 7154
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_MTR_R_CH_STS_3_ADDR   (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x158) // 7158
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_MTR_DBGOUT_0_ADDR     (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x15C) // 715C
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_MTR_DBGOUT_1_ADDR     (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x160) // 7160
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_MTR_DBGOUT_2_ADDR     (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x164) // 7164
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_MTR_DBGOUT_3_ADDR     (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x168) // 7168
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_MTR_DBGOUT_4_ADDR     (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x16C) // 716C
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_ADDR            (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x200) // 7200
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_ADDR            (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x204) // 7204
#define WF_WFDMA_EXT_WRAP_CSR_WED_TX0_CTRL0_ADDR               (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x300) // 7300
#define WF_WFDMA_EXT_WRAP_CSR_WED_TX0_CTRL1_ADDR               (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x304) // 7304
#define WF_WFDMA_EXT_WRAP_CSR_WED_TX0_CTRL2_ADDR               (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x308) // 7308
#define WF_WFDMA_EXT_WRAP_CSR_WED_TX0_STS_ADDR                 (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x30C) // 730C
#define WF_WFDMA_EXT_WRAP_CSR_WED_TX1_CTRL0_ADDR               (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x310) // 7310
#define WF_WFDMA_EXT_WRAP_CSR_WED_TX1_CTRL1_ADDR               (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x314) // 7314
#define WF_WFDMA_EXT_WRAP_CSR_WED_TX1_CTRL2_ADDR               (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x318) // 7318
#define WF_WFDMA_EXT_WRAP_CSR_WED_TX1_STS_ADDR                 (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x31C) // 731C
#define WF_WFDMA_EXT_WRAP_CSR_WED_RX1_CTRL0_ADDR               (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x410) // 7410
#define WF_WFDMA_EXT_WRAP_CSR_WED_RX1_CTRL1_ADDR               (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x414) // 7414
#define WF_WFDMA_EXT_WRAP_CSR_WED_RX1_CTRL2_ADDR               (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x418) // 7418
#define WF_WFDMA_EXT_WRAP_CSR_WED_RX1_STS_ADDR                 (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x41C) // 741C
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_0_ADDR        (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x500) // 7500
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_1_ADDR        (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x504) // 7504
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_2_ADDR        (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x508) // 7508
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_STS_ADDR          (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x50C) // 750C
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_DMAWR_PROBE_ADDR  (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x510) // 7510
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_DMARD_PROBE_ADDR  (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x514) // 7514
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_WR_DBG_AXIM_OUT0_ADDR (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x518) // 7518
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_WR_DBG_AXIM_OUT1_ADDR (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x51C) // 751C
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_AXI_SLP_STS_ADDR  (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x520) // 7520
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_RD_DBG_AXIM_OUT0_ADDR (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x524) // 7524
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_RD_DBG_AXIM_OUT1_ADDR (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x528) // 7528
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_FSM_CMD_ST_ADDR   (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x52C) // 752C
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_FSM_DAT_ST_ADDR   (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x530) // 7530
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_STS_ADDR          (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x534) // 7534
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_DMAWR_PROBE_ADDR  (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x538) // 7538
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_DMARD_PROBE_ADDR  (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x53C) // 753C
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_WR_DBG_AXIM_OUT0_ADDR (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x540) // 7540
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_WR_DBG_AXIM_OUT1_ADDR (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x544) // 7544
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_AXI_SLP_STS_ADDR  (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x548) // 7548
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_RD_DBG_AXIM_OUT0_ADDR (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x54C) // 754C
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_RD_DBG_AXIM_OUT1_ADDR (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x550) // 7550
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_FSM_CMD_ST_ADDR   (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x554) // 7554
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_FSM_DAT_ST_ADDR   (WF_WFDMA_EXT_WRAP_CSR_BASE + 0x558) // 7558




/* =====================================================================================

  ---WFDMA_TOP_CTRL_CR (0x18027000 + 0x00)---

    CONN_HIF_WRAP_CSR_OUT[15..0] - (RW) conn_hif_wrap_csr_out for top_ctrl if needed in the future
    RESERVED16[31..16]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_TOP_CTRL_CR_CONN_HIF_WRAP_CSR_OUT_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_TOP_CTRL_CR_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_TOP_CTRL_CR_CONN_HIF_WRAP_CSR_OUT_MASK 0x0000FFFF                // CONN_HIF_WRAP_CSR_OUT[15..0]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_TOP_CTRL_CR_CONN_HIF_WRAP_CSR_OUT_SHFT 0

/* =====================================================================================

  ---WFDMA_PREFETCH_SRAM_MBIST_CTRL0 (0x18027000 + 0x04)---

    SLEEP_TEST[0]                - (RW) SLEEP_TEST
    SLEEP_INV[1]                 - (RW) SLEEP_INV
    SLEEP_W[2]                   - (RW) SLEEP_W
    SLEEP_R[3]                   - (RW) SLEEP_R
    USE_DEFAULT_DELSEL[4]        - (RW) USE_DEFAULT_DELSEL
    MBIST_DEBUG[5]               - (RW) MBIST_DEBUG
    MBIST_HOLDB[6]               - (RW) MBIST_HOLDB
    MBIST_MODE[7]                - (RW) MBIST_MODE
    MBIST_RSTB[8]                - (RW) MBIST_RSTB
    MBIST_AWT[9]                 - (RW) MBIST_AWT
    MBIST_HDEN[10]               - (RW) MBIST_HDEN
    RESERVED11[31..11]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_PREFETCH_SRAM_MBIST_CTRL0_MBIST_HDEN_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_PREFETCH_SRAM_MBIST_CTRL0_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_PREFETCH_SRAM_MBIST_CTRL0_MBIST_HDEN_MASK 0x00000400                // MBIST_HDEN[10]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_PREFETCH_SRAM_MBIST_CTRL0_MBIST_HDEN_SHFT 10
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_PREFETCH_SRAM_MBIST_CTRL0_MBIST_AWT_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_PREFETCH_SRAM_MBIST_CTRL0_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_PREFETCH_SRAM_MBIST_CTRL0_MBIST_AWT_MASK 0x00000200                // MBIST_AWT[9]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_PREFETCH_SRAM_MBIST_CTRL0_MBIST_AWT_SHFT 9
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_PREFETCH_SRAM_MBIST_CTRL0_MBIST_RSTB_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_PREFETCH_SRAM_MBIST_CTRL0_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_PREFETCH_SRAM_MBIST_CTRL0_MBIST_RSTB_MASK 0x00000100                // MBIST_RSTB[8]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_PREFETCH_SRAM_MBIST_CTRL0_MBIST_RSTB_SHFT 8
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_PREFETCH_SRAM_MBIST_CTRL0_MBIST_MODE_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_PREFETCH_SRAM_MBIST_CTRL0_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_PREFETCH_SRAM_MBIST_CTRL0_MBIST_MODE_MASK 0x00000080                // MBIST_MODE[7]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_PREFETCH_SRAM_MBIST_CTRL0_MBIST_MODE_SHFT 7
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_PREFETCH_SRAM_MBIST_CTRL0_MBIST_HOLDB_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_PREFETCH_SRAM_MBIST_CTRL0_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_PREFETCH_SRAM_MBIST_CTRL0_MBIST_HOLDB_MASK 0x00000040                // MBIST_HOLDB[6]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_PREFETCH_SRAM_MBIST_CTRL0_MBIST_HOLDB_SHFT 6
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_PREFETCH_SRAM_MBIST_CTRL0_MBIST_DEBUG_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_PREFETCH_SRAM_MBIST_CTRL0_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_PREFETCH_SRAM_MBIST_CTRL0_MBIST_DEBUG_MASK 0x00000020                // MBIST_DEBUG[5]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_PREFETCH_SRAM_MBIST_CTRL0_MBIST_DEBUG_SHFT 5
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_PREFETCH_SRAM_MBIST_CTRL0_USE_DEFAULT_DELSEL_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_PREFETCH_SRAM_MBIST_CTRL0_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_PREFETCH_SRAM_MBIST_CTRL0_USE_DEFAULT_DELSEL_MASK 0x00000010                // USE_DEFAULT_DELSEL[4]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_PREFETCH_SRAM_MBIST_CTRL0_USE_DEFAULT_DELSEL_SHFT 4
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_PREFETCH_SRAM_MBIST_CTRL0_SLEEP_R_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_PREFETCH_SRAM_MBIST_CTRL0_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_PREFETCH_SRAM_MBIST_CTRL0_SLEEP_R_MASK 0x00000008                // SLEEP_R[3]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_PREFETCH_SRAM_MBIST_CTRL0_SLEEP_R_SHFT 3
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_PREFETCH_SRAM_MBIST_CTRL0_SLEEP_W_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_PREFETCH_SRAM_MBIST_CTRL0_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_PREFETCH_SRAM_MBIST_CTRL0_SLEEP_W_MASK 0x00000004                // SLEEP_W[2]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_PREFETCH_SRAM_MBIST_CTRL0_SLEEP_W_SHFT 2
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_PREFETCH_SRAM_MBIST_CTRL0_SLEEP_INV_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_PREFETCH_SRAM_MBIST_CTRL0_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_PREFETCH_SRAM_MBIST_CTRL0_SLEEP_INV_MASK 0x00000002                // SLEEP_INV[1]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_PREFETCH_SRAM_MBIST_CTRL0_SLEEP_INV_SHFT 1
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_PREFETCH_SRAM_MBIST_CTRL0_SLEEP_TEST_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_PREFETCH_SRAM_MBIST_CTRL0_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_PREFETCH_SRAM_MBIST_CTRL0_SLEEP_TEST_MASK 0x00000001                // SLEEP_TEST[0]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_PREFETCH_SRAM_MBIST_CTRL0_SLEEP_TEST_SHFT 0

/* =====================================================================================

  ---WFDMA_PREFETCH_SRAM_MBIST_CTRL1 (0x18027000 + 0x08)---

    MBIST_BACKGROUND[15..0]      - (RW) MBIST_BACKGROUND
    MBIST_DELSEL[31..16]         - (RW) MBIST_DELSEL

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_PREFETCH_SRAM_MBIST_CTRL1_MBIST_DELSEL_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_PREFETCH_SRAM_MBIST_CTRL1_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_PREFETCH_SRAM_MBIST_CTRL1_MBIST_DELSEL_MASK 0xFFFF0000                // MBIST_DELSEL[31..16]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_PREFETCH_SRAM_MBIST_CTRL1_MBIST_DELSEL_SHFT 16
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_PREFETCH_SRAM_MBIST_CTRL1_MBIST_BACKGROUND_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_PREFETCH_SRAM_MBIST_CTRL1_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_PREFETCH_SRAM_MBIST_CTRL1_MBIST_BACKGROUND_MASK 0x0000FFFF                // MBIST_BACKGROUND[15..0]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_PREFETCH_SRAM_MBIST_CTRL1_MBIST_BACKGROUND_SHFT 0

/* =====================================================================================

  ---WFDMA_PREFETCH_SRAM_MBIST_STATUS (0x18027000 + 0x0C)---

    MBIST_DONE[0]                - (RO) MBIST_DONE
    MBIST_FAIL_0[1]              - (RO) MBIST_FAIL_0
    RESERVED2[3..2]              - (RO) Reserved bits
    MBIST_DIAG_SCANOUT[4]        - (RO) MBIST_DIAG_SCANOUT
    RESERVED5[31..5]             - (RO) Reserved bits

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_PREFETCH_SRAM_MBIST_STATUS_MBIST_DIAG_SCANOUT_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_PREFETCH_SRAM_MBIST_STATUS_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_PREFETCH_SRAM_MBIST_STATUS_MBIST_DIAG_SCANOUT_MASK 0x00000010                // MBIST_DIAG_SCANOUT[4]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_PREFETCH_SRAM_MBIST_STATUS_MBIST_DIAG_SCANOUT_SHFT 4
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_PREFETCH_SRAM_MBIST_STATUS_MBIST_FAIL_0_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_PREFETCH_SRAM_MBIST_STATUS_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_PREFETCH_SRAM_MBIST_STATUS_MBIST_FAIL_0_MASK 0x00000002                // MBIST_FAIL_0[1]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_PREFETCH_SRAM_MBIST_STATUS_MBIST_FAIL_0_SHFT 1
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_PREFETCH_SRAM_MBIST_STATUS_MBIST_DONE_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_PREFETCH_SRAM_MBIST_STATUS_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_PREFETCH_SRAM_MBIST_STATUS_MBIST_DONE_MASK 0x00000001                // MBIST_DONE[0]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_PREFETCH_SRAM_MBIST_STATUS_MBIST_DONE_SHFT 0

/* =====================================================================================

  ---WFDMA_HOST_INT_STA (0x18027000 + 0x10)---

    host_dma1_rx_done_int_sts_0[0] - (W1C) RX Queue#0 packet receive interrupt
                                     Write 1 to clear the interrupt
                                     Read to get the raw interrupt status
    host_dma1_rx_done_int_sts_1[1] - (W1C) RX Queue#1 packet receive interrupt
                                     Write 1 to clear the interrupt
                                     Read to get the raw interrupt status
    host_dma1_rx_done_int_sts_2[2] - (W1C) RX Queue#2 packet receive interrupt
                                     Write 1 to clear the interrupt
                                     Read to get the raw interrupt status
    host_dma1_rx_done_int_sts_3[3] - (W1C) RX Queue#3 packet receive interrupt
                                     Write 1 to clear the interrupt
                                     Read to get the raw interrupt status
    host_dma1_tx_done_int_sts_0[4] - (W1C) TX Queue#0 packet transmit interrupt
                                     Write 1 to clear the interrupt
    host_dma1_tx_done_int_sts_1[5] - (W1C) TX Queue#1 packet transmit interrupt
                                     Write 1 to clear the interrupt
    host_dma1_tx_done_int_sts_2[6] - (W1C) TX Queue#2 packet transmit interrupt
                                     Write 1 to clear the interrupt
    host_dma1_tx_done_int_sts_3[7] - (W1C) TX Queue#3 packet transmit interrupt
                                     Write 1 to clear the interrupt
    host_dma1_tx_done_int_sts_4[8] - (W1C) TX Queue#4 packet transmit interrupt
                                     Write 1 to clear the interrupt
    host_dma1_tx_done_int_sts_5[9] - (W1C) TX Queue#5 packet transmit interrupt
                                     Write 1 to clear the interrupt
    host_dma1_tx_done_int_sts_6[10] - (W1C) TX Queue#6 packet transmit interrupt
                                     Write 1 to clear the interrupt
    host_dma1_tx_done_int_sts_7[11] - (W1C) TX Queue#7 packet transmit interrupt
                                     Write 1 to clear the interrupt
    host_dma1_tx_done_int_sts_8[12] - (W1C) TX Queue#8 packet transmit interrupt
                                     Write 1 to clear the interrupt
    RESERVED[14..13]             - (RO) reserved
    host_dma1_tx_done_int_sts_20[15] - (W1C) TX Queue#20 packet transmit interrupt
                                     Write 1 to clear the interrupt
    host_dma0_rx_don_int_sts_0[16] - (W1C) RX Queue#0 packet receive interrupt
                                     Write 1 to clear the interrupt
                                     Read to get the raw interrupt status
    host_dma0_rx_don_int_sts_1[17] - (W1C) RX Queue#1 packet receive interrupt
                                     Write 1 to clear the interrupt
                                     Read to get the raw interrupt status
    host_dma0_rx_don_int_sts_2[18] - (W1C) RX Queue#2 packet receive interrupt
                                     Write 1 to clear the interrupt
                                     Read to get the raw interrupt status
    host_dma0_rx_don_int_sts_3[19] - (W1C) RX Queue#3 packet receive interrupt
                                     Write 1 to clear the interrupt
                                     Read to get the raw interrupt status
    host_dma1_rx_coherent_int_sts[20] - (W1C) RX_DMA finds data coherent event when checking ddone bit
                                     Write 1 to clear the interrupt
                                     Read to get the raw interrupt status
    host_dma1_tx_coherent_int_sts[21] - (W1C) TX_DMA finds data coherent event when checking ddone bit
                                     Write 1 to clear the interrupt
                                     Read to get the raw interrupt status
    host_dma0_rx_coherent_int_sts[22] - (W1C) RX_DMA finds data coherent event when checking ddone bit
                                     Write 1 to clear the interrupt
                                     Read to get the raw interrupt status
    host_dma0_tx_coherent_int_sts[23] - (W1C) TX_DMA finds data coherent event when checking ddone bit
                                     Write 1 to clear the interrupt
                                     Read to get the raw interrupt status
    host_dma1_wpdma2host_err_int_sts[24] - (RO) wpdma interrupt overall status
                                     User should should check WPDMA_ERR_INT_STA for each wpdma error interrupt status 
                                     Host could read [0x0_41E8] to check indivisual wpdma2host_error interrupt status
    host_dma0_wpdma2host_err_int_sts[25] - (RO) wpdma interrupt overall status
                                     User should should check WPDMA_ERR_INT_STA for each wpdma error interrupt status 
                                     Host could read [0x0_41E8] to check indivisual wpdma2host_error interrupt status
    host_dma1_tx_done_int_sts_16[26] - (W1C) TX Queue#16 packet transmit interrupt
                                     Write 1 to clear the interrupt
    host_dma1_tx_done_int_sts_17[27] - (W1C) TX Queue#17 packet transmit interrupt
                                     Write 1 to clear the interrupt
    host_dma1_subsys_int_sts[28] - (RO) subsys interrupt overall status
                                     User should should check SUBSYS2HOST_INT_STA for each interrupt status 
                                     Host could read [0x0_41F8] to check indivisual subsys hw interrupt status
    host_dma1_mcu2host_sw_int_sts[29] - (RO) subsys interrupt overall status
                                     User should should check SUBSYS2HOST_INT_STA for each interrupt status 
                                     Host could read [0x0_41F8] to check indivisual subsys hw interrupt status
    host_dma1_tx_done_int_sts_18[30] - (W1C) TX Queue#18 packet transmit interrupt
                                     Write 1 to clear the interrupt
    host_dma1_tx_done_int_sts_19[31] - (W1C) TX Queue#19 packet transmit interrupt
                                     Write 1 to clear the interrupt

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma1_tx_done_int_sts_19_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma1_tx_done_int_sts_19_MASK 0x80000000                // host_dma1_tx_done_int_sts_19[31]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma1_tx_done_int_sts_19_SHFT 31
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma1_tx_done_int_sts_18_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma1_tx_done_int_sts_18_MASK 0x40000000                // host_dma1_tx_done_int_sts_18[30]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma1_tx_done_int_sts_18_SHFT 30
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma1_mcu2host_sw_int_sts_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma1_mcu2host_sw_int_sts_MASK 0x20000000                // host_dma1_mcu2host_sw_int_sts[29]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma1_mcu2host_sw_int_sts_SHFT 29
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma1_subsys_int_sts_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma1_subsys_int_sts_MASK 0x10000000                // host_dma1_subsys_int_sts[28]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma1_subsys_int_sts_SHFT 28
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma1_tx_done_int_sts_17_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma1_tx_done_int_sts_17_MASK 0x08000000                // host_dma1_tx_done_int_sts_17[27]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma1_tx_done_int_sts_17_SHFT 27
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma1_tx_done_int_sts_16_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma1_tx_done_int_sts_16_MASK 0x04000000                // host_dma1_tx_done_int_sts_16[26]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma1_tx_done_int_sts_16_SHFT 26
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma0_wpdma2host_err_int_sts_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma0_wpdma2host_err_int_sts_MASK 0x02000000                // host_dma0_wpdma2host_err_int_sts[25]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma0_wpdma2host_err_int_sts_SHFT 25
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma1_wpdma2host_err_int_sts_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma1_wpdma2host_err_int_sts_MASK 0x01000000                // host_dma1_wpdma2host_err_int_sts[24]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma1_wpdma2host_err_int_sts_SHFT 24
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma0_tx_coherent_int_sts_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma0_tx_coherent_int_sts_MASK 0x00800000                // host_dma0_tx_coherent_int_sts[23]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma0_tx_coherent_int_sts_SHFT 23
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma0_rx_coherent_int_sts_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma0_rx_coherent_int_sts_MASK 0x00400000                // host_dma0_rx_coherent_int_sts[22]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma0_rx_coherent_int_sts_SHFT 22
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma1_tx_coherent_int_sts_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma1_tx_coherent_int_sts_MASK 0x00200000                // host_dma1_tx_coherent_int_sts[21]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma1_tx_coherent_int_sts_SHFT 21
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma1_rx_coherent_int_sts_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma1_rx_coherent_int_sts_MASK 0x00100000                // host_dma1_rx_coherent_int_sts[20]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma1_rx_coherent_int_sts_SHFT 20
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma0_rx_don_int_sts_3_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma0_rx_don_int_sts_3_MASK 0x00080000                // host_dma0_rx_don_int_sts_3[19]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma0_rx_don_int_sts_3_SHFT 19
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma0_rx_don_int_sts_2_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma0_rx_don_int_sts_2_MASK 0x00040000                // host_dma0_rx_don_int_sts_2[18]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma0_rx_don_int_sts_2_SHFT 18
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma0_rx_don_int_sts_1_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma0_rx_don_int_sts_1_MASK 0x00020000                // host_dma0_rx_don_int_sts_1[17]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma0_rx_don_int_sts_1_SHFT 17
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma0_rx_don_int_sts_0_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma0_rx_don_int_sts_0_MASK 0x00010000                // host_dma0_rx_don_int_sts_0[16]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma0_rx_don_int_sts_0_SHFT 16
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma1_tx_done_int_sts_20_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma1_tx_done_int_sts_20_MASK 0x00008000                // host_dma1_tx_done_int_sts_20[15]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma1_tx_done_int_sts_20_SHFT 15
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma1_tx_done_int_sts_8_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma1_tx_done_int_sts_8_MASK 0x00001000                // host_dma1_tx_done_int_sts_8[12]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma1_tx_done_int_sts_8_SHFT 12
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma1_tx_done_int_sts_7_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma1_tx_done_int_sts_7_MASK 0x00000800                // host_dma1_tx_done_int_sts_7[11]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma1_tx_done_int_sts_7_SHFT 11
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma1_tx_done_int_sts_6_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma1_tx_done_int_sts_6_MASK 0x00000400                // host_dma1_tx_done_int_sts_6[10]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma1_tx_done_int_sts_6_SHFT 10
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma1_tx_done_int_sts_5_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma1_tx_done_int_sts_5_MASK 0x00000200                // host_dma1_tx_done_int_sts_5[9]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma1_tx_done_int_sts_5_SHFT 9
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma1_tx_done_int_sts_4_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma1_tx_done_int_sts_4_MASK 0x00000100                // host_dma1_tx_done_int_sts_4[8]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma1_tx_done_int_sts_4_SHFT 8
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma1_tx_done_int_sts_3_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma1_tx_done_int_sts_3_MASK 0x00000080                // host_dma1_tx_done_int_sts_3[7]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma1_tx_done_int_sts_3_SHFT 7
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma1_tx_done_int_sts_2_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma1_tx_done_int_sts_2_MASK 0x00000040                // host_dma1_tx_done_int_sts_2[6]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma1_tx_done_int_sts_2_SHFT 6
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma1_tx_done_int_sts_1_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma1_tx_done_int_sts_1_MASK 0x00000020                // host_dma1_tx_done_int_sts_1[5]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma1_tx_done_int_sts_1_SHFT 5
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma1_tx_done_int_sts_0_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma1_tx_done_int_sts_0_MASK 0x00000010                // host_dma1_tx_done_int_sts_0[4]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma1_tx_done_int_sts_0_SHFT 4
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma1_rx_done_int_sts_3_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma1_rx_done_int_sts_3_MASK 0x00000008                // host_dma1_rx_done_int_sts_3[3]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma1_rx_done_int_sts_3_SHFT 3
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma1_rx_done_int_sts_2_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma1_rx_done_int_sts_2_MASK 0x00000004                // host_dma1_rx_done_int_sts_2[2]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma1_rx_done_int_sts_2_SHFT 2
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma1_rx_done_int_sts_1_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma1_rx_done_int_sts_1_MASK 0x00000002                // host_dma1_rx_done_int_sts_1[1]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma1_rx_done_int_sts_1_SHFT 1
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma1_rx_done_int_sts_0_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma1_rx_done_int_sts_0_MASK 0x00000001                // host_dma1_rx_done_int_sts_0[0]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_STA_host_dma1_rx_done_int_sts_0_SHFT 0

/* =====================================================================================

  ---WFDMA_HOST_INT_ENA (0x18027000 + 0x14)---

    HOST_DMA1_HOST_RX_DONE_INT_ENA0[0] - (RW) RX Queue#0 packet receive interrupt
    HOST_DMA1_HOST_RX_DONE_INT_ENA1[1] - (RW) RX Queue#1 packet receive interrupt
    HOST_DMA1_HOST_RX_DONE_INT_ENA2[2] - (RW) RX Queue#2 packet receive interrupt
    HOST_DMA1_HOST_RX_DONE_INT_ENA3[3] - (RW) RX Queue#3 packet receive interrupt
    HOST_DMA1_HOST_TX_DONE_INT_ENA0[4] - (RW) TX Queue#0 packet transmit interrupt
    HOST_DMA1_HOST_TX_DONE_INT_ENA1[5] - (RW) TX Queue#1 packet transmit interrupt
    HOST_DMA1_HOST_TX_DONE_INT_ENA2[6] - (RW) TX Queue#2 packet transmit interrupt
    HOST_DMA1_HOST_TX_DONE_INT_ENA3[7] - (RW) TX Queue#3 packet transmit interrupt
    HOST_DMA1_HOST_TX_DONE_INT_ENA4[8] - (RW) TX Queue#4 packet transmit interrupt
    HOST_DMA1_HOST_TX_DONE_INT_ENA5[9] - (RW) TX Queue#5 packet transmit interrupt
    HOST_DMA1_HOST_TX_DONE_INT_ENA6[10] - (RW) TX Queue#6 packet transmit interrupt
    HOST_DMA1_HOST_TX_DONE_INT_ENA7[11] - (RW) TX Queue#7 packet transmit interrupt
    HOST_DMA1_HOST_TX_DONE_INT_ENA8[12] - (RW) TX Queue#8 packet transmit interrupt
    RESERVED[14..13]             - (RO) reserved
    HOST_DMA1_HOST_TX_DONE_INT_ENA20[15] - (RW) TX Queue#20 packet transmit interrupt
    HOST_DMA0_HOST_RX_DONE_INT_ENA0[16] - (RW) RX Queue#0 packet receive interrupt
    HOST_DMA0_HOST_RX_DONE_INT_ENA1[17] - (RW) RX Queue#1 packet receive interrupt
    HOST_DMA0_HOST_RX_DONE_INT_ENA2[18] - (RW) RX Queue#2 packet receive interrupt
    HOST_DMA0_HOST_RX_DONE_INT_ENA3[19] - (RW) RX Queue#3 packet receive interrupt
    HOST_DMA1_HOST_RX_COHERENT_EN[20] - (RW) Enable for RX_DMA data coherent interrupt
    HOST_DMA1_HOST_TX_COHERENT_EN[21] - (RW) Enable for TX_DMA data coherent interrupt
    HOST_DMA0_HOST_RX_COHERENT_EN[22] - (RW) Enable for RX_DMA data coherent interrupt
    HOST_DMA0_HOST_TX_COHERENT_EN[23] - (RW) Enable for TX_DMA data coherent interrupt
    host_dma1_wpdma2host_err_int_ena[24] - (RW) Enable bit of wpdma2host_err_int
    host_dma0_wpdma2host_err_int_ena[25] - (RW) Enable bit of wpdma2host_err_int
    HOST_DMA1_HOST_TX_DONE_INT_ENA16[26] - (RW) TX Queue#16 packet transmit interrupt
    HOST_DMA1_HOST_TX_DONE_INT_ENA17[27] - (RW) TX Queue#17 packet transmit interrupt
    host_dma1_subsys_int_ena[28] - (RW) Enable bit of subsys_int
    host_dma1_mcu2host_sw_int_ena[29] - (RW) Enable bit of mcu2host_sw_int
    HOST_DMA1_HOST_TX_DONE_INT_ENA18[30] - (RW) TX Queue#18 packet transmit interrupt
    HOST_DMA1_HOST_TX_DONE_INT_ENA19[31] - (RW) TX Queue#19 packet transmit interrupt

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA1_HOST_TX_DONE_INT_ENA19_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA1_HOST_TX_DONE_INT_ENA19_MASK 0x80000000                // HOST_DMA1_HOST_TX_DONE_INT_ENA19[31]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA1_HOST_TX_DONE_INT_ENA19_SHFT 31
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA1_HOST_TX_DONE_INT_ENA18_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA1_HOST_TX_DONE_INT_ENA18_MASK 0x40000000                // HOST_DMA1_HOST_TX_DONE_INT_ENA18[30]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA1_HOST_TX_DONE_INT_ENA18_SHFT 30
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_host_dma1_mcu2host_sw_int_ena_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_host_dma1_mcu2host_sw_int_ena_MASK 0x20000000                // host_dma1_mcu2host_sw_int_ena[29]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_host_dma1_mcu2host_sw_int_ena_SHFT 29
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_host_dma1_subsys_int_ena_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_host_dma1_subsys_int_ena_MASK 0x10000000                // host_dma1_subsys_int_ena[28]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_host_dma1_subsys_int_ena_SHFT 28
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA1_HOST_TX_DONE_INT_ENA17_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA1_HOST_TX_DONE_INT_ENA17_MASK 0x08000000                // HOST_DMA1_HOST_TX_DONE_INT_ENA17[27]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA1_HOST_TX_DONE_INT_ENA17_SHFT 27
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA1_HOST_TX_DONE_INT_ENA16_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA1_HOST_TX_DONE_INT_ENA16_MASK 0x04000000                // HOST_DMA1_HOST_TX_DONE_INT_ENA16[26]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA1_HOST_TX_DONE_INT_ENA16_SHFT 26
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_host_dma0_wpdma2host_err_int_ena_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_host_dma0_wpdma2host_err_int_ena_MASK 0x02000000                // host_dma0_wpdma2host_err_int_ena[25]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_host_dma0_wpdma2host_err_int_ena_SHFT 25
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_host_dma1_wpdma2host_err_int_ena_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_host_dma1_wpdma2host_err_int_ena_MASK 0x01000000                // host_dma1_wpdma2host_err_int_ena[24]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_host_dma1_wpdma2host_err_int_ena_SHFT 24
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA0_HOST_TX_COHERENT_EN_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA0_HOST_TX_COHERENT_EN_MASK 0x00800000                // HOST_DMA0_HOST_TX_COHERENT_EN[23]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA0_HOST_TX_COHERENT_EN_SHFT 23
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA0_HOST_RX_COHERENT_EN_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA0_HOST_RX_COHERENT_EN_MASK 0x00400000                // HOST_DMA0_HOST_RX_COHERENT_EN[22]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA0_HOST_RX_COHERENT_EN_SHFT 22
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA1_HOST_TX_COHERENT_EN_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA1_HOST_TX_COHERENT_EN_MASK 0x00200000                // HOST_DMA1_HOST_TX_COHERENT_EN[21]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA1_HOST_TX_COHERENT_EN_SHFT 21
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA1_HOST_RX_COHERENT_EN_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA1_HOST_RX_COHERENT_EN_MASK 0x00100000                // HOST_DMA1_HOST_RX_COHERENT_EN[20]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA1_HOST_RX_COHERENT_EN_SHFT 20
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA0_HOST_RX_DONE_INT_ENA3_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA0_HOST_RX_DONE_INT_ENA3_MASK 0x00080000                // HOST_DMA0_HOST_RX_DONE_INT_ENA3[19]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA0_HOST_RX_DONE_INT_ENA3_SHFT 19
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA0_HOST_RX_DONE_INT_ENA2_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA0_HOST_RX_DONE_INT_ENA2_MASK 0x00040000                // HOST_DMA0_HOST_RX_DONE_INT_ENA2[18]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA0_HOST_RX_DONE_INT_ENA2_SHFT 18
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA0_HOST_RX_DONE_INT_ENA1_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA0_HOST_RX_DONE_INT_ENA1_MASK 0x00020000                // HOST_DMA0_HOST_RX_DONE_INT_ENA1[17]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA0_HOST_RX_DONE_INT_ENA1_SHFT 17
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA0_HOST_RX_DONE_INT_ENA0_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA0_HOST_RX_DONE_INT_ENA0_MASK 0x00010000                // HOST_DMA0_HOST_RX_DONE_INT_ENA0[16]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA0_HOST_RX_DONE_INT_ENA0_SHFT 16
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA1_HOST_TX_DONE_INT_ENA20_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA1_HOST_TX_DONE_INT_ENA20_MASK 0x00008000                // HOST_DMA1_HOST_TX_DONE_INT_ENA20[15]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA1_HOST_TX_DONE_INT_ENA20_SHFT 15
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA1_HOST_TX_DONE_INT_ENA8_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA1_HOST_TX_DONE_INT_ENA8_MASK 0x00001000                // HOST_DMA1_HOST_TX_DONE_INT_ENA8[12]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA1_HOST_TX_DONE_INT_ENA8_SHFT 12
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA1_HOST_TX_DONE_INT_ENA7_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA1_HOST_TX_DONE_INT_ENA7_MASK 0x00000800                // HOST_DMA1_HOST_TX_DONE_INT_ENA7[11]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA1_HOST_TX_DONE_INT_ENA7_SHFT 11
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA1_HOST_TX_DONE_INT_ENA6_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA1_HOST_TX_DONE_INT_ENA6_MASK 0x00000400                // HOST_DMA1_HOST_TX_DONE_INT_ENA6[10]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA1_HOST_TX_DONE_INT_ENA6_SHFT 10
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA1_HOST_TX_DONE_INT_ENA5_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA1_HOST_TX_DONE_INT_ENA5_MASK 0x00000200                // HOST_DMA1_HOST_TX_DONE_INT_ENA5[9]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA1_HOST_TX_DONE_INT_ENA5_SHFT 9
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA1_HOST_TX_DONE_INT_ENA4_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA1_HOST_TX_DONE_INT_ENA4_MASK 0x00000100                // HOST_DMA1_HOST_TX_DONE_INT_ENA4[8]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA1_HOST_TX_DONE_INT_ENA4_SHFT 8
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA1_HOST_TX_DONE_INT_ENA3_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA1_HOST_TX_DONE_INT_ENA3_MASK 0x00000080                // HOST_DMA1_HOST_TX_DONE_INT_ENA3[7]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA1_HOST_TX_DONE_INT_ENA3_SHFT 7
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA1_HOST_TX_DONE_INT_ENA2_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA1_HOST_TX_DONE_INT_ENA2_MASK 0x00000040                // HOST_DMA1_HOST_TX_DONE_INT_ENA2[6]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA1_HOST_TX_DONE_INT_ENA2_SHFT 6
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA1_HOST_TX_DONE_INT_ENA1_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA1_HOST_TX_DONE_INT_ENA1_MASK 0x00000020                // HOST_DMA1_HOST_TX_DONE_INT_ENA1[5]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA1_HOST_TX_DONE_INT_ENA1_SHFT 5
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA1_HOST_TX_DONE_INT_ENA0_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA1_HOST_TX_DONE_INT_ENA0_MASK 0x00000010                // HOST_DMA1_HOST_TX_DONE_INT_ENA0[4]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA1_HOST_TX_DONE_INT_ENA0_SHFT 4
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA1_HOST_RX_DONE_INT_ENA3_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA1_HOST_RX_DONE_INT_ENA3_MASK 0x00000008                // HOST_DMA1_HOST_RX_DONE_INT_ENA3[3]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA1_HOST_RX_DONE_INT_ENA3_SHFT 3
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA1_HOST_RX_DONE_INT_ENA2_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA1_HOST_RX_DONE_INT_ENA2_MASK 0x00000004                // HOST_DMA1_HOST_RX_DONE_INT_ENA2[2]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA1_HOST_RX_DONE_INT_ENA2_SHFT 2
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA1_HOST_RX_DONE_INT_ENA1_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA1_HOST_RX_DONE_INT_ENA1_MASK 0x00000002                // HOST_DMA1_HOST_RX_DONE_INT_ENA1[1]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA1_HOST_RX_DONE_INT_ENA1_SHFT 1
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA1_HOST_RX_DONE_INT_ENA0_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA1_HOST_RX_DONE_INT_ENA0_MASK 0x00000001                // HOST_DMA1_HOST_RX_DONE_INT_ENA0[0]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_INT_ENA_HOST_DMA1_HOST_RX_DONE_INT_ENA0_SHFT 0

/* =====================================================================================

  ---WFDMA_TOP_DBG_IN0 (0x18027000 + 0x20)---

    DBG_IN_31_0[31..0]           - (RO) DBG_IN_31_0

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_TOP_DBG_IN0_DBG_IN_31_0_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_TOP_DBG_IN0_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_TOP_DBG_IN0_DBG_IN_31_0_MASK 0xFFFFFFFF                // DBG_IN_31_0[31..0]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_TOP_DBG_IN0_DBG_IN_31_0_SHFT 0

/* =====================================================================================

  ---WFDMA_TOP_DBG_IN1 (0x18027000 + 0x24)---

    DBG_IN_63_32[31..0]          - (RO) DBG_IN_63_32

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_TOP_DBG_IN1_DBG_IN_63_32_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_TOP_DBG_IN1_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_TOP_DBG_IN1_DBG_IN_63_32_MASK 0xFFFFFFFF                // DBG_IN_63_32[31..0]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_TOP_DBG_IN1_DBG_IN_63_32_SHFT 0

/* =====================================================================================

  ---WFDMA_TOP_DBG_IN2 (0x18027000 + 0x28)---

    DBG_IN_95_64[31..0]          - (RO) DBG_IN_95_64

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_TOP_DBG_IN2_DBG_IN_95_64_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_TOP_DBG_IN2_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_TOP_DBG_IN2_DBG_IN_95_64_MASK 0xFFFFFFFF                // DBG_IN_95_64[31..0]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_TOP_DBG_IN2_DBG_IN_95_64_SHFT 0

/* =====================================================================================

  ---WFDMA_TOP_DBG_IN3 (0x18027000 + 0x2C)---

    DBG_IN_127_96[31..0]         - (RO) DBG_IN_127_96

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_TOP_DBG_IN3_DBG_IN_127_96_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_TOP_DBG_IN3_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_TOP_DBG_IN3_DBG_IN_127_96_MASK 0xFFFFFFFF                // DBG_IN_127_96[31..0]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_TOP_DBG_IN3_DBG_IN_127_96_SHFT 0

/* =====================================================================================

  ---WFDMA_HOST_CONFIG (0x18027000 + 0x30)---

    pdma_per_band[0]             - (RW) 0: Dual band shares PDMA for 1PCIE   1: Dual band has dedicated PDMA for 2PCIE
    host_wed_en[1]               - (RW) TX WED function enable
    pcie0_msi_num[3..2]          - (RW) PCIE0 MSI message number - 2'h0: 1MSI , 2'h1: 2MSI , 2'h2: 4MSI , 2'h3: 8MSI
    pcie1_msi_num[5..4]          - (RW) PCIE1 MSI message number - 2'h0: 1MSI , 2'h1: 2MSI , 2'h2: 4MSI , 2'h3: 8MSI
    usb_rxevt_ep4[6]             - (RW) RX event forward to USB IN EP4, otherwise EP5
    usb_cmdpkt_dst[7]            - (RW) 0: command packet forward to TX ring 17 (WMCPU)   1: forward to TX ring 20 (WACPU)
    usb_rx_cso_en[8]             - (RW) 0: no RX CSO insertion   1: with RX CSO insertion
    RESERVED9[31..9]             - (RO) Reserved bits

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_CONFIG_usb_rx_cso_en_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_CONFIG_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_CONFIG_usb_rx_cso_en_MASK 0x00000100                // usb_rx_cso_en[8]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_CONFIG_usb_rx_cso_en_SHFT 8
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_CONFIG_usb_cmdpkt_dst_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_CONFIG_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_CONFIG_usb_cmdpkt_dst_MASK 0x00000080                // usb_cmdpkt_dst[7]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_CONFIG_usb_cmdpkt_dst_SHFT 7
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_CONFIG_usb_rxevt_ep4_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_CONFIG_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_CONFIG_usb_rxevt_ep4_MASK 0x00000040                // usb_rxevt_ep4[6]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_CONFIG_usb_rxevt_ep4_SHFT 6
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_CONFIG_pcie1_msi_num_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_CONFIG_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_CONFIG_pcie1_msi_num_MASK 0x00000030                // pcie1_msi_num[5..4]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_CONFIG_pcie1_msi_num_SHFT 4
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_CONFIG_pcie0_msi_num_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_CONFIG_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_CONFIG_pcie0_msi_num_MASK 0x0000000C                // pcie0_msi_num[3..2]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_CONFIG_pcie0_msi_num_SHFT 2
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_CONFIG_host_wed_en_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_CONFIG_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_CONFIG_host_wed_en_MASK 0x00000002                // host_wed_en[1]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_CONFIG_host_wed_en_SHFT 1
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_CONFIG_pdma_per_band_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_CONFIG_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_CONFIG_pdma_per_band_MASK 0x00000001                // pdma_per_band[0]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HOST_CONFIG_pdma_per_band_SHFT 0

/* =====================================================================================

  ---WED_RING_CONTROL_IDX (0x18027000 + 0x34)---

    WED_TX_RING0_CONTROL_IDX[4..0] - (RW) WED ring index for TX0 control
    RESERVED5[7..5]              - (RO) Reserved bits
    WED_TX_RING1_CONTROL_IDX[12..8] - (RW) WED ring index for TX1 control
    RESERVED13[15..13]           - (RO) Reserved bits
    WED_RX_RING1_CONTROL_IDX[20..16] - (RW) WED ring index for RX1 control
    RESERVED21[31..21]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WED_RING_CONTROL_IDX_WED_RX_RING1_CONTROL_IDX_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_RING_CONTROL_IDX_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_RING_CONTROL_IDX_WED_RX_RING1_CONTROL_IDX_MASK 0x001F0000                // WED_RX_RING1_CONTROL_IDX[20..16]
#define WF_WFDMA_EXT_WRAP_CSR_WED_RING_CONTROL_IDX_WED_RX_RING1_CONTROL_IDX_SHFT 16
#define WF_WFDMA_EXT_WRAP_CSR_WED_RING_CONTROL_IDX_WED_TX_RING1_CONTROL_IDX_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_RING_CONTROL_IDX_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_RING_CONTROL_IDX_WED_TX_RING1_CONTROL_IDX_MASK 0x00001F00                // WED_TX_RING1_CONTROL_IDX[12..8]
#define WF_WFDMA_EXT_WRAP_CSR_WED_RING_CONTROL_IDX_WED_TX_RING1_CONTROL_IDX_SHFT 8
#define WF_WFDMA_EXT_WRAP_CSR_WED_RING_CONTROL_IDX_WED_TX_RING0_CONTROL_IDX_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_RING_CONTROL_IDX_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_RING_CONTROL_IDX_WED_TX_RING0_CONTROL_IDX_MASK 0x0000001F                // WED_TX_RING0_CONTROL_IDX[4..0]
#define WF_WFDMA_EXT_WRAP_CSR_WED_RING_CONTROL_IDX_WED_TX_RING0_CONTROL_IDX_SHFT 0

/* =====================================================================================

  ---DLY_INT_TICK_THRES (0x18027000 + 0x38)---

    delay_int_tick_threshold[15..0] - (RW) 1us tick generation: slow clock period = 2*(delay_int_tick_threshold)*fast_clock_cycle_time
    RESERVED16[31..16]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_DLY_INT_TICK_THRES_delay_int_tick_threshold_ADDR WF_WFDMA_EXT_WRAP_CSR_DLY_INT_TICK_THRES_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_DLY_INT_TICK_THRES_delay_int_tick_threshold_MASK 0x0000FFFF                // delay_int_tick_threshold[15..0]
#define WF_WFDMA_EXT_WRAP_CSR_DLY_INT_TICK_THRES_delay_int_tick_threshold_SHFT 0

/* =====================================================================================

  ---WFDMA_SW_RST (0x18027000 + 0x3C)---

    HIF_SW_RST[0]                - (RW) HIF side S/W reset , write 1 to trigger reset pulse then auto clear
    MCU_SW_RST[1]                - (RW) MCU side S/W reset , write 1 to trigger reset pulse then auto clear
    RESERVED2[31..2]             - (RO) Reserved bits

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_SW_RST_MCU_SW_RST_ADDR     WF_WFDMA_EXT_WRAP_CSR_WFDMA_SW_RST_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_SW_RST_MCU_SW_RST_MASK     0x00000002                // MCU_SW_RST[1]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_SW_RST_MCU_SW_RST_SHFT     1
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_SW_RST_HIF_SW_RST_ADDR     WF_WFDMA_EXT_WRAP_CSR_WFDMA_SW_RST_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_SW_RST_HIF_SW_RST_MASK     0x00000001                // HIF_SW_RST[0]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_SW_RST_HIF_SW_RST_SHFT     0

/* =====================================================================================

  ---WFDMA_DBG_SEL (0x18027000 + 0x40)---

    DEBUG_SEL[1..0]              - (RW) debug select among PDMA
    RESERVED2[31..2]             - (RO) Reserved bits

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_DBG_SEL_DEBUG_SEL_ADDR     WF_WFDMA_EXT_WRAP_CSR_WFDMA_DBG_SEL_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_DBG_SEL_DEBUG_SEL_MASK     0x00000003                // DEBUG_SEL[1..0]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_DBG_SEL_DEBUG_SEL_SHFT     0

/* =====================================================================================

  ---WFDMA_HIF_MISC (0x18027000 + 0x44)---

    HIF_BUSY[0]                  - (RO) Inverse of idle indicator
    PCIE0_AXI_MST_GALS_SLPPROT_EN[1] - (RW) PCIE0 AXI Master GALS sleep protect enable
    RESERVED[2]                  - (RO) reserved
    PCIE0_AXI_MST_GALS_SLPPROT_RDY[3] - (RO) PCIE0 AXI Master GALS sleep protect ready
    RESERVED[4]                  - (RO) reserved
    PCIE1_AXI_MST_GALS_SLPPROT_EN[5] - (RW) PCIE1 AXI Master GALS sleep protect enable
    RESERVED[6]                  - (RO) reserved
    PCIE1_AXI_MST_GALS_SLPPROT_RDY[7] - (RO) PCIE1 AXI Master GALS sleep protect ready
    RESERVED[8]                  - (RO) reserved
    PCIE0_AXI_MST_GALS_MST_SYNC_SEL[10..9] - (RW) PCIE0 AXI Master GALS master sync select
    PCIE0_AXI_MST_GALS_SLV_SYNC_SEL[12..11] - (RW) PCIE0 AXI Master GALS slave sync select
    PCIE0_AXI_MST_GALS_SAMPLE_SEL[13] - (RW) PCIE0 AXI Master GALS sample select
    PCIE1_AXI_MST_GALS_MST_SYNC_SEL[15..14] - (RW) PCIE1 AXI Master GALS master sync select
    PCIE1_AXI_MST_GALS_SLV_SYNC_SEL[17..16] - (RW) PCIE1 AXI Master GALS slave sync select
    PCIE1_AXI_MST_GALS_SAMPLE_SEL[18] - (RW) PCIE1 AXI Master GALS sample select
    PCIE0_AXI_MST_GALS_SLPPROT_CLKRDY[19] - (RW) PCIE0 AXI Master GALS sleep protect clock ready on DCM
    PCIE1_AXI_MST_GALS_SLPPROT_CLKRDY[20] - (RW) PCIE1 AXI Master GALS sleep protect clock ready on DCM
    RESERVED21[23..21]           - (RO) Reserved bits
    STOP_RX_AFIFO_PCIE0_HDM0[24] - (RW) Stop AFIFO operation
    STOP_RX_AFIFO_PCIE0_HDM1[25] - (RW) Stop AFIFO operation
    STOP_RX_AFIFO_PCIE1_HDM0[26] - (RW) Stop AFIFO operation
    STOP_RX_AFIFO_PCIE1_HDM1[27] - (RW) Stop AFIFO operation
    RESERVED28[31..28]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HIF_MISC_STOP_RX_AFIFO_PCIE1_HDM1_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HIF_MISC_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HIF_MISC_STOP_RX_AFIFO_PCIE1_HDM1_MASK 0x08000000                // STOP_RX_AFIFO_PCIE1_HDM1[27]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HIF_MISC_STOP_RX_AFIFO_PCIE1_HDM1_SHFT 27
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HIF_MISC_STOP_RX_AFIFO_PCIE1_HDM0_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HIF_MISC_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HIF_MISC_STOP_RX_AFIFO_PCIE1_HDM0_MASK 0x04000000                // STOP_RX_AFIFO_PCIE1_HDM0[26]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HIF_MISC_STOP_RX_AFIFO_PCIE1_HDM0_SHFT 26
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HIF_MISC_STOP_RX_AFIFO_PCIE0_HDM1_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HIF_MISC_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HIF_MISC_STOP_RX_AFIFO_PCIE0_HDM1_MASK 0x02000000                // STOP_RX_AFIFO_PCIE0_HDM1[25]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HIF_MISC_STOP_RX_AFIFO_PCIE0_HDM1_SHFT 25
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HIF_MISC_STOP_RX_AFIFO_PCIE0_HDM0_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HIF_MISC_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HIF_MISC_STOP_RX_AFIFO_PCIE0_HDM0_MASK 0x01000000                // STOP_RX_AFIFO_PCIE0_HDM0[24]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HIF_MISC_STOP_RX_AFIFO_PCIE0_HDM0_SHFT 24
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HIF_MISC_PCIE1_AXI_MST_GALS_SLPPROT_CLKRDY_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HIF_MISC_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HIF_MISC_PCIE1_AXI_MST_GALS_SLPPROT_CLKRDY_MASK 0x00100000                // PCIE1_AXI_MST_GALS_SLPPROT_CLKRDY[20]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HIF_MISC_PCIE1_AXI_MST_GALS_SLPPROT_CLKRDY_SHFT 20
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HIF_MISC_PCIE0_AXI_MST_GALS_SLPPROT_CLKRDY_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HIF_MISC_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HIF_MISC_PCIE0_AXI_MST_GALS_SLPPROT_CLKRDY_MASK 0x00080000                // PCIE0_AXI_MST_GALS_SLPPROT_CLKRDY[19]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HIF_MISC_PCIE0_AXI_MST_GALS_SLPPROT_CLKRDY_SHFT 19
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HIF_MISC_PCIE1_AXI_MST_GALS_SAMPLE_SEL_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HIF_MISC_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HIF_MISC_PCIE1_AXI_MST_GALS_SAMPLE_SEL_MASK 0x00040000                // PCIE1_AXI_MST_GALS_SAMPLE_SEL[18]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HIF_MISC_PCIE1_AXI_MST_GALS_SAMPLE_SEL_SHFT 18
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HIF_MISC_PCIE1_AXI_MST_GALS_SLV_SYNC_SEL_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HIF_MISC_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HIF_MISC_PCIE1_AXI_MST_GALS_SLV_SYNC_SEL_MASK 0x00030000                // PCIE1_AXI_MST_GALS_SLV_SYNC_SEL[17..16]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HIF_MISC_PCIE1_AXI_MST_GALS_SLV_SYNC_SEL_SHFT 16
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HIF_MISC_PCIE1_AXI_MST_GALS_MST_SYNC_SEL_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HIF_MISC_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HIF_MISC_PCIE1_AXI_MST_GALS_MST_SYNC_SEL_MASK 0x0000C000                // PCIE1_AXI_MST_GALS_MST_SYNC_SEL[15..14]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HIF_MISC_PCIE1_AXI_MST_GALS_MST_SYNC_SEL_SHFT 14
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HIF_MISC_PCIE0_AXI_MST_GALS_SAMPLE_SEL_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HIF_MISC_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HIF_MISC_PCIE0_AXI_MST_GALS_SAMPLE_SEL_MASK 0x00002000                // PCIE0_AXI_MST_GALS_SAMPLE_SEL[13]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HIF_MISC_PCIE0_AXI_MST_GALS_SAMPLE_SEL_SHFT 13
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HIF_MISC_PCIE0_AXI_MST_GALS_SLV_SYNC_SEL_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HIF_MISC_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HIF_MISC_PCIE0_AXI_MST_GALS_SLV_SYNC_SEL_MASK 0x00001800                // PCIE0_AXI_MST_GALS_SLV_SYNC_SEL[12..11]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HIF_MISC_PCIE0_AXI_MST_GALS_SLV_SYNC_SEL_SHFT 11
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HIF_MISC_PCIE0_AXI_MST_GALS_MST_SYNC_SEL_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HIF_MISC_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HIF_MISC_PCIE0_AXI_MST_GALS_MST_SYNC_SEL_MASK 0x00000600                // PCIE0_AXI_MST_GALS_MST_SYNC_SEL[10..9]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HIF_MISC_PCIE0_AXI_MST_GALS_MST_SYNC_SEL_SHFT 9
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HIF_MISC_PCIE1_AXI_MST_GALS_SLPPROT_RDY_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HIF_MISC_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HIF_MISC_PCIE1_AXI_MST_GALS_SLPPROT_RDY_MASK 0x00000080                // PCIE1_AXI_MST_GALS_SLPPROT_RDY[7]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HIF_MISC_PCIE1_AXI_MST_GALS_SLPPROT_RDY_SHFT 7
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HIF_MISC_PCIE1_AXI_MST_GALS_SLPPROT_EN_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HIF_MISC_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HIF_MISC_PCIE1_AXI_MST_GALS_SLPPROT_EN_MASK 0x00000020                // PCIE1_AXI_MST_GALS_SLPPROT_EN[5]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HIF_MISC_PCIE1_AXI_MST_GALS_SLPPROT_EN_SHFT 5
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HIF_MISC_PCIE0_AXI_MST_GALS_SLPPROT_RDY_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HIF_MISC_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HIF_MISC_PCIE0_AXI_MST_GALS_SLPPROT_RDY_MASK 0x00000008                // PCIE0_AXI_MST_GALS_SLPPROT_RDY[3]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HIF_MISC_PCIE0_AXI_MST_GALS_SLPPROT_RDY_SHFT 3
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HIF_MISC_PCIE0_AXI_MST_GALS_SLPPROT_EN_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_HIF_MISC_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HIF_MISC_PCIE0_AXI_MST_GALS_SLPPROT_EN_MASK 0x00000002                // PCIE0_AXI_MST_GALS_SLPPROT_EN[1]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HIF_MISC_PCIE0_AXI_MST_GALS_SLPPROT_EN_SHFT 1
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HIF_MISC_HIF_BUSY_ADDR     WF_WFDMA_EXT_WRAP_CSR_WFDMA_HIF_MISC_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HIF_MISC_HIF_BUSY_MASK     0x00000001                // HIF_BUSY[0]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_HIF_MISC_HIF_BUSY_SHFT     0

/* =====================================================================================

  ---WFDMA_AXI_SLPPROT_CTRL (0x18027000 + 0x50)---

    AXI0_SLPPROT_EN[0]           - (RW) AXI0 sleep protect enable
    AXI0_SLPPROT_RDY[1]          - (RO) AXI0 sleep protect ready
    AXI0_SLPPROT_IDLE[2]         - (RO) AXI0 sleep protect idle
    AXI0_SLPPROT_ERR[3]          - (RO) AXI0 sleep protect error
    AXI0_SLPPROT_VIO_RD[4]       - (RO) AXI0 sleep protect violated transaction is read type
    AXI0_SLPPROT_VIO_WR[5]       - (RO) AXI0 sleep protect violated transaction is write type
    RESERVED6[7..6]              - (RO) Reserved bits
    AXI0_SLPPROT_VIO_ADDR_EXT[11..8] - (RO) AXI0 sleep protect violated address [35:32]
    RESERVED12[15..12]           - (RO) Reserved bits
    AXI1_SLPPROT_EN[16]          - (RW) AXI1 sleep protect enable
    AXI1_SLPPROT_RDY[17]         - (RO) AXI1 sleep protect ready
    AXI1_SLPPROT_IDLE[18]        - (RO) AXI1 sleep protect idle
    AXI1_SLPPROT_ERR[19]         - (RO) AXI1 sleep protect error
    AXI1_SLPPROT_VIO_RD[20]      - (RO) AXI1 sleep protect violated transaction is read type
    AXI1_SLPPROT_VIO_WR[21]      - (RO) AXI1 sleep protect violated transaction is write type
    RESERVED22[23..22]           - (RO) Reserved bits
    AXI1_SLPPROT_VIO_ADDR_EXT[27..24] - (RO) AXI1 sleep protect violated address [35:32]
    RESERVED28[31..28]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_SLPPROT_CTRL_AXI1_SLPPROT_VIO_ADDR_EXT_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_SLPPROT_CTRL_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_SLPPROT_CTRL_AXI1_SLPPROT_VIO_ADDR_EXT_MASK 0x0F000000                // AXI1_SLPPROT_VIO_ADDR_EXT[27..24]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_SLPPROT_CTRL_AXI1_SLPPROT_VIO_ADDR_EXT_SHFT 24
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_SLPPROT_CTRL_AXI1_SLPPROT_VIO_WR_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_SLPPROT_CTRL_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_SLPPROT_CTRL_AXI1_SLPPROT_VIO_WR_MASK 0x00200000                // AXI1_SLPPROT_VIO_WR[21]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_SLPPROT_CTRL_AXI1_SLPPROT_VIO_WR_SHFT 21
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_SLPPROT_CTRL_AXI1_SLPPROT_VIO_RD_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_SLPPROT_CTRL_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_SLPPROT_CTRL_AXI1_SLPPROT_VIO_RD_MASK 0x00100000                // AXI1_SLPPROT_VIO_RD[20]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_SLPPROT_CTRL_AXI1_SLPPROT_VIO_RD_SHFT 20
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_SLPPROT_CTRL_AXI1_SLPPROT_ERR_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_SLPPROT_CTRL_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_SLPPROT_CTRL_AXI1_SLPPROT_ERR_MASK 0x00080000                // AXI1_SLPPROT_ERR[19]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_SLPPROT_CTRL_AXI1_SLPPROT_ERR_SHFT 19
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_SLPPROT_CTRL_AXI1_SLPPROT_IDLE_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_SLPPROT_CTRL_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_SLPPROT_CTRL_AXI1_SLPPROT_IDLE_MASK 0x00040000                // AXI1_SLPPROT_IDLE[18]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_SLPPROT_CTRL_AXI1_SLPPROT_IDLE_SHFT 18
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_SLPPROT_CTRL_AXI1_SLPPROT_RDY_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_SLPPROT_CTRL_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_SLPPROT_CTRL_AXI1_SLPPROT_RDY_MASK 0x00020000                // AXI1_SLPPROT_RDY[17]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_SLPPROT_CTRL_AXI1_SLPPROT_RDY_SHFT 17
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_SLPPROT_CTRL_AXI1_SLPPROT_EN_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_SLPPROT_CTRL_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_SLPPROT_CTRL_AXI1_SLPPROT_EN_MASK 0x00010000                // AXI1_SLPPROT_EN[16]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_SLPPROT_CTRL_AXI1_SLPPROT_EN_SHFT 16
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_SLPPROT_CTRL_AXI0_SLPPROT_VIO_ADDR_EXT_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_SLPPROT_CTRL_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_SLPPROT_CTRL_AXI0_SLPPROT_VIO_ADDR_EXT_MASK 0x00000F00                // AXI0_SLPPROT_VIO_ADDR_EXT[11..8]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_SLPPROT_CTRL_AXI0_SLPPROT_VIO_ADDR_EXT_SHFT 8
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_SLPPROT_CTRL_AXI0_SLPPROT_VIO_WR_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_SLPPROT_CTRL_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_SLPPROT_CTRL_AXI0_SLPPROT_VIO_WR_MASK 0x00000020                // AXI0_SLPPROT_VIO_WR[5]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_SLPPROT_CTRL_AXI0_SLPPROT_VIO_WR_SHFT 5
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_SLPPROT_CTRL_AXI0_SLPPROT_VIO_RD_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_SLPPROT_CTRL_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_SLPPROT_CTRL_AXI0_SLPPROT_VIO_RD_MASK 0x00000010                // AXI0_SLPPROT_VIO_RD[4]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_SLPPROT_CTRL_AXI0_SLPPROT_VIO_RD_SHFT 4
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_SLPPROT_CTRL_AXI0_SLPPROT_ERR_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_SLPPROT_CTRL_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_SLPPROT_CTRL_AXI0_SLPPROT_ERR_MASK 0x00000008                // AXI0_SLPPROT_ERR[3]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_SLPPROT_CTRL_AXI0_SLPPROT_ERR_SHFT 3
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_SLPPROT_CTRL_AXI0_SLPPROT_IDLE_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_SLPPROT_CTRL_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_SLPPROT_CTRL_AXI0_SLPPROT_IDLE_MASK 0x00000004                // AXI0_SLPPROT_IDLE[2]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_SLPPROT_CTRL_AXI0_SLPPROT_IDLE_SHFT 2
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_SLPPROT_CTRL_AXI0_SLPPROT_RDY_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_SLPPROT_CTRL_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_SLPPROT_CTRL_AXI0_SLPPROT_RDY_MASK 0x00000002                // AXI0_SLPPROT_RDY[1]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_SLPPROT_CTRL_AXI0_SLPPROT_RDY_SHFT 1
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_SLPPROT_CTRL_AXI0_SLPPROT_EN_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_SLPPROT_CTRL_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_SLPPROT_CTRL_AXI0_SLPPROT_EN_MASK 0x00000001                // AXI0_SLPPROT_EN[0]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_SLPPROT_CTRL_AXI0_SLPPROT_EN_SHFT 0

/* =====================================================================================

  ---WFDMA_AXI0_SLPPROT_VIO_ADDR (0x18027000 + 0x54)---

    AXI0_SLPPROT_VIO_ADDR[31..0] - (RO) AXI0 sleep protect violated address [31:0]

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_SLPPROT_VIO_ADDR_AXI0_SLPPROT_VIO_ADDR_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_SLPPROT_VIO_ADDR_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_SLPPROT_VIO_ADDR_AXI0_SLPPROT_VIO_ADDR_MASK 0xFFFFFFFF                // AXI0_SLPPROT_VIO_ADDR[31..0]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_SLPPROT_VIO_ADDR_AXI0_SLPPROT_VIO_ADDR_SHFT 0

/* =====================================================================================

  ---WFDMA_AXI1_SLPPROT_VIO_ADDR (0x18027000 + 0x58)---

    AXI1_SLPPROT_VIO_ADDR[31..0] - (RO) AXI1 sleep protect violated address [31:0]

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_SLPPROT_VIO_ADDR_AXI1_SLPPROT_VIO_ADDR_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_SLPPROT_VIO_ADDR_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_SLPPROT_VIO_ADDR_AXI1_SLPPROT_VIO_ADDR_MASK 0xFFFFFFFF                // AXI1_SLPPROT_VIO_ADDR[31..0]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_SLPPROT_VIO_ADDR_AXI1_SLPPROT_VIO_ADDR_SHFT 0

/* =====================================================================================

  ---WFDMA_MBIST_FUSE_CTRL (0x18027000 + 0x5C)---

    MBIST_FUSE_SEL[0]            - (RW) TMBIST FUSE selection
    MBIST_PREFUSE_0[16..1]       - (RW) TMBIST PREFUSE control
    RESERVED17[31..17]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_MBIST_FUSE_CTRL_MBIST_PREFUSE_0_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_MBIST_FUSE_CTRL_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_MBIST_FUSE_CTRL_MBIST_PREFUSE_0_MASK 0x0001FFFE                // MBIST_PREFUSE_0[16..1]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_MBIST_FUSE_CTRL_MBIST_PREFUSE_0_SHFT 1
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_MBIST_FUSE_CTRL_MBIST_FUSE_SEL_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_MBIST_FUSE_CTRL_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_MBIST_FUSE_CTRL_MBIST_FUSE_SEL_MASK 0x00000001                // MBIST_FUSE_SEL[0]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_MBIST_FUSE_CTRL_MBIST_FUSE_SEL_SHFT 0

/* =====================================================================================

  ---WFDMA_MBIST_PREFUSE_D (0x18027000 + 0x60)---

    MBIST_PREFUSE_D[15..0]       - (RO) TMBIST PREFUSE data
    RESERVED16[31..16]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_MBIST_PREFUSE_D_MBIST_PREFUSE_D_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_MBIST_PREFUSE_D_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_MBIST_PREFUSE_D_MBIST_PREFUSE_D_MASK 0x0000FFFF                // MBIST_PREFUSE_D[15..0]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_MBIST_PREFUSE_D_MBIST_PREFUSE_D_SHFT 0

/* =====================================================================================

  ---WFDMA_AXI_MTR_TICK_CNT (0x18027000 + 0x64)---

    AXI_MTR_TICK_CNT[15..0]      - (RW) AXI monitor timer setting for tick generation
    RESERVED16[31..16]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_MTR_TICK_CNT_AXI_MTR_TICK_CNT_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_MTR_TICK_CNT_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_MTR_TICK_CNT_AXI_MTR_TICK_CNT_MASK 0x0000FFFF                // AXI_MTR_TICK_CNT[15..0]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_MTR_TICK_CNT_AXI_MTR_TICK_CNT_SHFT 0

/* =====================================================================================

  ---PCIE1_HOST_INT_STA (0x18027000 + 0x88)---

    RESERVED0[1..0]              - (RO) Reserved bits
    host_dma1_rx_done_int_sts_2[2] - (W1C) RX Queue#2 packet receive interrupt
                                     Write 1 to clear the interrupt
                                     Read to get the raw interrupt status
    RESERVED3[6..3]              - (RO) Reserved bits
    host_dma1_tx_done_int_sts_19[7] - (W1C) TX Queue#19 packet transmit interrupt
                                     Write 1 to clear the interrupt
    RESERVED8[16..8]             - (RO) Reserved bits
    host_dma0_rx_don_int_sts_1[17] - (W1C) RX Queue#1 packet receive interrupt
                                     Write 1 to clear the interrupt
                                     Read to get the raw interrupt status
    RESERVED18[19..18]           - (RO) Reserved bits
    host_dma1_rx_coherent_int_sts[20] - (W1C) RX_DMA finds data coherent event when checking ddone bit
                                     Write 1 to clear the interrupt
                                     Read to get the raw interrupt status
    host_dma1_tx_coherent_int_sts[21] - (W1C) TX_DMA finds data coherent event when checking ddone bit
                                     Write 1 to clear the interrupt
                                     Read to get the raw interrupt status
    host_dma0_rx_coherent_int_sts[22] - (W1C) RX_DMA finds data coherent event when checking ddone bit
                                     Write 1 to clear the interrupt
                                     Read to get the raw interrupt status
    host_dma0_tx_coherent_int_sts[23] - (W1C) TX_DMA finds data coherent event when checking ddone bit
                                     Write 1 to clear the interrupt
                                     Read to get the raw interrupt status
    host_dma1_wpdma2host_err_int_sts[24] - (RO) wpdma interrupt overall status
                                     User should should check WPDMA_ERR_INT_STA for each wpdma error interrupt status 
                                     Host could read [0x0_41E8] to check indivisual wpdma2host_error interrupt status
    host_dma0_wpdma2host_err_int_sts[25] - (RO) wpdma interrupt overall status
                                     User should should check WPDMA_ERR_INT_STA for each wpdma error interrupt status 
                                     Host could read [0x0_41E8] to check indivisual wpdma2host_error interrupt status
    RESERVED26[27..26]           - (RO) Reserved bits
    host_dma1_subsys_int_sts[28] - (RO) subsys interrupt overall status
                                     User should should check SUBSYS2HOST_INT_STA for each interrupt status 
                                     Host could read [0x0_41F8] to check indivisual subsys hw interrupt status
    host_dma1_mcu2host_sw_int_sts[29] - (RO) subsys interrupt overall status
                                     User should should check SUBSYS2HOST_INT_STA for each interrupt status 
                                     Host could read [0x0_41F8] to check indivisual subsys hw interrupt status
    RESERVED30[31..30]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_STA_host_dma1_mcu2host_sw_int_sts_ADDR WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_STA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_STA_host_dma1_mcu2host_sw_int_sts_MASK 0x20000000                // host_dma1_mcu2host_sw_int_sts[29]
#define WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_STA_host_dma1_mcu2host_sw_int_sts_SHFT 29
#define WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_STA_host_dma1_subsys_int_sts_ADDR WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_STA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_STA_host_dma1_subsys_int_sts_MASK 0x10000000                // host_dma1_subsys_int_sts[28]
#define WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_STA_host_dma1_subsys_int_sts_SHFT 28
#define WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_STA_host_dma0_wpdma2host_err_int_sts_ADDR WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_STA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_STA_host_dma0_wpdma2host_err_int_sts_MASK 0x02000000                // host_dma0_wpdma2host_err_int_sts[25]
#define WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_STA_host_dma0_wpdma2host_err_int_sts_SHFT 25
#define WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_STA_host_dma1_wpdma2host_err_int_sts_ADDR WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_STA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_STA_host_dma1_wpdma2host_err_int_sts_MASK 0x01000000                // host_dma1_wpdma2host_err_int_sts[24]
#define WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_STA_host_dma1_wpdma2host_err_int_sts_SHFT 24
#define WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_STA_host_dma0_tx_coherent_int_sts_ADDR WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_STA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_STA_host_dma0_tx_coherent_int_sts_MASK 0x00800000                // host_dma0_tx_coherent_int_sts[23]
#define WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_STA_host_dma0_tx_coherent_int_sts_SHFT 23
#define WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_STA_host_dma0_rx_coherent_int_sts_ADDR WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_STA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_STA_host_dma0_rx_coherent_int_sts_MASK 0x00400000                // host_dma0_rx_coherent_int_sts[22]
#define WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_STA_host_dma0_rx_coherent_int_sts_SHFT 22
#define WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_STA_host_dma1_tx_coherent_int_sts_ADDR WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_STA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_STA_host_dma1_tx_coherent_int_sts_MASK 0x00200000                // host_dma1_tx_coherent_int_sts[21]
#define WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_STA_host_dma1_tx_coherent_int_sts_SHFT 21
#define WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_STA_host_dma1_rx_coherent_int_sts_ADDR WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_STA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_STA_host_dma1_rx_coherent_int_sts_MASK 0x00100000                // host_dma1_rx_coherent_int_sts[20]
#define WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_STA_host_dma1_rx_coherent_int_sts_SHFT 20
#define WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_STA_host_dma0_rx_don_int_sts_1_ADDR WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_STA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_STA_host_dma0_rx_don_int_sts_1_MASK 0x00020000                // host_dma0_rx_don_int_sts_1[17]
#define WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_STA_host_dma0_rx_don_int_sts_1_SHFT 17
#define WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_STA_host_dma1_tx_done_int_sts_19_ADDR WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_STA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_STA_host_dma1_tx_done_int_sts_19_MASK 0x00000080                // host_dma1_tx_done_int_sts_19[7]
#define WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_STA_host_dma1_tx_done_int_sts_19_SHFT 7
#define WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_STA_host_dma1_rx_done_int_sts_2_ADDR WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_STA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_STA_host_dma1_rx_done_int_sts_2_MASK 0x00000004                // host_dma1_rx_done_int_sts_2[2]
#define WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_STA_host_dma1_rx_done_int_sts_2_SHFT 2

/* =====================================================================================

  ---PCIE1_HOST_INT_ENA (0x18027000 + 0x8C)---

    RESERVED0[1..0]              - (RO) Reserved bits
    HOST_DMA1_HOST_RX_DONE_INT_ENA2[2] - (RW) RX Queue#2 packet receive interrupt
    RESERVED3[6..3]              - (RO) Reserved bits
    HOST_DMA1_HOST_TX_DONE_INT_ENA19[7] - (RW) TX Queue#19 packet transmit interrupt
    RESERVED8[16..8]             - (RO) Reserved bits
    HOST_DMA0_HOST_RX_DONE_INT_ENA1[17] - (RW) RX Queue#1 packet receive interrupt
    RESERVED18[19..18]           - (RO) Reserved bits
    HOST_DMA1_HOST_RX_COHERENT_EN[20] - (RW) Enable for RX_DMA data coherent interrupt
    HOST_DMA1_HOST_TX_COHERENT_EN[21] - (RW) Enable for TX_DMA data coherent interrupt
    HOST_DMA0_HOST_RX_COHERENT_EN[22] - (RW) Enable for RX_DMA data coherent interrupt
    HOST_DMA0_HOST_TX_COHERENT_EN[23] - (RW) Enable for TX_DMA data coherent interrupt
    host_dma1_wpdma2host_err_int_ena[24] - (RW) Enable bit of wpdma2host_err_int
    host_dma0_wpdma2host_err_int_ena[25] - (RW) Enable bit of wpdma2host_err_int
    RESERVED26[27..26]           - (RO) Reserved bits
    host_dma1_subsys_int_ena[28] - (RW) Enable bit of subsys_int
    host_dma1_mcu2host_sw_int_ena[29] - (RW) Enable bit of mcu2host_sw_int
    RESERVED30[31..30]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_ENA_host_dma1_mcu2host_sw_int_ena_ADDR WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_ENA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_ENA_host_dma1_mcu2host_sw_int_ena_MASK 0x20000000                // host_dma1_mcu2host_sw_int_ena[29]
#define WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_ENA_host_dma1_mcu2host_sw_int_ena_SHFT 29
#define WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_ENA_host_dma1_subsys_int_ena_ADDR WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_ENA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_ENA_host_dma1_subsys_int_ena_MASK 0x10000000                // host_dma1_subsys_int_ena[28]
#define WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_ENA_host_dma1_subsys_int_ena_SHFT 28
#define WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_ENA_host_dma0_wpdma2host_err_int_ena_ADDR WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_ENA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_ENA_host_dma0_wpdma2host_err_int_ena_MASK 0x02000000                // host_dma0_wpdma2host_err_int_ena[25]
#define WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_ENA_host_dma0_wpdma2host_err_int_ena_SHFT 25
#define WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_ENA_host_dma1_wpdma2host_err_int_ena_ADDR WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_ENA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_ENA_host_dma1_wpdma2host_err_int_ena_MASK 0x01000000                // host_dma1_wpdma2host_err_int_ena[24]
#define WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_ENA_host_dma1_wpdma2host_err_int_ena_SHFT 24
#define WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_ENA_HOST_DMA0_HOST_TX_COHERENT_EN_ADDR WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_ENA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_ENA_HOST_DMA0_HOST_TX_COHERENT_EN_MASK 0x00800000                // HOST_DMA0_HOST_TX_COHERENT_EN[23]
#define WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_ENA_HOST_DMA0_HOST_TX_COHERENT_EN_SHFT 23
#define WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_ENA_HOST_DMA0_HOST_RX_COHERENT_EN_ADDR WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_ENA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_ENA_HOST_DMA0_HOST_RX_COHERENT_EN_MASK 0x00400000                // HOST_DMA0_HOST_RX_COHERENT_EN[22]
#define WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_ENA_HOST_DMA0_HOST_RX_COHERENT_EN_SHFT 22
#define WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_ENA_HOST_DMA1_HOST_TX_COHERENT_EN_ADDR WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_ENA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_ENA_HOST_DMA1_HOST_TX_COHERENT_EN_MASK 0x00200000                // HOST_DMA1_HOST_TX_COHERENT_EN[21]
#define WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_ENA_HOST_DMA1_HOST_TX_COHERENT_EN_SHFT 21
#define WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_ENA_HOST_DMA1_HOST_RX_COHERENT_EN_ADDR WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_ENA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_ENA_HOST_DMA1_HOST_RX_COHERENT_EN_MASK 0x00100000                // HOST_DMA1_HOST_RX_COHERENT_EN[20]
#define WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_ENA_HOST_DMA1_HOST_RX_COHERENT_EN_SHFT 20
#define WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_ENA_HOST_DMA0_HOST_RX_DONE_INT_ENA1_ADDR WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_ENA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_ENA_HOST_DMA0_HOST_RX_DONE_INT_ENA1_MASK 0x00020000                // HOST_DMA0_HOST_RX_DONE_INT_ENA1[17]
#define WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_ENA_HOST_DMA0_HOST_RX_DONE_INT_ENA1_SHFT 17
#define WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_ENA_HOST_DMA1_HOST_TX_DONE_INT_ENA19_ADDR WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_ENA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_ENA_HOST_DMA1_HOST_TX_DONE_INT_ENA19_MASK 0x00000080                // HOST_DMA1_HOST_TX_DONE_INT_ENA19[7]
#define WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_ENA_HOST_DMA1_HOST_TX_DONE_INT_ENA19_SHFT 7
#define WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_ENA_HOST_DMA1_HOST_RX_DONE_INT_ENA2_ADDR WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_ENA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_ENA_HOST_DMA1_HOST_RX_DONE_INT_ENA2_MASK 0x00000004                // HOST_DMA1_HOST_RX_DONE_INT_ENA2[2]
#define WF_WFDMA_EXT_WRAP_CSR_PCIE1_HOST_INT_ENA_HOST_DMA1_HOST_RX_DONE_INT_ENA2_SHFT 2

/* =====================================================================================

  ---PCIE_RECOGNITION_ID (0x18027000 + 0x90)---

    PCIE_RECOG_ID[30..0]         - (RW) PCIE recognition ID
    PCIE_RECOG_SEM[31]           - (RC) H/W semaphore: read to clear and S/W needs to write 1 upon setting PCIE recognition ID to release semaphore

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_PCIE_RECOGNITION_ID_PCIE_RECOG_SEM_ADDR WF_WFDMA_EXT_WRAP_CSR_PCIE_RECOGNITION_ID_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_PCIE_RECOGNITION_ID_PCIE_RECOG_SEM_MASK 0x80000000                // PCIE_RECOG_SEM[31]
#define WF_WFDMA_EXT_WRAP_CSR_PCIE_RECOGNITION_ID_PCIE_RECOG_SEM_SHFT 31
#define WF_WFDMA_EXT_WRAP_CSR_PCIE_RECOGNITION_ID_PCIE_RECOG_ID_ADDR WF_WFDMA_EXT_WRAP_CSR_PCIE_RECOGNITION_ID_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_PCIE_RECOGNITION_ID_PCIE_RECOG_ID_MASK 0x7FFFFFFF                // PCIE_RECOG_ID[30..0]
#define WF_WFDMA_EXT_WRAP_CSR_PCIE_RECOGNITION_ID_PCIE_RECOG_ID_SHFT 0

/* =====================================================================================

  ---WFDMA_AXI0_MTR_CTRL (0x18027000 + 0x100)---

    AXIMTR_CTRL[31..0]           - (RW) AXI0 monitor control

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_MTR_CTRL_AXIMTR_CTRL_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_MTR_CTRL_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_MTR_CTRL_AXIMTR_CTRL_MASK 0xFFFFFFFF                // AXIMTR_CTRL[31..0]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_MTR_CTRL_AXIMTR_CTRL_SHFT 0

/* =====================================================================================

  ---WFDMA_AXI1_MTR_CTRL (0x18027000 + 0x104)---

    AXIMTR_CTRL[31..0]           - (RW) AXI1 monitor control

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_MTR_CTRL_AXIMTR_CTRL_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_MTR_CTRL_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_MTR_CTRL_AXIMTR_CTRL_MASK 0xFFFFFFFF                // AXIMTR_CTRL[31..0]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_MTR_CTRL_AXIMTR_CTRL_SHFT 0

/* =====================================================================================

  ---WFDMA_AXI0_MTR_W_CH_STS_0 (0x18027000 + 0x108)---

    AXIMTR_W_CH_STS_0[31..0]     - (RO) AXI0 monitor W channel status [31:00]

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_MTR_W_CH_STS_0_AXIMTR_W_CH_STS_0_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_MTR_W_CH_STS_0_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_MTR_W_CH_STS_0_AXIMTR_W_CH_STS_0_MASK 0xFFFFFFFF                // AXIMTR_W_CH_STS_0[31..0]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_MTR_W_CH_STS_0_AXIMTR_W_CH_STS_0_SHFT 0

/* =====================================================================================

  ---WFDMA_AXI0_MTR_W_CH_STS_1 (0x18027000 + 0x10C)---

    AXIMTR_W_CH_STS_1[31..0]     - (RO) AXI0 monitor W channel status [63:32]

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_MTR_W_CH_STS_1_AXIMTR_W_CH_STS_1_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_MTR_W_CH_STS_1_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_MTR_W_CH_STS_1_AXIMTR_W_CH_STS_1_MASK 0xFFFFFFFF                // AXIMTR_W_CH_STS_1[31..0]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_MTR_W_CH_STS_1_AXIMTR_W_CH_STS_1_SHFT 0

/* =====================================================================================

  ---WFDMA_AXI0_MTR_W_CH_STS_2 (0x18027000 + 0x110)---

    AXIMTR_W_CH_STS_2[31..0]     - (RO) AXI0 monitor W channel status [95:64]

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_MTR_W_CH_STS_2_AXIMTR_W_CH_STS_2_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_MTR_W_CH_STS_2_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_MTR_W_CH_STS_2_AXIMTR_W_CH_STS_2_MASK 0xFFFFFFFF                // AXIMTR_W_CH_STS_2[31..0]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_MTR_W_CH_STS_2_AXIMTR_W_CH_STS_2_SHFT 0

/* =====================================================================================

  ---WFDMA_AXI0_MTR_W_CH_STS_3 (0x18027000 + 0x114)---

    AXIMTR_W_CH_STS_3[23..0]     - (RO) AXI0 monitor W channel status [119:96]
    RESERVED24[31..24]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_MTR_W_CH_STS_3_AXIMTR_W_CH_STS_3_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_MTR_W_CH_STS_3_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_MTR_W_CH_STS_3_AXIMTR_W_CH_STS_3_MASK 0x00FFFFFF                // AXIMTR_W_CH_STS_3[23..0]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_MTR_W_CH_STS_3_AXIMTR_W_CH_STS_3_SHFT 0

/* =====================================================================================

  ---WFDMA_AXI0_MTR_R_CH_STS_0 (0x18027000 + 0x118)---

    AXIMTR_R_CH_STS_0[31..0]     - (RO) AXI0 monitor R channel status [31:00]

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_MTR_R_CH_STS_0_AXIMTR_R_CH_STS_0_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_MTR_R_CH_STS_0_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_MTR_R_CH_STS_0_AXIMTR_R_CH_STS_0_MASK 0xFFFFFFFF                // AXIMTR_R_CH_STS_0[31..0]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_MTR_R_CH_STS_0_AXIMTR_R_CH_STS_0_SHFT 0

/* =====================================================================================

  ---WFDMA_AXI0_MTR_R_CH_STS_1 (0x18027000 + 0x11C)---

    AXIMTR_R_CH_STS_1[31..0]     - (RO) AXI0 monitor R channel status [63:32]

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_MTR_R_CH_STS_1_AXIMTR_R_CH_STS_1_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_MTR_R_CH_STS_1_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_MTR_R_CH_STS_1_AXIMTR_R_CH_STS_1_MASK 0xFFFFFFFF                // AXIMTR_R_CH_STS_1[31..0]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_MTR_R_CH_STS_1_AXIMTR_R_CH_STS_1_SHFT 0

/* =====================================================================================

  ---WFDMA_AXI0_MTR_R_CH_STS_2 (0x18027000 + 0x120)---

    AXIMTR_R_CH_STS_2[31..0]     - (RO) AXI0 monitor R channel status [95:64]

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_MTR_R_CH_STS_2_AXIMTR_R_CH_STS_2_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_MTR_R_CH_STS_2_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_MTR_R_CH_STS_2_AXIMTR_R_CH_STS_2_MASK 0xFFFFFFFF                // AXIMTR_R_CH_STS_2[31..0]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_MTR_R_CH_STS_2_AXIMTR_R_CH_STS_2_SHFT 0

/* =====================================================================================

  ---WFDMA_AXI0_MTR_R_CH_STS_3 (0x18027000 + 0x124)---

    AXIMTR_R_CH_STS_3[23..0]     - (RO) AXI0 monitor R channel status [119:96]
    RESERVED24[31..24]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_MTR_R_CH_STS_3_AXIMTR_R_CH_STS_3_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_MTR_R_CH_STS_3_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_MTR_R_CH_STS_3_AXIMTR_R_CH_STS_3_MASK 0x00FFFFFF                // AXIMTR_R_CH_STS_3[23..0]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_MTR_R_CH_STS_3_AXIMTR_R_CH_STS_3_SHFT 0

/* =====================================================================================

  ---WFDMA_AXI0_MTR_DBGOUT_0 (0x18027000 + 0x128)---

    AXIMTR_DBGOUT_0[31..0]       - (RO) AXI0 monitor debug out [31:00]

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_MTR_DBGOUT_0_AXIMTR_DBGOUT_0_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_MTR_DBGOUT_0_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_MTR_DBGOUT_0_AXIMTR_DBGOUT_0_MASK 0xFFFFFFFF                // AXIMTR_DBGOUT_0[31..0]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_MTR_DBGOUT_0_AXIMTR_DBGOUT_0_SHFT 0

/* =====================================================================================

  ---WFDMA_AXI0_MTR_DBGOUT_1 (0x18027000 + 0x12C)---

    AXIMTR_DBGOUT_1[31..0]       - (RO) AXI0 monitor debug out [63:32]

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_MTR_DBGOUT_1_AXIMTR_DBGOUT_1_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_MTR_DBGOUT_1_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_MTR_DBGOUT_1_AXIMTR_DBGOUT_1_MASK 0xFFFFFFFF                // AXIMTR_DBGOUT_1[31..0]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_MTR_DBGOUT_1_AXIMTR_DBGOUT_1_SHFT 0

/* =====================================================================================

  ---WFDMA_AXI0_MTR_DBGOUT_2 (0x18027000 + 0x130)---

    AXIMTR_DBGOUT_2[31..0]       - (RO) AXI0 monitor debug out [95:64]

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_MTR_DBGOUT_2_AXIMTR_DBGOUT_2_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_MTR_DBGOUT_2_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_MTR_DBGOUT_2_AXIMTR_DBGOUT_2_MASK 0xFFFFFFFF                // AXIMTR_DBGOUT_2[31..0]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_MTR_DBGOUT_2_AXIMTR_DBGOUT_2_SHFT 0

/* =====================================================================================

  ---WFDMA_AXI0_MTR_DBGOUT_3 (0x18027000 + 0x134)---

    AXIMTR_DBGOUT_3[31..0]       - (RO) AXI0 monitor debug out [127:96]

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_MTR_DBGOUT_3_AXIMTR_DBGOUT_3_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_MTR_DBGOUT_3_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_MTR_DBGOUT_3_AXIMTR_DBGOUT_3_MASK 0xFFFFFFFF                // AXIMTR_DBGOUT_3[31..0]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_MTR_DBGOUT_3_AXIMTR_DBGOUT_3_SHFT 0

/* =====================================================================================

  ---WFDMA_AXI0_MTR_DBGOUT_4 (0x18027000 + 0x138)---

    AXIMTR_DBGOUT_4[1..0]        - (RO) AXI0 monitor debug out [129:128]
    RESERVED2[31..2]             - (RO) Reserved bits

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_MTR_DBGOUT_4_AXIMTR_DBGOUT_4_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_MTR_DBGOUT_4_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_MTR_DBGOUT_4_AXIMTR_DBGOUT_4_MASK 0x00000003                // AXIMTR_DBGOUT_4[1..0]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_MTR_DBGOUT_4_AXIMTR_DBGOUT_4_SHFT 0

/* =====================================================================================

  ---WFDMA_AXI1_MTR_W_CH_STS_0 (0x18027000 + 0x13C)---

    AXIMTR_W_CH_STS_0[31..0]     - (RO) AXI1 monitor W channel status [31:00]

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_MTR_W_CH_STS_0_AXIMTR_W_CH_STS_0_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_MTR_W_CH_STS_0_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_MTR_W_CH_STS_0_AXIMTR_W_CH_STS_0_MASK 0xFFFFFFFF                // AXIMTR_W_CH_STS_0[31..0]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_MTR_W_CH_STS_0_AXIMTR_W_CH_STS_0_SHFT 0

/* =====================================================================================

  ---WFDMA_AXI1_MTR_W_CH_STS_1 (0x18027000 + 0x140)---

    AXIMTR_W_CH_STS_1[31..0]     - (RO) AXI1 monitor W channel status [63:32]

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_MTR_W_CH_STS_1_AXIMTR_W_CH_STS_1_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_MTR_W_CH_STS_1_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_MTR_W_CH_STS_1_AXIMTR_W_CH_STS_1_MASK 0xFFFFFFFF                // AXIMTR_W_CH_STS_1[31..0]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_MTR_W_CH_STS_1_AXIMTR_W_CH_STS_1_SHFT 0

/* =====================================================================================

  ---WFDMA_AXI1_MTR_W_CH_STS_2 (0x18027000 + 0x144)---

    AXIMTR_W_CH_STS_2[31..0]     - (RO) AXI1 monitor W channel status [95:64]

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_MTR_W_CH_STS_2_AXIMTR_W_CH_STS_2_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_MTR_W_CH_STS_2_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_MTR_W_CH_STS_2_AXIMTR_W_CH_STS_2_MASK 0xFFFFFFFF                // AXIMTR_W_CH_STS_2[31..0]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_MTR_W_CH_STS_2_AXIMTR_W_CH_STS_2_SHFT 0

/* =====================================================================================

  ---WFDMA_AXI1_MTR_W_CH_STS_3 (0x18027000 + 0x148)---

    AXIMTR_W_CH_STS_3[23..0]     - (RO) AXI1 monitor W channel status [119:96]
    RESERVED24[31..24]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_MTR_W_CH_STS_3_AXIMTR_W_CH_STS_3_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_MTR_W_CH_STS_3_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_MTR_W_CH_STS_3_AXIMTR_W_CH_STS_3_MASK 0x00FFFFFF                // AXIMTR_W_CH_STS_3[23..0]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_MTR_W_CH_STS_3_AXIMTR_W_CH_STS_3_SHFT 0

/* =====================================================================================

  ---WFDMA_AXI1_MTR_R_CH_STS_0 (0x18027000 + 0x14C)---

    AXIMTR_R_CH_STS_0[31..0]     - (RO) AXI1 monitor R channel status [31:00]

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_MTR_R_CH_STS_0_AXIMTR_R_CH_STS_0_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_MTR_R_CH_STS_0_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_MTR_R_CH_STS_0_AXIMTR_R_CH_STS_0_MASK 0xFFFFFFFF                // AXIMTR_R_CH_STS_0[31..0]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_MTR_R_CH_STS_0_AXIMTR_R_CH_STS_0_SHFT 0

/* =====================================================================================

  ---WFDMA_AXI1_MTR_R_CH_STS_1 (0x18027000 + 0x150)---

    AXIMTR_R_CH_STS_1[31..0]     - (RO) AXI1 monitor R channel status [63:32]

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_MTR_R_CH_STS_1_AXIMTR_R_CH_STS_1_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_MTR_R_CH_STS_1_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_MTR_R_CH_STS_1_AXIMTR_R_CH_STS_1_MASK 0xFFFFFFFF                // AXIMTR_R_CH_STS_1[31..0]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_MTR_R_CH_STS_1_AXIMTR_R_CH_STS_1_SHFT 0

/* =====================================================================================

  ---WFDMA_AXI1_MTR_R_CH_STS_2 (0x18027000 + 0x154)---

    AXIMTR_R_CH_STS_2[31..0]     - (RO) AXI1 monitor R channel status [95:64]

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_MTR_R_CH_STS_2_AXIMTR_R_CH_STS_2_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_MTR_R_CH_STS_2_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_MTR_R_CH_STS_2_AXIMTR_R_CH_STS_2_MASK 0xFFFFFFFF                // AXIMTR_R_CH_STS_2[31..0]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_MTR_R_CH_STS_2_AXIMTR_R_CH_STS_2_SHFT 0

/* =====================================================================================

  ---WFDMA_AXI1_MTR_R_CH_STS_3 (0x18027000 + 0x158)---

    AXIMTR_R_CH_STS_3[23..0]     - (RO) AXI1 monitor R channel status [119:96]
    RESERVED24[31..24]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_MTR_R_CH_STS_3_AXIMTR_R_CH_STS_3_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_MTR_R_CH_STS_3_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_MTR_R_CH_STS_3_AXIMTR_R_CH_STS_3_MASK 0x00FFFFFF                // AXIMTR_R_CH_STS_3[23..0]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_MTR_R_CH_STS_3_AXIMTR_R_CH_STS_3_SHFT 0

/* =====================================================================================

  ---WFDMA_AXI1_MTR_DBGOUT_0 (0x18027000 + 0x15C)---

    AXIMTR_DBGOUT_0[31..0]       - (RO) AXI1 monitor debug out [31:00]

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_MTR_DBGOUT_0_AXIMTR_DBGOUT_0_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_MTR_DBGOUT_0_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_MTR_DBGOUT_0_AXIMTR_DBGOUT_0_MASK 0xFFFFFFFF                // AXIMTR_DBGOUT_0[31..0]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_MTR_DBGOUT_0_AXIMTR_DBGOUT_0_SHFT 0

/* =====================================================================================

  ---WFDMA_AXI1_MTR_DBGOUT_1 (0x18027000 + 0x160)---

    AXIMTR_DBGOUT_1[31..0]       - (RO) AXI1 monitor debug out [63:32]

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_MTR_DBGOUT_1_AXIMTR_DBGOUT_1_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_MTR_DBGOUT_1_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_MTR_DBGOUT_1_AXIMTR_DBGOUT_1_MASK 0xFFFFFFFF                // AXIMTR_DBGOUT_1[31..0]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_MTR_DBGOUT_1_AXIMTR_DBGOUT_1_SHFT 0

/* =====================================================================================

  ---WFDMA_AXI1_MTR_DBGOUT_2 (0x18027000 + 0x164)---

    AXIMTR_DBGOUT_2[31..0]       - (RO) AXI1 monitor debug out [95:64]

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_MTR_DBGOUT_2_AXIMTR_DBGOUT_2_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_MTR_DBGOUT_2_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_MTR_DBGOUT_2_AXIMTR_DBGOUT_2_MASK 0xFFFFFFFF                // AXIMTR_DBGOUT_2[31..0]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_MTR_DBGOUT_2_AXIMTR_DBGOUT_2_SHFT 0

/* =====================================================================================

  ---WFDMA_AXI1_MTR_DBGOUT_3 (0x18027000 + 0x168)---

    AXIMTR_DBGOUT_3[31..0]       - (RO) AXI1 monitor debug out [127:96]

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_MTR_DBGOUT_3_AXIMTR_DBGOUT_3_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_MTR_DBGOUT_3_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_MTR_DBGOUT_3_AXIMTR_DBGOUT_3_MASK 0xFFFFFFFF                // AXIMTR_DBGOUT_3[31..0]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_MTR_DBGOUT_3_AXIMTR_DBGOUT_3_SHFT 0

/* =====================================================================================

  ---WFDMA_AXI1_MTR_DBGOUT_4 (0x18027000 + 0x16C)---

    AXIMTR_DBGOUT_4[1..0]        - (RO) AXI1 monitor debug out [129:128]
    RESERVED2[31..2]             - (RO) Reserved bits

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_MTR_DBGOUT_4_AXIMTR_DBGOUT_4_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_MTR_DBGOUT_4_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_MTR_DBGOUT_4_AXIMTR_DBGOUT_4_MASK 0x00000003                // AXIMTR_DBGOUT_4[1..0]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_MTR_DBGOUT_4_AXIMTR_DBGOUT_4_SHFT 0

/* =====================================================================================

  ---WED_HOST_INT_STA (0x18027000 + 0x200)---

    host_dma1_rx_done_int_sts_0[0] - (W1C) RX Queue#0 packet receive interrupt
                                     Write 1 to clear the interrupt
                                     Read to get the raw interrupt status
    host_dma1_rx_done_int_sts_1[1] - (W1C) RX Queue#1 packet receive interrupt
                                     Write 1 to clear the interrupt
                                     Read to get the raw interrupt status
    host_dma1_rx_done_int_sts_2[2] - (W1C) RX Queue#2 packet receive interrupt
                                     Write 1 to clear the interrupt
                                     Read to get the raw interrupt status
    host_dma1_rx_done_int_sts_3[3] - (W1C) RX Queue#3 packet receive interrupt
                                     Write 1 to clear the interrupt
                                     Read to get the raw interrupt status
    host_dma1_tx_done_int_sts_0[4] - (W1C) TX Queue#0 packet transmit interrupt
                                     Write 1 to clear the interrupt
    host_dma1_tx_done_int_sts_1[5] - (W1C) TX Queue#1 packet transmit interrupt
                                     Write 1 to clear the interrupt
    host_dma1_tx_done_int_sts_2[6] - (W1C) TX Queue#2 packet transmit interrupt
                                     Write 1 to clear the interrupt
    host_dma1_tx_done_int_sts_3[7] - (W1C) TX Queue#3 packet transmit interrupt
                                     Write 1 to clear the interrupt
    host_dma1_tx_done_int_sts_4[8] - (W1C) TX Queue#4 packet transmit interrupt
                                     Write 1 to clear the interrupt
    host_dma1_tx_done_int_sts_5[9] - (W1C) TX Queue#5 packet transmit interrupt
                                     Write 1 to clear the interrupt
    host_dma1_tx_done_int_sts_6[10] - (W1C) TX Queue#6 packet transmit interrupt
                                     Write 1 to clear the interrupt
    host_dma1_tx_done_int_sts_7[11] - (W1C) TX Queue#7 packet transmit interrupt
                                     Write 1 to clear the interrupt
    RESERVED12[14..12]           - (RO) Reserved bits
    host_dma1_tx_done_int_sts_20[15] - (W1C) TX Queue#20 packet transmit interrupt
                                     Write 1 to clear the interrupt
    host_dma0_rx_done_int_sts_0[16] - (W1C) RX Queue#0 packet receive interrupt
                                     Write 1 to clear the interrupt
                                     Read to get the raw interrupt status
    host_dma0_rx_done_int_sts_1[17] - (W1C) RX Queue#1 packet receive interrupt
                                     Write 1 to clear the interrupt
                                     Read to get the raw interrupt status
    host_dma0_rx_done_int_sts_2[18] - (W1C) RX Queue#2 packet receive interrupt
                                     Write 1 to clear the interrupt
                                     Read to get the raw interrupt status
    host_dma0_rx_done_int_sts_3[19] - (W1C) RX Queue#3 packet receive interrupt
                                     Write 1 to clear the interrupt
                                     Read to get the raw interrupt status
    host_dma1_rx_coherent_int_sts[20] - (W1C) RX_DMA finds data coherent event when checking ddone bit
                                     Write 1 to clear the interrupt
                                     Read to get the raw interrupt status
    host_dma1_tx_coherent_int_sts[21] - (W1C) TX_DMA finds data coherent event when checking ddone bit
                                     Write 1 to clear the interrupt
                                     Read to get the raw interrupt status
    host_dma0_rx_coherent_int_sts[22] - (W1C) RX_DMA finds data coherent event when checking ddone bit
                                     Write 1 to clear the interrupt
                                     Read to get the raw interrupt status
    host_dma0_tx_coherent_int_sts[23] - (W1C) TX_DMA finds data coherent event when checking ddone bit
                                     Write 1 to clear the interrupt
                                     Read to get the raw interrupt status
    host_dma1_wpdma2host_err_int_sts[24] - (W1C) wpdma interrupt overall status
                                     User should should check WPDMA_ERR_INT_STA for each wpdma error interrupt status 
                                     Host could read [0x0_41E8] to check indivisual wpdma2host_error interrupt status
    host_dma0_wpdma2host_err_int_sts[25] - (W1C) wpdma interrupt overall status
                                     User should should check WPDMA_ERR_INT_STA for each wpdma error interrupt status 
                                     Host could read [0x0_41E8] to check indivisual wpdma2host_error interrupt status
    host_dma1_tx_done_int_sts_16[26] - (W1C) TX Queue#16 packet transmit interrupt
                                     Write 1 to clear the interrupt
    host_dma1_tx_done_int_sts_17[27] - (W1C) TX Queue#17 packet transmit interrupt
                                     Write 1 to clear the interrupt
    host_dma1_subsys_int_sts[28] - (W1C) subsys interrupt overall status
                                     User should should check SUBSYS2HOST_INT_STA for each interrupt status 
                                     Host could read [0x0_41F8] to check indivisual subsys hw interrupt status
    host_dma1_mcu2host_sw_int_sts[29] - (W1C) subsys interrupt overall status
                                     User should should check SUBSYS2HOST_INT_STA for each interrupt status 
                                     Host could read [0x0_41F8] to check indivisual subsys hw interrupt status
    host_dma1_tx_done_int_sts_18[30] - (W1C) TX Queue#18 packet transmit interrupt
                                     Write 1 to clear the interrupt
    host_dma1_tx_done_int_sts_19[31] - (W1C) TX Queue#19 packet transmit interrupt
                                     Write 1 to clear the interrupt

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma1_tx_done_int_sts_19_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma1_tx_done_int_sts_19_MASK 0x80000000                // host_dma1_tx_done_int_sts_19[31]
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma1_tx_done_int_sts_19_SHFT 31
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma1_tx_done_int_sts_18_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma1_tx_done_int_sts_18_MASK 0x40000000                // host_dma1_tx_done_int_sts_18[30]
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma1_tx_done_int_sts_18_SHFT 30
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma1_mcu2host_sw_int_sts_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma1_mcu2host_sw_int_sts_MASK 0x20000000                // host_dma1_mcu2host_sw_int_sts[29]
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma1_mcu2host_sw_int_sts_SHFT 29
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma1_subsys_int_sts_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma1_subsys_int_sts_MASK 0x10000000                // host_dma1_subsys_int_sts[28]
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma1_subsys_int_sts_SHFT 28
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma1_tx_done_int_sts_17_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma1_tx_done_int_sts_17_MASK 0x08000000                // host_dma1_tx_done_int_sts_17[27]
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma1_tx_done_int_sts_17_SHFT 27
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma1_tx_done_int_sts_16_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma1_tx_done_int_sts_16_MASK 0x04000000                // host_dma1_tx_done_int_sts_16[26]
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma1_tx_done_int_sts_16_SHFT 26
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma0_wpdma2host_err_int_sts_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma0_wpdma2host_err_int_sts_MASK 0x02000000                // host_dma0_wpdma2host_err_int_sts[25]
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma0_wpdma2host_err_int_sts_SHFT 25
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma1_wpdma2host_err_int_sts_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma1_wpdma2host_err_int_sts_MASK 0x01000000                // host_dma1_wpdma2host_err_int_sts[24]
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma1_wpdma2host_err_int_sts_SHFT 24
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma0_tx_coherent_int_sts_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma0_tx_coherent_int_sts_MASK 0x00800000                // host_dma0_tx_coherent_int_sts[23]
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma0_tx_coherent_int_sts_SHFT 23
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma0_rx_coherent_int_sts_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma0_rx_coherent_int_sts_MASK 0x00400000                // host_dma0_rx_coherent_int_sts[22]
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma0_rx_coherent_int_sts_SHFT 22
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma1_tx_coherent_int_sts_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma1_tx_coherent_int_sts_MASK 0x00200000                // host_dma1_tx_coherent_int_sts[21]
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma1_tx_coherent_int_sts_SHFT 21
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma1_rx_coherent_int_sts_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma1_rx_coherent_int_sts_MASK 0x00100000                // host_dma1_rx_coherent_int_sts[20]
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma1_rx_coherent_int_sts_SHFT 20
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma0_rx_done_int_sts_3_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma0_rx_done_int_sts_3_MASK 0x00080000                // host_dma0_rx_done_int_sts_3[19]
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma0_rx_done_int_sts_3_SHFT 19
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma0_rx_done_int_sts_2_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma0_rx_done_int_sts_2_MASK 0x00040000                // host_dma0_rx_done_int_sts_2[18]
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma0_rx_done_int_sts_2_SHFT 18
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma0_rx_done_int_sts_1_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma0_rx_done_int_sts_1_MASK 0x00020000                // host_dma0_rx_done_int_sts_1[17]
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma0_rx_done_int_sts_1_SHFT 17
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma0_rx_done_int_sts_0_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma0_rx_done_int_sts_0_MASK 0x00010000                // host_dma0_rx_done_int_sts_0[16]
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma0_rx_done_int_sts_0_SHFT 16
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma1_tx_done_int_sts_20_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma1_tx_done_int_sts_20_MASK 0x00008000                // host_dma1_tx_done_int_sts_20[15]
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma1_tx_done_int_sts_20_SHFT 15
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma1_tx_done_int_sts_7_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma1_tx_done_int_sts_7_MASK 0x00000800                // host_dma1_tx_done_int_sts_7[11]
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma1_tx_done_int_sts_7_SHFT 11
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma1_tx_done_int_sts_6_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma1_tx_done_int_sts_6_MASK 0x00000400                // host_dma1_tx_done_int_sts_6[10]
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma1_tx_done_int_sts_6_SHFT 10
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma1_tx_done_int_sts_5_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma1_tx_done_int_sts_5_MASK 0x00000200                // host_dma1_tx_done_int_sts_5[9]
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma1_tx_done_int_sts_5_SHFT 9
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma1_tx_done_int_sts_4_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma1_tx_done_int_sts_4_MASK 0x00000100                // host_dma1_tx_done_int_sts_4[8]
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma1_tx_done_int_sts_4_SHFT 8
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma1_tx_done_int_sts_3_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma1_tx_done_int_sts_3_MASK 0x00000080                // host_dma1_tx_done_int_sts_3[7]
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma1_tx_done_int_sts_3_SHFT 7
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma1_tx_done_int_sts_2_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma1_tx_done_int_sts_2_MASK 0x00000040                // host_dma1_tx_done_int_sts_2[6]
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma1_tx_done_int_sts_2_SHFT 6
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma1_tx_done_int_sts_1_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma1_tx_done_int_sts_1_MASK 0x00000020                // host_dma1_tx_done_int_sts_1[5]
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma1_tx_done_int_sts_1_SHFT 5
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma1_tx_done_int_sts_0_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma1_tx_done_int_sts_0_MASK 0x00000010                // host_dma1_tx_done_int_sts_0[4]
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma1_tx_done_int_sts_0_SHFT 4
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma1_rx_done_int_sts_3_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma1_rx_done_int_sts_3_MASK 0x00000008                // host_dma1_rx_done_int_sts_3[3]
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma1_rx_done_int_sts_3_SHFT 3
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma1_rx_done_int_sts_2_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma1_rx_done_int_sts_2_MASK 0x00000004                // host_dma1_rx_done_int_sts_2[2]
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma1_rx_done_int_sts_2_SHFT 2
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma1_rx_done_int_sts_1_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma1_rx_done_int_sts_1_MASK 0x00000002                // host_dma1_rx_done_int_sts_1[1]
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma1_rx_done_int_sts_1_SHFT 1
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma1_rx_done_int_sts_0_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma1_rx_done_int_sts_0_MASK 0x00000001                // host_dma1_rx_done_int_sts_0[0]
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma1_rx_done_int_sts_0_SHFT 0

/* =====================================================================================

  ---WED_HOST_INT_ENA (0x18027000 + 0x204)---

    HOST_DMA1_HOST_RX_DONE_INT_ENA0[0] - (RW) RX Queue#0 packet receive interrupt
    HOST_DMA1_HOST_RX_DONE_INT_ENA1[1] - (RW) RX Queue#1 packet receive interrupt
    host_dma1_rx_done_int_ena_2[2] - (RW) RX Queue#2 packet receive interrupt
    host_dma1_rx_done_int_ena_3[3] - (RW) RX Queue#3 packet receive interrupt
    HOST_DMA1_HOST_TX_DONE_INT_ENA0[4] - (RW) TX Queue#0 packet transmit interrupt
    HOST_DMA1_HOST_TX_DONE_INT_ENA1[5] - (RW) TX Queue#1 packet transmit interrupt
    HOST_DMA1_HOST_TX_DONE_INT_ENA2[6] - (RW) TX Queue#2 packet transmit interrupt
    HOST_DMA1_HOST_TX_DONE_INT_ENA3[7] - (RW) TX Queue#3 packet transmit interrupt
    host_dma1_tx_done_int_ena_4[8] - (RW) TX Queue#4 packet transmit interrupt
    host_dma1_tx_done_int_ena_5[9] - (RW) TX Queue#5 packet transmit interrupt
    host_dma1_tx_done_int_ena_6[10] - (RW) TX Queue#6 packet transmit interrupt
    host_dma1_tx_done_int_ena_7[11] - (RW) TX Queue#7 packet transmit interrupt
    RESERVED12[14..12]           - (RO) Reserved bits
    host_dma1_tx_done_int_ena_20[15] - (RW) TX Queue#20 packet transmit interrupt
    host_dma0_rx_done_int_ena_0[16] - (RW) RX Queue#0 packet receive interrupt
    host_dma0_rx_done_int_ena_1[17] - (RW) RX Queue#1 packet receive interrupt
    host_dma0_rx_done_int_ena_2[18] - (RW) RX Queue#2 packet receive interrupt
    host_dma0_rx_done_int_ena_3[19] - (RW) RX Queue#3 packet receive interrupt
    HOST_DMA1_HOST_RX_COHERENT_EN[20] - (RW) Enable for RX_DMA data coherent interrupt
    HOST_DMA1_HOST_TX_COHERENT_EN[21] - (RW) Enable for TX_DMA data coherent interrupt
    HOST_DMA0_HOST_RX_COHERENT_EN[22] - (RW) Enable for RX_DMA data coherent interrupt
    HOST_DMA0_HOST_TX_COHERENT_EN[23] - (RW) Enable for TX_DMA data coherent interrupt
    host_dma1_wpdma2host_err_int_ena[24] - (RW) Enable bit of wpdma2host_err_int
    host_dma0_wpdma2host_err_int_ena[25] - (RW) Enable bit of wpdma2host_err_int
    HOST_DMA1_HOST_TX_DONE_INT_ENA16[26] - (RW) TX Queue#16 packet transmit interrupt
    HOST_DMA1_HOST_TX_DONE_INT_ENA17[27] - (RW) TX Queue#17 packet transmit interrupt
    host_dma1_subsys_int_ena[28] - (RW) Enable bit of subsys_int
    host_dma1_mcu2host_sw_int_ena[29] - (RW) Enable bit of mcu2host_sw_int
    HOST_DMA1_HOST_TX_DONE_INT_ENA18[30] - (RW) TX Queue#18 packet transmit interrupt
    HOST_DMA1_HOST_TX_DONE_INT_ENA19[31] - (RW) TX Queue#19 packet transmit interrupt

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_HOST_DMA1_HOST_TX_DONE_INT_ENA19_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_HOST_DMA1_HOST_TX_DONE_INT_ENA19_MASK 0x80000000                // HOST_DMA1_HOST_TX_DONE_INT_ENA19[31]
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_HOST_DMA1_HOST_TX_DONE_INT_ENA19_SHFT 31
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_HOST_DMA1_HOST_TX_DONE_INT_ENA18_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_HOST_DMA1_HOST_TX_DONE_INT_ENA18_MASK 0x40000000                // HOST_DMA1_HOST_TX_DONE_INT_ENA18[30]
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_HOST_DMA1_HOST_TX_DONE_INT_ENA18_SHFT 30
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_host_dma1_mcu2host_sw_int_ena_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_host_dma1_mcu2host_sw_int_ena_MASK 0x20000000                // host_dma1_mcu2host_sw_int_ena[29]
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_host_dma1_mcu2host_sw_int_ena_SHFT 29
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_host_dma1_subsys_int_ena_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_host_dma1_subsys_int_ena_MASK 0x10000000                // host_dma1_subsys_int_ena[28]
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_host_dma1_subsys_int_ena_SHFT 28
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_HOST_DMA1_HOST_TX_DONE_INT_ENA17_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_HOST_DMA1_HOST_TX_DONE_INT_ENA17_MASK 0x08000000                // HOST_DMA1_HOST_TX_DONE_INT_ENA17[27]
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_HOST_DMA1_HOST_TX_DONE_INT_ENA17_SHFT 27
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_HOST_DMA1_HOST_TX_DONE_INT_ENA16_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_HOST_DMA1_HOST_TX_DONE_INT_ENA16_MASK 0x04000000                // HOST_DMA1_HOST_TX_DONE_INT_ENA16[26]
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_HOST_DMA1_HOST_TX_DONE_INT_ENA16_SHFT 26
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_host_dma0_wpdma2host_err_int_ena_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_host_dma0_wpdma2host_err_int_ena_MASK 0x02000000                // host_dma0_wpdma2host_err_int_ena[25]
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_host_dma0_wpdma2host_err_int_ena_SHFT 25
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_host_dma1_wpdma2host_err_int_ena_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_host_dma1_wpdma2host_err_int_ena_MASK 0x01000000                // host_dma1_wpdma2host_err_int_ena[24]
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_host_dma1_wpdma2host_err_int_ena_SHFT 24
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_HOST_DMA0_HOST_TX_COHERENT_EN_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_HOST_DMA0_HOST_TX_COHERENT_EN_MASK 0x00800000                // HOST_DMA0_HOST_TX_COHERENT_EN[23]
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_HOST_DMA0_HOST_TX_COHERENT_EN_SHFT 23
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_HOST_DMA0_HOST_RX_COHERENT_EN_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_HOST_DMA0_HOST_RX_COHERENT_EN_MASK 0x00400000                // HOST_DMA0_HOST_RX_COHERENT_EN[22]
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_HOST_DMA0_HOST_RX_COHERENT_EN_SHFT 22
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_HOST_DMA1_HOST_TX_COHERENT_EN_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_HOST_DMA1_HOST_TX_COHERENT_EN_MASK 0x00200000                // HOST_DMA1_HOST_TX_COHERENT_EN[21]
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_HOST_DMA1_HOST_TX_COHERENT_EN_SHFT 21
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_HOST_DMA1_HOST_RX_COHERENT_EN_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_HOST_DMA1_HOST_RX_COHERENT_EN_MASK 0x00100000                // HOST_DMA1_HOST_RX_COHERENT_EN[20]
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_HOST_DMA1_HOST_RX_COHERENT_EN_SHFT 20
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_host_dma0_rx_done_int_ena_3_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_host_dma0_rx_done_int_ena_3_MASK 0x00080000                // host_dma0_rx_done_int_ena_3[19]
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_host_dma0_rx_done_int_ena_3_SHFT 19
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_host_dma0_rx_done_int_ena_2_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_host_dma0_rx_done_int_ena_2_MASK 0x00040000                // host_dma0_rx_done_int_ena_2[18]
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_host_dma0_rx_done_int_ena_2_SHFT 18
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_host_dma0_rx_done_int_ena_1_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_host_dma0_rx_done_int_ena_1_MASK 0x00020000                // host_dma0_rx_done_int_ena_1[17]
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_host_dma0_rx_done_int_ena_1_SHFT 17
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_host_dma0_rx_done_int_ena_0_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_host_dma0_rx_done_int_ena_0_MASK 0x00010000                // host_dma0_rx_done_int_ena_0[16]
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_host_dma0_rx_done_int_ena_0_SHFT 16
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_host_dma1_tx_done_int_ena_20_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_host_dma1_tx_done_int_ena_20_MASK 0x00008000                // host_dma1_tx_done_int_ena_20[15]
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_host_dma1_tx_done_int_ena_20_SHFT 15
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_host_dma1_tx_done_int_ena_7_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_host_dma1_tx_done_int_ena_7_MASK 0x00000800                // host_dma1_tx_done_int_ena_7[11]
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_host_dma1_tx_done_int_ena_7_SHFT 11
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_host_dma1_tx_done_int_ena_6_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_host_dma1_tx_done_int_ena_6_MASK 0x00000400                // host_dma1_tx_done_int_ena_6[10]
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_host_dma1_tx_done_int_ena_6_SHFT 10
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_host_dma1_tx_done_int_ena_5_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_host_dma1_tx_done_int_ena_5_MASK 0x00000200                // host_dma1_tx_done_int_ena_5[9]
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_host_dma1_tx_done_int_ena_5_SHFT 9
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_host_dma1_tx_done_int_ena_4_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_host_dma1_tx_done_int_ena_4_MASK 0x00000100                // host_dma1_tx_done_int_ena_4[8]
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_host_dma1_tx_done_int_ena_4_SHFT 8
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_HOST_DMA1_HOST_TX_DONE_INT_ENA3_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_HOST_DMA1_HOST_TX_DONE_INT_ENA3_MASK 0x00000080                // HOST_DMA1_HOST_TX_DONE_INT_ENA3[7]
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_HOST_DMA1_HOST_TX_DONE_INT_ENA3_SHFT 7
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_HOST_DMA1_HOST_TX_DONE_INT_ENA2_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_HOST_DMA1_HOST_TX_DONE_INT_ENA2_MASK 0x00000040                // HOST_DMA1_HOST_TX_DONE_INT_ENA2[6]
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_HOST_DMA1_HOST_TX_DONE_INT_ENA2_SHFT 6
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_HOST_DMA1_HOST_TX_DONE_INT_ENA1_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_HOST_DMA1_HOST_TX_DONE_INT_ENA1_MASK 0x00000020                // HOST_DMA1_HOST_TX_DONE_INT_ENA1[5]
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_HOST_DMA1_HOST_TX_DONE_INT_ENA1_SHFT 5
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_HOST_DMA1_HOST_TX_DONE_INT_ENA0_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_HOST_DMA1_HOST_TX_DONE_INT_ENA0_MASK 0x00000010                // HOST_DMA1_HOST_TX_DONE_INT_ENA0[4]
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_HOST_DMA1_HOST_TX_DONE_INT_ENA0_SHFT 4
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_host_dma1_rx_done_int_ena_3_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_host_dma1_rx_done_int_ena_3_MASK 0x00000008                // host_dma1_rx_done_int_ena_3[3]
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_host_dma1_rx_done_int_ena_3_SHFT 3
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_host_dma1_rx_done_int_ena_2_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_host_dma1_rx_done_int_ena_2_MASK 0x00000004                // host_dma1_rx_done_int_ena_2[2]
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_host_dma1_rx_done_int_ena_2_SHFT 2
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_HOST_DMA1_HOST_RX_DONE_INT_ENA1_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_HOST_DMA1_HOST_RX_DONE_INT_ENA1_MASK 0x00000002                // HOST_DMA1_HOST_RX_DONE_INT_ENA1[1]
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_HOST_DMA1_HOST_RX_DONE_INT_ENA1_SHFT 1
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_HOST_DMA1_HOST_RX_DONE_INT_ENA0_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_HOST_DMA1_HOST_RX_DONE_INT_ENA0_MASK 0x00000001                // HOST_DMA1_HOST_RX_DONE_INT_ENA0[0]
#define WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_HOST_DMA1_HOST_RX_DONE_INT_ENA0_SHFT 0

/* =====================================================================================

  ---WED_TX0_CTRL0 (0x18027000 + 0x300)---

    WED_TX_RING0_CTRL0[31..0]    - (RW) WED TX ring 0 control 0

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WED_TX0_CTRL0_WED_TX_RING0_CTRL0_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_TX0_CTRL0_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_TX0_CTRL0_WED_TX_RING0_CTRL0_MASK 0xFFFFFFFF                // WED_TX_RING0_CTRL0[31..0]
#define WF_WFDMA_EXT_WRAP_CSR_WED_TX0_CTRL0_WED_TX_RING0_CTRL0_SHFT 0

/* =====================================================================================

  ---WED_TX0_CTRL1 (0x18027000 + 0x304)---

    WED_TX_RING0_CTRL1[31..0]    - (RW) WED TX ring 0 control 1

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WED_TX0_CTRL1_WED_TX_RING0_CTRL1_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_TX0_CTRL1_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_TX0_CTRL1_WED_TX_RING0_CTRL1_MASK 0xFFFFFFFF                // WED_TX_RING0_CTRL1[31..0]
#define WF_WFDMA_EXT_WRAP_CSR_WED_TX0_CTRL1_WED_TX_RING0_CTRL1_SHFT 0

/* =====================================================================================

  ---WED_TX0_CTRL2 (0x18027000 + 0x308)---

    WED_TX_RING0_CTRL2[31..0]    - (RW) WED TX ring 0 control 2

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WED_TX0_CTRL2_WED_TX_RING0_CTRL2_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_TX0_CTRL2_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_TX0_CTRL2_WED_TX_RING0_CTRL2_MASK 0xFFFFFFFF                // WED_TX_RING0_CTRL2[31..0]
#define WF_WFDMA_EXT_WRAP_CSR_WED_TX0_CTRL2_WED_TX_RING0_CTRL2_SHFT 0

/* =====================================================================================

  ---WED_TX0_STS (0x18027000 + 0x30C)---

    WED_TX_RING0_DIDX[11..0]     - (RO) WED TX ring 0 DMA index
    RESERVED12[31..12]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WED_TX0_STS_WED_TX_RING0_DIDX_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_TX0_STS_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_TX0_STS_WED_TX_RING0_DIDX_MASK 0x00000FFF                // WED_TX_RING0_DIDX[11..0]
#define WF_WFDMA_EXT_WRAP_CSR_WED_TX0_STS_WED_TX_RING0_DIDX_SHFT 0

/* =====================================================================================

  ---WED_TX1_CTRL0 (0x18027000 + 0x310)---

    WED_TX_RING1_CTRL0[31..0]    - (RW) WED TX ring 1 control 0

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WED_TX1_CTRL0_WED_TX_RING1_CTRL0_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_TX1_CTRL0_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_TX1_CTRL0_WED_TX_RING1_CTRL0_MASK 0xFFFFFFFF                // WED_TX_RING1_CTRL0[31..0]
#define WF_WFDMA_EXT_WRAP_CSR_WED_TX1_CTRL0_WED_TX_RING1_CTRL0_SHFT 0

/* =====================================================================================

  ---WED_TX1_CTRL1 (0x18027000 + 0x314)---

    WED_TX_RING1_CTRL1[31..0]    - (RW) WED TX ring 1 control 1

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WED_TX1_CTRL1_WED_TX_RING1_CTRL1_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_TX1_CTRL1_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_TX1_CTRL1_WED_TX_RING1_CTRL1_MASK 0xFFFFFFFF                // WED_TX_RING1_CTRL1[31..0]
#define WF_WFDMA_EXT_WRAP_CSR_WED_TX1_CTRL1_WED_TX_RING1_CTRL1_SHFT 0

/* =====================================================================================

  ---WED_TX1_CTRL2 (0x18027000 + 0x318)---

    WED_TX_RING1_CTRL2[31..0]    - (RW) WED TX ring 1 control 2

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WED_TX1_CTRL2_WED_TX_RING1_CTRL2_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_TX1_CTRL2_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_TX1_CTRL2_WED_TX_RING1_CTRL2_MASK 0xFFFFFFFF                // WED_TX_RING1_CTRL2[31..0]
#define WF_WFDMA_EXT_WRAP_CSR_WED_TX1_CTRL2_WED_TX_RING1_CTRL2_SHFT 0

/* =====================================================================================

  ---WED_TX1_STS (0x18027000 + 0x31C)---

    WED_TX_RING1_DIDX[11..0]     - (RO) WED TX ring 1 DMA index
    RESERVED12[31..12]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WED_TX1_STS_WED_TX_RING1_DIDX_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_TX1_STS_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_TX1_STS_WED_TX_RING1_DIDX_MASK 0x00000FFF                // WED_TX_RING1_DIDX[11..0]
#define WF_WFDMA_EXT_WRAP_CSR_WED_TX1_STS_WED_TX_RING1_DIDX_SHFT 0

/* =====================================================================================

  ---WED_RX1_CTRL0 (0x18027000 + 0x410)---

    WED_RX_RING1_CTRL0[31..0]    - (RW) WED RX ring 1 control 0

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WED_RX1_CTRL0_WED_RX_RING1_CTRL0_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_RX1_CTRL0_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_RX1_CTRL0_WED_RX_RING1_CTRL0_MASK 0xFFFFFFFF                // WED_RX_RING1_CTRL0[31..0]
#define WF_WFDMA_EXT_WRAP_CSR_WED_RX1_CTRL0_WED_RX_RING1_CTRL0_SHFT 0

/* =====================================================================================

  ---WED_RX1_CTRL1 (0x18027000 + 0x414)---

    WED_RX_RING1_CTRL1[31..0]    - (RW) WED RX ring 1 control 1

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WED_RX1_CTRL1_WED_RX_RING1_CTRL1_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_RX1_CTRL1_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_RX1_CTRL1_WED_RX_RING1_CTRL1_MASK 0xFFFFFFFF                // WED_RX_RING1_CTRL1[31..0]
#define WF_WFDMA_EXT_WRAP_CSR_WED_RX1_CTRL1_WED_RX_RING1_CTRL1_SHFT 0

/* =====================================================================================

  ---WED_RX1_CTRL2 (0x18027000 + 0x418)---

    WED_RX_RING1_CTRL2[31..0]    - (RW) WED RX ring 1 control 2

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WED_RX1_CTRL2_WED_RX_RING1_CTRL2_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_RX1_CTRL2_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_RX1_CTRL2_WED_RX_RING1_CTRL2_MASK 0xFFFFFFFF                // WED_RX_RING1_CTRL2[31..0]
#define WF_WFDMA_EXT_WRAP_CSR_WED_RX1_CTRL2_WED_RX_RING1_CTRL2_SHFT 0

/* =====================================================================================

  ---WED_RX1_STS (0x18027000 + 0x41C)---

    WED_RX_RING1_DIDX[11..0]     - (RO) WED RX ring 1 DMA index
    RESERVED12[31..12]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WED_RX1_STS_WED_RX_RING1_DIDX_ADDR WF_WFDMA_EXT_WRAP_CSR_WED_RX1_STS_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WED_RX1_STS_WED_RX_RING1_DIDX_MASK 0x00000FFF                // WED_RX_RING1_DIDX[11..0]
#define WF_WFDMA_EXT_WRAP_CSR_WED_RX1_STS_WED_RX_RING1_DIDX_SHFT 0

/* =====================================================================================

  ---WFDMA_AXI_R2A_CTRL_0 (0x18027000 + 0x500)---

    AXI_RD_OUTSTAND_NUM[3..0]    - (RW) AXI read outstanding number
    LAST_NONBUF[4]               - (RW) Last nonbuf
    BUFFERABLE[5]                - (RW) Bufferable
    BURST_SIZE[7..6]             - (RW) AXI burst size
    SLEEP_MODE[9..8]             - (RW) Sleep mode
    BRESP_ERR_CHK_BYP[10]        - (RW) BRESP error check bypass enable
    BID_CHK_BYP[11]              - (RW) BID check bypass enable
    BUFRDY_BYP[12]               - (RW) Buffer ready bypass enable
    CLKGATE_BYP[13]              - (RW) Clock gating bypass enable
    RX_ERR_EN[14]                - (RW) RX error detect enable
    TX_ERR_EN[15]                - (RW) TX error detect enable
    TX_ERR_TH[23..16]            - (RW) TX error timer threshold
    RX_ERR_TH[31..24]            - (RW) RX error timer threshold

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_0_RX_ERR_TH_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_0_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_0_RX_ERR_TH_MASK 0xFF000000                // RX_ERR_TH[31..24]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_0_RX_ERR_TH_SHFT 24
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_0_TX_ERR_TH_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_0_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_0_TX_ERR_TH_MASK 0x00FF0000                // TX_ERR_TH[23..16]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_0_TX_ERR_TH_SHFT 16
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_0_TX_ERR_EN_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_0_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_0_TX_ERR_EN_MASK 0x00008000                // TX_ERR_EN[15]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_0_TX_ERR_EN_SHFT 15
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_0_RX_ERR_EN_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_0_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_0_RX_ERR_EN_MASK 0x00004000                // RX_ERR_EN[14]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_0_RX_ERR_EN_SHFT 14
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_0_CLKGATE_BYP_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_0_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_0_CLKGATE_BYP_MASK 0x00002000                // CLKGATE_BYP[13]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_0_CLKGATE_BYP_SHFT 13
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_0_BUFRDY_BYP_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_0_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_0_BUFRDY_BYP_MASK 0x00001000                // BUFRDY_BYP[12]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_0_BUFRDY_BYP_SHFT 12
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_0_BID_CHK_BYP_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_0_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_0_BID_CHK_BYP_MASK 0x00000800                // BID_CHK_BYP[11]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_0_BID_CHK_BYP_SHFT 11
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_0_BRESP_ERR_CHK_BYP_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_0_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_0_BRESP_ERR_CHK_BYP_MASK 0x00000400                // BRESP_ERR_CHK_BYP[10]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_0_BRESP_ERR_CHK_BYP_SHFT 10
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_0_SLEEP_MODE_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_0_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_0_SLEEP_MODE_MASK 0x00000300                // SLEEP_MODE[9..8]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_0_SLEEP_MODE_SHFT 8
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_0_BURST_SIZE_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_0_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_0_BURST_SIZE_MASK 0x000000C0                // BURST_SIZE[7..6]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_0_BURST_SIZE_SHFT 6
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_0_BUFFERABLE_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_0_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_0_BUFFERABLE_MASK 0x00000020                // BUFFERABLE[5]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_0_BUFFERABLE_SHFT 5
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_0_LAST_NONBUF_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_0_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_0_LAST_NONBUF_MASK 0x00000010                // LAST_NONBUF[4]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_0_LAST_NONBUF_SHFT 4
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_0_AXI_RD_OUTSTAND_NUM_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_0_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_0_AXI_RD_OUTSTAND_NUM_MASK 0x0000000F                // AXI_RD_OUTSTAND_NUM[3..0]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_0_AXI_RD_OUTSTAND_NUM_SHFT 0

/* =====================================================================================

  ---WFDMA_AXI_R2A_CTRL_1 (0x18027000 + 0x504)---

    LIMITER_SEL[0]               - (RW) LIMITER_SEL
    LIMITER_RX_RD_EN[2..1]       - (RW) LIMITER_RX_RD_EN
    LIMITER_RX_RD_1[8..3]        - (RW) LIMITER_RX_RD_1
    LIMITER_RX_RD_0[14..9]       - (RW) LIMITER_RX_RD_0
    LIMITER_RX_WR_EN[16..15]     - (RW) LIMITER_RX_WR_EN
    LIMITER_RX_WR_1[22..17]      - (RW) LIMITER_RX_WR_1
    LIMITER_RX_WR_0[28..23]      - (RW) LIMITER_RX_WR_0
    RESERVED29[31..29]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_1_LIMITER_RX_WR_0_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_1_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_1_LIMITER_RX_WR_0_MASK 0x1F800000                // LIMITER_RX_WR_0[28..23]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_1_LIMITER_RX_WR_0_SHFT 23
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_1_LIMITER_RX_WR_1_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_1_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_1_LIMITER_RX_WR_1_MASK 0x007E0000                // LIMITER_RX_WR_1[22..17]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_1_LIMITER_RX_WR_1_SHFT 17
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_1_LIMITER_RX_WR_EN_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_1_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_1_LIMITER_RX_WR_EN_MASK 0x00018000                // LIMITER_RX_WR_EN[16..15]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_1_LIMITER_RX_WR_EN_SHFT 15
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_1_LIMITER_RX_RD_0_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_1_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_1_LIMITER_RX_RD_0_MASK 0x00007E00                // LIMITER_RX_RD_0[14..9]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_1_LIMITER_RX_RD_0_SHFT 9
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_1_LIMITER_RX_RD_1_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_1_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_1_LIMITER_RX_RD_1_MASK 0x000001F8                // LIMITER_RX_RD_1[8..3]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_1_LIMITER_RX_RD_1_SHFT 3
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_1_LIMITER_RX_RD_EN_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_1_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_1_LIMITER_RX_RD_EN_MASK 0x00000006                // LIMITER_RX_RD_EN[2..1]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_1_LIMITER_RX_RD_EN_SHFT 1
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_1_LIMITER_SEL_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_1_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_1_LIMITER_SEL_MASK 0x00000001                // LIMITER_SEL[0]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_1_LIMITER_SEL_SHFT 0

/* =====================================================================================

  ---WFDMA_AXI_R2A_CTRL_2 (0x18027000 + 0x508)---

    LOCK_MAX_CNT[4..0]           - (RW) LOCK_MAX_CNT
    LOCK_MAX_CNT_EN[5]           - (RW) LOCK_MAX_CNT_EN
    ERR_FLAGS_CLR[6]             - (RW) ERR_FLAGS_CLR
    WFIFO_LAST_SW_CTL[7]         - (RW) WFIFO_LAST_SW_CTL
    LOCK_RLS_CNT[23..8]          - (RW) LOCK_RLS_CNT
    LOCK_RLS_EN[24]              - (RW) LOCK_RLS_EN
    AXI_RD_OUT_OF_ORDER[25]      - (RW) AXI read supports out-of-order response data
    RESERVED26[27..26]           - (RO) Reserved bits
    AXI_WR_OUTSTAND_NUM[31..28]  - (RW) AXI write outstanding number

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_2_AXI_WR_OUTSTAND_NUM_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_2_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_2_AXI_WR_OUTSTAND_NUM_MASK 0xF0000000                // AXI_WR_OUTSTAND_NUM[31..28]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_2_AXI_WR_OUTSTAND_NUM_SHFT 28
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_2_AXI_RD_OUT_OF_ORDER_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_2_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_2_AXI_RD_OUT_OF_ORDER_MASK 0x02000000                // AXI_RD_OUT_OF_ORDER[25]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_2_AXI_RD_OUT_OF_ORDER_SHFT 25
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_2_LOCK_RLS_EN_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_2_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_2_LOCK_RLS_EN_MASK 0x01000000                // LOCK_RLS_EN[24]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_2_LOCK_RLS_EN_SHFT 24
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_2_LOCK_RLS_CNT_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_2_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_2_LOCK_RLS_CNT_MASK 0x00FFFF00                // LOCK_RLS_CNT[23..8]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_2_LOCK_RLS_CNT_SHFT 8
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_2_WFIFO_LAST_SW_CTL_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_2_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_2_WFIFO_LAST_SW_CTL_MASK 0x00000080                // WFIFO_LAST_SW_CTL[7]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_2_WFIFO_LAST_SW_CTL_SHFT 7
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_2_ERR_FLAGS_CLR_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_2_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_2_ERR_FLAGS_CLR_MASK 0x00000040                // ERR_FLAGS_CLR[6]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_2_ERR_FLAGS_CLR_SHFT 6
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_2_LOCK_MAX_CNT_EN_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_2_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_2_LOCK_MAX_CNT_EN_MASK 0x00000020                // LOCK_MAX_CNT_EN[5]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_2_LOCK_MAX_CNT_EN_SHFT 5
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_2_LOCK_MAX_CNT_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_2_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_2_LOCK_MAX_CNT_MASK 0x0000001F                // LOCK_MAX_CNT[4..0]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI_R2A_CTRL_2_LOCK_MAX_CNT_SHFT 0

/* =====================================================================================

  ---WFDMA_AXI0_R2A_STS (0x18027000 + 0x50C)---

    RD_AXI_ERR_DET_INT[0]        - (RO) RD_AXI_ERR_DET_INT
    WR_AXI_ERR_DET_INT[1]        - (RO) WR_AXI_ERR_DET_INT
    ERR_PORT_RD_DAT_RID[2]       - (RO) ERR_PORT_RD_DAT_RID
    RRESP_ERR_STS[10..3]         - (RO) RRESP_ERR_STS
    RRESP_ERR[11]                - (RO) RRESP_ERR
    BRESP_ERR_STS[19..12]        - (RO) BRESP_ERR_STS
    BRESP_ERR[20]                - (RO) BRESP_ERR
    RESERVED21[31..21]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_STS_BRESP_ERR_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_STS_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_STS_BRESP_ERR_MASK 0x00100000                // BRESP_ERR[20]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_STS_BRESP_ERR_SHFT 20
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_STS_BRESP_ERR_STS_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_STS_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_STS_BRESP_ERR_STS_MASK 0x000FF000                // BRESP_ERR_STS[19..12]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_STS_BRESP_ERR_STS_SHFT 12
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_STS_RRESP_ERR_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_STS_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_STS_RRESP_ERR_MASK 0x00000800                // RRESP_ERR[11]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_STS_RRESP_ERR_SHFT 11
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_STS_RRESP_ERR_STS_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_STS_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_STS_RRESP_ERR_STS_MASK 0x000007F8                // RRESP_ERR_STS[10..3]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_STS_RRESP_ERR_STS_SHFT 3
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_STS_ERR_PORT_RD_DAT_RID_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_STS_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_STS_ERR_PORT_RD_DAT_RID_MASK 0x00000004                // ERR_PORT_RD_DAT_RID[2]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_STS_ERR_PORT_RD_DAT_RID_SHFT 2
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_STS_WR_AXI_ERR_DET_INT_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_STS_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_STS_WR_AXI_ERR_DET_INT_MASK 0x00000002                // WR_AXI_ERR_DET_INT[1]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_STS_WR_AXI_ERR_DET_INT_SHFT 1
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_STS_RD_AXI_ERR_DET_INT_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_STS_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_STS_RD_AXI_ERR_DET_INT_MASK 0x00000001                // RD_AXI_ERR_DET_INT[0]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_STS_RD_AXI_ERR_DET_INT_SHFT 0

/* =====================================================================================

  ---WFDMA_AXI0_R2A_DMAWR_PROBE (0x18027000 + 0x510)---

    WFDMA_AXI0_R2A_DMAWR_PROBE[31..0] - (RO) WFDMA_AXI0_R2A_DMAWR_PROBE

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_DMAWR_PROBE_WFDMA_AXI0_R2A_DMAWR_PROBE_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_DMAWR_PROBE_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_DMAWR_PROBE_WFDMA_AXI0_R2A_DMAWR_PROBE_MASK 0xFFFFFFFF                // WFDMA_AXI0_R2A_DMAWR_PROBE[31..0]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_DMAWR_PROBE_WFDMA_AXI0_R2A_DMAWR_PROBE_SHFT 0

/* =====================================================================================

  ---WFDMA_AXI0_R2A_DMARD_PROBE (0x18027000 + 0x514)---

    WFDMA_AXI0_R2A_DMARD_PROBE[31..0] - (RO) WFDMA_AXI0_R2A_DMARD_PROBE

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_DMARD_PROBE_WFDMA_AXI0_R2A_DMARD_PROBE_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_DMARD_PROBE_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_DMARD_PROBE_WFDMA_AXI0_R2A_DMARD_PROBE_MASK 0xFFFFFFFF                // WFDMA_AXI0_R2A_DMARD_PROBE[31..0]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_DMARD_PROBE_WFDMA_AXI0_R2A_DMARD_PROBE_SHFT 0

/* =====================================================================================

  ---WFDMA_AXI0_R2A_WR_DBG_AXIM_OUT0 (0x18027000 + 0x518)---

    WFDMA_AXI0_R2A_WR_DBG_AXIM_OUT0[31..0] - (RO) WFDMA_AXI0_R2A_WR_DBG_AXIM_OUT0

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_WR_DBG_AXIM_OUT0_WFDMA_AXI0_R2A_WR_DBG_AXIM_OUT0_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_WR_DBG_AXIM_OUT0_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_WR_DBG_AXIM_OUT0_WFDMA_AXI0_R2A_WR_DBG_AXIM_OUT0_MASK 0xFFFFFFFF                // WFDMA_AXI0_R2A_WR_DBG_AXIM_OUT0[31..0]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_WR_DBG_AXIM_OUT0_WFDMA_AXI0_R2A_WR_DBG_AXIM_OUT0_SHFT 0

/* =====================================================================================

  ---WFDMA_AXI0_R2A_WR_DBG_AXIM_OUT1 (0x18027000 + 0x51C)---

    WFDMA_AXI0_R2A_WR_DBG_AXIM_OUT1[31..0] - (RO) WFDMA_AXI0_R2A_WR_DBG_AXIM_OUT1

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_WR_DBG_AXIM_OUT1_WFDMA_AXI0_R2A_WR_DBG_AXIM_OUT1_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_WR_DBG_AXIM_OUT1_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_WR_DBG_AXIM_OUT1_WFDMA_AXI0_R2A_WR_DBG_AXIM_OUT1_MASK 0xFFFFFFFF                // WFDMA_AXI0_R2A_WR_DBG_AXIM_OUT1[31..0]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_WR_DBG_AXIM_OUT1_WFDMA_AXI0_R2A_WR_DBG_AXIM_OUT1_SHFT 0

/* =====================================================================================

  ---WFDMA_AXI0_R2A_AXI_SLP_STS (0x18027000 + 0x520)---

    WFDMA_AXI0_R2A_AXI_RD_SLP_STS[15..0] - (RO) WFDMA_AXI0_R2A_AXI_RD_SLP_STS
    WFDMA_AXI0_R2A_AXI_WR_SLP_STS[31..16] - (RO) WFDMA_AXI0_R2A_AXI_WR_SLP_STS

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_AXI_SLP_STS_WFDMA_AXI0_R2A_AXI_WR_SLP_STS_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_AXI_SLP_STS_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_AXI_SLP_STS_WFDMA_AXI0_R2A_AXI_WR_SLP_STS_MASK 0xFFFF0000                // WFDMA_AXI0_R2A_AXI_WR_SLP_STS[31..16]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_AXI_SLP_STS_WFDMA_AXI0_R2A_AXI_WR_SLP_STS_SHFT 16
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_AXI_SLP_STS_WFDMA_AXI0_R2A_AXI_RD_SLP_STS_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_AXI_SLP_STS_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_AXI_SLP_STS_WFDMA_AXI0_R2A_AXI_RD_SLP_STS_MASK 0x0000FFFF                // WFDMA_AXI0_R2A_AXI_RD_SLP_STS[15..0]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_AXI_SLP_STS_WFDMA_AXI0_R2A_AXI_RD_SLP_STS_SHFT 0

/* =====================================================================================

  ---WFDMA_AXI0_R2A_RD_DBG_AXIM_OUT0 (0x18027000 + 0x524)---

    WFDMA_AXI0_R2A_RD_DBG_AXIM_OUT0[31..0] - (RO) WFDMA_AXI0_R2A_RD_DBG_AXIM_OUT0

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_RD_DBG_AXIM_OUT0_WFDMA_AXI0_R2A_RD_DBG_AXIM_OUT0_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_RD_DBG_AXIM_OUT0_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_RD_DBG_AXIM_OUT0_WFDMA_AXI0_R2A_RD_DBG_AXIM_OUT0_MASK 0xFFFFFFFF                // WFDMA_AXI0_R2A_RD_DBG_AXIM_OUT0[31..0]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_RD_DBG_AXIM_OUT0_WFDMA_AXI0_R2A_RD_DBG_AXIM_OUT0_SHFT 0

/* =====================================================================================

  ---WFDMA_AXI0_R2A_RD_DBG_AXIM_OUT1 (0x18027000 + 0x528)---

    WFDMA_AXI0_R2A_RD_DBG_AXIM_OUT1[31..0] - (RO) WFDMA_AXI0_R2A_RD_DBG_AXIM_OUT1

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_RD_DBG_AXIM_OUT1_WFDMA_AXI0_R2A_RD_DBG_AXIM_OUT1_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_RD_DBG_AXIM_OUT1_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_RD_DBG_AXIM_OUT1_WFDMA_AXI0_R2A_RD_DBG_AXIM_OUT1_MASK 0xFFFFFFFF                // WFDMA_AXI0_R2A_RD_DBG_AXIM_OUT1[31..0]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_RD_DBG_AXIM_OUT1_WFDMA_AXI0_R2A_RD_DBG_AXIM_OUT1_SHFT 0

/* =====================================================================================

  ---WFDMA_AXI0_R2A_FSM_CMD_ST (0x18027000 + 0x52C)---

    WFDMA_AXI0_R2A_FSM_CMD_ST[31..0] - (RO) WFDMA_AXI0_R2A_FSM_CMD_ST

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_FSM_CMD_ST_WFDMA_AXI0_R2A_FSM_CMD_ST_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_FSM_CMD_ST_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_FSM_CMD_ST_WFDMA_AXI0_R2A_FSM_CMD_ST_MASK 0xFFFFFFFF                // WFDMA_AXI0_R2A_FSM_CMD_ST[31..0]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_FSM_CMD_ST_WFDMA_AXI0_R2A_FSM_CMD_ST_SHFT 0

/* =====================================================================================

  ---WFDMA_AXI0_R2A_FSM_DAT_ST (0x18027000 + 0x530)---

    WFDMA_AXI0_R2A_FSM_DAT_ST[31..0] - (RO) WFDMA_AXI0_R2A_FSM_DAT_ST

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_FSM_DAT_ST_WFDMA_AXI0_R2A_FSM_DAT_ST_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_FSM_DAT_ST_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_FSM_DAT_ST_WFDMA_AXI0_R2A_FSM_DAT_ST_MASK 0xFFFFFFFF                // WFDMA_AXI0_R2A_FSM_DAT_ST[31..0]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI0_R2A_FSM_DAT_ST_WFDMA_AXI0_R2A_FSM_DAT_ST_SHFT 0

/* =====================================================================================

  ---WFDMA_AXI1_R2A_STS (0x18027000 + 0x534)---

    RD_AXI_ERR_DET_INT[0]        - (RO) RD_AXI_ERR_DET_INT
    WR_AXI_ERR_DET_INT[1]        - (RO) WR_AXI_ERR_DET_INT
    ERR_PORT_RD_DAT_RID[2]       - (RO) ERR_PORT_RD_DAT_RID
    RRESP_ERR_STS[10..3]         - (RO) RRESP_ERR_STS
    RRESP_ERR[11]                - (RO) RRESP_ERR
    BRESP_ERR_STS[19..12]        - (RO) BRESP_ERR_STS
    BRESP_ERR[20]                - (RO) BRESP_ERR
    RESERVED21[31..21]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_STS_BRESP_ERR_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_STS_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_STS_BRESP_ERR_MASK 0x00100000                // BRESP_ERR[20]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_STS_BRESP_ERR_SHFT 20
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_STS_BRESP_ERR_STS_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_STS_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_STS_BRESP_ERR_STS_MASK 0x000FF000                // BRESP_ERR_STS[19..12]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_STS_BRESP_ERR_STS_SHFT 12
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_STS_RRESP_ERR_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_STS_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_STS_RRESP_ERR_MASK 0x00000800                // RRESP_ERR[11]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_STS_RRESP_ERR_SHFT 11
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_STS_RRESP_ERR_STS_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_STS_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_STS_RRESP_ERR_STS_MASK 0x000007F8                // RRESP_ERR_STS[10..3]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_STS_RRESP_ERR_STS_SHFT 3
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_STS_ERR_PORT_RD_DAT_RID_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_STS_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_STS_ERR_PORT_RD_DAT_RID_MASK 0x00000004                // ERR_PORT_RD_DAT_RID[2]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_STS_ERR_PORT_RD_DAT_RID_SHFT 2
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_STS_WR_AXI_ERR_DET_INT_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_STS_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_STS_WR_AXI_ERR_DET_INT_MASK 0x00000002                // WR_AXI_ERR_DET_INT[1]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_STS_WR_AXI_ERR_DET_INT_SHFT 1
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_STS_RD_AXI_ERR_DET_INT_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_STS_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_STS_RD_AXI_ERR_DET_INT_MASK 0x00000001                // RD_AXI_ERR_DET_INT[0]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_STS_RD_AXI_ERR_DET_INT_SHFT 0

/* =====================================================================================

  ---WFDMA_AXI1_R2A_DMAWR_PROBE (0x18027000 + 0x538)---

    WFDMA_AXI1_R2A_DMAWR_PROBE[31..0] - (RO) WFDMA_AXI1_R2A_DMAWR_PROBE

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_DMAWR_PROBE_WFDMA_AXI1_R2A_DMAWR_PROBE_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_DMAWR_PROBE_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_DMAWR_PROBE_WFDMA_AXI1_R2A_DMAWR_PROBE_MASK 0xFFFFFFFF                // WFDMA_AXI1_R2A_DMAWR_PROBE[31..0]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_DMAWR_PROBE_WFDMA_AXI1_R2A_DMAWR_PROBE_SHFT 0

/* =====================================================================================

  ---WFDMA_AXI1_R2A_DMARD_PROBE (0x18027000 + 0x53C)---

    WFDMA_AXI1_R2A_DMARD_PROBE[31..0] - (RO) WFDMA_AXI1_R2A_DMARD_PROBE

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_DMARD_PROBE_WFDMA_AXI1_R2A_DMARD_PROBE_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_DMARD_PROBE_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_DMARD_PROBE_WFDMA_AXI1_R2A_DMARD_PROBE_MASK 0xFFFFFFFF                // WFDMA_AXI1_R2A_DMARD_PROBE[31..0]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_DMARD_PROBE_WFDMA_AXI1_R2A_DMARD_PROBE_SHFT 0

/* =====================================================================================

  ---WFDMA_AXI1_R2A_WR_DBG_AXIM_OUT0 (0x18027000 + 0x540)---

    WFDMA_AXI1_R2A_WR_DBG_AXIM_OUT0[31..0] - (RO) WFDMA_AXI1_R2A_WR_DBG_AXIM_OUT0

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_WR_DBG_AXIM_OUT0_WFDMA_AXI1_R2A_WR_DBG_AXIM_OUT0_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_WR_DBG_AXIM_OUT0_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_WR_DBG_AXIM_OUT0_WFDMA_AXI1_R2A_WR_DBG_AXIM_OUT0_MASK 0xFFFFFFFF                // WFDMA_AXI1_R2A_WR_DBG_AXIM_OUT0[31..0]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_WR_DBG_AXIM_OUT0_WFDMA_AXI1_R2A_WR_DBG_AXIM_OUT0_SHFT 0

/* =====================================================================================

  ---WFDMA_AXI1_R2A_WR_DBG_AXIM_OUT1 (0x18027000 + 0x544)---

    WFDMA_AXI1_R2A_WR_DBG_AXIM_OUT1[31..0] - (RO) WFDMA_AXI1_R2A_WR_DBG_AXIM_OUT1

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_WR_DBG_AXIM_OUT1_WFDMA_AXI1_R2A_WR_DBG_AXIM_OUT1_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_WR_DBG_AXIM_OUT1_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_WR_DBG_AXIM_OUT1_WFDMA_AXI1_R2A_WR_DBG_AXIM_OUT1_MASK 0xFFFFFFFF                // WFDMA_AXI1_R2A_WR_DBG_AXIM_OUT1[31..0]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_WR_DBG_AXIM_OUT1_WFDMA_AXI1_R2A_WR_DBG_AXIM_OUT1_SHFT 0

/* =====================================================================================

  ---WFDMA_AXI1_R2A_AXI_SLP_STS (0x18027000 + 0x548)---

    WFDMA_AXI1_R2A_AXI_RD_SLP_STS[15..0] - (RO) WFDMA_AXI1_R2A_AXI_RD_SLP_STS
    WFDMA_AXI1_R2A_AXI_WR_SLP_STS[31..16] - (RO) WFDMA_AXI1_R2A_AXI_WR_SLP_STS

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_AXI_SLP_STS_WFDMA_AXI1_R2A_AXI_WR_SLP_STS_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_AXI_SLP_STS_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_AXI_SLP_STS_WFDMA_AXI1_R2A_AXI_WR_SLP_STS_MASK 0xFFFF0000                // WFDMA_AXI1_R2A_AXI_WR_SLP_STS[31..16]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_AXI_SLP_STS_WFDMA_AXI1_R2A_AXI_WR_SLP_STS_SHFT 16
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_AXI_SLP_STS_WFDMA_AXI1_R2A_AXI_RD_SLP_STS_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_AXI_SLP_STS_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_AXI_SLP_STS_WFDMA_AXI1_R2A_AXI_RD_SLP_STS_MASK 0x0000FFFF                // WFDMA_AXI1_R2A_AXI_RD_SLP_STS[15..0]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_AXI_SLP_STS_WFDMA_AXI1_R2A_AXI_RD_SLP_STS_SHFT 0

/* =====================================================================================

  ---WFDMA_AXI1_R2A_RD_DBG_AXIM_OUT0 (0x18027000 + 0x54C)---

    WFDMA_AXI1_R2A_RD_DBG_AXIM_OUT0[31..0] - (RO) WFDMA_AXI1_R2A_RD_DBG_AXIM_OUT0

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_RD_DBG_AXIM_OUT0_WFDMA_AXI1_R2A_RD_DBG_AXIM_OUT0_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_RD_DBG_AXIM_OUT0_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_RD_DBG_AXIM_OUT0_WFDMA_AXI1_R2A_RD_DBG_AXIM_OUT0_MASK 0xFFFFFFFF                // WFDMA_AXI1_R2A_RD_DBG_AXIM_OUT0[31..0]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_RD_DBG_AXIM_OUT0_WFDMA_AXI1_R2A_RD_DBG_AXIM_OUT0_SHFT 0

/* =====================================================================================

  ---WFDMA_AXI1_R2A_RD_DBG_AXIM_OUT1 (0x18027000 + 0x550)---

    WFDMA_AXI1_R2A_RD_DBG_AXIM_OUT1[31..0] - (RO) WFDMA_AXI1_R2A_RD_DBG_AXIM_OUT1

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_RD_DBG_AXIM_OUT1_WFDMA_AXI1_R2A_RD_DBG_AXIM_OUT1_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_RD_DBG_AXIM_OUT1_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_RD_DBG_AXIM_OUT1_WFDMA_AXI1_R2A_RD_DBG_AXIM_OUT1_MASK 0xFFFFFFFF                // WFDMA_AXI1_R2A_RD_DBG_AXIM_OUT1[31..0]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_RD_DBG_AXIM_OUT1_WFDMA_AXI1_R2A_RD_DBG_AXIM_OUT1_SHFT 0

/* =====================================================================================

  ---WFDMA_AXI1_R2A_FSM_CMD_ST (0x18027000 + 0x554)---

    WFDMA_AXI1_R2A_FSM_CMD_ST[31..0] - (RO) WFDMA_AXI1_R2A_FSM_CMD_ST

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_FSM_CMD_ST_WFDMA_AXI1_R2A_FSM_CMD_ST_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_FSM_CMD_ST_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_FSM_CMD_ST_WFDMA_AXI1_R2A_FSM_CMD_ST_MASK 0xFFFFFFFF                // WFDMA_AXI1_R2A_FSM_CMD_ST[31..0]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_FSM_CMD_ST_WFDMA_AXI1_R2A_FSM_CMD_ST_SHFT 0

/* =====================================================================================

  ---WFDMA_AXI1_R2A_FSM_DAT_ST (0x18027000 + 0x558)---

    WFDMA_AXI1_R2A_FSM_DAT_ST[31..0] - (RO) WFDMA_AXI1_R2A_FSM_DAT_ST

 =====================================================================================*/
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_FSM_DAT_ST_WFDMA_AXI1_R2A_FSM_DAT_ST_ADDR WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_FSM_DAT_ST_ADDR
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_FSM_DAT_ST_WFDMA_AXI1_R2A_FSM_DAT_ST_MASK 0xFFFFFFFF                // WFDMA_AXI1_R2A_FSM_DAT_ST[31..0]
#define WF_WFDMA_EXT_WRAP_CSR_WFDMA_AXI1_R2A_FSM_DAT_ST_WFDMA_AXI1_R2A_FSM_DAT_ST_SHFT 0

#ifdef __cplusplus
}
#endif

#endif // __WF_WFDMA_EXT_WRAP_CSR_REGS_H__
