/*
 * Copyright (c) [2020], MediaTek Inc. All rights reserved.
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws.
 * The information contained herein is confidential and proprietary to
 * MediaTek Inc. and/or its licensors.
 * Except as otherwise provided in the applicable licensing terms with
 * MediaTek Inc. and/or its licensors, any reproduction, modification, use or
 * disclosure of MediaTek Software, and information contained herein, in whole
 * or in part, shall be strictly prohibited.
*/
//[File]            : conn_infra_cfg.h
//[Revision time]   : Thu Jul 12 13:23:50 2018
//[Description]     : This file is auto generated by CODA
//[Copyright]       : Copyright (C) 2018 Mediatek Incorportion. All rights reserved.

#ifndef __CONN_INFRA_CFG_REGS_H__
#define __CONN_INFRA_CFG_REGS_H__

#include "hal_common.h"

#ifdef __cplusplus
extern "C" {
#endif


//****************************************************************************
//
//                     CONN_INFRA_CFG CR Definitions                     
//
//****************************************************************************

#define CONN_INFRA_CFG_BASE                                    0xf1000

#define CONN_INFRA_CFG_CONN_HW_VER_ADDR                        (CONN_INFRA_CFG_BASE + 0x0000) // 1000
#define CONN_INFRA_CFG_CONN_CFG_ID_ADDR                        (CONN_INFRA_CFG_BASE + 0x0004) // 1004
#define CONN_INFRA_CFG_CONN_FPGA_DUMMY0_ADDR                   (CONN_INFRA_CFG_BASE + 0x0010) // 1010
#define CONN_INFRA_CFG_CONN_FPGA_DUMMY1_ADDR                   (CONN_INFRA_CFG_BASE + 0x0014) // 1014
#define CONN_INFRA_CFG_CONN_INFRA_EASY_SECURITY_CTRL_ADDR      (CONN_INFRA_CFG_BASE + 0x00F0) // 10F0
#define CONN_INFRA_CFG_CONN_INFRA_EASY_SECURITY_TARGET_ADDR    (CONN_INFRA_CFG_BASE + 0x00F4) // 10F4
#define CONN_INFRA_CFG_AP2BGF_REMAP_0_ADDR                     (CONN_INFRA_CFG_BASE + 0x0100) // 1100
#define CONN_INFRA_CFG_AP2BGF_REMAP_1_ADDR                     (CONN_INFRA_CFG_BASE + 0x0104) // 1104
#define CONN_INFRA_CFG_AP2BGF_REMAP_2_ADDR                     (CONN_INFRA_CFG_BASE + 0x0108) // 1108
#define CONN_INFRA_CFG_AP2BGF_REMAP_SEG_0_ADDR                 (CONN_INFRA_CFG_BASE + 0x010C) // 110C
#define CONN_INFRA_CFG_AP2BGF_REMAP_SEG_1_ADDR                 (CONN_INFRA_CFG_BASE + 0x0110) // 1110
#define CONN_INFRA_CFG_SUBSYS2AP_REMAP_0_ADDR                  (CONN_INFRA_CFG_BASE + 0x0114) // 1114
#define CONN_INFRA_CFG_AP2BGF_REMAP_3_ADDR                     (CONN_INFRA_CFG_BASE + 0x0118) // 1118
#define CONN_INFRA_CFG_AP2WF_REMAP_0_ADDR                      (CONN_INFRA_CFG_BASE + 0x011C) // 111C
#define CONN_INFRA_CFG_AP2WF_REMAP_1_ADDR                      (CONN_INFRA_CFG_BASE + 0x0120) // 1120
#define CONN_INFRA_CFG_AP2WF_REMAP_2_ADDR                      (CONN_INFRA_CFG_BASE + 0x0124) // 1124
#define CONN_INFRA_CFG_AP2WF_REMAP_SEG_0_ADDR                  (CONN_INFRA_CFG_BASE + 0x0128) // 1128
#define CONN_INFRA_CFG_AP2WF_REMAP_SEG_1_ADDR                  (CONN_INFRA_CFG_BASE + 0x012C) // 112C
#define CONN_INFRA_CFG_AP2WF_REMAP_3_ADDR                      (CONN_INFRA_CFG_BASE + 0x0134) // 1134
#define CONN_INFRA_CFG_CONN_INFRA_GALS_AP2CONN_CTRL_0_ADDR     (CONN_INFRA_CFG_BASE + 0x0180) // 1180
#define CONN_INFRA_CFG_CONN_INFRA_GALS_AP2CONN_CTRL_1_ADDR     (CONN_INFRA_CFG_BASE + 0x0184) // 1184
#define CONN_INFRA_CFG_CONN_INFRA_GALS_CONN2AP_CTRL_0_ADDR     (CONN_INFRA_CFG_BASE + 0x0188) // 1188
#define CONN_INFRA_CFG_CONN_INFRA_GALS_CONN2AP_CTRL_1_ADDR     (CONN_INFRA_CFG_BASE + 0x018C) // 118C
#define CONN_INFRA_CFG_CONN_INFRA_PCIE2AP_REMAP_0_ADDR         (CONN_INFRA_CFG_BASE + 0x0190) // 1190
#define CONN_INFRA_CFG_CONN_INFRA_PCIE2AP_REMAP_1_ADDR         (CONN_INFRA_CFG_BASE + 0x0194) // 1194
#define CONN_INFRA_CFG_CONN_INFRA_PCIE2AP_REMAP_2_ADDR         (CONN_INFRA_CFG_BASE + 0x0198) // 1198
#define CONN_INFRA_CFG_CONN_INFRA_PCIE2AP_REMAP_3_ADDR         (CONN_INFRA_CFG_BASE + 0x019C) // 119C
#define CONN_INFRA_CFG_CONN_INFRA_PCIE2AP_REMAP_4_ADDR         (CONN_INFRA_CFG_BASE + 0x01A0) // 11A0
#define CONN_INFRA_CFG_CONN_INFRA_PCIE2AP_REMAP_5_ADDR         (CONN_INFRA_CFG_BASE + 0x01A4) // 11A4
#define CONN_INFRA_CFG_CONN_INFRA_PCIE2AP_REMAP_6_ADDR         (CONN_INFRA_CFG_BASE + 0x01A8) // 11A8
#define CONN_INFRA_CFG_CONN_INFRA_PCIE2AP_REMAP_7_ADDR         (CONN_INFRA_CFG_BASE + 0x01AC) // 11AC
#define CONN_INFRA_CFG_CONN_INFRA_LEGACY_REMAP_CTRL_0_ADDR     (CONN_INFRA_CFG_BASE + 0x01B0) // 11B0
#define CONN_INFRA_CFG_CONN_INFRA_LEGACY_REMAP_CTRL_1_ADDR     (CONN_INFRA_CFG_BASE + 0x01B4) // 11B4
#define CONN_INFRA_CFG_CONN_INFRA_LEGACY_REMAP_CTRL_2_ADDR     (CONN_INFRA_CFG_BASE + 0x01B8) // 11B8
#define CONN_INFRA_CFG_CONN_INFRA_LEGACY_REMAP_CTRL_3_ADDR     (CONN_INFRA_CFG_BASE + 0x01BC) // 11BC
#define CONN_INFRA_CFG_CONN_INFRA_LEGACY_REMAP_CTRL_4_ADDR     (CONN_INFRA_CFG_BASE + 0x01C0) // 11C0
#define CONN_INFRA_CFG_CONN_INFRA_LEGACY_REMAP_CTRL_5_ADDR     (CONN_INFRA_CFG_BASE + 0x01C4) // 11C4
#define CONN_INFRA_CFG_CONN_INFRA_LEGACY_REMAP_CTRL_6_ADDR     (CONN_INFRA_CFG_BASE + 0x01C8) // 11C8
#define CONN_INFRA_CFG_CONN_INFRA_SYSRAM_CTRL_0_ADDR           (CONN_INFRA_CFG_BASE + 0x0500) // 1500
#define CONN_INFRA_CFG_CONN_INFRA_SYSRAM_CTRL_1_ADDR           (CONN_INFRA_CFG_BASE + 0x0504) // 1504
#define CONN_INFRA_CFG_CONN_INFRA_SLP_PROT_DBG_BGF_ADDR        (CONN_INFRA_CFG_BASE + 0x0600) // 1600
#define CONN_INFRA_CFG_CONN_INFRA_SLP_PROT_DBG_WF_ADDR         (CONN_INFRA_CFG_BASE + 0x0604) // 1604




/* =====================================================================================

  ---CONN_HW_VER (0x18001000 + 0x0000)---

    ro_conn_hw_version[31..0]    - (RO)  xxx 

 =====================================================================================*/
#define CONN_INFRA_CFG_CONN_HW_VER_ro_conn_hw_version_ADDR     CONN_INFRA_CFG_CONN_HW_VER_ADDR
#define CONN_INFRA_CFG_CONN_HW_VER_ro_conn_hw_version_MASK     0xFFFFFFFF                // ro_conn_hw_version[31..0]
#define CONN_INFRA_CFG_CONN_HW_VER_ro_conn_hw_version_SHFT     0

/* =====================================================================================

  ---CONN_CFG_ID (0x18001000 + 0x0004)---

    ro_conn_cfg_id[31..0]        - (RO)  xxx 

 =====================================================================================*/
#define CONN_INFRA_CFG_CONN_CFG_ID_ro_conn_cfg_id_ADDR         CONN_INFRA_CFG_CONN_CFG_ID_ADDR
#define CONN_INFRA_CFG_CONN_CFG_ID_ro_conn_cfg_id_MASK         0xFFFFFFFF                // ro_conn_cfg_id[31..0]
#define CONN_INFRA_CFG_CONN_CFG_ID_ro_conn_cfg_id_SHFT         0

/* =====================================================================================

  ---CONN_FPGA_DUMMY0 (0x18001000 + 0x0010)---

    r_conn_fpga_dummy0[31..0]    - (RW)  xxx 

 =====================================================================================*/
#define CONN_INFRA_CFG_CONN_FPGA_DUMMY0_r_conn_fpga_dummy0_ADDR CONN_INFRA_CFG_CONN_FPGA_DUMMY0_ADDR
#define CONN_INFRA_CFG_CONN_FPGA_DUMMY0_r_conn_fpga_dummy0_MASK 0xFFFFFFFF                // r_conn_fpga_dummy0[31..0]
#define CONN_INFRA_CFG_CONN_FPGA_DUMMY0_r_conn_fpga_dummy0_SHFT 0

/* =====================================================================================

  ---CONN_FPGA_DUMMY1 (0x18001000 + 0x0014)---

    r_conn_fpga_dummy1[31..0]    - (RW)  xxx 

 =====================================================================================*/
#define CONN_INFRA_CFG_CONN_FPGA_DUMMY1_r_conn_fpga_dummy1_ADDR CONN_INFRA_CFG_CONN_FPGA_DUMMY1_ADDR
#define CONN_INFRA_CFG_CONN_FPGA_DUMMY1_r_conn_fpga_dummy1_MASK 0xFFFFFFFF                // r_conn_fpga_dummy1[31..0]
#define CONN_INFRA_CFG_CONN_FPGA_DUMMY1_r_conn_fpga_dummy1_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_EASY_SECURITY_CTRL (0x18001000 + 0x00F0)---

    r_conn_infra_wf_easy_security_control[0] - (RW)  xxx 
    r_conn_infra_bgf_easy_security_control[1] - (RW)  xxx 
    RESERVED2[31..2]             - (RO) Reserved bits

 =====================================================================================*/
#define CONN_INFRA_CFG_CONN_INFRA_EASY_SECURITY_CTRL_r_conn_infra_bgf_easy_security_control_ADDR CONN_INFRA_CFG_CONN_INFRA_EASY_SECURITY_CTRL_ADDR
#define CONN_INFRA_CFG_CONN_INFRA_EASY_SECURITY_CTRL_r_conn_infra_bgf_easy_security_control_MASK 0x00000002                // r_conn_infra_bgf_easy_security_control[1]
#define CONN_INFRA_CFG_CONN_INFRA_EASY_SECURITY_CTRL_r_conn_infra_bgf_easy_security_control_SHFT 1
#define CONN_INFRA_CFG_CONN_INFRA_EASY_SECURITY_CTRL_r_conn_infra_wf_easy_security_control_ADDR CONN_INFRA_CFG_CONN_INFRA_EASY_SECURITY_CTRL_ADDR
#define CONN_INFRA_CFG_CONN_INFRA_EASY_SECURITY_CTRL_r_conn_infra_wf_easy_security_control_MASK 0x00000001                // r_conn_infra_wf_easy_security_control[0]
#define CONN_INFRA_CFG_CONN_INFRA_EASY_SECURITY_CTRL_r_conn_infra_wf_easy_security_control_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_EASY_SECURITY_TARGET (0x18001000 + 0x00F4)---

    ro_conn_infra_easy_security_target[31..0] - (RO)  xxx 

 =====================================================================================*/
#define CONN_INFRA_CFG_CONN_INFRA_EASY_SECURITY_TARGET_ro_conn_infra_easy_security_target_ADDR CONN_INFRA_CFG_CONN_INFRA_EASY_SECURITY_TARGET_ADDR
#define CONN_INFRA_CFG_CONN_INFRA_EASY_SECURITY_TARGET_ro_conn_infra_easy_security_target_MASK 0xFFFFFFFF                // ro_conn_infra_easy_security_target[31..0]
#define CONN_INFRA_CFG_CONN_INFRA_EASY_SECURITY_TARGET_ro_conn_infra_easy_security_target_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_CFG_AP2BGF_REMAP_0 (0x18001000 + 0x0100)---

    r_ap2bgf_privat_remapping_0_start_address[31..0] - (RW)  xxx 

 =====================================================================================*/
#define CONN_INFRA_CFG_AP2BGF_REMAP_0_r_ap2bgf_privat_remapping_0_start_address_ADDR CONN_INFRA_CFG_AP2BGF_REMAP_0_ADDR
#define CONN_INFRA_CFG_AP2BGF_REMAP_0_r_ap2bgf_privat_remapping_0_start_address_MASK 0xFFFFFFFF                // r_ap2bgf_privat_remapping_0_start_address[31..0]
#define CONN_INFRA_CFG_AP2BGF_REMAP_0_r_ap2bgf_privat_remapping_0_start_address_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_CFG_AP2BGF_REMAP_1 (0x18001000 + 0x0104)---

    r_ap2bgf_public_remapping_0_start_address[31..0] - (RW)  xxx 

 =====================================================================================*/
#define CONN_INFRA_CFG_AP2BGF_REMAP_1_r_ap2bgf_public_remapping_0_start_address_ADDR CONN_INFRA_CFG_AP2BGF_REMAP_1_ADDR
#define CONN_INFRA_CFG_AP2BGF_REMAP_1_r_ap2bgf_public_remapping_0_start_address_MASK 0xFFFFFFFF                // r_ap2bgf_public_remapping_0_start_address[31..0]
#define CONN_INFRA_CFG_AP2BGF_REMAP_1_r_ap2bgf_public_remapping_0_start_address_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_CFG_AP2BGF_REMAP_2 (0x18001000 + 0x0108)---

    r_ap2bgf_public_remapping_1_start_address[31..0] - (RW)  xxx 

 =====================================================================================*/
#define CONN_INFRA_CFG_AP2BGF_REMAP_2_r_ap2bgf_public_remapping_1_start_address_ADDR CONN_INFRA_CFG_AP2BGF_REMAP_2_ADDR
#define CONN_INFRA_CFG_AP2BGF_REMAP_2_r_ap2bgf_public_remapping_1_start_address_MASK 0xFFFFFFFF                // r_ap2bgf_public_remapping_1_start_address[31..0]
#define CONN_INFRA_CFG_AP2BGF_REMAP_2_r_ap2bgf_public_remapping_1_start_address_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_CFG_AP2BGF_REMAP_SEG_0 (0x18001000 + 0x010C)---

    r_ap2bgf_remapping_segment_0[31..0] - (RW)  xxx 

 =====================================================================================*/
#define CONN_INFRA_CFG_AP2BGF_REMAP_SEG_0_r_ap2bgf_remapping_segment_0_ADDR CONN_INFRA_CFG_AP2BGF_REMAP_SEG_0_ADDR
#define CONN_INFRA_CFG_AP2BGF_REMAP_SEG_0_r_ap2bgf_remapping_segment_0_MASK 0xFFFFFFFF                // r_ap2bgf_remapping_segment_0[31..0]
#define CONN_INFRA_CFG_AP2BGF_REMAP_SEG_0_r_ap2bgf_remapping_segment_0_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_CFG_AP2BGF_REMAP_SEG_1 (0x18001000 + 0x0110)---

    r_ap2bgf_remapping_segment_1[31..0] - (RW)  xxx 

 =====================================================================================*/
#define CONN_INFRA_CFG_AP2BGF_REMAP_SEG_1_r_ap2bgf_remapping_segment_1_ADDR CONN_INFRA_CFG_AP2BGF_REMAP_SEG_1_ADDR
#define CONN_INFRA_CFG_AP2BGF_REMAP_SEG_1_r_ap2bgf_remapping_segment_1_MASK 0xFFFFFFFF                // r_ap2bgf_remapping_segment_1[31..0]
#define CONN_INFRA_CFG_AP2BGF_REMAP_SEG_1_r_ap2bgf_remapping_segment_1_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_CFG_SUBSYS2AP_REMAP_0 (0x18001000 + 0x0114)---

    r_conn_infra_start_address_in_ap[7..0] - (RW)  xxx 
    r_conn_infra_start_address_in_bgf[15..8] - (RW)  xxx 
    r_conn_infra_start_address_in_wf[23..16] - (RW)  xxx 
    RESERVED24[31..24]           - (RO) Reserved bits

 =====================================================================================*/
#define CONN_INFRA_CFG_SUBSYS2AP_REMAP_0_r_conn_infra_start_address_in_wf_ADDR CONN_INFRA_CFG_SUBSYS2AP_REMAP_0_ADDR
#define CONN_INFRA_CFG_SUBSYS2AP_REMAP_0_r_conn_infra_start_address_in_wf_MASK 0x00FF0000                // r_conn_infra_start_address_in_wf[23..16]
#define CONN_INFRA_CFG_SUBSYS2AP_REMAP_0_r_conn_infra_start_address_in_wf_SHFT 16
#define CONN_INFRA_CFG_SUBSYS2AP_REMAP_0_r_conn_infra_start_address_in_bgf_ADDR CONN_INFRA_CFG_SUBSYS2AP_REMAP_0_ADDR
#define CONN_INFRA_CFG_SUBSYS2AP_REMAP_0_r_conn_infra_start_address_in_bgf_MASK 0x0000FF00                // r_conn_infra_start_address_in_bgf[15..8]
#define CONN_INFRA_CFG_SUBSYS2AP_REMAP_0_r_conn_infra_start_address_in_bgf_SHFT 8
#define CONN_INFRA_CFG_SUBSYS2AP_REMAP_0_r_conn_infra_start_address_in_ap_ADDR CONN_INFRA_CFG_SUBSYS2AP_REMAP_0_ADDR
#define CONN_INFRA_CFG_SUBSYS2AP_REMAP_0_r_conn_infra_start_address_in_ap_MASK 0x000000FF                // r_conn_infra_start_address_in_ap[7..0]
#define CONN_INFRA_CFG_SUBSYS2AP_REMAP_0_r_conn_infra_start_address_in_ap_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_CFG_AP2BGF_REMAP_3 (0x18001000 + 0x0118)---

    r_ap2bgf_bgf_start_address[31..0] - (RW)  xxx 

 =====================================================================================*/
#define CONN_INFRA_CFG_AP2BGF_REMAP_3_r_ap2bgf_bgf_start_address_ADDR CONN_INFRA_CFG_AP2BGF_REMAP_3_ADDR
#define CONN_INFRA_CFG_AP2BGF_REMAP_3_r_ap2bgf_bgf_start_address_MASK 0xFFFFFFFF                // r_ap2bgf_bgf_start_address[31..0]
#define CONN_INFRA_CFG_AP2BGF_REMAP_3_r_ap2bgf_bgf_start_address_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_CFG_AP2WF_REMAP_0 (0x18001000 + 0x011C)---

    r_ap2wf_privat_remapping_0_start_address[31..0] - (RW)  xxx 

 =====================================================================================*/
#define CONN_INFRA_CFG_AP2WF_REMAP_0_r_ap2wf_privat_remapping_0_start_address_ADDR CONN_INFRA_CFG_AP2WF_REMAP_0_ADDR
#define CONN_INFRA_CFG_AP2WF_REMAP_0_r_ap2wf_privat_remapping_0_start_address_MASK 0xFFFFFFFF                // r_ap2wf_privat_remapping_0_start_address[31..0]
#define CONN_INFRA_CFG_AP2WF_REMAP_0_r_ap2wf_privat_remapping_0_start_address_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_CFG_AP2WF_REMAP_1 (0x18001000 + 0x0120)---

    r_ap2wf_public_remapping_0_start_address[31..0] - (RW)  xxx 

 =====================================================================================*/
#define CONN_INFRA_CFG_AP2WF_REMAP_1_r_ap2wf_public_remapping_0_start_address_ADDR CONN_INFRA_CFG_AP2WF_REMAP_1_ADDR
#define CONN_INFRA_CFG_AP2WF_REMAP_1_r_ap2wf_public_remapping_0_start_address_MASK 0xFFFFFFFF                // r_ap2wf_public_remapping_0_start_address[31..0]
#define CONN_INFRA_CFG_AP2WF_REMAP_1_r_ap2wf_public_remapping_0_start_address_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_CFG_AP2WF_REMAP_2 (0x18001000 + 0x0124)---

    r_ap2wf_public_remapping_1_start_address[31..0] - (RW)  xxx 

 =====================================================================================*/
#define CONN_INFRA_CFG_AP2WF_REMAP_2_r_ap2wf_public_remapping_1_start_address_ADDR CONN_INFRA_CFG_AP2WF_REMAP_2_ADDR
#define CONN_INFRA_CFG_AP2WF_REMAP_2_r_ap2wf_public_remapping_1_start_address_MASK 0xFFFFFFFF                // r_ap2wf_public_remapping_1_start_address[31..0]
#define CONN_INFRA_CFG_AP2WF_REMAP_2_r_ap2wf_public_remapping_1_start_address_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_CFG_AP2WF_REMAP_SEG_0 (0x18001000 + 0x0128)---

    r_ap2wf_remapping_segment_0[31..0] - (RW)  xxx 

 =====================================================================================*/
#define CONN_INFRA_CFG_AP2WF_REMAP_SEG_0_r_ap2wf_remapping_segment_0_ADDR CONN_INFRA_CFG_AP2WF_REMAP_SEG_0_ADDR
#define CONN_INFRA_CFG_AP2WF_REMAP_SEG_0_r_ap2wf_remapping_segment_0_MASK 0xFFFFFFFF                // r_ap2wf_remapping_segment_0[31..0]
#define CONN_INFRA_CFG_AP2WF_REMAP_SEG_0_r_ap2wf_remapping_segment_0_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_CFG_AP2WF_REMAP_SEG_1 (0x18001000 + 0x012C)---

    r_ap2wf_remapping_segment_1[31..0] - (RW)  xxx 

 =====================================================================================*/
#define CONN_INFRA_CFG_AP2WF_REMAP_SEG_1_r_ap2wf_remapping_segment_1_ADDR CONN_INFRA_CFG_AP2WF_REMAP_SEG_1_ADDR
#define CONN_INFRA_CFG_AP2WF_REMAP_SEG_1_r_ap2wf_remapping_segment_1_MASK 0xFFFFFFFF                // r_ap2wf_remapping_segment_1[31..0]
#define CONN_INFRA_CFG_AP2WF_REMAP_SEG_1_r_ap2wf_remapping_segment_1_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_CFG_AP2WF_REMAP_3 (0x18001000 + 0x0134)---

    r_ap2wf_wf_start_address[31..0] - (RW)  xxx 

 =====================================================================================*/
#define CONN_INFRA_CFG_AP2WF_REMAP_3_r_ap2wf_wf_start_address_ADDR CONN_INFRA_CFG_AP2WF_REMAP_3_ADDR
#define CONN_INFRA_CFG_AP2WF_REMAP_3_r_ap2wf_wf_start_address_MASK 0xFFFFFFFF                // r_ap2wf_wf_start_address[31..0]
#define CONN_INFRA_CFG_AP2WF_REMAP_3_r_ap2wf_wf_start_address_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_GALS_AP2CONN_CTRL_0 (0x18001000 + 0x0180)---

    ro_ap2conn_CBIP_GALS_sideband_gals_axi_dbg_slv[31..0] - (RO)  xxx 

 =====================================================================================*/
#define CONN_INFRA_CFG_CONN_INFRA_GALS_AP2CONN_CTRL_0_ro_ap2conn_CBIP_GALS_sideband_gals_axi_dbg_slv_ADDR CONN_INFRA_CFG_CONN_INFRA_GALS_AP2CONN_CTRL_0_ADDR
#define CONN_INFRA_CFG_CONN_INFRA_GALS_AP2CONN_CTRL_0_ro_ap2conn_CBIP_GALS_sideband_gals_axi_dbg_slv_MASK 0xFFFFFFFF                // ro_ap2conn_CBIP_GALS_sideband_gals_axi_dbg_slv[31..0]
#define CONN_INFRA_CFG_CONN_INFRA_GALS_AP2CONN_CTRL_0_ro_ap2conn_CBIP_GALS_sideband_gals_axi_dbg_slv_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_GALS_AP2CONN_CTRL_1 (0x18001000 + 0x0184)---

    r_ap2conn_CBIP_GALS_sideband_sample_sel[0] - (RW)  xxx 
    r_ap2conn_CBIP_GALS_sideband_slv_sync_sel[2..1] - (RW)  xxx 
    r_ap2conn_CBIP_GALS_sideband_mst_sync_sel[4..3] - (RW)  xxx 
    RESERVED5[31..5]             - (RO) Reserved bits

 =====================================================================================*/
#define CONN_INFRA_CFG_CONN_INFRA_GALS_AP2CONN_CTRL_1_r_ap2conn_CBIP_GALS_sideband_mst_sync_sel_ADDR CONN_INFRA_CFG_CONN_INFRA_GALS_AP2CONN_CTRL_1_ADDR
#define CONN_INFRA_CFG_CONN_INFRA_GALS_AP2CONN_CTRL_1_r_ap2conn_CBIP_GALS_sideband_mst_sync_sel_MASK 0x00000018                // r_ap2conn_CBIP_GALS_sideband_mst_sync_sel[4..3]
#define CONN_INFRA_CFG_CONN_INFRA_GALS_AP2CONN_CTRL_1_r_ap2conn_CBIP_GALS_sideband_mst_sync_sel_SHFT 3
#define CONN_INFRA_CFG_CONN_INFRA_GALS_AP2CONN_CTRL_1_r_ap2conn_CBIP_GALS_sideband_slv_sync_sel_ADDR CONN_INFRA_CFG_CONN_INFRA_GALS_AP2CONN_CTRL_1_ADDR
#define CONN_INFRA_CFG_CONN_INFRA_GALS_AP2CONN_CTRL_1_r_ap2conn_CBIP_GALS_sideband_slv_sync_sel_MASK 0x00000006                // r_ap2conn_CBIP_GALS_sideband_slv_sync_sel[2..1]
#define CONN_INFRA_CFG_CONN_INFRA_GALS_AP2CONN_CTRL_1_r_ap2conn_CBIP_GALS_sideband_slv_sync_sel_SHFT 1
#define CONN_INFRA_CFG_CONN_INFRA_GALS_AP2CONN_CTRL_1_r_ap2conn_CBIP_GALS_sideband_sample_sel_ADDR CONN_INFRA_CFG_CONN_INFRA_GALS_AP2CONN_CTRL_1_ADDR
#define CONN_INFRA_CFG_CONN_INFRA_GALS_AP2CONN_CTRL_1_r_ap2conn_CBIP_GALS_sideband_sample_sel_MASK 0x00000001                // r_ap2conn_CBIP_GALS_sideband_sample_sel[0]
#define CONN_INFRA_CFG_CONN_INFRA_GALS_AP2CONN_CTRL_1_r_ap2conn_CBIP_GALS_sideband_sample_sel_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_GALS_CONN2AP_CTRL_0 (0x18001000 + 0x0188)---

    ro_conn2ap_CBIP_GALS_sideband_gals_axi_dbg_mst[31..0] - (RO)  xxx 

 =====================================================================================*/
#define CONN_INFRA_CFG_CONN_INFRA_GALS_CONN2AP_CTRL_0_ro_conn2ap_CBIP_GALS_sideband_gals_axi_dbg_mst_ADDR CONN_INFRA_CFG_CONN_INFRA_GALS_CONN2AP_CTRL_0_ADDR
#define CONN_INFRA_CFG_CONN_INFRA_GALS_CONN2AP_CTRL_0_ro_conn2ap_CBIP_GALS_sideband_gals_axi_dbg_mst_MASK 0xFFFFFFFF                // ro_conn2ap_CBIP_GALS_sideband_gals_axi_dbg_mst[31..0]
#define CONN_INFRA_CFG_CONN_INFRA_GALS_CONN2AP_CTRL_0_ro_conn2ap_CBIP_GALS_sideband_gals_axi_dbg_mst_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_GALS_CONN2AP_CTRL_1 (0x18001000 + 0x018C)---

    r_conn2ap_CBIP_GALS_sideband_sample_sel[0] - (RW)  xxx 
    r_conn2ap_CBIP_GALS_sideband_slv_sync_sel[2..1] - (RW)  xxx 
    r_conn2ap_CBIP_GALS_sideband_mst_sync_sel[4..3] - (RW)  xxx 
    ro_conn2ap_CBIP_GALS_sideband_slpprot_rdy[5] - (RO)  xxx 
    r_conn2ap_CBIP_GALS_sideband_slpprot_en[6] - (RW)  xxx 
    r_conn2ap_CBIP_GALS_sideband_in_awflush_thre[8..7] - (RW)  xxx 
    r_conn2ap_CBIP_GALS_sideband_in_arflush_thre[10..9] - (RW)  xxx 
    RESERVED11[31..11]           - (RO) Reserved bits

 =====================================================================================*/
#define CONN_INFRA_CFG_CONN_INFRA_GALS_CONN2AP_CTRL_1_r_conn2ap_CBIP_GALS_sideband_in_arflush_thre_ADDR CONN_INFRA_CFG_CONN_INFRA_GALS_CONN2AP_CTRL_1_ADDR
#define CONN_INFRA_CFG_CONN_INFRA_GALS_CONN2AP_CTRL_1_r_conn2ap_CBIP_GALS_sideband_in_arflush_thre_MASK 0x00000600                // r_conn2ap_CBIP_GALS_sideband_in_arflush_thre[10..9]
#define CONN_INFRA_CFG_CONN_INFRA_GALS_CONN2AP_CTRL_1_r_conn2ap_CBIP_GALS_sideband_in_arflush_thre_SHFT 9
#define CONN_INFRA_CFG_CONN_INFRA_GALS_CONN2AP_CTRL_1_r_conn2ap_CBIP_GALS_sideband_in_awflush_thre_ADDR CONN_INFRA_CFG_CONN_INFRA_GALS_CONN2AP_CTRL_1_ADDR
#define CONN_INFRA_CFG_CONN_INFRA_GALS_CONN2AP_CTRL_1_r_conn2ap_CBIP_GALS_sideband_in_awflush_thre_MASK 0x00000180                // r_conn2ap_CBIP_GALS_sideband_in_awflush_thre[8..7]
#define CONN_INFRA_CFG_CONN_INFRA_GALS_CONN2AP_CTRL_1_r_conn2ap_CBIP_GALS_sideband_in_awflush_thre_SHFT 7
#define CONN_INFRA_CFG_CONN_INFRA_GALS_CONN2AP_CTRL_1_r_conn2ap_CBIP_GALS_sideband_slpprot_en_ADDR CONN_INFRA_CFG_CONN_INFRA_GALS_CONN2AP_CTRL_1_ADDR
#define CONN_INFRA_CFG_CONN_INFRA_GALS_CONN2AP_CTRL_1_r_conn2ap_CBIP_GALS_sideband_slpprot_en_MASK 0x00000040                // r_conn2ap_CBIP_GALS_sideband_slpprot_en[6]
#define CONN_INFRA_CFG_CONN_INFRA_GALS_CONN2AP_CTRL_1_r_conn2ap_CBIP_GALS_sideband_slpprot_en_SHFT 6
#define CONN_INFRA_CFG_CONN_INFRA_GALS_CONN2AP_CTRL_1_ro_conn2ap_CBIP_GALS_sideband_slpprot_rdy_ADDR CONN_INFRA_CFG_CONN_INFRA_GALS_CONN2AP_CTRL_1_ADDR
#define CONN_INFRA_CFG_CONN_INFRA_GALS_CONN2AP_CTRL_1_ro_conn2ap_CBIP_GALS_sideband_slpprot_rdy_MASK 0x00000020                // ro_conn2ap_CBIP_GALS_sideband_slpprot_rdy[5]
#define CONN_INFRA_CFG_CONN_INFRA_GALS_CONN2AP_CTRL_1_ro_conn2ap_CBIP_GALS_sideband_slpprot_rdy_SHFT 5
#define CONN_INFRA_CFG_CONN_INFRA_GALS_CONN2AP_CTRL_1_r_conn2ap_CBIP_GALS_sideband_mst_sync_sel_ADDR CONN_INFRA_CFG_CONN_INFRA_GALS_CONN2AP_CTRL_1_ADDR
#define CONN_INFRA_CFG_CONN_INFRA_GALS_CONN2AP_CTRL_1_r_conn2ap_CBIP_GALS_sideband_mst_sync_sel_MASK 0x00000018                // r_conn2ap_CBIP_GALS_sideband_mst_sync_sel[4..3]
#define CONN_INFRA_CFG_CONN_INFRA_GALS_CONN2AP_CTRL_1_r_conn2ap_CBIP_GALS_sideband_mst_sync_sel_SHFT 3
#define CONN_INFRA_CFG_CONN_INFRA_GALS_CONN2AP_CTRL_1_r_conn2ap_CBIP_GALS_sideband_slv_sync_sel_ADDR CONN_INFRA_CFG_CONN_INFRA_GALS_CONN2AP_CTRL_1_ADDR
#define CONN_INFRA_CFG_CONN_INFRA_GALS_CONN2AP_CTRL_1_r_conn2ap_CBIP_GALS_sideband_slv_sync_sel_MASK 0x00000006                // r_conn2ap_CBIP_GALS_sideband_slv_sync_sel[2..1]
#define CONN_INFRA_CFG_CONN_INFRA_GALS_CONN2AP_CTRL_1_r_conn2ap_CBIP_GALS_sideband_slv_sync_sel_SHFT 1
#define CONN_INFRA_CFG_CONN_INFRA_GALS_CONN2AP_CTRL_1_r_conn2ap_CBIP_GALS_sideband_sample_sel_ADDR CONN_INFRA_CFG_CONN_INFRA_GALS_CONN2AP_CTRL_1_ADDR
#define CONN_INFRA_CFG_CONN_INFRA_GALS_CONN2AP_CTRL_1_r_conn2ap_CBIP_GALS_sideband_sample_sel_MASK 0x00000001                // r_conn2ap_CBIP_GALS_sideband_sample_sel[0]
#define CONN_INFRA_CFG_CONN_INFRA_GALS_CONN2AP_CTRL_1_r_conn2ap_CBIP_GALS_sideband_sample_sel_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_PCIE2AP_REMAP_0 (0x18001000 + 0x0190)---

    r_pcie2ap_public_remapping_0[15..0] - (RW)  xxx 
    r_pcie2ap_public_remapping_1[31..16] - (RW)  xxx 

 =====================================================================================*/
#define CONN_INFRA_CFG_CONN_INFRA_PCIE2AP_REMAP_0_r_pcie2ap_public_remapping_1_ADDR CONN_INFRA_CFG_CONN_INFRA_PCIE2AP_REMAP_0_ADDR
#define CONN_INFRA_CFG_CONN_INFRA_PCIE2AP_REMAP_0_r_pcie2ap_public_remapping_1_MASK 0xFFFF0000                // r_pcie2ap_public_remapping_1[31..16]
#define CONN_INFRA_CFG_CONN_INFRA_PCIE2AP_REMAP_0_r_pcie2ap_public_remapping_1_SHFT 16
#define CONN_INFRA_CFG_CONN_INFRA_PCIE2AP_REMAP_0_r_pcie2ap_public_remapping_0_ADDR CONN_INFRA_CFG_CONN_INFRA_PCIE2AP_REMAP_0_ADDR
#define CONN_INFRA_CFG_CONN_INFRA_PCIE2AP_REMAP_0_r_pcie2ap_public_remapping_0_MASK 0x0000FFFF                // r_pcie2ap_public_remapping_0[15..0]
#define CONN_INFRA_CFG_CONN_INFRA_PCIE2AP_REMAP_0_r_pcie2ap_public_remapping_0_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_PCIE2AP_REMAP_1 (0x18001000 + 0x0194)---

    r_pcie2ap_public_remapping_2[15..0] - (RW)  xxx 
    r_pcie2ap_public_remapping_3[31..16] - (RW)  xxx 

 =====================================================================================*/
#define CONN_INFRA_CFG_CONN_INFRA_PCIE2AP_REMAP_1_r_pcie2ap_public_remapping_3_ADDR CONN_INFRA_CFG_CONN_INFRA_PCIE2AP_REMAP_1_ADDR
#define CONN_INFRA_CFG_CONN_INFRA_PCIE2AP_REMAP_1_r_pcie2ap_public_remapping_3_MASK 0xFFFF0000                // r_pcie2ap_public_remapping_3[31..16]
#define CONN_INFRA_CFG_CONN_INFRA_PCIE2AP_REMAP_1_r_pcie2ap_public_remapping_3_SHFT 16
#define CONN_INFRA_CFG_CONN_INFRA_PCIE2AP_REMAP_1_r_pcie2ap_public_remapping_2_ADDR CONN_INFRA_CFG_CONN_INFRA_PCIE2AP_REMAP_1_ADDR
#define CONN_INFRA_CFG_CONN_INFRA_PCIE2AP_REMAP_1_r_pcie2ap_public_remapping_2_MASK 0x0000FFFF                // r_pcie2ap_public_remapping_2[15..0]
#define CONN_INFRA_CFG_CONN_INFRA_PCIE2AP_REMAP_1_r_pcie2ap_public_remapping_2_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_PCIE2AP_REMAP_2 (0x18001000 + 0x0198)---

    r_pcie2ap_public_remapping_4[15..0] - (RW)  xxx 
    r_pcie2ap_public_remapping_5[31..16] - (RW)  xxx 

 =====================================================================================*/
#define CONN_INFRA_CFG_CONN_INFRA_PCIE2AP_REMAP_2_r_pcie2ap_public_remapping_5_ADDR CONN_INFRA_CFG_CONN_INFRA_PCIE2AP_REMAP_2_ADDR
#define CONN_INFRA_CFG_CONN_INFRA_PCIE2AP_REMAP_2_r_pcie2ap_public_remapping_5_MASK 0xFFFF0000                // r_pcie2ap_public_remapping_5[31..16]
#define CONN_INFRA_CFG_CONN_INFRA_PCIE2AP_REMAP_2_r_pcie2ap_public_remapping_5_SHFT 16
#define CONN_INFRA_CFG_CONN_INFRA_PCIE2AP_REMAP_2_r_pcie2ap_public_remapping_4_ADDR CONN_INFRA_CFG_CONN_INFRA_PCIE2AP_REMAP_2_ADDR
#define CONN_INFRA_CFG_CONN_INFRA_PCIE2AP_REMAP_2_r_pcie2ap_public_remapping_4_MASK 0x0000FFFF                // r_pcie2ap_public_remapping_4[15..0]
#define CONN_INFRA_CFG_CONN_INFRA_PCIE2AP_REMAP_2_r_pcie2ap_public_remapping_4_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_PCIE2AP_REMAP_3 (0x18001000 + 0x019C)---

    r_pcie2ap_public_remapping_6[15..0] - (RW)  xxx 
    r_pcie2ap_public_remapping_7[31..16] - (RW)  xxx 

 =====================================================================================*/
#define CONN_INFRA_CFG_CONN_INFRA_PCIE2AP_REMAP_3_r_pcie2ap_public_remapping_7_ADDR CONN_INFRA_CFG_CONN_INFRA_PCIE2AP_REMAP_3_ADDR
#define CONN_INFRA_CFG_CONN_INFRA_PCIE2AP_REMAP_3_r_pcie2ap_public_remapping_7_MASK 0xFFFF0000                // r_pcie2ap_public_remapping_7[31..16]
#define CONN_INFRA_CFG_CONN_INFRA_PCIE2AP_REMAP_3_r_pcie2ap_public_remapping_7_SHFT 16
#define CONN_INFRA_CFG_CONN_INFRA_PCIE2AP_REMAP_3_r_pcie2ap_public_remapping_6_ADDR CONN_INFRA_CFG_CONN_INFRA_PCIE2AP_REMAP_3_ADDR
#define CONN_INFRA_CFG_CONN_INFRA_PCIE2AP_REMAP_3_r_pcie2ap_public_remapping_6_MASK 0x0000FFFF                // r_pcie2ap_public_remapping_6[15..0]
#define CONN_INFRA_CFG_CONN_INFRA_PCIE2AP_REMAP_3_r_pcie2ap_public_remapping_6_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_PCIE2AP_REMAP_4 (0x18001000 + 0x01A0)---

    r_pcie2ap_public_remapping_8[15..0] - (RW)  xxx 
    r_pcie2ap_public_remapping_9[31..16] - (RW)  xxx 

 =====================================================================================*/
#define CONN_INFRA_CFG_CONN_INFRA_PCIE2AP_REMAP_4_r_pcie2ap_public_remapping_9_ADDR CONN_INFRA_CFG_CONN_INFRA_PCIE2AP_REMAP_4_ADDR
#define CONN_INFRA_CFG_CONN_INFRA_PCIE2AP_REMAP_4_r_pcie2ap_public_remapping_9_MASK 0xFFFF0000                // r_pcie2ap_public_remapping_9[31..16]
#define CONN_INFRA_CFG_CONN_INFRA_PCIE2AP_REMAP_4_r_pcie2ap_public_remapping_9_SHFT 16
#define CONN_INFRA_CFG_CONN_INFRA_PCIE2AP_REMAP_4_r_pcie2ap_public_remapping_8_ADDR CONN_INFRA_CFG_CONN_INFRA_PCIE2AP_REMAP_4_ADDR
#define CONN_INFRA_CFG_CONN_INFRA_PCIE2AP_REMAP_4_r_pcie2ap_public_remapping_8_MASK 0x0000FFFF                // r_pcie2ap_public_remapping_8[15..0]
#define CONN_INFRA_CFG_CONN_INFRA_PCIE2AP_REMAP_4_r_pcie2ap_public_remapping_8_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_PCIE2AP_REMAP_5 (0x18001000 + 0x01A4)---

    r_pcie2ap_public_remapping_a[15..0] - (RW)  xxx 
    r_pcie2ap_public_remapping_b[31..16] - (RW)  xxx 

 =====================================================================================*/
#define CONN_INFRA_CFG_CONN_INFRA_PCIE2AP_REMAP_5_r_pcie2ap_public_remapping_b_ADDR CONN_INFRA_CFG_CONN_INFRA_PCIE2AP_REMAP_5_ADDR
#define CONN_INFRA_CFG_CONN_INFRA_PCIE2AP_REMAP_5_r_pcie2ap_public_remapping_b_MASK 0xFFFF0000                // r_pcie2ap_public_remapping_b[31..16]
#define CONN_INFRA_CFG_CONN_INFRA_PCIE2AP_REMAP_5_r_pcie2ap_public_remapping_b_SHFT 16
#define CONN_INFRA_CFG_CONN_INFRA_PCIE2AP_REMAP_5_r_pcie2ap_public_remapping_a_ADDR CONN_INFRA_CFG_CONN_INFRA_PCIE2AP_REMAP_5_ADDR
#define CONN_INFRA_CFG_CONN_INFRA_PCIE2AP_REMAP_5_r_pcie2ap_public_remapping_a_MASK 0x0000FFFF                // r_pcie2ap_public_remapping_a[15..0]
#define CONN_INFRA_CFG_CONN_INFRA_PCIE2AP_REMAP_5_r_pcie2ap_public_remapping_a_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_PCIE2AP_REMAP_6 (0x18001000 + 0x01A8)---

    r_pcie2ap_public_remapping_c[15..0] - (RW)  xxx 
    r_pcie2ap_public_remapping_d[31..16] - (RW)  xxx 

 =====================================================================================*/
#define CONN_INFRA_CFG_CONN_INFRA_PCIE2AP_REMAP_6_r_pcie2ap_public_remapping_d_ADDR CONN_INFRA_CFG_CONN_INFRA_PCIE2AP_REMAP_6_ADDR
#define CONN_INFRA_CFG_CONN_INFRA_PCIE2AP_REMAP_6_r_pcie2ap_public_remapping_d_MASK 0xFFFF0000                // r_pcie2ap_public_remapping_d[31..16]
#define CONN_INFRA_CFG_CONN_INFRA_PCIE2AP_REMAP_6_r_pcie2ap_public_remapping_d_SHFT 16
#define CONN_INFRA_CFG_CONN_INFRA_PCIE2AP_REMAP_6_r_pcie2ap_public_remapping_c_ADDR CONN_INFRA_CFG_CONN_INFRA_PCIE2AP_REMAP_6_ADDR
#define CONN_INFRA_CFG_CONN_INFRA_PCIE2AP_REMAP_6_r_pcie2ap_public_remapping_c_MASK 0x0000FFFF                // r_pcie2ap_public_remapping_c[15..0]
#define CONN_INFRA_CFG_CONN_INFRA_PCIE2AP_REMAP_6_r_pcie2ap_public_remapping_c_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_PCIE2AP_REMAP_7 (0x18001000 + 0x01AC)---

    r_pcie2ap_public_remapping_e[15..0] - (RW)  xxx 
    r_pcie2ap_public_remapping_f[31..16] - (RO)  xxx 

 =====================================================================================*/
#define CONN_INFRA_CFG_CONN_INFRA_PCIE2AP_REMAP_7_r_pcie2ap_public_remapping_f_ADDR CONN_INFRA_CFG_CONN_INFRA_PCIE2AP_REMAP_7_ADDR
#define CONN_INFRA_CFG_CONN_INFRA_PCIE2AP_REMAP_7_r_pcie2ap_public_remapping_f_MASK 0xFFFF0000                // r_pcie2ap_public_remapping_f[31..16]
#define CONN_INFRA_CFG_CONN_INFRA_PCIE2AP_REMAP_7_r_pcie2ap_public_remapping_f_SHFT 16
#define CONN_INFRA_CFG_CONN_INFRA_PCIE2AP_REMAP_7_r_pcie2ap_public_remapping_e_ADDR CONN_INFRA_CFG_CONN_INFRA_PCIE2AP_REMAP_7_ADDR
#define CONN_INFRA_CFG_CONN_INFRA_PCIE2AP_REMAP_7_r_pcie2ap_public_remapping_e_MASK 0x0000FFFF                // r_pcie2ap_public_remapping_e[15..0]
#define CONN_INFRA_CFG_CONN_INFRA_PCIE2AP_REMAP_7_r_pcie2ap_public_remapping_e_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_LEGACY_REMAP_CTRL_0 (0x18001000 + 0x01B0)---

    r_connac_legacy_ap2wf_addr_map0[19..0] - (RW)  xxx 
    RESERVED20[31..20]           - (RO) Reserved bits

 =====================================================================================*/
#define CONN_INFRA_CFG_CONN_INFRA_LEGACY_REMAP_CTRL_0_r_connac_legacy_ap2wf_addr_map0_ADDR CONN_INFRA_CFG_CONN_INFRA_LEGACY_REMAP_CTRL_0_ADDR
#define CONN_INFRA_CFG_CONN_INFRA_LEGACY_REMAP_CTRL_0_r_connac_legacy_ap2wf_addr_map0_MASK 0x000FFFFF                // r_connac_legacy_ap2wf_addr_map0[19..0]
#define CONN_INFRA_CFG_CONN_INFRA_LEGACY_REMAP_CTRL_0_r_connac_legacy_ap2wf_addr_map0_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_LEGACY_REMAP_CTRL_1 (0x18001000 + 0x01B4)---

    r_connac_legacy_ap2wf_addr_map1[19..0] - (RW)  xxx 
    RESERVED20[31..20]           - (RO) Reserved bits

 =====================================================================================*/
#define CONN_INFRA_CFG_CONN_INFRA_LEGACY_REMAP_CTRL_1_r_connac_legacy_ap2wf_addr_map1_ADDR CONN_INFRA_CFG_CONN_INFRA_LEGACY_REMAP_CTRL_1_ADDR
#define CONN_INFRA_CFG_CONN_INFRA_LEGACY_REMAP_CTRL_1_r_connac_legacy_ap2wf_addr_map1_MASK 0x000FFFFF                // r_connac_legacy_ap2wf_addr_map1[19..0]
#define CONN_INFRA_CFG_CONN_INFRA_LEGACY_REMAP_CTRL_1_r_connac_legacy_ap2wf_addr_map1_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_LEGACY_REMAP_CTRL_2 (0x18001000 + 0x01B8)---

    r_connac_legacy_ap2wf_addr_map2[15..0] - (RW)  xxx 
    r_connac_legacy_ap2wf_addr_map3[31..16] - (RW)  xxx 

 =====================================================================================*/
#define CONN_INFRA_CFG_CONN_INFRA_LEGACY_REMAP_CTRL_2_r_connac_legacy_ap2wf_addr_map3_ADDR CONN_INFRA_CFG_CONN_INFRA_LEGACY_REMAP_CTRL_2_ADDR
#define CONN_INFRA_CFG_CONN_INFRA_LEGACY_REMAP_CTRL_2_r_connac_legacy_ap2wf_addr_map3_MASK 0xFFFF0000                // r_connac_legacy_ap2wf_addr_map3[31..16]
#define CONN_INFRA_CFG_CONN_INFRA_LEGACY_REMAP_CTRL_2_r_connac_legacy_ap2wf_addr_map3_SHFT 16
#define CONN_INFRA_CFG_CONN_INFRA_LEGACY_REMAP_CTRL_2_r_connac_legacy_ap2wf_addr_map2_ADDR CONN_INFRA_CFG_CONN_INFRA_LEGACY_REMAP_CTRL_2_ADDR
#define CONN_INFRA_CFG_CONN_INFRA_LEGACY_REMAP_CTRL_2_r_connac_legacy_ap2wf_addr_map2_MASK 0x0000FFFF                // r_connac_legacy_ap2wf_addr_map2[15..0]
#define CONN_INFRA_CFG_CONN_INFRA_LEGACY_REMAP_CTRL_2_r_connac_legacy_ap2wf_addr_map2_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_LEGACY_REMAP_CTRL_3 (0x18001000 + 0x01BC)---

    r_connac_legacy_ap2wf_addr_map4[15..0] - (RW)  xxx 
    r_connac_legacy_ap2wf_addr_map5[31..16] - (RW)  xxx 

 =====================================================================================*/
#define CONN_INFRA_CFG_CONN_INFRA_LEGACY_REMAP_CTRL_3_r_connac_legacy_ap2wf_addr_map5_ADDR CONN_INFRA_CFG_CONN_INFRA_LEGACY_REMAP_CTRL_3_ADDR
#define CONN_INFRA_CFG_CONN_INFRA_LEGACY_REMAP_CTRL_3_r_connac_legacy_ap2wf_addr_map5_MASK 0xFFFF0000                // r_connac_legacy_ap2wf_addr_map5[31..16]
#define CONN_INFRA_CFG_CONN_INFRA_LEGACY_REMAP_CTRL_3_r_connac_legacy_ap2wf_addr_map5_SHFT 16
#define CONN_INFRA_CFG_CONN_INFRA_LEGACY_REMAP_CTRL_3_r_connac_legacy_ap2wf_addr_map4_ADDR CONN_INFRA_CFG_CONN_INFRA_LEGACY_REMAP_CTRL_3_ADDR
#define CONN_INFRA_CFG_CONN_INFRA_LEGACY_REMAP_CTRL_3_r_connac_legacy_ap2wf_addr_map4_MASK 0x0000FFFF                // r_connac_legacy_ap2wf_addr_map4[15..0]
#define CONN_INFRA_CFG_CONN_INFRA_LEGACY_REMAP_CTRL_3_r_connac_legacy_ap2wf_addr_map4_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_LEGACY_REMAP_CTRL_4 (0x18001000 + 0x01C0)---

    r_connac_legacy_ap2wf_addr_map6[15..0] - (RW)  xxx 
    r_connac_legacy_ap2wf_addr_map7[31..16] - (RW)  xxx 

 =====================================================================================*/
#define CONN_INFRA_CFG_CONN_INFRA_LEGACY_REMAP_CTRL_4_r_connac_legacy_ap2wf_addr_map7_ADDR CONN_INFRA_CFG_CONN_INFRA_LEGACY_REMAP_CTRL_4_ADDR
#define CONN_INFRA_CFG_CONN_INFRA_LEGACY_REMAP_CTRL_4_r_connac_legacy_ap2wf_addr_map7_MASK 0xFFFF0000                // r_connac_legacy_ap2wf_addr_map7[31..16]
#define CONN_INFRA_CFG_CONN_INFRA_LEGACY_REMAP_CTRL_4_r_connac_legacy_ap2wf_addr_map7_SHFT 16
#define CONN_INFRA_CFG_CONN_INFRA_LEGACY_REMAP_CTRL_4_r_connac_legacy_ap2wf_addr_map6_ADDR CONN_INFRA_CFG_CONN_INFRA_LEGACY_REMAP_CTRL_4_ADDR
#define CONN_INFRA_CFG_CONN_INFRA_LEGACY_REMAP_CTRL_4_r_connac_legacy_ap2wf_addr_map6_MASK 0x0000FFFF                // r_connac_legacy_ap2wf_addr_map6[15..0]
#define CONN_INFRA_CFG_CONN_INFRA_LEGACY_REMAP_CTRL_4_r_connac_legacy_ap2wf_addr_map6_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_LEGACY_REMAP_CTRL_5 (0x18001000 + 0x01C4)---

    r_connac_legacy_ap2wf_addr_map8[15..0] - (RW)  xxx 
    r_connac_legacy_ap2wf_addr_map9[31..16] - (RW)  xxx 

 =====================================================================================*/
#define CONN_INFRA_CFG_CONN_INFRA_LEGACY_REMAP_CTRL_5_r_connac_legacy_ap2wf_addr_map9_ADDR CONN_INFRA_CFG_CONN_INFRA_LEGACY_REMAP_CTRL_5_ADDR
#define CONN_INFRA_CFG_CONN_INFRA_LEGACY_REMAP_CTRL_5_r_connac_legacy_ap2wf_addr_map9_MASK 0xFFFF0000                // r_connac_legacy_ap2wf_addr_map9[31..16]
#define CONN_INFRA_CFG_CONN_INFRA_LEGACY_REMAP_CTRL_5_r_connac_legacy_ap2wf_addr_map9_SHFT 16
#define CONN_INFRA_CFG_CONN_INFRA_LEGACY_REMAP_CTRL_5_r_connac_legacy_ap2wf_addr_map8_ADDR CONN_INFRA_CFG_CONN_INFRA_LEGACY_REMAP_CTRL_5_ADDR
#define CONN_INFRA_CFG_CONN_INFRA_LEGACY_REMAP_CTRL_5_r_connac_legacy_ap2wf_addr_map8_MASK 0x0000FFFF                // r_connac_legacy_ap2wf_addr_map8[15..0]
#define CONN_INFRA_CFG_CONN_INFRA_LEGACY_REMAP_CTRL_5_r_connac_legacy_ap2wf_addr_map8_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_LEGACY_REMAP_CTRL_6 (0x18001000 + 0x01C8)---

    r_connac_legacy_ap2bgf_mapper_enable[0] - (RW)  xxx 
    r_connac_legacy_ap2wf_mapper_enable[1] - (RW)  xxx 
    RESERVED2[31..2]             - (RO) Reserved bits

 =====================================================================================*/
#define CONN_INFRA_CFG_CONN_INFRA_LEGACY_REMAP_CTRL_6_r_connac_legacy_ap2wf_mapper_enable_ADDR CONN_INFRA_CFG_CONN_INFRA_LEGACY_REMAP_CTRL_6_ADDR
#define CONN_INFRA_CFG_CONN_INFRA_LEGACY_REMAP_CTRL_6_r_connac_legacy_ap2wf_mapper_enable_MASK 0x00000002                // r_connac_legacy_ap2wf_mapper_enable[1]
#define CONN_INFRA_CFG_CONN_INFRA_LEGACY_REMAP_CTRL_6_r_connac_legacy_ap2wf_mapper_enable_SHFT 1
#define CONN_INFRA_CFG_CONN_INFRA_LEGACY_REMAP_CTRL_6_r_connac_legacy_ap2bgf_mapper_enable_ADDR CONN_INFRA_CFG_CONN_INFRA_LEGACY_REMAP_CTRL_6_ADDR
#define CONN_INFRA_CFG_CONN_INFRA_LEGACY_REMAP_CTRL_6_r_connac_legacy_ap2bgf_mapper_enable_MASK 0x00000001                // r_connac_legacy_ap2bgf_mapper_enable[0]
#define CONN_INFRA_CFG_CONN_INFRA_LEGACY_REMAP_CTRL_6_r_connac_legacy_ap2bgf_mapper_enable_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_SYSRAM_CTRL_0 (0x18001000 + 0x0500)---

    r_conn_infra_sysram_sramrom_ram_mbist_background[15..0] - (RW)  xxx 
    r_conn_infra_sysram_sramrom_ram_delsel[31..16] - (RW)  xxx 

 =====================================================================================*/
#define CONN_INFRA_CFG_CONN_INFRA_SYSRAM_CTRL_0_r_conn_infra_sysram_sramrom_ram_delsel_ADDR CONN_INFRA_CFG_CONN_INFRA_SYSRAM_CTRL_0_ADDR
#define CONN_INFRA_CFG_CONN_INFRA_SYSRAM_CTRL_0_r_conn_infra_sysram_sramrom_ram_delsel_MASK 0xFFFF0000                // r_conn_infra_sysram_sramrom_ram_delsel[31..16]
#define CONN_INFRA_CFG_CONN_INFRA_SYSRAM_CTRL_0_r_conn_infra_sysram_sramrom_ram_delsel_SHFT 16
#define CONN_INFRA_CFG_CONN_INFRA_SYSRAM_CTRL_0_r_conn_infra_sysram_sramrom_ram_mbist_background_ADDR CONN_INFRA_CFG_CONN_INFRA_SYSRAM_CTRL_0_ADDR
#define CONN_INFRA_CFG_CONN_INFRA_SYSRAM_CTRL_0_r_conn_infra_sysram_sramrom_ram_mbist_background_MASK 0x0000FFFF                // r_conn_infra_sysram_sramrom_ram_mbist_background[15..0]
#define CONN_INFRA_CFG_CONN_INFRA_SYSRAM_CTRL_0_r_conn_infra_sysram_sramrom_ram_mbist_background_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_SYSRAM_CTRL_1 (0x18001000 + 0x0504)---

    r_conn_infra_sysram_cg_disable[0] - (RW)  xxx 
    r_conn_infra_sysram_mbist_use_default_delsel[1] - (RW)  xxx 
    r_conn_infra_sysram_mbist_bsel[5..2] - (RW)  xxx 
    r_conn_infra_sysram_sramrom_ram_mbist_mode[6] - (RW)  xxx 
    r_conn_infra_sysram_sramrom_ram_mbist_sleep_w[7] - (RW)  xxx 
    r_conn_infra_sysram_sramrom_ram_mbist_sleep_r[8] - (RW)  xxx 
    r_conn_infra_sysram_sramrom_ram_mbist_sleep_inv[9] - (RW)  xxx 
    r_conn_infra_sysram_sramrom_ram_mbist_sleep_test[10] - (RW)  xxx 
    r_conn_infra_sysram_sramrom_ram_mbist_debug[11] - (RW)  xxx 
    r_conn_infra_sysram_sramrom_ram_mbist_holdb[12] - (RW)  xxx 
    r_conn_infra_sysram_sramrom_ram_mbist_fail[20..13] - (RO)  xxx 
    r_conn_infra_sysram_sramrom_ram_mbist_done[21] - (RO)  xxx 
    RESERVED22[31..22]           - (RO) Reserved bits

 =====================================================================================*/
#define CONN_INFRA_CFG_CONN_INFRA_SYSRAM_CTRL_1_r_conn_infra_sysram_sramrom_ram_mbist_done_ADDR CONN_INFRA_CFG_CONN_INFRA_SYSRAM_CTRL_1_ADDR
#define CONN_INFRA_CFG_CONN_INFRA_SYSRAM_CTRL_1_r_conn_infra_sysram_sramrom_ram_mbist_done_MASK 0x00200000                // r_conn_infra_sysram_sramrom_ram_mbist_done[21]
#define CONN_INFRA_CFG_CONN_INFRA_SYSRAM_CTRL_1_r_conn_infra_sysram_sramrom_ram_mbist_done_SHFT 21
#define CONN_INFRA_CFG_CONN_INFRA_SYSRAM_CTRL_1_r_conn_infra_sysram_sramrom_ram_mbist_fail_ADDR CONN_INFRA_CFG_CONN_INFRA_SYSRAM_CTRL_1_ADDR
#define CONN_INFRA_CFG_CONN_INFRA_SYSRAM_CTRL_1_r_conn_infra_sysram_sramrom_ram_mbist_fail_MASK 0x001FE000                // r_conn_infra_sysram_sramrom_ram_mbist_fail[20..13]
#define CONN_INFRA_CFG_CONN_INFRA_SYSRAM_CTRL_1_r_conn_infra_sysram_sramrom_ram_mbist_fail_SHFT 13
#define CONN_INFRA_CFG_CONN_INFRA_SYSRAM_CTRL_1_r_conn_infra_sysram_sramrom_ram_mbist_holdb_ADDR CONN_INFRA_CFG_CONN_INFRA_SYSRAM_CTRL_1_ADDR
#define CONN_INFRA_CFG_CONN_INFRA_SYSRAM_CTRL_1_r_conn_infra_sysram_sramrom_ram_mbist_holdb_MASK 0x00001000                // r_conn_infra_sysram_sramrom_ram_mbist_holdb[12]
#define CONN_INFRA_CFG_CONN_INFRA_SYSRAM_CTRL_1_r_conn_infra_sysram_sramrom_ram_mbist_holdb_SHFT 12
#define CONN_INFRA_CFG_CONN_INFRA_SYSRAM_CTRL_1_r_conn_infra_sysram_sramrom_ram_mbist_debug_ADDR CONN_INFRA_CFG_CONN_INFRA_SYSRAM_CTRL_1_ADDR
#define CONN_INFRA_CFG_CONN_INFRA_SYSRAM_CTRL_1_r_conn_infra_sysram_sramrom_ram_mbist_debug_MASK 0x00000800                // r_conn_infra_sysram_sramrom_ram_mbist_debug[11]
#define CONN_INFRA_CFG_CONN_INFRA_SYSRAM_CTRL_1_r_conn_infra_sysram_sramrom_ram_mbist_debug_SHFT 11
#define CONN_INFRA_CFG_CONN_INFRA_SYSRAM_CTRL_1_r_conn_infra_sysram_sramrom_ram_mbist_sleep_test_ADDR CONN_INFRA_CFG_CONN_INFRA_SYSRAM_CTRL_1_ADDR
#define CONN_INFRA_CFG_CONN_INFRA_SYSRAM_CTRL_1_r_conn_infra_sysram_sramrom_ram_mbist_sleep_test_MASK 0x00000400                // r_conn_infra_sysram_sramrom_ram_mbist_sleep_test[10]
#define CONN_INFRA_CFG_CONN_INFRA_SYSRAM_CTRL_1_r_conn_infra_sysram_sramrom_ram_mbist_sleep_test_SHFT 10
#define CONN_INFRA_CFG_CONN_INFRA_SYSRAM_CTRL_1_r_conn_infra_sysram_sramrom_ram_mbist_sleep_inv_ADDR CONN_INFRA_CFG_CONN_INFRA_SYSRAM_CTRL_1_ADDR
#define CONN_INFRA_CFG_CONN_INFRA_SYSRAM_CTRL_1_r_conn_infra_sysram_sramrom_ram_mbist_sleep_inv_MASK 0x00000200                // r_conn_infra_sysram_sramrom_ram_mbist_sleep_inv[9]
#define CONN_INFRA_CFG_CONN_INFRA_SYSRAM_CTRL_1_r_conn_infra_sysram_sramrom_ram_mbist_sleep_inv_SHFT 9
#define CONN_INFRA_CFG_CONN_INFRA_SYSRAM_CTRL_1_r_conn_infra_sysram_sramrom_ram_mbist_sleep_r_ADDR CONN_INFRA_CFG_CONN_INFRA_SYSRAM_CTRL_1_ADDR
#define CONN_INFRA_CFG_CONN_INFRA_SYSRAM_CTRL_1_r_conn_infra_sysram_sramrom_ram_mbist_sleep_r_MASK 0x00000100                // r_conn_infra_sysram_sramrom_ram_mbist_sleep_r[8]
#define CONN_INFRA_CFG_CONN_INFRA_SYSRAM_CTRL_1_r_conn_infra_sysram_sramrom_ram_mbist_sleep_r_SHFT 8
#define CONN_INFRA_CFG_CONN_INFRA_SYSRAM_CTRL_1_r_conn_infra_sysram_sramrom_ram_mbist_sleep_w_ADDR CONN_INFRA_CFG_CONN_INFRA_SYSRAM_CTRL_1_ADDR
#define CONN_INFRA_CFG_CONN_INFRA_SYSRAM_CTRL_1_r_conn_infra_sysram_sramrom_ram_mbist_sleep_w_MASK 0x00000080                // r_conn_infra_sysram_sramrom_ram_mbist_sleep_w[7]
#define CONN_INFRA_CFG_CONN_INFRA_SYSRAM_CTRL_1_r_conn_infra_sysram_sramrom_ram_mbist_sleep_w_SHFT 7
#define CONN_INFRA_CFG_CONN_INFRA_SYSRAM_CTRL_1_r_conn_infra_sysram_sramrom_ram_mbist_mode_ADDR CONN_INFRA_CFG_CONN_INFRA_SYSRAM_CTRL_1_ADDR
#define CONN_INFRA_CFG_CONN_INFRA_SYSRAM_CTRL_1_r_conn_infra_sysram_sramrom_ram_mbist_mode_MASK 0x00000040                // r_conn_infra_sysram_sramrom_ram_mbist_mode[6]
#define CONN_INFRA_CFG_CONN_INFRA_SYSRAM_CTRL_1_r_conn_infra_sysram_sramrom_ram_mbist_mode_SHFT 6
#define CONN_INFRA_CFG_CONN_INFRA_SYSRAM_CTRL_1_r_conn_infra_sysram_mbist_bsel_ADDR CONN_INFRA_CFG_CONN_INFRA_SYSRAM_CTRL_1_ADDR
#define CONN_INFRA_CFG_CONN_INFRA_SYSRAM_CTRL_1_r_conn_infra_sysram_mbist_bsel_MASK 0x0000003C                // r_conn_infra_sysram_mbist_bsel[5..2]
#define CONN_INFRA_CFG_CONN_INFRA_SYSRAM_CTRL_1_r_conn_infra_sysram_mbist_bsel_SHFT 2
#define CONN_INFRA_CFG_CONN_INFRA_SYSRAM_CTRL_1_r_conn_infra_sysram_mbist_use_default_delsel_ADDR CONN_INFRA_CFG_CONN_INFRA_SYSRAM_CTRL_1_ADDR
#define CONN_INFRA_CFG_CONN_INFRA_SYSRAM_CTRL_1_r_conn_infra_sysram_mbist_use_default_delsel_MASK 0x00000002                // r_conn_infra_sysram_mbist_use_default_delsel[1]
#define CONN_INFRA_CFG_CONN_INFRA_SYSRAM_CTRL_1_r_conn_infra_sysram_mbist_use_default_delsel_SHFT 1
#define CONN_INFRA_CFG_CONN_INFRA_SYSRAM_CTRL_1_r_conn_infra_sysram_cg_disable_ADDR CONN_INFRA_CFG_CONN_INFRA_SYSRAM_CTRL_1_ADDR
#define CONN_INFRA_CFG_CONN_INFRA_SYSRAM_CTRL_1_r_conn_infra_sysram_cg_disable_MASK 0x00000001                // r_conn_infra_sysram_cg_disable[0]
#define CONN_INFRA_CFG_CONN_INFRA_SYSRAM_CTRL_1_r_conn_infra_sysram_cg_disable_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_SLP_PROT_DBG_BGF (0x18001000 + 0x0600)---

    r_conn_infra_bus_slp_prot_dbg_bgf_m_req[0] - (RW)  xxx 
    r_conn_infra_bus_slp_prot_dbg_bgf_r_req[1] - (RW)  xxx 
    r_conn_infra_bus_slp_prot_dbg_bgf_s_req[2] - (RW)  xxx 
    ro_conn_infra_bus_slp_prot_bgf_m_ack[3] - (RO)  xxx 
    ro_conn_infra_bus_slp_prot_bgf_m_req[4] - (RO)  xxx 
    ro_conn_infra_bus_slp_prot_bgf_r_ack[5] - (RO)  xxx 
    ro_conn_infra_bus_slp_prot_bgf_r_req[6] - (RO)  xxx 
    ro_conn_infra_bus_slp_prot_bgf_s_ack[7] - (RO)  xxx 
    ro_conn_infra_bus_slp_prot_bgf_s_req[8] - (RO)  xxx 
    RESERVED9[31..9]             - (RO) Reserved bits

 =====================================================================================*/
#define CONN_INFRA_CFG_CONN_INFRA_SLP_PROT_DBG_BGF_ro_conn_infra_bus_slp_prot_bgf_s_req_ADDR CONN_INFRA_CFG_CONN_INFRA_SLP_PROT_DBG_BGF_ADDR
#define CONN_INFRA_CFG_CONN_INFRA_SLP_PROT_DBG_BGF_ro_conn_infra_bus_slp_prot_bgf_s_req_MASK 0x00000100                // ro_conn_infra_bus_slp_prot_bgf_s_req[8]
#define CONN_INFRA_CFG_CONN_INFRA_SLP_PROT_DBG_BGF_ro_conn_infra_bus_slp_prot_bgf_s_req_SHFT 8
#define CONN_INFRA_CFG_CONN_INFRA_SLP_PROT_DBG_BGF_ro_conn_infra_bus_slp_prot_bgf_s_ack_ADDR CONN_INFRA_CFG_CONN_INFRA_SLP_PROT_DBG_BGF_ADDR
#define CONN_INFRA_CFG_CONN_INFRA_SLP_PROT_DBG_BGF_ro_conn_infra_bus_slp_prot_bgf_s_ack_MASK 0x00000080                // ro_conn_infra_bus_slp_prot_bgf_s_ack[7]
#define CONN_INFRA_CFG_CONN_INFRA_SLP_PROT_DBG_BGF_ro_conn_infra_bus_slp_prot_bgf_s_ack_SHFT 7
#define CONN_INFRA_CFG_CONN_INFRA_SLP_PROT_DBG_BGF_ro_conn_infra_bus_slp_prot_bgf_r_req_ADDR CONN_INFRA_CFG_CONN_INFRA_SLP_PROT_DBG_BGF_ADDR
#define CONN_INFRA_CFG_CONN_INFRA_SLP_PROT_DBG_BGF_ro_conn_infra_bus_slp_prot_bgf_r_req_MASK 0x00000040                // ro_conn_infra_bus_slp_prot_bgf_r_req[6]
#define CONN_INFRA_CFG_CONN_INFRA_SLP_PROT_DBG_BGF_ro_conn_infra_bus_slp_prot_bgf_r_req_SHFT 6
#define CONN_INFRA_CFG_CONN_INFRA_SLP_PROT_DBG_BGF_ro_conn_infra_bus_slp_prot_bgf_r_ack_ADDR CONN_INFRA_CFG_CONN_INFRA_SLP_PROT_DBG_BGF_ADDR
#define CONN_INFRA_CFG_CONN_INFRA_SLP_PROT_DBG_BGF_ro_conn_infra_bus_slp_prot_bgf_r_ack_MASK 0x00000020                // ro_conn_infra_bus_slp_prot_bgf_r_ack[5]
#define CONN_INFRA_CFG_CONN_INFRA_SLP_PROT_DBG_BGF_ro_conn_infra_bus_slp_prot_bgf_r_ack_SHFT 5
#define CONN_INFRA_CFG_CONN_INFRA_SLP_PROT_DBG_BGF_ro_conn_infra_bus_slp_prot_bgf_m_req_ADDR CONN_INFRA_CFG_CONN_INFRA_SLP_PROT_DBG_BGF_ADDR
#define CONN_INFRA_CFG_CONN_INFRA_SLP_PROT_DBG_BGF_ro_conn_infra_bus_slp_prot_bgf_m_req_MASK 0x00000010                // ro_conn_infra_bus_slp_prot_bgf_m_req[4]
#define CONN_INFRA_CFG_CONN_INFRA_SLP_PROT_DBG_BGF_ro_conn_infra_bus_slp_prot_bgf_m_req_SHFT 4
#define CONN_INFRA_CFG_CONN_INFRA_SLP_PROT_DBG_BGF_ro_conn_infra_bus_slp_prot_bgf_m_ack_ADDR CONN_INFRA_CFG_CONN_INFRA_SLP_PROT_DBG_BGF_ADDR
#define CONN_INFRA_CFG_CONN_INFRA_SLP_PROT_DBG_BGF_ro_conn_infra_bus_slp_prot_bgf_m_ack_MASK 0x00000008                // ro_conn_infra_bus_slp_prot_bgf_m_ack[3]
#define CONN_INFRA_CFG_CONN_INFRA_SLP_PROT_DBG_BGF_ro_conn_infra_bus_slp_prot_bgf_m_ack_SHFT 3
#define CONN_INFRA_CFG_CONN_INFRA_SLP_PROT_DBG_BGF_r_conn_infra_bus_slp_prot_dbg_bgf_s_req_ADDR CONN_INFRA_CFG_CONN_INFRA_SLP_PROT_DBG_BGF_ADDR
#define CONN_INFRA_CFG_CONN_INFRA_SLP_PROT_DBG_BGF_r_conn_infra_bus_slp_prot_dbg_bgf_s_req_MASK 0x00000004                // r_conn_infra_bus_slp_prot_dbg_bgf_s_req[2]
#define CONN_INFRA_CFG_CONN_INFRA_SLP_PROT_DBG_BGF_r_conn_infra_bus_slp_prot_dbg_bgf_s_req_SHFT 2
#define CONN_INFRA_CFG_CONN_INFRA_SLP_PROT_DBG_BGF_r_conn_infra_bus_slp_prot_dbg_bgf_r_req_ADDR CONN_INFRA_CFG_CONN_INFRA_SLP_PROT_DBG_BGF_ADDR
#define CONN_INFRA_CFG_CONN_INFRA_SLP_PROT_DBG_BGF_r_conn_infra_bus_slp_prot_dbg_bgf_r_req_MASK 0x00000002                // r_conn_infra_bus_slp_prot_dbg_bgf_r_req[1]
#define CONN_INFRA_CFG_CONN_INFRA_SLP_PROT_DBG_BGF_r_conn_infra_bus_slp_prot_dbg_bgf_r_req_SHFT 1
#define CONN_INFRA_CFG_CONN_INFRA_SLP_PROT_DBG_BGF_r_conn_infra_bus_slp_prot_dbg_bgf_m_req_ADDR CONN_INFRA_CFG_CONN_INFRA_SLP_PROT_DBG_BGF_ADDR
#define CONN_INFRA_CFG_CONN_INFRA_SLP_PROT_DBG_BGF_r_conn_infra_bus_slp_prot_dbg_bgf_m_req_MASK 0x00000001                // r_conn_infra_bus_slp_prot_dbg_bgf_m_req[0]
#define CONN_INFRA_CFG_CONN_INFRA_SLP_PROT_DBG_BGF_r_conn_infra_bus_slp_prot_dbg_bgf_m_req_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_SLP_PROT_DBG_WF (0x18001000 + 0x0604)---

    r_conn_infra_bus_slp_prot_dbg_wf_req[0] - (RW)  xxx 
    ro_conn_infra_bus_slp_prot_wf_ack[1] - (RO)  xxx 
    ro_conn_infra_bus_slp_prot_wf_req[2] - (RO)  xxx 
    RESERVED3[31..3]             - (RO) Reserved bits

 =====================================================================================*/
#define CONN_INFRA_CFG_CONN_INFRA_SLP_PROT_DBG_WF_ro_conn_infra_bus_slp_prot_wf_req_ADDR CONN_INFRA_CFG_CONN_INFRA_SLP_PROT_DBG_WF_ADDR
#define CONN_INFRA_CFG_CONN_INFRA_SLP_PROT_DBG_WF_ro_conn_infra_bus_slp_prot_wf_req_MASK 0x00000004                // ro_conn_infra_bus_slp_prot_wf_req[2]
#define CONN_INFRA_CFG_CONN_INFRA_SLP_PROT_DBG_WF_ro_conn_infra_bus_slp_prot_wf_req_SHFT 2
#define CONN_INFRA_CFG_CONN_INFRA_SLP_PROT_DBG_WF_ro_conn_infra_bus_slp_prot_wf_ack_ADDR CONN_INFRA_CFG_CONN_INFRA_SLP_PROT_DBG_WF_ADDR
#define CONN_INFRA_CFG_CONN_INFRA_SLP_PROT_DBG_WF_ro_conn_infra_bus_slp_prot_wf_ack_MASK 0x00000002                // ro_conn_infra_bus_slp_prot_wf_ack[1]
#define CONN_INFRA_CFG_CONN_INFRA_SLP_PROT_DBG_WF_ro_conn_infra_bus_slp_prot_wf_ack_SHFT 1
#define CONN_INFRA_CFG_CONN_INFRA_SLP_PROT_DBG_WF_r_conn_infra_bus_slp_prot_dbg_wf_req_ADDR CONN_INFRA_CFG_CONN_INFRA_SLP_PROT_DBG_WF_ADDR
#define CONN_INFRA_CFG_CONN_INFRA_SLP_PROT_DBG_WF_r_conn_infra_bus_slp_prot_dbg_wf_req_MASK 0x00000001                // r_conn_infra_bus_slp_prot_dbg_wf_req[0]
#define CONN_INFRA_CFG_CONN_INFRA_SLP_PROT_DBG_WF_r_conn_infra_bus_slp_prot_dbg_wf_req_SHFT 0

#ifdef __cplusplus
}
#endif

#endif // __CONN_INFRA_CFG_REGS_H__
