#!/bin/sh

prog=ookla
SpeedTestPath=/tmp/speedtest
LastResultPath=/etc/speedtest
StatusFile=$SpeedTestPath/ookla_speed_test_status
ResultFile=$SpeedTestPath/ookla_speed_test_result
LastResultFile=$LastResultPath/ookla_speed_test_last_result

if [ ! -d $SpeedTestPath ];
then
    mkdir $SpeedTestPath
fi

if [ ! -d $LastResultPath ];
then
    mkdir $LastResultPath
fi

# speedtest status
# 0: speed test init
# 1: speed test start
# 2: speed test cancel
# 3: speed test done

start_init() {
	echo -n $"Starting $prog"
	echo 1 > $StatusFile
	time=$(date +%s)
	echo "   TestTime: "$time > $ResultFile
	touch /tmp/speedtest_init
}

start() {
	if [ ! -e /tmp/speedtest_init ]; then
		echo -n $"Starting $prog"
		echo 1 > $StatusFile
		time=$(date +%s)
		echo "   TestTime: "$time > $ResultFile
	fi
	if [ -e /tmp/speedtest_init ]; then
		rm -fr /tmp/speedtest_init
	fi
	$prog --format=human-readable -p yes --configurl=http://www.speedtest.net/api/embed/netgear/config.php?threadnum=2 >> $ResultFile 2>&1
	echo Result: $? >> $ResultFile
	echo 3 > $StatusFile
	cp -f $ResultFile $LastResultFile
}

stop() {
	echo -n $"Shutting down $prog"
	killall $prog
	echo 2 > $StatusFile
}

# See how we were called.
case "$1" in
  start)
	start
	;;
  stop)
	stop
	;;
  start_init)
	start_init
	;;
  *)
	echo $"Usage: $0 {start_init|start|stop}"
	exit 2
esac
