#!/bin/sh

function register_switch_apmode()
{
#   ext to ap mode
    local apcaFinish="$(uci get system.@system[0].apcaFinish)"
    local apnetWizardState="$(uci get system.@system[0].apnetWizardState)"
    local caFinish="$(uci get system.@system[0].caFinish)"
    local netWizardState="$(uci get system.@system[0].netWizardState)"

    uci set system.@system[0].extcaFinish=$caFinish
    uci set system.@system[0].extnetWizardState=$netWizardState
    if [ "x$apnetWizardState" = "x" ]; then
        uci set system.@system[0].netWizardState='0'
        uci set system.@system[0].caFinish='0'
        uci commit system
    else
        uci set system.@system[0].netWizardState=$apnetWizardState
        uci set system.@system[0].caFinish=$apcaFinish
        uci commit system
    fi
}

function register_switch_extmode()
{
#   ap to ext mode
    local ext_caFinish="$(uci get system.@system[0].extcaFinish)"
    local ext_netWizardState="$(uci get system.@system[0].extnetWizardState)"
    local caFinish="$(uci get system.@system[0].caFinish)"
    local netWizardState="$(uci get system.@system[0].netWizardState)"

    uci set system.@system[0].apcaFinish=$caFinish
    uci set system.@system[0].apnetWizardState=$netWizardState
    if [ "x$ext_netWizardState" = "x" ]; then
        uci set system.@system[0].netWizardState='0'
        uci set system.@system[0].caFinish='0'
        uci commit system
    else
        uci set system.@system[0].netWizardState=$ext_netWizardState
        uci set system.@system[0].caFinish=$ext_caFinish
        uci commit system
    fi
}

function switch_apmode()
{
    echo "switch_apmode"
    local brproto=$(uci get network.lan.proto)
    uci set wireless.2g_5g.conf_mode=0
    uci commit wireless
    # register_switch_apmode
#    local linkStatus="$(uci get network.lan.linkrootap)"
#    if [ $linkStatus == "0" ] || [ $linkStatus == "9" ];then
#        local brMac=$(ifconfig br-lan | grep "HWaddr" | awk '{print $5}')
#        ebtables -I filter_arp -o eth1 -p arp -s $brMac -j DROP 2>>/dev/null
#    fi

    ebtables -F filter_arp
    iwpriv ra0 set PartialScan=0
    iwpriv apcli0 set ApCliEnable=0
    ifconfig apcli0 down
    iwpriv rax0 set PartialScan=0;
    iwpriv apclix0 set ApCliEnable=0
    ifconfig apclix0 down
    local ap2=$(brctl show | grep 'apcli0')
    local ap5=$(brctl show | grep 'apclix0')
    local ethifName=$(uci get network.lan.ifname)
    if [ -n "$ap2" ]; then
        brctl delif br-lan apcli0
    fi
    if [ -n "$ap5" ]; then
        brctl delif br-lan apclix0
    fi
    killall linkapCheck
    conntrack -F
    ethtool -r $ethifName
    iwpriv ra0 set DisConnectAllSta=1
    iwpriv ra1 set DisConnectAllSta=1
    iwpriv rax0 set DisConnectAllSta=1
    iwpriv rax1 set DisConnectAllSta=1
    echo 2 > /proc/br_dns_hijack
    uci set network.lan.linkrootap=9
    uci set network.lan.pingrootap=0
    if [ "$brproto" = "dhcp" ]; then
        uci set network.lan.twipaddr='192.168.1.250'
        uci set network.lan.twgateway='192.168.1.250'
        uci set network.lan.twnetmask='255.255.255.0'
        uci set network.lan.twdns='0.0.0.0'
    else
        uci set network.lan.ipaddr='192.168.1.250'
        uci set network.lan.gateway='192.168.1.250'
        uci set network.lan.netmask='255.255.255.0'
        uci set network.lan.dns='0.0.0.0'
    fi
    route delete default
    ip route add default via 192.168.1.250 dev br-lan
    /etc/init.d/dnsmasq restart
    #ifconfig br-lan:0 down
    ifconfig br-lan 192.168.1.250
    sleep 1
    /etc/init.d/system restart

    ebtables  -D OUTPUT -o ra0 -p IPv4 --ip-proto 17 --ip-sport 68 --ip-dport 67 -j DROP 2>/dev/null
    ebtables  -D OUTPUT -o ra1 -p IPv4 --ip-proto 17 --ip-sport 68 --ip-dport 67 -j DROP 2>/dev/null
    ebtables  -D OUTPUT -o rax0 -p IPv4 --ip-proto 17 --ip-sport 68 --ip-dport 67 -j DROP 2>/dev/null
    ebtables  -D OUTPUT -o rax1 -p IPv4 --ip-proto 17 --ip-sport 68 --ip-dport 67 -j DROP 2>/dev/null
    ebtables  -D OUTPUT -o $ethifName -p IPv4 --ip-proto 17 --ip-sport 68 --ip-dport 67 -j DROP 2>/dev/null
    ebtables  -D INPUT  -i $ethifName -p IPv4 --ip-proto 17 --ip-sport 67 --ip-dport 68 -j DROP 2>/dev/null	
    ebtables  -A OUTPUT -o ra0 -p IPv4 --ip-proto 17 --ip-sport 68 --ip-dport 67 -j DROP
    ebtables  -A OUTPUT -o ra1 -p IPv4 --ip-proto 17 --ip-sport 68 --ip-dport 67 -j DROP
    ebtables  -A OUTPUT -o rax0 -p IPv4 --ip-proto 17 --ip-sport 68 --ip-dport 67 -j DROP
    ebtables  -A OUTPUT -o rax1 -p IPv4 --ip-proto 17 --ip-sport 68 --ip-dport 67 -j DROP

    local dhcppid=$(cat /var/run/udhcpc-br-lan.pid)
    if [ $dhcppid -gt 0 ];then
        kill -SIGUSR2 $dhcppid
        kill -SIGUSR1 $dhcppid
    fi
}

function switch_extmode()
{
    echo "switch_extmode"
    local ethifName=$(uci get network.lan.ifname)
    local brproto=$(uci get network.lan.proto)
    uci set wireless.2g_5g.conf_mode=2
    uci commit wireless
    # register_switch_extmode

    ebtables  -D OUTPUT -o ra0 -p IPv4 --ip-proto 17 --ip-sport 68 --ip-dport 67 -j DROP 2>/dev/null
    ebtables  -D OUTPUT -o ra1 -p IPv4 --ip-proto 17 --ip-sport 68 --ip-dport 67 -j DROP 2>/dev/null
    ebtables  -D OUTPUT -o rax0 -p IPv4 --ip-proto 17 --ip-sport 68 --ip-dport 67 -j DROP 2>/dev/null
    ebtables  -D OUTPUT -o rax1 -p IPv4 --ip-proto 17 --ip-sport 68 --ip-dport 67 -j DROP 2>/dev/null
    ebtables  -D OUTPUT -o $ethifName -p IPv4 --ip-proto 17 --ip-sport 68 --ip-dport 67 -j DROP 2>/dev/null
    ebtables  -D INPUT  -i $ethifName -p IPv4 --ip-proto 17 --ip-sport 67 --ip-dport 68 -j DROP 2>/dev/null
    ebtables  -A OUTPUT -o ra0 -p IPv4 --ip-proto 17 --ip-sport 68 --ip-dport 67 -j DROP
    ebtables  -A OUTPUT -o ra1 -p IPv4 --ip-proto 17 --ip-sport 68 --ip-dport 67 -j DROP
    ebtables  -A OUTPUT -o rax0 -p IPv4 --ip-proto 17 --ip-sport 68 --ip-dport 67 -j DROP
    ebtables  -A OUTPUT -o rax1 -p IPv4 --ip-proto 17 --ip-sport 68 --ip-dport 67 -j DROP
    ebtables  -A OUTPUT -o $ethifName -p IPv4 --ip-proto 17 --ip-sport 68 --ip-dport 67 -j DROP
    ebtables  -A INPUT  -i $ethifName -p IPv4 --ip-proto 17 --ip-sport 67 --ip-dport 68 -j DROP

    ebtables -F filter_arp
    killall linkapCheck
    echo 2 > /proc/br_dns_hijack
    uci set network.lan.linkrootap=9
    uci set network.lan.pingrootap=0
    if [ "x$brproto" = "xdhcp" ]; then
        uci set network.lan.twipaddr='192.168.1.250'
        uci set network.lan.twgateway='192.168.1.250'
        uci set network.lan.twnetmask='255.255.255.0'
        uci set network.lan.twdns='0.0.0.0'
    else
        uci set network.lan.ipaddr='192.168.1.250'
        uci set network.lan.gateway='192.168.1.250'
        uci set network.lan.netmask='255.255.255.0'
        uci set network.lan.dns='0.0.0.0'
    fi
    route delete default
    ip route add default via 192.168.1.250 dev br-lan
    /etc/init.d/dnsmasq restart
    #ifconfig br-lan:0 down
    ifconfig br-lan 192.168.1.250
    local linkStatus="$(uci get network.lan.linkrootap)"
    if [ $linkStatus == "0" ] || [ $linkStatus == "9" ];then
        local brMac=$(ifconfig br-lan | grep "HWaddr" | awk '{print $5}')
        ebtables -I filter_arp -o apcli0 -p arp -s $brMac -j DROP 2>>/dev/null
        ebtables -I filter_arp -o apclix0 -p arp -s $brMac -j DROP 2>>/dev/null
    fi
    sleep 2
    /etc/init.d/system restart
    touch /tmp/mtk/wifi/apcli0.changed
    touch /tmp/mtk/wifi/apclix0.changed
    wifi reload

    local dhcppid=$(cat /var/run/udhcpc-br-lan.pid)
    if [ $dhcppid -gt 0 ];then
        kill -SIGUSR2 $dhcppid
        kill -SIGUSR1 $dhcppid
    fi
}

function monitor_wifi_switch()
{
    if [ -e /tmp/wifimonitorrunning ];then
        return
    fi
    touch /tmp/wifimonitorrunning
    touch /tmp/wifimonitor
    local cfgMdoe=$(uci get wireless.2g_5g.conf_mode)
    currentMode="extmode"
    if [ "x$cfgMdoe" = "x0" ];then
        currentMode="apmode"
    fi
    while [ -e /tmp/wifimonitor ]
    do
        sleep 1
        if [[ -e /tmp/apmode && "$currentMode" != "apmode" ]];then
            switch_apmode
            currentMode="apmode"
        fi

        if [[ -e /tmp/extmode && "$currentMode" != "extmode" ]];then
            switch_extmode
            currentMode="extmode"
        fi
         rm /tmp/wifimonitor
    done
    rm /tmp/wifimonitorrunning
}


function monitor_wifi_switch_exit()
{
    if [ -e /tmp/wifimonitor ];then
        rm /tmp/wifimonitor
    fi

    while [ -e /tmp/wifimonitorrunning ]
    do
        sleep 1
    done
}








