--This file is created for check some deamons

    local mtkwifi = require("mtkwifi")
    local devs = mtkwifi.get_all_devs()
    local nixio = require("nixio")

function miniupnpd_chk(devname,vif,enable)
    local WAN_IF=mtkwifi.__trim(mtkwifi.read_pipe("uci -q get network.wan.ifname"))

    os.execute("rm -rf /etc/miniupnpd.conf")

    if mtkwifi.exists("/tmp/run/miniupnpd."..vif) then
        os.execute("cat /tmp/run/miniupnpd."..vif.." | xargs kill -9")
    end

    if enable then
        local profile = mtkwifi.search_dev_and_profile()[devname]
        local cfgs = mtkwifi.load_profile(profile)
        local ssid_index = devs[devname]["vifs"][vif].vifidx
        local wsc_conf_mode = ""
        local PORT_NUM = 7777+(string.byte(vif, -1)+string.byte(vif, -2))
		local LAN_PROTO = mtkwifi.__trim(mtkwifi.read_pipe("uci -q get network.lan.proto"))
        local LAN_IPADDR = ""
        local LAN_MASK  = ""
        local port = 6352 + (string.byte(vif, -1)+string.byte(vif, -2))
		
		if LAN_PROTO == 'dhcp' then
			LAN_IPADDR = mtkwifi.__trim(mtkwifi.read_pipe("uci -q get network.lan.twipaddr"))
			LAN_MASK = mtkwifi.__trim(mtkwifi.read_pipe("uci -q get network.lan.twnetmask"))
		else
			LAN_IPADDR = mtkwifi.__trim(mtkwifi.read_pipe("uci -q get network.lan.ipaddr"))
			LAN_MASK = mtkwifi.__trim(mtkwifi.read_pipe("uci -q get network.lan.netmask"))
		end
        LAN_IPADDR = LAN_IPADDR.."/"..LAN_MASK
        wsc_conf_mode = mtkwifi.token_get(cfgs["WscConfMode"], ssid_index, "")

        local file = io.open("/etc/miniupnpd.conf", "w")
        if nil == file then
            nixio.syslog("debug","open file /etc/miniupnpd.conf fail")
        end

        file:write("ext_ifname=",WAN_IF,'\n','\n',
                   "listening_ip=",LAN_IPADDR,'\n','\n',
                   "port=",port,'\n','\n',
                   "bitrate_up=800000000",'\n',
                   "bitrate_down=800000000",'\n','\n',
                   "secure_mode=no",'\n','\n',
                   "system_uptime=yes",'\n','\n',
                   "notify_interval=30",'\n','\n',
                   "uuid=68555350-3352-3883-2883-335030522880",'\n','\n',
                   "serial=12345678",'\n','\n',
                   "model_number=1",'\n','\n',
                   "enable_upnp=no",'\n','\n')
        file:close()

        if wsc_conf_mode ~= "" and wsc_conf_mode ~= "0" then
            os.execute("miniupnpd -m 1 -I "..vif.." -P /var/run/miniupnpd."..vif.." -G -i "..WAN_IF.." -a "..LAN_IPADDR.." -n "..PORT_NUM)
        end
    end
end

function d8021xd_chk(devname, prefix, vif, enable)
    if mtkwifi.exists("/tmp/run/8021xd_"..vif..".pid") then
        os.execute("cat /tmp/run/8021xd_"..vif..".pid | xargs kill -9")
        os.execute("rm /tmp/run/8021xd_"..vif..".pid")
    end

    if enable then
        local profile = mtkwifi.search_dev_and_profile()[devname]
        local cfgs = mtkwifi.load_profile(profile)
        local auth_mode = cfgs.AuthMode
        local ieee8021x = cfgs.IEEE8021X
        local pat_auth_mode = {"WPA$", "WPA;", "WPA2$", "WPA2;", "WPA1WPA2$", "WPA1WPA2;", "WPA3$", "WPA3;", "192$", "192;"}
        local pat_ieee8021x = {"1$", "1;"}
        local apd_en = false

        for _, pat in ipairs(pat_auth_mode) do
            if string.find(auth_mode, pat) then
                apd_en = true
            end
        end

        for _, pat in ipairs(pat_ieee8021x) do
            if string.find(ieee8021x, pat) then
                apd_en = true
            end
        end

        if apd_en then
            os.execute("8021xd -p "..prefix.. " -i "..vif)
        end
    end
end

local function get_viflist()
    local devs = mtkwifi.get_all_devs()
    local vif_list = {}
    for _,dev in ipairs(devs) do
        for _,vif in ipairs(dev.vifs) do
            if not(string.find(dev.profile, "ax7800") and vif.vifname == "ra0") then
                table.insert(vif_list,vif.vifname)
            end
        end
    end
    return vif_list
end

--bUp==true: set interface up
--bUp==false: set interface down
function doBrctlAddIf(bUp)
    -- conf_mode/fastlaneApMode之间存在互斥关系，需要在这里充分考虑
    -- conf_mode==0: AP模式，上行接口不允许启动
    -- conf_mode==2: Extender模式，依据fastlaneApMode进行配置
    -- fastlaneApMode==1: fastlane模式，2.4G->5G,或5G->2.4G
    -- fastlaneApMode=0: 正常模式，依据配置决定上行接口状况
    -- fastlaneApBand: 2.4G/5G

    local conf_mode=mtkwifi.__trim(mtkwifi.read_pipe("uci -q get wireless.2g_5g.conf_mode"))
    local fastlaneApMode=mtkwifi.__trim(mtkwifi.read_pipe("uci -q get wireless.2g_5g.fastlaneApMode"))
    local fastlaneApBand=mtkwifi.__trim(mtkwifi.read_pipe("uci -q get wireless.2g_5g.fastlaneApBand"))
    local ap2gName=mtkwifi.__trim(mtkwifi.read_pipe("uci -q get wireless.@wifi-iface[0].ifName"))
    local ap5gName=mtkwifi.__trim(mtkwifi.read_pipe("uci -q get wireless.@wifi-iface[1].ifName"))
    local apcli2gName=mtkwifi.__trim(mtkwifi.read_pipe("uci -q get wireless.apcli_2g.ifName"))
    local apcli5gName=mtkwifi.__trim(mtkwifi.read_pipe("uci -q get wireless.apcli_5g.ifName"))
    local ap2gRadio=mtkwifi.__trim(mtkwifi.read_pipe("uci -q get wireless.@wifi-iface[0].radio"))
    local ap5gRadio=mtkwifi.__trim(mtkwifi.read_pipe("uci -q get wireless.@wifi-iface[1].radio"))
    local guest2gName=mtkwifi.__trim(mtkwifi.read_pipe("uci -q get wireless.@wifi-iface[2].ifName"))
    local guest5gName=mtkwifi.__trim(mtkwifi.read_pipe("uci -q get wireless.@wifi-iface[3].ifName"))
    local guest2gRadio=mtkwifi.__trim(mtkwifi.read_pipe("uci -q get wireless.@wifi-iface[2].radio"))
    local guest5gRadio=mtkwifi.__trim(mtkwifi.read_pipe("uci -q get wireless.@wifi-iface[3].radio"))
    local isRootApExist_2g=mtkwifi.__trim(mtkwifi.read_pipe("uci -q get wireless.apcli_2g.apcli_existOption"))
    local isRootApExist_5g=mtkwifi.__trim(mtkwifi.read_pipe("uci -q get wireless.apcli_5g.apcli_existOption"))
    local ap2gUp = false
    local ap5gUp = false
    local guest2gUp = false
    local guest5gUp = false
    local apcli2gUp = false
    local apcli5gUp = false
    local rst = ""

    -- ap模式依据开关控制下行接口,上行接口全部关闭
    if conf_mode == '0' then
        if ap5gRadio == '1' then
            ap5gUp = true
        end
        if guest5gRadio == '1' then
            guest5gUp = true
        end
        if ap2gRadio == '1' then
            ap2gUp = true
        end
        if guest2gRadio == '1' then
            guest2gUp = true
        end
        apcli2gUp = false
        apcli5gUp = false
    end

    -- extender正常模式依据开关控制上下行接口，
    if conf_mode ~= '0' and fastlaneApMode == '0' then
        if ap5gRadio == '1' then
            ap5gUp = true
        end
        if guest5gRadio == '1' then
            guest5gUp = true
        end
        if ap2gRadio == '1' then
            ap2gUp = true
        end
        if guest2gRadio == '1' then
            guest2gUp = true
        end
        if isRootApExist_2g == '1' then
            apcli2gUp = true
        end
        if isRootApExist_5g == '1' then
            apcli5gUp = true
        end
    end

    -- fastlane模式，依据fastlane模式控制上下行接口
    if conf_mode ~= '0' and fastlaneApMode ~= '0' then
        if fastlaneApBand == '2.4G' then
            if ap5gRadio == '1' then
                ap5gUp = true
            end
            if guest5gRadio == '1' then
                guest5gUp = true
            end
            if isRootApExist_2g == '1' then
                apcli2gUp = true
            end
        elseif fastlaneApBand == '5G' then
            if ap2gRadio == '1' then
                ap2gUp = true
            end
            if guest2gRadio == '1' then
                guest2gUp = true
            end
            if isRootApExist_5g == '1' then
                apcli5gUp = true
            end
        else
            os.execute("echo fastlaneApBand should in 2.4G/5G, can not be "..tostring(fastlaneApBand).." > /dev/console")
        end
    end

    if bUp then
        rst = "UP: "
        if ap5gUp then
            rst = rst.." ap5g"
            os.execute("ifconfig "..ap5gName.." up 1>/dev/null 2>&1")
            os.execute("brctl addif br-lan "..ap5gName.." 1>/dev/null 2>&1")
        end
        if guest5gUp then
            rst = rst.." guest5g"
            os.execute("ifconfig "..guest5gName.." up 1>/dev/null 2>&1")
            os.execute("brctl addif br-lan "..guest5gName.." 1>/dev/null 2>&1")
        end
        if apcli5gUp then
            rst = rst.." apcli5g"
            os.execute("ifconfig "..apcli5gName.." up 1>/dev/null 2>&1")
            os.execute("iwpriv "..apcli5gName.." set PartialScan=0 1>/dev/null 2>&1")
            os.execute("iwpriv "..apcli5gName.." set ApCliEnable=0 1>/dev/null 2>&1")
            os.execute("brctl addif br-lan "..apcli5gName.." 1>/dev/null 2>&1")
        end
        if ap2gUp then
            rst = rst.." ap2g"
            os.execute("ifconfig "..ap2gName.." up 1>/dev/null 2>&1")
            os.execute("brctl addif br-lan "..ap2gName.." 1>/dev/null 2>&1")
        end
        if guest2gUp then
            rst = rst.." guest2g"
            os.execute("ifconfig "..guest2gName.." up 1>/dev/null 2>&1")
            os.execute("brctl addif br-lan "..guest2gName.." 1>/dev/null 2>&1")
        end
        if apcli2gUp then
            rst = rst.." apcli2g"
            os.execute("ifconfig "..apcli2gName.." up 1>/dev/null 2>&1")
            os.execute("iwpriv "..apcli2gName.." set PartialScan=0 1>/dev/null 2>&1")
            os.execute("iwpriv "..apcli2gName.." set ApCliEnable=0 1>/dev/null 2>&1")
            os.execute("brctl addif br-lan "..apcli2gName.." 1>/dev/null 2>&1")
        end
        os.execute("echo "..rst.." >/dev/console")
    else
        rst = rst.."DOWN: "
        if not ap5gUp then
            rst = rst.." 5g"
            os.execute("brctl delif br-lan "..ap5gName.." 1>/dev/null 2>&1")
            os.execute("ifconfig "..ap5gName.." down 1>/dev/null 2>&1")
        end
        if not guest5gUp then
            rst = rst.." guse5g"
            os.execute("brctl delif br-lan "..guest5gName.." 1>/dev/null 2>&1")
            os.execute("ifconfig "..guest5gName.." down 1>/dev/null 2>&1")
        end
        if not apcli5gUp then
            rst = rst.." apcli5g"
            os.execute("iwpriv "..apcli5gName.." set PartialScan=0 1>/dev/null 2>&1")
            os.execute("iwpriv "..apcli5gName.." set ApCliEnable=0 1>/dev/null 2>&1")
            os.execute("ifconfig "..apcli5gName.." down 1>/dev/null 2>&1")
            os.execute("brctl delif br-lan "..apcli5gName.." 1>/dev/null 2>&1")
        end
        if not ap2gUp then
            rst = rst.." ap2g"
            os.execute("brctl delif br-lan "..ap2gName.." 1>/dev/null 2>&1")
            os.execute("ifconfig "..ap2gName.." down 1>/dev/null 2>&1")
        end
        if not guest2gUp then
            rst = rst.." guest2g"
            os.execute("brctl delif br-lan "..guest2gName.." 1>/dev/null 2>&1")
            os.execute("ifconfig "..guest2gName.." down 1>/dev/null 2>&1")
        end
        if not apcli2gUp then
            rst = rst.." apcli2g"
            os.execute("iwpriv "..apcli2gName.." set PartialScan=0 1>/dev/null 2>&1")
            os.execute("iwpriv "..apcli2gName.." set ApCliEnable=0 1>/dev/null 2>&1")
            os.execute("ifconfig "..apcli2gName.." down 1>/dev/null 2>&1")
            os.execute("brctl delif br-lan "..apcli2gName.." 1>/dev/null 2>&1")
        end
        os.execute("echo "..rst.." >/dev/console")
    end
end

function connetRootAp(dev)
    local conf_mode=mtkwifi.__trim(mtkwifi.read_pipe("uci -q get wireless.2g_5g.conf_mode"))

    if conf_mode ~= '0' then
        local isRootApExist_2g=mtkwifi.__trim(mtkwifi.read_pipe("uci -q get wireless.apcli_2g.apcli_existOption"))
        local isRootApExist_5g=mtkwifi.__trim(mtkwifi.read_pipe("uci -q get wireless.apcli_5g.apcli_existOption"))
        local devname_2g=mtkwifi.__trim(mtkwifi.read_pipe("uci -q get wireless.apcli_2g.device"))
        local devname_5g=mtkwifi.__trim(mtkwifi.read_pipe("uci -q get wireless.apcli_5g.device"))

        if devname_2g then devname_2g = devname_2g:gsub("%_", ".") end
        if devname_5g then devname_5g = devname_5g:gsub("%_", ".") end

        if isRootApExist_2g == '1' and dev == "2g" then
            for _,vif in ipairs(string.split(mtkwifi.read_pipe("ls /sys/class/net"), "\n"))
            do
                if string.match(vif, "apcli%d") then
                    mtkwifi.apcli_connect(devname_2g, vif);
                end
            end
        end

        if isRootApExist_5g == '1' and dev == "5g" then
            for _,vif in ipairs(string.split(mtkwifi.read_pipe("ls /sys/class/net"), "\n"))
            do
                if string.match(vif, "apclix%d") then
                    mtkwifi.apcli_connect(devname_5g, vif);
                end
            end
        end

--        for _,vif in ipairs(string.split(mtkwifi.read_pipe("ls /sys/class/net"), "\n")) do
--            if isRootApExist_2g == '1' or isRootApExist_5g == '1' then
--                if string.match(vif, "ra.") then
--                    mtkwifi.set_netgear_vie(vif, 1)
--                end
--            elseif string.match(vif, "ra.") then
--                mtkwifi.set_netgear_vie(vif, 0)
--            end
--        end

    end
end

function setNtgrVie()
    local if2g="ra0"
    local if5g="rax0"
	local conf_mode=mtkwifi.__trim(mtkwifi.read_pipe("uci -q get wireless.2g_5g.conf_mode"))
    local ap2gRadio=mtkwifi.__trim(mtkwifi.read_pipe("uci -q get wireless.@wifi-iface[0].radio"))
    local ap5gRadio=mtkwifi.__trim(mtkwifi.read_pipe("uci -q get wireless.@wifi-iface[1].radio"))

	os.execute("rm /tmp/setntgrvie 1>/dev/null 2>&1")

	-- ap mode
	if conf_mode == '0' then
		if mtkwifi.exists("/sys/class/net/"..if2g) and ap2gRadio == '1' then
			mtkwifi.set_netgear_vie(if2g, 0)
		end

		if mtkwifi.exists("/sys/class/net/"..if5g) and ap5gRadio == '1' then
			mtkwifi.set_netgear_vie(if5g, 0)
		end
	else
		if mtkwifi.exists("/sys/class/net/"..if2g) and ap2gRadio == '1' then
			mtkwifi.set_netgear_vie(if2g, 1)
		end

		if mtkwifi.exists("/sys/class/net/"..if5g) and ap5gRadio == '1' then
			mtkwifi.set_netgear_vie(if5g, 1)
		end
	end

	os.execute("echo 1 > /tmp/setntgrvie 1>/dev/null 2>&1")

end

function startAllApPin()
	local pinCode = mtkwifi.__trim(mtkwifi.read_pipe("uci -q get wireless.2g_5g.wpsPinCode"))
	local attackNum = mtkwifi.__trim(mtkwifi.read_pipe("uci -q get wireless.2g_5g.wpsPinAttackNum"))
	local wpsLock = mtkwifi.__trim(mtkwifi.read_pipe("uci -q get wireless.2g_5g.wpsLockdown"))
	local attackCheck = mtkwifi.__trim(mtkwifi.read_pipe("uci -q get wireless.2g_5g.wpsPinAttackCheck"))

	if attackCheck == '0' then
		attackNum = '0'
	end

	for _,vif in ipairs(string.split(mtkwifi.read_pipe("ls /sys/class/net"), "\n"))
	do
		if string.match(vif, "ra%a-%d+") then
			mtkwifi.__wps_ap_pin_start_all(vif, pinCode, wpsLock, attackNum)
		end
	end
end

function enableBlackList()
	local devList = mtkwifi.__trim(mtkwifi.read_pipe("uci -q get wireless.2g.blacklist"))
	for _,vif in ipairs(string.split(devList, " "))
	do
		local devMac = string.match(vif, ".+/")
		if devMac then
			devMac =string.gsub(devMac, "/", " ")
				for _,tif in ipairs(string.split(mtkwifi.read_pipe("ls /sys/class/net"), "\n"))
				do
					if string.match(tif, "ra%a-0") then
						mtkwifi.__attach_dev_black_list_enable(tif, devMac)
					end
				end
		end
	end

	devList = mtkwifi.__trim(mtkwifi.read_pipe("uci -q get wireless.2g.guest_blacklist"))
	for _,vif in ipairs(string.split(devList, " "))
	do
		local devMac = string.match(vif, ".+/")
		if devMac then
			devMac =string.gsub(devMac, "/", " ")
				for _,tif in ipairs(string.split(mtkwifi.read_pipe("ls /sys/class/net"), "\n"))
				do
					if string.match(tif, "ra%a-1") then
						mtkwifi.__attach_dev_black_list_enable(tif, devMac)
					end
				end
		end
	end
end

function guestNetActive(vif, allowed)
    os.execute("ebtables -D INPUT -p IPv4 -i "..vif.." --ip-proto 17 --ip-dport 67:68 -j ACCEPT 1>/dev/null 2>&1")
    os.execute("ebtables -D INPUT -p ARP -i "..vif.." -j ACCEPT 1>/dev/null 2>&1")
    os.execute("ebtables -D INPUT -i "..vif.." -j DROP 1>/dev/null 2>&1")

    if allowed == "0" then
        os.execute("ebtables -A INPUT -p IPv4 -i "..vif.." --ip-proto 17 --ip-dport 67:68 -j ACCEPT")
        os.execute("ebtables -A INPUT -p ARP -i "..vif.." -j ACCEPT")
        os.execute("ebtables -A INPUT -i "..vif.." -j DROP")
    end

    os.execute("ebtables -D FORWARD -p IPv4 -i "..vif.." --ip-proto 17 --ip-dport 53 -j ACCEPT 1>/dev/null 2>&1")
    os.execute("ebtables -D FORWARD -p IPv4 -i "..vif.." --ip-proto 17 --ip-dport 67:68 -j ACCEPT 1>/dev/null 2>&1")

    if allowed == "0" then
        os.execute("ebtables -A FORWARD -p IPv4 -i "..vif.." --ip-proto 17 --ip-dport 53 -j ACCEPT")
        os.execute("ebtables -A FORWARD -p IPv4 -i "..vif.." --ip-proto 17 --ip-dport 67:68 -j ACCEPT")
    end

    local fd = io.open("/tmp/br-lan-ipaddr"..vif, "r")
    if fd ~= nil then
        local oldIp = fd:read("*l")
        fd:close()
        if oldIp ~= nil then
            os.execute("ebtables -D FORWARD -p IPv4 -i "..vif.." --ip-dst "..oldIp.." -j DROP 1>/dev/null 2>&1")
        end
    end

    local cmdfd = io.popen("ifconfig br-lan | awk -F '[ :]+' '/inet addr/ {print $4}'")
    local curIp = cmdfd:read("*l")
    cmdfd:close()

    local cmdfd = io.popen("ifconfig br-lan | awk -F '[ :]+' '/inet addr/ {print $8}'")
    local curIpMask = cmdfd:read("*l")
    cmdfd:close()

    if allowed == "0"  and curIp ~= nil and curIpMask ~= nil then
        os.execute("ebtables -A FORWARD -p IPv4 -i "..vif.." --ip-dst "..curIp.."/"..curIpMask.." -j DROP")
    end

    if curIp ~= nil and  curIpMask ~= nil then
        local fd = io.open("/tmp/br-lan-ipaddr"..vif, "w")
        if nil ~= fd then
            fd:write(curIp.."/"..curIpMask)
            fd:close()
        end
    else
        os.remove("/tmp/br-lan-ipaddr"..vif)
    end
end

function guestNetwork()
    local if2g="ra1"
    local if5g="rax1"
    local guest2g = mtkwifi.__trim(mtkwifi.read_pipe("uci get wireless.@wifi-iface[2].allowLocalNetwork"))
    local guest5g = mtkwifi.__trim(mtkwifi.read_pipe("uci get wireless.@wifi-iface[3].allowLocalNetwork"))

    if mtkwifi.exists("/sys/class/net/"..if2g) then
        guestNetActive(if2g, guest2g)
    end

    if mtkwifi.exists("/sys/class/net/"..if5g) then
        guestNetActive(if5g, guest5g)
    end
end

function startFwdd()
    os.execute("/etc/init.d/fwdd stop")
    os.execute("/etc/init.d/fwdd start")
end

function ledAction()
    local ap2gRadio=mtkwifi.__trim(mtkwifi.read_pipe("uci -q get wireless.@wifi-iface[0].radio"))
    local ap5gRadio=mtkwifi.__trim(mtkwifi.read_pipe("uci -q get wireless.@wifi-iface[1].radio"))
    --local wpsLock = mtkwifi.__trim(mtkwifi.read_pipe("uci -q get wireless.2g_5g.wpsLockdown"))
    local ap2gsecurity = mtkwifi.__trim(mtkwifi.read_pipe("uci -q get wireless.@wifi-iface[0].security"))
    local ap5gsecurity = mtkwifi.__trim(mtkwifi.read_pipe("uci -q get wireless.@wifi-iface[1].security"))

    --os.execute("iwpriv ra0 e2p 3a=0d00") --config wifi driver LED_MODE:WPS_LED_MODE_13
    --os.execute("iwpriv rax0 e2p 3a=0d00") --config wifi driver LED_MODE:WPS_LED_MODE_13

    if ap2gRadio == '0' and ap5gRadio == '0' then
        os.execute(". /lib/functions/led_control.sh && platform_led_off green wps")
    --elseif wpsLock == '1' then
        --os.execute(". /lib/functions/led_control.sh && platform_led_set_timer green wps 200 200")
    else
        if ap2gRadio == '1' and ap5gRadio == '0' then
            if ap2gsecurity == "None" or ap2gsecurity == "OFF" or ap2gsecurity == "" then
                os.execute(". /lib/functions/led_control.sh && platform_led_off green wps")
            else
                os.execute(". /lib/functions/led_control.sh && platform_led_on green wps")
            end
        elseif ap2gRadio == '0' and ap5gRadio == '1' then
            if ap5gsecurity == "None" or ap5gsecurity == "OFF" or ap5gsecurity == "" then
                os.execute(". /lib/functions/led_control.sh && platform_led_off green wps")
            else
                os.execute(". /lib/functions/led_control.sh && platform_led_on green wps")
            end
        else
            if (ap2gsecurity == "None" or ap2gsecurity == "OFF" or ap2gsecurity == "") and (ap5gsecurity == "None" or ap5gsecurity == "OFF" or ap5gsecurity == "") then
                os.execute(". /lib/functions/led_control.sh && platform_led_off green wps")
            else
                os.execute(". /lib/functions/led_control.sh && platform_led_on green wps")
            end
        end
    end
end

function set_otp()
    local ap2gRadio=mtkwifi.__trim(mtkwifi.read_pipe("uci -q get wireless.@wifi-iface[0].radio"))
    local ap5gRadio=mtkwifi.__trim(mtkwifi.read_pipe("uci -q get wireless.@wifi-iface[1].radio"))
    nixio.syslog("debug","[ap2gRadio="..ap2gRadio.."], [ap5gRadio="..ap5gRadio.."]")
    if ap2gRadio == '1' then
        os.execute("iwpriv ra0 set thermal_protect_duty_cfg=0:0:100")
        os.execute("iwpriv ra0 set thermal_protect_duty_cfg=0:1:80")
        os.execute("iwpriv ra0 set thermal_protect_duty_cfg=0:2:60")
        os.execute("iwpriv ra0 set thermal_protect_duty_cfg=0:3:50")
        os.execute("iwpriv ra0 set thermal_protect_enable=0:1:1:118:112:0005")
        os.execute("iwpriv ra0 set probeReqCnt=11")
    end

    if ap5gRadio == '1' then
        os.execute("iwpriv rax0 set thermal_protect_duty_cfg=1:0:100")
        os.execute("iwpriv rax0 set thermal_protect_duty_cfg=1:1:80")
        os.execute("iwpriv rax0 set thermal_protect_duty_cfg=1:2:60")
        os.execute("iwpriv rax0 set thermal_protect_duty_cfg=1:3:50")
        os.execute("iwpriv rax0 set thermal_protect_enable=1:1:1:118:112:0005")
        os.execute("iwpriv rax0 set probeReqCnt=11")
    end
end

-- wifi service that require to start after wifi up
function wifi_service_misc()
    local mapd_default = mtkwifi.load_profile("/etc/map/mapd_default.cfg")
    local mapd_user = mtkwifi.load_profile("/etc/map/mapd_user.cfg")
    local first_card_cfgs = mtkwifi.load_profile(mtkwifi.detect_first_card())

    local vif_list = get_viflist()
    local total_vif = #vif_list
    local over_time = 0

    os.execute("echo [wifi] ENTER wifi_service_misc >> /tmp/wifiLuaDebug.log")

    -- 0.brctl
    --doBrctlAddIf()
    setNtgrVie()

    -- 1.startFwdd
    --startFwdd will cause network dead in EAX17
    --startFwdd()

	-- 2.apcli_connect
    connetRootAp("2g")
    connetRootAp("5g")
    if mtkwifi.exists("/tmp/mtk/wifi/normal_reload") then
        os.execute("rm /tmp/mtk/wifi/normal_reload")
    end

    -- 3.startAllApPin
    --startAllApPin()

    -- 4.enableBlackList
    enableBlackList()

    -- 5.guestnetwork
    guestNetwork()

    -- 6.ledAction
    ledAction()

    if mapd_default.mode then
        local eth_mode = mapd_default.mode
        local device_role = mapd_default.DeviceRole
        if mapd_user.mode then
            eth_mode = mapd_user.mode
        end
        if mapd_user.DeviceRole then
            device_role = mapd_user.DeviceRole
        end
	-- Start Hostapd if exists
	if ((first_card_cfgs.MapMode == "1") and mtkwifi.exists("/usr/bin/hostapd")) then
	    os.execute("killall hostapd")
	    local hostapd_cmd = ""
	    for _,ifname in ipairs(string.split(mtkwifi.read_pipe("ls /sys/class/net"), "\n"))
	    do
	        if (string.match(ifname,"ra")) then
		    hostapd_cmd = hostapd_cmd.." /etc/hostapd_"..ifname.."_map.conf"
		end
	    end
	    print(hostapd_cmd)
	    os.execute("echo "..hostapd_cmd.." >/dev/console")
	    os.execute("/usr/bin/hostapd -B "..hostapd_cmd)
	end
        -- 7.Wapp
        if mtkwifi.exists("/usr/bin/wapp_openwrt.sh") then
            os.execute("./etc/init.d/wapp start")
        end
        -- 8.EasyMesh
        if mtkwifi.exists("/usr/bin/EasyMesh_openwrt.sh") then
            if first_card_cfgs.MapMode == "1" then
                if (eth_mode == "0" and device_role == "1") or eth_mode == "1" then
                    os.execute("./etc/init.d/easymesh start")
                else
                    os.execute("./etc/init.d/easymesh_bridge start")
                end
            else
                os.execute("./etc/init.d/easymesh start")
            end
        end
    else
        -- 7.Wapp
        if mtkwifi.exists("/usr/bin/wapp_openwrt.sh") then
            os.execute("./etc/init.d/wapp start")
        end
        -- 8.EasyMesh
        if mtkwifi.exists("/usr/bin/EasyMesh_openwrt.sh") then
            os.execute("./etc/init.d/easymesh start")
        end 
    end
    -- Start Hostapd if exists
    if ((first_card_cfgs.MapMode == "0") and mtkwifi.exists("/usr/bin/hostapd")) then
        os.execute("killall hostapd")
        os.execute("echo start Hostapd in background > /dev/console")
        os.execute("/etc/init.d/hostapd_init start")
    end
    -- Start AFC
    os.execute("killall AFC")
    if mtkwifi.exists("/usr/bin/AFC") then
        local afc_cmd = "rax0 &"
        os.execute("echo start AFC in background > /dev/console")
        os.execute("/usr/bin/AFC "..afc_cmd)
    end

    --set otp
    local factory_mode=mtkwifi.__trim(mtkwifi.read_pipe("envctl factory get factory_mode"))
    nixio.syslog("debug","lua factory_mode:"..factory_mode)
    if factory_mode == "off" then
        nixio.syslog("debug"," wifi_services.lua set otp --------")
        set_otp()
    end

    local patch_filename="/tmp/wifi-patch-flag"
    os.execute("echo 'Patched Security_Advisory_2021-002_-_Wi-Fi_WPS_and_IEEE-1905_Vulnerabilities' > "..patch_filename)

end

if arg[1] == "guestNetwork" then
    guestNetwork()
end

-- wifi service that require to clean up before wifi down
function wifi_service_misc_clean()
    os.execute("rm -rf /tmp/wapp_ctrl")
    os.execute("killall -15 mapd")
    os.execute("killall -15 wapp")
    os.execute("killall -15 p1905_managerd")
    os.execute("killall -15 bs20")
end
