#!/bin/sh
#
# Copyright (C) 2016 OpenWrt.org
#

mediatek_mount_rae() {
	local mtd_id=`cat /proc/mtd | grep "RAE" | awk -F : '{print $1;}' | sed s/mtd//`

	if [ $? != 0 ] || [ ! $mtd_id ]; then
		echo "Get RAE partition failed"
		return 1
	fi

	local mount_dir="/rae"
	if UBI=`ubiattach -m $mtd_id`; then
		echo ">>>>> Mounting rae partition as UBIFS <<<<<"  > /dev/console
		UBI=${UBI##*"number "} # cut all before "number ", still need to get rid of leading space
		UBI=${UBI%%,*} # cut all after ","
		local pname=`ubinfo /dev/ubi"$UBI" -a | grep -o rae`
		if [ "$pname" != "rae" ]; then
			echo ">>>>> Creating ubi volume ubi"$UBI":rae <<<<<"  > /dev/console
			ubimkvol /dev/ubi"$UBI" -m -N rae
		fi
		if [ ! -d $mount_dir ]; then
			mkdir -p $mount_dir
		fi
		mount -t ubifs ubi"$UBI":rae /rae
	else
		echo ">>>>> ubiattach RAE partition failed <<<<<"  > /dev/console
		return 1
	fi
}
