KERNEL_LOADADDR := 0x44080000

define Build/GJEncoder
  cp -rf $@ $@_unenc
  Version=`cat $(TOPDIR)/package/tw/tw_base-files/files/$(1)/etc/config/system|grep "softVersion"|awk '{print $$3}'|sed "s/'//g"`;\
  $(STAGING_DIR_HOST)/bin/imgencoder \
		--encode $@ \
		--blocksize $(FLASH_NOR_BLOCK) \
		--region $(NTGR_SW_REGION) \
		--model $(1) \
		--sw_version $$Version \
		--hwidnum $(NTGR_HW_ID_NUM) \
		--hwidlist $(NTGR_HW_ID_LIST) \
		--modelnum $(NTGR_MODEL_NUM) \
		--modellist $(NTGR_MODEL_LIST) \
		--output $@.new
  rm $@.enc
  mv $@.new $@
  cp -rf $@_unenc $(BIN_DIR)
endef

define Build/append-mtk-boot-idm-working
  dd if=/dev/zero ibs=5632K count=1 | tr "\000" "\377" > $@
  dd if=$(PLATFORM_DIR)/image/bl2-$(1).img of=$@ bs=128K seek=0 conv=notrunc
  dd if=$(PLATFORM_DIR)/image/fip-$(1).bin of=$@ bs=128K seek=28 conv=notrunc
endef

define Device/mt7986a-ax4200-spim-nor-rfb
  DEVICE_VENDOR := MediaTek
  DEVICE_MODEL := mt7986a-ax4200-spim-nor-rfb
  DEVICE_DTS := mt7986a-spim-nor-rfb
  DEVICE_DTS_DIR := $(DTS_DIR)/mediatek
endef
TARGET_DEVICES += mt7986a-ax4200-spim-nor-rfb

define Device/mt7986a-ax4200-spim-nand-rfb
  DEVICE_VENDOR := MediaTek
  DEVICE_MODEL := mt7986a-ax4200-snand-rfb (SPI-NAND,UBI)
  DEVICE_DTS := mt7986a-spim-nand-rfb
  DEVICE_DTS_DIR := $(DTS_DIR)/mediatek
  SUPPORTED_DEVICES := mediatek,mt7986a-spim-snand-rfb
  UBINIZE_OPTS := -E 5
  BLOCKSIZE := 128k
  PAGESIZE := 2048
  UBI_SIZE := 65536k
  IMAGE_SIZE := 131072k
  KERNEL_IN_UBI := 1
  FLASH_NOR_BLOCK := 131072
  NTGR_SW_REGION  := US
  NTGR_HW_ID_NUM  := 1
  NTGR_HW_ID_LIST := "1010000009910000_NETGEAR"
  NTGR_MODEL_NUM  := 2
  NTGR_MODEL_LIST := "AX4200;EAX17"
  IMAGES += factory.bin
  IMAGES += AX4200
  IMAGES += AX4200-burnimg
  IMAGE_NAME = $$(2)-$$(shell cat $(TOPDIR)/package/tw/tw_base-files/files/$$(2)/etc/config/system|grep "softVersion"|awk '{print $$$$3}'|sed "s/'//g"|sed "s/_/ /g"|awk '{print $$$$1}')\($$(REVISION)-$$(BUILD_TIME)\).bin
  IMAGE/factory.bin := append-ubi | check-size $$$$(UBI_SIZE)
  IMAGE/sysupgrade.bin := sysupgrade-tar | append-metadata
  IMAGE/AX4200 := $$(IMAGE/sysupgrade.bin) | GJEncoder AX4200
  IMAGE/AX4200-burnimg := append-mtk-boot-idm-working wn-dax4200gr-ddr4 | append-ubi-dual-image | pad-to 87552k | pad-to 98304k | check-size $$$$(IMAGE_SIZE)
endef
TARGET_DEVICES += mt7986a-ax4200-spim-nand-rfb

define Device/mt7986a-ax4200-2500wan-spim-nand-rfb
  DEVICE_VENDOR := MediaTek
  DEVICE_MODEL := mt7986a-ax4200-2500wan-spim-nand-rfb (SPI-NAND,UBI)
  DEVICE_DTS := mt7986a-2500wan-spim-nand-rfb
  DEVICE_DTS_DIR := $(DTS_DIR)/mediatek
  SUPPORTED_DEVICES := mediatek,mt7986a-2500wan-spim-nand-rfb
  UBINIZE_OPTS := -E 5
  BLOCKSIZE := 128k
  PAGESIZE := 2048
  IMAGE_SIZE := 65536k
  KERNEL_IN_UBI := 1
  IMAGES += factory.bin
  IMAGE/factory.bin := append-ubi | check-size $$$$(IMAGE_SIZE)
  IMAGE/sysupgrade.bin := sysupgrade-tar | append-metadata
endef
TARGET_DEVICES += mt7986a-ax4200-2500wan-spim-nand-rfb
