#ifndef MT7986_MMU_H
#define MT7986_MMU_H

#include <platform_def.h>

#define MTK_MAP_DEVICE(_name, _base, _size)	\
			MAP_REGION_FLAT(_base,	\
					_size,	\
					MT_DEVICE | MT_RW | MT_SECURE)

#define MAP_SEC_SYSRAM	MAP_REGION_FLAT(TZRAM_BASE,	\
					TZRAM_SIZE,	\
					MT_MEMORY | MT_RW | MT_SECURE)

#define MAP_GIC	\
	MTK_MAP_DEVICE(GIC_V3, GIC_BASE, 0x1000000)

#define MAP_DEVICE0	\
	MTK_MAP_DEVICE(BASIC, 0x10000000, 0x20000),	\
	MTK_MAP_DEVICE(INFRACFG, 0x10209000, 0x2000),	\
	MTK_MAP_DEVICE(PERICFG, 0x1020B000, 0x2000),	\
	MTK_MAP_DEVICE(TRNG, 0x1020F000, 0x1000),	\
	MTK_MAP_DEVICE(MCUSYS, 0x10400000, 0x2000),	\
	MTK_MAP_DEVICE(UART, 0x11002000, 0x3000),	\
	MTK_MAP_DEVICE(EFUSE, 0x11D00000, 0x10000),	\
	MTK_MAP_DEVICE(TOP_MISC, 0x11D10000, 0x1000)

#define MAP_DEVICE1	\
	MTK_MAP_DEVICE(MPU, 0x10226000, 0x1000),	\
	MTK_MAP_DEVICE(DEVICE_APC, 0x1A0F0000, 0x30000)

#define MAP_DEVICE_EXTENTION	\
	MTK_MAP_DEVICE(PWM, 0x10048000, 0x1000),	\
	MTK_MAP_DEVICE(DMA, 0x10212000, 0x6000),	\
	MTK_MAP_DEVICE(EIP97, 0x10320000, 0x40000),	\
	MTK_MAP_DEVICE(NFI, 0x11005000, 0x2000),	\
	MTK_MAP_DEVICE(I2C, 0x11008000, 0x1000),	\
	MTK_MAP_DEVICE(SPI, 0x1100A000, 0x2000),	\
	MTK_MAP_DEVICE(AUXADC, 0x1100D000, 0x1000),	\
	MTK_MAP_DEVICE(IOCFG_0, 0x11C30000, 0x2000),	\
	MTK_MAP_DEVICE(IOCFG_1, 0x11E20000, 0x4000)

#endif
