//[File]            : conn_bus_cr.h
//[Revision time]   : Fri Sep 25 23:13:32 2020
//[Description]     : This file is auto generated by CODA
//[Copyright]       : Copyright (C) 2020 Mediatek Incorportion. All rights reserved.

#ifndef __CONN_BUS_CR_REGS_H__
#define __CONN_BUS_CR_REGS_H__

#include "hal_common.h"

#ifdef __cplusplus
extern "C" {
#endif


//****************************************************************************
//
//                     CONN_BUS_CR CR Definitions                     
//
//****************************************************************************
#ifdef RTMP_RBUS_SUPPORT
#define CONN_BUS_CR_BASE                                       (0x1800E000 + CONN_INFRA_REMAPPING_OFFSET)
#else
#define CONN_BUS_CR_BASE                                       0xFE000
#endif /* RTMP_RBUS_SUPPORT */

#define CONN_BUS_CR_WF_LIGHT_SECURITY_START_ADDR_0_ADDR        (CONN_BUS_CR_BASE + 0x200) // E200
#define CONN_BUS_CR_WF_LIGHT_SECURITY_END_ADDR_0_ADDR          (CONN_BUS_CR_BASE + 0x204) // E204
#define CONN_BUS_CR_WF_LIGHT_SECURITY_START_ADDR_1_ADDR        (CONN_BUS_CR_BASE + 0x208) // E208
#define CONN_BUS_CR_WF_LIGHT_SECURITY_END_ADDR_1_ADDR          (CONN_BUS_CR_BASE + 0x20C) // E20C
#define CONN_BUS_CR_WF_LIGHT_SECURITY_START_ADDR_2_ADDR        (CONN_BUS_CR_BASE + 0x210) // E210
#define CONN_BUS_CR_WF_LIGHT_SECURITY_END_ADDR_2_ADDR          (CONN_BUS_CR_BASE + 0x214) // E214
#define CONN_BUS_CR_BT_LIGHT_SECURITY_START_ADDR_0_ADDR        (CONN_BUS_CR_BASE + 0x218) // E218
#define CONN_BUS_CR_BT_LIGHT_SECURITY_END_ADDR_0_ADDR          (CONN_BUS_CR_BASE + 0x21C) // E21C
#define CONN_BUS_CR_BT_LIGHT_SECURITY_START_ADDR_1_ADDR        (CONN_BUS_CR_BASE + 0x220) // E220
#define CONN_BUS_CR_BT_LIGHT_SECURITY_END_ADDR_1_ADDR          (CONN_BUS_CR_BASE + 0x224) // E224
#define CONN_BUS_CR_BT_LIGHT_SECURITY_START_ADDR_2_ADDR        (CONN_BUS_CR_BASE + 0x228) // E228
#define CONN_BUS_CR_BT_LIGHT_SECURITY_END_ADDR_2_ADDR          (CONN_BUS_CR_BASE + 0x22C) // E22C
#define CONN_BUS_CR_EASY_SECURITY_WF_IRQ_CLR_ADDR              (CONN_BUS_CR_BASE + 0x230) // E230
#define CONN_BUS_CR_EASY_SECURITY_BGF_IRQ_CLR_ADDR             (CONN_BUS_CR_BASE + 0x234) // E234
#define CONN_BUS_CR_LIGHT_SECURITY_CTRL_ADDR                   (CONN_BUS_CR_BASE + 0x238) // E238
#define CONN_BUS_CR_BUS_DEAD_CR_ADDRESS_ADDR                   (CONN_BUS_CR_BASE + 0x23C) // E23C
#define CONN_BUS_CR_PCIE2AP_REMAP_DOMAIN_ID_ADDR               (CONN_BUS_CR_BASE + 0x240) // E240
#define CONN_BUS_CR_PCIE2AP_REMAP_0_ADDR                       (CONN_BUS_CR_BASE + 0x244) // E244
#define CONN_BUS_CR_PCIE2AP_REMAP_1_ADDR                       (CONN_BUS_CR_BASE + 0x248) // E248
#define CONN_BUS_CR_PCIE2AP_REMAP_2_ADDR                       (CONN_BUS_CR_BASE + 0x24C) // E24C
#define CONN_BUS_CR_PCIE2AP_REMAP_3_ADDR                       (CONN_BUS_CR_BASE + 0x250) // E250
#define CONN_BUS_CR_PCIE2AP_REMAP_4_ADDR                       (CONN_BUS_CR_BASE + 0x254) // E254
#define CONN_BUS_CR_PCIE2AP_REMAP_5_ADDR                       (CONN_BUS_CR_BASE + 0x258) // E258
#define CONN_BUS_CR_PCIE2AP_REMAP_6_ADDR                       (CONN_BUS_CR_BASE + 0x25C) // E25C
#define CONN_BUS_CR_PCIE2AP_REMAP_7_ADDR                       (CONN_BUS_CR_BASE + 0x260) // E260
#define CONN_BUS_CR_MST_WF_RBIST_IDLE_DIS_ADDR                 (CONN_BUS_CR_BASE + 0x270) // E270
#define CONN_BUS_CR_MST_WF_IDLE_DIS_ADDR                       (CONN_BUS_CR_BASE + 0x274) // E274
#define CONN_BUS_CR_MST_BT_IDLE_DIS_ADDR                       (CONN_BUS_CR_BASE + 0x278) // E278
#define CONN_BUS_CR_MST_GPS_IDLE_DIS_ADDR                      (CONN_BUS_CR_BASE + 0x27C) // E27C
#define CONN_BUS_CR_MST_INFRA_ON_IDLE_DIS_ADDR                 (CONN_BUS_CR_BASE + 0x280) // E280
#define CONN_BUS_CR_SLV_AP_IDLE_DIS_ADDR                       (CONN_BUS_CR_BASE + 0x284) // E284
#define CONN_BUS_CR_SLV_WF_IDLE_DIS_ADDR                       (CONN_BUS_CR_BASE + 0x288) // E288
#define CONN_BUS_CR_SLV_BT_IDLE_DIS_ADDR                       (CONN_BUS_CR_BASE + 0x28C) // E28C
#define CONN_BUS_CR_SLV_GPS_IDLE_DIS_ADDR                      (CONN_BUS_CR_BASE + 0x290) // E290
#define CONN_BUS_CR_SLV_INFRA_ON_IDLE_DIS_ADDR                 (CONN_BUS_CR_BASE + 0x294) // E294
#define CONN_BUS_CR_SLV_OTHER_IDLE_DIS_ADDR                    (CONN_BUS_CR_BASE + 0x298) // E298
#define CONN_BUS_CR_BUS_IDLE_DEBOUNCE_ADDR                     (CONN_BUS_CR_BASE + 0x29C) // E29C
#define CONN_BUS_CR_GALS_AP2CONN_GALS_DBG_ADDR                 (CONN_BUS_CR_BASE + 0x2A0) // E2A0
#define CONN_BUS_CR_GALS_CONN2AP_GALS_DBG_ADDR                 (CONN_BUS_CR_BASE + 0x2A4) // E2A4
#define CONN_BUS_CR_GALS_WF1_TO_CONN_GALS_DBG_ADDR             (CONN_BUS_CR_BASE + 0x2A8) // E2A8
#define CONN_BUS_CR_GALS_CONN_TO_WF1_GALS_DBG_ADDR             (CONN_BUS_CR_BASE + 0x2AC) // E2AC
#define CONN_BUS_CR_GALS_AP2CONN_GALS_CTRL_ADDR                (CONN_BUS_CR_BASE + 0x2B8) // E2B8
#define CONN_BUS_CR_GALS_CONN2AP_GALS_CTRL_ADDR                (CONN_BUS_CR_BASE + 0x2BC) // E2BC
#define CONN_BUS_CR_GALS_WF1_TO_CONN_CTRL_0_ADDR               (CONN_BUS_CR_BASE + 0x2C0) // E2C0
#define CONN_BUS_CR_GALS_CONN_TO_WF1_CTRL_0_ADDR               (CONN_BUS_CR_BASE + 0x2C4) // E2C4
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_0_ADDR                   (CONN_BUS_CR_BASE + 0x2D0) // E2D0
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_1_ADDR                   (CONN_BUS_CR_BASE + 0x2D4) // E2D4
#define CONN_BUS_CR_CONN_INFRA_DCM_CLOCK_CTRL_ADDR             (CONN_BUS_CR_BASE + 0x2D8) // E2D8
#define CONN_BUS_CR_CONN_INFRA_DEVAPC_DBG_CTRL_ADDR            (CONN_BUS_CR_BASE + 0x2DC) // E2DC
#define CONN_BUS_CR_CONN_INFRA_SLP_PROT_AP2CONN_CTRL_ADDR      (CONN_BUS_CR_BASE + 0x2E0) // E2E0
#define CONN_BUS_CR_CONN_INFRA_SLP_PROT_CONN2AP_CTRL_ADDR      (CONN_BUS_CR_BASE + 0x2E4) // E2E4
#define CONN_BUS_CR_CONN_INFRA_SLP_PROT_CTRL_ADDR              (CONN_BUS_CR_BASE + 0x2E8) // E2E8
#define CONN_BUS_CR_CONN_INFRA_BUS_OFF_TIMEOUT_CTRL_ADDR       (CONN_BUS_CR_BASE + 0x300) // E300
#define CONN_BUS_CR_CONN_INFRA_BUS_OFF_TIMEOUT_VALUE_ADDR      (CONN_BUS_CR_BASE + 0x304) // E304
#define CONN_BUS_CR_CONN_INFRA_BUS_OFF_ILLEGAL_VALUE_ADDR      (CONN_BUS_CR_BASE + 0x308) // E308
#define CONN_BUS_CR_CONN_INFRA_BUS_OFF_DBG_MON_1_ADDR          (CONN_BUS_CR_BASE + 0x30C) // E30C
#define CONN_BUS_CR_CONN_INFRA_BUS_OFF_DBG_MON_2_ADDR          (CONN_BUS_CR_BASE + 0x310) // E310
#define CONN_BUS_CR_CONN_INFRA_BUS_OFF_TOP_DBG_MON_1_ADDR      (CONN_BUS_CR_BASE + 0x314) // E314
#define CONN_BUS_CR_CONN_INFRA_BUS_OFF_TOP_DBG_MON_2_ADDR      (CONN_BUS_CR_BASE + 0x318) // E318
#define CONN_BUS_CR_CONN_INFRA_BUS_ON_TIMEOUT_CTRL_ADDR        (CONN_BUS_CR_BASE + 0x31C) // E31C
#define CONN_BUS_CR_CONN_INFRA_BUS_ON_TIMEOUT_VALUE_ADDR       (CONN_BUS_CR_BASE + 0x320) // E320
#define CONN_BUS_CR_CONN_INFRA_BUS_ON_DBG_WFDMA_MON_1_ADDR     (CONN_BUS_CR_BASE + 0x324) // E324
#define CONN_BUS_CR_CONN_INFRA_BUS_ON_DBG_WFDMA_MON_2_ADDR     (CONN_BUS_CR_BASE + 0x328) // E328
#define CONN_BUS_CR_CONN_INFRA_BUS_ON_TOP_DBG_APB_MON_1_ADDR   (CONN_BUS_CR_BASE + 0x32C) // E32C
#define CONN_BUS_CR_CONN_INFRA_BUS_ON_TOP_DBG_APB_MON_2_ADDR   (CONN_BUS_CR_BASE + 0x330) // E330
#define CONN_BUS_CR_CONN_INFRA_BUS_TIMEOUT_IRQ_B_ADDR          (CONN_BUS_CR_BASE + 0x334) // E334
#define CONN_BUS_CR_CONN_INFRA_OFF2ON_DET_CTL_ADDR             (CONN_BUS_CR_BASE + 0x358) // E358
#define CONN_BUS_CR_CONN_INFRA_CONN2AP_CR_PATH_ADDR_START_ADDR (CONN_BUS_CR_BASE + 0x360) // E360
#define CONN_BUS_CR_CONN_INFRA_CONN2AP_CR_PATH_ADDR_END_ADDR   (CONN_BUS_CR_BASE + 0x364) // E364
#define CONN_BUS_CR_CONN_INFRA_CONN2AP_EMI_PATH_ADDR_START_ADDR (CONN_BUS_CR_BASE + 0x368) // E368
#define CONN_BUS_CR_CONN_INFRA_CONN2AP_EMI_PATH_ADDR_END_ADDR  (CONN_BUS_CR_BASE + 0x36C) // E36C
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_ADDR       (CONN_BUS_CR_BASE + 0x370) // E370
#define CONN_BUS_CR_PCIE2AP_REMAP_WF1_0_ADDR                   (CONN_BUS_CR_BASE + 0x444) // E444
#define CONN_BUS_CR_PCIE2AP_REMAP_WF1_1_ADDR                   (CONN_BUS_CR_BASE + 0x448) // E448
#define CONN_BUS_CR_PCIE2AP_REMAP_WF1_2_ADDR                   (CONN_BUS_CR_BASE + 0x44C) // E44C
#define CONN_BUS_CR_PCIE2AP_REMAP_WF1_3_ADDR                   (CONN_BUS_CR_BASE + 0x450) // E450
#define CONN_BUS_CR_PCIE2AP_REMAP_WF1_4_ADDR                   (CONN_BUS_CR_BASE + 0x454) // E454
#define CONN_BUS_CR_PCIE2AP_REMAP_WF1_5_ADDR                   (CONN_BUS_CR_BASE + 0x458) // E458
#define CONN_BUS_CR_PCIE2AP_REMAP_WF1_6_ADDR                   (CONN_BUS_CR_BASE + 0x45C) // E45C
#define CONN_BUS_CR_PCIE2AP_REMAP_WF1_7_ADDR                   (CONN_BUS_CR_BASE + 0x460) // E460
#define CONN_BUS_CR_CONN2AP_REMAP_BYPASS_ADDR                  (CONN_BUS_CR_BASE + 0x464) // E464




/* =====================================================================================

  ---WF_LIGHT_SECURITY_START_ADDR_0 (0x1800E000 + 0x200)---

    R_WF_LIGHT_SECURITY_START_ADDR_0[31..0] - (RW) Wf illegal access range_0 start address set, default btsys

 =====================================================================================*/
#define CONN_BUS_CR_WF_LIGHT_SECURITY_START_ADDR_0_R_WF_LIGHT_SECURITY_START_ADDR_0_ADDR CONN_BUS_CR_WF_LIGHT_SECURITY_START_ADDR_0_ADDR
#define CONN_BUS_CR_WF_LIGHT_SECURITY_START_ADDR_0_R_WF_LIGHT_SECURITY_START_ADDR_0_MASK 0xFFFFFFFF                // R_WF_LIGHT_SECURITY_START_ADDR_0[31..0]
#define CONN_BUS_CR_WF_LIGHT_SECURITY_START_ADDR_0_R_WF_LIGHT_SECURITY_START_ADDR_0_SHFT 0

/* =====================================================================================

  ---WF_LIGHT_SECURITY_END_ADDR_0 (0x1800E000 + 0x204)---

    R_WF_LIGHT_SECURITY_END_ADDR_0[31..0] - (RW) Wf illegal access range_0 end address set, default btsys

 =====================================================================================*/
#define CONN_BUS_CR_WF_LIGHT_SECURITY_END_ADDR_0_R_WF_LIGHT_SECURITY_END_ADDR_0_ADDR CONN_BUS_CR_WF_LIGHT_SECURITY_END_ADDR_0_ADDR
#define CONN_BUS_CR_WF_LIGHT_SECURITY_END_ADDR_0_R_WF_LIGHT_SECURITY_END_ADDR_0_MASK 0xFFFFFFFF                // R_WF_LIGHT_SECURITY_END_ADDR_0[31..0]
#define CONN_BUS_CR_WF_LIGHT_SECURITY_END_ADDR_0_R_WF_LIGHT_SECURITY_END_ADDR_0_SHFT 0

/* =====================================================================================

  ---WF_LIGHT_SECURITY_START_ADDR_1 (0x1800E000 + 0x208)---

    R_WF_LIGHT_SECURITY_START_ADDR_1[31..0] - (RW) Wf illegal access range_1 start address set, default gps

 =====================================================================================*/
#define CONN_BUS_CR_WF_LIGHT_SECURITY_START_ADDR_1_R_WF_LIGHT_SECURITY_START_ADDR_1_ADDR CONN_BUS_CR_WF_LIGHT_SECURITY_START_ADDR_1_ADDR
#define CONN_BUS_CR_WF_LIGHT_SECURITY_START_ADDR_1_R_WF_LIGHT_SECURITY_START_ADDR_1_MASK 0xFFFFFFFF                // R_WF_LIGHT_SECURITY_START_ADDR_1[31..0]
#define CONN_BUS_CR_WF_LIGHT_SECURITY_START_ADDR_1_R_WF_LIGHT_SECURITY_START_ADDR_1_SHFT 0

/* =====================================================================================

  ---WF_LIGHT_SECURITY_END_ADDR_1 (0x1800E000 + 0x20C)---

    R_WF_LIGHT_SECURITY_END_ADDR_1[31..0] - (RW) Wf illegal access range_1 end address set, default gps

 =====================================================================================*/
#define CONN_BUS_CR_WF_LIGHT_SECURITY_END_ADDR_1_R_WF_LIGHT_SECURITY_END_ADDR_1_ADDR CONN_BUS_CR_WF_LIGHT_SECURITY_END_ADDR_1_ADDR
#define CONN_BUS_CR_WF_LIGHT_SECURITY_END_ADDR_1_R_WF_LIGHT_SECURITY_END_ADDR_1_MASK 0xFFFFFFFF                // R_WF_LIGHT_SECURITY_END_ADDR_1[31..0]
#define CONN_BUS_CR_WF_LIGHT_SECURITY_END_ADDR_1_R_WF_LIGHT_SECURITY_END_ADDR_1_SHFT 0

/* =====================================================================================

  ---WF_LIGHT_SECURITY_START_ADDR_2 (0x1800E000 + 0x210)---

    R_WF_LIGHT_SECURITY_START_ADDR_2[31..0] - (RW) Wf illegal access range_2 start address set, reserved CR, no use

 =====================================================================================*/
#define CONN_BUS_CR_WF_LIGHT_SECURITY_START_ADDR_2_R_WF_LIGHT_SECURITY_START_ADDR_2_ADDR CONN_BUS_CR_WF_LIGHT_SECURITY_START_ADDR_2_ADDR
#define CONN_BUS_CR_WF_LIGHT_SECURITY_START_ADDR_2_R_WF_LIGHT_SECURITY_START_ADDR_2_MASK 0xFFFFFFFF                // R_WF_LIGHT_SECURITY_START_ADDR_2[31..0]
#define CONN_BUS_CR_WF_LIGHT_SECURITY_START_ADDR_2_R_WF_LIGHT_SECURITY_START_ADDR_2_SHFT 0

/* =====================================================================================

  ---WF_LIGHT_SECURITY_END_ADDR_2 (0x1800E000 + 0x214)---

    R_WF_LIGHT_SECURITY_END_ADDR_2[31..0] - (RW) Wf illegal access range_2 end address set, reserved CR, no use

 =====================================================================================*/
#define CONN_BUS_CR_WF_LIGHT_SECURITY_END_ADDR_2_R_WF_LIGHT_SECURITY_END_ADDR_2_ADDR CONN_BUS_CR_WF_LIGHT_SECURITY_END_ADDR_2_ADDR
#define CONN_BUS_CR_WF_LIGHT_SECURITY_END_ADDR_2_R_WF_LIGHT_SECURITY_END_ADDR_2_MASK 0xFFFFFFFF                // R_WF_LIGHT_SECURITY_END_ADDR_2[31..0]
#define CONN_BUS_CR_WF_LIGHT_SECURITY_END_ADDR_2_R_WF_LIGHT_SECURITY_END_ADDR_2_SHFT 0

/* =====================================================================================

  ---BT_LIGHT_SECURITY_START_ADDR_0 (0x1800E000 + 0x218)---

    R_BT_LIGHT_SECURITY_START_ADDR_0[31..0] - (RW) Bt illegal access range_0 start address set, default wfsys

 =====================================================================================*/
#define CONN_BUS_CR_BT_LIGHT_SECURITY_START_ADDR_0_R_BT_LIGHT_SECURITY_START_ADDR_0_ADDR CONN_BUS_CR_BT_LIGHT_SECURITY_START_ADDR_0_ADDR
#define CONN_BUS_CR_BT_LIGHT_SECURITY_START_ADDR_0_R_BT_LIGHT_SECURITY_START_ADDR_0_MASK 0xFFFFFFFF                // R_BT_LIGHT_SECURITY_START_ADDR_0[31..0]
#define CONN_BUS_CR_BT_LIGHT_SECURITY_START_ADDR_0_R_BT_LIGHT_SECURITY_START_ADDR_0_SHFT 0

/* =====================================================================================

  ---BT_LIGHT_SECURITY_END_ADDR_0 (0x1800E000 + 0x21C)---

    R_BT_LIGHT_SECURITY_END_ADDR_0[31..0] - (RW) Bt illegal access range_0 end address set, default wfsys

 =====================================================================================*/
#define CONN_BUS_CR_BT_LIGHT_SECURITY_END_ADDR_0_R_BT_LIGHT_SECURITY_END_ADDR_0_ADDR CONN_BUS_CR_BT_LIGHT_SECURITY_END_ADDR_0_ADDR
#define CONN_BUS_CR_BT_LIGHT_SECURITY_END_ADDR_0_R_BT_LIGHT_SECURITY_END_ADDR_0_MASK 0xFFFFFFFF                // R_BT_LIGHT_SECURITY_END_ADDR_0[31..0]
#define CONN_BUS_CR_BT_LIGHT_SECURITY_END_ADDR_0_R_BT_LIGHT_SECURITY_END_ADDR_0_SHFT 0

/* =====================================================================================

  ---BT_LIGHT_SECURITY_START_ADDR_1 (0x1800E000 + 0x220)---

    R_BT_LIGHT_SECURITY_START_ADDR_1[31..0] - (RW) Bt illegal access range_1 start address set, default gps

 =====================================================================================*/
#define CONN_BUS_CR_BT_LIGHT_SECURITY_START_ADDR_1_R_BT_LIGHT_SECURITY_START_ADDR_1_ADDR CONN_BUS_CR_BT_LIGHT_SECURITY_START_ADDR_1_ADDR
#define CONN_BUS_CR_BT_LIGHT_SECURITY_START_ADDR_1_R_BT_LIGHT_SECURITY_START_ADDR_1_MASK 0xFFFFFFFF                // R_BT_LIGHT_SECURITY_START_ADDR_1[31..0]
#define CONN_BUS_CR_BT_LIGHT_SECURITY_START_ADDR_1_R_BT_LIGHT_SECURITY_START_ADDR_1_SHFT 0

/* =====================================================================================

  ---BT_LIGHT_SECURITY_END_ADDR_1 (0x1800E000 + 0x224)---

    R_BT_LIGHT_SECURITY_END_ADDR_1[31..0] - (RW) Bt illegal access range_1 end address set, default gps

 =====================================================================================*/
#define CONN_BUS_CR_BT_LIGHT_SECURITY_END_ADDR_1_R_BT_LIGHT_SECURITY_END_ADDR_1_ADDR CONN_BUS_CR_BT_LIGHT_SECURITY_END_ADDR_1_ADDR
#define CONN_BUS_CR_BT_LIGHT_SECURITY_END_ADDR_1_R_BT_LIGHT_SECURITY_END_ADDR_1_MASK 0xFFFFFFFF                // R_BT_LIGHT_SECURITY_END_ADDR_1[31..0]
#define CONN_BUS_CR_BT_LIGHT_SECURITY_END_ADDR_1_R_BT_LIGHT_SECURITY_END_ADDR_1_SHFT 0

/* =====================================================================================

  ---BT_LIGHT_SECURITY_START_ADDR_2 (0x1800E000 + 0x228)---

    R_BT_LIGHT_SECURITY_START_ADDR_2[31..0] - (RW) Bt illegal access range_2 start address set, reserved CR, no use

 =====================================================================================*/
#define CONN_BUS_CR_BT_LIGHT_SECURITY_START_ADDR_2_R_BT_LIGHT_SECURITY_START_ADDR_2_ADDR CONN_BUS_CR_BT_LIGHT_SECURITY_START_ADDR_2_ADDR
#define CONN_BUS_CR_BT_LIGHT_SECURITY_START_ADDR_2_R_BT_LIGHT_SECURITY_START_ADDR_2_MASK 0xFFFFFFFF                // R_BT_LIGHT_SECURITY_START_ADDR_2[31..0]
#define CONN_BUS_CR_BT_LIGHT_SECURITY_START_ADDR_2_R_BT_LIGHT_SECURITY_START_ADDR_2_SHFT 0

/* =====================================================================================

  ---BT_LIGHT_SECURITY_END_ADDR_2 (0x1800E000 + 0x22C)---

    R_BT_LIGHT_SECURITY_END_ADDR_2[31..0] - (RW) Bt illegal access range_2 end address set, reserved CR, no use

 =====================================================================================*/
#define CONN_BUS_CR_BT_LIGHT_SECURITY_END_ADDR_2_R_BT_LIGHT_SECURITY_END_ADDR_2_ADDR CONN_BUS_CR_BT_LIGHT_SECURITY_END_ADDR_2_ADDR
#define CONN_BUS_CR_BT_LIGHT_SECURITY_END_ADDR_2_R_BT_LIGHT_SECURITY_END_ADDR_2_MASK 0xFFFFFFFF                // R_BT_LIGHT_SECURITY_END_ADDR_2[31..0]
#define CONN_BUS_CR_BT_LIGHT_SECURITY_END_ADDR_2_R_BT_LIGHT_SECURITY_END_ADDR_2_SHFT 0

/* =====================================================================================

  ---EASY_SECURITY_WF_IRQ_CLR (0x1800E000 + 0x230)---

    R_CONN_INFRA_WF_SECURITY_IRQ_CLR[0] - (RW) write 1 to clear security irq for wf
                                     and should write 0 after irq is cleared
    RO_CONN_INFRA_WF_SECURITY_IRQ_STATE[1] - (RO) Security irq for wf 
                                     low active
    RESERVED2[31..2]             - (RO) Reserved bits

 =====================================================================================*/
#define CONN_BUS_CR_EASY_SECURITY_WF_IRQ_CLR_RO_CONN_INFRA_WF_SECURITY_IRQ_STATE_ADDR CONN_BUS_CR_EASY_SECURITY_WF_IRQ_CLR_ADDR
#define CONN_BUS_CR_EASY_SECURITY_WF_IRQ_CLR_RO_CONN_INFRA_WF_SECURITY_IRQ_STATE_MASK 0x00000002                // RO_CONN_INFRA_WF_SECURITY_IRQ_STATE[1]
#define CONN_BUS_CR_EASY_SECURITY_WF_IRQ_CLR_RO_CONN_INFRA_WF_SECURITY_IRQ_STATE_SHFT 1
#define CONN_BUS_CR_EASY_SECURITY_WF_IRQ_CLR_R_CONN_INFRA_WF_SECURITY_IRQ_CLR_ADDR CONN_BUS_CR_EASY_SECURITY_WF_IRQ_CLR_ADDR
#define CONN_BUS_CR_EASY_SECURITY_WF_IRQ_CLR_R_CONN_INFRA_WF_SECURITY_IRQ_CLR_MASK 0x00000001                // R_CONN_INFRA_WF_SECURITY_IRQ_CLR[0]
#define CONN_BUS_CR_EASY_SECURITY_WF_IRQ_CLR_R_CONN_INFRA_WF_SECURITY_IRQ_CLR_SHFT 0

/* =====================================================================================

  ---EASY_SECURITY_BGF_IRQ_CLR (0x1800E000 + 0x234)---

    R_CONN_INFRA_BGF_SECURITY_IRQ_CLR[0] - (RW) write 1 to clear security irq for bgf
                                     and should write 0 after irq is cleared
    RO_CONN_INFRA_BGF_SECURITY_IRQ_STATE[1] - (RO) Security irq for bgf 
                                     low active
    RESERVED2[31..2]             - (RO) Reserved bits

 =====================================================================================*/
#define CONN_BUS_CR_EASY_SECURITY_BGF_IRQ_CLR_RO_CONN_INFRA_BGF_SECURITY_IRQ_STATE_ADDR CONN_BUS_CR_EASY_SECURITY_BGF_IRQ_CLR_ADDR
#define CONN_BUS_CR_EASY_SECURITY_BGF_IRQ_CLR_RO_CONN_INFRA_BGF_SECURITY_IRQ_STATE_MASK 0x00000002                // RO_CONN_INFRA_BGF_SECURITY_IRQ_STATE[1]
#define CONN_BUS_CR_EASY_SECURITY_BGF_IRQ_CLR_RO_CONN_INFRA_BGF_SECURITY_IRQ_STATE_SHFT 1
#define CONN_BUS_CR_EASY_SECURITY_BGF_IRQ_CLR_R_CONN_INFRA_BGF_SECURITY_IRQ_CLR_ADDR CONN_BUS_CR_EASY_SECURITY_BGF_IRQ_CLR_ADDR
#define CONN_BUS_CR_EASY_SECURITY_BGF_IRQ_CLR_R_CONN_INFRA_BGF_SECURITY_IRQ_CLR_MASK 0x00000001                // R_CONN_INFRA_BGF_SECURITY_IRQ_CLR[0]
#define CONN_BUS_CR_EASY_SECURITY_BGF_IRQ_CLR_R_CONN_INFRA_BGF_SECURITY_IRQ_CLR_SHFT 0

/* =====================================================================================

  ---LIGHT_SECURITY_CTRL (0x1800E000 + 0x238)---

    R_CONN_INFRA_WF_PAIR0_EN[0]  - (RW) 1'b1 : wf pair-0 security on 
                                     1'b0 : wf pair-0 security off
    R_CONN_INFRA_WF_PAIR1_EN[1]  - (RW) 1'b1 : wf pair-1 security on 
                                     1'b0 : wf pair-1 security off
    R_CONN_INFRA_WF_PAIR2_EN[2]  - (RW) 1'b1 : wf pair-2 security on 
                                     1'b0 : wf pair-2 security off
    R_CONN_INFRA_BT_PAIR0_EN[3]  - (RW) 1'b1 : bt pair-0 security on 
                                     1'b0 : bt pair-0 security off
    R_CONN_INFRA_BT_PAIR1_EN[4]  - (RW) 1'b1 : bt pair-1 security on 
                                     1'b0 : bt pair-1 security off
    R_CONN_INFRA_BT_PAIR2_EN[5]  - (RW) 1'b1 : bt pair-2 security on 
                                     1'b0 : bt pair-2 security off
    R_CONN_INFRA_GPS_PAIR0_EN[6] - (RW) 1'b1 : gps pair-1 security on 
                                     1'b0 : gps pair-1 security off
    R_CONN_INFRA_GPS_PAIR1_EN[7] - (RW) 1'b1 : gps pair-1 security on 
                                     1'b0 : gps pair-1 security off
    R_CONN_INFRA_GPS_PAIR2_EN[8] - (RW) 1'b1 : gps pair-1 security on 
                                     1'b0 : gps pair-1 security off
    RESERVED9[31..9]             - (RO) Reserved bits

 =====================================================================================*/
#define CONN_BUS_CR_LIGHT_SECURITY_CTRL_R_CONN_INFRA_GPS_PAIR2_EN_ADDR CONN_BUS_CR_LIGHT_SECURITY_CTRL_ADDR
#define CONN_BUS_CR_LIGHT_SECURITY_CTRL_R_CONN_INFRA_GPS_PAIR2_EN_MASK 0x00000100                // R_CONN_INFRA_GPS_PAIR2_EN[8]
#define CONN_BUS_CR_LIGHT_SECURITY_CTRL_R_CONN_INFRA_GPS_PAIR2_EN_SHFT 8
#define CONN_BUS_CR_LIGHT_SECURITY_CTRL_R_CONN_INFRA_GPS_PAIR1_EN_ADDR CONN_BUS_CR_LIGHT_SECURITY_CTRL_ADDR
#define CONN_BUS_CR_LIGHT_SECURITY_CTRL_R_CONN_INFRA_GPS_PAIR1_EN_MASK 0x00000080                // R_CONN_INFRA_GPS_PAIR1_EN[7]
#define CONN_BUS_CR_LIGHT_SECURITY_CTRL_R_CONN_INFRA_GPS_PAIR1_EN_SHFT 7
#define CONN_BUS_CR_LIGHT_SECURITY_CTRL_R_CONN_INFRA_GPS_PAIR0_EN_ADDR CONN_BUS_CR_LIGHT_SECURITY_CTRL_ADDR
#define CONN_BUS_CR_LIGHT_SECURITY_CTRL_R_CONN_INFRA_GPS_PAIR0_EN_MASK 0x00000040                // R_CONN_INFRA_GPS_PAIR0_EN[6]
#define CONN_BUS_CR_LIGHT_SECURITY_CTRL_R_CONN_INFRA_GPS_PAIR0_EN_SHFT 6
#define CONN_BUS_CR_LIGHT_SECURITY_CTRL_R_CONN_INFRA_BT_PAIR2_EN_ADDR CONN_BUS_CR_LIGHT_SECURITY_CTRL_ADDR
#define CONN_BUS_CR_LIGHT_SECURITY_CTRL_R_CONN_INFRA_BT_PAIR2_EN_MASK 0x00000020                // R_CONN_INFRA_BT_PAIR2_EN[5]
#define CONN_BUS_CR_LIGHT_SECURITY_CTRL_R_CONN_INFRA_BT_PAIR2_EN_SHFT 5
#define CONN_BUS_CR_LIGHT_SECURITY_CTRL_R_CONN_INFRA_BT_PAIR1_EN_ADDR CONN_BUS_CR_LIGHT_SECURITY_CTRL_ADDR
#define CONN_BUS_CR_LIGHT_SECURITY_CTRL_R_CONN_INFRA_BT_PAIR1_EN_MASK 0x00000010                // R_CONN_INFRA_BT_PAIR1_EN[4]
#define CONN_BUS_CR_LIGHT_SECURITY_CTRL_R_CONN_INFRA_BT_PAIR1_EN_SHFT 4
#define CONN_BUS_CR_LIGHT_SECURITY_CTRL_R_CONN_INFRA_BT_PAIR0_EN_ADDR CONN_BUS_CR_LIGHT_SECURITY_CTRL_ADDR
#define CONN_BUS_CR_LIGHT_SECURITY_CTRL_R_CONN_INFRA_BT_PAIR0_EN_MASK 0x00000008                // R_CONN_INFRA_BT_PAIR0_EN[3]
#define CONN_BUS_CR_LIGHT_SECURITY_CTRL_R_CONN_INFRA_BT_PAIR0_EN_SHFT 3
#define CONN_BUS_CR_LIGHT_SECURITY_CTRL_R_CONN_INFRA_WF_PAIR2_EN_ADDR CONN_BUS_CR_LIGHT_SECURITY_CTRL_ADDR
#define CONN_BUS_CR_LIGHT_SECURITY_CTRL_R_CONN_INFRA_WF_PAIR2_EN_MASK 0x00000004                // R_CONN_INFRA_WF_PAIR2_EN[2]
#define CONN_BUS_CR_LIGHT_SECURITY_CTRL_R_CONN_INFRA_WF_PAIR2_EN_SHFT 2
#define CONN_BUS_CR_LIGHT_SECURITY_CTRL_R_CONN_INFRA_WF_PAIR1_EN_ADDR CONN_BUS_CR_LIGHT_SECURITY_CTRL_ADDR
#define CONN_BUS_CR_LIGHT_SECURITY_CTRL_R_CONN_INFRA_WF_PAIR1_EN_MASK 0x00000002                // R_CONN_INFRA_WF_PAIR1_EN[1]
#define CONN_BUS_CR_LIGHT_SECURITY_CTRL_R_CONN_INFRA_WF_PAIR1_EN_SHFT 1
#define CONN_BUS_CR_LIGHT_SECURITY_CTRL_R_CONN_INFRA_WF_PAIR0_EN_ADDR CONN_BUS_CR_LIGHT_SECURITY_CTRL_ADDR
#define CONN_BUS_CR_LIGHT_SECURITY_CTRL_R_CONN_INFRA_WF_PAIR0_EN_MASK 0x00000001                // R_CONN_INFRA_WF_PAIR0_EN[0]
#define CONN_BUS_CR_LIGHT_SECURITY_CTRL_R_CONN_INFRA_WF_PAIR0_EN_SHFT 0

/* =====================================================================================

  ---BUS_DEAD_CR_ADDRESS (0x1800E000 + 0x23C)---

    CONN_INFRA_DEAD_CR_ADDRESS[31..0] - (RW) if EN=1 and wf want to access btsys, there will reply "0xdead_dead" when read command, and not written by write command

 =====================================================================================*/
#define CONN_BUS_CR_BUS_DEAD_CR_ADDRESS_CONN_INFRA_DEAD_CR_ADDRESS_ADDR CONN_BUS_CR_BUS_DEAD_CR_ADDRESS_ADDR
#define CONN_BUS_CR_BUS_DEAD_CR_ADDRESS_CONN_INFRA_DEAD_CR_ADDRESS_MASK 0xFFFFFFFF                // CONN_INFRA_DEAD_CR_ADDRESS[31..0]
#define CONN_BUS_CR_BUS_DEAD_CR_ADDRESS_CONN_INFRA_DEAD_CR_ADDRESS_SHFT 0

/* =====================================================================================

  ---PCIE2AP_REMAP_DOMAIN_ID (0x1800E000 + 0x240)---

    R_PCIE2AP_REMAP_DOMAIN_ID[3..0] - (RW)  xxx 
    RESERVED4[31..4]             - (RO) Reserved bits

 =====================================================================================*/
#define CONN_BUS_CR_PCIE2AP_REMAP_DOMAIN_ID_R_PCIE2AP_REMAP_DOMAIN_ID_ADDR CONN_BUS_CR_PCIE2AP_REMAP_DOMAIN_ID_ADDR
#define CONN_BUS_CR_PCIE2AP_REMAP_DOMAIN_ID_R_PCIE2AP_REMAP_DOMAIN_ID_MASK 0x0000000F                // R_PCIE2AP_REMAP_DOMAIN_ID[3..0]
#define CONN_BUS_CR_PCIE2AP_REMAP_DOMAIN_ID_R_PCIE2AP_REMAP_DOMAIN_ID_SHFT 0

/* =====================================================================================

  ---PCIE2AP_REMAP_0 (0x1800E000 + 0x244)---

    R_PCIE2AP_PUBLIC_REMAPPING_0[15..0] - (RW)  xxx 
    R_PCIE2AP_PUBLIC_REMAPPING_1[31..16] - (RW)  xxx 

 =====================================================================================*/
#define CONN_BUS_CR_PCIE2AP_REMAP_0_R_PCIE2AP_PUBLIC_REMAPPING_1_ADDR CONN_BUS_CR_PCIE2AP_REMAP_0_ADDR
#define CONN_BUS_CR_PCIE2AP_REMAP_0_R_PCIE2AP_PUBLIC_REMAPPING_1_MASK 0xFFFF0000                // R_PCIE2AP_PUBLIC_REMAPPING_1[31..16]
#define CONN_BUS_CR_PCIE2AP_REMAP_0_R_PCIE2AP_PUBLIC_REMAPPING_1_SHFT 16
#define CONN_BUS_CR_PCIE2AP_REMAP_0_R_PCIE2AP_PUBLIC_REMAPPING_0_ADDR CONN_BUS_CR_PCIE2AP_REMAP_0_ADDR
#define CONN_BUS_CR_PCIE2AP_REMAP_0_R_PCIE2AP_PUBLIC_REMAPPING_0_MASK 0x0000FFFF                // R_PCIE2AP_PUBLIC_REMAPPING_0[15..0]
#define CONN_BUS_CR_PCIE2AP_REMAP_0_R_PCIE2AP_PUBLIC_REMAPPING_0_SHFT 0

/* =====================================================================================

  ---PCIE2AP_REMAP_1 (0x1800E000 + 0x248)---

    R_PCIE2AP_PUBLIC_REMAPPING_2[15..0] - (RW)  xxx 
    R_PCIE2AP_PUBLIC_REMAPPING_3[31..16] - (RW)  xxx 

 =====================================================================================*/
#define CONN_BUS_CR_PCIE2AP_REMAP_1_R_PCIE2AP_PUBLIC_REMAPPING_3_ADDR CONN_BUS_CR_PCIE2AP_REMAP_1_ADDR
#define CONN_BUS_CR_PCIE2AP_REMAP_1_R_PCIE2AP_PUBLIC_REMAPPING_3_MASK 0xFFFF0000                // R_PCIE2AP_PUBLIC_REMAPPING_3[31..16]
#define CONN_BUS_CR_PCIE2AP_REMAP_1_R_PCIE2AP_PUBLIC_REMAPPING_3_SHFT 16
#define CONN_BUS_CR_PCIE2AP_REMAP_1_R_PCIE2AP_PUBLIC_REMAPPING_2_ADDR CONN_BUS_CR_PCIE2AP_REMAP_1_ADDR
#define CONN_BUS_CR_PCIE2AP_REMAP_1_R_PCIE2AP_PUBLIC_REMAPPING_2_MASK 0x0000FFFF                // R_PCIE2AP_PUBLIC_REMAPPING_2[15..0]
#define CONN_BUS_CR_PCIE2AP_REMAP_1_R_PCIE2AP_PUBLIC_REMAPPING_2_SHFT 0

/* =====================================================================================

  ---PCIE2AP_REMAP_2 (0x1800E000 + 0x24C)---

    R_PCIE2AP_PUBLIC_REMAPPING_4[15..0] - (RW)  xxx 
    R_PCIE2AP_PUBLIC_REMAPPING_5[31..16] - (RW)  xxx 

 =====================================================================================*/
#define CONN_BUS_CR_PCIE2AP_REMAP_2_R_PCIE2AP_PUBLIC_REMAPPING_5_ADDR CONN_BUS_CR_PCIE2AP_REMAP_2_ADDR
#define CONN_BUS_CR_PCIE2AP_REMAP_2_R_PCIE2AP_PUBLIC_REMAPPING_5_MASK 0xFFFF0000                // R_PCIE2AP_PUBLIC_REMAPPING_5[31..16]
#define CONN_BUS_CR_PCIE2AP_REMAP_2_R_PCIE2AP_PUBLIC_REMAPPING_5_SHFT 16
#define CONN_BUS_CR_PCIE2AP_REMAP_2_R_PCIE2AP_PUBLIC_REMAPPING_4_ADDR CONN_BUS_CR_PCIE2AP_REMAP_2_ADDR
#define CONN_BUS_CR_PCIE2AP_REMAP_2_R_PCIE2AP_PUBLIC_REMAPPING_4_MASK 0x0000FFFF                // R_PCIE2AP_PUBLIC_REMAPPING_4[15..0]
#define CONN_BUS_CR_PCIE2AP_REMAP_2_R_PCIE2AP_PUBLIC_REMAPPING_4_SHFT 0

/* =====================================================================================

  ---PCIE2AP_REMAP_3 (0x1800E000 + 0x250)---

    R_PCIE2AP_PUBLIC_REMAPPING_6[15..0] - (RW)  xxx 
    R_PCIE2AP_PUBLIC_REMAPPING_7[31..16] - (RW)  xxx 

 =====================================================================================*/
#define CONN_BUS_CR_PCIE2AP_REMAP_3_R_PCIE2AP_PUBLIC_REMAPPING_7_ADDR CONN_BUS_CR_PCIE2AP_REMAP_3_ADDR
#define CONN_BUS_CR_PCIE2AP_REMAP_3_R_PCIE2AP_PUBLIC_REMAPPING_7_MASK 0xFFFF0000                // R_PCIE2AP_PUBLIC_REMAPPING_7[31..16]
#define CONN_BUS_CR_PCIE2AP_REMAP_3_R_PCIE2AP_PUBLIC_REMAPPING_7_SHFT 16
#define CONN_BUS_CR_PCIE2AP_REMAP_3_R_PCIE2AP_PUBLIC_REMAPPING_6_ADDR CONN_BUS_CR_PCIE2AP_REMAP_3_ADDR
#define CONN_BUS_CR_PCIE2AP_REMAP_3_R_PCIE2AP_PUBLIC_REMAPPING_6_MASK 0x0000FFFF                // R_PCIE2AP_PUBLIC_REMAPPING_6[15..0]
#define CONN_BUS_CR_PCIE2AP_REMAP_3_R_PCIE2AP_PUBLIC_REMAPPING_6_SHFT 0

/* =====================================================================================

  ---PCIE2AP_REMAP_4 (0x1800E000 + 0x254)---

    R_PCIE2AP_PUBLIC_REMAPPING_8[15..0] - (RW)  xxx 
    R_PCIE2AP_PUBLIC_REMAPPING_9[31..16] - (RW)  xxx 

 =====================================================================================*/
#define CONN_BUS_CR_PCIE2AP_REMAP_4_R_PCIE2AP_PUBLIC_REMAPPING_9_ADDR CONN_BUS_CR_PCIE2AP_REMAP_4_ADDR
#define CONN_BUS_CR_PCIE2AP_REMAP_4_R_PCIE2AP_PUBLIC_REMAPPING_9_MASK 0xFFFF0000                // R_PCIE2AP_PUBLIC_REMAPPING_9[31..16]
#define CONN_BUS_CR_PCIE2AP_REMAP_4_R_PCIE2AP_PUBLIC_REMAPPING_9_SHFT 16
#define CONN_BUS_CR_PCIE2AP_REMAP_4_R_PCIE2AP_PUBLIC_REMAPPING_8_ADDR CONN_BUS_CR_PCIE2AP_REMAP_4_ADDR
#define CONN_BUS_CR_PCIE2AP_REMAP_4_R_PCIE2AP_PUBLIC_REMAPPING_8_MASK 0x0000FFFF                // R_PCIE2AP_PUBLIC_REMAPPING_8[15..0]
#define CONN_BUS_CR_PCIE2AP_REMAP_4_R_PCIE2AP_PUBLIC_REMAPPING_8_SHFT 0

/* =====================================================================================

  ---PCIE2AP_REMAP_5 (0x1800E000 + 0x258)---

    R_PCIE2AP_PUBLIC_REMAPPING_A[15..0] - (RW)  xxx 
    R_PCIE2AP_PUBLIC_REMAPPING_B[31..16] - (RW)  xxx 

 =====================================================================================*/
#define CONN_BUS_CR_PCIE2AP_REMAP_5_R_PCIE2AP_PUBLIC_REMAPPING_B_ADDR CONN_BUS_CR_PCIE2AP_REMAP_5_ADDR
#define CONN_BUS_CR_PCIE2AP_REMAP_5_R_PCIE2AP_PUBLIC_REMAPPING_B_MASK 0xFFFF0000                // R_PCIE2AP_PUBLIC_REMAPPING_B[31..16]
#define CONN_BUS_CR_PCIE2AP_REMAP_5_R_PCIE2AP_PUBLIC_REMAPPING_B_SHFT 16
#define CONN_BUS_CR_PCIE2AP_REMAP_5_R_PCIE2AP_PUBLIC_REMAPPING_A_ADDR CONN_BUS_CR_PCIE2AP_REMAP_5_ADDR
#define CONN_BUS_CR_PCIE2AP_REMAP_5_R_PCIE2AP_PUBLIC_REMAPPING_A_MASK 0x0000FFFF                // R_PCIE2AP_PUBLIC_REMAPPING_A[15..0]
#define CONN_BUS_CR_PCIE2AP_REMAP_5_R_PCIE2AP_PUBLIC_REMAPPING_A_SHFT 0

/* =====================================================================================

  ---PCIE2AP_REMAP_6 (0x1800E000 + 0x25C)---

    R_PCIE2AP_PUBLIC_REMAPPING_C[15..0] - (RW)  xxx 
    R_PCIE2AP_PUBLIC_REMAPPING_D[31..16] - (RW)  xxx 

 =====================================================================================*/
#define CONN_BUS_CR_PCIE2AP_REMAP_6_R_PCIE2AP_PUBLIC_REMAPPING_D_ADDR CONN_BUS_CR_PCIE2AP_REMAP_6_ADDR
#define CONN_BUS_CR_PCIE2AP_REMAP_6_R_PCIE2AP_PUBLIC_REMAPPING_D_MASK 0xFFFF0000                // R_PCIE2AP_PUBLIC_REMAPPING_D[31..16]
#define CONN_BUS_CR_PCIE2AP_REMAP_6_R_PCIE2AP_PUBLIC_REMAPPING_D_SHFT 16
#define CONN_BUS_CR_PCIE2AP_REMAP_6_R_PCIE2AP_PUBLIC_REMAPPING_C_ADDR CONN_BUS_CR_PCIE2AP_REMAP_6_ADDR
#define CONN_BUS_CR_PCIE2AP_REMAP_6_R_PCIE2AP_PUBLIC_REMAPPING_C_MASK 0x0000FFFF                // R_PCIE2AP_PUBLIC_REMAPPING_C[15..0]
#define CONN_BUS_CR_PCIE2AP_REMAP_6_R_PCIE2AP_PUBLIC_REMAPPING_C_SHFT 0

/* =====================================================================================

  ---PCIE2AP_REMAP_7 (0x1800E000 + 0x260)---

    R_PCIE2AP_PUBLIC_REMAPPING_E[15..0] - (RW)  xxx 
    R_PCIE2AP_PUBLIC_REMAPPING_F[31..16] - (RO)  xxx 

 =====================================================================================*/
#define CONN_BUS_CR_PCIE2AP_REMAP_7_R_PCIE2AP_PUBLIC_REMAPPING_F_ADDR CONN_BUS_CR_PCIE2AP_REMAP_7_ADDR
#define CONN_BUS_CR_PCIE2AP_REMAP_7_R_PCIE2AP_PUBLIC_REMAPPING_F_MASK 0xFFFF0000                // R_PCIE2AP_PUBLIC_REMAPPING_F[31..16]
#define CONN_BUS_CR_PCIE2AP_REMAP_7_R_PCIE2AP_PUBLIC_REMAPPING_F_SHFT 16
#define CONN_BUS_CR_PCIE2AP_REMAP_7_R_PCIE2AP_PUBLIC_REMAPPING_E_ADDR CONN_BUS_CR_PCIE2AP_REMAP_7_ADDR
#define CONN_BUS_CR_PCIE2AP_REMAP_7_R_PCIE2AP_PUBLIC_REMAPPING_E_MASK 0x0000FFFF                // R_PCIE2AP_PUBLIC_REMAPPING_E[15..0]
#define CONN_BUS_CR_PCIE2AP_REMAP_7_R_PCIE2AP_PUBLIC_REMAPPING_E_SHFT 0

/* =====================================================================================

  ---MST_WF_RBIST_IDLE_DIS (0x1800E000 + 0x270)---

    CR_MST_WF_RBIST_IDLE_DIS[0]  - (RW) if CR_MST_WF_RBIST_LDLE_DIS=1'b0, the idle signal of wf_rbist will be valid, or not referenced
    RESERVED1[31..1]             - (RO) Reserved bits

 =====================================================================================*/
#define CONN_BUS_CR_MST_WF_RBIST_IDLE_DIS_CR_MST_WF_RBIST_IDLE_DIS_ADDR CONN_BUS_CR_MST_WF_RBIST_IDLE_DIS_ADDR
#define CONN_BUS_CR_MST_WF_RBIST_IDLE_DIS_CR_MST_WF_RBIST_IDLE_DIS_MASK 0x00000001                // CR_MST_WF_RBIST_IDLE_DIS[0]
#define CONN_BUS_CR_MST_WF_RBIST_IDLE_DIS_CR_MST_WF_RBIST_IDLE_DIS_SHFT 0

/* =====================================================================================

  ---MST_WF_IDLE_DIS (0x1800E000 + 0x274)---

    CR_MST_WF_IDLE_DIS[0]        - (RW) if CR_MST_WF_LDLE_DIS=1'b0, the idle signal of wf will be valid, or not referenced
    RESERVED1[31..1]             - (RO) Reserved bits

 =====================================================================================*/
#define CONN_BUS_CR_MST_WF_IDLE_DIS_CR_MST_WF_IDLE_DIS_ADDR    CONN_BUS_CR_MST_WF_IDLE_DIS_ADDR
#define CONN_BUS_CR_MST_WF_IDLE_DIS_CR_MST_WF_IDLE_DIS_MASK    0x00000001                // CR_MST_WF_IDLE_DIS[0]
#define CONN_BUS_CR_MST_WF_IDLE_DIS_CR_MST_WF_IDLE_DIS_SHFT    0

/* =====================================================================================

  ---MST_BT_IDLE_DIS (0x1800E000 + 0x278)---

    CR_MST_BT_IDLE_DIS[0]        - (RW) if CR_MST_BT_LDLE_DIS=1'b0, the idle signal of bt will be valid, or not referenced
    RESERVED1[31..1]             - (RO) Reserved bits

 =====================================================================================*/
#define CONN_BUS_CR_MST_BT_IDLE_DIS_CR_MST_BT_IDLE_DIS_ADDR    CONN_BUS_CR_MST_BT_IDLE_DIS_ADDR
#define CONN_BUS_CR_MST_BT_IDLE_DIS_CR_MST_BT_IDLE_DIS_MASK    0x00000001                // CR_MST_BT_IDLE_DIS[0]
#define CONN_BUS_CR_MST_BT_IDLE_DIS_CR_MST_BT_IDLE_DIS_SHFT    0

/* =====================================================================================

  ---MST_GPS_IDLE_DIS (0x1800E000 + 0x27C)---

    CR_MST_GPS_IDLE_DIS[0]       - (RW) if CR_MST_GPS_LDLE_DIS=1'b0, the idle signal of gps will be valid, or not referenced
    RESERVED1[31..1]             - (RO) Reserved bits

 =====================================================================================*/
#define CONN_BUS_CR_MST_GPS_IDLE_DIS_CR_MST_GPS_IDLE_DIS_ADDR  CONN_BUS_CR_MST_GPS_IDLE_DIS_ADDR
#define CONN_BUS_CR_MST_GPS_IDLE_DIS_CR_MST_GPS_IDLE_DIS_MASK  0x00000001                // CR_MST_GPS_IDLE_DIS[0]
#define CONN_BUS_CR_MST_GPS_IDLE_DIS_CR_MST_GPS_IDLE_DIS_SHFT  0

/* =====================================================================================

  ---MST_INFRA_ON_IDLE_DIS (0x1800E000 + 0x280)---

    CR_MST_INFRA_ON_IDLE_DIS[0]  - (RW) if CR_MST_CONN_INFRA_ON_LDLE_DIS=1'b0, the idle signal of conn_infra_on will be valid, or not referenced
    RESERVED1[31..1]             - (RO) Reserved bits

 =====================================================================================*/
#define CONN_BUS_CR_MST_INFRA_ON_IDLE_DIS_CR_MST_INFRA_ON_IDLE_DIS_ADDR CONN_BUS_CR_MST_INFRA_ON_IDLE_DIS_ADDR
#define CONN_BUS_CR_MST_INFRA_ON_IDLE_DIS_CR_MST_INFRA_ON_IDLE_DIS_MASK 0x00000001                // CR_MST_INFRA_ON_IDLE_DIS[0]
#define CONN_BUS_CR_MST_INFRA_ON_IDLE_DIS_CR_MST_INFRA_ON_IDLE_DIS_SHFT 0

/* =====================================================================================

  ---SLV_AP_IDLE_DIS (0x1800E000 + 0x284)---

    CR_SLV_AP_IDLE_DIS[0]        - (RW) if CR_SLV_AP_LDLE_DIS=1'b0, the idle signal of ap will be valid, or not referenced
    RESERVED1[31..1]             - (RO) Reserved bits

 =====================================================================================*/
#define CONN_BUS_CR_SLV_AP_IDLE_DIS_CR_SLV_AP_IDLE_DIS_ADDR    CONN_BUS_CR_SLV_AP_IDLE_DIS_ADDR
#define CONN_BUS_CR_SLV_AP_IDLE_DIS_CR_SLV_AP_IDLE_DIS_MASK    0x00000001                // CR_SLV_AP_IDLE_DIS[0]
#define CONN_BUS_CR_SLV_AP_IDLE_DIS_CR_SLV_AP_IDLE_DIS_SHFT    0

/* =====================================================================================

  ---SLV_WF_IDLE_DIS (0x1800E000 + 0x288)---

    CR_SLV_WF_IDLE_DIS[0]        - (RW) if CR_SLV_WF_LDLE_DIS=1'b0, the idle signal of wf will be valid, or not referenced
    RESERVED1[31..1]             - (RO) Reserved bits

 =====================================================================================*/
#define CONN_BUS_CR_SLV_WF_IDLE_DIS_CR_SLV_WF_IDLE_DIS_ADDR    CONN_BUS_CR_SLV_WF_IDLE_DIS_ADDR
#define CONN_BUS_CR_SLV_WF_IDLE_DIS_CR_SLV_WF_IDLE_DIS_MASK    0x00000001                // CR_SLV_WF_IDLE_DIS[0]
#define CONN_BUS_CR_SLV_WF_IDLE_DIS_CR_SLV_WF_IDLE_DIS_SHFT    0

/* =====================================================================================

  ---SLV_BT_IDLE_DIS (0x1800E000 + 0x28C)---

    CR_SLV_BT_IDLE_DIS[0]        - (RW) if CR_SLV_BT_LDLE_DIS=1'b0, the idle signal of bt will be valid, or not referenced
    RESERVED1[31..1]             - (RO) Reserved bits

 =====================================================================================*/
#define CONN_BUS_CR_SLV_BT_IDLE_DIS_CR_SLV_BT_IDLE_DIS_ADDR    CONN_BUS_CR_SLV_BT_IDLE_DIS_ADDR
#define CONN_BUS_CR_SLV_BT_IDLE_DIS_CR_SLV_BT_IDLE_DIS_MASK    0x00000001                // CR_SLV_BT_IDLE_DIS[0]
#define CONN_BUS_CR_SLV_BT_IDLE_DIS_CR_SLV_BT_IDLE_DIS_SHFT    0

/* =====================================================================================

  ---SLV_GPS_IDLE_DIS (0x1800E000 + 0x290)---

    CR_SLV_GPS_IDLE_DIS[0]       - (RW) if CR_SLV_GPS_LDLE_DIS=1'b0, the idle signal of gps will be valid, or not referenced
    RESERVED1[31..1]             - (RO) Reserved bits

 =====================================================================================*/
#define CONN_BUS_CR_SLV_GPS_IDLE_DIS_CR_SLV_GPS_IDLE_DIS_ADDR  CONN_BUS_CR_SLV_GPS_IDLE_DIS_ADDR
#define CONN_BUS_CR_SLV_GPS_IDLE_DIS_CR_SLV_GPS_IDLE_DIS_MASK  0x00000001                // CR_SLV_GPS_IDLE_DIS[0]
#define CONN_BUS_CR_SLV_GPS_IDLE_DIS_CR_SLV_GPS_IDLE_DIS_SHFT  0

/* =====================================================================================

  ---SLV_INFRA_ON_IDLE_DIS (0x1800E000 + 0x294)---

    CR_SLV_INFRA_ON_IDLE_DIS[0]  - (RW) if CR_SLV_CONN_INFRA_ON_LDLE_DIS=1'b0, the idle signal of conn_infra_on will be valid, or not referenced
    RESERVED1[31..1]             - (RO) Reserved bits

 =====================================================================================*/
#define CONN_BUS_CR_SLV_INFRA_ON_IDLE_DIS_CR_SLV_INFRA_ON_IDLE_DIS_ADDR CONN_BUS_CR_SLV_INFRA_ON_IDLE_DIS_ADDR
#define CONN_BUS_CR_SLV_INFRA_ON_IDLE_DIS_CR_SLV_INFRA_ON_IDLE_DIS_MASK 0x00000001                // CR_SLV_INFRA_ON_IDLE_DIS[0]
#define CONN_BUS_CR_SLV_INFRA_ON_IDLE_DIS_CR_SLV_INFRA_ON_IDLE_DIS_SHFT 0

/* =====================================================================================

  ---SLV_OTHER_IDLE_DIS (0x1800E000 + 0x298)---

    CR_SLV_OTHER_IDLE_DIS[0]     - (RW) if CR_SLV_OTHER_LDLE_DIS=1'b0, the idle signal of it will be valid, or not referenced
    RESERVED1[31..1]             - (RO) Reserved bits

 =====================================================================================*/
#define CONN_BUS_CR_SLV_OTHER_IDLE_DIS_CR_SLV_OTHER_IDLE_DIS_ADDR CONN_BUS_CR_SLV_OTHER_IDLE_DIS_ADDR
#define CONN_BUS_CR_SLV_OTHER_IDLE_DIS_CR_SLV_OTHER_IDLE_DIS_MASK 0x00000001                // CR_SLV_OTHER_IDLE_DIS[0]
#define CONN_BUS_CR_SLV_OTHER_IDLE_DIS_CR_SLV_OTHER_IDLE_DIS_SHFT 0

/* =====================================================================================

  ---BUS_IDLE_DEBOUNCE (0x1800E000 + 0x29C)---

    CR_BUS_IDLE_DEBOUNCE[4..0]   - (RW) if the time of idle signal = CR_BUS_IDLE_DEBOUNCE, the idle signal will be sent to bus
    RESERVED5[31..5]             - (RO) Reserved bits

 =====================================================================================*/
#define CONN_BUS_CR_BUS_IDLE_DEBOUNCE_CR_BUS_IDLE_DEBOUNCE_ADDR CONN_BUS_CR_BUS_IDLE_DEBOUNCE_ADDR
#define CONN_BUS_CR_BUS_IDLE_DEBOUNCE_CR_BUS_IDLE_DEBOUNCE_MASK 0x0000001F                // CR_BUS_IDLE_DEBOUNCE[4..0]
#define CONN_BUS_CR_BUS_IDLE_DEBOUNCE_CR_BUS_IDLE_DEBOUNCE_SHFT 0

/* =====================================================================================

  ---GALS_AP2CONN_GALS_DBG (0x1800E000 + 0x2A0)---

    RO_AP2CONN_CBIP_GALS_SIDEBAND_GALS_AXI_DBG_SLV[31..0] - (RO)  xxx 

 =====================================================================================*/
#define CONN_BUS_CR_GALS_AP2CONN_GALS_DBG_RO_AP2CONN_CBIP_GALS_SIDEBAND_GALS_AXI_DBG_SLV_ADDR CONN_BUS_CR_GALS_AP2CONN_GALS_DBG_ADDR
#define CONN_BUS_CR_GALS_AP2CONN_GALS_DBG_RO_AP2CONN_CBIP_GALS_SIDEBAND_GALS_AXI_DBG_SLV_MASK 0xFFFFFFFF                // RO_AP2CONN_CBIP_GALS_SIDEBAND_GALS_AXI_DBG_SLV[31..0]
#define CONN_BUS_CR_GALS_AP2CONN_GALS_DBG_RO_AP2CONN_CBIP_GALS_SIDEBAND_GALS_AXI_DBG_SLV_SHFT 0

/* =====================================================================================

  ---GALS_CONN2AP_GALS_DBG (0x1800E000 + 0x2A4)---

    RO_CONN2AP_CBIP_GALS_SIDEBAND_GALS_AXI_DBG_SLV[31..0] - (RO)  xxx 

 =====================================================================================*/
#define CONN_BUS_CR_GALS_CONN2AP_GALS_DBG_RO_CONN2AP_CBIP_GALS_SIDEBAND_GALS_AXI_DBG_SLV_ADDR CONN_BUS_CR_GALS_CONN2AP_GALS_DBG_ADDR
#define CONN_BUS_CR_GALS_CONN2AP_GALS_DBG_RO_CONN2AP_CBIP_GALS_SIDEBAND_GALS_AXI_DBG_SLV_MASK 0xFFFFFFFF                // RO_CONN2AP_CBIP_GALS_SIDEBAND_GALS_AXI_DBG_SLV[31..0]
#define CONN_BUS_CR_GALS_CONN2AP_GALS_DBG_RO_CONN2AP_CBIP_GALS_SIDEBAND_GALS_AXI_DBG_SLV_SHFT 0

/* =====================================================================================

  ---GALS_WF1_TO_CONN_GALS_DBG (0x1800E000 + 0x2A8)---

    RO_WF1_TO_CONN_CBIP_GALS_SIDEBAND_GALS_AXI_DBG_SLV[31..0] - (RO)  xxx 

 =====================================================================================*/
#define CONN_BUS_CR_GALS_WF1_TO_CONN_GALS_DBG_RO_WF1_TO_CONN_CBIP_GALS_SIDEBAND_GALS_AXI_DBG_SLV_ADDR CONN_BUS_CR_GALS_WF1_TO_CONN_GALS_DBG_ADDR
#define CONN_BUS_CR_GALS_WF1_TO_CONN_GALS_DBG_RO_WF1_TO_CONN_CBIP_GALS_SIDEBAND_GALS_AXI_DBG_SLV_MASK 0xFFFFFFFF                // RO_WF1_TO_CONN_CBIP_GALS_SIDEBAND_GALS_AXI_DBG_SLV[31..0]
#define CONN_BUS_CR_GALS_WF1_TO_CONN_GALS_DBG_RO_WF1_TO_CONN_CBIP_GALS_SIDEBAND_GALS_AXI_DBG_SLV_SHFT 0

/* =====================================================================================

  ---GALS_CONN_TO_WF1_GALS_DBG (0x1800E000 + 0x2AC)---

    RO_CONN_TO_WF1_CBIP_GALS_SIDEBAND_GALS_AHB_DBG_SLV[31..0] - (RO)  xxx 

 =====================================================================================*/
#define CONN_BUS_CR_GALS_CONN_TO_WF1_GALS_DBG_RO_CONN_TO_WF1_CBIP_GALS_SIDEBAND_GALS_AHB_DBG_SLV_ADDR CONN_BUS_CR_GALS_CONN_TO_WF1_GALS_DBG_ADDR
#define CONN_BUS_CR_GALS_CONN_TO_WF1_GALS_DBG_RO_CONN_TO_WF1_CBIP_GALS_SIDEBAND_GALS_AHB_DBG_SLV_MASK 0xFFFFFFFF                // RO_CONN_TO_WF1_CBIP_GALS_SIDEBAND_GALS_AHB_DBG_SLV[31..0]
#define CONN_BUS_CR_GALS_CONN_TO_WF1_GALS_DBG_RO_CONN_TO_WF1_CBIP_GALS_SIDEBAND_GALS_AHB_DBG_SLV_SHFT 0

/* =====================================================================================

  ---GALS_AP2CONN_GALS_CTRL (0x1800E000 + 0x2B8)---

    CONN_INFRA_AP2CONN_GALS_RX_SIDEBAND_RG_AFIFO_SYNC_SEL[1..0] - (RW)  xxx 
    RESERVED2[31..2]             - (RO) Reserved bits

 =====================================================================================*/
#define CONN_BUS_CR_GALS_AP2CONN_GALS_CTRL_CONN_INFRA_AP2CONN_GALS_RX_SIDEBAND_RG_AFIFO_SYNC_SEL_ADDR CONN_BUS_CR_GALS_AP2CONN_GALS_CTRL_ADDR
#define CONN_BUS_CR_GALS_AP2CONN_GALS_CTRL_CONN_INFRA_AP2CONN_GALS_RX_SIDEBAND_RG_AFIFO_SYNC_SEL_MASK 0x00000003                // CONN_INFRA_AP2CONN_GALS_RX_SIDEBAND_RG_AFIFO_SYNC_SEL[1..0]
#define CONN_BUS_CR_GALS_AP2CONN_GALS_CTRL_CONN_INFRA_AP2CONN_GALS_RX_SIDEBAND_RG_AFIFO_SYNC_SEL_SHFT 0

/* =====================================================================================

  ---GALS_CONN2AP_GALS_CTRL (0x1800E000 + 0x2BC)---

    R_CONN2AP_CBIP_GALS_SIDEBAND_SAMPLE_SEL[0] - (RW)  xxx 
    R_CONN2AP_CBIP_GALS_SIDEBAND_SLV_SYNC_SEL[2..1] - (RW)  xxx 
    R_CONN2AP_CBIP_GALS_SIDEBAND_MST_SYNC_SEL[4..3] - (RW)  xxx 
    R_CONN2AP_CBIP_GALS_SIDEBAND_IN_AWFLUSH_THRE[6..5] - (RW)  xxx 
    R_CONN2AP_CBIP_GALS_SIDEBAND_IN_ARFLUSH_THRE[8..7] - (RW)  xxx 
    RESERVED9[31..9]             - (RO) Reserved bits

 =====================================================================================*/
#define CONN_BUS_CR_GALS_CONN2AP_GALS_CTRL_R_CONN2AP_CBIP_GALS_SIDEBAND_IN_ARFLUSH_THRE_ADDR CONN_BUS_CR_GALS_CONN2AP_GALS_CTRL_ADDR
#define CONN_BUS_CR_GALS_CONN2AP_GALS_CTRL_R_CONN2AP_CBIP_GALS_SIDEBAND_IN_ARFLUSH_THRE_MASK 0x00000180                // R_CONN2AP_CBIP_GALS_SIDEBAND_IN_ARFLUSH_THRE[8..7]
#define CONN_BUS_CR_GALS_CONN2AP_GALS_CTRL_R_CONN2AP_CBIP_GALS_SIDEBAND_IN_ARFLUSH_THRE_SHFT 7
#define CONN_BUS_CR_GALS_CONN2AP_GALS_CTRL_R_CONN2AP_CBIP_GALS_SIDEBAND_IN_AWFLUSH_THRE_ADDR CONN_BUS_CR_GALS_CONN2AP_GALS_CTRL_ADDR
#define CONN_BUS_CR_GALS_CONN2AP_GALS_CTRL_R_CONN2AP_CBIP_GALS_SIDEBAND_IN_AWFLUSH_THRE_MASK 0x00000060                // R_CONN2AP_CBIP_GALS_SIDEBAND_IN_AWFLUSH_THRE[6..5]
#define CONN_BUS_CR_GALS_CONN2AP_GALS_CTRL_R_CONN2AP_CBIP_GALS_SIDEBAND_IN_AWFLUSH_THRE_SHFT 5
#define CONN_BUS_CR_GALS_CONN2AP_GALS_CTRL_R_CONN2AP_CBIP_GALS_SIDEBAND_MST_SYNC_SEL_ADDR CONN_BUS_CR_GALS_CONN2AP_GALS_CTRL_ADDR
#define CONN_BUS_CR_GALS_CONN2AP_GALS_CTRL_R_CONN2AP_CBIP_GALS_SIDEBAND_MST_SYNC_SEL_MASK 0x00000018                // R_CONN2AP_CBIP_GALS_SIDEBAND_MST_SYNC_SEL[4..3]
#define CONN_BUS_CR_GALS_CONN2AP_GALS_CTRL_R_CONN2AP_CBIP_GALS_SIDEBAND_MST_SYNC_SEL_SHFT 3
#define CONN_BUS_CR_GALS_CONN2AP_GALS_CTRL_R_CONN2AP_CBIP_GALS_SIDEBAND_SLV_SYNC_SEL_ADDR CONN_BUS_CR_GALS_CONN2AP_GALS_CTRL_ADDR
#define CONN_BUS_CR_GALS_CONN2AP_GALS_CTRL_R_CONN2AP_CBIP_GALS_SIDEBAND_SLV_SYNC_SEL_MASK 0x00000006                // R_CONN2AP_CBIP_GALS_SIDEBAND_SLV_SYNC_SEL[2..1]
#define CONN_BUS_CR_GALS_CONN2AP_GALS_CTRL_R_CONN2AP_CBIP_GALS_SIDEBAND_SLV_SYNC_SEL_SHFT 1
#define CONN_BUS_CR_GALS_CONN2AP_GALS_CTRL_R_CONN2AP_CBIP_GALS_SIDEBAND_SAMPLE_SEL_ADDR CONN_BUS_CR_GALS_CONN2AP_GALS_CTRL_ADDR
#define CONN_BUS_CR_GALS_CONN2AP_GALS_CTRL_R_CONN2AP_CBIP_GALS_SIDEBAND_SAMPLE_SEL_MASK 0x00000001                // R_CONN2AP_CBIP_GALS_SIDEBAND_SAMPLE_SEL[0]
#define CONN_BUS_CR_GALS_CONN2AP_GALS_CTRL_R_CONN2AP_CBIP_GALS_SIDEBAND_SAMPLE_SEL_SHFT 0

/* =====================================================================================

  ---GALS_WF1_TO_CONN_CTRL_0 (0x1800E000 + 0x2C0)---

    WF1_TO_CONN_CBIP_GALS_SIDEBAND_RG_AFIFO_SYNC_SEL[1..0] - (RW)  xxx 
    RESERVED2[31..2]             - (RO) Reserved bits

 =====================================================================================*/
#define CONN_BUS_CR_GALS_WF1_TO_CONN_CTRL_0_WF1_TO_CONN_CBIP_GALS_SIDEBAND_RG_AFIFO_SYNC_SEL_ADDR CONN_BUS_CR_GALS_WF1_TO_CONN_CTRL_0_ADDR
#define CONN_BUS_CR_GALS_WF1_TO_CONN_CTRL_0_WF1_TO_CONN_CBIP_GALS_SIDEBAND_RG_AFIFO_SYNC_SEL_MASK 0x00000003                // WF1_TO_CONN_CBIP_GALS_SIDEBAND_RG_AFIFO_SYNC_SEL[1..0]
#define CONN_BUS_CR_GALS_WF1_TO_CONN_CTRL_0_WF1_TO_CONN_CBIP_GALS_SIDEBAND_RG_AFIFO_SYNC_SEL_SHFT 0

/* =====================================================================================

  ---GALS_CONN_TO_WF1_CTRL_0 (0x1800E000 + 0x2C4)---

    R_CONN_TO_WF1_CBIP_GALS_SIDEBAND_AFIFO_SYNC_SEL[1..0] - (RW)  xxx 
    R_CONN_TO_WF1_CBIP_GALS_SIDEBAND_CMD_CNT_CLR[2] - (RW)  xxx 
    R_CONN_TO_WF1_CBIP_GALS_SIDEBAND_MONITOR_MODE[3] - (RW)  xxx 
    R_CONN_TO_WF1_CBIP_GALS_SIDEBAND_ERROR_FLAG_EN[4] - (RW)  xxx 
    R_CONN_TO_WF1_CBIP_GALS_SIDEBAND_POSTWRITE_DIS[5] - (RW) 1'b1: only support non-bufferable transation
                                     1'b0: support bufferable transation
    RO_CONN_TO_WF1_CBIP_GALS_SIDEBAND_BRIDGE_IDLE_SYNC[6] - (RO)  xxx 
    RO_CONN_TO_WF1_CBIP_GALS_SIDEBAND_BRIDGE_IDLE_ASYNC[7] - (RO)  xxx 
    RESERVED8[31..8]             - (RO) Reserved bits

 =====================================================================================*/
#define CONN_BUS_CR_GALS_CONN_TO_WF1_CTRL_0_RO_CONN_TO_WF1_CBIP_GALS_SIDEBAND_BRIDGE_IDLE_ASYNC_ADDR CONN_BUS_CR_GALS_CONN_TO_WF1_CTRL_0_ADDR
#define CONN_BUS_CR_GALS_CONN_TO_WF1_CTRL_0_RO_CONN_TO_WF1_CBIP_GALS_SIDEBAND_BRIDGE_IDLE_ASYNC_MASK 0x00000080                // RO_CONN_TO_WF1_CBIP_GALS_SIDEBAND_BRIDGE_IDLE_ASYNC[7]
#define CONN_BUS_CR_GALS_CONN_TO_WF1_CTRL_0_RO_CONN_TO_WF1_CBIP_GALS_SIDEBAND_BRIDGE_IDLE_ASYNC_SHFT 7
#define CONN_BUS_CR_GALS_CONN_TO_WF1_CTRL_0_RO_CONN_TO_WF1_CBIP_GALS_SIDEBAND_BRIDGE_IDLE_SYNC_ADDR CONN_BUS_CR_GALS_CONN_TO_WF1_CTRL_0_ADDR
#define CONN_BUS_CR_GALS_CONN_TO_WF1_CTRL_0_RO_CONN_TO_WF1_CBIP_GALS_SIDEBAND_BRIDGE_IDLE_SYNC_MASK 0x00000040                // RO_CONN_TO_WF1_CBIP_GALS_SIDEBAND_BRIDGE_IDLE_SYNC[6]
#define CONN_BUS_CR_GALS_CONN_TO_WF1_CTRL_0_RO_CONN_TO_WF1_CBIP_GALS_SIDEBAND_BRIDGE_IDLE_SYNC_SHFT 6
#define CONN_BUS_CR_GALS_CONN_TO_WF1_CTRL_0_R_CONN_TO_WF1_CBIP_GALS_SIDEBAND_POSTWRITE_DIS_ADDR CONN_BUS_CR_GALS_CONN_TO_WF1_CTRL_0_ADDR
#define CONN_BUS_CR_GALS_CONN_TO_WF1_CTRL_0_R_CONN_TO_WF1_CBIP_GALS_SIDEBAND_POSTWRITE_DIS_MASK 0x00000020                // R_CONN_TO_WF1_CBIP_GALS_SIDEBAND_POSTWRITE_DIS[5]
#define CONN_BUS_CR_GALS_CONN_TO_WF1_CTRL_0_R_CONN_TO_WF1_CBIP_GALS_SIDEBAND_POSTWRITE_DIS_SHFT 5
#define CONN_BUS_CR_GALS_CONN_TO_WF1_CTRL_0_R_CONN_TO_WF1_CBIP_GALS_SIDEBAND_ERROR_FLAG_EN_ADDR CONN_BUS_CR_GALS_CONN_TO_WF1_CTRL_0_ADDR
#define CONN_BUS_CR_GALS_CONN_TO_WF1_CTRL_0_R_CONN_TO_WF1_CBIP_GALS_SIDEBAND_ERROR_FLAG_EN_MASK 0x00000010                // R_CONN_TO_WF1_CBIP_GALS_SIDEBAND_ERROR_FLAG_EN[4]
#define CONN_BUS_CR_GALS_CONN_TO_WF1_CTRL_0_R_CONN_TO_WF1_CBIP_GALS_SIDEBAND_ERROR_FLAG_EN_SHFT 4
#define CONN_BUS_CR_GALS_CONN_TO_WF1_CTRL_0_R_CONN_TO_WF1_CBIP_GALS_SIDEBAND_MONITOR_MODE_ADDR CONN_BUS_CR_GALS_CONN_TO_WF1_CTRL_0_ADDR
#define CONN_BUS_CR_GALS_CONN_TO_WF1_CTRL_0_R_CONN_TO_WF1_CBIP_GALS_SIDEBAND_MONITOR_MODE_MASK 0x00000008                // R_CONN_TO_WF1_CBIP_GALS_SIDEBAND_MONITOR_MODE[3]
#define CONN_BUS_CR_GALS_CONN_TO_WF1_CTRL_0_R_CONN_TO_WF1_CBIP_GALS_SIDEBAND_MONITOR_MODE_SHFT 3
#define CONN_BUS_CR_GALS_CONN_TO_WF1_CTRL_0_R_CONN_TO_WF1_CBIP_GALS_SIDEBAND_CMD_CNT_CLR_ADDR CONN_BUS_CR_GALS_CONN_TO_WF1_CTRL_0_ADDR
#define CONN_BUS_CR_GALS_CONN_TO_WF1_CTRL_0_R_CONN_TO_WF1_CBIP_GALS_SIDEBAND_CMD_CNT_CLR_MASK 0x00000004                // R_CONN_TO_WF1_CBIP_GALS_SIDEBAND_CMD_CNT_CLR[2]
#define CONN_BUS_CR_GALS_CONN_TO_WF1_CTRL_0_R_CONN_TO_WF1_CBIP_GALS_SIDEBAND_CMD_CNT_CLR_SHFT 2
#define CONN_BUS_CR_GALS_CONN_TO_WF1_CTRL_0_R_CONN_TO_WF1_CBIP_GALS_SIDEBAND_AFIFO_SYNC_SEL_ADDR CONN_BUS_CR_GALS_CONN_TO_WF1_CTRL_0_ADDR
#define CONN_BUS_CR_GALS_CONN_TO_WF1_CTRL_0_R_CONN_TO_WF1_CBIP_GALS_SIDEBAND_AFIFO_SYNC_SEL_MASK 0x00000003                // R_CONN_TO_WF1_CBIP_GALS_SIDEBAND_AFIFO_SYNC_SEL[1..0]
#define CONN_BUS_CR_GALS_CONN_TO_WF1_CTRL_0_R_CONN_TO_WF1_CBIP_GALS_SIDEBAND_AFIFO_SYNC_SEL_SHFT 0

/* =====================================================================================

  ---BIST_CONN2AP_CTRL_0 (0x1800E000 + 0x2D0)---

    R_CONN2AP_TX_BIST_EN[0]      - (RW)  xxx 
    RESERVED1[1]                 - (RO) Reserved bits
    R_CONN2AP_TX_BIST_AWID_EN[3..2] - (RW)  xxx 
    R_CONN2AP_TX_BIST_AWLEN_EN[5..4] - (RW)  xxx 
    R_CONN2AP_TX_BIST_AWADDR_EN[7..6] - (RW)  xxx 
    R_CONN2AP_TX_BIST_AWSIZE_EN[9..8] - (RW)  xxx 
    R_CONN2AP_TX_BIST_AWBURST_EN[11..10] - (RW)  xxx 
    R_CONN2AP_TX_BIST_AWCACHE_EN[13..12] - (RW)  xxx 
    R_CONN2AP_TX_BIST_AWPROT_EN[15..14] - (RW)  xxx 
    R_CONN2AP_TX_BIST_AWUSER_EN[17..16] - (RW)  xxx 
    R_CONN2AP_TX_BIST_AWDOMAIN_APC_EN[19..18] - (RW)  xxx 
    R_CONN2AP_TX_BIST_AWULTRAL_EN[21..20] - (RW)  xxx 
    R_CONN2AP_TX_BIST_ARID_EN[23..22] - (RW)  xxx 
    R_CONN2AP_TX_BIST_ARLEN_EN[25..24] - (RW)  xxx 
    R_CONN2AP_TX_BIST_ARADDR_EN[27..26] - (RW)  xxx 
    R_CONN2AP_TX_BIST_ARSIZE_EN[29..28] - (RW)  xxx 
    R_CONN2AP_TX_BIST_ARBURST_EN[31..30] - (RW)  xxx 

 =====================================================================================*/
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_0_R_CONN2AP_TX_BIST_ARBURST_EN_ADDR CONN_BUS_CR_BIST_CONN2AP_CTRL_0_ADDR
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_0_R_CONN2AP_TX_BIST_ARBURST_EN_MASK 0xC0000000                // R_CONN2AP_TX_BIST_ARBURST_EN[31..30]
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_0_R_CONN2AP_TX_BIST_ARBURST_EN_SHFT 30
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_0_R_CONN2AP_TX_BIST_ARSIZE_EN_ADDR CONN_BUS_CR_BIST_CONN2AP_CTRL_0_ADDR
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_0_R_CONN2AP_TX_BIST_ARSIZE_EN_MASK 0x30000000                // R_CONN2AP_TX_BIST_ARSIZE_EN[29..28]
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_0_R_CONN2AP_TX_BIST_ARSIZE_EN_SHFT 28
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_0_R_CONN2AP_TX_BIST_ARADDR_EN_ADDR CONN_BUS_CR_BIST_CONN2AP_CTRL_0_ADDR
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_0_R_CONN2AP_TX_BIST_ARADDR_EN_MASK 0x0C000000                // R_CONN2AP_TX_BIST_ARADDR_EN[27..26]
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_0_R_CONN2AP_TX_BIST_ARADDR_EN_SHFT 26
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_0_R_CONN2AP_TX_BIST_ARLEN_EN_ADDR CONN_BUS_CR_BIST_CONN2AP_CTRL_0_ADDR
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_0_R_CONN2AP_TX_BIST_ARLEN_EN_MASK 0x03000000                // R_CONN2AP_TX_BIST_ARLEN_EN[25..24]
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_0_R_CONN2AP_TX_BIST_ARLEN_EN_SHFT 24
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_0_R_CONN2AP_TX_BIST_ARID_EN_ADDR CONN_BUS_CR_BIST_CONN2AP_CTRL_0_ADDR
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_0_R_CONN2AP_TX_BIST_ARID_EN_MASK 0x00C00000                // R_CONN2AP_TX_BIST_ARID_EN[23..22]
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_0_R_CONN2AP_TX_BIST_ARID_EN_SHFT 22
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_0_R_CONN2AP_TX_BIST_AWULTRAL_EN_ADDR CONN_BUS_CR_BIST_CONN2AP_CTRL_0_ADDR
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_0_R_CONN2AP_TX_BIST_AWULTRAL_EN_MASK 0x00300000                // R_CONN2AP_TX_BIST_AWULTRAL_EN[21..20]
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_0_R_CONN2AP_TX_BIST_AWULTRAL_EN_SHFT 20
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_0_R_CONN2AP_TX_BIST_AWDOMAIN_APC_EN_ADDR CONN_BUS_CR_BIST_CONN2AP_CTRL_0_ADDR
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_0_R_CONN2AP_TX_BIST_AWDOMAIN_APC_EN_MASK 0x000C0000                // R_CONN2AP_TX_BIST_AWDOMAIN_APC_EN[19..18]
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_0_R_CONN2AP_TX_BIST_AWDOMAIN_APC_EN_SHFT 18
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_0_R_CONN2AP_TX_BIST_AWUSER_EN_ADDR CONN_BUS_CR_BIST_CONN2AP_CTRL_0_ADDR
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_0_R_CONN2AP_TX_BIST_AWUSER_EN_MASK 0x00030000                // R_CONN2AP_TX_BIST_AWUSER_EN[17..16]
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_0_R_CONN2AP_TX_BIST_AWUSER_EN_SHFT 16
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_0_R_CONN2AP_TX_BIST_AWPROT_EN_ADDR CONN_BUS_CR_BIST_CONN2AP_CTRL_0_ADDR
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_0_R_CONN2AP_TX_BIST_AWPROT_EN_MASK 0x0000C000                // R_CONN2AP_TX_BIST_AWPROT_EN[15..14]
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_0_R_CONN2AP_TX_BIST_AWPROT_EN_SHFT 14
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_0_R_CONN2AP_TX_BIST_AWCACHE_EN_ADDR CONN_BUS_CR_BIST_CONN2AP_CTRL_0_ADDR
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_0_R_CONN2AP_TX_BIST_AWCACHE_EN_MASK 0x00003000                // R_CONN2AP_TX_BIST_AWCACHE_EN[13..12]
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_0_R_CONN2AP_TX_BIST_AWCACHE_EN_SHFT 12
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_0_R_CONN2AP_TX_BIST_AWBURST_EN_ADDR CONN_BUS_CR_BIST_CONN2AP_CTRL_0_ADDR
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_0_R_CONN2AP_TX_BIST_AWBURST_EN_MASK 0x00000C00                // R_CONN2AP_TX_BIST_AWBURST_EN[11..10]
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_0_R_CONN2AP_TX_BIST_AWBURST_EN_SHFT 10
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_0_R_CONN2AP_TX_BIST_AWSIZE_EN_ADDR CONN_BUS_CR_BIST_CONN2AP_CTRL_0_ADDR
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_0_R_CONN2AP_TX_BIST_AWSIZE_EN_MASK 0x00000300                // R_CONN2AP_TX_BIST_AWSIZE_EN[9..8]
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_0_R_CONN2AP_TX_BIST_AWSIZE_EN_SHFT 8
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_0_R_CONN2AP_TX_BIST_AWADDR_EN_ADDR CONN_BUS_CR_BIST_CONN2AP_CTRL_0_ADDR
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_0_R_CONN2AP_TX_BIST_AWADDR_EN_MASK 0x000000C0                // R_CONN2AP_TX_BIST_AWADDR_EN[7..6]
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_0_R_CONN2AP_TX_BIST_AWADDR_EN_SHFT 6
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_0_R_CONN2AP_TX_BIST_AWLEN_EN_ADDR CONN_BUS_CR_BIST_CONN2AP_CTRL_0_ADDR
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_0_R_CONN2AP_TX_BIST_AWLEN_EN_MASK 0x00000030                // R_CONN2AP_TX_BIST_AWLEN_EN[5..4]
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_0_R_CONN2AP_TX_BIST_AWLEN_EN_SHFT 4
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_0_R_CONN2AP_TX_BIST_AWID_EN_ADDR CONN_BUS_CR_BIST_CONN2AP_CTRL_0_ADDR
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_0_R_CONN2AP_TX_BIST_AWID_EN_MASK 0x0000000C                // R_CONN2AP_TX_BIST_AWID_EN[3..2]
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_0_R_CONN2AP_TX_BIST_AWID_EN_SHFT 2
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_0_R_CONN2AP_TX_BIST_EN_ADDR CONN_BUS_CR_BIST_CONN2AP_CTRL_0_ADDR
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_0_R_CONN2AP_TX_BIST_EN_MASK 0x00000001                // R_CONN2AP_TX_BIST_EN[0]
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_0_R_CONN2AP_TX_BIST_EN_SHFT 0

/* =====================================================================================

  ---BIST_CONN2AP_CTRL_1 (0x1800E000 + 0x2D4)---

    R_CONN2AP_TX_BIST_ARCACHE_EN[1..0] - (RW)  xxx 
    R_CONN2AP_TX_BIST_ARPROT_EN[3..2] - (RW)  xxx 
    R_CONN2AP_TX_BIST_ARUSER_EN[5..4] - (RW)  xxx 
    R_CONN2AP_TX_BIST_ARDOMAIN_APC_EN[7..6] - (RW)  xxx 
    R_CONN2AP_TX_BIST_ARULTRA_EN[9..8] - (RW)  xxx 
    R_CONN2AP_TX_BIST_WDATA_EN[11..10] - (RW)  xxx 
    R_CONN2AP_TX_BIST_WSTRB_EN[13..12] - (RW)  xxx 
    R_CONN2AP_TX_BIST_BRESP_EN[15..14] - (RW)  xxx 
    R_CONN2AP_TX_BIST_RDATA_EN[17..16] - (RW)  xxx 
    R_CONN2AP_TX_BIST_RRESP_EN[19..18] - (RW)  xxx 
    CONN2AP_BIST_DONE[20]        - (RO)  xxx 
    CONN2AP_BIST_FAIL[21]        - (RO)  xxx 
    RESERVED22[31..22]           - (RO) Reserved bits

 =====================================================================================*/
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_1_CONN2AP_BIST_FAIL_ADDR CONN_BUS_CR_BIST_CONN2AP_CTRL_1_ADDR
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_1_CONN2AP_BIST_FAIL_MASK 0x00200000                // CONN2AP_BIST_FAIL[21]
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_1_CONN2AP_BIST_FAIL_SHFT 21
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_1_CONN2AP_BIST_DONE_ADDR CONN_BUS_CR_BIST_CONN2AP_CTRL_1_ADDR
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_1_CONN2AP_BIST_DONE_MASK 0x00100000                // CONN2AP_BIST_DONE[20]
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_1_CONN2AP_BIST_DONE_SHFT 20
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_1_R_CONN2AP_TX_BIST_RRESP_EN_ADDR CONN_BUS_CR_BIST_CONN2AP_CTRL_1_ADDR
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_1_R_CONN2AP_TX_BIST_RRESP_EN_MASK 0x000C0000                // R_CONN2AP_TX_BIST_RRESP_EN[19..18]
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_1_R_CONN2AP_TX_BIST_RRESP_EN_SHFT 18
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_1_R_CONN2AP_TX_BIST_RDATA_EN_ADDR CONN_BUS_CR_BIST_CONN2AP_CTRL_1_ADDR
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_1_R_CONN2AP_TX_BIST_RDATA_EN_MASK 0x00030000                // R_CONN2AP_TX_BIST_RDATA_EN[17..16]
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_1_R_CONN2AP_TX_BIST_RDATA_EN_SHFT 16
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_1_R_CONN2AP_TX_BIST_BRESP_EN_ADDR CONN_BUS_CR_BIST_CONN2AP_CTRL_1_ADDR
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_1_R_CONN2AP_TX_BIST_BRESP_EN_MASK 0x0000C000                // R_CONN2AP_TX_BIST_BRESP_EN[15..14]
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_1_R_CONN2AP_TX_BIST_BRESP_EN_SHFT 14
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_1_R_CONN2AP_TX_BIST_WSTRB_EN_ADDR CONN_BUS_CR_BIST_CONN2AP_CTRL_1_ADDR
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_1_R_CONN2AP_TX_BIST_WSTRB_EN_MASK 0x00003000                // R_CONN2AP_TX_BIST_WSTRB_EN[13..12]
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_1_R_CONN2AP_TX_BIST_WSTRB_EN_SHFT 12
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_1_R_CONN2AP_TX_BIST_WDATA_EN_ADDR CONN_BUS_CR_BIST_CONN2AP_CTRL_1_ADDR
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_1_R_CONN2AP_TX_BIST_WDATA_EN_MASK 0x00000C00                // R_CONN2AP_TX_BIST_WDATA_EN[11..10]
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_1_R_CONN2AP_TX_BIST_WDATA_EN_SHFT 10
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_1_R_CONN2AP_TX_BIST_ARULTRA_EN_ADDR CONN_BUS_CR_BIST_CONN2AP_CTRL_1_ADDR
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_1_R_CONN2AP_TX_BIST_ARULTRA_EN_MASK 0x00000300                // R_CONN2AP_TX_BIST_ARULTRA_EN[9..8]
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_1_R_CONN2AP_TX_BIST_ARULTRA_EN_SHFT 8
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_1_R_CONN2AP_TX_BIST_ARDOMAIN_APC_EN_ADDR CONN_BUS_CR_BIST_CONN2AP_CTRL_1_ADDR
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_1_R_CONN2AP_TX_BIST_ARDOMAIN_APC_EN_MASK 0x000000C0                // R_CONN2AP_TX_BIST_ARDOMAIN_APC_EN[7..6]
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_1_R_CONN2AP_TX_BIST_ARDOMAIN_APC_EN_SHFT 6
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_1_R_CONN2AP_TX_BIST_ARUSER_EN_ADDR CONN_BUS_CR_BIST_CONN2AP_CTRL_1_ADDR
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_1_R_CONN2AP_TX_BIST_ARUSER_EN_MASK 0x00000030                // R_CONN2AP_TX_BIST_ARUSER_EN[5..4]
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_1_R_CONN2AP_TX_BIST_ARUSER_EN_SHFT 4
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_1_R_CONN2AP_TX_BIST_ARPROT_EN_ADDR CONN_BUS_CR_BIST_CONN2AP_CTRL_1_ADDR
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_1_R_CONN2AP_TX_BIST_ARPROT_EN_MASK 0x0000000C                // R_CONN2AP_TX_BIST_ARPROT_EN[3..2]
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_1_R_CONN2AP_TX_BIST_ARPROT_EN_SHFT 2
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_1_R_CONN2AP_TX_BIST_ARCACHE_EN_ADDR CONN_BUS_CR_BIST_CONN2AP_CTRL_1_ADDR
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_1_R_CONN2AP_TX_BIST_ARCACHE_EN_MASK 0x00000003                // R_CONN2AP_TX_BIST_ARCACHE_EN[1..0]
#define CONN_BUS_CR_BIST_CONN2AP_CTRL_1_R_CONN2AP_TX_BIST_ARCACHE_EN_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_DCM_CLOCK_CTRL (0x1800E000 + 0x2D8)---

    DCM_TOP_M2_INTERNAL_EMI_EARLY_WAKEUP[0] - (RW)  xxx 
    DCM_TOP_M2_INTERNAL_CR_EARLY_WAKEUP[1] - (RW)  xxx 
    DCM_CONN_INFRA_VDNR_CONN_INFRA_VDNR_SC_AXI_DCM_DIS[2] - (RW)  xxx 
    DCM_CONN_INFRA_VDNR_CONN_INFRA_VDNR_REG_DBG_I2C_CLK_CTRL[10..3] - (RW)  xxx 
    RESERVED11[31..11]           - (RO) Reserved bits

 =====================================================================================*/
#define CONN_BUS_CR_CONN_INFRA_DCM_CLOCK_CTRL_DCM_CONN_INFRA_VDNR_CONN_INFRA_VDNR_REG_DBG_I2C_CLK_CTRL_ADDR CONN_BUS_CR_CONN_INFRA_DCM_CLOCK_CTRL_ADDR
#define CONN_BUS_CR_CONN_INFRA_DCM_CLOCK_CTRL_DCM_CONN_INFRA_VDNR_CONN_INFRA_VDNR_REG_DBG_I2C_CLK_CTRL_MASK 0x000007F8                // DCM_CONN_INFRA_VDNR_CONN_INFRA_VDNR_REG_DBG_I2C_CLK_CTRL[10..3]
#define CONN_BUS_CR_CONN_INFRA_DCM_CLOCK_CTRL_DCM_CONN_INFRA_VDNR_CONN_INFRA_VDNR_REG_DBG_I2C_CLK_CTRL_SHFT 3
#define CONN_BUS_CR_CONN_INFRA_DCM_CLOCK_CTRL_DCM_CONN_INFRA_VDNR_CONN_INFRA_VDNR_SC_AXI_DCM_DIS_ADDR CONN_BUS_CR_CONN_INFRA_DCM_CLOCK_CTRL_ADDR
#define CONN_BUS_CR_CONN_INFRA_DCM_CLOCK_CTRL_DCM_CONN_INFRA_VDNR_CONN_INFRA_VDNR_SC_AXI_DCM_DIS_MASK 0x00000004                // DCM_CONN_INFRA_VDNR_CONN_INFRA_VDNR_SC_AXI_DCM_DIS[2]
#define CONN_BUS_CR_CONN_INFRA_DCM_CLOCK_CTRL_DCM_CONN_INFRA_VDNR_CONN_INFRA_VDNR_SC_AXI_DCM_DIS_SHFT 2
#define CONN_BUS_CR_CONN_INFRA_DCM_CLOCK_CTRL_DCM_TOP_M2_INTERNAL_CR_EARLY_WAKEUP_ADDR CONN_BUS_CR_CONN_INFRA_DCM_CLOCK_CTRL_ADDR
#define CONN_BUS_CR_CONN_INFRA_DCM_CLOCK_CTRL_DCM_TOP_M2_INTERNAL_CR_EARLY_WAKEUP_MASK 0x00000002                // DCM_TOP_M2_INTERNAL_CR_EARLY_WAKEUP[1]
#define CONN_BUS_CR_CONN_INFRA_DCM_CLOCK_CTRL_DCM_TOP_M2_INTERNAL_CR_EARLY_WAKEUP_SHFT 1
#define CONN_BUS_CR_CONN_INFRA_DCM_CLOCK_CTRL_DCM_TOP_M2_INTERNAL_EMI_EARLY_WAKEUP_ADDR CONN_BUS_CR_CONN_INFRA_DCM_CLOCK_CTRL_ADDR
#define CONN_BUS_CR_CONN_INFRA_DCM_CLOCK_CTRL_DCM_TOP_M2_INTERNAL_EMI_EARLY_WAKEUP_MASK 0x00000001                // DCM_TOP_M2_INTERNAL_EMI_EARLY_WAKEUP[0]
#define CONN_BUS_CR_CONN_INFRA_DCM_CLOCK_CTRL_DCM_TOP_M2_INTERNAL_EMI_EARLY_WAKEUP_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_DEVAPC_DBG_CTRL (0x1800E000 + 0x2DC)---

    DEVAPC_WRAPPER_DEVICE_ABORT_TYPEB[0] - (RW)  xxx 
    DEVAPC_WRAPPER_DBG_MODE[1]   - (RW)  xxx 
    DEVAPC_WRAPPER_SEN[2]        - (RO)  xxx 
    DEVAPC_WRAPPER_SECURE_VIO_IRQ_B[3] - (RO)  xxx 
    DEVAPC_WRAPPER_DEVAPC_SHFT_BUSY[4] - (RO)  xxx 
    RESERVED5[31..5]             - (RO) Reserved bits

 =====================================================================================*/
#define CONN_BUS_CR_CONN_INFRA_DEVAPC_DBG_CTRL_DEVAPC_WRAPPER_DEVAPC_SHFT_BUSY_ADDR CONN_BUS_CR_CONN_INFRA_DEVAPC_DBG_CTRL_ADDR
#define CONN_BUS_CR_CONN_INFRA_DEVAPC_DBG_CTRL_DEVAPC_WRAPPER_DEVAPC_SHFT_BUSY_MASK 0x00000010                // DEVAPC_WRAPPER_DEVAPC_SHFT_BUSY[4]
#define CONN_BUS_CR_CONN_INFRA_DEVAPC_DBG_CTRL_DEVAPC_WRAPPER_DEVAPC_SHFT_BUSY_SHFT 4
#define CONN_BUS_CR_CONN_INFRA_DEVAPC_DBG_CTRL_DEVAPC_WRAPPER_SECURE_VIO_IRQ_B_ADDR CONN_BUS_CR_CONN_INFRA_DEVAPC_DBG_CTRL_ADDR
#define CONN_BUS_CR_CONN_INFRA_DEVAPC_DBG_CTRL_DEVAPC_WRAPPER_SECURE_VIO_IRQ_B_MASK 0x00000008                // DEVAPC_WRAPPER_SECURE_VIO_IRQ_B[3]
#define CONN_BUS_CR_CONN_INFRA_DEVAPC_DBG_CTRL_DEVAPC_WRAPPER_SECURE_VIO_IRQ_B_SHFT 3
#define CONN_BUS_CR_CONN_INFRA_DEVAPC_DBG_CTRL_DEVAPC_WRAPPER_SEN_ADDR CONN_BUS_CR_CONN_INFRA_DEVAPC_DBG_CTRL_ADDR
#define CONN_BUS_CR_CONN_INFRA_DEVAPC_DBG_CTRL_DEVAPC_WRAPPER_SEN_MASK 0x00000004                // DEVAPC_WRAPPER_SEN[2]
#define CONN_BUS_CR_CONN_INFRA_DEVAPC_DBG_CTRL_DEVAPC_WRAPPER_SEN_SHFT 2
#define CONN_BUS_CR_CONN_INFRA_DEVAPC_DBG_CTRL_DEVAPC_WRAPPER_DBG_MODE_ADDR CONN_BUS_CR_CONN_INFRA_DEVAPC_DBG_CTRL_ADDR
#define CONN_BUS_CR_CONN_INFRA_DEVAPC_DBG_CTRL_DEVAPC_WRAPPER_DBG_MODE_MASK 0x00000002                // DEVAPC_WRAPPER_DBG_MODE[1]
#define CONN_BUS_CR_CONN_INFRA_DEVAPC_DBG_CTRL_DEVAPC_WRAPPER_DBG_MODE_SHFT 1
#define CONN_BUS_CR_CONN_INFRA_DEVAPC_DBG_CTRL_DEVAPC_WRAPPER_DEVICE_ABORT_TYPEB_ADDR CONN_BUS_CR_CONN_INFRA_DEVAPC_DBG_CTRL_ADDR
#define CONN_BUS_CR_CONN_INFRA_DEVAPC_DBG_CTRL_DEVAPC_WRAPPER_DEVICE_ABORT_TYPEB_MASK 0x00000001                // DEVAPC_WRAPPER_DEVICE_ABORT_TYPEB[0]
#define CONN_BUS_CR_CONN_INFRA_DEVAPC_DBG_CTRL_DEVAPC_WRAPPER_DEVICE_ABORT_TYPEB_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_SLP_PROT_AP2CONN_CTRL (0x1800E000 + 0x2E0)---

    CONN_INFRA_AP2CONN_CLK_READY_ON_DCM[0] - (RW)  xxx 
    CONN_INFRA_AP2CONN_RG_MONITOR_MODE[1] - (RW)  xxx 
    CONN_INFRA_AP2CONN_RG_CMD_CNT_CLR[2] - (RW)  xxx 
    CONN_INFRA_AP2CONN_ERROR_FLAG_EN[3] - (RW)  xxx 
    RESERVED4[31..4]             - (RO) Reserved bits

 =====================================================================================*/
#define CONN_BUS_CR_CONN_INFRA_SLP_PROT_AP2CONN_CTRL_CONN_INFRA_AP2CONN_ERROR_FLAG_EN_ADDR CONN_BUS_CR_CONN_INFRA_SLP_PROT_AP2CONN_CTRL_ADDR
#define CONN_BUS_CR_CONN_INFRA_SLP_PROT_AP2CONN_CTRL_CONN_INFRA_AP2CONN_ERROR_FLAG_EN_MASK 0x00000008                // CONN_INFRA_AP2CONN_ERROR_FLAG_EN[3]
#define CONN_BUS_CR_CONN_INFRA_SLP_PROT_AP2CONN_CTRL_CONN_INFRA_AP2CONN_ERROR_FLAG_EN_SHFT 3
#define CONN_BUS_CR_CONN_INFRA_SLP_PROT_AP2CONN_CTRL_CONN_INFRA_AP2CONN_RG_CMD_CNT_CLR_ADDR CONN_BUS_CR_CONN_INFRA_SLP_PROT_AP2CONN_CTRL_ADDR
#define CONN_BUS_CR_CONN_INFRA_SLP_PROT_AP2CONN_CTRL_CONN_INFRA_AP2CONN_RG_CMD_CNT_CLR_MASK 0x00000004                // CONN_INFRA_AP2CONN_RG_CMD_CNT_CLR[2]
#define CONN_BUS_CR_CONN_INFRA_SLP_PROT_AP2CONN_CTRL_CONN_INFRA_AP2CONN_RG_CMD_CNT_CLR_SHFT 2
#define CONN_BUS_CR_CONN_INFRA_SLP_PROT_AP2CONN_CTRL_CONN_INFRA_AP2CONN_RG_MONITOR_MODE_ADDR CONN_BUS_CR_CONN_INFRA_SLP_PROT_AP2CONN_CTRL_ADDR
#define CONN_BUS_CR_CONN_INFRA_SLP_PROT_AP2CONN_CTRL_CONN_INFRA_AP2CONN_RG_MONITOR_MODE_MASK 0x00000002                // CONN_INFRA_AP2CONN_RG_MONITOR_MODE[1]
#define CONN_BUS_CR_CONN_INFRA_SLP_PROT_AP2CONN_CTRL_CONN_INFRA_AP2CONN_RG_MONITOR_MODE_SHFT 1
#define CONN_BUS_CR_CONN_INFRA_SLP_PROT_AP2CONN_CTRL_CONN_INFRA_AP2CONN_CLK_READY_ON_DCM_ADDR CONN_BUS_CR_CONN_INFRA_SLP_PROT_AP2CONN_CTRL_ADDR
#define CONN_BUS_CR_CONN_INFRA_SLP_PROT_AP2CONN_CTRL_CONN_INFRA_AP2CONN_CLK_READY_ON_DCM_MASK 0x00000001                // CONN_INFRA_AP2CONN_CLK_READY_ON_DCM[0]
#define CONN_BUS_CR_CONN_INFRA_SLP_PROT_AP2CONN_CTRL_CONN_INFRA_AP2CONN_CLK_READY_ON_DCM_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_SLP_PROT_CONN2AP_CTRL (0x1800E000 + 0x2E4)---

    CONN_INFRA_CONN2AP_CLK_READY_ON_DCM[0] - (RW)  xxx 
    CONN_INFRA_CONN2AP_RG_MONITOR_MODE[1] - (RW)  xxx 
    CONN_INFRA_CONN2AP_RG_CMD_CNT_CLR[2] - (RW)  xxx 
    CONN_INFRA_CONN2AP_ERROR_FLAG_EN[3] - (RW)  xxx 
    RESERVED4[31..4]             - (RO) Reserved bits

 =====================================================================================*/
#define CONN_BUS_CR_CONN_INFRA_SLP_PROT_CONN2AP_CTRL_CONN_INFRA_CONN2AP_ERROR_FLAG_EN_ADDR CONN_BUS_CR_CONN_INFRA_SLP_PROT_CONN2AP_CTRL_ADDR
#define CONN_BUS_CR_CONN_INFRA_SLP_PROT_CONN2AP_CTRL_CONN_INFRA_CONN2AP_ERROR_FLAG_EN_MASK 0x00000008                // CONN_INFRA_CONN2AP_ERROR_FLAG_EN[3]
#define CONN_BUS_CR_CONN_INFRA_SLP_PROT_CONN2AP_CTRL_CONN_INFRA_CONN2AP_ERROR_FLAG_EN_SHFT 3
#define CONN_BUS_CR_CONN_INFRA_SLP_PROT_CONN2AP_CTRL_CONN_INFRA_CONN2AP_RG_CMD_CNT_CLR_ADDR CONN_BUS_CR_CONN_INFRA_SLP_PROT_CONN2AP_CTRL_ADDR
#define CONN_BUS_CR_CONN_INFRA_SLP_PROT_CONN2AP_CTRL_CONN_INFRA_CONN2AP_RG_CMD_CNT_CLR_MASK 0x00000004                // CONN_INFRA_CONN2AP_RG_CMD_CNT_CLR[2]
#define CONN_BUS_CR_CONN_INFRA_SLP_PROT_CONN2AP_CTRL_CONN_INFRA_CONN2AP_RG_CMD_CNT_CLR_SHFT 2
#define CONN_BUS_CR_CONN_INFRA_SLP_PROT_CONN2AP_CTRL_CONN_INFRA_CONN2AP_RG_MONITOR_MODE_ADDR CONN_BUS_CR_CONN_INFRA_SLP_PROT_CONN2AP_CTRL_ADDR
#define CONN_BUS_CR_CONN_INFRA_SLP_PROT_CONN2AP_CTRL_CONN_INFRA_CONN2AP_RG_MONITOR_MODE_MASK 0x00000002                // CONN_INFRA_CONN2AP_RG_MONITOR_MODE[1]
#define CONN_BUS_CR_CONN_INFRA_SLP_PROT_CONN2AP_CTRL_CONN_INFRA_CONN2AP_RG_MONITOR_MODE_SHFT 1
#define CONN_BUS_CR_CONN_INFRA_SLP_PROT_CONN2AP_CTRL_CONN_INFRA_CONN2AP_CLK_READY_ON_DCM_ADDR CONN_BUS_CR_CONN_INFRA_SLP_PROT_CONN2AP_CTRL_ADDR
#define CONN_BUS_CR_CONN_INFRA_SLP_PROT_CONN2AP_CTRL_CONN_INFRA_CONN2AP_CLK_READY_ON_DCM_MASK 0x00000001                // CONN_INFRA_CONN2AP_CLK_READY_ON_DCM[0]
#define CONN_BUS_CR_CONN_INFRA_SLP_PROT_CONN2AP_CTRL_CONN_INFRA_CONN2AP_CLK_READY_ON_DCM_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_SLP_PROT_CTRL (0x1800E000 + 0x2E8)---

    CONN_INFRA_VDNR_PWR_PROT_SPM_RG_SW_I[4..0] - (RW)  xxx 
    CONN_INFRA_VDNR_PWR_PROT_SPM_RG_RDY_O[9..5] - (RO)  xxx 
    CONN_INFRA_VDNR_PWR_PROT_SPM_RG_RDY_EXT_O[10] - (RO)  xxx 
    RESERVED11[31..11]           - (RO) Reserved bits

 =====================================================================================*/
#define CONN_BUS_CR_CONN_INFRA_SLP_PROT_CTRL_CONN_INFRA_VDNR_PWR_PROT_SPM_RG_RDY_EXT_O_ADDR CONN_BUS_CR_CONN_INFRA_SLP_PROT_CTRL_ADDR
#define CONN_BUS_CR_CONN_INFRA_SLP_PROT_CTRL_CONN_INFRA_VDNR_PWR_PROT_SPM_RG_RDY_EXT_O_MASK 0x00000400                // CONN_INFRA_VDNR_PWR_PROT_SPM_RG_RDY_EXT_O[10]
#define CONN_BUS_CR_CONN_INFRA_SLP_PROT_CTRL_CONN_INFRA_VDNR_PWR_PROT_SPM_RG_RDY_EXT_O_SHFT 10
#define CONN_BUS_CR_CONN_INFRA_SLP_PROT_CTRL_CONN_INFRA_VDNR_PWR_PROT_SPM_RG_RDY_O_ADDR CONN_BUS_CR_CONN_INFRA_SLP_PROT_CTRL_ADDR
#define CONN_BUS_CR_CONN_INFRA_SLP_PROT_CTRL_CONN_INFRA_VDNR_PWR_PROT_SPM_RG_RDY_O_MASK 0x000003E0                // CONN_INFRA_VDNR_PWR_PROT_SPM_RG_RDY_O[9..5]
#define CONN_BUS_CR_CONN_INFRA_SLP_PROT_CTRL_CONN_INFRA_VDNR_PWR_PROT_SPM_RG_RDY_O_SHFT 5
#define CONN_BUS_CR_CONN_INFRA_SLP_PROT_CTRL_CONN_INFRA_VDNR_PWR_PROT_SPM_RG_SW_I_ADDR CONN_BUS_CR_CONN_INFRA_SLP_PROT_CTRL_ADDR
#define CONN_BUS_CR_CONN_INFRA_SLP_PROT_CTRL_CONN_INFRA_VDNR_PWR_PROT_SPM_RG_SW_I_MASK 0x0000001F                // CONN_INFRA_VDNR_PWR_PROT_SPM_RG_SW_I[4..0]
#define CONN_BUS_CR_CONN_INFRA_SLP_PROT_CTRL_CONN_INFRA_VDNR_PWR_PROT_SPM_RG_SW_I_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_BUS_OFF_TIMEOUT_CTRL (0x1800E000 + 0x300)---

    CONN_INFRA_OFF_TIMEOUT_EN[0] - (RW)  xxx 
    CONN_INFRA_OFF_AHB_MUX_EN[1] - (RW)  xxx 
    CONN_INFRA_OFF_APB_MUX_EN[2] - (RW)  xxx 
    CONN_INFRA_OFF_TIMEOUT_WAY_EN[3] - (RW)  xxx 
    CONN_INFRA_OFF_FORCE_DEADDEAD_EN[4] - (RW)  xxx 
    CONN_INFRA_OFF_TIMEOUT_CLEAR[5] - (RW)  xxx 
    CONN_INFRA_OFF_HANG_FAST_MODE[6] - (RW)  xxx 
    CONN_INFRA_OFF_TIMEOUT_LIMIT[14..7] - (RW)  xxx 
    CONN_INFRA_OFF_ILLEGAL_ACCESS_EN[15] - (RW)  xxx 
    CONN_INFRA_OFF_ILLEGAL_ACCESS_CLEAR[16] - (RW)  xxx 
    CONN_INFRA_OFF_ILLEGAL_ACCESS_NODE[19..17] - (RO)  xxx 
    CONN_INFRA_OFF_TIMEOUT_NODE[24..20] - (RO)  xxx 
    RESERVED25[31..25]           - (RO) Reserved bits

 =====================================================================================*/
#define CONN_BUS_CR_CONN_INFRA_BUS_OFF_TIMEOUT_CTRL_CONN_INFRA_OFF_TIMEOUT_NODE_ADDR CONN_BUS_CR_CONN_INFRA_BUS_OFF_TIMEOUT_CTRL_ADDR
#define CONN_BUS_CR_CONN_INFRA_BUS_OFF_TIMEOUT_CTRL_CONN_INFRA_OFF_TIMEOUT_NODE_MASK 0x01F00000                // CONN_INFRA_OFF_TIMEOUT_NODE[24..20]
#define CONN_BUS_CR_CONN_INFRA_BUS_OFF_TIMEOUT_CTRL_CONN_INFRA_OFF_TIMEOUT_NODE_SHFT 20
#define CONN_BUS_CR_CONN_INFRA_BUS_OFF_TIMEOUT_CTRL_CONN_INFRA_OFF_ILLEGAL_ACCESS_NODE_ADDR CONN_BUS_CR_CONN_INFRA_BUS_OFF_TIMEOUT_CTRL_ADDR
#define CONN_BUS_CR_CONN_INFRA_BUS_OFF_TIMEOUT_CTRL_CONN_INFRA_OFF_ILLEGAL_ACCESS_NODE_MASK 0x000E0000                // CONN_INFRA_OFF_ILLEGAL_ACCESS_NODE[19..17]
#define CONN_BUS_CR_CONN_INFRA_BUS_OFF_TIMEOUT_CTRL_CONN_INFRA_OFF_ILLEGAL_ACCESS_NODE_SHFT 17
#define CONN_BUS_CR_CONN_INFRA_BUS_OFF_TIMEOUT_CTRL_CONN_INFRA_OFF_ILLEGAL_ACCESS_CLEAR_ADDR CONN_BUS_CR_CONN_INFRA_BUS_OFF_TIMEOUT_CTRL_ADDR
#define CONN_BUS_CR_CONN_INFRA_BUS_OFF_TIMEOUT_CTRL_CONN_INFRA_OFF_ILLEGAL_ACCESS_CLEAR_MASK 0x00010000                // CONN_INFRA_OFF_ILLEGAL_ACCESS_CLEAR[16]
#define CONN_BUS_CR_CONN_INFRA_BUS_OFF_TIMEOUT_CTRL_CONN_INFRA_OFF_ILLEGAL_ACCESS_CLEAR_SHFT 16
#define CONN_BUS_CR_CONN_INFRA_BUS_OFF_TIMEOUT_CTRL_CONN_INFRA_OFF_ILLEGAL_ACCESS_EN_ADDR CONN_BUS_CR_CONN_INFRA_BUS_OFF_TIMEOUT_CTRL_ADDR
#define CONN_BUS_CR_CONN_INFRA_BUS_OFF_TIMEOUT_CTRL_CONN_INFRA_OFF_ILLEGAL_ACCESS_EN_MASK 0x00008000                // CONN_INFRA_OFF_ILLEGAL_ACCESS_EN[15]
#define CONN_BUS_CR_CONN_INFRA_BUS_OFF_TIMEOUT_CTRL_CONN_INFRA_OFF_ILLEGAL_ACCESS_EN_SHFT 15
#define CONN_BUS_CR_CONN_INFRA_BUS_OFF_TIMEOUT_CTRL_CONN_INFRA_OFF_TIMEOUT_LIMIT_ADDR CONN_BUS_CR_CONN_INFRA_BUS_OFF_TIMEOUT_CTRL_ADDR
#define CONN_BUS_CR_CONN_INFRA_BUS_OFF_TIMEOUT_CTRL_CONN_INFRA_OFF_TIMEOUT_LIMIT_MASK 0x00007F80                // CONN_INFRA_OFF_TIMEOUT_LIMIT[14..7]
#define CONN_BUS_CR_CONN_INFRA_BUS_OFF_TIMEOUT_CTRL_CONN_INFRA_OFF_TIMEOUT_LIMIT_SHFT 7
#define CONN_BUS_CR_CONN_INFRA_BUS_OFF_TIMEOUT_CTRL_CONN_INFRA_OFF_HANG_FAST_MODE_ADDR CONN_BUS_CR_CONN_INFRA_BUS_OFF_TIMEOUT_CTRL_ADDR
#define CONN_BUS_CR_CONN_INFRA_BUS_OFF_TIMEOUT_CTRL_CONN_INFRA_OFF_HANG_FAST_MODE_MASK 0x00000040                // CONN_INFRA_OFF_HANG_FAST_MODE[6]
#define CONN_BUS_CR_CONN_INFRA_BUS_OFF_TIMEOUT_CTRL_CONN_INFRA_OFF_HANG_FAST_MODE_SHFT 6
#define CONN_BUS_CR_CONN_INFRA_BUS_OFF_TIMEOUT_CTRL_CONN_INFRA_OFF_TIMEOUT_CLEAR_ADDR CONN_BUS_CR_CONN_INFRA_BUS_OFF_TIMEOUT_CTRL_ADDR
#define CONN_BUS_CR_CONN_INFRA_BUS_OFF_TIMEOUT_CTRL_CONN_INFRA_OFF_TIMEOUT_CLEAR_MASK 0x00000020                // CONN_INFRA_OFF_TIMEOUT_CLEAR[5]
#define CONN_BUS_CR_CONN_INFRA_BUS_OFF_TIMEOUT_CTRL_CONN_INFRA_OFF_TIMEOUT_CLEAR_SHFT 5
#define CONN_BUS_CR_CONN_INFRA_BUS_OFF_TIMEOUT_CTRL_CONN_INFRA_OFF_FORCE_DEADDEAD_EN_ADDR CONN_BUS_CR_CONN_INFRA_BUS_OFF_TIMEOUT_CTRL_ADDR
#define CONN_BUS_CR_CONN_INFRA_BUS_OFF_TIMEOUT_CTRL_CONN_INFRA_OFF_FORCE_DEADDEAD_EN_MASK 0x00000010                // CONN_INFRA_OFF_FORCE_DEADDEAD_EN[4]
#define CONN_BUS_CR_CONN_INFRA_BUS_OFF_TIMEOUT_CTRL_CONN_INFRA_OFF_FORCE_DEADDEAD_EN_SHFT 4
#define CONN_BUS_CR_CONN_INFRA_BUS_OFF_TIMEOUT_CTRL_CONN_INFRA_OFF_TIMEOUT_WAY_EN_ADDR CONN_BUS_CR_CONN_INFRA_BUS_OFF_TIMEOUT_CTRL_ADDR
#define CONN_BUS_CR_CONN_INFRA_BUS_OFF_TIMEOUT_CTRL_CONN_INFRA_OFF_TIMEOUT_WAY_EN_MASK 0x00000008                // CONN_INFRA_OFF_TIMEOUT_WAY_EN[3]
#define CONN_BUS_CR_CONN_INFRA_BUS_OFF_TIMEOUT_CTRL_CONN_INFRA_OFF_TIMEOUT_WAY_EN_SHFT 3
#define CONN_BUS_CR_CONN_INFRA_BUS_OFF_TIMEOUT_CTRL_CONN_INFRA_OFF_APB_MUX_EN_ADDR CONN_BUS_CR_CONN_INFRA_BUS_OFF_TIMEOUT_CTRL_ADDR
#define CONN_BUS_CR_CONN_INFRA_BUS_OFF_TIMEOUT_CTRL_CONN_INFRA_OFF_APB_MUX_EN_MASK 0x00000004                // CONN_INFRA_OFF_APB_MUX_EN[2]
#define CONN_BUS_CR_CONN_INFRA_BUS_OFF_TIMEOUT_CTRL_CONN_INFRA_OFF_APB_MUX_EN_SHFT 2
#define CONN_BUS_CR_CONN_INFRA_BUS_OFF_TIMEOUT_CTRL_CONN_INFRA_OFF_AHB_MUX_EN_ADDR CONN_BUS_CR_CONN_INFRA_BUS_OFF_TIMEOUT_CTRL_ADDR
#define CONN_BUS_CR_CONN_INFRA_BUS_OFF_TIMEOUT_CTRL_CONN_INFRA_OFF_AHB_MUX_EN_MASK 0x00000002                // CONN_INFRA_OFF_AHB_MUX_EN[1]
#define CONN_BUS_CR_CONN_INFRA_BUS_OFF_TIMEOUT_CTRL_CONN_INFRA_OFF_AHB_MUX_EN_SHFT 1
#define CONN_BUS_CR_CONN_INFRA_BUS_OFF_TIMEOUT_CTRL_CONN_INFRA_OFF_TIMEOUT_EN_ADDR CONN_BUS_CR_CONN_INFRA_BUS_OFF_TIMEOUT_CTRL_ADDR
#define CONN_BUS_CR_CONN_INFRA_BUS_OFF_TIMEOUT_CTRL_CONN_INFRA_OFF_TIMEOUT_EN_MASK 0x00000001                // CONN_INFRA_OFF_TIMEOUT_EN[0]
#define CONN_BUS_CR_CONN_INFRA_BUS_OFF_TIMEOUT_CTRL_CONN_INFRA_OFF_TIMEOUT_EN_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_BUS_OFF_TIMEOUT_VALUE (0x1800E000 + 0x304)---

    CONN_INFRA_OFF_TIMEOUT_VALUE[31..0] - (RW)  xxx 

 =====================================================================================*/
#define CONN_BUS_CR_CONN_INFRA_BUS_OFF_TIMEOUT_VALUE_CONN_INFRA_OFF_TIMEOUT_VALUE_ADDR CONN_BUS_CR_CONN_INFRA_BUS_OFF_TIMEOUT_VALUE_ADDR
#define CONN_BUS_CR_CONN_INFRA_BUS_OFF_TIMEOUT_VALUE_CONN_INFRA_OFF_TIMEOUT_VALUE_MASK 0xFFFFFFFF                // CONN_INFRA_OFF_TIMEOUT_VALUE[31..0]
#define CONN_BUS_CR_CONN_INFRA_BUS_OFF_TIMEOUT_VALUE_CONN_INFRA_OFF_TIMEOUT_VALUE_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_BUS_OFF_ILLEGAL_VALUE (0x1800E000 + 0x308)---

    CONN_INFRA_OFF_ILLEGAL_VALUE[31..0] - (RW)  xxx 

 =====================================================================================*/
#define CONN_BUS_CR_CONN_INFRA_BUS_OFF_ILLEGAL_VALUE_CONN_INFRA_OFF_ILLEGAL_VALUE_ADDR CONN_BUS_CR_CONN_INFRA_BUS_OFF_ILLEGAL_VALUE_ADDR
#define CONN_BUS_CR_CONN_INFRA_BUS_OFF_ILLEGAL_VALUE_CONN_INFRA_OFF_ILLEGAL_VALUE_MASK 0xFFFFFFFF                // CONN_INFRA_OFF_ILLEGAL_VALUE[31..0]
#define CONN_BUS_CR_CONN_INFRA_BUS_OFF_ILLEGAL_VALUE_CONN_INFRA_OFF_ILLEGAL_VALUE_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_BUS_OFF_DBG_MON_1 (0x1800E000 + 0x30C)---

    CONN_INFRA_BUS_OFF_DBG_MON_1[31..0] - (RO)  xxx 

 =====================================================================================*/
#define CONN_BUS_CR_CONN_INFRA_BUS_OFF_DBG_MON_1_CONN_INFRA_BUS_OFF_DBG_MON_1_ADDR CONN_BUS_CR_CONN_INFRA_BUS_OFF_DBG_MON_1_ADDR
#define CONN_BUS_CR_CONN_INFRA_BUS_OFF_DBG_MON_1_CONN_INFRA_BUS_OFF_DBG_MON_1_MASK 0xFFFFFFFF                // CONN_INFRA_BUS_OFF_DBG_MON_1[31..0]
#define CONN_BUS_CR_CONN_INFRA_BUS_OFF_DBG_MON_1_CONN_INFRA_BUS_OFF_DBG_MON_1_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_BUS_OFF_DBG_MON_2 (0x1800E000 + 0x310)---

    CONN_INFRA_BUS_OFF_DBG_MON_2[16..0] - (RO)  xxx 
    RESERVED17[31..17]           - (RO) Reserved bits

 =====================================================================================*/
#define CONN_BUS_CR_CONN_INFRA_BUS_OFF_DBG_MON_2_CONN_INFRA_BUS_OFF_DBG_MON_2_ADDR CONN_BUS_CR_CONN_INFRA_BUS_OFF_DBG_MON_2_ADDR
#define CONN_BUS_CR_CONN_INFRA_BUS_OFF_DBG_MON_2_CONN_INFRA_BUS_OFF_DBG_MON_2_MASK 0x0001FFFF                // CONN_INFRA_BUS_OFF_DBG_MON_2[16..0]
#define CONN_BUS_CR_CONN_INFRA_BUS_OFF_DBG_MON_2_CONN_INFRA_BUS_OFF_DBG_MON_2_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_BUS_OFF_TOP_DBG_MON_1 (0x1800E000 + 0x314)---

    CONN_INFRA_BUS_OFF_DBG_TOP_MON_1[31..0] - (RO)  xxx 

 =====================================================================================*/
#define CONN_BUS_CR_CONN_INFRA_BUS_OFF_TOP_DBG_MON_1_CONN_INFRA_BUS_OFF_DBG_TOP_MON_1_ADDR CONN_BUS_CR_CONN_INFRA_BUS_OFF_TOP_DBG_MON_1_ADDR
#define CONN_BUS_CR_CONN_INFRA_BUS_OFF_TOP_DBG_MON_1_CONN_INFRA_BUS_OFF_DBG_TOP_MON_1_MASK 0xFFFFFFFF                // CONN_INFRA_BUS_OFF_DBG_TOP_MON_1[31..0]
#define CONN_BUS_CR_CONN_INFRA_BUS_OFF_TOP_DBG_MON_1_CONN_INFRA_BUS_OFF_DBG_TOP_MON_1_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_BUS_OFF_TOP_DBG_MON_2 (0x1800E000 + 0x318)---

    CONN_INFRA_BUS_OFF_DBG_TOP_MON_2[16..0] - (RO)  xxx 
    RESERVED17[31..17]           - (RO) Reserved bits

 =====================================================================================*/
#define CONN_BUS_CR_CONN_INFRA_BUS_OFF_TOP_DBG_MON_2_CONN_INFRA_BUS_OFF_DBG_TOP_MON_2_ADDR CONN_BUS_CR_CONN_INFRA_BUS_OFF_TOP_DBG_MON_2_ADDR
#define CONN_BUS_CR_CONN_INFRA_BUS_OFF_TOP_DBG_MON_2_CONN_INFRA_BUS_OFF_DBG_TOP_MON_2_MASK 0x0001FFFF                // CONN_INFRA_BUS_OFF_DBG_TOP_MON_2[16..0]
#define CONN_BUS_CR_CONN_INFRA_BUS_OFF_TOP_DBG_MON_2_CONN_INFRA_BUS_OFF_DBG_TOP_MON_2_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_BUS_ON_TIMEOUT_CTRL (0x1800E000 + 0x31C)---

    CONN_INFRA_ON_TIMEOUT_EN[0]  - (RW)  xxx 
    CONN_INFRA_ON_AHB_MUX_EN[1]  - (RW)  xxx 
    CONN_INFRA_ON_APB_MUX_EN[2]  - (RW)  xxx 
    CONN_INFRA_ON_TIMEOUT_WAY_EN[3] - (RW)  xxx 
    RESERVED4[4]                 - (RO) Reserved bits
    CONN_INFRA_ON_TIMEOUT_CLEAR[5] - (RW)  xxx 
    CONN_INFRA_ON_HANG_FAST_MODE[6] - (RW)  xxx 
    CONN_INFRA_ON_TIMEOUT_LIMIT[14..7] - (RW)  xxx 
    RESERVED15[19..15]           - (RO) Reserved bits
    CONN_INFRA_ON_TIMEOUT_NODE[24..20] - (RO)  xxx 
    RESERVED25[31..25]           - (RO) Reserved bits

 =====================================================================================*/
#define CONN_BUS_CR_CONN_INFRA_BUS_ON_TIMEOUT_CTRL_CONN_INFRA_ON_TIMEOUT_NODE_ADDR CONN_BUS_CR_CONN_INFRA_BUS_ON_TIMEOUT_CTRL_ADDR
#define CONN_BUS_CR_CONN_INFRA_BUS_ON_TIMEOUT_CTRL_CONN_INFRA_ON_TIMEOUT_NODE_MASK 0x01F00000                // CONN_INFRA_ON_TIMEOUT_NODE[24..20]
#define CONN_BUS_CR_CONN_INFRA_BUS_ON_TIMEOUT_CTRL_CONN_INFRA_ON_TIMEOUT_NODE_SHFT 20
#define CONN_BUS_CR_CONN_INFRA_BUS_ON_TIMEOUT_CTRL_CONN_INFRA_ON_TIMEOUT_LIMIT_ADDR CONN_BUS_CR_CONN_INFRA_BUS_ON_TIMEOUT_CTRL_ADDR
#define CONN_BUS_CR_CONN_INFRA_BUS_ON_TIMEOUT_CTRL_CONN_INFRA_ON_TIMEOUT_LIMIT_MASK 0x00007F80                // CONN_INFRA_ON_TIMEOUT_LIMIT[14..7]
#define CONN_BUS_CR_CONN_INFRA_BUS_ON_TIMEOUT_CTRL_CONN_INFRA_ON_TIMEOUT_LIMIT_SHFT 7
#define CONN_BUS_CR_CONN_INFRA_BUS_ON_TIMEOUT_CTRL_CONN_INFRA_ON_HANG_FAST_MODE_ADDR CONN_BUS_CR_CONN_INFRA_BUS_ON_TIMEOUT_CTRL_ADDR
#define CONN_BUS_CR_CONN_INFRA_BUS_ON_TIMEOUT_CTRL_CONN_INFRA_ON_HANG_FAST_MODE_MASK 0x00000040                // CONN_INFRA_ON_HANG_FAST_MODE[6]
#define CONN_BUS_CR_CONN_INFRA_BUS_ON_TIMEOUT_CTRL_CONN_INFRA_ON_HANG_FAST_MODE_SHFT 6
#define CONN_BUS_CR_CONN_INFRA_BUS_ON_TIMEOUT_CTRL_CONN_INFRA_ON_TIMEOUT_CLEAR_ADDR CONN_BUS_CR_CONN_INFRA_BUS_ON_TIMEOUT_CTRL_ADDR
#define CONN_BUS_CR_CONN_INFRA_BUS_ON_TIMEOUT_CTRL_CONN_INFRA_ON_TIMEOUT_CLEAR_MASK 0x00000020                // CONN_INFRA_ON_TIMEOUT_CLEAR[5]
#define CONN_BUS_CR_CONN_INFRA_BUS_ON_TIMEOUT_CTRL_CONN_INFRA_ON_TIMEOUT_CLEAR_SHFT 5
#define CONN_BUS_CR_CONN_INFRA_BUS_ON_TIMEOUT_CTRL_CONN_INFRA_ON_TIMEOUT_WAY_EN_ADDR CONN_BUS_CR_CONN_INFRA_BUS_ON_TIMEOUT_CTRL_ADDR
#define CONN_BUS_CR_CONN_INFRA_BUS_ON_TIMEOUT_CTRL_CONN_INFRA_ON_TIMEOUT_WAY_EN_MASK 0x00000008                // CONN_INFRA_ON_TIMEOUT_WAY_EN[3]
#define CONN_BUS_CR_CONN_INFRA_BUS_ON_TIMEOUT_CTRL_CONN_INFRA_ON_TIMEOUT_WAY_EN_SHFT 3
#define CONN_BUS_CR_CONN_INFRA_BUS_ON_TIMEOUT_CTRL_CONN_INFRA_ON_APB_MUX_EN_ADDR CONN_BUS_CR_CONN_INFRA_BUS_ON_TIMEOUT_CTRL_ADDR
#define CONN_BUS_CR_CONN_INFRA_BUS_ON_TIMEOUT_CTRL_CONN_INFRA_ON_APB_MUX_EN_MASK 0x00000004                // CONN_INFRA_ON_APB_MUX_EN[2]
#define CONN_BUS_CR_CONN_INFRA_BUS_ON_TIMEOUT_CTRL_CONN_INFRA_ON_APB_MUX_EN_SHFT 2
#define CONN_BUS_CR_CONN_INFRA_BUS_ON_TIMEOUT_CTRL_CONN_INFRA_ON_AHB_MUX_EN_ADDR CONN_BUS_CR_CONN_INFRA_BUS_ON_TIMEOUT_CTRL_ADDR
#define CONN_BUS_CR_CONN_INFRA_BUS_ON_TIMEOUT_CTRL_CONN_INFRA_ON_AHB_MUX_EN_MASK 0x00000002                // CONN_INFRA_ON_AHB_MUX_EN[1]
#define CONN_BUS_CR_CONN_INFRA_BUS_ON_TIMEOUT_CTRL_CONN_INFRA_ON_AHB_MUX_EN_SHFT 1
#define CONN_BUS_CR_CONN_INFRA_BUS_ON_TIMEOUT_CTRL_CONN_INFRA_ON_TIMEOUT_EN_ADDR CONN_BUS_CR_CONN_INFRA_BUS_ON_TIMEOUT_CTRL_ADDR
#define CONN_BUS_CR_CONN_INFRA_BUS_ON_TIMEOUT_CTRL_CONN_INFRA_ON_TIMEOUT_EN_MASK 0x00000001                // CONN_INFRA_ON_TIMEOUT_EN[0]
#define CONN_BUS_CR_CONN_INFRA_BUS_ON_TIMEOUT_CTRL_CONN_INFRA_ON_TIMEOUT_EN_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_BUS_ON_TIMEOUT_VALUE (0x1800E000 + 0x320)---

    CONN_INFRA_ON_TIMEOUT_VALUE[31..0] - (RW)  xxx 

 =====================================================================================*/
#define CONN_BUS_CR_CONN_INFRA_BUS_ON_TIMEOUT_VALUE_CONN_INFRA_ON_TIMEOUT_VALUE_ADDR CONN_BUS_CR_CONN_INFRA_BUS_ON_TIMEOUT_VALUE_ADDR
#define CONN_BUS_CR_CONN_INFRA_BUS_ON_TIMEOUT_VALUE_CONN_INFRA_ON_TIMEOUT_VALUE_MASK 0xFFFFFFFF                // CONN_INFRA_ON_TIMEOUT_VALUE[31..0]
#define CONN_BUS_CR_CONN_INFRA_BUS_ON_TIMEOUT_VALUE_CONN_INFRA_ON_TIMEOUT_VALUE_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_BUS_ON_DBG_WFDMA_MON_1 (0x1800E000 + 0x324)---

    CONN_INFRA_BUS_OFF_DBG_MON_1[31..0] - (RO)  xxx 

 =====================================================================================*/
#define CONN_BUS_CR_CONN_INFRA_BUS_ON_DBG_WFDMA_MON_1_CONN_INFRA_BUS_OFF_DBG_MON_1_ADDR CONN_BUS_CR_CONN_INFRA_BUS_ON_DBG_WFDMA_MON_1_ADDR
#define CONN_BUS_CR_CONN_INFRA_BUS_ON_DBG_WFDMA_MON_1_CONN_INFRA_BUS_OFF_DBG_MON_1_MASK 0xFFFFFFFF                // CONN_INFRA_BUS_OFF_DBG_MON_1[31..0]
#define CONN_BUS_CR_CONN_INFRA_BUS_ON_DBG_WFDMA_MON_1_CONN_INFRA_BUS_OFF_DBG_MON_1_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_BUS_ON_DBG_WFDMA_MON_2 (0x1800E000 + 0x328)---

    CONN_INFRA_BUS_OFF_DBG_MON_2[7..0] - (RO)  xxx 
    RESERVED8[31..8]             - (RO) Reserved bits

 =====================================================================================*/
#define CONN_BUS_CR_CONN_INFRA_BUS_ON_DBG_WFDMA_MON_2_CONN_INFRA_BUS_OFF_DBG_MON_2_ADDR CONN_BUS_CR_CONN_INFRA_BUS_ON_DBG_WFDMA_MON_2_ADDR
#define CONN_BUS_CR_CONN_INFRA_BUS_ON_DBG_WFDMA_MON_2_CONN_INFRA_BUS_OFF_DBG_MON_2_MASK 0x000000FF                // CONN_INFRA_BUS_OFF_DBG_MON_2[7..0]
#define CONN_BUS_CR_CONN_INFRA_BUS_ON_DBG_WFDMA_MON_2_CONN_INFRA_BUS_OFF_DBG_MON_2_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_BUS_ON_TOP_DBG_APB_MON_1 (0x1800E000 + 0x32C)---

    CONN_INFRA_BUS_OFF_DBG_TOP_MON_1[31..0] - (RO)  xxx 

 =====================================================================================*/
#define CONN_BUS_CR_CONN_INFRA_BUS_ON_TOP_DBG_APB_MON_1_CONN_INFRA_BUS_OFF_DBG_TOP_MON_1_ADDR CONN_BUS_CR_CONN_INFRA_BUS_ON_TOP_DBG_APB_MON_1_ADDR
#define CONN_BUS_CR_CONN_INFRA_BUS_ON_TOP_DBG_APB_MON_1_CONN_INFRA_BUS_OFF_DBG_TOP_MON_1_MASK 0xFFFFFFFF                // CONN_INFRA_BUS_OFF_DBG_TOP_MON_1[31..0]
#define CONN_BUS_CR_CONN_INFRA_BUS_ON_TOP_DBG_APB_MON_1_CONN_INFRA_BUS_OFF_DBG_TOP_MON_1_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_BUS_ON_TOP_DBG_APB_MON_2 (0x1800E000 + 0x330)---

    CONN_INFRA_BUS_OFF_DBG_TOP_MON_2[7..0] - (RO)  xxx 
    RESERVED8[31..8]             - (RO) Reserved bits

 =====================================================================================*/
#define CONN_BUS_CR_CONN_INFRA_BUS_ON_TOP_DBG_APB_MON_2_CONN_INFRA_BUS_OFF_DBG_TOP_MON_2_ADDR CONN_BUS_CR_CONN_INFRA_BUS_ON_TOP_DBG_APB_MON_2_ADDR
#define CONN_BUS_CR_CONN_INFRA_BUS_ON_TOP_DBG_APB_MON_2_CONN_INFRA_BUS_OFF_DBG_TOP_MON_2_MASK 0x000000FF                // CONN_INFRA_BUS_OFF_DBG_TOP_MON_2[7..0]
#define CONN_BUS_CR_CONN_INFRA_BUS_ON_TOP_DBG_APB_MON_2_CONN_INFRA_BUS_OFF_DBG_TOP_MON_2_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_BUS_TIMEOUT_IRQ_B (0x1800E000 + 0x334)---

    CONN_INFRA_ON_BUS_NO_ACK_IRQ_B[0] - (RO)  xxx 
    CONN_INFRA_OFF_BUS_NO_ACK_IRQ_B[1] - (RO)  xxx 
    RESERVED2[31..2]             - (RO) Reserved bits

 =====================================================================================*/
#define CONN_BUS_CR_CONN_INFRA_BUS_TIMEOUT_IRQ_B_CONN_INFRA_OFF_BUS_NO_ACK_IRQ_B_ADDR CONN_BUS_CR_CONN_INFRA_BUS_TIMEOUT_IRQ_B_ADDR
#define CONN_BUS_CR_CONN_INFRA_BUS_TIMEOUT_IRQ_B_CONN_INFRA_OFF_BUS_NO_ACK_IRQ_B_MASK 0x00000002                // CONN_INFRA_OFF_BUS_NO_ACK_IRQ_B[1]
#define CONN_BUS_CR_CONN_INFRA_BUS_TIMEOUT_IRQ_B_CONN_INFRA_OFF_BUS_NO_ACK_IRQ_B_SHFT 1
#define CONN_BUS_CR_CONN_INFRA_BUS_TIMEOUT_IRQ_B_CONN_INFRA_ON_BUS_NO_ACK_IRQ_B_ADDR CONN_BUS_CR_CONN_INFRA_BUS_TIMEOUT_IRQ_B_ADDR
#define CONN_BUS_CR_CONN_INFRA_BUS_TIMEOUT_IRQ_B_CONN_INFRA_ON_BUS_NO_ACK_IRQ_B_MASK 0x00000001                // CONN_INFRA_ON_BUS_NO_ACK_IRQ_B[0]
#define CONN_BUS_CR_CONN_INFRA_BUS_TIMEOUT_IRQ_B_CONN_INFRA_ON_BUS_NO_ACK_IRQ_B_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_OFF2ON_DET_CTL (0x1800E000 + 0x358)---

    CR_CONN_INFRA_OFF2ON_IDLE_DEBOUNCE[5..0] - (RW)  xxx 
    RESERVED6[31..6]             - (RO) Reserved bits

 =====================================================================================*/
#define CONN_BUS_CR_CONN_INFRA_OFF2ON_DET_CTL_CR_CONN_INFRA_OFF2ON_IDLE_DEBOUNCE_ADDR CONN_BUS_CR_CONN_INFRA_OFF2ON_DET_CTL_ADDR
#define CONN_BUS_CR_CONN_INFRA_OFF2ON_DET_CTL_CR_CONN_INFRA_OFF2ON_IDLE_DEBOUNCE_MASK 0x0000003F                // CR_CONN_INFRA_OFF2ON_IDLE_DEBOUNCE[5..0]
#define CONN_BUS_CR_CONN_INFRA_OFF2ON_DET_CTL_CR_CONN_INFRA_OFF2ON_IDLE_DEBOUNCE_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_CONN2AP_CR_PATH_ADDR_START (0x1800E000 + 0x360)---

    CR_CONN2AP_CR_PATH_ADDRESS_START[31..0] - (RW)  xxx 

 =====================================================================================*/
#define CONN_BUS_CR_CONN_INFRA_CONN2AP_CR_PATH_ADDR_START_CR_CONN2AP_CR_PATH_ADDRESS_START_ADDR CONN_BUS_CR_CONN_INFRA_CONN2AP_CR_PATH_ADDR_START_ADDR
#define CONN_BUS_CR_CONN_INFRA_CONN2AP_CR_PATH_ADDR_START_CR_CONN2AP_CR_PATH_ADDRESS_START_MASK 0xFFFFFFFF                // CR_CONN2AP_CR_PATH_ADDRESS_START[31..0]
#define CONN_BUS_CR_CONN_INFRA_CONN2AP_CR_PATH_ADDR_START_CR_CONN2AP_CR_PATH_ADDRESS_START_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_CONN2AP_CR_PATH_ADDR_END (0x1800E000 + 0x364)---

    CR_CONN2AP_CR_PATH_ADDRESS_END[31..0] - (RW)  xxx 

 =====================================================================================*/
#define CONN_BUS_CR_CONN_INFRA_CONN2AP_CR_PATH_ADDR_END_CR_CONN2AP_CR_PATH_ADDRESS_END_ADDR CONN_BUS_CR_CONN_INFRA_CONN2AP_CR_PATH_ADDR_END_ADDR
#define CONN_BUS_CR_CONN_INFRA_CONN2AP_CR_PATH_ADDR_END_CR_CONN2AP_CR_PATH_ADDRESS_END_MASK 0xFFFFFFFF                // CR_CONN2AP_CR_PATH_ADDRESS_END[31..0]
#define CONN_BUS_CR_CONN_INFRA_CONN2AP_CR_PATH_ADDR_END_CR_CONN2AP_CR_PATH_ADDRESS_END_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_CONN2AP_EMI_PATH_ADDR_START (0x1800E000 + 0x368)---

    CR_CONN2AP_EMI_PATH_ADDRESS_START[31..0] - (RW)  xxx 

 =====================================================================================*/
#define CONN_BUS_CR_CONN_INFRA_CONN2AP_EMI_PATH_ADDR_START_CR_CONN2AP_EMI_PATH_ADDRESS_START_ADDR CONN_BUS_CR_CONN_INFRA_CONN2AP_EMI_PATH_ADDR_START_ADDR
#define CONN_BUS_CR_CONN_INFRA_CONN2AP_EMI_PATH_ADDR_START_CR_CONN2AP_EMI_PATH_ADDRESS_START_MASK 0xFFFFFFFF                // CR_CONN2AP_EMI_PATH_ADDRESS_START[31..0]
#define CONN_BUS_CR_CONN_INFRA_CONN2AP_EMI_PATH_ADDR_START_CR_CONN2AP_EMI_PATH_ADDRESS_START_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_CONN2AP_EMI_PATH_ADDR_END (0x1800E000 + 0x36C)---

    CR_CONN2AP_EMI_PATH_ADDRESS_END[31..0] - (RW)  xxx 

 =====================================================================================*/
#define CONN_BUS_CR_CONN_INFRA_CONN2AP_EMI_PATH_ADDR_END_CR_CONN2AP_EMI_PATH_ADDRESS_END_ADDR CONN_BUS_CR_CONN_INFRA_CONN2AP_EMI_PATH_ADDR_END_ADDR
#define CONN_BUS_CR_CONN_INFRA_CONN2AP_EMI_PATH_ADDR_END_CR_CONN2AP_EMI_PATH_ADDRESS_END_MASK 0xFFFFFFFF                // CR_CONN2AP_EMI_PATH_ADDRESS_END[31..0]
#define CONN_BUS_CR_CONN_INFRA_CONN2AP_EMI_PATH_ADDR_END_CR_CONN2AP_EMI_PATH_ADDRESS_END_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_LOW_POWER_LAYER_CTRL (0x1800E000 + 0x370)---

    XT1_AXI_CLOCK_GATED_EN[0]    - (RW)  xxx 
    XT1_CLK_READY_ON_DCM[1]      - (RW)  xxx 
    XT1_BUSY_I[2]                - (RW)  xxx 
    XT1_ERROR_FLAG_EN[3]         - (RW)  xxx 
    XT0_IN_ARFLUSH_THRE[5..4]    - (RW)  xxx 
    XT0_IN_AWFLUSH_THRE[7..6]    - (RW)  xxx 
    XT0_WTHRE[10..8]             - (RW)  xxx 
    XT0_REG_AW_FCTRL_EN[11]      - (RW)  xxx 
    XM1_CG_DISABLE[12]           - (RW)  xxx 
    CONN_INFRA_VDNR_LOW_POWER_LAYER_XM1_MI_OUTSTANDING_EXTEND_EN[13] - (RW)  xxx 
    CONN_INFRA_VDNR_LOW_POWER_LAYER_XM1_MI_QOS_ON[14] - (RW)  xxx 
    XM0_CG_DISABLE[15]           - (RW)  xxx 
    XM0_CTRL_BYPASS[16]          - (RW)  xxx 
    XM0_OUTSTANDING_DISABLE[17]  - (RW)  xxx 
    XM0_WAY_INTERLEAVE_EN[19..18] - (RW)  xxx 
    XM0_WAY_EN[21..20]           - (RW)  xxx 
    XM1_IDLE[22]                 - (RO)  xxx 
    XT0_AXI_IDLE_OUT[23]         - (RO)  xxx 
    XT1_PROTECT_IDLE[24]         - (RO)  xxx 
    XT1_AXI_IDLE_ASYNC[25]       - (RO)  xxx 
    XT1_AXI_IDLE[26]             - (RO)  xxx 
    XM0_WR_OT_BUSY[27]           - (RO)  xxx 
    XM0_RD_OT_BUSY[28]           - (RO)  xxx 
    CONN_INFRA_VDNR_LOW_POWER_LAYER_XM1_MI_W_BUSY[29] - (RO)  xxx 
    CONN_INFRA_VDNR_LOW_POWER_LAYER_XM1_MI_R_BUSY[30] - (RO)  xxx 
    XT1_AXI_CLOCK_GATED[31]      - (RO)  xxx 

 =====================================================================================*/
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_XT1_AXI_CLOCK_GATED_ADDR CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_ADDR
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_XT1_AXI_CLOCK_GATED_MASK 0x80000000                // XT1_AXI_CLOCK_GATED[31]
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_XT1_AXI_CLOCK_GATED_SHFT 31
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_CONN_INFRA_VDNR_LOW_POWER_LAYER_XM1_MI_R_BUSY_ADDR CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_ADDR
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_CONN_INFRA_VDNR_LOW_POWER_LAYER_XM1_MI_R_BUSY_MASK 0x40000000                // CONN_INFRA_VDNR_LOW_POWER_LAYER_XM1_MI_R_BUSY[30]
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_CONN_INFRA_VDNR_LOW_POWER_LAYER_XM1_MI_R_BUSY_SHFT 30
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_CONN_INFRA_VDNR_LOW_POWER_LAYER_XM1_MI_W_BUSY_ADDR CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_ADDR
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_CONN_INFRA_VDNR_LOW_POWER_LAYER_XM1_MI_W_BUSY_MASK 0x20000000                // CONN_INFRA_VDNR_LOW_POWER_LAYER_XM1_MI_W_BUSY[29]
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_CONN_INFRA_VDNR_LOW_POWER_LAYER_XM1_MI_W_BUSY_SHFT 29
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_XM0_RD_OT_BUSY_ADDR CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_ADDR
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_XM0_RD_OT_BUSY_MASK 0x10000000                // XM0_RD_OT_BUSY[28]
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_XM0_RD_OT_BUSY_SHFT 28
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_XM0_WR_OT_BUSY_ADDR CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_ADDR
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_XM0_WR_OT_BUSY_MASK 0x08000000                // XM0_WR_OT_BUSY[27]
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_XM0_WR_OT_BUSY_SHFT 27
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_XT1_AXI_IDLE_ADDR CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_ADDR
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_XT1_AXI_IDLE_MASK 0x04000000                // XT1_AXI_IDLE[26]
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_XT1_AXI_IDLE_SHFT 26
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_XT1_AXI_IDLE_ASYNC_ADDR CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_ADDR
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_XT1_AXI_IDLE_ASYNC_MASK 0x02000000                // XT1_AXI_IDLE_ASYNC[25]
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_XT1_AXI_IDLE_ASYNC_SHFT 25
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_XT1_PROTECT_IDLE_ADDR CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_ADDR
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_XT1_PROTECT_IDLE_MASK 0x01000000                // XT1_PROTECT_IDLE[24]
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_XT1_PROTECT_IDLE_SHFT 24
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_XT0_AXI_IDLE_OUT_ADDR CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_ADDR
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_XT0_AXI_IDLE_OUT_MASK 0x00800000                // XT0_AXI_IDLE_OUT[23]
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_XT0_AXI_IDLE_OUT_SHFT 23
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_XM1_IDLE_ADDR CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_ADDR
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_XM1_IDLE_MASK 0x00400000                // XM1_IDLE[22]
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_XM1_IDLE_SHFT 22
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_XM0_WAY_EN_ADDR CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_ADDR
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_XM0_WAY_EN_MASK 0x00300000                // XM0_WAY_EN[21..20]
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_XM0_WAY_EN_SHFT 20
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_XM0_WAY_INTERLEAVE_EN_ADDR CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_ADDR
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_XM0_WAY_INTERLEAVE_EN_MASK 0x000C0000                // XM0_WAY_INTERLEAVE_EN[19..18]
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_XM0_WAY_INTERLEAVE_EN_SHFT 18
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_XM0_OUTSTANDING_DISABLE_ADDR CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_ADDR
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_XM0_OUTSTANDING_DISABLE_MASK 0x00020000                // XM0_OUTSTANDING_DISABLE[17]
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_XM0_OUTSTANDING_DISABLE_SHFT 17
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_XM0_CTRL_BYPASS_ADDR CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_ADDR
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_XM0_CTRL_BYPASS_MASK 0x00010000                // XM0_CTRL_BYPASS[16]
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_XM0_CTRL_BYPASS_SHFT 16
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_XM0_CG_DISABLE_ADDR CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_ADDR
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_XM0_CG_DISABLE_MASK 0x00008000                // XM0_CG_DISABLE[15]
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_XM0_CG_DISABLE_SHFT 15
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_CONN_INFRA_VDNR_LOW_POWER_LAYER_XM1_MI_QOS_ON_ADDR CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_ADDR
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_CONN_INFRA_VDNR_LOW_POWER_LAYER_XM1_MI_QOS_ON_MASK 0x00004000                // CONN_INFRA_VDNR_LOW_POWER_LAYER_XM1_MI_QOS_ON[14]
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_CONN_INFRA_VDNR_LOW_POWER_LAYER_XM1_MI_QOS_ON_SHFT 14
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_CONN_INFRA_VDNR_LOW_POWER_LAYER_XM1_MI_OUTSTANDING_EXTEND_EN_ADDR CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_ADDR
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_CONN_INFRA_VDNR_LOW_POWER_LAYER_XM1_MI_OUTSTANDING_EXTEND_EN_MASK 0x00002000                // CONN_INFRA_VDNR_LOW_POWER_LAYER_XM1_MI_OUTSTANDING_EXTEND_EN[13]
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_CONN_INFRA_VDNR_LOW_POWER_LAYER_XM1_MI_OUTSTANDING_EXTEND_EN_SHFT 13
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_XM1_CG_DISABLE_ADDR CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_ADDR
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_XM1_CG_DISABLE_MASK 0x00001000                // XM1_CG_DISABLE[12]
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_XM1_CG_DISABLE_SHFT 12
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_XT0_REG_AW_FCTRL_EN_ADDR CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_ADDR
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_XT0_REG_AW_FCTRL_EN_MASK 0x00000800                // XT0_REG_AW_FCTRL_EN[11]
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_XT0_REG_AW_FCTRL_EN_SHFT 11
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_XT0_WTHRE_ADDR CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_ADDR
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_XT0_WTHRE_MASK 0x00000700                // XT0_WTHRE[10..8]
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_XT0_WTHRE_SHFT 8
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_XT0_IN_AWFLUSH_THRE_ADDR CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_ADDR
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_XT0_IN_AWFLUSH_THRE_MASK 0x000000C0                // XT0_IN_AWFLUSH_THRE[7..6]
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_XT0_IN_AWFLUSH_THRE_SHFT 6
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_XT0_IN_ARFLUSH_THRE_ADDR CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_ADDR
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_XT0_IN_ARFLUSH_THRE_MASK 0x00000030                // XT0_IN_ARFLUSH_THRE[5..4]
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_XT0_IN_ARFLUSH_THRE_SHFT 4
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_XT1_ERROR_FLAG_EN_ADDR CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_ADDR
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_XT1_ERROR_FLAG_EN_MASK 0x00000008                // XT1_ERROR_FLAG_EN[3]
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_XT1_ERROR_FLAG_EN_SHFT 3
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_XT1_BUSY_I_ADDR CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_ADDR
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_XT1_BUSY_I_MASK 0x00000004                // XT1_BUSY_I[2]
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_XT1_BUSY_I_SHFT 2
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_XT1_CLK_READY_ON_DCM_ADDR CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_ADDR
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_XT1_CLK_READY_ON_DCM_MASK 0x00000002                // XT1_CLK_READY_ON_DCM[1]
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_XT1_CLK_READY_ON_DCM_SHFT 1
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_XT1_AXI_CLOCK_GATED_EN_ADDR CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_ADDR
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_XT1_AXI_CLOCK_GATED_EN_MASK 0x00000001                // XT1_AXI_CLOCK_GATED_EN[0]
#define CONN_BUS_CR_CONN_INFRA_LOW_POWER_LAYER_CTRL_XT1_AXI_CLOCK_GATED_EN_SHFT 0

/* =====================================================================================

  ---PCIE2AP_REMAP_WF1_0 (0x1800E000 + 0x444)---

    R_PCIE2AP_WF1_PUBLIC_REMAPPING_0[15..0] - (RW)  xxx 
    R_PCIE2AP_WF1_PUBLIC_REMAPPING_1[31..16] - (RW)  xxx 

 =====================================================================================*/
#define CONN_BUS_CR_PCIE2AP_REMAP_WF1_0_R_PCIE2AP_WF1_PUBLIC_REMAPPING_1_ADDR CONN_BUS_CR_PCIE2AP_REMAP_WF1_0_ADDR
#define CONN_BUS_CR_PCIE2AP_REMAP_WF1_0_R_PCIE2AP_WF1_PUBLIC_REMAPPING_1_MASK 0xFFFF0000                // R_PCIE2AP_WF1_PUBLIC_REMAPPING_1[31..16]
#define CONN_BUS_CR_PCIE2AP_REMAP_WF1_0_R_PCIE2AP_WF1_PUBLIC_REMAPPING_1_SHFT 16
#define CONN_BUS_CR_PCIE2AP_REMAP_WF1_0_R_PCIE2AP_WF1_PUBLIC_REMAPPING_0_ADDR CONN_BUS_CR_PCIE2AP_REMAP_WF1_0_ADDR
#define CONN_BUS_CR_PCIE2AP_REMAP_WF1_0_R_PCIE2AP_WF1_PUBLIC_REMAPPING_0_MASK 0x0000FFFF                // R_PCIE2AP_WF1_PUBLIC_REMAPPING_0[15..0]
#define CONN_BUS_CR_PCIE2AP_REMAP_WF1_0_R_PCIE2AP_WF1_PUBLIC_REMAPPING_0_SHFT 0

/* =====================================================================================

  ---PCIE2AP_REMAP_WF1_1 (0x1800E000 + 0x448)---

    R_PCIE2AP_WF1_PUBLIC_REMAPPING_2[15..0] - (RW)  xxx 
    R_PCIE2AP_WF1_PUBLIC_REMAPPING_3[31..16] - (RW)  xxx 

 =====================================================================================*/
#define CONN_BUS_CR_PCIE2AP_REMAP_WF1_1_R_PCIE2AP_WF1_PUBLIC_REMAPPING_3_ADDR CONN_BUS_CR_PCIE2AP_REMAP_WF1_1_ADDR
#define CONN_BUS_CR_PCIE2AP_REMAP_WF1_1_R_PCIE2AP_WF1_PUBLIC_REMAPPING_3_MASK 0xFFFF0000                // R_PCIE2AP_WF1_PUBLIC_REMAPPING_3[31..16]
#define CONN_BUS_CR_PCIE2AP_REMAP_WF1_1_R_PCIE2AP_WF1_PUBLIC_REMAPPING_3_SHFT 16
#define CONN_BUS_CR_PCIE2AP_REMAP_WF1_1_R_PCIE2AP_WF1_PUBLIC_REMAPPING_2_ADDR CONN_BUS_CR_PCIE2AP_REMAP_WF1_1_ADDR
#define CONN_BUS_CR_PCIE2AP_REMAP_WF1_1_R_PCIE2AP_WF1_PUBLIC_REMAPPING_2_MASK 0x0000FFFF                // R_PCIE2AP_WF1_PUBLIC_REMAPPING_2[15..0]
#define CONN_BUS_CR_PCIE2AP_REMAP_WF1_1_R_PCIE2AP_WF1_PUBLIC_REMAPPING_2_SHFT 0

/* =====================================================================================

  ---PCIE2AP_REMAP_WF1_2 (0x1800E000 + 0x44C)---

    R_PCIE2AP_WF1_PUBLIC_REMAPPING_4[15..0] - (RW)  xxx 
    R_PCIE2AP_WF1_PUBLIC_REMAPPING_5[31..16] - (RW)  xxx 

 =====================================================================================*/
#define CONN_BUS_CR_PCIE2AP_REMAP_WF1_2_R_PCIE2AP_WF1_PUBLIC_REMAPPING_5_ADDR CONN_BUS_CR_PCIE2AP_REMAP_WF1_2_ADDR
#define CONN_BUS_CR_PCIE2AP_REMAP_WF1_2_R_PCIE2AP_WF1_PUBLIC_REMAPPING_5_MASK 0xFFFF0000                // R_PCIE2AP_WF1_PUBLIC_REMAPPING_5[31..16]
#define CONN_BUS_CR_PCIE2AP_REMAP_WF1_2_R_PCIE2AP_WF1_PUBLIC_REMAPPING_5_SHFT 16
#define CONN_BUS_CR_PCIE2AP_REMAP_WF1_2_R_PCIE2AP_WF1_PUBLIC_REMAPPING_4_ADDR CONN_BUS_CR_PCIE2AP_REMAP_WF1_2_ADDR
#define CONN_BUS_CR_PCIE2AP_REMAP_WF1_2_R_PCIE2AP_WF1_PUBLIC_REMAPPING_4_MASK 0x0000FFFF                // R_PCIE2AP_WF1_PUBLIC_REMAPPING_4[15..0]
#define CONN_BUS_CR_PCIE2AP_REMAP_WF1_2_R_PCIE2AP_WF1_PUBLIC_REMAPPING_4_SHFT 0

/* =====================================================================================

  ---PCIE2AP_REMAP_WF1_3 (0x1800E000 + 0x450)---

    R_PCIE2AP_WF1_PUBLIC_REMAPPING_6[15..0] - (RW)  xxx 
    R_PCIE2AP_WF1_PUBLIC_REMAPPING_7[31..16] - (RW)  xxx 

 =====================================================================================*/
#define CONN_BUS_CR_PCIE2AP_REMAP_WF1_3_R_PCIE2AP_WF1_PUBLIC_REMAPPING_7_ADDR CONN_BUS_CR_PCIE2AP_REMAP_WF1_3_ADDR
#define CONN_BUS_CR_PCIE2AP_REMAP_WF1_3_R_PCIE2AP_WF1_PUBLIC_REMAPPING_7_MASK 0xFFFF0000                // R_PCIE2AP_WF1_PUBLIC_REMAPPING_7[31..16]
#define CONN_BUS_CR_PCIE2AP_REMAP_WF1_3_R_PCIE2AP_WF1_PUBLIC_REMAPPING_7_SHFT 16
#define CONN_BUS_CR_PCIE2AP_REMAP_WF1_3_R_PCIE2AP_WF1_PUBLIC_REMAPPING_6_ADDR CONN_BUS_CR_PCIE2AP_REMAP_WF1_3_ADDR
#define CONN_BUS_CR_PCIE2AP_REMAP_WF1_3_R_PCIE2AP_WF1_PUBLIC_REMAPPING_6_MASK 0x0000FFFF                // R_PCIE2AP_WF1_PUBLIC_REMAPPING_6[15..0]
#define CONN_BUS_CR_PCIE2AP_REMAP_WF1_3_R_PCIE2AP_WF1_PUBLIC_REMAPPING_6_SHFT 0

/* =====================================================================================

  ---PCIE2AP_REMAP_WF1_4 (0x1800E000 + 0x454)---

    R_PCIE2AP_WF1_PUBLIC_REMAPPING_8[15..0] - (RW)  xxx 
    R_PCIE2AP_WF1_PUBLIC_REMAPPING_9[31..16] - (RW)  xxx 

 =====================================================================================*/
#define CONN_BUS_CR_PCIE2AP_REMAP_WF1_4_R_PCIE2AP_WF1_PUBLIC_REMAPPING_9_ADDR CONN_BUS_CR_PCIE2AP_REMAP_WF1_4_ADDR
#define CONN_BUS_CR_PCIE2AP_REMAP_WF1_4_R_PCIE2AP_WF1_PUBLIC_REMAPPING_9_MASK 0xFFFF0000                // R_PCIE2AP_WF1_PUBLIC_REMAPPING_9[31..16]
#define CONN_BUS_CR_PCIE2AP_REMAP_WF1_4_R_PCIE2AP_WF1_PUBLIC_REMAPPING_9_SHFT 16
#define CONN_BUS_CR_PCIE2AP_REMAP_WF1_4_R_PCIE2AP_WF1_PUBLIC_REMAPPING_8_ADDR CONN_BUS_CR_PCIE2AP_REMAP_WF1_4_ADDR
#define CONN_BUS_CR_PCIE2AP_REMAP_WF1_4_R_PCIE2AP_WF1_PUBLIC_REMAPPING_8_MASK 0x0000FFFF                // R_PCIE2AP_WF1_PUBLIC_REMAPPING_8[15..0]
#define CONN_BUS_CR_PCIE2AP_REMAP_WF1_4_R_PCIE2AP_WF1_PUBLIC_REMAPPING_8_SHFT 0

/* =====================================================================================

  ---PCIE2AP_REMAP_WF1_5 (0x1800E000 + 0x458)---

    R_PCIE2AP_WF1_PUBLIC_REMAPPING_A[15..0] - (RW)  xxx 
    R_PCIE2AP_WF1_PUBLIC_REMAPPING_B[31..16] - (RW)  xxx 

 =====================================================================================*/
#define CONN_BUS_CR_PCIE2AP_REMAP_WF1_5_R_PCIE2AP_WF1_PUBLIC_REMAPPING_B_ADDR CONN_BUS_CR_PCIE2AP_REMAP_WF1_5_ADDR
#define CONN_BUS_CR_PCIE2AP_REMAP_WF1_5_R_PCIE2AP_WF1_PUBLIC_REMAPPING_B_MASK 0xFFFF0000                // R_PCIE2AP_WF1_PUBLIC_REMAPPING_B[31..16]
#define CONN_BUS_CR_PCIE2AP_REMAP_WF1_5_R_PCIE2AP_WF1_PUBLIC_REMAPPING_B_SHFT 16
#define CONN_BUS_CR_PCIE2AP_REMAP_WF1_5_R_PCIE2AP_WF1_PUBLIC_REMAPPING_A_ADDR CONN_BUS_CR_PCIE2AP_REMAP_WF1_5_ADDR
#define CONN_BUS_CR_PCIE2AP_REMAP_WF1_5_R_PCIE2AP_WF1_PUBLIC_REMAPPING_A_MASK 0x0000FFFF                // R_PCIE2AP_WF1_PUBLIC_REMAPPING_A[15..0]
#define CONN_BUS_CR_PCIE2AP_REMAP_WF1_5_R_PCIE2AP_WF1_PUBLIC_REMAPPING_A_SHFT 0

/* =====================================================================================

  ---PCIE2AP_REMAP_WF1_6 (0x1800E000 + 0x45C)---

    R_PCIE2AP_WF1_PUBLIC_REMAPPING_C[15..0] - (RW)  xxx 
    R_PCIE2AP_WF1_PUBLIC_REMAPPING_D[31..16] - (RW)  xxx 

 =====================================================================================*/
#define CONN_BUS_CR_PCIE2AP_REMAP_WF1_6_R_PCIE2AP_WF1_PUBLIC_REMAPPING_D_ADDR CONN_BUS_CR_PCIE2AP_REMAP_WF1_6_ADDR
#define CONN_BUS_CR_PCIE2AP_REMAP_WF1_6_R_PCIE2AP_WF1_PUBLIC_REMAPPING_D_MASK 0xFFFF0000                // R_PCIE2AP_WF1_PUBLIC_REMAPPING_D[31..16]
#define CONN_BUS_CR_PCIE2AP_REMAP_WF1_6_R_PCIE2AP_WF1_PUBLIC_REMAPPING_D_SHFT 16
#define CONN_BUS_CR_PCIE2AP_REMAP_WF1_6_R_PCIE2AP_WF1_PUBLIC_REMAPPING_C_ADDR CONN_BUS_CR_PCIE2AP_REMAP_WF1_6_ADDR
#define CONN_BUS_CR_PCIE2AP_REMAP_WF1_6_R_PCIE2AP_WF1_PUBLIC_REMAPPING_C_MASK 0x0000FFFF                // R_PCIE2AP_WF1_PUBLIC_REMAPPING_C[15..0]
#define CONN_BUS_CR_PCIE2AP_REMAP_WF1_6_R_PCIE2AP_WF1_PUBLIC_REMAPPING_C_SHFT 0

/* =====================================================================================

  ---PCIE2AP_REMAP_WF1_7 (0x1800E000 + 0x460)---

    R_PCIE2AP_WF1_PUBLIC_REMAPPING_E[15..0] - (RW)  xxx 
    R_PCIE2AP_WF1_PUBLIC_REMAPPING_F[31..16] - (RO)  xxx 

 =====================================================================================*/
#define CONN_BUS_CR_PCIE2AP_REMAP_WF1_7_R_PCIE2AP_WF1_PUBLIC_REMAPPING_F_ADDR CONN_BUS_CR_PCIE2AP_REMAP_WF1_7_ADDR
#define CONN_BUS_CR_PCIE2AP_REMAP_WF1_7_R_PCIE2AP_WF1_PUBLIC_REMAPPING_F_MASK 0xFFFF0000                // R_PCIE2AP_WF1_PUBLIC_REMAPPING_F[31..16]
#define CONN_BUS_CR_PCIE2AP_REMAP_WF1_7_R_PCIE2AP_WF1_PUBLIC_REMAPPING_F_SHFT 16
#define CONN_BUS_CR_PCIE2AP_REMAP_WF1_7_R_PCIE2AP_WF1_PUBLIC_REMAPPING_E_ADDR CONN_BUS_CR_PCIE2AP_REMAP_WF1_7_ADDR
#define CONN_BUS_CR_PCIE2AP_REMAP_WF1_7_R_PCIE2AP_WF1_PUBLIC_REMAPPING_E_MASK 0x0000FFFF                // R_PCIE2AP_WF1_PUBLIC_REMAPPING_E[15..0]
#define CONN_BUS_CR_PCIE2AP_REMAP_WF1_7_R_PCIE2AP_WF1_PUBLIC_REMAPPING_E_SHFT 0

/* =====================================================================================

  ---CONN2AP_REMAP_BYPASS (0x1800E000 + 0x464)---

    R_CONN2AP_REMAP_BYPASS[5..0] - (RW)  xxx 
    RESERVED6[31..6]             - (RO) Reserved bits

 =====================================================================================*/
#define CONN_BUS_CR_CONN2AP_REMAP_BYPASS_R_CONN2AP_REMAP_BYPASS_ADDR CONN_BUS_CR_CONN2AP_REMAP_BYPASS_ADDR
#define CONN_BUS_CR_CONN2AP_REMAP_BYPASS_R_CONN2AP_REMAP_BYPASS_MASK 0x0000003F                // R_CONN2AP_REMAP_BYPASS[5..0]
#define CONN_BUS_CR_CONN2AP_REMAP_BYPASS_R_CONN2AP_REMAP_BYPASS_SHFT 0

#ifdef __cplusplus
}
#endif

#endif // __CONN_BUS_CR_REGS_H__
