/*
 * Copyright (c) [2020], MediaTek Inc. All rights reserved.
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws.
 * The information contained herein is confidential and proprietary to
 * MediaTek Inc. and/or its licensors.
 * Except as otherwise provided in the applicable licensing terms with
 * MediaTek Inc. and/or its licensors, any reproduction, modification, use or
 * disclosure of MediaTek Software, and information contained herein, in whole
 * or in part, shall be strictly prohibited.
*/
//[File]            : wf_wtblon_top.h
//[Revision time]   : Wed Aug  1 17:59:42 2018
//[Description]     : This file is auto generated by CODA
//[Copyright]       : Copyright (C) 2018 Mediatek Incorportion. All rights reserved.

#ifndef __WF_WTBLON_TOP_REGS_H__
#define __WF_WTBLON_TOP_REGS_H__

#include "hal_common.h"

#ifdef __cplusplus
extern "C" {
#endif


//****************************************************************************
//
//                     WF_WTBLON_TOP CR Definitions                     
//
//****************************************************************************

#define WF_WTBLON_TOP_BASE                                     0x820D4000

#define WF_WTBLON_TOP_WDUCR_ADDR                               (WF_WTBLON_TOP_BASE + 0x0000) // 4000
#define WF_WTBLON_TOP_MCCR_ADDR                                (WF_WTBLON_TOP_BASE + 0x0004) // 4004
#define WF_WTBLON_TOP_RSCR_ADDR                                (WF_WTBLON_TOP_BASE + 0x0008) // 4008
#define WF_WTBLON_TOP_RICR0_ADDR                               (WF_WTBLON_TOP_BASE + 0x0010) // 4010
#define WF_WTBLON_TOP_RICR1_ADDR                               (WF_WTBLON_TOP_BASE + 0x0014) // 4014
#define WF_WTBLON_TOP_RIUCR0_ADDR                              (WF_WTBLON_TOP_BASE + 0x0020) // 4020
#define WF_WTBLON_TOP_RIUCR1_ADDR                              (WF_WTBLON_TOP_BASE + 0x0024) // 4024
#define WF_WTBLON_TOP_RIUCR2_ADDR                              (WF_WTBLON_TOP_BASE + 0x0028) // 4028
#define WF_WTBLON_TOP_RIUCR3_ADDR                              (WF_WTBLON_TOP_BASE + 0x002C) // 402C
#define WF_WTBLON_TOP_WIUCR_ADDR                               (WF_WTBLON_TOP_BASE + 0x0030) // 4030
#define WF_WTBLON_TOP_WMUDR_ADDR                               (WF_WTBLON_TOP_BASE + 0x0034) // 4034
#define WF_WTBLON_TOP_WMUMR_ADDR                               (WF_WTBLON_TOP_BASE + 0x0038) // 4038
#define WF_WTBLON_TOP_WTBLOR_ADDR                              (WF_WTBLON_TOP_BASE + 0x003C) // 403C
#define WF_WTBLON_TOP_TCGSBR_ADDR                              (WF_WTBLON_TOP_BASE + 0x0040) // 4040
#define WF_WTBLON_TOP_ACGSBR_ADDR                              (WF_WTBLON_TOP_BASE + 0x0050) // 4050
#define WF_WTBLON_TOP_RCGSBR_ADDR                              (WF_WTBLON_TOP_BASE + 0x0060) // 4060
#define WF_WTBLON_TOP_RVCDAR0_ADDR                             (WF_WTBLON_TOP_BASE + 0x0080) // 4080
#define WF_WTBLON_TOP_RVCDAR1_ADDR                             (WF_WTBLON_TOP_BASE + 0x0084) // 4084
#define WF_WTBLON_TOP_RVCDAR2_ADDR                             (WF_WTBLON_TOP_BASE + 0x0088) // 4088
#define WF_WTBLON_TOP_RVCDAR3_ADDR                             (WF_WTBLON_TOP_BASE + 0x008C) // 408C
#define WF_WTBLON_TOP_RVCDAR4_ADDR                             (WF_WTBLON_TOP_BASE + 0x0090) // 4090
#define WF_WTBLON_TOP_RVCDAR5_ADDR                             (WF_WTBLON_TOP_BASE + 0x0094) // 4094
#define WF_WTBLON_TOP_RVCDAR6_ADDR                             (WF_WTBLON_TOP_BASE + 0x0098) // 4098
#define WF_WTBLON_TOP_RVCDAR7_ADDR                             (WF_WTBLON_TOP_BASE + 0x009C) // 409C
#define WF_WTBLON_TOP_PSCDAR0_ADDR                             (WF_WTBLON_TOP_BASE + 0x0100) // 4100
#define WF_WTBLON_TOP_PSCDAR1_ADDR                             (WF_WTBLON_TOP_BASE + 0x0104) // 4104
#define WF_WTBLON_TOP_PSCDAR2_ADDR                             (WF_WTBLON_TOP_BASE + 0x0108) // 4108
#define WF_WTBLON_TOP_PSCDAR3_ADDR                             (WF_WTBLON_TOP_BASE + 0x010C) // 410C
#define WF_WTBLON_TOP_PSCDAR4_ADDR                             (WF_WTBLON_TOP_BASE + 0x0110) // 4110
#define WF_WTBLON_TOP_PSCDAR5_ADDR                             (WF_WTBLON_TOP_BASE + 0x0114) // 4114
#define WF_WTBLON_TOP_PSCDAR6_ADDR                             (WF_WTBLON_TOP_BASE + 0x0118) // 4118
#define WF_WTBLON_TOP_PSCDAR7_ADDR                             (WF_WTBLON_TOP_BASE + 0x011C) // 411C
#define WF_WTBLON_TOP_TPCDAR0_ADDR                             (WF_WTBLON_TOP_BASE + 0x0180) // 4180
#define WF_WTBLON_TOP_TPCDAR1_ADDR                             (WF_WTBLON_TOP_BASE + 0x0184) // 4184
#define WF_WTBLON_TOP_TPCDAR2_ADDR                             (WF_WTBLON_TOP_BASE + 0x0188) // 4188
#define WF_WTBLON_TOP_TPCDAR3_ADDR                             (WF_WTBLON_TOP_BASE + 0x018C) // 418C
#define WF_WTBLON_TOP_TPCDAR4_ADDR                             (WF_WTBLON_TOP_BASE + 0x0190) // 4190
#define WF_WTBLON_TOP_TPCDAR5_ADDR                             (WF_WTBLON_TOP_BASE + 0x0194) // 4194
#define WF_WTBLON_TOP_TPCDAR6_ADDR                             (WF_WTBLON_TOP_BASE + 0x0198) // 4198
#define WF_WTBLON_TOP_TPCDAR7_ADDR                             (WF_WTBLON_TOP_BASE + 0x019C) // 419C
#define WF_WTBLON_TOP_MBIST_0_ADDR                             (WF_WTBLON_TOP_BASE + 0x0300) // 4300
#define WF_WTBLON_TOP_MBIST_1_ADDR                             (WF_WTBLON_TOP_BASE + 0x0304) // 4304
#define WF_WTBLON_TOP_MBIST_2_ADDR                             (WF_WTBLON_TOP_BASE + 0x0308) // 4308
#define WF_WTBLON_TOP_MBIST_3_ADDR                             (WF_WTBLON_TOP_BASE + 0x030C) // 430C
#define WF_WTBLON_TOP_MBIST_4_ADDR                             (WF_WTBLON_TOP_BASE + 0x0310) // 4310
#define WF_WTBLON_TOP_MBIST_5_ADDR                             (WF_WTBLON_TOP_BASE + 0x0314) // 4314
#define WF_WTBLON_TOP_MBIST_6_ADDR                             (WF_WTBLON_TOP_BASE + 0x0318) // 4318
#define WF_WTBLON_TOP_MBIST_7_ADDR                             (WF_WTBLON_TOP_BASE + 0x031C) // 431C
#define WF_WTBLON_TOP_MBIST_8_ADDR                             (WF_WTBLON_TOP_BASE + 0x0320) // 4320
#define WF_WTBLON_TOP_MBIST_9_ADDR                             (WF_WTBLON_TOP_BASE + 0x0324) // 4324
#define WF_WTBLON_TOP_DFR_ADDR                                 (WF_WTBLON_TOP_BASE + 0x0400) // 4400
#define WF_WTBLON_TOP_DBG_ADDR                                 (WF_WTBLON_TOP_BASE + 0x0404) // 4404
#define WF_WTBLON_TOP_DMY0_ADDR                                (WF_WTBLON_TOP_BASE + 0x04F0) // 44F0
#define WF_WTBLON_TOP_DMY1_ADDR                                (WF_WTBLON_TOP_BASE + 0x04F4) // 44F4
#define WF_WTBLON_TOP_B0BTCRn_ADDR                             (WF_WTBLON_TOP_BASE + 0x1000) // 5000
#define WF_WTBLON_TOP_B0BTBCRn_ADDR                            (WF_WTBLON_TOP_BASE + 0x1010) // 5010
#define WF_WTBLON_TOP_B0BRCRn_ADDR                             (WF_WTBLON_TOP_BASE + 0x1020) // 5020
#define WF_WTBLON_TOP_B0BRBCRn_ADDR                            (WF_WTBLON_TOP_BASE + 0x1030) // 5030
#define WF_WTBLON_TOP_B0BTDCRn_ADDR                            (WF_WTBLON_TOP_BASE + 0x1040) // 5040
#define WF_WTBLON_TOP_B0BRDCRn_ADDR                            (WF_WTBLON_TOP_BASE + 0x1050) // 5050
#define WF_WTBLON_TOP_B0BTMRCRn_ADDR                           (WF_WTBLON_TOP_BASE + 0x1080) // 5080
#define WF_WTBLON_TOP_B0BTDRCRn_ADDR                           (WF_WTBLON_TOP_BASE + 0x1090) // 5090
#define WF_WTBLON_TOP_B0BTCCRn_ADDR                            (WF_WTBLON_TOP_BASE + 0x10a0) // 50A0
#define WF_WTBLON_TOP_B0MBTCRn_ADDR                            (WF_WTBLON_TOP_BASE + 0x1100) // 5100
#define WF_WTBLON_TOP_B0MBTBCRn_ADDR                           (WF_WTBLON_TOP_BASE + 0x1140) // 5140
#define WF_WTBLON_TOP_B0MBRCRn_ADDR                            (WF_WTBLON_TOP_BASE + 0x1180) // 5180
#define WF_WTBLON_TOP_B0MBRBCRn_ADDR                           (WF_WTBLON_TOP_BASE + 0x11C0) // 51C0
#define WF_WTBLON_TOP_B0MBTMRCRn_ADDR                          (WF_WTBLON_TOP_BASE + 0x1200) // 5200
#define WF_WTBLON_TOP_B0MBTDRCRn_ADDR                          (WF_WTBLON_TOP_BASE + 0x1240) // 5240
#define WF_WTBLON_TOP_B0MBTCCRn_ADDR                           (WF_WTBLON_TOP_BASE + 0x1280) // 5280
#define WF_WTBLON_TOP_B1BTCRn_ADDR                             (WF_WTBLON_TOP_BASE + 0x1800) // 5800
#define WF_WTBLON_TOP_B1BTBCRn_ADDR                            (WF_WTBLON_TOP_BASE + 0x1810) // 5810
#define WF_WTBLON_TOP_B1BRCRn_ADDR                             (WF_WTBLON_TOP_BASE + 0x1820) // 5820
#define WF_WTBLON_TOP_B1BRBCRn_ADDR                            (WF_WTBLON_TOP_BASE + 0x1830) // 5830
#define WF_WTBLON_TOP_B1BTDCRn_ADDR                            (WF_WTBLON_TOP_BASE + 0x1840) // 5840
#define WF_WTBLON_TOP_B1BRDCRn_ADDR                            (WF_WTBLON_TOP_BASE + 0x1850) // 5850
#define WF_WTBLON_TOP_B1BTMRCRn_ADDR                           (WF_WTBLON_TOP_BASE + 0x1880) // 5880
#define WF_WTBLON_TOP_B1BTDRCRn_ADDR                           (WF_WTBLON_TOP_BASE + 0x1890) // 5890
#define WF_WTBLON_TOP_B1BTCCRn_ADDR                            (WF_WTBLON_TOP_BASE + 0x18a0) // 58A0
#define WF_WTBLON_TOP_B1MBTCRn_ADDR                            (WF_WTBLON_TOP_BASE + 0x1900) // 5900
#define WF_WTBLON_TOP_B1MBTBCRn_ADDR                           (WF_WTBLON_TOP_BASE + 0x1940) // 5940
#define WF_WTBLON_TOP_B1MBRCRn_ADDR                            (WF_WTBLON_TOP_BASE + 0x1980) // 5980
#define WF_WTBLON_TOP_B1MBRBCRn_ADDR                           (WF_WTBLON_TOP_BASE + 0x19C0) // 59C0
#define WF_WTBLON_TOP_B1MBTMRCRn_ADDR                          (WF_WTBLON_TOP_BASE + 0x1a00) // 5A00
#define WF_WTBLON_TOP_B1MBTDRCRn_ADDR                          (WF_WTBLON_TOP_BASE + 0x1a40) // 5A40
#define WF_WTBLON_TOP_B1MBTCCRn_ADDR                           (WF_WTBLON_TOP_BASE + 0x1a80) // 5A80




/* =====================================================================================

  ---WDUCR (0x820D4000 + 0x0000)---

    GROUP[2..0]                  - (RW) The selected group of wtbl
                                     128 entries for each group
    RESERVED3[31..3]             - (RO) Reserved bits

 =====================================================================================*/
#define WF_WTBLON_TOP_WDUCR_GROUP_ADDR                         WF_WTBLON_TOP_WDUCR_ADDR
#define WF_WTBLON_TOP_WDUCR_GROUP_MASK                         0x00000007                // GROUP[2..0]
#define WF_WTBLON_TOP_WDUCR_GROUP_SHFT                         0

/* =====================================================================================

  ---MCCR (0x820D4000 + 0x0004)---

    MIB_PER_BSS_EN[0]            - (RW) Enable per-BSS MIB counter
    MIB_PER_MBSS_EN[1]           - (RW) Enable per-MBSS MIB counter
    RESERVED2[30..2]             - (RO) Reserved bits
    MIB_ACCESS_MODE[31]          - (RW) Access mode for MIB BSS/MBSS counters

 =====================================================================================*/
#define WF_WTBLON_TOP_MCCR_MIB_ACCESS_MODE_ADDR                WF_WTBLON_TOP_MCCR_ADDR
#define WF_WTBLON_TOP_MCCR_MIB_ACCESS_MODE_MASK                0x80000000                // MIB_ACCESS_MODE[31]
#define WF_WTBLON_TOP_MCCR_MIB_ACCESS_MODE_SHFT                31
#define WF_WTBLON_TOP_MCCR_MIB_PER_MBSS_EN_ADDR                WF_WTBLON_TOP_MCCR_ADDR
#define WF_WTBLON_TOP_MCCR_MIB_PER_MBSS_EN_MASK                0x00000002                // MIB_PER_MBSS_EN[1]
#define WF_WTBLON_TOP_MCCR_MIB_PER_MBSS_EN_SHFT                1
#define WF_WTBLON_TOP_MCCR_MIB_PER_BSS_EN_ADDR                 WF_WTBLON_TOP_MCCR_ADDR
#define WF_WTBLON_TOP_MCCR_MIB_PER_BSS_EN_MASK                 0x00000001                // MIB_PER_BSS_EN[0]
#define WF_WTBLON_TOP_MCCR_MIB_PER_BSS_EN_SHFT                 0

/* =====================================================================================

  ---RSCR (0x820D4000 + 0x0008)---

    WTBL_SU_SEARCH[0]            - (RW) WTBL search mode
    WTBL_PRECISE_MATCH[1]        - (RW) Precise match when checking peer address
                                     WTBL do NOT ignore individual/group bit in address check when comparing the peer address with A2
    RESERVED2[31..2]             - (RO) Reserved bits

 =====================================================================================*/
#define WF_WTBLON_TOP_RSCR_WTBL_PRECISE_MATCH_ADDR             WF_WTBLON_TOP_RSCR_ADDR
#define WF_WTBLON_TOP_RSCR_WTBL_PRECISE_MATCH_MASK             0x00000002                // WTBL_PRECISE_MATCH[1]
#define WF_WTBLON_TOP_RSCR_WTBL_PRECISE_MATCH_SHFT             1
#define WF_WTBLON_TOP_RSCR_WTBL_SU_SEARCH_ADDR                 WF_WTBLON_TOP_RSCR_ADDR
#define WF_WTBLON_TOP_RSCR_WTBL_SU_SEARCH_MASK                 0x00000001                // WTBL_SU_SEARCH[0]
#define WF_WTBLON_TOP_RSCR_WTBL_SU_SEARCH_SHFT                 0

/* =====================================================================================

  ---RICR0 (0x820D4000 + 0x0010)---

    DW0_WTBL[31..0]              - (RW) The value of DW in WTBL for updating
                                     the data are updated to WTBL when WIUCR.RXINFO_UPDATE is asserted.

 =====================================================================================*/
#define WF_WTBLON_TOP_RICR0_DW0_WTBL_ADDR                      WF_WTBLON_TOP_RICR0_ADDR
#define WF_WTBLON_TOP_RICR0_DW0_WTBL_MASK                      0xFFFFFFFF                // DW0_WTBL[31..0]
#define WF_WTBLON_TOP_RICR0_DW0_WTBL_SHFT                      0

/* =====================================================================================

  ---RICR1 (0x820D4000 + 0x0014)---

    DW1_WTBL[31..0]              - (RW) The value of DW in WTBL for updating
                                     the data are updated to WTBL when WIUCR.RXINFO_UPDATE is asserted.

 =====================================================================================*/
#define WF_WTBLON_TOP_RICR1_DW1_WTBL_ADDR                      WF_WTBLON_TOP_RICR1_ADDR
#define WF_WTBLON_TOP_RICR1_DW1_WTBL_MASK                      0xFFFFFFFF                // DW1_WTBL[31..0]
#define WF_WTBLON_TOP_RICR1_DW1_WTBL_SHFT                      0

/* =====================================================================================

  ---RIUCR0 (0x820D4000 + 0x0020)---

    DW10_WTBL[31..0]             - (RW) The value of DW in WTBL for updating
                                     the data are updated to WTBL when WIUCR.RATE_UPDATE is asserted.

 =====================================================================================*/
#define WF_WTBLON_TOP_RIUCR0_DW10_WTBL_ADDR                    WF_WTBLON_TOP_RIUCR0_ADDR
#define WF_WTBLON_TOP_RIUCR0_DW10_WTBL_MASK                    0xFFFFFFFF                // DW10_WTBL[31..0]
#define WF_WTBLON_TOP_RIUCR0_DW10_WTBL_SHFT                    0

/* =====================================================================================

  ---RIUCR1 (0x820D4000 + 0x0024)---

    DW11_WTBL[31..0]             - (RW) The value of DW in WTBL for updating
                                     the data are updated to WTBL when WIUCR.RATE_UPDATE is asserted.

 =====================================================================================*/
#define WF_WTBLON_TOP_RIUCR1_DW11_WTBL_ADDR                    WF_WTBLON_TOP_RIUCR1_ADDR
#define WF_WTBLON_TOP_RIUCR1_DW11_WTBL_MASK                    0xFFFFFFFF                // DW11_WTBL[31..0]
#define WF_WTBLON_TOP_RIUCR1_DW11_WTBL_SHFT                    0

/* =====================================================================================

  ---RIUCR2 (0x820D4000 + 0x0028)---

    DW12_WTBL[31..0]             - (RW) The value of DW in WTBL for updating
                                     the data are updated to WTBL when WIUCR.RATE_UPDATE is asserted.

 =====================================================================================*/
#define WF_WTBLON_TOP_RIUCR2_DW12_WTBL_ADDR                    WF_WTBLON_TOP_RIUCR2_ADDR
#define WF_WTBLON_TOP_RIUCR2_DW12_WTBL_MASK                    0xFFFFFFFF                // DW12_WTBL[31..0]
#define WF_WTBLON_TOP_RIUCR2_DW12_WTBL_SHFT                    0

/* =====================================================================================

  ---RIUCR3 (0x820D4000 + 0x002C)---

    DW13_WTBL[31..0]             - (RW) The value of DW in WTBL for updating
                                     the data are updated to WTBL when WIUCR.RATE_UPDATE is asserted.

 =====================================================================================*/
#define WF_WTBLON_TOP_RIUCR3_DW13_WTBL_ADDR                    WF_WTBLON_TOP_RIUCR3_ADDR
#define WF_WTBLON_TOP_RIUCR3_DW13_WTBL_MASK                    0xFFFFFFFF                // DW13_WTBL[31..0]
#define WF_WTBLON_TOP_RIUCR3_DW13_WTBL_SHFT                    0

/* =====================================================================================

  ---WIUCR (0x820D4000 + 0x0030)---

    WLAN_IDX[9..0]               - (RW) Target for clearing or updating
    RESERVED10[10]               - (RO) Reserved bits
    RXINFO_UPDATE[11]            - (W1) Updates RX information according to the value of RICRn (n=0~1)
    ADM_CNT_CLEAR[12]            - (W1) Clear ADM counter to 0
    RATE_UPDATE[13]              - (W1) Updates rate information according to the value of RIUCRn (n=0~3) and clears rate_idx, mpdu_cnt
    TX_RATE_CNT_CLEAR[14]        - (W1) Clear TX rate/BW CNTs and CHK_PER to 0
    RX_CNT_CLEAR[15]             - (W1) Sets RCPI, RSSI, SNR to initial value.
    RTS_CNT_CLEAR[16]            - (W1) Clear RTS counter & RTS_FAIL_CNT_AC* to 0
    RETRY_CNT_CLEAR[17]          - (W1) Clear retry counter to 0
    RESERVED18[19..18]           - (RO) Reserved bits
    MASK_UPDATE[20]              - (W1) Mask Update
                                     WTBL loads target wlan_idx & dw and update the target field by WMUDR & WMUMR
    RESERVED21[23..21]           - (RO) Reserved bits
    DW[29..24]                   - (RW) Target double word
    RESERVED30[30]               - (RO) Reserved bits
    IU_BUSY[31]                  - (RO) Indirect update status
                                     HW will set up this bit when it is updating WTBL.

 =====================================================================================*/
#define WF_WTBLON_TOP_WIUCR_IU_BUSY_ADDR                       WF_WTBLON_TOP_WIUCR_ADDR
#define WF_WTBLON_TOP_WIUCR_IU_BUSY_MASK                       0x80000000                // IU_BUSY[31]
#define WF_WTBLON_TOP_WIUCR_IU_BUSY_SHFT                       31
#define WF_WTBLON_TOP_WIUCR_DW_ADDR                            WF_WTBLON_TOP_WIUCR_ADDR
#define WF_WTBLON_TOP_WIUCR_DW_MASK                            0x3F000000                // DW[29..24]
#define WF_WTBLON_TOP_WIUCR_DW_SHFT                            24
#define WF_WTBLON_TOP_WIUCR_MASK_UPDATE_ADDR                   WF_WTBLON_TOP_WIUCR_ADDR
#define WF_WTBLON_TOP_WIUCR_MASK_UPDATE_MASK                   0x00100000                // MASK_UPDATE[20]
#define WF_WTBLON_TOP_WIUCR_MASK_UPDATE_SHFT                   20
#define WF_WTBLON_TOP_WIUCR_RETRY_CNT_CLEAR_ADDR               WF_WTBLON_TOP_WIUCR_ADDR
#define WF_WTBLON_TOP_WIUCR_RETRY_CNT_CLEAR_MASK               0x00020000                // RETRY_CNT_CLEAR[17]
#define WF_WTBLON_TOP_WIUCR_RETRY_CNT_CLEAR_SHFT               17
#define WF_WTBLON_TOP_WIUCR_RTS_CNT_CLEAR_ADDR                 WF_WTBLON_TOP_WIUCR_ADDR
#define WF_WTBLON_TOP_WIUCR_RTS_CNT_CLEAR_MASK                 0x00010000                // RTS_CNT_CLEAR[16]
#define WF_WTBLON_TOP_WIUCR_RTS_CNT_CLEAR_SHFT                 16
#define WF_WTBLON_TOP_WIUCR_RX_CNT_CLEAR_ADDR                  WF_WTBLON_TOP_WIUCR_ADDR
#define WF_WTBLON_TOP_WIUCR_RX_CNT_CLEAR_MASK                  0x00008000                // RX_CNT_CLEAR[15]
#define WF_WTBLON_TOP_WIUCR_RX_CNT_CLEAR_SHFT                  15
#define WF_WTBLON_TOP_WIUCR_TX_RATE_CNT_CLEAR_ADDR             WF_WTBLON_TOP_WIUCR_ADDR
#define WF_WTBLON_TOP_WIUCR_TX_RATE_CNT_CLEAR_MASK             0x00004000                // TX_RATE_CNT_CLEAR[14]
#define WF_WTBLON_TOP_WIUCR_TX_RATE_CNT_CLEAR_SHFT             14
#define WF_WTBLON_TOP_WIUCR_RATE_UPDATE_ADDR                   WF_WTBLON_TOP_WIUCR_ADDR
#define WF_WTBLON_TOP_WIUCR_RATE_UPDATE_MASK                   0x00002000                // RATE_UPDATE[13]
#define WF_WTBLON_TOP_WIUCR_RATE_UPDATE_SHFT                   13
#define WF_WTBLON_TOP_WIUCR_ADM_CNT_CLEAR_ADDR                 WF_WTBLON_TOP_WIUCR_ADDR
#define WF_WTBLON_TOP_WIUCR_ADM_CNT_CLEAR_MASK                 0x00001000                // ADM_CNT_CLEAR[12]
#define WF_WTBLON_TOP_WIUCR_ADM_CNT_CLEAR_SHFT                 12
#define WF_WTBLON_TOP_WIUCR_RXINFO_UPDATE_ADDR                 WF_WTBLON_TOP_WIUCR_ADDR
#define WF_WTBLON_TOP_WIUCR_RXINFO_UPDATE_MASK                 0x00000800                // RXINFO_UPDATE[11]
#define WF_WTBLON_TOP_WIUCR_RXINFO_UPDATE_SHFT                 11
#define WF_WTBLON_TOP_WIUCR_WLAN_IDX_ADDR                      WF_WTBLON_TOP_WIUCR_ADDR
#define WF_WTBLON_TOP_WIUCR_WLAN_IDX_MASK                      0x000003FF                // WLAN_IDX[9..0]
#define WF_WTBLON_TOP_WIUCR_WLAN_IDX_SHFT                      0

/* =====================================================================================

  ---WMUDR (0x820D4000 + 0x0034)---

    UPDATE_DATA[31..0]           - (RW) Data to update wlan entry

 =====================================================================================*/
#define WF_WTBLON_TOP_WMUDR_UPDATE_DATA_ADDR                   WF_WTBLON_TOP_WMUDR_ADDR
#define WF_WTBLON_TOP_WMUDR_UPDATE_DATA_MASK                   0xFFFFFFFF                // UPDATE_DATA[31..0]
#define WF_WTBLON_TOP_WMUDR_UPDATE_DATA_SHFT                   0

/* =====================================================================================

  ---WMUMR (0x820D4000 + 0x0038)---

    UPDATE_MASK[31..0]           - (RW) Mask of data to update wlan entry

 =====================================================================================*/
#define WF_WTBLON_TOP_WMUMR_UPDATE_MASK_ADDR                   WF_WTBLON_TOP_WMUMR_ADDR
#define WF_WTBLON_TOP_WMUMR_UPDATE_MASK_MASK                   0xFFFFFFFF                // UPDATE_MASK[31..0]
#define WF_WTBLON_TOP_WMUMR_UPDATE_MASK_SHFT                   0

/* =====================================================================================

  ---WTBLOR (0x820D4000 + 0x003C)---

    LOCK_WLAN_IDX[9..0]          - (RW) Target for locking
    RESERVED10[11..10]           - (RO) Reserved bits
    LOCK_RATE[12]                - (RW) Lock rate update
                                     Read this flag to know if it is locked or not.
    RESERVED13[19..13]           - (RO) Reserved bits
    LOCK_ADM_CNT[20]             - (RW) Lock admission control counter update
                                     Read this flag to know if it is locked or not.
    RESERVED21[23..21]           - (RO) Reserved bits
    LOCK_TX_CNT[24]              - (RW) Lock TX/RTS/retry counter update
                                     Read this flag to know if it is locked or not.
    RESERVED25[27..25]           - (RO) Reserved bits
    LOCK_RX_STAT_CNT[28]         - (RW) Lock RX counter update
                                     Read this flag to know if it is locked or not.
    RESERVED29[31..29]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_WTBLON_TOP_WTBLOR_LOCK_RX_STAT_CNT_ADDR             WF_WTBLON_TOP_WTBLOR_ADDR
#define WF_WTBLON_TOP_WTBLOR_LOCK_RX_STAT_CNT_MASK             0x10000000                // LOCK_RX_STAT_CNT[28]
#define WF_WTBLON_TOP_WTBLOR_LOCK_RX_STAT_CNT_SHFT             28
#define WF_WTBLON_TOP_WTBLOR_LOCK_TX_CNT_ADDR                  WF_WTBLON_TOP_WTBLOR_ADDR
#define WF_WTBLON_TOP_WTBLOR_LOCK_TX_CNT_MASK                  0x01000000                // LOCK_TX_CNT[24]
#define WF_WTBLON_TOP_WTBLOR_LOCK_TX_CNT_SHFT                  24
#define WF_WTBLON_TOP_WTBLOR_LOCK_ADM_CNT_ADDR                 WF_WTBLON_TOP_WTBLOR_ADDR
#define WF_WTBLON_TOP_WTBLOR_LOCK_ADM_CNT_MASK                 0x00100000                // LOCK_ADM_CNT[20]
#define WF_WTBLON_TOP_WTBLOR_LOCK_ADM_CNT_SHFT                 20
#define WF_WTBLON_TOP_WTBLOR_LOCK_RATE_ADDR                    WF_WTBLON_TOP_WTBLOR_ADDR
#define WF_WTBLON_TOP_WTBLOR_LOCK_RATE_MASK                    0x00001000                // LOCK_RATE[12]
#define WF_WTBLON_TOP_WTBLOR_LOCK_RATE_SHFT                    12
#define WF_WTBLON_TOP_WTBLOR_LOCK_WLAN_IDX_ADDR                WF_WTBLON_TOP_WTBLOR_ADDR
#define WF_WTBLON_TOP_WTBLOR_LOCK_WLAN_IDX_MASK                0x000003FF                // LOCK_WLAN_IDX[9..0]
#define WF_WTBLON_TOP_WTBLOR_LOCK_WLAN_IDX_SHFT                0

/* =====================================================================================

  ---TCGSBR (0x820D4000 + 0x0040)---

    TX_CNT_STATUS_BITMAP_32[3..0] - (RW) Group bitmap for TX count status
                                     Each bit is mapped to 8 entries in WLAN entry. For example, bit0 -> WLAN entry 0~7; bit1 -> WLAN entry 8~15, etc. SW should read to clear the bitmap when interrupt occurs.
                                     If the entries are absent (i.e. STA mode does not have WLAN entry 33~255), the mapping group bits will be invalid.
    TX_CNT_STATUS_BITMAP_128[15..4] - (RW) Group bitmap for TX count status
                                     Each bit is mapped to 8 entries in WLAN entry. For example, bit0 -> WLAN entry 0~7; bit1 -> WLAN entry 8~15, etc. SW should read to clear the bitmap when interrupt occurs.
                                     If the entries are absent (i.e. STA mode does not have WLAN entry 33~255), the mapping group bits will be invalid.
    TX_CNT_STATUS_BITMAP_256[31..16] - (RW) Group bitmap for TX count status
                                     Each bit is mapped to 8 entries in WLAN entry. For example, bit0 -> WLAN entry 0~7; bit1 -> WLAN entry 8~15, etc. SW should read to clear the bitmap when interrupt occurs.
                                     If the entries are absent (i.e. STA mode does not have WLAN entry 33~255), the mapping group bits will be invalid.

 =====================================================================================*/
#define WF_WTBLON_TOP_TCGSBR_TX_CNT_STATUS_BITMAP_256_ADDR     WF_WTBLON_TOP_TCGSBR_ADDR
#define WF_WTBLON_TOP_TCGSBR_TX_CNT_STATUS_BITMAP_256_MASK     0xFFFF0000                // TX_CNT_STATUS_BITMAP_256[31..16]
#define WF_WTBLON_TOP_TCGSBR_TX_CNT_STATUS_BITMAP_256_SHFT     16
#define WF_WTBLON_TOP_TCGSBR_TX_CNT_STATUS_BITMAP_128_ADDR     WF_WTBLON_TOP_TCGSBR_ADDR
#define WF_WTBLON_TOP_TCGSBR_TX_CNT_STATUS_BITMAP_128_MASK     0x0000FFF0                // TX_CNT_STATUS_BITMAP_128[15..4]
#define WF_WTBLON_TOP_TCGSBR_TX_CNT_STATUS_BITMAP_128_SHFT     4
#define WF_WTBLON_TOP_TCGSBR_TX_CNT_STATUS_BITMAP_32_ADDR      WF_WTBLON_TOP_TCGSBR_ADDR
#define WF_WTBLON_TOP_TCGSBR_TX_CNT_STATUS_BITMAP_32_MASK      0x0000000F                // TX_CNT_STATUS_BITMAP_32[3..0]
#define WF_WTBLON_TOP_TCGSBR_TX_CNT_STATUS_BITMAP_32_SHFT      0

/* =====================================================================================

  ---ACGSBR (0x820D4000 + 0x0050)---

    ADM_CNT_STATUS_BITMAP_32[3..0] - (RW) Group bitmap for ADM count status
                                     Each bit is mapped to 8 entries in WLAN entry. For example, bit0 -> WLAN entry 0~7; bit1 -> WLAN entry 8~15, etc. SW should read to clear the bitmap when interrupt occurs.
                                     If the entries are absent (i.e. STA mode does not have WLAN entry 33~255), the mapping group bits will be invalid.
    ADM_CNT_STATUS_BITMAP_128[15..4] - (RW) Group bitmap for ADM count status
                                     Each bit is mapped to 8 entries in WLAN entry. For example, bit0 -> WLAN entry 0~7; bit1 -> WLAN entry 8~15, etc. SW should read to clear the bitmap when interrupt occurs.
                                     If the entries are absent (i.e. STA mode does not have WLAN entry 33~255), the mapping group bits will be invalid.
    ADM_CNT_STATUS_BITMAP_256[31..16] - (RW) Group bitmap for ADM count status
                                     Each bit is mapped to 8 entries in WLAN entry. For example, bit0 -> WLAN entry 0~7; bit1 -> WLAN entry 8~15, etc. SW should read to clear the bitmap when interrupt occurs.
                                     If the entries are absent (i.e. STA mode does not have WLAN entry 33~255), the mapping group bits will be invalid.

 =====================================================================================*/
#define WF_WTBLON_TOP_ACGSBR_ADM_CNT_STATUS_BITMAP_256_ADDR    WF_WTBLON_TOP_ACGSBR_ADDR
#define WF_WTBLON_TOP_ACGSBR_ADM_CNT_STATUS_BITMAP_256_MASK    0xFFFF0000                // ADM_CNT_STATUS_BITMAP_256[31..16]
#define WF_WTBLON_TOP_ACGSBR_ADM_CNT_STATUS_BITMAP_256_SHFT    16
#define WF_WTBLON_TOP_ACGSBR_ADM_CNT_STATUS_BITMAP_128_ADDR    WF_WTBLON_TOP_ACGSBR_ADDR
#define WF_WTBLON_TOP_ACGSBR_ADM_CNT_STATUS_BITMAP_128_MASK    0x0000FFF0                // ADM_CNT_STATUS_BITMAP_128[15..4]
#define WF_WTBLON_TOP_ACGSBR_ADM_CNT_STATUS_BITMAP_128_SHFT    4
#define WF_WTBLON_TOP_ACGSBR_ADM_CNT_STATUS_BITMAP_32_ADDR     WF_WTBLON_TOP_ACGSBR_ADDR
#define WF_WTBLON_TOP_ACGSBR_ADM_CNT_STATUS_BITMAP_32_MASK     0x0000000F                // ADM_CNT_STATUS_BITMAP_32[3..0]
#define WF_WTBLON_TOP_ACGSBR_ADM_CNT_STATUS_BITMAP_32_SHFT     0

/* =====================================================================================

  ---RCGSBR (0x820D4000 + 0x0060)---

    RATE_CHANGE_STATUS_BITMAP[31..0] - (RW) Group bitmap for rate change status
                                     Each bit is mapped to 8 entries in WLAN entry.
                                     For example,
                                     a = WTBL_NO/8.
                                     bit 0->WLAN entry a*n,
                                     bit 1->WLAN entry a*n+1,
                                     ...
                                     bit m->WLAN entry a*n+m (m <= a).
                                     SW should read to clear the bitmap when interrupt occurs.
                                     If the entries are absent (i.e. STA mode does not have WLAN entry 33~255), the mapping group bits will be invalid.

 =====================================================================================*/
#define WF_WTBLON_TOP_RCGSBR_RATE_CHANGE_STATUS_BITMAP_ADDR    WF_WTBLON_TOP_RCGSBR_ADDR
#define WF_WTBLON_TOP_RCGSBR_RATE_CHANGE_STATUS_BITMAP_MASK    0xFFFFFFFF                // RATE_CHANGE_STATUS_BITMAP[31..0]
#define WF_WTBLON_TOP_RCGSBR_RATE_CHANGE_STATUS_BITMAP_SHFT    0

/* =====================================================================================

  ---RVCDAR0 (0x820D4000 + 0x0080)---

    RV_CACHE[31..0]              - (RW) Each bit is mapped to RV bit in bit 28@WTBL1.
                                     SW uses this CR to read/write RV bit when Wi-Fi enters deep sleep mode.
                                     If wlan_idx > 32, RVCDAR+0x4*i store RV for wlan_idx 32*i ~32*(i+1)-1
                                     HW will update WTBL.RV automatically when this flag is updated.

 =====================================================================================*/
#define WF_WTBLON_TOP_RVCDAR0_RV_CACHE_ADDR                    WF_WTBLON_TOP_RVCDAR0_ADDR
#define WF_WTBLON_TOP_RVCDAR0_RV_CACHE_MASK                    0xFFFFFFFF                // RV_CACHE[31..0]
#define WF_WTBLON_TOP_RVCDAR0_RV_CACHE_SHFT                    0

/* =====================================================================================

  ---RVCDAR1 (0x820D4000 + 0x0084)---

    RV_CACHE[31..0]              - (RW) Each bit is mapped to RV bit in bit 28@WTBL1.
                                     SW uses this CR to read/write RV bit when Wi-Fi enters deep sleep mode.
                                     If wlan_idx > 32, RVCDAR+0x4*i store RV for wlan_idx 32*i ~32*(i+1)-1
                                     HW will update WTBL.RV automatically when this flag is updated.

 =====================================================================================*/
#define WF_WTBLON_TOP_RVCDAR1_RV_CACHE_ADDR                    WF_WTBLON_TOP_RVCDAR1_ADDR
#define WF_WTBLON_TOP_RVCDAR1_RV_CACHE_MASK                    0xFFFFFFFF                // RV_CACHE[31..0]
#define WF_WTBLON_TOP_RVCDAR1_RV_CACHE_SHFT                    0

/* =====================================================================================

  ---RVCDAR2 (0x820D4000 + 0x0088)---

    RV_CACHE[31..0]              - (RW) Each bit is mapped to RV bit in bit 28@WTBL1.
                                     SW uses this CR to read/write RV bit when Wi-Fi enters deep sleep mode.
                                     If wlan_idx > 32, RVCDAR+0x4*i store RV for wlan_idx 32*i ~32*(i+1)-1
                                     HW will update WTBL.RV automatically when this flag is updated.

 =====================================================================================*/
#define WF_WTBLON_TOP_RVCDAR2_RV_CACHE_ADDR                    WF_WTBLON_TOP_RVCDAR2_ADDR
#define WF_WTBLON_TOP_RVCDAR2_RV_CACHE_MASK                    0xFFFFFFFF                // RV_CACHE[31..0]
#define WF_WTBLON_TOP_RVCDAR2_RV_CACHE_SHFT                    0

/* =====================================================================================

  ---RVCDAR3 (0x820D4000 + 0x008C)---

    RV_CACHE[31..0]              - (RW) Each bit is mapped to RV bit in bit 28@WTBL1.
                                     SW uses this CR to read/write RV bit when Wi-Fi enters deep sleep mode.
                                     If wlan_idx > 32, RVCDAR+0x4*i store RV for wlan_idx 32*i ~32*(i+1)-1
                                     HW will update WTBL.RV automatically when this flag is updated.

 =====================================================================================*/
#define WF_WTBLON_TOP_RVCDAR3_RV_CACHE_ADDR                    WF_WTBLON_TOP_RVCDAR3_ADDR
#define WF_WTBLON_TOP_RVCDAR3_RV_CACHE_MASK                    0xFFFFFFFF                // RV_CACHE[31..0]
#define WF_WTBLON_TOP_RVCDAR3_RV_CACHE_SHFT                    0

/* =====================================================================================

  ---RVCDAR4 (0x820D4000 + 0x0090)---

    RV_CACHE[31..0]              - (RW) Each bit is mapped to RV bit in bit 28@WTBL1.
                                     SW uses this CR to read/write RV bit when Wi-Fi enters deep sleep mode.
                                     If wlan_idx > 32, RVCDAR+0x4*i store RV for wlan_idx 32*i ~32*(i+1)-1
                                     HW will update WTBL.RV automatically when this flag is updated.

 =====================================================================================*/
#define WF_WTBLON_TOP_RVCDAR4_RV_CACHE_ADDR                    WF_WTBLON_TOP_RVCDAR4_ADDR
#define WF_WTBLON_TOP_RVCDAR4_RV_CACHE_MASK                    0xFFFFFFFF                // RV_CACHE[31..0]
#define WF_WTBLON_TOP_RVCDAR4_RV_CACHE_SHFT                    0

/* =====================================================================================

  ---RVCDAR5 (0x820D4000 + 0x0094)---

    RV_CACHE[31..0]              - (RW) Each bit is mapped to RV bit in bit 28@WTBL1.
                                     SW uses this CR to read/write RV bit when Wi-Fi enters deep sleep mode.
                                     If wlan_idx > 32, RVCDAR+0x4*i store RV for wlan_idx 32*i ~32*(i+1)-1
                                     HW will update WTBL.RV automatically when this flag is updated.

 =====================================================================================*/
#define WF_WTBLON_TOP_RVCDAR5_RV_CACHE_ADDR                    WF_WTBLON_TOP_RVCDAR5_ADDR
#define WF_WTBLON_TOP_RVCDAR5_RV_CACHE_MASK                    0xFFFFFFFF                // RV_CACHE[31..0]
#define WF_WTBLON_TOP_RVCDAR5_RV_CACHE_SHFT                    0

/* =====================================================================================

  ---RVCDAR6 (0x820D4000 + 0x0098)---

    RV_CACHE[31..0]              - (RW) Each bit is mapped to RV bit in bit 28@WTBL1.
                                     SW uses this CR to read/write RV bit when Wi-Fi enters deep sleep mode.
                                     If wlan_idx > 32, RVCDAR+0x4*i store RV for wlan_idx 32*i ~32*(i+1)-1
                                     HW will update WTBL.RV automatically when this flag is updated.

 =====================================================================================*/
#define WF_WTBLON_TOP_RVCDAR6_RV_CACHE_ADDR                    WF_WTBLON_TOP_RVCDAR6_ADDR
#define WF_WTBLON_TOP_RVCDAR6_RV_CACHE_MASK                    0xFFFFFFFF                // RV_CACHE[31..0]
#define WF_WTBLON_TOP_RVCDAR6_RV_CACHE_SHFT                    0

/* =====================================================================================

  ---RVCDAR7 (0x820D4000 + 0x009C)---

    RV_CACHE[31..0]              - (RW) Each bit is mapped to RV bit in bit 28@WTBL1.
                                     SW uses this CR to read/write RV bit when Wi-Fi enters deep sleep mode.
                                     If wlan_idx > 32, RVCDAR+0x4*i store RV for wlan_idx 32*i ~32*(i+1)-1
                                     HW will update WTBL.RV automatically when this flag is updated.

 =====================================================================================*/
#define WF_WTBLON_TOP_RVCDAR7_RV_CACHE_ADDR                    WF_WTBLON_TOP_RVCDAR7_ADDR
#define WF_WTBLON_TOP_RVCDAR7_RV_CACHE_MASK                    0xFFFFFFFF                // RV_CACHE[31..0]
#define WF_WTBLON_TOP_RVCDAR7_RV_CACHE_SHFT                    0

/* =====================================================================================

  ---PSCDAR0 (0x820D4000 + 0x0100)---

    PS_CACHE[31..0]              - (RW) Each bit is mapped to PS INFO bit (calculate by WTBL).
                                     SW uses this CR to read/write PS INFO bit when Wi-Fi enters deep sleep mode.
                                     If wlan_idx > 32, PSCDAR+0x4*i store PS for wlan_idx 32*i ~32*(i+1)-1

 =====================================================================================*/
#define WF_WTBLON_TOP_PSCDAR0_PS_CACHE_ADDR                    WF_WTBLON_TOP_PSCDAR0_ADDR
#define WF_WTBLON_TOP_PSCDAR0_PS_CACHE_MASK                    0xFFFFFFFF                // PS_CACHE[31..0]
#define WF_WTBLON_TOP_PSCDAR0_PS_CACHE_SHFT                    0

/* =====================================================================================

  ---PSCDAR1 (0x820D4000 + 0x0104)---

    PS_CACHE[31..0]              - (RW) Each bit is mapped to PS INFO bit (calculate by WTBL).
                                     SW uses this CR to read/write PS INFO bit when Wi-Fi enters deep sleep mode.
                                     If wlan_idx > 32, PSCDAR+0x4*i store PS for wlan_idx 32*i ~32*(i+1)-1

 =====================================================================================*/
#define WF_WTBLON_TOP_PSCDAR1_PS_CACHE_ADDR                    WF_WTBLON_TOP_PSCDAR1_ADDR
#define WF_WTBLON_TOP_PSCDAR1_PS_CACHE_MASK                    0xFFFFFFFF                // PS_CACHE[31..0]
#define WF_WTBLON_TOP_PSCDAR1_PS_CACHE_SHFT                    0

/* =====================================================================================

  ---PSCDAR2 (0x820D4000 + 0x0108)---

    PS_CACHE[31..0]              - (RW) Each bit is mapped to PS INFO bit (calculate by WTBL).
                                     SW uses this CR to read/write PS INFO bit when Wi-Fi enters deep sleep mode.
                                     If wlan_idx > 32, PSCDAR+0x4*i store PS for wlan_idx 32*i ~32*(i+1)-1

 =====================================================================================*/
#define WF_WTBLON_TOP_PSCDAR2_PS_CACHE_ADDR                    WF_WTBLON_TOP_PSCDAR2_ADDR
#define WF_WTBLON_TOP_PSCDAR2_PS_CACHE_MASK                    0xFFFFFFFF                // PS_CACHE[31..0]
#define WF_WTBLON_TOP_PSCDAR2_PS_CACHE_SHFT                    0

/* =====================================================================================

  ---PSCDAR3 (0x820D4000 + 0x010C)---

    PS_CACHE[31..0]              - (RW) Each bit is mapped to PS INFO bit (calculate by WTBL).
                                     SW uses this CR to read/write PS INFO bit when Wi-Fi enters deep sleep mode.
                                     If wlan_idx > 32, PSCDAR+0x4*i store PS for wlan_idx 32*i ~32*(i+1)-1

 =====================================================================================*/
#define WF_WTBLON_TOP_PSCDAR3_PS_CACHE_ADDR                    WF_WTBLON_TOP_PSCDAR3_ADDR
#define WF_WTBLON_TOP_PSCDAR3_PS_CACHE_MASK                    0xFFFFFFFF                // PS_CACHE[31..0]
#define WF_WTBLON_TOP_PSCDAR3_PS_CACHE_SHFT                    0

/* =====================================================================================

  ---PSCDAR4 (0x820D4000 + 0x0110)---

    PS_CACHE[31..0]              - (RW) Each bit is mapped to PS INFO bit (calculate by WTBL).
                                     SW uses this CR to read/write PS INFO bit when Wi-Fi enters deep sleep mode.
                                     If wlan_idx > 32, PSCDAR+0x4*i store PS for wlan_idx 32*i ~32*(i+1)-1

 =====================================================================================*/
#define WF_WTBLON_TOP_PSCDAR4_PS_CACHE_ADDR                    WF_WTBLON_TOP_PSCDAR4_ADDR
#define WF_WTBLON_TOP_PSCDAR4_PS_CACHE_MASK                    0xFFFFFFFF                // PS_CACHE[31..0]
#define WF_WTBLON_TOP_PSCDAR4_PS_CACHE_SHFT                    0

/* =====================================================================================

  ---PSCDAR5 (0x820D4000 + 0x0114)---

    PS_CACHE[31..0]              - (RW) Each bit is mapped to PS INFO bit (calculate by WTBL).
                                     SW uses this CR to read/write PS INFO bit when Wi-Fi enters deep sleep mode.
                                     If wlan_idx > 32, PSCDAR+0x4*i store PS for wlan_idx 32*i ~32*(i+1)-1

 =====================================================================================*/
#define WF_WTBLON_TOP_PSCDAR5_PS_CACHE_ADDR                    WF_WTBLON_TOP_PSCDAR5_ADDR
#define WF_WTBLON_TOP_PSCDAR5_PS_CACHE_MASK                    0xFFFFFFFF                // PS_CACHE[31..0]
#define WF_WTBLON_TOP_PSCDAR5_PS_CACHE_SHFT                    0

/* =====================================================================================

  ---PSCDAR6 (0x820D4000 + 0x0118)---

    PS_CACHE[31..0]              - (RW) Each bit is mapped to PS INFO bit (calculate by WTBL).
                                     SW uses this CR to read/write PS INFO bit when Wi-Fi enters deep sleep mode.
                                     If wlan_idx > 32, PSCDAR+0x4*i store PS for wlan_idx 32*i ~32*(i+1)-1

 =====================================================================================*/
#define WF_WTBLON_TOP_PSCDAR6_PS_CACHE_ADDR                    WF_WTBLON_TOP_PSCDAR6_ADDR
#define WF_WTBLON_TOP_PSCDAR6_PS_CACHE_MASK                    0xFFFFFFFF                // PS_CACHE[31..0]
#define WF_WTBLON_TOP_PSCDAR6_PS_CACHE_SHFT                    0

/* =====================================================================================

  ---PSCDAR7 (0x820D4000 + 0x011C)---

    PS_CACHE[31..0]              - (RW) Each bit is mapped to PS INFO bit (calculate by WTBL).
                                     SW uses this CR to read/write PS INFO bit when Wi-Fi enters deep sleep mode.
                                     If wlan_idx > 32, PSCDAR+0x4*i store PS for wlan_idx 32*i ~32*(i+1)-1

 =====================================================================================*/
#define WF_WTBLON_TOP_PSCDAR7_PS_CACHE_ADDR                    WF_WTBLON_TOP_PSCDAR7_ADDR
#define WF_WTBLON_TOP_PSCDAR7_PS_CACHE_MASK                    0xFFFFFFFF                // PS_CACHE[31..0]
#define WF_WTBLON_TOP_PSCDAR7_PS_CACHE_SHFT                    0

/* =====================================================================================

  ---TPCDAR0 (0x820D4000 + 0x0180)---

    TXOP_PS_CACHE[31..0]         - (RW) Each bit is mapped to TXOP_PS_CAP bit.
                                     SW uses this CR to read/write TXOP_PS_CAP bit when Wi-Fi enters deep sleep mode.
                                     If wlan_idx > 32, TPCDAR+0x4*i store TXOP_PS_CAP for wlan_idx 32*i ~32*(i+1)-1
                                     HW will NOT update WTBL.TXOP_PS_CAP automatically when this flag is updated

 =====================================================================================*/
#define WF_WTBLON_TOP_TPCDAR0_TXOP_PS_CACHE_ADDR               WF_WTBLON_TOP_TPCDAR0_ADDR
#define WF_WTBLON_TOP_TPCDAR0_TXOP_PS_CACHE_MASK               0xFFFFFFFF                // TXOP_PS_CACHE[31..0]
#define WF_WTBLON_TOP_TPCDAR0_TXOP_PS_CACHE_SHFT               0

/* =====================================================================================

  ---TPCDAR1 (0x820D4000 + 0x0184)---

    TXOP_PS_CACHE[31..0]         - (RW) Each bit is mapped to TXOP_PS_CAP bit.
                                     SW uses this CR to read/write TXOP_PS_CAP bit when Wi-Fi enters deep sleep mode.
                                     If wlan_idx > 32, TPCDAR+0x4*i store TXOP_PS_CAP for wlan_idx 32*i ~32*(i+1)-1
                                     HW will NOT update WTBL.TXOP_PS_CAP automatically when this flag is updated

 =====================================================================================*/
#define WF_WTBLON_TOP_TPCDAR1_TXOP_PS_CACHE_ADDR               WF_WTBLON_TOP_TPCDAR1_ADDR
#define WF_WTBLON_TOP_TPCDAR1_TXOP_PS_CACHE_MASK               0xFFFFFFFF                // TXOP_PS_CACHE[31..0]
#define WF_WTBLON_TOP_TPCDAR1_TXOP_PS_CACHE_SHFT               0

/* =====================================================================================

  ---TPCDAR2 (0x820D4000 + 0x0188)---

    TXOP_PS_CACHE[31..0]         - (RW) Each bit is mapped to TXOP_PS_CAP bit.
                                     SW uses this CR to read/write TXOP_PS_CAP bit when Wi-Fi enters deep sleep mode.
                                     If wlan_idx > 32, TPCDAR+0x4*i store TXOP_PS_CAP for wlan_idx 32*i ~32*(i+1)-1
                                     HW will NOT update WTBL.TXOP_PS_CAP automatically when this flag is updated

 =====================================================================================*/
#define WF_WTBLON_TOP_TPCDAR2_TXOP_PS_CACHE_ADDR               WF_WTBLON_TOP_TPCDAR2_ADDR
#define WF_WTBLON_TOP_TPCDAR2_TXOP_PS_CACHE_MASK               0xFFFFFFFF                // TXOP_PS_CACHE[31..0]
#define WF_WTBLON_TOP_TPCDAR2_TXOP_PS_CACHE_SHFT               0

/* =====================================================================================

  ---TPCDAR3 (0x820D4000 + 0x018C)---

    TXOP_PS_CACHE[31..0]         - (RW) Each bit is mapped to TXOP_PS_CAP bit.
                                     SW uses this CR to read/write TXOP_PS_CAP bit when Wi-Fi enters deep sleep mode.
                                     If wlan_idx > 32, TPCDAR+0x4*i store TXOP_PS_CAP for wlan_idx 32*i ~32*(i+1)-1
                                     HW will NOT update WTBL.TXOP_PS_CAP automatically when this flag is updated

 =====================================================================================*/
#define WF_WTBLON_TOP_TPCDAR3_TXOP_PS_CACHE_ADDR               WF_WTBLON_TOP_TPCDAR3_ADDR
#define WF_WTBLON_TOP_TPCDAR3_TXOP_PS_CACHE_MASK               0xFFFFFFFF                // TXOP_PS_CACHE[31..0]
#define WF_WTBLON_TOP_TPCDAR3_TXOP_PS_CACHE_SHFT               0

/* =====================================================================================

  ---TPCDAR4 (0x820D4000 + 0x0190)---

    TXOP_PS_CACHE[31..0]         - (RW) Each bit is mapped to TXOP_PS_CAP bit.
                                     SW uses this CR to read/write TXOP_PS_CAP bit when Wi-Fi enters deep sleep mode.
                                     If wlan_idx > 32, TPCDAR+0x4*i store TXOP_PS_CAP for wlan_idx 32*i ~32*(i+1)-1
                                     HW will NOT update WTBL.TXOP_PS_CAP automatically when this flag is updated

 =====================================================================================*/
#define WF_WTBLON_TOP_TPCDAR4_TXOP_PS_CACHE_ADDR               WF_WTBLON_TOP_TPCDAR4_ADDR
#define WF_WTBLON_TOP_TPCDAR4_TXOP_PS_CACHE_MASK               0xFFFFFFFF                // TXOP_PS_CACHE[31..0]
#define WF_WTBLON_TOP_TPCDAR4_TXOP_PS_CACHE_SHFT               0

/* =====================================================================================

  ---TPCDAR5 (0x820D4000 + 0x0194)---

    TXOP_PS_CACHE[31..0]         - (RW) Each bit is mapped to TXOP_PS_CAP bit.
                                     SW uses this CR to read/write TXOP_PS_CAP bit when Wi-Fi enters deep sleep mode.
                                     If wlan_idx > 32, TPCDAR+0x4*i store TXOP_PS_CAP for wlan_idx 32*i ~32*(i+1)-1
                                     HW will NOT update WTBL.TXOP_PS_CAP automatically when this flag is updated

 =====================================================================================*/
#define WF_WTBLON_TOP_TPCDAR5_TXOP_PS_CACHE_ADDR               WF_WTBLON_TOP_TPCDAR5_ADDR
#define WF_WTBLON_TOP_TPCDAR5_TXOP_PS_CACHE_MASK               0xFFFFFFFF                // TXOP_PS_CACHE[31..0]
#define WF_WTBLON_TOP_TPCDAR5_TXOP_PS_CACHE_SHFT               0

/* =====================================================================================

  ---TPCDAR6 (0x820D4000 + 0x0198)---

    TXOP_PS_CACHE[31..0]         - (RW) Each bit is mapped to TXOP_PS_CAP bit.
                                     SW uses this CR to read/write TXOP_PS_CAP bit when Wi-Fi enters deep sleep mode.
                                     If wlan_idx > 32, TPCDAR+0x4*i store TXOP_PS_CAP for wlan_idx 32*i ~32*(i+1)-1
                                     HW will NOT update WTBL.TXOP_PS_CAP automatically when this flag is updated

 =====================================================================================*/
#define WF_WTBLON_TOP_TPCDAR6_TXOP_PS_CACHE_ADDR               WF_WTBLON_TOP_TPCDAR6_ADDR
#define WF_WTBLON_TOP_TPCDAR6_TXOP_PS_CACHE_MASK               0xFFFFFFFF                // TXOP_PS_CACHE[31..0]
#define WF_WTBLON_TOP_TPCDAR6_TXOP_PS_CACHE_SHFT               0

/* =====================================================================================

  ---TPCDAR7 (0x820D4000 + 0x019C)---

    TXOP_PS_CACHE[31..0]         - (RW) Each bit is mapped to TXOP_PS_CAP bit.
                                     SW uses this CR to read/write TXOP_PS_CAP bit when Wi-Fi enters deep sleep mode.
                                     If wlan_idx > 32, TPCDAR+0x4*i store TXOP_PS_CAP for wlan_idx 32*i ~32*(i+1)-1
                                     HW will NOT update WTBL.TXOP_PS_CAP automatically when this flag is updated

 =====================================================================================*/
#define WF_WTBLON_TOP_TPCDAR7_TXOP_PS_CACHE_ADDR               WF_WTBLON_TOP_TPCDAR7_ADDR
#define WF_WTBLON_TOP_TPCDAR7_TXOP_PS_CACHE_MASK               0xFFFFFFFF                // TXOP_PS_CACHE[31..0]
#define WF_WTBLON_TOP_TPCDAR7_TXOP_PS_CACHE_SHFT               0

/* =====================================================================================

  ---MBIST_0 (0x820D4000 + 0x0300)---

    MBIST_MODE[0]                - (RW)  xxx 
    MBIST_HOLDB[1]               - (RW)  xxx 
    MBIST_DEBUG[2]               - (RW)  xxx 
    MEM_USE_DEFAULT_DELSEL[3]    - (RW)  xxx 
    SLEEP_TEST[4]                - (RW)  xxx 
    SLEEP_INV[5]                 - (RW)  xxx 
    SLEEP_W[6]                   - (RW)  xxx 
    SLEEP_R[7]                   - (RW)  xxx 
    RESERVED8[31..8]             - (RO) Reserved bits

 =====================================================================================*/
#define WF_WTBLON_TOP_MBIST_0_SLEEP_R_ADDR                     WF_WTBLON_TOP_MBIST_0_ADDR
#define WF_WTBLON_TOP_MBIST_0_SLEEP_R_MASK                     0x00000080                // SLEEP_R[7]
#define WF_WTBLON_TOP_MBIST_0_SLEEP_R_SHFT                     7
#define WF_WTBLON_TOP_MBIST_0_SLEEP_W_ADDR                     WF_WTBLON_TOP_MBIST_0_ADDR
#define WF_WTBLON_TOP_MBIST_0_SLEEP_W_MASK                     0x00000040                // SLEEP_W[6]
#define WF_WTBLON_TOP_MBIST_0_SLEEP_W_SHFT                     6
#define WF_WTBLON_TOP_MBIST_0_SLEEP_INV_ADDR                   WF_WTBLON_TOP_MBIST_0_ADDR
#define WF_WTBLON_TOP_MBIST_0_SLEEP_INV_MASK                   0x00000020                // SLEEP_INV[5]
#define WF_WTBLON_TOP_MBIST_0_SLEEP_INV_SHFT                   5
#define WF_WTBLON_TOP_MBIST_0_SLEEP_TEST_ADDR                  WF_WTBLON_TOP_MBIST_0_ADDR
#define WF_WTBLON_TOP_MBIST_0_SLEEP_TEST_MASK                  0x00000010                // SLEEP_TEST[4]
#define WF_WTBLON_TOP_MBIST_0_SLEEP_TEST_SHFT                  4
#define WF_WTBLON_TOP_MBIST_0_MEM_USE_DEFAULT_DELSEL_ADDR      WF_WTBLON_TOP_MBIST_0_ADDR
#define WF_WTBLON_TOP_MBIST_0_MEM_USE_DEFAULT_DELSEL_MASK      0x00000008                // MEM_USE_DEFAULT_DELSEL[3]
#define WF_WTBLON_TOP_MBIST_0_MEM_USE_DEFAULT_DELSEL_SHFT      3
#define WF_WTBLON_TOP_MBIST_0_MBIST_DEBUG_ADDR                 WF_WTBLON_TOP_MBIST_0_ADDR
#define WF_WTBLON_TOP_MBIST_0_MBIST_DEBUG_MASK                 0x00000004                // MBIST_DEBUG[2]
#define WF_WTBLON_TOP_MBIST_0_MBIST_DEBUG_SHFT                 2
#define WF_WTBLON_TOP_MBIST_0_MBIST_HOLDB_ADDR                 WF_WTBLON_TOP_MBIST_0_ADDR
#define WF_WTBLON_TOP_MBIST_0_MBIST_HOLDB_MASK                 0x00000002                // MBIST_HOLDB[1]
#define WF_WTBLON_TOP_MBIST_0_MBIST_HOLDB_SHFT                 1
#define WF_WTBLON_TOP_MBIST_0_MBIST_MODE_ADDR                  WF_WTBLON_TOP_MBIST_0_ADDR
#define WF_WTBLON_TOP_MBIST_0_MBIST_MODE_MASK                  0x00000001                // MBIST_MODE[0]
#define WF_WTBLON_TOP_MBIST_0_MBIST_MODE_SHFT                  0

/* =====================================================================================

  ---MBIST_1 (0x820D4000 + 0x0304)---

    MBIST_FAIL[26..0]            - (RO)  xxx 
    RESERVED27[30..27]           - (RO) Reserved bits
    MBIST_DONE[31]               - (RO)  xxx 

 =====================================================================================*/
#define WF_WTBLON_TOP_MBIST_1_MBIST_DONE_ADDR                  WF_WTBLON_TOP_MBIST_1_ADDR
#define WF_WTBLON_TOP_MBIST_1_MBIST_DONE_MASK                  0x80000000                // MBIST_DONE[31]
#define WF_WTBLON_TOP_MBIST_1_MBIST_DONE_SHFT                  31
#define WF_WTBLON_TOP_MBIST_1_MBIST_FAIL_ADDR                  WF_WTBLON_TOP_MBIST_1_ADDR
#define WF_WTBLON_TOP_MBIST_1_MBIST_FAIL_MASK                  0x07FFFFFF                // MBIST_FAIL[26..0]
#define WF_WTBLON_TOP_MBIST_1_MBIST_FAIL_SHFT                  0

/* =====================================================================================

  ---MBIST_2 (0x820D4000 + 0x0308)---

    MBIST_BACKGROUND[15..0]      - (RW)  xxx 
    RESERVED16[31..16]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_WTBLON_TOP_MBIST_2_MBIST_BACKGROUND_ADDR            WF_WTBLON_TOP_MBIST_2_ADDR
#define WF_WTBLON_TOP_MBIST_2_MBIST_BACKGROUND_MASK            0x0000FFFF                // MBIST_BACKGROUND[15..0]
#define WF_WTBLON_TOP_MBIST_2_MBIST_BACKGROUND_SHFT            0

/* =====================================================================================

  ---MBIST_3 (0x820D4000 + 0x030C)---

    MEM_DELSEL_0[15..0]          - (RW)  xxx 
    MEM_DELSEL_1[31..16]         - (RW)  xxx 

 =====================================================================================*/
#define WF_WTBLON_TOP_MBIST_3_MEM_DELSEL_1_ADDR                WF_WTBLON_TOP_MBIST_3_ADDR
#define WF_WTBLON_TOP_MBIST_3_MEM_DELSEL_1_MASK                0xFFFF0000                // MEM_DELSEL_1[31..16]
#define WF_WTBLON_TOP_MBIST_3_MEM_DELSEL_1_SHFT                16
#define WF_WTBLON_TOP_MBIST_3_MEM_DELSEL_0_ADDR                WF_WTBLON_TOP_MBIST_3_ADDR
#define WF_WTBLON_TOP_MBIST_3_MEM_DELSEL_0_MASK                0x0000FFFF                // MEM_DELSEL_0[15..0]
#define WF_WTBLON_TOP_MBIST_3_MEM_DELSEL_0_SHFT                0

/* =====================================================================================

  ---MBIST_4 (0x820D4000 + 0x0310)---

    MEM_DELSEL_2[15..0]          - (RW)  xxx 
    RESERVED16[31..16]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_WTBLON_TOP_MBIST_4_MEM_DELSEL_2_ADDR                WF_WTBLON_TOP_MBIST_4_ADDR
#define WF_WTBLON_TOP_MBIST_4_MEM_DELSEL_2_MASK                0x0000FFFF                // MEM_DELSEL_2[15..0]
#define WF_WTBLON_TOP_MBIST_4_MEM_DELSEL_2_SHFT                0

/* =====================================================================================

  ---MBIST_5 (0x820D4000 + 0x0314)---

    MBIST_FUSE[6..0]             - (RW)  xxx 
    RESERVED7[7]                 - (RO) Reserved bits
    MBIST_PRE_FUSE_0[14..8]      - (RO)  xxx 
    RESERVED15[23..15]           - (RO) Reserved bits
    MBIST_PRE_FUSE_1[30..24]     - (RO)  xxx 
    RESERVED31[31]               - (RO) Reserved bits

 =====================================================================================*/
#define WF_WTBLON_TOP_MBIST_5_MBIST_PRE_FUSE_1_ADDR            WF_WTBLON_TOP_MBIST_5_ADDR
#define WF_WTBLON_TOP_MBIST_5_MBIST_PRE_FUSE_1_MASK            0x7F000000                // MBIST_PRE_FUSE_1[30..24]
#define WF_WTBLON_TOP_MBIST_5_MBIST_PRE_FUSE_1_SHFT            24
#define WF_WTBLON_TOP_MBIST_5_MBIST_PRE_FUSE_0_ADDR            WF_WTBLON_TOP_MBIST_5_ADDR
#define WF_WTBLON_TOP_MBIST_5_MBIST_PRE_FUSE_0_MASK            0x00007F00                // MBIST_PRE_FUSE_0[14..8]
#define WF_WTBLON_TOP_MBIST_5_MBIST_PRE_FUSE_0_SHFT            8
#define WF_WTBLON_TOP_MBIST_5_MBIST_FUSE_ADDR                  WF_WTBLON_TOP_MBIST_5_ADDR
#define WF_WTBLON_TOP_MBIST_5_MBIST_FUSE_MASK                  0x0000007F                // MBIST_FUSE[6..0]
#define WF_WTBLON_TOP_MBIST_5_MBIST_FUSE_SHFT                  0

/* =====================================================================================

  ---MBIST_6 (0x820D4000 + 0x0318)---

    MEM_HDEN[26..0]              - (RW)  xxx 
    RESERVED27[31..27]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_WTBLON_TOP_MBIST_6_MEM_HDEN_ADDR                    WF_WTBLON_TOP_MBIST_6_ADDR
#define WF_WTBLON_TOP_MBIST_6_MEM_HDEN_MASK                    0x07FFFFFF                // MEM_HDEN[26..0]
#define WF_WTBLON_TOP_MBIST_6_MEM_HDEN_SHFT                    0

/* =====================================================================================

  ---MBIST_7 (0x820D4000 + 0x031C)---

    MEM_AWT[26..0]               - (RW)  xxx 
    RESERVED27[31..27]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_WTBLON_TOP_MBIST_7_MEM_AWT_ADDR                     WF_WTBLON_TOP_MBIST_7_ADDR
#define WF_WTBLON_TOP_MBIST_7_MEM_AWT_MASK                     0x07FFFFFF                // MEM_AWT[26..0]
#define WF_WTBLON_TOP_MBIST_7_MEM_AWT_SHFT                     0

/* =====================================================================================

  ---MBIST_8 (0x820D4000 + 0x0320)---

    MBIST_RP_OK[26..0]           - (RO)  xxx 
    RESERVED27[31..27]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_WTBLON_TOP_MBIST_8_MBIST_RP_OK_ADDR                 WF_WTBLON_TOP_MBIST_8_ADDR
#define WF_WTBLON_TOP_MBIST_8_MBIST_RP_OK_MASK                 0x07FFFFFF                // MBIST_RP_OK[26..0]
#define WF_WTBLON_TOP_MBIST_8_MBIST_RP_OK_SHFT                 0

/* =====================================================================================

  ---MBIST_9 (0x820D4000 + 0x0324)---

    MBIST_RP_FAIL[26..0]         - (RO)  xxx 
    RESERVED27[31..27]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_WTBLON_TOP_MBIST_9_MBIST_RP_FAIL_ADDR               WF_WTBLON_TOP_MBIST_9_ADDR
#define WF_WTBLON_TOP_MBIST_9_MBIST_RP_FAIL_MASK               0x07FFFFFF                // MBIST_RP_FAIL[26..0]
#define WF_WTBLON_TOP_MBIST_9_MBIST_RP_FAIL_SHFT               0

/* =====================================================================================

  ---DFR (0x820D4000 + 0x0400)---

    SRAMIF_CS[7..0]              - (RO) SRAM interface FSM
    MUCOPIF_DEB[11..8]           - (RO) MUCOP interface debug
    MDPIF_DBG[15..12]            - (RO) MDP interface debug
    CTRIF_DBG[19..16]            - (RO) Counter Update interface debug
    RESERVED20[27..20]           - (RO) Reserved bits
    SIFIF_CS[30..28]             - (RO) SIF interface FSM
    RESERVED31[31]               - (RO) Reserved bits

 =====================================================================================*/
#define WF_WTBLON_TOP_DFR_SIFIF_CS_ADDR                        WF_WTBLON_TOP_DFR_ADDR
#define WF_WTBLON_TOP_DFR_SIFIF_CS_MASK                        0x70000000                // SIFIF_CS[30..28]
#define WF_WTBLON_TOP_DFR_SIFIF_CS_SHFT                        28
#define WF_WTBLON_TOP_DFR_CTRIF_DBG_ADDR                       WF_WTBLON_TOP_DFR_ADDR
#define WF_WTBLON_TOP_DFR_CTRIF_DBG_MASK                       0x000F0000                // CTRIF_DBG[19..16]
#define WF_WTBLON_TOP_DFR_CTRIF_DBG_SHFT                       16
#define WF_WTBLON_TOP_DFR_MDPIF_DBG_ADDR                       WF_WTBLON_TOP_DFR_ADDR
#define WF_WTBLON_TOP_DFR_MDPIF_DBG_MASK                       0x0000F000                // MDPIF_DBG[15..12]
#define WF_WTBLON_TOP_DFR_MDPIF_DBG_SHFT                       12
#define WF_WTBLON_TOP_DFR_MUCOPIF_DEB_ADDR                     WF_WTBLON_TOP_DFR_ADDR
#define WF_WTBLON_TOP_DFR_MUCOPIF_DEB_MASK                     0x00000F00                // MUCOPIF_DEB[11..8]
#define WF_WTBLON_TOP_DFR_MUCOPIF_DEB_SHFT                     8
#define WF_WTBLON_TOP_DFR_SRAMIF_CS_ADDR                       WF_WTBLON_TOP_DFR_ADDR
#define WF_WTBLON_TOP_DFR_SRAMIF_CS_MASK                       0x000000FF                // SRAMIF_CS[7..0]
#define WF_WTBLON_TOP_DFR_SRAMIF_CS_SHFT                       0

/* =====================================================================================

  ---DBG (0x820D4000 + 0x0404)---

    DBG_USER_SEL[5..0]           - (RW) Select the user for debug flag
    RESERVED6[30..6]             - (RO) Reserved bits
    CKEN_ERROR[31]               - (RO) HW debug info

 =====================================================================================*/
#define WF_WTBLON_TOP_DBG_CKEN_ERROR_ADDR                      WF_WTBLON_TOP_DBG_ADDR
#define WF_WTBLON_TOP_DBG_CKEN_ERROR_MASK                      0x80000000                // CKEN_ERROR[31]
#define WF_WTBLON_TOP_DBG_CKEN_ERROR_SHFT                      31
#define WF_WTBLON_TOP_DBG_DBG_USER_SEL_ADDR                    WF_WTBLON_TOP_DBG_ADDR
#define WF_WTBLON_TOP_DBG_DBG_USER_SEL_MASK                    0x0000003F                // DBG_USER_SEL[5..0]
#define WF_WTBLON_TOP_DBG_DBG_USER_SEL_SHFT                    0

/* =====================================================================================

  ---DMY0 (0x820D4000 + 0x04F0)---

    DMY0[31..0]                  - (RW) Dummy Register with default value 0 for ECO purpose
                                     [31:16] : wtbloff
                                     [15:0] : wtblon

 =====================================================================================*/
#define WF_WTBLON_TOP_DMY0_DMY0_ADDR                           WF_WTBLON_TOP_DMY0_ADDR
#define WF_WTBLON_TOP_DMY0_DMY0_MASK                           0xFFFFFFFF                // DMY0[31..0]
#define WF_WTBLON_TOP_DMY0_DMY0_SHFT                           0

/* =====================================================================================

  ---DMY1 (0x820D4000 + 0x04F4)---

    DMY1[31..0]                  - (RW) Dummy Register with default value 1 for ECO purpose
                                     [31:16] : wtbloff
                                     [15:0] : wtblon

 =====================================================================================*/
#define WF_WTBLON_TOP_DMY1_DMY1_ADDR                           WF_WTBLON_TOP_DMY1_ADDR
#define WF_WTBLON_TOP_DMY1_DMY1_MASK                           0xFFFFFFFF                // DMY1[31..0]
#define WF_WTBLON_TOP_DMY1_DMY1_SHFT                           0

/* =====================================================================================

  ---B0BTCRn (0x820D4000 + 0x1000)---

    TX_COUNTn[31..0]             - (RC) This counter should be incremented for an acknowledged MPDU with an individual address in the address 1 field or an MPDU with a multicast address in the address 1 field is transmitted successfully.

 =====================================================================================*/
#define WF_WTBLON_TOP_B0BTCRn_TX_COUNTn_ADDR                   WF_WTBLON_TOP_B0BTCRn_ADDR
#define WF_WTBLON_TOP_B0BTCRn_TX_COUNTn_MASK                   0xFFFFFFFF                // TX_COUNTn[31..0]
#define WF_WTBLON_TOP_B0BTCRn_TX_COUNTn_SHFT                   0

/* =====================================================================================

  ---B0BTBCRn (0x820D4000 + 0x1010)---

    TX_BYTE_COUNTn[31..0]        - (RC) This counter should be incremented for each successfully transmitted MPDU (802.11 payload).

 =====================================================================================*/
#define WF_WTBLON_TOP_B0BTBCRn_TX_BYTE_COUNTn_ADDR             WF_WTBLON_TOP_B0BTBCRn_ADDR
#define WF_WTBLON_TOP_B0BTBCRn_TX_BYTE_COUNTn_MASK             0xFFFFFFFF                // TX_BYTE_COUNTn[31..0]
#define WF_WTBLON_TOP_B0BTBCRn_TX_BYTE_COUNTn_SHFT             0

/* =====================================================================================

  ---B0BRCRn (0x820D4000 + 0x1020)---

    RX_COUNTn[31..0]             - (RC) This counter should be incremented for each successfully received MPDU (FCS pass+RX filter pass+security pass).

 =====================================================================================*/
#define WF_WTBLON_TOP_B0BRCRn_RX_COUNTn_ADDR                   WF_WTBLON_TOP_B0BRCRn_ADDR
#define WF_WTBLON_TOP_B0BRCRn_RX_COUNTn_MASK                   0xFFFFFFFF                // RX_COUNTn[31..0]
#define WF_WTBLON_TOP_B0BRCRn_RX_COUNTn_SHFT                   0

/* =====================================================================================

  ---B0BRBCRn (0x820D4000 + 0x1030)---

    RX_BYTE_COUNTn[31..0]        - (RC) This counter should be incremented for each successfully received MPDU (payload) (FCS pass+RX filter pass+security pass).

 =====================================================================================*/
#define WF_WTBLON_TOP_B0BRBCRn_RX_BYTE_COUNTn_ADDR             WF_WTBLON_TOP_B0BRBCRn_ADDR
#define WF_WTBLON_TOP_B0BRBCRn_RX_BYTE_COUNTn_MASK             0xFFFFFFFF                // RX_BYTE_COUNTn[31..0]
#define WF_WTBLON_TOP_B0BRBCRn_RX_BYTE_COUNTn_SHFT             0

/* =====================================================================================

  ---B0BTDCRn (0x820D4000 + 0x1040)---

    TX_DATA_COUNTn[31..0]        - (RC) This counter should be incremented when an MSDU is successfully transmitted after one or more retransmissions  (not including MMPDU/NULL frame).

 =====================================================================================*/
#define WF_WTBLON_TOP_B0BTDCRn_TX_DATA_COUNTn_ADDR             WF_WTBLON_TOP_B0BTDCRn_ADDR
#define WF_WTBLON_TOP_B0BTDCRn_TX_DATA_COUNTn_MASK             0xFFFFFFFF                // TX_DATA_COUNTn[31..0]
#define WF_WTBLON_TOP_B0BTDCRn_TX_DATA_COUNTn_SHFT             0

/* =====================================================================================

  ---B0BRDCRn (0x820D4000 + 0x1050)---

    RX_DATA_COUNTn[31..0]        - (RC) This counter should be incremented when an MSDU is successfully received (not including MMPDU/NULL frame).

 =====================================================================================*/
#define WF_WTBLON_TOP_B0BRDCRn_RX_DATA_COUNTn_ADDR             WF_WTBLON_TOP_B0BRDCRn_ADDR
#define WF_WTBLON_TOP_B0BRDCRn_RX_DATA_COUNTn_MASK             0xFFFFFFFF                // RX_DATA_COUNTn[31..0]
#define WF_WTBLON_TOP_B0BRDCRn_RX_DATA_COUNTn_SHFT             0

/* =====================================================================================

  ---B0BTMRCRn (0x820D4000 + 0x1080)---

    TX_MGNT_RETRY_COUNTn[31..0]  - (RC) This counter should be incremented for each retry of management frame after one or more retransmissions (count only 1 time)

 =====================================================================================*/
#define WF_WTBLON_TOP_B0BTMRCRn_TX_MGNT_RETRY_COUNTn_ADDR      WF_WTBLON_TOP_B0BTMRCRn_ADDR
#define WF_WTBLON_TOP_B0BTMRCRn_TX_MGNT_RETRY_COUNTn_MASK      0xFFFFFFFF                // TX_MGNT_RETRY_COUNTn[31..0]
#define WF_WTBLON_TOP_B0BTMRCRn_TX_MGNT_RETRY_COUNTn_SHFT      0

/* =====================================================================================

  ---B0BTDRCRn (0x820D4000 + 0x1090)---

    TX_DATA_RETRY_COUNTn[31..0]  - (RC) This counter should be incremented for each retry of data frame after one or more retransmissions (count only 1 time)

 =====================================================================================*/
#define WF_WTBLON_TOP_B0BTDRCRn_TX_DATA_RETRY_COUNTn_ADDR      WF_WTBLON_TOP_B0BTDRCRn_ADDR
#define WF_WTBLON_TOP_B0BTDRCRn_TX_DATA_RETRY_COUNTn_MASK      0xFFFFFFFF                // TX_DATA_RETRY_COUNTn[31..0]
#define WF_WTBLON_TOP_B0BTDRCRn_TX_DATA_RETRY_COUNTn_SHFT      0

/* =====================================================================================

  ---B0BTCCRn (0x820D4000 + 0x10a0)---

    TX_CTRL_COUNTn[31..0]        - (RC) This counter should be incremented for each successfully transmitted control frame (HW generates only)

 =====================================================================================*/
#define WF_WTBLON_TOP_B0BTCCRn_TX_CTRL_COUNTn_ADDR             WF_WTBLON_TOP_B0BTCCRn_ADDR
#define WF_WTBLON_TOP_B0BTCCRn_TX_CTRL_COUNTn_MASK             0xFFFFFFFF                // TX_CTRL_COUNTn[31..0]
#define WF_WTBLON_TOP_B0BTCCRn_TX_CTRL_COUNTn_SHFT             0

/* =====================================================================================

  ---B0MBTCRn (0x820D4000 + 0x1100)---

    TX_COUNTn[31..0]             - (RC) This counter should be incremented for an acknowledged MPDU with an individual address in the address 1 field or an MPDU with a multicast address in the address 1 field is transmitted successfully.

 =====================================================================================*/
#define WF_WTBLON_TOP_B0MBTCRn_TX_COUNTn_ADDR                  WF_WTBLON_TOP_B0MBTCRn_ADDR
#define WF_WTBLON_TOP_B0MBTCRn_TX_COUNTn_MASK                  0xFFFFFFFF                // TX_COUNTn[31..0]
#define WF_WTBLON_TOP_B0MBTCRn_TX_COUNTn_SHFT                  0

/* =====================================================================================

  ---B0MBTBCRn (0x820D4000 + 0x1140)---

    TX_BYTE_COUNTn[31..0]        - (RC) This counter should be incremented for each successfully transmitted MPDU (802.11 payload).

 =====================================================================================*/
#define WF_WTBLON_TOP_B0MBTBCRn_TX_BYTE_COUNTn_ADDR            WF_WTBLON_TOP_B0MBTBCRn_ADDR
#define WF_WTBLON_TOP_B0MBTBCRn_TX_BYTE_COUNTn_MASK            0xFFFFFFFF                // TX_BYTE_COUNTn[31..0]
#define WF_WTBLON_TOP_B0MBTBCRn_TX_BYTE_COUNTn_SHFT            0

/* =====================================================================================

  ---B0MBRCRn (0x820D4000 + 0x1180)---

    RX_COUNTn[31..0]             - (RC) This counter should be incremented for each successfully received MPDU (FCS pass+RX filter pass+security pass).

 =====================================================================================*/
#define WF_WTBLON_TOP_B0MBRCRn_RX_COUNTn_ADDR                  WF_WTBLON_TOP_B0MBRCRn_ADDR
#define WF_WTBLON_TOP_B0MBRCRn_RX_COUNTn_MASK                  0xFFFFFFFF                // RX_COUNTn[31..0]
#define WF_WTBLON_TOP_B0MBRCRn_RX_COUNTn_SHFT                  0

/* =====================================================================================

  ---B0MBRBCRn (0x820D4000 + 0x11C0)---

    RX_BYTE_COUNTn[31..0]        - (RC) This counter should be incremented for each successfully received MPDU (payload) (FCS pass+RX filter pass+security pass).

 =====================================================================================*/
#define WF_WTBLON_TOP_B0MBRBCRn_RX_BYTE_COUNTn_ADDR            WF_WTBLON_TOP_B0MBRBCRn_ADDR
#define WF_WTBLON_TOP_B0MBRBCRn_RX_BYTE_COUNTn_MASK            0xFFFFFFFF                // RX_BYTE_COUNTn[31..0]
#define WF_WTBLON_TOP_B0MBRBCRn_RX_BYTE_COUNTn_SHFT            0

/* =====================================================================================

  ---B0MBTMRCRn (0x820D4000 + 0x1200)---

    TX_MGNT_RETRY_COUNTn[31..0]  - (RC) This counter should be incremented for each retry of management frame after one or more retransmissions (count only 1 time)

 =====================================================================================*/
#define WF_WTBLON_TOP_B0MBTMRCRn_TX_MGNT_RETRY_COUNTn_ADDR     WF_WTBLON_TOP_B0MBTMRCRn_ADDR
#define WF_WTBLON_TOP_B0MBTMRCRn_TX_MGNT_RETRY_COUNTn_MASK     0xFFFFFFFF                // TX_MGNT_RETRY_COUNTn[31..0]
#define WF_WTBLON_TOP_B0MBTMRCRn_TX_MGNT_RETRY_COUNTn_SHFT     0

/* =====================================================================================

  ---B0MBTDRCRn (0x820D4000 + 0x1240)---

    TX_DATA_RETRY_COUNTn[31..0]  - (RC) This counter should be incremented for each retry of data frame after one or more retransmissions (count only 1 time)

 =====================================================================================*/
#define WF_WTBLON_TOP_B0MBTDRCRn_TX_DATA_RETRY_COUNTn_ADDR     WF_WTBLON_TOP_B0MBTDRCRn_ADDR
#define WF_WTBLON_TOP_B0MBTDRCRn_TX_DATA_RETRY_COUNTn_MASK     0xFFFFFFFF                // TX_DATA_RETRY_COUNTn[31..0]
#define WF_WTBLON_TOP_B0MBTDRCRn_TX_DATA_RETRY_COUNTn_SHFT     0

/* =====================================================================================

  ---B0MBTCCRn (0x820D4000 + 0x1280)---

    TX_CTRL_COUNTn[31..0]        - (RC) This counter should be incremented for each successfully transmitted control frame (HW generates only)

 =====================================================================================*/
#define WF_WTBLON_TOP_B0MBTCCRn_TX_CTRL_COUNTn_ADDR            WF_WTBLON_TOP_B0MBTCCRn_ADDR
#define WF_WTBLON_TOP_B0MBTCCRn_TX_CTRL_COUNTn_MASK            0xFFFFFFFF                // TX_CTRL_COUNTn[31..0]
#define WF_WTBLON_TOP_B0MBTCCRn_TX_CTRL_COUNTn_SHFT            0

/* =====================================================================================

  ---B1BTCRn (0x820D4000 + 0x1800)---

    TX_COUNTn[31..0]             - (RC) This counter should be incremented for an acknowledged MPDU with an individual address in the address 1 field or an MPDU with a multicast address in the address 1 field is transmitted successfully.

 =====================================================================================*/
#define WF_WTBLON_TOP_B1BTCRn_TX_COUNTn_ADDR                   WF_WTBLON_TOP_B1BTCRn_ADDR
#define WF_WTBLON_TOP_B1BTCRn_TX_COUNTn_MASK                   0xFFFFFFFF                // TX_COUNTn[31..0]
#define WF_WTBLON_TOP_B1BTCRn_TX_COUNTn_SHFT                   0

/* =====================================================================================

  ---B1BTBCRn (0x820D4000 + 0x1810)---

    TX_BYTE_COUNTn[31..0]        - (RC) This counter should be incremented for each successfully transmitted MPDU (802.11 payload).

 =====================================================================================*/
#define WF_WTBLON_TOP_B1BTBCRn_TX_BYTE_COUNTn_ADDR             WF_WTBLON_TOP_B1BTBCRn_ADDR
#define WF_WTBLON_TOP_B1BTBCRn_TX_BYTE_COUNTn_MASK             0xFFFFFFFF                // TX_BYTE_COUNTn[31..0]
#define WF_WTBLON_TOP_B1BTBCRn_TX_BYTE_COUNTn_SHFT             0

/* =====================================================================================

  ---B1BRCRn (0x820D4000 + 0x1820)---

    RX_COUNTn[31..0]             - (RC) This counter should be incremented for each successfully received MPDU (FCS pass+RX filter pass+security pass).

 =====================================================================================*/
#define WF_WTBLON_TOP_B1BRCRn_RX_COUNTn_ADDR                   WF_WTBLON_TOP_B1BRCRn_ADDR
#define WF_WTBLON_TOP_B1BRCRn_RX_COUNTn_MASK                   0xFFFFFFFF                // RX_COUNTn[31..0]
#define WF_WTBLON_TOP_B1BRCRn_RX_COUNTn_SHFT                   0

/* =====================================================================================

  ---B1BRBCRn (0x820D4000 + 0x1830)---

    RX_BYTE_COUNTn[31..0]        - (RC) This counter should be incremented for each successfully received MPDU (payload) (FCS pass+RX filter pass+security pass).

 =====================================================================================*/
#define WF_WTBLON_TOP_B1BRBCRn_RX_BYTE_COUNTn_ADDR             WF_WTBLON_TOP_B1BRBCRn_ADDR
#define WF_WTBLON_TOP_B1BRBCRn_RX_BYTE_COUNTn_MASK             0xFFFFFFFF                // RX_BYTE_COUNTn[31..0]
#define WF_WTBLON_TOP_B1BRBCRn_RX_BYTE_COUNTn_SHFT             0

/* =====================================================================================

  ---B1BTDCRn (0x820D4000 + 0x1840)---

    TX_DATA_COUNTn[31..0]        - (RC) This counter should be incremented when an MSDU is successfully transmitted after one or more retransmissions  (not including MMPDU/NULL frame).

 =====================================================================================*/
#define WF_WTBLON_TOP_B1BTDCRn_TX_DATA_COUNTn_ADDR             WF_WTBLON_TOP_B1BTDCRn_ADDR
#define WF_WTBLON_TOP_B1BTDCRn_TX_DATA_COUNTn_MASK             0xFFFFFFFF                // TX_DATA_COUNTn[31..0]
#define WF_WTBLON_TOP_B1BTDCRn_TX_DATA_COUNTn_SHFT             0

/* =====================================================================================

  ---B1BRDCRn (0x820D4000 + 0x1850)---

    RX_DATA_COUNTn[31..0]        - (RC) This counter should be incremented when an MSDU is successfully received (not including MMPDU/NULL frame).

 =====================================================================================*/
#define WF_WTBLON_TOP_B1BRDCRn_RX_DATA_COUNTn_ADDR             WF_WTBLON_TOP_B1BRDCRn_ADDR
#define WF_WTBLON_TOP_B1BRDCRn_RX_DATA_COUNTn_MASK             0xFFFFFFFF                // RX_DATA_COUNTn[31..0]
#define WF_WTBLON_TOP_B1BRDCRn_RX_DATA_COUNTn_SHFT             0

/* =====================================================================================

  ---B1BTMRCRn (0x820D4000 + 0x1880)---

    TX_MGNT_RETRY_COUNTn[31..0]  - (RC) This counter should be incremented for each retry of management frame after one or more retransmissions (count only 1 time)

 =====================================================================================*/
#define WF_WTBLON_TOP_B1BTMRCRn_TX_MGNT_RETRY_COUNTn_ADDR      WF_WTBLON_TOP_B1BTMRCRn_ADDR
#define WF_WTBLON_TOP_B1BTMRCRn_TX_MGNT_RETRY_COUNTn_MASK      0xFFFFFFFF                // TX_MGNT_RETRY_COUNTn[31..0]
#define WF_WTBLON_TOP_B1BTMRCRn_TX_MGNT_RETRY_COUNTn_SHFT      0

/* =====================================================================================

  ---B1BTDRCRn (0x820D4000 + 0x1890)---

    TX_DATA_RETRY_COUNTn[31..0]  - (RC) This counter should be incremented for each retry of data frame after one or more retransmissions (count only 1 time)

 =====================================================================================*/
#define WF_WTBLON_TOP_B1BTDRCRn_TX_DATA_RETRY_COUNTn_ADDR      WF_WTBLON_TOP_B1BTDRCRn_ADDR
#define WF_WTBLON_TOP_B1BTDRCRn_TX_DATA_RETRY_COUNTn_MASK      0xFFFFFFFF                // TX_DATA_RETRY_COUNTn[31..0]
#define WF_WTBLON_TOP_B1BTDRCRn_TX_DATA_RETRY_COUNTn_SHFT      0

/* =====================================================================================

  ---B1BTCCRn (0x820D4000 + 0x18a0)---

    TX_CTRL_COUNTn[31..0]        - (RC) This counter should be incremented for each successfully transmitted control frame (HW generates only)

 =====================================================================================*/
#define WF_WTBLON_TOP_B1BTCCRn_TX_CTRL_COUNTn_ADDR             WF_WTBLON_TOP_B1BTCCRn_ADDR
#define WF_WTBLON_TOP_B1BTCCRn_TX_CTRL_COUNTn_MASK             0xFFFFFFFF                // TX_CTRL_COUNTn[31..0]
#define WF_WTBLON_TOP_B1BTCCRn_TX_CTRL_COUNTn_SHFT             0

/* =====================================================================================

  ---B1MBTCRn (0x820D4000 + 0x1900)---

    TX_COUNTn[31..0]             - (RC) This counter should be incremented for an acknowledged MPDU with an individual address in the address 1 field or an MPDU with a multicast address in the address 1 field is transmitted successfully.

 =====================================================================================*/
#define WF_WTBLON_TOP_B1MBTCRn_TX_COUNTn_ADDR                  WF_WTBLON_TOP_B1MBTCRn_ADDR
#define WF_WTBLON_TOP_B1MBTCRn_TX_COUNTn_MASK                  0xFFFFFFFF                // TX_COUNTn[31..0]
#define WF_WTBLON_TOP_B1MBTCRn_TX_COUNTn_SHFT                  0

/* =====================================================================================

  ---B1MBTBCRn (0x820D4000 + 0x1940)---

    TX_BYTE_COUNTn[31..0]        - (RC) This counter should be incremented for each successfully transmitted MPDU (802.11 payload).

 =====================================================================================*/
#define WF_WTBLON_TOP_B1MBTBCRn_TX_BYTE_COUNTn_ADDR            WF_WTBLON_TOP_B1MBTBCRn_ADDR
#define WF_WTBLON_TOP_B1MBTBCRn_TX_BYTE_COUNTn_MASK            0xFFFFFFFF                // TX_BYTE_COUNTn[31..0]
#define WF_WTBLON_TOP_B1MBTBCRn_TX_BYTE_COUNTn_SHFT            0

/* =====================================================================================

  ---B1MBRCRn (0x820D4000 + 0x1980)---

    RX_COUNTn[31..0]             - (RC) This counter should be incremented for each successfully received MPDU (FCS pass+RX filter pass+security pass).

 =====================================================================================*/
#define WF_WTBLON_TOP_B1MBRCRn_RX_COUNTn_ADDR                  WF_WTBLON_TOP_B1MBRCRn_ADDR
#define WF_WTBLON_TOP_B1MBRCRn_RX_COUNTn_MASK                  0xFFFFFFFF                // RX_COUNTn[31..0]
#define WF_WTBLON_TOP_B1MBRCRn_RX_COUNTn_SHFT                  0

/* =====================================================================================

  ---B1MBRBCRn (0x820D4000 + 0x19C0)---

    RX_BYTE_COUNTn[31..0]        - (RC) This counter should be incremented for each successfully received MPDU (payload) (FCS pass+RX filter pass+security pass).

 =====================================================================================*/
#define WF_WTBLON_TOP_B1MBRBCRn_RX_BYTE_COUNTn_ADDR            WF_WTBLON_TOP_B1MBRBCRn_ADDR
#define WF_WTBLON_TOP_B1MBRBCRn_RX_BYTE_COUNTn_MASK            0xFFFFFFFF                // RX_BYTE_COUNTn[31..0]
#define WF_WTBLON_TOP_B1MBRBCRn_RX_BYTE_COUNTn_SHFT            0

/* =====================================================================================

  ---B1MBTMRCRn (0x820D4000 + 0x1a00)---

    TX_MGNT_RETRY_COUNTn[31..0]  - (RC) This counter should be incremented for each retry of management frame after one or more retransmissions (count only 1 time)

 =====================================================================================*/
#define WF_WTBLON_TOP_B1MBTMRCRn_TX_MGNT_RETRY_COUNTn_ADDR     WF_WTBLON_TOP_B1MBTMRCRn_ADDR
#define WF_WTBLON_TOP_B1MBTMRCRn_TX_MGNT_RETRY_COUNTn_MASK     0xFFFFFFFF                // TX_MGNT_RETRY_COUNTn[31..0]
#define WF_WTBLON_TOP_B1MBTMRCRn_TX_MGNT_RETRY_COUNTn_SHFT     0

/* =====================================================================================

  ---B1MBTDRCRn (0x820D4000 + 0x1a40)---

    TX_DATA_RETRY_COUNTn[31..0]  - (RC) This counter should be incremented for each retry of data frame after one or more retransmissions (count only 1 time)

 =====================================================================================*/
#define WF_WTBLON_TOP_B1MBTDRCRn_TX_DATA_RETRY_COUNTn_ADDR     WF_WTBLON_TOP_B1MBTDRCRn_ADDR
#define WF_WTBLON_TOP_B1MBTDRCRn_TX_DATA_RETRY_COUNTn_MASK     0xFFFFFFFF                // TX_DATA_RETRY_COUNTn[31..0]
#define WF_WTBLON_TOP_B1MBTDRCRn_TX_DATA_RETRY_COUNTn_SHFT     0

/* =====================================================================================

  ---B1MBTCCRn (0x820D4000 + 0x1a80)---

    TX_CTRL_COUNTn[31..0]        - (RC) This counter should be incremented for each successfully transmitted control frame (HW generates only)

 =====================================================================================*/
#define WF_WTBLON_TOP_B1MBTCCRn_TX_CTRL_COUNTn_ADDR            WF_WTBLON_TOP_B1MBTCCRn_ADDR
#define WF_WTBLON_TOP_B1MBTCCRn_TX_CTRL_COUNTn_MASK            0xFFFFFFFF                // TX_CTRL_COUNTn[31..0]
#define WF_WTBLON_TOP_B1MBTCCRn_TX_CTRL_COUNTn_SHFT            0

#ifdef __cplusplus
}
#endif

#endif // __WF_WTBLON_TOP_REGS_H__
