#ifndef __COMMON_CHIP_H__
#define __COMMON_CHIP_H__
static const UINT16 wtbl_e1_risky_wcid[] = {
	0, 1, 2, 3,
	32, 33, 34, 35,
	64, 65, 66, 67,
	96, 97, 98, 99,
	128, 129, 130, 131,
	160, 161, 162, 163,
	192, 193, 194, 195,
	224, 225, 226, 227 /* total 32 wtbl entries */
};

typedef enum _POWER_LIMIT_TABLE_TYPE_SKU_CATEGORY {
	SINGLE_SKU_TABLE_CCK = 0,
	SINGLE_SKU_TABLE_OFDM,
	SINGLE_SKU_TABLE_HT20,
	SINGLE_SKU_TABLE_HT40,
	SINGLE_SKU_TABLE_VHT20,
	SINGLE_SKU_TABLE_VHT40,
	SINGLE_SKU_TABLE_VHT80,
	SINGLE_SKU_TABLE_VHT160,
	SINGLE_SKU_TABLE_RU26,
	SINGLE_SKU_TABLE_RU52,
	SINGLE_SKU_TABLE_RU106,
	SINGLE_SKU_TABLE_RU242,
	SINGLE_SKU_TABLE_RU484,
	SINGLE_SKU_TABLE_RU996,
	SINGLE_SKU_TABLE_RU996X2,
	SINGLE_SKU_TABLE_NUM
} POWER_LIMIT_TABLE_TYPE_SKU_CATEGORY, *P_POWER_LIMIT_TABLE_TYPE_SKU_CATEGORY;

typedef enum _POWER_LIMIT_TABLE_TYPE_BACKOFF_CATEGORY {
	BACKOFF_TABLE_BF_OFF_CCK = 0,
	BACKOFF_TABLE_BF_OFF_OFDM,
	BACKOFF_TABLE_BF_ON_OFDM,
	BACKOFF_TABLE_BF_OFF_HT20,
	BACKOFF_TABLE_BF_ON_HT20,
	BACKOFF_TABLE_BF_OFF_HT40,
	BACKOFF_TABLE_BF_ON_HT40,
	BACKOFF_TABLE_BF_OFF_VHT20,
	BACKOFF_TABLE_BF_ON_VHT20,
	BACKOFF_TABLE_BF_OFF_VHT40,
	BACKOFF_TABLE_BF_ON_VHT40,
	BACKOFF_TABLE_BF_OFF_VHT80,
	BACKOFF_TABLE_BF_ON_VHT80,
	BACKOFF_TABLE_BF_OFF_VHT160,
	BACKOFF_TABLE_BF_ON_VHT160,
	BACKOFF_TABLE_BF_OFF_RU26,
	BACKOFF_TABLE_BF_ON_RU26,
	BACKOFF_TABLE_BF_OFF_RU52,
	BACKOFF_TABLE_BF_ON_RU52,
	BACKOFF_TABLE_BF_OFF_RU106,
	BACKOFF_TABLE_BF_ON_RU106,
	BACKOFF_TABLE_NUM
} POWER_LIMIT_TABLE_TYPE_BACKOFF_CATEGORY, *P_POWER_LIMIT_TABLE_TYPE_BACKOFF_CATEGORY;

/* SKU Table definitions */
static const CHAR cSkuParseTypeName[SINGLE_SKU_TYPE_PARSE_NUM_V1][8] = {"CCK", "OFDM", "VHT20", "VHT40", "VHT80", "VHT160", "RU26", "RU52", "RU106", "RU242", "RU484", "RU996", "RU996X2"};
static const CHAR cBackoffParseTypeName[BACKOFF_TYPE_PARSE_NUM_V1][14] = {"BFOFF_CCK", "BF_OFF_OFDM", "BF_ON_OFDM", "BF_OFF_VHT20", "BF_ON_VHT20", "BF_OFF_VHT40", "BF_ON_VHT40", "BF_OFF_VHT80", "BF_ON_VHT80", "BF_OFF_VHT160", "BF_ON_VHT160", "BF_OFF_RU26", "BF_ON_RU26", "BF_OFF_RU52", "BF_ON_RU52", "BF_OFF_RU106", "BF_ON_RU106"};

static const UINT8 SINGLE_SKU_PARSE_TABLE_LENGTH[SINGLE_SKU_TYPE_PARSE_NUM_V1] = {
	SINGLE_SKU_PARSE_TABLE_CCK_LENGTH_V1,
	SINGLE_SKU_PARSE_TABLE_OFDM_LENGTH_V1,
	SINGLE_SKU_PARSE_TABLE_HTVHT20_LENGTH_V1,
	SINGLE_SKU_PARSE_TABLE_HTVHT40_LENGTH_V1,
	SINGLE_SKU_PARSE_TABLE_VHT80_LENGTH_V1,
	SINGLE_SKU_PARSE_TABLE_VHT160_LENGTH_V1,
	SINGLE_SKU_PARSE_TABLE_RU26_LENGTH_V1,
	SINGLE_SKU_PARSE_TABLE_RU52_LENGTH_V1,
	SINGLE_SKU_PARSE_TABLE_RU106_LENGTH_V1,
	SINGLE_SKU_PARSE_TABLE_RU242_LENGTH_V1,
	SINGLE_SKU_PARSE_TABLE_RU484_LENGTH_V1,
	SINGLE_SKU_PARSE_TABLE_RU996_LENGTH_V1,
	SINGLE_SKU_PARSE_TABLE_RU996X2_LENGTH_V1
};

static const UINT8 BACKOFF_TABLE_BF_LENGTH[BACKOFF_TYPE_PARSE_NUM_V1] = {
	BACKOFF_TABLE_BF_OFF_CCK_LENGTH_V1,
	BACKOFF_TABLE_BF_OFF_OFDM_LENGTH_V1,
	BACKOFF_TABLE_BF_ON_OFDM_LENGTH_V1,
	BACKOFF_TABLE_BF_OFF_VHT20_LENGTH_V1,
	BACKOFF_TABLE_BF_ON_VHT20_LENGTH_V1,
	BACKOFF_TABLE_BF_OFF_VHT40_LENGTH_V1,
	BACKOFF_TABLE_BF_ON_VHT40_LENGTH_V1,
	BACKOFF_TABLE_BF_OFF_VHT80_LENGTH_V1,
	BACKOFF_TABLE_BF_ON_VHT80_LENGTH_V1,
	BACKOFF_TABLE_BF_OFF_VHT160_LENGTH_V1,
	BACKOFF_TABLE_BF_ON_VHT160_LENGTH_V1,
	BACKOFF_TABLE_BF_OFF_RU26_LENGTH_V1,
	BACKOFF_TABLE_BF_ON_RU26_LENGTH_V1,
	BACKOFF_TABLE_BF_OFF_RU52_LENGTH_V1,
	BACKOFF_TABLE_BF_ON_RU52_LENGTH_V1,
	BACKOFF_TABLE_BF_OFF_RU106_LENGTH_V1,
	BACKOFF_TABLE_BF_ON_RU106_LENGTH_V1
};

static const UINT8 BACKOFF_FILL_TABLE_BF_LENGTH[BACKOFF_PARAM_NUM_V1] = {
	BACKOFF_TABLE_BF_OFF_CCK_LENGTH_V1,
	BACKOFF_TABLE_BF_OFF_OFDM_LENGTH_V1,
	BACKOFF_TABLE_BF_ON_OFDM_LENGTH_V1,
	BACKOFF_TABLE_BF_OFF_VHT20_LENGTH_V1,
	BACKOFF_TABLE_BF_ON_VHT20_LENGTH_V1,
	BACKOFF_TABLE_BF_OFF_VHT40_LENGTH_V1,
	BACKOFF_TABLE_BF_ON_VHT40_LENGTH_V1,
	BACKOFF_TABLE_BF_OFF_VHT20_LENGTH_V1,
	BACKOFF_TABLE_BF_ON_VHT20_LENGTH_V1,
	BACKOFF_TABLE_BF_OFF_VHT40_LENGTH_V1,
	BACKOFF_TABLE_BF_ON_VHT40_LENGTH_V1,
	BACKOFF_TABLE_BF_OFF_VHT80_LENGTH_V1,
	BACKOFF_TABLE_BF_ON_VHT80_LENGTH_V1,
	BACKOFF_TABLE_BF_OFF_VHT160_LENGTH_V1,
	BACKOFF_TABLE_BF_ON_VHT160_LENGTH_V1,
	BACKOFF_TABLE_BF_OFF_RU26_LENGTH_V1,
	BACKOFF_TABLE_BF_ON_RU26_LENGTH_V1,
	BACKOFF_TABLE_BF_OFF_RU52_LENGTH_V1,
	BACKOFF_TABLE_BF_ON_RU52_LENGTH_V1,
	BACKOFF_TABLE_BF_OFF_RU106_LENGTH_V1,
	BACKOFF_TABLE_BF_ON_RU106_LENGTH_V1
};

typedef enum _ENUM_TXPOWER_TYPE_CCK_T {
	MODULATION_SYSTEM_CCK_1M = 0,
	MODULATION_SYSTEM_CCK_2M,
	MODULATION_SYSTEM_CCK_5M,
	MODULATION_SYSTEM_CCK_11M,
	MODULATION_SYSTEM_CCK_NUM
} ENUM_TXPOWER_TYPE_CCK_T, *P_ENUM_TXPOWER_TYPE_CCK_T;

typedef enum _ENUM_TXPOWER_TYPE_OFDM_T {
	MODULATION_SYSTEM_OFDM_6M = 0,
	MODULATION_SYSTEM_OFDM_9M,
	MODULATION_SYSTEM_OFDM_12M,
	MODULATION_SYSTEM_OFDM_18M,
	MODULATION_SYSTEM_OFDM_24M,
	MODULATION_SYSTEM_OFDM_36M,
	MODULATION_SYSTEM_OFDM_48M,
	MODULATION_SYSTEM_OFDM_54M,
	MODULATION_SYSTEM_OFDM_NUM
} ENUM_TXPOWER_TYPE_OFDM_T, *P_ENUM_TXPOWER_TYPE_OFDM_T;

typedef enum _ENUM_TXPOWER_TYPE_HT20_T {
	MODULATION_SYSTEM_HT20_MCS0 = 0,
	MODULATION_SYSTEM_HT20_MCS1,
	MODULATION_SYSTEM_HT20_MCS2,
	MODULATION_SYSTEM_HT20_MCS3,
	MODULATION_SYSTEM_HT20_MCS4,
	MODULATION_SYSTEM_HT20_MCS5,
	MODULATION_SYSTEM_HT20_MCS6,
	MODULATION_SYSTEM_HT20_MCS7,
	MODULATION_SYSTEM_HT20_NUM
} ENUM_TXPOWER_TYPE_HT20_T, *P_ENUM_TXPOWER_TYPE_HT20_T;

typedef enum _ENUM_TXPOWER_TYPE_HT40_T {
	MODULATION_SYSTEM_HT40_MCS0 = 0,
	MODULATION_SYSTEM_HT40_MCS1,
	MODULATION_SYSTEM_HT40_MCS2,
	MODULATION_SYSTEM_HT40_MCS3,
	MODULATION_SYSTEM_HT40_MCS4,
	MODULATION_SYSTEM_HT40_MCS5,
	MODULATION_SYSTEM_HT40_MCS6,
	MODULATION_SYSTEM_HT40_MCS7,
	MODULATION_SYSTEM_HT40_MCS32,
	MODULATION_SYSTEM_HT40_NUM
} ENUM_TXPOWER_TYPE_HT40_T, *P_ENUM_TXPOWER_TYPE_HT40_T;

typedef enum _ENUM_TXPOWER_TYPE_VHT20_T {
	MODULATION_SYSTEM_VHT20_MCS0 = 0,
	MODULATION_SYSTEM_VHT20_MCS1,
	MODULATION_SYSTEM_VHT20_MCS2,
	MODULATION_SYSTEM_VHT20_MCS3,
	MODULATION_SYSTEM_VHT20_MCS4,
	MODULATION_SYSTEM_VHT20_MCS5,
	MODULATION_SYSTEM_VHT20_MCS6,
	MODULATION_SYSTEM_VHT20_MCS7,
	MODULATION_SYSTEM_VHT20_MCS8,
	MODULATION_SYSTEM_VHT20_MCS9,
	MODULATION_SYSTEM_VHT20_MCS10,
	MODULATION_SYSTEM_VHT20_MCS11,
	MODULATION_SYSTEM_VHT20_NUM
} ENUM_TXPOWER_TYPE_VHT20_T, *P_ENUM_TXPOWER_TYPE_VHT20_T;

typedef enum _ENUM_TXPOWER_TYPE_VHT40_T {
	MODULATION_SYSTEM_VHT40_MCS0 = 0,
	MODULATION_SYSTEM_VHT40_MCS1,
	MODULATION_SYSTEM_VHT40_MCS2,
	MODULATION_SYSTEM_VHT40_MCS3,
	MODULATION_SYSTEM_VHT40_MCS4,
	MODULATION_SYSTEM_VHT40_MCS5,
	MODULATION_SYSTEM_VHT40_MCS6,
	MODULATION_SYSTEM_VHT40_MCS7,
	MODULATION_SYSTEM_VHT40_MCS8,
	MODULATION_SYSTEM_VHT40_MCS9,
	MODULATION_SYSTEM_VHT40_MCS10,
	MODULATION_SYSTEM_VHT40_MCS11,
	MODULATION_SYSTEM_VHT40_NUM
} ENUM_TXPOWER_TYPE_VHT40_T, *P_ENUM_TXPOWER_TYPE_VHT40_T;

typedef enum _ENUM_TXPOWER_TYPE_VHT80_T {
	MODULATION_SYSTEM_VHT80_MCS0 = 0,
	MODULATION_SYSTEM_VHT80_MCS1,
	MODULATION_SYSTEM_VHT80_MCS2,
	MODULATION_SYSTEM_VHT80_MCS3,
	MODULATION_SYSTEM_VHT80_MCS4,
	MODULATION_SYSTEM_VHT80_MCS5,
	MODULATION_SYSTEM_VHT80_MCS6,
	MODULATION_SYSTEM_VHT80_MCS7,
	MODULATION_SYSTEM_VHT80_MCS8,
	MODULATION_SYSTEM_VHT80_MCS9,
	MODULATION_SYSTEM_VHT80_MCS10,
	MODULATION_SYSTEM_VHT80_MCS11,
	MODULATION_SYSTEM_VHT80_NUM
} ENUM_TXPOWER_TYPE_VHT80_T, *P_ENUM_TXPOWER_TYPE_VHT80_T;

typedef enum _ENUM_TXPOWER_TYPE_VHT160_T {
	MODULATION_SYSTEM_VHT160_MCS0 = 0,
	MODULATION_SYSTEM_VHT160_MCS1,
	MODULATION_SYSTEM_VHT160_MCS2,
	MODULATION_SYSTEM_VHT160_MCS3,
	MODULATION_SYSTEM_VHT160_MCS4,
	MODULATION_SYSTEM_VHT160_MCS5,
	MODULATION_SYSTEM_VHT160_MCS6,
	MODULATION_SYSTEM_VHT160_MCS7,
	MODULATION_SYSTEM_VHT160_MCS8,
	MODULATION_SYSTEM_VHT160_MCS9,
	MODULATION_SYSTEM_VHT160_MCS10,
	MODULATION_SYSTEM_VHT160_MCS11,
	MODULATION_SYSTEM_VHT160_NUM
} ENUM_TXPOWER_TYPE_VHT160_T, *P_ENUM_TXPOWER_TYPE_VHT160_T;

typedef enum _ENUM_TXPOWER_TYPE_HE26_T {
	MODULATION_SYSTEM_HE26_MCS0 = 0,
	MODULATION_SYSTEM_HE26_MCS1,
	MODULATION_SYSTEM_HE26_MCS2,
	MODULATION_SYSTEM_HE26_MCS3,
	MODULATION_SYSTEM_HE26_MCS4,
	MODULATION_SYSTEM_HE26_MCS5,
	MODULATION_SYSTEM_HE26_MCS6,
	MODULATION_SYSTEM_HE26_MCS7,
	MODULATION_SYSTEM_HE26_MCS8,
	MODULATION_SYSTEM_HE26_MCS9,
	MODULATION_SYSTEM_HE26_MCS10,
	MODULATION_SYSTEM_HE26_MCS11,
	MODULATION_SYSTEM_HE26_NUM
} ENUM_TXPOWER_TYPE_HE26_T, *P_ENUM_TXPOWER_TYPE_HE26_T;

typedef enum _ENUM_TXPOWER_TYPE_HE52_T {
	MODULATION_SYSTEM_HE52_MCS0 = 0,
	MODULATION_SYSTEM_HE52_MCS1,
	MODULATION_SYSTEM_HE52_MCS2,
	MODULATION_SYSTEM_HE52_MCS3,
	MODULATION_SYSTEM_HE52_MCS4,
	MODULATION_SYSTEM_HE52_MCS5,
	MODULATION_SYSTEM_HE52_MCS6,
	MODULATION_SYSTEM_HE52_MCS7,
	MODULATION_SYSTEM_HE52_MCS8,
	MODULATION_SYSTEM_HE52_MCS9,
	MODULATION_SYSTEM_HE52_MCS10,
	MODULATION_SYSTEM_HE52_MCS11,
	MODULATION_SYSTEM_HE52_NUM
} ENUM_TXPOWER_TYPE_HE52_T, *P_ENUM_TXPOWER_TYPE_HE52_T;

typedef enum _ENUM_TXPOWER_TYPE_HE106_T {
	MODULATION_SYSTEM_HE106_MCS0 = 0,
	MODULATION_SYSTEM_HE106_MCS1,
	MODULATION_SYSTEM_HE106_MCS2,
	MODULATION_SYSTEM_HE106_MCS3,
	MODULATION_SYSTEM_HE106_MCS4,
	MODULATION_SYSTEM_HE106_MCS5,
	MODULATION_SYSTEM_HE106_MCS6,
	MODULATION_SYSTEM_HE106_MCS7,
	MODULATION_SYSTEM_HE106_MCS8,
	MODULATION_SYSTEM_HE106_MCS9,
	MODULATION_SYSTEM_HE106_MCS10,
	MODULATION_SYSTEM_HE106_MCS11,
	MODULATION_SYSTEM_HE106_NUM
} ENUM_TXPOWER_TYPE_HE106_T, *P_ENUM_TXPOWER_TYPE_HE106_T;

typedef enum _ENUM_TXPOWER_TYPE_HE242_T {
	MODULATION_SYSTEM_HE242_MCS0 = 0,
	MODULATION_SYSTEM_HE242_MCS1,
	MODULATION_SYSTEM_HE242_MCS2,
	MODULATION_SYSTEM_HE242_MCS3,
	MODULATION_SYSTEM_HE242_MCS4,
	MODULATION_SYSTEM_HE242_MCS5,
	MODULATION_SYSTEM_HE242_MCS6,
	MODULATION_SYSTEM_HE242_MCS7,
	MODULATION_SYSTEM_HE242_MCS8,
	MODULATION_SYSTEM_HE242_MCS9,
	MODULATION_SYSTEM_HE242_MCS10,
	MODULATION_SYSTEM_HE242_MCS11,
	MODULATION_SYSTEM_HE242_NUM
} ENUM_TXPOWER_TYPE_HE242_T, *P_ENUM_TXPOWER_TYPE_HE242_T;

typedef enum _ENUM_TXPOWER_TYPE_HE484_T {
	MODULATION_SYSTEM_HE484_MCS0 = 0,
	MODULATION_SYSTEM_HE484_MCS1,
	MODULATION_SYSTEM_HE484_MCS2,
	MODULATION_SYSTEM_HE484_MCS3,
	MODULATION_SYSTEM_HE484_MCS4,
	MODULATION_SYSTEM_HE484_MCS5,
	MODULATION_SYSTEM_HE484_MCS6,
	MODULATION_SYSTEM_HE484_MCS7,
	MODULATION_SYSTEM_HE484_MCS8,
	MODULATION_SYSTEM_HE484_MCS9,
	MODULATION_SYSTEM_HE484_MCS10,
	MODULATION_SYSTEM_HE484_MCS11,
	MODULATION_SYSTEM_HE484_NUM
} ENUM_TXPOWER_TYPE_HE484_T, *P_ENUM_TXPOWER_TYPE_HE484_T;

typedef enum _ENUM_TXPOWER_TYPE_HE996_T {
	MODULATION_SYSTEM_HE996_MCS0 = 0,
	MODULATION_SYSTEM_HE996_MCS1,
	MODULATION_SYSTEM_HE996_MCS2,
	MODULATION_SYSTEM_HE996_MCS3,
	MODULATION_SYSTEM_HE996_MCS4,
	MODULATION_SYSTEM_HE996_MCS5,
	MODULATION_SYSTEM_HE996_MCS6,
	MODULATION_SYSTEM_HE996_MCS7,
	MODULATION_SYSTEM_HE996_MCS8,
	MODULATION_SYSTEM_HE996_MCS9,
	MODULATION_SYSTEM_HE996_MCS10,
	MODULATION_SYSTEM_HE996_MCS11,
	MODULATION_SYSTEM_HE996_NUM
} ENUM_TXPOWER_TYPE_HE996_T, *P_ENUM_TXPOWER_TYPE_HE996_T;

typedef enum _ENUM_TXPOWER_TYPE_HE996X2_T {
	MODULATION_SYSTEM_HE996X2_MCS0 = 0,
	MODULATION_SYSTEM_HE996X2_MCS1,
	MODULATION_SYSTEM_HE996X2_MCS2,
	MODULATION_SYSTEM_HE996X2_MCS3,
	MODULATION_SYSTEM_HE996X2_MCS4,
	MODULATION_SYSTEM_HE996X2_MCS5,
	MODULATION_SYSTEM_HE996X2_MCS6,
	MODULATION_SYSTEM_HE996X2_MCS7,
	MODULATION_SYSTEM_HE996X2_MCS8,
	MODULATION_SYSTEM_HE996X2_MCS9,
	MODULATION_SYSTEM_HE996X2_MCS10,
	MODULATION_SYSTEM_HE996X2_MCS11,
	MODULATION_SYSTEM_HE996X2_NUM
} ENUM_TXPOWER_TYPE_HE996X2_T, *P_ENUM_TXPOWER_TYPE_HE996X2_T;

typedef struct _cos_msg_trace_t {
	UINT32 dest_id;
	UINT8 msg_id;
	UINT32 pcount;
	UINT32 qread;
	UINT32 ts_enq;
	UINT32 ts_deq;
	UINT32 ts_finshq;
} cos_msg_trace_t;

typedef void (*cos_main_func_ptr)(void);
typedef void (*cos_init_func_ptr)(void);

typedef struct _COS_MSGQID {
	UINT8 unused;
} COS_MSGQID, P_COS_MSGQID;

typedef struct {
	UINT32           tc_stack_start;
	UINT32           tc_stack_end;
	UINT32           tc_stack_pointer;
	UINT32           tc_stack_size;
	UINT32           tc_schedule_count;
	UINT8            tc_status;
	UINT8            tc_priority;
	UINT8            tc_weight;
	UINT8            RSVD[28];
	UINT32    		 tc_entry_func;
	UINT32           tc_exe_start;
	UINT32           tc_exe_time;
	UINT32           tc_exe_peak;
	UINT32           tc_pcount;
} cos_task_type, *cos_internal_taskid;

typedef struct {
	UINT32           task_name_ptr;
	UINT32           task_qname_ptr;
	UINT32           task_priority;
	UINT16           task_stack_size;
	UINT8            task_ext_qsize;
	UINT32           task_id;
	UINT32           task_ext_qid;
	UINT32           task_main_func;
	UINT32           task_init_func;
} task_info_struct;

typedef struct {
	UINT32           finish_cnt;
	UINT32           exe_time;
	UINT32           exe_peak;
} cos_msg_type, *cos_internal_msgid;

typedef struct {
    UINT32			dest_id;
    UINT8           idx;
    UINT8           base;
    UINT8           num;
    cos_msg_type	*ptr;
} cos_msg_info_range;

typedef struct {
	UINT32    dest_id;
	UINT32    msg_id;
	UINT32    msg_sn;
	UINT32    ts_gpt2;
	UINT32    LP;
	CHAR        name[12];
} cos_program_trace_t, *p_cos_program_trace_t;

#ifdef CONNAC_EFUSE_FORMAT_SUPPORT
typedef struct _EFUSE_INFO_T {
	/* MT7916 as example */
	UINT8 bytes_0x0_0x6F[0x70]; /* 0x00 ~ 0x6F : other purpose */
	/* 0x70 */
	EFUSE_INFO_MODULE_TX_POWER_T rTxPower; /* 59 bytes */
	UINT8 bytes_0xAB_0xAF[0x5]; /* 0x100 ~ 0x1AF : padding */
	/* 0xB0 */
	EFUSE_INFO_MODULE_2G4_COMMON_T r2G4Cmm; /* 48 bytes */
	/* 0xE0 */
	EFUSE_INFO_MODULE_2G4_WIFI_PATH_T ar2G4WFPath[MAX_ANTENNA_NUM]; /* 16*2=32 bytes */
	UINT8 bytes_0x100_0x1AF[0xB0]; /* 0x100 ~ 0x1AF : other purpose */
	/* 0x1B0 */
	EFUSE_INFO_MODULE_SYSTEM_T rSys; /* 16 bytes */
	/* 0x1C0 */
	EFUSE_INFO_MODULE_DELAY_COMP_T rDelayComp; /* 34 bytes */
	UINT8 bytes_0x1E2_0x1EF[0xE]; /* 0x1E2 ~ 0x1EF: padding */
	/* 0x1F0 */
	EFUSE_INFO_MODULE_5G_COMMON_T r5GCmm; /* 80 bytes */
	/* 0x240 */
	EFUSE_INFO_MODULE_5G_WIFI_PATH_T ar5GWFPath[MAX_ANTENNA_NUM]; /* 112*2=224 bytes */
	/* 0x320 */
	EFUSE_INFO_MODULE_IBF_CAL_T rIBfCal; /* 12*9=108 bytes */
	UINT8 bytes_0x38C_0x3FF[0x74]; /* 0x38C ~ 0x3FF: other purpose */
	UINT8 bytes_ADie_0x000_0x17F[0x180]; /* A Die 0x000 ~ 0x17F */
} EFUSE_INFO_T, *P_EFUSE_INFO_T;
#endif /*#ifdef CONNAC_EFUSE_FORMAT_SUPPORT*/

enum ENUM_TXMODE {
	TXMODE_LEGACY_CCK = 0x0,
	TXMODE_LEGACY_OFDMA = 0x1,
	TXMODE_HT_MIXED = 0x2,
	TXMODE_HT_GREEN_FIELD = 0x3,
	TXMODE_VHT = 0x4,
	TXMODE_HE_SU = 0x8,
	TXMODE_HE_EXT_SU = 0x9,
	TXMODE_HE_TRIG = 0xA,
	TXMODE_HE_MU = 0xB
};

#endif /* __COMMON_CHIP_H__ */

