#ifndef __TXCMDSU_DVT_H__
#define __TXCMDSU_DVT_H__
enum _ENUM_SYSDVT_TXCMDSU_TYPE_T {
	ENUM_SYSDVT_TXCMDSU_RATE = 100,
	ENUM_SYSDVT_TXCMDSU_CFG = 101,
	ENUM_SYSDVT_TXCMD_STAT = 200,
	ENUM_SYSDVT_TXCMD_TXCTRL = 201,
} ENUM_SYSDVT_TXCMDSU_TYPE_T;

typedef enum {
	TXCMD_SU_RATE_TXD,
	TXCMD_SU_RATE_TXCMD,
	TXCMD_SU_RATE_RA,
	TXCMD_SU_RATE_MAX
} ENUM_TXCMD_SU_RATE_TYPE;

typedef enum {
	TXCMD_SU_CFG_TXDATA,
	TXCMD_SU_CFG_PROTECT,
	TXCMD_SU_CFG_TRIG,
	TXCMD_SU_CFG_GLOBAL,
	TXCMD_SU_CFG_MAX
} ENUM_TXCMD_SU_CFG_TYPE;

typedef enum {
	TXCMD_SU_VAL_PROTECT_EN,
	TXCMD_SU_VAL_PROTECT_TYPE,
	TXCMD_SU_VAL_RATE_TYPE,
	TXCMD_SU_VAL_DURATION,
	TXCMD_SU_VAL_LSIG,
	TXCMD_SU_VAL_TRIG_EN,
	TXCMD_SU_VAL_TRIG_TYPE,
	TXCMD_SU_VAL_TRIG_INTERVAL,
	TXCMD_SU_VAL_TRIG_MUSPCFAC,
	TXCMD_SU_VAL_TRIG_CS,
	TXCMD_SU_VAL_SPL,
	TXCMD_SU_VAL_BW,
	TXCMD_SU_VAL_MCS,
	TXCMD_SU_VAL_GI,
	TXCMD_SU_VAL_LTF,
	TXCMD_SU_VAL_COD,
	TXCMD_SU_VAL_TRIG_TX_INTERNAL,
	TXCMD_SU_VAL_MAX
} ENUM_TXCMD_SU_VAL_TYPE;

typedef struct _DVT_TXCMDSU_CMD_RATE {
	ENUM_TXCMD_SU_CFG_TYPE eType;
	UINT8 ucTxMode;
	UINT8 ucRate;
	UINT8 ucGi;
	UINT8 ucBw;
	UINT8 ucNss;
	UINT8 ucEcc;
	UINT8 ucHeLtf;
	UINT8 ucStbc;
} DVT_TXCMDSU_CMD_RATE, *P_DVT_TXCMDSU_CMD_RATE;

typedef struct _DVT_TXCMDSU_CMD_CFG {
	ENUM_TXCMD_SU_CFG_TYPE eType;
	ENUM_TXCMD_SU_VAL_TYPE eValType;
	UINT32 u4Val;
} DVT_TXCMDSU_CMD_CFG, *P_DVT_TXCMDSU_CMD_CFG;

typedef struct _DVT_TXCMDSU_CMD_GET_CTRL {
	ENUM_TXCMD_SU_CFG_TYPE eType;
} DVT_TXCMDSU_CMD_GET_CTRL, *P_DVT_TXCMDSU_CMD_GET_CTRL;

typedef struct _RATE_INFO_RSP_T {
	UINT8      u1Mcs; /*RARU:RU MCS*/
	UINT8      u1Nss; /*RARU:RU NSS*/
	UINT8      u1GI; /*RARU:RU GI*/
	UINT8      u1Bw;
	UINT8      u1Ecc; /* BCC/LDPC */
	UINT8      u1HeLtf;
	UINT8      u1Stbc;
	UINT8      u1Reserved;/*xx*/
	UINT8      u1BfType;
	UINT16     u2WeightFactor; /*RARU: Avg. PER estimation*/
	UINT32     eDataTxMode;
} RATE_INFO_RSP_T, *P_RATE_INFO_RSP_T, *P_DL_RATE_INFO_RSP_T;

typedef struct _TXM_TXCMD_SU_TXDATA_REC {
	BOOLEAN fgProtect;
	UINT8 ucAcQ;
	UINT16 u2Wcid;
	UINT32 u4Duration;
	UINT8  ucMTB;
	UINT32 eProtectType;
	ENUM_TXCMD_SU_RATE_TYPE eRateType;
	RATE_INFO_RSP_T rDataRate;
} TXM_TXCMD_SU_TXDATA_REC, *P_TXM_TXCMD_SU_TXDATA_REC;


typedef struct _TXM_TXCMD_SU_PROTECT_REC {
	ENUM_TXCMD_SU_RATE_TYPE eRateType;
	RATE_INFO_RSP_T rRate;
} TXM_TXCMD_SU_PROTECT_REC, *P_TXM_TXCMD_SU_PROTECT_REC;


typedef struct _TXM_TXCMD_SU_TRIG_REC {
    /*control section*/
    BOOLEAN fgTrigEn;
    BOOLEAN fgProtect;
    BOOLEAN fgCs;
    BOOLEAN fgBc;
    UINT8 u1MuSpacingFactor;
    UINT32 u4RxTotQLen;
    UINT32 u4Length;
    UINT32 u4TimerCnt;
    UINT16 u2Duration;
    UINT8 u1TxInternal;
    UINT8 u1Rsv;
    UINT32 eProtectType;
    UINT32 eRateType;
    UINT32 eTrigType;
    RATE_INFO_RSP_T rRate;
} TXM_TXCMD_SU_TRIG_REC, *P_TXM_TXCMD_SU_TRIG_REC;


#define DVT_TXCMD_WMM_SET 4
#define DVT_TXCMD_SWQ_TYPE 3

typedef enum _ENUM_WH_SPL_GEN_MODE_T {
	WH_SPL_TXCMD_DONE_TX_MODE = 0x0,
	WH_SPL_TXCMD_DONE_RX_MODE = 0x1,
	WH_SPL_TXCMD_DONE_TWT_DL_MODE = 0x2,
	WH_SPL_TXCMD_DONE_TWT_UL_MODE = 0x3,
	WH_SPL_IO_TX_MODE = 0x4,
	WH_SPL_IO_RX_MODE = 0x5,
	WH_SPL_TWT_DL_MODE = 0x6,
	WH_SPL_TWT_UL_MODE = 0x7,
	WH_SPL_CHNL_NONEMPTY_TX_MODE = 0x8,
	WH_SPL_CHNL_NONEMPTY_RX_MODE = 0x9,
	WH_SPL_BWREFILL_TX_MODE = 0xa,
	WH_SPL_BWREFILL_RX_MODE = 0xb,
	WH_SPL_ARB_B0_MODE = 0xc,
	WH_SPL_ARB_B1_MODE = 0xd,
	WH_SPL_PRELPAD_MODE = 0xe,
	WH_SPL_PM_CHG_DET_MODE = 0xf,
	WH_SPL_GEN_MODE_INVAILD,
	WH_SPL_GEN_MODE_NUM
} ENUM_WH_SPL_GEN_MODE_T;

typedef enum _ENUM_CMDRPT_TYPE_T {
	CMDRPT_TYPE_SPL,
	CMDRPT_TYPE_TXDATA,
	CMDRPT_TYPE_TXTRIG,
	CMDRPT_TYPE_RXRPT,
	CMDRPT_TYPE_NUM
} ENUM_CMDRPT_TYPE_T, *P_ENUM_CMDRPT_TYPE_T;

typedef enum _ENUM_WH_TXCMD_TYPE_T {
	WH_TXCMD_MU_TRIG_DATA        = 0x0,
	WH_TXCMD_MU_TX_DATA          = 0x1,
	WH_TXCMD_HE_SOUNDING         = 0x2,
	WH_TXCMD_SU_TX_DATA          = 0x3,
	WH_TXCMD_SU_TRIG_DATA        = 0x4,
	WH_TXCMD_NONE_HE_TX_DATA     = 0x5,
	WH_TXCMD_SW_PKT              = 0x6,
	WH_TXCMD_TYPE_NUM
} ENUM_WH_TXCMD_TYPE_T, *P_ENUM_WH_TXCMD_TYPE_T;

typedef enum _ENUM_WH_TXCMD_QUE_T {
	WH_TXC_AC00 = 0,
	WH_TXC_AC01,
	WH_TXC_AC02,
	WH_TXC_AC03,
	WH_TXC_AC10,
	WH_TXC_AC11,
	WH_TXC_AC12,
	WH_TXC_AC13,
	WH_TXC_AC20,
	WH_TXC_AC21,
	WH_TXC_AC22,
	WH_TXC_AC23,
	WH_TXC_AC30,
	WH_TXC_AC31,
	WH_TXC_AC32,
	WH_TXC_AC33,
	WH_TXC_ALTX0,
	WH_TXC_TF0,
	WH_TXC_TWT_TSF_TF0,
	WH_TXC_TWT_DL0,
	WH_TXC_TWT_UL0,
	WH_TXC_QUE_NUM
} ENUM_WH_TXCMD_QUE_T;

enum _ENUM_CMDRPT_ORDER_T {
	CMDRPT_ORDER_TXCMD_MODUL = 0,
	CMDRPT_ORDER_TWT,
	CMDRPT_ORDER_ACTRL,
	CMDRPT_ORDER_MURU,
	CMDRPT_ORDER_SU,
	CMDRPT_ORDER_RXV,
	CMDRPT_ORDER_RA,
	CMDRPT_ORDER_SR,
	CMDRPT_ORDER_VOW,
	CMDRPT_ORDER_TPC,
	CMDRPT_ORDER_TXCMD_TX_CTRL,
	CMDRPT_ORDER_MAX,
};


struct HE_ACTRL_OMI {
	UINT16  rx_nss: 3,
		bw: 2,
		ul_mu_disable: 1,
		tx_nss: 3,
		er_su_diable: 1,
		dl_mumimo_res_rec: 1,
		ul_mudata_disable: 1,
		rsv: 4;
};

struct dvt_txcmdsu_statistic {
	BOOLEAN spl_en;
	BOOLEAN txcmd_mode[DVT_TXCMD_WMM_SET];
	UINT32 rx_cnt[CMDRPT_TYPE_NUM];
	UINT32 tx_cnt[WH_TXCMD_TYPE_NUM];
	UINT32 tx_err_cnt[WH_TXCMD_TYPE_NUM];
	UINT32 spl_cnt[WH_SPL_GEN_MODE_NUM];
	UINT32 swq_len[DVT_TXCMD_SWQ_TYPE];
	UINT32 acq_len[WH_TXC_QUE_NUM];
	UINT16 omi;
};

#define PFM_MAX_REC 64
#define PFM_STACK_SIZE 12
#define PFM_CPU_MS 640

typedef struct _PFM_REC {
	UINT32 u4Start;
	UINT32 u4Tick;
	UINT32 u4Cnt;
	UINT32 u4Overhead;
	UINT32 prFun;
	BOOLEAN fUse;
} PFM_REC;

typedef struct _PFM_CTRL {
	PFM_REC rPfmRec[PFM_MAX_REC];
} PFM_CTRL;





#endif
