#!/bin/sh
set -eu
# NOTE: For this script to work properly, the feature name should be the same as the field name in featureSwitch DAL table
help() {

    cat <<EOF
-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
-=- Unified Feature Switch Utility Tool -=-
-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

Usage:
 feature_switch.sh <Supported action> <Supported feature>

Eg. feature_switch.sh enable rp
    feature_switch.sh show rp
    feature_switch.sh show

Supported Features:
  rp                    -- Router Protection
  armorra               -- Armor Router Analytics

Supported actions:
  enable                -- enable a feature
  disable               -- disable a feature
  show                  -- display states of feature(s)

EOF
}

list_contains() {
    list="$1"
    item="$2"
    for list_item in $list; do
        if [ "$item" = "$list_item" ]; then
            return 0
        fi
    done
    return 1
}

validate_feature() {
    feature="$2"
    available_features="rp armorra"
    if [ "$feature" != "" ] && ! list_contains "$available_features" "$feature"; then
        logger -s -t feature_switch.sh "Error: Invalid feature: '$2'."
        help
        exit 1
    fi
}

validate_action() {
    action="$1"
    available_actions="enable disable show"
    if [ "$action" != "" ] && ! list_contains "$available_actions" "$action"; then
        logger -s -t feature_switch.sh "Error: Invalid action: '$1'."
        help
        exit 1
    fi
}

if [ $# -lt 1 ]; then
    logger -s -t feature_switch.sh "ERROR: No. of arguments are less than 2"
    help
    exit 1
fi

validate_action "$@"
if [ "$1" = "show" ]; then
    if [ -z "${2:-}" ]; then
        d2 featureSwitch[0]
        exit 0
    else
        validate_feature "$@"
        d2 -s featureSwitch[0]."$2"
        exit 0
    fi
fi
validate_feature "$@"

echo "Integrated feature $2 is being $1d"
d2 -c featureSwitch[0]."$2" "$1"
