#ifndef CYGONCE_LIBM_SCABNF_H
#define CYGONCE_LIBM_SCABNF_H
//===========================================================================
//
//      tanhf.h
//
//      Test vectors for testing of tanhf() math library function
//
//===========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####
// -------------------------------------------
// This file is part of eCos, the Embedded Configurable Operating System.
// Copyright (C) 2012 Free Software Foundation, Inc.
//
// eCos is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 or (at your option) any later
// version.
//
// eCos is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
// for more details.
//
// You should have received a copy of the GNU General Public License
// along with eCos; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//
// As a special exception, if other files instantiate templates or use
// macros or inline functions from this file, or you compile this file
// and link it with other works to produce a work based on this file,
// this file does not by itself cause the resulting work to be covered by
// the GNU General Public License. However the source code for this file
// must still be made available in accordance with section (3) of the GNU
// General Public License v2.
//
// This exception does not invalidate any other reasons why a work based
// on this file might be covered by the GNU General Public License.
// -------------------------------------------
// ####ECOSGPLCOPYRIGHTEND####
//===========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):
// Contributors:  visar, ilijak
// Date:        1998-02-13
// Purpose:
// Description:
// Usage:       #include "vectors/tanhf.h"
//
//####DESCRIPTIONEND####
//
//===========================================================================


// CONFIGURATION

#include <pkgconf/libm.h>   // Configuration header


// INCLUDES

#include <cyg/infra/cyg_type.h>    // Common type definitions and support
#include "vectors/vector_support_float.h"// extra support for math tests

#define TANHF_TOLERANCE 1.0E-04

static const Cyg_libm_test_float_vec_t tanhf_vec[] = {

// AUTOMATICALLY GENERATED VECTORS START

{0, 3214514586u, 0u, 3210046052u, 0, TANHF_TOLERANCE, 0},
{1, 3214430700u, 0u, 3209994449u, 0, TANHF_TOLERANCE, 0},
{2, 3214346813u, 0u, 3209941982u, 0, TANHF_TOLERANCE, 0},
{3, 3214262927u, 0u, 3209888640u, 0, TANHF_TOLERANCE, 0},
{4, 3214179041u, 0u, 3209834411u, 0, TANHF_TOLERANCE, 0},
{5, 3214095155u, 0u, 3209779285u, 0, TANHF_TOLERANCE, 0},
{6, 3214011269u, 0u, 3209723249u, 0, TANHF_TOLERANCE, 0},
{7, 3213927383u, 0u, 3209666293u, 0, TANHF_TOLERANCE, 0},
{8, 3213843497u, 0u, 3209608406u, 0, TANHF_TOLERANCE, 0},
{9, 3213759611u, 0u, 3209549577u, 0, TANHF_TOLERANCE, 0},
{10, 3213675725u, 0u, 3209489793u, 0, TANHF_TOLERANCE, 0},
{11, 3213591839u, 0u, 3209429045u, 0, TANHF_TOLERANCE, 0},
{12, 3213507953u, 0u, 3209367321u, 0, TANHF_TOLERANCE, 0},
{13, 3213424067u, 0u, 3209304610u, 0, TANHF_TOLERANCE, 0},
{14, 3213340180u, 0u, 3209240900u, 0, TANHF_TOLERANCE, 0},
{15, 3213256294u, 0u, 3209176182u, 0, TANHF_TOLERANCE, 0},
{16, 3213172408u, 0u, 3209110444u, 0, TANHF_TOLERANCE, 0},
{17, 3213088522u, 0u, 3209043675u, 0, TANHF_TOLERANCE, 0},
{18, 3213004636u, 0u, 3208975865u, 0, TANHF_TOLERANCE, 0},
{19, 3212920750u, 0u, 3208907003u, 0, TANHF_TOLERANCE, 0},
{20, 3212836864u, 0u, 3208837078u, 0, TANHF_TOLERANCE, 0},
{21, 3212669092u, 0u, 3208766079u, 0, TANHF_TOLERANCE, 0},
{22, 3212501320u, 0u, 3208693997u, 0, TANHF_TOLERANCE, 0},
{23, 3212333548u, 0u, 3208620822u, 0, TANHF_TOLERANCE, 0},
{24, 3212165775u, 0u, 3208546542u, 0, TANHF_TOLERANCE, 0},
{25, 3211998003u, 0u, 3208471148u, 0, TANHF_TOLERANCE, 0},
{26, 3211830231u, 0u, 3208394631u, 0, TANHF_TOLERANCE, 0},
{27, 3211662459u, 0u, 3208316980u, 0, TANHF_TOLERANCE, 0},
{28, 3211494687u, 0u, 3208238186u, 0, TANHF_TOLERANCE, 0},
{29, 3211326915u, 0u, 3208158240u, 0, TANHF_TOLERANCE, 0},
{30, 3211159142u, 0u, 3208077132u, 0, TANHF_TOLERANCE, 0},
{31, 3210991370u, 0u, 3207994854u, 0, TANHF_TOLERANCE, 0},
{32, 3210823598u, 0u, 3207911397u, 0, TANHF_TOLERANCE, 0},
{33, 3210655826u, 0u, 3207826753u, 0, TANHF_TOLERANCE, 0},
{34, 3210488054u, 0u, 3207740913u, 0, TANHF_TOLERANCE, 0},
{35, 3210320282u, 0u, 3207653870u, 0, TANHF_TOLERANCE, 0},
{36, 3210152509u, 0u, 3207565615u, 0, TANHF_TOLERANCE, 0},
{37, 3209984737u, 0u, 3207476141u, 0, TANHF_TOLERANCE, 0},
{38, 3209816965u, 0u, 3207385441u, 0, TANHF_TOLERANCE, 0},
{39, 3209649193u, 0u, 3207293508u, 0, TANHF_TOLERANCE, 0},
{40, 3209481421u, 0u, 3207200336u, 0, TANHF_TOLERANCE, 0},
{41, 3209313649u, 0u, 3207105919u, 0, TANHF_TOLERANCE, 0},
{42, 3209145876u, 0u, 3207010249u, 0, TANHF_TOLERANCE, 0},
{43, 3208978104u, 0u, 3206913323u, 0, TANHF_TOLERANCE, 0},
{44, 3208810332u, 0u, 3206815135u, 0, TANHF_TOLERANCE, 0},
{45, 3208642560u, 0u, 3206715679u, 0, TANHF_TOLERANCE, 0},
{46, 3208474788u, 0u, 3206614952u, 0, TANHF_TOLERANCE, 0},
{47, 3208307016u, 0u, 3206512950u, 0, TANHF_TOLERANCE, 0},
{48, 3208139244u, 0u, 3206409669u, 0, TANHF_TOLERANCE, 0},
{49, 3207971471u, 0u, 3206305105u, 0, TANHF_TOLERANCE, 0},
{50, 3207803699u, 0u, 3206199257u, 0, TANHF_TOLERANCE, 0},
{51, 3207635927u, 0u, 3206092121u, 0, TANHF_TOLERANCE, 0},
{52, 3207468155u, 0u, 3205983697u, 0, TANHF_TOLERANCE, 0},
{53, 3207300383u, 0u, 3205873982u, 0, TANHF_TOLERANCE, 0},
{54, 3207132611u, 0u, 3205762976u, 0, TANHF_TOLERANCE, 0},
{55, 3206964838u, 0u, 3205650678u, 0, TANHF_TOLERANCE, 0},
{56, 3206797066u, 0u, 3205537090u, 0, TANHF_TOLERANCE, 0},
{57, 3206629294u, 0u, 3205422211u, 0, TANHF_TOLERANCE, 0},
{58, 3206461522u, 0u, 3205306042u, 0, TANHF_TOLERANCE, 0},
{59, 3206293750u, 0u, 3205188586u, 0, TANHF_TOLERANCE, 0},
{60, 3206125978u, 0u, 3205069845u, 0, TANHF_TOLERANCE, 0},
{61, 3205958205u, 0u, 3204949821u, 0, TANHF_TOLERANCE, 0},
{62, 3205790433u, 0u, 3204828519u, 0, TANHF_TOLERANCE, 0},
{63, 3205622661u, 0u, 3204705942u, 0, TANHF_TOLERANCE, 0},
{64, 3205454889u, 0u, 3204582095u, 0, TANHF_TOLERANCE, 0},
{65, 3205287117u, 0u, 3204456984u, 0, TANHF_TOLERANCE, 0},
{66, 3205119345u, 0u, 3204212972u, 0, TANHF_TOLERANCE, 0},
{67, 3204951572u, 0u, 3203957726u, 0, TANHF_TOLERANCE, 0},
{68, 3204783800u, 0u, 3203699992u, 0, TANHF_TOLERANCE, 0},
{69, 3204616028u, 0u, 3203439784u, 0, TANHF_TOLERANCE, 0},
{70, 3204448256u, 0u, 3203177119u, 0, TANHF_TOLERANCE, 0},
{71, 3204112712u, 0u, 3202912015u, 0, TANHF_TOLERANCE, 0},
{72, 3203777167u, 0u, 3202644491u, 0, TANHF_TOLERANCE, 0},
{73, 3203441623u, 0u, 3202374569u, 0, TANHF_TOLERANCE, 0},
{74, 3203106079u, 0u, 3202102272u, 0, TANHF_TOLERANCE, 0},
{75, 3202770534u, 0u, 3201827621u, 0, TANHF_TOLERANCE, 0},
{76, 3202434990u, 0u, 3201550644u, 0, TANHF_TOLERANCE, 0},
{77, 3202099446u, 0u, 3201271366u, 0, TANHF_TOLERANCE, 0},
{78, 3201763901u, 0u, 3200989815u, 0, TANHF_TOLERANCE, 0},
{79, 3201428357u, 0u, 3200706020u, 0, TANHF_TOLERANCE, 0},
{80, 3201092813u, 0u, 3200420012u, 0, TANHF_TOLERANCE, 0},
{81, 3200757268u, 0u, 3200131821u, 0, TANHF_TOLERANCE, 0},
{82, 3200421724u, 0u, 3199841483u, 0, TANHF_TOLERANCE, 0},
{83, 3200086180u, 0u, 3199549031u, 0, TANHF_TOLERANCE, 0},
{84, 3199750636u, 0u, 3199254501u, 0, TANHF_TOLERANCE, 0},
{85, 3199415091u, 0u, 3198957930u, 0, TANHF_TOLERANCE, 0},
{86, 3199079547u, 0u, 3198659358u, 0, TANHF_TOLERANCE, 0},
{87, 3198744003u, 0u, 3198358824u, 0, TANHF_TOLERANCE, 0},
{88, 3198408458u, 0u, 3198056369u, 0, TANHF_TOLERANCE, 0},
{89, 3198072914u, 0u, 3197752036u, 0, TANHF_TOLERANCE, 0},
{90, 3197737370u, 0u, 3197445870u, 0, TANHF_TOLERANCE, 0},
{91, 3197401825u, 0u, 3197137913u, 0, TANHF_TOLERANCE, 0},
{92, 3197066281u, 0u, 3196828215u, 0, TANHF_TOLERANCE, 0},
{93, 3196730737u, 0u, 3196516822u, 0, TANHF_TOLERANCE, 0},
{94, 3196395192u, 0u, 3196203782u, 0, TANHF_TOLERANCE, 0},
{95, 3196059648u, 0u, 3195718645u, 0, TANHF_TOLERANCE, 0},
{96, 3195388559u, 0u, 3195086284u, 0, TANHF_TOLERANCE, 0},
{97, 3194717471u, 0u, 3194450938u, 0, TANHF_TOLERANCE, 0},
{98, 3194046382u, 0u, 3193812713u, 0, TANHF_TOLERANCE, 0},
{99, 3193375293u, 0u, 3193171718u, 0, TANHF_TOLERANCE, 0},
{100, 3192704205u, 0u, 3192528066u, 0, TANHF_TOLERANCE, 0},
{101, 3192033116u, 0u, 3191881866u, 0, TANHF_TOLERANCE, 0},
{102, 3191362028u, 0u, 3191233237u, 0, TANHF_TOLERANCE, 0},
{103, 3190690939u, 0u, 3190582293u, 0, TANHF_TOLERANCE, 0},
{104, 3190019850u, 0u, 3189929153u, 0, TANHF_TOLERANCE, 0},
{105, 3189348762u, 0u, 3189273938u, 0, TANHF_TOLERANCE, 0},
{106, 3188677673u, 0u, 3188616768u, 0, TANHF_TOLERANCE, 0},
{107, 3188006584u, 0u, 3187957768u, 0, TANHF_TOLERANCE, 0},
{108, 3186999951u, 0u, 3186923084u, 0, TANHF_TOLERANCE, 0},
{109, 3185657774u, 0u, 3185598513u, 0, TANHF_TOLERANCE, 0},
{110, 3184315597u, 0u, 3184271036u, 0, TANHF_TOLERANCE, 0},
{111, 3182973420u, 0u, 3182940910u, 0, TANHF_TOLERANCE, 0},
{112, 3181631242u, 0u, 3181608394u, 0, TANHF_TOLERANCE, 0},
{113, 3180289065u, 0u, 3180273749u, 0, TANHF_TOLERANCE, 0},
{114, 3178611343u, 0u, 3178592043u, 0, TANHF_TOLERANCE, 0},
{115, 3175926989u, 0u, 3175915815u, 0, TANHF_TOLERANCE, 0},
{116, 3173242634u, 0u, 3173236911u, 0, TANHF_TOLERANCE, 0},
{117, 3170222735u, 0u, 3170217905u, 0, TANHF_TOLERANCE, 0},
{118, 3164854026u, 0u, 3164852595u, 0, TANHF_TOLERANCE, 0},
{119, 3156465418u, 0u, 3156465060u, 0, TANHF_TOLERANCE, 0},
{120, 1008981770u, 0u, 1008981412u, 0, TANHF_TOLERANCE, 0},
{121, 1017370378u, 0u, 1017368947u, 0, TANHF_TOLERANCE, 0},
{122, 1022739087u, 0u, 1022734257u, 0, TANHF_TOLERANCE, 0},
{123, 1025758986u, 0u, 1025753263u, 0, TANHF_TOLERANCE, 0},
{124, 1028443341u, 0u, 1028432167u, 0, TANHF_TOLERANCE, 0},
{125, 1031127695u, 0u, 1031108395u, 0, TANHF_TOLERANCE, 0},
{126, 1032805417u, 0u, 1032790101u, 0, TANHF_TOLERANCE, 0},
{127, 1034147594u, 0u, 1034124746u, 0, TANHF_TOLERANCE, 0},
{128, 1035489772u, 0u, 1035457262u, 0, TANHF_TOLERANCE, 0},
{129, 1036831949u, 0u, 1036787388u, 0, TANHF_TOLERANCE, 0},
{130, 1038174126u, 0u, 1038114865u, 0, TANHF_TOLERANCE, 0},
{131, 1039516303u, 0u, 1039439436u, 0, TANHF_TOLERANCE, 0},
{132, 1040522936u, 0u, 1040474120u, 0, TANHF_TOLERANCE, 0},
{133, 1041194025u, 0u, 1041133120u, 0, TANHF_TOLERANCE, 0},
{134, 1041865114u, 0u, 1041790290u, 0, TANHF_TOLERANCE, 0},
{135, 1042536202u, 0u, 1042445505u, 0, TANHF_TOLERANCE, 0},
{136, 1043207291u, 0u, 1043098645u, 0, TANHF_TOLERANCE, 0},
{137, 1043878380u, 0u, 1043749589u, 0, TANHF_TOLERANCE, 0},
{138, 1044549468u, 0u, 1044398218u, 0, TANHF_TOLERANCE, 0},
{139, 1045220557u, 0u, 1045044418u, 0, TANHF_TOLERANCE, 0},
{140, 1045891645u, 0u, 1045688070u, 0, TANHF_TOLERANCE, 0},
{141, 1046562734u, 0u, 1046329065u, 0, TANHF_TOLERANCE, 0},
{142, 1047233823u, 0u, 1046967290u, 0, TANHF_TOLERANCE, 0},
{143, 1047904911u, 0u, 1047602636u, 0, TANHF_TOLERANCE, 0},
{144, 1048576000u, 0u, 1048234997u, 0, TANHF_TOLERANCE, 0},
{145, 1048911544u, 0u, 1048720134u, 0, TANHF_TOLERANCE, 0},
{146, 1049247089u, 0u, 1049033174u, 0, TANHF_TOLERANCE, 0},
{147, 1049582633u, 0u, 1049344567u, 0, TANHF_TOLERANCE, 0},
{148, 1049918177u, 0u, 1049654265u, 0, TANHF_TOLERANCE, 0},
{149, 1050253722u, 0u, 1049962222u, 0, TANHF_TOLERANCE, 0},
{150, 1050589266u, 0u, 1050268388u, 0, TANHF_TOLERANCE, 0},
{151, 1050924810u, 0u, 1050572721u, 0, TANHF_TOLERANCE, 0},
{152, 1051260355u, 0u, 1050875176u, 0, TANHF_TOLERANCE, 0},
{153, 1051595899u, 0u, 1051175710u, 0, TANHF_TOLERANCE, 0},
{154, 1051931443u, 0u, 1051474282u, 0, TANHF_TOLERANCE, 0},
{155, 1052266988u, 0u, 1051770853u, 0, TANHF_TOLERANCE, 0},
{156, 1052602532u, 0u, 1052065383u, 0, TANHF_TOLERANCE, 0},
{157, 1052938076u, 0u, 1052357835u, 0, TANHF_TOLERANCE, 0},
{158, 1053273620u, 0u, 1052648173u, 0, TANHF_TOLERANCE, 0},
{159, 1053609165u, 0u, 1052936364u, 0, TANHF_TOLERANCE, 0},
{160, 1053944709u, 0u, 1053222372u, 0, TANHF_TOLERANCE, 0},
{161, 1054280253u, 0u, 1053506167u, 0, TANHF_TOLERANCE, 0},
{162, 1054615798u, 0u, 1053787718u, 0, TANHF_TOLERANCE, 0},
{163, 1054951342u, 0u, 1054066996u, 0, TANHF_TOLERANCE, 0},
{164, 1055286886u, 0u, 1054343973u, 0, TANHF_TOLERANCE, 0},
{165, 1055622431u, 0u, 1054618624u, 0, TANHF_TOLERANCE, 0},
{166, 1055957975u, 0u, 1054890921u, 0, TANHF_TOLERANCE, 0},
{167, 1056293519u, 0u, 1055160843u, 0, TANHF_TOLERANCE, 0},
{168, 1056629064u, 0u, 1055428367u, 0, TANHF_TOLERANCE, 0},
{169, 1056964608u, 0u, 1055693471u, 0, TANHF_TOLERANCE, 0},
{170, 1057132380u, 0u, 1055956136u, 0, TANHF_TOLERANCE, 0},
{171, 1057300152u, 0u, 1056216344u, 0, TANHF_TOLERANCE, 0},
{172, 1057467924u, 0u, 1056474078u, 0, TANHF_TOLERANCE, 0},
{173, 1057635697u, 0u, 1056729324u, 0, TANHF_TOLERANCE, 0},
{174, 1057803469u, 0u, 1056973336u, 0, TANHF_TOLERANCE, 0},
{175, 1057971241u, 0u, 1057098447u, 0, TANHF_TOLERANCE, 0},
{176, 1058139013u, 0u, 1057222294u, 0, TANHF_TOLERANCE, 0},
{177, 1058306785u, 0u, 1057344871u, 0, TANHF_TOLERANCE, 0},
{178, 1058474557u, 0u, 1057466173u, 0, TANHF_TOLERANCE, 0},
{179, 1058642330u, 0u, 1057586197u, 0, TANHF_TOLERANCE, 0},
{180, 1058810102u, 0u, 1057704938u, 0, TANHF_TOLERANCE, 0},
{181, 1058977874u, 0u, 1057822394u, 0, TANHF_TOLERANCE, 0},
{182, 1059145646u, 0u, 1057938563u, 0, TANHF_TOLERANCE, 0},
{183, 1059313418u, 0u, 1058053442u, 0, TANHF_TOLERANCE, 0},
{184, 1059481190u, 0u, 1058167030u, 0, TANHF_TOLERANCE, 0},
{185, 1059648963u, 0u, 1058279328u, 0, TANHF_TOLERANCE, 0},
{186, 1059816735u, 0u, 1058390334u, 0, TANHF_TOLERANCE, 0},
{187, 1059984507u, 0u, 1058500049u, 0, TANHF_TOLERANCE, 0},
{188, 1060152279u, 0u, 1058608473u, 0, TANHF_TOLERANCE, 0},
{189, 1060320051u, 0u, 1058715609u, 0, TANHF_TOLERANCE, 0},
{190, 1060487823u, 0u, 1058821457u, 0, TANHF_TOLERANCE, 0},
{191, 1060655596u, 0u, 1058926021u, 0, TANHF_TOLERANCE, 0},
{192, 1060823368u, 0u, 1059029302u, 0, TANHF_TOLERANCE, 0},
{193, 1060991140u, 0u, 1059131304u, 0, TANHF_TOLERANCE, 0},
{194, 1061158912u, 0u, 1059232031u, 0, TANHF_TOLERANCE, 0},
{195, 1061326684u, 0u, 1059331487u, 0, TANHF_TOLERANCE, 0},
{196, 1061494456u, 0u, 1059429675u, 0, TANHF_TOLERANCE, 0},
{197, 1061662228u, 0u, 1059526601u, 0, TANHF_TOLERANCE, 0},
{198, 1061830001u, 0u, 1059622271u, 0, TANHF_TOLERANCE, 0},
{199, 1061997773u, 0u, 1059716688u, 0, TANHF_TOLERANCE, 0},
{200, 1062165545u, 0u, 1059809860u, 0, TANHF_TOLERANCE, 0},
{201, 1062333317u, 0u, 1059901793u, 0, TANHF_TOLERANCE, 0},
{202, 1062501089u, 0u, 1059992493u, 0, TANHF_TOLERANCE, 0},
{203, 1062668861u, 0u, 1060081967u, 0, TANHF_TOLERANCE, 0},
{204, 1062836634u, 0u, 1060170222u, 0, TANHF_TOLERANCE, 0},
{205, 1063004406u, 0u, 1060257265u, 0, TANHF_TOLERANCE, 0},
{206, 1063172178u, 0u, 1060343105u, 0, TANHF_TOLERANCE, 0},
{207, 1063339950u, 0u, 1060427749u, 0, TANHF_TOLERANCE, 0},
{208, 1063507722u, 0u, 1060511206u, 0, TANHF_TOLERANCE, 0},
{209, 1063675494u, 0u, 1060593484u, 0, TANHF_TOLERANCE, 0},
{210, 1063843267u, 0u, 1060674592u, 0, TANHF_TOLERANCE, 0},
{211, 1064011039u, 0u, 1060754538u, 0, TANHF_TOLERANCE, 0},
{212, 1064178811u, 0u, 1060833332u, 0, TANHF_TOLERANCE, 0},
{213, 1064346583u, 0u, 1060910983u, 0, TANHF_TOLERANCE, 0},
{214, 1064514355u, 0u, 1060987500u, 0, TANHF_TOLERANCE, 0},
{215, 1064682127u, 0u, 1061062894u, 0, TANHF_TOLERANCE, 0},
{216, 1064849900u, 0u, 1061137174u, 0, TANHF_TOLERANCE, 0},
{217, 1065017672u, 0u, 1061210349u, 0, TANHF_TOLERANCE, 0},
{218, 1065185444u, 0u, 1061282431u, 0, TANHF_TOLERANCE, 0},
{219, 1065353216u, 0u, 1061353430u, 0, TANHF_TOLERANCE, 0},
{220, 1065437102u, 0u, 1061423355u, 0, TANHF_TOLERANCE, 0},
{221, 1065520988u, 0u, 1061492217u, 0, TANHF_TOLERANCE, 0},
{222, 1065604874u, 0u, 1061560027u, 0, TANHF_TOLERANCE, 0},
{223, 1065688760u, 0u, 1061626796u, 0, TANHF_TOLERANCE, 0},
{224, 1065772646u, 0u, 1061692534u, 0, TANHF_TOLERANCE, 0},
{225, 1065856532u, 0u, 1061757252u, 0, TANHF_TOLERANCE, 0},
{226, 1065940419u, 0u, 1061820962u, 0, TANHF_TOLERANCE, 0},
{227, 1066024305u, 0u, 1061883673u, 0, TANHF_TOLERANCE, 0},
{228, 1066108191u, 0u, 1061945397u, 0, TANHF_TOLERANCE, 0},
{229, 1066192077u, 0u, 1062006145u, 0, TANHF_TOLERANCE, 0},
{230, 1066275963u, 0u, 1062065929u, 0, TANHF_TOLERANCE, 0},
{231, 1066359849u, 0u, 1062124758u, 0, TANHF_TOLERANCE, 0},
{232, 1066443735u, 0u, 1062182645u, 0, TANHF_TOLERANCE, 0},
{233, 1066527621u, 0u, 1062239601u, 0, TANHF_TOLERANCE, 0},
{234, 1066611507u, 0u, 1062295637u, 0, TANHF_TOLERANCE, 0},
{235, 1066695393u, 0u, 1062350763u, 0, TANHF_TOLERANCE, 0},
{236, 1066779279u, 0u, 1062404992u, 0, TANHF_TOLERANCE, 0},
{237, 1066863165u, 0u, 1062458334u, 0, TANHF_TOLERANCE, 0},
{238, 1066947052u, 0u, 1062510801u, 0, TANHF_TOLERANCE, 0},
{239, 3234402267u, 0u, 3212836747u, 0, TANHF_TOLERANCE, 0},
{240, 3231108068u, 0u, 3212834156u, 0, TANHF_TOLERANCE, 0},
{241, 3226013659u, 0u, 3212774320u, 0, TANHF_TOLERANCE, 0},
{242, 3217625051u, 0u, 3211446911u, 0, TANHF_TOLERANCE, 0},
{243, 0u, 0u, 0u, 0, TANHF_TOLERANCE, 0},
{244, 1070141403u, 0u, 1063963263u, 0, TANHF_TOLERANCE, 0},
{245, 1078530011u, 0u, 1065290672u, 0, TANHF_TOLERANCE, 0},
{246, 1083624420u, 0u, 1065350508u, 0, TANHF_TOLERANCE, 0},
{247, 3253731328u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{248, 3252840038u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{249, 3251948749u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{250, 3251057459u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{251, 3250166170u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{252, 3249274880u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{253, 3248383590u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{254, 3247492301u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{255, 3246601011u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{256, 3245028147u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{257, 3243245568u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{258, 3241462989u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{259, 3239680410u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{260, 3237792973u, 0u, 3212836859u, 0, TANHF_TOLERANCE, 0},
{261, 3234227814u, 0u, 3212836726u, 0, TANHF_TOLERANCE, 0},
{262, 3230662656u, 0u, 3212832724u, 0, TANHF_TOLERANCE, 0},
{263, 3224580915u, 0u, 3212713241u, 0, TANHF_TOLERANCE, 0},
{264, 3213675725u, 0u, 3209489793u, 0, TANHF_TOLERANCE, 0},
{265, 1058642330u, 0u, 1057586197u, 0, TANHF_TOLERANCE, 0},
{266, 1075000115u, 0u, 1065019289u, 0, TANHF_TOLERANCE, 0},
{267, 1082130432u, 0u, 1065341964u, 0, TANHF_TOLERANCE, 0},
{268, 1085695590u, 0u, 1065352840u, 0, TANHF_TOLERANCE, 0},
{269, 1089260749u, 0u, 1065353203u, 0, TANHF_TOLERANCE, 0},
{270, 1091672474u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{271, 1093455053u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{272, 1095237632u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{273, 1097020211u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{274, 1098802790u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{275, 1099746509u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{276, 1100637798u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{277, 1101529088u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{278, 1102420378u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{279, 1103311667u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{280, 1104202957u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{281, 1105094246u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{282, 1105985536u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{283, 1107800421u, 100135u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{284, 3196650934u, 0u, 3196442519u, 0, TANHF_TOLERANCE, 0},
{285, 3368700125u, 4294964487u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{286, 1224242132u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{287, 3221027117u, 73066312u, 3212204671u, 0, TANHF_TOLERANCE, 0},
{288, 1198712763u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{289, 3159309973u, 0u, 3159309249u, 0, TANHF_TOLERANCE, 0},
{290, 954173073u, 0u, 954173073u, 0, TANHF_TOLERANCE, 0},
{291, 3090780435u, 0u, 3090780435u, 0, TANHF_TOLERANCE, 0},
{292, 966554515u, 4294967290u, 966554515u, 0, TANHF_TOLERANCE, 0},
{293, 1312607135u, 47678u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{294, 1166191415u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{295, 3111900019u, 225u, 3111900019u, 0, TANHF_TOLERANCE, 0},
{296, 1234419246u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{297, 1302107128u, 4294492157u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{298, 1052801068u, 0u, 1052238675u, 0, TANHF_TOLERANCE, 0},
{299, 1060849628u, 0u, 1059045352u, 0, TANHF_TOLERANCE, 0},
{300, 3484320003u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{301, 3181522772u, 4294965180u, 3181500608u, 0, TANHF_TOLERANCE, 0},
{302, 882596369u, 7581303u, 882596369u, 0, TANHF_TOLERANCE, 0},
{303, 1167223673u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{304, 968192794u, 0u, 968192794u, 0, TANHF_TOLERANCE, 0},
{305, 3122346862u, 48u, 3122346861u, 0, TANHF_TOLERANCE, 0},
{306, 1052361612u, 53381624u, 1051854119u, 0, TANHF_TOLERANCE, 0},
{307, 906701409u, 0u, 906701409u, 0, TANHF_TOLERANCE, 0},
{308, 3471653172u, 1621u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{309, 3231467496u, 0u, 3212834942u, 0, TANHF_TOLERANCE, 0},
{310, 1341514497u, 3022046720u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{311, 1272351391u, 4294363968u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{312, 3319724992u, 4294842689u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{313, 917622040u, 603040256u, 917622040u, 0, TANHF_TOLERANCE, 0},
{314, 940236348u, 4294965375u, 940236348u, 0, TANHF_TOLERANCE, 0},
{315, 3251541546u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{316, 3099843889u, 4294828114u, 3099843889u, 0, TANHF_TOLERANCE, 0},
{317, 3110358400u, 0u, 3110358400u, 0, TANHF_TOLERANCE, 0},
{318, 3371863479u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{319, 3204069187u, 0u, 3202877449u, 0, TANHF_TOLERANCE, 0},
{320, 1306460502u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{321, 1197542187u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{322, 922888249u, 467u, 922888249u, 0, TANHF_TOLERANCE, 0},
{323, 1184239996u, 4294967294u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{324, 1252490238u, 7808u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{325, 1001673627u, 3340510784u, 1001673508u, 0, TANHF_TOLERANCE, 0},
{326, 976098044u, 1357u, 976098042u, 0, TANHF_TOLERANCE, 0},
{327, 941796645u, 0u, 941796645u, 0, TANHF_TOLERANCE, 0},
{328, 3287199470u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{329, 893184329u, 2485427u, 893184329u, 0, TANHF_TOLERANCE, 0},
{330, 1143233714u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{331, 1139941253u, 929u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{332, 3143717025u, 4294967290u, 3143716967u, 0, TANHF_TOLERANCE, 0},
{333, 3048866608u, 3978787488u, 3048866608u, 0, TANHF_TOLERANCE, 0},
{334, 3240298487u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{335, 1288902137u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{336, 1333134799u, 2211432960u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{337, 1187847971u, 1157221888u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{338, 1038851706u, 2696359424u, 1038783936u, 0, TANHF_TOLERANCE, 0},
{339, 3329354473u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{340, 3077218579u, 529671904u, 3077218579u, 0, TANHF_TOLERANCE, 0},
{341, 1309289088u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{342, 3444653659u, 50272864u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{343, 3405585402u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{344, 3106647724u, 0u, 3106647724u, 0, TANHF_TOLERANCE, 0},
{345, 1106778573u, 4294965325u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{346, 1140567947u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{347, 1238569473u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{348, 3154871957u, 39965012u, 3154871736u, 0, TANHF_TOLERANCE, 0},
{349, 1261071232u, 15806u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{350, 1175011025u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{351, 1082692850u, 187658u, 1065346634u, 0, TANHF_TOLERANCE, 0},
{352, 974547519u, 1563599616u, 974547518u, 0, TANHF_TOLERANCE, 0},
{353, 3058097085u, 0u, 3058097085u, 0, TANHF_TOLERANCE, 0},
{354, 3107252546u, 1u, 3107252546u, 0, TANHF_TOLERANCE, 0},
{355, 3096032662u, 0u, 3096032662u, 0, TANHF_TOLERANCE, 0},
{356, 3197942144u, 0u, 3197632931u, 0, TANHF_TOLERANCE, 0},
{357, 3403348556u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{358, 3182301130u, 3460013312u, 3182273742u, 0, TANHF_TOLERANCE, 0},
{359, 1136411063u, 82u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{360, 3239231622u, 4294965540u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{361, 3340615780u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{362, 998567360u, 0u, 998567312u, 0, TANHF_TOLERANCE, 0},
{363, 3417964312u, 1627479168u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{364, 3109481038u, 695u, 3109481038u, 0, TANHF_TOLERANCE, 0},
{365, 1148867223u, 7486109u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{366, 989687421u, 4294414202u, 989687400u, 0, TANHF_TOLERANCE, 0},
{367, 1152956913u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{368, 892922651u, 4294392467u, 892922651u, 0, TANHF_TOLERANCE, 0},
{369, 1109627625u, 891137088u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{370, 1307091856u, 24u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{371, 1077234132u, 4294967159u, 1065237377u, 0, TANHF_TOLERANCE, 0},
{372, 1142167709u, 13u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{373, 3426232834u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{374, 3368566779u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{375, 3030724760u, 4294886457u, 3030724760u, 0, TANHF_TOLERANCE, 0},
{376, 1138741813u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{377, 982950501u, 0u, 982950497u, 0, TANHF_TOLERANCE, 0},
{378, 1142981585u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{379, 3347165962u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{380, 1009535440u, 4293825695u, 1009535024u, 0, TANHF_TOLERANCE, 0},
{381, 3103736980u, 4287990860u, 3103736980u, 0, TANHF_TOLERANCE, 0},
{382, 3126820946u, 2u, 3126820942u, 0, TANHF_TOLERANCE, 0},
{383, 3473956030u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{384, 3349098349u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{385, 3152729489u, 0u, 3152729226u, 0, TANHF_TOLERANCE, 0},
{386, 945568720u, 4294963204u, 945568720u, 0, TANHF_TOLERANCE, 0},
{387, 3345489836u, 36u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{388, 940893161u, 394u, 940893161u, 0, TANHF_TOLERANCE, 0},
{389, 976791751u, 4294967292u, 976791749u, 0, TANHF_TOLERANCE, 0},
{390, 1004442355u, 0u, 1004442131u, 0, TANHF_TOLERANCE, 0},
{391, 1108485380u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{392, 1061834641u, 0u, 1059624899u, 0, TANHF_TOLERANCE, 0},
{393, 3381268392u, 885u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{394, 1087189715u, 0u, 1065353126u, 0, TANHF_TOLERANCE, 0},
{395, 3212952285u, 4294951762u, 3208933014u, 0, TANHF_TOLERANCE, 0},
{396, 1000611335u, 0u, 1000611245u, 0, TANHF_TOLERANCE, 0},
{397, 3466188568u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{398, 3072456205u, 0u, 3072456205u, 0, TANHF_TOLERANCE, 0},
{399, 3319315516u, 4262338968u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{400, 935938416u, 867u, 935938416u, 0, TANHF_TOLERANCE, 0},
{401, 3212614372u, 1438u, 3208742689u, 0, TANHF_TOLERANCE, 0},
{402, 1315030230u, 4294939294u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{403, 1134593658u, 3712906944u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{404, 977281449u, 0u, 977281447u, 0, TANHF_TOLERANCE, 0},
{405, 1086198791u, 0u, 1065352984u, 0, TANHF_TOLERANCE, 0},
{406, 1255152035u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{407, 1135271264u, 4294966890u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{408, 1094190727u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{409, 1294665325u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{410, 1036608591u, 0u, 1036566212u, 0, TANHF_TOLERANCE, 0},
{411, 3229998064u, 0u, 3212829061u, 0, TANHF_TOLERANCE, 0},
{412, 3439134022u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{413, 3073083133u, 1094097536u, 3073083133u, 0, TANHF_TOLERANCE, 0},
{414, 1325668223u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{415, 1092037607u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{416, 3316278408u, 3774649632u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{417, 3295436768u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{418, 1151984049u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{419, 1129287043u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{420, 1243664530u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{421, 950829092u, 0u, 950829092u, 0, TANHF_TOLERANCE, 0},
{422, 1115471979u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{423, 3351092088u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{424, 3424479544u, 4294963555u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{425, 3241193975u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{426, 1030934236u, 0u, 1030915623u, 0, TANHF_TOLERANCE, 0},
{427, 3131791114u, 4283960578u, 3131791108u, 0, TANHF_TOLERANCE, 0},
{428, 1025254314u, 0u, 1025249360u, 0, TANHF_TOLERANCE, 0},
{429, 1110545760u, 4294967286u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{430, 3180213739u, 37u, 3180198788u, 0, TANHF_TOLERANCE, 0},
{431, 3361976590u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{432, 881280146u, 4262747520u, 881280146u, 0, TANHF_TOLERANCE, 0},
{433, 1304154705u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{434, 3264443610u, 4294967294u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{435, 3374550627u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{436, 899599265u, 4294967286u, 899599265u, 0, TANHF_TOLERANCE, 0},
{437, 1268194719u, 3962356224u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{438, 1133420220u, 3161371u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{439, 1161858787u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{440, 3184462258u, 13627054u, 3184416224u, 0, TANHF_TOLERANCE, 0},
{441, 3295996963u, 3846806432u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{442, 1270887389u, 1864u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{443, 3325193181u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{444, 925657343u, 955232128u, 925657343u, 0, TANHF_TOLERANCE, 0},
{445, 3115275450u, 0u, 3115275450u, 0, TANHF_TOLERANCE, 0},
{446, 3116607482u, 4294967294u, 3116607481u, 0, TANHF_TOLERANCE, 0},
{447, 3187892415u, 0u, 3187845482u, 0, TANHF_TOLERANCE, 0},
{448, 1189120494u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{449, 889030794u, 0u, 889030794u, 0, TANHF_TOLERANCE, 0},
{450, 1323529208u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{451, 3465768388u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{452, 3426099899u, 87u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{453, 3224857113u, 4290382691u, 3212728447u, 0, TANHF_TOLERANCE, 0},
{454, 1065798296u, 0u, 1061712431u, 0, TANHF_TOLERANCE, 0},
{455, 3328989444u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{456, 3357819026u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{457, 1273397670u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{458, 3424831780u, 414735168u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{459, 1257596246u, 4264851904u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{460, 1051773536u, 0u, 1051334021u, 0, TANHF_TOLERANCE, 0},
{461, 3294752507u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{462, 3424848725u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{463, 1090870906u, 4294966393u, 1065353214u, 0, TANHF_TOLERANCE, 0},
{464, 1227582289u, 147011u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{465, 1272325814u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{466, 3359508271u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{467, 1137854355u, 4294941607u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{468, 3440773058u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{469, 3101598400u, 0u, 3101598400u, 0, TANHF_TOLERANCE, 0},
{470, 3451216836u, 4294896064u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{471, 3437062994u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{472, 1131196082u, 3743u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{473, 3177294154u, 63027320u, 3177279209u, 0, TANHF_TOLERANCE, 0},
{474, 3258097678u, 449173056u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{475, 3460915348u, 356647u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{476, 3303035472u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{477, 1053698677u, 4294966907u, 1053012876u, 0, TANHF_TOLERANCE, 0},
{478, 3396166221u, 83688u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{479, 3037541131u, 5u, 3037541131u, 0, TANHF_TOLERANCE, 0},
{480, 3458934263u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{481, 1065761827u, 4294943781u, 1061684113u, 0, TANHF_TOLERANCE, 0},
{482, 3025843188u, 0u, 3025843188u, 0, TANHF_TOLERANCE, 0},
{483, 926665223u, 0u, 926665223u, 0, TANHF_TOLERANCE, 0},
{484, 1199816046u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{485, 3333779015u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{486, 948398145u, 4294967288u, 948398145u, 0, TANHF_TOLERANCE, 0},
{487, 3054021468u, 23933390u, 3054021468u, 0, TANHF_TOLERANCE, 0},
{488, 1080781593u, 224021u, 1065331814u, 0, TANHF_TOLERANCE, 0},
{489, 3164749613u, 0u, 3164748223u, 0, TANHF_TOLERANCE, 0},
{490, 3235326590u, 26828788u, 3212836816u, 0, TANHF_TOLERANCE, 0},
{491, 3118883815u, 0u, 3118883814u, 0, TANHF_TOLERANCE, 0},
{492, 965378004u, 146193824u, 965378004u, 0, TANHF_TOLERANCE, 0},
{493, 3226990408u, 45u, 3212797580u, 0, TANHF_TOLERANCE, 0},
{494, 3117098218u, 115u, 3117098217u, 0, TANHF_TOLERANCE, 0},
{495, 1283624229u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{496, 970649315u, 3u, 970649314u, 0, TANHF_TOLERANCE, 0},
{497, 959776291u, 4294967028u, 959776291u, 0, TANHF_TOLERANCE, 0},
{498, 3341117305u, 4294966405u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{499, 1270734970u, 4294829480u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{500, 3454816067u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{501, 917206623u, 7364u, 917206623u, 0, TANHF_TOLERANCE, 0},
{502, 1106502045u, 126247200u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{503, 1157598381u, 4294964293u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{504, 3335234513u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{505, 1279489061u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{506, 3157416480u, 624023680u, 3157416018u, 0, TANHF_TOLERANCE, 0},
{507, 3143920719u, 0u, 3143920658u, 0, TANHF_TOLERANCE, 0},
{508, 1233171235u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{509, 1148920078u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{510, 3064988156u, 4294967292u, 3064988156u, 0, TANHF_TOLERANCE, 0},
{511, 3083619260u, 2484u, 3083619260u, 0, TANHF_TOLERANCE, 0},
{512, 1109198803u, 431095u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{513, 3219949483u, 0u, 3212023955u, 0, TANHF_TOLERANCE, 0},
{514, 3361149474u, 4293077090u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{515, 1207502108u, 4292985650u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{516, 1000014431u, 0u, 1000014355u, 0, TANHF_TOLERANCE, 0},
{517, 3161756316u, 0u, 3161755126u, 0, TANHF_TOLERANCE, 0},
{518, 3160728744u, 4293625597u, 3160727768u, 0, TANHF_TOLERANCE, 0},
{519, 1234530539u, 3u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{520, 1017843965u, 40165u, 1017842336u, 0, TANHF_TOLERANCE, 0},
{521, 951862956u, 7732u, 951862956u, 0, TANHF_TOLERANCE, 0},
{522, 3306328852u, 87u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{523, 1291910469u, 183319u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{524, 3027442905u, 7942u, 3027442905u, 0, TANHF_TOLERANCE, 0},
{525, 1131927531u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{526, 3449879391u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{527, 970094304u, 4294911386u, 970094303u, 0, TANHF_TOLERANCE, 0},
{528, 1125551064u, 4294949017u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{529, 3427296372u, 3784252480u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{530, 1198917460u, 2607027968u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{531, 3201603336u, 0u, 3200854291u, 0, TANHF_TOLERANCE, 0},
{532, 3114686212u, 1328603904u, 3114686212u, 0, TANHF_TOLERANCE, 0},
{533, 921940707u, 0u, 921940707u, 0, TANHF_TOLERANCE, 0},
{534, 1091906532u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{535, 3393557778u, 4293570247u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{536, 1276853215u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{537, 3462778440u, 4294884341u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{538, 3360170117u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{539, 3224245428u, 4294967170u, 3212691888u, 0, TANHF_TOLERANCE, 0},
{540, 1120124467u, 352u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{541, 1064364381u, 0u, 1060919153u, 0, TANHF_TOLERANCE, 0},
{542, 1268744779u, 4294952694u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{543, 1165195428u, 4292538760u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{544, 3044092739u, 30u, 3044092739u, 0, TANHF_TOLERANCE, 0},
{545, 3149469534u, 47144136u, 3149469405u, 0, TANHF_TOLERANCE, 0},
{546, 3247790039u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{547, 3215244648u, 4u, 3210460317u, 0, TANHF_TOLERANCE, 0},
{548, 3095275931u, 0u, 3095275931u, 0, TANHF_TOLERANCE, 0},
{549, 3059688264u, 77u, 3059688264u, 0, TANHF_TOLERANCE, 0},
{550, 1212717473u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{551, 3275973009u, 3930410816u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{552, 3028857014u, 0u, 3028857014u, 0, TANHF_TOLERANCE, 0},
{553, 3391162308u, 129212984u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{554, 1044867873u, 4294528232u, 1044705124u, 0, TANHF_TOLERANCE, 0},
{555, 1089986803u, 3370664576u, 1065353210u, 0, TANHF_TOLERANCE, 0},
{556, 1296314700u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{557, 1251462432u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{558, 3485236902u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{559, 3262169538u, 19958524u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{560, 3080852256u, 0u, 3080852256u, 0, TANHF_TOLERANCE, 0},
{561, 1022211242u, 0u, 1022206871u, 0, TANHF_TOLERANCE, 0},
{562, 884661176u, 0u, 884661176u, 0, TANHF_TOLERANCE, 0},
{563, 3071422941u, 4294967172u, 3071422941u, 0, TANHF_TOLERANCE, 0},
{564, 989762529u, 4294733601u, 989762508u, 0, TANHF_TOLERANCE, 0},
{565, 1295475718u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{566, 1002632518u, 4294950696u, 1002632367u, 0, TANHF_TOLERANCE, 0},
{567, 3404372005u, 3938008096u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{568, 3158912530u, 0u, 3158911867u, 0, TANHF_TOLERANCE, 0},
{569, 1125800069u, 4294967259u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{570, 3138037576u, 0u, 3138037562u, 0, TANHF_TOLERANCE, 0},
{571, 3108384823u, 268832992u, 3108384823u, 0, TANHF_TOLERANCE, 0},
{572, 999985470u, 4282999218u, 999985395u, 0, TANHF_TOLERANCE, 0},
{573, 1189421739u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{574, 3075182644u, 0u, 3075182644u, 0, TANHF_TOLERANCE, 0},
{575, 3028099649u, 4292241163u, 3028099649u, 0, TANHF_TOLERANCE, 0},
{576, 3132541814u, 4077666864u, 3132541806u, 0, TANHF_TOLERANCE, 0},
{577, 1164046161u, 4139845440u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{578, 1292596266u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{579, 3469748379u, 4279587928u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{580, 1314644642u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{581, 3399813173u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{582, 948775569u, 2159002624u, 948775569u, 0, TANHF_TOLERANCE, 0},
{583, 1034611395u, 0u, 1034585462u, 0, TANHF_TOLERANCE, 0},
{584, 3489122735u, 4294428604u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{585, 1181604787u, 4294717096u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{586, 3059042077u, 0u, 3059042077u, 0, TANHF_TOLERANCE, 0},
{587, 1043691622u, 4288164501u, 1043568665u, 0, TANHF_TOLERANCE, 0},
{588, 1314588083u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{589, 3141533334u, 0u, 3141533298u, 0, TANHF_TOLERANCE, 0},
{590, 3157534378u, 3899913312u, 3157533902u, 0, TANHF_TOLERANCE, 0},
{591, 3400949680u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{592, 3365581801u, 9596u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{593, 1110424755u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{594, 3189917167u, 0u, 3189829030u, 0, TANHF_TOLERANCE, 0},
{595, 969804941u, 4294836255u, 969804940u, 0, TANHF_TOLERANCE, 0},
{596, 1139120919u, 4294967176u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{597, 934308144u, 0u, 934308144u, 0, TANHF_TOLERANCE, 0},
{598, 1220524226u, 1440u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{599, 3162548604u, 3394333056u, 3162547911u, 0, TANHF_TOLERANCE, 0},
{600, 3382391700u, 4294966243u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{601, 1156767533u, 7u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{602, 3079222483u, 4294963487u, 3079222483u, 0, TANHF_TOLERANCE, 0},
{603, 994934087u, 0u, 994934043u, 0, TANHF_TOLERANCE, 0},
{604, 3185240099u, 122u, 3185185712u, 0, TANHF_TOLERANCE, 0},
{605, 3479873563u, 3288004u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{606, 3424264117u, 4203174416u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{607, 3228365887u, 275492u, 3212816465u, 0, TANHF_TOLERANCE, 0},
{608, 1035909900u, 4101891u, 1035873887u, 0, TANHF_TOLERANCE, 0},
{609, 3024951184u, 3626688u, 3024951184u, 0, TANHF_TOLERANCE, 0},
{610, 1212129651u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{611, 3125775254u, 0u, 3125775251u, 0, TANHF_TOLERANCE, 0},
{612, 1037464105u, 0u, 1037412966u, 0, TANHF_TOLERANCE, 0},
{613, 1311706596u, 6702361u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{614, 918212457u, 0u, 918212457u, 0, TANHF_TOLERANCE, 0},
{615, 1337315179u, 3421796288u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{616, 1131358407u, 4294955130u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{617, 1156517523u, 4294914801u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{618, 3210802820u, 0u, 3207900979u, 0, TANHF_TOLERANCE, 0},
{619, 3337499209u, 621819u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{620, 3468429030u, 4294967266u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{621, 3253515800u, 28517u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{622, 3055299953u, 0u, 3055299953u, 0, TANHF_TOLERANCE, 0},
{623, 959956547u, 0u, 959956547u, 0, TANHF_TOLERANCE, 0},
{624, 3425290480u, 461u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{625, 1039917375u, 117u, 1039834646u, 0, TANHF_TOLERANCE, 0},
{626, 3220979495u, 4234725636u, 3212197589u, 0, TANHF_TOLERANCE, 0},
{627, 1311016004u, 4294941884u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{628, 1128016396u, 27u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{629, 3210335769u, 0u, 3207661956u, 0, TANHF_TOLERANCE, 0},
{630, 3022705759u, 4287084865u, 3022705759u, 0, TANHF_TOLERANCE, 0},
{631, 1206054701u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{632, 3144504834u, 3170u, 3144504766u, 0, TANHF_TOLERANCE, 0},
{633, 1213609983u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{634, 1246902946u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{635, 995850843u, 3845036544u, 995850789u, 0, TANHF_TOLERANCE, 0},
{636, 3362082828u, 4294328268u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{637, 1029480631u, 0u, 1029466664u, 0, TANHF_TOLERANCE, 0},
{638, 3153568584u, 0u, 3153568275u, 0, TANHF_TOLERANCE, 0},
{639, 3384988527u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{640, 1317696241u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{641, 3235395924u, 249u, 3212836819u, 0, TANHF_TOLERANCE, 0},
{642, 3341877624u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{643, 1228636133u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{644, 3161654634u, 4294939932u, 3161653466u, 0, TANHF_TOLERANCE, 0},
{645, 3162655243u, 4294964738u, 3162654523u, 0, TANHF_TOLERANCE, 0},
{646, 1207246237u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{647, 1165476654u, 4294877038u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{648, 1215278023u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{649, 1017239798u, 4167373560u, 1017238418u, 0, TANHF_TOLERANCE, 0},
{650, 1149651309u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{651, 1111943722u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{652, 1189849849u, 4293652457u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{653, 3204848496u, 0u, 3203799673u, 0, TANHF_TOLERANCE, 0},
{654, 1249758327u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{655, 3092982276u, 4065500752u, 3092982276u, 0, TANHF_TOLERANCE, 0},
{656, 1168098747u, 1063712256u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{657, 892549317u, 13301u, 892549317u, 0, TANHF_TOLERANCE, 0},
{658, 3301009024u, 4286178976u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{659, 3233089227u, 204399u, 3212836455u, 0, TANHF_TOLERANCE, 0},
{660, 3218245284u, 1767132u, 3211631110u, 0, TANHF_TOLERANCE, 0},
{661, 3215981890u, 4294967286u, 3210820373u, 0, TANHF_TOLERANCE, 0},
{662, 1266687209u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{663, 3487959775u, 4294948774u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{664, 943645710u, 0u, 943645710u, 0, TANHF_TOLERANCE, 0},
{665, 3345065699u, 4294966959u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{666, 935847271u, 1u, 935847271u, 0, TANHF_TOLERANCE, 0},
{667, 3410336089u, 47u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{668, 3082940740u, 1562501120u, 3082940740u, 0, TANHF_TOLERANCE, 0},
{669, 1141063391u, 5507u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{670, 3059263153u, 0u, 3059263153u, 0, TANHF_TOLERANCE, 0},
{671, 3353679791u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{672, 1001823878u, 0u, 1001823754u, 0, TANHF_TOLERANCE, 0},
{673, 1009130212u, 0u, 1009129839u, 0, TANHF_TOLERANCE, 0},
{674, 3367127535u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{675, 1032920919u, 3981458912u, 1032905032u, 0, TANHF_TOLERANCE, 0},
{676, 3281952870u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{677, 1237868497u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{678, 1153753924u, 4294958733u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{679, 1120261759u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{680, 3226328360u, 4294623870u, 3212783021u, 0, TANHF_TOLERANCE, 0},
{681, 3349595986u, 4294967271u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{682, 3166889490u, 4294965026u, 3166887081u, 0, TANHF_TOLERANCE, 0},
{683, 1087750238u, 16u, 1065353163u, 0, TANHF_TOLERANCE, 0},
{684, 3121620061u, 4294773019u, 3121620060u, 0, TANHF_TOLERANCE, 0},
{685, 1066116543u, 0u, 1061951489u, 0, TANHF_TOLERANCE, 0},
{686, 3210898034u, 0u, 3207948571u, 0, TANHF_TOLERANCE, 0},
{687, 3051923237u, 4294697573u, 3051923237u, 0, TANHF_TOLERANCE, 0},
{688, 1030612298u, 4294908239u, 1030594791u, 0, TANHF_TOLERANCE, 0},
{689, 1186234578u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{690, 1331680743u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{691, 3060774997u, 2318310656u, 3060774997u, 0, TANHF_TOLERANCE, 0},
{692, 887589411u, 141578704u, 887589411u, 0, TANHF_TOLERANCE, 0},
{693, 1045232522u, 4294967290u, 1045055916u, 0, TANHF_TOLERANCE, 0},
{694, 3119858470u, 0u, 3119858469u, 0, TANHF_TOLERANCE, 0},
{695, 3349432725u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{696, 912423027u, 0u, 912423027u, 0, TANHF_TOLERANCE, 0},
{697, 3228795133u, 4294967132u, 3212820239u, 0, TANHF_TOLERANCE, 0},
{698, 3194674746u, 0u, 3194410390u, 0, TANHF_TOLERANCE, 0},
{699, 3296784303u, 4294967098u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{700, 965402291u, 0u, 965402291u, 0, TANHF_TOLERANCE, 0},
{701, 3388153589u, 4246639564u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{702, 1133410485u, 4294951516u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{703, 3136790322u, 7u, 3136790303u, 0, TANHF_TOLERANCE, 0},
{704, 3369970587u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{705, 1270451568u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{706, 989498922u, 0u, 989498902u, 0, TANHF_TOLERANCE, 0},
{707, 1280215674u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{708, 1171873518u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{709, 3298258100u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{710, 3415208824u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{711, 1001897182u, 0u, 1001897056u, 0, TANHF_TOLERANCE, 0},
{712, 3152777939u, 4294967281u, 3152777673u, 0, TANHF_TOLERANCE, 0},
{713, 985903305u, 4294945424u, 985903295u, 0, TANHF_TOLERANCE, 0},
{714, 3357328848u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{715, 982612185u, 0u, 982612181u, 0, TANHF_TOLERANCE, 0},
{716, 3267868136u, 136421u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{717, 3319048157u, 7150u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{718, 1144755661u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{719, 898467286u, 0u, 898467286u, 0, TANHF_TOLERANCE, 0},
{720, 3301461672u, 1119632u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{721, 3364525678u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{722, 931441127u, 285u, 931441127u, 0, TANHF_TOLERANCE, 0},
{723, 3146660041u, 0u, 3146659982u, 0, TANHF_TOLERANCE, 0},
{724, 3467121799u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{725, 1151257041u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{726, 3097873255u, 4294967295u, 3097873255u, 0, TANHF_TOLERANCE, 0},
{727, 3130670309u, 0u, 3130670304u, 0, TANHF_TOLERANCE, 0},
{728, 1017573824u, 0u, 1017572310u, 0, TANHF_TOLERANCE, 0},
{729, 1258369714u, 3364363264u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{730, 1216602683u, 4294468761u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{731, 3297265739u, 228335u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{732, 1071940738u, 4294963632u, 1064434859u, 0, TANHF_TOLERANCE, 0},
{733, 922601356u, 4294937447u, 922601356u, 0, TANHF_TOLERANCE, 0},
{734, 3462285635u, 4085532736u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{735, 3357177805u, 5u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{736, 3049120080u, 0u, 3049120080u, 0, TANHF_TOLERANCE, 0},
{737, 1153863660u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{738, 3034243695u, 0u, 3034243695u, 0, TANHF_TOLERANCE, 0},
{739, 1249365132u, 4294967060u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{740, 3046215730u, 0u, 3046215730u, 0, TANHF_TOLERANCE, 0},
{741, 3047251716u, 8u, 3047251716u, 0, TANHF_TOLERANCE, 0},
{742, 3131219358u, 2355170688u, 3131219353u, 0, TANHF_TOLERANCE, 0},
{743, 3222096285u, 59453u, 3212435981u, 0, TANHF_TOLERANCE, 0},
{744, 1297708818u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{745, 3345532722u, 4293531291u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{746, 3418753236u, 4002743296u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{747, 1277417964u, 1103002624u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{748, 987577257u, 1370u, 987577243u, 0, TANHF_TOLERANCE, 0},
{749, 3161606610u, 0u, 3161605453u, 0, TANHF_TOLERANCE, 0},
{750, 888030585u, 0u, 888030585u, 0, TANHF_TOLERANCE, 0},
{751, 1043442869u, 4294963715u, 1043327408u, 0, TANHF_TOLERANCE, 0},
{752, 3320923228u, 3214934912u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{753, 1337400405u, 418188288u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{754, 3400348640u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{755, 1250249095u, 1u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{756, 3284411233u, 7805u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{757, 3020883322u, 0u, 3020883322u, 0, TANHF_TOLERANCE, 0},
{758, 1215968622u, 2531374080u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{759, 3202319550u, 0u, 3201454820u, 0, TANHF_TOLERANCE, 0},
{760, 3061638260u, 0u, 3061638260u, 0, TANHF_TOLERANCE, 0},
{761, 1025404104u, 1u, 1025398930u, 0, TANHF_TOLERANCE, 0},
{762, 3138086437u, 0u, 3138086423u, 0, TANHF_TOLERANCE, 0},
{763, 3091024506u, 3752313152u, 3091024506u, 0, TANHF_TOLERANCE, 0},
{764, 3362748242u, 4294517284u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{765, 3099671635u, 4294967295u, 3099671635u, 0, TANHF_TOLERANCE, 0},
{766, 3068014841u, 0u, 3068014841u, 0, TANHF_TOLERANCE, 0},
{767, 1252237719u, 105u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{768, 3327895594u, 517257u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{769, 3082454432u, 0u, 3082454432u, 0, TANHF_TOLERANCE, 0},
{770, 3396161504u, 16393u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{771, 1099710167u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{772, 1157186482u, 109233848u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{773, 1282110851u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{774, 3477008113u, 3797391872u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{775, 3292127294u, 4282395772u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{776, 1123357102u, 4294966999u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{777, 1106837025u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{778, 1049949008u, 230u, 1049682635u, 0, TANHF_TOLERANCE, 0},
{779, 1253017688u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{780, 1108543194u, 4294966999u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{781, 3087985411u, 1700586u, 3087985411u, 0, TANHF_TOLERANCE, 0},
{782, 3163283126u, 2976129280u, 3163282235u, 0, TANHF_TOLERANCE, 0},
{783, 1160162706u, 14164775u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{784, 3305715025u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{785, 1266928623u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{786, 3025340297u, 43483u, 3025340297u, 0, TANHF_TOLERANCE, 0},
{787, 3438080027u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{788, 3344574751u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{789, 1152416724u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{790, 1218239308u, 161u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{791, 3263310567u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{792, 3041998669u, 2782u, 3041998669u, 0, TANHF_TOLERANCE, 0},
{793, 1000313118u, 0u, 1000313035u, 0, TANHF_TOLERANCE, 0},
{794, 972485427u, 131u, 972485426u, 0, TANHF_TOLERANCE, 0},
{795, 3290264612u, 137u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{796, 3222106584u, 18249u, 3212437922u, 0, TANHF_TOLERANCE, 0},
{797, 1278946388u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{798, 947914771u, 0u, 947914771u, 0, TANHF_TOLERANCE, 0},
{799, 3167730654u, 0u, 3167727737u, 0, TANHF_TOLERANCE, 0},
{800, 1098530298u, 4294967260u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{801, 3232726036u, 0u, 3212836285u, 0, TANHF_TOLERANCE, 0},
{802, 1297190916u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{803, 1277649137u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{804, 3203377685u, 466619008u, 3202322865u, 0, TANHF_TOLERANCE, 0},
{805, 3090306474u, 0u, 3090306474u, 0, TANHF_TOLERANCE, 0},
{806, 3244032016u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{807, 3033122376u, 0u, 3033122376u, 0, TANHF_TOLERANCE, 0},
{808, 1096155623u, 7454884u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{809, 873151908u, 4294967280u, 873151908u, 0, TANHF_TOLERANCE, 0},
{810, 3238729605u, 245005088u, 3212836863u, 0, TANHF_TOLERANCE, 0},
{811, 3317196817u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{812, 3374748510u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{813, 3345634950u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{814, 3189860276u, 0u, 3189773537u, 0, TANHF_TOLERANCE, 0},
{815, 887311687u, 9077u, 887311687u, 0, TANHF_TOLERANCE, 0},
{816, 3396917283u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{817, 3317032737u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{818, 1200051436u, 3555u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{819, 3105291012u, 45279u, 3105291012u, 0, TANHF_TOLERANCE, 0},
{820, 1306520561u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{821, 1314936356u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{822, 3475052219u, 71851496u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{823, 3085636260u, 33u, 3085636260u, 0, TANHF_TOLERANCE, 0},
{824, 3393227708u, 4294967164u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{825, 3182540197u, 0u, 3182511055u, 0, TANHF_TOLERANCE, 0},
{826, 3349005404u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{827, 3154720153u, 4090490144u, 3154719943u, 0, TANHF_TOLERANCE, 0},
{828, 1262863321u, 345111u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{829, 882902102u, 512593u, 882902102u, 0, TANHF_TOLERANCE, 0},
{830, 1053387478u, 0u, 1052746205u, 0, TANHF_TOLERANCE, 0},
{831, 3387653691u, 4294896063u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{832, 3136364836u, 0u, 3136364818u, 0, TANHF_TOLERANCE, 0},
{833, 1338680611u, 4126u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{834, 1112891928u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{835, 893449284u, 0u, 893449284u, 0, TANHF_TOLERANCE, 0},
{836, 892311459u, 14u, 892311459u, 0, TANHF_TOLERANCE, 0},
{837, 3105373037u, 4294967280u, 3105373037u, 0, TANHF_TOLERANCE, 0},
{838, 1190105283u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{839, 1011225926u, 14129u, 1011225294u, 0, TANHF_TOLERANCE, 0},
{840, 1043025031u, 0u, 1042921472u, 0, TANHF_TOLERANCE, 0},
{841, 3410531037u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{842, 3125834184u, 0u, 3125834181u, 0, TANHF_TOLERANCE, 0},
{843, 902318189u, 0u, 902318189u, 0, TANHF_TOLERANCE, 0},
{844, 3213624815u, 0u, 3209453041u, 0, TANHF_TOLERANCE, 0},
{845, 1120888322u, 5u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{846, 1315217243u, 4291026624u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{847, 3137758475u, 0u, 3137758463u, 0, TANHF_TOLERANCE, 0},
{848, 1040617590u, 0u, 1040567175u, 0, TANHF_TOLERANCE, 0},
{849, 955384253u, 4294910624u, 955384253u, 0, TANHF_TOLERANCE, 0},
{850, 3061417900u, 7119u, 3061417900u, 0, TANHF_TOLERANCE, 0},
{851, 904255535u, 0u, 904255535u, 0, TANHF_TOLERANCE, 0},
{852, 1022984119u, 0u, 1022979065u, 0, TANHF_TOLERANCE, 0},
{853, 997362368u, 0u, 997362295u, 0, TANHF_TOLERANCE, 0},
{854, 900933520u, 19u, 900933520u, 0, TANHF_TOLERANCE, 0},
{855, 1168623062u, 661u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{856, 878737490u, 4294967181u, 878737490u, 0, TANHF_TOLERANCE, 0},
{857, 1039827284u, 1u, 1039745896u, 0, TANHF_TOLERANCE, 0},
{858, 1021564080u, 0u, 1021560232u, 0, TANHF_TOLERANCE, 0},
{859, 3458669745u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{860, 3327516316u, 4286775627u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{861, 1040711112u, 4294967293u, 1040659084u, 0, TANHF_TOLERANCE, 0},
{862, 1134528351u, 4294638880u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{863, 3039884464u, 6340u, 3039884464u, 0, TANHF_TOLERANCE, 0},
{864, 3414352838u, 4294876517u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{865, 1133689539u, 1u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{866, 3455688478u, 4294945415u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{867, 1137634874u, 395u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{868, 3415502662u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{869, 954999730u, 0u, 954999730u, 0, TANHF_TOLERANCE, 0},
{870, 1066157309u, 4294967285u, 1061981085u, 0, TANHF_TOLERANCE, 0},
{871, 3436353675u, 8741u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{872, 940437609u, 0u, 940437609u, 0, TANHF_TOLERANCE, 0},
{873, 3108347547u, 4203356328u, 3108347547u, 0, TANHF_TOLERANCE, 0},
{874, 3064200154u, 0u, 3064200154u, 0, TANHF_TOLERANCE, 0},
{875, 1023889593u, 0u, 1023886368u, 0, TANHF_TOLERANCE, 0},
{876, 3272661536u, 3393767296u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{877, 1170245333u, 1083705u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{878, 1219052056u, 4294526211u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{879, 3318983619u, 4294967246u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{880, 3372118621u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{881, 3146190320u, 0u, 3146190270u, 0, TANHF_TOLERANCE, 0},
{882, 1299683827u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{883, 3190796331u, 1457792256u, 3190684670u, 0, TANHF_TOLERANCE, 0},
{884, 3086068902u, 2772570624u, 3086068902u, 0, TANHF_TOLERANCE, 0},
{885, 3064155399u, 0u, 3064155399u, 0, TANHF_TOLERANCE, 0},
{886, 3040314717u, 1u, 3040314717u, 0, TANHF_TOLERANCE, 0},
{887, 3257224022u, 4294737239u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{888, 1229268598u, 1u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{889, 3184078812u, 0u, 3184036562u, 0, TANHF_TOLERANCE, 0},
{890, 1086717248u, 4256439624u, 1065353074u, 0, TANHF_TOLERANCE, 0},
{891, 3434884607u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{892, 3464955606u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{893, 1025278524u, 0u, 1025273535u, 0, TANHF_TOLERANCE, 0},
{894, 1242829722u, 4294967290u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{895, 3075149137u, 76u, 3075149137u, 0, TANHF_TOLERANCE, 0},
{896, 1200927971u, 1093714048u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{897, 3326858092u, 3870213632u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{898, 1246019790u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{899, 3184801644u, 424u, 3184752079u, 0, TANHF_TOLERANCE, 0},
{900, 1136052740u, 4294967282u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{901, 1069009211u, 0u, 1063555619u, 0, TANHF_TOLERANCE, 0},
{902, 1015670780u, 20u, 1015669926u, 0, TANHF_TOLERANCE, 0},
{903, 1012543234u, 70u, 1012542389u, 0, TANHF_TOLERANCE, 0},
{904, 3316611992u, 4291436324u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{905, 1087942795u, 4294961657u, 1065353172u, 0, TANHF_TOLERANCE, 0},
{906, 3426365713u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{907, 3066654389u, 4087070784u, 3066654389u, 0, TANHF_TOLERANCE, 0},
{908, 3295326432u, 842363840u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{909, 3318835308u, 4294967077u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{910, 3283555717u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{911, 3381255420u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{912, 3040485181u, 4294241104u, 3040485181u, 0, TANHF_TOLERANCE, 0},
{913, 3388772093u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{914, 954670189u, 760u, 954670189u, 0, TANHF_TOLERANCE, 0},
{915, 1319200415u, 4293050361u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{916, 1279324488u, 4294967293u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{917, 3217795424u, 0u, 3211500035u, 0, TANHF_TOLERANCE, 0},
{918, 3455131757u, 10314665u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{919, 1246947517u, 6u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{920, 3396723577u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{921, 3433761025u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{922, 3201187455u, 0u, 3200500904u, 0, TANHF_TOLERANCE, 0},
{923, 1173247961u, 32661u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{924, 3037297123u, 4294904338u, 3037297123u, 0, TANHF_TOLERANCE, 0},
{925, 3248534678u, 1927801856u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{926, 3083019343u, 0u, 3083019343u, 0, TANHF_TOLERANCE, 0},
{927, 3042018375u, 0u, 3042018375u, 0, TANHF_TOLERANCE, 0},
{928, 1082862511u, 0u, 1065347617u, 0, TANHF_TOLERANCE, 0},
{929, 3157626955u, 3075906560u, 3157626468u, 0, TANHF_TOLERANCE, 0},
{930, 1341821683u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{931, 881101379u, 32095u, 881101379u, 0, TANHF_TOLERANCE, 0},
{932, 1079061705u, 0u, 1065304658u, 0, TANHF_TOLERANCE, 0},
{933, 3182695954u, 4294967257u, 3182665629u, 0, TANHF_TOLERANCE, 0},
{934, 1105291533u, 3424974848u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{935, 1016023520u, 4294967293u, 1016022562u, 0, TANHF_TOLERANCE, 0},
{936, 3370691006u, 198615840u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{937, 1156767169u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{938, 3077020499u, 0u, 3077020499u, 0, TANHF_TOLERANCE, 0},
{939, 1104284039u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{940, 3335212901u, 1662125568u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{941, 1093697541u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{942, 3266691185u, 2645u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{943, 3179003144u, 37u, 3178982403u, 0, TANHF_TOLERANCE, 0},
{944, 1094115255u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{945, 3424086808u, 4294967244u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{946, 3353608773u, 305u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{947, 973664327u, 1394344832u, 973664326u, 0, TANHF_TOLERANCE, 0},
{948, 882878091u, 0u, 882878091u, 0, TANHF_TOLERANCE, 0},
{949, 1098662266u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{950, 927582555u, 0u, 927582555u, 0, TANHF_TOLERANCE, 0},
{951, 3111440310u, 0u, 3111440310u, 0, TANHF_TOLERANCE, 0},
{952, 3476083859u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{953, 3038754840u, 0u, 3038754840u, 0, TANHF_TOLERANCE, 0},
{954, 979878744u, 1008405u, 979878740u, 0, TANHF_TOLERANCE, 0},
{955, 3464546616u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{956, 1002542205u, 0u, 1002542057u, 0, TANHF_TOLERANCE, 0},
{957, 3443552129u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{958, 1287620154u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{959, 946058434u, 4207447u, 946058434u, 0, TANHF_TOLERANCE, 0},
{960, 3073260205u, 0u, 3073260205u, 0, TANHF_TOLERANCE, 0},
{961, 1245702957u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{962, 989655126u, 528989952u, 989655105u, 0, TANHF_TOLERANCE, 0},
{963, 1002715618u, 32425u, 1002715464u, 0, TANHF_TOLERANCE, 0},
{964, 3087802274u, 0u, 3087802274u, 0, TANHF_TOLERANCE, 0},
{965, 1000863905u, 54834u, 1000863809u, 0, TANHF_TOLERANCE, 0},
{966, 3415763001u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{967, 3283471961u, 10190634u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{968, 3311210827u, 36713u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{969, 3026311911u, 0u, 3026311911u, 0, TANHF_TOLERANCE, 0},
{970, 1198307901u, 68u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{971, 1288901567u, 206618288u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{972, 922255363u, 0u, 922255363u, 0, TANHF_TOLERANCE, 0},
{973, 1113104661u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{974, 1136714348u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{975, 948856035u, 0u, 948856035u, 0, TANHF_TOLERANCE, 0},
{976, 1062512367u, 4294967293u, 1059998546u, 0, TANHF_TOLERANCE, 0},
{977, 3486907092u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{978, 1162027071u, 4294964303u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{979, 1034561811u, 0u, 1034536221u, 0, TANHF_TOLERANCE, 0},
{980, 3271615417u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{981, 1042014529u, 869u, 1041936344u, 0, TANHF_TOLERANCE, 0},
{982, 1177157787u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{983, 3196144817u, 0u, 3195878666u, 0, TANHF_TOLERANCE, 0},
{984, 3432084552u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{985, 1309658335u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{986, 1226494979u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{987, 3100289712u, 3743522688u, 3100289712u, 0, TANHF_TOLERANCE, 0},
{988, 3375507013u, 462886112u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{989, 3460699001u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{990, 3079231719u, 0u, 3079231719u, 0, TANHF_TOLERANCE, 0},
{991, 3093951884u, 0u, 3093951884u, 0, TANHF_TOLERANCE, 0},
{992, 3468023178u, 156157u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{993, 1204196034u, 4294966040u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{994, 3459877411u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{995, 909696559u, 3378u, 909696559u, 0, TANHF_TOLERANCE, 0},
{996, 1161439847u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{997, 908663107u, 0u, 908663107u, 0, TANHF_TOLERANCE, 0},
{998, 1055319316u, 4294967238u, 1054370620u, 0, TANHF_TOLERANCE, 0},
{999, 1084378658u, 0u, 1065351897u, 0, TANHF_TOLERANCE, 0},
{1000, 3053887750u, 4294922339u, 3053887750u, 0, TANHF_TOLERANCE, 0},
{1001, 3022828828u, 0u, 3022828828u, 0, TANHF_TOLERANCE, 0},
{1002, 1226473697u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{1003, 1123114742u, 841711u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{1004, 1258114435u, 130141336u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{1005, 3468040845u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{1006, 1178825761u, 54u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{1007, 3059266302u, 0u, 3059266302u, 0, TANHF_TOLERANCE, 0},
{1008, 3223384012u, 225u, 3212618726u, 0, TANHF_TOLERANCE, 0},
{1009, 1019964626u, 1299605u, 1019961886u, 0, TANHF_TOLERANCE, 0},
{1010, 3445262427u, 3129568512u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{1011, 1125653081u, 129823u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{1012, 3337652712u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{1013, 1184753508u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{1014, 996404791u, 4294853343u, 996404731u, 0, TANHF_TOLERANCE, 0},
{1015, 1188439315u, 55u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{1016, 906557513u, 0u, 906557513u, 0, TANHF_TOLERANCE, 0},
{1017, 916831283u, 0u, 916831283u, 0, TANHF_TOLERANCE, 0},
{1018, 996786317u, 0u, 996786252u, 0, TANHF_TOLERANCE, 0},
{1019, 3461635065u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{1020, 1188167943u, 74707u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{1021, 3036502395u, 7309u, 3036502395u, 0, TANHF_TOLERANCE, 0},
{1022, 891257783u, 18537700u, 891257783u, 0, TANHF_TOLERANCE, 0},
{1023, 3290079438u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{1024, 3350690327u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{1025, 1102061604u, 4253821380u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{1026, 1282351521u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{1027, 3458861065u, 4292002951u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{1028, 3095256878u, 0u, 3095256878u, 0, TANHF_TOLERANCE, 0},
{1029, 3163373610u, 0u, 3163372693u, 0, TANHF_TOLERANCE, 0},
{1030, 3228793330u, 0u, 3212820224u, 0, TANHF_TOLERANCE, 0},
{1031, 3422194733u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{1032, 3083885296u, 0u, 3083885296u, 0, TANHF_TOLERANCE, 0},
{1033, 1261940623u, 4288291120u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{1034, 3400603081u, 4294967290u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{1035, 1219411812u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{1036, 3094833770u, 0u, 3094833770u, 0, TANHF_TOLERANCE, 0},
{1037, 3139250800u, 0u, 3139250780u, 0, TANHF_TOLERANCE, 0},
{1038, 886201503u, 4294967150u, 886201503u, 0, TANHF_TOLERANCE, 0},
{1039, 3297366026u, 7u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{1040, 1218488455u, 4294964141u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{1041, 3040358923u, 0u, 3040358923u, 0, TANHF_TOLERANCE, 0},
{1042, 1283938137u, 53086u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{1043, 3182551696u, 0u, 3182522467u, 0, TANHF_TOLERANCE, 0},
{1044, 1317098613u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{1045, 3116209179u, 4294965434u, 3116209178u, 0, TANHF_TOLERANCE, 0},
{1046, 3431703657u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{1047, 3239728775u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{1048, 3207141672u, 0u, 3205769004u, 0, TANHF_TOLERANCE, 0},
{1049, 3154378805u, 0u, 3154378618u, 0, TANHF_TOLERANCE, 0},
{1050, 3069658155u, 0u, 3069658155u, 0, TANHF_TOLERANCE, 0},
{1051, 3313160088u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{1052, 3207056527u, 4293469023u, 3205712210u, 0, TANHF_TOLERANCE, 0},
{1053, 1284174954u, 4180334232u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{1054, 3156081645u, 4294964338u, 3156081324u, 0, TANHF_TOLERANCE, 0},
{1055, 1063693032u, 0u, 1060602017u, 0, TANHF_TOLERANCE, 0},
{1056, 3036026175u, 4845007u, 3036026175u, 0, TANHF_TOLERANCE, 0},
{1057, 1102631663u, 4290881696u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{1058, 968803479u, 0u, 968803478u, 0, TANHF_TOLERANCE, 0},
{1059, 3273080388u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{1060, 1172529774u, 4294966405u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{1061, 1306695905u, 147733664u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{1062, 1003649752u, 338518u, 1003649562u, 0, TANHF_TOLERANCE, 0},
{1063, 1078478376u, 2364151808u, 1065289116u, 0, TANHF_TOLERANCE, 0},
{1064, 3158855023u, 0u, 3158854369u, 0, TANHF_TOLERANCE, 0},
{1065, 1165177679u, 4294967097u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{1066, 3403009513u, 4293749042u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{1067, 952348506u, 4294108410u, 952348506u, 0, TANHF_TOLERANCE, 0},
{1068, 1222777442u, 153u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{1069, 1325324763u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{1070, 3363524213u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{1071, 1158950321u, 1u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{1072, 903129873u, 4272788450u, 903129873u, 0, TANHF_TOLERANCE, 0},
{1073, 3078339944u, 0u, 3078339944u, 0, TANHF_TOLERANCE, 0},
{1074, 1208345407u, 6333643u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{1075, 1258634105u, 3575206u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{1076, 1248478509u, 102613680u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{1077, 1153863988u, 4229464460u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{1078, 1235620969u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{1079, 1097120930u, 4294967294u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{1080, 3469778622u, 70286u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{1081, 1147712200u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{1082, 1124721745u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{1083, 3261744304u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{1084, 1064922416u, 1518435840u, 1061168937u, 0, TANHF_TOLERANCE, 0},
{1085, 3303160152u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{1086, 1315090496u, 4294967183u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{1087, 3230403187u, 1820050432u, 3212831561u, 0, TANHF_TOLERANCE, 0},
{1088, 1335399673u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{1089, 1072458508u, 4294404660u, 1064538920u, 0, TANHF_TOLERANCE, 0},
{1090, 3303015249u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{1091, 3252139741u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{1092, 3468519966u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{1093, 1006231203u, 0u, 1006230886u, 0, TANHF_TOLERANCE, 0},
{1094, 951554138u, 0u, 951554138u, 0, TANHF_TOLERANCE, 0},
{1095, 942046828u, 0u, 942046828u, 0, TANHF_TOLERANCE, 0},
{1096, 3319723279u, 4277552160u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{1097, 3255104167u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{1098, 1155477903u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{1099, 3273889176u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{1100, 3237813668u, 4133749200u, 3212836859u, 0, TANHF_TOLERANCE, 0},
{1101, 1228207362u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{1102, 975349337u, 748694784u, 975349336u, 0, TANHF_TOLERANCE, 0},
{1103, 1290175785u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{1104, 981908840u, 4294962938u, 981908837u, 0, TANHF_TOLERANCE, 0},
{1105, 941187647u, 33u, 941187647u, 0, TANHF_TOLERANCE, 0},
{1106, 1214223128u, 4294967293u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{1107, 3422922584u, 6u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{1108, 1315857601u, 1055172096u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{1109, 3453226030u, 4294967291u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{1110, 1078359574u, 0u, 1065285387u, 0, TANHF_TOLERANCE, 0},
{1111, 1029557624u, 4294965511u, 1029543432u, 0, TANHF_TOLERANCE, 0},
{1112, 1207675424u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{1113, 1028355074u, 4113313408u, 1028344119u, 0, TANHF_TOLERANCE, 0},
{1114, 3119299090u, 24787u, 3119299089u, 0, TANHF_TOLERANCE, 0},
{1115, 1248421894u, 4294582111u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{1116, 3353251994u, 12u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{1117, 876926659u, 4294966792u, 876926659u, 0, TANHF_TOLERANCE, 0},
{1118, 1076752219u, 0u, 1065207581u, 0, TANHF_TOLERANCE, 0},
{1119, 3388531942u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{1120, 1273395082u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{1121, 3385588183u, 4294967251u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{1122, 3192315328u, 4294966714u, 3192153914u, 0, TANHF_TOLERANCE, 0},
{1123, 3441804648u, 4294967121u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{1124, 3392827417u, 45125368u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{1125, 1161241793u, 2814016256u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{1126, 3034494183u, 0u, 3034494183u, 0, TANHF_TOLERANCE, 0},
{1127, 1171318485u, 4294306215u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{1128, 3047748143u, 0u, 3047748143u, 0, TANHF_TOLERANCE, 0},
{1129, 1001216371u, 0u, 1001216265u, 0, TANHF_TOLERANCE, 0},
{1130, 912515889u, 2u, 912515889u, 0, TANHF_TOLERANCE, 0},
{1131, 3391452505u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{1132, 3249603369u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{1133, 1220264047u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{1134, 3169816394u, 0u, 3169811920u, 0, TANHF_TOLERANCE, 0},
{1135, 3098997418u, 0u, 3098997418u, 0, TANHF_TOLERANCE, 0},
{1136, 3282212423u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{1137, 3352293320u, 4294967278u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{1138, 3296358441u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{1139, 1197828352u, 4294967281u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{1140, 3340510371u, 0u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{1141, 1127109339u, 4294570975u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{1142, 909467381u, 1001724u, 909467381u, 0, TANHF_TOLERANCE, 0},
{1143, 1200599955u, 0u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{1144, 962230977u, 0u, 962230977u, 0, TANHF_TOLERANCE, 0},
{1145, 3192887808u, 0u, 3192704420u, 0, TANHF_TOLERANCE, 0},
{1146, 3237183876u, 0u, 3212836856u, 0, TANHF_TOLERANCE, 0},
{1147, 939285924u, 0u, 939285924u, 0, TANHF_TOLERANCE, 0},
{1148, 944050180u, 3871652128u, 944050180u, 0, TANHF_TOLERANCE, 0},
{1149, 3058135703u, 0u, 3058135703u, 0, TANHF_TOLERANCE, 0},
{1150, 3480592662u, 4294967238u, 3212836864u, 0, TANHF_TOLERANCE, 0},
{1151, 3061939312u, 4294967125u, 3061939312u, 0, TANHF_TOLERANCE, 0},
{1152, 1003299981u, 0u, 1003299805u, 0, TANHF_TOLERANCE, 0},
{1153, 1155775526u, 7150230u, 1065353216u, 0, TANHF_TOLERANCE, 0},
{1154, 1234491880u, 4283784819u, 1065353216u, 0, TANHF_TOLERANCE, 0}

// AUTOMATICALLY GENERATED VECTORS STOP

};

#endif // CYGONCE_LIBM_SCABNF_H multiple inclusion protection

// EOF tanhf.h
