#ifndef CYGONCE_LIBM_SCABNF_H
#define CYGONCE_LIBM_SCABNF_H
//===========================================================================
//
//      tanf.h
//
//      Test vectors for testing of tanf() math library function
//
//===========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####
// -------------------------------------------
// This file is part of eCos, the Embedded Configurable Operating System.
// Copyright (C) 2012 Free Software Foundation, Inc.
//
// eCos is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 or (at your option) any later
// version.
//
// eCos is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
// for more details.
//
// You should have received a copy of the GNU General Public License
// along with eCos; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//
// As a special exception, if other files instantiate templates or use
// macros or inline functions from this file, or you compile this file
// and link it with other works to produce a work based on this file,
// this file does not by itself cause the resulting work to be covered by
// the GNU General Public License. However the source code for this file
// must still be made available in accordance with section (3) of the GNU
// General Public License v2.
//
// This exception does not invalidate any other reasons why a work based
// on this file might be covered by the GNU General Public License.
// -------------------------------------------
// ####ECOSGPLCOPYRIGHTEND####
//===========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):
// Contributors:  visar, ilijak
// Date:        1998-02-13
// Purpose:
// Description:
// Usage:       #include "vectors/tanf.h"
//
//####DESCRIPTIONEND####
//
//===========================================================================


// CONFIGURATION

#include <pkgconf/libm.h>   // Configuration header


// INCLUDES

#include <cyg/infra/cyg_type.h>    // Common type definitions and support
#include "vectors/vector_support_float.h"// extra support for math tests

#define TANF_TOLERANCE 1.0E-04

static const Cyg_libm_test_float_vec_t tanf_vec[] = {

// AUTOMATICALLY GENERATED VECTORS START

{0, 3214514586u, 0u, 3223625251u, 0, TANF_TOLERANCE, 0},
{1, 3214430700u, 0u, 3223313815u, 0, TANF_TOLERANCE, 0},
{2, 3214346813u, 0u, 3223017555u, 0, TANF_TOLERANCE, 0},
{3, 3214262927u, 0u, 3222735341u, 0, TANF_TOLERANCE, 0},
{4, 3214179041u, 0u, 3222466140u, 0, TANF_TOLERANCE, 0},
{5, 3214095155u, 0u, 3222209023u, 0, TANF_TOLERANCE, 0},
{6, 3214011269u, 0u, 3221963145u, 0, TANF_TOLERANCE, 0},
{7, 3213927383u, 0u, 3221727740u, 0, TANF_TOLERANCE, 0},
{8, 3213843497u, 0u, 3221502108u, 0, TANF_TOLERANCE, 0},
{9, 3213759611u, 0u, 3221285611u, 0, TANF_TOLERANCE, 0},
{10, 3213675725u, 0u, 3220929855u, 0, TANF_TOLERANCE, 0},
{11, 3213591839u, 0u, 3220529989u, 0, TANF_TOLERANCE, 0},
{12, 3213507953u, 0u, 3220145165u, 0, TANF_TOLERANCE, 0},
{13, 3213424067u, 0u, 3219774482u, 0, TANF_TOLERANCE, 0},
{14, 3213340180u, 0u, 3219417095u, 0, TANF_TOLERANCE, 0},
{15, 3213256294u, 0u, 3219072244u, 0, TANF_TOLERANCE, 0},
{16, 3213172408u, 0u, 3218739210u, 0, TANF_TOLERANCE, 0},
{17, 3213088522u, 0u, 3218417335u, 0, TANF_TOLERANCE, 0},
{18, 3213004636u, 0u, 3218106004u, 0, TANF_TOLERANCE, 0},
{19, 3212920750u, 0u, 3217804648u, 0, TANF_TOLERANCE, 0},
{20, 3212836864u, 0u, 3217512739u, 0, TANF_TOLERANCE, 0},
{21, 3212669092u, 0u, 3217229784u, 0, TANF_TOLERANCE, 0},
{22, 3212501320u, 0u, 3216955321u, 0, TANF_TOLERANCE, 0},
{23, 3212333548u, 0u, 3216688923u, 0, TANF_TOLERANCE, 0},
{24, 3212165775u, 0u, 3216430186u, 0, TANF_TOLERANCE, 0},
{25, 3211998003u, 0u, 3216178740u, 0, TANF_TOLERANCE, 0},
{26, 3211830231u, 0u, 3215934228u, 0, TANF_TOLERANCE, 0},
{27, 3211662459u, 0u, 3215696321u, 0, TANF_TOLERANCE, 0},
{28, 3211494687u, 0u, 3215464711u, 0, TANF_TOLERANCE, 0},
{29, 3211326915u, 0u, 3215239105u, 0, TANF_TOLERANCE, 0},
{30, 3211159142u, 0u, 3215019230u, 0, TANF_TOLERANCE, 0},
{31, 3210991370u, 0u, 3214804827u, 0, TANF_TOLERANCE, 0},
{32, 3210823598u, 0u, 3214595654u, 0, TANF_TOLERANCE, 0},
{33, 3210655826u, 0u, 3214391483u, 0, TANF_TOLERANCE, 0},
{34, 3210488054u, 0u, 3214192094u, 0, TANF_TOLERANCE, 0},
{35, 3210320282u, 0u, 3213997284u, 0, TANF_TOLERANCE, 0},
{36, 3210152509u, 0u, 3213806858u, 0, TANF_TOLERANCE, 0},
{37, 3209984737u, 0u, 3213620637u, 0, TANF_TOLERANCE, 0},
{38, 3209816965u, 0u, 3213438442u, 0, TANF_TOLERANCE, 0},
{39, 3209649193u, 0u, 3213260113u, 0, TANF_TOLERANCE, 0},
{40, 3209481421u, 0u, 3213085491u, 0, TANF_TOLERANCE, 0},
{41, 3209313649u, 0u, 3212914427u, 0, TANF_TOLERANCE, 0},
{42, 3209145876u, 0u, 3212656702u, 0, TANF_TOLERANCE, 0},
{43, 3208978104u, 0u, 3212327983u, 0, TANF_TOLERANCE, 0},
{44, 3208810332u, 0u, 3212005577u, 0, TANF_TOLERANCE, 0},
{45, 3208642560u, 0u, 3211689243u, 0, TANF_TOLERANCE, 0},
{46, 3208474788u, 0u, 3211378749u, 0, TANF_TOLERANCE, 0},
{47, 3208307016u, 0u, 3211073873u, 0, TANF_TOLERANCE, 0},
{48, 3208139244u, 0u, 3210774407u, 0, TANF_TOLERANCE, 0},
{49, 3207971471u, 0u, 3210480145u, 0, TANF_TOLERANCE, 0},
{50, 3207803699u, 0u, 3210190902u, 0, TANF_TOLERANCE, 0},
{51, 3207635927u, 0u, 3209906490u, 0, TANF_TOLERANCE, 0},
{52, 3207468155u, 0u, 3209626734u, 0, TANF_TOLERANCE, 0},
{53, 3207300383u, 0u, 3209351468u, 0, TANF_TOLERANCE, 0},
{54, 3207132611u, 0u, 3209080528u, 0, TANF_TOLERANCE, 0},
{55, 3206964838u, 0u, 3208813761u, 0, TANF_TOLERANCE, 0},
{56, 3206797066u, 0u, 3208551021u, 0, TANF_TOLERANCE, 0},
{57, 3206629294u, 0u, 3208292164u, 0, TANF_TOLERANCE, 0},
{58, 3206461522u, 0u, 3208037053u, 0, TANF_TOLERANCE, 0},
{59, 3206293750u, 0u, 3207785562u, 0, TANF_TOLERANCE, 0},
{60, 3206125978u, 0u, 3207537560u, 0, TANF_TOLERANCE, 0},
{61, 3205958205u, 0u, 3207292928u, 0, TANF_TOLERANCE, 0},
{62, 3205790433u, 0u, 3207051550u, 0, TANF_TOLERANCE, 0},
{63, 3205622661u, 0u, 3206813316u, 0, TANF_TOLERANCE, 0},
{64, 3205454889u, 0u, 3206578116u, 0, TANF_TOLERANCE, 0},
{65, 3205287117u, 0u, 3206345847u, 0, TANF_TOLERANCE, 0},
{66, 3205119345u, 0u, 3206116409u, 0, TANF_TOLERANCE, 0},
{67, 3204951572u, 0u, 3205889704u, 0, TANF_TOLERANCE, 0},
{68, 3204783800u, 0u, 3205665640u, 0, TANF_TOLERANCE, 0},
{69, 3204616028u, 0u, 3205444129u, 0, TANF_TOLERANCE, 0},
{70, 3204448256u, 0u, 3205225083u, 0, TANF_TOLERANCE, 0},
{71, 3204112712u, 0u, 3205008416u, 0, TANF_TOLERANCE, 0},
{72, 3203777167u, 0u, 3204794048u, 0, TANF_TOLERANCE, 0},
{73, 3203441623u, 0u, 3204581902u, 0, TANF_TOLERANCE, 0},
{74, 3203106079u, 0u, 3204295542u, 0, TANF_TOLERANCE, 0},
{75, 3202770534u, 0u, 3203879679u, 0, TANF_TOLERANCE, 0},
{76, 3202434990u, 0u, 3203467813u, 0, TANF_TOLERANCE, 0},
{77, 3202099446u, 0u, 3203059808u, 0, TANF_TOLERANCE, 0},
{78, 3201763901u, 0u, 3202655528u, 0, TANF_TOLERANCE, 0},
{79, 3201428357u, 0u, 3202254843u, 0, TANF_TOLERANCE, 0},
{80, 3201092813u, 0u, 3201857626u, 0, TANF_TOLERANCE, 0},
{81, 3200757268u, 0u, 3201463754u, 0, TANF_TOLERANCE, 0},
{82, 3200421724u, 0u, 3201073106u, 0, TANF_TOLERANCE, 0},
{83, 3200086180u, 0u, 3200685568u, 0, TANF_TOLERANCE, 0},
{84, 3199750636u, 0u, 3200301024u, 0, TANF_TOLERANCE, 0},
{85, 3199415091u, 0u, 3199919364u, 0, TANF_TOLERANCE, 0},
{86, 3199079547u, 0u, 3199540480u, 0, TANF_TOLERANCE, 0},
{87, 3198744003u, 0u, 3199164268u, 0, TANF_TOLERANCE, 0},
{88, 3198408458u, 0u, 3198790623u, 0, TANF_TOLERANCE, 0},
{89, 3198072914u, 0u, 3198419447u, 0, TANF_TOLERANCE, 0},
{90, 3197737370u, 0u, 3198050643u, 0, TANF_TOLERANCE, 0},
{91, 3197401825u, 0u, 3197684111u, 0, TANF_TOLERANCE, 0},
{92, 3197066281u, 0u, 3197319762u, 0, TANF_TOLERANCE, 0},
{93, 3196730737u, 0u, 3196957502u, 0, TANF_TOLERANCE, 0},
{94, 3196395192u, 0u, 3196597241u, 0, TANF_TOLERANCE, 0},
{95, 3196059648u, 0u, 3196238893u, 0, TANF_TOLERANCE, 0},
{96, 3195388559u, 0u, 3195705092u, 0, TANF_TOLERANCE, 0},
{97, 3194717471u, 0u, 3194995527u, 0, TANF_TOLERANCE, 0},
{98, 3194046382u, 0u, 3194289277u, 0, TANF_TOLERANCE, 0},
{99, 3193375293u, 0u, 3193586179u, 0, TANF_TOLERANCE, 0},
{100, 3192704205u, 0u, 3192886073u, 0, TANF_TOLERANCE, 0},
{101, 3192033116u, 0u, 3192188798u, 0, TANF_TOLERANCE, 0},
{102, 3191362028u, 0u, 3191494201u, 0, TANF_TOLERANCE, 0},
{103, 3190690939u, 0u, 3190802126u, 0, TANF_TOLERANCE, 0},
{104, 3190019850u, 0u, 3190112424u, 0, TANF_TOLERANCE, 0},
{105, 3189348762u, 0u, 3189424945u, 0, TANF_TOLERANCE, 0},
{106, 3188677673u, 0u, 3188739540u, 0, TANF_TOLERANCE, 0},
{107, 3188006584u, 0u, 3188056065u, 0, TANF_TOLERANCE, 0},
{108, 3186999951u, 0u, 3187077709u, 0, TANF_TOLERANCE, 0},
{109, 3185657774u, 0u, 3185717611u, 0, TANF_TOLERANCE, 0},
{110, 3184315597u, 0u, 3184360516u, 0, TANF_TOLERANCE, 0},
{111, 3182973420u, 0u, 3183006141u, 0, TANF_TOLERANCE, 0},
{112, 3181631242u, 0u, 3181654207u, 0, TANF_TOLERANCE, 0},
{113, 3180289065u, 0u, 3180304441u, 0, TANF_TOLERANCE, 0},
{114, 3178611343u, 0u, 3178630698u, 0, TANF_TOLERANCE, 0},
{115, 3175926989u, 0u, 3175938185u, 0, TANF_TOLERANCE, 0},
{116, 3173242634u, 0u, 3173248365u, 0, TANF_TOLERANCE, 0},
{117, 3170222735u, 0u, 3170227569u, 0, TANF_TOLERANCE, 0},
{118, 3164854026u, 0u, 3164855458u, 0, TANF_TOLERANCE, 0},
{119, 3156465418u, 0u, 3156465776u, 0, TANF_TOLERANCE, 0},
{120, 1008981770u, 0u, 1008982128u, 0, TANF_TOLERANCE, 0},
{121, 1017370378u, 0u, 1017371810u, 0, TANF_TOLERANCE, 0},
{122, 1022739087u, 0u, 1022743921u, 0, TANF_TOLERANCE, 0},
{123, 1025758986u, 0u, 1025764717u, 0, TANF_TOLERANCE, 0},
{124, 1028443341u, 0u, 1028454537u, 0, TANF_TOLERANCE, 0},
{125, 1031127695u, 0u, 1031147050u, 0, TANF_TOLERANCE, 0},
{126, 1032805417u, 0u, 1032820793u, 0, TANF_TOLERANCE, 0},
{127, 1034147594u, 0u, 1034170559u, 0, TANF_TOLERANCE, 0},
{128, 1035489772u, 0u, 1035522493u, 0, TANF_TOLERANCE, 0},
{129, 1036831949u, 0u, 1036876868u, 0, TANF_TOLERANCE, 0},
{130, 1038174126u, 0u, 1038233963u, 0, TANF_TOLERANCE, 0},
{131, 1039516303u, 0u, 1039594061u, 0, TANF_TOLERANCE, 0},
{132, 1040522936u, 0u, 1040572417u, 0, TANF_TOLERANCE, 0},
{133, 1041194025u, 0u, 1041255892u, 0, TANF_TOLERANCE, 0},
{134, 1041865114u, 0u, 1041941297u, 0, TANF_TOLERANCE, 0},
{135, 1042536202u, 0u, 1042628776u, 0, TANF_TOLERANCE, 0},
{136, 1043207291u, 0u, 1043318478u, 0, TANF_TOLERANCE, 0},
{137, 1043878380u, 0u, 1044010553u, 0, TANF_TOLERANCE, 0},
{138, 1044549468u, 0u, 1044705150u, 0, TANF_TOLERANCE, 0},
{139, 1045220557u, 0u, 1045402425u, 0, TANF_TOLERANCE, 0},
{140, 1045891645u, 0u, 1046102531u, 0, TANF_TOLERANCE, 0},
{141, 1046562734u, 0u, 1046805629u, 0, TANF_TOLERANCE, 0},
{142, 1047233823u, 0u, 1047511879u, 0, TANF_TOLERANCE, 0},
{143, 1047904911u, 0u, 1048221444u, 0, TANF_TOLERANCE, 0},
{144, 1048576000u, 0u, 1048755245u, 0, TANF_TOLERANCE, 0},
{145, 1048911544u, 0u, 1049113593u, 0, TANF_TOLERANCE, 0},
{146, 1049247089u, 0u, 1049473854u, 0, TANF_TOLERANCE, 0},
{147, 1049582633u, 0u, 1049836114u, 0, TANF_TOLERANCE, 0},
{148, 1049918177u, 0u, 1050200463u, 0, TANF_TOLERANCE, 0},
{149, 1050253722u, 0u, 1050566995u, 0, TANF_TOLERANCE, 0},
{150, 1050589266u, 0u, 1050935799u, 0, TANF_TOLERANCE, 0},
{151, 1050924810u, 0u, 1051306975u, 0, TANF_TOLERANCE, 0},
{152, 1051260355u, 0u, 1051680620u, 0, TANF_TOLERANCE, 0},
{153, 1051595899u, 0u, 1052056832u, 0, TANF_TOLERANCE, 0},
{154, 1051931443u, 0u, 1052435716u, 0, TANF_TOLERANCE, 0},
{155, 1052266988u, 0u, 1052817376u, 0, TANF_TOLERANCE, 0},
{156, 1052602532u, 0u, 1053201920u, 0, TANF_TOLERANCE, 0},
{157, 1052938076u, 0u, 1053589458u, 0, TANF_TOLERANCE, 0},
{158, 1053273620u, 0u, 1053980106u, 0, TANF_TOLERANCE, 0},
{159, 1053609165u, 0u, 1054373978u, 0, TANF_TOLERANCE, 0},
{160, 1053944709u, 0u, 1054771195u, 0, TANF_TOLERANCE, 0},
{161, 1054280253u, 0u, 1055171880u, 0, TANF_TOLERANCE, 0},
{162, 1054615798u, 0u, 1055576160u, 0, TANF_TOLERANCE, 0},
{163, 1054951342u, 0u, 1055984165u, 0, TANF_TOLERANCE, 0},
{164, 1055286886u, 0u, 1056396031u, 0, TANF_TOLERANCE, 0},
{165, 1055622431u, 0u, 1056811894u, 0, TANF_TOLERANCE, 0},
{166, 1055957975u, 0u, 1057098254u, 0, TANF_TOLERANCE, 0},
{167, 1056293519u, 0u, 1057310400u, 0, TANF_TOLERANCE, 0},
{168, 1056629064u, 0u, 1057524768u, 0, TANF_TOLERANCE, 0},
{169, 1056964608u, 0u, 1057741435u, 0, TANF_TOLERANCE, 0},
{170, 1057132380u, 0u, 1057960481u, 0, TANF_TOLERANCE, 0},
{171, 1057300152u, 0u, 1058181992u, 0, TANF_TOLERANCE, 0},
{172, 1057467924u, 0u, 1058406056u, 0, TANF_TOLERANCE, 0},
{173, 1057635697u, 0u, 1058632761u, 0, TANF_TOLERANCE, 0},
{174, 1057803469u, 0u, 1058862199u, 0, TANF_TOLERANCE, 0},
{175, 1057971241u, 0u, 1059094468u, 0, TANF_TOLERANCE, 0},
{176, 1058139013u, 0u, 1059329668u, 0, TANF_TOLERANCE, 0},
{177, 1058306785u, 0u, 1059567902u, 0, TANF_TOLERANCE, 0},
{178, 1058474557u, 0u, 1059809280u, 0, TANF_TOLERANCE, 0},
{179, 1058642330u, 0u, 1060053912u, 0, TANF_TOLERANCE, 0},
{180, 1058810102u, 0u, 1060301914u, 0, TANF_TOLERANCE, 0},
{181, 1058977874u, 0u, 1060553405u, 0, TANF_TOLERANCE, 0},
{182, 1059145646u, 0u, 1060808516u, 0, TANF_TOLERANCE, 0},
{183, 1059313418u, 0u, 1061067373u, 0, TANF_TOLERANCE, 0},
{184, 1059481190u, 0u, 1061330113u, 0, TANF_TOLERANCE, 0},
{185, 1059648963u, 0u, 1061596880u, 0, TANF_TOLERANCE, 0},
{186, 1059816735u, 0u, 1061867820u, 0, TANF_TOLERANCE, 0},
{187, 1059984507u, 0u, 1062143086u, 0, TANF_TOLERANCE, 0},
{188, 1060152279u, 0u, 1062422842u, 0, TANF_TOLERANCE, 0},
{189, 1060320051u, 0u, 1062707254u, 0, TANF_TOLERANCE, 0},
{190, 1060487823u, 0u, 1062996497u, 0, TANF_TOLERANCE, 0},
{191, 1060655596u, 0u, 1063290759u, 0, TANF_TOLERANCE, 0},
{192, 1060823368u, 0u, 1063590225u, 0, TANF_TOLERANCE, 0},
{193, 1060991140u, 0u, 1063895101u, 0, TANF_TOLERANCE, 0},
{194, 1061158912u, 0u, 1064205595u, 0, TANF_TOLERANCE, 0},
{195, 1061326684u, 0u, 1064521929u, 0, TANF_TOLERANCE, 0},
{196, 1061494456u, 0u, 1064844335u, 0, TANF_TOLERANCE, 0},
{197, 1061662228u, 0u, 1065173054u, 0, TANF_TOLERANCE, 0},
{198, 1061830001u, 0u, 1065430779u, 0, TANF_TOLERANCE, 0},
{199, 1061997773u, 0u, 1065601843u, 0, TANF_TOLERANCE, 0},
{200, 1062165545u, 0u, 1065776465u, 0, TANF_TOLERANCE, 0},
{201, 1062333317u, 0u, 1065954794u, 0, TANF_TOLERANCE, 0},
{202, 1062501089u, 0u, 1066136989u, 0, TANF_TOLERANCE, 0},
{203, 1062668861u, 0u, 1066323210u, 0, TANF_TOLERANCE, 0},
{204, 1062836634u, 0u, 1066513636u, 0, TANF_TOLERANCE, 0},
{205, 1063004406u, 0u, 1066708446u, 0, TANF_TOLERANCE, 0},
{206, 1063172178u, 0u, 1066907835u, 0, TANF_TOLERANCE, 0},
{207, 1063339950u, 0u, 1067112006u, 0, TANF_TOLERANCE, 0},
{208, 1063507722u, 0u, 1067321179u, 0, TANF_TOLERANCE, 0},
{209, 1063675494u, 0u, 1067535582u, 0, TANF_TOLERANCE, 0},
{210, 1063843267u, 0u, 1067755457u, 0, TANF_TOLERANCE, 0},
{211, 1064011039u, 0u, 1067981063u, 0, TANF_TOLERANCE, 0},
{212, 1064178811u, 0u, 1068212673u, 0, TANF_TOLERANCE, 0},
{213, 1064346583u, 0u, 1068450580u, 0, TANF_TOLERANCE, 0},
{214, 1064514355u, 0u, 1068695092u, 0, TANF_TOLERANCE, 0},
{215, 1064682127u, 0u, 1068946538u, 0, TANF_TOLERANCE, 0},
{216, 1064849900u, 0u, 1069205275u, 0, TANF_TOLERANCE, 0},
{217, 1065017672u, 0u, 1069471673u, 0, TANF_TOLERANCE, 0},
{218, 1065185444u, 0u, 1069746136u, 0, TANF_TOLERANCE, 0},
{219, 1065353216u, 0u, 1070029091u, 0, TANF_TOLERANCE, 0},
{220, 1065437102u, 0u, 1070321000u, 0, TANF_TOLERANCE, 0},
{221, 1065520988u, 0u, 1070622356u, 0, TANF_TOLERANCE, 0},
{222, 1065604874u, 0u, 1070933687u, 0, TANF_TOLERANCE, 0},
{223, 1065688760u, 0u, 1071255562u, 0, TANF_TOLERANCE, 0},
{224, 1065772646u, 0u, 1071588596u, 0, TANF_TOLERANCE, 0},
{225, 1065856532u, 0u, 1071933447u, 0, TANF_TOLERANCE, 0},
{226, 1065940419u, 0u, 1072290834u, 0, TANF_TOLERANCE, 0},
{227, 1066024305u, 0u, 1072661517u, 0, TANF_TOLERANCE, 0},
{228, 1066108191u, 0u, 1073046341u, 0, TANF_TOLERANCE, 0},
{229, 1066192077u, 0u, 1073446207u, 0, TANF_TOLERANCE, 0},
{230, 1066275963u, 0u, 1073801963u, 0, TANF_TOLERANCE, 0},
{231, 1066359849u, 0u, 1074018460u, 0, TANF_TOLERANCE, 0},
{232, 1066443735u, 0u, 1074244092u, 0, TANF_TOLERANCE, 0},
{233, 1066527621u, 0u, 1074479497u, 0, TANF_TOLERANCE, 0},
{234, 1066611507u, 0u, 1074725375u, 0, TANF_TOLERANCE, 0},
{235, 1066695393u, 0u, 1074982492u, 0, TANF_TOLERANCE, 0},
{236, 1066779279u, 0u, 1075251693u, 0, TANF_TOLERANCE, 0},
{237, 1066863165u, 0u, 1075533907u, 0, TANF_TOLERANCE, 0},
{238, 1066947052u, 0u, 1075830167u, 0, TANF_TOLERANCE, 0},
{239, 3234402267u, 0u, 3023813934u, 0, TANF_TOLERANCE, 0},
{240, 3231108068u, 0u, 1285550701u, 0, TANF_TOLERANCE, 0},
{241, 3217625051u, 0u, 1269729867u, 0, TANF_TOLERANCE, 0},
{242, 0u, 0u, 0u, 0, TANF_TOLERANCE, 0},
{243, 1070141403u, 0u, 3417213515u, 0, TANF_TOLERANCE, 0},
{244, 1083624420u, 0u, 3433034349u, 0, TANF_TOLERANCE, 0},
{245, 3253731328u, 0u, 1087174777u, 0, TANF_TOLERANCE, 0},
{246, 3252840038u, 0u, 3167898616u, 0, TANF_TOLERANCE, 0},
{247, 3251948749u, 0u, 3239705397u, 0, TANF_TOLERANCE, 0},
{248, 3251057459u, 0u, 1047706077u, 0, TANF_TOLERANCE, 0},
{249, 3250166170u, 0u, 3223914617u, 0, TANF_TOLERANCE, 0},
{250, 3249274880u, 0u, 1057549535u, 0, TANF_TOLERANCE, 0},
{251, 3248383590u, 0u, 3216189737u, 0, TANF_TOLERANCE, 0},
{252, 3247492301u, 0u, 1064191672u, 0, TANF_TOLERANCE, 0},
{253, 3246601011u, 0u, 3209964023u, 0, TANF_TOLERANCE, 0},
{254, 3245028147u, 0u, 1070260802u, 0, TANF_TOLERANCE, 0},
{255, 3243245568u, 0u, 3203207451u, 0, TANF_TOLERANCE, 0},
{256, 3241462989u, 0u, 1078702695u, 0, TANF_TOLERANCE, 0},
{257, 3239680410u, 0u, 3191163251u, 0, TANF_TOLERANCE, 0},
{258, 3237792973u, 0u, 1101903989u, 0, TANF_TOLERANCE, 0},
{259, 3234227814u, 0u, 1034600970u, 0, TANF_TOLERANCE, 0},
{260, 3230662656u, 0u, 3230950662u, 0, TANF_TOLERANCE, 0},
{261, 3224580915u, 0u, 1052116995u, 0, TANF_TOLERANCE, 0},
{262, 3213675725u, 0u, 3220929855u, 0, TANF_TOLERANCE, 0},
{263, 1058642330u, 0u, 1060053912u, 0, TANF_TOLERANCE, 0},
{264, 1075000115u, 0u, 3213836902u, 0, TANF_TOLERANCE, 0},
{265, 1082130432u, 0u, 1066677117u, 0, TANF_TOLERANCE, 0},
{266, 1085695590u, 0u, 3207128095u, 0, TANF_TOLERANCE, 0},
{267, 1089260749u, 0u, 1073948539u, 0, TANF_TOLERANCE, 0},
{268, 1091672474u, 0u, 3198968821u, 0, TANF_TOLERANCE, 0},
{269, 1093455053u, 0u, 1084327814u, 0, TANF_TOLERANCE, 0},
{270, 1095237632u, 0u, 3179815041u, 0, TANF_TOLERANCE, 0},
{271, 1097020211u, 0u, 3246280447u, 0, TANF_TOLERANCE, 0},
{272, 1098802790u, 0u, 1044846917u, 0, TANF_TOLERANCE, 0},
{273, 1099746509u, 0u, 3225441190u, 0, TANF_TOLERANCE, 0},
{274, 1100637798u, 0u, 1056414381u, 0, TANF_TOLERANCE, 0},
{275, 1101529088u, 0u, 3217261841u, 0, TANF_TOLERANCE, 0},
{276, 1102420378u, 0u, 1062963047u, 0, TANF_TOLERANCE, 0},
{277, 1103311667u, 0u, 3211156910u, 0, TANF_TOLERANCE, 0},
{278, 1104202957u, 0u, 1069133612u, 0, TANF_TOLERANCE, 0},
{279, 1105094246u, 0u, 3204673592u, 0, TANF_TOLERANCE, 0},
{280, 1105985536u, 0u, 1077019629u, 0, TANF_TOLERANCE, 0},
{281, 1107800421u, 100135u, 3208402548u, 0, TANF_TOLERANCE, 0},
{282, 3196650934u, 0u, 3196871643u, 0, TANF_TOLERANCE, 0},
{283, 3368700125u, 4294964487u, 3194614723u, 0, TANF_TOLERANCE, 0},
{284, 1224242132u, 0u, 3206830634u, 0, TANF_TOLERANCE, 0},
{285, 3221027117u, 73066312u, 1075121948u, 0, TANF_TOLERANCE, 0},
{286, 1198712763u, 0u, 3216291424u, 0, TANF_TOLERANCE, 0},
{287, 3159309973u, 0u, 3159310697u, 0, TANF_TOLERANCE, 0},
{288, 954173073u, 0u, 954173073u, 0, TANF_TOLERANCE, 0},
{289, 3090780435u, 0u, 3090780435u, 0, TANF_TOLERANCE, 0},
{290, 966554515u, 4294967290u, 966554515u, 0, TANF_TOLERANCE, 0},
{291, 1312607135u, 47678u, 1057104214u, 0, TANF_TOLERANCE, 0},
{292, 1166191415u, 0u, 3178082920u, 0, TANF_TOLERANCE, 0},
{293, 3111900019u, 225u, 3111900019u, 0, TANF_TOLERANCE, 0},
{294, 1234419246u, 0u, 3232454771u, 0, TANF_TOLERANCE, 0},
{295, 1302107128u, 4294492157u, 3186679693u, 0, TANF_TOLERANCE, 0},
{296, 1052801068u, 0u, 1053430852u, 0, TANF_TOLERANCE, 0},
{297, 1060849628u, 0u, 1063637583u, 0, TANF_TOLERANCE, 0},
{298, 3484320003u, 0u, 3201724532u, 0, TANF_TOLERANCE, 0},
{299, 3181522772u, 4294965180u, 3181545047u, 0, TANF_TOLERANCE, 0},
{300, 882596369u, 7581303u, 882596369u, 0, TANF_TOLERANCE, 0},
{301, 1167223673u, 0u, 1081686688u, 0, TANF_TOLERANCE, 0},
{302, 968192794u, 0u, 968192794u, 0, TANF_TOLERANCE, 0},
{303, 3122346862u, 48u, 3122346863u, 0, TANF_TOLERANCE, 0},
{304, 1052361612u, 53381624u, 1052925522u, 0, TANF_TOLERANCE, 0},
{305, 906701409u, 0u, 906701409u, 0, TANF_TOLERANCE, 0},
{306, 3471653172u, 1621u, 1100734332u, 0, TANF_TOLERANCE, 0},
{307, 3231467496u, 0u, 1085858016u, 0, TANF_TOLERANCE, 0},
{308, 1341514497u, 3022046720u, 1049131149u, 0, TANF_TOLERANCE, 0},
{309, 1272351391u, 4294363968u, 3226645714u, 0, TANF_TOLERANCE, 0},
{310, 3319724992u, 4294842689u, 3215280037u, 0, TANF_TOLERANCE, 0},
{311, 917622040u, 603040256u, 917622040u, 0, TANF_TOLERANCE, 0},
{312, 940236348u, 4294965375u, 940236348u, 0, TANF_TOLERANCE, 0},
{313, 3251541546u, 0u, 3209922887u, 0, TANF_TOLERANCE, 0},
{314, 3099843889u, 4294828114u, 3099843889u, 0, TANF_TOLERANCE, 0},
{315, 3110358400u, 0u, 3110358400u, 0, TANF_TOLERANCE, 0},
{316, 3371863479u, 0u, 1091463657u, 0, TANF_TOLERANCE, 0},
{317, 3204069187u, 0u, 3204980482u, 0, TANF_TOLERANCE, 0},
{318, 1306460502u, 0u, 1078444858u, 0, TANF_TOLERANCE, 0},
{319, 1197542187u, 0u, 1061116656u, 0, TANF_TOLERANCE, 0},
{320, 922888249u, 467u, 922888249u, 0, TANF_TOLERANCE, 0},
{321, 1184239996u, 4294967294u, 1071410775u, 0, TANF_TOLERANCE, 0},
{322, 1252490238u, 7808u, 1048885026u, 0, TANF_TOLERANCE, 0},
{323, 1001673627u, 3340510784u, 1001673746u, 0, TANF_TOLERANCE, 0},
{324, 976098044u, 1357u, 976098046u, 0, TANF_TOLERANCE, 0},
{325, 941796645u, 0u, 941796645u, 0, TANF_TOLERANCE, 0},
{326, 3287199470u, 0u, 1042315374u, 0, TANF_TOLERANCE, 0},
{327, 893184329u, 2485427u, 893184329u, 0, TANF_TOLERANCE, 0},
{328, 1143233714u, 0u, 1066620219u, 0, TANF_TOLERANCE, 0},
{329, 1139941253u, 929u, 1056024260u, 0, TANF_TOLERANCE, 0},
{330, 3143717025u, 4294967290u, 3143717083u, 0, TANF_TOLERANCE, 0},
{331, 3048866608u, 3978787488u, 3048866608u, 0, TANF_TOLERANCE, 0},
{332, 3240298487u, 0u, 3212155261u, 0, TANF_TOLERANCE, 0},
{333, 1288902137u, 0u, 1065679218u, 0, TANF_TOLERANCE, 0},
{334, 1333134799u, 2211432960u, 3219769977u, 0, TANF_TOLERANCE, 0},
{335, 1187847971u, 1157221888u, 1079294396u, 0, TANF_TOLERANCE, 0},
{336, 1038851706u, 2696359424u, 1038920197u, 0, TANF_TOLERANCE, 0},
{337, 3329354473u, 0u, 3216403250u, 0, TANF_TOLERANCE, 0},
{338, 3077218579u, 529671904u, 3077218579u, 0, TANF_TOLERANCE, 0},
{339, 1309289088u, 0u, 3214417687u, 0, TANF_TOLERANCE, 0},
{340, 3444653659u, 50272864u, 3215945259u, 0, TANF_TOLERANCE, 0},
{341, 3405585402u, 0u, 1079727474u, 0, TANF_TOLERANCE, 0},
{342, 3106647724u, 0u, 3106647724u, 0, TANF_TOLERANCE, 0},
{343, 1106778573u, 4294965325u, 3201989462u, 0, TANF_TOLERANCE, 0},
{344, 1140567947u, 0u, 1063190279u, 0, TANF_TOLERANCE, 0},
{345, 1238569473u, 0u, 3204992016u, 0, TANF_TOLERANCE, 0},
{346, 3154871957u, 39965012u, 3154872178u, 0, TANF_TOLERANCE, 0},
{347, 1261071232u, 15806u, 3241842703u, 0, TANF_TOLERANCE, 0},
{348, 1175011025u, 0u, 3192116290u, 0, TANF_TOLERANCE, 0},
{349, 1082692850u, 187658u, 1074166068u, 0, TANF_TOLERANCE, 0},
{350, 974547519u, 1563599616u, 974547520u, 0, TANF_TOLERANCE, 0},
{351, 3058097085u, 0u, 3058097085u, 0, TANF_TOLERANCE, 0},
{352, 3107252546u, 1u, 3107252546u, 0, TANF_TOLERANCE, 0},
{353, 3096032662u, 0u, 3096032662u, 0, TANF_TOLERANCE, 0},
{354, 3197942144u, 0u, 3198275438u, 0, TANF_TOLERANCE, 0},
{355, 3403348556u, 0u, 3257568817u, 0, TANF_TOLERANCE, 0},
{356, 3182301130u, 3460013312u, 3182328676u, 0, TANF_TOLERANCE, 0},
{357, 1136411063u, 82u, 3204745512u, 0, TANF_TOLERANCE, 0},
{358, 3239231622u, 4294965540u, 1048854506u, 0, TANF_TOLERANCE, 0},
{359, 3340615780u, 0u, 1065270832u, 0, TANF_TOLERANCE, 0},
{360, 998567360u, 0u, 998567408u, 0, TANF_TOLERANCE, 0},
{361, 3417964312u, 1627479168u, 1061011657u, 0, TANF_TOLERANCE, 0},
{362, 3109481038u, 695u, 3109481038u, 0, TANF_TOLERANCE, 0},
{363, 1148867223u, 7486109u, 3214546003u, 0, TANF_TOLERANCE, 0},
{364, 989687421u, 4294414202u, 989687442u, 0, TANF_TOLERANCE, 0},
{365, 1152956913u, 0u, 1078507001u, 0, TANF_TOLERANCE, 0},
{366, 892922651u, 4294392467u, 892922651u, 0, TANF_TOLERANCE, 0},
{367, 1109627625u, 891137088u, 1029198039u, 0, TANF_TOLERANCE, 0},
{368, 1307091856u, 24u, 1084288813u, 0, TANF_TOLERANCE, 0},
{369, 1077234132u, 4294967159u, 3198381040u, 0, TANF_TOLERANCE, 0},
{370, 1142167709u, 13u, 3231878889u, 0, TANF_TOLERANCE, 0},
{371, 3426232834u, 0u, 3220906277u, 0, TANF_TOLERANCE, 0},
{372, 3368566779u, 0u, 1072891723u, 0, TANF_TOLERANCE, 0},
{373, 3030724760u, 4294886457u, 3030724760u, 0, TANF_TOLERANCE, 0},
{374, 1138741813u, 0u, 1105617478u, 0, TANF_TOLERANCE, 0},
{375, 982950501u, 0u, 982950505u, 0, TANF_TOLERANCE, 0},
{376, 1142981585u, 0u, 1075383500u, 0, TANF_TOLERANCE, 0},
{377, 3347165962u, 0u, 1067697451u, 0, TANF_TOLERANCE, 0},
{378, 1009535440u, 4293825695u, 1009535856u, 0, TANF_TOLERANCE, 0},
{379, 3103736980u, 4287990860u, 3103736980u, 0, TANF_TOLERANCE, 0},
{380, 3126820946u, 2u, 3126820950u, 0, TANF_TOLERANCE, 0},
{381, 3473956030u, 0u, 3211118531u, 0, TANF_TOLERANCE, 0},
{382, 3349098349u, 0u, 3205518067u, 0, TANF_TOLERANCE, 0},
{383, 3152729489u, 0u, 3152729752u, 0, TANF_TOLERANCE, 0},
{384, 945568720u, 4294963204u, 945568720u, 0, TANF_TOLERANCE, 0},
{385, 3345489836u, 36u, 3203748788u, 0, TANF_TOLERANCE, 0},
{386, 940893161u, 394u, 940893161u, 0, TANF_TOLERANCE, 0},
{387, 976791751u, 4294967292u, 976791753u, 0, TANF_TOLERANCE, 0},
{388, 1004442355u, 0u, 1004442579u, 0, TANF_TOLERANCE, 0},
{389, 1108485380u, 0u, 3222544626u, 0, TANF_TOLERANCE, 0},
{390, 1061834641u, 0u, 1065435464u, 0, TANF_TOLERANCE, 0},
{391, 3381268392u, 885u, 1094771149u, 0, TANF_TOLERANCE, 0},
{392, 1087189715u, 0u, 1040522514u, 0, TANF_TOLERANCE, 0},
{393, 3212952285u, 4294951762u, 3217916800u, 0, TANF_TOLERANCE, 0},
{394, 1000611335u, 0u, 1000611425u, 0, TANF_TOLERANCE, 0},
{395, 3466188568u, 0u, 3229906439u, 0, TANF_TOLERANCE, 0},
{396, 3072456205u, 0u, 3072456205u, 0, TANF_TOLERANCE, 0},
{397, 3319315516u, 4262338968u, 1073744625u, 0, TANF_TOLERANCE, 0},
{398, 935938416u, 867u, 935938416u, 0, TANF_TOLERANCE, 0},
{399, 3212614372u, 1438u, 3217139354u, 0, TANF_TOLERANCE, 0},
{400, 1315030230u, 4294939294u, 1056507579u, 0, TANF_TOLERANCE, 0},
{401, 1134593658u, 3712906944u, 1060255710u, 0, TANF_TOLERANCE, 0},
{402, 977281449u, 0u, 977281451u, 0, TANF_TOLERANCE, 0},
{403, 1086198791u, 0u, 3199662962u, 0, TANF_TOLERANCE, 0},
{404, 1255152035u, 0u, 1063441211u, 0, TANF_TOLERANCE, 0},
{405, 1135271264u, 4294966890u, 3210309101u, 0, TANF_TOLERANCE, 0},
{406, 1094190727u, 0u, 3219586210u, 0, TANF_TOLERANCE, 0},
{407, 1294665325u, 0u, 1065350968u, 0, TANF_TOLERANCE, 0},
{408, 1036608591u, 0u, 1036651299u, 0, TANF_TOLERANCE, 0},
{409, 3229998064u, 0u, 3218788610u, 0, TANF_TOLERANCE, 0},
{410, 3439134022u, 0u, 3216748046u, 0, TANF_TOLERANCE, 0},
{411, 3073083133u, 1094097536u, 3073083133u, 0, TANF_TOLERANCE, 0},
{412, 1325668223u, 0u, 3213764573u, 0, TANF_TOLERANCE, 0},
{413, 1092037607u, 0u, 1019219726u, 0, TANF_TOLERANCE, 0},
{414, 3316278408u, 3774649632u, 1077505006u, 0, TANF_TOLERANCE, 0},
{415, 3295436768u, 0u, 1039776810u, 0, TANF_TOLERANCE, 0},
{416, 1151984049u, 0u, 3225751119u, 0, TANF_TOLERANCE, 0},
{417, 1129287043u, 0u, 1045938796u, 0, TANF_TOLERANCE, 0},
{418, 1243664530u, 0u, 1063139457u, 0, TANF_TOLERANCE, 0},
{419, 950829092u, 0u, 950829092u, 0, TANF_TOLERANCE, 0},
{420, 1115471979u, 0u, 1052666476u, 0, TANF_TOLERANCE, 0},
{421, 3351092088u, 0u, 3207121496u, 0, TANF_TOLERANCE, 0},
{422, 3424479544u, 4294963555u, 3207351422u, 0, TANF_TOLERANCE, 0},
{423, 3241193975u, 0u, 1101462049u, 0, TANF_TOLERANCE, 0},
{424, 1030934236u, 0u, 1030952901u, 0, TANF_TOLERANCE, 0},
{425, 3131791114u, 4283960578u, 3131791120u, 0, TANF_TOLERANCE, 0},
{426, 1025254314u, 0u, 1025259273u, 0, TANF_TOLERANCE, 0},
{427, 1110545760u, 4294967286u, 1054914110u, 0, TANF_TOLERANCE, 0},
{428, 3180213739u, 37u, 3180228747u, 0, TANF_TOLERANCE, 0},
{429, 3361976590u, 0u, 1046920446u, 0, TANF_TOLERANCE, 0},
{430, 881280146u, 4262747520u, 881280146u, 0, TANF_TOLERANCE, 0},
{431, 1304154705u, 0u, 1032301172u, 0, TANF_TOLERANCE, 0},
{432, 3264443610u, 4294967294u, 3240149530u, 0, TANF_TOLERANCE, 0},
{433, 3374550627u, 0u, 3202003323u, 0, TANF_TOLERANCE, 0},
{434, 899599265u, 4294967286u, 899599265u, 0, TANF_TOLERANCE, 0},
{435, 1268194719u, 3962356224u, 1024654683u, 0, TANF_TOLERANCE, 0},
{436, 1133420220u, 3161371u, 3208677146u, 0, TANF_TOLERANCE, 0},
{437, 1161858787u, 0u, 3216740870u, 0, TANF_TOLERANCE, 0},
{438, 3184462258u, 13627054u, 3184508670u, 0, TANF_TOLERANCE, 0},
{439, 3295996963u, 3846806432u, 1057466057u, 0, TANF_TOLERANCE, 0},
{440, 1270887389u, 1864u, 3181932714u, 0, TANF_TOLERANCE, 0},
{441, 3325193181u, 0u, 1063394237u, 0, TANF_TOLERANCE, 0},
{442, 925657343u, 955232128u, 925657343u, 0, TANF_TOLERANCE, 0},
{443, 3115275450u, 0u, 3115275450u, 0, TANF_TOLERANCE, 0},
{444, 3116607482u, 4294967294u, 3116607483u, 0, TANF_TOLERANCE, 0},
{445, 3187892415u, 0u, 3187939970u, 0, TANF_TOLERANCE, 0},
{446, 1189120494u, 0u, 3239616339u, 0, TANF_TOLERANCE, 0},
{447, 889030794u, 0u, 889030794u, 0, TANF_TOLERANCE, 0},
{448, 1323529208u, 0u, 3221615964u, 0, TANF_TOLERANCE, 0},
{449, 3465768388u, 0u, 3196684139u, 0, TANF_TOLERANCE, 0},
{450, 3426099899u, 87u, 3212893834u, 0, TANF_TOLERANCE, 0},
{451, 3224857113u, 4290382691u, 1049681612u, 0, TANF_TOLERANCE, 0},
{452, 1065798296u, 0u, 1071692755u, 0, TANF_TOLERANCE, 0},
{453, 3328989444u, 0u, 1058064740u, 0, TANF_TOLERANCE, 0},
{454, 3357819026u, 0u, 1050796778u, 0, TANF_TOLERANCE, 0},
{455, 1273397670u, 0u, 1110301372u, 0, TANF_TOLERANCE, 0},
{456, 3424831780u, 414735168u, 1018699100u, 0, TANF_TOLERANCE, 0},
{457, 1257596246u, 4264851904u, 1111546709u, 0, TANF_TOLERANCE, 0},
{458, 1051773536u, 0u, 1052257074u, 0, TANF_TOLERANCE, 0},
{459, 3294752507u, 0u, 1071407813u, 0, TANF_TOLERANCE, 0},
{460, 3424848725u, 0u, 3186537053u, 0, TANF_TOLERANCE, 0},
{461, 1090870906u, 4294966393u, 3220499145u, 0, TANF_TOLERANCE, 0},
{462, 1227582289u, 147011u, 3199134534u, 0, TANF_TOLERANCE, 0},
{463, 1272325814u, 0u, 3210855731u, 0, TANF_TOLERANCE, 0},
{464, 3359508271u, 0u, 1099836859u, 0, TANF_TOLERANCE, 0},
{465, 1137854355u, 4294941607u, 3202424383u, 0, TANF_TOLERANCE, 0},
{466, 3440773058u, 0u, 1068726618u, 0, TANF_TOLERANCE, 0},
{467, 3101598400u, 0u, 3101598400u, 0, TANF_TOLERANCE, 0},
{468, 3451216836u, 4294896064u, 3200426155u, 0, TANF_TOLERANCE, 0},
{469, 3437062994u, 0u, 1059689791u, 0, TANF_TOLERANCE, 0},
{470, 1131196082u, 3743u, 1072037701u, 0, TANF_TOLERANCE, 0},
{471, 3177294154u, 63027320u, 3177309135u, 0, TANF_TOLERANCE, 0},
{472, 3258097678u, 449173056u, 3209461218u, 0, TANF_TOLERANCE, 0},
{473, 3460915348u, 356647u, 3224836939u, 0, TANF_TOLERANCE, 0},
{474, 3303035472u, 0u, 3210859526u, 0, TANF_TOLERANCE, 0},
{475, 1053698677u, 4294966907u, 1054479611u, 0, TANF_TOLERANCE, 0},
{476, 3396166221u, 83688u, 3225970172u, 0, TANF_TOLERANCE, 0},
{477, 3037541131u, 5u, 3037541131u, 0, TANF_TOLERANCE, 0},
{478, 3458934263u, 0u, 3206505437u, 0, TANF_TOLERANCE, 0},
{479, 1065761827u, 4294943781u, 1071544994u, 0, TANF_TOLERANCE, 0},
{480, 3025843188u, 0u, 3025843188u, 0, TANF_TOLERANCE, 0},
{481, 926665223u, 0u, 926665223u, 0, TANF_TOLERANCE, 0},
{482, 1199816046u, 0u, 1066809597u, 0, TANF_TOLERANCE, 0},
{483, 3333779015u, 0u, 3204917603u, 0, TANF_TOLERANCE, 0},
{484, 948398145u, 4294967288u, 948398145u, 0, TANF_TOLERANCE, 0},
{485, 3054021468u, 23933390u, 3054021468u, 0, TANF_TOLERANCE, 0},
{486, 1080781593u, 224021u, 1058560355u, 0, TANF_TOLERANCE, 0},
{487, 3164749613u, 0u, 3164751004u, 0, TANF_TOLERANCE, 0},
{488, 3235326590u, 26828788u, 3203498638u, 0, TANF_TOLERANCE, 0},
{489, 3118883815u, 0u, 3118883816u, 0, TANF_TOLERANCE, 0},
{490, 965378004u, 146193824u, 965378004u, 0, TANF_TOLERANCE, 0},
{491, 3226990408u, 45u, 3195199194u, 0, TANF_TOLERANCE, 0},
{492, 3117098218u, 115u, 3117098219u, 0, TANF_TOLERANCE, 0},
{493, 1283624229u, 0u, 3198816655u, 0, TANF_TOLERANCE, 0},
{494, 970649315u, 3u, 970649316u, 0, TANF_TOLERANCE, 0},
{495, 959776291u, 4294967028u, 959776291u, 0, TANF_TOLERANCE, 0},
{496, 3341117305u, 4294966405u, 3220408010u, 0, TANF_TOLERANCE, 0},
{497, 1270734970u, 4294829480u, 1033886173u, 0, TANF_TOLERANCE, 0},
{498, 3454816067u, 0u, 3185422933u, 0, TANF_TOLERANCE, 0},
{499, 917206623u, 7364u, 917206623u, 0, TANF_TOLERANCE, 0},
{500, 1106502045u, 126247200u, 3215714266u, 0, TANF_TOLERANCE, 0},
{501, 1157598381u, 4294964293u, 3212679933u, 0, TANF_TOLERANCE, 0},
{502, 3335234513u, 0u, 3186255331u, 0, TANF_TOLERANCE, 0},
{503, 1279489061u, 0u, 1089588244u, 0, TANF_TOLERANCE, 0},
{504, 3157416480u, 624023680u, 3157416942u, 0, TANF_TOLERANCE, 0},
{505, 3143920719u, 0u, 3143920780u, 0, TANF_TOLERANCE, 0},
{506, 1233171235u, 0u, 3210041471u, 0, TANF_TOLERANCE, 0},
{507, 1148920078u, 0u, 3212968272u, 0, TANF_TOLERANCE, 0},
{508, 3064988156u, 4294967292u, 3064988156u, 0, TANF_TOLERANCE, 0},
{509, 3083619260u, 2484u, 3083619260u, 0, TANF_TOLERANCE, 0},
{510, 1109198803u, 431095u, 1117980359u, 0, TANF_TOLERANCE, 0},
{511, 3219949483u, 0u, 1080100572u, 0, TANF_TOLERANCE, 0},
{512, 3361149474u, 4293077090u, 3207612789u, 0, TANF_TOLERANCE, 0},
{513, 1207502108u, 4292985650u, 3191321179u, 0, TANF_TOLERANCE, 0},
{514, 1000014431u, 0u, 1000014507u, 0, TANF_TOLERANCE, 0},
{515, 3161756316u, 0u, 3161757507u, 0, TANF_TOLERANCE, 0},
{516, 3160728744u, 4293625597u, 3160729720u, 0, TANF_TOLERANCE, 0},
{517, 1234530539u, 3u, 3211178013u, 0, TANF_TOLERANCE, 0},
{518, 1017843965u, 40165u, 1017845595u, 0, TANF_TOLERANCE, 0},
{519, 951862956u, 7732u, 951862956u, 0, TANF_TOLERANCE, 0},
{520, 3306328852u, 87u, 3273199760u, 0, TANF_TOLERANCE, 0},
{521, 1291910469u, 183319u, 3204374719u, 0, TANF_TOLERANCE, 0},
{522, 3027442905u, 7942u, 3027442905u, 0, TANF_TOLERANCE, 0},
{523, 1131927531u, 0u, 3199630789u, 0, TANF_TOLERANCE, 0},
{524, 3449879391u, 0u, 3209274073u, 0, TANF_TOLERANCE, 0},
{525, 970094304u, 4294911386u, 970094305u, 0, TANF_TOLERANCE, 0},
{526, 1125551064u, 4294949017u, 3196245424u, 0, TANF_TOLERANCE, 0},
{527, 3427296372u, 3784252480u, 1024398711u, 0, TANF_TOLERANCE, 0},
{528, 1198917460u, 2607027968u, 1062104444u, 0, TANF_TOLERANCE, 0},
{529, 3201603336u, 0u, 3202463351u, 0, TANF_TOLERANCE, 0},
{530, 3114686212u, 1328603904u, 3114686212u, 0, TANF_TOLERANCE, 0},
{531, 921940707u, 0u, 921940707u, 0, TANF_TOLERANCE, 0},
{532, 1091906532u, 0u, 3184572372u, 0, TANF_TOLERANCE, 0},
{533, 3393557778u, 4293570247u, 3198923133u, 0, TANF_TOLERANCE, 0},
{534, 1276853215u, 0u, 1050751223u, 0, TANF_TOLERANCE, 0},
{535, 3462778440u, 4294884341u, 1042202295u, 0, TANF_TOLERANCE, 0},
{536, 3360170117u, 0u, 3213953845u, 0, TANF_TOLERANCE, 0},
{537, 3224245428u, 4294967170u, 1055235475u, 0, TANF_TOLERANCE, 0},
{538, 1120124467u, 352u, 1057355457u, 0, TANF_TOLERANCE, 0},
{539, 1064364381u, 0u, 1068476199u, 0, TANF_TOLERANCE, 0},
{540, 1268744779u, 4294952694u, 1049186545u, 0, TANF_TOLERANCE, 0},
{541, 1165195428u, 4292538760u, 3171864354u, 0, TANF_TOLERANCE, 0},
{542, 3044092739u, 30u, 3044092739u, 0, TANF_TOLERANCE, 0},
{543, 3149469534u, 47144136u, 3149469663u, 0, TANF_TOLERANCE, 0},
{544, 3247790039u, 0u, 1044126050u, 0, TANF_TOLERANCE, 0},
{545, 3215244648u, 4u, 3227218833u, 0, TANF_TOLERANCE, 0},
{546, 3095275931u, 0u, 3095275931u, 0, TANF_TOLERANCE, 0},
{547, 3059688264u, 77u, 3059688264u, 0, TANF_TOLERANCE, 0},
{548, 1212717473u, 0u, 1093643519u, 0, TANF_TOLERANCE, 0},
{549, 3275973009u, 3930410816u, 3207596131u, 0, TANF_TOLERANCE, 0},
{550, 3028857014u, 0u, 3028857014u, 0, TANF_TOLERANCE, 0},
{551, 3391162308u, 129212984u, 1072543465u, 0, TANF_TOLERANCE, 0},
{552, 1044867873u, 4294528232u, 1045035636u, 0, TANF_TOLERANCE, 0},
{553, 1089986803u, 3370664576u, 1091822310u, 0, TANF_TOLERANCE, 0},
{554, 1296314700u, 0u, 1056804853u, 0, TANF_TOLERANCE, 0},
{555, 1251462432u, 0u, 3218109010u, 0, TANF_TOLERANCE, 0},
{556, 3485236902u, 0u, 3252201041u, 0, TANF_TOLERANCE, 0},
{557, 3262169538u, 19958524u, 3205202357u, 0, TANF_TOLERANCE, 0},
{558, 3080852256u, 0u, 3080852256u, 0, TANF_TOLERANCE, 0},
{559, 1022211242u, 0u, 1022215616u, 0, TANF_TOLERANCE, 0},
{560, 884661176u, 0u, 884661176u, 0, TANF_TOLERANCE, 0},
{561, 3071422941u, 4294967172u, 3071422941u, 0, TANF_TOLERANCE, 0},
{562, 989762529u, 4294733601u, 989762550u, 0, TANF_TOLERANCE, 0},
{563, 1295475718u, 0u, 3197707674u, 0, TANF_TOLERANCE, 0},
{564, 1002632518u, 4294950696u, 1002632669u, 0, TANF_TOLERANCE, 0},
{565, 3404372005u, 3938008096u, 3237779534u, 0, TANF_TOLERANCE, 0},
{566, 3158912530u, 0u, 3158913193u, 0, TANF_TOLERANCE, 0},
{567, 1125800069u, 4294967259u, 1054681101u, 0, TANF_TOLERANCE, 0},
{568, 3138037576u, 0u, 3138037590u, 0, TANF_TOLERANCE, 0},
{569, 3108384823u, 268832992u, 3108384823u, 0, TANF_TOLERANCE, 0},
{570, 999985470u, 4282999218u, 999985545u, 0, TANF_TOLERANCE, 0},
{571, 1189421739u, 0u, 3206932751u, 0, TANF_TOLERANCE, 0},
{572, 3075182644u, 0u, 3075182644u, 0, TANF_TOLERANCE, 0},
{573, 3028099649u, 4292241163u, 3028099649u, 0, TANF_TOLERANCE, 0},
{574, 3132541814u, 4077666864u, 3132541822u, 0, TANF_TOLERANCE, 0},
{575, 1164046161u, 4139845440u, 3217980332u, 0, TANF_TOLERANCE, 0},
{576, 1292596266u, 0u, 1068007873u, 0, TANF_TOLERANCE, 0},
{577, 3469748379u, 4279587928u, 1060131664u, 0, TANF_TOLERANCE, 0},
{578, 1314644642u, 0u, 3197317752u, 0, TANF_TOLERANCE, 0},
{579, 3399813173u, 0u, 1059796620u, 0, TANF_TOLERANCE, 0},
{580, 948775569u, 2159002624u, 948775569u, 0, TANF_TOLERANCE, 0},
{581, 1034611395u, 0u, 1034637473u, 0, TANF_TOLERANCE, 0},
{582, 3489122735u, 4294428604u, 3207259992u, 0, TANF_TOLERANCE, 0},
{583, 1181604787u, 4294717096u, 3224785060u, 0, TANF_TOLERANCE, 0},
{584, 3059042077u, 0u, 3059042077u, 0, TANF_TOLERANCE, 0},
{585, 1043691622u, 4288164501u, 1043817708u, 0, TANF_TOLERANCE, 0},
{586, 1314588083u, 0u, 1082395610u, 0, TANF_TOLERANCE, 0},
{587, 3141533334u, 0u, 3141533370u, 0, TANF_TOLERANCE, 0},
{588, 3157534378u, 3899913312u, 3157534854u, 0, TANF_TOLERANCE, 0},
{589, 3400949680u, 0u, 1099168145u, 0, TANF_TOLERANCE, 0},
{590, 3365581801u, 9596u, 1093578518u, 0, TANF_TOLERANCE, 0},
{591, 1110424755u, 0u, 3175405557u, 0, TANF_TOLERANCE, 0},
{592, 3189917167u, 0u, 3190007093u, 0, TANF_TOLERANCE, 0},
{593, 969804941u, 4294836255u, 969804942u, 0, TANF_TOLERANCE, 0},
{594, 1139120919u, 4294967176u, 1058612519u, 0, TANF_TOLERANCE, 0},
{595, 934308144u, 0u, 934308144u, 0, TANF_TOLERANCE, 0},
{596, 1220524226u, 1440u, 1053896882u, 0, TANF_TOLERANCE, 0},
{597, 3162548604u, 3394333056u, 3162549297u, 0, TANF_TOLERANCE, 0},
{598, 3382391700u, 4294966243u, 1092675627u, 0, TANF_TOLERANCE, 0},
{599, 1156767533u, 7u, 1092496361u, 0, TANF_TOLERANCE, 0},
{600, 3079222483u, 4294963487u, 3079222483u, 0, TANF_TOLERANCE, 0},
{601, 994934087u, 0u, 994934131u, 0, TANF_TOLERANCE, 0},
{602, 3185240099u, 122u, 3185294986u, 0, TANF_TOLERANCE, 0},
{603, 3479873563u, 3288004u, 1068753718u, 0, TANF_TOLERANCE, 0},
{604, 3424264117u, 4203174416u, 3173613126u, 0, TANF_TOLERANCE, 0},
{605, 3228365887u, 275492u, 3206597172u, 0, TANF_TOLERANCE, 0},
{606, 1035909900u, 4101891u, 1035946163u, 0, TANF_TOLERANCE, 0},
{607, 3024951184u, 3626688u, 3024951184u, 0, TANF_TOLERANCE, 0},
{608, 1212129651u, 0u, 3200433496u, 0, TANF_TOLERANCE, 0},
{609, 3125775254u, 0u, 3125775257u, 0, TANF_TOLERANCE, 0},
{610, 1037464105u, 0u, 1037515694u, 0, TANF_TOLERANCE, 0},
{611, 1311706596u, 6702361u, 1067617575u, 0, TANF_TOLERANCE, 0},
{612, 918212457u, 0u, 918212457u, 0, TANF_TOLERANCE, 0},
{613, 1337315179u, 3421796288u, 3233803179u, 0, TANF_TOLERANCE, 0},
{614, 1131358407u, 4294955130u, 1054304608u, 0, TANF_TOLERANCE, 0},
{615, 1156517523u, 4294914801u, 3212474510u, 0, TANF_TOLERANCE, 0},
{616, 3210802820u, 0u, 3214570101u, 0, TANF_TOLERANCE, 0},
{617, 3337499209u, 621819u, 1013411925u, 0, TANF_TOLERANCE, 0},
{618, 3468429030u, 4294967266u, 1083934034u, 0, TANF_TOLERANCE, 0},
{619, 3253515800u, 28517u, 3228847177u, 0, TANF_TOLERANCE, 0},
{620, 3055299953u, 0u, 3055299953u, 0, TANF_TOLERANCE, 0},
{621, 959956547u, 0u, 959956547u, 0, TANF_TOLERANCE, 0},
{622, 3425290480u, 461u, 1035239809u, 0, TANF_TOLERANCE, 0},
{623, 1039917375u, 117u, 1040001112u, 0, TANF_TOLERANCE, 0},
{624, 3220979495u, 4234725636u, 1075276972u, 0, TANF_TOLERANCE, 0},
{625, 1311016004u, 4294941884u, 3227474106u, 0, TANF_TOLERANCE, 0},
{626, 1128016396u, 27u, 3199213538u, 0, TANF_TOLERANCE, 0},
{627, 3210335769u, 0u, 3214015080u, 0, TANF_TOLERANCE, 0},
{628, 3022705759u, 4287084865u, 3022705759u, 0, TANF_TOLERANCE, 0},
{629, 1206054701u, 0u, 3238454059u, 0, TANF_TOLERANCE, 0},
{630, 3144504834u, 3170u, 3144504902u, 0, TANF_TOLERANCE, 0},
{631, 1213609983u, 0u, 1087444763u, 0, TANF_TOLERANCE, 0},
{632, 1246902946u, 0u, 1059569979u, 0, TANF_TOLERANCE, 0},
{633, 995850843u, 3845036544u, 995850897u, 0, TANF_TOLERANCE, 0},
{634, 3362082828u, 4294328268u, 3217124513u, 0, TANF_TOLERANCE, 0},
{635, 1029480631u, 0u, 1029494631u, 0, TANF_TOLERANCE, 0},
{636, 3153568584u, 0u, 3153568893u, 0, TANF_TOLERANCE, 0},
{637, 3384988527u, 0u, 1015237194u, 0, TANF_TOLERANCE, 0},
{638, 1317696241u, 0u, 3214540299u, 0, TANF_TOLERANCE, 0},
{639, 3235395924u, 249u, 3204662531u, 0, TANF_TOLERANCE, 0},
{640, 3341877624u, 0u, 1066781384u, 0, TANF_TOLERANCE, 0},
{641, 1228636133u, 0u, 1088625043u, 0, TANF_TOLERANCE, 0},
{642, 3161654634u, 4294939932u, 3161655802u, 0, TANF_TOLERANCE, 0},
{643, 3162655243u, 4294964738u, 3162655963u, 0, TANF_TOLERANCE, 0},
{644, 1207246237u, 0u, 3221431060u, 0, TANF_TOLERANCE, 0},
{645, 1165476654u, 4294877038u, 3205034258u, 0, TANF_TOLERANCE, 0},
{646, 1215278023u, 0u, 3225473261u, 0, TANF_TOLERANCE, 0},
{647, 1017239798u, 4167373560u, 1017241178u, 0, TANF_TOLERANCE, 0},
{648, 1149651309u, 0u, 3188065066u, 0, TANF_TOLERANCE, 0},
{649, 1111943722u, 0u, 3206043720u, 0, TANF_TOLERANCE, 0},
{650, 1189849849u, 4293652457u, 3182509934u, 0, TANF_TOLERANCE, 0},
{651, 3204848496u, 0u, 3205751737u, 0, TANF_TOLERANCE, 0},
{652, 1249758327u, 0u, 1059591112u, 0, TANF_TOLERANCE, 0},
{653, 3092982276u, 4065500752u, 3092982276u, 0, TANF_TOLERANCE, 0},
{654, 1168098747u, 1063712256u, 1082873807u, 0, TANF_TOLERANCE, 0},
{655, 892549317u, 13301u, 892549317u, 0, TANF_TOLERANCE, 0},
{656, 3301009024u, 4286178976u, 3254770741u, 0, TANF_TOLERANCE, 0},
{657, 3233089227u, 204399u, 1060708740u, 0, TANF_TOLERANCE, 0},
{658, 3218245284u, 1767132u, 1096286488u, 0, TANF_TOLERANCE, 0},
{659, 3215981890u, 4294967286u, 3231794500u, 0, TANF_TOLERANCE, 0},
{660, 1266687209u, 0u, 1072040735u, 0, TANF_TOLERANCE, 0},
{661, 3487959775u, 4294948774u, 1080427053u, 0, TANF_TOLERANCE, 0},
{662, 943645710u, 0u, 943645710u, 0, TANF_TOLERANCE, 0},
{663, 3345065699u, 4294966959u, 1063260966u, 0, TANF_TOLERANCE, 0},
{664, 935847271u, 1u, 935847271u, 0, TANF_TOLERANCE, 0},
{665, 3410336089u, 47u, 1039814645u, 0, TANF_TOLERANCE, 0},
{666, 3082940740u, 1562501120u, 3082940740u, 0, TANF_TOLERANCE, 0},
{667, 1141063391u, 5507u, 1051920630u, 0, TANF_TOLERANCE, 0},
{668, 3059263153u, 0u, 3059263153u, 0, TANF_TOLERANCE, 0},
{669, 3353679791u, 0u, 3214268763u, 0, TANF_TOLERANCE, 0},
{670, 1001823878u, 0u, 1001824002u, 0, TANF_TOLERANCE, 0},
{671, 1009130212u, 0u, 1009130585u, 0, TANF_TOLERANCE, 0},
{672, 3367127535u, 0u, 3210803933u, 0, TANF_TOLERANCE, 0},
{673, 1032920919u, 3981458912u, 1032936870u, 0, TANF_TOLERANCE, 0},
{674, 3281952870u, 0u, 1027847826u, 0, TANF_TOLERANCE, 0},
{675, 1237868497u, 0u, 3199109460u, 0, TANF_TOLERANCE, 0},
{676, 1153753924u, 4294958733u, 1075092193u, 0, TANF_TOLERANCE, 0},
{677, 1120261759u, 0u, 1103227732u, 0, TANF_TOLERANCE, 0},
{678, 3226328360u, 4294623870u, 3180983208u, 0, TANF_TOLERANCE, 0},
{679, 3349595986u, 4294967271u, 1069726435u, 0, TANF_TOLERANCE, 0},
{680, 3166889490u, 4294965026u, 3166891900u, 0, TANF_TOLERANCE, 0},
{681, 1087750238u, 16u, 1054237603u, 0, TANF_TOLERANCE, 0},
{682, 3121620061u, 4294773019u, 3121620062u, 0, TANF_TOLERANCE, 0},
{683, 1066116543u, 0u, 1073085463u, 0, TANF_TOLERANCE, 0},
{684, 3210898034u, 0u, 3214687828u, 0, TANF_TOLERANCE, 0},
{685, 3051923237u, 4294697573u, 3051923237u, 0, TANF_TOLERANCE, 0},
{686, 1030612298u, 4294908239u, 1030629852u, 0, TANF_TOLERANCE, 0},
{687, 1186234578u, 0u, 1074426401u, 0, TANF_TOLERANCE, 0},
{688, 1331680743u, 0u, 1068067591u, 0, TANF_TOLERANCE, 0},
{689, 3060774997u, 2318310656u, 3060774997u, 0, TANF_TOLERANCE, 0},
{690, 887589411u, 141578704u, 887589411u, 0, TANF_TOLERANCE, 0},
{691, 1045232522u, 4294967290u, 1045414882u, 0, TANF_TOLERANCE, 0},
{692, 3119858470u, 0u, 3119858471u, 0, TANF_TOLERANCE, 0},
{693, 3349432725u, 0u, 1069451077u, 0, TANF_TOLERANCE, 0},
{694, 912423027u, 0u, 912423027u, 0, TANF_TOLERANCE, 0},
{695, 3228795133u, 4294967132u, 3209165556u, 0, TANF_TOLERANCE, 0},
{696, 3194674746u, 0u, 3194950467u, 0, TANF_TOLERANCE, 0},
{697, 3296784303u, 4294967098u, 3218995362u, 0, TANF_TOLERANCE, 0},
{698, 965402291u, 0u, 965402291u, 0, TANF_TOLERANCE, 0},
{699, 3388153589u, 4246639564u, 1059937603u, 0, TANF_TOLERANCE, 0},
{700, 1133410485u, 4294951516u, 3215980355u, 0, TANF_TOLERANCE, 0},
{701, 3136790322u, 7u, 3136790341u, 0, TANF_TOLERANCE, 0},
{702, 3369970587u, 0u, 1079671878u, 0, TANF_TOLERANCE, 0},
{703, 1270451568u, 0u, 3215399533u, 0, TANF_TOLERANCE, 0},
{704, 989498922u, 0u, 989498942u, 0, TANF_TOLERANCE, 0},
{705, 1280215674u, 0u, 3203020348u, 0, TANF_TOLERANCE, 0},
{706, 1171873518u, 0u, 1053592412u, 0, TANF_TOLERANCE, 0},
{707, 3298258100u, 0u, 1078312850u, 0, TANF_TOLERANCE, 0},
{708, 3415208824u, 0u, 1072972802u, 0, TANF_TOLERANCE, 0},
{709, 1001897182u, 0u, 1001897308u, 0, TANF_TOLERANCE, 0},
{710, 3152777939u, 4294967281u, 3152778205u, 0, TANF_TOLERANCE, 0},
{711, 985903305u, 4294945424u, 985903315u, 0, TANF_TOLERANCE, 0},
{712, 3357328848u, 0u, 1040886478u, 0, TANF_TOLERANCE, 0},
{713, 982612185u, 0u, 982612189u, 0, TANF_TOLERANCE, 0},
{714, 3267868136u, 136421u, 1062023610u, 0, TANF_TOLERANCE, 0},
{715, 3319048157u, 7150u, 3197801983u, 0, TANF_TOLERANCE, 0},
{716, 1144755661u, 0u, 3205225235u, 0, TANF_TOLERANCE, 0},
{717, 898467286u, 0u, 898467286u, 0, TANF_TOLERANCE, 0},
{718, 3301461672u, 1119632u, 3196087313u, 0, TANF_TOLERANCE, 0},
{719, 3364525678u, 0u, 3196210714u, 0, TANF_TOLERANCE, 0},
{720, 931441127u, 285u, 931441127u, 0, TANF_TOLERANCE, 0},
{721, 3146660041u, 0u, 3146660100u, 0, TANF_TOLERANCE, 0},
{722, 3467121799u, 0u, 3191838679u, 0, TANF_TOLERANCE, 0},
{723, 1151257041u, 0u, 1073582895u, 0, TANF_TOLERANCE, 0},
{724, 3097873255u, 4294967295u, 3097873255u, 0, TANF_TOLERANCE, 0},
{725, 3130670309u, 0u, 3130670314u, 0, TANF_TOLERANCE, 0},
{726, 1017573824u, 0u, 1017575339u, 0, TANF_TOLERANCE, 0},
{727, 1258369714u, 3364363264u, 3221741189u, 0, TANF_TOLERANCE, 0},
{728, 1216602683u, 4294468761u, 3207163210u, 0, TANF_TOLERANCE, 0},
{729, 3297265739u, 228335u, 3187817583u, 0, TANF_TOLERANCE, 0},
{730, 1071940738u, 4294963632u, 3230852112u, 0, TANF_TOLERANCE, 0},
{731, 922601356u, 4294937447u, 922601356u, 0, TANF_TOLERANCE, 0},
{732, 3462285635u, 4085532736u, 1046898481u, 0, TANF_TOLERANCE, 0},
{733, 3357177805u, 5u, 1066425327u, 0, TANF_TOLERANCE, 0},
{734, 3049120080u, 0u, 3049120080u, 0, TANF_TOLERANCE, 0},
{735, 1153863660u, 0u, 3222167055u, 0, TANF_TOLERANCE, 0},
{736, 3034243695u, 0u, 3034243695u, 0, TANF_TOLERANCE, 0},
{737, 1249365132u, 4294967060u, 3214523524u, 0, TANF_TOLERANCE, 0},
{738, 3046215730u, 0u, 3046215730u, 0, TANF_TOLERANCE, 0},
{739, 3047251716u, 8u, 3047251716u, 0, TANF_TOLERANCE, 0},
{740, 3131219358u, 2355170688u, 3131219363u, 0, TANF_TOLERANCE, 0},
{741, 3222096285u, 59453u, 1068306462u, 0, TANF_TOLERANCE, 0},
{742, 1297708818u, 0u, 3206939123u, 0, TANF_TOLERANCE, 0},
{743, 3345532722u, 4293531291u, 3239569797u, 0, TANF_TOLERANCE, 0},
{744, 3418753236u, 4002743296u, 3228029453u, 0, TANF_TOLERANCE, 0},
{745, 1277417964u, 1103002624u, 3203882980u, 0, TANF_TOLERANCE, 0},
{746, 987577257u, 1370u, 987577271u, 0, TANF_TOLERANCE, 0},
{747, 3161606610u, 0u, 3161607768u, 0, TANF_TOLERANCE, 0},
{748, 888030585u, 0u, 888030585u, 0, TANF_TOLERANCE, 0},
{749, 1043442869u, 4294963715u, 1043561145u, 0, TANF_TOLERANCE, 0},
{750, 3320923228u, 3214934912u, 1095051388u, 0, TANF_TOLERANCE, 0},
{751, 1337400405u, 418188288u, 1047433444u, 0, TANF_TOLERANCE, 0},
{752, 3400348640u, 0u, 3184549924u, 0, TANF_TOLERANCE, 0},
{753, 1250249095u, 1u, 1050407057u, 0, TANF_TOLERANCE, 0},
{754, 3284411233u, 7805u, 1055280030u, 0, TANF_TOLERANCE, 0},
{755, 3020883322u, 0u, 3020883322u, 0, TANF_TOLERANCE, 0},
{756, 1215968622u, 2531374080u, 1074241478u, 0, TANF_TOLERANCE, 0},
{757, 3202319550u, 0u, 3203327015u, 0, TANF_TOLERANCE, 0},
{758, 3061638260u, 0u, 3061638260u, 0, TANF_TOLERANCE, 0},
{759, 1025404104u, 1u, 1025409284u, 0, TANF_TOLERANCE, 0},
{760, 3138086437u, 0u, 3138086451u, 0, TANF_TOLERANCE, 0},
{761, 3091024506u, 3752313152u, 3091024506u, 0, TANF_TOLERANCE, 0},
{762, 3362748242u, 4294517284u, 1059851445u, 0, TANF_TOLERANCE, 0},
{763, 3099671635u, 4294967295u, 3099671635u, 0, TANF_TOLERANCE, 0},
{764, 3068014841u, 0u, 3068014841u, 0, TANF_TOLERANCE, 0},
{765, 1252237719u, 105u, 1083657804u, 0, TANF_TOLERANCE, 0},
{766, 3327895594u, 517257u, 1059714984u, 0, TANF_TOLERANCE, 0},
{767, 3082454432u, 0u, 3082454432u, 0, TANF_TOLERANCE, 0},
{768, 3396161504u, 16393u, 3185570312u, 0, TANF_TOLERANCE, 0},
{769, 1099710167u, 0u, 3229132239u, 0, TANF_TOLERANCE, 0},
{770, 1157186482u, 109233848u, 3213014187u, 0, TANF_TOLERANCE, 0},
{771, 1282110851u, 0u, 1058083394u, 0, TANF_TOLERANCE, 0},
{772, 3477008113u, 3797391872u, 3243115119u, 0, TANF_TOLERANCE, 0},
{773, 3292127294u, 4282395772u, 1071713910u, 0, TANF_TOLERANCE, 0},
{774, 1123357102u, 4294966999u, 1011577850u, 0, TANF_TOLERANCE, 0},
{775, 1106837025u, 0u, 3197751392u, 0, TANF_TOLERANCE, 0},
{776, 1049949008u, 230u, 1050234049u, 0, TANF_TOLERANCE, 0},
{777, 1253017688u, 0u, 1073946677u, 0, TANF_TOLERANCE, 0},
{778, 1108543194u, 4294966999u, 3215992802u, 0, TANF_TOLERANCE, 0},
{779, 3087985411u, 1700586u, 3087985411u, 0, TANF_TOLERANCE, 0},
{780, 3163283126u, 2976129280u, 3163284017u, 0, TANF_TOLERANCE, 0},
{781, 1160162706u, 14164775u, 3200455195u, 0, TANF_TOLERANCE, 0},
{782, 3305715025u, 0u, 1061093195u, 0, TANF_TOLERANCE, 0},
{783, 1266928623u, 0u, 1066131511u, 0, TANF_TOLERANCE, 0},
{784, 3025340297u, 43483u, 3025340297u, 0, TANF_TOLERANCE, 0},
{785, 3438080027u, 0u, 3196462866u, 0, TANF_TOLERANCE, 0},
{786, 3344574751u, 0u, 3218369690u, 0, TANF_TOLERANCE, 0},
{787, 1152416724u, 0u, 1080146948u, 0, TANF_TOLERANCE, 0},
{788, 1218239308u, 161u, 3223069606u, 0, TANF_TOLERANCE, 0},
{789, 3263310567u, 0u, 1067313815u, 0, TANF_TOLERANCE, 0},
{790, 3041998669u, 2782u, 3041998669u, 0, TANF_TOLERANCE, 0},
{791, 1000313118u, 0u, 1000313201u, 0, TANF_TOLERANCE, 0},
{792, 972485427u, 131u, 972485428u, 0, TANF_TOLERANCE, 0},
{793, 3290264612u, 137u, 3243638355u, 0, TANF_TOLERANCE, 0},
{794, 3222106584u, 18249u, 1068248402u, 0, TANF_TOLERANCE, 0},
{795, 1278946388u, 0u, 3213687170u, 0, TANF_TOLERANCE, 0},
{796, 947914771u, 0u, 947914771u, 0, TANF_TOLERANCE, 0},
{797, 3167730654u, 0u, 3167733573u, 0, TANF_TOLERANCE, 0},
{798, 1098530298u, 4294967260u, 3180012107u, 0, TANF_TOLERANCE, 0},
{799, 3232726036u, 0u, 1065589565u, 0, TANF_TOLERANCE, 0},
{800, 1297190916u, 0u, 3227258942u, 0, TANF_TOLERANCE, 0},
{801, 1277649137u, 0u, 1090874516u, 0, TANF_TOLERANCE, 0},
{802, 3203377685u, 466619008u, 3204541722u, 0, TANF_TOLERANCE, 0},
{803, 3090306474u, 0u, 3090306474u, 0, TANF_TOLERANCE, 0},
{804, 3244032016u, 0u, 3223123848u, 0, TANF_TOLERANCE, 0},
{805, 3033122376u, 0u, 3033122376u, 0, TANF_TOLERANCE, 0},
{806, 1096155623u, 7454884u, 1065760490u, 0, TANF_TOLERANCE, 0},
{807, 873151908u, 4294967280u, 873151908u, 0, TANF_TOLERANCE, 0},
{808, 3238729605u, 245005088u, 1063636693u, 0, TANF_TOLERANCE, 0},
{809, 3317196817u, 0u, 3220820246u, 0, TANF_TOLERANCE, 0},
{810, 3374748510u, 0u, 1052782883u, 0, TANF_TOLERANCE, 0},
{811, 3345634950u, 0u, 1082277486u, 0, TANF_TOLERANCE, 0},
{812, 3189860276u, 0u, 3189948757u, 0, TANF_TOLERANCE, 0},
{813, 887311687u, 9077u, 887311687u, 0, TANF_TOLERANCE, 0},
{814, 3396917283u, 0u, 3176463205u, 0, TANF_TOLERANCE, 0},
{815, 3317032737u, 0u, 1057311975u, 0, TANF_TOLERANCE, 0},
{816, 1200051436u, 3555u, 3221587134u, 0, TANF_TOLERANCE, 0},
{817, 3105291012u, 45279u, 3105291012u, 0, TANF_TOLERANCE, 0},
{818, 1306520561u, 0u, 1073667024u, 0, TANF_TOLERANCE, 0},
{819, 1314936356u, 0u, 3214605429u, 0, TANF_TOLERANCE, 0},
{820, 3475052219u, 71851496u, 1038538546u, 0, TANF_TOLERANCE, 0},
{821, 3085636260u, 33u, 3085636260u, 0, TANF_TOLERANCE, 0},
{822, 3393227708u, 4294967164u, 1037393136u, 0, TANF_TOLERANCE, 0},
{823, 3182540197u, 0u, 3182569515u, 0, TANF_TOLERANCE, 0},
{824, 3349005404u, 0u, 3182795207u, 0, TANF_TOLERANCE, 0},
{825, 3154720153u, 4090490144u, 3154720363u, 0, TANF_TOLERANCE, 0},
{826, 1262863321u, 345111u, 1058701781u, 0, TANF_TOLERANCE, 0},
{827, 882902102u, 512593u, 882902102u, 0, TANF_TOLERANCE, 0},
{828, 1053387478u, 0u, 1054113388u, 0, TANF_TOLERANCE, 0},
{829, 3387653691u, 4294896063u, 1133672154u, 0, TANF_TOLERANCE, 0},
{830, 3136364836u, 0u, 3136364854u, 0, TANF_TOLERANCE, 0},
{831, 1338680611u, 4126u, 3203129222u, 0, TANF_TOLERANCE, 0},
{832, 1112891928u, 0u, 3178975679u, 0, TANF_TOLERANCE, 0},
{833, 893449284u, 0u, 893449284u, 0, TANF_TOLERANCE, 0},
{834, 892311459u, 14u, 892311459u, 0, TANF_TOLERANCE, 0},
{835, 3105373037u, 4294967280u, 3105373037u, 0, TANF_TOLERANCE, 0},
{836, 1190105283u, 0u, 3210335843u, 0, TANF_TOLERANCE, 0},
{837, 1011225926u, 14129u, 1011226559u, 0, TANF_TOLERANCE, 0},
{838, 1043025031u, 0u, 1043130935u, 0, TANF_TOLERANCE, 0},
{839, 3410531037u, 0u, 1058007796u, 0, TANF_TOLERANCE, 0},
{840, 3125834184u, 0u, 3125834187u, 0, TANF_TOLERANCE, 0},
{841, 902318189u, 0u, 902318189u, 0, TANF_TOLERANCE, 0},
{842, 3213624815u, 0u, 3220685331u, 0, TANF_TOLERANCE, 0},
{843, 1120888322u, 5u, 1020958163u, 0, TANF_TOLERANCE, 0},
{844, 1315217243u, 4291026624u, 3216322935u, 0, TANF_TOLERANCE, 0},
{845, 3137758475u, 0u, 3137758487u, 0, TANF_TOLERANCE, 0},
{846, 1040617590u, 0u, 1040668706u, 0, TANF_TOLERANCE, 0},
{847, 955384253u, 4294910624u, 955384253u, 0, TANF_TOLERANCE, 0},
{848, 3061417900u, 7119u, 3061417900u, 0, TANF_TOLERANCE, 0},
{849, 904255535u, 0u, 904255535u, 0, TANF_TOLERANCE, 0},
{850, 1022984119u, 0u, 1022989177u, 0, TANF_TOLERANCE, 0},
{851, 997362368u, 0u, 997362441u, 0, TANF_TOLERANCE, 0},
{852, 900933520u, 19u, 900933520u, 0, TANF_TOLERANCE, 0},
{853, 1168623062u, 661u, 3196323038u, 0, TANF_TOLERANCE, 0},
{854, 878737490u, 4294967181u, 878737490u, 0, TANF_TOLERANCE, 0},
{855, 1039827284u, 1u, 1039909652u, 0, TANF_TOLERANCE, 0},
{856, 1021564080u, 0u, 1021567931u, 0, TANF_TOLERANCE, 0},
{857, 3458669745u, 0u, 1066422342u, 0, TANF_TOLERANCE, 0},
{858, 3327516316u, 4286775627u, 1049360086u, 0, TANF_TOLERANCE, 0},
{859, 1040711112u, 4294967293u, 1040763880u, 0, TANF_TOLERANCE, 0},
{860, 1134528351u, 4294638880u, 3232374310u, 0, TANF_TOLERANCE, 0},
{861, 3039884464u, 6340u, 3039884464u, 0, TANF_TOLERANCE, 0},
{862, 3414352838u, 4294876517u, 3188011275u, 0, TANF_TOLERANCE, 0},
{863, 1133689539u, 1u, 1079948290u, 0, TANF_TOLERANCE, 0},
{864, 3455688478u, 4294945415u, 1107170377u, 0, TANF_TOLERANCE, 0},
{865, 1137634874u, 395u, 3213603805u, 0, TANF_TOLERANCE, 0},
{866, 3415502662u, 0u, 1066223566u, 0, TANF_TOLERANCE, 0},
{867, 954999730u, 0u, 954999730u, 0, TANF_TOLERANCE, 0},
{868, 1066157309u, 4294967285u, 1073278589u, 0, TANF_TOLERANCE, 0},
{869, 3436353675u, 8741u, 1059785901u, 0, TANF_TOLERANCE, 0},
{870, 940437609u, 0u, 940437609u, 0, TANF_TOLERANCE, 0},
{871, 3108347547u, 4203356328u, 3108347547u, 0, TANF_TOLERANCE, 0},
{872, 3064200154u, 0u, 3064200154u, 0, TANF_TOLERANCE, 0},
{873, 1023889593u, 0u, 1023892821u, 0, TANF_TOLERANCE, 0},
{874, 3272661536u, 3393767296u, 3199494770u, 0, TANF_TOLERANCE, 0},
{875, 1170245333u, 1083705u, 1044761542u, 0, TANF_TOLERANCE, 0},
{876, 1219052056u, 4294526211u, 1059052342u, 0, TANF_TOLERANCE, 0},
{877, 3318983619u, 4294967246u, 3192638482u, 0, TANF_TOLERANCE, 0},
{878, 3372118621u, 0u, 3246295792u, 0, TANF_TOLERANCE, 0},
{879, 3146190320u, 0u, 3146190370u, 0, TANF_TOLERANCE, 0},
{880, 1299683827u, 0u, 1043926259u, 0, TANF_TOLERANCE, 0},
{881, 3190796331u, 1457792256u, 3190910653u, 0, TANF_TOLERANCE, 0},
{882, 3086068902u, 2772570624u, 3086068902u, 0, TANF_TOLERANCE, 0},
{883, 3064155399u, 0u, 3064155399u, 0, TANF_TOLERANCE, 0},
{884, 3040314717u, 1u, 3040314717u, 0, TANF_TOLERANCE, 0},
{885, 3257224022u, 4294737239u, 3204855251u, 0, TANF_TOLERANCE, 0},
{886, 1229268598u, 1u, 3190598378u, 0, TANF_TOLERANCE, 0},
{887, 3184078812u, 0u, 3184121389u, 0, TANF_TOLERANCE, 0},
{888, 1086717248u, 4256439624u, 3183821300u, 0, TANF_TOLERANCE, 0},
{889, 3434884607u, 0u, 1054771109u, 0, TANF_TOLERANCE, 0},
{890, 3464955606u, 0u, 3208802337u, 0, TANF_TOLERANCE, 0},
{891, 1025278524u, 0u, 1025283519u, 0, TANF_TOLERANCE, 0},
{892, 1242829722u, 4294967290u, 1069973034u, 0, TANF_TOLERANCE, 0},
{893, 3075149137u, 76u, 3075149137u, 0, TANF_TOLERANCE, 0},
{894, 1200927971u, 1093714048u, 1079140552u, 0, TANF_TOLERANCE, 0},
{895, 3326858092u, 3870213632u, 3216501138u, 0, TANF_TOLERANCE, 0},
{896, 1246019790u, 0u, 3203052164u, 0, TANF_TOLERANCE, 0},
{897, 3184801644u, 424u, 3184851637u, 0, TANF_TOLERANCE, 0},
{898, 1136052740u, 4294967282u, 1074814028u, 0, TANF_TOLERANCE, 0},
{899, 1069009211u, 0u, 1089185530u, 0, TANF_TOLERANCE, 0},
{900, 1015670780u, 20u, 1015671634u, 0, TANF_TOLERANCE, 0},
{901, 1012543234u, 70u, 1012544079u, 0, TANF_TOLERANCE, 0},
{902, 3316611992u, 4291436324u, 3235325687u, 0, TANF_TOLERANCE, 0},
{903, 1087942795u, 4294961657u, 1057489571u, 0, TANF_TOLERANCE, 0},
{904, 3426365713u, 0u, 3204426893u, 0, TANF_TOLERANCE, 0},
{905, 3066654389u, 4087070784u, 3066654389u, 0, TANF_TOLERANCE, 0},
{906, 3295326432u, 842363840u, 1059389687u, 0, TANF_TOLERANCE, 0},
{907, 3318835308u, 4294967077u, 3172066705u, 0, TANF_TOLERANCE, 0},
{908, 3283555717u, 0u, 1085772908u, 0, TANF_TOLERANCE, 0},
{909, 3381255420u, 0u, 3224136418u, 0, TANF_TOLERANCE, 0},
{910, 3040485181u, 4294241104u, 3040485181u, 0, TANF_TOLERANCE, 0},
{911, 3388772093u, 0u, 3216206684u, 0, TANF_TOLERANCE, 0},
{912, 954670189u, 760u, 954670189u, 0, TANF_TOLERANCE, 0},
{913, 1319200415u, 4293050361u, 3194828150u, 0, TANF_TOLERANCE, 0},
{914, 1279324488u, 4294967293u, 3224898935u, 0, TANF_TOLERANCE, 0},
{915, 3217795424u, 0u, 1111812957u, 0, TANF_TOLERANCE, 0},
{916, 3455131757u, 10314665u, 1036377031u, 0, TANF_TOLERANCE, 0},
{917, 1246947517u, 6u, 1037004901u, 0, TANF_TOLERANCE, 0},
{918, 3396723577u, 0u, 3223712291u, 0, TANF_TOLERANCE, 0},
{919, 3433761025u, 0u, 1060669919u, 0, TANF_TOLERANCE, 0},
{920, 3201187455u, 0u, 3201969320u, 0, TANF_TOLERANCE, 0},
{921, 1173247961u, 32661u, 3213189930u, 0, TANF_TOLERANCE, 0},
{922, 3037297123u, 4294904338u, 3037297123u, 0, TANF_TOLERANCE, 0},
{923, 3248534678u, 1927801856u, 3224995767u, 0, TANF_TOLERANCE, 0},
{924, 3083019343u, 0u, 3083019343u, 0, TANF_TOLERANCE, 0},
{925, 3042018375u, 0u, 3042018375u, 0, TANF_TOLERANCE, 0},
{926, 1082862511u, 0u, 1076385558u, 0, TANF_TOLERANCE, 0},
{927, 3157626955u, 3075906560u, 3157627442u, 0, TANF_TOLERANCE, 0},
{928, 1341821683u, 0u, 3246356184u, 0, TANF_TOLERANCE, 0},
{929, 881101379u, 32095u, 881101379u, 0, TANF_TOLERANCE, 0},
{930, 1079061705u, 0u, 1040351757u, 0, TANF_TOLERANCE, 0},
{931, 3182695954u, 4294967257u, 3182726467u, 0, TANF_TOLERANCE, 0},
{932, 1105291533u, 3424974848u, 3184094792u, 0, TANF_TOLERANCE, 0},
{933, 1016023520u, 4294967293u, 1016024478u, 0, TANF_TOLERANCE, 0},
{934, 3370691006u, 198615840u, 1066418799u, 0, TANF_TOLERANCE, 0},
{935, 1156767169u, 0u, 1088078700u, 0, TANF_TOLERANCE, 0},
{936, 3077020499u, 0u, 3077020499u, 0, TANF_TOLERANCE, 0},
{937, 1104284039u, 0u, 1074060849u, 0, TANF_TOLERANCE, 0},
{938, 3335212901u, 1662125568u, 1078246146u, 0, TANF_TOLERANCE, 0},
{939, 1093697541u, 0u, 3252690424u, 0, TANF_TOLERANCE, 0},
{940, 3266691185u, 2645u, 1047534875u, 0, TANF_TOLERANCE, 0},
{941, 3179003144u, 37u, 3179023948u, 0, TANF_TOLERANCE, 0},
{942, 1094115255u, 0u, 3221885590u, 0, TANF_TOLERANCE, 0},
{943, 3424086808u, 4294967244u, 3206909502u, 0, TANF_TOLERANCE, 0},
{944, 3353608773u, 305u, 1071385573u, 0, TANF_TOLERANCE, 0},
{945, 973664327u, 1394344832u, 973664328u, 0, TANF_TOLERANCE, 0},
{946, 882878091u, 0u, 882878091u, 0, TANF_TOLERANCE, 0},
{947, 1098662266u, 0u, 1030614291u, 0, TANF_TOLERANCE, 0},
{948, 927582555u, 0u, 927582555u, 0, TANF_TOLERANCE, 0},
{949, 3111440310u, 0u, 3111440310u, 0, TANF_TOLERANCE, 0},
{950, 3476083859u, 0u, 1033621363u, 0, TANF_TOLERANCE, 0},
{951, 3038754840u, 0u, 3038754840u, 0, TANF_TOLERANCE, 0},
{952, 979878744u, 1008405u, 979878748u, 0, TANF_TOLERANCE, 0},
{953, 3464546616u, 0u, 3247225494u, 0, TANF_TOLERANCE, 0},
{954, 1002542205u, 0u, 1002542353u, 0, TANF_TOLERANCE, 0},
{955, 3443552129u, 0u, 3195730557u, 0, TANF_TOLERANCE, 0},
{956, 1287620154u, 0u, 1073814380u, 0, TANF_TOLERANCE, 0},
{957, 946058434u, 4207447u, 946058434u, 0, TANF_TOLERANCE, 0},
{958, 3073260205u, 0u, 3073260205u, 0, TANF_TOLERANCE, 0},
{959, 1245702957u, 0u, 1050411430u, 0, TANF_TOLERANCE, 0},
{960, 989655126u, 528989952u, 989655147u, 0, TANF_TOLERANCE, 0},
{961, 1002715618u, 32425u, 1002715772u, 0, TANF_TOLERANCE, 0},
{962, 3087802274u, 0u, 3087802274u, 0, TANF_TOLERANCE, 0},
{963, 1000863905u, 54834u, 1000864001u, 0, TANF_TOLERANCE, 0},
{964, 3415763001u, 0u, 1069372312u, 0, TANF_TOLERANCE, 0},
{965, 3283471961u, 10190634u, 1065823474u, 0, TANF_TOLERANCE, 0},
{966, 3311210827u, 36713u, 1052531529u, 0, TANF_TOLERANCE, 0},
{967, 3026311911u, 0u, 3026311911u, 0, TANF_TOLERANCE, 0},
{968, 1198307901u, 68u, 1067889968u, 0, TANF_TOLERANCE, 0},
{969, 1288901567u, 206618288u, 3211520956u, 0, TANF_TOLERANCE, 0},
{970, 922255363u, 0u, 922255363u, 0, TANF_TOLERANCE, 0},
{971, 1113104661u, 0u, 1064212853u, 0, TANF_TOLERANCE, 0},
{972, 1136714348u, 0u, 3208733877u, 0, TANF_TOLERANCE, 0},
{973, 948856035u, 0u, 948856035u, 0, TANF_TOLERANCE, 0},
{974, 1062512367u, 4294967293u, 1066149378u, 0, TANF_TOLERANCE, 0},
{975, 3486907092u, 0u, 1064674781u, 0, TANF_TOLERANCE, 0},
{976, 1162027071u, 4294964303u, 3211005030u, 0, TANF_TOLERANCE, 0},
{977, 1034561811u, 0u, 1034587543u, 0, TANF_TOLERANCE, 0},
{978, 3271615417u, 0u, 3182227529u, 0, TANF_TOLERANCE, 0},
{979, 1042014529u, 869u, 1042094177u, 0, TANF_TOLERANCE, 0},
{980, 1177157787u, 0u, 1065883147u, 0, TANF_TOLERANCE, 0},
{981, 3196144817u, 0u, 3196329674u, 0, TANF_TOLERANCE, 0},
{982, 3432084552u, 0u, 3221944554u, 0, TANF_TOLERANCE, 0},
{983, 1309658335u, 0u, 3205458472u, 0, TANF_TOLERANCE, 0},
{984, 1226494979u, 0u, 3234449269u, 0, TANF_TOLERANCE, 0},
{985, 3100289712u, 3743522688u, 3100289712u, 0, TANF_TOLERANCE, 0},
{986, 3375507013u, 462886112u, 1058971981u, 0, TANF_TOLERANCE, 0},
{987, 3460699001u, 0u, 1145143987u, 0, TANF_TOLERANCE, 0},
{988, 3079231719u, 0u, 3079231719u, 0, TANF_TOLERANCE, 0},
{989, 3093951884u, 0u, 3093951884u, 0, TANF_TOLERANCE, 0},
{990, 3468023178u, 156157u, 3238327698u, 0, TANF_TOLERANCE, 0},
{991, 1204196034u, 4294966040u, 1080126796u, 0, TANF_TOLERANCE, 0},
{992, 3459877411u, 0u, 3237605854u, 0, TANF_TOLERANCE, 0},
{993, 909696559u, 3378u, 909696559u, 0, TANF_TOLERANCE, 0},
{994, 1161439847u, 0u, 1055184394u, 0, TANF_TOLERANCE, 0},
{995, 908663107u, 0u, 908663107u, 0, TANF_TOLERANCE, 0},
{996, 1055319316u, 4294967238u, 1056436046u, 0, TANF_TOLERANCE, 0},
{997, 1084378658u, 0u, 3223991873u, 0, TANF_TOLERANCE, 0},
{998, 3053887750u, 4294922339u, 3053887750u, 0, TANF_TOLERANCE, 0},
{999, 3022828828u, 0u, 3022828828u, 0, TANF_TOLERANCE, 0},
{1000, 1226473697u, 0u, 1057671157u, 0, TANF_TOLERANCE, 0},
{1001, 1123114742u, 841711u, 1080756932u, 0, TANF_TOLERANCE, 0},
{1002, 1258114435u, 130141336u, 3205684831u, 0, TANF_TOLERANCE, 0},
{1003, 3468040845u, 0u, 1060841431u, 0, TANF_TOLERANCE, 0},
{1004, 1178825761u, 54u, 3212909688u, 0, TANF_TOLERANCE, 0},
{1005, 3059266302u, 0u, 3059266302u, 0, TANF_TOLERANCE, 0},
{1006, 3223384012u, 225u, 1060730485u, 0, TANF_TOLERANCE, 0},
{1007, 1019964626u, 1299605u, 1019967367u, 0, TANF_TOLERANCE, 0},
{1008, 3445262427u, 3129568512u, 3213611207u, 0, TANF_TOLERANCE, 0},
{1009, 1125653081u, 129823u, 1080850023u, 0, TANF_TOLERANCE, 0},
{1010, 3337652712u, 0u, 3230359910u, 0, TANF_TOLERANCE, 0},
{1011, 1184753508u, 0u, 3228668908u, 0, TANF_TOLERANCE, 0},
{1012, 996404791u, 4294853343u, 996404851u, 0, TANF_TOLERANCE, 0},
{1013, 1188439315u, 55u, 1041338502u, 0, TANF_TOLERANCE, 0},
{1014, 906557513u, 0u, 906557513u, 0, TANF_TOLERANCE, 0},
{1015, 916831283u, 0u, 916831283u, 0, TANF_TOLERANCE, 0},
{1016, 996786317u, 0u, 996786382u, 0, TANF_TOLERANCE, 0},
{1017, 3461635065u, 0u, 1067126850u, 0, TANF_TOLERANCE, 0},
{1018, 1188167943u, 74707u, 1071485055u, 0, TANF_TOLERANCE, 0},
{1019, 3036502395u, 7309u, 3036502395u, 0, TANF_TOLERANCE, 0},
{1020, 891257783u, 18537700u, 891257783u, 0, TANF_TOLERANCE, 0},
{1021, 3290079438u, 0u, 1053635373u, 0, TANF_TOLERANCE, 0},
{1022, 3350690327u, 0u, 3197180407u, 0, TANF_TOLERANCE, 0},
{1023, 1102061604u, 4253821380u, 1019813152u, 0, TANF_TOLERANCE, 0},
{1024, 1282351521u, 0u, 3214248829u, 0, TANF_TOLERANCE, 0},
{1025, 3458861065u, 4292002951u, 1063733247u, 0, TANF_TOLERANCE, 0},
{1026, 3095256878u, 0u, 3095256878u, 0, TANF_TOLERANCE, 0},
{1027, 3163373610u, 0u, 3163374527u, 0, TANF_TOLERANCE, 0},
{1028, 3228793330u, 0u, 3209153947u, 0, TANF_TOLERANCE, 0},
{1029, 3422194733u, 0u, 3234741565u, 0, TANF_TOLERANCE, 0},
{1030, 3083885296u, 0u, 3083885296u, 0, TANF_TOLERANCE, 0},
{1031, 1261940623u, 4288291120u, 1066943232u, 0, TANF_TOLERANCE, 0},
{1032, 3400603081u, 4294967290u, 1082458884u, 0, TANF_TOLERANCE, 0},
{1033, 1219411812u, 0u, 3213563946u, 0, TANF_TOLERANCE, 0},
{1034, 3094833770u, 0u, 3094833770u, 0, TANF_TOLERANCE, 0},
{1035, 3139250800u, 0u, 3139250820u, 0, TANF_TOLERANCE, 0},
{1036, 886201503u, 4294967150u, 886201503u, 0, TANF_TOLERANCE, 0},
{1037, 3297366026u, 7u, 1045248836u, 0, TANF_TOLERANCE, 0},
{1038, 1218488455u, 4294964141u, 3193210449u, 0, TANF_TOLERANCE, 0},
{1039, 3040358923u, 0u, 3040358923u, 0, TANF_TOLERANCE, 0},
{1040, 1283938137u, 53086u, 1043714569u, 0, TANF_TOLERANCE, 0},
{1041, 3182551696u, 0u, 3182581102u, 0, TANF_TOLERANCE, 0},
{1042, 1317098613u, 0u, 1084069604u, 0, TANF_TOLERANCE, 0},
{1043, 3116209179u, 4294965434u, 3116209180u, 0, TANF_TOLERANCE, 0},
{1044, 3431703657u, 0u, 3209060142u, 0, TANF_TOLERANCE, 0},
{1045, 3239728775u, 0u, 3194384213u, 0, TANF_TOLERANCE, 0},
{1046, 3207141672u, 0u, 3209095053u, 0, TANF_TOLERANCE, 0},
{1047, 3154378805u, 0u, 3154378992u, 0, TANF_TOLERANCE, 0},
{1048, 3069658155u, 0u, 3069658155u, 0, TANF_TOLERANCE, 0},
{1049, 3313160088u, 0u, 3222486976u, 0, TANF_TOLERANCE, 0},
{1050, 3207056527u, 4293469023u, 3208959043u, 0, TANF_TOLERANCE, 0},
{1051, 1284174954u, 4180334232u, 3226552351u, 0, TANF_TOLERANCE, 0},
{1052, 3156081645u, 4294964338u, 3156081966u, 0, TANF_TOLERANCE, 0},
{1053, 1063693032u, 0u, 1067558305u, 0, TANF_TOLERANCE, 0},
{1054, 3036026175u, 4845007u, 3036026175u, 0, TANF_TOLERANCE, 0},
{1055, 1102631663u, 4290881696u, 1073841275u, 0, TANF_TOLERANCE, 0},
{1056, 968803479u, 0u, 968803480u, 0, TANF_TOLERANCE, 0},
{1057, 3273080388u, 0u, 3203746534u, 0, TANF_TOLERANCE, 0},
{1058, 1172529774u, 4294966405u, 1053400161u, 0, TANF_TOLERANCE, 0},
{1059, 1306695905u, 147733664u, 3218662868u, 0, TANF_TOLERANCE, 0},
{1060, 1003649752u, 338518u, 1003649942u, 0, TANF_TOLERANCE, 0},
{1061, 1078478376u, 2364151808u, 3158947134u, 0, TANF_TOLERANCE, 0},
{1062, 3158855023u, 0u, 3158855677u, 0, TANF_TOLERANCE, 0},
{1063, 1165177679u, 4294967097u, 3224534299u, 0, TANF_TOLERANCE, 0},
{1064, 3403009513u, 4293749042u, 3201343705u, 0, TANF_TOLERANCE, 0},
{1065, 952348506u, 4294108410u, 952348506u, 0, TANF_TOLERANCE, 0},
{1066, 1222777442u, 153u, 1066942837u, 0, TANF_TOLERANCE, 0},
{1067, 1325324763u, 0u, 3206284830u, 0, TANF_TOLERANCE, 0},
{1068, 3363524213u, 0u, 3206324887u, 0, TANF_TOLERANCE, 0},
{1069, 1158950321u, 1u, 3218962430u, 0, TANF_TOLERANCE, 0},
{1070, 903129873u, 4272788450u, 903129873u, 0, TANF_TOLERANCE, 0},
{1071, 3078339944u, 0u, 3078339944u, 0, TANF_TOLERANCE, 0},
{1072, 1208345407u, 6333643u, 3225922734u, 0, TANF_TOLERANCE, 0},
{1073, 1258634105u, 3575206u, 3197506179u, 0, TANF_TOLERANCE, 0},
{1074, 1248478509u, 102613680u, 3264157759u, 0, TANF_TOLERANCE, 0},
{1075, 1153863988u, 4229464460u, 3221249357u, 0, TANF_TOLERANCE, 0},
{1076, 1235620969u, 0u, 3226071801u, 0, TANF_TOLERANCE, 0},
{1077, 1097120930u, 4294967294u, 3234313315u, 0, TANF_TOLERANCE, 0},
{1078, 3469778622u, 70286u, 3247090687u, 0, TANF_TOLERANCE, 0},
{1079, 1147712200u, 0u, 1067154089u, 0, TANF_TOLERANCE, 0},
{1080, 1124721745u, 0u, 3199473163u, 0, TANF_TOLERANCE, 0},
{1081, 3261744304u, 0u, 1074089254u, 0, TANF_TOLERANCE, 0},
{1082, 1064922416u, 1518435840u, 1069319457u, 0, TANF_TOLERANCE, 0},
{1083, 3303160152u, 0u, 3195323188u, 0, TANF_TOLERANCE, 0},
{1084, 1315090496u, 4294967183u, 1027295675u, 0, TANF_TOLERANCE, 0},
{1085, 3230403187u, 1820050432u, 3224842200u, 0, TANF_TOLERANCE, 0},
{1086, 1335399673u, 0u, 1058375572u, 0, TANF_TOLERANCE, 0},
{1087, 1072458508u, 4294404660u, 3227633324u, 0, TANF_TOLERANCE, 0},
{1088, 3303015249u, 0u, 3233088608u, 0, TANF_TOLERANCE, 0},
{1089, 3252139741u, 0u, 1081072463u, 0, TANF_TOLERANCE, 0},
{1090, 3468519966u, 0u, 1095853277u, 0, TANF_TOLERANCE, 0},
{1091, 1006231203u, 0u, 1006231520u, 0, TANF_TOLERANCE, 0},
{1092, 951554138u, 0u, 951554138u, 0, TANF_TOLERANCE, 0},
{1093, 942046828u, 0u, 942046828u, 0, TANF_TOLERANCE, 0},
{1094, 3319723279u, 4277552160u, 3181034131u, 0, TANF_TOLERANCE, 0},
{1095, 3255104167u, 0u, 1081762853u, 0, TANF_TOLERANCE, 0},
{1096, 1155477903u, 0u, 1074109354u, 0, TANF_TOLERANCE, 0},
{1097, 3273889176u, 0u, 3194397309u, 0, TANF_TOLERANCE, 0},
{1098, 3237813668u, 4133749200u, 1099890553u, 0, TANF_TOLERANCE, 0},
{1099, 1228207362u, 0u, 1070890926u, 0, TANF_TOLERANCE, 0},
{1100, 975349337u, 748694784u, 975349338u, 0, TANF_TOLERANCE, 0},
{1101, 1290175785u, 0u, 1065643442u, 0, TANF_TOLERANCE, 0},
{1102, 981908840u, 4294962938u, 981908843u, 0, TANF_TOLERANCE, 0},
{1103, 941187647u, 33u, 941187647u, 0, TANF_TOLERANCE, 0},
{1104, 1214223128u, 4294967293u, 3175410167u, 0, TANF_TOLERANCE, 0},
{1105, 3422922584u, 6u, 3204371032u, 0, TANF_TOLERANCE, 0},
{1106, 1315857601u, 1055172096u, 3212838470u, 0, TANF_TOLERANCE, 0},
{1107, 3453226030u, 4294967291u, 3204290872u, 0, TANF_TOLERANCE, 0},
{1108, 1078359574u, 0u, 3173419168u, 0, TANF_TOLERANCE, 0},
{1109, 1029557624u, 4294965511u, 1029571849u, 0, TANF_TOLERANCE, 0},
{1110, 1207675424u, 0u, 3190987846u, 0, TANF_TOLERANCE, 0},
{1111, 1028355074u, 4113313408u, 1028366050u, 0, TANF_TOLERANCE, 0},
{1112, 3119299090u, 24787u, 3119299091u, 0, TANF_TOLERANCE, 0},
{1113, 1248421894u, 4294582111u, 1062987066u, 0, TANF_TOLERANCE, 0},
{1114, 3353251994u, 12u, 3230764707u, 0, TANF_TOLERANCE, 0},
{1115, 876926659u, 4294966792u, 876926659u, 0, TANF_TOLERANCE, 0},
{1116, 1076752219u, 0u, 3202811089u, 0, TANF_TOLERANCE, 0},
{1117, 3388531942u, 0u, 1002890227u, 0, TANF_TOLERANCE, 0},
{1118, 1273395082u, 0u, 3196206979u, 0, TANF_TOLERANCE, 0},
{1119, 3385588183u, 4294967251u, 1087246844u, 0, TANF_TOLERANCE, 0},
{1120, 3192315328u, 4294966714u, 3192481686u, 0, TANF_TOLERANCE, 0},
{1121, 3441804648u, 4294967121u, 3229962545u, 0, TANF_TOLERANCE, 0},
{1122, 3392827417u, 45125368u, 1059127667u, 0, TANF_TOLERANCE, 0},
{1123, 1161241793u, 2814016256u, 3213239434u, 0, TANF_TOLERANCE, 0},
{1124, 3034494183u, 0u, 3034494183u, 0, TANF_TOLERANCE, 0},
{1125, 1171318485u, 4294306215u, 3204093878u, 0, TANF_TOLERANCE, 0},
{1126, 3047748143u, 0u, 3047748143u, 0, TANF_TOLERANCE, 0},
{1127, 1001216371u, 0u, 1001216477u, 0, TANF_TOLERANCE, 0},
{1128, 912515889u, 2u, 912515889u, 0, TANF_TOLERANCE, 0},
{1129, 3391452505u, 0u, 1060706149u, 0, TANF_TOLERANCE, 0},
{1130, 3249603369u, 0u, 3188424533u, 0, TANF_TOLERANCE, 0},
{1131, 1220264047u, 0u, 1047931096u, 0, TANF_TOLERANCE, 0},
{1132, 3169816394u, 0u, 3169820871u, 0, TANF_TOLERANCE, 0},
{1133, 3098997418u, 0u, 3098997418u, 0, TANF_TOLERANCE, 0},
{1134, 3282212423u, 0u, 1112557809u, 0, TANF_TOLERANCE, 0},
{1135, 3352293320u, 4294967278u, 3226389131u, 0, TANF_TOLERANCE, 0},
{1136, 3296358441u, 0u, 1054993302u, 0, TANF_TOLERANCE, 0},
{1137, 1197828352u, 4294967281u, 1032407318u, 0, TANF_TOLERANCE, 0},
{1138, 3340510371u, 0u, 1069696271u, 0, TANF_TOLERANCE, 0},
{1139, 1127109339u, 4294570975u, 1105605562u, 0, TANF_TOLERANCE, 0},
{1140, 909467381u, 1001724u, 909467381u, 0, TANF_TOLERANCE, 0},
{1141, 1200599955u, 0u, 3216216244u, 0, TANF_TOLERANCE, 0},
{1142, 962230977u, 0u, 962230977u, 0, TANF_TOLERANCE, 0},
{1143, 3192887808u, 0u, 3193077326u, 0, TANF_TOLERANCE, 0},
{1144, 3237183876u, 0u, 3229633984u, 0, TANF_TOLERANCE, 0},
{1145, 939285924u, 0u, 939285924u, 0, TANF_TOLERANCE, 0},
{1146, 944050180u, 3871652128u, 944050180u, 0, TANF_TOLERANCE, 0},
{1147, 3058135703u, 0u, 3058135703u, 0, TANF_TOLERANCE, 0},
{1148, 3480592662u, 4294967238u, 1058275636u, 0, TANF_TOLERANCE, 0},
{1149, 3061939312u, 4294967125u, 3061939312u, 0, TANF_TOLERANCE, 0},
{1150, 1003299981u, 0u, 1003300157u, 0, TANF_TOLERANCE, 0},
{1151, 1155775526u, 7150230u, 3195997040u, 0, TANF_TOLERANCE, 0},
{1152, 1234491880u, 4283784819u, 3230107658u, 0, TANF_TOLERANCE, 0}

// AUTOMATICALLY GENERATED VECTORS STOP

};

#endif // CYGONCE_LIBM_SCABNF_H multiple inclusion protection

// EOF tanf.h
