#ifndef CYGONCE_LIBM_SQRT_H
#define CYGONCE_LIBM_SQRT_H
//===========================================================================
//
//      sqrtf.h
//
//      Test vectors for testing of sqrtf() math library function
//
//===========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####
// -------------------------------------------
// This file is part of eCos, the Embedded Configurable Operating System.
// Copyright (C) 2012 Free Software Foundation, Inc.
//
// eCos is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 or (at your option) any later
// version.
//
// eCos is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
// for more details.
//
// You should have received a copy of the GNU General Public License
// along with eCos; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//
// As a special exception, if other files instantiate templates or use
// macros or inline functions from this file, or you compile this file
// and link it with other works to produce a work based on this file,
// this file does not by itself cause the resulting work to be covered by
// the GNU General Public License. However the source code for this file
// must still be made available in accordance with section (3) of the GNU
// General Public License v2.
//
// This exception does not invalidate any other reasons why a work based
// on this file might be covered by the GNU General Public License.
// -------------------------------------------
// ####ECOSGPLCOPYRIGHTEND####
//===========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):
// Contributors:  visar, ilijak
// Date:        1998-02-13
// Purpose:
// Description:
// Usage:       #include "vectors/sqrtf.h"
//
//####DESCRIPTIONEND####
//
//===========================================================================


// CONFIGURATION

#include <pkgconf/libm.h>   // Configuration header

// INCLUDES

#include <cyg/infra/cyg_type.h>    // Common type definitions and support
#include "vectors/vector_support_float.h"// extra support for math tests

#define SQRT_TOLERANCE 1.0E-04

static const Cyg_libm_test_float_vec_t sqrtf_vec[] = {

// AUTOMATICALLY GENERATED VECTORS START

{0, 3214514586u, 1090024059u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{1, 3214430700u, 1051524793u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{2, 3214346813u, 3232101343u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{3, 3214262927u, 3201242716u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{4, 3214179041u, 1100049309u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{5, 3214095155u, 1054478713u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{6, 3214011269u, 3202039382u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{7, 3213927383u, 1046089230u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{8, 3213843497u, 1045840574u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{9, 3213759611u, 1068931671u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{10, 3213675725u, 3222889559u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{11, 3213591839u, 1088899021u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{12, 3213507953u, 1066856791u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{13, 3213424067u, 1080833116u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{14, 3213340180u, 3191644264u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{15, 3213256294u, 3239903247u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{16, 3213172408u, 3198462609u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{17, 3213088522u, 3203741999u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{18, 3213004636u, 3249401130u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{19, 3212920750u, 3197817016u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{20, 3212836864u, 3231746400u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{21, 3212669092u, 1096608669u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{22, 3212501320u, 1045286891u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{23, 3212333548u, 1049342524u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{24, 3212165775u, 1078472138u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{25, 3211998003u, 1099527247u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{26, 3211830231u, 3189610016u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{27, 3211662459u, 1083791358u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{28, 3211494687u, 3214426435u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{29, 3211326915u, 1056316170u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{30, 3211159142u, 3251828686u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{31, 3210991370u, 3240257920u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{32, 3210823598u, 3237899261u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{33, 3210655826u, 3226869477u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{34, 3210488054u, 1106394906u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{35, 3210320282u, 3231581370u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{36, 3210152509u, 1061652681u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{37, 3209984737u, 3215417793u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{38, 3209816965u, 3238067573u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{39, 3209649193u, 1045917232u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{40, 3209481421u, 1066381836u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{41, 3209313649u, 1060345752u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{42, 3209145876u, 1052460275u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{43, 3208978104u, 3196647153u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{44, 3208810332u, 1081948134u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{45, 3208642560u, 3221584595u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{46, 3208474788u, 1086226574u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{47, 3208307016u, 3251401196u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{48, 3208139244u, 1083520023u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{49, 3207971471u, 1050330591u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{50, 3207803699u, 1077406406u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{51, 3207635927u, 3220729740u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{52, 3207468155u, 1046304788u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{53, 3207300383u, 1094907481u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{54, 3207132611u, 1065432625u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{55, 3206964838u, 1082985198u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{56, 3206797066u, 3222902057u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{57, 3206629294u, 3249723525u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{58, 3206461522u, 1067056698u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{59, 3206293750u, 3209056785u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{60, 3206125978u, 1106787580u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{61, 3205958205u, 1104232051u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{62, 3205790433u, 1105467109u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{63, 3205622661u, 3214251949u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{64, 3205454889u, 1103073830u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{65, 3205287117u, 1067009473u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{66, 3205119345u, 1101371955u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{67, 3204951572u, 1099430098u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{68, 3204783800u, 3188865420u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{69, 3204616028u, 1046255144u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{70, 3204448256u, 3231633258u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{71, 3204112712u, 3202219056u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{72, 3203777167u, 1048653554u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{73, 3203441623u, 3221570188u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{74, 3203106079u, 1099107978u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{75, 3202770534u, 1087299442u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{76, 3202434990u, 3197285510u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{77, 3202099446u, 1090971734u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{78, 3201763901u, 3252967851u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{79, 3201428357u, 3206610957u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{80, 3201092813u, 1073415902u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{81, 3200757268u, 3190678390u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{82, 3200421724u, 3205337291u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{83, 3200086180u, 3216653996u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{84, 3199750636u, 3240198679u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{85, 3199415091u, 3251167793u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{86, 3199079547u, 1079286273u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{87, 3198744003u, 3231412671u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{88, 3198408458u, 1048317852u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{89, 3198072914u, 3192982124u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{90, 3197737370u, 1104691287u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{91, 3197401825u, 1082507103u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{92, 3197066281u, 1096584871u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{93, 3196730737u, 1103798670u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{94, 3196395192u, 3240157452u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{95, 3196059648u, 3214382367u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{96, 3195388559u, 3240200923u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{97, 3194717471u, 1103793878u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{98, 3194046382u, 1077424413u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{99, 3193375293u, 3227593179u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{100, 3192704205u, 1076579751u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{101, 3192033116u, 1069112254u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{102, 3191362028u, 3215075200u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{103, 3190690939u, 1060430241u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{104, 3190019850u, 3237198975u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{105, 3189348762u, 3202753937u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{106, 3188677673u, 1062342831u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{107, 3188006584u, 1066474375u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{108, 3186999951u, 3239267288u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{109, 3185657774u, 3210508124u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{110, 3184315597u, 3241241441u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{111, 3182973420u, 3243941101u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{112, 3181631242u, 1074261978u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{113, 3180289065u, 1061635587u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{114, 3178611343u, 1071440059u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{115, 3175926989u, 1072073912u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{116, 3173242634u, 3232757923u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{117, 3170222735u, 1078073146u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{118, 3164854026u, 1081649113u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{119, 3156465418u, 3222407050u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{120, 646742016u, 1105124431u, 856038076u, 0, SQRT_TOLERANCE, 0},
{121, 1008981770u, 3198136112u, 1036831949u, 0, SQRT_TOLERANCE, 0},
{122, 1017370378u, 3215264397u, 1041289411u, 0, SQRT_TOLERANCE, 0},
{123, 1022739087u, 1061072607u, 1043422380u, 0, SQRT_TOLERANCE, 0},
{124, 1025758986u, 1082896196u, 1045220557u, 0, SQRT_TOLERANCE, 0},
{125, 1028443341u, 3187675097u, 1046804782u, 0, SQRT_TOLERANCE, 0},
{126, 1031127695u, 3234748208u, 1048237031u, 0, SQRT_TOLERANCE, 0},
{127, 1032805417u, 1046724025u, 1049065060u, 0, SQRT_TOLERANCE, 0},
{128, 1034147594u, 1093012318u, 1049678019u, 0, SQRT_TOLERANCE, 0},
{129, 1035489772u, 1069733884u, 1050253722u, 0, SQRT_TOLERANCE, 0},
{130, 1036831949u, 3204997271u, 1050798235u, 0, SQRT_TOLERANCE, 0},
{131, 1038174126u, 3213604117u, 1051316138u, 0, SQRT_TOLERANCE, 0},
{132, 1039516303u, 3246333414u, 1051810988u, 0, SQRT_TOLERANCE, 0},
{133, 1040522936u, 1082858682u, 1052285615u, 0, SQRT_TOLERANCE, 0},
{134, 1041194025u, 1083603224u, 1052742311u, 0, SQRT_TOLERANCE, 0},
{135, 1041865114u, 3235600523u, 1053182968u, 0, SQRT_TOLERANCE, 0},
{136, 1042536202u, 1051824459u, 1053609165u, 0, SQRT_TOLERANCE, 0},
{137, 1043207291u, 3250673860u, 1054022239u, 0, SQRT_TOLERANCE, 0},
{138, 1043878380u, 1049514449u, 1054423332u, 0, SQRT_TOLERANCE, 0},
{139, 1044549468u, 1054539840u, 1054813430u, 0, SQRT_TOLERANCE, 0},
{140, 1045220557u, 1045993352u, 1055193390u, 0, SQRT_TOLERANCE, 0},
{141, 1045891645u, 3229182089u, 1055563964u, 0, SQRT_TOLERANCE, 0},
{142, 1046562734u, 1071630912u, 1055925816u, 0, SQRT_TOLERANCE, 0},
{143, 1047233823u, 1063422305u, 1056279532u, 0, SQRT_TOLERANCE, 0},
{144, 1047904911u, 1040201163u, 1056625639u, 0, SQRT_TOLERANCE, 0},
{145, 1048576000u, 1101553990u, 1056964608u, 0, SQRT_TOLERANCE, 0},
{146, 1048911544u, 1042678728u, 1057130735u, 0, SQRT_TOLERANCE, 0},
{147, 1049247089u, 1070002807u, 1057293697u, 0, SQRT_TOLERANCE, 0},
{148, 1049582633u, 1104170406u, 1057453668u, 0, SQRT_TOLERANCE, 0},
{149, 1049918177u, 1060859316u, 1057610807u, 0, SQRT_TOLERANCE, 0},
{150, 1050253722u, 1067940450u, 1057765260u, 0, SQRT_TOLERANCE, 0},
{151, 1050589266u, 3236511256u, 1057917159u, 0, SQRT_TOLERANCE, 0},
{152, 1050924810u, 3250520938u, 1058066627u, 0, SQRT_TOLERANCE, 0},
{153, 1051260355u, 3209806504u, 1058213777u, 0, SQRT_TOLERANCE, 0},
{154, 1051595899u, 3202890678u, 1058358714u, 0, SQRT_TOLERANCE, 0},
{155, 1051931443u, 3203138231u, 1058501535u, 0, SQRT_TOLERANCE, 0},
{156, 1052266988u, 1061134072u, 1058642330u, 0, SQRT_TOLERANCE, 0},
{157, 1052602532u, 1055663370u, 1058781182u, 0, SQRT_TOLERANCE, 0},
{158, 1052938076u, 3199478070u, 1058918171u, 0, SQRT_TOLERANCE, 0},
{159, 1053273620u, 3196654963u, 1059053368u, 0, SQRT_TOLERANCE, 0},
{160, 1053609165u, 3232578253u, 1059186843u, 0, SQRT_TOLERANCE, 0},
{161, 1053944709u, 1050082319u, 1059318660u, 0, SQRT_TOLERANCE, 0},
{162, 1054280253u, 3253385962u, 1059448879u, 0, SQRT_TOLERANCE, 0},
{163, 1054615798u, 1070166500u, 1059577556u, 0, SQRT_TOLERANCE, 0},
{164, 1054951342u, 3244621407u, 1059704746u, 0, SQRT_TOLERANCE, 0},
{165, 1055286886u, 3200798890u, 1059830499u, 0, SQRT_TOLERANCE, 0},
{166, 1055622431u, 3223590310u, 1059954862u, 0, SQRT_TOLERANCE, 0},
{167, 1055957975u, 1075961161u, 1060077880u, 0, SQRT_TOLERANCE, 0},
{168, 1056293519u, 1078123323u, 1060199596u, 0, SQRT_TOLERANCE, 0},
{169, 1056629064u, 3210844787u, 1060320051u, 0, SQRT_TOLERANCE, 0},
{170, 1056964608u, 3246307879u, 1060439283u, 0, SQRT_TOLERANCE, 0},
{171, 1057132380u, 3188814424u, 1060557329u, 0, SQRT_TOLERANCE, 0},
{172, 1057300152u, 3221436876u, 1060674223u, 0, SQRT_TOLERANCE, 0},
{173, 1057467924u, 3200554324u, 1060789998u, 0, SQRT_TOLERANCE, 0},
{174, 1057635697u, 3239246636u, 1060904686u, 0, SQRT_TOLERANCE, 0},
{175, 1057803469u, 3223587064u, 1061018316u, 0, SQRT_TOLERANCE, 0},
{176, 1057971241u, 3250158026u, 1061130919u, 0, SQRT_TOLERANCE, 0},
{177, 1058139013u, 1106085272u, 1061242520u, 0, SQRT_TOLERANCE, 0},
{178, 1058306785u, 1095245453u, 1061353147u, 0, SQRT_TOLERANCE, 0},
{179, 1058474557u, 1041444355u, 1061462824u, 0, SQRT_TOLERANCE, 0},
{180, 1058642330u, 1097465301u, 1061571576u, 0, SQRT_TOLERANCE, 0},
{181, 1058810102u, 3250239076u, 1061679425u, 0, SQRT_TOLERANCE, 0},
{182, 1058977874u, 1084039594u, 1061786393u, 0, SQRT_TOLERANCE, 0},
{183, 1059145646u, 1063771493u, 1061892502u, 0, SQRT_TOLERANCE, 0},
{184, 1059313418u, 1103919063u, 1061997773u, 0, SQRT_TOLERANCE, 0},
{185, 1059481190u, 3194616071u, 1062102224u, 0, SQRT_TOLERANCE, 0},
{186, 1059648963u, 3221613219u, 1062205875u, 0, SQRT_TOLERANCE, 0},
{187, 1059816735u, 3208334452u, 1062308743u, 0, SQRT_TOLERANCE, 0},
{188, 1059984507u, 1061894279u, 1062410847u, 0, SQRT_TOLERANCE, 0},
{189, 1060152279u, 3209762784u, 1062512202u, 0, SQRT_TOLERANCE, 0},
{190, 1060320051u, 3206165386u, 1062612826u, 0, SQRT_TOLERANCE, 0},
{191, 1060487823u, 1057079837u, 1062712733u, 0, SQRT_TOLERANCE, 0},
{192, 1060655596u, 3217432469u, 1062811940u, 0, SQRT_TOLERANCE, 0},
{193, 1060823368u, 1079368611u, 1062910460u, 0, SQRT_TOLERANCE, 0},
{194, 1060991140u, 3243343143u, 1063008307u, 0, SQRT_TOLERANCE, 0},
{195, 1061158912u, 1041548088u, 1063105495u, 0, SQRT_TOLERANCE, 0},
{196, 1061326684u, 1045807374u, 1063202038u, 0, SQRT_TOLERANCE, 0},
{197, 1061494456u, 3212131720u, 1063297947u, 0, SQRT_TOLERANCE, 0},
{198, 1061662228u, 1052187689u, 1063393236u, 0, SQRT_TOLERANCE, 0},
{199, 1061830001u, 1102624859u, 1063487916u, 0, SQRT_TOLERANCE, 0},
{200, 1061997773u, 3246176356u, 1063581998u, 0, SQRT_TOLERANCE, 0},
{201, 1062165545u, 1051558014u, 1063675494u, 0, SQRT_TOLERANCE, 0},
{202, 1062333317u, 3207725532u, 1063768415u, 0, SQRT_TOLERANCE, 0},
{203, 1062501089u, 3190303581u, 1063860771u, 0, SQRT_TOLERANCE, 0},
{204, 1062668861u, 3230415151u, 1063952572u, 0, SQRT_TOLERANCE, 0},
{205, 1062836634u, 1090646554u, 1064043829u, 0, SQRT_TOLERANCE, 0},
{206, 1063004406u, 1046063872u, 1064134550u, 0, SQRT_TOLERANCE, 0},
{207, 1063172178u, 3194111199u, 1064224745u, 0, SQRT_TOLERANCE, 0},
{208, 1063339950u, 1047020885u, 1064314424u, 0, SQRT_TOLERANCE, 0},
{209, 1063507722u, 3193450280u, 1064403594u, 0, SQRT_TOLERANCE, 0},
{210, 1063675494u, 3235452527u, 1064492265u, 0, SQRT_TOLERANCE, 0},
{211, 1063843267u, 3219096387u, 1064580444u, 0, SQRT_TOLERANCE, 0},
{212, 1064011039u, 3200792376u, 1064668140u, 0, SQRT_TOLERANCE, 0},
{213, 1064178811u, 3237045253u, 1064755361u, 0, SQRT_TOLERANCE, 0},
{214, 1064346583u, 3206926643u, 1064842114u, 0, SQRT_TOLERANCE, 0},
{215, 1064514355u, 1085095743u, 1064928407u, 0, SQRT_TOLERANCE, 0},
{216, 1064682127u, 1099828675u, 1065014247u, 0, SQRT_TOLERANCE, 0},
{217, 1064849900u, 1102759382u, 1065099641u, 0, SQRT_TOLERANCE, 0},
{218, 1065017672u, 1091945628u, 1065184596u, 0, SQRT_TOLERANCE, 0},
{219, 1065185444u, 1096533424u, 1065269119u, 0, SQRT_TOLERANCE, 0},
{220, 1065353216u, 3212698915u, 1065353216u, 0, SQRT_TOLERANCE, 0},
{221, 1065437102u, 3229111426u, 1065395055u, 0, SQRT_TOLERANCE, 0},
{222, 1065520988u, 1089760910u, 1065436687u, 0, SQRT_TOLERANCE, 0},
{223, 1065604874u, 1075198900u, 1065478115u, 0, SQRT_TOLERANCE, 0},
{224, 1065688760u, 1065221325u, 1065519343u, 0, SQRT_TOLERANCE, 0},
{225, 1065772646u, 3235313361u, 1065560373u, 0, SQRT_TOLERANCE, 0},
{226, 1065856532u, 1042055360u, 1065601209u, 0, SQRT_TOLERANCE, 0},
{227, 1065940419u, 3194723421u, 1065641852u, 0, SQRT_TOLERANCE, 0},
{228, 1066024305u, 3212424262u, 1065682305u, 0, SQRT_TOLERANCE, 0},
{229, 1066108191u, 3241512456u, 1065722572u, 0, SQRT_TOLERANCE, 0},
{230, 1066192077u, 3211544311u, 1065762654u, 0, SQRT_TOLERANCE, 0},
{231, 1066275963u, 1058576726u, 1065802555u, 0, SQRT_TOLERANCE, 0},
{232, 1066359849u, 3205004060u, 1065842276u, 0, SQRT_TOLERANCE, 0},
{233, 1066443735u, 3223356436u, 1065881821u, 0, SQRT_TOLERANCE, 0},
{234, 1066527621u, 1098306332u, 1065921190u, 0, SQRT_TOLERANCE, 0},
{235, 1066611507u, 1091262633u, 1065960388u, 0, SQRT_TOLERANCE, 0},
{236, 1066695393u, 3194927008u, 1065999415u, 0, SQRT_TOLERANCE, 0},
{237, 1066779279u, 1066368383u, 1066038275u, 0, SQRT_TOLERANCE, 0},
{238, 1066863165u, 1098487295u, 1066076969u, 0, SQRT_TOLERANCE, 0},
{239, 1066947052u, 1070999426u, 1066115499u, 0, SQRT_TOLERANCE, 0},
{240, 3234402267u, 1101098363u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{241, 3231108068u, 1078368488u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{242, 3226013659u, 3230316437u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{243, 3217625051u, 1079833442u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{244, 0u, 1052873711u, 0u, 0, SQRT_TOLERANCE, 0},
{245, 1070141403u, 1085015978u, 1067478169u, 0, SQRT_TOLERANCE, 0},
{246, 1078530011u, 1074309900u, 1071833029u, 0, SQRT_TOLERANCE, 0},
{247, 1083624420u, 3228615456u, 1074458227u, 0, SQRT_TOLERANCE, 0},
{248, 3253731328u, 3230392165u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{249, 3252840038u, 3238056647u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{250, 3251948749u, 1048120593u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{251, 3251057459u, 1086112947u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{252, 3250166170u, 1100880260u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{253, 3249274880u, 3232200256u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{254, 3248383590u, 1076097908u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{255, 3247492301u, 1064816262u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{256, 3246601011u, 1065280276u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{257, 3245028147u, 1078398157u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{258, 3243245568u, 1103272172u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{259, 3241462989u, 3210023352u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{260, 3239680410u, 1085153597u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{261, 3237792973u, 1042831668u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{262, 3234227814u, 1065483445u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{263, 3230662656u, 3222430705u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{264, 3224580915u, 1084451053u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{265, 3213675725u, 1092243422u, 2143289344u, EDOM, SQRT_TOLERANCE, 0},
{266, 1058642330u, 1071545057u, 1061571576u, 0, SQRT_TOLERANCE, 0},
{267, 1075000115u, 3241990046u, 1069686562u, 0, SQRT_TOLERANCE, 0},
{268, 1082130432u, 1079333374u, 1073741824u, 0, SQRT_TOLERANCE, 0},
{269, 1085695590u, 3242081486u, 1075366980u, 0, SQRT_TOLERANCE, 0},
{270, 1089260749u, 1043425732u, 1076762956u, 0, SQRT_TOLERANCE, 0},
{271, 1091672474u, 3211529757u, 1078005840u, 0, SQRT_TOLERANCE, 0},
{272, 1093455053u, 3241441539u, 1079137105u, 0, SQRT_TOLERANCE, 0},
{273, 1095237632u, 1074522705u, 1080182320u, 0, SQRT_TOLERANCE, 0},
{274, 1097020211u, 1088658621u, 1081158565u, 0, SQRT_TOLERANCE, 0},
{275, 1098802790u, 3224596567u, 1082077921u, 0, SQRT_TOLERANCE, 0},
{276, 1099746509u, 1086207177u, 1082539870u, 0, SQRT_TOLERANCE, 0},
{277, 1100637798u, 1079361728u, 1082954983u, 0, SQRT_TOLERANCE, 0},
{278, 1101529088u, 1090937016u, 1083352182u, 0, SQRT_TOLERANCE, 0},
{279, 1102420378u, 1086260896u, 1083733603u, 0, SQRT_TOLERANCE, 0},
{280, 1103311667u, 3194387916u, 1084100991u, 0, SQRT_TOLERANCE, 0},
{281, 1104202957u, 3216442625u, 1084455788u, 0, SQRT_TOLERANCE, 0},
{282, 1105094246u, 1063475914u, 1084799206u, 0, SQRT_TOLERANCE, 0},
{283, 1105985536u, 3236646101u, 1085132275u, 0, SQRT_TOLERANCE, 0}

// AUTOMATICALLY GENERATED VECTORS STOP

};

#endif // CYGONCE_LIBM_SQRT_H multiple inclusion protection

// EOF sqrtf.h
