#ifndef CYGONCE_LIBM_SINHF_H
#define CYGONCE_LIBM_SINHF_H
//===========================================================================
//
//      sinhf.h
//
//      Test vectors for testing of sinhf() math library function
//
//===========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####
// -------------------------------------------
// This file is part of eCos, the Embedded Configurable Operating System.
// Copyright (C) 2012 Free Software Foundation, Inc.
//
// eCos is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 or (at your option) any later
// version.
//
// eCos is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
// for more details.
//
// You should have received a copy of the GNU General Public License
// along with eCos; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//
// As a special exception, if other files instantiate templates or use
// macros or inline functions from this file, or you compile this file
// and link it with other works to produce a work based on this file,
// this file does not by itself cause the resulting work to be covered by
// the GNU General Public License. However the source code for this file
// must still be made available in accordance with section (3) of the GNU
// General Public License v2.
//
// This exception does not invalidate any other reasons why a work based
// on this file might be covered by the GNU General Public License.
// -------------------------------------------
// ####ECOSGPLCOPYRIGHTEND####
//===========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):
// Contributors:  visar, ilijak
// Date:        1998-02-13
// Purpose:
// Description:
// Usage:       #include "vectors/sinhf.h"
//
//####DESCRIPTIONEND####
//
//===========================================================================


// CONFIGURATION

#include <pkgconf/libm.h>   // Configuration header


// INCLUDES

#include <cyg/infra/cyg_type.h>    // Common type definitions and support
#include "vectors/vector_support_float.h"// extra support for math tests

#define SINH_TOLERANCE 1.0E-04

static const Cyg_libm_test_float_vec_t sinhf_vec[] = {

// AUTOMATICALLY GENERATED VECTORS START

{0, 3214514586u, 3217110536u, 3217110536u, 0, SINH_TOLERANCE, 0},
{1, 3214430700u, 3216959278u, 3216959278u, 0, SINH_TOLERANCE, 0},
{2, 3214346813u, 3216809269u, 3216809269u, 0, SINH_TOLERANCE, 0},
{3, 3214262927u, 3216660499u, 3216660499u, 0, SINH_TOLERANCE, 0},
{4, 3214179041u, 3216512949u, 3216512949u, 0, SINH_TOLERANCE, 0},
{5, 3214095155u, 3216366607u, 3216366607u, 0, SINH_TOLERANCE, 0},
{6, 3214011269u, 3216221454u, 3216221454u, 0, SINH_TOLERANCE, 0},
{7, 3213927383u, 3216077481u, 3216077481u, 0, SINH_TOLERANCE, 0},
{8, 3213843497u, 3215934670u, 3215934670u, 0, SINH_TOLERANCE, 0},
{9, 3213759611u, 3215793008u, 3215793008u, 0, SINH_TOLERANCE, 0},
{10, 3213675725u, 3215652480u, 3215652480u, 0, SINH_TOLERANCE, 0},
{11, 3213591839u, 3215513072u, 3215513072u, 0, SINH_TOLERANCE, 0},
{12, 3213507953u, 3215374771u, 3215374771u, 0, SINH_TOLERANCE, 0},
{13, 3213424067u, 3215237562u, 3215237562u, 0, SINH_TOLERANCE, 0},
{14, 3213340180u, 3215101431u, 3215101431u, 0, SINH_TOLERANCE, 0},
{15, 3213256294u, 3214966367u, 3214966367u, 0, SINH_TOLERANCE, 0},
{16, 3213172408u, 3214832356u, 3214832356u, 0, SINH_TOLERANCE, 0},
{17, 3213088522u, 3214699382u, 3214699382u, 0, SINH_TOLERANCE, 0},
{18, 3213004636u, 3214567433u, 3214567433u, 0, SINH_TOLERANCE, 0},
{19, 3212920750u, 3214436496u, 3214436496u, 0, SINH_TOLERANCE, 0},
{20, 3212836864u, 3214306558u, 3214306558u, 0, SINH_TOLERANCE, 0},
{21, 3212669092u, 3214177606u, 3214177606u, 0, SINH_TOLERANCE, 0},
{22, 3212501320u, 3214049627u, 3214049627u, 0, SINH_TOLERANCE, 0},
{23, 3212333548u, 3213922608u, 3213922608u, 0, SINH_TOLERANCE, 0},
{24, 3212165775u, 3213796536u, 3213796536u, 0, SINH_TOLERANCE, 0},
{25, 3211998003u, 3213671399u, 3213671399u, 0, SINH_TOLERANCE, 0},
{26, 3211830231u, 3213547184u, 3213547184u, 0, SINH_TOLERANCE, 0},
{27, 3211662459u, 3213423880u, 3213423880u, 0, SINH_TOLERANCE, 0},
{28, 3211494687u, 3213301473u, 3213301473u, 0, SINH_TOLERANCE, 0},
{29, 3211326915u, 3213179951u, 3213179951u, 0, SINH_TOLERANCE, 0},
{30, 3211159142u, 3213059302u, 3213059302u, 0, SINH_TOLERANCE, 0},
{31, 3210991370u, 3212939515u, 3212939515u, 0, SINH_TOLERANCE, 0},
{32, 3210823598u, 3212804289u, 3212804289u, 0, SINH_TOLERANCE, 0},
{33, 3210655826u, 3212568087u, 3212568087u, 0, SINH_TOLERANCE, 0},
{34, 3210488054u, 3212333536u, 3212333536u, 0, SINH_TOLERANCE, 0},
{35, 3210320282u, 3212100612u, 3212100612u, 0, SINH_TOLERANCE, 0},
{36, 3210152509u, 3211869292u, 3211869292u, 0, SINH_TOLERANCE, 0},
{37, 3209984737u, 3211639553u, 3211639553u, 0, SINH_TOLERANCE, 0},
{38, 3209816965u, 3211411372u, 3211411372u, 0, SINH_TOLERANCE, 0},
{39, 3209649193u, 3211184727u, 3211184727u, 0, SINH_TOLERANCE, 0},
{40, 3209481421u, 3210959594u, 3210959594u, 0, SINH_TOLERANCE, 0},
{41, 3209313649u, 3210735951u, 3210735951u, 0, SINH_TOLERANCE, 0},
{42, 3209145876u, 3210513775u, 3210513775u, 0, SINH_TOLERANCE, 0},
{43, 3208978104u, 3210293045u, 3210293045u, 0, SINH_TOLERANCE, 0},
{44, 3208810332u, 3210073739u, 3210073739u, 0, SINH_TOLERANCE, 0},
{45, 3208642560u, 3209855833u, 3209855833u, 0, SINH_TOLERANCE, 0},
{46, 3208474788u, 3209639308u, 3209639308u, 0, SINH_TOLERANCE, 0},
{47, 3208307016u, 3209424141u, 3209424141u, 0, SINH_TOLERANCE, 0},
{48, 3208139244u, 3209210310u, 3209210310u, 0, SINH_TOLERANCE, 0},
{49, 3207971471u, 3208997792u, 3208997792u, 0, SINH_TOLERANCE, 0},
{50, 3207803699u, 3208786570u, 3208786570u, 0, SINH_TOLERANCE, 0},
{51, 3207635927u, 3208576621u, 3208576621u, 0, SINH_TOLERANCE, 0},
{52, 3207468155u, 3208367923u, 3208367923u, 0, SINH_TOLERANCE, 0},
{53, 3207300383u, 3208160456u, 3208160456u, 0, SINH_TOLERANCE, 0},
{54, 3207132611u, 3207954200u, 3207954200u, 0, SINH_TOLERANCE, 0},
{55, 3206964838u, 3207749131u, 3207749131u, 0, SINH_TOLERANCE, 0},
{56, 3206797066u, 3207545233u, 3207545233u, 0, SINH_TOLERANCE, 0},
{57, 3206629294u, 3207342483u, 3207342483u, 0, SINH_TOLERANCE, 0},
{58, 3206461522u, 3207140862u, 3207140862u, 0, SINH_TOLERANCE, 0},
{59, 3206293750u, 3206940348u, 3206940348u, 0, SINH_TOLERANCE, 0},
{60, 3206125978u, 3206740923u, 3206740923u, 0, SINH_TOLERANCE, 0},
{61, 3205958205u, 3206542565u, 3206542565u, 0, SINH_TOLERANCE, 0},
{62, 3205790433u, 3206345256u, 3206345256u, 0, SINH_TOLERANCE, 0},
{63, 3205622661u, 3206148976u, 3206148976u, 0, SINH_TOLERANCE, 0},
{64, 3205454889u, 3205953704u, 3205953704u, 0, SINH_TOLERANCE, 0},
{65, 3205287117u, 3205759423u, 3205759423u, 0, SINH_TOLERANCE, 0},
{66, 3205119345u, 3205566111u, 3205566111u, 0, SINH_TOLERANCE, 0},
{67, 3204951572u, 3205373748u, 3205373748u, 0, SINH_TOLERANCE, 0},
{68, 3204783800u, 3205182318u, 3205182318u, 0, SINH_TOLERANCE, 0},
{69, 3204616028u, 3204991801u, 3204991801u, 0, SINH_TOLERANCE, 0},
{70, 3204448256u, 3204802176u, 3204802176u, 0, SINH_TOLERANCE, 0},
{71, 3204112712u, 3204613426u, 3204613426u, 0, SINH_TOLERANCE, 0},
{72, 3203777167u, 3204402806u, 3204402806u, 0, SINH_TOLERANCE, 0},
{73, 3203441623u, 3204028690u, 3204028690u, 0, SINH_TOLERANCE, 0},
{74, 3203106079u, 3203656210u, 3203656210u, 0, SINH_TOLERANCE, 0},
{75, 3202770534u, 3203285327u, 3203285327u, 0, SINH_TOLERANCE, 0},
{76, 3202434990u, 3202916006u, 3202916006u, 0, SINH_TOLERANCE, 0},
{77, 3202099446u, 3202548210u, 3202548210u, 0, SINH_TOLERANCE, 0},
{78, 3201763901u, 3202181901u, 3202181901u, 0, SINH_TOLERANCE, 0},
{79, 3201428357u, 3201817044u, 3201817044u, 0, SINH_TOLERANCE, 0},
{80, 3201092813u, 3201453601u, 3201453601u, 0, SINH_TOLERANCE, 0},
{81, 3200757268u, 3201091536u, 3201091536u, 0, SINH_TOLERANCE, 0},
{82, 3200421724u, 3200730814u, 3200730814u, 0, SINH_TOLERANCE, 0},
{83, 3200086180u, 3200371397u, 3200371397u, 0, SINH_TOLERANCE, 0},
{84, 3199750636u, 3200013251u, 3200013251u, 0, SINH_TOLERANCE, 0},
{85, 3199415091u, 3199656338u, 3199656338u, 0, SINH_TOLERANCE, 0},
{86, 3199079547u, 3199300625u, 3199300625u, 0, SINH_TOLERANCE, 0},
{87, 3198744003u, 3198946074u, 3198946074u, 0, SINH_TOLERANCE, 0},
{88, 3198408458u, 3198592650u, 3198592650u, 0, SINH_TOLERANCE, 0},
{89, 3198072914u, 3198240320u, 3198240320u, 0, SINH_TOLERANCE, 0},
{90, 3197737370u, 3197889046u, 3197889046u, 0, SINH_TOLERANCE, 0},
{91, 3197401825u, 3197538793u, 3197538793u, 0, SINH_TOLERANCE, 0},
{92, 3197066281u, 3197189528u, 3197189528u, 0, SINH_TOLERANCE, 0},
{93, 3196730737u, 3196841214u, 3196841214u, 0, SINH_TOLERANCE, 0},
{94, 3196395192u, 3196493817u, 3196493817u, 0, SINH_TOLERANCE, 0},
{95, 3196059648u, 3196147303u, 3196147303u, 0, SINH_TOLERANCE, 0},
{96, 3195388559u, 3195543624u, 3195543624u, 0, SINH_TOLERANCE, 0},
{97, 3194717471u, 3194853917u, 3194853917u, 0, SINH_TOLERANCE, 0},
{98, 3194046382u, 3194165766u, 3194165766u, 0, SINH_TOLERANCE, 0},
{99, 3193375293u, 3193479104u, 3193479104u, 0, SINH_TOLERANCE, 0},
{100, 3192704205u, 3192793863u, 3192793863u, 0, SINH_TOLERANCE, 0},
{101, 3192033116u, 3192109971u, 3192109971u, 0, SINH_TOLERANCE, 0},
{102, 3191362028u, 3191427364u, 3191427364u, 0, SINH_TOLERANCE, 0},
{103, 3190690939u, 3190745969u, 3190745969u, 0, SINH_TOLERANCE, 0},
{104, 3190019850u, 3190065722u, 3190065722u, 0, SINH_TOLERANCE, 0},
{105, 3189348762u, 3189386553u, 3189386553u, 0, SINH_TOLERANCE, 0},
{106, 3188677673u, 3188708394u, 3188708394u, 0, SINH_TOLERANCE, 0},
{107, 3188006584u, 3188031178u, 3188031178u, 0, SINH_TOLERANCE, 0},
{108, 3186999951u, 3187038634u, 3187038634u, 0, SINH_TOLERANCE, 0},
{109, 3185657774u, 3185687566u, 3185687566u, 0, SINH_TOLERANCE, 0},
{110, 3184315597u, 3184337978u, 3184337978u, 0, SINH_TOLERANCE, 0},
{111, 3182973420u, 3182989734u, 3182989734u, 0, SINH_TOLERANCE, 0},
{112, 3181631242u, 3181642699u, 3181642699u, 0, SINH_TOLERANCE, 0},
{113, 3180289065u, 3180296740u, 3180296740u, 0, SINH_TOLERANCE, 0},
{114, 3178611343u, 3178621008u, 3178621008u, 0, SINH_TOLERANCE, 0},
{115, 3175926989u, 3175932582u, 3175932582u, 0, SINH_TOLERANCE, 0},
{116, 3173242634u, 3173245498u, 3173245498u, 0, SINH_TOLERANCE, 0},
{117, 3170222735u, 3170225151u, 3170225151u, 0, SINH_TOLERANCE, 0},
{118, 3164854026u, 3164854742u, 3164854742u, 0, SINH_TOLERANCE, 0},
{119, 3156465418u, 3156465597u, 3156465597u, 0, SINH_TOLERANCE, 0},
{120, 646742016u, 646742016u, 646742016u, 0, SINH_TOLERANCE, 0},
{121, 1008981770u, 1008981949u, 1008981949u, 0, SINH_TOLERANCE, 0},
{122, 1017370378u, 1017371094u, 1017371094u, 0, SINH_TOLERANCE, 0},
{123, 1022739087u, 1022741503u, 1022741503u, 0, SINH_TOLERANCE, 0},
{124, 1025758986u, 1025761850u, 1025761850u, 0, SINH_TOLERANCE, 0},
{125, 1028443341u, 1028448934u, 1028448934u, 0, SINH_TOLERANCE, 0},
{126, 1031127695u, 1031137360u, 1031137360u, 0, SINH_TOLERANCE, 0},
{127, 1032805417u, 1032813092u, 1032813092u, 0, SINH_TOLERANCE, 0},
{128, 1034147594u, 1034159051u, 1034159051u, 0, SINH_TOLERANCE, 0},
{129, 1035489772u, 1035506086u, 1035506086u, 0, SINH_TOLERANCE, 0},
{130, 1036831949u, 1036854330u, 1036854330u, 0, SINH_TOLERANCE, 0},
{131, 1038174126u, 1038203918u, 1038203918u, 0, SINH_TOLERANCE, 0},
{132, 1039516303u, 1039554986u, 1039554986u, 0, SINH_TOLERANCE, 0},
{133, 1040522936u, 1040547530u, 1040547530u, 0, SINH_TOLERANCE, 0},
{134, 1041194025u, 1041224746u, 1041224746u, 0, SINH_TOLERANCE, 0},
{135, 1041865114u, 1041902905u, 1041902905u, 0, SINH_TOLERANCE, 0},
{136, 1042536202u, 1042582074u, 1042582074u, 0, SINH_TOLERANCE, 0},
{137, 1043207291u, 1043262321u, 1043262321u, 0, SINH_TOLERANCE, 0},
{138, 1043878380u, 1043943716u, 1043943716u, 0, SINH_TOLERANCE, 0},
{139, 1044549468u, 1044626323u, 1044626323u, 0, SINH_TOLERANCE, 0},
{140, 1045220557u, 1045310215u, 1045310215u, 0, SINH_TOLERANCE, 0},
{141, 1045891645u, 1045995456u, 1045995456u, 0, SINH_TOLERANCE, 0},
{142, 1046562734u, 1046682118u, 1046682118u, 0, SINH_TOLERANCE, 0},
{143, 1047233823u, 1047370269u, 1047370269u, 0, SINH_TOLERANCE, 0},
{144, 1047904911u, 1048059976u, 1048059976u, 0, SINH_TOLERANCE, 0},
{145, 1048576000u, 1048663655u, 1048663655u, 0, SINH_TOLERANCE, 0},
{146, 1048911544u, 1049010169u, 1049010169u, 0, SINH_TOLERANCE, 0},
{147, 1049247089u, 1049357566u, 1049357566u, 0, SINH_TOLERANCE, 0},
{148, 1049582633u, 1049705880u, 1049705880u, 0, SINH_TOLERANCE, 0},
{149, 1049918177u, 1050055145u, 1050055145u, 0, SINH_TOLERANCE, 0},
{150, 1050253722u, 1050405398u, 1050405398u, 0, SINH_TOLERANCE, 0},
{151, 1050589266u, 1050756672u, 1050756672u, 0, SINH_TOLERANCE, 0},
{152, 1050924810u, 1051109002u, 1051109002u, 0, SINH_TOLERANCE, 0},
{153, 1051260355u, 1051462426u, 1051462426u, 0, SINH_TOLERANCE, 0},
{154, 1051595899u, 1051816977u, 1051816977u, 0, SINH_TOLERANCE, 0},
{155, 1051931443u, 1052172690u, 1052172690u, 0, SINH_TOLERANCE, 0},
{156, 1052266988u, 1052529603u, 1052529603u, 0, SINH_TOLERANCE, 0},
{157, 1052602532u, 1052887749u, 1052887749u, 0, SINH_TOLERANCE, 0},
{158, 1052938076u, 1053247166u, 1053247166u, 0, SINH_TOLERANCE, 0},
{159, 1053273620u, 1053607888u, 1053607888u, 0, SINH_TOLERANCE, 0},
{160, 1053609165u, 1053969953u, 1053969953u, 0, SINH_TOLERANCE, 0},
{161, 1053944709u, 1054333396u, 1054333396u, 0, SINH_TOLERANCE, 0},
{162, 1054280253u, 1054698253u, 1054698253u, 0, SINH_TOLERANCE, 0},
{163, 1054615798u, 1055064562u, 1055064562u, 0, SINH_TOLERANCE, 0},
{164, 1054951342u, 1055432358u, 1055432358u, 0, SINH_TOLERANCE, 0},
{165, 1055286886u, 1055801679u, 1055801679u, 0, SINH_TOLERANCE, 0},
{166, 1055622431u, 1056172562u, 1056172562u, 0, SINH_TOLERANCE, 0},
{167, 1055957975u, 1056545042u, 1056545042u, 0, SINH_TOLERANCE, 0},
{168, 1056293519u, 1056919158u, 1056919158u, 0, SINH_TOLERANCE, 0},
{169, 1056629064u, 1057129778u, 1057129778u, 0, SINH_TOLERANCE, 0},
{170, 1056964608u, 1057318528u, 1057318528u, 0, SINH_TOLERANCE, 0},
{171, 1057132380u, 1057508153u, 1057508153u, 0, SINH_TOLERANCE, 0},
{172, 1057300152u, 1057698670u, 1057698670u, 0, SINH_TOLERANCE, 0},
{173, 1057467924u, 1057890100u, 1057890100u, 0, SINH_TOLERANCE, 0},
{174, 1057635697u, 1058082463u, 1058082463u, 0, SINH_TOLERANCE, 0},
{175, 1057803469u, 1058275775u, 1058275775u, 0, SINH_TOLERANCE, 0},
{176, 1057971241u, 1058470056u, 1058470056u, 0, SINH_TOLERANCE, 0},
{177, 1058139013u, 1058665328u, 1058665328u, 0, SINH_TOLERANCE, 0},
{178, 1058306785u, 1058861608u, 1058861608u, 0, SINH_TOLERANCE, 0},
{179, 1058474557u, 1059058917u, 1059058917u, 0, SINH_TOLERANCE, 0},
{180, 1058642330u, 1059257275u, 1059257275u, 0, SINH_TOLERANCE, 0},
{181, 1058810102u, 1059456700u, 1059456700u, 0, SINH_TOLERANCE, 0},
{182, 1058977874u, 1059657214u, 1059657214u, 0, SINH_TOLERANCE, 0},
{183, 1059145646u, 1059858835u, 1059858835u, 0, SINH_TOLERANCE, 0},
{184, 1059313418u, 1060061585u, 1060061585u, 0, SINH_TOLERANCE, 0},
{185, 1059481190u, 1060265483u, 1060265483u, 0, SINH_TOLERANCE, 0},
{186, 1059648963u, 1060470552u, 1060470552u, 0, SINH_TOLERANCE, 0},
{187, 1059816735u, 1060676808u, 1060676808u, 0, SINH_TOLERANCE, 0},
{188, 1059984507u, 1060884275u, 1060884275u, 0, SINH_TOLERANCE, 0},
{189, 1060152279u, 1061092973u, 1061092973u, 0, SINH_TOLERANCE, 0},
{190, 1060320051u, 1061302922u, 1061302922u, 0, SINH_TOLERANCE, 0},
{191, 1060487823u, 1061514144u, 1061514144u, 0, SINH_TOLERANCE, 0},
{192, 1060655596u, 1061726662u, 1061726662u, 0, SINH_TOLERANCE, 0},
{193, 1060823368u, 1061940493u, 1061940493u, 0, SINH_TOLERANCE, 0},
{194, 1060991140u, 1062155660u, 1062155660u, 0, SINH_TOLERANCE, 0},
{195, 1061158912u, 1062372185u, 1062372185u, 0, SINH_TOLERANCE, 0},
{196, 1061326684u, 1062590091u, 1062590091u, 0, SINH_TOLERANCE, 0},
{197, 1061494456u, 1062809397u, 1062809397u, 0, SINH_TOLERANCE, 0},
{198, 1061662228u, 1063030127u, 1063030127u, 0, SINH_TOLERANCE, 0},
{199, 1061830001u, 1063252303u, 1063252303u, 0, SINH_TOLERANCE, 0},
{200, 1061997773u, 1063475946u, 1063475946u, 0, SINH_TOLERANCE, 0},
{201, 1062165545u, 1063701079u, 1063701079u, 0, SINH_TOLERANCE, 0},
{202, 1062333317u, 1063927724u, 1063927724u, 0, SINH_TOLERANCE, 0},
{203, 1062501089u, 1064155905u, 1064155905u, 0, SINH_TOLERANCE, 0},
{204, 1062668861u, 1064385644u, 1064385644u, 0, SINH_TOLERANCE, 0},
{205, 1062836634u, 1064616964u, 1064616964u, 0, SINH_TOLERANCE, 0},
{206, 1063004406u, 1064849888u, 1064849888u, 0, SINH_TOLERANCE, 0},
{207, 1063172178u, 1065084439u, 1065084439u, 0, SINH_TOLERANCE, 0},
{208, 1063339950u, 1065320641u, 1065320641u, 0, SINH_TOLERANCE, 0},
{209, 1063507722u, 1065455867u, 1065455867u, 0, SINH_TOLERANCE, 0},
{210, 1063675494u, 1065575654u, 1065575654u, 0, SINH_TOLERANCE, 0},
{211, 1063843267u, 1065696303u, 1065696303u, 0, SINH_TOLERANCE, 0},
{212, 1064011039u, 1065817825u, 1065817825u, 0, SINH_TOLERANCE, 0},
{213, 1064178811u, 1065940232u, 1065940232u, 0, SINH_TOLERANCE, 0},
{214, 1064346583u, 1066063536u, 1066063536u, 0, SINH_TOLERANCE, 0},
{215, 1064514355u, 1066187751u, 1066187751u, 0, SINH_TOLERANCE, 0},
{216, 1064682127u, 1066312888u, 1066312888u, 0, SINH_TOLERANCE, 0},
{217, 1064849900u, 1066438960u, 1066438960u, 0, SINH_TOLERANCE, 0},
{218, 1065017672u, 1066565979u, 1066565979u, 0, SINH_TOLERANCE, 0},
{219, 1065185444u, 1066693958u, 1066693958u, 0, SINH_TOLERANCE, 0},
{220, 1065353216u, 1066822910u, 1066822910u, 0, SINH_TOLERANCE, 0},
{221, 1065437102u, 1066952848u, 1066952848u, 0, SINH_TOLERANCE, 0},
{222, 1065520988u, 1067083785u, 1067083785u, 0, SINH_TOLERANCE, 0},
{223, 1065604874u, 1067215734u, 1067215734u, 0, SINH_TOLERANCE, 0},
{224, 1065688760u, 1067348708u, 1067348708u, 0, SINH_TOLERANCE, 0},
{225, 1065772646u, 1067482719u, 1067482719u, 0, SINH_TOLERANCE, 0},
{226, 1065856532u, 1067617783u, 1067617783u, 0, SINH_TOLERANCE, 0},
{227, 1065940419u, 1067753914u, 1067753914u, 0, SINH_TOLERANCE, 0},
{228, 1066024305u, 1067891123u, 1067891123u, 0, SINH_TOLERANCE, 0},
{229, 1066108191u, 1068029424u, 1068029424u, 0, SINH_TOLERANCE, 0},
{230, 1066192077u, 1068168832u, 1068168832u, 0, SINH_TOLERANCE, 0},
{231, 1066275963u, 1068309360u, 1068309360u, 0, SINH_TOLERANCE, 0},
{232, 1066359849u, 1068451022u, 1068451022u, 0, SINH_TOLERANCE, 0},
{233, 1066443735u, 1068593833u, 1068593833u, 0, SINH_TOLERANCE, 0},
{234, 1066527621u, 1068737806u, 1068737806u, 0, SINH_TOLERANCE, 0},
{235, 1066611507u, 1068882959u, 1068882959u, 0, SINH_TOLERANCE, 0},
{236, 1066695393u, 1069029301u, 1069029301u, 0, SINH_TOLERANCE, 0},
{237, 1066779279u, 1069176851u, 1069176851u, 0, SINH_TOLERANCE, 0},
{238, 1066863165u, 1069325621u, 1069325621u, 0, SINH_TOLERANCE, 0},
{239, 1066947052u, 1069475630u, 1069475630u, 0, SINH_TOLERANCE, 0},
{240, 3234402267u, 3280330582u, 3280330582u, 0, SINH_TOLERANCE, 0},
{241, 3231108068u, 3260980762u, 3260980762u, 0, SINH_TOLERANCE, 0},
{242, 3226013659u, 3241723811u, 3241723811u, 0, SINH_TOLERANCE, 0},
{243, 3217625051u, 3222489211u, 3222489211u, 0, SINH_TOLERANCE, 0},
{244, 0u, 0u, 0u, 0, SINH_TOLERANCE, 0},
{245, 1070141403u, 1075005563u, 1075005563u, 0, SINH_TOLERANCE, 0},
{246, 1078530011u, 1094240163u, 1094240163u, 0, SINH_TOLERANCE, 0},
{247, 1083624420u, 1113497114u, 1113497114u, 0, SINH_TOLERANCE, 0},
{248, 3253731328u, 3566961202u, 3566961202u, 0, SINH_TOLERANCE, 0},
{249, 3252840038u, 3546498372u, 3546498372u, 0, SINH_TOLERANCE, 0},
{250, 3251948749u, 3525710617u, 3525710617u, 0, SINH_TOLERANCE, 0},
{251, 3251057459u, 3505567330u, 3505567330u, 0, SINH_TOLERANCE, 0},
{252, 3250166170u, 3484507079u, 3484507079u, 0, SINH_TOLERANCE, 0},
{253, 3249274880u, 3464600087u, 3464600087u, 0, SINH_TOLERANCE, 0},
{254, 3248383590u, 3443353772u, 3443353772u, 0, SINH_TOLERANCE, 0},
{255, 3247492301u, 3423234143u, 3423234143u, 0, SINH_TOLERANCE, 0},
{256, 3246601011u, 3402254137u, 3402254137u, 0, SINH_TOLERANCE, 0},
{257, 3245028147u, 3381907410u, 3381907410u, 0, SINH_TOLERANCE, 0},
{258, 3243245568u, 3361211828u, 3361211828u, 0, SINH_TOLERANCE, 0},
{259, 3241462989u, 3340622545u, 3340622545u, 0, SINH_TOLERANCE, 0},
{260, 3239680410u, 3320230690u, 3320230690u, 0, SINH_TOLERANCE, 0},
{261, 3237792973u, 3299382405u, 3299382405u, 0, SINH_TOLERANCE, 0},
{262, 3234227814u, 3279314841u, 3279314841u, 0, SINH_TOLERANCE, 0},
{263, 3230662656u, 3258188566u, 3258188566u, 0, SINH_TOLERANCE, 0},
{264, 3224580915u, 3238203928u, 3238203928u, 0, SINH_TOLERANCE, 0},
{265, 3213675725u, 3215652480u, 3215652480u, 0, SINH_TOLERANCE, 0},
{266, 1058642330u, 1059257275u, 1059257275u, 0, SINH_TOLERANCE, 0},
{267, 1075000115u, 1084095382u, 1084095382u, 0, SINH_TOLERANCE, 0},
{268, 1082130432u, 1104826815u, 1104826815u, 0, SINH_TOLERANCE, 0},
{269, 1085695590u, 1125478038u, 1125478038u, 0, SINH_TOLERANCE, 0},
{270, 1089260749u, 1145864059u, 1145864059u, 0, SINH_TOLERANCE, 0},
{271, 1091672474u, 1166798129u, 1166798129u, 0, SINH_TOLERANCE, 0},
{272, 1093455053u, 1186954451u, 1186954451u, 0, SINH_TOLERANCE, 0},
{273, 1095237632u, 1208157740u, 1208157740u, 0, SINH_TOLERANCE, 0},
{274, 1097020211u, 1228099076u, 1228099076u, 0, SINH_TOLERANCE, 0},
{275, 1098802790u, 1249206348u, 1249206348u, 0, SINH_TOLERANCE, 0},
{276, 1099746509u, 1269294498u, 1269294498u, 0, SINH_TOLERANCE, 0},
{277, 1100637798u, 1290126283u, 1290126283u, 0, SINH_TOLERANCE, 0},
{278, 1101529088u, 1310537485u, 1310537485u, 0, SINH_TOLERANCE, 0},
{279, 1102420378u, 1331111329u, 1331111329u, 0, SINH_TOLERANCE, 0},
{280, 1103311667u, 1351825023u, 1351825023u, 0, SINH_TOLERANCE, 0},
{281, 1104202957u, 1372157288u, 1372157288u, 0, SINH_TOLERANCE, 0},
{282, 1105094246u, 1393154230u, 1393154230u, 0, SINH_TOLERANCE, 0},
{283, 1105985536u, 1413260339u, 1413260339u, 0, SINH_TOLERANCE, 0}

// AUTOMATICALLY GENERATED VECTORS STOP

};

#endif // CYGONCE_LIBM_SINHF_H multiple inclusion protection

// EOF sinhf.h
