#ifndef CYGONCE_LIBM_SCABNF_H
#define CYGONCE_LIBM_SCABNF_H
//===========================================================================
//
//      sinf.h
//
//      Test vectors for testing of sinf() math library function
//
//===========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####
// -------------------------------------------
// This file is part of eCos, the Embedded Configurable Operating System.
// Copyright (C) 2012 Free Software Foundation, Inc.
//
// eCos is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 or (at your option) any later
// version.
//
// eCos is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
// for more details.
//
// You should have received a copy of the GNU General Public License
// along with eCos; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//
// As a special exception, if other files instantiate templates or use
// macros or inline functions from this file, or you compile this file
// and link it with other works to produce a work based on this file,
// this file does not by itself cause the resulting work to be covered by
// the GNU General Public License. However the source code for this file
// must still be made available in accordance with section (3) of the GNU
// General Public License v2.
//
// This exception does not invalidate any other reasons why a work based
// on this file might be covered by the GNU General Public License.
// -------------------------------------------
// ####ECOSGPLCOPYRIGHTEND####
//===========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):
// Contributors:  visar, ilijak
// Date:        1998-02-13
// Purpose:
// Description:
// Usage:       #include "vectors/sinf.h"
//
//####DESCRIPTIONEND####
//
//===========================================================================


// CONFIGURATION

#include <pkgconf/libm.h>   // Configuration header


// INCLUDES

#include <cyg/infra/cyg_type.h>    // Common type definitions and support
#include "vectors/vector_support_float.h"// extra support for math tests

#define SINF_TOLERANCE 1.0E-04

static const Cyg_libm_test_float_vec_t sinf_vec[] = {

// AUTOMATICALLY GENERATED VECTORS START

{0, 3214514586u, 0u, 3211696670u, 0, SINF_TOLERANCE, 0},
{1, 3214430700u, 0u, 3211635095u, 0, SINF_TOLERANCE, 0},
{2, 3214346813u, 0u, 3211571962u, 0, SINF_TOLERANCE, 0},
{3, 3214262927u, 0u, 3211507279u, 0, SINF_TOLERANCE, 0},
{4, 3214179041u, 0u, 3211441052u, 0, SINF_TOLERANCE, 0},
{5, 3214095155u, 0u, 3211373285u, 0, SINF_TOLERANCE, 0},
{6, 3214011269u, 0u, 3211303988u, 0, SINF_TOLERANCE, 0},
{7, 3213927383u, 0u, 3211233167u, 0, SINF_TOLERANCE, 0},
{8, 3213843497u, 0u, 3211160828u, 0, SINF_TOLERANCE, 0},
{9, 3213759611u, 0u, 3211086979u, 0, SINF_TOLERANCE, 0},
{10, 3213675725u, 0u, 3211011627u, 0, SINF_TOLERANCE, 0},
{11, 3213591839u, 0u, 3210934780u, 0, SINF_TOLERANCE, 0},
{12, 3213507953u, 0u, 3210856445u, 0, SINF_TOLERANCE, 0},
{13, 3213424067u, 0u, 3210776631u, 0, SINF_TOLERANCE, 0},
{14, 3213340180u, 0u, 3210695344u, 0, SINF_TOLERANCE, 0},
{15, 3213256294u, 0u, 3210612595u, 0, SINF_TOLERANCE, 0},
{16, 3213172408u, 0u, 3210528390u, 0, SINF_TOLERANCE, 0},
{17, 3213088522u, 0u, 3210442738u, 0, SINF_TOLERANCE, 0},
{18, 3213004636u, 0u, 3210355648u, 0, SINF_TOLERANCE, 0},
{19, 3212920750u, 0u, 3210267129u, 0, SINF_TOLERANCE, 0},
{20, 3212836864u, 0u, 3210177188u, 0, SINF_TOLERANCE, 0},
{21, 3212669092u, 0u, 3210085836u, 0, SINF_TOLERANCE, 0},
{22, 3212501320u, 0u, 3209993082u, 0, SINF_TOLERANCE, 0},
{23, 3212333548u, 0u, 3209898934u, 0, SINF_TOLERANCE, 0},
{24, 3212165775u, 0u, 3209803402u, 0, SINF_TOLERANCE, 0},
{25, 3211998003u, 0u, 3209706495u, 0, SINF_TOLERANCE, 0},
{26, 3211830231u, 0u, 3209608225u, 0, SINF_TOLERANCE, 0},
{27, 3211662459u, 0u, 3209508599u, 0, SINF_TOLERANCE, 0},
{28, 3211494687u, 0u, 3209407628u, 0, SINF_TOLERANCE, 0},
{29, 3211326915u, 0u, 3209305323u, 0, SINF_TOLERANCE, 0},
{30, 3211159142u, 0u, 3209201692u, 0, SINF_TOLERANCE, 0},
{31, 3210991370u, 0u, 3209096748u, 0, SINF_TOLERANCE, 0},
{32, 3210823598u, 0u, 3208990501u, 0, SINF_TOLERANCE, 0},
{33, 3210655826u, 0u, 3208882960u, 0, SINF_TOLERANCE, 0},
{34, 3210488054u, 0u, 3208774137u, 0, SINF_TOLERANCE, 0},
{35, 3210320282u, 0u, 3208664042u, 0, SINF_TOLERANCE, 0},
{36, 3210152509u, 0u, 3208552686u, 0, SINF_TOLERANCE, 0},
{37, 3209984737u, 0u, 3208440082u, 0, SINF_TOLERANCE, 0},
{38, 3209816965u, 0u, 3208326239u, 0, SINF_TOLERANCE, 0},
{39, 3209649193u, 0u, 3208211170u, 0, SINF_TOLERANCE, 0},
{40, 3209481421u, 0u, 3208094886u, 0, SINF_TOLERANCE, 0},
{41, 3209313649u, 0u, 3207977399u, 0, SINF_TOLERANCE, 0},
{42, 3209145876u, 0u, 3207858718u, 0, SINF_TOLERANCE, 0},
{43, 3208978104u, 0u, 3207738859u, 0, SINF_TOLERANCE, 0},
{44, 3208810332u, 0u, 3207617832u, 0, SINF_TOLERANCE, 0},
{45, 3208642560u, 0u, 3207495649u, 0, SINF_TOLERANCE, 0},
{46, 3208474788u, 0u, 3207372322u, 0, SINF_TOLERANCE, 0},
{47, 3208307016u, 0u, 3207247864u, 0, SINF_TOLERANCE, 0},
{48, 3208139244u, 0u, 3207122288u, 0, SINF_TOLERANCE, 0},
{49, 3207971471u, 0u, 3206995604u, 0, SINF_TOLERANCE, 0},
{50, 3207803699u, 0u, 3206867827u, 0, SINF_TOLERANCE, 0},
{51, 3207635927u, 0u, 3206738970u, 0, SINF_TOLERANCE, 0},
{52, 3207468155u, 0u, 3206609044u, 0, SINF_TOLERANCE, 0},
{53, 3207300383u, 0u, 3206478064u, 0, SINF_TOLERANCE, 0},
{54, 3207132611u, 0u, 3206346042u, 0, SINF_TOLERANCE, 0},
{55, 3206964838u, 0u, 3206212991u, 0, SINF_TOLERANCE, 0},
{56, 3206797066u, 0u, 3206078925u, 0, SINF_TOLERANCE, 0},
{57, 3206629294u, 0u, 3205943857u, 0, SINF_TOLERANCE, 0},
{58, 3206461522u, 0u, 3205807800u, 0, SINF_TOLERANCE, 0},
{59, 3206293750u, 0u, 3205670769u, 0, SINF_TOLERANCE, 0},
{60, 3206125978u, 0u, 3205532777u, 0, SINF_TOLERANCE, 0},
{61, 3205958205u, 0u, 3205393837u, 0, SINF_TOLERANCE, 0},
{62, 3205790433u, 0u, 3205253964u, 0, SINF_TOLERANCE, 0},
{63, 3205622661u, 0u, 3205113171u, 0, SINF_TOLERANCE, 0},
{64, 3205454889u, 0u, 3204971474u, 0, SINF_TOLERANCE, 0},
{65, 3205287117u, 0u, 3204828885u, 0, SINF_TOLERANCE, 0},
{66, 3205119345u, 0u, 3204685419u, 0, SINF_TOLERANCE, 0},
{67, 3204951572u, 0u, 3204541090u, 0, SINF_TOLERANCE, 0},
{68, 3204783800u, 0u, 3204343570u, 0, SINF_TOLERANCE, 0},
{69, 3204616028u, 0u, 3204051550u, 0, SINF_TOLERANCE, 0},
{70, 3204448256u, 0u, 3203757892u, 0, SINF_TOLERANCE, 0},
{71, 3204112712u, 0u, 3203462625u, 0, SINF_TOLERANCE, 0},
{72, 3203777167u, 0u, 3203165778u, 0, SINF_TOLERANCE, 0},
{73, 3203441623u, 0u, 3202867382u, 0, SINF_TOLERANCE, 0},
{74, 3203106079u, 0u, 3202567467u, 0, SINF_TOLERANCE, 0},
{75, 3202770534u, 0u, 3202266061u, 0, SINF_TOLERANCE, 0},
{76, 3202434990u, 0u, 3201963197u, 0, SINF_TOLERANCE, 0},
{77, 3202099446u, 0u, 3201658903u, 0, SINF_TOLERANCE, 0},
{78, 3201763901u, 0u, 3201353210u, 0, SINF_TOLERANCE, 0},
{79, 3201428357u, 0u, 3201046149u, 0, SINF_TOLERANCE, 0},
{80, 3201092813u, 0u, 3200737751u, 0, SINF_TOLERANCE, 0},
{81, 3200757268u, 0u, 3200428046u, 0, SINF_TOLERANCE, 0},
{82, 3200421724u, 0u, 3200117066u, 0, SINF_TOLERANCE, 0},
{83, 3200086180u, 0u, 3199804841u, 0, SINF_TOLERANCE, 0},
{84, 3199750636u, 0u, 3199491402u, 0, SINF_TOLERANCE, 0},
{85, 3199415091u, 0u, 3199176781u, 0, SINF_TOLERANCE, 0},
{86, 3199079547u, 0u, 3198861010u, 0, SINF_TOLERANCE, 0},
{87, 3198744003u, 0u, 3198544120u, 0, SINF_TOLERANCE, 0},
{88, 3198408458u, 0u, 3198226142u, 0, SINF_TOLERANCE, 0},
{89, 3198072914u, 0u, 3197907109u, 0, SINF_TOLERANCE, 0},
{90, 3197737370u, 0u, 3197587053u, 0, SINF_TOLERANCE, 0},
{91, 3197401825u, 0u, 3197266004u, 0, SINF_TOLERANCE, 0},
{92, 3197066281u, 0u, 3196943997u, 0, SINF_TOLERANCE, 0},
{93, 3196730737u, 0u, 3196621062u, 0, SINF_TOLERANCE, 0},
{94, 3196395192u, 0u, 3196297232u, 0, SINF_TOLERANCE, 0},
{95, 3196059648u, 0u, 3195885431u, 0, SINF_TOLERANCE, 0},
{96, 3195388559u, 0u, 3195234385u, 0, SINF_TOLERANCE, 0},
{97, 3194717471u, 0u, 3194581745u, 0, SINF_TOLERANCE, 0},
{98, 3194046382u, 0u, 3193927574u, 0, SINF_TOLERANCE, 0},
{99, 3193375293u, 0u, 3193271939u, 0, SINF_TOLERANCE, 0},
{100, 3192704205u, 0u, 3192614905u, 0, SINF_TOLERANCE, 0},
{101, 3192033116u, 0u, 3191956538u, 0, SINF_TOLERANCE, 0},
{102, 3191362028u, 0u, 3191296904u, 0, SINF_TOLERANCE, 0},
{103, 3190690939u, 0u, 3190636067u, 0, SINF_TOLERANCE, 0},
{104, 3190019850u, 0u, 3189974096u, 0, SINF_TOLERANCE, 0},
{105, 3189348762u, 0u, 3189311056u, 0, SINF_TOLERANCE, 0},
{106, 3188677673u, 0u, 3188647012u, 0, SINF_TOLERANCE, 0},
{107, 3188006584u, 0u, 3187982032u, 0, SINF_TOLERANCE, 0},
{108, 3186999951u, 0u, 3186961324u, 0, SINF_TOLERANCE, 0},
{109, 3185657774u, 0u, 3185628018u, 0, SINF_TOLERANCE, 0},
{110, 3184315597u, 0u, 3184293239u, 0, SINF_TOLERANCE, 0},
{111, 3182973420u, 0u, 3182957119u, 0, SINF_TOLERANCE, 0},
{112, 3181631242u, 0u, 3181619792u, 0, SINF_TOLERANCE, 0},
{113, 3180289065u, 0u, 3180281394u, 0, SINF_TOLERANCE, 0},
{114, 3178611343u, 0u, 3178601681u, 0, SINF_TOLERANCE, 0},
{115, 3175926989u, 0u, 3175921397u, 0, SINF_TOLERANCE, 0},
{116, 3173242634u, 0u, 3173239771u, 0, SINF_TOLERANCE, 0},
{117, 3170222735u, 0u, 3170220319u, 0, SINF_TOLERANCE, 0},
{118, 3164854026u, 0u, 3164853310u, 0, SINF_TOLERANCE, 0},
{119, 3156465418u, 0u, 3156465239u, 0, SINF_TOLERANCE, 0},
{120, 1008981770u, 0u, 1008981591u, 0, SINF_TOLERANCE, 0},
{121, 1017370378u, 0u, 1017369662u, 0, SINF_TOLERANCE, 0},
{122, 1022739087u, 0u, 1022736671u, 0, SINF_TOLERANCE, 0},
{123, 1025758986u, 0u, 1025756123u, 0, SINF_TOLERANCE, 0},
{124, 1028443341u, 0u, 1028437749u, 0, SINF_TOLERANCE, 0},
{125, 1031127695u, 0u, 1031118033u, 0, SINF_TOLERANCE, 0},
{126, 1032805417u, 0u, 1032797746u, 0, SINF_TOLERANCE, 0},
{127, 1034147594u, 0u, 1034136144u, 0, SINF_TOLERANCE, 0},
{128, 1035489772u, 0u, 1035473471u, 0, SINF_TOLERANCE, 0},
{129, 1036831949u, 0u, 1036809591u, 0, SINF_TOLERANCE, 0},
{130, 1038174126u, 0u, 1038144370u, 0, SINF_TOLERANCE, 0},
{131, 1039516303u, 0u, 1039477676u, 0, SINF_TOLERANCE, 0},
{132, 1040522936u, 0u, 1040498384u, 0, SINF_TOLERANCE, 0},
{133, 1041194025u, 0u, 1041163364u, 0, SINF_TOLERANCE, 0},
{134, 1041865114u, 0u, 1041827408u, 0, SINF_TOLERANCE, 0},
{135, 1042536202u, 0u, 1042490448u, 0, SINF_TOLERANCE, 0},
{136, 1043207291u, 0u, 1043152419u, 0, SINF_TOLERANCE, 0},
{137, 1043878380u, 0u, 1043813256u, 0, SINF_TOLERANCE, 0},
{138, 1044549468u, 0u, 1044472890u, 0, SINF_TOLERANCE, 0},
{139, 1045220557u, 0u, 1045131257u, 0, SINF_TOLERANCE, 0},
{140, 1045891645u, 0u, 1045788291u, 0, SINF_TOLERANCE, 0},
{141, 1046562734u, 0u, 1046443926u, 0, SINF_TOLERANCE, 0},
{142, 1047233823u, 0u, 1047098097u, 0, SINF_TOLERANCE, 0},
{143, 1047904911u, 0u, 1047750737u, 0, SINF_TOLERANCE, 0},
{144, 1048576000u, 0u, 1048401783u, 0, SINF_TOLERANCE, 0},
{145, 1048911544u, 0u, 1048813584u, 0, SINF_TOLERANCE, 0},
{146, 1049247089u, 0u, 1049137414u, 0, SINF_TOLERANCE, 0},
{147, 1049582633u, 0u, 1049460349u, 0, SINF_TOLERANCE, 0},
{148, 1049918177u, 0u, 1049782356u, 0, SINF_TOLERANCE, 0},
{149, 1050253722u, 0u, 1050103405u, 0, SINF_TOLERANCE, 0},
{150, 1050589266u, 0u, 1050423461u, 0, SINF_TOLERANCE, 0},
{151, 1050924810u, 0u, 1050742494u, 0, SINF_TOLERANCE, 0},
{152, 1051260355u, 0u, 1051060472u, 0, SINF_TOLERANCE, 0},
{153, 1051595899u, 0u, 1051377362u, 0, SINF_TOLERANCE, 0},
{154, 1051931443u, 0u, 1051693133u, 0, SINF_TOLERANCE, 0},
{155, 1052266988u, 0u, 1052007754u, 0, SINF_TOLERANCE, 0},
{156, 1052602532u, 0u, 1052321193u, 0, SINF_TOLERANCE, 0},
{157, 1052938076u, 0u, 1052633418u, 0, SINF_TOLERANCE, 0},
{158, 1053273620u, 0u, 1052944398u, 0, SINF_TOLERANCE, 0},
{159, 1053609165u, 0u, 1053254103u, 0, SINF_TOLERANCE, 0},
{160, 1053944709u, 0u, 1053562501u, 0, SINF_TOLERANCE, 0},
{161, 1054280253u, 0u, 1053869562u, 0, SINF_TOLERANCE, 0},
{162, 1054615798u, 0u, 1054175255u, 0, SINF_TOLERANCE, 0},
{163, 1054951342u, 0u, 1054479549u, 0, SINF_TOLERANCE, 0},
{164, 1055286886u, 0u, 1054782413u, 0, SINF_TOLERANCE, 0},
{165, 1055622431u, 0u, 1055083819u, 0, SINF_TOLERANCE, 0},
{166, 1055957975u, 0u, 1055383734u, 0, SINF_TOLERANCE, 0},
{167, 1056293519u, 0u, 1055682130u, 0, SINF_TOLERANCE, 0},
{168, 1056629064u, 0u, 1055978977u, 0, SINF_TOLERANCE, 0},
{169, 1056964608u, 0u, 1056274244u, 0, SINF_TOLERANCE, 0},
{170, 1057132380u, 0u, 1056567902u, 0, SINF_TOLERANCE, 0},
{171, 1057300152u, 0u, 1056859922u, 0, SINF_TOLERANCE, 0},
{172, 1057467924u, 0u, 1057057442u, 0, SINF_TOLERANCE, 0},
{173, 1057635697u, 0u, 1057201771u, 0, SINF_TOLERANCE, 0},
{174, 1057803469u, 0u, 1057345237u, 0, SINF_TOLERANCE, 0},
{175, 1057971241u, 0u, 1057487826u, 0, SINF_TOLERANCE, 0},
{176, 1058139013u, 0u, 1057629523u, 0, SINF_TOLERANCE, 0},
{177, 1058306785u, 0u, 1057770316u, 0, SINF_TOLERANCE, 0},
{178, 1058474557u, 0u, 1057910189u, 0, SINF_TOLERANCE, 0},
{179, 1058642330u, 0u, 1058049129u, 0, SINF_TOLERANCE, 0},
{180, 1058810102u, 0u, 1058187121u, 0, SINF_TOLERANCE, 0},
{181, 1058977874u, 0u, 1058324152u, 0, SINF_TOLERANCE, 0},
{182, 1059145646u, 0u, 1058460209u, 0, SINF_TOLERANCE, 0},
{183, 1059313418u, 0u, 1058595277u, 0, SINF_TOLERANCE, 0},
{184, 1059481190u, 0u, 1058729343u, 0, SINF_TOLERANCE, 0},
{185, 1059648963u, 0u, 1058862394u, 0, SINF_TOLERANCE, 0},
{186, 1059816735u, 0u, 1058994416u, 0, SINF_TOLERANCE, 0},
{187, 1059984507u, 0u, 1059125396u, 0, SINF_TOLERANCE, 0},
{188, 1060152279u, 0u, 1059255322u, 0, SINF_TOLERANCE, 0},
{189, 1060320051u, 0u, 1059384179u, 0, SINF_TOLERANCE, 0},
{190, 1060487823u, 0u, 1059511956u, 0, SINF_TOLERANCE, 0},
{191, 1060655596u, 0u, 1059638640u, 0, SINF_TOLERANCE, 0},
{192, 1060823368u, 0u, 1059764216u, 0, SINF_TOLERANCE, 0},
{193, 1060991140u, 0u, 1059888674u, 0, SINF_TOLERANCE, 0},
{194, 1061158912u, 0u, 1060012001u, 0, SINF_TOLERANCE, 0},
{195, 1061326684u, 0u, 1060134184u, 0, SINF_TOLERANCE, 0},
{196, 1061494456u, 0u, 1060255211u, 0, SINF_TOLERANCE, 0},
{197, 1061662228u, 0u, 1060375070u, 0, SINF_TOLERANCE, 0},
{198, 1061830001u, 0u, 1060493751u, 0, SINF_TOLERANCE, 0},
{199, 1061997773u, 0u, 1060611238u, 0, SINF_TOLERANCE, 0},
{200, 1062165545u, 0u, 1060727522u, 0, SINF_TOLERANCE, 0},
{201, 1062333317u, 0u, 1060842591u, 0, SINF_TOLERANCE, 0},
{202, 1062501089u, 0u, 1060956434u, 0, SINF_TOLERANCE, 0},
{203, 1062668861u, 0u, 1061069038u, 0, SINF_TOLERANCE, 0},
{204, 1062836634u, 0u, 1061180394u, 0, SINF_TOLERANCE, 0},
{205, 1063004406u, 0u, 1061290489u, 0, SINF_TOLERANCE, 0},
{206, 1063172178u, 0u, 1061399312u, 0, SINF_TOLERANCE, 0},
{207, 1063339950u, 0u, 1061506853u, 0, SINF_TOLERANCE, 0},
{208, 1063507722u, 0u, 1061613100u, 0, SINF_TOLERANCE, 0},
{209, 1063675494u, 0u, 1061718044u, 0, SINF_TOLERANCE, 0},
{210, 1063843267u, 0u, 1061821675u, 0, SINF_TOLERANCE, 0},
{211, 1064011039u, 0u, 1061923980u, 0, SINF_TOLERANCE, 0},
{212, 1064178811u, 0u, 1062024951u, 0, SINF_TOLERANCE, 0},
{213, 1064346583u, 0u, 1062124577u, 0, SINF_TOLERANCE, 0},
{214, 1064514355u, 0u, 1062222847u, 0, SINF_TOLERANCE, 0},
{215, 1064682127u, 0u, 1062319754u, 0, SINF_TOLERANCE, 0},
{216, 1064849900u, 0u, 1062415286u, 0, SINF_TOLERANCE, 0},
{217, 1065017672u, 0u, 1062509434u, 0, SINF_TOLERANCE, 0},
{218, 1065185444u, 0u, 1062602188u, 0, SINF_TOLERANCE, 0},
{219, 1065353216u, 0u, 1062693540u, 0, SINF_TOLERANCE, 0},
{220, 1065437102u, 0u, 1062783481u, 0, SINF_TOLERANCE, 0},
{221, 1065520988u, 0u, 1062872000u, 0, SINF_TOLERANCE, 0},
{222, 1065604874u, 0u, 1062959090u, 0, SINF_TOLERANCE, 0},
{223, 1065688760u, 0u, 1063044742u, 0, SINF_TOLERANCE, 0},
{224, 1065772646u, 0u, 1063128947u, 0, SINF_TOLERANCE, 0},
{225, 1065856532u, 0u, 1063211696u, 0, SINF_TOLERANCE, 0},
{226, 1065940419u, 0u, 1063292983u, 0, SINF_TOLERANCE, 0},
{227, 1066024305u, 0u, 1063372797u, 0, SINF_TOLERANCE, 0},
{228, 1066108191u, 0u, 1063451132u, 0, SINF_TOLERANCE, 0},
{229, 1066192077u, 0u, 1063527979u, 0, SINF_TOLERANCE, 0},
{230, 1066275963u, 0u, 1063603331u, 0, SINF_TOLERANCE, 0},
{231, 1066359849u, 0u, 1063677180u, 0, SINF_TOLERANCE, 0},
{232, 1066443735u, 0u, 1063749519u, 0, SINF_TOLERANCE, 0},
{233, 1066527621u, 0u, 1063820340u, 0, SINF_TOLERANCE, 0},
{234, 1066611507u, 0u, 1063889637u, 0, SINF_TOLERANCE, 0},
{235, 1066695393u, 0u, 1063957404u, 0, SINF_TOLERANCE, 0},
{236, 1066779279u, 0u, 1064023631u, 0, SINF_TOLERANCE, 0},
{237, 1066863165u, 0u, 1064088314u, 0, SINF_TOLERANCE, 0},
{238, 1066947052u, 0u, 1064151447u, 0, SINF_TOLERANCE, 0},
{239, 3231108068u, 0u, 1065353216u, 0, SINF_TOLERANCE, 0},
{240, 3217625051u, 0u, 3212836864u, 0, SINF_TOLERANCE, 0},
{241, 0u, 0u, 0u, 0, SINF_TOLERANCE, 0},
{242, 1070141403u, 0u, 1065353216u, 0, SINF_TOLERANCE, 0},
{243, 1083624420u, 0u, 3212836864u, 0, SINF_TOLERANCE, 0},
{244, 3253731328u, 0u, 1065152422u, 0, SINF_TOLERANCE, 0},
{245, 3252840038u, 0u, 1020410054u, 0, SINF_TOLERANCE, 0},
{246, 3251948749u, 0u, 3212747018u, 0, SINF_TOLERANCE, 0},
{247, 3251057459u, 0u, 1047277214u, 0, SINF_TOLERANCE, 0},
{248, 3250166170u, 0u, 1064266220u, 0, SINF_TOLERANCE, 0},
{249, 3249274880u, 0u, 3203496634u, 0, SINF_TOLERANCE, 0},
{250, 3248383590u, 0u, 3209710816u, 0, SINF_TOLERANCE, 0},
{251, 3247492301u, 0u, 1060006548u, 0, SINF_TOLERANCE, 0},
{252, 3246601011u, 0u, 1059281644u, 0, SINF_TOLERANCE, 0},
{253, 3245028147u, 0u, 3210248930u, 0, SINF_TOLERANCE, 0},
{254, 3243245568u, 0u, 3201769496u, 0, SINF_TOLERANCE, 0},
{255, 3241462989u, 0u, 1064581787u, 0, SINF_TOLERANCE, 0},
{256, 3239680410u, 0u, 1043497670u, 0, SINF_TOLERANCE, 0},
{257, 3237792973u, 0u, 3212819103u, 0, SINF_TOLERANCE, 0},
{258, 3234227814u, 0u, 1034562272u, 0, SINF_TOLERANCE, 0},
{259, 3230662656u, 0u, 1064976234u, 0, SINF_TOLERANCE, 0},
{260, 3224580915u, 0u, 3198911379u, 0, SINF_TOLERANCE, 0},
{261, 3213675725u, 0u, 3211011627u, 0, SINF_TOLERANCE, 0},
{262, 1058642330u, 0u, 1058049129u, 0, SINF_TOLERANCE, 0},
{263, 1075000115u, 0u, 1061086858u, 0, SINF_TOLERANCE, 0},
{264, 1082130432u, 0u, 3208756687u, 0, SINF_TOLERANCE, 0},
{265, 1085695590u, 0u, 3205298621u, 0, SINF_TOLERANCE, 0},
{266, 1089260749u, 0u, 1063653819u, 0, SINF_TOLERANCE, 0},
{267, 1091672474u, 0u, 1050894550u, 0, SINF_TOLERANCE, 0},
{268, 1093455053u, 0u, 3212517027u, 0, SINF_TOLERANCE, 0},
{269, 1095237632u, 0u, 3179795422u, 0, SINF_TOLERANCE, 0},
{270, 1097020211u, 0u, 1065320109u, 0, SINF_TOLERANCE, 0},
{271, 1098802790u, 0u, 3192090686u, 0, SINF_TOLERANCE, 0},
{272, 1099746509u, 0u, 3211978617u, 0, SINF_TOLERANCE, 0},
{273, 1100637798u, 0u, 1054795790u, 0, SINF_TOLERANCE, 0},
{274, 1101529088u, 0u, 1062612757u, 0, SINF_TOLERANCE, 0},
{275, 1102420378u, 0u, 3206980986u, 0, SINF_TOLERANCE, 0},
{276, 1103311667u, 0u, 3207282104u, 0, SINF_TOLERANCE, 0},
{277, 1104202957u, 0u, 1062389233u, 0, SINF_TOLERANCE, 0},
{278, 1105094246u, 0u, 1055513287u, 0, SINF_TOLERANCE, 0},
{279, 1105985536u, 0u, 3211847531u, 0, SINF_TOLERANCE, 0},
{280, 1107800421u, 100135u, 1058518171u, 0, SINF_TOLERANCE, 0},
{281, 3196650934u, 0u, 3196544125u, 0, SINF_TOLERANCE, 0},
{282, 3368700125u, 4294964487u, 1046745931u, 0, SINF_TOLERANCE, 0},
{283, 1224242132u, 0u, 3205123499u, 0, SINF_TOLERANCE, 0},
{284, 3221027117u, 73066312u, 3211475937u, 0, SINF_TOLERANCE, 0},
{285, 1198712763u, 0u, 3209750432u, 0, SINF_TOLERANCE, 0},
{286, 3159309973u, 0u, 3159309611u, 0, SINF_TOLERANCE, 0},
{287, 954173073u, 0u, 954173073u, 0, SINF_TOLERANCE, 0},
{288, 3090780435u, 0u, 3090780435u, 0, SINF_TOLERANCE, 0},
{289, 966554515u, 4294967290u, 966554515u, 0, SINF_TOLERANCE, 0},
{290, 1312607135u, 47678u, 3202875829u, 0, SINF_TOLERANCE, 0},
{291, 1166191415u, 0u, 1030573108u, 0, SINF_TOLERANCE, 0},
{292, 3111900019u, 225u, 3111900019u, 0, SINF_TOLERANCE, 0},
{293, 1234419246u, 0u, 3212551722u, 0, SINF_TOLERANCE, 0},
{294, 1302107128u, 4294492157u, 3186571629u, 0, SINF_TOLERANCE, 0},
{295, 1052801068u, 0u, 1052506080u, 0, SINF_TOLERANCE, 0},
{296, 1060849628u, 0u, 1059783771u, 0, SINF_TOLERANCE, 0},
{297, 3484320003u, 0u, 1053149884u, 0, SINF_TOLERANCE, 0},
{298, 3181522772u, 4294965180u, 3181511666u, 0, SINF_TOLERANCE, 0},
{299, 882596369u, 7581303u, 882596369u, 0, SINF_TOLERANCE, 0},
{300, 1167223673u, 0u, 3212309638u, 0, SINF_TOLERANCE, 0},
{301, 968192794u, 0u, 968192794u, 0, SINF_TOLERANCE, 0},
{302, 3122346862u, 48u, 3122346861u, 0, SINF_TOLERANCE, 0},
{303, 1052361612u, 53381624u, 1052096265u, 0, SINF_TOLERANCE, 0},
{304, 906701409u, 0u, 906701409u, 0, SINF_TOLERANCE, 0},
{305, 3471653172u, 1621u, 1065331163u, 0, SINF_TOLERANCE, 0},
{306, 3231467496u, 0u, 1065107411u, 0, SINF_TOLERANCE, 0},
{307, 1341514497u, 3022046720u, 3196313073u, 0, SINF_TOLERANCE, 0},
{308, 1272351391u, 4294363968u, 3212112687u, 0, SINF_TOLERANCE, 0},
{309, 3319724992u, 4294842689u, 1061840534u, 0, SINF_TOLERANCE, 0},
{310, 917622040u, 603040256u, 917622040u, 0, SINF_TOLERANCE, 0},
{311, 940236348u, 4294965375u, 940236348u, 0, SINF_TOLERANCE, 0},
{312, 3251541546u, 0u, 3206746487u, 0, SINF_TOLERANCE, 0},
{313, 3099843889u, 4294828114u, 3099843889u, 0, SINF_TOLERANCE, 0},
{314, 3110358400u, 0u, 3110358400u, 0, SINF_TOLERANCE, 0},
{315, 3371863479u, 0u, 1065248325u, 0, SINF_TOLERANCE, 0},
{316, 3204069187u, 0u, 3203424208u, 0, SINF_TOLERANCE, 0},
{317, 1306460502u, 0u, 3212036909u, 0, SINF_TOLERANCE, 0},
{318, 1197542187u, 0u, 1058620655u, 0, SINF_TOLERANCE, 0},
{319, 922888249u, 467u, 922888249u, 0, SINF_TOLERANCE, 0},
{320, 1184239996u, 4294967294u, 1063084528u, 0, SINF_TOLERANCE, 0},
{321, 1252490238u, 7808u, 3196090424u, 0, SINF_TOLERANCE, 0},
{322, 1001673627u, 3340510784u, 1001673567u, 0, SINF_TOLERANCE, 0},
{323, 976098044u, 1357u, 976098043u, 0, SINF_TOLERANCE, 0},
{324, 941796645u, 0u, 941796645u, 0, SINF_TOLERANCE, 0},
{325, 3287199470u, 0u, 1042188572u, 0, SINF_TOLERANCE, 0},
{326, 893184329u, 2485427u, 893184329u, 0, SINF_TOLERANCE, 0},
{327, 1143233714u, 0u, 3208724747u, 0, SINF_TOLERANCE, 0},
{328, 1139941253u, 929u, 1054509223u, 0, SINF_TOLERANCE, 0},
{329, 3143717025u, 4294967290u, 3143716996u, 0, SINF_TOLERANCE, 0},
{330, 3048866608u, 3978787488u, 3048866608u, 0, SINF_TOLERANCE, 0},
{331, 3240298487u, 0u, 1060190807u, 0, SINF_TOLERANCE, 0},
{332, 1288902137u, 0u, 3208146860u, 0, SINF_TOLERANCE, 0},
{333, 1333134799u, 2211432960u, 3210775633u, 0, SINF_TOLERANCE, 0},
{334, 1187847971u, 1157221888u, 3212125511u, 0, SINF_TOLERANCE, 0},
{335, 1038851706u, 2696359424u, 1038817664u, 0, SINF_TOLERANCE, 0},
{336, 3329354473u, 0u, 3209793216u, 0, SINF_TOLERANCE, 0},
{337, 3077218579u, 529671904u, 3077218579u, 0, SINF_TOLERANCE, 0},
{338, 1309289088u, 0u, 1061413332u, 0, SINF_TOLERANCE, 0},
{339, 3444653659u, 50272864u, 1062129099u, 0, SINF_TOLERANCE, 0},
{340, 3405585402u, 0u, 1064681582u, 0, SINF_TOLERANCE, 0},
{341, 3106647724u, 0u, 3106647724u, 0, SINF_TOLERANCE, 0},
{342, 1106778573u, 4294965325u, 3200840548u, 0, SINF_TOLERANCE, 0},
{343, 1140567947u, 0u, 1059595752u, 0, SINF_TOLERANCE, 0},
{344, 1238569473u, 0u, 3203440080u, 0, SINF_TOLERANCE, 0},
{345, 3154871957u, 39965012u, 3154871846u, 0, SINF_TOLERANCE, 0},
{346, 1261071232u, 15806u, 1065291875u, 0, SINF_TOLERANCE, 0},
{347, 1175011025u, 0u, 3191887854u, 0, SINF_TOLERANCE, 0},
{348, 1082692850u, 187658u, 3211208663u, 0, SINF_TOLERANCE, 0},
{349, 974547519u, 1563599616u, 974547518u, 0, SINF_TOLERANCE, 0},
{350, 3058097085u, 0u, 3058097085u, 0, SINF_TOLERANCE, 0},
{351, 3107252546u, 1u, 3107252546u, 0, SINF_TOLERANCE, 0},
{352, 3096032662u, 0u, 3096032662u, 0, SINF_TOLERANCE, 0},
{353, 3197942144u, 0u, 3197782495u, 0, SINF_TOLERANCE, 0},
{354, 3403348556u, 0u, 3212832252u, 0, SINF_TOLERANCE, 0},
{355, 3182301130u, 3460013312u, 3182287402u, 0, SINF_TOLERANCE, 0},
{356, 1136411063u, 82u, 3203097915u, 0, SINF_TOLERANCE, 0},
{357, 3239231622u, 4294965540u, 3196062732u, 0, SINF_TOLERANCE, 0},
{358, 3340615780u, 0u, 3207893697u, 0, SINF_TOLERANCE, 0},
{359, 998567360u, 0u, 998567336u, 0, SINF_TOLERANCE, 0},
{360, 3417964312u, 1627479168u, 1058566457u, 0, SINF_TOLERANCE, 0},
{361, 3109481038u, 695u, 3109481038u, 0, SINF_TOLERANCE, 0},
{362, 1148867223u, 7486109u, 1061481055u, 0, SINF_TOLERANCE, 0},
{363, 989687421u, 4294414202u, 989687411u, 0, SINF_TOLERANCE, 0},
{364, 1152956913u, 0u, 1064560276u, 0, SINF_TOLERANCE, 0},
{365, 892922651u, 4294392467u, 892922651u, 0, SINF_TOLERANCE, 0},
{366, 1109627625u, 891137088u, 3176661959u, 0, SINF_TOLERANCE, 0},
{367, 1307091856u, 24u, 1065031078u, 0, SINF_TOLERANCE, 0},
{368, 1077234132u, 4294967159u, 1050390272u, 0, SINF_TOLERANCE, 0},
{369, 1142167709u, 13u, 1065037302u, 0, SINF_TOLERANCE, 0},
{370, 3426232834u, 0u, 1063523570u, 0, SINF_TOLERANCE, 0},
{371, 3368566779u, 0u, 3210903839u, 0, SINF_TOLERANCE, 0},
{372, 3030724760u, 4294886457u, 3030724760u, 0, SINF_TOLERANCE, 0},
{373, 1138741813u, 0u, 1065343110u, 0, SINF_TOLERANCE, 0},
{374, 982950501u, 0u, 982950499u, 0, SINF_TOLERANCE, 0},
{375, 1142981585u, 0u, 1064054420u, 0, SINF_TOLERANCE, 0},
{376, 3347165962u, 0u, 1061794719u, 0, SINF_TOLERANCE, 0},
{377, 1009535440u, 4293825695u, 1009535232u, 0, SINF_TOLERANCE, 0},
{378, 3103736980u, 4287990860u, 3103736980u, 0, SINF_TOLERANCE, 0},
{379, 3126820946u, 2u, 3126820944u, 0, SINF_TOLERANCE, 0},
{380, 3473956030u, 0u, 1059782658u, 0, SINF_TOLERANCE, 0},
{381, 3349098349u, 0u, 1056665925u, 0, SINF_TOLERANCE, 0},
{382, 3152729489u, 0u, 3152729357u, 0, SINF_TOLERANCE, 0},
{383, 945568720u, 4294963204u, 945568720u, 0, SINF_TOLERANCE, 0},
{384, 3345489836u, 36u, 1054686633u, 0, SINF_TOLERANCE, 0},
{385, 940893161u, 394u, 940893161u, 0, SINF_TOLERANCE, 0},
{386, 976791751u, 4294967292u, 976791750u, 0, SINF_TOLERANCE, 0},
{387, 1004442355u, 0u, 1004442243u, 0, SINF_TOLERANCE, 0},
{388, 1108485380u, 0u, 3211460841u, 0, SINF_TOLERANCE, 0},
{389, 1061834641u, 0u, 1060497016u, 0, SINF_TOLERANCE, 0},
{390, 3381268392u, 885u, 1065295790u, 0, SINF_TOLERANCE, 0},
{391, 1087189715u, 0u, 1040449727u, 0, SINF_TOLERANCE, 0},
{392, 3212952285u, 4294951762u, 3210300573u, 0, SINF_TOLERANCE, 0},
{393, 1000611335u, 0u, 1000611290u, 0, SINF_TOLERANCE, 0},
{394, 3466188568u, 0u, 3212367733u, 0, SINF_TOLERANCE, 0},
{395, 3072456205u, 0u, 3072456205u, 0, SINF_TOLERANCE, 0},
{396, 3319315516u, 4262338968u, 1063583000u, 0, SINF_TOLERANCE, 0},
{397, 935938416u, 867u, 935938416u, 0, SINF_TOLERANCE, 0},
{398, 3212614372u, 1438u, 3210055738u, 0, SINF_TOLERANCE, 0},
{399, 1315030230u, 4294939294u, 3202347342u, 0, SINF_TOLERANCE, 0},
{400, 1134593658u, 3712906944u, 1058161630u, 0, SINF_TOLERANCE, 0},
{401, 977281449u, 0u, 977281448u, 0, SINF_TOLERANCE, 0},
{402, 1086198791u, 0u, 3198963462u, 0, SINF_TOLERANCE, 0},
{403, 1255152035u, 0u, 3207185794u, 0, SINF_TOLERANCE, 0},
{404, 1135271264u, 4294966890u, 1059436789u, 0, SINF_TOLERANCE, 0},
{405, 1094190727u, 0u, 3210734358u, 0, SINF_TOLERANCE, 0},
{406, 1294665325u, 0u, 1060438488u, 0, SINF_TOLERANCE, 0},
{407, 1036608591u, 0u, 1036587330u, 0, SINF_TOLERANCE, 0},
{408, 3229998064u, 0u, 1063057509u, 0, SINF_TOLERANCE, 0},
{409, 3439134022u, 0u, 1062436542u, 0, SINF_TOLERANCE, 0},
{410, 3073083133u, 1094097536u, 3073083133u, 0, SINF_TOLERANCE, 0},
{411, 1325668223u, 0u, 1061043796u, 0, SINF_TOLERANCE, 0},
{412, 1092037607u, 0u, 3166699916u, 0, SINF_TOLERANCE, 0},
{413, 3316278408u, 3774649632u, 1064435105u, 0, SINF_TOLERANCE, 0},
{414, 3295436768u, 0u, 3187140116u, 0, SINF_TOLERANCE, 0},
{415, 1151984049u, 0u, 1064532731u, 0, SINF_TOLERANCE, 0},
{416, 1129287043u, 0u, 1045634997u, 0, SINF_TOLERANCE, 0},
{417, 1243664530u, 0u, 3207057562u, 0, SINF_TOLERANCE, 0},
{418, 950829092u, 0u, 950829092u, 0, SINF_TOLERANCE, 0},
{419, 1115471979u, 0u, 1051883779u, 0, SINF_TOLERANCE, 0},
{420, 3351092088u, 0u, 1057811134u, 0, SINF_TOLERANCE, 0},
{421, 3424479544u, 4294963555u, 1057943668u, 0, SINF_TOLERANCE, 0},
{422, 3241193975u, 0u, 1065333994u, 0, SINF_TOLERANCE, 0},
{423, 1030934236u, 0u, 1030924918u, 0, SINF_TOLERANCE, 0},
{424, 3131791114u, 4283960578u, 3131791111u, 0, SINF_TOLERANCE, 0},
{425, 1025254314u, 0u, 1025251836u, 0, SINF_TOLERANCE, 0},
{426, 1110545760u, 4294967286u, 1053672489u, 0, SINF_TOLERANCE, 0},
{427, 3180213739u, 37u, 3180206251u, 0, SINF_TOLERANCE, 0},
{428, 3361976590u, 0u, 1046550580u, 0, SINF_TOLERANCE, 0},
{429, 881280146u, 4262747520u, 881280146u, 0, SINF_TOLERANCE, 0},
{430, 1304154705u, 0u, 1032281728u, 0, SINF_TOLERANCE, 0},
{431, 3264443610u, 4294967294u, 1065270732u, 0, SINF_TOLERANCE, 0},
{432, 3374550627u, 0u, 3200851331u, 0, SINF_TOLERANCE, 0},
{433, 899599265u, 4294967286u, 899599265u, 0, SINF_TOLERANCE, 0},
{434, 1268194719u, 3962356224u, 1024648486u, 0, SINF_TOLERANCE, 0},
{435, 1133420220u, 3161371u, 1058660012u, 0, SINF_TOLERANCE, 0},
{436, 1161858787u, 0u, 1062433973u, 0, SINF_TOLERANCE, 0},
{437, 3184462258u, 13627054u, 3184439159u, 0, SINF_TOLERANCE, 0},
{438, 3295996963u, 3846806432u, 1055898143u, 0, SINF_TOLERANCE, 0},
{439, 1270887389u, 1864u, 1034411919u, 0, SINF_TOLERANCE, 0},
{440, 3325193181u, 0u, 3207166057u, 0, SINF_TOLERANCE, 0},
{441, 925657343u, 955232128u, 925657343u, 0, SINF_TOLERANCE, 0},
{442, 3115275450u, 0u, 3115275450u, 0, SINF_TOLERANCE, 0},
{443, 3116607482u, 4294967294u, 3116607482u, 0, SINF_TOLERANCE, 0},
{444, 3187892415u, 0u, 3187868814u, 0, SINF_TOLERANCE, 0},
{445, 1189120494u, 0u, 1065261777u, 0, SINF_TOLERANCE, 0},
{446, 889030794u, 0u, 889030794u, 0, SINF_TOLERANCE, 0},
{447, 1323529208u, 0u, 1063714250u, 0, SINF_TOLERANCE, 0},
{448, 3465768388u, 0u, 1048891935u, 0, SINF_TOLERANCE, 0},
{449, 3426099899u, 87u, 1060479363u, 0, SINF_TOLERANCE, 0},
{450, 3224857113u, 4290382691u, 3196806602u, 0, SINF_TOLERANCE, 0},
{451, 1065798296u, 0u, 1063154404u, 0, SINF_TOLERANCE, 0},
{452, 3328989444u, 0u, 3204189613u, 0, SINF_TOLERANCE, 0},
{453, 3357819026u, 0u, 1050303171u, 0, SINF_TOLERANCE, 0},
{454, 1273397670u, 0u, 3212832425u, 0, SINF_TOLERANCE, 0},
{455, 3424831780u, 414735168u, 1018696053u, 0, SINF_TOLERANCE, 0},
{456, 1257596246u, 4264851904u, 3212833257u, 0, SINF_TOLERANCE, 0},
{457, 1051773536u, 0u, 1051544673u, 0, SINF_TOLERANCE, 0},
{458, 3294752507u, 0u, 1063083778u, 0, SINF_TOLERANCE, 0},
{459, 3424848725u, 0u, 1038948225u, 0, SINF_TOLERANCE, 0},
{460, 1090870906u, 4294966393u, 1063445015u, 0, SINF_TOLERANCE, 0},
{461, 1227582289u, 147011u, 3198518934u, 0, SINF_TOLERANCE, 0},
{462, 1272325814u, 0u, 1059673072u, 0, SINF_TOLERANCE, 0},
{463, 3359508271u, 0u, 1065326721u, 0, SINF_TOLERANCE, 0},
{464, 1137854355u, 4294941607u, 3201176570u, 0, SINF_TOLERANCE, 0},
{465, 3440773058u, 0u, 3209718873u, 0, SINF_TOLERANCE, 0},
{466, 3101598400u, 0u, 3101598400u, 0, SINF_TOLERANCE, 0},
{467, 3451216836u, 4294896064u, 1052110141u, 0, SINF_TOLERANCE, 0},
{468, 3437062994u, 0u, 1057841295u, 0, SINF_TOLERANCE, 0},
{469, 1131196082u, 3743u, 3210719513u, 0, SINF_TOLERANCE, 0},
{470, 3177294154u, 63027320u, 3177286674u, 0, SINF_TOLERANCE, 0},
{471, 3258097678u, 449173056u, 3206530664u, 0, SINF_TOLERANCE, 0},
{472, 3460915348u, 356647u, 1064413669u, 0, SINF_TOLERANCE, 0},
{473, 3303035472u, 0u, 1059674673u, 0, SINF_TOLERANCE, 0},
{474, 1053698677u, 4294966907u, 1053336503u, 0, SINF_TOLERANCE, 0},
{475, 3396166221u, 83688u, 3212041622u, 0, SINF_TOLERANCE, 0},
{476, 3037541131u, 5u, 3037541131u, 0, SINF_TOLERANCE, 0},
{477, 3458934263u, 0u, 1057443493u, 0, SINF_TOLERANCE, 0},
{478, 1065761827u, 4294943781u, 1063118168u, 0, SINF_TOLERANCE, 0},
{479, 3025843188u, 0u, 3025843188u, 0, SINF_TOLERANCE, 0},
{480, 926665223u, 0u, 926665223u, 0, SINF_TOLERANCE, 0},
{481, 1199816046u, 0u, 1061346174u, 0, SINF_TOLERANCE, 0},
{482, 3333779015u, 0u, 3203337443u, 0, SINF_TOLERANCE, 0},
{483, 948398145u, 4294967288u, 948398145u, 0, SINF_TOLERANCE, 0},
{484, 3054021468u, 23933390u, 3054021468u, 0, SINF_TOLERANCE, 0},
{485, 1080781593u, 224021u, 3204639602u, 0, SINF_TOLERANCE, 0},
{486, 3164749613u, 0u, 3164748918u, 0, SINF_TOLERANCE, 0},
{487, 3235326590u, 26828788u, 3201986014u, 0, SINF_TOLERANCE, 0},
{488, 3118883815u, 0u, 3118883815u, 0, SINF_TOLERANCE, 0},
{489, 965378004u, 146193824u, 965378004u, 0, SINF_TOLERANCE, 0},
{490, 3226990408u, 45u, 1047285903u, 0, SINF_TOLERANCE, 0},
{491, 3117098218u, 115u, 3117098218u, 0, SINF_TOLERANCE, 0},
{492, 1283624229u, 0u, 1050764752u, 0, SINF_TOLERANCE, 0},
{493, 970649315u, 3u, 970649315u, 0, SINF_TOLERANCE, 0},
{494, 959776291u, 4294967028u, 959776291u, 0, SINF_TOLERANCE, 0},
{495, 3341117305u, 4294966405u, 3210910429u, 0, SINF_TOLERANCE, 0},
{496, 1270734970u, 4294829480u, 1033854408u, 0, SINF_TOLERANCE, 0},
{497, 3454816067u, 0u, 1037854899u, 0, SINF_TOLERANCE, 0},
{498, 917206623u, 7364u, 917206623u, 0, SINF_TOLERANCE, 0},
{499, 1106502045u, 126247200u, 3209516256u, 0, SINF_TOLERANCE, 0},
{500, 1157598381u, 4294964293u, 1060383409u, 0, SINF_TOLERANCE, 0},
{501, 3335234513u, 0u, 1038672048u, 0, SINF_TOLERANCE, 0},
{502, 1279489061u, 0u, 3212691844u, 0, SINF_TOLERANCE, 0},
{503, 3157416480u, 624023680u, 3157416249u, 0, SINF_TOLERANCE, 0},
{504, 3143920719u, 0u, 3143920689u, 0, SINF_TOLERANCE, 0},
{505, 1233171235u, 0u, 1059316879u, 0, SINF_TOLERANCE, 0},
{506, 1148920078u, 0u, 3208014767u, 0, SINF_TOLERANCE, 0},
{507, 3064988156u, 4294967292u, 3064988156u, 0, SINF_TOLERANCE, 0},
{508, 3083619260u, 2484u, 3083619260u, 0, SINF_TOLERANCE, 0},
{509, 1109198803u, 431095u, 1065351954u, 0, SINF_TOLERANCE, 0},
{510, 3219949483u, 0u, 3212196888u, 0, SINF_TOLERANCE, 0},
{511, 3361149474u, 4293077090u, 3205574938u, 0, SINF_TOLERANCE, 0},
{512, 1207502108u, 4292985650u, 3191132022u, 0, SINF_TOLERANCE, 0},
{513, 1000014431u, 0u, 1000014393u, 0, SINF_TOLERANCE, 0},
{514, 3161756316u, 0u, 3161755721u, 0, SINF_TOLERANCE, 0},
{515, 3160728744u, 4293625597u, 3160728256u, 0, SINF_TOLERANCE, 0},
{516, 1234530539u, 3u, 3207290757u, 0, SINF_TOLERANCE, 0},
{517, 1017843965u, 40165u, 1017843150u, 0, SINF_TOLERANCE, 0},
{518, 951862956u, 7732u, 951862956u, 0, SINF_TOLERANCE, 0},
{519, 3306328852u, 87u, 3212836506u, 0, SINF_TOLERANCE, 0},
{520, 1291910469u, 183319u, 3202624350u, 0, SINF_TOLERANCE, 0},
{521, 3027442905u, 7942u, 3027442905u, 0, SINF_TOLERANCE, 0},
{522, 1131927531u, 0u, 1051452936u, 0, SINF_TOLERANCE, 0},
{523, 3449879391u, 0u, 3206440668u, 0, SINF_TOLERANCE, 0},
{524, 970094304u, 4294911386u, 970094304u, 0, SINF_TOLERANCE, 0},
{525, 1125551064u, 4294949017u, 3195897312u, 0, SINF_TOLERANCE, 0},
{526, 3427296372u, 3784252480u, 1024392995u, 0, SINF_TOLERANCE, 0},
{527, 1198917460u, 2607027968u, 1059107199u, 0, SINF_TOLERANCE, 0},
{528, 3201603336u, 0u, 3201206444u, 0, SINF_TOLERANCE, 0},
{529, 3114686212u, 1328603904u, 3114686212u, 0, SINF_TOLERANCE, 0},
{530, 921940707u, 0u, 921940707u, 0, SINF_TOLERANCE, 0},
{531, 1091906532u, 0u, 1037018238u, 0, SINF_TOLERANCE, 0},
{532, 3393557778u, 4293570247u, 1050855630u, 0, SINF_TOLERANCE, 0},
{533, 1276853215u, 0u, 1050263660u, 0, SINF_TOLERANCE, 0},
{534, 3462778440u, 4294884341u, 1042079492u, 0, SINF_TOLERANCE, 0},
{535, 3360170117u, 0u, 1061155323u, 0, SINF_TOLERANCE, 0},
{536, 3224245428u, 4294967170u, 3201401572u, 0, SINF_TOLERANCE, 0},
{537, 1120124467u, 352u, 3203228560u, 0, SINF_TOLERANCE, 0},
{538, 1064364381u, 0u, 1062135066u, 0, SINF_TOLERANCE, 0},
{539, 1268744779u, 4294952694u, 3196363019u, 0, SINF_TOLERANCE, 0},
{540, 1165195428u, 4292538760u, 3171858671u, 0, SINF_TOLERANCE, 0},
{541, 3044092739u, 30u, 3044092739u, 0, SINF_TOLERANCE, 0},
{542, 3149469534u, 47144136u, 3149469469u, 0, SINF_TOLERANCE, 0},
{543, 3247790039u, 0u, 1043923194u, 0, SINF_TOLERANCE, 0},
{544, 3215244648u, 4u, 3212165907u, 0, SINF_TOLERANCE, 0},
{545, 3095275931u, 0u, 3095275931u, 0, SINF_TOLERANCE, 0},
{546, 3059688264u, 77u, 3059688264u, 0, SINF_TOLERANCE, 0},
{547, 1212717473u, 0u, 3212767710u, 0, SINF_TOLERANCE, 0},
{548, 3275973009u, 3930410816u, 3205565626u, 0, SINF_TOLERANCE, 0},
{549, 3028857014u, 0u, 3028857014u, 0, SINF_TOLERANCE, 0},
{550, 3391162308u, 129212984u, 1063347857u, 0, SINF_TOLERANCE, 0},
{551, 1044867873u, 4294528232u, 1044785421u, 0, SINF_TOLERANCE, 0},
{552, 1089986803u, 3370664576u, 1065255878u, 0, SINF_TOLERANCE, 0},
{553, 1296314700u, 0u, 1055078752u, 0, SINF_TOLERANCE, 0},
{554, 1251462432u, 0u, 1062872862u, 0, SINF_TOLERANCE, 0},
{555, 3485236902u, 0u, 1065341790u, 0, SINF_TOLERANCE, 0},
{556, 3262169538u, 19958524u, 1056243498u, 0, SINF_TOLERANCE, 0},
{557, 3080852256u, 0u, 3080852256u, 0, SINF_TOLERANCE, 0},
{558, 1022211242u, 0u, 1022209056u, 0, SINF_TOLERANCE, 0},
{559, 884661176u, 0u, 884661176u, 0, SINF_TOLERANCE, 0},
{560, 3071422941u, 4294967172u, 3071422941u, 0, SINF_TOLERANCE, 0},
{561, 989762529u, 4294733601u, 989762519u, 0, SINF_TOLERANCE, 0},
{562, 1295475718u, 0u, 3197286731u, 0, SINF_TOLERANCE, 0},
{563, 1002632518u, 4294950696u, 1002632443u, 0, SINF_TOLERANCE, 0},
{564, 3404372005u, 3938008096u, 1065220186u, 0, SINF_TOLERANCE, 0},
{565, 3158912530u, 0u, 3158912199u, 0, SINF_TOLERANCE, 0},
{566, 1125800069u, 4294967259u, 3200976549u, 0, SINF_TOLERANCE, 0},
{567, 3138037576u, 0u, 3138037569u, 0, SINF_TOLERANCE, 0},
{568, 3108384823u, 268832992u, 3108384823u, 0, SINF_TOLERANCE, 0},
{569, 999985470u, 4282999218u, 999985432u, 0, SINF_TOLERANCE, 0},
{570, 1189421739u, 0u, 3205184098u, 0, SINF_TOLERANCE, 0},
{571, 3075182644u, 0u, 3075182644u, 0, SINF_TOLERANCE, 0},
{572, 3028099649u, 4292241163u, 3028099649u, 0, SINF_TOLERANCE, 0},
{573, 3132541814u, 4077666864u, 3132541810u, 0, SINF_TOLERANCE, 0},
{574, 1164046161u, 4139845440u, 1062835605u, 0, SINF_TOLERANCE, 0},
{575, 1292596266u, 0u, 3209419523u, 0, SINF_TOLERANCE, 0},
{576, 3469748379u, 4279587928u, 3205576348u, 0, SINF_TOLERANCE, 0},
{577, 1314644642u, 0u, 1049458564u, 0, SINF_TOLERANCE, 0},
{578, 3399813173u, 0u, 3205386570u, 0, SINF_TOLERANCE, 0},
{579, 948775569u, 2159002624u, 948775569u, 0, SINF_TOLERANCE, 0},
{580, 1034611395u, 0u, 1034598397u, 0, SINF_TOLERANCE, 0},
{581, 3489122735u, 4294428604u, 3205374915u, 0, SINF_TOLERANCE, 0},
{582, 1181604787u, 4294717096u, 3211889820u, 0, SINF_TOLERANCE, 0},
{583, 3059042077u, 0u, 3059042077u, 0, SINF_TOLERANCE, 0},
{584, 1043691622u, 4288164501u, 1043629469u, 0, SINF_TOLERANCE, 0},
{585, 1314588083u, 0u, 1064881256u, 0, SINF_TOLERANCE, 0},
{586, 3141533334u, 0u, 3141533316u, 0, SINF_TOLERANCE, 0},
{587, 3157534378u, 3899913312u, 3157534140u, 0, SINF_TOLERANCE, 0},
{588, 3400949680u, 0u, 1065322477u, 0, SINF_TOLERANCE, 0},
{589, 3365581801u, 9596u, 3212766928u, 0, SINF_TOLERANCE, 0},
{590, 1110424755u, 0u, 3175390686u, 0, SINF_TOLERANCE, 0},
{591, 3189917167u, 0u, 3189872712u, 0, SINF_TOLERANCE, 0},
{592, 969804941u, 4294836255u, 969804941u, 0, SINF_TOLERANCE, 0},
{593, 1139120919u, 4294967176u, 1057188989u, 0, SINF_TOLERANCE, 0},
{594, 934308144u, 0u, 934308144u, 0, SINF_TOLERANCE, 0},
{595, 1220524226u, 1440u, 3200362112u, 0, SINF_TOLERANCE, 0},
{596, 3162548604u, 3394333056u, 3162548257u, 0, SINF_TOLERANCE, 0},
{597, 3382391700u, 4294966243u, 3212754531u, 0, SINF_TOLERANCE, 0},
{598, 1156767533u, 7u, 1065268032u, 0, SINF_TOLERANCE, 0},
{599, 3079222483u, 4294963487u, 3079222483u, 0, SINF_TOLERANCE, 0},
{600, 994934087u, 0u, 994934065u, 0, SINF_TOLERANCE, 0},
{601, 3185240099u, 122u, 3185212797u, 0, SINF_TOLERANCE, 0},
{602, 3479873563u, 3288004u, 3209729459u, 0, SINF_TOLERANCE, 0},
{603, 3424264117u, 4203174416u, 1026119980u, 0, SINF_TOLERANCE, 0},
{604, 3228365887u, 275492u, 1057499407u, 0, SINF_TOLERANCE, 0},
{605, 1035909900u, 4101891u, 1035891839u, 0, SINF_TOLERANCE, 0},
{606, 3024951184u, 3626688u, 3024951184u, 0, SINF_TOLERANCE, 0},
{607, 1212129651u, 0u, 3199599784u, 0, SINF_TOLERANCE, 0},
{608, 3125775254u, 0u, 3125775253u, 0, SINF_TOLERANCE, 0},
{609, 1037464105u, 0u, 1037438437u, 0, SINF_TOLERANCE, 0},
{610, 1311706596u, 6702361u, 3209240801u, 0, SINF_TOLERANCE, 0},
{611, 918212457u, 0u, 918212457u, 0, SINF_TOLERANCE, 0},
{612, 1337315179u, 3421796288u, 1065124759u, 0, SINF_TOLERANCE, 0},
{613, 1131358407u, 4294955130u, 1053199838u, 0, SINF_TOLERANCE, 0},
{614, 1156517523u, 4294914801u, 1060309074u, 0, SINF_TOLERANCE, 0},
{615, 3210802820u, 0u, 3208977252u, 0, SINF_TOLERANCE, 0},
{616, 3337499209u, 621819u, 3160894060u, 0, SINF_TOLERANCE, 0},
{617, 3468429030u, 4294967266u, 3212492606u, 0, SINF_TOLERANCE, 0},
{618, 3253515800u, 28517u, 1064805533u, 0, SINF_TOLERANCE, 0},
{619, 3055299953u, 0u, 3055299953u, 0, SINF_TOLERANCE, 0},
{620, 959956547u, 0u, 959956547u, 0, SINF_TOLERANCE, 0},
{621, 3425290480u, 461u, 3182677775u, 0, SINF_TOLERANCE, 0},
{622, 1039917375u, 117u, 1039875792u, 0, SINF_TOLERANCE, 0},
{623, 3220979495u, 4234725636u, 3211513265u, 0, SINF_TOLERANCE, 0},
{624, 1311016004u, 4294941884u, 1064704129u, 0, SINF_TOLERANCE, 0},
{625, 1128016396u, 27u, 3198585809u, 0, SINF_TOLERANCE, 0},
{626, 3210335769u, 0u, 3208674258u, 0, SINF_TOLERANCE, 0},
{627, 3022705759u, 4287084865u, 3022705759u, 0, SINF_TOLERANCE, 0},
{628, 1206054701u, 0u, 1065236418u, 0, SINF_TOLERANCE, 0},
{629, 3144504834u, 3170u, 3144504800u, 0, SINF_TOLERANCE, 0},
{630, 1213609983u, 0u, 1065160120u, 0, SINF_TOLERANCE, 0},
{631, 1246902946u, 0u, 1057771531u, 0, SINF_TOLERANCE, 0},
{632, 995850843u, 3845036544u, 995850816u, 0, SINF_TOLERANCE, 0},
{633, 3362082828u, 4294328268u, 3210050755u, 0, SINF_TOLERANCE, 0},
{634, 1029480631u, 0u, 1029473640u, 0, SINF_TOLERANCE, 0},
{635, 3153568584u, 0u, 3153568430u, 0, SINF_TOLERANCE, 0},
{636, 3384988527u, 0u, 3162719737u, 0, SINF_TOLERANCE, 0},
{637, 1317696241u, 0u, 1061478077u, 0, SINF_TOLERANCE, 0},
{638, 3235395924u, 249u, 3202981334u, 0, SINF_TOLERANCE, 0},
{639, 3341877624u, 0u, 1061330742u, 0, SINF_TOLERANCE, 0},
{640, 1228636133u, 0u, 3212672750u, 0, SINF_TOLERANCE, 0},
{641, 3161654634u, 4294939932u, 3161654050u, 0, SINF_TOLERANCE, 0},
{642, 3162655243u, 4294964738u, 3162654883u, 0, SINF_TOLERANCE, 0},
{643, 1207246237u, 0u, 3211137088u, 0, SINF_TOLERANCE, 0},
{644, 1165476654u, 4294877038u, 3203498092u, 0, SINF_TOLERANCE, 0},
{645, 1215278023u, 0u, 1064498991u, 0, SINF_TOLERANCE, 0},
{646, 1017239798u, 4167373560u, 1017239108u, 0, SINF_TOLERANCE, 0},
{647, 1149651309u, 0u, 3187990807u, 0, SINF_TOLERANCE, 0},
{648, 1111943722u, 0u, 3204639422u, 0, SINF_TOLERANCE, 0},
{649, 1189849849u, 4293652457u, 3182466673u, 0, SINF_TOLERANCE, 0},
{650, 3204848496u, 0u, 3204451995u, 0, SINF_TOLERANCE, 0},
{651, 1249758327u, 0u, 1057783887u, 0, SINF_TOLERANCE, 0},
{652, 3092982276u, 4065500752u, 3092982276u, 0, SINF_TOLERANCE, 0},
{653, 1168098747u, 1063712256u, 3212411223u, 0, SINF_TOLERANCE, 0},
{654, 892549317u, 13301u, 892549317u, 0, SINF_TOLERANCE, 0},
{655, 3301009024u, 4286178976u, 3212828669u, 0, SINF_TOLERANCE, 0},
{656, 3233089227u, 204399u, 1058407346u, 0, SINF_TOLERANCE, 0},
{657, 3218245284u, 1767132u, 3212791026u, 0, SINF_TOLERANCE, 0},
{658, 3215981890u, 4294967286u, 3212516029u, 0, SINF_TOLERANCE, 0},
{659, 1266687209u, 0u, 3210720211u, 0, SINF_TOLERANCE, 0},
{660, 3487959775u, 4294948774u, 1064739176u, 0, SINF_TOLERANCE, 0},
{661, 943645710u, 0u, 943645710u, 0, SINF_TOLERANCE, 0},
{662, 3345065699u, 4294966959u, 1059625963u, 0, SINF_TOLERANCE, 0},
{663, 935847271u, 1u, 935847271u, 0, SINF_TOLERANCE, 0},
{664, 3410336089u, 47u, 3187177121u, 0, SINF_TOLERANCE, 0},
{665, 3082940740u, 1562501120u, 3082940740u, 0, SINF_TOLERANCE, 0},
{666, 1141063391u, 5507u, 3198746667u, 0, SINF_TOLERANCE, 0},
{667, 3059263153u, 0u, 3059263153u, 0, SINF_TOLERANCE, 0},
{668, 3353679791u, 0u, 3208816436u, 0, SINF_TOLERANCE, 0},
{669, 1001823878u, 0u, 1001823816u, 0, SINF_TOLERANCE, 0},
{670, 1009130212u, 0u, 1009130026u, 0, SINF_TOLERANCE, 0},
{671, 3367127535u, 0u, 3207134818u, 0, SINF_TOLERANCE, 0},
{672, 1032920919u, 3981458912u, 1032912962u, 0, SINF_TOLERANCE, 0},
{673, 3281952870u, 0u, 3175316857u, 0, SINF_TOLERANCE, 0},
{674, 1237868497u, 0u, 1051014031u, 0, SINF_TOLERANCE, 0},
{675, 1153753924u, 4294958733u, 3211468600u, 0, SINF_TOLERANCE, 0},
{676, 1120261759u, 0u, 3212822605u, 0, SINF_TOLERANCE, 0},
{677, 3226328360u, 4294623870u, 1033471174u, 0, SINF_TOLERANCE, 0},
{678, 3349595986u, 4294967271u, 3210079317u, 0, SINF_TOLERANCE, 0},
{679, 3166889490u, 4294965026u, 3166888285u, 0, SINF_TOLERANCE, 0},
{680, 1087750238u, 16u, 1053147309u, 0, SINF_TOLERANCE, 0},
{681, 3121620061u, 4294773019u, 3121620061u, 0, SINF_TOLERANCE, 0},
{682, 1066116543u, 0u, 1063458849u, 0, SINF_TOLERANCE, 0},
{683, 3210898034u, 0u, 3209037800u, 0, SINF_TOLERANCE, 0},
{684, 3051923237u, 4294697573u, 3051923237u, 0, SINF_TOLERANCE, 0},
{685, 1030612298u, 4294908239u, 1030603534u, 0, SINF_TOLERANCE, 0},
{686, 1186234578u, 0u, 1063804762u, 0, SINF_TOLERANCE, 0},
{687, 1331680743u, 0u, 3209445822u, 0, SINF_TOLERANCE, 0},
{688, 3060774997u, 2318310656u, 3060774997u, 0, SINF_TOLERANCE, 0},
{689, 887589411u, 141578704u, 887589411u, 0, SINF_TOLERANCE, 0},
{690, 1045232522u, 4294967290u, 1045142984u, 0, SINF_TOLERANCE, 0},
{691, 3119858470u, 0u, 3119858469u, 0, SINF_TOLERANCE, 0},
{692, 3349432725u, 0u, 3209985951u, 0, SINF_TOLERANCE, 0},
{693, 912423027u, 0u, 912423027u, 0, SINF_TOLERANCE, 0},
{694, 3228795133u, 4294967132u, 1058904161u, 0, SINF_TOLERANCE, 0},
{695, 3194674746u, 0u, 3194540142u, 0, SINF_TOLERANCE, 0},
{696, 3296784303u, 4294967098u, 3210593540u, 0, SINF_TOLERANCE, 0},
{697, 965402291u, 0u, 965402291u, 0, SINF_TOLERANCE, 0},
{698, 3388153589u, 4246639564u, 3205467070u, 0, SINF_TOLERANCE, 0},
{699, 1133410485u, 4294951516u, 1062143430u, 0, SINF_TOLERANCE, 0},
{700, 3136790322u, 7u, 3136790312u, 0, SINF_TOLERANCE, 0},
{701, 3369970587u, 0u, 3212160316u, 0, SINF_TOLERANCE, 0},
{702, 1270451568u, 0u, 1061894833u, 0, SINF_TOLERANCE, 0},
{703, 989498922u, 0u, 989498912u, 0, SINF_TOLERANCE, 0},
{704, 1280215674u, 0u, 3201629248u, 0, SINF_TOLERANCE, 0},
{705, 1171873518u, 0u, 1052635782u, 0, SINF_TOLERANCE, 0},
{706, 3298258100u, 0u, 1064538056u, 0, SINF_TOLERANCE, 0},
{707, 3415208824u, 0u, 1063436503u, 0, SINF_TOLERANCE, 0},
{708, 1001897182u, 0u, 1001897119u, 0, SINF_TOLERANCE, 0},
{709, 3152777939u, 4294967281u, 3152777806u, 0, SINF_TOLERANCE, 0},
{710, 985903305u, 4294945424u, 985903300u, 0, SINF_TOLERANCE, 0},
{711, 3357328848u, 0u, 1040804283u, 0, SINF_TOLERANCE, 0},
{712, 982612185u, 0u, 982612183u, 0, SINF_TOLERANCE, 0},
{713, 3267868136u, 136421u, 1059068932u, 0, SINF_TOLERANCE, 0},
{714, 3319048157u, 7150u, 3197369568u, 0, SINF_TOLERANCE, 0},
{715, 1144755661u, 0u, 1056274450u, 0, SINF_TOLERANCE, 0},
{716, 898467286u, 0u, 898467286u, 0, SINF_TOLERANCE, 0},
{717, 3301461672u, 1119632u, 3195609227u, 0, SINF_TOLERANCE, 0},
{718, 3364525678u, 0u, 1048350503u, 0, SINF_TOLERANCE, 0},
{719, 931441127u, 285u, 931441127u, 0, SINF_TOLERANCE, 0},
{720, 3146660041u, 0u, 3146660012u, 0, SINF_TOLERANCE, 0},
{721, 3467121799u, 0u, 3191624506u, 0, SINF_TOLERANCE, 0},
{722, 1151257041u, 0u, 1063553242u, 0, SINF_TOLERANCE, 0},
{723, 3097873255u, 4294967295u, 3097873255u, 0, SINF_TOLERANCE, 0},
{724, 3130670309u, 0u, 3130670307u, 0, SINF_TOLERANCE, 0},
{725, 1017573824u, 0u, 1017573067u, 0, SINF_TOLERANCE, 0},
{726, 1258369714u, 3364363264u, 1063753689u, 0, SINF_TOLERANCE, 0},
{727, 1216602683u, 4294468761u, 1057835366u, 0, SINF_TOLERANCE, 0},
{728, 3297265739u, 228335u, 1040265730u, 0, SINF_TOLERANCE, 0},
{729, 1071940738u, 4294963632u, 1064968741u, 0, SINF_TOLERANCE, 0},
{730, 922601356u, 4294937447u, 922601356u, 0, SINF_TOLERANCE, 0},
{731, 3462285635u, 4085532736u, 3194013834u, 0, SINF_TOLERANCE, 0},
{732, 3357177805u, 5u, 3208612869u, 0, SINF_TOLERANCE, 0},
{733, 3049120080u, 0u, 3049120080u, 0, SINF_TOLERANCE, 0},
{734, 1153863660u, 0u, 3211361779u, 0, SINF_TOLERANCE, 0},
{735, 3034243695u, 0u, 3034243695u, 0, SINF_TOLERANCE, 0},
{736, 1249365132u, 4294967060u, 1061469301u, 0, SINF_TOLERANCE, 0},
{737, 3046215730u, 0u, 3046215730u, 0, SINF_TOLERANCE, 0},
{738, 3047251716u, 8u, 3047251716u, 0, SINF_TOLERANCE, 0},
{739, 3131219358u, 2355170688u, 3131219355u, 0, SINF_TOLERANCE, 0},
{740, 3222096285u, 59453u, 3209548358u, 0, SINF_TOLERANCE, 0},
{741, 1297708818u, 0u, 1057704214u, 0, SINF_TOLERANCE, 0},
{742, 3345532722u, 4293531291u, 3212744575u, 0, SINF_TOLERANCE, 0},
{743, 3418753236u, 4002743296u, 3212231875u, 0, SINF_TOLERANCE, 0},
{744, 1277417964u, 1103002624u, 1054784824u, 0, SINF_TOLERANCE, 0},
{745, 987577257u, 1370u, 987577250u, 0, SINF_TOLERANCE, 0},
{746, 3161606610u, 0u, 3161606031u, 0, SINF_TOLERANCE, 0},
{747, 888030585u, 0u, 888030585u, 0, SINF_TOLERANCE, 0},
{748, 1043442869u, 4294963715u, 1043384531u, 0, SINF_TOLERANCE, 0},
{749, 3320923228u, 3214934912u, 1065298241u, 0, SINF_TOLERANCE, 0},
{750, 1337400405u, 418188288u, 3194509316u, 0, SINF_TOLERANCE, 0},
{751, 3400348640u, 0u, 1036996135u, 0, SINF_TOLERANCE, 0},
{752, 1250249095u, 1u, 1049963674u, 0, SINF_TOLERANCE, 0},
{753, 3284411233u, 7805u, 3201435394u, 0, SINF_TOLERANCE, 0},
{754, 3020883322u, 0u, 3020883322u, 0, SINF_TOLERANCE, 0},
{755, 1215968622u, 2531374080u, 3211232354u, 0, SINF_TOLERANCE, 0},
{756, 3202319550u, 0u, 3201858668u, 0, SINF_TOLERANCE, 0},
{757, 3061638260u, 0u, 3061638260u, 0, SINF_TOLERANCE, 0},
{758, 1025404104u, 1u, 1025401516u, 0, SINF_TOLERANCE, 0},
{759, 3138086437u, 0u, 3138086430u, 0, SINF_TOLERANCE, 0},
{760, 3091024506u, 3752313152u, 3091024506u, 0, SINF_TOLERANCE, 0},
{761, 3362748242u, 4294517284u, 1057934339u, 0, SINF_TOLERANCE, 0},
{762, 3099671635u, 4294967295u, 3099671635u, 0, SINF_TOLERANCE, 0},
{763, 3068014841u, 0u, 3068014841u, 0, SINF_TOLERANCE, 0},
{764, 1252237719u, 105u, 3212473786u, 0, SINF_TOLERANCE, 0},
{765, 3327895594u, 517257u, 3205339525u, 0, SINF_TOLERANCE, 0},
{766, 3082454432u, 0u, 3082454432u, 0, SINF_TOLERANCE, 0},
{767, 3396161504u, 16393u, 1037999699u, 0, SINF_TOLERANCE, 0},
{768, 1099710167u, 0u, 3212307285u, 0, SINF_TOLERANCE, 0},
{769, 1157186482u, 109233848u, 1060562703u, 0, SINF_TOLERANCE, 0},
{770, 1282110851u, 0u, 1056730550u, 0, SINF_TOLERANCE, 0},
{771, 3477008113u, 3797391872u, 3212786491u, 0, SINF_TOLERANCE, 0},
{772, 3292127294u, 4282395772u, 3210643173u, 0, SINF_TOLERANCE, 0},
{773, 1123357102u, 4294966999u, 3159060470u, 0, SINF_TOLERANCE, 0},
{774, 1106837025u, 0u, 3197325155u, 0, SINF_TOLERANCE, 0},
{775, 1049949008u, 230u, 1049811896u, 0, SINF_TOLERANCE, 0},
{776, 1253017688u, 0u, 3211136840u, 0, SINF_TOLERANCE, 0},
{777, 1108543194u, 4294966999u, 3209632139u, 0, SINF_TOLERANCE, 0},
{778, 3087985411u, 1700586u, 3087985411u, 0, SINF_TOLERANCE, 0},
{779, 3163283126u, 2976129280u, 3163282681u, 0, SINF_TOLERANCE, 0},
{780, 1160162706u, 14164775u, 1052133849u, 0, SINF_TOLERANCE, 0},
{781, 3305715025u, 0u, 3206092235u, 0, SINF_TOLERANCE, 0},
{782, 1266928623u, 0u, 1060953065u, 0, SINF_TOLERANCE, 0},
{783, 3025340297u, 43483u, 3025340297u, 0, SINF_TOLERANCE, 0},
{784, 3438080027u, 0u, 1048692127u, 0, SINF_TOLERANCE, 0},
{785, 3344574751u, 0u, 1062946039u, 0, SINF_TOLERANCE, 0},
{786, 1152416724u, 0u, 3212200670u, 0, SINF_TOLERANCE, 0},
{787, 1218239308u, 161u, 1064099748u, 0, SINF_TOLERANCE, 0},
{788, 3263310567u, 0u, 3209093074u, 0, SINF_TOLERANCE, 0},
{789, 3041998669u, 2782u, 3041998669u, 0, SINF_TOLERANCE, 0},
{790, 1000313118u, 0u, 1000313077u, 0, SINF_TOLERANCE, 0},
{791, 972485427u, 131u, 972485426u, 0, SINF_TOLERANCE, 0},
{792, 3290264612u, 137u, 3212790164u, 0, SINF_TOLERANCE, 0},
{793, 3222106584u, 18249u, 3209523821u, 0, SINF_TOLERANCE, 0},
{794, 1278946388u, 0u, 1060997095u, 0, SINF_TOLERANCE, 0},
{795, 947914771u, 0u, 947914771u, 0, SINF_TOLERANCE, 0},
{796, 3167730654u, 0u, 3167729195u, 0, SINF_TOLERANCE, 0},
{797, 1098530298u, 4294967260u, 1032507489u, 0, SINF_TOLERANCE, 0},
{798, 3232726036u, 0u, 1060602925u, 0, SINF_TOLERANCE, 0},
{799, 1297190916u, 0u, 3212169414u, 0, SINF_TOLERANCE, 0},
{800, 1277649137u, 0u, 3212717518u, 0, SINF_TOLERANCE, 0},
{801, 3203377685u, 466619008u, 3202810349u, 0, SINF_TOLERANCE, 0},
{802, 3090306474u, 0u, 3090306474u, 0, SINF_TOLERANCE, 0},
{803, 3244032016u, 0u, 3211595152u, 0, SINF_TOLERANCE, 0},
{804, 3033122376u, 0u, 3033122376u, 0, SINF_TOLERANCE, 0},
{805, 1096155623u, 7454884u, 1060717035u, 0, SINF_TOLERANCE, 0},
{806, 873151908u, 4294967280u, 873151908u, 0, SINF_TOLERANCE, 0},
{807, 3238729605u, 245005088u, 3207267052u, 0, SINF_TOLERANCE, 0},
{808, 3317196817u, 0u, 3210991004u, 0, SINF_TOLERANCE, 0},
{809, 3374748510u, 0u, 3199463111u, 0, SINF_TOLERANCE, 0},
{810, 3345634950u, 0u, 1064868668u, 0, SINF_TOLERANCE, 0},
{811, 3189860276u, 0u, 3189816530u, 0, SINF_TOLERANCE, 0},
{812, 887311687u, 9077u, 887311687u, 0, SINF_TOLERANCE, 0},
{813, 3396917283u, 0u, 3176444374u, 0, SINF_TOLERANCE, 0},
{814, 3317032737u, 0u, 3203167975u, 0, SINF_TOLERANCE, 0},
{815, 1200051436u, 3555u, 3211188622u, 0, SINF_TOLERANCE, 0},
{816, 3105291012u, 45279u, 3105291012u, 0, SINF_TOLERANCE, 0},
{817, 1306520561u, 0u, 3211052194u, 0, SINF_TOLERANCE, 0},
{818, 1314936356u, 0u, 3208995553u, 0, SINF_TOLERANCE, 0},
{819, 3475052219u, 71851496u, 3185927000u, 0, SINF_TOLERANCE, 0},
{820, 3085636260u, 33u, 3085636260u, 0, SINF_TOLERANCE, 0},
{821, 3393227708u, 4294967164u, 3184801513u, 0, SINF_TOLERANCE, 0},
{822, 3182540197u, 0u, 3182525587u, 0, SINF_TOLERANCE, 0},
{823, 3349005404u, 0u, 3182748692u, 0, SINF_TOLERANCE, 0},
{824, 3154720153u, 4090490144u, 3154720048u, 0, SINF_TOLERANCE, 0},
{825, 1262863321u, 345111u, 1057245203u, 0, SINF_TOLERANCE, 0},
{826, 882902102u, 512593u, 882902102u, 0, SINF_TOLERANCE, 0},
{827, 1053387478u, 0u, 1053049633u, 0, SINF_TOLERANCE, 0},
{828, 3387653691u, 4294896063u, 3212836766u, 0, SINF_TOLERANCE, 0},
{829, 3136364836u, 0u, 3136364827u, 0, SINF_TOLERANCE, 0},
{830, 1338680611u, 4126u, 1054227324u, 0, SINF_TOLERANCE, 0},
{831, 1112891928u, 0u, 1031461115u, 0, SINF_TOLERANCE, 0},
{832, 893449284u, 0u, 893449284u, 0, SINF_TOLERANCE, 0},
{833, 892311459u, 14u, 892311459u, 0, SINF_TOLERANCE, 0},
{834, 3105373037u, 4294967280u, 3105373037u, 0, SINF_TOLERANCE, 0},
{835, 1190105283u, 0u, 1059448616u, 0, SINF_TOLERANCE, 0},
{836, 1011225926u, 14129u, 1011225610u, 0, SINF_TOLERANCE, 0},
{837, 1043025031u, 0u, 1042972745u, 0, SINF_TOLERANCE, 0},
{838, 3410531037u, 0u, 3204114341u, 0, SINF_TOLERANCE, 0},
{839, 3125834184u, 0u, 3125834183u, 0, SINF_TOLERANCE, 0},
{840, 902318189u, 0u, 902318189u, 0, SINF_TOLERANCE, 0},
{841, 3213624815u, 0u, 3210965166u, 0, SINF_TOLERANCE, 0},
{842, 1120888322u, 5u, 3168436714u, 0, SINF_TOLERANCE, 0},
{843, 1315217243u, 4291026624u, 1062278922u, 0, SINF_TOLERANCE, 0},
{844, 3137758475u, 0u, 3137758469u, 0, SINF_TOLERANCE, 0},
{845, 1040617590u, 0u, 1040592230u, 0, SINF_TOLERANCE, 0},
{846, 955384253u, 4294910624u, 955384253u, 0, SINF_TOLERANCE, 0},
{847, 3061417900u, 7119u, 3061417900u, 0, SINF_TOLERANCE, 0},
{848, 904255535u, 0u, 904255535u, 0, SINF_TOLERANCE, 0},
{849, 1022984119u, 0u, 1022981591u, 0, SINF_TOLERANCE, 0},
{850, 997362368u, 0u, 997362332u, 0, SINF_TOLERANCE, 0},
{851, 900933520u, 19u, 900933520u, 0, SINF_TOLERANCE, 0},
{852, 1168623062u, 661u, 1048554722u, 0, SINF_TOLERANCE, 0},
{853, 878737490u, 4294967181u, 878737490u, 0, SINF_TOLERANCE, 0},
{854, 1039827284u, 1u, 1039786377u, 0, SINF_TOLERANCE, 0},
{855, 1021564080u, 0u, 1021562155u, 0, SINF_TOLERANCE, 0},
{856, 3458669745u, 0u, 3208611126u, 0, SINF_TOLERANCE, 0},
{857, 3327516316u, 4286775627u, 3196519084u, 0, SINF_TOLERANCE, 0},
{858, 1040711112u, 4294967293u, 1040684937u, 0, SINF_TOLERANCE, 0},
{859, 1134528351u, 4294638880u, 3212547697u, 0, SINF_TOLERANCE, 0},
{860, 3039884464u, 6340u, 3039884464u, 0, SINF_TOLERANCE, 0},
{861, 3414352838u, 4294876517u, 3187938361u, 0, SINF_TOLERANCE, 0},
{862, 1133689539u, 1u, 3212184237u, 0, SINF_TOLERANCE, 0},
{863, 3455688478u, 4294945415u, 3212828554u, 0, SINF_TOLERANCE, 0},
{864, 1137634874u, 395u, 3208429720u, 0, SINF_TOLERANCE, 0},
{865, 3415502662u, 0u, 3208492898u, 0, SINF_TOLERANCE, 0},
{866, 954999730u, 0u, 954999730u, 0, SINF_TOLERANCE, 0},
{867, 1066157309u, 4294967285u, 1063496309u, 0, SINF_TOLERANCE, 0},
{868, 3436353675u, 8741u, 1057896763u, 0, SINF_TOLERANCE, 0},
{869, 940437609u, 0u, 940437609u, 0, SINF_TOLERANCE, 0},
{870, 3108347547u, 4203356328u, 3108347547u, 0, SINF_TOLERANCE, 0},
{871, 3064200154u, 0u, 3064200154u, 0, SINF_TOLERANCE, 0},
{872, 1023889593u, 0u, 1023887980u, 0, SINF_TOLERANCE, 0},
{873, 3272661536u, 3393767296u, 3198822684u, 0, SINF_TOLERANCE, 0},
{874, 1170245333u, 1083705u, 3192009928u, 0, SINF_TOLERANCE, 0},
{875, 1219052056u, 4294526211u, 3204945810u, 0, SINF_TOLERANCE, 0},
{876, 3318983619u, 4294967246u, 3192381578u, 0, SINF_TOLERANCE, 0},
{877, 3372118621u, 0u, 1065320170u, 0, SINF_TOLERANCE, 0},
{878, 3146190320u, 0u, 3146190295u, 0, SINF_TOLERANCE, 0},
{879, 1299683827u, 0u, 3191216603u, 0, SINF_TOLERANCE, 0},
{880, 3190796331u, 1457792256u, 3190739926u, 0, SINF_TOLERANCE, 0},
{881, 3086068902u, 2772570624u, 3086068902u, 0, SINF_TOLERANCE, 0},
{882, 3064155399u, 0u, 3064155399u, 0, SINF_TOLERANCE, 0},
{883, 3040314717u, 1u, 3040314717u, 0, SINF_TOLERANCE, 0},
{884, 3257224022u, 4294737239u, 1055767359u, 0, SINF_TOLERANCE, 0},
{885, 1229268598u, 1u, 3190440857u, 0, SINF_TOLERANCE, 0},
{886, 3184078812u, 0u, 3184057616u, 0, SINF_TOLERANCE, 0},
{887, 1086717248u, 4256439624u, 3183761749u, 0, SINF_TOLERANCE, 0},
{888, 3434884607u, 0u, 3201046083u, 0, SINF_TOLERANCE, 0},
{889, 3464955606u, 0u, 1058723576u, 0, SINF_TOLERANCE, 0},
{890, 1025278524u, 0u, 1025276028u, 0, SINF_TOLERANCE, 0},
{891, 1242829722u, 4294967290u, 3210159424u, 0, SINF_TOLERANCE, 0},
{892, 3075149137u, 76u, 3075149137u, 0, SINF_TOLERANCE, 0},
{893, 1200927971u, 1093714048u, 3212110569u, 0, SINF_TOLERANCE, 0},
{894, 3326858092u, 3870213632u, 3209830012u, 0, SINF_TOLERANCE, 0},
{895, 1246019790u, 0u, 1054169513u, 0, SINF_TOLERANCE, 0},
{896, 3184801644u, 424u, 3184776768u, 0, SINF_TOLERANCE, 0},
{897, 1136052740u, 4294967282u, 1063913525u, 0, SINF_TOLERANCE, 0},
{898, 1069009211u, 0u, 1065200638u, 0, SINF_TOLERANCE, 0},
{899, 1015670780u, 20u, 1015670353u, 0, SINF_TOLERANCE, 0},
{900, 1012543234u, 70u, 1012542811u, 0, SINF_TOLERANCE, 0},
{901, 3316611992u, 4291436324u, 1065170673u, 0, SINF_TOLERANCE, 0},
{902, 1087942795u, 4294961657u, 1055930559u, 0, SINF_TOLERANCE, 0},
{903, 3426365713u, 0u, 3202661746u, 0, SINF_TOLERANCE, 0},
{904, 3066654389u, 4087070784u, 3066654389u, 0, SINF_TOLERANCE, 0},
{905, 3295326432u, 842363840u, 3205148900u, 0, SINF_TOLERANCE, 0},
{906, 3318835308u, 4294967077u, 1024576997u, 0, SINF_TOLERANCE, 0},
{907, 3283555717u, 0u, 3212587646u, 0, SINF_TOLERANCE, 0},
{908, 3381255420u, 0u, 1064304600u, 0, SINF_TOLERANCE, 0},
{909, 3040485181u, 4294241104u, 3040485181u, 0, SINF_TOLERANCE, 0},
{910, 3388772093u, 0u, 3209717469u, 0, SINF_TOLERANCE, 0},
{911, 954670189u, 760u, 954670189u, 0, SINF_TOLERANCE, 0},
{912, 1319200415u, 4293050361u, 1046943470u, 0, SINF_TOLERANCE, 0},
{913, 1279324488u, 4294967293u, 1064422515u, 0, SINF_TOLERANCE, 0},
{914, 3217795424u, 0u, 3212833404u, 0, SINF_TOLERANCE, 0},
{915, 3455131757u, 10314665u, 3183800585u, 0, SINF_TOLERANCE, 0},
{916, 1246947517u, 6u, 3184419344u, 0, SINF_TOLERANCE, 0},
{917, 3396723577u, 0u, 1064229414u, 0, SINF_TOLERANCE, 0},
{918, 3433761025u, 0u, 3205870305u, 0, SINF_TOLERANCE, 0},
{919, 3201187455u, 0u, 3200824870u, 0, SINF_TOLERANCE, 0},
{920, 1173247961u, 32661u, 3208164870u, 0, SINF_TOLERANCE, 0},
{921, 3037297123u, 4294904338u, 3037297123u, 0, SINF_TOLERANCE, 0},
{922, 3248534678u, 1927801856u, 3211919740u, 0, SINF_TOLERANCE, 0},
{923, 3083019343u, 0u, 3083019343u, 0, SINF_TOLERANCE, 0},
{924, 3042018375u, 0u, 3042018375u, 0, SINF_TOLERANCE, 0},
{925, 1082862511u, 0u, 3211741763u, 0, SINF_TOLERANCE, 0},
{926, 3157626955u, 3075906560u, 3157626711u, 0, SINF_TOLERANCE, 0},
{927, 1341821683u, 0u, 3212804055u, 0, SINF_TOLERANCE, 0},
{928, 881101379u, 32095u, 881101379u, 0, SINF_TOLERANCE, 0},
{929, 1079061705u, 0u, 3187766776u, 0, SINF_TOLERANCE, 0},
{930, 3182695954u, 4294967257u, 3182680751u, 0, SINF_TOLERANCE, 0},
{931, 1105291533u, 3424974848u, 1036547753u, 0, SINF_TOLERANCE, 0},
{932, 1016023520u, 4294967293u, 1016023041u, 0, SINF_TOLERANCE, 0},
{933, 3370691006u, 198615840u, 3208609055u, 0, SINF_TOLERANCE, 0},
{934, 1156767169u, 0u, 1065176556u, 0, SINF_TOLERANCE, 0},
{935, 3077020499u, 0u, 3077020499u, 0, SINF_TOLERANCE, 0},
{936, 1104284039u, 0u, 1063691119u, 0, SINF_TOLERANCE, 0},
{937, 3335212901u, 1662125568u, 1064530211u, 0, SINF_TOLERANCE, 0},
{938, 1093697541u, 0u, 3212826186u, 0, SINF_TOLERANCE, 0},
{939, 3266691185u, 2645u, 3194602969u, 0, SINF_TOLERANCE, 0},
{940, 3179003144u, 37u, 3178992760u, 0, SINF_TOLERANCE, 0},
{941, 1094115255u, 0u, 3211281158u, 0, SINF_TOLERANCE, 0},
{942, 3424086808u, 4294967244u, 3205170345u, 0, SINF_TOLERANCE, 0},
{943, 3353608773u, 305u, 1063078133u, 0, SINF_TOLERANCE, 0},
{944, 973664327u, 1394344832u, 973664327u, 0, SINF_TOLERANCE, 0},
{945, 882878091u, 0u, 882878091u, 0, SINF_TOLERANCE, 0},
{946, 1098662266u, 0u, 3178071700u, 0, SINF_TOLERANCE, 0},
{947, 927582555u, 0u, 927582555u, 0, SINF_TOLERANCE, 0},
{948, 3111440310u, 0u, 3111440310u, 0, SINF_TOLERANCE, 0},
{949, 3476083859u, 0u, 3181075587u, 0, SINF_TOLERANCE, 0},
{950, 3038754840u, 0u, 3038754840u, 0, SINF_TOLERANCE, 0},
{951, 979878744u, 1008405u, 979878742u, 0, SINF_TOLERANCE, 0},
{952, 3464546616u, 0u, 1065326173u, 0, SINF_TOLERANCE, 0},
{953, 1002542205u, 0u, 1002542131u, 0, SINF_TOLERANCE, 0},
{954, 3443552129u, 0u, 1047774072u, 0, SINF_TOLERANCE, 0},
{955, 1287620154u, 0u, 1063607690u, 0, SINF_TOLERANCE, 0},
{956, 946058434u, 4207447u, 946058434u, 0, SINF_TOLERANCE, 0},
{957, 3073260205u, 0u, 3073260205u, 0, SINF_TOLERANCE, 0},
{958, 1245702957u, 0u, 1049967502u, 0, SINF_TOLERANCE, 0},
{959, 989655126u, 528989952u, 989655116u, 0, SINF_TOLERANCE, 0},
{960, 1002715618u, 32425u, 1002715541u, 0, SINF_TOLERANCE, 0},
{961, 3087802274u, 0u, 3087802274u, 0, SINF_TOLERANCE, 0},
{962, 1000863905u, 54834u, 1000863857u, 0, SINF_TOLERANCE, 0},
{963, 3415763001u, 0u, 1062474805u, 0, SINF_TOLERANCE, 0},
{964, 3283471961u, 10190634u, 1060758212u, 0, SINF_TOLERANCE, 0},
{965, 3311210827u, 36713u, 1051772445u, 0, SINF_TOLERANCE, 0},
{966, 3026311911u, 0u, 3026311911u, 0, SINF_TOLERANCE, 0},
{967, 1198307901u, 68u, 1061883151u, 0, SINF_TOLERANCE, 0},
{968, 1288901567u, 206618288u, 3207429230u, 0, SINF_TOLERANCE, 0},
{969, 922255363u, 0u, 922255363u, 0, SINF_TOLERANCE, 0},
{970, 1113104661u, 0u, 3207498491u, 0, SINF_TOLERANCE, 0},
{971, 1136714348u, 0u, 1058688901u, 0, SINF_TOLERANCE, 0},
{972, 948856035u, 0u, 948856035u, 0, SINF_TOLERANCE, 0},
{973, 1062512367u, 4294967293u, 1060964042u, 0, SINF_TOLERANCE, 0},
{974, 3486907092u, 0u, 1060191997u, 0, SINF_TOLERANCE, 0},
{975, 1162027071u, 4294964303u, 3207219290u, 0, SINF_TOLERANCE, 0},
{976, 1034561811u, 0u, 1034548985u, 0, SINF_TOLERANCE, 0},
{977, 3271615417u, 0u, 1034703688u, 0, SINF_TOLERANCE, 0},
{978, 1042014529u, 869u, 1041975120u, 0, SINF_TOLERANCE, 0},
{979, 1177157787u, 0u, 3208280448u, 0, SINF_TOLERANCE, 0},
{980, 3196144817u, 0u, 3196050420u, 0, SINF_TOLERANCE, 0},
{981, 3432084552u, 0u, 1063814911u, 0, SINF_TOLERANCE, 0},
{982, 1309658335u, 0u, 1056586960u, 0, SINF_TOLERANCE, 0},
{983, 1226494979u, 0u, 1065146136u, 0, SINF_TOLERANCE, 0},
{984, 3100289712u, 3743522688u, 3100289712u, 0, SINF_TOLERANCE, 0},
{985, 3375507013u, 462886112u, 3204896610u, 0, SINF_TOLERANCE, 0},
{986, 3460699001u, 0u, 3212836850u, 0, SINF_TOLERANCE, 0},
{987, 3079231719u, 0u, 3079231719u, 0, SINF_TOLERANCE, 0},
{988, 3093951884u, 0u, 3093951884u, 0, SINF_TOLERANCE, 0},
{989, 3468023178u, 156157u, 3212716691u, 0, SINF_TOLERANCE, 0},
{990, 1204196034u, 4294966040u, 1064715383u, 0, SINF_TOLERANCE, 0},
{991, 3459877411u, 0u, 3212701032u, 0, SINF_TOLERANCE, 0},
{992, 909696559u, 3378u, 909696559u, 0, SINF_TOLERANCE, 0},
{993, 1161439847u, 0u, 1053879087u, 0, SINF_TOLERANCE, 0},
{994, 908663107u, 0u, 908663107u, 0, SINF_TOLERANCE, 0},
{995, 1055319316u, 4294967238u, 1054811608u, 0, SINF_TOLERANCE, 0},
{996, 1084378658u, 0u, 3211763466u, 0, SINF_TOLERANCE, 0},
{997, 3053887750u, 4294922339u, 3053887750u, 0, SINF_TOLERANCE, 0},
{998, 3022828828u, 0u, 3022828828u, 0, SINF_TOLERANCE, 0},
{999, 1226473697u, 0u, 3203662642u, 0, SINF_TOLERANCE, 0},
{1000, 1123114742u, 841711u, 1064763840u, 0, SINF_TOLERANCE, 0},
{1001, 1258114435u, 130141336u, 3204368636u, 0, SINF_TOLERANCE, 0},
{1002, 3468040845u, 0u, 3205961198u, 0, SINF_TOLERANCE, 0},
{1003, 1178825761u, 54u, 3207974092u, 0, SINF_TOLERANCE, 0},
{1004, 3059266302u, 0u, 3059266302u, 0, SINF_TOLERANCE, 0},
{1005, 3223384012u, 225u, 3205902554u, 0, SINF_TOLERANCE, 0},
{1006, 1019964626u, 1299605u, 1019963256u, 0, SINF_TOLERANCE, 0},
{1007, 3445262427u, 3129568512u, 1060950633u, 0, SINF_TOLERANCE, 0},
{1008, 1125653081u, 129823u, 1064770536u, 0, SINF_TOLERANCE, 0},
{1009, 3337652712u, 0u, 3212411443u, 0, SINF_TOLERANCE, 0},
{1010, 1184753508u, 0u, 3212277391u, 0, SINF_TOLERANCE, 0},
{1011, 996404791u, 4294853343u, 996404761u, 0, SINF_TOLERANCE, 0},
{1012, 1188439315u, 55u, 3188727200u, 0, SINF_TOLERANCE, 0},
{1013, 906557513u, 0u, 906557513u, 0, SINF_TOLERANCE, 0},
{1014, 916831283u, 0u, 916831283u, 0, SINF_TOLERANCE, 0},
{1015, 996786317u, 0u, 996786285u, 0, SINF_TOLERANCE, 0},
{1016, 3461635065u, 0u, 1061514522u, 0, SINF_TOLERANCE, 0},
{1017, 1188167943u, 74707u, 1063103232u, 0, SINF_TOLERANCE, 0},
{1018, 3036502395u, 7309u, 3036502395u, 0, SINF_TOLERANCE, 0},
{1019, 891257783u, 18537700u, 891257783u, 0, SINF_TOLERANCE, 0},
{1020, 3290079438u, 0u, 3200153812u, 0, SINF_TOLERANCE, 0},
{1021, 3350690327u, 0u, 3196820093u, 0, SINF_TOLERANCE, 0},
{1022, 1102061604u, 4253821380u, 3167292829u, 0, SINF_TOLERANCE, 0},
{1023, 1282351521u, 0u, 1061321845u, 0, SINF_TOLERANCE, 0},
{1024, 3458861065u, 4292002951u, 1059823021u, 0, SINF_TOLERANCE, 0},
{1025, 3095256878u, 0u, 3095256878u, 0, SINF_TOLERANCE, 0},
{1026, 3163373610u, 0u, 3163373151u, 0, SINF_TOLERANCE, 0},
{1027, 3228793330u, 0u, 1058898476u, 0, SINF_TOLERANCE, 0},
{1028, 3422194733u, 0u, 1065154839u, 0, SINF_TOLERANCE, 0},
{1029, 3083885296u, 0u, 3083885296u, 0, SINF_TOLERANCE, 0},
{1030, 1261940623u, 4288291120u, 1061418234u, 0, SINF_TOLERANCE, 0},
{1031, 3400603081u, 4294967290u, 3212371450u, 0, SINF_TOLERANCE, 0},
{1032, 1219411812u, 0u, 3208405055u, 0, SINF_TOLERANCE, 0},
{1033, 3094833770u, 0u, 3094833770u, 0, SINF_TOLERANCE, 0},
{1034, 3139250800u, 0u, 3139250790u, 0, SINF_TOLERANCE, 0},
{1035, 886201503u, 4294967150u, 886201503u, 0, SINF_TOLERANCE, 0},
{1036, 3297366026u, 7u, 3192470223u, 0, SINF_TOLERANCE, 0},
{1037, 1218488455u, 4294964141u, 1045436187u, 0, SINF_TOLERANCE, 0},
{1038, 3040358923u, 0u, 3040358923u, 0, SINF_TOLERANCE, 0},
{1039, 1283938137u, 53086u, 3191014709u, 0, SINF_TOLERANCE, 0},
{1040, 3182551696u, 0u, 3182537043u, 0, SINF_TOLERANCE, 0},
{1041, 1317098613u, 0u, 3212501318u, 0, SINF_TOLERANCE, 0},
{1042, 3116209179u, 4294965434u, 3116209179u, 0, SINF_TOLERANCE, 0},
{1043, 3431703657u, 0u, 3206335982u, 0, SINF_TOLERANCE, 0},
{1044, 3239728775u, 0u, 1046532122u, 0, SINF_TOLERANCE, 0},
{1045, 3207141672u, 0u, 3206353199u, 0, SINF_TOLERANCE, 0},
{1046, 3154378805u, 0u, 3154378711u, 0, SINF_TOLERANCE, 0},
{1047, 3069658155u, 0u, 3069658155u, 0, SINF_TOLERANCE, 0},
{1048, 3313160088u, 0u, 1063962697u, 0, SINF_TOLERANCE, 0},
{1049, 3207056527u, 4293469023u, 3206285831u, 0, SINF_TOLERANCE, 0},
{1050, 1284174954u, 4180334232u, 1064619785u, 0, SINF_TOLERANCE, 0},
{1051, 3156081645u, 4294964338u, 3156081485u, 0, SINF_TOLERANCE, 0},
{1052, 1063693032u, 0u, 1061728939u, 0, SINF_TOLERANCE, 0},
{1053, 3036026175u, 4845007u, 3036026175u, 0, SINF_TOLERANCE, 0},
{1054, 1102631663u, 4290881696u, 3211100727u, 0, SINF_TOLERANCE, 0},
{1055, 968803479u, 0u, 968803479u, 0, SINF_TOLERANCE, 0},
{1056, 3273080388u, 0u, 3202168628u, 0, SINF_TOLERANCE, 0},
{1057, 1172529774u, 4294966405u, 1052481368u, 0, SINF_TOLERANCE, 0},
{1058, 1306695905u, 147733664u, 1063024816u, 0, SINF_TOLERANCE, 0},
{1059, 1003649752u, 338518u, 1003649657u, 0, SINF_TOLERANCE, 0},
{1060, 1078478376u, 2364151808u, 1011462484u, 0, SINF_TOLERANCE, 0},
{1061, 3158855023u, 0u, 3158854696u, 0, SINF_TOLERANCE, 0},
{1062, 1165177679u, 4294967097u, 1064368675u, 0, SINF_TOLERANCE, 0},
{1063, 3403009513u, 4293749042u, 3200332882u, 0, SINF_TOLERANCE, 0},
{1064, 952348506u, 4294108410u, 952348506u, 0, SINF_TOLERANCE, 0},
{1065, 1222777442u, 153u, 1061418024u, 0, SINF_TOLERANCE, 0},
{1066, 1325324763u, 0u, 1057307338u, 0, SINF_TOLERANCE, 0},
{1067, 3363524213u, 0u, 1057332239u, 0, SINF_TOLERANCE, 0},
{1068, 1158950321u, 1u, 1063101660u, 0, SINF_TOLERANCE, 0},
{1069, 903129873u, 4272788450u, 903129873u, 0, SINF_TOLERANCE, 0},
{1070, 3078339944u, 0u, 3078339944u, 0, SINF_TOLERANCE, 0},
{1071, 1208345407u, 6333643u, 1064552605u, 0, SINF_TOLERANCE, 0},
{1072, 1258634105u, 3575206u, 1049625456u, 0, SINF_TOLERANCE, 0},
{1073, 1248478509u, 102613680u, 3212835226u, 0, SINF_TOLERANCE, 0},
{1074, 1153863988u, 4229464460u, 3211074162u, 0, SINF_TOLERANCE, 0},
{1075, 1235620969u, 0u, 1064569301u, 0, SINF_TOLERANCE, 0},
{1076, 1097120930u, 4294967294u, 1065141893u, 0, SINF_TOLERANCE, 0},
{1077, 3469778622u, 70286u, 1065325367u, 0, SINF_TOLERANCE, 0},
{1078, 1147712200u, 0u, 1061528543u, 0, SINF_TOLERANCE, 0},
{1079, 1124721745u, 0u, 3198804551u, 0, SINF_TOLERANCE, 0},
{1080, 3261744304u, 0u, 3211184016u, 0, SINF_TOLERANCE, 0},
{1081, 1064922416u, 1518435840u, 1062456150u, 0, SINF_TOLERANCE, 0},
{1082, 3303160152u, 0u, 3194883701u, 0, SINF_TOLERANCE, 0},
{1083, 1315090496u, 4294967183u, 1027282864u, 0, SINF_TOLERANCE, 0},
{1084, 3230403187u, 1820050432u, 1064414424u, 0, SINF_TOLERANCE, 0},
{1085, 1335399673u, 0u, 1057037838u, 0, SINF_TOLERANCE, 0},
{1086, 1072458508u, 4294404660u, 1064717243u, 0, SINF_TOLERANCE, 0},
{1087, 3303015249u, 0u, 3212580702u, 0, SINF_TOLERANCE, 0},
{1088, 3252139741u, 0u, 3212269737u, 0, SINF_TOLERANCE, 0},
{1089, 3468519966u, 0u, 3212788099u, 0, SINF_TOLERANCE, 0},
{1090, 1006231203u, 0u, 1006231044u, 0, SINF_TOLERANCE, 0},
{1091, 951554138u, 0u, 951554138u, 0, SINF_TOLERANCE, 0},
{1092, 942046828u, 0u, 942046828u, 0, SINF_TOLERANCE, 0},
{1093, 3319723279u, 4277552160u, 1033521666u, 0, SINF_TOLERANCE, 0},
{1094, 3255104167u, 0u, 3212314295u, 0, SINF_TOLERANCE, 0},
{1095, 1155477903u, 0u, 1063706868u, 0, SINF_TOLERANCE, 0},
{1096, 3273889176u, 0u, 3194027929u, 0, SINF_TOLERANCE, 0},
{1097, 3237813668u, 4133749200u, 3212810671u, 0, SINF_TOLERANCE, 0},
{1098, 1228207362u, 0u, 3210431030u, 0, SINF_TOLERANCE, 0},
{1099, 975349337u, 748694784u, 975349336u, 0, SINF_TOLERANCE, 0},
{1100, 1290175785u, 0u, 3208122918u, 0, SINF_TOLERANCE, 0},
{1101, 981908840u, 4294962938u, 981908838u, 0, SINF_TOLERANCE, 0},
{1102, 941187647u, 33u, 941187647u, 0, SINF_TOLERANCE, 0},
{1103, 1214223128u, 4294967293u, 3175395280u, 0, SINF_TOLERANCE, 0},
{1104, 3422922584u, 6u, 3202621705u, 0, SINF_TOLERANCE, 0},
{1105, 1315857601u, 1055172096u, 1060440419u, 0, SINF_TOLERANCE, 0},
{1106, 3453226030u, 4294967291u, 1055080459u, 0, SINF_TOLERANCE, 0},
{1107, 1078359574u, 0u, 1025926511u, 0, SINF_TOLERANCE, 0},
{1108, 1029557624u, 4294965511u, 1029550521u, 0, SINF_TOLERANCE, 0},
{1109, 1207675424u, 0u, 1043330099u, 0, SINF_TOLERANCE, 0},
{1110, 1028355074u, 4113313408u, 1028349592u, 0, SINF_TOLERANCE, 0},
{1111, 3119299090u, 24787u, 3119299089u, 0, SINF_TOLERANCE, 0},
{1112, 1248421894u, 4294582111u, 1059507841u, 0, SINF_TOLERANCE, 0},
{1113, 3353251994u, 12u, 3212445556u, 0, SINF_TOLERANCE, 0},
{1114, 876926659u, 4294966792u, 876926659u, 0, SINF_TOLERANCE, 0},
{1115, 1076752219u, 0u, 1053987679u, 0, SINF_TOLERANCE, 0},
{1116, 3388531942u, 0u, 3150373635u, 0, SINF_TOLERANCE, 0},
{1117, 1273395082u, 0u, 3195827353u, 0, SINF_TOLERANCE, 0},
{1118, 3385588183u, 4294967251u, 3212638167u, 0, SINF_TOLERANCE, 0},
{1119, 3192315328u, 4294966714u, 3192233558u, 0, SINF_TOLERANCE, 0},
{1120, 3441804648u, 4294967121u, 1064889844u, 0, SINF_TOLERANCE, 0},
{1121, 3392827417u, 45125368u, 3204991638u, 0, SINF_TOLERANCE, 0},
{1122, 1161241793u, 2814016256u, 1060713941u, 0, SINF_TOLERANCE, 0},
{1123, 3034494183u, 0u, 3034494183u, 0, SINF_TOLERANCE, 0},
{1124, 1171318485u, 4294306215u, 3202421859u, 0, SINF_TOLERANCE, 0},
{1125, 3047748143u, 0u, 3047748143u, 0, SINF_TOLERANCE, 0},
{1126, 1001216371u, 0u, 1001216318u, 0, SINF_TOLERANCE, 0},
{1127, 912515889u, 2u, 912515889u, 0, SINF_TOLERANCE, 0},
{1128, 3391452505u, 0u, 3205889616u, 0, SINF_TOLERANCE, 0},
{1129, 3249603369u, 0u, 1040857218u, 0, SINF_TOLERANCE, 0},
{1130, 1220264047u, 0u, 3194967897u, 0, SINF_TOLERANCE, 0},
{1131, 3169816394u, 0u, 3169814156u, 0, SINF_TOLERANCE, 0},
{1132, 3098997418u, 0u, 3098997418u, 0, SINF_TOLERANCE, 0},
{1133, 3282212423u, 0u, 1065350123u, 0, SINF_TOLERANCE, 0},
{1134, 3352293320u, 4294967278u, 3212086835u, 0, SINF_TOLERANCE, 0},
{1135, 3296358441u, 0u, 3201216860u, 0, SINF_TOLERANCE, 0},
{1136, 1197828352u, 4294967281u, 1032387171u, 0, SINF_TOLERANCE, 0},
{1137, 3340510371u, 0u, 1062585647u, 0, SINF_TOLERANCE, 0},
{1138, 1127109339u, 4294570975u, 3212826742u, 0, SINF_TOLERANCE, 0},
{1139, 909467381u, 1001724u, 909467381u, 0, SINF_TOLERANCE, 0},
{1140, 1200599955u, 0u, 3209721212u, 0, SINF_TOLERANCE, 0},
{1141, 962230977u, 0u, 962230977u, 0, SINF_TOLERANCE, 0},
{1142, 3192887808u, 0u, 3192794798u, 0, SINF_TOLERANCE, 0},
{1143, 3237183876u, 0u, 3212338202u, 0, SINF_TOLERANCE, 0},
{1144, 939285924u, 0u, 939285924u, 0, SINF_TOLERANCE, 0},
{1145, 944050180u, 3871652128u, 944050180u, 0, SINF_TOLERANCE, 0},
{1146, 3058135703u, 0u, 3058135703u, 0, SINF_TOLERANCE, 0},
{1147, 3480592662u, 4294967238u, 3204456894u, 0, SINF_TOLERANCE, 0},
{1148, 3061939312u, 4294967125u, 3061939312u, 0, SINF_TOLERANCE, 0},
{1149, 1003299981u, 0u, 1003299893u, 0, SINF_TOLERANCE, 0},
{1150, 1155775526u, 7150230u, 3195501537u, 0, SINF_TOLERANCE, 0},
{1151, 1234491880u, 4283784819u, 3212387912u, 0, SINF_TOLERANCE, 0}

// AUTOMATICALLY GENERATED VECTORS STOP

};

#endif // CYGONCE_LIBM_SCABNF_H multiple inclusion protection

// EOF sinf.h
