#ifndef CYGONCE_LIBM_SCABNF_H
#define CYGONCE_LIBM_SCABNF_H
//===========================================================================
//
//      scalbnf.h
//
//      Test vectors for testing of scalbnf() math library function
//
//===========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####
// -------------------------------------------
// This file is part of eCos, the Embedded Configurable Operating System.
// Copyright (C) 2012 Free Software Foundation, Inc.
//
// eCos is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 or (at your option) any later
// version.
//
// eCos is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
// for more details.
//
// You should have received a copy of the GNU General Public License
// along with eCos; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//
// As a special exception, if other files instantiate templates or use
// macros or inline functions from this file, or you compile this file
// and link it with other works to produce a work based on this file,
// this file does not by itself cause the resulting work to be covered by
// the GNU General Public License. However the source code for this file
// must still be made available in accordance with section (3) of the GNU
// General Public License v2.
//
// This exception does not invalidate any other reasons why a work based
// on this file might be covered by the GNU General Public License.
// -------------------------------------------
// ####ECOSGPLCOPYRIGHTEND####
//===========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):
// Contributors:  visar, ilijak
// Date:        1998-02-13
// Purpose:
// Description:
// Usage:       #include "vectors/scalbnf.h"
//
//####DESCRIPTIONEND####
//
//===========================================================================


// CONFIGURATION

#include <pkgconf/libm.h>   // Configuration header


// INCLUDES

#include <cyg/infra/cyg_type.h>    // Common type definitions and support
#include "vectors/vector_support_float.h"// extra support for math tests

#define SCALBNF_TOLERANCE 1.0E-04

static const Cyg_libm_test_float_vec_t scalbnf_vec[] = {

// AUTOMATICALLY GENERATED VECTORS START

{0, 3196650934u, 0u, 3196650934u, 0, SCALBNF_TOLERANCE, 0},
{1, 1224242132u, 0u, 1224242132u, 0, SCALBNF_TOLERANCE, 0},
{2, 1198712763u, 0u, 1198712763u, 0, SCALBNF_TOLERANCE, 0},
{3, 3159309973u, 0u, 3159309973u, 0, SCALBNF_TOLERANCE, 0},
{4, 954173073u, 0u, 954173073u, 0, SCALBNF_TOLERANCE, 0},
{5, 3090780435u, 0u, 3090780435u, 0, SCALBNF_TOLERANCE, 0},
{6, 966554515u, 4294967290u, 916222867u, 0, SCALBNF_TOLERANCE, 0},
{7, 1166191415u, 0u, 1166191415u, 0, SCALBNF_TOLERANCE, 0},
{8, 1234419246u, 0u, 1234419246u, 0, SCALBNF_TOLERANCE, 0},
{9, 1302107128u, 4294492157u, 0u, 0, SCALBNF_TOLERANCE, 0},
{10, 1052801068u, 0u, 1052801068u, 0, SCALBNF_TOLERANCE, 0},
{11, 1060849628u, 0u, 1060849628u, 0, SCALBNF_TOLERANCE, 0},
{12, 3484320003u, 0u, 3484320003u, 0, SCALBNF_TOLERANCE, 0},
{13, 1167223673u, 0u, 1167223673u, 0, SCALBNF_TOLERANCE, 0},
{14, 968192794u, 0u, 968192794u, 0, SCALBNF_TOLERANCE, 0},
{15, 3122346862u, 48u, 3525000046u, 0, SCALBNF_TOLERANCE, 0},
{16, 906701409u, 0u, 906701409u, 0, SCALBNF_TOLERANCE, 0},
{17, 3231467496u, 0u, 3231467496u, 0, SCALBNF_TOLERANCE, 0},
{18, 1341514497u, 3022046720u, 0u, 0, SCALBNF_TOLERANCE, 0},
{19, 1272351391u, 4294363968u, 0u, 0, SCALBNF_TOLERANCE, 0},
{20, 940236348u, 4294965375u, 0u, 0, SCALBNF_TOLERANCE, 0},
{21, 3251541546u, 0u, 3251541546u, 0, SCALBNF_TOLERANCE, 0},
{22, 3110358400u, 0u, 3110358400u, 0, SCALBNF_TOLERANCE, 0},
{23, 3371863479u, 0u, 3371863479u, 0, SCALBNF_TOLERANCE, 0},
{24, 3204069187u, 0u, 3204069187u, 0, SCALBNF_TOLERANCE, 0},
{25, 1306460502u, 0u, 1306460502u, 0, SCALBNF_TOLERANCE, 0},
{26, 1197542187u, 0u, 1197542187u, 0, SCALBNF_TOLERANCE, 0},
{27, 1184239996u, 4294967294u, 1167462780u, 0, SCALBNF_TOLERANCE, 0},
{28, 1001673627u, 3340510784u, 0u, 0, SCALBNF_TOLERANCE, 0},
{29, 941796645u, 0u, 941796645u, 0, SCALBNF_TOLERANCE, 0},
{30, 3287199470u, 0u, 3287199470u, 0, SCALBNF_TOLERANCE, 0},
{31, 1143233714u, 0u, 1143233714u, 0, SCALBNF_TOLERANCE, 0},
{32, 3143717025u, 4294967290u, 3093385377u, 0, SCALBNF_TOLERANCE, 0},
{33, 3240298487u, 0u, 3240298487u, 0, SCALBNF_TOLERANCE, 0},
{34, 1288902137u, 0u, 1288902137u, 0, SCALBNF_TOLERANCE, 0},
{35, 3329354473u, 0u, 3329354473u, 0, SCALBNF_TOLERANCE, 0},
{36, 1309289088u, 0u, 1309289088u, 0, SCALBNF_TOLERANCE, 0},
{37, 3405585402u, 0u, 3405585402u, 0, SCALBNF_TOLERANCE, 0},
{38, 3106647724u, 0u, 3106647724u, 0, SCALBNF_TOLERANCE, 0},
{39, 1106778573u, 4294965325u, 0u, 0, SCALBNF_TOLERANCE, 0},
{40, 1140567947u, 0u, 1140567947u, 0, SCALBNF_TOLERANCE, 0},
{41, 1238569473u, 0u, 1238569473u, 0, SCALBNF_TOLERANCE, 0},
{42, 1175011025u, 0u, 1175011025u, 0, SCALBNF_TOLERANCE, 0},
{43, 3058097085u, 0u, 3058097085u, 0, SCALBNF_TOLERANCE, 0},
{44, 3107252546u, 1u, 3115641154u, 0, SCALBNF_TOLERANCE, 0},
{45, 3096032662u, 0u, 3096032662u, 0, SCALBNF_TOLERANCE, 0},
{46, 3197942144u, 0u, 3197942144u, 0, SCALBNF_TOLERANCE, 0},
{47, 3403348556u, 0u, 3403348556u, 0, SCALBNF_TOLERANCE, 0},
{48, 1136411063u, 82u, 1824276919u, 0, SCALBNF_TOLERANCE, 0},
{49, 3340615780u, 0u, 3340615780u, 0, SCALBNF_TOLERANCE, 0},
{50, 998567360u, 0u, 998567360u, 0, SCALBNF_TOLERANCE, 0},
{51, 989687421u, 4294414202u, 0u, 0, SCALBNF_TOLERANCE, 0},
{52, 1152956913u, 0u, 1152956913u, 0, SCALBNF_TOLERANCE, 0},
{53, 892922651u, 4294392467u, 0u, 0, SCALBNF_TOLERANCE, 0},
{54, 1307091856u, 24u, 1508418448u, 0, SCALBNF_TOLERANCE, 0},
{55, 1142167709u, 13u, 1251219613u, 0, SCALBNF_TOLERANCE, 0},
{56, 3426232834u, 0u, 3426232834u, 0, SCALBNF_TOLERANCE, 0},
{57, 3368566779u, 0u, 3368566779u, 0, SCALBNF_TOLERANCE, 0},
{58, 1138741813u, 0u, 1138741813u, 0, SCALBNF_TOLERANCE, 0},
{59, 982950501u, 0u, 982950501u, 0, SCALBNF_TOLERANCE, 0},
{60, 1142981585u, 0u, 1142981585u, 0, SCALBNF_TOLERANCE, 0},
{61, 3347165962u, 0u, 3347165962u, 0, SCALBNF_TOLERANCE, 0},
{62, 1009535440u, 4293825695u, 0u, 0, SCALBNF_TOLERANCE, 0},
{63, 3126820946u, 2u, 3143598162u, 0, SCALBNF_TOLERANCE, 0},
{64, 3473956030u, 0u, 3473956030u, 0, SCALBNF_TOLERANCE, 0},
{65, 3349098349u, 0u, 3349098349u, 0, SCALBNF_TOLERANCE, 0},
{66, 3152729489u, 0u, 3152729489u, 0, SCALBNF_TOLERANCE, 0},
{67, 945568720u, 4294963204u, 0u, 0, SCALBNF_TOLERANCE, 0},
{68, 3345489836u, 36u, 3647479724u, 0, SCALBNF_TOLERANCE, 0},
{69, 976791751u, 4294967292u, 943237319u, 0, SCALBNF_TOLERANCE, 0},
{70, 1004442355u, 0u, 1004442355u, 0, SCALBNF_TOLERANCE, 0},
{71, 1108485380u, 0u, 1108485380u, 0, SCALBNF_TOLERANCE, 0},
{72, 1061834641u, 0u, 1061834641u, 0, SCALBNF_TOLERANCE, 0},
{73, 1087189715u, 0u, 1087189715u, 0, SCALBNF_TOLERANCE, 0},
{74, 1000611335u, 0u, 1000611335u, 0, SCALBNF_TOLERANCE, 0},
{75, 3466188568u, 0u, 3466188568u, 0, SCALBNF_TOLERANCE, 0},
{76, 3072456205u, 0u, 3072456205u, 0, SCALBNF_TOLERANCE, 0},
{77, 1315030230u, 4294939294u, 0u, 0, SCALBNF_TOLERANCE, 0},
{78, 1134593658u, 3712906944u, 0u, 0, SCALBNF_TOLERANCE, 0},
{79, 977281449u, 0u, 977281449u, 0, SCALBNF_TOLERANCE, 0},
{80, 1086198791u, 0u, 1086198791u, 0, SCALBNF_TOLERANCE, 0},
{81, 1255152035u, 0u, 1255152035u, 0, SCALBNF_TOLERANCE, 0},
{82, 1135271264u, 4294966890u, 0u, 0, SCALBNF_TOLERANCE, 0},
{83, 1094190727u, 0u, 1094190727u, 0, SCALBNF_TOLERANCE, 0},
{84, 1294665325u, 0u, 1294665325u, 0, SCALBNF_TOLERANCE, 0},
{85, 1036608591u, 0u, 1036608591u, 0, SCALBNF_TOLERANCE, 0},
{86, 3229998064u, 0u, 3229998064u, 0, SCALBNF_TOLERANCE, 0},
{87, 3439134022u, 0u, 3439134022u, 0, SCALBNF_TOLERANCE, 0},
{88, 1325668223u, 0u, 1325668223u, 0, SCALBNF_TOLERANCE, 0},
{89, 1092037607u, 0u, 1092037607u, 0, SCALBNF_TOLERANCE, 0},
{90, 3295436768u, 0u, 3295436768u, 0, SCALBNF_TOLERANCE, 0},
{91, 1151984049u, 0u, 1151984049u, 0, SCALBNF_TOLERANCE, 0},
{92, 1129287043u, 0u, 1129287043u, 0, SCALBNF_TOLERANCE, 0},
{93, 1243664530u, 0u, 1243664530u, 0, SCALBNF_TOLERANCE, 0},
{94, 950829092u, 0u, 950829092u, 0, SCALBNF_TOLERANCE, 0},
{95, 1115471979u, 0u, 1115471979u, 0, SCALBNF_TOLERANCE, 0},
{96, 3351092088u, 0u, 3351092088u, 0, SCALBNF_TOLERANCE, 0},
{97, 3241193975u, 0u, 3241193975u, 0, SCALBNF_TOLERANCE, 0},
{98, 1030934236u, 0u, 1030934236u, 0, SCALBNF_TOLERANCE, 0},
{99, 1025254314u, 0u, 1025254314u, 0, SCALBNF_TOLERANCE, 0},
{100, 1110545760u, 4294967286u, 1026659680u, 0, SCALBNF_TOLERANCE, 0},
{101, 3180213739u, 37u, 3490592235u, 0, SCALBNF_TOLERANCE, 0},
{102, 3361976590u, 0u, 3361976590u, 0, SCALBNF_TOLERANCE, 0},
{103, 881280146u, 4262747520u, 0u, 0, SCALBNF_TOLERANCE, 0},
{104, 1304154705u, 0u, 1304154705u, 0, SCALBNF_TOLERANCE, 0},
{105, 3264443610u, 4294967294u, 3247666394u, 0, SCALBNF_TOLERANCE, 0},
{106, 3374550627u, 0u, 3374550627u, 0, SCALBNF_TOLERANCE, 0},
{107, 1161858787u, 0u, 1161858787u, 0, SCALBNF_TOLERANCE, 0},
{108, 3325193181u, 0u, 3325193181u, 0, SCALBNF_TOLERANCE, 0},
{109, 3115275450u, 0u, 3115275450u, 0, SCALBNF_TOLERANCE, 0},
{110, 3116607482u, 4294967294u, 3099830266u, 0, SCALBNF_TOLERANCE, 0},
{111, 3187892415u, 0u, 3187892415u, 0, SCALBNF_TOLERANCE, 0},
{112, 1189120494u, 0u, 1189120494u, 0, SCALBNF_TOLERANCE, 0},
{113, 889030794u, 0u, 889030794u, 0, SCALBNF_TOLERANCE, 0},
{114, 1323529208u, 0u, 1323529208u, 0, SCALBNF_TOLERANCE, 0},
{115, 3465768388u, 0u, 3465768388u, 0, SCALBNF_TOLERANCE, 0},
{116, 3426099899u, 87u, 4155908795u, 0, SCALBNF_TOLERANCE, 0},
{117, 1065798296u, 0u, 1065798296u, 0, SCALBNF_TOLERANCE, 0},
{118, 3328989444u, 0u, 3328989444u, 0, SCALBNF_TOLERANCE, 0},
{119, 3357819026u, 0u, 3357819026u, 0, SCALBNF_TOLERANCE, 0},
{120, 1273397670u, 0u, 1273397670u, 0, SCALBNF_TOLERANCE, 0},
{121, 1257596246u, 4264851904u, 0u, 0, SCALBNF_TOLERANCE, 0},
{122, 1051773536u, 0u, 1051773536u, 0, SCALBNF_TOLERANCE, 0},
{123, 3294752507u, 0u, 3294752507u, 0, SCALBNF_TOLERANCE, 0},
{124, 3424848725u, 0u, 3424848725u, 0, SCALBNF_TOLERANCE, 0},
{125, 1090870906u, 4294966393u, 0u, 0, SCALBNF_TOLERANCE, 0},
{126, 1272325814u, 0u, 1272325814u, 0, SCALBNF_TOLERANCE, 0},
{127, 3359508271u, 0u, 3359508271u, 0, SCALBNF_TOLERANCE, 0},
{128, 1137854355u, 4294941607u, 0u, 0, SCALBNF_TOLERANCE, 0},
{129, 3440773058u, 0u, 3440773058u, 0, SCALBNF_TOLERANCE, 0},
{130, 3101598400u, 0u, 3101598400u, 0, SCALBNF_TOLERANCE, 0},
{131, 3437062994u, 0u, 3437062994u, 0, SCALBNF_TOLERANCE, 0},
{132, 3303035472u, 0u, 3303035472u, 0, SCALBNF_TOLERANCE, 0},
{133, 1053698677u, 4294966907u, 0u, 0, SCALBNF_TOLERANCE, 0},
{134, 3037541131u, 5u, 3079484171u, 0, SCALBNF_TOLERANCE, 0},
{135, 3458934263u, 0u, 3458934263u, 0, SCALBNF_TOLERANCE, 0},
{136, 1065761827u, 4294943781u, 0u, 0, SCALBNF_TOLERANCE, 0},
{137, 3025843188u, 0u, 3025843188u, 0, SCALBNF_TOLERANCE, 0},
{138, 926665223u, 0u, 926665223u, 0, SCALBNF_TOLERANCE, 0},
{139, 1199816046u, 0u, 1199816046u, 0, SCALBNF_TOLERANCE, 0},
{140, 3333779015u, 0u, 3333779015u, 0, SCALBNF_TOLERANCE, 0},
{141, 948398145u, 4294967288u, 881289281u, 0, SCALBNF_TOLERANCE, 0},
{142, 3164749613u, 0u, 3164749613u, 0, SCALBNF_TOLERANCE, 0},
{143, 3118883815u, 0u, 3118883815u, 0, SCALBNF_TOLERANCE, 0},
{144, 3226990408u, 45u, 3604477768u, 0, SCALBNF_TOLERANCE, 0},
{145, 3117098218u, 115u, 4081788138u, 0, SCALBNF_TOLERANCE, 0},
{146, 1283624229u, 0u, 1283624229u, 0, SCALBNF_TOLERANCE, 0},
{147, 970649315u, 3u, 995815139u, 0, SCALBNF_TOLERANCE, 0},
{148, 959776291u, 4294967028u, 0u, 0, SCALBNF_TOLERANCE, 0},
{149, 1270734970u, 4294829480u, 0u, 0, SCALBNF_TOLERANCE, 0},
{150, 3454816067u, 0u, 3454816067u, 0, SCALBNF_TOLERANCE, 0},
{151, 1157598381u, 4294964293u, 0u, 0, SCALBNF_TOLERANCE, 0},
{152, 3335234513u, 0u, 3335234513u, 0, SCALBNF_TOLERANCE, 0},
{153, 1279489061u, 0u, 1279489061u, 0, SCALBNF_TOLERANCE, 0},
{154, 3143920719u, 0u, 3143920719u, 0, SCALBNF_TOLERANCE, 0},
{155, 1233171235u, 0u, 1233171235u, 0, SCALBNF_TOLERANCE, 0},
{156, 1148920078u, 0u, 1148920078u, 0, SCALBNF_TOLERANCE, 0},
{157, 3064988156u, 4294967292u, 3031433724u, 0, SCALBNF_TOLERANCE, 0},
{158, 3219949483u, 0u, 3219949483u, 0, SCALBNF_TOLERANCE, 0},
{159, 1207502108u, 4292985650u, 0u, 0, SCALBNF_TOLERANCE, 0},
{160, 1000014431u, 0u, 1000014431u, 0, SCALBNF_TOLERANCE, 0},
{161, 3161756316u, 0u, 3161756316u, 0, SCALBNF_TOLERANCE, 0},
{162, 1234530539u, 3u, 1259696363u, 0, SCALBNF_TOLERANCE, 0},
{163, 3306328852u, 87u, 4036137748u, 0, SCALBNF_TOLERANCE, 0},
{164, 1131927531u, 0u, 1131927531u, 0, SCALBNF_TOLERANCE, 0},
{165, 3449879391u, 0u, 3449879391u, 0, SCALBNF_TOLERANCE, 0},
{166, 970094304u, 4294911386u, 0u, 0, SCALBNF_TOLERANCE, 0},
{167, 1125551064u, 4294949017u, 0u, 0, SCALBNF_TOLERANCE, 0},
{168, 3201603336u, 0u, 3201603336u, 0, SCALBNF_TOLERANCE, 0},
{169, 921940707u, 0u, 921940707u, 0, SCALBNF_TOLERANCE, 0},
{170, 1091906532u, 0u, 1091906532u, 0, SCALBNF_TOLERANCE, 0},
{171, 1276853215u, 0u, 1276853215u, 0, SCALBNF_TOLERANCE, 0},
{172, 3360170117u, 0u, 3360170117u, 0, SCALBNF_TOLERANCE, 0},
{173, 1064364381u, 0u, 1064364381u, 0, SCALBNF_TOLERANCE, 0},
{174, 1268744779u, 4294952694u, 0u, 0, SCALBNF_TOLERANCE, 0},
{175, 1165195428u, 4292538760u, 0u, 0, SCALBNF_TOLERANCE, 0},
{176, 3044092739u, 30u, 3295750979u, 0, SCALBNF_TOLERANCE, 0},
{177, 3247790039u, 0u, 3247790039u, 0, SCALBNF_TOLERANCE, 0},
{178, 3215244648u, 4u, 3248799080u, 0, SCALBNF_TOLERANCE, 0},
{179, 3095275931u, 0u, 3095275931u, 0, SCALBNF_TOLERANCE, 0},
{180, 3059688264u, 77u, 3705611080u, 0, SCALBNF_TOLERANCE, 0},
{181, 1212717473u, 0u, 1212717473u, 0, SCALBNF_TOLERANCE, 0},
{182, 3028857014u, 0u, 3028857014u, 0, SCALBNF_TOLERANCE, 0},
{183, 1044867873u, 4294528232u, 0u, 0, SCALBNF_TOLERANCE, 0},
{184, 1089986803u, 3370664576u, 0u, 0, SCALBNF_TOLERANCE, 0},
{185, 1296314700u, 0u, 1296314700u, 0, SCALBNF_TOLERANCE, 0},
{186, 1251462432u, 0u, 1251462432u, 0, SCALBNF_TOLERANCE, 0},
{187, 3485236902u, 0u, 3485236902u, 0, SCALBNF_TOLERANCE, 0},
{188, 3080852256u, 0u, 3080852256u, 0, SCALBNF_TOLERANCE, 0},
{189, 1022211242u, 0u, 1022211242u, 0, SCALBNF_TOLERANCE, 0},
{190, 884661176u, 0u, 884661176u, 0, SCALBNF_TOLERANCE, 0},
{191, 989762529u, 4294733601u, 0u, 0, SCALBNF_TOLERANCE, 0},
{192, 1295475718u, 0u, 1295475718u, 0, SCALBNF_TOLERANCE, 0},
{193, 1002632518u, 4294950696u, 0u, 0, SCALBNF_TOLERANCE, 0},
{194, 3158912530u, 0u, 3158912530u, 0, SCALBNF_TOLERANCE, 0},
{195, 3138037576u, 0u, 3138037576u, 0, SCALBNF_TOLERANCE, 0},
{196, 999985470u, 4282999218u, 0u, 0, SCALBNF_TOLERANCE, 0},
{197, 1189421739u, 0u, 1189421739u, 0, SCALBNF_TOLERANCE, 0},
{198, 3075182644u, 0u, 3075182644u, 0, SCALBNF_TOLERANCE, 0},
{199, 1164046161u, 4139845440u, 0u, 0, SCALBNF_TOLERANCE, 0},
{200, 1292596266u, 0u, 1292596266u, 0, SCALBNF_TOLERANCE, 0},
{201, 1314644642u, 0u, 1314644642u, 0, SCALBNF_TOLERANCE, 0},
{202, 3399813173u, 0u, 3399813173u, 0, SCALBNF_TOLERANCE, 0},
{203, 1034611395u, 0u, 1034611395u, 0, SCALBNF_TOLERANCE, 0},
{204, 1181604787u, 4294717096u, 0u, 0, SCALBNF_TOLERANCE, 0},
{205, 3059042077u, 0u, 3059042077u, 0, SCALBNF_TOLERANCE, 0},
{206, 1043691622u, 4288164501u, 0u, 0, SCALBNF_TOLERANCE, 0},
{207, 1314588083u, 0u, 1314588083u, 0, SCALBNF_TOLERANCE, 0},
{208, 3141533334u, 0u, 3141533334u, 0, SCALBNF_TOLERANCE, 0},
{209, 3400949680u, 0u, 3400949680u, 0, SCALBNF_TOLERANCE, 0},
{210, 1110424755u, 0u, 1110424755u, 0, SCALBNF_TOLERANCE, 0},
{211, 3189917167u, 0u, 3189917167u, 0, SCALBNF_TOLERANCE, 0},
{212, 969804941u, 4294836255u, 0u, 0, SCALBNF_TOLERANCE, 0},
{213, 934308144u, 0u, 934308144u, 0, SCALBNF_TOLERANCE, 0},
{214, 1156767533u, 7u, 1215487789u, 0, SCALBNF_TOLERANCE, 0},
{215, 994934087u, 0u, 994934087u, 0, SCALBNF_TOLERANCE, 0},
{216, 3185240099u, 122u, 4208650275u, 0, SCALBNF_TOLERANCE, 0},
{217, 1212129651u, 0u, 1212129651u, 0, SCALBNF_TOLERANCE, 0},
{218, 3125775254u, 0u, 3125775254u, 0, SCALBNF_TOLERANCE, 0},
{219, 1037464105u, 0u, 1037464105u, 0, SCALBNF_TOLERANCE, 0},
{220, 918212457u, 0u, 918212457u, 0, SCALBNF_TOLERANCE, 0},
{221, 1337315179u, 3421796288u, 0u, 0, SCALBNF_TOLERANCE, 0},
{222, 1131358407u, 4294955130u, 0u, 0, SCALBNF_TOLERANCE, 0},
{223, 1156517523u, 4294914801u, 0u, 0, SCALBNF_TOLERANCE, 0},
{224, 3210802820u, 0u, 3210802820u, 0, SCALBNF_TOLERANCE, 0},
{225, 3468429030u, 4294967266u, 3216770790u, 0, SCALBNF_TOLERANCE, 0},
{226, 3055299953u, 0u, 3055299953u, 0, SCALBNF_TOLERANCE, 0},
{227, 959956547u, 0u, 959956547u, 0, SCALBNF_TOLERANCE, 0},
{228, 1039917375u, 117u, 2021384511u, 0, SCALBNF_TOLERANCE, 0},
{229, 1311016004u, 4294941884u, 0u, 0, SCALBNF_TOLERANCE, 0},
{230, 1128016396u, 27u, 1354508812u, 0, SCALBNF_TOLERANCE, 0},
{231, 3210335769u, 0u, 3210335769u, 0, SCALBNF_TOLERANCE, 0},
{232, 1206054701u, 0u, 1206054701u, 0, SCALBNF_TOLERANCE, 0},
{233, 1213609983u, 0u, 1213609983u, 0, SCALBNF_TOLERANCE, 0},
{234, 1246902946u, 0u, 1246902946u, 0, SCALBNF_TOLERANCE, 0},
{235, 1029480631u, 0u, 1029480631u, 0, SCALBNF_TOLERANCE, 0},
{236, 3153568584u, 0u, 3153568584u, 0, SCALBNF_TOLERANCE, 0},
{237, 3384988527u, 0u, 3384988527u, 0, SCALBNF_TOLERANCE, 0},
{238, 1317696241u, 0u, 1317696241u, 0, SCALBNF_TOLERANCE, 0},
{239, 3341877624u, 0u, 3341877624u, 0, SCALBNF_TOLERANCE, 0},
{240, 1228636133u, 0u, 1228636133u, 0, SCALBNF_TOLERANCE, 0},
{241, 1207246237u, 0u, 1207246237u, 0, SCALBNF_TOLERANCE, 0},
{242, 1165476654u, 4294877038u, 0u, 0, SCALBNF_TOLERANCE, 0},
{243, 1215278023u, 0u, 1215278023u, 0, SCALBNF_TOLERANCE, 0},
{244, 1017239798u, 4167373560u, 0u, 0, SCALBNF_TOLERANCE, 0},
{245, 1149651309u, 0u, 1149651309u, 0, SCALBNF_TOLERANCE, 0},
{246, 1111943722u, 0u, 1111943722u, 0, SCALBNF_TOLERANCE, 0},
{247, 1189849849u, 4293652457u, 0u, 0, SCALBNF_TOLERANCE, 0},
{248, 3204848496u, 0u, 3204848496u, 0, SCALBNF_TOLERANCE, 0},
{249, 1249758327u, 0u, 1249758327u, 0, SCALBNF_TOLERANCE, 0},
{250, 3215981890u, 4294967286u, 3132095810u, 0, SCALBNF_TOLERANCE, 0},
{251, 1266687209u, 0u, 1266687209u, 0, SCALBNF_TOLERANCE, 0},
{252, 943645710u, 0u, 943645710u, 0, SCALBNF_TOLERANCE, 0},
{253, 935847271u, 1u, 944235879u, 0, SCALBNF_TOLERANCE, 0},
{254, 3410336089u, 47u, 3804600665u, 0, SCALBNF_TOLERANCE, 0},
{255, 3059263153u, 0u, 3059263153u, 0, SCALBNF_TOLERANCE, 0},
{256, 3353679791u, 0u, 3353679791u, 0, SCALBNF_TOLERANCE, 0},
{257, 1001823878u, 0u, 1001823878u, 0, SCALBNF_TOLERANCE, 0},
{258, 1009130212u, 0u, 1009130212u, 0, SCALBNF_TOLERANCE, 0},
{259, 3367127535u, 0u, 3367127535u, 0, SCALBNF_TOLERANCE, 0},
{260, 1032920919u, 3981458912u, 0u, 0, SCALBNF_TOLERANCE, 0},
{261, 3281952870u, 0u, 3281952870u, 0, SCALBNF_TOLERANCE, 0},
{262, 1237868497u, 0u, 1237868497u, 0, SCALBNF_TOLERANCE, 0},
{263, 1153753924u, 4294958733u, 0u, 0, SCALBNF_TOLERANCE, 0},
{264, 1120261759u, 0u, 1120261759u, 0, SCALBNF_TOLERANCE, 0},
{265, 3349595986u, 4294967271u, 3139880786u, 0, SCALBNF_TOLERANCE, 0},
{266, 1087750238u, 16u, 1221967966u, 0, SCALBNF_TOLERANCE, 0},
{267, 1066116543u, 0u, 1066116543u, 0, SCALBNF_TOLERANCE, 0},
{268, 3210898034u, 0u, 3210898034u, 0, SCALBNF_TOLERANCE, 0},
{269, 1030612298u, 4294908239u, 0u, 0, SCALBNF_TOLERANCE, 0},
{270, 1186234578u, 0u, 1186234578u, 0, SCALBNF_TOLERANCE, 0},
{271, 1331680743u, 0u, 1331680743u, 0, SCALBNF_TOLERANCE, 0},
{272, 1045232522u, 4294967290u, 994900874u, 0, SCALBNF_TOLERANCE, 0},
{273, 3119858470u, 0u, 3119858470u, 0, SCALBNF_TOLERANCE, 0},
{274, 3349432725u, 0u, 3349432725u, 0, SCALBNF_TOLERANCE, 0},
{275, 912423027u, 0u, 912423027u, 0, SCALBNF_TOLERANCE, 0},
{276, 3194674746u, 0u, 3194674746u, 0, SCALBNF_TOLERANCE, 0},
{277, 965402291u, 0u, 965402291u, 0, SCALBNF_TOLERANCE, 0},
{278, 1133410485u, 4294951516u, 0u, 0, SCALBNF_TOLERANCE, 0},
{279, 3136790322u, 7u, 3195510578u, 0, SCALBNF_TOLERANCE, 0},
{280, 3369970587u, 0u, 3369970587u, 0, SCALBNF_TOLERANCE, 0},
{281, 1270451568u, 0u, 1270451568u, 0, SCALBNF_TOLERANCE, 0},
{282, 989498922u, 0u, 989498922u, 0, SCALBNF_TOLERANCE, 0},
{283, 1280215674u, 0u, 1280215674u, 0, SCALBNF_TOLERANCE, 0},
{284, 1171873518u, 0u, 1171873518u, 0, SCALBNF_TOLERANCE, 0},
{285, 3298258100u, 0u, 3298258100u, 0, SCALBNF_TOLERANCE, 0},
{286, 3415208824u, 0u, 3415208824u, 0, SCALBNF_TOLERANCE, 0},
{287, 1001897182u, 0u, 1001897182u, 0, SCALBNF_TOLERANCE, 0},
{288, 3152777939u, 4294967281u, 3026948819u, 0, SCALBNF_TOLERANCE, 0},
{289, 985903305u, 4294945424u, 0u, 0, SCALBNF_TOLERANCE, 0},
{290, 3357328848u, 0u, 3357328848u, 0, SCALBNF_TOLERANCE, 0},
{291, 982612185u, 0u, 982612185u, 0, SCALBNF_TOLERANCE, 0},
{292, 1144755661u, 0u, 1144755661u, 0, SCALBNF_TOLERANCE, 0},
{293, 898467286u, 0u, 898467286u, 0, SCALBNF_TOLERANCE, 0},
{294, 3364525678u, 0u, 3364525678u, 0, SCALBNF_TOLERANCE, 0},
{295, 3146660041u, 0u, 3146660041u, 0, SCALBNF_TOLERANCE, 0},
{296, 3467121799u, 0u, 3467121799u, 0, SCALBNF_TOLERANCE, 0},
{297, 1151257041u, 0u, 1151257041u, 0, SCALBNF_TOLERANCE, 0},
{298, 3097873255u, 4294967295u, 3089484647u, 0, SCALBNF_TOLERANCE, 0},
{299, 3130670309u, 0u, 3130670309u, 0, SCALBNF_TOLERANCE, 0},
{300, 1017573824u, 0u, 1017573824u, 0, SCALBNF_TOLERANCE, 0},
{301, 1258369714u, 3364363264u, 0u, 0, SCALBNF_TOLERANCE, 0},
{302, 1216602683u, 4294468761u, 0u, 0, SCALBNF_TOLERANCE, 0},
{303, 1071940738u, 4294963632u, 0u, 0, SCALBNF_TOLERANCE, 0},
{304, 922601356u, 4294937447u, 0u, 0, SCALBNF_TOLERANCE, 0},
{305, 3357177805u, 5u, 3399120845u, 0, SCALBNF_TOLERANCE, 0},
{306, 3049120080u, 0u, 3049120080u, 0, SCALBNF_TOLERANCE, 0},
{307, 1153863660u, 0u, 1153863660u, 0, SCALBNF_TOLERANCE, 0},
{308, 3034243695u, 0u, 3034243695u, 0, SCALBNF_TOLERANCE, 0},
{309, 1249365132u, 4294967060u, 0u, 0, SCALBNF_TOLERANCE, 0},
{310, 3046215730u, 0u, 3046215730u, 0, SCALBNF_TOLERANCE, 0},
{311, 3047251716u, 8u, 3114360580u, 0, SCALBNF_TOLERANCE, 0},
{312, 1297708818u, 0u, 1297708818u, 0, SCALBNF_TOLERANCE, 0},
{313, 3161606610u, 0u, 3161606610u, 0, SCALBNF_TOLERANCE, 0},
{314, 888030585u, 0u, 888030585u, 0, SCALBNF_TOLERANCE, 0},
{315, 1043442869u, 4294963715u, 0u, 0, SCALBNF_TOLERANCE, 0},
{316, 3400348640u, 0u, 3400348640u, 0, SCALBNF_TOLERANCE, 0},
{317, 1250249095u, 1u, 1258637703u, 0, SCALBNF_TOLERANCE, 0},
{318, 3020883322u, 0u, 3020883322u, 0, SCALBNF_TOLERANCE, 0},
{319, 1215968622u, 2531374080u, 0u, 0, SCALBNF_TOLERANCE, 0},
{320, 3202319550u, 0u, 3202319550u, 0, SCALBNF_TOLERANCE, 0},
{321, 3061638260u, 0u, 3061638260u, 0, SCALBNF_TOLERANCE, 0},
{322, 1025404104u, 1u, 1033792712u, 0, SCALBNF_TOLERANCE, 0},
{323, 3138086437u, 0u, 3138086437u, 0, SCALBNF_TOLERANCE, 0},
{324, 3099671635u, 4294967295u, 3091283027u, 0, SCALBNF_TOLERANCE, 0},
{325, 3068014841u, 0u, 3068014841u, 0, SCALBNF_TOLERANCE, 0},
{326, 1252237719u, 105u, 2133041559u, 0, SCALBNF_TOLERANCE, 0},
{327, 3082454432u, 0u, 3082454432u, 0, SCALBNF_TOLERANCE, 0},
{328, 1099710167u, 0u, 1099710167u, 0, SCALBNF_TOLERANCE, 0},
{329, 1282110851u, 0u, 1282110851u, 0, SCALBNF_TOLERANCE, 0},
{330, 1123357102u, 4294966999u, 0u, 0, SCALBNF_TOLERANCE, 0},
{331, 1106837025u, 0u, 1106837025u, 0, SCALBNF_TOLERANCE, 0},
{332, 1253017688u, 0u, 1253017688u, 0, SCALBNF_TOLERANCE, 0},
{333, 1108543194u, 4294966999u, 0u, 0, SCALBNF_TOLERANCE, 0},
{334, 3305715025u, 0u, 3305715025u, 0, SCALBNF_TOLERANCE, 0},
{335, 1266928623u, 0u, 1266928623u, 0, SCALBNF_TOLERANCE, 0},
{336, 3438080027u, 0u, 3438080027u, 0, SCALBNF_TOLERANCE, 0},
{337, 3344574751u, 0u, 3344574751u, 0, SCALBNF_TOLERANCE, 0},
{338, 1152416724u, 0u, 1152416724u, 0, SCALBNF_TOLERANCE, 0},
{339, 3263310567u, 0u, 3263310567u, 0, SCALBNF_TOLERANCE, 0},
{340, 1000313118u, 0u, 1000313118u, 0, SCALBNF_TOLERANCE, 0},
{341, 972485427u, 131u, 2071393075u, 0, SCALBNF_TOLERANCE, 0},
{342, 1278946388u, 0u, 1278946388u, 0, SCALBNF_TOLERANCE, 0},
{343, 947914771u, 0u, 947914771u, 0, SCALBNF_TOLERANCE, 0},
{344, 3167730654u, 0u, 3167730654u, 0, SCALBNF_TOLERANCE, 0},
{345, 3232726036u, 0u, 3232726036u, 0, SCALBNF_TOLERANCE, 0},
{346, 1297190916u, 0u, 1297190916u, 0, SCALBNF_TOLERANCE, 0},
{347, 1277649137u, 0u, 1277649137u, 0, SCALBNF_TOLERANCE, 0},
{348, 3090306474u, 0u, 3090306474u, 0, SCALBNF_TOLERANCE, 0},
{349, 3244032016u, 0u, 3244032016u, 0, SCALBNF_TOLERANCE, 0},
{350, 3033122376u, 0u, 3033122376u, 0, SCALBNF_TOLERANCE, 0},
{351, 3317196817u, 0u, 3317196817u, 0, SCALBNF_TOLERANCE, 0},
{352, 3374748510u, 0u, 3374748510u, 0, SCALBNF_TOLERANCE, 0},
{353, 3345634950u, 0u, 3345634950u, 0, SCALBNF_TOLERANCE, 0},
{354, 3189860276u, 0u, 3189860276u, 0, SCALBNF_TOLERANCE, 0},
{355, 3396917283u, 0u, 3396917283u, 0, SCALBNF_TOLERANCE, 0},
{356, 3317032737u, 0u, 3317032737u, 0, SCALBNF_TOLERANCE, 0},
{357, 1306520561u, 0u, 1306520561u, 0, SCALBNF_TOLERANCE, 0},
{358, 1314936356u, 0u, 1314936356u, 0, SCALBNF_TOLERANCE, 0},
{359, 3085636260u, 33u, 3362460324u, 0, SCALBNF_TOLERANCE, 0},
{360, 3182540197u, 0u, 3182540197u, 0, SCALBNF_TOLERANCE, 0},
{361, 3349005404u, 0u, 3349005404u, 0, SCALBNF_TOLERANCE, 0},
{362, 1053387478u, 0u, 1053387478u, 0, SCALBNF_TOLERANCE, 0},
{363, 3136364836u, 0u, 3136364836u, 0, SCALBNF_TOLERANCE, 0},
{364, 1112891928u, 0u, 1112891928u, 0, SCALBNF_TOLERANCE, 0},
{365, 893449284u, 0u, 893449284u, 0, SCALBNF_TOLERANCE, 0},
{366, 892311459u, 14u, 1009751971u, 0, SCALBNF_TOLERANCE, 0},
{367, 1190105283u, 0u, 1190105283u, 0, SCALBNF_TOLERANCE, 0},
{368, 1043025031u, 0u, 1043025031u, 0, SCALBNF_TOLERANCE, 0},
{369, 3410531037u, 0u, 3410531037u, 0, SCALBNF_TOLERANCE, 0},
{370, 3125834184u, 0u, 3125834184u, 0, SCALBNF_TOLERANCE, 0},
{371, 902318189u, 0u, 902318189u, 0, SCALBNF_TOLERANCE, 0},
{372, 3213624815u, 0u, 3213624815u, 0, SCALBNF_TOLERANCE, 0},
{373, 1120888322u, 5u, 1162831362u, 0, SCALBNF_TOLERANCE, 0},
{374, 1315217243u, 4291026624u, 0u, 0, SCALBNF_TOLERANCE, 0},
{375, 3137758475u, 0u, 3137758475u, 0, SCALBNF_TOLERANCE, 0},
{376, 1040617590u, 0u, 1040617590u, 0, SCALBNF_TOLERANCE, 0},
{377, 955384253u, 4294910624u, 0u, 0, SCALBNF_TOLERANCE, 0},
{378, 904255535u, 0u, 904255535u, 0, SCALBNF_TOLERANCE, 0},
{379, 1022984119u, 0u, 1022984119u, 0, SCALBNF_TOLERANCE, 0},
{380, 997362368u, 0u, 997362368u, 0, SCALBNF_TOLERANCE, 0},
{381, 900933520u, 19u, 1060317072u, 0, SCALBNF_TOLERANCE, 0},
{382, 1039827284u, 1u, 1048215892u, 0, SCALBNF_TOLERANCE, 0},
{383, 1021564080u, 0u, 1021564080u, 0, SCALBNF_TOLERANCE, 0},
{384, 3458669745u, 0u, 3458669745u, 0, SCALBNF_TOLERANCE, 0},
{385, 1040711112u, 4294967293u, 1015545288u, 0, SCALBNF_TOLERANCE, 0},
{386, 1134528351u, 4294638880u, 0u, 0, SCALBNF_TOLERANCE, 0},
{387, 1133689539u, 1u, 1142078147u, 0, SCALBNF_TOLERANCE, 0},
{388, 3415502662u, 0u, 3415502662u, 0, SCALBNF_TOLERANCE, 0},
{389, 954999730u, 0u, 954999730u, 0, SCALBNF_TOLERANCE, 0},
{390, 1066157309u, 4294967285u, 973882621u, 0, SCALBNF_TOLERANCE, 0},
{391, 940437609u, 0u, 940437609u, 0, SCALBNF_TOLERANCE, 0},
{392, 3064200154u, 0u, 3064200154u, 0, SCALBNF_TOLERANCE, 0},
{393, 1023889593u, 0u, 1023889593u, 0, SCALBNF_TOLERANCE, 0},
{394, 1219052056u, 4294526211u, 0u, 0, SCALBNF_TOLERANCE, 0},
{395, 3372118621u, 0u, 3372118621u, 0, SCALBNF_TOLERANCE, 0},
{396, 3146190320u, 0u, 3146190320u, 0, SCALBNF_TOLERANCE, 0},
{397, 1299683827u, 0u, 1299683827u, 0, SCALBNF_TOLERANCE, 0},
{398, 3064155399u, 0u, 3064155399u, 0, SCALBNF_TOLERANCE, 0},
{399, 3040314717u, 1u, 3048703325u, 0, SCALBNF_TOLERANCE, 0},
{400, 1229268598u, 1u, 1237657206u, 0, SCALBNF_TOLERANCE, 0},
{401, 3184078812u, 0u, 3184078812u, 0, SCALBNF_TOLERANCE, 0},
{402, 1086717248u, 4256439624u, 0u, 0, SCALBNF_TOLERANCE, 0},
{403, 3434884607u, 0u, 3434884607u, 0, SCALBNF_TOLERANCE, 0},
{404, 3464955606u, 0u, 3464955606u, 0, SCALBNF_TOLERANCE, 0},
{405, 1025278524u, 0u, 1025278524u, 0, SCALBNF_TOLERANCE, 0},
{406, 1242829722u, 4294967290u, 1192498074u, 0, SCALBNF_TOLERANCE, 0},
{407, 3075149137u, 76u, 3712683345u, 0, SCALBNF_TOLERANCE, 0},
{408, 1246019790u, 0u, 1246019790u, 0, SCALBNF_TOLERANCE, 0},
{409, 1136052740u, 4294967282u, 1018612228u, 0, SCALBNF_TOLERANCE, 0},
{410, 1069009211u, 0u, 1069009211u, 0, SCALBNF_TOLERANCE, 0},
{411, 1015670780u, 20u, 1183442940u, 0, SCALBNF_TOLERANCE, 0},
{412, 1012543234u, 70u, 1599745794u, 0, SCALBNF_TOLERANCE, 0},
{413, 1087942795u, 4294961657u, 0u, 0, SCALBNF_TOLERANCE, 0},
{414, 3426365713u, 0u, 3426365713u, 0, SCALBNF_TOLERANCE, 0},
{415, 3283555717u, 0u, 3283555717u, 0, SCALBNF_TOLERANCE, 0},
{416, 3381255420u, 0u, 3381255420u, 0, SCALBNF_TOLERANCE, 0},
{417, 3388772093u, 0u, 3388772093u, 0, SCALBNF_TOLERANCE, 0},
{418, 1319200415u, 4293050361u, 0u, 0, SCALBNF_TOLERANCE, 0},
{419, 1279324488u, 4294967293u, 1254158664u, 0, SCALBNF_TOLERANCE, 0},
{420, 3217795424u, 0u, 3217795424u, 0, SCALBNF_TOLERANCE, 0},
{421, 1246947517u, 6u, 1297279165u, 0, SCALBNF_TOLERANCE, 0},
{422, 3396723577u, 0u, 3396723577u, 0, SCALBNF_TOLERANCE, 0},
{423, 3433761025u, 0u, 3433761025u, 0, SCALBNF_TOLERANCE, 0},
{424, 3201187455u, 0u, 3201187455u, 0, SCALBNF_TOLERANCE, 0},
{425, 3083019343u, 0u, 3083019343u, 0, SCALBNF_TOLERANCE, 0},
{426, 3042018375u, 0u, 3042018375u, 0, SCALBNF_TOLERANCE, 0},
{427, 1082862511u, 0u, 1082862511u, 0, SCALBNF_TOLERANCE, 0},
{428, 1341821683u, 0u, 1341821683u, 0, SCALBNF_TOLERANCE, 0},
{429, 1079061705u, 0u, 1079061705u, 0, SCALBNF_TOLERANCE, 0},
{430, 1016023520u, 4294967293u, 990857696u, 0, SCALBNF_TOLERANCE, 0},
{431, 1156767169u, 0u, 1156767169u, 0, SCALBNF_TOLERANCE, 0},
{432, 3077020499u, 0u, 3077020499u, 0, SCALBNF_TOLERANCE, 0},
{433, 1104284039u, 0u, 1104284039u, 0, SCALBNF_TOLERANCE, 0},
{434, 1093697541u, 0u, 1093697541u, 0, SCALBNF_TOLERANCE, 0},
{435, 3179003144u, 37u, 3489381640u, 0, SCALBNF_TOLERANCE, 0},
{436, 1094115255u, 0u, 1094115255u, 0, SCALBNF_TOLERANCE, 0},
{437, 882878091u, 0u, 882878091u, 0, SCALBNF_TOLERANCE, 0},
{438, 1098662266u, 0u, 1098662266u, 0, SCALBNF_TOLERANCE, 0},
{439, 927582555u, 0u, 927582555u, 0, SCALBNF_TOLERANCE, 0},
{440, 3111440310u, 0u, 3111440310u, 0, SCALBNF_TOLERANCE, 0},
{441, 3476083859u, 0u, 3476083859u, 0, SCALBNF_TOLERANCE, 0},
{442, 3038754840u, 0u, 3038754840u, 0, SCALBNF_TOLERANCE, 0},
{443, 3464546616u, 0u, 3464546616u, 0, SCALBNF_TOLERANCE, 0},
{444, 1002542205u, 0u, 1002542205u, 0, SCALBNF_TOLERANCE, 0},
{445, 3443552129u, 0u, 3443552129u, 0, SCALBNF_TOLERANCE, 0},
{446, 1287620154u, 0u, 1287620154u, 0, SCALBNF_TOLERANCE, 0},
{447, 3073260205u, 0u, 3073260205u, 0, SCALBNF_TOLERANCE, 0},
{448, 1245702957u, 0u, 1245702957u, 0, SCALBNF_TOLERANCE, 0},
{449, 3087802274u, 0u, 3087802274u, 0, SCALBNF_TOLERANCE, 0},
{450, 3415763001u, 0u, 3415763001u, 0, SCALBNF_TOLERANCE, 0},
{451, 3026311911u, 0u, 3026311911u, 0, SCALBNF_TOLERANCE, 0},
{452, 1198307901u, 68u, 1768733245u, 0, SCALBNF_TOLERANCE, 0},
{453, 922255363u, 0u, 922255363u, 0, SCALBNF_TOLERANCE, 0},
{454, 1113104661u, 0u, 1113104661u, 0, SCALBNF_TOLERANCE, 0},
{455, 1136714348u, 0u, 1136714348u, 0, SCALBNF_TOLERANCE, 0},
{456, 948856035u, 0u, 948856035u, 0, SCALBNF_TOLERANCE, 0},
{457, 1062512367u, 4294967293u, 1037346543u, 0, SCALBNF_TOLERANCE, 0},
{458, 3486907092u, 0u, 3486907092u, 0, SCALBNF_TOLERANCE, 0},
{459, 1162027071u, 4294964303u, 0u, 0, SCALBNF_TOLERANCE, 0},
{460, 1034561811u, 0u, 1034561811u, 0, SCALBNF_TOLERANCE, 0},
{461, 3271615417u, 0u, 3271615417u, 0, SCALBNF_TOLERANCE, 0},
{462, 1177157787u, 0u, 1177157787u, 0, SCALBNF_TOLERANCE, 0},
{463, 3196144817u, 0u, 3196144817u, 0, SCALBNF_TOLERANCE, 0},
{464, 3432084552u, 0u, 3432084552u, 0, SCALBNF_TOLERANCE, 0},
{465, 1309658335u, 0u, 1309658335u, 0, SCALBNF_TOLERANCE, 0},
{466, 1226494979u, 0u, 1226494979u, 0, SCALBNF_TOLERANCE, 0},
{467, 3460699001u, 0u, 3460699001u, 0, SCALBNF_TOLERANCE, 0},
{468, 3079231719u, 0u, 3079231719u, 0, SCALBNF_TOLERANCE, 0},
{469, 3093951884u, 0u, 3093951884u, 0, SCALBNF_TOLERANCE, 0},
{470, 1204196034u, 4294966040u, 0u, 0, SCALBNF_TOLERANCE, 0},
{471, 3459877411u, 0u, 3459877411u, 0, SCALBNF_TOLERANCE, 0},
{472, 1161439847u, 0u, 1161439847u, 0, SCALBNF_TOLERANCE, 0},
{473, 908663107u, 0u, 908663107u, 0, SCALBNF_TOLERANCE, 0},
{474, 1084378658u, 0u, 1084378658u, 0, SCALBNF_TOLERANCE, 0},
{475, 3022828828u, 0u, 3022828828u, 0, SCALBNF_TOLERANCE, 0},
{476, 1226473697u, 0u, 1226473697u, 0, SCALBNF_TOLERANCE, 0},
{477, 3468040845u, 0u, 3468040845u, 0, SCALBNF_TOLERANCE, 0},
{478, 1178825761u, 54u, 1631810593u, 0, SCALBNF_TOLERANCE, 0},
{479, 3059266302u, 0u, 3059266302u, 0, SCALBNF_TOLERANCE, 0},
{480, 3337652712u, 0u, 3337652712u, 0, SCALBNF_TOLERANCE, 0},
{481, 1184753508u, 0u, 1184753508u, 0, SCALBNF_TOLERANCE, 0},
{482, 996404791u, 4294853343u, 0u, 0, SCALBNF_TOLERANCE, 0},
{483, 1188439315u, 55u, 1649812755u, 0, SCALBNF_TOLERANCE, 0},
{484, 906557513u, 0u, 906557513u, 0, SCALBNF_TOLERANCE, 0},
{485, 916831283u, 0u, 916831283u, 0, SCALBNF_TOLERANCE, 0},
{486, 996786317u, 0u, 996786317u, 0, SCALBNF_TOLERANCE, 0},
{487, 3461635065u, 0u, 3461635065u, 0, SCALBNF_TOLERANCE, 0},
{488, 3290079438u, 0u, 3290079438u, 0, SCALBNF_TOLERANCE, 0},
{489, 3350690327u, 0u, 3350690327u, 0, SCALBNF_TOLERANCE, 0},
{490, 1102061604u, 4253821380u, 0u, 0, SCALBNF_TOLERANCE, 0},
{491, 1282351521u, 0u, 1282351521u, 0, SCALBNF_TOLERANCE, 0},
{492, 3095256878u, 0u, 3095256878u, 0, SCALBNF_TOLERANCE, 0},
{493, 3163373610u, 0u, 3163373610u, 0, SCALBNF_TOLERANCE, 0},
{494, 3228793330u, 0u, 3228793330u, 0, SCALBNF_TOLERANCE, 0},
{495, 3422194733u, 0u, 3422194733u, 0, SCALBNF_TOLERANCE, 0},
{496, 3083885296u, 0u, 3083885296u, 0, SCALBNF_TOLERANCE, 0},
{497, 1261940623u, 4288291120u, 0u, 0, SCALBNF_TOLERANCE, 0},
{498, 3400603081u, 4294967290u, 3350271433u, 0, SCALBNF_TOLERANCE, 0},
{499, 1219411812u, 0u, 1219411812u, 0, SCALBNF_TOLERANCE, 0},
{500, 3094833770u, 0u, 3094833770u, 0, SCALBNF_TOLERANCE, 0},
{501, 3139250800u, 0u, 3139250800u, 0, SCALBNF_TOLERANCE, 0},
{502, 886201503u, 4294967150u, 0u, 0, SCALBNF_TOLERANCE, 0},
{503, 3297366026u, 7u, 3356086282u, 0, SCALBNF_TOLERANCE, 0},
{504, 1218488455u, 4294964141u, 0u, 0, SCALBNF_TOLERANCE, 0},
{505, 3040358923u, 0u, 3040358923u, 0, SCALBNF_TOLERANCE, 0},
{506, 3182551696u, 0u, 3182551696u, 0, SCALBNF_TOLERANCE, 0},
{507, 1317098613u, 0u, 1317098613u, 0, SCALBNF_TOLERANCE, 0},
{508, 3431703657u, 0u, 3431703657u, 0, SCALBNF_TOLERANCE, 0},
{509, 3239728775u, 0u, 3239728775u, 0, SCALBNF_TOLERANCE, 0},
{510, 3207141672u, 0u, 3207141672u, 0, SCALBNF_TOLERANCE, 0},
{511, 3154378805u, 0u, 3154378805u, 0, SCALBNF_TOLERANCE, 0},
{512, 3069658155u, 0u, 3069658155u, 0, SCALBNF_TOLERANCE, 0},
{513, 3313160088u, 0u, 3313160088u, 0, SCALBNF_TOLERANCE, 0},
{514, 1284174954u, 4180334232u, 0u, 0, SCALBNF_TOLERANCE, 0},
{515, 1063693032u, 0u, 1063693032u, 0, SCALBNF_TOLERANCE, 0},
{516, 1102631663u, 4290881696u, 0u, 0, SCALBNF_TOLERANCE, 0},
{517, 968803479u, 0u, 968803479u, 0, SCALBNF_TOLERANCE, 0},
{518, 3273080388u, 0u, 3273080388u, 0, SCALBNF_TOLERANCE, 0},
{519, 1172529774u, 4294966405u, 0u, 0, SCALBNF_TOLERANCE, 0},
{520, 3158855023u, 0u, 3158855023u, 0, SCALBNF_TOLERANCE, 0},
{521, 1165177679u, 4294967097u, 0u, 0, SCALBNF_TOLERANCE, 0},
{522, 952348506u, 4294108410u, 0u, 0, SCALBNF_TOLERANCE, 0},
{523, 1325324763u, 0u, 1325324763u, 0, SCALBNF_TOLERANCE, 0},
{524, 3363524213u, 0u, 3363524213u, 0, SCALBNF_TOLERANCE, 0},
{525, 1158950321u, 1u, 1167338929u, 0, SCALBNF_TOLERANCE, 0},
{526, 903129873u, 4272788450u, 0u, 0, SCALBNF_TOLERANCE, 0},
{527, 3078339944u, 0u, 3078339944u, 0, SCALBNF_TOLERANCE, 0},
{528, 1153863988u, 4229464460u, 0u, 0, SCALBNF_TOLERANCE, 0},
{529, 1235620969u, 0u, 1235620969u, 0, SCALBNF_TOLERANCE, 0},
{530, 1097120930u, 4294967294u, 1080343714u, 0, SCALBNF_TOLERANCE, 0},
{531, 1147712200u, 0u, 1147712200u, 0, SCALBNF_TOLERANCE, 0},
{532, 1124721745u, 0u, 1124721745u, 0, SCALBNF_TOLERANCE, 0},
{533, 3261744304u, 0u, 3261744304u, 0, SCALBNF_TOLERANCE, 0},
{534, 3303160152u, 0u, 3303160152u, 0, SCALBNF_TOLERANCE, 0},
{535, 1335399673u, 0u, 1335399673u, 0, SCALBNF_TOLERANCE, 0},
{536, 1072458508u, 4294404660u, 0u, 0, SCALBNF_TOLERANCE, 0},
{537, 3303015249u, 0u, 3303015249u, 0, SCALBNF_TOLERANCE, 0},
{538, 3252139741u, 0u, 3252139741u, 0, SCALBNF_TOLERANCE, 0},
{539, 3468519966u, 0u, 3468519966u, 0, SCALBNF_TOLERANCE, 0},
{540, 1006231203u, 0u, 1006231203u, 0, SCALBNF_TOLERANCE, 0},
{541, 951554138u, 0u, 951554138u, 0, SCALBNF_TOLERANCE, 0},
{542, 942046828u, 0u, 942046828u, 0, SCALBNF_TOLERANCE, 0},
{543, 3255104167u, 0u, 3255104167u, 0, SCALBNF_TOLERANCE, 0},
{544, 1155477903u, 0u, 1155477903u, 0, SCALBNF_TOLERANCE, 0},
{545, 3273889176u, 0u, 3273889176u, 0, SCALBNF_TOLERANCE, 0},
{546, 1228207362u, 0u, 1228207362u, 0, SCALBNF_TOLERANCE, 0},
{547, 1290175785u, 0u, 1290175785u, 0, SCALBNF_TOLERANCE, 0},
{548, 981908840u, 4294962938u, 0u, 0, SCALBNF_TOLERANCE, 0},
{549, 941187647u, 33u, 1218011711u, 0, SCALBNF_TOLERANCE, 0},
{550, 1214223128u, 4294967293u, 1189057304u, 0, SCALBNF_TOLERANCE, 0},
{551, 3422922584u, 6u, 3473254232u, 0, SCALBNF_TOLERANCE, 0},
{552, 3453226030u, 4294967291u, 3411282990u, 0, SCALBNF_TOLERANCE, 0},
{553, 1078359574u, 0u, 1078359574u, 0, SCALBNF_TOLERANCE, 0},
{554, 1029557624u, 4294965511u, 0u, 0, SCALBNF_TOLERANCE, 0},
{555, 1207675424u, 0u, 1207675424u, 0, SCALBNF_TOLERANCE, 0},
{556, 1028355074u, 4113313408u, 0u, 0, SCALBNF_TOLERANCE, 0},
{557, 1248421894u, 4294582111u, 0u, 0, SCALBNF_TOLERANCE, 0},
{558, 3353251994u, 12u, 3453915290u, 0, SCALBNF_TOLERANCE, 0},
{559, 876926659u, 4294966792u, 0u, 0, SCALBNF_TOLERANCE, 0},
{560, 1076752219u, 0u, 1076752219u, 0, SCALBNF_TOLERANCE, 0},
{561, 3388531942u, 0u, 3388531942u, 0, SCALBNF_TOLERANCE, 0},
{562, 1273395082u, 0u, 1273395082u, 0, SCALBNF_TOLERANCE, 0},
{563, 3034494183u, 0u, 3034494183u, 0, SCALBNF_TOLERANCE, 0},
{564, 1171318485u, 4294306215u, 0u, 0, SCALBNF_TOLERANCE, 0},
{565, 3047748143u, 0u, 3047748143u, 0, SCALBNF_TOLERANCE, 0},
{566, 1001216371u, 0u, 1001216371u, 0, SCALBNF_TOLERANCE, 0},
{567, 912515889u, 2u, 929293105u, 0, SCALBNF_TOLERANCE, 0},
{568, 3391452505u, 0u, 3391452505u, 0, SCALBNF_TOLERANCE, 0},
{569, 3249603369u, 0u, 3249603369u, 0, SCALBNF_TOLERANCE, 0},
{570, 1220264047u, 0u, 1220264047u, 0, SCALBNF_TOLERANCE, 0},
{571, 3169816394u, 0u, 3169816394u, 0, SCALBNF_TOLERANCE, 0},
{572, 3098997418u, 0u, 3098997418u, 0, SCALBNF_TOLERANCE, 0},
{573, 3282212423u, 0u, 3282212423u, 0, SCALBNF_TOLERANCE, 0},
{574, 3352293320u, 4294967278u, 3201298376u, 0, SCALBNF_TOLERANCE, 0},
{575, 3296358441u, 0u, 3296358441u, 0, SCALBNF_TOLERANCE, 0},
{576, 1197828352u, 4294967281u, 1071999232u, 0, SCALBNF_TOLERANCE, 0},
{577, 3340510371u, 0u, 3340510371u, 0, SCALBNF_TOLERANCE, 0},
{578, 1127109339u, 4294570975u, 0u, 0, SCALBNF_TOLERANCE, 0},
{579, 1200599955u, 0u, 1200599955u, 0, SCALBNF_TOLERANCE, 0},
{580, 962230977u, 0u, 962230977u, 0, SCALBNF_TOLERANCE, 0},
{581, 3192887808u, 0u, 3192887808u, 0, SCALBNF_TOLERANCE, 0},
{582, 3237183876u, 0u, 3237183876u, 0, SCALBNF_TOLERANCE, 0},
{583, 939285924u, 0u, 939285924u, 0, SCALBNF_TOLERANCE, 0},
{584, 944050180u, 3871652128u, 0u, 0, SCALBNF_TOLERANCE, 0},
{585, 3058135703u, 0u, 3058135703u, 0, SCALBNF_TOLERANCE, 0},
{586, 1003299981u, 0u, 1003299981u, 0, SCALBNF_TOLERANCE, 0},
{587, 1234491880u, 4283784819u, 0u, 0, SCALBNF_TOLERANCE, 0}

// AUTOMATICALLY GENERATED VECTORS STOP

};

#endif // CYGONCE_LIBM_SCABNF_H multiple inclusion protection

// EOF scalbnf.h
