#ifndef CYGONCE_LIBM_RINTF_H
#define CYGONCE_LIBM_RINTF_H
//===========================================================================
//
//      rintf.h
//
//      Test vectors for testing of rintf() math library function
//
//===========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####
// -------------------------------------------
// This file is part of eCos, the Embedded Configurable Operating System.
// Copyright (C) 2012 Free Software Foundation, Inc.
//
// eCos is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 or (at your option) any later
// version.
//
// eCos is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
// for more details.
//
// You should have received a copy of the GNU General Public License
// along with eCos; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//
// As a special exception, if other files instantiate templates or use
// macros or inline functions from this file, or you compile this file
// and link it with other works to produce a work based on this file,
// this file does not by itself cause the resulting work to be covered by
// the GNU General Public License. However the source code for this file
// must still be made available in accordance with section (3) of the GNU
// General Public License v2.
//
// This exception does not invalidate any other reasons why a work based
// on this file might be covered by the GNU General Public License.
// -------------------------------------------
// ####ECOSGPLCOPYRIGHTEND####
//===========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):
// Contributors:  visar, ilijak
// Date:        1998-02-13
// Purpose:
// Description:
// Usage:       #include "vectors/rintf.h"
//
//####DESCRIPTIONEND####
//
//===========================================================================


// CONFIGURATION

#include <pkgconf/libm.h>   // Configuration header


// INCLUDES

#include <cyg/infra/cyg_type.h>    // Common type definitions and support
#include "vectors/vector_support_float.h"// extra support for math tests

#define RINTF_TOLERANCE 1.0E-04

static const Cyg_libm_test_float_vec_t rintf_vec[] = {

// AUTOMATICALLY GENERATED VECTORS START

{0, 3214514586u, 0u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{1, 3214430700u, 0u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{2, 3214346813u, 0u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{3, 3214262927u, 0u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{4, 3214179041u, 0u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{5, 3214095155u, 0u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{6, 3214011269u, 0u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{7, 3213927383u, 0u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{8, 3213843497u, 0u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{9, 3213759611u, 0u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{10, 3213675725u, 0u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{11, 3213591839u, 0u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{12, 3213507953u, 0u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{13, 3213424067u, 0u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{14, 3213340180u, 0u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{15, 3213256294u, 0u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{16, 3213172408u, 0u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{17, 3213088522u, 0u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{18, 3213004636u, 0u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{19, 3212920750u, 0u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{20, 3212836864u, 0u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{21, 3212669092u, 0u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{22, 3212501320u, 0u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{23, 3212333548u, 0u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{24, 3212165775u, 0u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{25, 3211998003u, 0u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{26, 3211830231u, 0u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{27, 3211662459u, 0u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{28, 3211494687u, 0u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{29, 3211326915u, 0u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{30, 3211159142u, 0u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{31, 3210991370u, 0u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{32, 3210823598u, 0u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{33, 3210655826u, 0u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{34, 3210488054u, 0u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{35, 3210320282u, 0u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{36, 3210152509u, 0u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{37, 3209984737u, 0u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{38, 3209816965u, 0u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{39, 3209649193u, 0u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{40, 3209481421u, 0u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{41, 3209313649u, 0u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{42, 3209145876u, 0u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{43, 3208978104u, 0u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{44, 3208810332u, 0u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{45, 3208642560u, 0u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{46, 3208474788u, 0u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{47, 3208307016u, 0u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{48, 3208139244u, 0u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{49, 3207971471u, 0u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{50, 3207803699u, 0u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{51, 3207635927u, 0u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{52, 3207468155u, 0u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{53, 3207300383u, 0u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{54, 3207132611u, 0u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{55, 3206964838u, 0u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{56, 3206797066u, 0u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{57, 3206629294u, 0u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{58, 3206461522u, 0u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{59, 3206293750u, 0u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{60, 3206125978u, 0u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{61, 3205958205u, 0u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{62, 3205790433u, 0u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{63, 3205622661u, 0u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{64, 3205454889u, 0u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{65, 3205287117u, 0u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{66, 3205119345u, 0u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{67, 3204951572u, 0u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{68, 3204783800u, 0u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{69, 3204616028u, 0u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{70, 1008981770u, 0u, 0u, 0, RINTF_TOLERANCE, 0},
{71, 1017370378u, 0u, 0u, 0, RINTF_TOLERANCE, 0},
{72, 1022739087u, 0u, 0u, 0, RINTF_TOLERANCE, 0},
{73, 1025758986u, 0u, 0u, 0, RINTF_TOLERANCE, 0},
{74, 1028443341u, 0u, 0u, 0, RINTF_TOLERANCE, 0},
{75, 1031127695u, 0u, 0u, 0, RINTF_TOLERANCE, 0},
{76, 1032805417u, 0u, 0u, 0, RINTF_TOLERANCE, 0},
{77, 1034147594u, 0u, 0u, 0, RINTF_TOLERANCE, 0},
{78, 1035489772u, 0u, 0u, 0, RINTF_TOLERANCE, 0},
{79, 1036831949u, 0u, 0u, 0, RINTF_TOLERANCE, 0},
{80, 1038174126u, 0u, 0u, 0, RINTF_TOLERANCE, 0},
{81, 1039516303u, 0u, 0u, 0, RINTF_TOLERANCE, 0},
{82, 1040522936u, 0u, 0u, 0, RINTF_TOLERANCE, 0},
{83, 1041194025u, 0u, 0u, 0, RINTF_TOLERANCE, 0},
{84, 1041865114u, 0u, 0u, 0, RINTF_TOLERANCE, 0},
{85, 1042536202u, 0u, 0u, 0, RINTF_TOLERANCE, 0},
{86, 1043207291u, 0u, 0u, 0, RINTF_TOLERANCE, 0},
{87, 1043878380u, 0u, 0u, 0, RINTF_TOLERANCE, 0},
{88, 1044549468u, 0u, 0u, 0, RINTF_TOLERANCE, 0},
{89, 1045220557u, 0u, 0u, 0, RINTF_TOLERANCE, 0},
{90, 1045891645u, 0u, 0u, 0, RINTF_TOLERANCE, 0},
{91, 1046562734u, 0u, 0u, 0, RINTF_TOLERANCE, 0},
{92, 1047233823u, 0u, 0u, 0, RINTF_TOLERANCE, 0},
{93, 1047904911u, 0u, 0u, 0, RINTF_TOLERANCE, 0},
{94, 1048576000u, 0u, 0u, 0, RINTF_TOLERANCE, 0},
{95, 1048911544u, 0u, 0u, 0, RINTF_TOLERANCE, 0},
{96, 1049247089u, 0u, 0u, 0, RINTF_TOLERANCE, 0},
{97, 1049582633u, 0u, 0u, 0, RINTF_TOLERANCE, 0},
{98, 1049918177u, 0u, 0u, 0, RINTF_TOLERANCE, 0},
{99, 1050253722u, 0u, 0u, 0, RINTF_TOLERANCE, 0},
{100, 1050589266u, 0u, 0u, 0, RINTF_TOLERANCE, 0},
{101, 1050924810u, 0u, 0u, 0, RINTF_TOLERANCE, 0},
{102, 1051260355u, 0u, 0u, 0, RINTF_TOLERANCE, 0},
{103, 1051595899u, 0u, 0u, 0, RINTF_TOLERANCE, 0},
{104, 1051931443u, 0u, 0u, 0, RINTF_TOLERANCE, 0},
{105, 1052266988u, 0u, 0u, 0, RINTF_TOLERANCE, 0},
{106, 1052602532u, 0u, 0u, 0, RINTF_TOLERANCE, 0},
{107, 1052938076u, 0u, 0u, 0, RINTF_TOLERANCE, 0},
{108, 1053273620u, 0u, 0u, 0, RINTF_TOLERANCE, 0},
{109, 1053609165u, 0u, 0u, 0, RINTF_TOLERANCE, 0},
{110, 1053944709u, 0u, 0u, 0, RINTF_TOLERANCE, 0},
{111, 1054280253u, 0u, 0u, 0, RINTF_TOLERANCE, 0},
{112, 1054615798u, 0u, 0u, 0, RINTF_TOLERANCE, 0},
{113, 1054951342u, 0u, 0u, 0, RINTF_TOLERANCE, 0},
{114, 1055286886u, 0u, 0u, 0, RINTF_TOLERANCE, 0},
{115, 1055622431u, 0u, 0u, 0, RINTF_TOLERANCE, 0},
{116, 1055957975u, 0u, 0u, 0, RINTF_TOLERANCE, 0},
{117, 1056293519u, 0u, 0u, 0, RINTF_TOLERANCE, 0},
{118, 1056629064u, 0u, 0u, 0, RINTF_TOLERANCE, 0},
{119, 1056964608u, 0u, 0u, 0, RINTF_TOLERANCE, 0},
{120, 1057132380u, 0u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{121, 1057300152u, 0u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{122, 1057467924u, 0u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{123, 1057635697u, 0u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{124, 1057803469u, 0u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{125, 1057971241u, 0u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{126, 1058139013u, 0u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{127, 1058306785u, 0u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{128, 1058474557u, 0u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{129, 1058642330u, 0u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{130, 1058810102u, 0u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{131, 1058977874u, 0u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{132, 1059145646u, 0u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{133, 1059313418u, 0u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{134, 1059481190u, 0u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{135, 1059648963u, 0u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{136, 1059816735u, 0u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{137, 1059984507u, 0u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{138, 1060152279u, 0u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{139, 1060320051u, 0u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{140, 1060487823u, 0u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{141, 1060655596u, 0u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{142, 1060823368u, 0u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{143, 1060991140u, 0u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{144, 1061158912u, 0u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{145, 1061326684u, 0u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{146, 1061494456u, 0u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{147, 1061662228u, 0u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{148, 1061830001u, 0u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{149, 1061997773u, 0u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{150, 1062165545u, 0u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{151, 1062333317u, 0u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{152, 1062501089u, 0u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{153, 1062668861u, 0u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{154, 1062836634u, 0u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{155, 1063004406u, 0u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{156, 1063172178u, 0u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{157, 1063339950u, 0u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{158, 1063507722u, 0u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{159, 1063675494u, 0u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{160, 1063843267u, 0u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{161, 1064011039u, 0u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{162, 1064178811u, 0u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{163, 1064346583u, 0u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{164, 1064514355u, 0u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{165, 1064682127u, 0u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{166, 1064849900u, 0u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{167, 1065017672u, 0u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{168, 1065185444u, 0u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{169, 1065353216u, 0u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{170, 1065437102u, 0u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{171, 1065520988u, 0u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{172, 1065604874u, 0u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{173, 1065688760u, 0u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{174, 1065772646u, 0u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{175, 1065856532u, 0u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{176, 1065940419u, 0u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{177, 1066024305u, 0u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{178, 1066108191u, 0u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{179, 1066192077u, 0u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{180, 1066275963u, 0u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{181, 1066359849u, 0u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{182, 1066443735u, 0u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{183, 1066527621u, 0u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{184, 1066611507u, 0u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{185, 1066695393u, 0u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{186, 1066779279u, 0u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{187, 1066863165u, 0u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{188, 1066947052u, 0u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{189, 3234402267u, 0u, 3233808384u, 0, RINTF_TOLERANCE, 0},
{190, 3231108068u, 0u, 3231711232u, 0, RINTF_TOLERANCE, 0},
{191, 3226013659u, 0u, 3225419776u, 0, RINTF_TOLERANCE, 0},
{192, 3217625051u, 0u, 3221225472u, 0, RINTF_TOLERANCE, 0},
{193, 0u, 0u, 0u, 0, RINTF_TOLERANCE, 0},
{194, 1070141403u, 0u, 1073741824u, 0, RINTF_TOLERANCE, 0},
{195, 1078530011u, 0u, 1077936128u, 0, RINTF_TOLERANCE, 0},
{196, 1083624420u, 0u, 1084227584u, 0, RINTF_TOLERANCE, 0},
{197, 3253731328u, 0u, 3253731328u, 0, RINTF_TOLERANCE, 0},
{198, 3252840038u, 0u, 3252682752u, 0, RINTF_TOLERANCE, 0},
{199, 3251948749u, 0u, 3252158464u, 0, RINTF_TOLERANCE, 0},
{200, 3251057459u, 0u, 3251109888u, 0, RINTF_TOLERANCE, 0},
{201, 3250166170u, 0u, 3250061312u, 0, RINTF_TOLERANCE, 0},
{202, 3249274880u, 0u, 3249537024u, 0, RINTF_TOLERANCE, 0},
{203, 3248383590u, 0u, 3248488448u, 0, RINTF_TOLERANCE, 0},
{204, 3247492301u, 0u, 3247439872u, 0, RINTF_TOLERANCE, 0},
{205, 3246601011u, 0u, 3246391296u, 0, RINTF_TOLERANCE, 0},
{206, 3245028147u, 0u, 3245342720u, 0, RINTF_TOLERANCE, 0},
{207, 3243245568u, 0u, 3243245568u, 0, RINTF_TOLERANCE, 0},
{208, 3241462989u, 0u, 3241148416u, 0, RINTF_TOLERANCE, 0},
{209, 3239680410u, 0u, 3240099840u, 0, RINTF_TOLERANCE, 0},
{210, 3237792973u, 0u, 3238002688u, 0, RINTF_TOLERANCE, 0},
{211, 3234227814u, 0u, 3233808384u, 0, RINTF_TOLERANCE, 0},
{212, 3230662656u, 0u, 3229614080u, 0, RINTF_TOLERANCE, 0},
{213, 3224580915u, 0u, 3225419776u, 0, RINTF_TOLERANCE, 0},
{214, 3213675725u, 0u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{215, 1058642330u, 0u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{216, 1075000115u, 0u, 1073741824u, 0, RINTF_TOLERANCE, 0},
{217, 1082130432u, 0u, 1082130432u, 0, RINTF_TOLERANCE, 0},
{218, 1085695590u, 0u, 1086324736u, 0, RINTF_TOLERANCE, 0},
{219, 1089260749u, 0u, 1088421888u, 0, RINTF_TOLERANCE, 0},
{220, 1091672474u, 0u, 1091567616u, 0, RINTF_TOLERANCE, 0},
{221, 1093455053u, 0u, 1093664768u, 0, RINTF_TOLERANCE, 0},
{222, 1095237632u, 0u, 1094713344u, 0, RINTF_TOLERANCE, 0},
{223, 1097020211u, 0u, 1096810496u, 0, RINTF_TOLERANCE, 0},
{224, 1098802790u, 0u, 1098907648u, 0, RINTF_TOLERANCE, 0},
{225, 1099746509u, 0u, 1099956224u, 0, RINTF_TOLERANCE, 0},
{226, 1100637798u, 0u, 1100480512u, 0, RINTF_TOLERANCE, 0},
{227, 1101529088u, 0u, 1101529088u, 0, RINTF_TOLERANCE, 0},
{228, 1102420378u, 0u, 1102577664u, 0, RINTF_TOLERANCE, 0},
{229, 1103311667u, 0u, 1103101952u, 0, RINTF_TOLERANCE, 0},
{230, 1104202957u, 0u, 1104150528u, 0, RINTF_TOLERANCE, 0},
{231, 1105094246u, 0u, 1105199104u, 0, RINTF_TOLERANCE, 0},
{232, 1105985536u, 0u, 1106247680u, 0, RINTF_TOLERANCE, 0},
{233, 1107800421u, 1203999711u, 1107820544u, 0, RINTF_TOLERANCE, 0},
{234, 3368700125u, 3308232444u, 3368700128u, 0, RINTF_TOLERANCE, 0},
{235, 1224242132u, 3061363425u, 1224242144u, 0, RINTF_TOLERANCE, 0},
{236, 3221027117u, 1284201705u, 3221225472u, 0, RINTF_TOLERANCE, 0},
{237, 1198712763u, 919636942u, 1198712832u, 0, RINTF_TOLERANCE, 0},
{238, 954173073u, 850531830u, 0u, 0, RINTF_TOLERANCE, 0},
{239, 966554515u, 3234538174u, 0u, 0, RINTF_TOLERANCE, 0},
{240, 1312607135u, 1194999402u, 1312607135u, 0, RINTF_TOLERANCE, 0},
{241, 1166191415u, 1018661564u, 1166190592u, 0, RINTF_TOLERANCE, 0},
{242, 1234419246u, 2984575812u, 1234419248u, 0, RINTF_TOLERANCE, 0},
{243, 1302107128u, 3370647675u, 1302107128u, 0, RINTF_TOLERANCE, 0},
{244, 1052801068u, 3039122570u, 0u, 0, RINTF_TOLERANCE, 0},
{245, 1060849628u, 3081357692u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{246, 3484320003u, 3033957825u, 3484320003u, 0, RINTF_TOLERANCE, 0},
{247, 882596369u, 1256676590u, 0u, 0, RINTF_TOLERANCE, 0},
{248, 1167223673u, 846102364u, 1167222784u, 0, RINTF_TOLERANCE, 0},
{249, 968192794u, 878547432u, 0u, 0, RINTF_TOLERANCE, 0},
{250, 1052361612u, 1280025214u, 0u, 0, RINTF_TOLERANCE, 0},
{251, 906701409u, 2968301825u, 0u, 0, RINTF_TOLERANCE, 0},
{252, 3471653172u, 1154138102u, 3471653172u, 0, RINTF_TOLERANCE, 0},
{253, 3231467496u, 934336592u, 3231711232u, 0, RINTF_TOLERANCE, 0},
{254, 1341514497u, 3466051188u, 1341514497u, 0, RINTF_TOLERANCE, 0},
{255, 1272351391u, 3373485062u, 1272351391u, 0, RINTF_TOLERANCE, 0},
{256, 3319724992u, 3354615790u, 3319724032u, 0, RINTF_TOLERANCE, 0},
{257, 917622040u, 1334966485u, 0u, 0, RINTF_TOLERANCE, 0},
{258, 940236348u, 3304072663u, 0u, 0, RINTF_TOLERANCE, 0},
{259, 3251541546u, 3174764041u, 3251634176u, 0, RINTF_TOLERANCE, 0},
{260, 3371863479u, 1014861921u, 3371863488u, 0, RINTF_TOLERANCE, 0},
{261, 1306460502u, 903489435u, 1306460502u, 0, RINTF_TOLERANCE, 0},
{262, 1197542187u, 3024598921u, 1197542144u, 0, RINTF_TOLERANCE, 0},
{263, 922888249u, 1139392309u, 0u, 0, RINTF_TOLERANCE, 0},
{264, 1184239996u, 3224098462u, 1184240128u, 0, RINTF_TOLERANCE, 0},
{265, 1252490238u, 1173619825u, 1252490238u, 0, RINTF_TOLERANCE, 0},
{266, 1001673627u, 3462631271u, 0u, 0, RINTF_TOLERANCE, 0},
{267, 976098044u, 1151967422u, 0u, 0, RINTF_TOLERANCE, 0},
{268, 941796645u, 886451963u, 0u, 0, RINTF_TOLERANCE, 0},
{269, 3287199470u, 854245542u, 3287187456u, 0, RINTF_TOLERANCE, 0},
{270, 893184329u, 1243067084u, 0u, 0, RINTF_TOLERANCE, 0},
{271, 1143233714u, 1007268238u, 1143226368u, 0, RINTF_TOLERANCE, 0},
{272, 1139941253u, 1147688821u, 1139933184u, 0, RINTF_TOLERANCE, 0},
{273, 3240298487u, 1020260821u, 3240099840u, 0, RINTF_TOLERANCE, 0},
{274, 1288902137u, 3123875978u, 1288902137u, 0, RINTF_TOLERANCE, 0},
{275, 1333134799u, 1338107877u, 1333134799u, 0, RINTF_TOLERANCE, 0},
{276, 1187847971u, 1317663644u, 1187848192u, 0, RINTF_TOLERANCE, 0},
{277, 1038851706u, 1327544110u, 0u, 0, RINTF_TOLERANCE, 0},
{278, 3329354473u, 3165437289u, 3329354752u, 0, RINTF_TOLERANCE, 0},
{279, 1309289088u, 1019883016u, 1309289088u, 0, RINTF_TOLERANCE, 0},
{280, 3444653659u, 1279248024u, 3444653659u, 0, RINTF_TOLERANCE, 0},
{281, 3405585402u, 2962345057u, 3405585402u, 0, RINTF_TOLERANCE, 0},
{282, 1106778573u, 3304487767u, 1106771968u, 0, RINTF_TOLERANCE, 0},
{283, 1140567947u, 3069174149u, 1140555776u, 0, RINTF_TOLERANCE, 0},
{284, 1238569473u, 873035665u, 1238569472u, 0, RINTF_TOLERANCE, 0},
{285, 1261071232u, 1182202773u, 1261071232u, 0, RINTF_TOLERANCE, 0},
{286, 1175011025u, 3029705783u, 1175011328u, 0, RINTF_TOLERANCE, 0},
{287, 1082692850u, 1211581107u, 1082130432u, 0, RINTF_TOLERANCE, 0},
{288, 974547519u, 3475164509u, 0u, 0, RINTF_TOLERANCE, 0},
{289, 3403348556u, 3184653669u, 3403348556u, 0, RINTF_TOLERANCE, 0},
{290, 1136411063u, 1118097422u, 1136427008u, 0, RINTF_TOLERANCE, 0},
{291, 3239231622u, 3302723069u, 3239051264u, 0, RINTF_TOLERANCE, 0},
{292, 3340615780u, 870350055u, 3340615680u, 0, RINTF_TOLERANCE, 0},
{293, 998567360u, 2995278691u, 0u, 0, RINTF_TOLERANCE, 0},
{294, 3417964312u, 1321337529u, 3417964312u, 0, RINTF_TOLERANCE, 0},
{295, 1148867223u, 1256486202u, 1148862464u, 0, RINTF_TOLERANCE, 0},
{296, 989687421u, 3372681320u, 0u, 0, RINTF_TOLERANCE, 0},
{297, 1152956913u, 3166480640u, 1152958464u, 0, RINTF_TOLERANCE, 0},
{298, 892922651u, 3373029087u, 0u, 0, RINTF_TOLERANCE, 0},
{299, 1109627625u, 1314158257u, 1109655552u, 0, RINTF_TOLERANCE, 0},
{300, 1307091856u, 1103202538u, 1307091856u, 0, RINTF_TOLERANCE, 0},
{301, 1077234132u, 3272167130u, 1077936128u, 0, RINTF_TOLERANCE, 0},
{302, 1142167709u, 1096445242u, 1142161408u, 0, RINTF_TOLERANCE, 0},
{303, 3426232834u, 1036705270u, 3426232834u, 0, RINTF_TOLERANCE, 0},
{304, 3368566779u, 967249167u, 3368566784u, 0, RINTF_TOLERANCE, 0},
{305, 1138741813u, 3073453199u, 1138753536u, 0, RINTF_TOLERANCE, 0},
{306, 982950501u, 982549888u, 0u, 0, RINTF_TOLERANCE, 0},
{307, 1142981585u, 1015602236u, 1142980608u, 0, RINTF_TOLERANCE, 0},
{308, 3347165962u, 3135486696u, 3347165952u, 0, RINTF_TOLERANCE, 0},
{309, 1009535440u, 3381353228u, 0u, 0, RINTF_TOLERANCE, 0},
{310, 3473956030u, 976891930u, 3473956030u, 0, RINTF_TOLERANCE, 0},
{311, 3349098349u, 1055327704u, 3349098368u, 0, RINTF_TOLERANCE, 0},
{312, 945568720u, 3313485084u, 0u, 0, RINTF_TOLERANCE, 0},
{313, 3345489836u, 1108392401u, 3345489920u, 0, RINTF_TOLERANCE, 0},
{314, 940893161u, 1137000140u, 0u, 0, RINTF_TOLERANCE, 0},
{315, 976791751u, 3230678102u, 0u, 0, RINTF_TOLERANCE, 0},
{316, 1004442355u, 3036510596u, 0u, 0, RINTF_TOLERANCE, 0},
{317, 1108485380u, 3173536878u, 1108606976u, 0, RINTF_TOLERANCE, 0},
{318, 1061834641u, 972388096u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{319, 3381268392u, 1146976802u, 3381268392u, 0, RINTF_TOLERANCE, 0},
{320, 1087189715u, 2952822478u, 1086324736u, 0, RINTF_TOLERANCE, 0},
{321, 3212952285u, 3329407365u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{322, 1000611335u, 857599439u, 0u, 0, RINTF_TOLERANCE, 0},
{323, 3466188568u, 1041678304u, 3466188568u, 0, RINTF_TOLERANCE, 0},
{324, 3319315516u, 3422089012u, 3319316480u, 0, RINTF_TOLERANCE, 0},
{325, 935938416u, 1146676692u, 0u, 0, RINTF_TOLERANCE, 0},
{326, 3212614372u, 1152633030u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{327, 1315030230u, 3336225884u, 1315030230u, 0, RINTF_TOLERANCE, 0},
{328, 1134593658u, 3456812581u, 1134592000u, 0, RINTF_TOLERANCE, 0},
{329, 977281449u, 879922831u, 0u, 0, RINTF_TOLERANCE, 0},
{330, 1086198791u, 920125958u, 1086324736u, 0, RINTF_TOLERANCE, 0},
{331, 1255152035u, 851754050u, 1255152036u, 0, RINTF_TOLERANCE, 0},
{332, 1135271264u, 3284878412u, 1135280128u, 0, RINTF_TOLERANCE, 0},
{333, 1094190727u, 1056854532u, 1094713344u, 0, RINTF_TOLERANCE, 0},
{334, 1294665325u, 991185677u, 1294665325u, 0, RINTF_TOLERANCE, 0},
{335, 1036608591u, 805416536u, 0u, 0, RINTF_TOLERANCE, 0},
{336, 3229998064u, 825237063u, 3229614080u, 0, RINTF_TOLERANCE, 0},
{337, 3439134022u, 1043829691u, 3439134022u, 0, RINTF_TOLERANCE, 0},
{338, 1325668223u, 970681762u, 1325668223u, 0, RINTF_TOLERANCE, 0},
{339, 1092037607u, 1027330835u, 1091567616u, 0, RINTF_TOLERANCE, 0},
{340, 3316278408u, 3455589207u, 3316279296u, 0, RINTF_TOLERANCE, 0},
{341, 3295436768u, 3129873731u, 3295428608u, 0, RINTF_TOLERANCE, 0},
{342, 1151984049u, 3074547120u, 1151983616u, 0, RINTF_TOLERANCE, 0},
{343, 1129287043u, 3076527544u, 1129316352u, 0, RINTF_TOLERANCE, 0},
{344, 1243664530u, 972879810u, 1243664528u, 0, RINTF_TOLERANCE, 0},
{345, 950829092u, 929114193u, 0u, 0, RINTF_TOLERANCE, 0},
{346, 1115471979u, 3047246262u, 1115422720u, 0, RINTF_TOLERANCE, 0},
{347, 3351092088u, 3024661404u, 3351092096u, 0, RINTF_TOLERANCE, 0},
{348, 3424479544u, 3312047722u, 3424479544u, 0, RINTF_TOLERANCE, 0},
{349, 3241193975u, 884465785u, 3241148416u, 0, RINTF_TOLERANCE, 0},
{350, 1030934236u, 1045139240u, 0u, 0, RINTF_TOLERANCE, 0},
{351, 1025254314u, 3057812821u, 0u, 0, RINTF_TOLERANCE, 0},
{352, 1110545760u, 3240144177u, 1110441984u, 0, RINTF_TOLERANCE, 0},
{353, 3361976590u, 3138179993u, 3361976576u, 0, RINTF_TOLERANCE, 0},
{354, 881280146u, 3421884736u, 0u, 0, RINTF_TOLERANCE, 0},
{355, 1304154705u, 2961937089u, 1304154705u, 0, RINTF_TOLERANCE, 0},
{356, 3264443610u, 3222916705u, 3264479232u, 0, RINTF_TOLERANCE, 0},
{357, 3374550627u, 3055856293u, 3374550624u, 0, RINTF_TOLERANCE, 0},
{358, 899599265u, 3240118211u, 0u, 0, RINTF_TOLERANCE, 0},
{359, 1268194719u, 1332489410u, 1268194719u, 0, RINTF_TOLERANCE, 0},
{360, 1133420220u, 1245770860u, 1133412352u, 0, RINTF_TOLERANCE, 0},
{361, 1161858787u, 815362075u, 1161859072u, 0, RINTF_TOLERANCE, 0},
{362, 3295996963u, 3453334307u, 3296002048u, 0, RINTF_TOLERANCE, 0},
{363, 1270887389u, 1156123987u, 1270887389u, 0, RINTF_TOLERANCE, 0},
{364, 3325193181u, 993979179u, 3325193216u, 0, RINTF_TOLERANCE, 0},
{365, 925657343u, 1315159742u, 0u, 0, RINTF_TOLERANCE, 0},
{366, 1189120494u, 978961471u, 1189120512u, 0, RINTF_TOLERANCE, 0},
{367, 889030794u, 3129523970u, 0u, 0, RINTF_TOLERANCE, 0},
{368, 1323529208u, 3100744786u, 1323529208u, 0, RINTF_TOLERANCE, 0},
{369, 3465768388u, 3190881451u, 3465768388u, 0, RINTF_TOLERANCE, 0},
{370, 3426099899u, 1118756120u, 3426099899u, 0, RINTF_TOLERANCE, 0},
{371, 3224857113u, 3398166843u, 3225419776u, 0, RINTF_TOLERANCE, 0},
{372, 1065798296u, 816191940u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{373, 3328989444u, 850266225u, 3328989184u, 0, RINTF_TOLERANCE, 0},
{374, 3357819026u, 3148475462u, 3357819008u, 0, RINTF_TOLERANCE, 0},
{375, 1273397670u, 901308750u, 1273397670u, 0, RINTF_TOLERANCE, 0},
{376, 3424831780u, 1304806106u, 3424831780u, 0, RINTF_TOLERANCE, 0},
{377, 1257596246u, 3420832544u, 1257596246u, 0, RINTF_TOLERANCE, 0},
{378, 1051773536u, 896271348u, 0u, 0, RINTF_TOLERANCE, 0},
{379, 3294752507u, 3113225954u, 3294756864u, 0, RINTF_TOLERANCE, 0},
{380, 3424848725u, 2973850350u, 3424848725u, 0, RINTF_TOLERANCE, 0},
{381, 1090870906u, 3294742905u, 1090519040u, 0, RINTF_TOLERANCE, 0},
{382, 1227582289u, 1208979668u, 1227582288u, 0, RINTF_TOLERANCE, 0},
{383, 1272325814u, 3004311296u, 1272325814u, 0, RINTF_TOLERANCE, 0},
{384, 3359508271u, 859974315u, 3359508288u, 0, RINTF_TOLERANCE, 0},
{385, 1137854355u, 3335041917u, 1137868800u, 0, RINTF_TOLERANCE, 0},
{386, 3440773058u, 3204192793u, 3440773058u, 0, RINTF_TOLERANCE, 0},
{387, 3451216836u, 3347783723u, 3451216836u, 0, RINTF_TOLERANCE, 0},
{388, 3437062994u, 3106834845u, 3437062994u, 0, RINTF_TOLERANCE, 0},
{389, 1131196082u, 1164573183u, 1131216896u, 0, RINTF_TOLERANCE, 0},
{390, 3258097678u, 1305882290u, 3258187776u, 0, RINTF_TOLERANCE, 0},
{391, 3460915348u, 1219372260u, 3460915348u, 0, RINTF_TOLERANCE, 0},
{392, 3303035472u, 3153013020u, 3303038976u, 0, RINTF_TOLERANCE, 0},
{393, 1053698677u, 3284313107u, 0u, 0, RINTF_TOLERANCE, 0},
{394, 3396166221u, 1201894512u, 3396166220u, 0, RINTF_TOLERANCE, 0},
{395, 3458934263u, 1005577835u, 3458934263u, 0, RINTF_TOLERANCE, 0},
{396, 1065761827u, 3333928591u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{397, 926665223u, 3150815797u, 0u, 0, RINTF_TOLERANCE, 0},
{398, 1199816046u, 3143776186u, 1199816064u, 0, RINTF_TOLERANCE, 0},
{399, 3333779015u, 952421041u, 3333778944u, 0, RINTF_TOLERANCE, 0},
{400, 948398145u, 3238273189u, 0u, 0, RINTF_TOLERANCE, 0},
{401, 1080781593u, 1213908300u, 1082130432u, 0, RINTF_TOLERANCE, 0},
{402, 3235326590u, 1271705594u, 3235905536u, 0, RINTF_TOLERANCE, 0},
{403, 965378004u, 1292594138u, 0u, 0, RINTF_TOLERANCE, 0},
{404, 3226990408u, 1110755136u, 3225419776u, 0, RINTF_TOLERANCE, 0},
{405, 1283624229u, 906796922u, 1283624229u, 0, RINTF_TOLERANCE, 0},
{406, 970649315u, 1078286437u, 0u, 0, RINTF_TOLERANCE, 0},
{407, 959776291u, 3280345347u, 0u, 0, RINTF_TOLERANCE, 0},
{408, 3341117305u, 3294559023u, 3341117184u, 0, RINTF_TOLERANCE, 0},
{409, 1270734970u, 3355874874u, 1270734970u, 0, RINTF_TOLERANCE, 0},
{410, 3454816067u, 868771977u, 3454816067u, 0, RINTF_TOLERANCE, 0},
{411, 917206623u, 1172710814u, 0u, 0, RINTF_TOLERANCE, 0},
{412, 1106502045u, 1290849316u, 1106247680u, 0, RINTF_TOLERANCE, 0},
{413, 1157598381u, 3309023746u, 1157595136u, 0, RINTF_TOLERANCE, 0},
{414, 3335234513u, 1002337336u, 3335234560u, 0, RINTF_TOLERANCE, 0},
{415, 1279489061u, 1006049444u, 1279489061u, 0, RINTF_TOLERANCE, 0},
{416, 1233171235u, 826460580u, 1233171232u, 0, RINTF_TOLERANCE, 0},
{417, 1148920078u, 1007674793u, 1148928000u, 0, RINTF_TOLERANCE, 0},
{418, 1109198803u, 1221754614u, 1109131264u, 0, RINTF_TOLERANCE, 0},
{419, 3219949483u, 1056167693u, 3221225472u, 0, RINTF_TOLERANCE, 0},
{420, 3361149474u, 3387342069u, 3361149504u, 0, RINTF_TOLERANCE, 0},
{421, 1207502108u, 3388073586u, 1207502080u, 0, RINTF_TOLERANCE, 0},
{422, 1000014431u, 831213088u, 0u, 0, RINTF_TOLERANCE, 0},
{423, 1234530539u, 1079988872u, 1234530536u, 0, RINTF_TOLERANCE, 0},
{424, 1017843965u, 1193076204u, 0u, 0, RINTF_TOLERANCE, 0},
{425, 951862956u, 1173464654u, 0u, 0, RINTF_TOLERANCE, 0},
{426, 3306328852u, 1118701064u, 3306328064u, 0, RINTF_TOLERANCE, 0},
{427, 1291910469u, 1211303367u, 1291910469u, 0, RINTF_TOLERANCE, 0},
{428, 1131927531u, 3182962700u, 1131937792u, 0, RINTF_TOLERANCE, 0},
{429, 3449879391u, 991614550u, 3449879391u, 0, RINTF_TOLERANCE, 0},
{430, 970094304u, 3344590506u, 0u, 0, RINTF_TOLERANCE, 0},
{431, 1125551064u, 3331248076u, 1125580800u, 0, RINTF_TOLERANCE, 0},
{432, 3427296372u, 3455289118u, 3427296372u, 0, RINTF_TOLERANCE, 0},
{433, 1198917460u, 1327195159u, 1198917376u, 0, RINTF_TOLERANCE, 0},
{434, 921940707u, 2967544056u, 0u, 0, RINTF_TOLERANCE, 0},
{435, 1091906532u, 3011904455u, 1091567616u, 0, RINTF_TOLERANCE, 0},
{436, 3393557778u, 3383396815u, 3393557776u, 0, RINTF_TOLERANCE, 0},
{437, 1276853215u, 873199561u, 1276853215u, 0, RINTF_TOLERANCE, 0},
{438, 3462778440u, 3349284325u, 3462778440u, 0, RINTF_TOLERANCE, 0},
{439, 3360170117u, 3048354042u, 3360170112u, 0, RINTF_TOLERANCE, 0},
{440, 3224245428u, 3271307999u, 3225419776u, 0, RINTF_TOLERANCE, 0},
{441, 1120124467u, 1135619937u, 1120141312u, 0, RINTF_TOLERANCE, 0},
{442, 1064364381u, 3180675544u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{443, 1268744779u, 3328452652u, 1268744779u, 0, RINTF_TOLERANCE, 0},
{444, 1165195428u, 3390323168u, 1165197312u, 0, RINTF_TOLERANCE, 0},
{445, 3247790039u, 909788142u, 3247964160u, 0, RINTF_TOLERANCE, 0},
{446, 3215244648u, 1083988595u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{447, 1212717473u, 837873779u, 1212717504u, 0, RINTF_TOLERANCE, 0},
{448, 3275973009u, 3450721670u, 3275948032u, 0, RINTF_TOLERANCE, 0},
{449, 3391162308u, 1291220039u, 3391162308u, 0, RINTF_TOLERANCE, 0},
{450, 1044867873u, 3369493273u, 0u, 0, RINTF_TOLERANCE, 0},
{451, 1089986803u, 3462160118u, 1090519040u, 0, RINTF_TOLERANCE, 0},
{452, 1296314700u, 2957454177u, 1296314700u, 0, RINTF_TOLERANCE, 0},
{453, 1251462432u, 3171021770u, 1251462432u, 0, RINTF_TOLERANCE, 0},
{454, 3485236902u, 980772835u, 3485236902u, 0, RINTF_TOLERANCE, 0},
{455, 3262169538u, 1268270462u, 3262119936u, 0, RINTF_TOLERANCE, 0},
{456, 1022211242u, 922124181u, 0u, 0, RINTF_TOLERANCE, 0},
{457, 884661176u, 2985540645u, 0u, 0, RINTF_TOLERANCE, 0},
{458, 989762529u, 3362011135u, 0u, 0, RINTF_TOLERANCE, 0},
{459, 1295475718u, 3212305413u, 1295475718u, 0, RINTF_TOLERANCE, 0},
{460, 1002632518u, 3330388441u, 0u, 0, RINTF_TOLERANCE, 0},
{461, 3404372005u, 3450484255u, 3404372004u, 0, RINTF_TOLERANCE, 0},
{462, 1125800069u, 3256265749u, 1125777408u, 0, RINTF_TOLERANCE, 0},
{463, 999985470u, 3409354318u, 0u, 0, RINTF_TOLERANCE, 0},
{464, 1189421739u, 1056599002u, 1189421568u, 0, RINTF_TOLERANCE, 0},
{465, 1164046161u, 3440635788u, 1164046336u, 0, RINTF_TOLERANCE, 0},
{466, 1292596266u, 3116569667u, 1292596266u, 0, RINTF_TOLERANCE, 0},
{467, 3469748379u, 3412765608u, 3469748379u, 0, RINTF_TOLERANCE, 0},
{468, 1314644642u, 3123051784u, 1314644642u, 0, RINTF_TOLERANCE, 0},
{469, 3399813173u, 828743798u, 3399813172u, 0, RINTF_TOLERANCE, 0},
{470, 948775569u, 3485444126u, 0u, 0, RINTF_TOLERANCE, 0},
{471, 1034611395u, 882288581u, 0u, 0, RINTF_TOLERANCE, 0},
{472, 3489122735u, 3372450889u, 3489122735u, 0, RINTF_TOLERANCE, 0},
{473, 1181604787u, 3363067409u, 1181604864u, 0, RINTF_TOLERANCE, 0},
{474, 1043691622u, 3402603223u, 0u, 0, RINTF_TOLERANCE, 0},
{475, 1314588083u, 856187848u, 1314588083u, 0, RINTF_TOLERANCE, 0},
{476, 3400949680u, 3073750220u, 3400949680u, 0, RINTF_TOLERANCE, 0},
{477, 3365581801u, 1175843167u, 3365581792u, 0, RINTF_TOLERANCE, 0},
{478, 1110424755u, 3011308654u, 1110441984u, 0, RINTF_TOLERANCE, 0},
{479, 969804941u, 3355439348u, 0u, 0, RINTF_TOLERANCE, 0},
{480, 1139120919u, 3270515074u, 1139113984u, 0, RINTF_TOLERANCE, 0},
{481, 934308144u, 3118191228u, 0u, 0, RINTF_TOLERANCE, 0},
{482, 1220524226u, 1152648002u, 1220524224u, 0, RINTF_TOLERANCE, 0},
{483, 3382391700u, 3296962745u, 3382391696u, 0, RINTF_TOLERANCE, 0},
{484, 1156767533u, 1088986462u, 1156767744u, 0, RINTF_TOLERANCE, 0},
{485, 994934087u, 967678094u, 0u, 0, RINTF_TOLERANCE, 0},
{486, 3479873563u, 1246277393u, 3479873563u, 0, RINTF_TOLERANCE, 0},
{487, 3424264117u, 3434026174u, 3424264117u, 0, RINTF_TOLERANCE, 0},
{488, 3228365887u, 1216775310u, 3229614080u, 0, RINTF_TOLERANCE, 0},
{489, 1035909900u, 1249532942u, 0u, 0, RINTF_TOLERANCE, 0},
{490, 1212129651u, 3017366784u, 1212129664u, 0, RINTF_TOLERANCE, 0},
{491, 1037464105u, 3121544932u, 0u, 0, RINTF_TOLERANCE, 0},
{492, 1311706596u, 1254918706u, 1311706596u, 0, RINTF_TOLERANCE, 0},
{493, 918212457u, 1017468331u, 0u, 0, RINTF_TOLERANCE, 0},
{494, 1337315179u, 3461361185u, 1337315179u, 0, RINTF_TOLERANCE, 0},
{495, 1131358407u, 3325958870u, 1131347968u, 0, RINTF_TOLERANCE, 0},
{496, 1156517523u, 3343716230u, 1156513792u, 0, RINTF_TOLERANCE, 0},
{497, 3210802820u, 3207408574u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{498, 3337499209u, 1226297264u, 3337499136u, 0, RINTF_TOLERANCE, 0},
{499, 3468429030u, 3253874001u, 3468429030u, 0, RINTF_TOLERANCE, 0},
{500, 3253515800u, 1189005947u, 3253731328u, 0, RINTF_TOLERANCE, 0},
{501, 959956547u, 876324728u, 0u, 0, RINTF_TOLERANCE, 0},
{502, 3425290480u, 1139193797u, 3425290480u, 0, RINTF_TOLERANCE, 0},
{503, 1039917375u, 1122740999u, 0u, 0, RINTF_TOLERANCE, 0},
{504, 3220979495u, 3429223871u, 3221225472u, 0, RINTF_TOLERANCE, 0},
{505, 1311016004u, 3334899880u, 1311016004u, 0, RINTF_TOLERANCE, 0},
{506, 1128016396u, 1105151547u, 1128005632u, 0, RINTF_TOLERANCE, 0},
{507, 3210335769u, 3100646155u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{508, 1206054701u, 826010009u, 1206054656u, 0, RINTF_TOLERANCE, 0},
{509, 1213609983u, 919983950u, 1213609984u, 0, RINTF_TOLERANCE, 0},
{510, 1246902946u, 3064047808u, 1246902944u, 0, RINTF_TOLERANCE, 0},
{511, 995850843u, 1332031130u, 0u, 0, RINTF_TOLERANCE, 0},
{512, 3362082828u, 3374056268u, 3362082816u, 0, RINTF_TOLERANCE, 0},
{513, 1029480631u, 3047777170u, 0u, 0, RINTF_TOLERANCE, 0},
{514, 3384988527u, 3109485565u, 3384988528u, 0, RINTF_TOLERANCE, 0},
{515, 1317696241u, 870681806u, 1317696241u, 0, RINTF_TOLERANCE, 0},
{516, 3235395924u, 1132055244u, 3235905536u, 0, RINTF_TOLERANCE, 0},
{517, 3341877624u, 2969495570u, 3341877504u, 0, RINTF_TOLERANCE, 0},
{518, 1228636133u, 886552820u, 1228636128u, 0, RINTF_TOLERANCE, 0},
{519, 1207246237u, 859223639u, 1207246208u, 0, RINTF_TOLERANCE, 0},
{520, 1165476654u, 3350219111u, 1165475840u, 0, RINTF_TOLERANCE, 0},
{521, 1215278023u, 3019755242u, 1215278016u, 0, RINTF_TOLERANCE, 0},
{522, 1017239798u, 3438501281u, 0u, 0, RINTF_TOLERANCE, 0},
{523, 1149651309u, 970030475u, 1149648896u, 0, RINTF_TOLERANCE, 0},
{524, 1111943722u, 3122211334u, 1112014848u, 0, RINTF_TOLERANCE, 0},
{525, 1189849849u, 3382739134u, 1189849600u, 0, RINTF_TOLERANCE, 0},
{526, 3204848496u, 3141519085u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{527, 1249758327u, 3104759211u, 1249758328u, 0, RINTF_TOLERANCE, 0},
{528, 1168098747u, 1316854744u, 1168099328u, 0, RINTF_TOLERANCE, 0},
{529, 892549317u, 1179637545u, 0u, 0, RINTF_TOLERANCE, 0},
{530, 3301009024u, 3406174560u, 3301007360u, 0, RINTF_TOLERANCE, 0},
{531, 3233089227u, 1212652543u, 3233808384u, 0, RINTF_TOLERANCE, 0},
{532, 3218245284u, 1238873830u, 3221225472u, 0, RINTF_TOLERANCE, 0},
{533, 3215981890u, 3240474694u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{534, 1266687209u, 3092038122u, 1266687209u, 0, RINTF_TOLERANCE, 0},
{535, 3487959775u, 3331372071u, 3487959775u, 0, RINTF_TOLERANCE, 0},
{536, 943645710u, 852875779u, 0u, 0, RINTF_TOLERANCE, 0},
{537, 3345065699u, 3282620725u, 3345065728u, 0, RINTF_TOLERANCE, 0},
{538, 935847271u, 1067255804u, 0u, 0, RINTF_TOLERANCE, 0},
{539, 3410336089u, 1111437780u, 3410336089u, 0, RINTF_TOLERANCE, 0},
{540, 1141063391u, 1168908072u, 1141063680u, 0, RINTF_TOLERANCE, 0},
{541, 3353679791u, 897158391u, 3353679744u, 0, RINTF_TOLERANCE, 0},
{542, 1001823878u, 1016826861u, 0u, 0, RINTF_TOLERANCE, 0},
{543, 1009130212u, 1004302940u, 0u, 0, RINTF_TOLERANCE, 0},
{544, 3367127535u, 943136342u, 3367127520u, 0, RINTF_TOLERANCE, 0},
{545, 1032920919u, 3449126417u, 0u, 0, RINTF_TOLERANCE, 0},
{546, 3281952870u, 3147012185u, 3281944576u, 0, RINTF_TOLERANCE, 0},
{547, 1237868497u, 3048281802u, 1237868496u, 0, RINTF_TOLERANCE, 0},
{548, 1153753924u, 3322269242u, 1153753088u, 0, RINTF_TOLERANCE, 0},
{549, 1120261759u, 892210998u, 1120272384u, 0, RINTF_TOLERANCE, 0},
{550, 3226328360u, 3366432856u, 3225419776u, 0, RINTF_TOLERANCE, 0},
{551, 3349595986u, 3251588707u, 3349596032u, 0, RINTF_TOLERANCE, 0},
{552, 1087750238u, 1099325523u, 1088421888u, 0, RINTF_TOLERANCE, 0},
{553, 1066116543u, 3072159933u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{554, 3210898034u, 2981803389u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{555, 1030612298u, 3345396001u, 0u, 0, RINTF_TOLERANCE, 0},
{556, 1186234578u, 858134374u, 1186234368u, 0, RINTF_TOLERANCE, 0},
{557, 1331680743u, 1009396165u, 1331680743u, 0, RINTF_TOLERANCE, 0},
{558, 887589411u, 1292305693u, 0u, 0, RINTF_TOLERANCE, 0},
{559, 1045232522u, 3234993273u, 0u, 0, RINTF_TOLERANCE, 0},
{560, 3349432725u, 928848003u, 3349432704u, 0, RINTF_TOLERANCE, 0},
{561, 912423027u, 3184646319u, 0u, 0, RINTF_TOLERANCE, 0},
{562, 3228795133u, 3273940030u, 3229614080u, 0, RINTF_TOLERANCE, 0},
{563, 3296784303u, 3276182352u, 3296780288u, 0, RINTF_TOLERANCE, 0},
{564, 965402291u, 3107104376u, 0u, 0, RINTF_TOLERANCE, 0},
{565, 3388153589u, 3426245389u, 3388153592u, 0, RINTF_TOLERANCE, 0},
{566, 1133410485u, 3329658993u, 1133412352u, 0, RINTF_TOLERANCE, 0},
{567, 3369970587u, 959121458u, 3369970592u, 0, RINTF_TOLERANCE, 0},
{568, 1270451568u, 928393353u, 1270451568u, 0, RINTF_TOLERANCE, 0},
{569, 989498922u, 3088358419u, 0u, 0, RINTF_TOLERANCE, 0},
{570, 1280215674u, 3148135875u, 1280215674u, 0, RINTF_TOLERANCE, 0},
{571, 1171873518u, 954709738u, 1171873792u, 0, RINTF_TOLERANCE, 0},
{572, 3298258100u, 935525182u, 3298254848u, 0, RINTF_TOLERANCE, 0},
{573, 3415208824u, 822843236u, 3415208824u, 0, RINTF_TOLERANCE, 0},
{574, 1001897182u, 3191875320u, 0u, 0, RINTF_TOLERANCE, 0},
{575, 985903305u, 3333087577u, 0u, 0, RINTF_TOLERANCE, 0},
{576, 3357328848u, 859306298u, 3357328832u, 0, RINTF_TOLERANCE, 0},
{577, 982612185u, 923582663u, 0u, 0, RINTF_TOLERANCE, 0},
{578, 3267868136u, 1208301947u, 3267887104u, 0, RINTF_TOLERANCE, 0},
{579, 3319048157u, 1172271145u, 3319048192u, 0, RINTF_TOLERANCE, 0},
{580, 1144755661u, 860947435u, 1144750080u, 0, RINTF_TOLERANCE, 0},
{581, 898467286u, 839254959u, 0u, 0, RINTF_TOLERANCE, 0},
{582, 3301461672u, 1233693827u, 3301457920u, 0, RINTF_TOLERANCE, 0},
{583, 3364525678u, 3089849671u, 3364525664u, 0, RINTF_TOLERANCE, 0},
{584, 931441127u, 1133424555u, 0u, 0, RINTF_TOLERANCE, 0},
{585, 3467121799u, 3023584354u, 3467121799u, 0, RINTF_TOLERANCE, 0},
{586, 1151257041u, 3084216427u, 1151254528u, 0, RINTF_TOLERANCE, 0},
{587, 1017573824u, 3130901062u, 0u, 0, RINTF_TOLERANCE, 0},
{588, 1258369714u, 3462258576u, 1258369714u, 0, RINTF_TOLERANCE, 0},
{589, 1216602683u, 3371396332u, 1216602688u, 0, RINTF_TOLERANCE, 0},
{590, 3297265739u, 1214184410u, 3297263616u, 0, RINTF_TOLERANCE, 0},
{591, 1071940738u, 3311731012u, 1073741824u, 0, RINTF_TOLERANCE, 0},
{592, 922601356u, 3337171870u, 0u, 0, RINTF_TOLERANCE, 0},
{593, 3462285635u, 3444030332u, 3462285635u, 0, RINTF_TOLERANCE, 0},
{594, 3357177805u, 1085464241u, 3357177792u, 0, RINTF_TOLERANCE, 0},
{595, 1153863660u, 1011991342u, 1153859584u, 0, RINTF_TOLERANCE, 0},
{596, 1249365132u, 3278686216u, 1249365132u, 0, RINTF_TOLERANCE, 0},
{597, 3222096285u, 1198013705u, 3221225472u, 0, RINTF_TOLERANCE, 0},
{598, 1297708818u, 3079166173u, 1297708818u, 0, RINTF_TOLERANCE, 0},
{599, 3345532722u, 3383708463u, 3345532672u, 0, RINTF_TOLERANCE, 0},
{600, 3418753236u, 3481843070u, 3418753236u, 0, RINTF_TOLERANCE, 0},
{601, 1277417964u, 3487506626u, 1277417964u, 0, RINTF_TOLERANCE, 0},
{602, 987577257u, 1152077087u, 0u, 0, RINTF_TOLERANCE, 0},
{603, 888030585u, 3062367380u, 0u, 0, RINTF_TOLERANCE, 0},
{604, 1043442869u, 3311393817u, 0u, 0, RINTF_TOLERANCE, 0},
{605, 3320923228u, 3464544249u, 3320924160u, 0, RINTF_TOLERANCE, 0},
{606, 1337400405u, 3488844154u, 1337400405u, 0, RINTF_TOLERANCE, 0},
{607, 3400348640u, 3129868490u, 3400348640u, 0, RINTF_TOLERANCE, 0},
{608, 1250249095u, 1069023744u, 1250249096u, 0, RINTF_TOLERANCE, 0},
{609, 3284411233u, 1173613526u, 3284402176u, 0, RINTF_TOLERANCE, 0},
{610, 1215968622u, 3469884568u, 1215968640u, 0, RINTF_TOLERANCE, 0},
{611, 1025404104u, 1066370251u, 0u, 0, RINTF_TOLERANCE, 0},
{612, 3362748242u, 3369843597u, 3362748224u, 0, RINTF_TOLERANCE, 0},
{613, 1252237719u, 1121169249u, 1252237720u, 0, RINTF_TOLERANCE, 0},
{614, 3327895594u, 1224511805u, 3327895552u, 0, RINTF_TOLERANCE, 0},
{615, 3396161504u, 1182798837u, 3396161504u, 0, RINTF_TOLERANCE, 0},
{616, 1099710167u, 887180181u, 1099956224u, 0, RINTF_TOLERANCE, 0},
{617, 1157186482u, 1288722647u, 1157185536u, 0, RINTF_TOLERANCE, 0},
{618, 1282110851u, 3176633124u, 1282110851u, 0, RINTF_TOLERANCE, 0},
{619, 3477008113u, 1331845018u, 3477008113u, 0, RINTF_TOLERANCE, 0},
{620, 3292127294u, 3409957764u, 3292135424u, 0, RINTF_TOLERANCE, 0},
{621, 1123357102u, 3281307320u, 1123418112u, 0, RINTF_TOLERANCE, 0},
{622, 1106837025u, 3088080674u, 1106771968u, 0, RINTF_TOLERANCE, 0},
{623, 1049949008u, 1130799489u, 0u, 0, RINTF_TOLERANCE, 0},
{624, 1253017688u, 942062372u, 1253017688u, 0, RINTF_TOLERANCE, 0},
{625, 1108543194u, 3281299199u, 1108606976u, 0, RINTF_TOLERANCE, 0},
{626, 1160162706u, 1264067367u, 1160163328u, 0, RINTF_TOLERANCE, 0},
{627, 3305715025u, 3017496063u, 3305713664u, 0, RINTF_TOLERANCE, 0},
{628, 1266928623u, 811778614u, 1266928623u, 0, RINTF_TOLERANCE, 0},
{629, 3438080027u, 3107114149u, 3438080027u, 0, RINTF_TOLERANCE, 0},
{630, 3344574751u, 3111270744u, 3344574720u, 0, RINTF_TOLERANCE, 0},
{631, 1152416724u, 962669179u, 1152417792u, 0, RINTF_TOLERANCE, 0},
{632, 1218239308u, 1126238113u, 1218239296u, 0, RINTF_TOLERANCE, 0},
{633, 3263310567u, 1030748197u, 3263299584u, 0, RINTF_TOLERANCE, 0},
{634, 1000313118u, 2980130729u, 0u, 0, RINTF_TOLERANCE, 0},
{635, 972485427u, 1124312043u, 0u, 0, RINTF_TOLERANCE, 0},
{636, 3290264612u, 1124703898u, 3290267648u, 0, RINTF_TOLERANCE, 0},
{637, 3222106584u, 1183748648u, 3221225472u, 0, RINTF_TOLERANCE, 0},
{638, 1278946388u, 825129857u, 1278946388u, 0, RINTF_TOLERANCE, 0},
{639, 947914771u, 3181847068u, 0u, 0, RINTF_TOLERANCE, 0},
{640, 1098530298u, 3255870890u, 1098907648u, 0, RINTF_TOLERANCE, 0},
{641, 3232726036u, 871038882u, 3231711232u, 0, RINTF_TOLERANCE, 0},
{642, 1297190916u, 811863044u, 1297190916u, 0, RINTF_TOLERANCE, 0},
{643, 1277649137u, 961171401u, 1277649137u, 0, RINTF_TOLERANCE, 0},
{644, 3244032016u, 3045313345u, 3244294144u, 0, RINTF_TOLERANCE, 0},
{645, 1096155623u, 1256423752u, 1095761920u, 0, RINTF_TOLERANCE, 0},
{646, 873151908u, 3246562559u, 0u, 0, RINTF_TOLERANCE, 0},
{647, 3238729605u, 1298769842u, 3239051264u, 0, RINTF_TOLERANCE, 0},
{648, 3317196817u, 989537151u, 3317196800u, 0, RINTF_TOLERANCE, 0},
{649, 3374748510u, 834161190u, 3374748512u, 0, RINTF_TOLERANCE, 0},
{650, 3345634950u, 959901149u, 3345635072u, 0, RINTF_TOLERANCE, 0},
{651, 887311687u, 1175312255u, 0u, 0, RINTF_TOLERANCE, 0},
{652, 3396917283u, 3066326686u, 3396917284u, 0, RINTF_TOLERANCE, 0},
{653, 3317032737u, 3143803722u, 3317032960u, 0, RINTF_TOLERANCE, 0},
{654, 1200051436u, 1163802508u, 1200051456u, 0, RINTF_TOLERANCE, 0},
{655, 1306520561u, 957302464u, 1306520561u, 0, RINTF_TOLERANCE, 0},
{656, 1314936356u, 2985592532u, 1314936356u, 0, RINTF_TOLERANCE, 0},
{657, 3475052219u, 1284049853u, 3475052219u, 0, RINTF_TOLERANCE, 0},
{658, 3393227708u, 3271879112u, 3393227708u, 0, RINTF_TOLERANCE, 0},
{659, 3349005404u, 3080993030u, 3349005440u, 0, RINTF_TOLERANCE, 0},
{660, 1262863321u, 1219003129u, 1262863321u, 0, RINTF_TOLERANCE, 0},
{661, 882902102u, 1224362550u, 0u, 0, RINTF_TOLERANCE, 0},
{662, 1053387478u, 3184880021u, 0u, 0, RINTF_TOLERANCE, 0},
{663, 3387653691u, 3347783852u, 3387653688u, 0, RINTF_TOLERANCE, 0},
{664, 1338680611u, 1166078045u, 1338680611u, 0, RINTF_TOLERANCE, 0},
{665, 1112891928u, 3074730425u, 1112801280u, 0, RINTF_TOLERANCE, 0},
{666, 893449284u, 1052877339u, 0u, 0, RINTF_TOLERANCE, 0},
{667, 892311459u, 1097338393u, 0u, 0, RINTF_TOLERANCE, 0},
{668, 1190105283u, 3033907262u, 1190105088u, 0, RINTF_TOLERANCE, 0},
{669, 1011225926u, 1180485180u, 0u, 0, RINTF_TOLERANCE, 0},
{670, 1043025031u, 987068973u, 0u, 0, RINTF_TOLERANCE, 0},
{671, 3410531037u, 2953541915u, 3410531037u, 0, RINTF_TOLERANCE, 0},
{672, 902318189u, 849277289u, 0u, 0, RINTF_TOLERANCE, 0},
{673, 3213624815u, 2987148017u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{674, 1120888322u, 1086209113u, 1120927744u, 0, RINTF_TOLERANCE, 0},
{675, 1315217243u, 3396371713u, 1315217243u, 0, RINTF_TOLERANCE, 0},
{676, 1040617590u, 1034835971u, 0u, 0, RINTF_TOLERANCE, 0},
{677, 955384253u, 3344785562u, 0u, 0, RINTF_TOLERANCE, 0},
{678, 904255535u, 1019967545u, 0u, 0, RINTF_TOLERANCE, 0},
{679, 1022984119u, 3113891410u, 0u, 0, RINTF_TOLERANCE, 0},
{680, 997362368u, 3112875428u, 0u, 0, RINTF_TOLERANCE, 0},
{681, 900933520u, 1100589187u, 0u, 0, RINTF_TOLERANCE, 0},
{682, 1168623062u, 1143306482u, 1168623616u, 0, RINTF_TOLERANCE, 0},
{683, 878737490u, 3269908326u, 0u, 0, RINTF_TOLERANCE, 0},
{684, 1039827284u, 1072928888u, 0u, 0, RINTF_TOLERANCE, 0},
{685, 1021564080u, 1064468397u, 0u, 0, RINTF_TOLERANCE, 0},
{686, 3458669745u, 3033299853u, 3458669745u, 0, RINTF_TOLERANCE, 0},
{687, 3327516316u, 3405380971u, 3327516672u, 0, RINTF_TOLERANCE, 0},
{688, 1040711112u, 3229444200u, 0u, 0, RINTF_TOLERANCE, 0},
{689, 1134528351u, 3365952513u, 1134526464u, 0, RINTF_TOLERANCE, 0},
{690, 3414352838u, 3350285760u, 3414352838u, 0, RINTF_TOLERANCE, 0},
{691, 1133689539u, 1067460093u, 1133674496u, 0, RINTF_TOLERANCE, 0},
{692, 3455688478u, 3333091960u, 3455688478u, 0, RINTF_TOLERANCE, 0},
{693, 1137634874u, 1137038869u, 1137639424u, 0, RINTF_TOLERANCE, 0},
{694, 3415502662u, 955510692u, 3415502662u, 0, RINTF_TOLERANCE, 0},
{695, 954999730u, 969618597u, 0u, 0, RINTF_TOLERANCE, 0},
{696, 1066157309u, 3241712664u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{697, 3436353675u, 1174967495u, 3436353675u, 0, RINTF_TOLERANCE, 0},
{698, 940437609u, 860372396u, 0u, 0, RINTF_TOLERANCE, 0},
{699, 1023889593u, 2979304683u, 0u, 0, RINTF_TOLERANCE, 0},
{700, 3272661536u, 3461799138u, 3272671232u, 0, RINTF_TOLERANCE, 0},
{701, 1170245333u, 1233406410u, 1170245632u, 0, RINTF_TOLERANCE, 0},
{702, 1219052056u, 3369557946u, 1219052064u, 0, RINTF_TOLERANCE, 0},
{703, 3318983619u, 3259663338u, 3318982656u, 0, RINTF_TOLERANCE, 0},
{704, 3372118621u, 837597103u, 3372118624u, 0, RINTF_TOLERANCE, 0},
{705, 1299683827u, 966031619u, 1299683827u, 0, RINTF_TOLERANCE, 0},
{706, 3257224022u, 3361778245u, 3257139200u, 0, RINTF_TOLERANCE, 0},
{707, 1229268598u, 1066965677u, 1229268592u, 0, RINTF_TOLERANCE, 0},
{708, 1086717248u, 3423795374u, 1086324736u, 0, RINTF_TOLERANCE, 0},
{709, 3434884607u, 3029593823u, 3434884607u, 0, RINTF_TOLERANCE, 0},
{710, 3464955606u, 1017987696u, 3464955606u, 0, RINTF_TOLERANCE, 0},
{711, 1025278524u, 3121856207u, 0u, 0, RINTF_TOLERANCE, 0},
{712, 1242829722u, 3233935671u, 1242829720u, 0, RINTF_TOLERANCE, 0},
{713, 1200927971u, 1317167489u, 1200928000u, 0, RINTF_TOLERANCE, 0},
{714, 3326858092u, 3452602832u, 3326858240u, 0, RINTF_TOLERANCE, 0},
{715, 1246019790u, 850632217u, 1246019792u, 0, RINTF_TOLERANCE, 0},
{716, 1136052740u, 3244616020u, 1136066560u, 0, RINTF_TOLERANCE, 0},
{717, 1069009211u, 3002507482u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{718, 1015670780u, 1101217251u, 0u, 0, RINTF_TOLERANCE, 0},
{719, 1012543234u, 1116520440u, 0u, 0, RINTF_TOLERANCE, 0},
{720, 3316611992u, 3394732912u, 3316611072u, 0, RINTF_TOLERANCE, 0},
{721, 1087942795u, 3316660295u, 1088421888u, 0, RINTF_TOLERANCE, 0},
{722, 3426365713u, 3069778532u, 3426365713u, 0, RINTF_TOLERANCE, 0},
{723, 3295326432u, 1313396175u, 3295330304u, 0, RINTF_TOLERANCE, 0},
{724, 3318835308u, 3277583511u, 3318835200u, 0, RINTF_TOLERANCE, 0},
{725, 3283555717u, 891875120u, 3283550208u, 0, RINTF_TOLERANCE, 0},
{726, 3381255420u, 3015406047u, 3381255424u, 0, RINTF_TOLERANCE, 0},
{727, 3388772093u, 1032597076u, 3388772096u, 0, RINTF_TOLERANCE, 0},
{728, 954670189u, 1144923689u, 0u, 0, RINTF_TOLERANCE, 0},
{729, 1319200415u, 3387555900u, 1319200415u, 0, RINTF_TOLERANCE, 0},
{730, 1279324488u, 3228401212u, 1279324488u, 0, RINTF_TOLERANCE, 0},
{731, 3217795424u, 865577227u, 3221225472u, 0, RINTF_TOLERANCE, 0},
{732, 3455131757u, 1260217257u, 3455131757u, 0, RINTF_TOLERANCE, 0},
{733, 1246947517u, 1087951909u, 1246947516u, 0, RINTF_TOLERANCE, 0},
{734, 3396723577u, 869285240u, 3396723576u, 0, RINTF_TOLERANCE, 0},
{735, 3433761025u, 3060143904u, 3433761025u, 0, RINTF_TOLERANCE, 0},
{736, 1173247961u, 1191127979u, 1173248000u, 0, RINTF_TOLERANCE, 0},
{737, 3248534678u, 1323683800u, 3248488448u, 0, RINTF_TOLERANCE, 0},
{738, 1082862511u, 3032804719u, 1082130432u, 0, RINTF_TOLERANCE, 0},
{739, 1341821683u, 3003675365u, 1341821683u, 0, RINTF_TOLERANCE, 0},
{740, 881101379u, 1190838126u, 0u, 0, RINTF_TOLERANCE, 0},
{741, 1079061705u, 2960507663u, 1077936128u, 0, RINTF_TOLERANCE, 0},
{742, 1105291533u, 3482971524u, 1105199104u, 0, RINTF_TOLERANCE, 0},
{743, 1016023520u, 3227712090u, 0u, 0, RINTF_TOLERANCE, 0},
{744, 3370691006u, 1295870514u, 3370691008u, 0, RINTF_TOLERANCE, 0},
{745, 1156767169u, 1049756240u, 1156767744u, 0, RINTF_TOLERANCE, 0},
{746, 1104284039u, 3040211914u, 1104150528u, 0, RINTF_TOLERANCE, 0},
{747, 3335212901u, 3486414589u, 3335213056u, 0, RINTF_TOLERANCE, 0},
{748, 1093697541u, 3193708441u, 1093664768u, 0, RINTF_TOLERANCE, 0},
{749, 3266691185u, 1160074593u, 3266707456u, 0, RINTF_TOLERANCE, 0},
{750, 1094115255u, 3008610212u, 1093664768u, 0, RINTF_TOLERANCE, 0},
{751, 3424086808u, 3260140004u, 3424086808u, 0, RINTF_TOLERANCE, 0},
{752, 3353608773u, 1134068114u, 3353608832u, 0, RINTF_TOLERANCE, 0},
{753, 973664327u, 1319516167u, 0u, 0, RINTF_TOLERANCE, 0},
{754, 882878091u, 3136970767u, 0u, 0, RINTF_TOLERANCE, 0},
{755, 1098662266u, 833740182u, 1098907648u, 0, RINTF_TOLERANCE, 0},
{756, 927582555u, 947955456u, 0u, 0, RINTF_TOLERANCE, 0},
{757, 3476083859u, 966439623u, 3476083859u, 0, RINTF_TOLERANCE, 0},
{758, 979878744u, 1232482646u, 0u, 0, RINTF_TOLERANCE, 0},
{759, 3464546616u, 3205527253u, 3464546616u, 0, RINTF_TOLERANCE, 0},
{760, 1002542205u, 3152136093u, 0u, 0, RINTF_TOLERANCE, 0},
{761, 3443552129u, 3165561391u, 3443552129u, 0, RINTF_TOLERANCE, 0},
{762, 1287620154u, 3119707283u, 1287620154u, 0, RINTF_TOLERANCE, 0},
{763, 946058434u, 1249928879u, 0u, 0, RINTF_TOLERANCE, 0},
{764, 1245702957u, 894348966u, 1245702956u, 0, RINTF_TOLERANCE, 0},
{765, 989655126u, 1308376568u, 0u, 0, RINTF_TOLERANCE, 0},
{766, 1002715618u, 1191006977u, 0u, 0, RINTF_TOLERANCE, 0},
{767, 1000863905u, 1196831314u, 0u, 0, RINTF_TOLERANCE, 0},
{768, 3415763001u, 3032518431u, 3415763001u, 0, RINTF_TOLERANCE, 0},
{769, 3283471961u, 1260093226u, 3283484672u, 0, RINTF_TOLERANCE, 0},
{770, 3311210827u, 1192192264u, 3311210496u, 0, RINTF_TOLERANCE, 0},
{771, 1198307901u, 1116328249u, 1198307840u, 0, RINTF_TOLERANCE, 0},
{772, 1288901567u, 1296370667u, 1288901567u, 0, RINTF_TOLERANCE, 0},
{773, 922255363u, 958305289u, 0u, 0, RINTF_TOLERANCE, 0},
{774, 1113104661u, 944376032u, 1113063424u, 0, RINTF_TOLERANCE, 0},
{775, 1136714348u, 828849087u, 1136721920u, 0, RINTF_TOLERANCE, 0},
{776, 948856035u, 1015466475u, 0u, 0, RINTF_TOLERANCE, 0},
{777, 1062512367u, 3229559531u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{778, 3486907092u, 823220784u, 3486907092u, 0, RINTF_TOLERANCE, 0},
{779, 1162027071u, 3308983387u, 1162027008u, 0, RINTF_TOLERANCE, 0},
{780, 1034561811u, 1054043114u, 0u, 0, RINTF_TOLERANCE, 0},
{781, 3271615417u, 3209997200u, 3271622656u, 0, RINTF_TOLERANCE, 0},
{782, 1042014529u, 1146708584u, 0u, 0, RINTF_TOLERANCE, 0},
{783, 1177157787u, 3090208179u, 1177157632u, 0, RINTF_TOLERANCE, 0},
{784, 3432084552u, 2997091781u, 3432084552u, 0, RINTF_TOLERANCE, 0},
{785, 1309658335u, 1010219988u, 1309658335u, 0, RINTF_TOLERANCE, 0},
{786, 1226494979u, 2991604792u, 1226494976u, 0, RINTF_TOLERANCE, 0},
{787, 3375507013u, 1306310823u, 3375507008u, 0, RINTF_TOLERANCE, 0},
{788, 3460699001u, 3096700943u, 3460699001u, 0, RINTF_TOLERANCE, 0},
{789, 3468023178u, 1209565017u, 3468023178u, 0, RINTF_TOLERANCE, 0},
{790, 1204196034u, 3298625731u, 1204196096u, 0, RINTF_TOLERANCE, 0},
{791, 3459877411u, 2960476959u, 3459877411u, 0, RINTF_TOLERANCE, 0},
{792, 909696559u, 1163075690u, 0u, 0, RINTF_TOLERANCE, 0},
{793, 1161439847u, 943449277u, 1161441280u, 0, RINTF_TOLERANCE, 0},
{794, 908663107u, 939489763u, 0u, 0, RINTF_TOLERANCE, 0},
{795, 1055319316u, 3261813492u, 0u, 0, RINTF_TOLERANCE, 0},
{796, 1084378658u, 1009650785u, 1084227584u, 0, RINTF_TOLERANCE, 0},
{797, 1226473697u, 821025132u, 1226473696u, 0, RINTF_TOLERANCE, 0},
{798, 1123114742u, 1229815537u, 1123155968u, 0, RINTF_TOLERANCE, 0},
{799, 1258114435u, 1291336083u, 1258114436u, 0, RINTF_TOLERANCE, 0},
{800, 3468040845u, 3066966245u, 3468040845u, 0, RINTF_TOLERANCE, 0},
{801, 1178825761u, 1113195286u, 1178825728u, 0, RINTF_TOLERANCE, 0},
{802, 3223384012u, 1130486973u, 3225419776u, 0, RINTF_TOLERANCE, 0},
{803, 1019964626u, 1235133609u, 0u, 0, RINTF_TOLERANCE, 0},
{804, 3445262427u, 3465211174u, 3445262427u, 0, RINTF_TOLERANCE, 0},
{805, 1125653081u, 1207799746u, 1125646336u, 0, RINTF_TOLERANCE, 0},
{806, 3337652712u, 3025581813u, 3337652736u, 0, RINTF_TOLERANCE, 0},
{807, 1184753508u, 3147374485u, 1184753664u, 0, RINTF_TOLERANCE, 0},
{808, 996404791u, 3353251979u, 0u, 0, RINTF_TOLERANCE, 0},
{809, 1188439315u, 1113484271u, 1188439552u, 0, RINTF_TOLERANCE, 0},
{810, 906557513u, 3006513432u, 0u, 0, RINTF_TOLERANCE, 0},
{811, 916831283u, 999465787u, 0u, 0, RINTF_TOLERANCE, 0},
{812, 996786317u, 3179221951u, 0u, 0, RINTF_TOLERANCE, 0},
{813, 3461635065u, 1004690387u, 3461635065u, 0, RINTF_TOLERANCE, 0},
{814, 1188167943u, 1200744896u, 1188168192u, 0, RINTF_TOLERANCE, 0},
{815, 891257783u, 1267560050u, 0u, 0, RINTF_TOLERANCE, 0},
{816, 3290079438u, 846519377u, 3290087424u, 0, RINTF_TOLERANCE, 0},
{817, 3350690327u, 2967953392u, 3350690304u, 0, RINTF_TOLERANCE, 0},
{818, 1102061604u, 3424449935u, 1102053376u, 0, RINTF_TOLERANCE, 0},
{819, 1282351521u, 3039376424u, 1282351521u, 0, RINTF_TOLERANCE, 0},
{820, 3458861065u, 3392466405u, 3458861065u, 0, RINTF_TOLERANCE, 0},
{821, 3228793330u, 855146890u, 3229614080u, 0, RINTF_TOLERANCE, 0},
{822, 3422194733u, 893873945u, 3422194733u, 0, RINTF_TOLERANCE, 0},
{823, 1261940623u, 3402349985u, 1261940623u, 0, RINTF_TOLERANCE, 0},
{824, 3400603081u, 3234396843u, 3400603080u, 0, RINTF_TOLERANCE, 0},
{825, 1219411812u, 2961857939u, 1219411808u, 0, RINTF_TOLERANCE, 0},
{826, 886201503u, 3272760705u, 0u, 0, RINTF_TOLERANCE, 0},
{827, 3297366026u, 1089966380u, 3297370112u, 0, RINTF_TOLERANCE, 0},
{828, 1218488455u, 3309646450u, 1218488448u, 0, RINTF_TOLERANCE, 0},
{829, 1283938137u, 1196383822u, 1283938137u, 0, RINTF_TOLERANCE, 0},
{830, 1317098613u, 949986176u, 1317098613u, 0, RINTF_TOLERANCE, 0},
{831, 3431703657u, 3014443710u, 3431703657u, 0, RINTF_TOLERANCE, 0},
{832, 3239728775u, 927815421u, 3240099840u, 0, RINTF_TOLERANCE, 0},
{833, 3207141672u, 933456504u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{834, 3313160088u, 2964063309u, 3313160192u, 0, RINTF_TOLERANCE, 0},
{835, 3207056527u, 3384206601u, 3212836864u, 0, RINTF_TOLERANCE, 0},
{836, 1284174954u, 3436881197u, 1284174954u, 0, RINTF_TOLERANCE, 0},
{837, 1063693032u, 976661408u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{838, 1102631663u, 3396951425u, 1102577664u, 0, RINTF_TOLERANCE, 0},
{839, 968803479u, 992989712u, 0u, 0, RINTF_TOLERANCE, 0},
{840, 3273080388u, 3109405906u, 3273064448u, 0, RINTF_TOLERANCE, 0},
{841, 1172529774u, 3294550127u, 1172529152u, 0, RINTF_TOLERANCE, 0},
{842, 1306695905u, 1292690378u, 1306695905u, 0, RINTF_TOLERANCE, 0},
{843, 1003649752u, 1218792138u, 0u, 0, RINTF_TOLERANCE, 0},
{844, 1078478376u, 1326246424u, 1077936128u, 0, RINTF_TOLERANCE, 0},
{845, 1165177679u, 3276237026u, 1165176832u, 0, RINTF_TOLERANCE, 0},
{846, 3403009513u, 3381966453u, 3403009512u, 0, RINTF_TOLERANCE, 0},
{847, 952348506u, 3377573987u, 0u, 0, RINTF_TOLERANCE, 0},
{848, 1222777442u, 1125769920u, 1222777440u, 0, RINTF_TOLERANCE, 0},
{849, 1325324763u, 978336043u, 1325324763u, 0, RINTF_TOLERANCE, 0},
{850, 3363524213u, 3202991311u, 3363524224u, 0, RINTF_TOLERANCE, 0},
{851, 1158950321u, 1073578913u, 1158950912u, 0, RINTF_TOLERANCE, 0},
{852, 903129873u, 3416864271u, 0u, 0, RINTF_TOLERANCE, 0},
{853, 1208345407u, 1254181270u, 1208345408u, 0, RINTF_TOLERANCE, 0},
{854, 1258634105u, 1247426200u, 1258634105u, 0, RINTF_TOLERANCE, 0},
{855, 1248478509u, 1287895126u, 1248478508u, 0, RINTF_TOLERANCE, 0},
{856, 1153863988u, 3430539165u, 1153867776u, 0, RINTF_TOLERANCE, 0},
{857, 1235620969u, 866627358u, 1235620968u, 0, RINTF_TOLERANCE, 0},
{858, 1097120930u, 3221726305u, 1096810496u, 0, RINTF_TOLERANCE, 0},
{859, 3469778622u, 1200179013u, 3469778622u, 0, RINTF_TOLERANCE, 0},
{860, 1147712200u, 931865525u, 1147715584u, 0, RINTF_TOLERANCE, 0},
{861, 1124721745u, 3058969650u, 1124728832u, 0, RINTF_TOLERANCE, 0},
{862, 3261744304u, 1043806501u, 3261857792u, 0, RINTF_TOLERANCE, 0},
{863, 1064922416u, 1320485628u, 1065353216u, 0, RINTF_TOLERANCE, 0},
{864, 3303160152u, 3075455322u, 3303161856u, 0, RINTF_TOLERANCE, 0},
{865, 1315090496u, 3269683237u, 1315090496u, 0, RINTF_TOLERANCE, 0},
{866, 3230403187u, 1322841992u, 3229614080u, 0, RINTF_TOLERANCE, 0},
{867, 1335399673u, 974138676u, 1335399673u, 0, RINTF_TOLERANCE, 0},
{868, 1072458508u, 3372833993u, 1073741824u, 0, RINTF_TOLERANCE, 0},
{869, 3303015249u, 3015039539u, 3303014400u, 0, RINTF_TOLERANCE, 0},
{870, 3252139741u, 1059615003u, 3252158464u, 0, RINTF_TOLERANCE, 0},
{871, 3468519966u, 3113982619u, 3468519966u, 0, RINTF_TOLERANCE, 0},
{872, 1006231203u, 897530770u, 0u, 0, RINTF_TOLERANCE, 0},
{873, 951554138u, 1001144381u, 0u, 0, RINTF_TOLERANCE, 0},
{874, 942046828u, 986341002u, 0u, 0, RINTF_TOLERANCE, 0},
{875, 3319723279u, 3414482416u, 3319724032u, 0, RINTF_TOLERANCE, 0},
{876, 3255104167u, 928827688u, 3255042048u, 0, RINTF_TOLERANCE, 0},
{877, 1155477903u, 3104812800u, 1155481600u, 0, RINTF_TOLERANCE, 0},
{878, 3273889176u, 980486479u, 3273916416u, 0, RINTF_TOLERANCE, 0},
{879, 3237813668u, 3441016803u, 3238002688u, 0, RINTF_TOLERANCE, 0},
{880, 1228207362u, 2985476579u, 1228207360u, 0, RINTF_TOLERANCE, 0},
{881, 975349337u, 1311932596u, 0u, 0, RINTF_TOLERANCE, 0},
{882, 1290175785u, 3008182462u, 1290175785u, 0, RINTF_TOLERANCE, 0},
{883, 981908840u, 3314038398u, 0u, 0, RINTF_TOLERANCE, 0},
{884, 941187647u, 1107765599u, 0u, 0, RINTF_TOLERANCE, 0},
{885, 1214223128u, 3225536822u, 1214223104u, 0, RINTF_TOLERANCE, 0},
{886, 3422922584u, 1086391131u, 3422922584u, 0, RINTF_TOLERANCE, 0},
{887, 1315857601u, 3487600045u, 1315857601u, 0, RINTF_TOLERANCE, 0},
{888, 3453226030u, 3233768835u, 3453226030u, 0, RINTF_TOLERANCE, 0},
{889, 1078359574u, 3199175230u, 1077936128u, 0, RINTF_TOLERANCE, 0},
{890, 1029557624u, 3302959071u, 0u, 0, RINTF_TOLERANCE, 0},
{891, 1207675424u, 3042692550u, 1207675392u, 0, RINTF_TOLERANCE, 0},
{892, 1028355074u, 3442294040u, 0u, 0, RINTF_TOLERANCE, 0},
{893, 1248421894u, 3367769132u, 1248421896u, 0, RINTF_TOLERANCE, 0},
{894, 3353251994u, 1095517730u, 3353251968u, 0, RINTF_TOLERANCE, 0},
{895, 876926659u, 3288089977u, 0u, 0, RINTF_TOLERANCE, 0},
{896, 1076752219u, 876236939u, 1077936128u, 0, RINTF_TOLERANCE, 0},
{897, 3388531942u, 2988520062u, 3388531944u, 0, RINTF_TOLERANCE, 0},
{898, 1273395082u, 3031189261u, 1273395082u, 0, RINTF_TOLERANCE, 0},
{899, 3385588183u, 3258252464u, 3385588184u, 0, RINTF_TOLERANCE, 0},
{900, 3441804648u, 3274638356u, 3441804648u, 0, RINTF_TOLERANCE, 0},
{901, 3392827417u, 1277961150u, 3392827416u, 0, RINTF_TOLERANCE, 0},
{902, 1161241793u, 1328003707u, 1161240576u, 0, RINTF_TOLERANCE, 0},
{903, 1171318485u, 3374409104u, 1171318784u, 0, RINTF_TOLERANCE, 0},
{904, 1001216371u, 3052357038u, 0u, 0, RINTF_TOLERANCE, 0},
{905, 912515889u, 1074635609u, 0u, 0, RINTF_TOLERANCE, 0},
{906, 3391452505u, 897989232u, 3391452504u, 0, RINTF_TOLERANCE, 0},
{907, 3249603369u, 3147662248u, 3249537024u, 0, RINTF_TOLERANCE, 0},
{908, 1220264047u, 2960450369u, 1220264032u, 0, RINTF_TOLERANCE, 0},
{909, 3282212423u, 3174079140u, 3282206720u, 0, RINTF_TOLERANCE, 0},
{910, 3352293320u, 3247843425u, 3352293376u, 0, RINTF_TOLERANCE, 0},
{911, 3296358441u, 875645354u, 3296362496u, 0, RINTF_TOLERANCE, 0},
{912, 1197828352u, 3245614728u, 1197828352u, 0, RINTF_TOLERANCE, 0},
{913, 3340510371u, 914930263u, 3340510464u, 0, RINTF_TOLERANCE, 0},
{914, 1127109339u, 3368125489u, 1127088128u, 0, RINTF_TOLERANCE, 0},
{915, 909467381u, 1232375752u, 0u, 0, RINTF_TOLERANCE, 0},
{916, 1200599955u, 2981200675u, 1200599936u, 0, RINTF_TOLERANCE, 0},
{917, 962230977u, 2988248037u, 0u, 0, RINTF_TOLERANCE, 0},
{918, 3237183876u, 3179379969u, 3238002688u, 0, RINTF_TOLERANCE, 0},
{919, 939285924u, 3056079386u, 0u, 0, RINTF_TOLERANCE, 0},
{920, 944050180u, 3452557879u, 0u, 0, RINTF_TOLERANCE, 0},
{921, 3480592662u, 3261728191u, 3480592662u, 0, RINTF_TOLERANCE, 0},
{922, 1003299981u, 853295521u, 0u, 0, RINTF_TOLERANCE, 0},
{923, 1155775526u, 1255814444u, 1155776512u, 0, RINTF_TOLERANCE, 0},
{924, 1234491880u, 3408568717u, 1234491880u, 0, RINTF_TOLERANCE, 0}

// AUTOMATICALLY GENERATED VECTORS STOP

};

#endif // CYGONCE_LIBM_RINTF_H multiple inclusion protection

// EOF rintf.h
