#ifndef CYGONCE_LIBM_SCABNF_H
#define CYGONCE_LIBM_SCABNF_H
//===========================================================================
//
//      remainderf.h
//
//      Test vectors for testing of remainderf() math library function
//
//===========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####
// -------------------------------------------
// This file is part of eCos, the Embedded Configurable Operating System.
// Copyright (C) 2012 Free Software Foundation, Inc.
//
// eCos is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 or (at your option) any later
// version.
//
// eCos is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
// for more details.
//
// You should have received a copy of the GNU General Public License
// along with eCos; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//
// As a special exception, if other files instantiate templates or use
// macros or inline functions from this file, or you compile this file
// and link it with other works to produce a work based on this file,
// this file does not by itself cause the resulting work to be covered by
// the GNU General Public License. However the source code for this file
// must still be made available in accordance with section (3) of the GNU
// General Public License v2.
//
// This exception does not invalidate any other reasons why a work based
// on this file might be covered by the GNU General Public License.
// -------------------------------------------
// ####ECOSGPLCOPYRIGHTEND####
//===========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):
// Contributors:  visar, ilijak
// Date:        1998-02-13
// Purpose:
// Description:
// Usage:       #include "vectors/remainderf.h"
//
//####DESCRIPTIONEND####
//
//===========================================================================


// CONFIGURATION

#include <pkgconf/libm.h>   // Configuration header


// INCLUDES

#include <cyg/infra/cyg_type.h>    // Common type definitions and support
#include "vectors/vector_support_float.h"// extra support for math tests

#define REMAINDERF_TOLERANCE 1.0E-04

static const Cyg_libm_test_float_vec_t remainderf_vec[] = {

// AUTOMATICALLY GENERATED VECTORS START

{0, 3212836864u, 3212836864u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{1, 3212836864u, 3211998003u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{2, 3212836864u, 3211159142u, 3184315600u, 0, REMAINDERF_TOLERANCE, 0},
{3, 3212836864u, 3210320282u, 3189348760u, 0, REMAINDERF_TOLERANCE, 0},
{4, 3212836864u, 3209481421u, 3192704204u, 0, REMAINDERF_TOLERANCE, 0},
{5, 3212836864u, 3208642560u, 3196059648u, 0, REMAINDERF_TOLERANCE, 0},
{6, 3212836864u, 3207803699u, 3197737370u, 0, REMAINDERF_TOLERANCE, 0},
{7, 3212836864u, 3206964838u, 1050253720u, 0, REMAINDERF_TOLERANCE, 0},
{8, 3212836864u, 3206125978u, 1045220560u, 0, REMAINDERF_TOLERANCE, 0},
{9, 3212836864u, 3205287117u, 1036831952u, 0, REMAINDERF_TOLERANCE, 0},
{10, 3212836864u, 3204448256u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{11, 3212836864u, 3202770534u, 3184315600u, 0, REMAINDERF_TOLERANCE, 0},
{12, 3212836864u, 3201092813u, 3192704204u, 0, REMAINDERF_TOLERANCE, 0},
{13, 3212836864u, 3199415091u, 1028443336u, 0, REMAINDERF_TOLERANCE, 0},
{14, 3212836864u, 3197737370u, 3184315592u, 0, REMAINDERF_TOLERANCE, 0},
{15, 3212836864u, 3196059648u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{16, 3212836864u, 3192704205u, 847249408u, 0, REMAINDERF_TOLERANCE, 0},
{17, 3212836864u, 3189348762u, 1028443352u, 0, REMAINDERF_TOLERANCE, 0},
{18, 3212836864u, 3184315597u, 847249408u, 0, REMAINDERF_TOLERANCE, 0},
{19, 3212836864u, 3175926989u, 847249408u, 0, REMAINDERF_TOLERANCE, 0},
{20, 3212836864u, 632815616u, 2751463424u, 0, REMAINDERF_TOLERANCE, 0},
{21, 3212836864u, 1028443341u, 847249408u, 0, REMAINDERF_TOLERANCE, 0},
{22, 3212836864u, 1036831949u, 847249408u, 0, REMAINDERF_TOLERANCE, 0},
{23, 3212836864u, 1041865114u, 1028443352u, 0, REMAINDERF_TOLERANCE, 0},
{24, 3212836864u, 1045220557u, 847249408u, 0, REMAINDERF_TOLERANCE, 0},
{25, 3212836864u, 1048576000u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{26, 3212836864u, 1050253722u, 3184315592u, 0, REMAINDERF_TOLERANCE, 0},
{27, 3212836864u, 1051931443u, 1028443336u, 0, REMAINDERF_TOLERANCE, 0},
{28, 3212836864u, 1053609165u, 3192704204u, 0, REMAINDERF_TOLERANCE, 0},
{29, 3212836864u, 1055286886u, 3184315600u, 0, REMAINDERF_TOLERANCE, 0},
{30, 3212836864u, 1056964608u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{31, 3212836864u, 1057803469u, 1036831952u, 0, REMAINDERF_TOLERANCE, 0},
{32, 3212836864u, 1058642330u, 1045220560u, 0, REMAINDERF_TOLERANCE, 0},
{33, 3212836864u, 1059481190u, 1050253720u, 0, REMAINDERF_TOLERANCE, 0},
{34, 3212836864u, 1060320051u, 3197737370u, 0, REMAINDERF_TOLERANCE, 0},
{35, 3212836864u, 1061158912u, 3196059648u, 0, REMAINDERF_TOLERANCE, 0},
{36, 3212836864u, 1061997773u, 3192704204u, 0, REMAINDERF_TOLERANCE, 0},
{37, 3212836864u, 1062836634u, 3189348760u, 0, REMAINDERF_TOLERANCE, 0},
{38, 3212836864u, 1063675494u, 3184315600u, 0, REMAINDERF_TOLERANCE, 0},
{39, 3212836864u, 1064514355u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{40, 3211998003u, 3212836864u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{41, 3211998003u, 3211998003u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{42, 3211998003u, 3211159142u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{43, 3211998003u, 3210320282u, 3184315592u, 0, REMAINDERF_TOLERANCE, 0},
{44, 3211998003u, 3209481421u, 3189348760u, 0, REMAINDERF_TOLERANCE, 0},
{45, 3211998003u, 3208642560u, 3192704204u, 0, REMAINDERF_TOLERANCE, 0},
{46, 3211998003u, 3207803699u, 3196059648u, 0, REMAINDERF_TOLERANCE, 0},
{47, 3211998003u, 3206964838u, 3197737370u, 0, REMAINDERF_TOLERANCE, 0},
{48, 3211998003u, 3206125978u, 1048576002u, 0, REMAINDERF_TOLERANCE, 0},
{49, 3211998003u, 3205287117u, 1041865116u, 0, REMAINDERF_TOLERANCE, 0},
{50, 3211998003u, 3204448256u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{51, 3211998003u, 3202770534u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{52, 3211998003u, 3201092813u, 3189348760u, 0, REMAINDERF_TOLERANCE, 0},
{53, 3211998003u, 3199415091u, 1036831948u, 0, REMAINDERF_TOLERANCE, 0},
{54, 3211998003u, 3197737370u, 3175926976u, 0, REMAINDERF_TOLERANCE, 0},
{55, 3211998003u, 3196059648u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{56, 3211998003u, 3192704205u, 1028443348u, 0, REMAINDERF_TOLERANCE, 0},
{57, 3211998003u, 3189348762u, 3175926976u, 0, REMAINDERF_TOLERANCE, 0},
{58, 3211998003u, 3184315597u, 3175926982u, 0, REMAINDERF_TOLERANCE, 0},
{59, 3211998003u, 3175926989u, 853540864u, 0, REMAINDERF_TOLERANCE, 0},
{60, 3211998003u, 632815616u, 2771386368u, 0, REMAINDERF_TOLERANCE, 0},
{61, 3211998003u, 1028443341u, 853540864u, 0, REMAINDERF_TOLERANCE, 0},
{62, 3211998003u, 1036831949u, 3175926982u, 0, REMAINDERF_TOLERANCE, 0},
{63, 3211998003u, 1041865114u, 3175926976u, 0, REMAINDERF_TOLERANCE, 0},
{64, 3211998003u, 1045220557u, 1028443348u, 0, REMAINDERF_TOLERANCE, 0},
{65, 3211998003u, 1048576000u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{66, 3211998003u, 1050253722u, 3175926976u, 0, REMAINDERF_TOLERANCE, 0},
{67, 3211998003u, 1051931443u, 1036831948u, 0, REMAINDERF_TOLERANCE, 0},
{68, 3211998003u, 1053609165u, 3189348760u, 0, REMAINDERF_TOLERANCE, 0},
{69, 3211998003u, 1055286886u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{70, 3211998003u, 1056964608u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{71, 3211998003u, 1057803469u, 1041865116u, 0, REMAINDERF_TOLERANCE, 0},
{72, 3211998003u, 1058642330u, 1048576002u, 0, REMAINDERF_TOLERANCE, 0},
{73, 3211998003u, 1059481190u, 3197737370u, 0, REMAINDERF_TOLERANCE, 0},
{74, 3211998003u, 1060320051u, 3196059648u, 0, REMAINDERF_TOLERANCE, 0},
{75, 3211998003u, 1061158912u, 3192704204u, 0, REMAINDERF_TOLERANCE, 0},
{76, 3211998003u, 1061997773u, 3189348760u, 0, REMAINDERF_TOLERANCE, 0},
{77, 3211998003u, 1062836634u, 3184315592u, 0, REMAINDERF_TOLERANCE, 0},
{78, 3211998003u, 1063675494u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{79, 3211998003u, 1064514355u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{80, 3211159142u, 3212836864u, 1036831952u, 0, REMAINDERF_TOLERANCE, 0},
{81, 3211159142u, 3211998003u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{82, 3211159142u, 3211159142u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{83, 3211159142u, 3210320282u, 3175926976u, 0, REMAINDERF_TOLERANCE, 0},
{84, 3211159142u, 3209481421u, 3184315592u, 0, REMAINDERF_TOLERANCE, 0},
{85, 3211159142u, 3208642560u, 3189348760u, 0, REMAINDERF_TOLERANCE, 0},
{86, 3211159142u, 3207803699u, 3192704204u, 0, REMAINDERF_TOLERANCE, 0},
{87, 3211159142u, 3206964838u, 3196059648u, 0, REMAINDERF_TOLERANCE, 0},
{88, 3211159142u, 3206125978u, 3197737368u, 0, REMAINDERF_TOLERANCE, 0},
{89, 3211159142u, 3205287117u, 1045220560u, 0, REMAINDERF_TOLERANCE, 0},
{90, 3211159142u, 3204448256u, 1036831952u, 0, REMAINDERF_TOLERANCE, 0},
{91, 3211159142u, 3202770534u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{92, 3211159142u, 3201092813u, 3184315592u, 0, REMAINDERF_TOLERANCE, 0},
{93, 3211159142u, 3199415091u, 1041865114u, 0, REMAINDERF_TOLERANCE, 0},
{94, 3211159142u, 3197737370u, 864026624u, 0, REMAINDERF_TOLERANCE, 0},
{95, 3211159142u, 3196059648u, 1036831952u, 0, REMAINDERF_TOLERANCE, 0},
{96, 3211159142u, 3192704205u, 3184315592u, 0, REMAINDERF_TOLERANCE, 0},
{97, 3211159142u, 3189348762u, 864026624u, 0, REMAINDERF_TOLERANCE, 0},
{98, 3211159142u, 3184315597u, 857735168u, 0, REMAINDERF_TOLERANCE, 0},
{99, 3211159142u, 3175926989u, 857735168u, 0, REMAINDERF_TOLERANCE, 0},
{100, 3211159142u, 632815616u, 608174080u, 0, REMAINDERF_TOLERANCE, 0},
{101, 3211159142u, 1028443341u, 857735168u, 0, REMAINDERF_TOLERANCE, 0},
{102, 3211159142u, 1036831949u, 857735168u, 0, REMAINDERF_TOLERANCE, 0},
{103, 3211159142u, 1041865114u, 864026624u, 0, REMAINDERF_TOLERANCE, 0},
{104, 3211159142u, 1045220557u, 3184315592u, 0, REMAINDERF_TOLERANCE, 0},
{105, 3211159142u, 1048576000u, 1036831952u, 0, REMAINDERF_TOLERANCE, 0},
{106, 3211159142u, 1050253722u, 864026624u, 0, REMAINDERF_TOLERANCE, 0},
{107, 3211159142u, 1051931443u, 1041865114u, 0, REMAINDERF_TOLERANCE, 0},
{108, 3211159142u, 1053609165u, 3184315592u, 0, REMAINDERF_TOLERANCE, 0},
{109, 3211159142u, 1055286886u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{110, 3211159142u, 1056964608u, 1036831952u, 0, REMAINDERF_TOLERANCE, 0},
{111, 3211159142u, 1057803469u, 1045220560u, 0, REMAINDERF_TOLERANCE, 0},
{112, 3211159142u, 1058642330u, 3197737368u, 0, REMAINDERF_TOLERANCE, 0},
{113, 3211159142u, 1059481190u, 3196059648u, 0, REMAINDERF_TOLERANCE, 0},
{114, 3211159142u, 1060320051u, 3192704204u, 0, REMAINDERF_TOLERANCE, 0},
{115, 3211159142u, 1061158912u, 3189348760u, 0, REMAINDERF_TOLERANCE, 0},
{116, 3211159142u, 1061997773u, 3184315592u, 0, REMAINDERF_TOLERANCE, 0},
{117, 3211159142u, 1062836634u, 3175926976u, 0, REMAINDERF_TOLERANCE, 0},
{118, 3211159142u, 1063675494u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{119, 3211159142u, 1064514355u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{120, 3210320282u, 3212836864u, 1041865112u, 0, REMAINDERF_TOLERANCE, 0},
{121, 3210320282u, 3211998003u, 1036831944u, 0, REMAINDERF_TOLERANCE, 0},
{122, 3210320282u, 3211159142u, 1028443328u, 0, REMAINDERF_TOLERANCE, 0},
{123, 3210320282u, 3210320282u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{124, 3210320282u, 3209481421u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{125, 3210320282u, 3208642560u, 3184315600u, 0, REMAINDERF_TOLERANCE, 0},
{126, 3210320282u, 3207803699u, 3189348764u, 0, REMAINDERF_TOLERANCE, 0},
{127, 3210320282u, 3206964838u, 3192704208u, 0, REMAINDERF_TOLERANCE, 0},
{128, 3210320282u, 3206125978u, 3196059648u, 0, REMAINDERF_TOLERANCE, 0},
{129, 3210320282u, 3205287117u, 1048576000u, 0, REMAINDERF_TOLERANCE, 0},
{130, 3210320282u, 3204448256u, 1041865112u, 0, REMAINDERF_TOLERANCE, 0},
{131, 3210320282u, 3202770534u, 1028443328u, 0, REMAINDERF_TOLERANCE, 0},
{132, 3210320282u, 3201092813u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{133, 3210320282u, 3199415091u, 3189348764u, 0, REMAINDERF_TOLERANCE, 0},
{134, 3210320282u, 3197737370u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{135, 3210320282u, 3196059648u, 3184315600u, 0, REMAINDERF_TOLERANCE, 0},
{136, 3210320282u, 3192704205u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{137, 3210320282u, 3189348762u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{138, 3210320282u, 3184315597u, 1028443338u, 0, REMAINDERF_TOLERANCE, 0},
{139, 3210320282u, 3175926989u, 2990538752u, 0, REMAINDERF_TOLERANCE, 0},
{140, 3210320282u, 632815616u, 614465536u, 0, REMAINDERF_TOLERANCE, 0},
{141, 3210320282u, 1028443341u, 2990538752u, 0, REMAINDERF_TOLERANCE, 0},
{142, 3210320282u, 1036831949u, 1028443338u, 0, REMAINDERF_TOLERANCE, 0},
{143, 3210320282u, 1041865114u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{144, 3210320282u, 1045220557u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{145, 3210320282u, 1048576000u, 3184315600u, 0, REMAINDERF_TOLERANCE, 0},
{146, 3210320282u, 1050253722u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{147, 3210320282u, 1051931443u, 3189348764u, 0, REMAINDERF_TOLERANCE, 0},
{148, 3210320282u, 1053609165u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{149, 3210320282u, 1055286886u, 1028443328u, 0, REMAINDERF_TOLERANCE, 0},
{150, 3210320282u, 1056964608u, 1041865112u, 0, REMAINDERF_TOLERANCE, 0},
{151, 3210320282u, 1057803469u, 1048576000u, 0, REMAINDERF_TOLERANCE, 0},
{152, 3210320282u, 1058642330u, 3196059648u, 0, REMAINDERF_TOLERANCE, 0},
{153, 3210320282u, 1059481190u, 3192704208u, 0, REMAINDERF_TOLERANCE, 0},
{154, 3210320282u, 1060320051u, 3189348764u, 0, REMAINDERF_TOLERANCE, 0},
{155, 3210320282u, 1061158912u, 3184315600u, 0, REMAINDERF_TOLERANCE, 0},
{156, 3210320282u, 1061997773u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{157, 3210320282u, 1062836634u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{158, 3210320282u, 1063675494u, 1028443328u, 0, REMAINDERF_TOLERANCE, 0},
{159, 3210320282u, 1064514355u, 1036831944u, 0, REMAINDERF_TOLERANCE, 0},
{160, 3209481421u, 3212836864u, 1045220556u, 0, REMAINDERF_TOLERANCE, 0},
{161, 3209481421u, 3211998003u, 1041865112u, 0, REMAINDERF_TOLERANCE, 0},
{162, 3209481421u, 3211159142u, 1036831944u, 0, REMAINDERF_TOLERANCE, 0},
{163, 3209481421u, 3210320282u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{164, 3209481421u, 3209481421u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{165, 3209481421u, 3208642560u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{166, 3209481421u, 3207803699u, 3184315600u, 0, REMAINDERF_TOLERANCE, 0},
{167, 3209481421u, 3206964838u, 3189348764u, 0, REMAINDERF_TOLERANCE, 0},
{168, 3209481421u, 3206125978u, 3192704204u, 0, REMAINDERF_TOLERANCE, 0},
{169, 3209481421u, 3205287117u, 3196059648u, 0, REMAINDERF_TOLERANCE, 0},
{170, 3209481421u, 3204448256u, 1045220556u, 0, REMAINDERF_TOLERANCE, 0},
{171, 3209481421u, 3202770534u, 1036831944u, 0, REMAINDERF_TOLERANCE, 0},
{172, 3209481421u, 3201092813u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{173, 3209481421u, 3199415091u, 3184315600u, 0, REMAINDERF_TOLERANCE, 0},
{174, 3209481421u, 3197737370u, 1036831952u, 0, REMAINDERF_TOLERANCE, 0},
{175, 3209481421u, 3196059648u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{176, 3209481421u, 3192704205u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{177, 3209481421u, 3189348762u, 3175926984u, 0, REMAINDERF_TOLERANCE, 0},
{178, 3209481421u, 3184315597u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{179, 3209481421u, 3175926989u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{180, 3209481421u, 632815616u, 2759852032u, 0, REMAINDERF_TOLERANCE, 0},
{181, 3209481421u, 1028443341u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{182, 3209481421u, 1036831949u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{183, 3209481421u, 1041865114u, 3175926984u, 0, REMAINDERF_TOLERANCE, 0},
{184, 3209481421u, 1045220557u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{185, 3209481421u, 1048576000u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{186, 3209481421u, 1050253722u, 1036831952u, 0, REMAINDERF_TOLERANCE, 0},
{187, 3209481421u, 1051931443u, 3184315600u, 0, REMAINDERF_TOLERANCE, 0},
{188, 3209481421u, 1053609165u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{189, 3209481421u, 1055286886u, 1036831944u, 0, REMAINDERF_TOLERANCE, 0},
{190, 3209481421u, 1056964608u, 1045220556u, 0, REMAINDERF_TOLERANCE, 0},
{191, 3209481421u, 1057803469u, 3196059648u, 0, REMAINDERF_TOLERANCE, 0},
{192, 3209481421u, 1058642330u, 3192704204u, 0, REMAINDERF_TOLERANCE, 0},
{193, 3209481421u, 1059481190u, 3189348764u, 0, REMAINDERF_TOLERANCE, 0},
{194, 3209481421u, 1060320051u, 3184315600u, 0, REMAINDERF_TOLERANCE, 0},
{195, 3209481421u, 1061158912u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{196, 3209481421u, 1061997773u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{197, 3209481421u, 1062836634u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{198, 3209481421u, 1063675494u, 1036831944u, 0, REMAINDERF_TOLERANCE, 0},
{199, 3209481421u, 1064514355u, 1041865112u, 0, REMAINDERF_TOLERANCE, 0},
{200, 3208642560u, 3212836864u, 1048576000u, 0, REMAINDERF_TOLERANCE, 0},
{201, 3208642560u, 3211998003u, 1045220556u, 0, REMAINDERF_TOLERANCE, 0},
{202, 3208642560u, 3211159142u, 1041865112u, 0, REMAINDERF_TOLERANCE, 0},
{203, 3208642560u, 3210320282u, 1036831952u, 0, REMAINDERF_TOLERANCE, 0},
{204, 3208642560u, 3209481421u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{205, 3208642560u, 3208642560u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{206, 3208642560u, 3207803699u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{207, 3208642560u, 3206964838u, 3184315600u, 0, REMAINDERF_TOLERANCE, 0},
{208, 3208642560u, 3206125978u, 3189348760u, 0, REMAINDERF_TOLERANCE, 0},
{209, 3208642560u, 3205287117u, 3192704204u, 0, REMAINDERF_TOLERANCE, 0},
{210, 3208642560u, 3204448256u, 1048576000u, 0, REMAINDERF_TOLERANCE, 0},
{211, 3208642560u, 3202770534u, 1041865112u, 0, REMAINDERF_TOLERANCE, 0},
{212, 3208642560u, 3201092813u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{213, 3208642560u, 3199415091u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{214, 3208642560u, 3197737370u, 3189348760u, 0, REMAINDERF_TOLERANCE, 0},
{215, 3208642560u, 3196059648u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{216, 3208642560u, 3192704205u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{217, 3208642560u, 3189348762u, 855638016u, 0, REMAINDERF_TOLERANCE, 0},
{218, 3208642560u, 3184315597u, 3175926986u, 0, REMAINDERF_TOLERANCE, 0},
{219, 3208642560u, 3175926989u, 843055104u, 0, REMAINDERF_TOLERANCE, 0},
{220, 3208642560u, 632815616u, 622854144u, 0, REMAINDERF_TOLERANCE, 0},
{221, 3208642560u, 1028443341u, 843055104u, 0, REMAINDERF_TOLERANCE, 0},
{222, 3208642560u, 1036831949u, 3175926986u, 0, REMAINDERF_TOLERANCE, 0},
{223, 3208642560u, 1041865114u, 855638016u, 0, REMAINDERF_TOLERANCE, 0},
{224, 3208642560u, 1045220557u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{225, 3208642560u, 1048576000u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{226, 3208642560u, 1050253722u, 3189348760u, 0, REMAINDERF_TOLERANCE, 0},
{227, 3208642560u, 1051931443u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{228, 3208642560u, 1053609165u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{229, 3208642560u, 1055286886u, 1041865112u, 0, REMAINDERF_TOLERANCE, 0},
{230, 3208642560u, 1056964608u, 1048576000u, 0, REMAINDERF_TOLERANCE, 0},
{231, 3208642560u, 1057803469u, 3192704204u, 0, REMAINDERF_TOLERANCE, 0},
{232, 3208642560u, 1058642330u, 3189348760u, 0, REMAINDERF_TOLERANCE, 0},
{233, 3208642560u, 1059481190u, 3184315600u, 0, REMAINDERF_TOLERANCE, 0},
{234, 3208642560u, 1060320051u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{235, 3208642560u, 1061158912u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{236, 3208642560u, 1061997773u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{237, 3208642560u, 1062836634u, 1036831952u, 0, REMAINDERF_TOLERANCE, 0},
{238, 3208642560u, 1063675494u, 1041865112u, 0, REMAINDERF_TOLERANCE, 0},
{239, 3208642560u, 1064514355u, 1045220556u, 0, REMAINDERF_TOLERANCE, 0},
{240, 3207803699u, 3212836864u, 1050253722u, 0, REMAINDERF_TOLERANCE, 0},
{241, 3207803699u, 3211998003u, 1048576000u, 0, REMAINDERF_TOLERANCE, 0},
{242, 3207803699u, 3211159142u, 1045220556u, 0, REMAINDERF_TOLERANCE, 0},
{243, 3207803699u, 3210320282u, 1041865116u, 0, REMAINDERF_TOLERANCE, 0},
{244, 3207803699u, 3209481421u, 1036831952u, 0, REMAINDERF_TOLERANCE, 0},
{245, 3207803699u, 3208642560u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{246, 3207803699u, 3207803699u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{247, 3207803699u, 3206964838u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{248, 3207803699u, 3206125978u, 3184315592u, 0, REMAINDERF_TOLERANCE, 0},
{249, 3207803699u, 3205287117u, 3189348760u, 0, REMAINDERF_TOLERANCE, 0},
{250, 3207803699u, 3204448256u, 3192704204u, 0, REMAINDERF_TOLERANCE, 0},
{251, 3207803699u, 3202770534u, 1045220556u, 0, REMAINDERF_TOLERANCE, 0},
{252, 3207803699u, 3201092813u, 1036831952u, 0, REMAINDERF_TOLERANCE, 0},
{253, 3207803699u, 3199415091u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{254, 3207803699u, 3197737370u, 3184315592u, 0, REMAINDERF_TOLERANCE, 0},
{255, 3207803699u, 3196059648u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{256, 3207803699u, 3192704205u, 3184315594u, 0, REMAINDERF_TOLERANCE, 0},
{257, 3207803699u, 3189348762u, 1028443352u, 0, REMAINDERF_TOLERANCE, 0},
{258, 3207803699u, 3184315597u, 851443712u, 0, REMAINDERF_TOLERANCE, 0},
{259, 3207803699u, 3175926989u, 851443712u, 0, REMAINDERF_TOLERANCE, 0},
{260, 3207803699u, 632815616u, 595591168u, 0, REMAINDERF_TOLERANCE, 0},
{261, 3207803699u, 1028443341u, 851443712u, 0, REMAINDERF_TOLERANCE, 0},
{262, 3207803699u, 1036831949u, 851443712u, 0, REMAINDERF_TOLERANCE, 0},
{263, 3207803699u, 1041865114u, 1028443352u, 0, REMAINDERF_TOLERANCE, 0},
{264, 3207803699u, 1045220557u, 3184315594u, 0, REMAINDERF_TOLERANCE, 0},
{265, 3207803699u, 1048576000u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{266, 3207803699u, 1050253722u, 3184315592u, 0, REMAINDERF_TOLERANCE, 0},
{267, 3207803699u, 1051931443u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{268, 3207803699u, 1053609165u, 1036831952u, 0, REMAINDERF_TOLERANCE, 0},
{269, 3207803699u, 1055286886u, 1045220556u, 0, REMAINDERF_TOLERANCE, 0},
{270, 3207803699u, 1056964608u, 3192704204u, 0, REMAINDERF_TOLERANCE, 0},
{271, 3207803699u, 1057803469u, 3189348760u, 0, REMAINDERF_TOLERANCE, 0},
{272, 3207803699u, 1058642330u, 3184315592u, 0, REMAINDERF_TOLERANCE, 0},
{273, 3207803699u, 1059481190u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{274, 3207803699u, 1060320051u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{275, 3207803699u, 1061158912u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{276, 3207803699u, 1061997773u, 1036831952u, 0, REMAINDERF_TOLERANCE, 0},
{277, 3207803699u, 1062836634u, 1041865116u, 0, REMAINDERF_TOLERANCE, 0},
{278, 3207803699u, 1063675494u, 1045220556u, 0, REMAINDERF_TOLERANCE, 0},
{279, 3207803699u, 1064514355u, 1048576000u, 0, REMAINDERF_TOLERANCE, 0},
{280, 3206964838u, 3212836864u, 1051931444u, 0, REMAINDERF_TOLERANCE, 0},
{281, 3206964838u, 3211998003u, 1050253722u, 0, REMAINDERF_TOLERANCE, 0},
{282, 3206964838u, 3211159142u, 1048576000u, 0, REMAINDERF_TOLERANCE, 0},
{283, 3206964838u, 3210320282u, 1045220560u, 0, REMAINDERF_TOLERANCE, 0},
{284, 3206964838u, 3209481421u, 1041865116u, 0, REMAINDERF_TOLERANCE, 0},
{285, 3206964838u, 3208642560u, 1036831952u, 0, REMAINDERF_TOLERANCE, 0},
{286, 3206964838u, 3207803699u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{287, 3206964838u, 3206964838u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{288, 3206964838u, 3206125978u, 3175926976u, 0, REMAINDERF_TOLERANCE, 0},
{289, 3206964838u, 3205287117u, 3184315592u, 0, REMAINDERF_TOLERANCE, 0},
{290, 3206964838u, 3204448256u, 3189348760u, 0, REMAINDERF_TOLERANCE, 0},
{291, 3206964838u, 3202770534u, 3192704204u, 0, REMAINDERF_TOLERANCE, 0},
{292, 3206964838u, 3201092813u, 1041865116u, 0, REMAINDERF_TOLERANCE, 0},
{293, 3206964838u, 3199415091u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{294, 3206964838u, 3197737370u, 3175926976u, 0, REMAINDERF_TOLERANCE, 0},
{295, 3206964838u, 3196059648u, 1036831952u, 0, REMAINDERF_TOLERANCE, 0},
{296, 3206964838u, 3192704205u, 3175926980u, 0, REMAINDERF_TOLERANCE, 0},
{297, 3206964838u, 3189348762u, 3175926976u, 0, REMAINDERF_TOLERANCE, 0},
{298, 3206964838u, 3184315597u, 3175926980u, 0, REMAINDERF_TOLERANCE, 0},
{299, 3206964838u, 3175926989u, 856686592u, 0, REMAINDERF_TOLERANCE, 0},
{300, 3206964838u, 632815616u, 2768240640u, 0, REMAINDERF_TOLERANCE, 0},
{301, 3206964838u, 1028443341u, 856686592u, 0, REMAINDERF_TOLERANCE, 0},
{302, 3206964838u, 1036831949u, 3175926980u, 0, REMAINDERF_TOLERANCE, 0},
{303, 3206964838u, 1041865114u, 3175926976u, 0, REMAINDERF_TOLERANCE, 0},
{304, 3206964838u, 1045220557u, 3175926980u, 0, REMAINDERF_TOLERANCE, 0},
{305, 3206964838u, 1048576000u, 1036831952u, 0, REMAINDERF_TOLERANCE, 0},
{306, 3206964838u, 1050253722u, 3175926976u, 0, REMAINDERF_TOLERANCE, 0},
{307, 3206964838u, 1051931443u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{308, 3206964838u, 1053609165u, 1041865116u, 0, REMAINDERF_TOLERANCE, 0},
{309, 3206964838u, 1055286886u, 3192704204u, 0, REMAINDERF_TOLERANCE, 0},
{310, 3206964838u, 1056964608u, 3189348760u, 0, REMAINDERF_TOLERANCE, 0},
{311, 3206964838u, 1057803469u, 3184315592u, 0, REMAINDERF_TOLERANCE, 0},
{312, 3206964838u, 1058642330u, 3175926976u, 0, REMAINDERF_TOLERANCE, 0},
{313, 3206964838u, 1059481190u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{314, 3206964838u, 1060320051u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{315, 3206964838u, 1061158912u, 1036831952u, 0, REMAINDERF_TOLERANCE, 0},
{316, 3206964838u, 1061997773u, 1041865116u, 0, REMAINDERF_TOLERANCE, 0},
{317, 3206964838u, 1062836634u, 1045220560u, 0, REMAINDERF_TOLERANCE, 0},
{318, 3206964838u, 1063675494u, 1048576000u, 0, REMAINDERF_TOLERANCE, 0},
{319, 3206964838u, 1064514355u, 1050253722u, 0, REMAINDERF_TOLERANCE, 0},
{320, 3206125978u, 3212836864u, 1053609164u, 0, REMAINDERF_TOLERANCE, 0},
{321, 3206125978u, 3211998003u, 1051931442u, 0, REMAINDERF_TOLERANCE, 0},
{322, 3206125978u, 3211159142u, 1050253720u, 0, REMAINDERF_TOLERANCE, 0},
{323, 3206125978u, 3210320282u, 1048576000u, 0, REMAINDERF_TOLERANCE, 0},
{324, 3206125978u, 3209481421u, 1045220556u, 0, REMAINDERF_TOLERANCE, 0},
{325, 3206125978u, 3208642560u, 1041865112u, 0, REMAINDERF_TOLERANCE, 0},
{326, 3206125978u, 3207803699u, 1036831944u, 0, REMAINDERF_TOLERANCE, 0},
{327, 3206125978u, 3206964838u, 1028443328u, 0, REMAINDERF_TOLERANCE, 0},
{328, 3206125978u, 3206125978u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{329, 3206125978u, 3205287117u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{330, 3206125978u, 3204448256u, 3184315600u, 0, REMAINDERF_TOLERANCE, 0},
{331, 3206125978u, 3202770534u, 3189348764u, 0, REMAINDERF_TOLERANCE, 0},
{332, 3206125978u, 3201092813u, 1045220556u, 0, REMAINDERF_TOLERANCE, 0},
{333, 3206125978u, 3199415091u, 1036831944u, 0, REMAINDERF_TOLERANCE, 0},
{334, 3206125978u, 3197737370u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{335, 3206125978u, 3196059648u, 3184315600u, 0, REMAINDERF_TOLERANCE, 0},
{336, 3206125978u, 3192704205u, 2994733056u, 0, REMAINDERF_TOLERANCE, 0},
{337, 3206125978u, 3189348762u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{338, 3206125978u, 3184315597u, 2994733056u, 0, REMAINDERF_TOLERANCE, 0},
{339, 3206125978u, 3175926989u, 2994733056u, 0, REMAINDERF_TOLERANCE, 0},
{340, 3206125978u, 632815616u, 2764046336u, 0, REMAINDERF_TOLERANCE, 0},
{341, 3206125978u, 1028443341u, 2994733056u, 0, REMAINDERF_TOLERANCE, 0},
{342, 3206125978u, 1036831949u, 2994733056u, 0, REMAINDERF_TOLERANCE, 0},
{343, 3206125978u, 1041865114u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{344, 3206125978u, 1045220557u, 2994733056u, 0, REMAINDERF_TOLERANCE, 0},
{345, 3206125978u, 1048576000u, 3184315600u, 0, REMAINDERF_TOLERANCE, 0},
{346, 3206125978u, 1050253722u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{347, 3206125978u, 1051931443u, 1036831944u, 0, REMAINDERF_TOLERANCE, 0},
{348, 3206125978u, 1053609165u, 1045220556u, 0, REMAINDERF_TOLERANCE, 0},
{349, 3206125978u, 1055286886u, 3189348764u, 0, REMAINDERF_TOLERANCE, 0},
{350, 3206125978u, 1056964608u, 3184315600u, 0, REMAINDERF_TOLERANCE, 0},
{351, 3206125978u, 1057803469u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{352, 3206125978u, 1058642330u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{353, 3206125978u, 1059481190u, 1028443328u, 0, REMAINDERF_TOLERANCE, 0},
{354, 3206125978u, 1060320051u, 1036831944u, 0, REMAINDERF_TOLERANCE, 0},
{355, 3206125978u, 1061158912u, 1041865112u, 0, REMAINDERF_TOLERANCE, 0},
{356, 3206125978u, 1061997773u, 1045220556u, 0, REMAINDERF_TOLERANCE, 0},
{357, 3206125978u, 1062836634u, 1048576000u, 0, REMAINDERF_TOLERANCE, 0},
{358, 3206125978u, 1063675494u, 1050253720u, 0, REMAINDERF_TOLERANCE, 0},
{359, 3206125978u, 1064514355u, 1051931442u, 0, REMAINDERF_TOLERANCE, 0},
{360, 3205287117u, 3212836864u, 1055286886u, 0, REMAINDERF_TOLERANCE, 0},
{361, 3205287117u, 3211998003u, 1053609164u, 0, REMAINDERF_TOLERANCE, 0},
{362, 3205287117u, 3211159142u, 1051931442u, 0, REMAINDERF_TOLERANCE, 0},
{363, 3205287117u, 3210320282u, 1050253722u, 0, REMAINDERF_TOLERANCE, 0},
{364, 3205287117u, 3209481421u, 1048576000u, 0, REMAINDERF_TOLERANCE, 0},
{365, 3205287117u, 3208642560u, 1045220556u, 0, REMAINDERF_TOLERANCE, 0},
{366, 3205287117u, 3207803699u, 1041865112u, 0, REMAINDERF_TOLERANCE, 0},
{367, 3205287117u, 3206964838u, 1036831944u, 0, REMAINDERF_TOLERANCE, 0},
{368, 3205287117u, 3206125978u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{369, 3205287117u, 3205287117u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{370, 3205287117u, 3204448256u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{371, 3205287117u, 3202770534u, 3184315600u, 0, REMAINDERF_TOLERANCE, 0},
{372, 3205287117u, 3201092813u, 3189348762u, 0, REMAINDERF_TOLERANCE, 0},
{373, 3205287117u, 3199415091u, 1041865112u, 0, REMAINDERF_TOLERANCE, 0},
{374, 3205287117u, 3197737370u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{375, 3205287117u, 3196059648u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{376, 3205287117u, 3192704205u, 1028443340u, 0, REMAINDERF_TOLERANCE, 0},
{377, 3205287117u, 3189348762u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{378, 3205287117u, 3184315597u, 1028443340u, 0, REMAINDERF_TOLERANCE, 0},
{379, 3205287117u, 3175926989u, 2977955840u, 0, REMAINDERF_TOLERANCE, 0},
{380, 3205287117u, 632815616u, 620756992u, 0, REMAINDERF_TOLERANCE, 0},
{381, 3205287117u, 1028443341u, 2977955840u, 0, REMAINDERF_TOLERANCE, 0},
{382, 3205287117u, 1036831949u, 1028443340u, 0, REMAINDERF_TOLERANCE, 0},
{383, 3205287117u, 1041865114u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{384, 3205287117u, 1045220557u, 1028443340u, 0, REMAINDERF_TOLERANCE, 0},
{385, 3205287117u, 1048576000u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{386, 3205287117u, 1050253722u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{387, 3205287117u, 1051931443u, 1041865112u, 0, REMAINDERF_TOLERANCE, 0},
{388, 3205287117u, 1053609165u, 3189348762u, 0, REMAINDERF_TOLERANCE, 0},
{389, 3205287117u, 1055286886u, 3184315600u, 0, REMAINDERF_TOLERANCE, 0},
{390, 3205287117u, 1056964608u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{391, 3205287117u, 1057803469u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{392, 3205287117u, 1058642330u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{393, 3205287117u, 1059481190u, 1036831944u, 0, REMAINDERF_TOLERANCE, 0},
{394, 3205287117u, 1060320051u, 1041865112u, 0, REMAINDERF_TOLERANCE, 0},
{395, 3205287117u, 1061158912u, 1045220556u, 0, REMAINDERF_TOLERANCE, 0},
{396, 3205287117u, 1061997773u, 1048576000u, 0, REMAINDERF_TOLERANCE, 0},
{397, 3205287117u, 1062836634u, 1050253722u, 0, REMAINDERF_TOLERANCE, 0},
{398, 3205287117u, 1063675494u, 1051931442u, 0, REMAINDERF_TOLERANCE, 0},
{399, 3205287117u, 1064514355u, 1053609164u, 0, REMAINDERF_TOLERANCE, 0},
{400, 3204448256u, 3212836864u, 3204448256u, 0, REMAINDERF_TOLERANCE, 0},
{401, 3204448256u, 3211998003u, 1055286886u, 0, REMAINDERF_TOLERANCE, 0},
{402, 3204448256u, 3211159142u, 1053609164u, 0, REMAINDERF_TOLERANCE, 0},
{403, 3204448256u, 3210320282u, 1051931444u, 0, REMAINDERF_TOLERANCE, 0},
{404, 3204448256u, 3209481421u, 1050253722u, 0, REMAINDERF_TOLERANCE, 0},
{405, 3204448256u, 3208642560u, 1048576000u, 0, REMAINDERF_TOLERANCE, 0},
{406, 3204448256u, 3207803699u, 1045220556u, 0, REMAINDERF_TOLERANCE, 0},
{407, 3204448256u, 3206964838u, 1041865112u, 0, REMAINDERF_TOLERANCE, 0},
{408, 3204448256u, 3206125978u, 1036831952u, 0, REMAINDERF_TOLERANCE, 0},
{409, 3204448256u, 3205287117u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{410, 3204448256u, 3204448256u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{411, 3204448256u, 3202770534u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{412, 3204448256u, 3201092813u, 3184315596u, 0, REMAINDERF_TOLERANCE, 0},
{413, 3204448256u, 3199415091u, 3189348762u, 0, REMAINDERF_TOLERANCE, 0},
{414, 3204448256u, 3197737370u, 1036831952u, 0, REMAINDERF_TOLERANCE, 0},
{415, 3204448256u, 3196059648u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{416, 3204448256u, 3192704205u, 3184315596u, 0, REMAINDERF_TOLERANCE, 0},
{417, 3204448256u, 3189348762u, 3175926984u, 0, REMAINDERF_TOLERANCE, 0},
{418, 3204448256u, 3184315597u, 838860800u, 0, REMAINDERF_TOLERANCE, 0},
{419, 3204448256u, 3175926989u, 838860800u, 0, REMAINDERF_TOLERANCE, 0},
{420, 3204448256u, 632815616u, 2743074816u, 0, REMAINDERF_TOLERANCE, 0},
{421, 3204448256u, 1028443341u, 838860800u, 0, REMAINDERF_TOLERANCE, 0},
{422, 3204448256u, 1036831949u, 838860800u, 0, REMAINDERF_TOLERANCE, 0},
{423, 3204448256u, 1041865114u, 3175926984u, 0, REMAINDERF_TOLERANCE, 0},
{424, 3204448256u, 1045220557u, 3184315596u, 0, REMAINDERF_TOLERANCE, 0},
{425, 3204448256u, 1048576000u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{426, 3204448256u, 1050253722u, 1036831952u, 0, REMAINDERF_TOLERANCE, 0},
{427, 3204448256u, 1051931443u, 3189348762u, 0, REMAINDERF_TOLERANCE, 0},
{428, 3204448256u, 1053609165u, 3184315596u, 0, REMAINDERF_TOLERANCE, 0},
{429, 3204448256u, 1055286886u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{430, 3204448256u, 1056964608u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{431, 3204448256u, 1057803469u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{432, 3204448256u, 1058642330u, 1036831952u, 0, REMAINDERF_TOLERANCE, 0},
{433, 3204448256u, 1059481190u, 1041865112u, 0, REMAINDERF_TOLERANCE, 0},
{434, 3204448256u, 1060320051u, 1045220556u, 0, REMAINDERF_TOLERANCE, 0},
{435, 3204448256u, 1061158912u, 1048576000u, 0, REMAINDERF_TOLERANCE, 0},
{436, 3204448256u, 1061997773u, 1050253722u, 0, REMAINDERF_TOLERANCE, 0},
{437, 3204448256u, 1062836634u, 1051931444u, 0, REMAINDERF_TOLERANCE, 0},
{438, 3204448256u, 1063675494u, 1053609164u, 0, REMAINDERF_TOLERANCE, 0},
{439, 3204448256u, 1064514355u, 1055286886u, 0, REMAINDERF_TOLERANCE, 0},
{440, 3202770534u, 3212836864u, 3202770534u, 0, REMAINDERF_TOLERANCE, 0},
{441, 3202770534u, 3211998003u, 3202770534u, 0, REMAINDERF_TOLERANCE, 0},
{442, 3202770534u, 3211159142u, 3202770534u, 0, REMAINDERF_TOLERANCE, 0},
{443, 3202770534u, 3210320282u, 1053609166u, 0, REMAINDERF_TOLERANCE, 0},
{444, 3202770534u, 3209481421u, 1051931444u, 0, REMAINDERF_TOLERANCE, 0},
{445, 3202770534u, 3208642560u, 1050253722u, 0, REMAINDERF_TOLERANCE, 0},
{446, 3202770534u, 3207803699u, 1048576000u, 0, REMAINDERF_TOLERANCE, 0},
{447, 3202770534u, 3206964838u, 1045220556u, 0, REMAINDERF_TOLERANCE, 0},
{448, 3202770534u, 3206125978u, 1041865116u, 0, REMAINDERF_TOLERANCE, 0},
{449, 3202770534u, 3205287117u, 1036831952u, 0, REMAINDERF_TOLERANCE, 0},
{450, 3202770534u, 3204448256u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{451, 3202770534u, 3202770534u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{452, 3202770534u, 3201092813u, 3175926984u, 0, REMAINDERF_TOLERANCE, 0},
{453, 3202770534u, 3199415091u, 3184315596u, 0, REMAINDERF_TOLERANCE, 0},
{454, 3202770534u, 3197737370u, 3189348760u, 0, REMAINDERF_TOLERANCE, 0},
{455, 3202770534u, 3196059648u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{456, 3202770534u, 3192704205u, 3175926984u, 0, REMAINDERF_TOLERANCE, 0},
{457, 3202770534u, 3189348762u, 855638016u, 0, REMAINDERF_TOLERANCE, 0},
{458, 3202770534u, 3184315597u, 3175926984u, 0, REMAINDERF_TOLERANCE, 0},
{459, 3202770534u, 3175926989u, 849346560u, 0, REMAINDERF_TOLERANCE, 0},
{460, 3202770534u, 632815616u, 2770337792u, 0, REMAINDERF_TOLERANCE, 0},
{461, 3202770534u, 1028443341u, 849346560u, 0, REMAINDERF_TOLERANCE, 0},
{462, 3202770534u, 1036831949u, 3175926984u, 0, REMAINDERF_TOLERANCE, 0},
{463, 3202770534u, 1041865114u, 855638016u, 0, REMAINDERF_TOLERANCE, 0},
{464, 3202770534u, 1045220557u, 3175926984u, 0, REMAINDERF_TOLERANCE, 0},
{465, 3202770534u, 1048576000u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{466, 3202770534u, 1050253722u, 3189348760u, 0, REMAINDERF_TOLERANCE, 0},
{467, 3202770534u, 1051931443u, 3184315596u, 0, REMAINDERF_TOLERANCE, 0},
{468, 3202770534u, 1053609165u, 3175926984u, 0, REMAINDERF_TOLERANCE, 0},
{469, 3202770534u, 1055286886u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{470, 3202770534u, 1056964608u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{471, 3202770534u, 1057803469u, 1036831952u, 0, REMAINDERF_TOLERANCE, 0},
{472, 3202770534u, 1058642330u, 1041865116u, 0, REMAINDERF_TOLERANCE, 0},
{473, 3202770534u, 1059481190u, 1045220556u, 0, REMAINDERF_TOLERANCE, 0},
{474, 3202770534u, 1060320051u, 1048576000u, 0, REMAINDERF_TOLERANCE, 0},
{475, 3202770534u, 1061158912u, 1050253722u, 0, REMAINDERF_TOLERANCE, 0},
{476, 3202770534u, 1061997773u, 1051931444u, 0, REMAINDERF_TOLERANCE, 0},
{477, 3202770534u, 1062836634u, 1053609166u, 0, REMAINDERF_TOLERANCE, 0},
{478, 3202770534u, 1063675494u, 3202770534u, 0, REMAINDERF_TOLERANCE, 0},
{479, 3202770534u, 1064514355u, 3202770534u, 0, REMAINDERF_TOLERANCE, 0},
{480, 3201092813u, 3212836864u, 3201092813u, 0, REMAINDERF_TOLERANCE, 0},
{481, 3201092813u, 3211998003u, 3201092813u, 0, REMAINDERF_TOLERANCE, 0},
{482, 3201092813u, 3211159142u, 3201092813u, 0, REMAINDERF_TOLERANCE, 0},
{483, 3201092813u, 3210320282u, 3201092813u, 0, REMAINDERF_TOLERANCE, 0},
{484, 3201092813u, 3209481421u, 3201092813u, 0, REMAINDERF_TOLERANCE, 0},
{485, 3201092813u, 3208642560u, 1051931443u, 0, REMAINDERF_TOLERANCE, 0},
{486, 3201092813u, 3207803699u, 1050253721u, 0, REMAINDERF_TOLERANCE, 0},
{487, 3201092813u, 3206964838u, 1048575998u, 0, REMAINDERF_TOLERANCE, 0},
{488, 3201092813u, 3206125978u, 1045220558u, 0, REMAINDERF_TOLERANCE, 0},
{489, 3201092813u, 3205287117u, 1041865114u, 0, REMAINDERF_TOLERANCE, 0},
{490, 3201092813u, 3204448256u, 1036831948u, 0, REMAINDERF_TOLERANCE, 0},
{491, 3201092813u, 3202770534u, 1028443336u, 0, REMAINDERF_TOLERANCE, 0},
{492, 3201092813u, 3201092813u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{493, 3201092813u, 3199415091u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{494, 3201092813u, 3197737370u, 3184315596u, 0, REMAINDERF_TOLERANCE, 0},
{495, 3201092813u, 3196059648u, 1036831948u, 0, REMAINDERF_TOLERANCE, 0},
{496, 3201092813u, 3192704205u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{497, 3201092813u, 3189348762u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{498, 3201092813u, 3184315597u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{499, 3201092813u, 3175926989u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{500, 3201092813u, 632815616u, 2751463424u, 0, REMAINDERF_TOLERANCE, 0},
{501, 3201092813u, 1028443341u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{502, 3201092813u, 1036831949u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{503, 3201092813u, 1041865114u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{504, 3201092813u, 1045220557u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{505, 3201092813u, 1048576000u, 1036831948u, 0, REMAINDERF_TOLERANCE, 0},
{506, 3201092813u, 1050253722u, 3184315596u, 0, REMAINDERF_TOLERANCE, 0},
{507, 3201092813u, 1051931443u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{508, 3201092813u, 1053609165u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{509, 3201092813u, 1055286886u, 1028443336u, 0, REMAINDERF_TOLERANCE, 0},
{510, 3201092813u, 1056964608u, 1036831948u, 0, REMAINDERF_TOLERANCE, 0},
{511, 3201092813u, 1057803469u, 1041865114u, 0, REMAINDERF_TOLERANCE, 0},
{512, 3201092813u, 1058642330u, 1045220558u, 0, REMAINDERF_TOLERANCE, 0},
{513, 3201092813u, 1059481190u, 1048575998u, 0, REMAINDERF_TOLERANCE, 0},
{514, 3201092813u, 1060320051u, 1050253721u, 0, REMAINDERF_TOLERANCE, 0},
{515, 3201092813u, 1061158912u, 1051931443u, 0, REMAINDERF_TOLERANCE, 0},
{516, 3201092813u, 1061997773u, 3201092813u, 0, REMAINDERF_TOLERANCE, 0},
{517, 3201092813u, 1062836634u, 3201092813u, 0, REMAINDERF_TOLERANCE, 0},
{518, 3201092813u, 1063675494u, 3201092813u, 0, REMAINDERF_TOLERANCE, 0},
{519, 3201092813u, 1064514355u, 3201092813u, 0, REMAINDERF_TOLERANCE, 0},
{520, 3199415091u, 3212836864u, 3199415091u, 0, REMAINDERF_TOLERANCE, 0},
{521, 3199415091u, 3211998003u, 3199415091u, 0, REMAINDERF_TOLERANCE, 0},
{522, 3199415091u, 3211159142u, 3199415091u, 0, REMAINDERF_TOLERANCE, 0},
{523, 3199415091u, 3210320282u, 3199415091u, 0, REMAINDERF_TOLERANCE, 0},
{524, 3199415091u, 3209481421u, 3199415091u, 0, REMAINDERF_TOLERANCE, 0},
{525, 3199415091u, 3208642560u, 3199415091u, 0, REMAINDERF_TOLERANCE, 0},
{526, 3199415091u, 3207803699u, 3199415091u, 0, REMAINDERF_TOLERANCE, 0},
{527, 3199415091u, 3206964838u, 1050253721u, 0, REMAINDERF_TOLERANCE, 0},
{528, 3199415091u, 3206125978u, 1048576001u, 0, REMAINDERF_TOLERANCE, 0},
{529, 3199415091u, 3205287117u, 1045220558u, 0, REMAINDERF_TOLERANCE, 0},
{530, 3199415091u, 3204448256u, 1041865114u, 0, REMAINDERF_TOLERANCE, 0},
{531, 3199415091u, 3202770534u, 1036831948u, 0, REMAINDERF_TOLERANCE, 0},
{532, 3199415091u, 3201092813u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{533, 3199415091u, 3199415091u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{534, 3199415091u, 3197737370u, 3175926984u, 0, REMAINDERF_TOLERANCE, 0},
{535, 3199415091u, 3196059648u, 3184315596u, 0, REMAINDERF_TOLERANCE, 0},
{536, 3199415091u, 3192704205u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{537, 3199415091u, 3189348762u, 3175926984u, 0, REMAINDERF_TOLERANCE, 0},
{538, 3199415091u, 3184315597u, 3175926986u, 0, REMAINDERF_TOLERANCE, 0},
{539, 3199415091u, 3175926989u, 843055104u, 0, REMAINDERF_TOLERANCE, 0},
{540, 3199415091u, 632815616u, 2771386368u, 0, REMAINDERF_TOLERANCE, 0},
{541, 3199415091u, 1028443341u, 843055104u, 0, REMAINDERF_TOLERANCE, 0},
{542, 3199415091u, 1036831949u, 3175926986u, 0, REMAINDERF_TOLERANCE, 0},
{543, 3199415091u, 1041865114u, 3175926984u, 0, REMAINDERF_TOLERANCE, 0},
{544, 3199415091u, 1045220557u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{545, 3199415091u, 1048576000u, 3184315596u, 0, REMAINDERF_TOLERANCE, 0},
{546, 3199415091u, 1050253722u, 3175926984u, 0, REMAINDERF_TOLERANCE, 0},
{547, 3199415091u, 1051931443u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{548, 3199415091u, 1053609165u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{549, 3199415091u, 1055286886u, 1036831948u, 0, REMAINDERF_TOLERANCE, 0},
{550, 3199415091u, 1056964608u, 1041865114u, 0, REMAINDERF_TOLERANCE, 0},
{551, 3199415091u, 1057803469u, 1045220558u, 0, REMAINDERF_TOLERANCE, 0},
{552, 3199415091u, 1058642330u, 1048576001u, 0, REMAINDERF_TOLERANCE, 0},
{553, 3199415091u, 1059481190u, 1050253721u, 0, REMAINDERF_TOLERANCE, 0},
{554, 3199415091u, 1060320051u, 3199415091u, 0, REMAINDERF_TOLERANCE, 0},
{555, 3199415091u, 1061158912u, 3199415091u, 0, REMAINDERF_TOLERANCE, 0},
{556, 3199415091u, 1061997773u, 3199415091u, 0, REMAINDERF_TOLERANCE, 0},
{557, 3199415091u, 1062836634u, 3199415091u, 0, REMAINDERF_TOLERANCE, 0},
{558, 3199415091u, 1063675494u, 3199415091u, 0, REMAINDERF_TOLERANCE, 0},
{559, 3199415091u, 1064514355u, 3199415091u, 0, REMAINDERF_TOLERANCE, 0},
{560, 3197737370u, 3212836864u, 3197737370u, 0, REMAINDERF_TOLERANCE, 0},
{561, 3197737370u, 3211998003u, 3197737370u, 0, REMAINDERF_TOLERANCE, 0},
{562, 3197737370u, 3211159142u, 3197737370u, 0, REMAINDERF_TOLERANCE, 0},
{563, 3197737370u, 3210320282u, 3197737370u, 0, REMAINDERF_TOLERANCE, 0},
{564, 3197737370u, 3209481421u, 3197737370u, 0, REMAINDERF_TOLERANCE, 0},
{565, 3197737370u, 3208642560u, 3197737370u, 0, REMAINDERF_TOLERANCE, 0},
{566, 3197737370u, 3207803699u, 3197737370u, 0, REMAINDERF_TOLERANCE, 0},
{567, 3197737370u, 3206964838u, 3197737370u, 0, REMAINDERF_TOLERANCE, 0},
{568, 3197737370u, 3206125978u, 3197737370u, 0, REMAINDERF_TOLERANCE, 0},
{569, 3197737370u, 3205287117u, 1048576000u, 0, REMAINDERF_TOLERANCE, 0},
{570, 3197737370u, 3204448256u, 1045220556u, 0, REMAINDERF_TOLERANCE, 0},
{571, 3197737370u, 3202770534u, 1041865112u, 0, REMAINDERF_TOLERANCE, 0},
{572, 3197737370u, 3201092813u, 1036831948u, 0, REMAINDERF_TOLERANCE, 0},
{573, 3197737370u, 3199415091u, 1028443336u, 0, REMAINDERF_TOLERANCE, 0},
{574, 3197737370u, 3197737370u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{575, 3197737370u, 3196059648u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{576, 3197737370u, 3192704205u, 1036831948u, 0, REMAINDERF_TOLERANCE, 0},
{577, 3197737370u, 3189348762u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{578, 3197737370u, 3184315597u, 2986344448u, 0, REMAINDERF_TOLERANCE, 0},
{579, 3197737370u, 3175926989u, 2986344448u, 0, REMAINDERF_TOLERANCE, 0},
{580, 3197737370u, 632815616u, 2755657728u, 0, REMAINDERF_TOLERANCE, 0},
{581, 3197737370u, 1028443341u, 2986344448u, 0, REMAINDERF_TOLERANCE, 0},
{582, 3197737370u, 1036831949u, 2986344448u, 0, REMAINDERF_TOLERANCE, 0},
{583, 3197737370u, 1041865114u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{584, 3197737370u, 1045220557u, 1036831948u, 0, REMAINDERF_TOLERANCE, 0},
{585, 3197737370u, 1048576000u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{586, 3197737370u, 1050253722u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{587, 3197737370u, 1051931443u, 1028443336u, 0, REMAINDERF_TOLERANCE, 0},
{588, 3197737370u, 1053609165u, 1036831948u, 0, REMAINDERF_TOLERANCE, 0},
{589, 3197737370u, 1055286886u, 1041865112u, 0, REMAINDERF_TOLERANCE, 0},
{590, 3197737370u, 1056964608u, 1045220556u, 0, REMAINDERF_TOLERANCE, 0},
{591, 3197737370u, 1057803469u, 1048576000u, 0, REMAINDERF_TOLERANCE, 0},
{592, 3197737370u, 1058642330u, 3197737370u, 0, REMAINDERF_TOLERANCE, 0},
{593, 3197737370u, 1059481190u, 3197737370u, 0, REMAINDERF_TOLERANCE, 0},
{594, 3197737370u, 1060320051u, 3197737370u, 0, REMAINDERF_TOLERANCE, 0},
{595, 3197737370u, 1061158912u, 3197737370u, 0, REMAINDERF_TOLERANCE, 0},
{596, 3197737370u, 1061997773u, 3197737370u, 0, REMAINDERF_TOLERANCE, 0},
{597, 3197737370u, 1062836634u, 3197737370u, 0, REMAINDERF_TOLERANCE, 0},
{598, 3197737370u, 1063675494u, 3197737370u, 0, REMAINDERF_TOLERANCE, 0},
{599, 3197737370u, 1064514355u, 3197737370u, 0, REMAINDERF_TOLERANCE, 0},
{600, 3196059648u, 3212836864u, 3196059648u, 0, REMAINDERF_TOLERANCE, 0},
{601, 3196059648u, 3211998003u, 3196059648u, 0, REMAINDERF_TOLERANCE, 0},
{602, 3196059648u, 3211159142u, 3196059648u, 0, REMAINDERF_TOLERANCE, 0},
{603, 3196059648u, 3210320282u, 3196059648u, 0, REMAINDERF_TOLERANCE, 0},
{604, 3196059648u, 3209481421u, 3196059648u, 0, REMAINDERF_TOLERANCE, 0},
{605, 3196059648u, 3208642560u, 3196059648u, 0, REMAINDERF_TOLERANCE, 0},
{606, 3196059648u, 3207803699u, 3196059648u, 0, REMAINDERF_TOLERANCE, 0},
{607, 3196059648u, 3206964838u, 3196059648u, 0, REMAINDERF_TOLERANCE, 0},
{608, 3196059648u, 3206125978u, 3196059648u, 0, REMAINDERF_TOLERANCE, 0},
{609, 3196059648u, 3205287117u, 3196059648u, 0, REMAINDERF_TOLERANCE, 0},
{610, 3196059648u, 3204448256u, 3196059648u, 0, REMAINDERF_TOLERANCE, 0},
{611, 3196059648u, 3202770534u, 1045220556u, 0, REMAINDERF_TOLERANCE, 0},
{612, 3196059648u, 3201092813u, 1041865114u, 0, REMAINDERF_TOLERANCE, 0},
{613, 3196059648u, 3199415091u, 1036831948u, 0, REMAINDERF_TOLERANCE, 0},
{614, 3196059648u, 3197737370u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{615, 3196059648u, 3196059648u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{616, 3196059648u, 3192704205u, 3175926988u, 0, REMAINDERF_TOLERANCE, 0},
{617, 3196059648u, 3189348762u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{618, 3196059648u, 3184315597u, 3175926988u, 0, REMAINDERF_TOLERANCE, 0},
{619, 3196059648u, 3175926989u, 830472192u, 0, REMAINDERF_TOLERANCE, 0},
{620, 3196059648u, 632815616u, 623902720u, 0, REMAINDERF_TOLERANCE, 0},
{621, 3196059648u, 1028443341u, 830472192u, 0, REMAINDERF_TOLERANCE, 0},
{622, 3196059648u, 1036831949u, 3175926988u, 0, REMAINDERF_TOLERANCE, 0},
{623, 3196059648u, 1041865114u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{624, 3196059648u, 1045220557u, 3175926988u, 0, REMAINDERF_TOLERANCE, 0},
{625, 3196059648u, 1048576000u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{626, 3196059648u, 1050253722u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{627, 3196059648u, 1051931443u, 1036831948u, 0, REMAINDERF_TOLERANCE, 0},
{628, 3196059648u, 1053609165u, 1041865114u, 0, REMAINDERF_TOLERANCE, 0},
{629, 3196059648u, 1055286886u, 1045220556u, 0, REMAINDERF_TOLERANCE, 0},
{630, 3196059648u, 1056964608u, 3196059648u, 0, REMAINDERF_TOLERANCE, 0},
{631, 3196059648u, 1057803469u, 3196059648u, 0, REMAINDERF_TOLERANCE, 0},
{632, 3196059648u, 1058642330u, 3196059648u, 0, REMAINDERF_TOLERANCE, 0},
{633, 3196059648u, 1059481190u, 3196059648u, 0, REMAINDERF_TOLERANCE, 0},
{634, 3196059648u, 1060320051u, 3196059648u, 0, REMAINDERF_TOLERANCE, 0},
{635, 3196059648u, 1061158912u, 3196059648u, 0, REMAINDERF_TOLERANCE, 0},
{636, 3196059648u, 1061997773u, 3196059648u, 0, REMAINDERF_TOLERANCE, 0},
{637, 3196059648u, 1062836634u, 3196059648u, 0, REMAINDERF_TOLERANCE, 0},
{638, 3196059648u, 1063675494u, 3196059648u, 0, REMAINDERF_TOLERANCE, 0},
{639, 3196059648u, 1064514355u, 3196059648u, 0, REMAINDERF_TOLERANCE, 0},
{640, 3192704205u, 3212836864u, 3192704205u, 0, REMAINDERF_TOLERANCE, 0},
{641, 3192704205u, 3211998003u, 3192704205u, 0, REMAINDERF_TOLERANCE, 0},
{642, 3192704205u, 3211159142u, 3192704205u, 0, REMAINDERF_TOLERANCE, 0},
{643, 3192704205u, 3210320282u, 3192704205u, 0, REMAINDERF_TOLERANCE, 0},
{644, 3192704205u, 3209481421u, 3192704205u, 0, REMAINDERF_TOLERANCE, 0},
{645, 3192704205u, 3208642560u, 3192704205u, 0, REMAINDERF_TOLERANCE, 0},
{646, 3192704205u, 3207803699u, 3192704205u, 0, REMAINDERF_TOLERANCE, 0},
{647, 3192704205u, 3206964838u, 3192704205u, 0, REMAINDERF_TOLERANCE, 0},
{648, 3192704205u, 3206125978u, 3192704205u, 0, REMAINDERF_TOLERANCE, 0},
{649, 3192704205u, 3205287117u, 3192704205u, 0, REMAINDERF_TOLERANCE, 0},
{650, 3192704205u, 3204448256u, 3192704205u, 0, REMAINDERF_TOLERANCE, 0},
{651, 3192704205u, 3202770534u, 3192704205u, 0, REMAINDERF_TOLERANCE, 0},
{652, 3192704205u, 3201092813u, 3192704205u, 0, REMAINDERF_TOLERANCE, 0},
{653, 3192704205u, 3199415091u, 1041865113u, 0, REMAINDERF_TOLERANCE, 0},
{654, 3192704205u, 3197737370u, 1036831950u, 0, REMAINDERF_TOLERANCE, 0},
{655, 3192704205u, 3196059648u, 1028443340u, 0, REMAINDERF_TOLERANCE, 0},
{656, 3192704205u, 3192704205u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{657, 3192704205u, 3189348762u, 3175926988u, 0, REMAINDERF_TOLERANCE, 0},
{658, 3192704205u, 3184315597u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{659, 3192704205u, 3175926989u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{660, 3192704205u, 632815616u, 2743074816u, 0, REMAINDERF_TOLERANCE, 0},
{661, 3192704205u, 1028443341u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{662, 3192704205u, 1036831949u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{663, 3192704205u, 1041865114u, 3175926988u, 0, REMAINDERF_TOLERANCE, 0},
{664, 3192704205u, 1045220557u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{665, 3192704205u, 1048576000u, 1028443340u, 0, REMAINDERF_TOLERANCE, 0},
{666, 3192704205u, 1050253722u, 1036831950u, 0, REMAINDERF_TOLERANCE, 0},
{667, 3192704205u, 1051931443u, 1041865113u, 0, REMAINDERF_TOLERANCE, 0},
{668, 3192704205u, 1053609165u, 3192704205u, 0, REMAINDERF_TOLERANCE, 0},
{669, 3192704205u, 1055286886u, 3192704205u, 0, REMAINDERF_TOLERANCE, 0},
{670, 3192704205u, 1056964608u, 3192704205u, 0, REMAINDERF_TOLERANCE, 0},
{671, 3192704205u, 1057803469u, 3192704205u, 0, REMAINDERF_TOLERANCE, 0},
{672, 3192704205u, 1058642330u, 3192704205u, 0, REMAINDERF_TOLERANCE, 0},
{673, 3192704205u, 1059481190u, 3192704205u, 0, REMAINDERF_TOLERANCE, 0},
{674, 3192704205u, 1060320051u, 3192704205u, 0, REMAINDERF_TOLERANCE, 0},
{675, 3192704205u, 1061158912u, 3192704205u, 0, REMAINDERF_TOLERANCE, 0},
{676, 3192704205u, 1061997773u, 3192704205u, 0, REMAINDERF_TOLERANCE, 0},
{677, 3192704205u, 1062836634u, 3192704205u, 0, REMAINDERF_TOLERANCE, 0},
{678, 3192704205u, 1063675494u, 3192704205u, 0, REMAINDERF_TOLERANCE, 0},
{679, 3192704205u, 1064514355u, 3192704205u, 0, REMAINDERF_TOLERANCE, 0},
{680, 3189348762u, 3212836864u, 3189348762u, 0, REMAINDERF_TOLERANCE, 0},
{681, 3189348762u, 3211998003u, 3189348762u, 0, REMAINDERF_TOLERANCE, 0},
{682, 3189348762u, 3211159142u, 3189348762u, 0, REMAINDERF_TOLERANCE, 0},
{683, 3189348762u, 3210320282u, 3189348762u, 0, REMAINDERF_TOLERANCE, 0},
{684, 3189348762u, 3209481421u, 3189348762u, 0, REMAINDERF_TOLERANCE, 0},
{685, 3189348762u, 3208642560u, 3189348762u, 0, REMAINDERF_TOLERANCE, 0},
{686, 3189348762u, 3207803699u, 3189348762u, 0, REMAINDERF_TOLERANCE, 0},
{687, 3189348762u, 3206964838u, 3189348762u, 0, REMAINDERF_TOLERANCE, 0},
{688, 3189348762u, 3206125978u, 3189348762u, 0, REMAINDERF_TOLERANCE, 0},
{689, 3189348762u, 3205287117u, 3189348762u, 0, REMAINDERF_TOLERANCE, 0},
{690, 3189348762u, 3204448256u, 3189348762u, 0, REMAINDERF_TOLERANCE, 0},
{691, 3189348762u, 3202770534u, 3189348762u, 0, REMAINDERF_TOLERANCE, 0},
{692, 3189348762u, 3201092813u, 3189348762u, 0, REMAINDERF_TOLERANCE, 0},
{693, 3189348762u, 3199415091u, 3189348762u, 0, REMAINDERF_TOLERANCE, 0},
{694, 3189348762u, 3197737370u, 3189348762u, 0, REMAINDERF_TOLERANCE, 0},
{695, 3189348762u, 3196059648u, 1036831948u, 0, REMAINDERF_TOLERANCE, 0},
{696, 3189348762u, 3192704205u, 1028443340u, 0, REMAINDERF_TOLERANCE, 0},
{697, 3189348762u, 3189348762u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{698, 3189348762u, 3184315597u, 1028443340u, 0, REMAINDERF_TOLERANCE, 0},
{699, 3189348762u, 3175926989u, 2977955840u, 0, REMAINDERF_TOLERANCE, 0},
{700, 3189348762u, 632815616u, 622854144u, 0, REMAINDERF_TOLERANCE, 0},
{701, 3189348762u, 1028443341u, 2977955840u, 0, REMAINDERF_TOLERANCE, 0},
{702, 3189348762u, 1036831949u, 1028443340u, 0, REMAINDERF_TOLERANCE, 0},
{703, 3189348762u, 1041865114u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{704, 3189348762u, 1045220557u, 1028443340u, 0, REMAINDERF_TOLERANCE, 0},
{705, 3189348762u, 1048576000u, 1036831948u, 0, REMAINDERF_TOLERANCE, 0},
{706, 3189348762u, 1050253722u, 3189348762u, 0, REMAINDERF_TOLERANCE, 0},
{707, 3189348762u, 1051931443u, 3189348762u, 0, REMAINDERF_TOLERANCE, 0},
{708, 3189348762u, 1053609165u, 3189348762u, 0, REMAINDERF_TOLERANCE, 0},
{709, 3189348762u, 1055286886u, 3189348762u, 0, REMAINDERF_TOLERANCE, 0},
{710, 3189348762u, 1056964608u, 3189348762u, 0, REMAINDERF_TOLERANCE, 0},
{711, 3189348762u, 1057803469u, 3189348762u, 0, REMAINDERF_TOLERANCE, 0},
{712, 3189348762u, 1058642330u, 3189348762u, 0, REMAINDERF_TOLERANCE, 0},
{713, 3189348762u, 1059481190u, 3189348762u, 0, REMAINDERF_TOLERANCE, 0},
{714, 3189348762u, 1060320051u, 3189348762u, 0, REMAINDERF_TOLERANCE, 0},
{715, 3189348762u, 1061158912u, 3189348762u, 0, REMAINDERF_TOLERANCE, 0},
{716, 3189348762u, 1061997773u, 3189348762u, 0, REMAINDERF_TOLERANCE, 0},
{717, 3189348762u, 1062836634u, 3189348762u, 0, REMAINDERF_TOLERANCE, 0},
{718, 3189348762u, 1063675494u, 3189348762u, 0, REMAINDERF_TOLERANCE, 0},
{719, 3189348762u, 1064514355u, 3189348762u, 0, REMAINDERF_TOLERANCE, 0},
{720, 3184315597u, 3212836864u, 3184315597u, 0, REMAINDERF_TOLERANCE, 0},
{721, 3184315597u, 3211998003u, 3184315597u, 0, REMAINDERF_TOLERANCE, 0},
{722, 3184315597u, 3211159142u, 3184315597u, 0, REMAINDERF_TOLERANCE, 0},
{723, 3184315597u, 3210320282u, 3184315597u, 0, REMAINDERF_TOLERANCE, 0},
{724, 3184315597u, 3209481421u, 3184315597u, 0, REMAINDERF_TOLERANCE, 0},
{725, 3184315597u, 3208642560u, 3184315597u, 0, REMAINDERF_TOLERANCE, 0},
{726, 3184315597u, 3207803699u, 3184315597u, 0, REMAINDERF_TOLERANCE, 0},
{727, 3184315597u, 3206964838u, 3184315597u, 0, REMAINDERF_TOLERANCE, 0},
{728, 3184315597u, 3206125978u, 3184315597u, 0, REMAINDERF_TOLERANCE, 0},
{729, 3184315597u, 3205287117u, 3184315597u, 0, REMAINDERF_TOLERANCE, 0},
{730, 3184315597u, 3204448256u, 3184315597u, 0, REMAINDERF_TOLERANCE, 0},
{731, 3184315597u, 3202770534u, 3184315597u, 0, REMAINDERF_TOLERANCE, 0},
{732, 3184315597u, 3201092813u, 3184315597u, 0, REMAINDERF_TOLERANCE, 0},
{733, 3184315597u, 3199415091u, 3184315597u, 0, REMAINDERF_TOLERANCE, 0},
{734, 3184315597u, 3197737370u, 3184315597u, 0, REMAINDERF_TOLERANCE, 0},
{735, 3184315597u, 3196059648u, 3184315597u, 0, REMAINDERF_TOLERANCE, 0},
{736, 3184315597u, 3192704205u, 3184315597u, 0, REMAINDERF_TOLERANCE, 0},
{737, 3184315597u, 3189348762u, 1028443342u, 0, REMAINDERF_TOLERANCE, 0},
{738, 3184315597u, 3184315597u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{739, 3184315597u, 3175926989u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{740, 3184315597u, 632815616u, 623902720u, 0, REMAINDERF_TOLERANCE, 0},
{741, 3184315597u, 1028443341u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{742, 3184315597u, 1036831949u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{743, 3184315597u, 1041865114u, 1028443342u, 0, REMAINDERF_TOLERANCE, 0},
{744, 3184315597u, 1045220557u, 3184315597u, 0, REMAINDERF_TOLERANCE, 0},
{745, 3184315597u, 1048576000u, 3184315597u, 0, REMAINDERF_TOLERANCE, 0},
{746, 3184315597u, 1050253722u, 3184315597u, 0, REMAINDERF_TOLERANCE, 0},
{747, 3184315597u, 1051931443u, 3184315597u, 0, REMAINDERF_TOLERANCE, 0},
{748, 3184315597u, 1053609165u, 3184315597u, 0, REMAINDERF_TOLERANCE, 0},
{749, 3184315597u, 1055286886u, 3184315597u, 0, REMAINDERF_TOLERANCE, 0},
{750, 3184315597u, 1056964608u, 3184315597u, 0, REMAINDERF_TOLERANCE, 0},
{751, 3184315597u, 1057803469u, 3184315597u, 0, REMAINDERF_TOLERANCE, 0},
{752, 3184315597u, 1058642330u, 3184315597u, 0, REMAINDERF_TOLERANCE, 0},
{753, 3184315597u, 1059481190u, 3184315597u, 0, REMAINDERF_TOLERANCE, 0},
{754, 3184315597u, 1060320051u, 3184315597u, 0, REMAINDERF_TOLERANCE, 0},
{755, 3184315597u, 1061158912u, 3184315597u, 0, REMAINDERF_TOLERANCE, 0},
{756, 3184315597u, 1061997773u, 3184315597u, 0, REMAINDERF_TOLERANCE, 0},
{757, 3184315597u, 1062836634u, 3184315597u, 0, REMAINDERF_TOLERANCE, 0},
{758, 3184315597u, 1063675494u, 3184315597u, 0, REMAINDERF_TOLERANCE, 0},
{759, 3184315597u, 1064514355u, 3184315597u, 0, REMAINDERF_TOLERANCE, 0},
{760, 3175926989u, 3212836864u, 3175926989u, 0, REMAINDERF_TOLERANCE, 0},
{761, 3175926989u, 3211998003u, 3175926989u, 0, REMAINDERF_TOLERANCE, 0},
{762, 3175926989u, 3211159142u, 3175926989u, 0, REMAINDERF_TOLERANCE, 0},
{763, 3175926989u, 3210320282u, 3175926989u, 0, REMAINDERF_TOLERANCE, 0},
{764, 3175926989u, 3209481421u, 3175926989u, 0, REMAINDERF_TOLERANCE, 0},
{765, 3175926989u, 3208642560u, 3175926989u, 0, REMAINDERF_TOLERANCE, 0},
{766, 3175926989u, 3207803699u, 3175926989u, 0, REMAINDERF_TOLERANCE, 0},
{767, 3175926989u, 3206964838u, 3175926989u, 0, REMAINDERF_TOLERANCE, 0},
{768, 3175926989u, 3206125978u, 3175926989u, 0, REMAINDERF_TOLERANCE, 0},
{769, 3175926989u, 3205287117u, 3175926989u, 0, REMAINDERF_TOLERANCE, 0},
{770, 3175926989u, 3204448256u, 3175926989u, 0, REMAINDERF_TOLERANCE, 0},
{771, 3175926989u, 3202770534u, 3175926989u, 0, REMAINDERF_TOLERANCE, 0},
{772, 3175926989u, 3201092813u, 3175926989u, 0, REMAINDERF_TOLERANCE, 0},
{773, 3175926989u, 3199415091u, 3175926989u, 0, REMAINDERF_TOLERANCE, 0},
{774, 3175926989u, 3197737370u, 3175926989u, 0, REMAINDERF_TOLERANCE, 0},
{775, 3175926989u, 3196059648u, 3175926989u, 0, REMAINDERF_TOLERANCE, 0},
{776, 3175926989u, 3192704205u, 3175926989u, 0, REMAINDERF_TOLERANCE, 0},
{777, 3175926989u, 3189348762u, 3175926989u, 0, REMAINDERF_TOLERANCE, 0},
{778, 3175926989u, 3184315597u, 3175926989u, 0, REMAINDERF_TOLERANCE, 0},
{779, 3175926989u, 3175926989u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{780, 3175926989u, 632815616u, 2764046336u, 0, REMAINDERF_TOLERANCE, 0},
{781, 3175926989u, 1028443341u, 2147483648u, 0, REMAINDERF_TOLERANCE, 0},
{782, 3175926989u, 1036831949u, 3175926989u, 0, REMAINDERF_TOLERANCE, 0},
{783, 3175926989u, 1041865114u, 3175926989u, 0, REMAINDERF_TOLERANCE, 0},
{784, 3175926989u, 1045220557u, 3175926989u, 0, REMAINDERF_TOLERANCE, 0},
{785, 3175926989u, 1048576000u, 3175926989u, 0, REMAINDERF_TOLERANCE, 0},
{786, 3175926989u, 1050253722u, 3175926989u, 0, REMAINDERF_TOLERANCE, 0},
{787, 3175926989u, 1051931443u, 3175926989u, 0, REMAINDERF_TOLERANCE, 0},
{788, 3175926989u, 1053609165u, 3175926989u, 0, REMAINDERF_TOLERANCE, 0},
{789, 3175926989u, 1055286886u, 3175926989u, 0, REMAINDERF_TOLERANCE, 0},
{790, 3175926989u, 1056964608u, 3175926989u, 0, REMAINDERF_TOLERANCE, 0},
{791, 3175926989u, 1057803469u, 3175926989u, 0, REMAINDERF_TOLERANCE, 0},
{792, 3175926989u, 1058642330u, 3175926989u, 0, REMAINDERF_TOLERANCE, 0},
{793, 3175926989u, 1059481190u, 3175926989u, 0, REMAINDERF_TOLERANCE, 0},
{794, 3175926989u, 1060320051u, 3175926989u, 0, REMAINDERF_TOLERANCE, 0},
{795, 3175926989u, 1061158912u, 3175926989u, 0, REMAINDERF_TOLERANCE, 0},
{796, 3175926989u, 1061997773u, 3175926989u, 0, REMAINDERF_TOLERANCE, 0},
{797, 3175926989u, 1062836634u, 3175926989u, 0, REMAINDERF_TOLERANCE, 0},
{798, 3175926989u, 1063675494u, 3175926989u, 0, REMAINDERF_TOLERANCE, 0},
{799, 3175926989u, 1064514355u, 3175926989u, 0, REMAINDERF_TOLERANCE, 0},
{800, 1028443341u, 3212836864u, 1028443341u, 0, REMAINDERF_TOLERANCE, 0},
{801, 1028443341u, 3211998003u, 1028443341u, 0, REMAINDERF_TOLERANCE, 0},
{802, 1028443341u, 3211159142u, 1028443341u, 0, REMAINDERF_TOLERANCE, 0},
{803, 1028443341u, 3210320282u, 1028443341u, 0, REMAINDERF_TOLERANCE, 0},
{804, 1028443341u, 3209481421u, 1028443341u, 0, REMAINDERF_TOLERANCE, 0},
{805, 1028443341u, 3208642560u, 1028443341u, 0, REMAINDERF_TOLERANCE, 0},
{806, 1028443341u, 3207803699u, 1028443341u, 0, REMAINDERF_TOLERANCE, 0},
{807, 1028443341u, 3206964838u, 1028443341u, 0, REMAINDERF_TOLERANCE, 0},
{808, 1028443341u, 3206125978u, 1028443341u, 0, REMAINDERF_TOLERANCE, 0},
{809, 1028443341u, 3205287117u, 1028443341u, 0, REMAINDERF_TOLERANCE, 0},
{810, 1028443341u, 3204448256u, 1028443341u, 0, REMAINDERF_TOLERANCE, 0},
{811, 1028443341u, 3202770534u, 1028443341u, 0, REMAINDERF_TOLERANCE, 0},
{812, 1028443341u, 3201092813u, 1028443341u, 0, REMAINDERF_TOLERANCE, 0},
{813, 1028443341u, 3199415091u, 1028443341u, 0, REMAINDERF_TOLERANCE, 0},
{814, 1028443341u, 3197737370u, 1028443341u, 0, REMAINDERF_TOLERANCE, 0},
{815, 1028443341u, 3196059648u, 1028443341u, 0, REMAINDERF_TOLERANCE, 0},
{816, 1028443341u, 3192704205u, 1028443341u, 0, REMAINDERF_TOLERANCE, 0},
{817, 1028443341u, 3189348762u, 1028443341u, 0, REMAINDERF_TOLERANCE, 0},
{818, 1028443341u, 3184315597u, 1028443341u, 0, REMAINDERF_TOLERANCE, 0},
{819, 1028443341u, 3175926989u, 0u, 0, REMAINDERF_TOLERANCE, 0},
{820, 1028443341u, 632815616u, 616562688u, 0, REMAINDERF_TOLERANCE, 0},
{821, 1028443341u, 1028443341u, 0u, 0, REMAINDERF_TOLERANCE, 0},
{822, 1028443341u, 1036831949u, 1028443341u, 0, REMAINDERF_TOLERANCE, 0},
{823, 1028443341u, 1041865114u, 1028443341u, 0, REMAINDERF_TOLERANCE, 0},
{824, 1028443341u, 1045220557u, 1028443341u, 0, REMAINDERF_TOLERANCE, 0},
{825, 1028443341u, 1048576000u, 1028443341u, 0, REMAINDERF_TOLERANCE, 0},
{826, 1028443341u, 1050253722u, 1028443341u, 0, REMAINDERF_TOLERANCE, 0},
{827, 1028443341u, 1051931443u, 1028443341u, 0, REMAINDERF_TOLERANCE, 0},
{828, 1028443341u, 1053609165u, 1028443341u, 0, REMAINDERF_TOLERANCE, 0},
{829, 1028443341u, 1055286886u, 1028443341u, 0, REMAINDERF_TOLERANCE, 0},
{830, 1028443341u, 1056964608u, 1028443341u, 0, REMAINDERF_TOLERANCE, 0},
{831, 1028443341u, 1057803469u, 1028443341u, 0, REMAINDERF_TOLERANCE, 0},
{832, 1028443341u, 1058642330u, 1028443341u, 0, REMAINDERF_TOLERANCE, 0},
{833, 1028443341u, 1059481190u, 1028443341u, 0, REMAINDERF_TOLERANCE, 0},
{834, 1028443341u, 1060320051u, 1028443341u, 0, REMAINDERF_TOLERANCE, 0},
{835, 1028443341u, 1061158912u, 1028443341u, 0, REMAINDERF_TOLERANCE, 0},
{836, 1028443341u, 1061997773u, 1028443341u, 0, REMAINDERF_TOLERANCE, 0},
{837, 1028443341u, 1062836634u, 1028443341u, 0, REMAINDERF_TOLERANCE, 0},
{838, 1028443341u, 1063675494u, 1028443341u, 0, REMAINDERF_TOLERANCE, 0},
{839, 1028443341u, 1064514355u, 1028443341u, 0, REMAINDERF_TOLERANCE, 0},
{840, 1036831949u, 3212836864u, 1036831949u, 0, REMAINDERF_TOLERANCE, 0},
{841, 1036831949u, 3211998003u, 1036831949u, 0, REMAINDERF_TOLERANCE, 0},
{842, 1036831949u, 3211159142u, 1036831949u, 0, REMAINDERF_TOLERANCE, 0},
{843, 1036831949u, 3210320282u, 1036831949u, 0, REMAINDERF_TOLERANCE, 0},
{844, 1036831949u, 3209481421u, 1036831949u, 0, REMAINDERF_TOLERANCE, 0},
{845, 1036831949u, 3208642560u, 1036831949u, 0, REMAINDERF_TOLERANCE, 0},
{846, 1036831949u, 3207803699u, 1036831949u, 0, REMAINDERF_TOLERANCE, 0},
{847, 1036831949u, 3206964838u, 1036831949u, 0, REMAINDERF_TOLERANCE, 0},
{848, 1036831949u, 3206125978u, 1036831949u, 0, REMAINDERF_TOLERANCE, 0},
{849, 1036831949u, 3205287117u, 1036831949u, 0, REMAINDERF_TOLERANCE, 0},
{850, 1036831949u, 3204448256u, 1036831949u, 0, REMAINDERF_TOLERANCE, 0},
{851, 1036831949u, 3202770534u, 1036831949u, 0, REMAINDERF_TOLERANCE, 0},
{852, 1036831949u, 3201092813u, 1036831949u, 0, REMAINDERF_TOLERANCE, 0},
{853, 1036831949u, 3199415091u, 1036831949u, 0, REMAINDERF_TOLERANCE, 0},
{854, 1036831949u, 3197737370u, 1036831949u, 0, REMAINDERF_TOLERANCE, 0},
{855, 1036831949u, 3196059648u, 1036831949u, 0, REMAINDERF_TOLERANCE, 0},
{856, 1036831949u, 3192704205u, 1036831949u, 0, REMAINDERF_TOLERANCE, 0},
{857, 1036831949u, 3189348762u, 3175926990u, 0, REMAINDERF_TOLERANCE, 0},
{858, 1036831949u, 3184315597u, 0u, 0, REMAINDERF_TOLERANCE, 0},
{859, 1036831949u, 3175926989u, 0u, 0, REMAINDERF_TOLERANCE, 0},
{860, 1036831949u, 632815616u, 2771386368u, 0, REMAINDERF_TOLERANCE, 0},
{861, 1036831949u, 1028443341u, 0u, 0, REMAINDERF_TOLERANCE, 0},
{862, 1036831949u, 1036831949u, 0u, 0, REMAINDERF_TOLERANCE, 0},
{863, 1036831949u, 1041865114u, 3175926990u, 0, REMAINDERF_TOLERANCE, 0},
{864, 1036831949u, 1045220557u, 1036831949u, 0, REMAINDERF_TOLERANCE, 0},
{865, 1036831949u, 1048576000u, 1036831949u, 0, REMAINDERF_TOLERANCE, 0},
{866, 1036831949u, 1050253722u, 1036831949u, 0, REMAINDERF_TOLERANCE, 0},
{867, 1036831949u, 1051931443u, 1036831949u, 0, REMAINDERF_TOLERANCE, 0},
{868, 1036831949u, 1053609165u, 1036831949u, 0, REMAINDERF_TOLERANCE, 0},
{869, 1036831949u, 1055286886u, 1036831949u, 0, REMAINDERF_TOLERANCE, 0},
{870, 1036831949u, 1056964608u, 1036831949u, 0, REMAINDERF_TOLERANCE, 0},
{871, 1036831949u, 1057803469u, 1036831949u, 0, REMAINDERF_TOLERANCE, 0},
{872, 1036831949u, 1058642330u, 1036831949u, 0, REMAINDERF_TOLERANCE, 0},
{873, 1036831949u, 1059481190u, 1036831949u, 0, REMAINDERF_TOLERANCE, 0},
{874, 1036831949u, 1060320051u, 1036831949u, 0, REMAINDERF_TOLERANCE, 0},
{875, 1036831949u, 1061158912u, 1036831949u, 0, REMAINDERF_TOLERANCE, 0},
{876, 1036831949u, 1061997773u, 1036831949u, 0, REMAINDERF_TOLERANCE, 0},
{877, 1036831949u, 1062836634u, 1036831949u, 0, REMAINDERF_TOLERANCE, 0},
{878, 1036831949u, 1063675494u, 1036831949u, 0, REMAINDERF_TOLERANCE, 0},
{879, 1036831949u, 1064514355u, 1036831949u, 0, REMAINDERF_TOLERANCE, 0},
{880, 1041865114u, 3212836864u, 1041865114u, 0, REMAINDERF_TOLERANCE, 0},
{881, 1041865114u, 3211998003u, 1041865114u, 0, REMAINDERF_TOLERANCE, 0},
{882, 1041865114u, 3211159142u, 1041865114u, 0, REMAINDERF_TOLERANCE, 0},
{883, 1041865114u, 3210320282u, 1041865114u, 0, REMAINDERF_TOLERANCE, 0},
{884, 1041865114u, 3209481421u, 1041865114u, 0, REMAINDERF_TOLERANCE, 0},
{885, 1041865114u, 3208642560u, 1041865114u, 0, REMAINDERF_TOLERANCE, 0},
{886, 1041865114u, 3207803699u, 1041865114u, 0, REMAINDERF_TOLERANCE, 0},
{887, 1041865114u, 3206964838u, 1041865114u, 0, REMAINDERF_TOLERANCE, 0},
{888, 1041865114u, 3206125978u, 1041865114u, 0, REMAINDERF_TOLERANCE, 0},
{889, 1041865114u, 3205287117u, 1041865114u, 0, REMAINDERF_TOLERANCE, 0},
{890, 1041865114u, 3204448256u, 1041865114u, 0, REMAINDERF_TOLERANCE, 0},
{891, 1041865114u, 3202770534u, 1041865114u, 0, REMAINDERF_TOLERANCE, 0},
{892, 1041865114u, 3201092813u, 1041865114u, 0, REMAINDERF_TOLERANCE, 0},
{893, 1041865114u, 3199415091u, 1041865114u, 0, REMAINDERF_TOLERANCE, 0},
{894, 1041865114u, 3197737370u, 1041865114u, 0, REMAINDERF_TOLERANCE, 0},
{895, 1041865114u, 3196059648u, 3184315596u, 0, REMAINDERF_TOLERANCE, 0},
{896, 1041865114u, 3192704205u, 3175926988u, 0, REMAINDERF_TOLERANCE, 0},
{897, 1041865114u, 3189348762u, 0u, 0, REMAINDERF_TOLERANCE, 0},
{898, 1041865114u, 3184315597u, 3175926988u, 0, REMAINDERF_TOLERANCE, 0},
{899, 1041865114u, 3175926989u, 830472192u, 0, REMAINDERF_TOLERANCE, 0},
{900, 1041865114u, 632815616u, 2770337792u, 0, REMAINDERF_TOLERANCE, 0},
{901, 1041865114u, 1028443341u, 830472192u, 0, REMAINDERF_TOLERANCE, 0},
{902, 1041865114u, 1036831949u, 3175926988u, 0, REMAINDERF_TOLERANCE, 0},
{903, 1041865114u, 1041865114u, 0u, 0, REMAINDERF_TOLERANCE, 0},
{904, 1041865114u, 1045220557u, 3175926988u, 0, REMAINDERF_TOLERANCE, 0},
{905, 1041865114u, 1048576000u, 3184315596u, 0, REMAINDERF_TOLERANCE, 0},
{906, 1041865114u, 1050253722u, 1041865114u, 0, REMAINDERF_TOLERANCE, 0},
{907, 1041865114u, 1051931443u, 1041865114u, 0, REMAINDERF_TOLERANCE, 0},
{908, 1041865114u, 1053609165u, 1041865114u, 0, REMAINDERF_TOLERANCE, 0},
{909, 1041865114u, 1055286886u, 1041865114u, 0, REMAINDERF_TOLERANCE, 0},
{910, 1041865114u, 1056964608u, 1041865114u, 0, REMAINDERF_TOLERANCE, 0},
{911, 1041865114u, 1057803469u, 1041865114u, 0, REMAINDERF_TOLERANCE, 0},
{912, 1041865114u, 1058642330u, 1041865114u, 0, REMAINDERF_TOLERANCE, 0},
{913, 1041865114u, 1059481190u, 1041865114u, 0, REMAINDERF_TOLERANCE, 0},
{914, 1041865114u, 1060320051u, 1041865114u, 0, REMAINDERF_TOLERANCE, 0},
{915, 1041865114u, 1061158912u, 1041865114u, 0, REMAINDERF_TOLERANCE, 0},
{916, 1041865114u, 1061997773u, 1041865114u, 0, REMAINDERF_TOLERANCE, 0},
{917, 1041865114u, 1062836634u, 1041865114u, 0, REMAINDERF_TOLERANCE, 0},
{918, 1041865114u, 1063675494u, 1041865114u, 0, REMAINDERF_TOLERANCE, 0},
{919, 1041865114u, 1064514355u, 1041865114u, 0, REMAINDERF_TOLERANCE, 0},
{920, 1045220557u, 3212836864u, 1045220557u, 0, REMAINDERF_TOLERANCE, 0},
{921, 1045220557u, 3211998003u, 1045220557u, 0, REMAINDERF_TOLERANCE, 0},
{922, 1045220557u, 3211159142u, 1045220557u, 0, REMAINDERF_TOLERANCE, 0},
{923, 1045220557u, 3210320282u, 1045220557u, 0, REMAINDERF_TOLERANCE, 0},
{924, 1045220557u, 3209481421u, 1045220557u, 0, REMAINDERF_TOLERANCE, 0},
{925, 1045220557u, 3208642560u, 1045220557u, 0, REMAINDERF_TOLERANCE, 0},
{926, 1045220557u, 3207803699u, 1045220557u, 0, REMAINDERF_TOLERANCE, 0},
{927, 1045220557u, 3206964838u, 1045220557u, 0, REMAINDERF_TOLERANCE, 0},
{928, 1045220557u, 3206125978u, 1045220557u, 0, REMAINDERF_TOLERANCE, 0},
{929, 1045220557u, 3205287117u, 1045220557u, 0, REMAINDERF_TOLERANCE, 0},
{930, 1045220557u, 3204448256u, 1045220557u, 0, REMAINDERF_TOLERANCE, 0},
{931, 1045220557u, 3202770534u, 1045220557u, 0, REMAINDERF_TOLERANCE, 0},
{932, 1045220557u, 3201092813u, 1045220557u, 0, REMAINDERF_TOLERANCE, 0},
{933, 1045220557u, 3199415091u, 3189348761u, 0, REMAINDERF_TOLERANCE, 0},
{934, 1045220557u, 3197737370u, 3184315598u, 0, REMAINDERF_TOLERANCE, 0},
{935, 1045220557u, 3196059648u, 3175926988u, 0, REMAINDERF_TOLERANCE, 0},
{936, 1045220557u, 3192704205u, 0u, 0, REMAINDERF_TOLERANCE, 0},
{937, 1045220557u, 3189348762u, 1028443340u, 0, REMAINDERF_TOLERANCE, 0},
{938, 1045220557u, 3184315597u, 0u, 0, REMAINDERF_TOLERANCE, 0},
{939, 1045220557u, 3175926989u, 0u, 0, REMAINDERF_TOLERANCE, 0},
{940, 1045220557u, 632815616u, 595591168u, 0, REMAINDERF_TOLERANCE, 0},
{941, 1045220557u, 1028443341u, 0u, 0, REMAINDERF_TOLERANCE, 0},
{942, 1045220557u, 1036831949u, 0u, 0, REMAINDERF_TOLERANCE, 0},
{943, 1045220557u, 1041865114u, 1028443340u, 0, REMAINDERF_TOLERANCE, 0},
{944, 1045220557u, 1045220557u, 0u, 0, REMAINDERF_TOLERANCE, 0},
{945, 1045220557u, 1048576000u, 3175926988u, 0, REMAINDERF_TOLERANCE, 0},
{946, 1045220557u, 1050253722u, 3184315598u, 0, REMAINDERF_TOLERANCE, 0},
{947, 1045220557u, 1051931443u, 3189348761u, 0, REMAINDERF_TOLERANCE, 0},
{948, 1045220557u, 1053609165u, 1045220557u, 0, REMAINDERF_TOLERANCE, 0},
{949, 1045220557u, 1055286886u, 1045220557u, 0, REMAINDERF_TOLERANCE, 0},
{950, 1045220557u, 1056964608u, 1045220557u, 0, REMAINDERF_TOLERANCE, 0},
{951, 1045220557u, 1057803469u, 1045220557u, 0, REMAINDERF_TOLERANCE, 0},
{952, 1045220557u, 1058642330u, 1045220557u, 0, REMAINDERF_TOLERANCE, 0},
{953, 1045220557u, 1059481190u, 1045220557u, 0, REMAINDERF_TOLERANCE, 0},
{954, 1045220557u, 1060320051u, 1045220557u, 0, REMAINDERF_TOLERANCE, 0},
{955, 1045220557u, 1061158912u, 1045220557u, 0, REMAINDERF_TOLERANCE, 0},
{956, 1045220557u, 1061997773u, 1045220557u, 0, REMAINDERF_TOLERANCE, 0},
{957, 1045220557u, 1062836634u, 1045220557u, 0, REMAINDERF_TOLERANCE, 0},
{958, 1045220557u, 1063675494u, 1045220557u, 0, REMAINDERF_TOLERANCE, 0},
{959, 1045220557u, 1064514355u, 1045220557u, 0, REMAINDERF_TOLERANCE, 0},
{960, 1048576000u, 3212836864u, 1048576000u, 0, REMAINDERF_TOLERANCE, 0},
{961, 1048576000u, 3211998003u, 1048576000u, 0, REMAINDERF_TOLERANCE, 0},
{962, 1048576000u, 3211159142u, 1048576000u, 0, REMAINDERF_TOLERANCE, 0},
{963, 1048576000u, 3210320282u, 1048576000u, 0, REMAINDERF_TOLERANCE, 0},
{964, 1048576000u, 3209481421u, 1048576000u, 0, REMAINDERF_TOLERANCE, 0},
{965, 1048576000u, 3208642560u, 1048576000u, 0, REMAINDERF_TOLERANCE, 0},
{966, 1048576000u, 3207803699u, 1048576000u, 0, REMAINDERF_TOLERANCE, 0},
{967, 1048576000u, 3206964838u, 1048576000u, 0, REMAINDERF_TOLERANCE, 0},
{968, 1048576000u, 3206125978u, 1048576000u, 0, REMAINDERF_TOLERANCE, 0},
{969, 1048576000u, 3205287117u, 1048576000u, 0, REMAINDERF_TOLERANCE, 0},
{970, 1048576000u, 3204448256u, 1048576000u, 0, REMAINDERF_TOLERANCE, 0},
{971, 1048576000u, 3202770534u, 3192704204u, 0, REMAINDERF_TOLERANCE, 0},
{972, 1048576000u, 3201092813u, 3189348762u, 0, REMAINDERF_TOLERANCE, 0},
{973, 1048576000u, 3199415091u, 3184315596u, 0, REMAINDERF_TOLERANCE, 0},
{974, 1048576000u, 3197737370u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{975, 1048576000u, 3196059648u, 0u, 0, REMAINDERF_TOLERANCE, 0},
{976, 1048576000u, 3192704205u, 1028443340u, 0, REMAINDERF_TOLERANCE, 0},
{977, 1048576000u, 3189348762u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{978, 1048576000u, 3184315597u, 1028443340u, 0, REMAINDERF_TOLERANCE, 0},
{979, 1048576000u, 3175926989u, 2977955840u, 0, REMAINDERF_TOLERANCE, 0},
{980, 1048576000u, 632815616u, 2771386368u, 0, REMAINDERF_TOLERANCE, 0},
{981, 1048576000u, 1028443341u, 2977955840u, 0, REMAINDERF_TOLERANCE, 0},
{982, 1048576000u, 1036831949u, 1028443340u, 0, REMAINDERF_TOLERANCE, 0},
{983, 1048576000u, 1041865114u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{984, 1048576000u, 1045220557u, 1028443340u, 0, REMAINDERF_TOLERANCE, 0},
{985, 1048576000u, 1048576000u, 0u, 0, REMAINDERF_TOLERANCE, 0},
{986, 1048576000u, 1050253722u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{987, 1048576000u, 1051931443u, 3184315596u, 0, REMAINDERF_TOLERANCE, 0},
{988, 1048576000u, 1053609165u, 3189348762u, 0, REMAINDERF_TOLERANCE, 0},
{989, 1048576000u, 1055286886u, 3192704204u, 0, REMAINDERF_TOLERANCE, 0},
{990, 1048576000u, 1056964608u, 1048576000u, 0, REMAINDERF_TOLERANCE, 0},
{991, 1048576000u, 1057803469u, 1048576000u, 0, REMAINDERF_TOLERANCE, 0},
{992, 1048576000u, 1058642330u, 1048576000u, 0, REMAINDERF_TOLERANCE, 0},
{993, 1048576000u, 1059481190u, 1048576000u, 0, REMAINDERF_TOLERANCE, 0},
{994, 1048576000u, 1060320051u, 1048576000u, 0, REMAINDERF_TOLERANCE, 0},
{995, 1048576000u, 1061158912u, 1048576000u, 0, REMAINDERF_TOLERANCE, 0},
{996, 1048576000u, 1061997773u, 1048576000u, 0, REMAINDERF_TOLERANCE, 0},
{997, 1048576000u, 1062836634u, 1048576000u, 0, REMAINDERF_TOLERANCE, 0},
{998, 1048576000u, 1063675494u, 1048576000u, 0, REMAINDERF_TOLERANCE, 0},
{999, 1048576000u, 1064514355u, 1048576000u, 0, REMAINDERF_TOLERANCE, 0},
{1000, 1050253722u, 3212836864u, 1050253722u, 0, REMAINDERF_TOLERANCE, 0},
{1001, 1050253722u, 3211998003u, 1050253722u, 0, REMAINDERF_TOLERANCE, 0},
{1002, 1050253722u, 3211159142u, 1050253722u, 0, REMAINDERF_TOLERANCE, 0},
{1003, 1050253722u, 3210320282u, 1050253722u, 0, REMAINDERF_TOLERANCE, 0},
{1004, 1050253722u, 3209481421u, 1050253722u, 0, REMAINDERF_TOLERANCE, 0},
{1005, 1050253722u, 3208642560u, 1050253722u, 0, REMAINDERF_TOLERANCE, 0},
{1006, 1050253722u, 3207803699u, 1050253722u, 0, REMAINDERF_TOLERANCE, 0},
{1007, 1050253722u, 3206964838u, 1050253722u, 0, REMAINDERF_TOLERANCE, 0},
{1008, 1050253722u, 3206125978u, 1050253722u, 0, REMAINDERF_TOLERANCE, 0},
{1009, 1050253722u, 3205287117u, 3196059648u, 0, REMAINDERF_TOLERANCE, 0},
{1010, 1050253722u, 3204448256u, 3192704204u, 0, REMAINDERF_TOLERANCE, 0},
{1011, 1050253722u, 3202770534u, 3189348760u, 0, REMAINDERF_TOLERANCE, 0},
{1012, 1050253722u, 3201092813u, 3184315596u, 0, REMAINDERF_TOLERANCE, 0},
{1013, 1050253722u, 3199415091u, 3175926984u, 0, REMAINDERF_TOLERANCE, 0},
{1014, 1050253722u, 3197737370u, 0u, 0, REMAINDERF_TOLERANCE, 0},
{1015, 1050253722u, 3196059648u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{1016, 1050253722u, 3192704205u, 3184315596u, 0, REMAINDERF_TOLERANCE, 0},
{1017, 1050253722u, 3189348762u, 0u, 0, REMAINDERF_TOLERANCE, 0},
{1018, 1050253722u, 3184315597u, 838860800u, 0, REMAINDERF_TOLERANCE, 0},
{1019, 1050253722u, 3175926989u, 838860800u, 0, REMAINDERF_TOLERANCE, 0},
{1020, 1050253722u, 632815616u, 608174080u, 0, REMAINDERF_TOLERANCE, 0},
{1021, 1050253722u, 1028443341u, 838860800u, 0, REMAINDERF_TOLERANCE, 0},
{1022, 1050253722u, 1036831949u, 838860800u, 0, REMAINDERF_TOLERANCE, 0},
{1023, 1050253722u, 1041865114u, 0u, 0, REMAINDERF_TOLERANCE, 0},
{1024, 1050253722u, 1045220557u, 3184315596u, 0, REMAINDERF_TOLERANCE, 0},
{1025, 1050253722u, 1048576000u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{1026, 1050253722u, 1050253722u, 0u, 0, REMAINDERF_TOLERANCE, 0},
{1027, 1050253722u, 1051931443u, 3175926984u, 0, REMAINDERF_TOLERANCE, 0},
{1028, 1050253722u, 1053609165u, 3184315596u, 0, REMAINDERF_TOLERANCE, 0},
{1029, 1050253722u, 1055286886u, 3189348760u, 0, REMAINDERF_TOLERANCE, 0},
{1030, 1050253722u, 1056964608u, 3192704204u, 0, REMAINDERF_TOLERANCE, 0},
{1031, 1050253722u, 1057803469u, 3196059648u, 0, REMAINDERF_TOLERANCE, 0},
{1032, 1050253722u, 1058642330u, 1050253722u, 0, REMAINDERF_TOLERANCE, 0},
{1033, 1050253722u, 1059481190u, 1050253722u, 0, REMAINDERF_TOLERANCE, 0},
{1034, 1050253722u, 1060320051u, 1050253722u, 0, REMAINDERF_TOLERANCE, 0},
{1035, 1050253722u, 1061158912u, 1050253722u, 0, REMAINDERF_TOLERANCE, 0},
{1036, 1050253722u, 1061997773u, 1050253722u, 0, REMAINDERF_TOLERANCE, 0},
{1037, 1050253722u, 1062836634u, 1050253722u, 0, REMAINDERF_TOLERANCE, 0},
{1038, 1050253722u, 1063675494u, 1050253722u, 0, REMAINDERF_TOLERANCE, 0},
{1039, 1050253722u, 1064514355u, 1050253722u, 0, REMAINDERF_TOLERANCE, 0},
{1040, 1051931443u, 3212836864u, 1051931443u, 0, REMAINDERF_TOLERANCE, 0},
{1041, 1051931443u, 3211998003u, 1051931443u, 0, REMAINDERF_TOLERANCE, 0},
{1042, 1051931443u, 3211159142u, 1051931443u, 0, REMAINDERF_TOLERANCE, 0},
{1043, 1051931443u, 3210320282u, 1051931443u, 0, REMAINDERF_TOLERANCE, 0},
{1044, 1051931443u, 3209481421u, 1051931443u, 0, REMAINDERF_TOLERANCE, 0},
{1045, 1051931443u, 3208642560u, 1051931443u, 0, REMAINDERF_TOLERANCE, 0},
{1046, 1051931443u, 3207803699u, 1051931443u, 0, REMAINDERF_TOLERANCE, 0},
{1047, 1051931443u, 3206964838u, 3197737369u, 0, REMAINDERF_TOLERANCE, 0},
{1048, 1051931443u, 3206125978u, 3196059649u, 0, REMAINDERF_TOLERANCE, 0},
{1049, 1051931443u, 3205287117u, 3192704206u, 0, REMAINDERF_TOLERANCE, 0},
{1050, 1051931443u, 3204448256u, 3189348762u, 0, REMAINDERF_TOLERANCE, 0},
{1051, 1051931443u, 3202770534u, 3184315596u, 0, REMAINDERF_TOLERANCE, 0},
{1052, 1051931443u, 3201092813u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{1053, 1051931443u, 3199415091u, 0u, 0, REMAINDERF_TOLERANCE, 0},
{1054, 1051931443u, 3197737370u, 1028443336u, 0, REMAINDERF_TOLERANCE, 0},
{1055, 1051931443u, 3196059648u, 1036831948u, 0, REMAINDERF_TOLERANCE, 0},
{1056, 1051931443u, 3192704205u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{1057, 1051931443u, 3189348762u, 1028443336u, 0, REMAINDERF_TOLERANCE, 0},
{1058, 1051931443u, 3184315597u, 1028443338u, 0, REMAINDERF_TOLERANCE, 0},
{1059, 1051931443u, 3175926989u, 2990538752u, 0, REMAINDERF_TOLERANCE, 0},
{1060, 1051931443u, 632815616u, 623902720u, 0, REMAINDERF_TOLERANCE, 0},
{1061, 1051931443u, 1028443341u, 2990538752u, 0, REMAINDERF_TOLERANCE, 0},
{1062, 1051931443u, 1036831949u, 1028443338u, 0, REMAINDERF_TOLERANCE, 0},
{1063, 1051931443u, 1041865114u, 1028443336u, 0, REMAINDERF_TOLERANCE, 0},
{1064, 1051931443u, 1045220557u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{1065, 1051931443u, 1048576000u, 1036831948u, 0, REMAINDERF_TOLERANCE, 0},
{1066, 1051931443u, 1050253722u, 1028443336u, 0, REMAINDERF_TOLERANCE, 0},
{1067, 1051931443u, 1051931443u, 0u, 0, REMAINDERF_TOLERANCE, 0},
{1068, 1051931443u, 1053609165u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{1069, 1051931443u, 1055286886u, 3184315596u, 0, REMAINDERF_TOLERANCE, 0},
{1070, 1051931443u, 1056964608u, 3189348762u, 0, REMAINDERF_TOLERANCE, 0},
{1071, 1051931443u, 1057803469u, 3192704206u, 0, REMAINDERF_TOLERANCE, 0},
{1072, 1051931443u, 1058642330u, 3196059649u, 0, REMAINDERF_TOLERANCE, 0},
{1073, 1051931443u, 1059481190u, 3197737369u, 0, REMAINDERF_TOLERANCE, 0},
{1074, 1051931443u, 1060320051u, 1051931443u, 0, REMAINDERF_TOLERANCE, 0},
{1075, 1051931443u, 1061158912u, 1051931443u, 0, REMAINDERF_TOLERANCE, 0},
{1076, 1051931443u, 1061997773u, 1051931443u, 0, REMAINDERF_TOLERANCE, 0},
{1077, 1051931443u, 1062836634u, 1051931443u, 0, REMAINDERF_TOLERANCE, 0},
{1078, 1051931443u, 1063675494u, 1051931443u, 0, REMAINDERF_TOLERANCE, 0},
{1079, 1051931443u, 1064514355u, 1051931443u, 0, REMAINDERF_TOLERANCE, 0},
{1080, 1053609165u, 3212836864u, 1053609165u, 0, REMAINDERF_TOLERANCE, 0},
{1081, 1053609165u, 3211998003u, 1053609165u, 0, REMAINDERF_TOLERANCE, 0},
{1082, 1053609165u, 3211159142u, 1053609165u, 0, REMAINDERF_TOLERANCE, 0},
{1083, 1053609165u, 3210320282u, 1053609165u, 0, REMAINDERF_TOLERANCE, 0},
{1084, 1053609165u, 3209481421u, 1053609165u, 0, REMAINDERF_TOLERANCE, 0},
{1085, 1053609165u, 3208642560u, 3199415091u, 0, REMAINDERF_TOLERANCE, 0},
{1086, 1053609165u, 3207803699u, 3197737369u, 0, REMAINDERF_TOLERANCE, 0},
{1087, 1053609165u, 3206964838u, 3196059646u, 0, REMAINDERF_TOLERANCE, 0},
{1088, 1053609165u, 3206125978u, 3192704206u, 0, REMAINDERF_TOLERANCE, 0},
{1089, 1053609165u, 3205287117u, 3189348762u, 0, REMAINDERF_TOLERANCE, 0},
{1090, 1053609165u, 3204448256u, 3184315596u, 0, REMAINDERF_TOLERANCE, 0},
{1091, 1053609165u, 3202770534u, 3175926984u, 0, REMAINDERF_TOLERANCE, 0},
{1092, 1053609165u, 3201092813u, 0u, 0, REMAINDERF_TOLERANCE, 0},
{1093, 1053609165u, 3199415091u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{1094, 1053609165u, 3197737370u, 1036831948u, 0, REMAINDERF_TOLERANCE, 0},
{1095, 1053609165u, 3196059648u, 3184315596u, 0, REMAINDERF_TOLERANCE, 0},
{1096, 1053609165u, 3192704205u, 0u, 0, REMAINDERF_TOLERANCE, 0},
{1097, 1053609165u, 3189348762u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{1098, 1053609165u, 3184315597u, 0u, 0, REMAINDERF_TOLERANCE, 0},
{1099, 1053609165u, 3175926989u, 0u, 0, REMAINDERF_TOLERANCE, 0},
{1100, 1053609165u, 632815616u, 603979776u, 0, REMAINDERF_TOLERANCE, 0},
{1101, 1053609165u, 1028443341u, 0u, 0, REMAINDERF_TOLERANCE, 0},
{1102, 1053609165u, 1036831949u, 0u, 0, REMAINDERF_TOLERANCE, 0},
{1103, 1053609165u, 1041865114u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{1104, 1053609165u, 1045220557u, 0u, 0, REMAINDERF_TOLERANCE, 0},
{1105, 1053609165u, 1048576000u, 3184315596u, 0, REMAINDERF_TOLERANCE, 0},
{1106, 1053609165u, 1050253722u, 1036831948u, 0, REMAINDERF_TOLERANCE, 0},
{1107, 1053609165u, 1051931443u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{1108, 1053609165u, 1053609165u, 0u, 0, REMAINDERF_TOLERANCE, 0},
{1109, 1053609165u, 1055286886u, 3175926984u, 0, REMAINDERF_TOLERANCE, 0},
{1110, 1053609165u, 1056964608u, 3184315596u, 0, REMAINDERF_TOLERANCE, 0},
{1111, 1053609165u, 1057803469u, 3189348762u, 0, REMAINDERF_TOLERANCE, 0},
{1112, 1053609165u, 1058642330u, 3192704206u, 0, REMAINDERF_TOLERANCE, 0},
{1113, 1053609165u, 1059481190u, 3196059646u, 0, REMAINDERF_TOLERANCE, 0},
{1114, 1053609165u, 1060320051u, 3197737369u, 0, REMAINDERF_TOLERANCE, 0},
{1115, 1053609165u, 1061158912u, 3199415091u, 0, REMAINDERF_TOLERANCE, 0},
{1116, 1053609165u, 1061997773u, 1053609165u, 0, REMAINDERF_TOLERANCE, 0},
{1117, 1053609165u, 1062836634u, 1053609165u, 0, REMAINDERF_TOLERANCE, 0},
{1118, 1053609165u, 1063675494u, 1053609165u, 0, REMAINDERF_TOLERANCE, 0},
{1119, 1053609165u, 1064514355u, 1053609165u, 0, REMAINDERF_TOLERANCE, 0},
{1120, 1055286886u, 3212836864u, 1055286886u, 0, REMAINDERF_TOLERANCE, 0},
{1121, 1055286886u, 3211998003u, 1055286886u, 0, REMAINDERF_TOLERANCE, 0},
{1122, 1055286886u, 3211159142u, 1055286886u, 0, REMAINDERF_TOLERANCE, 0},
{1123, 1055286886u, 3210320282u, 3201092814u, 0, REMAINDERF_TOLERANCE, 0},
{1124, 1055286886u, 3209481421u, 3199415092u, 0, REMAINDERF_TOLERANCE, 0},
{1125, 1055286886u, 3208642560u, 3197737370u, 0, REMAINDERF_TOLERANCE, 0},
{1126, 1055286886u, 3207803699u, 3196059648u, 0, REMAINDERF_TOLERANCE, 0},
{1127, 1055286886u, 3206964838u, 3192704204u, 0, REMAINDERF_TOLERANCE, 0},
{1128, 1055286886u, 3206125978u, 3189348764u, 0, REMAINDERF_TOLERANCE, 0},
{1129, 1055286886u, 3205287117u, 3184315600u, 0, REMAINDERF_TOLERANCE, 0},
{1130, 1055286886u, 3204448256u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{1131, 1055286886u, 3202770534u, 0u, 0, REMAINDERF_TOLERANCE, 0},
{1132, 1055286886u, 3201092813u, 1028443336u, 0, REMAINDERF_TOLERANCE, 0},
{1133, 1055286886u, 3199415091u, 1036831948u, 0, REMAINDERF_TOLERANCE, 0},
{1134, 1055286886u, 3197737370u, 1041865112u, 0, REMAINDERF_TOLERANCE, 0},
{1135, 1055286886u, 3196059648u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{1136, 1055286886u, 3192704205u, 1028443336u, 0, REMAINDERF_TOLERANCE, 0},
{1137, 1055286886u, 3189348762u, 3003121664u, 0, REMAINDERF_TOLERANCE, 0},
{1138, 1055286886u, 3184315597u, 1028443336u, 0, REMAINDERF_TOLERANCE, 0},
{1139, 1055286886u, 3175926989u, 2996830208u, 0, REMAINDERF_TOLERANCE, 0},
{1140, 1055286886u, 632815616u, 622854144u, 0, REMAINDERF_TOLERANCE, 0},
{1141, 1055286886u, 1028443341u, 2996830208u, 0, REMAINDERF_TOLERANCE, 0},
{1142, 1055286886u, 1036831949u, 1028443336u, 0, REMAINDERF_TOLERANCE, 0},
{1143, 1055286886u, 1041865114u, 3003121664u, 0, REMAINDERF_TOLERANCE, 0},
{1144, 1055286886u, 1045220557u, 1028443336u, 0, REMAINDERF_TOLERANCE, 0},
{1145, 1055286886u, 1048576000u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{1146, 1055286886u, 1050253722u, 1041865112u, 0, REMAINDERF_TOLERANCE, 0},
{1147, 1055286886u, 1051931443u, 1036831948u, 0, REMAINDERF_TOLERANCE, 0},
{1148, 1055286886u, 1053609165u, 1028443336u, 0, REMAINDERF_TOLERANCE, 0},
{1149, 1055286886u, 1055286886u, 0u, 0, REMAINDERF_TOLERANCE, 0},
{1150, 1055286886u, 1056964608u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{1151, 1055286886u, 1057803469u, 3184315600u, 0, REMAINDERF_TOLERANCE, 0},
{1152, 1055286886u, 1058642330u, 3189348764u, 0, REMAINDERF_TOLERANCE, 0},
{1153, 1055286886u, 1059481190u, 3192704204u, 0, REMAINDERF_TOLERANCE, 0},
{1154, 1055286886u, 1060320051u, 3196059648u, 0, REMAINDERF_TOLERANCE, 0},
{1155, 1055286886u, 1061158912u, 3197737370u, 0, REMAINDERF_TOLERANCE, 0},
{1156, 1055286886u, 1061997773u, 3199415092u, 0, REMAINDERF_TOLERANCE, 0},
{1157, 1055286886u, 1062836634u, 3201092814u, 0, REMAINDERF_TOLERANCE, 0},
{1158, 1055286886u, 1063675494u, 1055286886u, 0, REMAINDERF_TOLERANCE, 0},
{1159, 1055286886u, 1064514355u, 1055286886u, 0, REMAINDERF_TOLERANCE, 0},
{1160, 1056964608u, 3212836864u, 1056964608u, 0, REMAINDERF_TOLERANCE, 0},
{1161, 1056964608u, 3211998003u, 3202770534u, 0, REMAINDERF_TOLERANCE, 0},
{1162, 1056964608u, 3211159142u, 3201092812u, 0, REMAINDERF_TOLERANCE, 0},
{1163, 1056964608u, 3210320282u, 3199415092u, 0, REMAINDERF_TOLERANCE, 0},
{1164, 1056964608u, 3209481421u, 3197737370u, 0, REMAINDERF_TOLERANCE, 0},
{1165, 1056964608u, 3208642560u, 3196059648u, 0, REMAINDERF_TOLERANCE, 0},
{1166, 1056964608u, 3207803699u, 3192704204u, 0, REMAINDERF_TOLERANCE, 0},
{1167, 1056964608u, 3206964838u, 3189348760u, 0, REMAINDERF_TOLERANCE, 0},
{1168, 1056964608u, 3206125978u, 3184315600u, 0, REMAINDERF_TOLERANCE, 0},
{1169, 1056964608u, 3205287117u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{1170, 1056964608u, 3204448256u, 0u, 0, REMAINDERF_TOLERANCE, 0},
{1171, 1056964608u, 3202770534u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{1172, 1056964608u, 3201092813u, 1036831948u, 0, REMAINDERF_TOLERANCE, 0},
{1173, 1056964608u, 3199415091u, 1041865114u, 0, REMAINDERF_TOLERANCE, 0},
{1174, 1056964608u, 3197737370u, 3184315600u, 0, REMAINDERF_TOLERANCE, 0},
{1175, 1056964608u, 3196059648u, 0u, 0, REMAINDERF_TOLERANCE, 0},
{1176, 1056964608u, 3192704205u, 1036831948u, 0, REMAINDERF_TOLERANCE, 0},
{1177, 1056964608u, 3189348762u, 1028443336u, 0, REMAINDERF_TOLERANCE, 0},
{1178, 1056964608u, 3184315597u, 2986344448u, 0, REMAINDERF_TOLERANCE, 0},
{1179, 1056964608u, 3175926989u, 2986344448u, 0, REMAINDERF_TOLERANCE, 0},
{1180, 1056964608u, 632815616u, 595591168u, 0, REMAINDERF_TOLERANCE, 0},
{1181, 1056964608u, 1028443341u, 2986344448u, 0, REMAINDERF_TOLERANCE, 0},
{1182, 1056964608u, 1036831949u, 2986344448u, 0, REMAINDERF_TOLERANCE, 0},
{1183, 1056964608u, 1041865114u, 1028443336u, 0, REMAINDERF_TOLERANCE, 0},
{1184, 1056964608u, 1045220557u, 1036831948u, 0, REMAINDERF_TOLERANCE, 0},
{1185, 1056964608u, 1048576000u, 0u, 0, REMAINDERF_TOLERANCE, 0},
{1186, 1056964608u, 1050253722u, 3184315600u, 0, REMAINDERF_TOLERANCE, 0},
{1187, 1056964608u, 1051931443u, 1041865114u, 0, REMAINDERF_TOLERANCE, 0},
{1188, 1056964608u, 1053609165u, 1036831948u, 0, REMAINDERF_TOLERANCE, 0},
{1189, 1056964608u, 1055286886u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{1190, 1056964608u, 1056964608u, 0u, 0, REMAINDERF_TOLERANCE, 0},
{1191, 1056964608u, 1057803469u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{1192, 1056964608u, 1058642330u, 3184315600u, 0, REMAINDERF_TOLERANCE, 0},
{1193, 1056964608u, 1059481190u, 3189348760u, 0, REMAINDERF_TOLERANCE, 0},
{1194, 1056964608u, 1060320051u, 3192704204u, 0, REMAINDERF_TOLERANCE, 0},
{1195, 1056964608u, 1061158912u, 3196059648u, 0, REMAINDERF_TOLERANCE, 0},
{1196, 1056964608u, 1061997773u, 3197737370u, 0, REMAINDERF_TOLERANCE, 0},
{1197, 1056964608u, 1062836634u, 3199415092u, 0, REMAINDERF_TOLERANCE, 0},
{1198, 1056964608u, 1063675494u, 3201092812u, 0, REMAINDERF_TOLERANCE, 0},
{1199, 1056964608u, 1064514355u, 3202770534u, 0, REMAINDERF_TOLERANCE, 0},
{1200, 1057803469u, 3212836864u, 3202770534u, 0, REMAINDERF_TOLERANCE, 0},
{1201, 1057803469u, 3211998003u, 3201092812u, 0, REMAINDERF_TOLERANCE, 0},
{1202, 1057803469u, 3211159142u, 3199415090u, 0, REMAINDERF_TOLERANCE, 0},
{1203, 1057803469u, 3210320282u, 3197737370u, 0, REMAINDERF_TOLERANCE, 0},
{1204, 1057803469u, 3209481421u, 3196059648u, 0, REMAINDERF_TOLERANCE, 0},
{1205, 1057803469u, 3208642560u, 3192704204u, 0, REMAINDERF_TOLERANCE, 0},
{1206, 1057803469u, 3207803699u, 3189348760u, 0, REMAINDERF_TOLERANCE, 0},
{1207, 1057803469u, 3206964838u, 3184315592u, 0, REMAINDERF_TOLERANCE, 0},
{1208, 1057803469u, 3206125978u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{1209, 1057803469u, 3205287117u, 0u, 0, REMAINDERF_TOLERANCE, 0},
{1210, 1057803469u, 3204448256u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{1211, 1057803469u, 3202770534u, 1036831952u, 0, REMAINDERF_TOLERANCE, 0},
{1212, 1057803469u, 3201092813u, 1041865114u, 0, REMAINDERF_TOLERANCE, 0},
{1213, 1057803469u, 3199415091u, 3189348760u, 0, REMAINDERF_TOLERANCE, 0},
{1214, 1057803469u, 3197737370u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{1215, 1057803469u, 3196059648u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{1216, 1057803469u, 3192704205u, 3175926988u, 0, REMAINDERF_TOLERANCE, 0},
{1217, 1057803469u, 3189348762u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{1218, 1057803469u, 3184315597u, 3175926988u, 0, REMAINDERF_TOLERANCE, 0},
{1219, 1057803469u, 3175926989u, 830472192u, 0, REMAINDERF_TOLERANCE, 0},
{1220, 1057803469u, 632815616u, 2768240640u, 0, REMAINDERF_TOLERANCE, 0},
{1221, 1057803469u, 1028443341u, 830472192u, 0, REMAINDERF_TOLERANCE, 0},
{1222, 1057803469u, 1036831949u, 3175926988u, 0, REMAINDERF_TOLERANCE, 0},
{1223, 1057803469u, 1041865114u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{1224, 1057803469u, 1045220557u, 3175926988u, 0, REMAINDERF_TOLERANCE, 0},
{1225, 1057803469u, 1048576000u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{1226, 1057803469u, 1050253722u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{1227, 1057803469u, 1051931443u, 3189348760u, 0, REMAINDERF_TOLERANCE, 0},
{1228, 1057803469u, 1053609165u, 1041865114u, 0, REMAINDERF_TOLERANCE, 0},
{1229, 1057803469u, 1055286886u, 1036831952u, 0, REMAINDERF_TOLERANCE, 0},
{1230, 1057803469u, 1056964608u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{1231, 1057803469u, 1057803469u, 0u, 0, REMAINDERF_TOLERANCE, 0},
{1232, 1057803469u, 1058642330u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{1233, 1057803469u, 1059481190u, 3184315592u, 0, REMAINDERF_TOLERANCE, 0},
{1234, 1057803469u, 1060320051u, 3189348760u, 0, REMAINDERF_TOLERANCE, 0},
{1235, 1057803469u, 1061158912u, 3192704204u, 0, REMAINDERF_TOLERANCE, 0},
{1236, 1057803469u, 1061997773u, 3196059648u, 0, REMAINDERF_TOLERANCE, 0},
{1237, 1057803469u, 1062836634u, 3197737370u, 0, REMAINDERF_TOLERANCE, 0},
{1238, 1057803469u, 1063675494u, 3199415090u, 0, REMAINDERF_TOLERANCE, 0},
{1239, 1057803469u, 1064514355u, 3201092812u, 0, REMAINDERF_TOLERANCE, 0},
{1240, 1058642330u, 3212836864u, 3201092812u, 0, REMAINDERF_TOLERANCE, 0},
{1241, 1058642330u, 3211998003u, 3199415090u, 0, REMAINDERF_TOLERANCE, 0},
{1242, 1058642330u, 3211159142u, 3197737368u, 0, REMAINDERF_TOLERANCE, 0},
{1243, 1058642330u, 3210320282u, 3196059648u, 0, REMAINDERF_TOLERANCE, 0},
{1244, 1058642330u, 3209481421u, 3192704204u, 0, REMAINDERF_TOLERANCE, 0},
{1245, 1058642330u, 3208642560u, 3189348760u, 0, REMAINDERF_TOLERANCE, 0},
{1246, 1058642330u, 3207803699u, 3184315592u, 0, REMAINDERF_TOLERANCE, 0},
{1247, 1058642330u, 3206964838u, 3175926976u, 0, REMAINDERF_TOLERANCE, 0},
{1248, 1058642330u, 3206125978u, 0u, 0, REMAINDERF_TOLERANCE, 0},
{1249, 1058642330u, 3205287117u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{1250, 1058642330u, 3204448256u, 1036831952u, 0, REMAINDERF_TOLERANCE, 0},
{1251, 1058642330u, 3202770534u, 1041865116u, 0, REMAINDERF_TOLERANCE, 0},
{1252, 1058642330u, 3201092813u, 3192704204u, 0, REMAINDERF_TOLERANCE, 0},
{1253, 1058642330u, 3199415091u, 3184315592u, 0, REMAINDERF_TOLERANCE, 0},
{1254, 1058642330u, 3197737370u, 0u, 0, REMAINDERF_TOLERANCE, 0},
{1255, 1058642330u, 3196059648u, 1036831952u, 0, REMAINDERF_TOLERANCE, 0},
{1256, 1058642330u, 3192704205u, 847249408u, 0, REMAINDERF_TOLERANCE, 0},
{1257, 1058642330u, 3189348762u, 0u, 0, REMAINDERF_TOLERANCE, 0},
{1258, 1058642330u, 3184315597u, 847249408u, 0, REMAINDERF_TOLERANCE, 0},
{1259, 1058642330u, 3175926989u, 847249408u, 0, REMAINDERF_TOLERANCE, 0},
{1260, 1058642330u, 632815616u, 616562688u, 0, REMAINDERF_TOLERANCE, 0},
{1261, 1058642330u, 1028443341u, 847249408u, 0, REMAINDERF_TOLERANCE, 0},
{1262, 1058642330u, 1036831949u, 847249408u, 0, REMAINDERF_TOLERANCE, 0},
{1263, 1058642330u, 1041865114u, 0u, 0, REMAINDERF_TOLERANCE, 0},
{1264, 1058642330u, 1045220557u, 847249408u, 0, REMAINDERF_TOLERANCE, 0},
{1265, 1058642330u, 1048576000u, 1036831952u, 0, REMAINDERF_TOLERANCE, 0},
{1266, 1058642330u, 1050253722u, 0u, 0, REMAINDERF_TOLERANCE, 0},
{1267, 1058642330u, 1051931443u, 3184315592u, 0, REMAINDERF_TOLERANCE, 0},
{1268, 1058642330u, 1053609165u, 3192704204u, 0, REMAINDERF_TOLERANCE, 0},
{1269, 1058642330u, 1055286886u, 1041865116u, 0, REMAINDERF_TOLERANCE, 0},
{1270, 1058642330u, 1056964608u, 1036831952u, 0, REMAINDERF_TOLERANCE, 0},
{1271, 1058642330u, 1057803469u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{1272, 1058642330u, 1058642330u, 0u, 0, REMAINDERF_TOLERANCE, 0},
{1273, 1058642330u, 1059481190u, 3175926976u, 0, REMAINDERF_TOLERANCE, 0},
{1274, 1058642330u, 1060320051u, 3184315592u, 0, REMAINDERF_TOLERANCE, 0},
{1275, 1058642330u, 1061158912u, 3189348760u, 0, REMAINDERF_TOLERANCE, 0},
{1276, 1058642330u, 1061997773u, 3192704204u, 0, REMAINDERF_TOLERANCE, 0},
{1277, 1058642330u, 1062836634u, 3196059648u, 0, REMAINDERF_TOLERANCE, 0},
{1278, 1058642330u, 1063675494u, 3197737368u, 0, REMAINDERF_TOLERANCE, 0},
{1279, 1058642330u, 1064514355u, 3199415090u, 0, REMAINDERF_TOLERANCE, 0},
{1280, 1059481190u, 3212836864u, 3199415092u, 0, REMAINDERF_TOLERANCE, 0},
{1281, 1059481190u, 3211998003u, 3197737370u, 0, REMAINDERF_TOLERANCE, 0},
{1282, 1059481190u, 3211159142u, 3196059648u, 0, REMAINDERF_TOLERANCE, 0},
{1283, 1059481190u, 3210320282u, 3192704208u, 0, REMAINDERF_TOLERANCE, 0},
{1284, 1059481190u, 3209481421u, 3189348764u, 0, REMAINDERF_TOLERANCE, 0},
{1285, 1059481190u, 3208642560u, 3184315600u, 0, REMAINDERF_TOLERANCE, 0},
{1286, 1059481190u, 3207803699u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{1287, 1059481190u, 3206964838u, 0u, 0, REMAINDERF_TOLERANCE, 0},
{1288, 1059481190u, 3206125978u, 1028443328u, 0, REMAINDERF_TOLERANCE, 0},
{1289, 1059481190u, 3205287117u, 1036831944u, 0, REMAINDERF_TOLERANCE, 0},
{1290, 1059481190u, 3204448256u, 1041865112u, 0, REMAINDERF_TOLERANCE, 0},
{1291, 1059481190u, 3202770534u, 1045220556u, 0, REMAINDERF_TOLERANCE, 0},
{1292, 1059481190u, 3201092813u, 3189348764u, 0, REMAINDERF_TOLERANCE, 0},
{1293, 1059481190u, 3199415091u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{1294, 1059481190u, 3197737370u, 1028443328u, 0, REMAINDERF_TOLERANCE, 0},
{1295, 1059481190u, 3196059648u, 3184315600u, 0, REMAINDERF_TOLERANCE, 0},
{1296, 1059481190u, 3192704205u, 1028443332u, 0, REMAINDERF_TOLERANCE, 0},
{1297, 1059481190u, 3189348762u, 1028443328u, 0, REMAINDERF_TOLERANCE, 0},
{1298, 1059481190u, 3184315597u, 1028443332u, 0, REMAINDERF_TOLERANCE, 0},
{1299, 1059481190u, 3175926989u, 3004170240u, 0, REMAINDERF_TOLERANCE, 0},
{1300, 1059481190u, 632815616u, 620756992u, 0, REMAINDERF_TOLERANCE, 0},
{1301, 1059481190u, 1028443341u, 3004170240u, 0, REMAINDERF_TOLERANCE, 0},
{1302, 1059481190u, 1036831949u, 1028443332u, 0, REMAINDERF_TOLERANCE, 0},
{1303, 1059481190u, 1041865114u, 1028443328u, 0, REMAINDERF_TOLERANCE, 0},
{1304, 1059481190u, 1045220557u, 1028443332u, 0, REMAINDERF_TOLERANCE, 0},
{1305, 1059481190u, 1048576000u, 3184315600u, 0, REMAINDERF_TOLERANCE, 0},
{1306, 1059481190u, 1050253722u, 1028443328u, 0, REMAINDERF_TOLERANCE, 0},
{1307, 1059481190u, 1051931443u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{1308, 1059481190u, 1053609165u, 3189348764u, 0, REMAINDERF_TOLERANCE, 0},
{1309, 1059481190u, 1055286886u, 1045220556u, 0, REMAINDERF_TOLERANCE, 0},
{1310, 1059481190u, 1056964608u, 1041865112u, 0, REMAINDERF_TOLERANCE, 0},
{1311, 1059481190u, 1057803469u, 1036831944u, 0, REMAINDERF_TOLERANCE, 0},
{1312, 1059481190u, 1058642330u, 1028443328u, 0, REMAINDERF_TOLERANCE, 0},
{1313, 1059481190u, 1059481190u, 0u, 0, REMAINDERF_TOLERANCE, 0},
{1314, 1059481190u, 1060320051u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{1315, 1059481190u, 1061158912u, 3184315600u, 0, REMAINDERF_TOLERANCE, 0},
{1316, 1059481190u, 1061997773u, 3189348764u, 0, REMAINDERF_TOLERANCE, 0},
{1317, 1059481190u, 1062836634u, 3192704208u, 0, REMAINDERF_TOLERANCE, 0},
{1318, 1059481190u, 1063675494u, 3196059648u, 0, REMAINDERF_TOLERANCE, 0},
{1319, 1059481190u, 1064514355u, 3197737370u, 0, REMAINDERF_TOLERANCE, 0},
{1320, 1060320051u, 3212836864u, 3197737370u, 0, REMAINDERF_TOLERANCE, 0},
{1321, 1060320051u, 3211998003u, 3196059648u, 0, REMAINDERF_TOLERANCE, 0},
{1322, 1060320051u, 3211159142u, 3192704204u, 0, REMAINDERF_TOLERANCE, 0},
{1323, 1060320051u, 3210320282u, 3189348764u, 0, REMAINDERF_TOLERANCE, 0},
{1324, 1060320051u, 3209481421u, 3184315600u, 0, REMAINDERF_TOLERANCE, 0},
{1325, 1060320051u, 3208642560u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{1326, 1060320051u, 3207803699u, 0u, 0, REMAINDERF_TOLERANCE, 0},
{1327, 1060320051u, 3206964838u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{1328, 1060320051u, 3206125978u, 1036831944u, 0, REMAINDERF_TOLERANCE, 0},
{1329, 1060320051u, 3205287117u, 1041865112u, 0, REMAINDERF_TOLERANCE, 0},
{1330, 1060320051u, 3204448256u, 1045220556u, 0, REMAINDERF_TOLERANCE, 0},
{1331, 1060320051u, 3202770534u, 3192704204u, 0, REMAINDERF_TOLERANCE, 0},
{1332, 1060320051u, 3201092813u, 3184315600u, 0, REMAINDERF_TOLERANCE, 0},
{1333, 1060320051u, 3199415091u, 0u, 0, REMAINDERF_TOLERANCE, 0},
{1334, 1060320051u, 3197737370u, 1036831944u, 0, REMAINDERF_TOLERANCE, 0},
{1335, 1060320051u, 3196059648u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{1336, 1060320051u, 3192704205u, 1036831946u, 0, REMAINDERF_TOLERANCE, 0},
{1337, 1060320051u, 3189348762u, 3175927000u, 0, REMAINDERF_TOLERANCE, 0},
{1338, 1060320051u, 3184315597u, 2998927360u, 0, REMAINDERF_TOLERANCE, 0},
{1339, 1060320051u, 3175926989u, 2998927360u, 0, REMAINDERF_TOLERANCE, 0},
{1340, 1060320051u, 632815616u, 2743074816u, 0, REMAINDERF_TOLERANCE, 0},
{1341, 1060320051u, 1028443341u, 2998927360u, 0, REMAINDERF_TOLERANCE, 0},
{1342, 1060320051u, 1036831949u, 2998927360u, 0, REMAINDERF_TOLERANCE, 0},
{1343, 1060320051u, 1041865114u, 3175927000u, 0, REMAINDERF_TOLERANCE, 0},
{1344, 1060320051u, 1045220557u, 1036831946u, 0, REMAINDERF_TOLERANCE, 0},
{1345, 1060320051u, 1048576000u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{1346, 1060320051u, 1050253722u, 1036831944u, 0, REMAINDERF_TOLERANCE, 0},
{1347, 1060320051u, 1051931443u, 0u, 0, REMAINDERF_TOLERANCE, 0},
{1348, 1060320051u, 1053609165u, 3184315600u, 0, REMAINDERF_TOLERANCE, 0},
{1349, 1060320051u, 1055286886u, 3192704204u, 0, REMAINDERF_TOLERANCE, 0},
{1350, 1060320051u, 1056964608u, 1045220556u, 0, REMAINDERF_TOLERANCE, 0},
{1351, 1060320051u, 1057803469u, 1041865112u, 0, REMAINDERF_TOLERANCE, 0},
{1352, 1060320051u, 1058642330u, 1036831944u, 0, REMAINDERF_TOLERANCE, 0},
{1353, 1060320051u, 1059481190u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{1354, 1060320051u, 1060320051u, 0u, 0, REMAINDERF_TOLERANCE, 0},
{1355, 1060320051u, 1061158912u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{1356, 1060320051u, 1061997773u, 3184315600u, 0, REMAINDERF_TOLERANCE, 0},
{1357, 1060320051u, 1062836634u, 3189348764u, 0, REMAINDERF_TOLERANCE, 0},
{1358, 1060320051u, 1063675494u, 3192704204u, 0, REMAINDERF_TOLERANCE, 0},
{1359, 1060320051u, 1064514355u, 3196059648u, 0, REMAINDERF_TOLERANCE, 0},
{1360, 1061158912u, 3212836864u, 3196059648u, 0, REMAINDERF_TOLERANCE, 0},
{1361, 1061158912u, 3211998003u, 3192704204u, 0, REMAINDERF_TOLERANCE, 0},
{1362, 1061158912u, 3211159142u, 3189348760u, 0, REMAINDERF_TOLERANCE, 0},
{1363, 1061158912u, 3210320282u, 3184315600u, 0, REMAINDERF_TOLERANCE, 0},
{1364, 1061158912u, 3209481421u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{1365, 1061158912u, 3208642560u, 0u, 0, REMAINDERF_TOLERANCE, 0},
{1366, 1061158912u, 3207803699u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{1367, 1061158912u, 3206964838u, 1036831952u, 0, REMAINDERF_TOLERANCE, 0},
{1368, 1061158912u, 3206125978u, 1041865112u, 0, REMAINDERF_TOLERANCE, 0},
{1369, 1061158912u, 3205287117u, 1045220556u, 0, REMAINDERF_TOLERANCE, 0},
{1370, 1061158912u, 3204448256u, 3196059648u, 0, REMAINDERF_TOLERANCE, 0},
{1371, 1061158912u, 3202770534u, 3189348760u, 0, REMAINDERF_TOLERANCE, 0},
{1372, 1061158912u, 3201092813u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{1373, 1061158912u, 3199415091u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{1374, 1061158912u, 3197737370u, 1041865112u, 0, REMAINDERF_TOLERANCE, 0},
{1375, 1061158912u, 3196059648u, 0u, 0, REMAINDERF_TOLERANCE, 0},
{1376, 1061158912u, 3192704205u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{1377, 1061158912u, 3189348762u, 3003121664u, 0, REMAINDERF_TOLERANCE, 0},
{1378, 1061158912u, 3184315597u, 1028443338u, 0, REMAINDERF_TOLERANCE, 0},
{1379, 1061158912u, 3175926989u, 2990538752u, 0, REMAINDERF_TOLERANCE, 0},
{1380, 1061158912u, 632815616u, 2770337792u, 0, REMAINDERF_TOLERANCE, 0},
{1381, 1061158912u, 1028443341u, 2990538752u, 0, REMAINDERF_TOLERANCE, 0},
{1382, 1061158912u, 1036831949u, 1028443338u, 0, REMAINDERF_TOLERANCE, 0},
{1383, 1061158912u, 1041865114u, 3003121664u, 0, REMAINDERF_TOLERANCE, 0},
{1384, 1061158912u, 1045220557u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{1385, 1061158912u, 1048576000u, 0u, 0, REMAINDERF_TOLERANCE, 0},
{1386, 1061158912u, 1050253722u, 1041865112u, 0, REMAINDERF_TOLERANCE, 0},
{1387, 1061158912u, 1051931443u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{1388, 1061158912u, 1053609165u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{1389, 1061158912u, 1055286886u, 3189348760u, 0, REMAINDERF_TOLERANCE, 0},
{1390, 1061158912u, 1056964608u, 3196059648u, 0, REMAINDERF_TOLERANCE, 0},
{1391, 1061158912u, 1057803469u, 1045220556u, 0, REMAINDERF_TOLERANCE, 0},
{1392, 1061158912u, 1058642330u, 1041865112u, 0, REMAINDERF_TOLERANCE, 0},
{1393, 1061158912u, 1059481190u, 1036831952u, 0, REMAINDERF_TOLERANCE, 0},
{1394, 1061158912u, 1060320051u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{1395, 1061158912u, 1061158912u, 0u, 0, REMAINDERF_TOLERANCE, 0},
{1396, 1061158912u, 1061997773u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{1397, 1061158912u, 1062836634u, 3184315600u, 0, REMAINDERF_TOLERANCE, 0},
{1398, 1061158912u, 1063675494u, 3189348760u, 0, REMAINDERF_TOLERANCE, 0},
{1399, 1061158912u, 1064514355u, 3192704204u, 0, REMAINDERF_TOLERANCE, 0},
{1400, 1061997773u, 3212836864u, 3192704204u, 0, REMAINDERF_TOLERANCE, 0},
{1401, 1061997773u, 3211998003u, 3189348760u, 0, REMAINDERF_TOLERANCE, 0},
{1402, 1061997773u, 3211159142u, 3184315592u, 0, REMAINDERF_TOLERANCE, 0},
{1403, 1061997773u, 3210320282u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{1404, 1061997773u, 3209481421u, 0u, 0, REMAINDERF_TOLERANCE, 0},
{1405, 1061997773u, 3208642560u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{1406, 1061997773u, 3207803699u, 1036831952u, 0, REMAINDERF_TOLERANCE, 0},
{1407, 1061997773u, 3206964838u, 1041865116u, 0, REMAINDERF_TOLERANCE, 0},
{1408, 1061997773u, 3206125978u, 1045220556u, 0, REMAINDERF_TOLERANCE, 0},
{1409, 1061997773u, 3205287117u, 1048576000u, 0, REMAINDERF_TOLERANCE, 0},
{1410, 1061997773u, 3204448256u, 3192704204u, 0, REMAINDERF_TOLERANCE, 0},
{1411, 1061997773u, 3202770534u, 3184315592u, 0, REMAINDERF_TOLERANCE, 0},
{1412, 1061997773u, 3201092813u, 0u, 0, REMAINDERF_TOLERANCE, 0},
{1413, 1061997773u, 3199415091u, 1036831952u, 0, REMAINDERF_TOLERANCE, 0},
{1414, 1061997773u, 3197737370u, 3184315600u, 0, REMAINDERF_TOLERANCE, 0},
{1415, 1061997773u, 3196059648u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{1416, 1061997773u, 3192704205u, 0u, 0, REMAINDERF_TOLERANCE, 0},
{1417, 1061997773u, 3189348762u, 1028443336u, 0, REMAINDERF_TOLERANCE, 0},
{1418, 1061997773u, 3184315597u, 0u, 0, REMAINDERF_TOLERANCE, 0},
{1419, 1061997773u, 3175926989u, 0u, 0, REMAINDERF_TOLERANCE, 0},
{1420, 1061997773u, 632815616u, 612368384u, 0, REMAINDERF_TOLERANCE, 0},
{1421, 1061997773u, 1028443341u, 0u, 0, REMAINDERF_TOLERANCE, 0},
{1422, 1061997773u, 1036831949u, 0u, 0, REMAINDERF_TOLERANCE, 0},
{1423, 1061997773u, 1041865114u, 1028443336u, 0, REMAINDERF_TOLERANCE, 0},
{1424, 1061997773u, 1045220557u, 0u, 0, REMAINDERF_TOLERANCE, 0},
{1425, 1061997773u, 1048576000u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{1426, 1061997773u, 1050253722u, 3184315600u, 0, REMAINDERF_TOLERANCE, 0},
{1427, 1061997773u, 1051931443u, 1036831952u, 0, REMAINDERF_TOLERANCE, 0},
{1428, 1061997773u, 1053609165u, 0u, 0, REMAINDERF_TOLERANCE, 0},
{1429, 1061997773u, 1055286886u, 3184315592u, 0, REMAINDERF_TOLERANCE, 0},
{1430, 1061997773u, 1056964608u, 3192704204u, 0, REMAINDERF_TOLERANCE, 0},
{1431, 1061997773u, 1057803469u, 1048576000u, 0, REMAINDERF_TOLERANCE, 0},
{1432, 1061997773u, 1058642330u, 1045220556u, 0, REMAINDERF_TOLERANCE, 0},
{1433, 1061997773u, 1059481190u, 1041865116u, 0, REMAINDERF_TOLERANCE, 0},
{1434, 1061997773u, 1060320051u, 1036831952u, 0, REMAINDERF_TOLERANCE, 0},
{1435, 1061997773u, 1061158912u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{1436, 1061997773u, 1061997773u, 0u, 0, REMAINDERF_TOLERANCE, 0},
{1437, 1061997773u, 1062836634u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{1438, 1061997773u, 1063675494u, 3184315592u, 0, REMAINDERF_TOLERANCE, 0},
{1439, 1061997773u, 1064514355u, 3189348760u, 0, REMAINDERF_TOLERANCE, 0},
{1440, 1062836634u, 3212836864u, 3189348760u, 0, REMAINDERF_TOLERANCE, 0},
{1441, 1062836634u, 3211998003u, 3184315592u, 0, REMAINDERF_TOLERANCE, 0},
{1442, 1062836634u, 3211159142u, 3175926976u, 0, REMAINDERF_TOLERANCE, 0},
{1443, 1062836634u, 3210320282u, 0u, 0, REMAINDERF_TOLERANCE, 0},
{1444, 1062836634u, 3209481421u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{1445, 1062836634u, 3208642560u, 1036831952u, 0, REMAINDERF_TOLERANCE, 0},
{1446, 1062836634u, 3207803699u, 1041865116u, 0, REMAINDERF_TOLERANCE, 0},
{1447, 1062836634u, 3206964838u, 1045220560u, 0, REMAINDERF_TOLERANCE, 0},
{1448, 1062836634u, 3206125978u, 1048576000u, 0, REMAINDERF_TOLERANCE, 0},
{1449, 1062836634u, 3205287117u, 3196059648u, 0, REMAINDERF_TOLERANCE, 0},
{1450, 1062836634u, 3204448256u, 3189348760u, 0, REMAINDERF_TOLERANCE, 0},
{1451, 1062836634u, 3202770534u, 3175926976u, 0, REMAINDERF_TOLERANCE, 0},
{1452, 1062836634u, 3201092813u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{1453, 1062836634u, 3199415091u, 1041865116u, 0, REMAINDERF_TOLERANCE, 0},
{1454, 1062836634u, 3197737370u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{1455, 1062836634u, 3196059648u, 1036831952u, 0, REMAINDERF_TOLERANCE, 0},
{1456, 1062836634u, 3192704205u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{1457, 1062836634u, 3189348762u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{1458, 1062836634u, 3184315597u, 3175926986u, 0, REMAINDERF_TOLERANCE, 0},
{1459, 1062836634u, 3175926989u, 843055104u, 0, REMAINDERF_TOLERANCE, 0},
{1460, 1062836634u, 632815616u, 2761949184u, 0, REMAINDERF_TOLERANCE, 0},
{1461, 1062836634u, 1028443341u, 843055104u, 0, REMAINDERF_TOLERANCE, 0},
{1462, 1062836634u, 1036831949u, 3175926986u, 0, REMAINDERF_TOLERANCE, 0},
{1463, 1062836634u, 1041865114u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{1464, 1062836634u, 1045220557u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{1465, 1062836634u, 1048576000u, 1036831952u, 0, REMAINDERF_TOLERANCE, 0},
{1466, 1062836634u, 1050253722u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{1467, 1062836634u, 1051931443u, 1041865116u, 0, REMAINDERF_TOLERANCE, 0},
{1468, 1062836634u, 1053609165u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{1469, 1062836634u, 1055286886u, 3175926976u, 0, REMAINDERF_TOLERANCE, 0},
{1470, 1062836634u, 1056964608u, 3189348760u, 0, REMAINDERF_TOLERANCE, 0},
{1471, 1062836634u, 1057803469u, 3196059648u, 0, REMAINDERF_TOLERANCE, 0},
{1472, 1062836634u, 1058642330u, 1048576000u, 0, REMAINDERF_TOLERANCE, 0},
{1473, 1062836634u, 1059481190u, 1045220560u, 0, REMAINDERF_TOLERANCE, 0},
{1474, 1062836634u, 1060320051u, 1041865116u, 0, REMAINDERF_TOLERANCE, 0},
{1475, 1062836634u, 1061158912u, 1036831952u, 0, REMAINDERF_TOLERANCE, 0},
{1476, 1062836634u, 1061997773u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{1477, 1062836634u, 1062836634u, 0u, 0, REMAINDERF_TOLERANCE, 0},
{1478, 1062836634u, 1063675494u, 3175926976u, 0, REMAINDERF_TOLERANCE, 0},
{1479, 1062836634u, 1064514355u, 3184315592u, 0, REMAINDERF_TOLERANCE, 0},
{1480, 1063675494u, 3212836864u, 3184315600u, 0, REMAINDERF_TOLERANCE, 0},
{1481, 1063675494u, 3211998003u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{1482, 1063675494u, 3211159142u, 0u, 0, REMAINDERF_TOLERANCE, 0},
{1483, 1063675494u, 3210320282u, 1028443328u, 0, REMAINDERF_TOLERANCE, 0},
{1484, 1063675494u, 3209481421u, 1036831944u, 0, REMAINDERF_TOLERANCE, 0},
{1485, 1063675494u, 3208642560u, 1041865112u, 0, REMAINDERF_TOLERANCE, 0},
{1486, 1063675494u, 3207803699u, 1045220556u, 0, REMAINDERF_TOLERANCE, 0},
{1487, 1063675494u, 3206964838u, 1048576000u, 0, REMAINDERF_TOLERANCE, 0},
{1488, 1063675494u, 3206125978u, 1050253720u, 0, REMAINDERF_TOLERANCE, 0},
{1489, 1063675494u, 3205287117u, 3192704208u, 0, REMAINDERF_TOLERANCE, 0},
{1490, 1063675494u, 3204448256u, 3184315600u, 0, REMAINDERF_TOLERANCE, 0},
{1491, 1063675494u, 3202770534u, 0u, 0, REMAINDERF_TOLERANCE, 0},
{1492, 1063675494u, 3201092813u, 1036831944u, 0, REMAINDERF_TOLERANCE, 0},
{1493, 1063675494u, 3199415091u, 3189348762u, 0, REMAINDERF_TOLERANCE, 0},
{1494, 1063675494u, 3197737370u, 3011510272u, 0, REMAINDERF_TOLERANCE, 0},
{1495, 1063675494u, 3196059648u, 3184315600u, 0, REMAINDERF_TOLERANCE, 0},
{1496, 1063675494u, 3192704205u, 1036831944u, 0, REMAINDERF_TOLERANCE, 0},
{1497, 1063675494u, 3189348762u, 3011510272u, 0, REMAINDERF_TOLERANCE, 0},
{1498, 1063675494u, 3184315597u, 3005218816u, 0, REMAINDERF_TOLERANCE, 0},
{1499, 1063675494u, 3175926989u, 3005218816u, 0, REMAINDERF_TOLERANCE, 0},
{1500, 1063675494u, 632815616u, 2755657728u, 0, REMAINDERF_TOLERANCE, 0},
{1501, 1063675494u, 1028443341u, 3005218816u, 0, REMAINDERF_TOLERANCE, 0},
{1502, 1063675494u, 1036831949u, 3005218816u, 0, REMAINDERF_TOLERANCE, 0},
{1503, 1063675494u, 1041865114u, 3011510272u, 0, REMAINDERF_TOLERANCE, 0},
{1504, 1063675494u, 1045220557u, 1036831944u, 0, REMAINDERF_TOLERANCE, 0},
{1505, 1063675494u, 1048576000u, 3184315600u, 0, REMAINDERF_TOLERANCE, 0},
{1506, 1063675494u, 1050253722u, 3011510272u, 0, REMAINDERF_TOLERANCE, 0},
{1507, 1063675494u, 1051931443u, 3189348762u, 0, REMAINDERF_TOLERANCE, 0},
{1508, 1063675494u, 1053609165u, 1036831944u, 0, REMAINDERF_TOLERANCE, 0},
{1509, 1063675494u, 1055286886u, 0u, 0, REMAINDERF_TOLERANCE, 0},
{1510, 1063675494u, 1056964608u, 3184315600u, 0, REMAINDERF_TOLERANCE, 0},
{1511, 1063675494u, 1057803469u, 3192704208u, 0, REMAINDERF_TOLERANCE, 0},
{1512, 1063675494u, 1058642330u, 1050253720u, 0, REMAINDERF_TOLERANCE, 0},
{1513, 1063675494u, 1059481190u, 1048576000u, 0, REMAINDERF_TOLERANCE, 0},
{1514, 1063675494u, 1060320051u, 1045220556u, 0, REMAINDERF_TOLERANCE, 0},
{1515, 1063675494u, 1061158912u, 1041865112u, 0, REMAINDERF_TOLERANCE, 0},
{1516, 1063675494u, 1061997773u, 1036831944u, 0, REMAINDERF_TOLERANCE, 0},
{1517, 1063675494u, 1062836634u, 1028443328u, 0, REMAINDERF_TOLERANCE, 0},
{1518, 1063675494u, 1063675494u, 0u, 0, REMAINDERF_TOLERANCE, 0},
{1519, 1063675494u, 1064514355u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{1520, 1064514355u, 3212836864u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{1521, 1064514355u, 3211998003u, 0u, 0, REMAINDERF_TOLERANCE, 0},
{1522, 1064514355u, 3211159142u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{1523, 1064514355u, 3210320282u, 1036831944u, 0, REMAINDERF_TOLERANCE, 0},
{1524, 1064514355u, 3209481421u, 1041865112u, 0, REMAINDERF_TOLERANCE, 0},
{1525, 1064514355u, 3208642560u, 1045220556u, 0, REMAINDERF_TOLERANCE, 0},
{1526, 1064514355u, 3207803699u, 1048576000u, 0, REMAINDERF_TOLERANCE, 0},
{1527, 1064514355u, 3206964838u, 1050253722u, 0, REMAINDERF_TOLERANCE, 0},
{1528, 1064514355u, 3206125978u, 3196059650u, 0, REMAINDERF_TOLERANCE, 0},
{1529, 1064514355u, 3205287117u, 3189348764u, 0, REMAINDERF_TOLERANCE, 0},
{1530, 1064514355u, 3204448256u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{1531, 1064514355u, 3202770534u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{1532, 1064514355u, 3201092813u, 1041865112u, 0, REMAINDERF_TOLERANCE, 0},
{1533, 1064514355u, 3199415091u, 3184315596u, 0, REMAINDERF_TOLERANCE, 0},
{1534, 1064514355u, 3197737370u, 1028443328u, 0, REMAINDERF_TOLERANCE, 0},
{1535, 1064514355u, 3196059648u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{1536, 1064514355u, 3192704205u, 3175926996u, 0, REMAINDERF_TOLERANCE, 0},
{1537, 1064514355u, 3189348762u, 1028443328u, 0, REMAINDERF_TOLERANCE, 0},
{1538, 1064514355u, 3184315597u, 1028443334u, 0, REMAINDERF_TOLERANCE, 0},
{1539, 1064514355u, 3175926989u, 3001024512u, 0, REMAINDERF_TOLERANCE, 0},
{1540, 1064514355u, 632815616u, 623902720u, 0, REMAINDERF_TOLERANCE, 0},
{1541, 1064514355u, 1028443341u, 3001024512u, 0, REMAINDERF_TOLERANCE, 0},
{1542, 1064514355u, 1036831949u, 1028443334u, 0, REMAINDERF_TOLERANCE, 0},
{1543, 1064514355u, 1041865114u, 1028443328u, 0, REMAINDERF_TOLERANCE, 0},
{1544, 1064514355u, 1045220557u, 3175926996u, 0, REMAINDERF_TOLERANCE, 0},
{1545, 1064514355u, 1048576000u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{1546, 1064514355u, 1050253722u, 1028443328u, 0, REMAINDERF_TOLERANCE, 0},
{1547, 1064514355u, 1051931443u, 3184315596u, 0, REMAINDERF_TOLERANCE, 0},
{1548, 1064514355u, 1053609165u, 1041865112u, 0, REMAINDERF_TOLERANCE, 0},
{1549, 1064514355u, 1055286886u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{1550, 1064514355u, 1056964608u, 3175926992u, 0, REMAINDERF_TOLERANCE, 0},
{1551, 1064514355u, 1057803469u, 3189348764u, 0, REMAINDERF_TOLERANCE, 0},
{1552, 1064514355u, 1058642330u, 3196059650u, 0, REMAINDERF_TOLERANCE, 0},
{1553, 1064514355u, 1059481190u, 1050253722u, 0, REMAINDERF_TOLERANCE, 0},
{1554, 1064514355u, 1060320051u, 1048576000u, 0, REMAINDERF_TOLERANCE, 0},
{1555, 1064514355u, 1061158912u, 1045220556u, 0, REMAINDERF_TOLERANCE, 0},
{1556, 1064514355u, 1061997773u, 1041865112u, 0, REMAINDERF_TOLERANCE, 0},
{1557, 1064514355u, 1062836634u, 1036831944u, 0, REMAINDERF_TOLERANCE, 0},
{1558, 1064514355u, 1063675494u, 1028443344u, 0, REMAINDERF_TOLERANCE, 0},
{1559, 1064514355u, 1064514355u, 0u, 0, REMAINDERF_TOLERANCE, 0},
{1560, 1107800421u, 1203999711u, 1107800421u, 0, REMAINDERF_TOLERANCE, 0},
{1561, 3196650934u, 896005582u, 882096508u, 0, REMAINDERF_TOLERANCE, 0},
{1562, 3368700125u, 3308232444u, 3298314136u, 0, REMAINDERF_TOLERANCE, 0},
{1563, 1224242132u, 3061363425u, 3044549332u, 0, REMAINDERF_TOLERANCE, 0},
{1564, 1198712763u, 919636942u, 885884832u, 0, REMAINDERF_TOLERANCE, 0},
{1565, 3159309973u, 852521077u, 839902526u, 0, REMAINDERF_TOLERANCE, 0},
{1566, 954173073u, 850531830u, 825251472u, 0, REMAINDERF_TOLERANCE, 0},
{1567, 3090780435u, 1035260608u, 3090780435u, 0, REMAINDERF_TOLERANCE, 0},
{1568, 966554515u, 3234538174u, 966554515u, 0, REMAINDERF_TOLERANCE, 0},
{1569, 1312607135u, 1194999402u, 1185760896u, 0, REMAINDERF_TOLERANCE, 0},
{1570, 1166191415u, 1018661564u, 3139188608u, 0, REMAINDERF_TOLERANCE, 0},
{1571, 3111900019u, 1130472166u, 3111900019u, 0, REMAINDERF_TOLERANCE, 0},
{1572, 1234419246u, 2984575812u, 2976175128u, 0, REMAINDERF_TOLERANCE, 0},
{1573, 1302107128u, 3370647675u, 1194631160u, 0, REMAINDERF_TOLERANCE, 0},
{1574, 1052801068u, 3039122570u, 3028194648u, 0, REMAINDERF_TOLERANCE, 0},
{1575, 1060849628u, 3081357692u, 913794560u, 0, REMAINDERF_TOLERANCE, 0},
{1576, 3484320003u, 3033957825u, 3023031010u, 0, REMAINDERF_TOLERANCE, 0},
{1577, 3181522772u, 3305392896u, 3181522772u, 0, REMAINDERF_TOLERANCE, 0},
{1578, 1167223673u, 846102364u, 2976462032u, 0, REMAINDERF_TOLERANCE, 0},
{1579, 968192794u, 878547432u, 856689888u, 0, REMAINDERF_TOLERANCE, 0},
{1580, 3122346862u, 1111584337u, 3122346862u, 0, REMAINDERF_TOLERANCE, 0},
{1581, 906701409u, 2968301825u, 797588784u, 0, REMAINDERF_TOLERANCE, 0},
{1582, 3471653172u, 1154138102u, 1142724376u, 0, REMAINDERF_TOLERANCE, 0},
{1583, 3231467496u, 934336592u, 3050561280u, 0, REMAINDERF_TOLERANCE, 0},
{1584, 1341514497u, 3466051188u, 1309813400u, 0, REMAINDERF_TOLERANCE, 0},
{1585, 1272351391u, 3373485062u, 3362161896u, 0, REMAINDERF_TOLERANCE, 0},
{1586, 3319724992u, 3354615790u, 3319724992u, 0, REMAINDERF_TOLERANCE, 0},
{1587, 940236348u, 3304072663u, 940236348u, 0, REMAINDERF_TOLERANCE, 0},
{1588, 3251541546u, 3174764041u, 3165434950u, 0, REMAINDERF_TOLERANCE, 0},
{1589, 3099843889u, 3355962282u, 3099843889u, 0, REMAINDERF_TOLERANCE, 0},
{1590, 3110358400u, 851145088u, 836197376u, 0, REMAINDERF_TOLERANCE, 0},
{1591, 3371863479u, 1014861921u, 3143714060u, 0, REMAINDERF_TOLERANCE, 0},
{1592, 3204069187u, 966573255u, 951221204u, 0, REMAINDERF_TOLERANCE, 0},
{1593, 1306460502u, 903489435u, 3040775560u, 0, REMAINDERF_TOLERANCE, 0},
{1594, 1197542187u, 3024598921u, 3000922096u, 0, REMAINDERF_TOLERANCE, 0},
{1595, 1184239996u, 3224098462u, 1054844192u, 0, REMAINDERF_TOLERANCE, 0},
{1596, 1252490238u, 1173619825u, 3298879804u, 0, REMAINDERF_TOLERANCE, 0},
{1597, 1001673627u, 3462631271u, 1001673627u, 0, REMAINDERF_TOLERANCE, 0},
{1598, 976098044u, 1151967422u, 976098044u, 0, REMAINDERF_TOLERANCE, 0},
{1599, 941796645u, 886451963u, 867898772u, 0, REMAINDERF_TOLERANCE, 0},
{1600, 3287199470u, 854245542u, 841079712u, 0, REMAINDERF_TOLERANCE, 0},
{1601, 1143233714u, 1007268238u, 962500224u, 0, REMAINDERF_TOLERANCE, 0},
{1602, 1139941253u, 1147688821u, 3286142821u, 0, REMAINDERF_TOLERANCE, 0},
{1603, 3143717025u, 3234638157u, 3143717025u, 0, REMAINDERF_TOLERANCE, 0},
{1604, 3048866608u, 3449209899u, 3048866608u, 0, REMAINDERF_TOLERANCE, 0},
{1605, 3240298487u, 1020260821u, 3157016246u, 0, REMAINDERF_TOLERANCE, 0},
{1606, 1288902137u, 3123875978u, 3108655544u, 0, REMAINDERF_TOLERANCE, 0},
{1607, 1333134799u, 1338107877u, 3473787387u, 0, REMAINDERF_TOLERANCE, 0},
{1608, 1187847971u, 1317663644u, 1187847971u, 0, REMAINDERF_TOLERANCE, 0},
{1609, 3329354473u, 3165437289u, 3155146426u, 0, REMAINDERF_TOLERANCE, 0},
{1610, 1309289088u, 1019883016u, 984572800u, 0, REMAINDERF_TOLERANCE, 0},
{1611, 3444653659u, 1279248024u, 3414933016u, 0, REMAINDERF_TOLERANCE, 0},
{1612, 3405585402u, 2962345057u, 805631426u, 0, REMAINDERF_TOLERANCE, 0},
{1613, 3106647724u, 853848387u, 831766088u, 0, REMAINDERF_TOLERANCE, 0},
{1614, 1106778573u, 3304487767u, 1106778573u, 0, REMAINDERF_TOLERANCE, 0},
{1615, 1140567947u, 3069174149u, 3046837080u, 0, REMAINDERF_TOLERANCE, 0},
{1616, 1238569473u, 873035665u, 2979712896u, 0, REMAINDERF_TOLERANCE, 0},
{1617, 1261071232u, 1182202773u, 3319109886u, 0, REMAINDERF_TOLERANCE, 0},
{1618, 1175011025u, 3029705783u, 3017221104u, 0, REMAINDERF_TOLERANCE, 0},
{1619, 1082692850u, 1211581107u, 1082692850u, 0, REMAINDERF_TOLERANCE, 0},
{1620, 974547519u, 3475164509u, 974547519u, 0, REMAINDERF_TOLERANCE, 0},
{1621, 3058097085u, 3104309359u, 3058097085u, 0, REMAINDERF_TOLERANCE, 0},
{1622, 3107252546u, 1071134451u, 3107252546u, 0, REMAINDERF_TOLERANCE, 0},
{1623, 3096032662u, 2976848821u, 2936508032u, 0, REMAINDERF_TOLERANCE, 0},
{1624, 3197942144u, 3094120030u, 3069704000u, 0, REMAINDERF_TOLERANCE, 0},
{1625, 3403348556u, 3184653669u, 3175976148u, 0, REMAINDERF_TOLERANCE, 0},
{1626, 3182301130u, 3460764044u, 3182301130u, 0, REMAINDERF_TOLERANCE, 0},
{1627, 1136411063u, 1118097422u, 3255702228u, 0, REMAINDERF_TOLERANCE, 0},
{1628, 3239231622u, 3302723069u, 3239231622u, 0, REMAINDERF_TOLERANCE, 0},
{1629, 3340615780u, 870350055u, 3007060526u, 0, REMAINDERF_TOLERANCE, 0},
{1630, 998567360u, 2995278691u, 2976034720u, 0, REMAINDERF_TOLERANCE, 0},
{1631, 3417964312u, 1321337529u, 3417964312u, 0, REMAINDERF_TOLERANCE, 0},
{1632, 3109481038u, 1143864063u, 3109481038u, 0, REMAINDERF_TOLERANCE, 0},
{1633, 1148867223u, 1256486202u, 1148867223u, 0, REMAINDERF_TOLERANCE, 0},
{1634, 989687421u, 3372681320u, 989687421u, 0, REMAINDERF_TOLERANCE, 0},
{1635, 1152956913u, 3166480640u, 1010228736u, 0, REMAINDERF_TOLERANCE, 0},
{1636, 892922651u, 3373029087u, 892922651u, 0, REMAINDERF_TOLERANCE, 0},
{1637, 1307091856u, 1103202538u, 3226552416u, 0, REMAINDERF_TOLERANCE, 0},
{1638, 1077234132u, 3272167130u, 1077234132u, 0, REMAINDERF_TOLERANCE, 0},
{1639, 1142167709u, 1096445242u, 1084988676u, 0, REMAINDERF_TOLERANCE, 0},
{1640, 3426232834u, 1036705270u, 1027717904u, 0, REMAINDERF_TOLERANCE, 0},
{1641, 3368566779u, 967249167u, 3090485704u, 0, REMAINDERF_TOLERANCE, 0},
{1642, 3030724760u, 3349013503u, 3030724760u, 0, REMAINDERF_TOLERANCE, 0},
{1643, 1138741813u, 3073453199u, 913937868u, 0, REMAINDERF_TOLERANCE, 0},
{1644, 982950501u, 982549888u, 943955104u, 0, REMAINDERF_TOLERANCE, 0},
{1645, 1142981585u, 1015602236u, 3153640960u, 0, REMAINDERF_TOLERANCE, 0},
{1646, 3347165962u, 3135486696u, 967160064u, 0, REMAINDERF_TOLERANCE, 0},
{1647, 1009535440u, 3381353228u, 1009535440u, 0, REMAINDERF_TOLERANCE, 0},
{1648, 3103736980u, 3402950505u, 3103736980u, 0, REMAINDERF_TOLERANCE, 0},
{1649, 3126820946u, 1077903063u, 3126820946u, 0, REMAINDERF_TOLERANCE, 0},
{1650, 3473956030u, 976891930u, 3114088028u, 0, REMAINDERF_TOLERANCE, 0},
{1651, 3349098349u, 1055327704u, 3180791072u, 0, REMAINDERF_TOLERANCE, 0},
{1652, 3152729489u, 1060398533u, 3152729489u, 0, REMAINDERF_TOLERANCE, 0},
{1653, 945568720u, 3313485084u, 945568720u, 0, REMAINDERF_TOLERANCE, 0},
{1654, 3345489836u, 1108392401u, 3243992536u, 0, REMAINDERF_TOLERANCE, 0},
{1655, 976791751u, 3230678102u, 976791751u, 0, REMAINDERF_TOLERANCE, 0},
{1656, 1004442355u, 3036510596u, 3022957208u, 0, REMAINDERF_TOLERANCE, 0},
{1657, 1108485380u, 3173536878u, 987480128u, 0, REMAINDERF_TOLERANCE, 0},
{1658, 1061834641u, 972388096u, 3082944512u, 0, REMAINDERF_TOLERANCE, 0},
{1659, 3381268392u, 1146976802u, 1134163764u, 0, REMAINDERF_TOLERANCE, 0},
{1660, 1087189715u, 2952822478u, 789171392u, 0, REMAINDERF_TOLERANCE, 0},
{1661, 3212952285u, 3329407365u, 3212952285u, 0, REMAINDERF_TOLERANCE, 0},
{1662, 1000611335u, 857599439u, 2957130752u, 0, REMAINDERF_TOLERANCE, 0},
{1663, 3466188568u, 1041678304u, 3175744512u, 0, REMAINDERF_TOLERANCE, 0},
{1664, 3072456205u, 3160254633u, 3072456205u, 0, REMAINDERF_TOLERANCE, 0},
{1665, 3319315516u, 3422089012u, 3319315516u, 0, REMAINDERF_TOLERANCE, 0},
{1666, 3212614372u, 1152633030u, 3212614372u, 0, REMAINDERF_TOLERANCE, 0},
{1667, 1315030230u, 3336225884u, 3318117360u, 0, REMAINDERF_TOLERANCE, 0},
{1668, 1134593658u, 3456812581u, 1134593658u, 0, REMAINDERF_TOLERANCE, 0},
{1669, 977281449u, 879922831u, 870852568u, 0, REMAINDERF_TOLERANCE, 0},
{1670, 1086198791u, 920125958u, 3058317260u, 0, REMAINDERF_TOLERANCE, 0},
{1671, 1255152035u, 851754050u, 2941965824u, 0, REMAINDERF_TOLERANCE, 0},
{1672, 1135271264u, 3284878412u, 3263273904u, 0, REMAINDERF_TOLERANCE, 0},
{1673, 1094190727u, 1056854532u, 1033751056u, 0, REMAINDERF_TOLERANCE, 0},
{1674, 1294665325u, 991185677u, 3117296032u, 0, REMAINDERF_TOLERANCE, 0},
{1675, 1036608591u, 805416536u, 2936971008u, 0, REMAINDERF_TOLERANCE, 0},
{1676, 3229998064u, 825237063u, 815291510u, 0, REMAINDERF_TOLERANCE, 0},
{1677, 3439134022u, 1043829691u, 3176027496u, 0, REMAINDERF_TOLERANCE, 0},
{1678, 1325668223u, 970681762u, 927876224u, 0, REMAINDERF_TOLERANCE, 0},
{1679, 1092037607u, 1027330835u, 989911904u, 0, REMAINDERF_TOLERANCE, 0},
{1680, 3316278408u, 3455589207u, 3316278408u, 0, REMAINDERF_TOLERANCE, 0},
{1681, 3295436768u, 3129873731u, 3121435968u, 0, REMAINDERF_TOLERANCE, 0},
{1682, 1151984049u, 3074547120u, 916078880u, 0, REMAINDERF_TOLERANCE, 0},
{1683, 1129287043u, 3076527544u, 3043337472u, 0, REMAINDERF_TOLERANCE, 0},
{1684, 1243664530u, 972879810u, 961936076u, 0, REMAINDERF_TOLERANCE, 0},
{1685, 950829092u, 929114193u, 904427984u, 0, REMAINDERF_TOLERANCE, 0},
{1686, 1115471979u, 3047246262u, 882754776u, 0, REMAINDERF_TOLERANCE, 0},
{1687, 3351092088u, 3024661404u, 857377760u, 0, REMAINDERF_TOLERANCE, 0},
{1688, 3424479544u, 3312047722u, 3286030960u, 0, REMAINDERF_TOLERANCE, 0},
{1689, 3241193975u, 884465785u, 865361832u, 0, REMAINDERF_TOLERANCE, 0},
{1690, 1030934236u, 1045139240u, 1030934236u, 0, REMAINDERF_TOLERANCE, 0},
{1691, 3131791114u, 3408392958u, 3131791114u, 0, REMAINDERF_TOLERANCE, 0},
{1692, 1025254314u, 3057812821u, 892099028u, 0, REMAINDERF_TOLERANCE, 0},
{1693, 1110545760u, 3240144177u, 1082605944u, 0, REMAINDERF_TOLERANCE, 0},
{1694, 3180213739u, 1108793820u, 3180213739u, 0, REMAINDERF_TOLERANCE, 0},
{1695, 3361976590u, 3138179993u, 3123449732u, 0, REMAINDERF_TOLERANCE, 0},
{1696, 881280146u, 3421884736u, 881280146u, 0, REMAINDERF_TOLERANCE, 0},
{1697, 1304154705u, 2961937089u, 806053242u, 0, REMAINDERF_TOLERANCE, 0},
{1698, 3264443610u, 3222916705u, 1061521916u, 0, REMAINDERF_TOLERANCE, 0},
{1699, 3374550627u, 3055856293u, 3046700470u, 0, REMAINDERF_TOLERANCE, 0},
{1700, 899599265u, 3240118211u, 899599265u, 0, REMAINDERF_TOLERANCE, 0},
{1701, 1268194719u, 1332489410u, 1268194719u, 0, REMAINDERF_TOLERANCE, 0},
{1702, 1133420220u, 1245770860u, 1133420220u, 0, REMAINDERF_TOLERANCE, 0},
{1703, 1161858787u, 815362075u, 2940727152u, 0, REMAINDERF_TOLERANCE, 0},
{1704, 3295996963u, 3453334307u, 3295996963u, 0, REMAINDERF_TOLERANCE, 0},
{1705, 1270887389u, 1156123987u, 1136651424u, 0, REMAINDERF_TOLERANCE, 0},
{1706, 3325193181u, 993979179u, 3128968444u, 0, REMAINDERF_TOLERANCE, 0},
{1707, 3115275450u, 3008350271u, 850287230u, 0, REMAINDERF_TOLERANCE, 0},
{1708, 3116607482u, 3224327456u, 3116607482u, 0, REMAINDERF_TOLERANCE, 0},
{1709, 3187892415u, 3118097315u, 3058627072u, 0, REMAINDERF_TOLERANCE, 0},
{1710, 1189120494u, 978961471u, 3116486970u, 0, REMAINDERF_TOLERANCE, 0},
{1711, 889030794u, 3129523970u, 889030794u, 0, REMAINDERF_TOLERANCE, 0},
{1712, 1323529208u, 3100744786u, 933418032u, 0, REMAINDERF_TOLERANCE, 0},
{1713, 3465768388u, 3190881451u, 3088019456u, 0, REMAINDERF_TOLERANCE, 0},
{1714, 3426099899u, 1118756120u, 3256863216u, 0, REMAINDERF_TOLERANCE, 0},
{1715, 3224857113u, 3398166843u, 3224857113u, 0, REMAINDERF_TOLERANCE, 0},
{1716, 1065798296u, 816191940u, 802953808u, 0, REMAINDERF_TOLERANCE, 0},
{1717, 3328989444u, 850266225u, 2989327724u, 0, REMAINDERF_TOLERANCE, 0},
{1718, 3357819026u, 3148475462u, 3131211808u, 0, REMAINDERF_TOLERANCE, 0},
{1719, 1273397670u, 901308750u, 3030947488u, 0, REMAINDERF_TOLERANCE, 0},
{1720, 3424831780u, 1304806106u, 3424831780u, 0, REMAINDERF_TOLERANCE, 0},
{1721, 1257596246u, 3420832544u, 1257596246u, 0, REMAINDERF_TOLERANCE, 0},
{1722, 1051773536u, 896271348u, 3007754304u, 0, REMAINDERF_TOLERANCE, 0},
{1723, 3294752507u, 3113225954u, 3104157972u, 0, REMAINDERF_TOLERANCE, 0},
{1724, 3424848725u, 2973850350u, 816846232u, 0, REMAINDERF_TOLERANCE, 0},
{1725, 1090870906u, 3294742905u, 1090870906u, 0, REMAINDERF_TOLERANCE, 0},
{1726, 1227582289u, 1208979668u, 3338705792u, 0, REMAINDERF_TOLERANCE, 0},
{1727, 1272325814u, 3004311296u, 2994725888u, 0, REMAINDERF_TOLERANCE, 0},
{1728, 3359508271u, 859974315u, 848405304u, 0, REMAINDERF_TOLERANCE, 0},
{1729, 1137854355u, 3335041917u, 1137854355u, 0, REMAINDERF_TOLERANCE, 0},
{1730, 3440773058u, 3204192793u, 1030651208u, 0, REMAINDERF_TOLERANCE, 0},
{1731, 3101598400u, 3057760708u, 892208464u, 0, REMAINDERF_TOLERANCE, 0},
{1732, 3451216836u, 3347783723u, 3332701232u, 0, REMAINDERF_TOLERANCE, 0},
{1733, 3437062994u, 3106834845u, 3071458160u, 0, REMAINDERF_TOLERANCE, 0},
{1734, 1131196082u, 1164573183u, 1131196082u, 0, REMAINDERF_TOLERANCE, 0},
{1735, 3460915348u, 1219372260u, 3351088128u, 0, REMAINDERF_TOLERANCE, 0},
{1736, 3303035472u, 3153013020u, 975757344u, 0, REMAINDERF_TOLERANCE, 0},
{1737, 1053698677u, 3284313107u, 1053698677u, 0, REMAINDERF_TOLERANCE, 0},
{1738, 3396166221u, 1201894512u, 3340417792u, 0, REMAINDERF_TOLERANCE, 0},
{1739, 3458934263u, 1005577835u, 995171350u, 0, REMAINDERF_TOLERANCE, 0},
{1740, 1065761827u, 3333928591u, 1065761827u, 0, REMAINDERF_TOLERANCE, 0},
{1741, 3025843188u, 820250112u, 802398208u, 0, REMAINDERF_TOLERANCE, 0},
{1742, 926665223u, 3150815797u, 926665223u, 0, REMAINDERF_TOLERANCE, 0},
{1743, 1199816046u, 3143776186u, 3118363744u, 0, REMAINDERF_TOLERANCE, 0},
{1744, 3333779015u, 952421041u, 3088442550u, 0, REMAINDERF_TOLERANCE, 0},
{1745, 948398145u, 3238273189u, 948398145u, 0, REMAINDERF_TOLERANCE, 0},
{1746, 1080781593u, 1213908300u, 1080781593u, 0, REMAINDERF_TOLERANCE, 0},
{1747, 3164749613u, 3010837763u, 805593536u, 0, REMAINDERF_TOLERANCE, 0},
{1748, 3235326590u, 1271705594u, 3235326590u, 0, REMAINDERF_TOLERANCE, 0},
{1749, 3118883815u, 1051802647u, 3118883815u, 0, REMAINDERF_TOLERANCE, 0},
{1750, 3226990408u, 1110755136u, 3226990408u, 0, REMAINDERF_TOLERANCE, 0},
{1751, 3117098218u, 1122474770u, 3117098218u, 0, REMAINDERF_TOLERANCE, 0},
{1752, 1283624229u, 906796922u, 893859424u, 0, REMAINDERF_TOLERANCE, 0},
{1753, 970649315u, 1078286437u, 970649315u, 0, REMAINDERF_TOLERANCE, 0},
{1754, 959776291u, 3280345347u, 959776291u, 0, REMAINDERF_TOLERANCE, 0},
{1755, 3341117305u, 3294559023u, 3285418302u, 0, REMAINDERF_TOLERANCE, 0},
{1756, 1270734970u, 3355874874u, 3344951304u, 0, REMAINDERF_TOLERANCE, 0},
{1757, 3454816067u, 868771977u, 843230680u, 0, REMAINDERF_TOLERANCE, 0},
{1758, 1106502045u, 1290849316u, 1106502045u, 0, REMAINDERF_TOLERANCE, 0},
{1759, 1157598381u, 3309023746u, 3295653550u, 0, REMAINDERF_TOLERANCE, 0},
{1760, 3335234513u, 1002337336u, 3134023072u, 0, REMAINDERF_TOLERANCE, 0},
{1761, 1279489061u, 1006049444u, 3142664432u, 0, REMAINDERF_TOLERANCE, 0},
{1762, 3143920719u, 3131608518u, 969097936u, 0, REMAINDERF_TOLERANCE, 0},
{1763, 1233171235u, 826460580u, 789268992u, 0, REMAINDERF_TOLERANCE, 0},
{1764, 1148920078u, 1007674793u, 995580876u, 0, REMAINDERF_TOLERANCE, 0},
{1765, 3064988156u, 3230867340u, 3064988156u, 0, REMAINDERF_TOLERANCE, 0},
{1766, 1109198803u, 1221754614u, 1109198803u, 0, REMAINDERF_TOLERANCE, 0},
{1767, 3219949483u, 1056167693u, 1030351936u, 0, REMAINDERF_TOLERANCE, 0},
{1768, 3361149474u, 3387342069u, 3361149474u, 0, REMAINDERF_TOLERANCE, 0},
{1769, 1207502108u, 3388073586u, 1207502108u, 0, REMAINDERF_TOLERANCE, 0},
{1770, 1000014431u, 831213088u, 2968051712u, 0, REMAINDERF_TOLERANCE, 0},
{1771, 3161756316u, 3143659754u, 3131116944u, 0, REMAINDERF_TOLERANCE, 0},
{1772, 3160728744u, 3382954009u, 3160728744u, 0, REMAINDERF_TOLERANCE, 0},
{1773, 1234530539u, 1079988872u, 3205280992u, 0, REMAINDERF_TOLERANCE, 0},
{1774, 1017843965u, 1193076204u, 1017843965u, 0, REMAINDERF_TOLERANCE, 0},
{1775, 3306328852u, 1118701064u, 1082393984u, 0, REMAINDERF_TOLERANCE, 0},
{1776, 1291910469u, 1211303367u, 3339079352u, 0, REMAINDERF_TOLERANCE, 0},
{1777, 1131927531u, 3182962700u, 1019272000u, 0, REMAINDERF_TOLERANCE, 0},
{1778, 3449879391u, 991614550u, 3126666016u, 0, REMAINDERF_TOLERANCE, 0},
{1779, 970094304u, 3344590506u, 970094304u, 0, REMAINDERF_TOLERANCE, 0},
{1780, 1125551064u, 3331248076u, 1125551064u, 0, REMAINDERF_TOLERANCE, 0},
{1781, 3427296372u, 3455289118u, 3427296372u, 0, REMAINDERF_TOLERANCE, 0},
{1782, 1198917460u, 1327195159u, 1198917460u, 0, REMAINDERF_TOLERANCE, 0},
{1783, 3201603336u, 820047343u, 2945749204u, 0, REMAINDERF_TOLERANCE, 0},
{1784, 3114686212u, 3476082461u, 3114686212u, 0, REMAINDERF_TOLERANCE, 0},
{1785, 921940707u, 2967544056u, 2943794048u, 0, REMAINDERF_TOLERANCE, 0},
{1786, 1091906532u, 3011904455u, 841227264u, 0, REMAINDERF_TOLERANCE, 0},
{1787, 3393557778u, 3383396815u, 3369622040u, 0, REMAINDERF_TOLERANCE, 0},
{1788, 1276853215u, 873199561u, 863650072u, 0, REMAINDERF_TOLERANCE, 0},
{1789, 3462778440u, 3349284325u, 3325803400u, 0, REMAINDERF_TOLERANCE, 0},
{1790, 3360170117u, 3048354042u, 870847968u, 0, REMAINDERF_TOLERANCE, 0},
{1791, 3224245428u, 3271307999u, 3224245428u, 0, REMAINDERF_TOLERANCE, 0},
{1792, 1120124467u, 1135619937u, 1120124467u, 0, REMAINDERF_TOLERANCE, 0},
{1793, 1064364381u, 3180675544u, 3151024384u, 0, REMAINDERF_TOLERANCE, 0},
{1794, 1268744779u, 3328452652u, 3308877952u, 0, REMAINDERF_TOLERANCE, 0},
{1795, 1165195428u, 3390323168u, 1165195428u, 0, REMAINDERF_TOLERANCE, 0},
{1796, 3247790039u, 909788142u, 3039398736u, 0, REMAINDERF_TOLERANCE, 0},
{1797, 3215244648u, 1083988595u, 3215244648u, 0, REMAINDERF_TOLERANCE, 0},
{1798, 3095275931u, 989153382u, 3095275931u, 0, REMAINDERF_TOLERANCE, 0},
{1799, 1212717473u, 837873779u, 826399162u, 0, REMAINDERF_TOLERANCE, 0},
{1800, 3275973009u, 3450721670u, 3275973009u, 0, REMAINDERF_TOLERANCE, 0},
{1801, 3028857014u, 3188853813u, 3028857014u, 0, REMAINDERF_TOLERANCE, 0},
{1802, 3391162308u, 1291220039u, 3391162308u, 0, REMAINDERF_TOLERANCE, 0},
{1803, 1044867873u, 3369493273u, 1044867873u, 0, REMAINDERF_TOLERANCE, 0},
{1804, 1089986803u, 3462160118u, 1089986803u, 0, REMAINDERF_TOLERANCE, 0},
{1805, 1296314700u, 2957454177u, 794053992u, 0, REMAINDERF_TOLERANCE, 0},
{1806, 1251462432u, 3171021770u, 3158130160u, 0, REMAINDERF_TOLERANCE, 0},
{1807, 3485236902u, 980772835u, 966641182u, 0, REMAINDERF_TOLERANCE, 0},
{1808, 3262169538u, 1268270462u, 3262169538u, 0, REMAINDERF_TOLERANCE, 0},
{1809, 3080852256u, 994641495u, 3080852256u, 0, REMAINDERF_TOLERANCE, 0},
{1810, 1022211242u, 922124181u, 3041880112u, 0, REMAINDERF_TOLERANCE, 0},
{1811, 884661176u, 2985540645u, 805220016u, 0, REMAINDERF_TOLERANCE, 0},
{1812, 3071422941u, 3271100396u, 3071422941u, 0, REMAINDERF_TOLERANCE, 0},
{1813, 989762529u, 3362011135u, 989762529u, 0, REMAINDERF_TOLERANCE, 0},
{1814, 1295475718u, 3212305413u, 3203032832u, 0, REMAINDERF_TOLERANCE, 0},
{1815, 1002632518u, 3330388441u, 1002632518u, 0, REMAINDERF_TOLERANCE, 0},
{1816, 3404372005u, 3450484255u, 3404372005u, 0, REMAINDERF_TOLERANCE, 0},
{1817, 3158912530u, 3105501826u, 949623888u, 0, REMAINDERF_TOLERANCE, 0},
{1818, 1125800069u, 3256265749u, 1080761344u, 0, REMAINDERF_TOLERANCE, 0},
{1819, 3138037576u, 3103365227u, 937376280u, 0, REMAINDERF_TOLERANCE, 0},
{1820, 999985470u, 3409354318u, 999985470u, 0, REMAINDERF_TOLERANCE, 0},
{1821, 1189421739u, 1056599002u, 1045697052u, 0, REMAINDERF_TOLERANCE, 0},
{1822, 3075182644u, 3144159778u, 3075182644u, 0, REMAINDERF_TOLERANCE, 0},
{1823, 3028099649u, 3391513557u, 3028099649u, 0, REMAINDERF_TOLERANCE, 0},
{1824, 3132541814u, 3444521949u, 3132541814u, 0, REMAINDERF_TOLERANCE, 0},
{1825, 1164046161u, 3440635788u, 1164046161u, 0, REMAINDERF_TOLERANCE, 0},
{1826, 1292596266u, 3116569667u, 3096394216u, 0, REMAINDERF_TOLERANCE, 0},
{1827, 3469748379u, 3412765608u, 1255687840u, 0, REMAINDERF_TOLERANCE, 0},
{1828, 1314644642u, 3123051784u, 3111935360u, 0, REMAINDERF_TOLERANCE, 0},
{1829, 3399813173u, 828743798u, 819389240u, 0, REMAINDERF_TOLERANCE, 0},
{1830, 948775569u, 3485444126u, 948775569u, 0, REMAINDERF_TOLERANCE, 0},
{1831, 1034611395u, 882288581u, 3007845568u, 0, REMAINDERF_TOLERANCE, 0},
{1832, 3489122735u, 3372450889u, 3359775640u, 0, REMAINDERF_TOLERANCE, 0},
{1833, 1181604787u, 3363067409u, 1181604787u, 0, REMAINDERF_TOLERANCE, 0},
{1834, 3059042077u, 3204983963u, 3059042077u, 0, REMAINDERF_TOLERANCE, 0},
{1835, 1043691622u, 3402603223u, 1043691622u, 0, REMAINDERF_TOLERANCE, 0},
{1836, 1314588083u, 856187848u, 816680192u, 0, REMAINDERF_TOLERANCE, 0},
{1837, 3141533334u, 3010142974u, 849931232u, 0, REMAINDERF_TOLERANCE, 0},
{1838, 3157534378u, 3451674717u, 3157534378u, 0, REMAINDERF_TOLERANCE, 0},
{1839, 3400949680u, 3073750220u, 3046724288u, 0, REMAINDERF_TOLERANCE, 0},
{1840, 3365581801u, 1175843167u, 3273128000u, 0, REMAINDERF_TOLERANCE, 0},
{1841, 1110424755u, 3011308654u, 2979891760u, 0, REMAINDERF_TOLERANCE, 0},
{1842, 3189917167u, 927278934u, 3062195652u, 0, REMAINDERF_TOLERANCE, 0},
{1843, 969804941u, 3355439348u, 969804941u, 0, REMAINDERF_TOLERANCE, 0},
{1844, 1139120919u, 3270515074u, 3249006256u, 0, REMAINDERF_TOLERANCE, 0},
{1845, 934308144u, 3118191228u, 934308144u, 0, REMAINDERF_TOLERANCE, 0},
{1846, 1220524226u, 1152648002u, 3287997832u, 0, REMAINDERF_TOLERANCE, 0},
{1847, 3162548604u, 3461790298u, 3162548604u, 0, REMAINDERF_TOLERANCE, 0},
{1848, 3382391700u, 3296962745u, 3269262352u, 0, REMAINDERF_TOLERANCE, 0},
{1849, 1156767533u, 1088986462u, 1074141164u, 0, REMAINDERF_TOLERANCE, 0},
{1850, 3079222483u, 3312324949u, 3079222483u, 0, REMAINDERF_TOLERANCE, 0},
{1851, 994934087u, 967678094u, 958601844u, 0, REMAINDERF_TOLERANCE, 0},
{1852, 3185240099u, 1123403720u, 3185240099u, 0, REMAINDERF_TOLERANCE, 0},
{1853, 3479873563u, 1246277393u, 3381375750u, 0, REMAINDERF_TOLERANCE, 0},
{1854, 3424264117u, 3434026174u, 3424264117u, 0, REMAINDERF_TOLERANCE, 0},
{1855, 3228365887u, 1216775310u, 3228365887u, 0, REMAINDERF_TOLERANCE, 0},
{1856, 1212129651u, 3017366784u, 3007833088u, 0, REMAINDERF_TOLERANCE, 0},
{1857, 3125775254u, 955826310u, 941739508u, 0, REMAINDERF_TOLERANCE, 0},
{1858, 1037464105u, 3121544932u, 3082997760u, 0, REMAINDERF_TOLERANCE, 0},
{1859, 1311706596u, 1254918706u, 3392724728u, 0, REMAINDERF_TOLERANCE, 0},
{1860, 918212457u, 1017468331u, 918212457u, 0, REMAINDERF_TOLERANCE, 0},
{1861, 1337315179u, 3461361185u, 3409044416u, 0, REMAINDERF_TOLERANCE, 0},
{1862, 1131358407u, 3325958870u, 1131358407u, 0, REMAINDERF_TOLERANCE, 0},
{1863, 1156517523u, 3343716230u, 1156517523u, 0, REMAINDERF_TOLERANCE, 0},
{1864, 3210802820u, 3207408574u, 3192859416u, 0, REMAINDERF_TOLERANCE, 0},
{1865, 3337499209u, 1226297264u, 3337499209u, 0, REMAINDERF_TOLERANCE, 0},
{1866, 3468429030u, 3253874001u, 1045759872u, 0, REMAINDERF_TOLERANCE, 0},
{1867, 3253515800u, 1189005947u, 3253515800u, 0, REMAINDERF_TOLERANCE, 0},
{1868, 3055299953u, 3047908678u, 879983952u, 0, REMAINDERF_TOLERANCE, 0},
{1869, 959956547u, 876324728u, 3003145376u, 0, REMAINDERF_TOLERANCE, 0},
{1870, 3425290480u, 1139193797u, 1125241808u, 0, REMAINDERF_TOLERANCE, 0},
{1871, 1039917375u, 1122740999u, 1039917375u, 0, REMAINDERF_TOLERANCE, 0},
{1872, 3220979495u, 3429223871u, 3220979495u, 0, REMAINDERF_TOLERANCE, 0},
{1873, 1311016004u, 3334899880u, 1178253744u, 0, REMAINDERF_TOLERANCE, 0},
{1874, 1128016396u, 1105151547u, 3236326644u, 0, REMAINDERF_TOLERANCE, 0},
{1875, 3210335769u, 3100646155u, 3063195824u, 0, REMAINDERF_TOLERANCE, 0},
{1876, 3022705759u, 3404762495u, 3022705759u, 0, REMAINDERF_TOLERANCE, 0},
{1877, 1206054701u, 826010009u, 805457284u, 0, REMAINDERF_TOLERANCE, 0},
{1878, 3144504834u, 1162227076u, 3144504834u, 0, REMAINDERF_TOLERANCE, 0},
{1879, 1213609983u, 919983950u, 908176668u, 0, REMAINDERF_TOLERANCE, 0},
{1880, 1246902946u, 3064047808u, 895564800u, 0, REMAINDERF_TOLERANCE, 0},
{1881, 3362082828u, 3374056268u, 3362082828u, 0, REMAINDERF_TOLERANCE, 0},
{1882, 1029480631u, 3047777170u, 867447040u, 0, REMAINDERF_TOLERANCE, 0},
{1883, 3153568584u, 3106514232u, 943960352u, 0, REMAINDERF_TOLERANCE, 0},
{1884, 3384988527u, 3109485565u, 3095242288u, 0, REMAINDERF_TOLERANCE, 0},
{1885, 1317696241u, 870681806u, 2971687040u, 0, REMAINDERF_TOLERANCE, 0},
{1886, 3235395924u, 1132055244u, 3235395924u, 0, REMAINDERF_TOLERANCE, 0},
{1887, 3341877624u, 2969495570u, 2960140912u, 0, REMAINDERF_TOLERANCE, 0},
{1888, 1228636133u, 886552820u, 3003200064u, 0, REMAINDERF_TOLERANCE, 0},
{1889, 3161654634u, 3335899347u, 3161654634u, 0, REMAINDERF_TOLERANCE, 0},
{1890, 3162655243u, 3307203982u, 3162655243u, 0, REMAINDERF_TOLERANCE, 0},
{1891, 1207246237u, 859223639u, 845699204u, 0, REMAINDERF_TOLERANCE, 0},
{1892, 1165476654u, 3350219111u, 1165476654u, 0, REMAINDERF_TOLERANCE, 0},
{1893, 1215278023u, 3019755242u, 855540272u, 0, REMAINDERF_TOLERANCE, 0},
{1894, 1017239798u, 3438501281u, 1017239798u, 0, REMAINDERF_TOLERANCE, 0},
{1895, 1149651309u, 970030475u, 958104804u, 0, REMAINDERF_TOLERANCE, 0},
{1896, 1111943722u, 3122211334u, 3104172864u, 0, REMAINDERF_TOLERANCE, 0},
{1897, 1189849849u, 3382739134u, 1189849849u, 0, REMAINDERF_TOLERANCE, 0},
{1898, 3204848496u, 3141519085u, 3092648512u, 0, REMAINDERF_TOLERANCE, 0},
{1899, 1249758327u, 3104759211u, 933001456u, 0, REMAINDERF_TOLERANCE, 0},
{1900, 3092982276u, 3445282331u, 3092982276u, 0, REMAINDERF_TOLERANCE, 0},
{1901, 1168098747u, 1316854744u, 1168098747u, 0, REMAINDERF_TOLERANCE, 0},
{1902, 3301009024u, 3406174560u, 3301009024u, 0, REMAINDERF_TOLERANCE, 0},
{1903, 3233089227u, 1212652543u, 3233089227u, 0, REMAINDERF_TOLERANCE, 0},
{1904, 3218245284u, 1238873830u, 3218245284u, 0, REMAINDERF_TOLERANCE, 0},
{1905, 3215981890u, 3240474694u, 3215981890u, 0, REMAINDERF_TOLERANCE, 0},
{1906, 1266687209u, 3092038122u, 3059402624u, 0, REMAINDERF_TOLERANCE, 0},
{1907, 3487959775u, 3331372071u, 1151779600u, 0, REMAINDERF_TOLERANCE, 0},
{1908, 943645710u, 852875779u, 826119328u, 0, REMAINDERF_TOLERANCE, 0},
{1909, 3345065699u, 3282620725u, 3254464912u, 0, REMAINDERF_TOLERANCE, 0},
{1910, 935847271u, 1067255804u, 935847271u, 0, REMAINDERF_TOLERANCE, 0},
{1911, 3410336089u, 1111437780u, 1078086720u, 0, REMAINDERF_TOLERANCE, 0},
{1912, 1141063391u, 1168908072u, 1141063391u, 0, REMAINDERF_TOLERANCE, 0},
{1913, 3059263153u, 3067795684u, 3059263153u, 0, REMAINDERF_TOLERANCE, 0},
{1914, 3353679791u, 897158391u, 3031717612u, 0, REMAINDERF_TOLERANCE, 0},
{1915, 1001823878u, 1016826861u, 1001823878u, 0, REMAINDERF_TOLERANCE, 0},
{1916, 1009130212u, 1004302940u, 3143196128u, 0, REMAINDERF_TOLERANCE, 0},
{1917, 3367127535u, 943136342u, 928140432u, 0, REMAINDERF_TOLERANCE, 0},
{1918, 1032920919u, 3449126417u, 1032920919u, 0, REMAINDERF_TOLERANCE, 0},
{1919, 3281952870u, 3147012185u, 3130041528u, 0, REMAINDERF_TOLERANCE, 0},
{1920, 1237868497u, 3048281802u, 3023784992u, 0, REMAINDERF_TOLERANCE, 0},
{1921, 1153753924u, 3322269242u, 1153753924u, 0, REMAINDERF_TOLERANCE, 0},
{1922, 1120261759u, 892210998u, 883701944u, 0, REMAINDERF_TOLERANCE, 0},
{1923, 3226328360u, 3366432856u, 3226328360u, 0, REMAINDERF_TOLERANCE, 0},
{1924, 3349595986u, 3251588707u, 3234647820u, 0, REMAINDERF_TOLERANCE, 0},
{1925, 3166889490u, 3306023523u, 3166889490u, 0, REMAINDERF_TOLERANCE, 0},
{1926, 1087750238u, 1099325523u, 1087750238u, 0, REMAINDERF_TOLERANCE, 0},
{1927, 3121620061u, 3359488363u, 3121620061u, 0, REMAINDERF_TOLERANCE, 0},
{1928, 1066116543u, 3072159933u, 889619088u, 0, REMAINDERF_TOLERANCE, 0},
{1929, 3210898034u, 2981803389u, 820754888u, 0, REMAINDERF_TOLERANCE, 0},
{1930, 3051923237u, 3364074347u, 3051923237u, 0, REMAINDERF_TOLERANCE, 0},
{1931, 1030612298u, 3345396001u, 1030612298u, 0, REMAINDERF_TOLERANCE, 0},
{1932, 1186234578u, 858134374u, 824693856u, 0, REMAINDERF_TOLERANCE, 0},
{1933, 1331680743u, 1009396165u, 975246528u, 0, REMAINDERF_TOLERANCE, 0},
{1934, 1045232522u, 3234993273u, 1045232522u, 0, REMAINDERF_TOLERANCE, 0},
{1935, 3119858470u, 962515365u, 3090385928u, 0, REMAINDERF_TOLERANCE, 0},
{1936, 3349432725u, 928848003u, 3055503844u, 0, REMAINDERF_TOLERANCE, 0},
{1937, 912423027u, 3184646319u, 912423027u, 0, REMAINDERF_TOLERANCE, 0},
{1938, 3228795133u, 3273940030u, 3228795133u, 0, REMAINDERF_TOLERANCE, 0},
{1939, 3194674746u, 3112269709u, 942871912u, 0, REMAINDERF_TOLERANCE, 0},
{1940, 3296784303u, 3276182352u, 3256513440u, 0, REMAINDERF_TOLERANCE, 0},
{1941, 965402291u, 3107104376u, 3097435924u, 0, REMAINDERF_TOLERANCE, 0},
{1942, 3388153589u, 3426245389u, 3388153589u, 0, REMAINDERF_TOLERANCE, 0},
{1943, 1133410485u, 3329658993u, 1133410485u, 0, REMAINDERF_TOLERANCE, 0},
{1944, 3136790322u, 1088652637u, 3136790322u, 0, REMAINDERF_TOLERANCE, 0},
{1945, 3369970587u, 959121458u, 3088503784u, 0, REMAINDERF_TOLERANCE, 0},
{1946, 1270451568u, 928393353u, 3061279676u, 0, REMAINDERF_TOLERANCE, 0},
{1947, 989498922u, 3088358419u, 3051673664u, 0, REMAINDERF_TOLERANCE, 0},
{1948, 1280215674u, 3148135875u, 3139032254u, 0, REMAINDERF_TOLERANCE, 0},
{1949, 1171873518u, 954709738u, 3078051120u, 0, REMAINDERF_TOLERANCE, 0},
{1950, 3298258100u, 935525182u, 3037756096u, 0, REMAINDERF_TOLERANCE, 0},
{1951, 3415208824u, 822843236u, 806916432u, 0, REMAINDERF_TOLERANCE, 0},
{1952, 1001897182u, 3191875320u, 1001897182u, 0, REMAINDERF_TOLERANCE, 0},
{1953, 3152777939u, 3245830463u, 3152777939u, 0, REMAINDERF_TOLERANCE, 0},
{1954, 985903305u, 3333087577u, 985903305u, 0, REMAINDERF_TOLERANCE, 0},
{1955, 3357328848u, 859306298u, 2991993656u, 0, REMAINDERF_TOLERANCE, 0},
{1956, 982612185u, 923582663u, 908334992u, 0, REMAINDERF_TOLERANCE, 0},
{1957, 3267868136u, 1208301947u, 3267868136u, 0, REMAINDERF_TOLERANCE, 0},
{1958, 3319048157u, 1172271145u, 1135379648u, 0, REMAINDERF_TOLERANCE, 0},
{1959, 1144755661u, 860947435u, 837949656u, 0, REMAINDERF_TOLERANCE, 0},
{1960, 898467286u, 839254959u, 817352120u, 0, REMAINDERF_TOLERANCE, 0},
{1961, 3301461672u, 1233693827u, 3301461672u, 0, REMAINDERF_TOLERANCE, 0},
{1962, 3364525678u, 3089849671u, 3069169320u, 0, REMAINDERF_TOLERANCE, 0},
{1963, 3146660041u, 3143695961u, 3127758052u, 0, REMAINDERF_TOLERANCE, 0},
{1964, 3467121799u, 3023584354u, 865329844u, 0, REMAINDERF_TOLERANCE, 0},
{1965, 1151257041u, 3084216427u, 922291812u, 0, REMAINDERF_TOLERANCE, 0},
{1966, 3097873255u, 3219266640u, 3097873255u, 0, REMAINDERF_TOLERANCE, 0},
{1967, 3130670309u, 3192399254u, 3130670309u, 0, REMAINDERF_TOLERANCE, 0},
{1968, 1017573824u, 3130901062u, 3098323552u, 0, REMAINDERF_TOLERANCE, 0},
{1969, 1258369714u, 3462258576u, 1258369714u, 0, REMAINDERF_TOLERANCE, 0},
{1970, 1216602683u, 3371396332u, 3361674594u, 0, REMAINDERF_TOLERANCE, 0},
{1971, 3297265739u, 1214184410u, 3297265739u, 0, REMAINDERF_TOLERANCE, 0},
{1972, 1071940738u, 3311731012u, 1071940738u, 0, REMAINDERF_TOLERANCE, 0},
{1973, 922601356u, 3337171870u, 922601356u, 0, REMAINDERF_TOLERANCE, 0},
{1974, 3462285635u, 3444030332u, 3434376760u, 0, REMAINDERF_TOLERANCE, 0},
{1975, 3357177805u, 1085464241u, 1071015336u, 0, REMAINDERF_TOLERANCE, 0},
{1976, 3049120080u, 900832851u, 3015978960u, 0, REMAINDERF_TOLERANCE, 0},
{1977, 1153863660u, 1011991342u, 1001807172u, 0, REMAINDERF_TOLERANCE, 0},
{1978, 3034243695u, 917098003u, 3034243695u, 0, REMAINDERF_TOLERANCE, 0},
{1979, 1249365132u, 3278686216u, 1118515296u, 0, REMAINDERF_TOLERANCE, 0},
{1980, 3046215730u, 3211219980u, 3046215730u, 0, REMAINDERF_TOLERANCE, 0},
{1981, 3047251716u, 1090787353u, 3047251716u, 0, REMAINDERF_TOLERANCE, 0},
{1982, 3131219358u, 3471261157u, 3131219358u, 0, REMAINDERF_TOLERANCE, 0},
{1983, 3222096285u, 1198013705u, 3222096285u, 0, REMAINDERF_TOLERANCE, 0},
{1984, 1297708818u, 3079166173u, 906966632u, 0, REMAINDERF_TOLERANCE, 0},
{1985, 3345532722u, 3383708463u, 3345532722u, 0, REMAINDERF_TOLERANCE, 0},
{1986, 3418753236u, 3481843070u, 3418753236u, 0, REMAINDERF_TOLERANCE, 0},
{1987, 1277417964u, 3487506626u, 1277417964u, 0, REMAINDERF_TOLERANCE, 0},
{1988, 987577257u, 1152077087u, 987577257u, 0, REMAINDERF_TOLERANCE, 0},
{1989, 3161606610u, 3190282989u, 3161606610u, 0, REMAINDERF_TOLERANCE, 0},
{1990, 888030585u, 3062367380u, 888030585u, 0, REMAINDERF_TOLERANCE, 0},
{1991, 1043442869u, 3311393817u, 1043442869u, 0, REMAINDERF_TOLERANCE, 0},
{1992, 3320923228u, 3464544249u, 3320923228u, 0, REMAINDERF_TOLERANCE, 0},
{1993, 1337400405u, 3488844154u, 3471946900u, 0, REMAINDERF_TOLERANCE, 0},
{1994, 3400348640u, 3129868490u, 965234592u, 0, REMAINDERF_TOLERANCE, 0},
{1995, 1250249095u, 1069023744u, 1060149248u, 0, REMAINDERF_TOLERANCE, 0},
{1996, 3284411233u, 1173613526u, 3284411233u, 0, REMAINDERF_TOLERANCE, 0},
{1997, 3020883322u, 2953622587u, 2935189664u, 0, REMAINDERF_TOLERANCE, 0},
{1998, 1215968622u, 3469884568u, 1215968622u, 0, REMAINDERF_TOLERANCE, 0},
{1999, 3202319550u, 819117302u, 806034448u, 0, REMAINDERF_TOLERANCE, 0},
{2000, 3061638260u, 3116222327u, 3061638260u, 0, REMAINDERF_TOLERANCE, 0},
{2001, 1025404104u, 1066370251u, 1025404104u, 0, REMAINDERF_TOLERANCE, 0},
{2002, 3138086437u, 3195983510u, 3138086437u, 0, REMAINDERF_TOLERANCE, 0},
{2003, 3091024506u, 3456196859u, 3091024506u, 0, REMAINDERF_TOLERANCE, 0},
{2004, 3362748242u, 3369843597u, 1212678088u, 0, REMAINDERF_TOLERANCE, 0},
{2005, 3099671635u, 3218383623u, 3099671635u, 0, REMAINDERF_TOLERANCE, 0},
{2006, 3068014841u, 2978226656u, 796858368u, 0, REMAINDERF_TOLERANCE, 0},
{2007, 1252237719u, 1121169249u, 3239657496u, 0, REMAINDERF_TOLERANCE, 0},
{2008, 3327895594u, 1224511805u, 3327895594u, 0, REMAINDERF_TOLERANCE, 0},
{2009, 3082454432u, 889268276u, 3017528640u, 0, REMAINDERF_TOLERANCE, 0},
{2010, 3396161504u, 1182798837u, 3307975032u, 0, REMAINDERF_TOLERANCE, 0},
{2011, 1099710167u, 887180181u, 3025478368u, 0, REMAINDERF_TOLERANCE, 0},
{2012, 1157186482u, 1288722647u, 1157186482u, 0, REMAINDERF_TOLERANCE, 0},
{2013, 1282110851u, 3176633124u, 988272128u, 0, REMAINDERF_TOLERANCE, 0},
{2014, 3477008113u, 1331845018u, 1309516452u, 0, REMAINDERF_TOLERANCE, 0},
{2015, 3292127294u, 3409957764u, 3292127294u, 0, REMAINDERF_TOLERANCE, 0},
{2016, 1123357102u, 3281307320u, 1123357102u, 0, REMAINDERF_TOLERANCE, 0},
{2017, 1106837025u, 3088080674u, 923829400u, 0, REMAINDERF_TOLERANCE, 0},
{2018, 1049949008u, 1130799489u, 1049949008u, 0, REMAINDERF_TOLERANCE, 0},
{2019, 1253017688u, 942062372u, 3078263968u, 0, REMAINDERF_TOLERANCE, 0},
{2020, 1108543194u, 3281299199u, 1108543194u, 0, REMAINDERF_TOLERANCE, 0},
{2021, 1160162706u, 1264067367u, 1160162706u, 0, REMAINDERF_TOLERANCE, 0},
{2022, 3305715025u, 3017496063u, 859763526u, 0, REMAINDERF_TOLERANCE, 0},
{2023, 1266928623u, 811778614u, 2944546360u, 0, REMAINDERF_TOLERANCE, 0},
{2024, 3438080027u, 3107114149u, 932701080u, 0, REMAINDERF_TOLERANCE, 0},
{2025, 3344574751u, 3111270744u, 3101782928u, 0, REMAINDERF_TOLERANCE, 0},
{2026, 1152416724u, 962669179u, 948286872u, 0, REMAINDERF_TOLERANCE, 0},
{2027, 1218239308u, 1126238113u, 3242277552u, 0, REMAINDERF_TOLERANCE, 0},
{2028, 3263310567u, 1030748197u, 1001751704u, 0, REMAINDERF_TOLERANCE, 0},
{2029, 1000313118u, 2980130729u, 2961403816u, 0, REMAINDERF_TOLERANCE, 0},
{2030, 972485427u, 1124312043u, 972485427u, 0, REMAINDERF_TOLERANCE, 0},
{2031, 3290264612u, 1124703898u, 1114186184u, 0, REMAINDERF_TOLERANCE, 0},
{2032, 3222106584u, 1183748648u, 3222106584u, 0, REMAINDERF_TOLERANCE, 0},
{2033, 1278946388u, 825129857u, 2955667752u, 0, REMAINDERF_TOLERANCE, 0},
{2034, 947914771u, 3181847068u, 947914771u, 0, REMAINDERF_TOLERANCE, 0},
{2035, 3167730654u, 3195765940u, 3167730654u, 0, REMAINDERF_TOLERANCE, 0},
{2036, 1098530298u, 3255870890u, 1098530298u, 0, REMAINDERF_TOLERANCE, 0},
{2037, 3232726036u, 871038882u, 853288144u, 0, REMAINDERF_TOLERANCE, 0},
{2038, 1297190916u, 811863044u, 801786168u, 0, REMAINDERF_TOLERANCE, 0},
{2039, 1277649137u, 961171401u, 923065584u, 0, REMAINDERF_TOLERANCE, 0},
{2040, 3090306474u, 3124785016u, 3090306474u, 0, REMAINDERF_TOLERANCE, 0},
{2041, 3244032016u, 3045313345u, 2997382784u, 0, REMAINDERF_TOLERANCE, 0},
{2042, 3033122376u, 3049877065u, 3033122376u, 0, REMAINDERF_TOLERANCE, 0},
{2043, 1096155623u, 1256423752u, 1096155623u, 0, REMAINDERF_TOLERANCE, 0},
{2044, 873151908u, 3246562559u, 873151908u, 0, REMAINDERF_TOLERANCE, 0},
{2045, 3317196817u, 989537151u, 3128603888u, 0, REMAINDERF_TOLERANCE, 0},
{2046, 3374748510u, 834161190u, 2962771824u, 0, REMAINDERF_TOLERANCE, 0},
{2047, 3345634950u, 959901149u, 3088828252u, 0, REMAINDERF_TOLERANCE, 0},
{2048, 3189860276u, 883598767u, 817257216u, 0, REMAINDERF_TOLERANCE, 0},
{2049, 3396917283u, 3066326686u, 893564336u, 0, REMAINDERF_TOLERANCE, 0},
{2050, 3317032737u, 3143803722u, 974854600u, 0, REMAINDERF_TOLERANCE, 0},
{2051, 1200051436u, 1163802508u, 1155071032u, 0, REMAINDERF_TOLERANCE, 0},
{2052, 1306520561u, 957302464u, 944812800u, 0, REMAINDERF_TOLERANCE, 0},
{2053, 1314936356u, 2985592532u, 810494176u, 0, REMAINDERF_TOLERANCE, 0},
{2054, 3475052219u, 1284049853u, 1272158904u, 0, REMAINDERF_TOLERANCE, 0},
{2055, 3085636260u, 1107682820u, 3085636260u, 0, REMAINDERF_TOLERANCE, 0},
{2056, 3393227708u, 3271879112u, 1103097792u, 0, REMAINDERF_TOLERANCE, 0},
{2057, 3182540197u, 852580839u, 794870400u, 0, REMAINDERF_TOLERANCE, 0},
{2058, 3349005404u, 3080993030u, 924182316u, 0, REMAINDERF_TOLERANCE, 0},
{2059, 3154720153u, 3443720494u, 3154720153u, 0, REMAINDERF_TOLERANCE, 0},
{2060, 1262863321u, 1219003129u, 3356879788u, 0, REMAINDERF_TOLERANCE, 0},
{2061, 1053387478u, 3184880021u, 3166694384u, 0, REMAINDERF_TOLERANCE, 0},
{2062, 3387653691u, 3347783852u, 3317110976u, 0, REMAINDERF_TOLERANCE, 0},
{2063, 3136364836u, 1018492227u, 3136364836u, 0, REMAINDERF_TOLERANCE, 0},
{2064, 1338680611u, 1166078045u, 3279619968u, 0, REMAINDERF_TOLERANCE, 0},
{2065, 1112891928u, 3074730425u, 3049799216u, 0, REMAINDERF_TOLERANCE, 0},
{2066, 893449284u, 1052877339u, 893449284u, 0, REMAINDERF_TOLERANCE, 0},
{2067, 3105373037u, 3246705916u, 3105373037u, 0, REMAINDERF_TOLERANCE, 0},
{2068, 1190105283u, 3033907262u, 3005110384u, 0, REMAINDERF_TOLERANCE, 0},
{2069, 1011225926u, 1180485180u, 1011225926u, 0, REMAINDERF_TOLERANCE, 0},
{2070, 1043025031u, 987068973u, 3120009836u, 0, REMAINDERF_TOLERANCE, 0},
{2071, 3410531037u, 2953541915u, 2915509408u, 0, REMAINDERF_TOLERANCE, 0},
{2072, 3125834184u, 896953754u, 3022091312u, 0, REMAINDERF_TOLERANCE, 0},
{2073, 902318189u, 849277289u, 2984319972u, 0, REMAINDERF_TOLERANCE, 0},
{2074, 3213624815u, 2987148017u, 810618448u, 0, REMAINDERF_TOLERANCE, 0},
{2075, 1120888322u, 1086209113u, 1076411502u, 0, REMAINDERF_TOLERANCE, 0},
{2076, 1315217243u, 3396371713u, 1235367450u, 0, REMAINDERF_TOLERANCE, 0},
{2077, 3137758475u, 1039403054u, 3137758475u, 0, REMAINDERF_TOLERANCE, 0},
{2078, 1040617590u, 1034835971u, 3172933172u, 0, REMAINDERF_TOLERANCE, 0},
{2079, 955384253u, 3344785562u, 955384253u, 0, REMAINDERF_TOLERANCE, 0},
{2080, 904255535u, 1019967545u, 904255535u, 0, REMAINDERF_TOLERANCE, 0},
{2081, 1022984119u, 3113891410u, 3104589600u, 0, REMAINDERF_TOLERANCE, 0},
{2082, 997362368u, 3112875428u, 3058465792u, 0, REMAINDERF_TOLERANCE, 0},
{2083, 1168623062u, 1143306482u, 1116944640u, 0, REMAINDERF_TOLERANCE, 0},
{2084, 878737490u, 3269908326u, 878737490u, 0, REMAINDERF_TOLERANCE, 0},
{2085, 1039827284u, 1072928888u, 1039827284u, 0, REMAINDERF_TOLERANCE, 0},
{2086, 1021564080u, 1064468397u, 1021564080u, 0, REMAINDERF_TOLERANCE, 0},
{2087, 3458669745u, 3033299853u, 874931060u, 0, REMAINDERF_TOLERANCE, 0},
{2088, 3327516316u, 3405380971u, 3327516316u, 0, REMAINDERF_TOLERANCE, 0},
{2089, 1040711112u, 3229444200u, 1040711112u, 0, REMAINDERF_TOLERANCE, 0},
{2090, 1134528351u, 3365952513u, 1134528351u, 0, REMAINDERF_TOLERANCE, 0},
{2091, 3414352838u, 3350285760u, 1151873024u, 0, REMAINDERF_TOLERANCE, 0},
{2092, 1133689539u, 1067460093u, 3205511294u, 0, REMAINDERF_TOLERANCE, 0},
{2093, 3455688478u, 3333091960u, 3320850048u, 0, REMAINDERF_TOLERANCE, 0},
{2094, 1137634874u, 1137038869u, 1100055120u, 0, REMAINDERF_TOLERANCE, 0},
{2095, 3415502662u, 955510692u, 3074734528u, 0, REMAINDERF_TOLERANCE, 0},
{2096, 954999730u, 969618597u, 954999730u, 0, REMAINDERF_TOLERANCE, 0},
{2097, 1066157309u, 3241712664u, 1066157309u, 0, REMAINDERF_TOLERANCE, 0},
{2098, 3436353675u, 1174967495u, 3308447100u, 0, REMAINDERF_TOLERANCE, 0},
{2099, 940437609u, 860372396u, 2984906304u, 0, REMAINDERF_TOLERANCE, 0},
{2100, 3108347547u, 3434003435u, 3108347547u, 0, REMAINDERF_TOLERANCE, 0},
{2101, 3064200154u, 3158080507u, 3064200154u, 0, REMAINDERF_TOLERANCE, 0},
{2102, 1023889593u, 2979304683u, 2952006656u, 0, REMAINDERF_TOLERANCE, 0},
{2103, 3272661536u, 3461799138u, 3272661536u, 0, REMAINDERF_TOLERANCE, 0},
{2104, 1170245333u, 1233406410u, 1170245333u, 0, REMAINDERF_TOLERANCE, 0},
{2105, 1219052056u, 3369557946u, 3350754952u, 0, REMAINDERF_TOLERANCE, 0},
{2106, 3318983619u, 3259663338u, 1093446640u, 0, REMAINDERF_TOLERANCE, 0},
{2107, 3372118621u, 837597103u, 2969878364u, 0, REMAINDERF_TOLERANCE, 0},
{2108, 3146190320u, 889646054u, 3005091072u, 0, REMAINDERF_TOLERANCE, 0},
{2109, 1299683827u, 966031619u, 951225020u, 0, REMAINDERF_TOLERANCE, 0},
{2110, 3086068902u, 3484245751u, 3086068902u, 0, REMAINDERF_TOLERANCE, 0},
{2111, 3064155399u, 3176569312u, 3064155399u, 0, REMAINDERF_TOLERANCE, 0},
{2112, 3040314717u, 1071290674u, 3040314717u, 0, REMAINDERF_TOLERANCE, 0},
{2113, 3257224022u, 3361778245u, 3257224022u, 0, REMAINDERF_TOLERANCE, 0},
{2114, 1229268598u, 1066965677u, 3201545820u, 0, REMAINDERF_TOLERANCE, 0},
{2115, 3184078812u, 871003709u, 856625364u, 0, REMAINDERF_TOLERANCE, 0},
{2116, 1086717248u, 3423795374u, 1086717248u, 0, REMAINDERF_TOLERANCE, 0},
{2117, 3434884607u, 3029593823u, 3012614440u, 0, REMAINDERF_TOLERANCE, 0},
{2118, 3464955606u, 1017987696u, 1009465856u, 0, REMAINDERF_TOLERANCE, 0},
{2119, 1025278524u, 3121856207u, 3102801888u, 0, REMAINDERF_TOLERANCE, 0},
{2120, 1242829722u, 3233935671u, 1075185908u, 0, REMAINDERF_TOLERANCE, 0},
{2121, 3075149137u, 1117325737u, 3075149137u, 0, REMAINDERF_TOLERANCE, 0},
{2122, 1200927971u, 1317167489u, 1200927971u, 0, REMAINDERF_TOLERANCE, 0},
{2123, 3326858092u, 3452602832u, 3326858092u, 0, REMAINDERF_TOLERANCE, 0},
{2124, 1246019790u, 850632217u, 830042472u, 0, REMAINDERF_TOLERANCE, 0},
{2125, 3184801644u, 1137974313u, 3184801644u, 0, REMAINDERF_TOLERANCE, 0},
{2126, 1136052740u, 3244616020u, 3234653200u, 0, REMAINDERF_TOLERANCE, 0},
{2127, 1069009211u, 3002507482u, 814487552u, 0, REMAINDERF_TOLERANCE, 0},
{2128, 1015670780u, 1101217251u, 1015670780u, 0, REMAINDERF_TOLERANCE, 0},
{2129, 1012543234u, 1116520440u, 1012543234u, 0, REMAINDERF_TOLERANCE, 0},
{2130, 3316611992u, 3394732912u, 3316611992u, 0, REMAINDERF_TOLERANCE, 0},
{2131, 1087942795u, 3316660295u, 1087942795u, 0, REMAINDERF_TOLERANCE, 0},
{2132, 3426365713u, 3069778532u, 899297264u, 0, REMAINDERF_TOLERANCE, 0},
{2133, 3066654389u, 3443934204u, 3066654389u, 0, REMAINDERF_TOLERANCE, 0},
{2134, 3295326432u, 1313396175u, 3295326432u, 0, REMAINDERF_TOLERANCE, 0},
{2135, 3318835308u, 3277583511u, 3268200348u, 0, REMAINDERF_TOLERANCE, 0},
{2136, 3283555717u, 891875120u, 3018418816u, 0, REMAINDERF_TOLERANCE, 0},
{2137, 3381255420u, 3015406047u, 3003470174u, 0, REMAINDERF_TOLERANCE, 0},
{2138, 3040485181u, 3375450886u, 3040485181u, 0, REMAINDERF_TOLERANCE, 0},
{2139, 3388772093u, 1032597076u, 3165073936u, 0, REMAINDERF_TOLERANCE, 0},
{2140, 954670189u, 1144923689u, 954670189u, 0, REMAINDERF_TOLERANCE, 0},
{2141, 1319200415u, 3387555900u, 1225501968u, 0, REMAINDERF_TOLERANCE, 0},
{2142, 1279324488u, 3228401212u, 3206297888u, 0, REMAINDERF_TOLERANCE, 0},
{2143, 3217795424u, 865577227u, 3001572528u, 0, REMAINDERF_TOLERANCE, 0},
{2144, 3455131757u, 1260217257u, 3363738048u, 0, REMAINDERF_TOLERANCE, 0},
{2145, 1246947517u, 1087951909u, 3223711398u, 0, REMAINDERF_TOLERANCE, 0},
{2146, 3396723577u, 869285240u, 856565232u, 0, REMAINDERF_TOLERANCE, 0},
{2147, 3433761025u, 3060143904u, 889916032u, 0, REMAINDERF_TOLERANCE, 0},
{2148, 3201187455u, 900233172u, 3030875120u, 0, REMAINDERF_TOLERANCE, 0},
{2149, 1173247961u, 1191127979u, 1173247961u, 0, REMAINDERF_TOLERANCE, 0},
{2150, 3037297123u, 3346394818u, 3037297123u, 0, REMAINDERF_TOLERANCE, 0},
{2151, 3083019343u, 3033309444u, 2992028032u, 0, REMAINDERF_TOLERANCE, 0},
{2152, 3042018375u, 3203882372u, 3042018375u, 0, REMAINDERF_TOLERANCE, 0},
{2153, 1082862511u, 3032804719u, 870904016u, 0, REMAINDERF_TOLERANCE, 0},
{2154, 3157626955u, 3483653298u, 3157626955u, 0, REMAINDERF_TOLERANCE, 0},
{2155, 1341821683u, 3003675365u, 2982557440u, 0, REMAINDERF_TOLERANCE, 0},
{2156, 1079061705u, 2960507663u, 2951154782u, 0, REMAINDERF_TOLERANCE, 0},
{2157, 3182695954u, 3256861672u, 3182695954u, 0, REMAINDERF_TOLERANCE, 0},
{2158, 1105291533u, 3482971524u, 1105291533u, 0, REMAINDERF_TOLERANCE, 0},
{2159, 1016023520u, 3227712090u, 1016023520u, 0, REMAINDERF_TOLERANCE, 0},
{2160, 3370691006u, 1295870514u, 3370691006u, 0, REMAINDERF_TOLERANCE, 0},
{2161, 1156767169u, 1049756240u, 1025779584u, 0, REMAINDERF_TOLERANCE, 0},
{2162, 3077020499u, 894671462u, 885935096u, 0, REMAINDERF_TOLERANCE, 0},
{2163, 1104284039u, 3040211914u, 862037856u, 0, REMAINDERF_TOLERANCE, 0},
{2164, 3335212901u, 3486414589u, 3335212901u, 0, REMAINDERF_TOLERANCE, 0},
{2165, 1093697541u, 3193708441u, 1032547210u, 0, REMAINDERF_TOLERANCE, 0},
{2166, 3266691185u, 1160074593u, 3266691185u, 0, REMAINDERF_TOLERANCE, 0},
{2167, 3179003144u, 1108615803u, 3179003144u, 0, REMAINDERF_TOLERANCE, 0},
{2168, 1094115255u, 3008610212u, 2973244032u, 0, REMAINDERF_TOLERANCE, 0},
{2169, 3424086808u, 3260140004u, 1099884568u, 0, REMAINDERF_TOLERANCE, 0},
{2170, 3353608773u, 1134068114u, 1117671864u, 0, REMAINDERF_TOLERANCE, 0},
{2171, 882878091u, 3136970767u, 882878091u, 0, REMAINDERF_TOLERANCE, 0},
{2172, 1098662266u, 833740182u, 2965890624u, 0, REMAINDERF_TOLERANCE, 0},
{2173, 927582555u, 947955456u, 927582555u, 0, REMAINDERF_TOLERANCE, 0},
{2174, 3111440310u, 3067634077u, 3048272560u, 0, REMAINDERF_TOLERANCE, 0},
{2175, 3476083859u, 966439623u, 950958600u, 0, REMAINDERF_TOLERANCE, 0},
{2176, 3038754840u, 932009686u, 3038754840u, 0, REMAINDERF_TOLERANCE, 0},
{2177, 3464546616u, 3205527253u, 3195154312u, 0, REMAINDERF_TOLERANCE, 0},
{2178, 1002542205u, 3152136093u, 3129003136u, 0, REMAINDERF_TOLERANCE, 0},
{2179, 3443552129u, 3165561391u, 3131907072u, 0, REMAINDERF_TOLERANCE, 0},
{2180, 1287620154u, 3119707283u, 3093984640u, 0, REMAINDERF_TOLERANCE, 0},
{2181, 3073260205u, 3093124531u, 3073260205u, 0, REMAINDERF_TOLERANCE, 0},
{2182, 1245702957u, 894348966u, 815923200u, 0, REMAINDERF_TOLERANCE, 0},
{2183, 1002715618u, 1191006977u, 1002715618u, 0, REMAINDERF_TOLERANCE, 0},
{2184, 3087802274u, 897541752u, 3018272960u, 0, REMAINDERF_TOLERANCE, 0},
{2185, 3415763001u, 3032518431u, 846106048u, 0, REMAINDERF_TOLERANCE, 0},
{2186, 3283471961u, 1260093226u, 3283471961u, 0, REMAINDERF_TOLERANCE, 0},
{2187, 3311210827u, 1192192264u, 3311210827u, 0, REMAINDERF_TOLERANCE, 0},
{2188, 3026311911u, 2968974374u, 2935874080u, 0, REMAINDERF_TOLERANCE, 0},
{2189, 1198307901u, 1116328249u, 1107057956u, 0, REMAINDERF_TOLERANCE, 0},
{2190, 1288901567u, 1296370667u, 3434546199u, 0, REMAINDERF_TOLERANCE, 0},
{2191, 922255363u, 958305289u, 922255363u, 0, REMAINDERF_TOLERANCE, 0},
{2192, 1113104661u, 944376032u, 3061836288u, 0, REMAINDERF_TOLERANCE, 0},
{2193, 1136714348u, 828849087u, 806528084u, 0, REMAINDERF_TOLERANCE, 0},
{2194, 948856035u, 1015466475u, 948856035u, 0, REMAINDERF_TOLERANCE, 0},
{2195, 1062512367u, 3229559531u, 1062512367u, 0, REMAINDERF_TOLERANCE, 0},
{2196, 3486907092u, 823220784u, 2917834752u, 0, REMAINDERF_TOLERANCE, 0},
{2197, 1162027071u, 3308983387u, 1124122176u, 0, REMAINDERF_TOLERANCE, 0},
{2198, 1034561811u, 1054043114u, 1034561811u, 0, REMAINDERF_TOLERANCE, 0},
{2199, 3271615417u, 3209997200u, 3187590784u, 0, REMAINDERF_TOLERANCE, 0},
{2200, 1042014529u, 1146708584u, 1042014529u, 0, REMAINDERF_TOLERANCE, 0},
{2201, 1177157787u, 3090208179u, 3079778204u, 0, REMAINDERF_TOLERANCE, 0},
{2202, 3196144817u, 1056118717u, 1046713880u, 0, REMAINDERF_TOLERANCE, 0},
{2203, 3432084552u, 2997091781u, 840592388u, 0, REMAINDERF_TOLERANCE, 0},
{2204, 1309658335u, 1010219988u, 3143725360u, 0, REMAINDERF_TOLERANCE, 0},
{2205, 1226494979u, 2991604792u, 824811424u, 0, REMAINDERF_TOLERANCE, 0},
{2206, 3100289712u, 3456334210u, 3100289712u, 0, REMAINDERF_TOLERANCE, 0},
{2207, 3375507013u, 1306310823u, 3375507013u, 0, REMAINDERF_TOLERANCE, 0},
{2208, 3460699001u, 3096700943u, 929697272u, 0, REMAINDERF_TOLERANCE, 0},
{2209, 3079231719u, 1044386263u, 3079231719u, 0, REMAINDERF_TOLERANCE, 0},
{2210, 3093951884u, 1014115231u, 3093951884u, 0, REMAINDERF_TOLERANCE, 0},
{2211, 3468023178u, 1209565017u, 1176354432u, 0, REMAINDERF_TOLERANCE, 0},
{2212, 1204196034u, 3298625731u, 3266401072u, 0, REMAINDERF_TOLERANCE, 0},
{2213, 3459877411u, 2960476959u, 802433148u, 0, REMAINDERF_TOLERANCE, 0},
{2214, 1161439847u, 943449277u, 3075310388u, 0, REMAINDERF_TOLERANCE, 0},
{2215, 908663107u, 939489763u, 908663107u, 0, REMAINDERF_TOLERANCE, 0},
{2216, 1055319316u, 3261813492u, 1055319316u, 0, REMAINDERF_TOLERANCE, 0},
{2217, 1084378658u, 1009650785u, 1000236678u, 0, REMAINDERF_TOLERANCE, 0},
{2218, 3053887750u, 3341786453u, 3053887750u, 0, REMAINDERF_TOLERANCE, 0},
{2219, 3022828828u, 881335251u, 868680980u, 0, REMAINDERF_TOLERANCE, 0},
{2220, 1226473697u, 821025132u, 810787144u, 0, REMAINDERF_TOLERANCE, 0},
{2221, 1123114742u, 1229815537u, 1123114742u, 0, REMAINDERF_TOLERANCE, 0},
{2222, 1258114435u, 1291336083u, 1258114435u, 0, REMAINDERF_TOLERANCE, 0},
{2223, 3468040845u, 3066966245u, 3058342472u, 0, REMAINDERF_TOLERANCE, 0},
{2224, 1178825761u, 1113195286u, 3251980680u, 0, REMAINDERF_TOLERANCE, 0},
{2225, 3059266302u, 878503862u, 864458496u, 0, REMAINDERF_TOLERANCE, 0},
{2226, 3223384012u, 1130486973u, 3223384012u, 0, REMAINDERF_TOLERANCE, 0},
{2227, 3445262427u, 3465211174u, 3445262427u, 0, REMAINDERF_TOLERANCE, 0},
{2228, 1125653081u, 1207799746u, 1125653081u, 0, REMAINDERF_TOLERANCE, 0},
{2229, 3337652712u, 3025581813u, 3012467368u, 0, REMAINDERF_TOLERANCE, 0},
{2230, 1184753508u, 3147374485u, 3116845728u, 0, REMAINDERF_TOLERANCE, 0},
{2231, 996404791u, 3353251979u, 996404791u, 0, REMAINDERF_TOLERANCE, 0},
{2232, 1188439315u, 1113484271u, 3225113648u, 0, REMAINDERF_TOLERANCE, 0},
{2233, 906557513u, 3006513432u, 2988936544u, 0, REMAINDERF_TOLERANCE, 0},
{2234, 916831283u, 999465787u, 916831283u, 0, REMAINDERF_TOLERANCE, 0},
{2235, 996786317u, 3179221951u, 996786317u, 0, REMAINDERF_TOLERANCE, 0},
{2236, 3461635065u, 1004690387u, 984706768u, 0, REMAINDERF_TOLERANCE, 0},
{2237, 1188167943u, 1200744896u, 1188167943u, 0, REMAINDERF_TOLERANCE, 0},
{2238, 3290079438u, 846519377u, 821187528u, 0, REMAINDERF_TOLERANCE, 0},
{2239, 3350690327u, 2967953392u, 2957315104u, 0, REMAINDERF_TOLERANCE, 0},
{2240, 1102061604u, 3424449935u, 1102061604u, 0, REMAINDERF_TOLERANCE, 0},
{2241, 1282351521u, 3039376424u, 867630848u, 0, REMAINDERF_TOLERANCE, 0},
{2242, 3458861065u, 3392466405u, 1234687786u, 0, REMAINDERF_TOLERANCE, 0},
{2243, 3095256878u, 1023623326u, 3095256878u, 0, REMAINDERF_TOLERANCE, 0},
{2244, 3163373610u, 843150426u, 824504784u, 0, REMAINDERF_TOLERANCE, 0},
{2245, 3228793330u, 855146890u, 2992187816u, 0, REMAINDERF_TOLERANCE, 0},
{2246, 3422194733u, 893873945u, 881924592u, 0, REMAINDERF_TOLERANCE, 0},
{2247, 3083885296u, 974543672u, 3083885296u, 0, REMAINDERF_TOLERANCE, 0},
{2248, 1261940623u, 3402349985u, 3382734992u, 0, REMAINDERF_TOLERANCE, 0},
{2249, 3400603081u, 3234396843u, 1076561414u, 0, REMAINDERF_TOLERANCE, 0},
{2250, 1219411812u, 2961857939u, 800538620u, 0, REMAINDERF_TOLERANCE, 0},
{2251, 3094833770u, 805351108u, 785839264u, 0, REMAINDERF_TOLERANCE, 0},
{2252, 3139250800u, 3079109479u, 3070476520u, 0, REMAINDERF_TOLERANCE, 0},
{2253, 886201503u, 3272760705u, 886201503u, 0, REMAINDERF_TOLERANCE, 0},
{2254, 3297366026u, 1089966380u, 1081350952u, 0, REMAINDERF_TOLERANCE, 0},
{2255, 1218488455u, 3309646450u, 1147081920u, 0, REMAINDERF_TOLERANCE, 0},
{2256, 3040358923u, 3093401553u, 3040358923u, 0, REMAINDERF_TOLERANCE, 0},
{2257, 1283938137u, 1196383822u, 3331422908u, 0, REMAINDERF_TOLERANCE, 0},
{2258, 3182551696u, 3029982441u, 870845312u, 0, REMAINDERF_TOLERANCE, 0},
{2259, 1317098613u, 949986176u, 3084154368u, 0, REMAINDERF_TOLERANCE, 0},
{2260, 3116209179u, 3303588342u, 3116209179u, 0, REMAINDERF_TOLERANCE, 0},
{2261, 3431703657u, 3014443710u, 842962944u, 0, REMAINDERF_TOLERANCE, 0},
{2262, 3239728775u, 927815421u, 3057910716u, 0, REMAINDERF_TOLERANCE, 0},
{2263, 3207141672u, 933456504u, 3070924848u, 0, REMAINDERF_TOLERANCE, 0},
{2264, 3154378805u, 905462392u, 889766848u, 0, REMAINDERF_TOLERANCE, 0},
{2265, 3069658155u, 1041452042u, 3069658155u, 0, REMAINDERF_TOLERANCE, 0},
{2266, 3313160088u, 2964063309u, 803763456u, 0, REMAINDERF_TOLERANCE, 0},
{2267, 3207056527u, 3384206601u, 3207056527u, 0, REMAINDERF_TOLERANCE, 0},
{2268, 1284174954u, 3436881197u, 3424608646u, 0, REMAINDERF_TOLERANCE, 0},
{2269, 3156081645u, 3308839704u, 3156081645u, 0, REMAINDERF_TOLERANCE, 0},
{2270, 1063693032u, 976661408u, 942444032u, 0, REMAINDERF_TOLERANCE, 0},
{2271, 1102631663u, 3396951425u, 1102631663u, 0, REMAINDERF_TOLERANCE, 0},
{2272, 968803479u, 992989712u, 968803479u, 0, REMAINDERF_TOLERANCE, 0},
{2273, 3273080388u, 3109405906u, 3092240224u, 0, REMAINDERF_TOLERANCE, 0},
{2274, 1172529774u, 3294550127u, 1125203936u, 0, REMAINDERF_TOLERANCE, 0},
{2275, 1306695905u, 1292690378u, 1274295072u, 0, REMAINDERF_TOLERANCE, 0},
{2276, 3158855023u, 3151283866u, 977769136u, 0, REMAINDERF_TOLERANCE, 0},
{2277, 1165177679u, 3276237026u, 3267492208u, 0, REMAINDERF_TOLERANCE, 0},
{2278, 3403009513u, 3381966453u, 1217674344u, 0, REMAINDERF_TOLERANCE, 0},
{2279, 952348506u, 3377573987u, 952348506u, 0, REMAINDERF_TOLERANCE, 0},
{2280, 1222777442u, 1125769920u, 1099360768u, 0, REMAINDERF_TOLERANCE, 0},
{2281, 1325324763u, 978336043u, 3113756462u, 0, REMAINDERF_TOLERANCE, 0},
{2282, 3363524213u, 3202991311u, 1029473112u, 0, REMAINDERF_TOLERANCE, 0},
{2283, 1158950321u, 1073578913u, 1037108016u, 0, REMAINDERF_TOLERANCE, 0},
{2284, 903129873u, 3416864271u, 903129873u, 0, REMAINDERF_TOLERANCE, 0},
{2285, 3078339944u, 988173985u, 3078339944u, 0, REMAINDERF_TOLERANCE, 0},
{2286, 1208345407u, 1254181270u, 1208345407u, 0, REMAINDERF_TOLERANCE, 0},
{2287, 1258634105u, 1247426200u, 1237385576u, 0, REMAINDERF_TOLERANCE, 0},
{2288, 1248478509u, 1287895126u, 1248478509u, 0, REMAINDERF_TOLERANCE, 0},
{2289, 1153863988u, 3430539165u, 1153863988u, 0, REMAINDERF_TOLERANCE, 0},
{2290, 1235620969u, 866627358u, 3004237692u, 0, REMAINDERF_TOLERANCE, 0},
{2291, 1097120930u, 3221726305u, 3205116028u, 0, REMAINDERF_TOLERANCE, 0},
{2292, 3469778622u, 1200179013u, 1190998076u, 0, REMAINDERF_TOLERANCE, 0},
{2293, 1147712200u, 931865525u, 899214128u, 0, REMAINDERF_TOLERANCE, 0},
{2294, 1124721745u, 3058969650u, 3036165440u, 0, REMAINDERF_TOLERANCE, 0},
{2295, 3261744304u, 1043806501u, 3177891572u, 0, REMAINDERF_TOLERANCE, 0},
{2296, 3303160152u, 3075455322u, 3064687000u, 0, REMAINDERF_TOLERANCE, 0},
{2297, 1315090496u, 3269683237u, 3245461936u, 0, REMAINDERF_TOLERANCE, 0},
{2298, 1335399673u, 974138676u, 3108006224u, 0, REMAINDERF_TOLERANCE, 0},
{2299, 1072458508u, 3372833993u, 1072458508u, 0, REMAINDERF_TOLERANCE, 0},
{2300, 3303015249u, 3015039539u, 850147332u, 0, REMAINDERF_TOLERANCE, 0},
{2301, 3252139741u, 1059615003u, 1011903680u, 0, REMAINDERF_TOLERANCE, 0},
{2302, 3468519966u, 3113982619u, 3087617688u, 0, REMAINDERF_TOLERANCE, 0},
{2303, 1006231203u, 897530770u, 3020384160u, 0, REMAINDERF_TOLERANCE, 0},
{2304, 951554138u, 1001144381u, 951554138u, 0, REMAINDERF_TOLERANCE, 0},
{2305, 942046828u, 986341002u, 942046828u, 0, REMAINDERF_TOLERANCE, 0},
{2306, 3319723279u, 3414482416u, 3319723279u, 0, REMAINDERF_TOLERANCE, 0},
{2307, 3255104167u, 928827688u, 915676752u, 0, REMAINDERF_TOLERANCE, 0},
{2308, 1155477903u, 3104812800u, 3094453248u, 0, REMAINDERF_TOLERANCE, 0},
{2309, 3273889176u, 980486479u, 3119241930u, 0, REMAINDERF_TOLERANCE, 0},
{2310, 3237813668u, 3441016803u, 3237813668u, 0, REMAINDERF_TOLERANCE, 0},
{2311, 1228207362u, 2985476579u, 2953847432u, 0, REMAINDERF_TOLERANCE, 0},
{2312, 1290175785u, 3008182462u, 2998391348u, 0, REMAINDERF_TOLERANCE, 0},
{2313, 981908840u, 3314038398u, 981908840u, 0, REMAINDERF_TOLERANCE, 0},
{2314, 941187647u, 1107765599u, 941187647u, 0, REMAINDERF_TOLERANCE, 0},
{2315, 1214223128u, 3225536822u, 1053837344u, 0, REMAINDERF_TOLERANCE, 0},
{2316, 3422922584u, 1086391131u, 3207980032u, 0, REMAINDERF_TOLERANCE, 0},
{2317, 1315857601u, 3487600045u, 1315857601u, 0, REMAINDERF_TOLERANCE, 0},
{2318, 3453226030u, 3233768835u, 3223552828u, 0, REMAINDERF_TOLERANCE, 0},
{2319, 1078359574u, 3199175230u, 1014665280u, 0, REMAINDERF_TOLERANCE, 0},
{2320, 1029557624u, 3302959071u, 1029557624u, 0, REMAINDERF_TOLERANCE, 0},
{2321, 1207675424u, 3042692550u, 876831328u, 0, REMAINDERF_TOLERANCE, 0},
{2322, 1028355074u, 3442294040u, 1028355074u, 0, REMAINDERF_TOLERANCE, 0},
{2323, 1248421894u, 3367769132u, 3336083584u, 0, REMAINDERF_TOLERANCE, 0},
{2324, 3353251994u, 1095517730u, 1086597880u, 0, REMAINDERF_TOLERANCE, 0},
{2325, 876926659u, 3288089977u, 876926659u, 0, REMAINDERF_TOLERANCE, 0},
{2326, 1076752219u, 876236939u, 853834344u, 0, REMAINDERF_TOLERANCE, 0},
{2327, 3388531942u, 2988520062u, 2965920304u, 0, REMAINDERF_TOLERANCE, 0},
{2328, 1273395082u, 3031189261u, 872233456u, 0, REMAINDERF_TOLERANCE, 0},
{2329, 3385588183u, 3258252464u, 3237664000u, 0, REMAINDERF_TOLERANCE, 0},
{2330, 3192315328u, 3289489214u, 3192315328u, 0, REMAINDERF_TOLERANCE, 0},
{2331, 3441804648u, 3274638356u, 3263870600u, 0, REMAINDERF_TOLERANCE, 0},
{2332, 3392827417u, 1277961150u, 3392827417u, 0, REMAINDERF_TOLERANCE, 0},
{2333, 1161241793u, 1328003707u, 1161241793u, 0, REMAINDERF_TOLERANCE, 0},
{2334, 3034494183u, 3041579130u, 884403213u, 0, REMAINDERF_TOLERANCE, 0},
{2335, 1171318485u, 3374409104u, 1171318485u, 0, REMAINDERF_TOLERANCE, 0},
{2336, 3047748143u, 831102792u, 2962440896u, 0, REMAINDERF_TOLERANCE, 0},
{2337, 1001216371u, 3052357038u, 896350396u, 0, REMAINDERF_TOLERANCE, 0},
{2338, 912515889u, 1074635609u, 912515889u, 0, REMAINDERF_TOLERANCE, 0},
{2339, 3391452505u, 897989232u, 888432512u, 0, REMAINDERF_TOLERANCE, 0},
{2340, 3249603369u, 3147662248u, 3104459008u, 0, REMAINDERF_TOLERANCE, 0},
{2341, 1220264047u, 2960450369u, 2948790886u, 0, REMAINDERF_TOLERANCE, 0},
{2342, 3169816394u, 988430929u, 3123289888u, 0, REMAINDERF_TOLERANCE, 0},
{2343, 3098997418u, 3002162688u, 842333184u, 0, REMAINDERF_TOLERANCE, 0},
{2344, 3282212423u, 3174079140u, 1007414880u, 0, REMAINDERF_TOLERANCE, 0},
{2345, 3352293320u, 3247843425u, 3218976128u, 0, REMAINDERF_TOLERANCE, 0},
{2346, 3296358441u, 875645354u, 862714536u, 0, REMAINDERF_TOLERANCE, 0},
{2347, 1197828352u, 3245614728u, 3230573968u, 0, REMAINDERF_TOLERANCE, 0},
{2348, 3340510371u, 914930263u, 897884204u, 0, REMAINDERF_TOLERANCE, 0},
{2349, 1127109339u, 3368125489u, 1127109339u, 0, REMAINDERF_TOLERANCE, 0},
{2350, 1200599955u, 2981200675u, 817704344u, 0, REMAINDERF_TOLERANCE, 0},
{2351, 962230977u, 2988248037u, 805535536u, 0, REMAINDERF_TOLERANCE, 0},
{2352, 3192887808u, 3191848339u, 3162359504u, 0, REMAINDERF_TOLERANCE, 0},
{2353, 3237183876u, 3179379969u, 3166118432u, 0, REMAINDERF_TOLERANCE, 0},
{2354, 939285924u, 3056079386u, 855964160u, 0, REMAINDERF_TOLERANCE, 0},
{2355, 944050180u, 3452557879u, 944050180u, 0, REMAINDERF_TOLERANCE, 0},
{2356, 3058135703u, 3090284601u, 3058135703u, 0, REMAINDERF_TOLERANCE, 0},
{2357, 3480592662u, 3261728191u, 3221094720u, 0, REMAINDERF_TOLERANCE, 0},
{2358, 3061939312u, 3274418540u, 3061939312u, 0, REMAINDERF_TOLERANCE, 0},
{2359, 1003299981u, 853295521u, 831378192u, 0, REMAINDERF_TOLERANCE, 0},
{2360, 1155775526u, 1255814444u, 1155775526u, 0, REMAINDERF_TOLERANCE, 0},
{2361, 1234491880u, 3408568717u, 1234491880u, 0, REMAINDERF_TOLERANCE, 0}

// AUTOMATICALLY GENERATED VECTORS STOP

};

#endif // CYGONCE_LIBM_SCABNF_H multiple inclusion protection

// EOF remainderf.h
