#ifndef CYGONCE_LIBM_POW_H
#define CYGONCE_LIBM_POW_H
//===========================================================================
//
//      pow.h
//
//      Test vectors for testing of pow() math library function
//
//===========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####
// -------------------------------------------
// This file is part of eCos, the Embedded Configurable Operating System.
// Copyright (C) 2012 Free Software Foundation, Inc.
//
// eCos is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 or (at your option) any later
// version.
//
// eCos is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
// for more details.
//
// You should have received a copy of the GNU General Public License
// along with eCos; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//
// As a special exception, if other files instantiate templates or use
// macros or inline functions from this file, or you compile this file
// and link it with other works to produce a work based on this file,
// this file does not by itself cause the resulting work to be covered by
// the GNU General Public License. However the source code for this file
// must still be made available in accordance with section (3) of the GNU
// General Public License v2.
//
// This exception does not invalidate any other reasons why a work based
// on this file might be covered by the GNU General Public License.
// -------------------------------------------
// ####ECOSGPLCOPYRIGHTEND####
//===========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):
// Contributors:  visar, ilijak
// Date:        1998-02-13
// Purpose:
// Description:
// Usage:       #include "vectors/pow.h"
//
//####DESCRIPTIONEND####
//
//===========================================================================


// CONFIGURATION

#include <pkgconf/libm.h>   // Configuration header


// INCLUDES

#include <cyg/infra/cyg_type.h>    // Common type definitions and support
#include "vectors/vector_support_float.h"// extra support for math tests

#define POW_TOLERANCE 2.0E-04

static const Cyg_libm_test_float_vec_t pow_vec[] = {

// AUTOMATICALLY GENERATED VECTORS START

{0, 1198712763u, 919636942u, 1065353791u, 0, POW_TOLERANCE, 0},
{1, 954173073u, 850531830u, 1065353213u, 0, POW_TOLERANCE, 0},
{2, 1166191415u, 1018661564u, 1067076343u, 0, POW_TOLERANCE, 0},
{3, 1167223673u, 846102364u, 1065353217u, 0, POW_TOLERANCE, 0},
{4, 968192794u, 878547432u, 1065353188u, 0, POW_TOLERANCE, 0},
{5, 1306460502u, 903489435u, 1065353488u, 0, POW_TOLERANCE, 0},
{6, 941796645u, 886451963u, 1065353148u, 0, POW_TOLERANCE, 0},
{7, 1143233714u, 1007268238u, 1065823341u, 0, POW_TOLERANCE, 0},
{8, 1309289088u, 1019883016u, 1070767293u, 0, POW_TOLERANCE, 0},
{9, 1238569473u, 873035665u, 1065353231u, 0, POW_TOLERANCE, 0},
{10, 1142167709u, 1096445242u, 2119523639u, 0, POW_TOLERANCE, 0},
{11, 982950501u, 982549888u, 1065228471u, 0, POW_TOLERANCE, 0},
{12, 1142981585u, 1015602236u, 1066309943u, 0, POW_TOLERANCE, 0},
{13, 1061834641u, 972388096u, 1065351367u, 0, POW_TOLERANCE, 0},
{14, 1000611335u, 857599439u, 1065353213u, 0, POW_TOLERANCE, 0},
{15, 822041816u, 898402905u, 1065352863u, 0, POW_TOLERANCE, 0},
{16, 977281449u, 879922831u, 1065353189u, 0, POW_TOLERANCE, 0},
{17, 1086198791u, 920125958u, 1065353312u, 0, POW_TOLERANCE, 0},
{18, 1255152035u, 851754050u, 1065353219u, 0, POW_TOLERANCE, 0},
{19, 1094190727u, 1056854532u, 1079464258u, 0, POW_TOLERANCE, 0},
{20, 1294665325u, 991185677u, 1065721824u, 0, POW_TOLERANCE, 0},
{21, 1036608591u, 805416536u, 1065353216u, 0, POW_TOLERANCE, 0},
{22, 1325668223u, 970681762u, 1065429107u, 0, POW_TOLERANCE, 0},
{23, 1092037607u, 1027330835u, 1066263156u, 0, POW_TOLERANCE, 0},
{24, 1243664530u, 972879810u, 1065413269u, 0, POW_TOLERANCE, 0},
{25, 950829092u, 929114193u, 1065351098u, 0, POW_TOLERANCE, 0},
{26, 1030934236u, 1045139240u, 1058143257u, 0, POW_TOLERANCE, 0},
{27, 1161858787u, 815362075u, 1065353216u, 0, POW_TOLERANCE, 0},
{28, 1189120494u, 978961471u, 1065425061u, 0, POW_TOLERANCE, 0},
{29, 1065798296u, 816191940u, 1065353216u, 0, POW_TOLERANCE, 0},
{30, 1273397670u, 901308750u, 1065353415u, 0, POW_TOLERANCE, 0},
{31, 1051773536u, 896271348u, 1065353200u, 0, POW_TOLERANCE, 0},
{32, 1283624229u, 906796922u, 1065353533u, 0, POW_TOLERANCE, 0},
{33, 970649315u, 1078286437u, 774321244u, 0, POW_TOLERANCE, 0},
{34, 1279489061u, 1006049444u, 1066554775u, 0, POW_TOLERANCE, 0},
{35, 1233171235u, 826460580u, 1065353216u, 0, POW_TOLERANCE, 0},
{36, 1148920078u, 1007674793u, 1065878255u, 0, POW_TOLERANCE, 0},
{37, 1000014431u, 831213088u, 1065353216u, 0, POW_TOLERANCE, 0},
{38, 1234530539u, 1079988872u, 1656602122u, 0, POW_TOLERANCE, 0},
{39, 1276853215u, 873199561u, 1065353235u, 0, POW_TOLERANCE, 0},
{40, 1212717473u, 837873779u, 1065353217u, 0, POW_TOLERANCE, 0},
{41, 1022211242u, 922124181u, 1065352780u, 0, POW_TOLERANCE, 0},
{42, 1189421739u, 1056599002u, 1125718440u, 0, POW_TOLERANCE, 0},
{43, 1034611395u, 882288581u, 1065353204u, 0, POW_TOLERANCE, 0},
{44, 1314588083u, 856187848u, 1065353221u, 0, POW_TOLERANCE, 0},
{45, 861266716u, 822172554u, 1065353215u, 0, POW_TOLERANCE, 0},
{46, 1156767533u, 1088986462u, 1730804446u, 0, POW_TOLERANCE, 0},
{47, 994934087u, 967678094u, 1065321222u, 0, POW_TOLERANCE, 0},
{48, 918212457u, 1017468331u, 1061718387u, 0, POW_TOLERANCE, 0},
{49, 959956547u, 876324728u, 1065353191u, 0, POW_TOLERANCE, 0},
{50, 1206054701u, 826010009u, 1065353216u, 0, POW_TOLERANCE, 0},
{51, 822524010u, 970745811u, 1065212397u, 0, POW_TOLERANCE, 0},
{52, 1213609983u, 919983950u, 1065353874u, 0, POW_TOLERANCE, 0},
{53, 1317696241u, 870681806u, 1065353235u, 0, POW_TOLERANCE, 0},
{54, 1228636133u, 886552820u, 1065353262u, 0, POW_TOLERANCE, 0},
{55, 1207246237u, 859223639u, 1065353220u, 0, POW_TOLERANCE, 0},
{56, 1149651309u, 970030475u, 1065376643u, 0, POW_TOLERANCE, 0},
{57, 943645710u, 852875779u, 1065353212u, 0, POW_TOLERANCE, 0},
{58, 935847271u, 1067255804u, 906953987u, 0, POW_TOLERANCE, 0},
{59, 1001823878u, 1016826861u, 1063778802u, 0, POW_TOLERANCE, 0},
{60, 1009130212u, 1004302940u, 1064842908u, 0, POW_TOLERANCE, 0},
{61, 1120261759u, 892210998u, 1065353241u, 0, POW_TOLERANCE, 0},
{62, 1087750238u, 1099325523u, 1451348348u, 0, POW_TOLERANCE, 0},
{63, 1186234578u, 858134374u, 1065353219u, 0, POW_TOLERANCE, 0},
{64, 1331680743u, 1009396165u, 1067511672u, 0, POW_TOLERANCE, 0},
{65, 847857044u, 894661023u, 1065352979u, 0, POW_TOLERANCE, 0},
{66, 1270451568u, 928393353u, 1065355037u, 0, POW_TOLERANCE, 0},
{67, 1171873518u, 954709738u, 1065361420u, 0, POW_TOLERANCE, 0},
{68, 982612185u, 923582663u, 1065352258u, 0, POW_TOLERANCE, 0},
{69, 1144755661u, 860947435u, 1065353219u, 0, POW_TOLERANCE, 0},
{70, 840456845u, 1051585760u, 988879588u, 0, POW_TOLERANCE, 0},
{71, 898467286u, 839254959u, 1065353214u, 0, POW_TOLERANCE, 0},
{72, 871130681u, 905123007u, 1065352729u, 0, POW_TOLERANCE, 0},
{73, 1153863660u, 1011991342u, 1066183352u, 0, POW_TOLERANCE, 0},
{74, 849056171u, 910674398u, 1065352326u, 0, POW_TOLERANCE, 0},
{75, 1250249095u, 1069023744u, 1330736323u, 0, POW_TOLERANCE, 0},
{76, 1025404104u, 1066370251u, 1020631328u, 0, POW_TOLERANCE, 0},
{77, 1099710167u, 887180181u, 1065353226u, 0, POW_TOLERANCE, 0},
{78, 1253017688u, 942062372u, 1065358408u, 0, POW_TOLERANCE, 0},
{79, 1266928623u, 811778614u, 1065353216u, 0, POW_TOLERANCE, 0},
{80, 1152416724u, 962669179u, 1065366291u, 0, POW_TOLERANCE, 0},
{81, 835770216u, 865469272u, 1065353194u, 0, POW_TOLERANCE, 0},
{82, 1278946388u, 825129857u, 1065353216u, 0, POW_TOLERANCE, 0},
{83, 1297190916u, 811863044u, 1065353216u, 0, POW_TOLERANCE, 0},
{84, 1277649137u, 961171401u, 1065381745u, 0, POW_TOLERANCE, 0},
{85, 1306520561u, 957302464u, 1065376134u, 0, POW_TOLERANCE, 0},
{86, 808412264u, 941158192u, 1065340269u, 0, POW_TOLERANCE, 0},
{87, 893449284u, 1052877339u, 1000054884u, 0, POW_TOLERANCE, 0},
{88, 1043025031u, 987068973u, 1065304428u, 0, POW_TOLERANCE, 0},
{89, 902318189u, 849277289u, 1065353212u, 0, POW_TOLERANCE, 0},
{90, 1120888322u, 1086209113u, 1398810821u, 0, POW_TOLERANCE, 0},
{91, 1040617590u, 1034835971u, 1062691293u, 0, POW_TOLERANCE, 0},
{92, 823111402u, 877253523u, 1065353153u, 0, POW_TOLERANCE, 0},
{93, 904255535u, 1019967545u, 1060640156u, 0, POW_TOLERANCE, 0},
{94, 1039827284u, 1072928888u, 1016479294u, 0, POW_TOLERANCE, 0},
{95, 1021564080u, 1064468397u, 1024039626u, 0, POW_TOLERANCE, 0},
{96, 1133689539u, 1067460093u, 1150866472u, 0, POW_TOLERANCE, 0},
{97, 954999730u, 969618597u, 1065294201u, 0, POW_TOLERANCE, 0},
{98, 940437609u, 860372396u, 1065353208u, 0, POW_TOLERANCE, 0},
{99, 1299683827u, 966031619u, 1065399368u, 0, POW_TOLERANCE, 0},
{100, 1229268598u, 1066965677u, 1260934057u, 0, POW_TOLERANCE, 0},
{101, 1246019790u, 850632217u, 1065353219u, 0, POW_TOLERANCE, 0},
{102, 1015670780u, 1101217251u, 56180015u, 0, POW_TOLERANCE, 0},
{103, 1156767169u, 1049756240u, 1091216627u, 0, POW_TOLERANCE, 0},
{104, 1098662266u, 833740182u, 1065353216u, 0, POW_TOLERANCE, 0},
{105, 927582555u, 947955456u, 1065341561u, 0, POW_TOLERANCE, 0},
{106, 860108361u, 921064349u, 1065351270u, 0, POW_TOLERANCE, 0},
{107, 1245702957u, 894348966u, 1065353313u, 0, POW_TOLERANCE, 0},
{108, 922255363u, 958305289u, 1065323270u, 0, POW_TOLERANCE, 0},
{109, 1113104661u, 944376032u, 1065354829u, 0, POW_TOLERANCE, 0},
{110, 1136714348u, 828849087u, 1065353216u, 0, POW_TOLERANCE, 0},
{111, 948856035u, 1015466475u, 1062902450u, 0, POW_TOLERANCE, 0},
{112, 1034561811u, 1054043114u, 1052198635u, 0, POW_TOLERANCE, 0},
{113, 853827378u, 898656161u, 1065352901u, 0, POW_TOLERANCE, 0},
{114, 1309658335u, 1010219988u, 1067475014u, 0, POW_TOLERANCE, 0},
{115, 1161439847u, 943449277u, 1065356223u, 0, POW_TOLERANCE, 0},
{116, 908663107u, 939489763u, 1065346630u, 0, POW_TOLERANCE, 0},
{117, 1084378658u, 1009650785u, 1065499167u, 0, POW_TOLERANCE, 0},
{118, 1226473697u, 821025132u, 1065353216u, 0, POW_TOLERANCE, 0},
{119, 916831283u, 999465787u, 1064460513u, 0, POW_TOLERANCE, 0},
{120, 1317098613u, 949986176u, 1065366511u, 0, POW_TOLERANCE, 0},
{121, 1063693032u, 976661408u, 1065351998u, 0, POW_TOLERANCE, 0},
{122, 968803479u, 992989712u, 1065000552u, 0, POW_TOLERANCE, 0},
{123, 1325324763u, 978336043u, 1065497589u, 0, POW_TOLERANCE, 0},
{124, 1158950321u, 1073578913u, 1251181125u, 0, POW_TOLERANCE, 0},
{125, 1235620969u, 866627358u, 1065353225u, 0, POW_TOLERANCE, 0},
{126, 1147712200u, 931865525u, 1065354167u, 0, POW_TOLERANCE, 0},
{127, 805759679u, 903848557u, 1065352617u, 0, POW_TOLERANCE, 0},
{128, 1335399673u, 974138676u, 1065456997u, 0, POW_TOLERANCE, 0},
{129, 1006231203u, 897530770u, 1065353138u, 0, POW_TOLERANCE, 0},
{130, 951554138u, 1001144381u, 1064549096u, 0, POW_TOLERANCE, 0},
{131, 942046828u, 986341002u, 1065092748u, 0, POW_TOLERANCE, 0},
{132, 1076752219u, 876236939u, 1065353217u, 0, POW_TOLERANCE, 0},
{133, 862047095u, 829323655u, 1065353215u, 0, POW_TOLERANCE, 0},
{134, 912515889u, 1074635609u, 727565233u, 0, POW_TOLERANCE, 0},
{135, 1003299981u, 853295521u, 1065353214u, 0, POW_TOLERANCE, 0}

// AUTOMATICALLY GENERATED VECTORS STOP

};

#endif // CYGONCE_LIBM_POW_H multiple inclusion protection

// EOF pow.h
