#ifndef CYGONCE_LIBM_NEXTAFTERF_H
#define CYGONCE_LIBM_NEXTAFTERF_H
//===========================================================================
//
//      nextafterf.h
//
//      Test vectors for testing of nextafterf() math library function
//
//===========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####
// -------------------------------------------
// This file is part of eCos, the Embedded Configurable Operating System.
// Copyright (C) 2012 Free Software Foundation, Inc.
//
// eCos is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 or (at your option) any later
// version.
//
// eCos is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
// for more details.
//
// You should have received a copy of the GNU General Public License
// along with eCos; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//
// As a special exception, if other files instantiate templates or use
// macros or inline functions from this file, or you compile this file
// and link it with other works to produce a work based on this file,
// this file does not by itself cause the resulting work to be covered by
// the GNU General Public License. However the source code for this file
// must still be made available in accordance with section (3) of the GNU
// General Public License v2.
//
// This exception does not invalidate any other reasons why a work based
// on this file might be covered by the GNU General Public License.
// -------------------------------------------
// ####ECOSGPLCOPYRIGHTEND####
//===========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):
// Contributors:  visar, ilijak
// Date:        1998-02-13
// Purpose:
// Description:
// Usage:       #include "vectors/nextafterf.h"
//
//####DESCRIPTIONEND####
//
//===========================================================================


// CONFIGURATION

#include <pkgconf/libm.h>   // Configuration header


// INCLUDES

#include <cyg/infra/cyg_type.h>    // Common type definitions and support
#include "vectors/vector_support_float.h"// extra support for math tests

#define NEXTAFTERF_TOLERANCE 1.0E-04

static const Cyg_libm_test_float_vec_t nextafterf_vec[] = {

// AUTOMATICALLY GENERATED VECTORS START

{0, 3214514586u, 0u, 3214514585u, 0, NEXTAFTERF_TOLERANCE, 0},
{1, 3214430700u, 0u, 3214430699u, 0, NEXTAFTERF_TOLERANCE, 0},
{2, 3214346813u, 0u, 3214346812u, 0, NEXTAFTERF_TOLERANCE, 0},
{3, 3214262927u, 0u, 3214262926u, 0, NEXTAFTERF_TOLERANCE, 0},
{4, 3214179041u, 0u, 3214179040u, 0, NEXTAFTERF_TOLERANCE, 0},
{5, 3214095155u, 0u, 3214095154u, 0, NEXTAFTERF_TOLERANCE, 0},
{6, 3214011269u, 0u, 3214011268u, 0, NEXTAFTERF_TOLERANCE, 0},
{7, 3213927383u, 0u, 3213927382u, 0, NEXTAFTERF_TOLERANCE, 0},
{8, 3213843497u, 0u, 3213843496u, 0, NEXTAFTERF_TOLERANCE, 0},
{9, 3213759611u, 0u, 3213759610u, 0, NEXTAFTERF_TOLERANCE, 0},
{10, 3213675725u, 0u, 3213675724u, 0, NEXTAFTERF_TOLERANCE, 0},
{11, 3213591839u, 0u, 3213591838u, 0, NEXTAFTERF_TOLERANCE, 0},
{12, 3213507953u, 0u, 3213507952u, 0, NEXTAFTERF_TOLERANCE, 0},
{13, 3213424067u, 0u, 3213424066u, 0, NEXTAFTERF_TOLERANCE, 0},
{14, 3213340180u, 0u, 3213340179u, 0, NEXTAFTERF_TOLERANCE, 0},
{15, 3213256294u, 0u, 3213256293u, 0, NEXTAFTERF_TOLERANCE, 0},
{16, 3213172408u, 0u, 3213172407u, 0, NEXTAFTERF_TOLERANCE, 0},
{17, 3213088522u, 0u, 3213088521u, 0, NEXTAFTERF_TOLERANCE, 0},
{18, 3213004636u, 0u, 3213004635u, 0, NEXTAFTERF_TOLERANCE, 0},
{19, 3212920750u, 0u, 3212920749u, 0, NEXTAFTERF_TOLERANCE, 0},
{20, 3212836864u, 0u, 3212836863u, 0, NEXTAFTERF_TOLERANCE, 0},
{21, 3212669092u, 0u, 3212669091u, 0, NEXTAFTERF_TOLERANCE, 0},
{22, 3212501320u, 0u, 3212501319u, 0, NEXTAFTERF_TOLERANCE, 0},
{23, 3212333548u, 0u, 3212333547u, 0, NEXTAFTERF_TOLERANCE, 0},
{24, 3212165775u, 0u, 3212165774u, 0, NEXTAFTERF_TOLERANCE, 0},
{25, 3211998003u, 0u, 3211998002u, 0, NEXTAFTERF_TOLERANCE, 0},
{26, 3211830231u, 0u, 3211830230u, 0, NEXTAFTERF_TOLERANCE, 0},
{27, 3211662459u, 0u, 3211662458u, 0, NEXTAFTERF_TOLERANCE, 0},
{28, 3211494687u, 0u, 3211494686u, 0, NEXTAFTERF_TOLERANCE, 0},
{29, 3211326915u, 0u, 3211326914u, 0, NEXTAFTERF_TOLERANCE, 0},
{30, 3211159142u, 0u, 3211159141u, 0, NEXTAFTERF_TOLERANCE, 0},
{31, 3210991370u, 0u, 3210991369u, 0, NEXTAFTERF_TOLERANCE, 0},
{32, 3210823598u, 0u, 3210823597u, 0, NEXTAFTERF_TOLERANCE, 0},
{33, 3210655826u, 0u, 3210655825u, 0, NEXTAFTERF_TOLERANCE, 0},
{34, 3210488054u, 0u, 3210488053u, 0, NEXTAFTERF_TOLERANCE, 0},
{35, 3210320282u, 0u, 3210320281u, 0, NEXTAFTERF_TOLERANCE, 0},
{36, 3210152509u, 0u, 3210152508u, 0, NEXTAFTERF_TOLERANCE, 0},
{37, 3209984737u, 0u, 3209984736u, 0, NEXTAFTERF_TOLERANCE, 0},
{38, 3209816965u, 0u, 3209816964u, 0, NEXTAFTERF_TOLERANCE, 0},
{39, 3209649193u, 0u, 3209649192u, 0, NEXTAFTERF_TOLERANCE, 0},
{40, 3209481421u, 0u, 3209481420u, 0, NEXTAFTERF_TOLERANCE, 0},
{41, 3209313649u, 0u, 3209313648u, 0, NEXTAFTERF_TOLERANCE, 0},
{42, 3209145876u, 0u, 3209145875u, 0, NEXTAFTERF_TOLERANCE, 0},
{43, 3208978104u, 0u, 3208978103u, 0, NEXTAFTERF_TOLERANCE, 0},
{44, 3208810332u, 0u, 3208810331u, 0, NEXTAFTERF_TOLERANCE, 0},
{45, 3208642560u, 0u, 3208642559u, 0, NEXTAFTERF_TOLERANCE, 0},
{46, 3208474788u, 0u, 3208474787u, 0, NEXTAFTERF_TOLERANCE, 0},
{47, 3208307016u, 0u, 3208307015u, 0, NEXTAFTERF_TOLERANCE, 0},
{48, 3208139244u, 0u, 3208139243u, 0, NEXTAFTERF_TOLERANCE, 0},
{49, 3207971471u, 0u, 3207971470u, 0, NEXTAFTERF_TOLERANCE, 0},
{50, 3207803699u, 0u, 3207803698u, 0, NEXTAFTERF_TOLERANCE, 0},
{51, 3207635927u, 0u, 3207635926u, 0, NEXTAFTERF_TOLERANCE, 0},
{52, 3207468155u, 0u, 3207468154u, 0, NEXTAFTERF_TOLERANCE, 0},
{53, 3207300383u, 0u, 3207300382u, 0, NEXTAFTERF_TOLERANCE, 0},
{54, 3207132611u, 0u, 3207132610u, 0, NEXTAFTERF_TOLERANCE, 0},
{55, 3206964838u, 0u, 3206964837u, 0, NEXTAFTERF_TOLERANCE, 0},
{56, 3206797066u, 0u, 3206797065u, 0, NEXTAFTERF_TOLERANCE, 0},
{57, 3206629294u, 0u, 3206629293u, 0, NEXTAFTERF_TOLERANCE, 0},
{58, 3206461522u, 0u, 3206461521u, 0, NEXTAFTERF_TOLERANCE, 0},
{59, 3206293750u, 0u, 3206293749u, 0, NEXTAFTERF_TOLERANCE, 0},
{60, 3206125978u, 0u, 3206125977u, 0, NEXTAFTERF_TOLERANCE, 0},
{61, 3205958205u, 0u, 3205958204u, 0, NEXTAFTERF_TOLERANCE, 0},
{62, 3205790433u, 0u, 3205790432u, 0, NEXTAFTERF_TOLERANCE, 0},
{63, 3205622661u, 0u, 3205622660u, 0, NEXTAFTERF_TOLERANCE, 0},
{64, 3205454889u, 0u, 3205454888u, 0, NEXTAFTERF_TOLERANCE, 0},
{65, 3205287117u, 0u, 3205287116u, 0, NEXTAFTERF_TOLERANCE, 0},
{66, 3205119345u, 0u, 3205119344u, 0, NEXTAFTERF_TOLERANCE, 0},
{67, 3204951572u, 0u, 3204951571u, 0, NEXTAFTERF_TOLERANCE, 0},
{68, 3204783800u, 0u, 3204783799u, 0, NEXTAFTERF_TOLERANCE, 0},
{69, 3204616028u, 0u, 3204616027u, 0, NEXTAFTERF_TOLERANCE, 0},
{70, 3204448256u, 0u, 3204448255u, 0, NEXTAFTERF_TOLERANCE, 0},
{71, 3204112712u, 0u, 3204112711u, 0, NEXTAFTERF_TOLERANCE, 0},
{72, 3203777167u, 0u, 3203777166u, 0, NEXTAFTERF_TOLERANCE, 0},
{73, 3203441623u, 0u, 3203441622u, 0, NEXTAFTERF_TOLERANCE, 0},
{74, 3203106079u, 0u, 3203106078u, 0, NEXTAFTERF_TOLERANCE, 0},
{75, 3202770534u, 0u, 3202770533u, 0, NEXTAFTERF_TOLERANCE, 0},
{76, 3202434990u, 0u, 3202434989u, 0, NEXTAFTERF_TOLERANCE, 0},
{77, 3202099446u, 0u, 3202099445u, 0, NEXTAFTERF_TOLERANCE, 0},
{78, 3201763901u, 0u, 3201763900u, 0, NEXTAFTERF_TOLERANCE, 0},
{79, 3201428357u, 0u, 3201428356u, 0, NEXTAFTERF_TOLERANCE, 0},
{80, 3201092813u, 0u, 3201092812u, 0, NEXTAFTERF_TOLERANCE, 0},
{81, 3200757268u, 0u, 3200757267u, 0, NEXTAFTERF_TOLERANCE, 0},
{82, 3200421724u, 0u, 3200421723u, 0, NEXTAFTERF_TOLERANCE, 0},
{83, 3200086180u, 0u, 3200086179u, 0, NEXTAFTERF_TOLERANCE, 0},
{84, 3199750636u, 0u, 3199750635u, 0, NEXTAFTERF_TOLERANCE, 0},
{85, 3199415091u, 0u, 3199415090u, 0, NEXTAFTERF_TOLERANCE, 0},
{86, 3199079547u, 0u, 3199079546u, 0, NEXTAFTERF_TOLERANCE, 0},
{87, 3198744003u, 0u, 3198744002u, 0, NEXTAFTERF_TOLERANCE, 0},
{88, 3198408458u, 0u, 3198408457u, 0, NEXTAFTERF_TOLERANCE, 0},
{89, 3198072914u, 0u, 3198072913u, 0, NEXTAFTERF_TOLERANCE, 0},
{90, 3197737370u, 0u, 3197737369u, 0, NEXTAFTERF_TOLERANCE, 0},
{91, 3197401825u, 0u, 3197401824u, 0, NEXTAFTERF_TOLERANCE, 0},
{92, 3197066281u, 0u, 3197066280u, 0, NEXTAFTERF_TOLERANCE, 0},
{93, 3196730737u, 0u, 3196730736u, 0, NEXTAFTERF_TOLERANCE, 0},
{94, 3196395192u, 0u, 3196395191u, 0, NEXTAFTERF_TOLERANCE, 0},
{95, 3196059648u, 0u, 3196059647u, 0, NEXTAFTERF_TOLERANCE, 0},
{96, 3195388559u, 0u, 3195388558u, 0, NEXTAFTERF_TOLERANCE, 0},
{97, 3194717471u, 0u, 3194717470u, 0, NEXTAFTERF_TOLERANCE, 0},
{98, 3194046382u, 0u, 3194046381u, 0, NEXTAFTERF_TOLERANCE, 0},
{99, 3193375293u, 0u, 3193375292u, 0, NEXTAFTERF_TOLERANCE, 0},
{100, 3192704205u, 0u, 3192704204u, 0, NEXTAFTERF_TOLERANCE, 0},
{101, 3192033116u, 0u, 3192033115u, 0, NEXTAFTERF_TOLERANCE, 0},
{102, 3191362028u, 0u, 3191362027u, 0, NEXTAFTERF_TOLERANCE, 0},
{103, 3190690939u, 0u, 3190690938u, 0, NEXTAFTERF_TOLERANCE, 0},
{104, 3190019850u, 0u, 3190019849u, 0, NEXTAFTERF_TOLERANCE, 0},
{105, 3189348762u, 0u, 3189348761u, 0, NEXTAFTERF_TOLERANCE, 0},
{106, 3188677673u, 0u, 3188677672u, 0, NEXTAFTERF_TOLERANCE, 0},
{107, 3188006584u, 0u, 3188006583u, 0, NEXTAFTERF_TOLERANCE, 0},
{108, 3186999951u, 0u, 3186999950u, 0, NEXTAFTERF_TOLERANCE, 0},
{109, 3185657774u, 0u, 3185657773u, 0, NEXTAFTERF_TOLERANCE, 0},
{110, 3184315597u, 0u, 3184315596u, 0, NEXTAFTERF_TOLERANCE, 0},
{111, 3182973420u, 0u, 3182973419u, 0, NEXTAFTERF_TOLERANCE, 0},
{112, 3181631242u, 0u, 3181631241u, 0, NEXTAFTERF_TOLERANCE, 0},
{113, 3180289065u, 0u, 3180289064u, 0, NEXTAFTERF_TOLERANCE, 0},
{114, 3178611343u, 0u, 3178611342u, 0, NEXTAFTERF_TOLERANCE, 0},
{115, 3175926989u, 0u, 3175926988u, 0, NEXTAFTERF_TOLERANCE, 0},
{116, 3173242634u, 0u, 3173242633u, 0, NEXTAFTERF_TOLERANCE, 0},
{117, 3170222735u, 0u, 3170222734u, 0, NEXTAFTERF_TOLERANCE, 0},
{118, 3164854026u, 0u, 3164854025u, 0, NEXTAFTERF_TOLERANCE, 0},
{119, 3156465418u, 0u, 3156465417u, 0, NEXTAFTERF_TOLERANCE, 0},
{120, 1008981770u, 0u, 1008981769u, 0, NEXTAFTERF_TOLERANCE, 0},
{121, 1017370378u, 0u, 1017370377u, 0, NEXTAFTERF_TOLERANCE, 0},
{122, 1022739087u, 0u, 1022739086u, 0, NEXTAFTERF_TOLERANCE, 0},
{123, 1025758986u, 0u, 1025758985u, 0, NEXTAFTERF_TOLERANCE, 0},
{124, 1028443341u, 0u, 1028443340u, 0, NEXTAFTERF_TOLERANCE, 0},
{125, 1031127695u, 0u, 1031127694u, 0, NEXTAFTERF_TOLERANCE, 0},
{126, 1032805417u, 0u, 1032805416u, 0, NEXTAFTERF_TOLERANCE, 0},
{127, 1034147594u, 0u, 1034147593u, 0, NEXTAFTERF_TOLERANCE, 0},
{128, 1035489772u, 0u, 1035489771u, 0, NEXTAFTERF_TOLERANCE, 0},
{129, 1036831949u, 0u, 1036831948u, 0, NEXTAFTERF_TOLERANCE, 0},
{130, 1038174126u, 0u, 1038174125u, 0, NEXTAFTERF_TOLERANCE, 0},
{131, 1039516303u, 0u, 1039516302u, 0, NEXTAFTERF_TOLERANCE, 0},
{132, 1040522936u, 0u, 1040522935u, 0, NEXTAFTERF_TOLERANCE, 0},
{133, 1041194025u, 0u, 1041194024u, 0, NEXTAFTERF_TOLERANCE, 0},
{134, 1041865114u, 0u, 1041865113u, 0, NEXTAFTERF_TOLERANCE, 0},
{135, 1042536202u, 0u, 1042536201u, 0, NEXTAFTERF_TOLERANCE, 0},
{136, 1043207291u, 0u, 1043207290u, 0, NEXTAFTERF_TOLERANCE, 0},
{137, 1043878380u, 0u, 1043878379u, 0, NEXTAFTERF_TOLERANCE, 0},
{138, 1044549468u, 0u, 1044549467u, 0, NEXTAFTERF_TOLERANCE, 0},
{139, 1045220557u, 0u, 1045220556u, 0, NEXTAFTERF_TOLERANCE, 0},
{140, 1045891645u, 0u, 1045891644u, 0, NEXTAFTERF_TOLERANCE, 0},
{141, 1046562734u, 0u, 1046562733u, 0, NEXTAFTERF_TOLERANCE, 0},
{142, 1047233823u, 0u, 1047233822u, 0, NEXTAFTERF_TOLERANCE, 0},
{143, 1047904911u, 0u, 1047904910u, 0, NEXTAFTERF_TOLERANCE, 0},
{144, 1048576000u, 0u, 1048575999u, 0, NEXTAFTERF_TOLERANCE, 0},
{145, 1048911544u, 0u, 1048911543u, 0, NEXTAFTERF_TOLERANCE, 0},
{146, 1049247089u, 0u, 1049247088u, 0, NEXTAFTERF_TOLERANCE, 0},
{147, 1049582633u, 0u, 1049582632u, 0, NEXTAFTERF_TOLERANCE, 0},
{148, 1049918177u, 0u, 1049918176u, 0, NEXTAFTERF_TOLERANCE, 0},
{149, 1050253722u, 0u, 1050253721u, 0, NEXTAFTERF_TOLERANCE, 0},
{150, 1050589266u, 0u, 1050589265u, 0, NEXTAFTERF_TOLERANCE, 0},
{151, 1050924810u, 0u, 1050924809u, 0, NEXTAFTERF_TOLERANCE, 0},
{152, 1051260355u, 0u, 1051260354u, 0, NEXTAFTERF_TOLERANCE, 0},
{153, 1051595899u, 0u, 1051595898u, 0, NEXTAFTERF_TOLERANCE, 0},
{154, 1051931443u, 0u, 1051931442u, 0, NEXTAFTERF_TOLERANCE, 0},
{155, 1052266988u, 0u, 1052266987u, 0, NEXTAFTERF_TOLERANCE, 0},
{156, 1052602532u, 0u, 1052602531u, 0, NEXTAFTERF_TOLERANCE, 0},
{157, 1052938076u, 0u, 1052938075u, 0, NEXTAFTERF_TOLERANCE, 0},
{158, 1053273620u, 0u, 1053273619u, 0, NEXTAFTERF_TOLERANCE, 0},
{159, 1053609165u, 0u, 1053609164u, 0, NEXTAFTERF_TOLERANCE, 0},
{160, 1053944709u, 0u, 1053944708u, 0, NEXTAFTERF_TOLERANCE, 0},
{161, 1054280253u, 0u, 1054280252u, 0, NEXTAFTERF_TOLERANCE, 0},
{162, 1054615798u, 0u, 1054615797u, 0, NEXTAFTERF_TOLERANCE, 0},
{163, 1054951342u, 0u, 1054951341u, 0, NEXTAFTERF_TOLERANCE, 0},
{164, 1055286886u, 0u, 1055286885u, 0, NEXTAFTERF_TOLERANCE, 0},
{165, 1055622431u, 0u, 1055622430u, 0, NEXTAFTERF_TOLERANCE, 0},
{166, 1055957975u, 0u, 1055957974u, 0, NEXTAFTERF_TOLERANCE, 0},
{167, 1056293519u, 0u, 1056293518u, 0, NEXTAFTERF_TOLERANCE, 0},
{168, 1056629064u, 0u, 1056629063u, 0, NEXTAFTERF_TOLERANCE, 0},
{169, 1056964608u, 0u, 1056964607u, 0, NEXTAFTERF_TOLERANCE, 0},
{170, 1057132380u, 0u, 1057132379u, 0, NEXTAFTERF_TOLERANCE, 0},
{171, 1057300152u, 0u, 1057300151u, 0, NEXTAFTERF_TOLERANCE, 0},
{172, 1057467924u, 0u, 1057467923u, 0, NEXTAFTERF_TOLERANCE, 0},
{173, 1057635697u, 0u, 1057635696u, 0, NEXTAFTERF_TOLERANCE, 0},
{174, 1057803469u, 0u, 1057803468u, 0, NEXTAFTERF_TOLERANCE, 0},
{175, 1057971241u, 0u, 1057971240u, 0, NEXTAFTERF_TOLERANCE, 0},
{176, 1058139013u, 0u, 1058139012u, 0, NEXTAFTERF_TOLERANCE, 0},
{177, 1058306785u, 0u, 1058306784u, 0, NEXTAFTERF_TOLERANCE, 0},
{178, 1058474557u, 0u, 1058474556u, 0, NEXTAFTERF_TOLERANCE, 0},
{179, 1058642330u, 0u, 1058642329u, 0, NEXTAFTERF_TOLERANCE, 0},
{180, 1058810102u, 0u, 1058810101u, 0, NEXTAFTERF_TOLERANCE, 0},
{181, 1058977874u, 0u, 1058977873u, 0, NEXTAFTERF_TOLERANCE, 0},
{182, 1059145646u, 0u, 1059145645u, 0, NEXTAFTERF_TOLERANCE, 0},
{183, 1059313418u, 0u, 1059313417u, 0, NEXTAFTERF_TOLERANCE, 0},
{184, 1059481190u, 0u, 1059481189u, 0, NEXTAFTERF_TOLERANCE, 0},
{185, 1059648963u, 0u, 1059648962u, 0, NEXTAFTERF_TOLERANCE, 0},
{186, 1059816735u, 0u, 1059816734u, 0, NEXTAFTERF_TOLERANCE, 0},
{187, 1059984507u, 0u, 1059984506u, 0, NEXTAFTERF_TOLERANCE, 0},
{188, 1060152279u, 0u, 1060152278u, 0, NEXTAFTERF_TOLERANCE, 0},
{189, 1060320051u, 0u, 1060320050u, 0, NEXTAFTERF_TOLERANCE, 0},
{190, 1060487823u, 0u, 1060487822u, 0, NEXTAFTERF_TOLERANCE, 0},
{191, 1060655596u, 0u, 1060655595u, 0, NEXTAFTERF_TOLERANCE, 0},
{192, 1060823368u, 0u, 1060823367u, 0, NEXTAFTERF_TOLERANCE, 0},
{193, 1060991140u, 0u, 1060991139u, 0, NEXTAFTERF_TOLERANCE, 0},
{194, 1061158912u, 0u, 1061158911u, 0, NEXTAFTERF_TOLERANCE, 0},
{195, 1061326684u, 0u, 1061326683u, 0, NEXTAFTERF_TOLERANCE, 0},
{196, 1061494456u, 0u, 1061494455u, 0, NEXTAFTERF_TOLERANCE, 0},
{197, 1061662228u, 0u, 1061662227u, 0, NEXTAFTERF_TOLERANCE, 0},
{198, 1061830001u, 0u, 1061830000u, 0, NEXTAFTERF_TOLERANCE, 0},
{199, 1061997773u, 0u, 1061997772u, 0, NEXTAFTERF_TOLERANCE, 0},
{200, 1062165545u, 0u, 1062165544u, 0, NEXTAFTERF_TOLERANCE, 0},
{201, 1062333317u, 0u, 1062333316u, 0, NEXTAFTERF_TOLERANCE, 0},
{202, 1062501089u, 0u, 1062501088u, 0, NEXTAFTERF_TOLERANCE, 0},
{203, 1062668861u, 0u, 1062668860u, 0, NEXTAFTERF_TOLERANCE, 0},
{204, 1062836634u, 0u, 1062836633u, 0, NEXTAFTERF_TOLERANCE, 0},
{205, 1063004406u, 0u, 1063004405u, 0, NEXTAFTERF_TOLERANCE, 0},
{206, 1063172178u, 0u, 1063172177u, 0, NEXTAFTERF_TOLERANCE, 0},
{207, 1063339950u, 0u, 1063339949u, 0, NEXTAFTERF_TOLERANCE, 0},
{208, 1063507722u, 0u, 1063507721u, 0, NEXTAFTERF_TOLERANCE, 0},
{209, 1063675494u, 0u, 1063675493u, 0, NEXTAFTERF_TOLERANCE, 0},
{210, 1063843267u, 0u, 1063843266u, 0, NEXTAFTERF_TOLERANCE, 0},
{211, 1064011039u, 0u, 1064011038u, 0, NEXTAFTERF_TOLERANCE, 0},
{212, 1064178811u, 0u, 1064178810u, 0, NEXTAFTERF_TOLERANCE, 0},
{213, 1064346583u, 0u, 1064346582u, 0, NEXTAFTERF_TOLERANCE, 0},
{214, 1064514355u, 0u, 1064514354u, 0, NEXTAFTERF_TOLERANCE, 0},
{215, 1064682127u, 0u, 1064682126u, 0, NEXTAFTERF_TOLERANCE, 0},
{216, 1064849900u, 0u, 1064849899u, 0, NEXTAFTERF_TOLERANCE, 0},
{217, 1065017672u, 0u, 1065017671u, 0, NEXTAFTERF_TOLERANCE, 0},
{218, 1065185444u, 0u, 1065185443u, 0, NEXTAFTERF_TOLERANCE, 0},
{219, 1065353216u, 0u, 1065353215u, 0, NEXTAFTERF_TOLERANCE, 0},
{220, 1065437102u, 0u, 1065437101u, 0, NEXTAFTERF_TOLERANCE, 0},
{221, 1065520988u, 0u, 1065520987u, 0, NEXTAFTERF_TOLERANCE, 0},
{222, 1065604874u, 0u, 1065604873u, 0, NEXTAFTERF_TOLERANCE, 0},
{223, 1065688760u, 0u, 1065688759u, 0, NEXTAFTERF_TOLERANCE, 0},
{224, 1065772646u, 0u, 1065772645u, 0, NEXTAFTERF_TOLERANCE, 0},
{225, 1065856532u, 0u, 1065856531u, 0, NEXTAFTERF_TOLERANCE, 0},
{226, 1065940419u, 0u, 1065940418u, 0, NEXTAFTERF_TOLERANCE, 0},
{227, 1066024305u, 0u, 1066024304u, 0, NEXTAFTERF_TOLERANCE, 0},
{228, 1066108191u, 0u, 1066108190u, 0, NEXTAFTERF_TOLERANCE, 0},
{229, 1066192077u, 0u, 1066192076u, 0, NEXTAFTERF_TOLERANCE, 0},
{230, 1066275963u, 0u, 1066275962u, 0, NEXTAFTERF_TOLERANCE, 0},
{231, 1066359849u, 0u, 1066359848u, 0, NEXTAFTERF_TOLERANCE, 0},
{232, 1066443735u, 0u, 1066443734u, 0, NEXTAFTERF_TOLERANCE, 0},
{233, 1066527621u, 0u, 1066527620u, 0, NEXTAFTERF_TOLERANCE, 0},
{234, 1066611507u, 0u, 1066611506u, 0, NEXTAFTERF_TOLERANCE, 0},
{235, 1066695393u, 0u, 1066695392u, 0, NEXTAFTERF_TOLERANCE, 0},
{236, 1066779279u, 0u, 1066779278u, 0, NEXTAFTERF_TOLERANCE, 0},
{237, 1066863165u, 0u, 1066863164u, 0, NEXTAFTERF_TOLERANCE, 0},
{238, 1066947052u, 0u, 1066947051u, 0, NEXTAFTERF_TOLERANCE, 0},
{239, 3234402267u, 0u, 3234402266u, 0, NEXTAFTERF_TOLERANCE, 0},
{240, 3231108068u, 0u, 3231108067u, 0, NEXTAFTERF_TOLERANCE, 0},
{241, 3226013659u, 0u, 3226013658u, 0, NEXTAFTERF_TOLERANCE, 0},
{242, 3217625051u, 0u, 3217625050u, 0, NEXTAFTERF_TOLERANCE, 0},
{243, 0u, 0u, 0u, 0, NEXTAFTERF_TOLERANCE, 0},
{244, 1070141403u, 0u, 1070141402u, 0, NEXTAFTERF_TOLERANCE, 0},
{245, 1078530011u, 0u, 1078530010u, 0, NEXTAFTERF_TOLERANCE, 0},
{246, 1083624420u, 0u, 1083624419u, 0, NEXTAFTERF_TOLERANCE, 0},
{247, 3253731328u, 0u, 3253731327u, 0, NEXTAFTERF_TOLERANCE, 0},
{248, 3252840038u, 0u, 3252840037u, 0, NEXTAFTERF_TOLERANCE, 0},
{249, 3251948749u, 0u, 3251948748u, 0, NEXTAFTERF_TOLERANCE, 0},
{250, 3251057459u, 0u, 3251057458u, 0, NEXTAFTERF_TOLERANCE, 0},
{251, 3250166170u, 0u, 3250166169u, 0, NEXTAFTERF_TOLERANCE, 0},
{252, 3249274880u, 0u, 3249274879u, 0, NEXTAFTERF_TOLERANCE, 0},
{253, 3248383590u, 0u, 3248383589u, 0, NEXTAFTERF_TOLERANCE, 0},
{254, 3247492301u, 0u, 3247492300u, 0, NEXTAFTERF_TOLERANCE, 0},
{255, 3246601011u, 0u, 3246601010u, 0, NEXTAFTERF_TOLERANCE, 0},
{256, 3245028147u, 0u, 3245028146u, 0, NEXTAFTERF_TOLERANCE, 0},
{257, 3243245568u, 0u, 3243245567u, 0, NEXTAFTERF_TOLERANCE, 0},
{258, 3241462989u, 0u, 3241462988u, 0, NEXTAFTERF_TOLERANCE, 0},
{259, 3239680410u, 0u, 3239680409u, 0, NEXTAFTERF_TOLERANCE, 0},
{260, 3237792973u, 0u, 3237792972u, 0, NEXTAFTERF_TOLERANCE, 0},
{261, 3234227814u, 0u, 3234227813u, 0, NEXTAFTERF_TOLERANCE, 0},
{262, 3230662656u, 0u, 3230662655u, 0, NEXTAFTERF_TOLERANCE, 0},
{263, 3224580915u, 0u, 3224580914u, 0, NEXTAFTERF_TOLERANCE, 0},
{264, 3213675725u, 0u, 3213675724u, 0, NEXTAFTERF_TOLERANCE, 0},
{265, 1058642330u, 0u, 1058642329u, 0, NEXTAFTERF_TOLERANCE, 0},
{266, 1075000115u, 0u, 1075000114u, 0, NEXTAFTERF_TOLERANCE, 0},
{267, 1082130432u, 0u, 1082130431u, 0, NEXTAFTERF_TOLERANCE, 0},
{268, 1085695590u, 0u, 1085695589u, 0, NEXTAFTERF_TOLERANCE, 0},
{269, 1089260749u, 0u, 1089260748u, 0, NEXTAFTERF_TOLERANCE, 0},
{270, 1091672474u, 0u, 1091672473u, 0, NEXTAFTERF_TOLERANCE, 0},
{271, 1093455053u, 0u, 1093455052u, 0, NEXTAFTERF_TOLERANCE, 0},
{272, 1095237632u, 0u, 1095237631u, 0, NEXTAFTERF_TOLERANCE, 0},
{273, 1097020211u, 0u, 1097020210u, 0, NEXTAFTERF_TOLERANCE, 0},
{274, 1098802790u, 0u, 1098802789u, 0, NEXTAFTERF_TOLERANCE, 0},
{275, 1099746509u, 0u, 1099746508u, 0, NEXTAFTERF_TOLERANCE, 0},
{276, 1100637798u, 0u, 1100637797u, 0, NEXTAFTERF_TOLERANCE, 0},
{277, 1101529088u, 0u, 1101529087u, 0, NEXTAFTERF_TOLERANCE, 0},
{278, 1102420378u, 0u, 1102420377u, 0, NEXTAFTERF_TOLERANCE, 0},
{279, 1103311667u, 0u, 1103311666u, 0, NEXTAFTERF_TOLERANCE, 0},
{280, 1104202957u, 0u, 1104202956u, 0, NEXTAFTERF_TOLERANCE, 0},
{281, 1105094246u, 0u, 1105094245u, 0, NEXTAFTERF_TOLERANCE, 0},
{282, 1105985536u, 0u, 1105985535u, 0, NEXTAFTERF_TOLERANCE, 0},
{283, 1107800421u, 1203999711u, 1107800422u, 0, NEXTAFTERF_TOLERANCE, 0},
{284, 3196650934u, 896005582u, 3196650933u, 0, NEXTAFTERF_TOLERANCE, 0},
{285, 3368700125u, 3308232444u, 3368700124u, 0, NEXTAFTERF_TOLERANCE, 0},
{286, 1224242132u, 3061363425u, 1224242131u, 0, NEXTAFTERF_TOLERANCE, 0},
{287, 3221027117u, 1284201705u, 3221027116u, 0, NEXTAFTERF_TOLERANCE, 0},
{288, 1198712763u, 919636942u, 1198712762u, 0, NEXTAFTERF_TOLERANCE, 0},
{289, 3090780435u, 1035260608u, 3090780434u, 0, NEXTAFTERF_TOLERANCE, 0},
{290, 966554515u, 3234538174u, 966554514u, 0, NEXTAFTERF_TOLERANCE, 0},
{291, 1312607135u, 1194999402u, 1312607134u, 0, NEXTAFTERF_TOLERANCE, 0},
{292, 1166191415u, 1018661564u, 1166191414u, 0, NEXTAFTERF_TOLERANCE, 0},
{293, 3111900019u, 1130472166u, 3111900018u, 0, NEXTAFTERF_TOLERANCE, 0},
{294, 1302107128u, 3370647675u, 1302107127u, 0, NEXTAFTERF_TOLERANCE, 0},
{295, 1052801068u, 3039122570u, 1052801067u, 0, NEXTAFTERF_TOLERANCE, 0},
{296, 1060849628u, 3081357692u, 1060849627u, 0, NEXTAFTERF_TOLERANCE, 0},
{297, 3484320003u, 3033957825u, 3484320002u, 0, NEXTAFTERF_TOLERANCE, 0},
{298, 3181522772u, 3305392896u, 3181522773u, 0, NEXTAFTERF_TOLERANCE, 0},
{299, 882596369u, 1256676590u, 882596370u, 0, NEXTAFTERF_TOLERANCE, 0},
{300, 968192794u, 878547432u, 968192793u, 0, NEXTAFTERF_TOLERANCE, 0},
{301, 3122346862u, 1111584337u, 3122346861u, 0, NEXTAFTERF_TOLERANCE, 0},
{302, 1052361612u, 1280025214u, 1052361613u, 0, NEXTAFTERF_TOLERANCE, 0},
{303, 3471653172u, 1154138102u, 3471653171u, 0, NEXTAFTERF_TOLERANCE, 0},
{304, 3231467496u, 934336592u, 3231467495u, 0, NEXTAFTERF_TOLERANCE, 0},
{305, 1341514497u, 3466051188u, 1341514496u, 0, NEXTAFTERF_TOLERANCE, 0},
{306, 1272351391u, 3373485062u, 1272351390u, 0, NEXTAFTERF_TOLERANCE, 0},
{307, 3319724992u, 3354615790u, 3319724993u, 0, NEXTAFTERF_TOLERANCE, 0},
{308, 917622040u, 1334966485u, 917622041u, 0, NEXTAFTERF_TOLERANCE, 0},
{309, 940236348u, 3304072663u, 940236347u, 0, NEXTAFTERF_TOLERANCE, 0},
{310, 3251541546u, 3174764041u, 3251541545u, 0, NEXTAFTERF_TOLERANCE, 0},
{311, 3099843889u, 3355962282u, 3099843890u, 0, NEXTAFTERF_TOLERANCE, 0},
{312, 3371863479u, 1014861921u, 3371863478u, 0, NEXTAFTERF_TOLERANCE, 0},
{313, 3204069187u, 966573255u, 3204069186u, 0, NEXTAFTERF_TOLERANCE, 0},
{314, 1306460502u, 903489435u, 1306460501u, 0, NEXTAFTERF_TOLERANCE, 0},
{315, 1197542187u, 3024598921u, 1197542186u, 0, NEXTAFTERF_TOLERANCE, 0},
{316, 922888249u, 1139392309u, 922888250u, 0, NEXTAFTERF_TOLERANCE, 0},
{317, 1184239996u, 3224098462u, 1184239995u, 0, NEXTAFTERF_TOLERANCE, 0},
{318, 1252490238u, 1173619825u, 1252490237u, 0, NEXTAFTERF_TOLERANCE, 0},
{319, 1001673627u, 3462631271u, 1001673626u, 0, NEXTAFTERF_TOLERANCE, 0},
{320, 976098044u, 1151967422u, 976098045u, 0, NEXTAFTERF_TOLERANCE, 0},
{321, 941796645u, 886451963u, 941796644u, 0, NEXTAFTERF_TOLERANCE, 0},
{322, 893184329u, 1243067084u, 893184330u, 0, NEXTAFTERF_TOLERANCE, 0},
{323, 1143233714u, 1007268238u, 1143233713u, 0, NEXTAFTERF_TOLERANCE, 0},
{324, 1139941253u, 1147688821u, 1139941254u, 0, NEXTAFTERF_TOLERANCE, 0},
{325, 3143717025u, 3234638157u, 3143717026u, 0, NEXTAFTERF_TOLERANCE, 0},
{326, 3048866608u, 3449209899u, 3048866609u, 0, NEXTAFTERF_TOLERANCE, 0},
{327, 3240298487u, 1020260821u, 3240298486u, 0, NEXTAFTERF_TOLERANCE, 0},
{328, 1288902137u, 3123875978u, 1288902136u, 0, NEXTAFTERF_TOLERANCE, 0},
{329, 1333134799u, 1338107877u, 1333134800u, 0, NEXTAFTERF_TOLERANCE, 0},
{330, 1187847971u, 1317663644u, 1187847972u, 0, NEXTAFTERF_TOLERANCE, 0},
{331, 1038851706u, 1327544110u, 1038851707u, 0, NEXTAFTERF_TOLERANCE, 0},
{332, 3329354473u, 3165437289u, 3329354472u, 0, NEXTAFTERF_TOLERANCE, 0},
{333, 3077218579u, 1308397879u, 3077218578u, 0, NEXTAFTERF_TOLERANCE, 0},
{334, 1309289088u, 1019883016u, 1309289087u, 0, NEXTAFTERF_TOLERANCE, 0},
{335, 3444653659u, 1279248024u, 3444653658u, 0, NEXTAFTERF_TOLERANCE, 0},
{336, 1106778573u, 3304487767u, 1106778572u, 0, NEXTAFTERF_TOLERANCE, 0},
{337, 1140567947u, 3069174149u, 1140567946u, 0, NEXTAFTERF_TOLERANCE, 0},
{338, 1238569473u, 873035665u, 1238569472u, 0, NEXTAFTERF_TOLERANCE, 0},
{339, 3154871957u, 1276671061u, 3154871956u, 0, NEXTAFTERF_TOLERANCE, 0},
{340, 1261071232u, 1182202773u, 1261071231u, 0, NEXTAFTERF_TOLERANCE, 0},
{341, 1175011025u, 3029705783u, 1175011024u, 0, NEXTAFTERF_TOLERANCE, 0},
{342, 1082692850u, 1211581107u, 1082692851u, 0, NEXTAFTERF_TOLERANCE, 0},
{343, 974547519u, 3475164509u, 974547518u, 0, NEXTAFTERF_TOLERANCE, 0},
{344, 3058097085u, 3104309359u, 3058097086u, 0, NEXTAFTERF_TOLERANCE, 0},
{345, 3107252546u, 1071134451u, 3107252545u, 0, NEXTAFTERF_TOLERANCE, 0},
{346, 3197942144u, 3094120030u, 3197942143u, 0, NEXTAFTERF_TOLERANCE, 0},
{347, 3403348556u, 3184653669u, 3403348555u, 0, NEXTAFTERF_TOLERANCE, 0},
{348, 3182301130u, 3460764044u, 3182301131u, 0, NEXTAFTERF_TOLERANCE, 0},
{349, 1136411063u, 1118097422u, 1136411062u, 0, NEXTAFTERF_TOLERANCE, 0},
{350, 3239231622u, 3302723069u, 3239231623u, 0, NEXTAFTERF_TOLERANCE, 0},
{351, 3417964312u, 1321337529u, 3417964311u, 0, NEXTAFTERF_TOLERANCE, 0},
{352, 3109481038u, 1143864063u, 3109481037u, 0, NEXTAFTERF_TOLERANCE, 0},
{353, 1148867223u, 1256486202u, 1148867224u, 0, NEXTAFTERF_TOLERANCE, 0},
{354, 989687421u, 3372681320u, 989687420u, 0, NEXTAFTERF_TOLERANCE, 0},
{355, 1152956913u, 3166480640u, 1152956912u, 0, NEXTAFTERF_TOLERANCE, 0},
{356, 892922651u, 3373029087u, 892922650u, 0, NEXTAFTERF_TOLERANCE, 0},
{357, 1109627625u, 1314158257u, 1109627626u, 0, NEXTAFTERF_TOLERANCE, 0},
{358, 1307091856u, 1103202538u, 1307091855u, 0, NEXTAFTERF_TOLERANCE, 0},
{359, 1077234132u, 3272167130u, 1077234131u, 0, NEXTAFTERF_TOLERANCE, 0},
{360, 1142167709u, 1096445242u, 1142167708u, 0, NEXTAFTERF_TOLERANCE, 0},
{361, 3426232834u, 1036705270u, 3426232833u, 0, NEXTAFTERF_TOLERANCE, 0},
{362, 3368566779u, 967249167u, 3368566778u, 0, NEXTAFTERF_TOLERANCE, 0},
{363, 3030724760u, 3349013503u, 3030724761u, 0, NEXTAFTERF_TOLERANCE, 0},
{364, 1138741813u, 3073453199u, 1138741812u, 0, NEXTAFTERF_TOLERANCE, 0},
{365, 982950501u, 982549888u, 982950500u, 0, NEXTAFTERF_TOLERANCE, 0},
{366, 1142981585u, 1015602236u, 1142981584u, 0, NEXTAFTERF_TOLERANCE, 0},
{367, 3347165962u, 3135486696u, 3347165961u, 0, NEXTAFTERF_TOLERANCE, 0},
{368, 1009535440u, 3381353228u, 1009535439u, 0, NEXTAFTERF_TOLERANCE, 0},
{369, 3103736980u, 3402950505u, 3103736981u, 0, NEXTAFTERF_TOLERANCE, 0},
{370, 3126820946u, 1077903063u, 3126820945u, 0, NEXTAFTERF_TOLERANCE, 0},
{371, 3473956030u, 976891930u, 3473956029u, 0, NEXTAFTERF_TOLERANCE, 0},
{372, 3349098349u, 1055327704u, 3349098348u, 0, NEXTAFTERF_TOLERANCE, 0},
{373, 3152729489u, 1060398533u, 3152729488u, 0, NEXTAFTERF_TOLERANCE, 0},
{374, 945568720u, 3313485084u, 945568719u, 0, NEXTAFTERF_TOLERANCE, 0},
{375, 3345489836u, 1108392401u, 3345489835u, 0, NEXTAFTERF_TOLERANCE, 0},
{376, 940893161u, 1137000140u, 940893162u, 0, NEXTAFTERF_TOLERANCE, 0},
{377, 976791751u, 3230678102u, 976791750u, 0, NEXTAFTERF_TOLERANCE, 0},
{378, 1004442355u, 3036510596u, 1004442354u, 0, NEXTAFTERF_TOLERANCE, 0},
{379, 1108485380u, 3173536878u, 1108485379u, 0, NEXTAFTERF_TOLERANCE, 0},
{380, 1061834641u, 972388096u, 1061834640u, 0, NEXTAFTERF_TOLERANCE, 0},
{381, 3381268392u, 1146976802u, 3381268391u, 0, NEXTAFTERF_TOLERANCE, 0},
{382, 3212952285u, 3329407365u, 3212952286u, 0, NEXTAFTERF_TOLERANCE, 0},
{383, 3466188568u, 1041678304u, 3466188567u, 0, NEXTAFTERF_TOLERANCE, 0},
{384, 3072456205u, 3160254633u, 3072456206u, 0, NEXTAFTERF_TOLERANCE, 0},
{385, 3319315516u, 3422089012u, 3319315517u, 0, NEXTAFTERF_TOLERANCE, 0},
{386, 935938416u, 1146676692u, 935938417u, 0, NEXTAFTERF_TOLERANCE, 0},
{387, 3212614372u, 1152633030u, 3212614371u, 0, NEXTAFTERF_TOLERANCE, 0},
{388, 1315030230u, 3336225884u, 1315030229u, 0, NEXTAFTERF_TOLERANCE, 0},
{389, 1134593658u, 3456812581u, 1134593657u, 0, NEXTAFTERF_TOLERANCE, 0},
{390, 977281449u, 879922831u, 977281448u, 0, NEXTAFTERF_TOLERANCE, 0},
{391, 1086198791u, 920125958u, 1086198790u, 0, NEXTAFTERF_TOLERANCE, 0},
{392, 1135271264u, 3284878412u, 1135271263u, 0, NEXTAFTERF_TOLERANCE, 0},
{393, 1094190727u, 1056854532u, 1094190726u, 0, NEXTAFTERF_TOLERANCE, 0},
{394, 1294665325u, 991185677u, 1294665324u, 0, NEXTAFTERF_TOLERANCE, 0},
{395, 3439134022u, 1043829691u, 3439134021u, 0, NEXTAFTERF_TOLERANCE, 0},
{396, 3073083133u, 1317170485u, 3073083132u, 0, NEXTAFTERF_TOLERANCE, 0},
{397, 1325668223u, 970681762u, 1325668222u, 0, NEXTAFTERF_TOLERANCE, 0},
{398, 1092037607u, 1027330835u, 1092037606u, 0, NEXTAFTERF_TOLERANCE, 0},
{399, 3316278408u, 3455589207u, 3316278409u, 0, NEXTAFTERF_TOLERANCE, 0},
{400, 3295436768u, 3129873731u, 3295436767u, 0, NEXTAFTERF_TOLERANCE, 0},
{401, 1151984049u, 3074547120u, 1151984048u, 0, NEXTAFTERF_TOLERANCE, 0},
{402, 1129287043u, 3076527544u, 1129287042u, 0, NEXTAFTERF_TOLERANCE, 0},
{403, 1243664530u, 972879810u, 1243664529u, 0, NEXTAFTERF_TOLERANCE, 0},
{404, 950829092u, 929114193u, 950829091u, 0, NEXTAFTERF_TOLERANCE, 0},
{405, 1115471979u, 3047246262u, 1115471978u, 0, NEXTAFTERF_TOLERANCE, 0},
{406, 3351092088u, 3024661404u, 3351092087u, 0, NEXTAFTERF_TOLERANCE, 0},
{407, 3424479544u, 3312047722u, 3424479543u, 0, NEXTAFTERF_TOLERANCE, 0},
{408, 3241193975u, 884465785u, 3241193974u, 0, NEXTAFTERF_TOLERANCE, 0},
{409, 1030934236u, 1045139240u, 1030934237u, 0, NEXTAFTERF_TOLERANCE, 0},
{410, 3131791114u, 3408392958u, 3131791115u, 0, NEXTAFTERF_TOLERANCE, 0},
{411, 1025254314u, 3057812821u, 1025254313u, 0, NEXTAFTERF_TOLERANCE, 0},
{412, 1110545760u, 3240144177u, 1110545759u, 0, NEXTAFTERF_TOLERANCE, 0},
{413, 3180213739u, 1108793820u, 3180213738u, 0, NEXTAFTERF_TOLERANCE, 0},
{414, 3361976590u, 3138179993u, 3361976589u, 0, NEXTAFTERF_TOLERANCE, 0},
{415, 881280146u, 3421884736u, 881280145u, 0, NEXTAFTERF_TOLERANCE, 0},
{416, 3264443610u, 3222916705u, 3264443609u, 0, NEXTAFTERF_TOLERANCE, 0},
{417, 3374550627u, 3055856293u, 3374550626u, 0, NEXTAFTERF_TOLERANCE, 0},
{418, 899599265u, 3240118211u, 899599264u, 0, NEXTAFTERF_TOLERANCE, 0},
{419, 1268194719u, 1332489410u, 1268194720u, 0, NEXTAFTERF_TOLERANCE, 0},
{420, 1133420220u, 1245770860u, 1133420221u, 0, NEXTAFTERF_TOLERANCE, 0},
{421, 3184462258u, 1263529646u, 3184462257u, 0, NEXTAFTERF_TOLERANCE, 0},
{422, 3295996963u, 3453334307u, 3295996964u, 0, NEXTAFTERF_TOLERANCE, 0},
{423, 1270887389u, 1156123987u, 1270887388u, 0, NEXTAFTERF_TOLERANCE, 0},
{424, 3325193181u, 993979179u, 3325193180u, 0, NEXTAFTERF_TOLERANCE, 0},
{425, 925657343u, 1315159742u, 925657344u, 0, NEXTAFTERF_TOLERANCE, 0},
{426, 3116607482u, 3224327456u, 3116607483u, 0, NEXTAFTERF_TOLERANCE, 0},
{427, 3187892415u, 3118097315u, 3187892414u, 0, NEXTAFTERF_TOLERANCE, 0},
{428, 1189120494u, 978961471u, 1189120493u, 0, NEXTAFTERF_TOLERANCE, 0},
{429, 889030794u, 3129523970u, 889030793u, 0, NEXTAFTERF_TOLERANCE, 0},
{430, 1323529208u, 3100744786u, 1323529207u, 0, NEXTAFTERF_TOLERANCE, 0},
{431, 3465768388u, 3190881451u, 3465768387u, 0, NEXTAFTERF_TOLERANCE, 0},
{432, 3426099899u, 1118756120u, 3426099898u, 0, NEXTAFTERF_TOLERANCE, 0},
{433, 3224857113u, 3398166843u, 3224857114u, 0, NEXTAFTERF_TOLERANCE, 0},
{434, 3357819026u, 3148475462u, 3357819025u, 0, NEXTAFTERF_TOLERANCE, 0},
{435, 1273397670u, 901308750u, 1273397669u, 0, NEXTAFTERF_TOLERANCE, 0},
{436, 3424831780u, 1304806106u, 3424831779u, 0, NEXTAFTERF_TOLERANCE, 0},
{437, 1257596246u, 3420832544u, 1257596245u, 0, NEXTAFTERF_TOLERANCE, 0},
{438, 1051773536u, 896271348u, 1051773535u, 0, NEXTAFTERF_TOLERANCE, 0},
{439, 3294752507u, 3113225954u, 3294752506u, 0, NEXTAFTERF_TOLERANCE, 0},
{440, 1090870906u, 3294742905u, 1090870905u, 0, NEXTAFTERF_TOLERANCE, 0},
{441, 1227582289u, 1208979668u, 1227582288u, 0, NEXTAFTERF_TOLERANCE, 0},
{442, 1137854355u, 3335041917u, 1137854354u, 0, NEXTAFTERF_TOLERANCE, 0},
{443, 3440773058u, 3204192793u, 3440773057u, 0, NEXTAFTERF_TOLERANCE, 0},
{444, 3101598400u, 3057760708u, 3101598399u, 0, NEXTAFTERF_TOLERANCE, 0},
{445, 3451216836u, 3347783723u, 3451216835u, 0, NEXTAFTERF_TOLERANCE, 0},
{446, 3437062994u, 3106834845u, 3437062993u, 0, NEXTAFTERF_TOLERANCE, 0},
{447, 1131196082u, 1164573183u, 1131196083u, 0, NEXTAFTERF_TOLERANCE, 0},
{448, 3177294154u, 1282436638u, 3177294153u, 0, NEXTAFTERF_TOLERANCE, 0},
{449, 3258097678u, 1305882290u, 3258097677u, 0, NEXTAFTERF_TOLERANCE, 0},
{450, 3460915348u, 1219372260u, 3460915347u, 0, NEXTAFTERF_TOLERANCE, 0},
{451, 3303035472u, 3153013020u, 3303035471u, 0, NEXTAFTERF_TOLERANCE, 0},
{452, 1053698677u, 3284313107u, 1053698676u, 0, NEXTAFTERF_TOLERANCE, 0},
{453, 3396166221u, 1201894512u, 3396166220u, 0, NEXTAFTERF_TOLERANCE, 0},
{454, 3037541131u, 1085398440u, 3037541130u, 0, NEXTAFTERF_TOLERANCE, 0},
{455, 3458934263u, 1005577835u, 3458934262u, 0, NEXTAFTERF_TOLERANCE, 0},
{456, 1065761827u, 3333928591u, 1065761826u, 0, NEXTAFTERF_TOLERANCE, 0},
{457, 926665223u, 3150815797u, 926665222u, 0, NEXTAFTERF_TOLERANCE, 0},
{458, 1199816046u, 3143776186u, 1199816045u, 0, NEXTAFTERF_TOLERANCE, 0},
{459, 3333779015u, 952421041u, 3333779014u, 0, NEXTAFTERF_TOLERANCE, 0},
{460, 948398145u, 3238273189u, 948398144u, 0, NEXTAFTERF_TOLERANCE, 0},
{461, 3054021468u, 1270257895u, 3054021467u, 0, NEXTAFTERF_TOLERANCE, 0},
{462, 1080781593u, 1213908300u, 1080781594u, 0, NEXTAFTERF_TOLERANCE, 0},
{463, 3235326590u, 1271705594u, 3235326589u, 0, NEXTAFTERF_TOLERANCE, 0},
{464, 3118883815u, 1051802647u, 3118883814u, 0, NEXTAFTERF_TOLERANCE, 0},
{465, 965378004u, 1292594138u, 965378005u, 0, NEXTAFTERF_TOLERANCE, 0},
{466, 3226990408u, 1110755136u, 3226990407u, 0, NEXTAFTERF_TOLERANCE, 0},
{467, 3117098218u, 1122474770u, 3117098217u, 0, NEXTAFTERF_TOLERANCE, 0},
{468, 1283624229u, 906796922u, 1283624228u, 0, NEXTAFTERF_TOLERANCE, 0},
{469, 970649315u, 1078286437u, 970649316u, 0, NEXTAFTERF_TOLERANCE, 0},
{470, 959776291u, 3280345347u, 959776290u, 0, NEXTAFTERF_TOLERANCE, 0},
{471, 3341117305u, 3294559023u, 3341117304u, 0, NEXTAFTERF_TOLERANCE, 0},
{472, 1270734970u, 3355874874u, 1270734969u, 0, NEXTAFTERF_TOLERANCE, 0},
{473, 917206623u, 1172710814u, 917206624u, 0, NEXTAFTERF_TOLERANCE, 0},
{474, 1106502045u, 1290849316u, 1106502046u, 0, NEXTAFTERF_TOLERANCE, 0},
{475, 1157598381u, 3309023746u, 1157598380u, 0, NEXTAFTERF_TOLERANCE, 0},
{476, 3335234513u, 1002337336u, 3335234512u, 0, NEXTAFTERF_TOLERANCE, 0},
{477, 1279489061u, 1006049444u, 1279489060u, 0, NEXTAFTERF_TOLERANCE, 0},
{478, 3157416480u, 1309984610u, 3157416479u, 0, NEXTAFTERF_TOLERANCE, 0},
{479, 3143920719u, 3131608518u, 3143920718u, 0, NEXTAFTERF_TOLERANCE, 0},
{480, 1148920078u, 1007674793u, 1148920077u, 0, NEXTAFTERF_TOLERANCE, 0},
{481, 3064988156u, 3230867340u, 3064988157u, 0, NEXTAFTERF_TOLERANCE, 0},
{482, 3083619260u, 1159415661u, 3083619259u, 0, NEXTAFTERF_TOLERANCE, 0},
{483, 1109198803u, 1221754614u, 1109198804u, 0, NEXTAFTERF_TOLERANCE, 0},
{484, 3219949483u, 1056167693u, 3219949482u, 0, NEXTAFTERF_TOLERANCE, 0},
{485, 3361149474u, 3387342069u, 3361149475u, 0, NEXTAFTERF_TOLERANCE, 0},
{486, 1207502108u, 3388073586u, 1207502107u, 0, NEXTAFTERF_TOLERANCE, 0},
{487, 3161756316u, 3143659754u, 3161756315u, 0, NEXTAFTERF_TOLERANCE, 0},
{488, 3160728744u, 3382954009u, 3160728745u, 0, NEXTAFTERF_TOLERANCE, 0},
{489, 1234530539u, 1079988872u, 1234530538u, 0, NEXTAFTERF_TOLERANCE, 0},
{490, 1017843965u, 1193076204u, 1017843966u, 0, NEXTAFTERF_TOLERANCE, 0},
{491, 951862956u, 1173464654u, 951862957u, 0, NEXTAFTERF_TOLERANCE, 0},
{492, 3306328852u, 1118701064u, 3306328851u, 0, NEXTAFTERF_TOLERANCE, 0},
{493, 1291910469u, 1211303367u, 1291910468u, 0, NEXTAFTERF_TOLERANCE, 0},
{494, 3027442905u, 1173894400u, 3027442904u, 0, NEXTAFTERF_TOLERANCE, 0},
{495, 1131927531u, 3182962700u, 1131927530u, 0, NEXTAFTERF_TOLERANCE, 0},
{496, 3449879391u, 991614550u, 3449879390u, 0, NEXTAFTERF_TOLERANCE, 0},
{497, 970094304u, 3344590506u, 970094303u, 0, NEXTAFTERF_TOLERANCE, 0},
{498, 1125551064u, 3331248076u, 1125551063u, 0, NEXTAFTERF_TOLERANCE, 0},
{499, 3427296372u, 3455289118u, 3427296373u, 0, NEXTAFTERF_TOLERANCE, 0},
{500, 1198917460u, 1327195159u, 1198917461u, 0, NEXTAFTERF_TOLERANCE, 0},
{501, 3114686212u, 3476082461u, 3114686213u, 0, NEXTAFTERF_TOLERANCE, 0},
{502, 3393557778u, 3383396815u, 3393557777u, 0, NEXTAFTERF_TOLERANCE, 0},
{503, 1276853215u, 873199561u, 1276853214u, 0, NEXTAFTERF_TOLERANCE, 0},
{504, 3462778440u, 3349284325u, 3462778439u, 0, NEXTAFTERF_TOLERANCE, 0},
{505, 3360170117u, 3048354042u, 3360170116u, 0, NEXTAFTERF_TOLERANCE, 0},
{506, 3224245428u, 3271307999u, 3224245429u, 0, NEXTAFTERF_TOLERANCE, 0},
{507, 1120124467u, 1135619937u, 1120124468u, 0, NEXTAFTERF_TOLERANCE, 0},
{508, 1064364381u, 3180675544u, 1064364380u, 0, NEXTAFTERF_TOLERANCE, 0},
{509, 1268744779u, 3328452652u, 1268744778u, 0, NEXTAFTERF_TOLERANCE, 0},
{510, 1165195428u, 3390323168u, 1165195427u, 0, NEXTAFTERF_TOLERANCE, 0},
{511, 3044092739u, 1106497311u, 3044092738u, 0, NEXTAFTERF_TOLERANCE, 0},
{512, 3149469534u, 1278465842u, 3149469533u, 0, NEXTAFTERF_TOLERANCE, 0},
{513, 3247790039u, 909788142u, 3247790038u, 0, NEXTAFTERF_TOLERANCE, 0},
{514, 3215244648u, 1083988595u, 3215244647u, 0, NEXTAFTERF_TOLERANCE, 0},
{515, 3095275931u, 989153382u, 3095275930u, 0, NEXTAFTERF_TOLERANCE, 0},
{516, 3059688264u, 1117455718u, 3059688263u, 0, NEXTAFTERF_TOLERANCE, 0},
{517, 3275973009u, 3450721670u, 3275973010u, 0, NEXTAFTERF_TOLERANCE, 0},
{518, 3028857014u, 3188853813u, 3028857015u, 0, NEXTAFTERF_TOLERANCE, 0},
{519, 3391162308u, 1291220039u, 3391162307u, 0, NEXTAFTERF_TOLERANCE, 0},
{520, 1044867873u, 3369493273u, 1044867872u, 0, NEXTAFTERF_TOLERANCE, 0},
{521, 1089986803u, 3462160118u, 1089986802u, 0, NEXTAFTERF_TOLERANCE, 0},
{522, 1251462432u, 3171021770u, 1251462431u, 0, NEXTAFTERF_TOLERANCE, 0},
{523, 3485236902u, 980772835u, 3485236901u, 0, NEXTAFTERF_TOLERANCE, 0},
{524, 3262169538u, 1268270462u, 3262169537u, 0, NEXTAFTERF_TOLERANCE, 0},
{525, 3080852256u, 994641495u, 3080852255u, 0, NEXTAFTERF_TOLERANCE, 0},
{526, 1022211242u, 922124181u, 1022211241u, 0, NEXTAFTERF_TOLERANCE, 0},
{527, 3071422941u, 3271100396u, 3071422942u, 0, NEXTAFTERF_TOLERANCE, 0},
{528, 989762529u, 3362011135u, 989762528u, 0, NEXTAFTERF_TOLERANCE, 0},
{529, 1295475718u, 3212305413u, 1295475717u, 0, NEXTAFTERF_TOLERANCE, 0},
{530, 1002632518u, 3330388441u, 1002632517u, 0, NEXTAFTERF_TOLERANCE, 0},
{531, 3404372005u, 3450484255u, 3404372006u, 0, NEXTAFTERF_TOLERANCE, 0},
{532, 3158912530u, 3105501826u, 3158912529u, 0, NEXTAFTERF_TOLERANCE, 0},
{533, 1125800069u, 3256265749u, 1125800068u, 0, NEXTAFTERF_TOLERANCE, 0},
{534, 3138037576u, 3103365227u, 3138037575u, 0, NEXTAFTERF_TOLERANCE, 0},
{535, 3108384823u, 1300246663u, 3108384822u, 0, NEXTAFTERF_TOLERANCE, 0},
{536, 999985470u, 3409354318u, 999985469u, 0, NEXTAFTERF_TOLERANCE, 0},
{537, 1189421739u, 1056599002u, 1189421738u, 0, NEXTAFTERF_TOLERANCE, 0},
{538, 3075182644u, 3144159778u, 3075182645u, 0, NEXTAFTERF_TOLERANCE, 0},
{539, 3028099649u, 3391513557u, 3028099650u, 0, NEXTAFTERF_TOLERANCE, 0},
{540, 3132541814u, 3444521949u, 3132541815u, 0, NEXTAFTERF_TOLERANCE, 0},
{541, 1164046161u, 3440635788u, 1164046160u, 0, NEXTAFTERF_TOLERANCE, 0},
{542, 1292596266u, 3116569667u, 1292596265u, 0, NEXTAFTERF_TOLERANCE, 0},
{543, 3469748379u, 3412765608u, 3469748378u, 0, NEXTAFTERF_TOLERANCE, 0},
{544, 1314644642u, 3123051784u, 1314644641u, 0, NEXTAFTERF_TOLERANCE, 0},
{545, 948775569u, 3485444126u, 948775568u, 0, NEXTAFTERF_TOLERANCE, 0},
{546, 1034611395u, 882288581u, 1034611394u, 0, NEXTAFTERF_TOLERANCE, 0},
{547, 3489122735u, 3372450889u, 3489122734u, 0, NEXTAFTERF_TOLERANCE, 0},
{548, 1181604787u, 3363067409u, 1181604786u, 0, NEXTAFTERF_TOLERANCE, 0},
{549, 3059042077u, 3204983963u, 3059042078u, 0, NEXTAFTERF_TOLERANCE, 0},
{550, 1043691622u, 3402603223u, 1043691621u, 0, NEXTAFTERF_TOLERANCE, 0},
{551, 3157534378u, 3451674717u, 3157534379u, 0, NEXTAFTERF_TOLERANCE, 0},
{552, 3400949680u, 3073750220u, 3400949679u, 0, NEXTAFTERF_TOLERANCE, 0},
{553, 3365581801u, 1175843167u, 3365581800u, 0, NEXTAFTERF_TOLERANCE, 0},
{554, 3189917167u, 927278934u, 3189917166u, 0, NEXTAFTERF_TOLERANCE, 0},
{555, 969804941u, 3355439348u, 969804940u, 0, NEXTAFTERF_TOLERANCE, 0},
{556, 1139120919u, 3270515074u, 1139120918u, 0, NEXTAFTERF_TOLERANCE, 0},
{557, 934308144u, 3118191228u, 934308143u, 0, NEXTAFTERF_TOLERANCE, 0},
{558, 1220524226u, 1152648002u, 1220524225u, 0, NEXTAFTERF_TOLERANCE, 0},
{559, 3162548604u, 3461790298u, 3162548605u, 0, NEXTAFTERF_TOLERANCE, 0},
{560, 3382391700u, 3296962745u, 3382391699u, 0, NEXTAFTERF_TOLERANCE, 0},
{561, 1156767533u, 1088986462u, 1156767532u, 0, NEXTAFTERF_TOLERANCE, 0},
{562, 3079222483u, 3312324949u, 3079222484u, 0, NEXTAFTERF_TOLERANCE, 0},
{563, 994934087u, 967678094u, 994934086u, 0, NEXTAFTERF_TOLERANCE, 0},
{564, 3185240099u, 1123403720u, 3185240098u, 0, NEXTAFTERF_TOLERANCE, 0},
{565, 3479873563u, 1246277393u, 3479873562u, 0, NEXTAFTERF_TOLERANCE, 0},
{566, 3424264117u, 3434026174u, 3424264118u, 0, NEXTAFTERF_TOLERANCE, 0},
{567, 3228365887u, 1216775310u, 3228365886u, 0, NEXTAFTERF_TOLERANCE, 0},
{568, 1035909900u, 1249532942u, 1035909901u, 0, NEXTAFTERF_TOLERANCE, 0},
{569, 3024951184u, 1247632131u, 3024951183u, 0, NEXTAFTERF_TOLERANCE, 0},
{570, 3125775254u, 955826310u, 3125775253u, 0, NEXTAFTERF_TOLERANCE, 0},
{571, 1037464105u, 3121544932u, 1037464104u, 0, NEXTAFTERF_TOLERANCE, 0},
{572, 1311706596u, 1254918706u, 1311706595u, 0, NEXTAFTERF_TOLERANCE, 0},
{573, 918212457u, 1017468331u, 918212458u, 0, NEXTAFTERF_TOLERANCE, 0},
{574, 1337315179u, 3461361185u, 1337315178u, 0, NEXTAFTERF_TOLERANCE, 0},
{575, 1131358407u, 3325958870u, 1131358406u, 0, NEXTAFTERF_TOLERANCE, 0},
{576, 1156517523u, 3343716230u, 1156517522u, 0, NEXTAFTERF_TOLERANCE, 0},
{577, 3210802820u, 3207408574u, 3210802819u, 0, NEXTAFTERF_TOLERANCE, 0},
{578, 3337499209u, 1226297264u, 3337499208u, 0, NEXTAFTERF_TOLERANCE, 0},
{579, 3468429030u, 3253874001u, 3468429029u, 0, NEXTAFTERF_TOLERANCE, 0},
{580, 3253515800u, 1189005947u, 3253515799u, 0, NEXTAFTERF_TOLERANCE, 0},
{581, 3055299953u, 3047908678u, 3055299952u, 0, NEXTAFTERF_TOLERANCE, 0},
{582, 959956547u, 876324728u, 959956546u, 0, NEXTAFTERF_TOLERANCE, 0},
{583, 3425290480u, 1139193797u, 3425290479u, 0, NEXTAFTERF_TOLERANCE, 0},
{584, 1039917375u, 1122740999u, 1039917376u, 0, NEXTAFTERF_TOLERANCE, 0},
{585, 3220979495u, 3429223871u, 3220979496u, 0, NEXTAFTERF_TOLERANCE, 0},
{586, 1311016004u, 3334899880u, 1311016003u, 0, NEXTAFTERF_TOLERANCE, 0},
{587, 1128016396u, 1105151547u, 1128016395u, 0, NEXTAFTERF_TOLERANCE, 0},
{588, 3210335769u, 3100646155u, 3210335768u, 0, NEXTAFTERF_TOLERANCE, 0},
{589, 3022705759u, 3404762495u, 3022705760u, 0, NEXTAFTERF_TOLERANCE, 0},
{590, 3144504834u, 1162227076u, 3144504833u, 0, NEXTAFTERF_TOLERANCE, 0},
{591, 1213609983u, 919983950u, 1213609982u, 0, NEXTAFTERF_TOLERANCE, 0},
{592, 1246902946u, 3064047808u, 1246902945u, 0, NEXTAFTERF_TOLERANCE, 0},
{593, 995850843u, 1332031130u, 995850844u, 0, NEXTAFTERF_TOLERANCE, 0},
{594, 3362082828u, 3374056268u, 3362082829u, 0, NEXTAFTERF_TOLERANCE, 0},
{595, 1029480631u, 3047777170u, 1029480630u, 0, NEXTAFTERF_TOLERANCE, 0},
{596, 3153568584u, 3106514232u, 3153568583u, 0, NEXTAFTERF_TOLERANCE, 0},
{597, 3384988527u, 3109485565u, 3384988526u, 0, NEXTAFTERF_TOLERANCE, 0},
{598, 3235395924u, 1132055244u, 3235395923u, 0, NEXTAFTERF_TOLERANCE, 0},
{599, 1228636133u, 886552820u, 1228636132u, 0, NEXTAFTERF_TOLERANCE, 0},
{600, 3161654634u, 3335899347u, 3161654635u, 0, NEXTAFTERF_TOLERANCE, 0},
{601, 3162655243u, 3307203982u, 3162655244u, 0, NEXTAFTERF_TOLERANCE, 0},
{602, 1165476654u, 3350219111u, 1165476653u, 0, NEXTAFTERF_TOLERANCE, 0},
{603, 1017239798u, 3438501281u, 1017239797u, 0, NEXTAFTERF_TOLERANCE, 0},
{604, 1149651309u, 970030475u, 1149651308u, 0, NEXTAFTERF_TOLERANCE, 0},
{605, 1111943722u, 3122211334u, 1111943721u, 0, NEXTAFTERF_TOLERANCE, 0},
{606, 1189849849u, 3382739134u, 1189849848u, 0, NEXTAFTERF_TOLERANCE, 0},
{607, 3204848496u, 3141519085u, 3204848495u, 0, NEXTAFTERF_TOLERANCE, 0},
{608, 1249758327u, 3104759211u, 1249758326u, 0, NEXTAFTERF_TOLERANCE, 0},
{609, 3092982276u, 3445282331u, 3092982277u, 0, NEXTAFTERF_TOLERANCE, 0},
{610, 1168098747u, 1316854744u, 1168098748u, 0, NEXTAFTERF_TOLERANCE, 0},
{611, 892549317u, 1179637545u, 892549318u, 0, NEXTAFTERF_TOLERANCE, 0},
{612, 3301009024u, 3406174560u, 3301009025u, 0, NEXTAFTERF_TOLERANCE, 0},
{613, 3233089227u, 1212652543u, 3233089226u, 0, NEXTAFTERF_TOLERANCE, 0},
{614, 3218245284u, 1238873830u, 3218245283u, 0, NEXTAFTERF_TOLERANCE, 0},
{615, 3215981890u, 3240474694u, 3215981891u, 0, NEXTAFTERF_TOLERANCE, 0},
{616, 1266687209u, 3092038122u, 1266687208u, 0, NEXTAFTERF_TOLERANCE, 0},
{617, 3487959775u, 3331372071u, 3487959774u, 0, NEXTAFTERF_TOLERANCE, 0},
{618, 3345065699u, 3282620725u, 3345065698u, 0, NEXTAFTERF_TOLERANCE, 0},
{619, 935847271u, 1067255804u, 935847272u, 0, NEXTAFTERF_TOLERANCE, 0},
{620, 3410336089u, 1111437780u, 3410336088u, 0, NEXTAFTERF_TOLERANCE, 0},
{621, 3082940740u, 1336840432u, 3082940739u, 0, NEXTAFTERF_TOLERANCE, 0},
{622, 1141063391u, 1168908072u, 1141063392u, 0, NEXTAFTERF_TOLERANCE, 0},
{623, 3059263153u, 3067795684u, 3059263154u, 0, NEXTAFTERF_TOLERANCE, 0},
{624, 3353679791u, 897158391u, 3353679790u, 0, NEXTAFTERF_TOLERANCE, 0},
{625, 1001823878u, 1016826861u, 1001823879u, 0, NEXTAFTERF_TOLERANCE, 0},
{626, 1009130212u, 1004302940u, 1009130211u, 0, NEXTAFTERF_TOLERANCE, 0},
{627, 3367127535u, 943136342u, 3367127534u, 0, NEXTAFTERF_TOLERANCE, 0},
{628, 1032920919u, 3449126417u, 1032920918u, 0, NEXTAFTERF_TOLERANCE, 0},
{629, 3281952870u, 3147012185u, 3281952869u, 0, NEXTAFTERF_TOLERANCE, 0},
{630, 1237868497u, 3048281802u, 1237868496u, 0, NEXTAFTERF_TOLERANCE, 0},
{631, 1153753924u, 3322269242u, 1153753923u, 0, NEXTAFTERF_TOLERANCE, 0},
{632, 1120261759u, 892210998u, 1120261758u, 0, NEXTAFTERF_TOLERANCE, 0},
{633, 3226328360u, 3366432856u, 3226328361u, 0, NEXTAFTERF_TOLERANCE, 0},
{634, 3349595986u, 3251588707u, 3349595985u, 0, NEXTAFTERF_TOLERANCE, 0},
{635, 3166889490u, 3306023523u, 3166889491u, 0, NEXTAFTERF_TOLERANCE, 0},
{636, 1087750238u, 1099325523u, 1087750239u, 0, NEXTAFTERF_TOLERANCE, 0},
{637, 3121620061u, 3359488363u, 3121620062u, 0, NEXTAFTERF_TOLERANCE, 0},
{638, 1066116543u, 3072159933u, 1066116542u, 0, NEXTAFTERF_TOLERANCE, 0},
{639, 3051923237u, 3364074347u, 3051923238u, 0, NEXTAFTERF_TOLERANCE, 0},
{640, 1030612298u, 3345396001u, 1030612297u, 0, NEXTAFTERF_TOLERANCE, 0},
{641, 1331680743u, 1009396165u, 1331680742u, 0, NEXTAFTERF_TOLERANCE, 0},
{642, 3060774997u, 1326067357u, 3060774996u, 0, NEXTAFTERF_TOLERANCE, 0},
{643, 887589411u, 1292305693u, 887589412u, 0, NEXTAFTERF_TOLERANCE, 0},
{644, 1045232522u, 3234993273u, 1045232521u, 0, NEXTAFTERF_TOLERANCE, 0},
{645, 3119858470u, 962515365u, 3119858469u, 0, NEXTAFTERF_TOLERANCE, 0},
{646, 3349432725u, 928848003u, 3349432724u, 0, NEXTAFTERF_TOLERANCE, 0},
{647, 912423027u, 3184646319u, 912423026u, 0, NEXTAFTERF_TOLERANCE, 0},
{648, 3228795133u, 3273940030u, 3228795134u, 0, NEXTAFTERF_TOLERANCE, 0},
{649, 3194674746u, 3112269709u, 3194674745u, 0, NEXTAFTERF_TOLERANCE, 0},
{650, 3296784303u, 3276182352u, 3296784302u, 0, NEXTAFTERF_TOLERANCE, 0},
{651, 965402291u, 3107104376u, 965402290u, 0, NEXTAFTERF_TOLERANCE, 0},
{652, 3388153589u, 3426245389u, 3388153590u, 0, NEXTAFTERF_TOLERANCE, 0},
{653, 1133410485u, 3329658993u, 1133410484u, 0, NEXTAFTERF_TOLERANCE, 0},
{654, 3136790322u, 1088652637u, 3136790321u, 0, NEXTAFTERF_TOLERANCE, 0},
{655, 3369970587u, 959121458u, 3369970586u, 0, NEXTAFTERF_TOLERANCE, 0},
{656, 1270451568u, 928393353u, 1270451567u, 0, NEXTAFTERF_TOLERANCE, 0},
{657, 989498922u, 3088358419u, 989498921u, 0, NEXTAFTERF_TOLERANCE, 0},
{658, 1280215674u, 3148135875u, 1280215673u, 0, NEXTAFTERF_TOLERANCE, 0},
{659, 1171873518u, 954709738u, 1171873517u, 0, NEXTAFTERF_TOLERANCE, 0},
{660, 3298258100u, 935525182u, 3298258099u, 0, NEXTAFTERF_TOLERANCE, 0},
{661, 1001897182u, 3191875320u, 1001897181u, 0, NEXTAFTERF_TOLERANCE, 0},
{662, 3152777939u, 3245830463u, 3152777940u, 0, NEXTAFTERF_TOLERANCE, 0},
{663, 985903305u, 3333087577u, 985903304u, 0, NEXTAFTERF_TOLERANCE, 0},
{664, 982612185u, 923582663u, 982612184u, 0, NEXTAFTERF_TOLERANCE, 0},
{665, 3267868136u, 1208301947u, 3267868135u, 0, NEXTAFTERF_TOLERANCE, 0},
{666, 3319048157u, 1172271145u, 3319048156u, 0, NEXTAFTERF_TOLERANCE, 0},
{667, 3301461672u, 1233693827u, 3301461671u, 0, NEXTAFTERF_TOLERANCE, 0},
{668, 3364525678u, 3089849671u, 3364525677u, 0, NEXTAFTERF_TOLERANCE, 0},
{669, 931441127u, 1133424555u, 931441128u, 0, NEXTAFTERF_TOLERANCE, 0},
{670, 3146660041u, 3143695961u, 3146660040u, 0, NEXTAFTERF_TOLERANCE, 0},
{671, 3467121799u, 3023584354u, 3467121798u, 0, NEXTAFTERF_TOLERANCE, 0},
{672, 1151257041u, 3084216427u, 1151257040u, 0, NEXTAFTERF_TOLERANCE, 0},
{673, 3097873255u, 3219266640u, 3097873256u, 0, NEXTAFTERF_TOLERANCE, 0},
{674, 3130670309u, 3192399254u, 3130670310u, 0, NEXTAFTERF_TOLERANCE, 0},
{675, 1017573824u, 3130901062u, 1017573823u, 0, NEXTAFTERF_TOLERANCE, 0},
{676, 1258369714u, 3462258576u, 1258369713u, 0, NEXTAFTERF_TOLERANCE, 0},
{677, 1216602683u, 3371396332u, 1216602682u, 0, NEXTAFTERF_TOLERANCE, 0},
{678, 3297265739u, 1214184410u, 3297265738u, 0, NEXTAFTERF_TOLERANCE, 0},
{679, 1071940738u, 3311731012u, 1071940737u, 0, NEXTAFTERF_TOLERANCE, 0},
{680, 922601356u, 3337171870u, 922601355u, 0, NEXTAFTERF_TOLERANCE, 0},
{681, 3462285635u, 3444030332u, 3462285634u, 0, NEXTAFTERF_TOLERANCE, 0},
{682, 3357177805u, 1085464241u, 3357177804u, 0, NEXTAFTERF_TOLERANCE, 0},
{683, 3049120080u, 900832851u, 3049120079u, 0, NEXTAFTERF_TOLERANCE, 0},
{684, 1153863660u, 1011991342u, 1153863659u, 0, NEXTAFTERF_TOLERANCE, 0},
{685, 3034243695u, 917098003u, 3034243694u, 0, NEXTAFTERF_TOLERANCE, 0},
{686, 1249365132u, 3278686216u, 1249365131u, 0, NEXTAFTERF_TOLERANCE, 0},
{687, 3046215730u, 3211219980u, 3046215731u, 0, NEXTAFTERF_TOLERANCE, 0},
{688, 3047251716u, 1090787353u, 3047251715u, 0, NEXTAFTERF_TOLERANCE, 0},
{689, 3131219358u, 3471261157u, 3131219359u, 0, NEXTAFTERF_TOLERANCE, 0},
{690, 3222096285u, 1198013705u, 3222096284u, 0, NEXTAFTERF_TOLERANCE, 0},
{691, 1297708818u, 3079166173u, 1297708817u, 0, NEXTAFTERF_TOLERANCE, 0},
{692, 3345532722u, 3383708463u, 3345532723u, 0, NEXTAFTERF_TOLERANCE, 0},
{693, 3418753236u, 3481843070u, 3418753237u, 0, NEXTAFTERF_TOLERANCE, 0},
{694, 1277417964u, 3487506626u, 1277417963u, 0, NEXTAFTERF_TOLERANCE, 0},
{695, 987577257u, 1152077087u, 987577258u, 0, NEXTAFTERF_TOLERANCE, 0},
{696, 3161606610u, 3190282989u, 3161606611u, 0, NEXTAFTERF_TOLERANCE, 0},
{697, 888030585u, 3062367380u, 888030584u, 0, NEXTAFTERF_TOLERANCE, 0},
{698, 1043442869u, 3311393817u, 1043442868u, 0, NEXTAFTERF_TOLERANCE, 0},
{699, 3320923228u, 3464544249u, 3320923229u, 0, NEXTAFTERF_TOLERANCE, 0},
{700, 1337400405u, 3488844154u, 1337400404u, 0, NEXTAFTERF_TOLERANCE, 0},
{701, 3400348640u, 3129868490u, 3400348639u, 0, NEXTAFTERF_TOLERANCE, 0},
{702, 1250249095u, 1069023744u, 1250249094u, 0, NEXTAFTERF_TOLERANCE, 0},
{703, 3284411233u, 1173613526u, 3284411232u, 0, NEXTAFTERF_TOLERANCE, 0},
{704, 1215968622u, 3469884568u, 1215968621u, 0, NEXTAFTERF_TOLERANCE, 0},
{705, 3061638260u, 3116222327u, 3061638261u, 0, NEXTAFTERF_TOLERANCE, 0},
{706, 1025404104u, 1066370251u, 1025404105u, 0, NEXTAFTERF_TOLERANCE, 0},
{707, 3138086437u, 3195983510u, 3138086438u, 0, NEXTAFTERF_TOLERANCE, 0},
{708, 3091024506u, 3456196859u, 3091024507u, 0, NEXTAFTERF_TOLERANCE, 0},
{709, 3362748242u, 3369843597u, 3362748243u, 0, NEXTAFTERF_TOLERANCE, 0},
{710, 3099671635u, 3218383623u, 3099671636u, 0, NEXTAFTERF_TOLERANCE, 0},
{711, 1252237719u, 1121169249u, 1252237718u, 0, NEXTAFTERF_TOLERANCE, 0},
{712, 3327895594u, 1224511805u, 3327895593u, 0, NEXTAFTERF_TOLERANCE, 0},
{713, 3082454432u, 889268276u, 3082454431u, 0, NEXTAFTERF_TOLERANCE, 0},
{714, 3396161504u, 1182798837u, 3396161503u, 0, NEXTAFTERF_TOLERANCE, 0},
{715, 1099710167u, 887180181u, 1099710166u, 0, NEXTAFTERF_TOLERANCE, 0},
{716, 1157186482u, 1288722647u, 1157186483u, 0, NEXTAFTERF_TOLERANCE, 0},
{717, 1282110851u, 3176633124u, 1282110850u, 0, NEXTAFTERF_TOLERANCE, 0},
{718, 3477008113u, 1331845018u, 3477008112u, 0, NEXTAFTERF_TOLERANCE, 0},
{719, 3292127294u, 3409957764u, 3292127295u, 0, NEXTAFTERF_TOLERANCE, 0},
{720, 1123357102u, 3281307320u, 1123357101u, 0, NEXTAFTERF_TOLERANCE, 0},
{721, 1106837025u, 3088080674u, 1106837024u, 0, NEXTAFTERF_TOLERANCE, 0},
{722, 1049949008u, 1130799489u, 1049949009u, 0, NEXTAFTERF_TOLERANCE, 0},
{723, 1253017688u, 942062372u, 1253017687u, 0, NEXTAFTERF_TOLERANCE, 0},
{724, 1108543194u, 3281299199u, 1108543193u, 0, NEXTAFTERF_TOLERANCE, 0},
{725, 3087985411u, 1238341456u, 3087985410u, 0, NEXTAFTERF_TOLERANCE, 0},
{726, 3163283126u, 1328636961u, 3163283125u, 0, NEXTAFTERF_TOLERANCE, 0},
{727, 1160162706u, 1264067367u, 1160162707u, 0, NEXTAFTERF_TOLERANCE, 0},
{728, 3025340297u, 1193925540u, 3025340296u, 0, NEXTAFTERF_TOLERANCE, 0},
{729, 3438080027u, 3107114149u, 3438080026u, 0, NEXTAFTERF_TOLERANCE, 0},
{730, 3344574751u, 3111270744u, 3344574750u, 0, NEXTAFTERF_TOLERANCE, 0},
{731, 1152416724u, 962669179u, 1152416723u, 0, NEXTAFTERF_TOLERANCE, 0},
{732, 1218239308u, 1126238113u, 1218239307u, 0, NEXTAFTERF_TOLERANCE, 0},
{733, 3263310567u, 1030748197u, 3263310566u, 0, NEXTAFTERF_TOLERANCE, 0},
{734, 3041998669u, 1160635263u, 3041998668u, 0, NEXTAFTERF_TOLERANCE, 0},
{735, 972485427u, 1124312043u, 972485428u, 0, NEXTAFTERF_TOLERANCE, 0},
{736, 3290264612u, 1124703898u, 3290264611u, 0, NEXTAFTERF_TOLERANCE, 0},
{737, 3222106584u, 1183748648u, 3222106583u, 0, NEXTAFTERF_TOLERANCE, 0},
{738, 947914771u, 3181847068u, 947914770u, 0, NEXTAFTERF_TOLERANCE, 0},
{739, 3167730654u, 3195765940u, 3167730655u, 0, NEXTAFTERF_TOLERANCE, 0},
{740, 1098530298u, 3255870890u, 1098530297u, 0, NEXTAFTERF_TOLERANCE, 0},
{741, 1277649137u, 961171401u, 1277649136u, 0, NEXTAFTERF_TOLERANCE, 0},
{742, 3203377685u, 1306427476u, 3203377684u, 0, NEXTAFTERF_TOLERANCE, 0},
{743, 3090306474u, 3124785016u, 3090306475u, 0, NEXTAFTERF_TOLERANCE, 0},
{744, 3244032016u, 3045313345u, 3244032015u, 0, NEXTAFTERF_TOLERANCE, 0},
{745, 3033122376u, 3049877065u, 3033122377u, 0, NEXTAFTERF_TOLERANCE, 0},
{746, 1096155623u, 1256423752u, 1096155624u, 0, NEXTAFTERF_TOLERANCE, 0},
{747, 873151908u, 3246562559u, 873151907u, 0, NEXTAFTERF_TOLERANCE, 0},
{748, 3238729605u, 1298769842u, 3238729604u, 0, NEXTAFTERF_TOLERANCE, 0},
{749, 3317196817u, 989537151u, 3317196816u, 0, NEXTAFTERF_TOLERANCE, 0},
{750, 3345634950u, 959901149u, 3345634949u, 0, NEXTAFTERF_TOLERANCE, 0},
{751, 3189860276u, 883598767u, 3189860275u, 0, NEXTAFTERF_TOLERANCE, 0},
{752, 887311687u, 1175312255u, 887311688u, 0, NEXTAFTERF_TOLERANCE, 0},
{753, 3396917283u, 3066326686u, 3396917282u, 0, NEXTAFTERF_TOLERANCE, 0},
{754, 3317032737u, 3143803722u, 3317032736u, 0, NEXTAFTERF_TOLERANCE, 0},
{755, 1200051436u, 1163802508u, 1200051435u, 0, NEXTAFTERF_TOLERANCE, 0},
{756, 3105291012u, 1194385202u, 3105291011u, 0, NEXTAFTERF_TOLERANCE, 0},
{757, 1306520561u, 957302464u, 1306520560u, 0, NEXTAFTERF_TOLERANCE, 0},
{758, 3475052219u, 1284049853u, 3475052218u, 0, NEXTAFTERF_TOLERANCE, 0},
{759, 3085636260u, 1107682820u, 3085636259u, 0, NEXTAFTERF_TOLERANCE, 0},
{760, 3393227708u, 3271879112u, 3393227707u, 0, NEXTAFTERF_TOLERANCE, 0},
{761, 3349005404u, 3080993030u, 3349005403u, 0, NEXTAFTERF_TOLERANCE, 0},
{762, 3154720153u, 3443720494u, 3154720154u, 0, NEXTAFTERF_TOLERANCE, 0},
{763, 1262863321u, 1219003129u, 1262863320u, 0, NEXTAFTERF_TOLERANCE, 0},
{764, 882902102u, 1224362550u, 882902103u, 0, NEXTAFTERF_TOLERANCE, 0},
{765, 1053387478u, 3184880021u, 1053387477u, 0, NEXTAFTERF_TOLERANCE, 0},
{766, 3387653691u, 3347783852u, 3387653690u, 0, NEXTAFTERF_TOLERANCE, 0},
{767, 3136364836u, 1018492227u, 3136364835u, 0, NEXTAFTERF_TOLERANCE, 0},
{768, 1338680611u, 1166078045u, 1338680610u, 0, NEXTAFTERF_TOLERANCE, 0},
{769, 1112891928u, 3074730425u, 1112891927u, 0, NEXTAFTERF_TOLERANCE, 0},
{770, 893449284u, 1052877339u, 893449285u, 0, NEXTAFTERF_TOLERANCE, 0},
{771, 892311459u, 1097338393u, 892311460u, 0, NEXTAFTERF_TOLERANCE, 0},
{772, 3105373037u, 3246705916u, 3105373038u, 0, NEXTAFTERF_TOLERANCE, 0},
{773, 1190105283u, 3033907262u, 1190105282u, 0, NEXTAFTERF_TOLERANCE, 0},
{774, 1011225926u, 1180485180u, 1011225927u, 0, NEXTAFTERF_TOLERANCE, 0},
{775, 1043025031u, 987068973u, 1043025030u, 0, NEXTAFTERF_TOLERANCE, 0},
{776, 3125834184u, 896953754u, 3125834183u, 0, NEXTAFTERF_TOLERANCE, 0},
{777, 1120888322u, 1086209113u, 1120888321u, 0, NEXTAFTERF_TOLERANCE, 0},
{778, 1315217243u, 3396371713u, 1315217242u, 0, NEXTAFTERF_TOLERANCE, 0},
{779, 3137758475u, 1039403054u, 3137758474u, 0, NEXTAFTERF_TOLERANCE, 0},
{780, 1040617590u, 1034835971u, 1040617589u, 0, NEXTAFTERF_TOLERANCE, 0},
{781, 955384253u, 3344785562u, 955384252u, 0, NEXTAFTERF_TOLERANCE, 0},
{782, 3061417900u, 1172208065u, 3061417899u, 0, NEXTAFTERF_TOLERANCE, 0},
{783, 904255535u, 1019967545u, 904255536u, 0, NEXTAFTERF_TOLERANCE, 0},
{784, 1022984119u, 3113891410u, 1022984118u, 0, NEXTAFTERF_TOLERANCE, 0},
{785, 997362368u, 3112875428u, 997362367u, 0, NEXTAFTERF_TOLERANCE, 0},
{786, 900933520u, 1100589187u, 900933521u, 0, NEXTAFTERF_TOLERANCE, 0},
{787, 1168623062u, 1143306482u, 1168623061u, 0, NEXTAFTERF_TOLERANCE, 0},
{788, 878737490u, 3269908326u, 878737489u, 0, NEXTAFTERF_TOLERANCE, 0},
{789, 1039827284u, 1072928888u, 1039827285u, 0, NEXTAFTERF_TOLERANCE, 0},
{790, 1021564080u, 1064468397u, 1021564081u, 0, NEXTAFTERF_TOLERANCE, 0},
{791, 3458669745u, 3033299853u, 3458669744u, 0, NEXTAFTERF_TOLERANCE, 0},
{792, 3327516316u, 3405380971u, 3327516317u, 0, NEXTAFTERF_TOLERANCE, 0},
{793, 1040711112u, 3229444200u, 1040711111u, 0, NEXTAFTERF_TOLERANCE, 0},
{794, 1134528351u, 3365952513u, 1134528350u, 0, NEXTAFTERF_TOLERANCE, 0},
{795, 3039884464u, 1170612785u, 3039884463u, 0, NEXTAFTERF_TOLERANCE, 0},
{796, 3414352838u, 3350285760u, 3414352837u, 0, NEXTAFTERF_TOLERANCE, 0},
{797, 1133689539u, 1067460093u, 1133689538u, 0, NEXTAFTERF_TOLERANCE, 0},
{798, 3455688478u, 3333091960u, 3455688477u, 0, NEXTAFTERF_TOLERANCE, 0},
{799, 1137634874u, 1137038869u, 1137634873u, 0, NEXTAFTERF_TOLERANCE, 0},
{800, 3415502662u, 955510692u, 3415502661u, 0, NEXTAFTERF_TOLERANCE, 0},
{801, 954999730u, 969618597u, 954999731u, 0, NEXTAFTERF_TOLERANCE, 0},
{802, 1066157309u, 3241712664u, 1066157308u, 0, NEXTAFTERF_TOLERANCE, 0},
{803, 3436353675u, 1174967495u, 3436353674u, 0, NEXTAFTERF_TOLERANCE, 0},
{804, 3108347547u, 3434003435u, 3108347548u, 0, NEXTAFTERF_TOLERANCE, 0},
{805, 3064200154u, 3158080507u, 3064200155u, 0, NEXTAFTERF_TOLERANCE, 0},
{806, 3272661536u, 3461799138u, 3272661537u, 0, NEXTAFTERF_TOLERANCE, 0},
{807, 1170245333u, 1233406410u, 1170245334u, 0, NEXTAFTERF_TOLERANCE, 0},
{808, 1219052056u, 3369557946u, 1219052055u, 0, NEXTAFTERF_TOLERANCE, 0},
{809, 3318983619u, 3259663338u, 3318983618u, 0, NEXTAFTERF_TOLERANCE, 0},
{810, 3146190320u, 889646054u, 3146190319u, 0, NEXTAFTERF_TOLERANCE, 0},
{811, 1299683827u, 966031619u, 1299683826u, 0, NEXTAFTERF_TOLERANCE, 0},
{812, 3190796331u, 1320011850u, 3190796330u, 0, NEXTAFTERF_TOLERANCE, 0},
{813, 3086068902u, 3484245751u, 3086068903u, 0, NEXTAFTERF_TOLERANCE, 0},
{814, 3064155399u, 3176569312u, 3064155400u, 0, NEXTAFTERF_TOLERANCE, 0},
{815, 3040314717u, 1071290674u, 3040314716u, 0, NEXTAFTERF_TOLERANCE, 0},
{816, 3257224022u, 3361778245u, 3257224023u, 0, NEXTAFTERF_TOLERANCE, 0},
{817, 1229268598u, 1066965677u, 1229268597u, 0, NEXTAFTERF_TOLERANCE, 0},
{818, 1086717248u, 3423795374u, 1086717247u, 0, NEXTAFTERF_TOLERANCE, 0},
{819, 3434884607u, 3029593823u, 3434884606u, 0, NEXTAFTERF_TOLERANCE, 0},
{820, 3464955606u, 1017987696u, 3464955605u, 0, NEXTAFTERF_TOLERANCE, 0},
{821, 1025278524u, 3121856207u, 1025278523u, 0, NEXTAFTERF_TOLERANCE, 0},
{822, 1242829722u, 3233935671u, 1242829721u, 0, NEXTAFTERF_TOLERANCE, 0},
{823, 3075149137u, 1117325737u, 3075149136u, 0, NEXTAFTERF_TOLERANCE, 0},
{824, 1200927971u, 1317167489u, 1200927972u, 0, NEXTAFTERF_TOLERANCE, 0},
{825, 3326858092u, 3452602832u, 3326858093u, 0, NEXTAFTERF_TOLERANCE, 0},
{826, 3184801644u, 1137974313u, 3184801643u, 0, NEXTAFTERF_TOLERANCE, 0},
{827, 1136052740u, 3244616020u, 1136052739u, 0, NEXTAFTERF_TOLERANCE, 0},
{828, 1015670780u, 1101217251u, 1015670781u, 0, NEXTAFTERF_TOLERANCE, 0},
{829, 1012543234u, 1116520440u, 1012543235u, 0, NEXTAFTERF_TOLERANCE, 0},
{830, 3316611992u, 3394732912u, 3316611993u, 0, NEXTAFTERF_TOLERANCE, 0},
{831, 1087942795u, 3316660295u, 1087942794u, 0, NEXTAFTERF_TOLERANCE, 0},
{832, 3426365713u, 3069778532u, 3426365712u, 0, NEXTAFTERF_TOLERANCE, 0},
{833, 3066654389u, 3443934204u, 3066654390u, 0, NEXTAFTERF_TOLERANCE, 0},
{834, 3295326432u, 1313396175u, 3295326431u, 0, NEXTAFTERF_TOLERANCE, 0},
{835, 3318835308u, 3277583511u, 3318835307u, 0, NEXTAFTERF_TOLERANCE, 0},
{836, 3283555717u, 891875120u, 3283555716u, 0, NEXTAFTERF_TOLERANCE, 0},
{837, 3040485181u, 3375450886u, 3040485182u, 0, NEXTAFTERF_TOLERANCE, 0},
{838, 3388772093u, 1032597076u, 3388772092u, 0, NEXTAFTERF_TOLERANCE, 0},
{839, 954670189u, 1144923689u, 954670190u, 0, NEXTAFTERF_TOLERANCE, 0},
{840, 1319200415u, 3387555900u, 1319200414u, 0, NEXTAFTERF_TOLERANCE, 0},
{841, 1279324488u, 3228401212u, 1279324487u, 0, NEXTAFTERF_TOLERANCE, 0},
{842, 3455131757u, 1260217257u, 3455131756u, 0, NEXTAFTERF_TOLERANCE, 0},
{843, 1246947517u, 1087951909u, 1246947516u, 0, NEXTAFTERF_TOLERANCE, 0},
{844, 3433761025u, 3060143904u, 3433761024u, 0, NEXTAFTERF_TOLERANCE, 0},
{845, 3201187455u, 900233172u, 3201187454u, 0, NEXTAFTERF_TOLERANCE, 0},
{846, 1173247961u, 1191127979u, 1173247962u, 0, NEXTAFTERF_TOLERANCE, 0},
{847, 3037297123u, 3346394818u, 3037297124u, 0, NEXTAFTERF_TOLERANCE, 0},
{848, 3248534678u, 1323683800u, 3248534677u, 0, NEXTAFTERF_TOLERANCE, 0},
{849, 3083019343u, 3033309444u, 3083019342u, 0, NEXTAFTERF_TOLERANCE, 0},
{850, 3042018375u, 3203882372u, 3042018376u, 0, NEXTAFTERF_TOLERANCE, 0},
{851, 1082862511u, 3032804719u, 1082862510u, 0, NEXTAFTERF_TOLERANCE, 0},
{852, 3157626955u, 3483653298u, 3157626956u, 0, NEXTAFTERF_TOLERANCE, 0},
{853, 881101379u, 1190838126u, 881101380u, 0, NEXTAFTERF_TOLERANCE, 0},
{854, 3182695954u, 3256861672u, 3182695955u, 0, NEXTAFTERF_TOLERANCE, 0},
{855, 1105291533u, 3482971524u, 1105291532u, 0, NEXTAFTERF_TOLERANCE, 0},
{856, 1016023520u, 3227712090u, 1016023519u, 0, NEXTAFTERF_TOLERANCE, 0},
{857, 3370691006u, 1295870514u, 3370691005u, 0, NEXTAFTERF_TOLERANCE, 0},
{858, 1156767169u, 1049756240u, 1156767168u, 0, NEXTAFTERF_TOLERANCE, 0},
{859, 3077020499u, 894671462u, 3077020498u, 0, NEXTAFTERF_TOLERANCE, 0},
{860, 1104284039u, 3040211914u, 1104284038u, 0, NEXTAFTERF_TOLERANCE, 0},
{861, 3335212901u, 3486414589u, 3335212902u, 0, NEXTAFTERF_TOLERANCE, 0},
{862, 1093697541u, 3193708441u, 1093697540u, 0, NEXTAFTERF_TOLERANCE, 0},
{863, 3266691185u, 1160074593u, 3266691184u, 0, NEXTAFTERF_TOLERANCE, 0},
{864, 3179003144u, 1108615803u, 3179003143u, 0, NEXTAFTERF_TOLERANCE, 0},
{865, 3424086808u, 3260140004u, 3424086807u, 0, NEXTAFTERF_TOLERANCE, 0},
{866, 3353608773u, 1134068114u, 3353608772u, 0, NEXTAFTERF_TOLERANCE, 0},
{867, 973664327u, 1319516167u, 973664328u, 0, NEXTAFTERF_TOLERANCE, 0},
{868, 882878091u, 3136970767u, 882878090u, 0, NEXTAFTERF_TOLERANCE, 0},
{869, 927582555u, 947955456u, 927582556u, 0, NEXTAFTERF_TOLERANCE, 0},
{870, 3111440310u, 3067634077u, 3111440309u, 0, NEXTAFTERF_TOLERANCE, 0},
{871, 3476083859u, 966439623u, 3476083858u, 0, NEXTAFTERF_TOLERANCE, 0},
{872, 3038754840u, 932009686u, 3038754839u, 0, NEXTAFTERF_TOLERANCE, 0},
{873, 979878744u, 1232482646u, 979878745u, 0, NEXTAFTERF_TOLERANCE, 0},
{874, 3464546616u, 3205527253u, 3464546615u, 0, NEXTAFTERF_TOLERANCE, 0},
{875, 1002542205u, 3152136093u, 1002542204u, 0, NEXTAFTERF_TOLERANCE, 0},
{876, 3443552129u, 3165561391u, 3443552128u, 0, NEXTAFTERF_TOLERANCE, 0},
{877, 1287620154u, 3119707283u, 1287620153u, 0, NEXTAFTERF_TOLERANCE, 0},
{878, 946058434u, 1249928879u, 946058435u, 0, NEXTAFTERF_TOLERANCE, 0},
{879, 3073260205u, 3093124531u, 3073260206u, 0, NEXTAFTERF_TOLERANCE, 0},
{880, 1245702957u, 894348966u, 1245702956u, 0, NEXTAFTERF_TOLERANCE, 0},
{881, 989655126u, 1308376568u, 989655127u, 0, NEXTAFTERF_TOLERANCE, 0},
{882, 1002715618u, 1191006977u, 1002715619u, 0, NEXTAFTERF_TOLERANCE, 0},
{883, 3087802274u, 897541752u, 3087802273u, 0, NEXTAFTERF_TOLERANCE, 0},
{884, 1000863905u, 1196831314u, 1000863906u, 0, NEXTAFTERF_TOLERANCE, 0},
{885, 3415763001u, 3032518431u, 3415763000u, 0, NEXTAFTERF_TOLERANCE, 0},
{886, 3283471961u, 1260093226u, 3283471960u, 0, NEXTAFTERF_TOLERANCE, 0},
{887, 3311210827u, 1192192264u, 3311210826u, 0, NEXTAFTERF_TOLERANCE, 0},
{888, 1198307901u, 1116328249u, 1198307900u, 0, NEXTAFTERF_TOLERANCE, 0},
{889, 1288901567u, 1296370667u, 1288901568u, 0, NEXTAFTERF_TOLERANCE, 0},
{890, 922255363u, 958305289u, 922255364u, 0, NEXTAFTERF_TOLERANCE, 0},
{891, 1113104661u, 944376032u, 1113104660u, 0, NEXTAFTERF_TOLERANCE, 0},
{892, 948856035u, 1015466475u, 948856036u, 0, NEXTAFTERF_TOLERANCE, 0},
{893, 1062512367u, 3229559531u, 1062512366u, 0, NEXTAFTERF_TOLERANCE, 0},
{894, 1162027071u, 3308983387u, 1162027070u, 0, NEXTAFTERF_TOLERANCE, 0},
{895, 1034561811u, 1054043114u, 1034561812u, 0, NEXTAFTERF_TOLERANCE, 0},
{896, 3271615417u, 3209997200u, 3271615416u, 0, NEXTAFTERF_TOLERANCE, 0},
{897, 1042014529u, 1146708584u, 1042014530u, 0, NEXTAFTERF_TOLERANCE, 0},
{898, 1177157787u, 3090208179u, 1177157786u, 0, NEXTAFTERF_TOLERANCE, 0},
{899, 3196144817u, 1056118717u, 3196144816u, 0, NEXTAFTERF_TOLERANCE, 0},
{900, 1309658335u, 1010219988u, 1309658334u, 0, NEXTAFTERF_TOLERANCE, 0},
{901, 3100289712u, 3456334210u, 3100289713u, 0, NEXTAFTERF_TOLERANCE, 0},
{902, 3375507013u, 1306310823u, 3375507012u, 0, NEXTAFTERF_TOLERANCE, 0},
{903, 3460699001u, 3096700943u, 3460699000u, 0, NEXTAFTERF_TOLERANCE, 0},
{904, 3079231719u, 1044386263u, 3079231718u, 0, NEXTAFTERF_TOLERANCE, 0},
{905, 3093951884u, 1014115231u, 3093951883u, 0, NEXTAFTERF_TOLERANCE, 0},
{906, 3468023178u, 1209565017u, 3468023177u, 0, NEXTAFTERF_TOLERANCE, 0},
{907, 1204196034u, 3298625731u, 1204196033u, 0, NEXTAFTERF_TOLERANCE, 0},
{908, 909696559u, 1163075690u, 909696560u, 0, NEXTAFTERF_TOLERANCE, 0},
{909, 1161439847u, 943449277u, 1161439846u, 0, NEXTAFTERF_TOLERANCE, 0},
{910, 908663107u, 939489763u, 908663108u, 0, NEXTAFTERF_TOLERANCE, 0},
{911, 1055319316u, 3261813492u, 1055319315u, 0, NEXTAFTERF_TOLERANCE, 0},
{912, 1084378658u, 1009650785u, 1084378657u, 0, NEXTAFTERF_TOLERANCE, 0},
{913, 3053887750u, 3341786453u, 3053887751u, 0, NEXTAFTERF_TOLERANCE, 0},
{914, 3022828828u, 881335251u, 3022828827u, 0, NEXTAFTERF_TOLERANCE, 0},
{915, 1123114742u, 1229815537u, 1123114743u, 0, NEXTAFTERF_TOLERANCE, 0},
{916, 1258114435u, 1291336083u, 1258114436u, 0, NEXTAFTERF_TOLERANCE, 0},
{917, 3468040845u, 3066966245u, 3468040844u, 0, NEXTAFTERF_TOLERANCE, 0},
{918, 1178825761u, 1113195286u, 1178825760u, 0, NEXTAFTERF_TOLERANCE, 0},
{919, 3059266302u, 878503862u, 3059266301u, 0, NEXTAFTERF_TOLERANCE, 0},
{920, 3223384012u, 1130486973u, 3223384011u, 0, NEXTAFTERF_TOLERANCE, 0},
{921, 1019964626u, 1235133609u, 1019964627u, 0, NEXTAFTERF_TOLERANCE, 0},
{922, 3445262427u, 3465211174u, 3445262428u, 0, NEXTAFTERF_TOLERANCE, 0},
{923, 1125653081u, 1207799746u, 1125653082u, 0, NEXTAFTERF_TOLERANCE, 0},
{924, 3337652712u, 3025581813u, 3337652711u, 0, NEXTAFTERF_TOLERANCE, 0},
{925, 1184753508u, 3147374485u, 1184753507u, 0, NEXTAFTERF_TOLERANCE, 0},
{926, 996404791u, 3353251979u, 996404790u, 0, NEXTAFTERF_TOLERANCE, 0},
{927, 1188439315u, 1113484271u, 1188439314u, 0, NEXTAFTERF_TOLERANCE, 0},
{928, 916831283u, 999465787u, 916831284u, 0, NEXTAFTERF_TOLERANCE, 0},
{929, 996786317u, 3179221951u, 996786316u, 0, NEXTAFTERF_TOLERANCE, 0},
{930, 3461635065u, 1004690387u, 3461635064u, 0, NEXTAFTERF_TOLERANCE, 0},
{931, 1188167943u, 1200744896u, 1188167944u, 0, NEXTAFTERF_TOLERANCE, 0},
{932, 3036502395u, 1172597364u, 3036502394u, 0, NEXTAFTERF_TOLERANCE, 0},
{933, 891257783u, 1267560050u, 891257784u, 0, NEXTAFTERF_TOLERANCE, 0},
{934, 1102061604u, 3424449935u, 1102061603u, 0, NEXTAFTERF_TOLERANCE, 0},
{935, 1282351521u, 3039376424u, 1282351520u, 0, NEXTAFTERF_TOLERANCE, 0},
{936, 3458861065u, 3392466405u, 3458861064u, 0, NEXTAFTERF_TOLERANCE, 0},
{937, 3095256878u, 1023623326u, 3095256877u, 0, NEXTAFTERF_TOLERANCE, 0},
{938, 3422194733u, 893873945u, 3422194732u, 0, NEXTAFTERF_TOLERANCE, 0},
{939, 3083885296u, 974543672u, 3083885295u, 0, NEXTAFTERF_TOLERANCE, 0},
{940, 1261940623u, 3402349985u, 1261940622u, 0, NEXTAFTERF_TOLERANCE, 0},
{941, 3400603081u, 3234396843u, 3400603080u, 0, NEXTAFTERF_TOLERANCE, 0},
{942, 3139250800u, 3079109479u, 3139250799u, 0, NEXTAFTERF_TOLERANCE, 0},
{943, 886201503u, 3272760705u, 886201502u, 0, NEXTAFTERF_TOLERANCE, 0},
{944, 3297366026u, 1089966380u, 3297366025u, 0, NEXTAFTERF_TOLERANCE, 0},
{945, 1218488455u, 3309646450u, 1218488454u, 0, NEXTAFTERF_TOLERANCE, 0},
{946, 3040358923u, 3093401553u, 3040358924u, 0, NEXTAFTERF_TOLERANCE, 0},
{947, 1283938137u, 1196383822u, 1283938136u, 0, NEXTAFTERF_TOLERANCE, 0},
{948, 3182551696u, 3029982441u, 3182551695u, 0, NEXTAFTERF_TOLERANCE, 0},
{949, 1317098613u, 949986176u, 1317098612u, 0, NEXTAFTERF_TOLERANCE, 0},
{950, 3116209179u, 3303588342u, 3116209180u, 0, NEXTAFTERF_TOLERANCE, 0},
{951, 3239728775u, 927815421u, 3239728774u, 0, NEXTAFTERF_TOLERANCE, 0},
{952, 3207141672u, 933456504u, 3207141671u, 0, NEXTAFTERF_TOLERANCE, 0},
{953, 3154378805u, 905462392u, 3154378804u, 0, NEXTAFTERF_TOLERANCE, 0},
{954, 3069658155u, 1041452042u, 3069658154u, 0, NEXTAFTERF_TOLERANCE, 0},
{955, 3207056527u, 3384206601u, 3207056528u, 0, NEXTAFTERF_TOLERANCE, 0},
{956, 1284174954u, 3436881197u, 1284174953u, 0, NEXTAFTERF_TOLERANCE, 0},
{957, 3156081645u, 3308839704u, 3156081646u, 0, NEXTAFTERF_TOLERANCE, 0},
{958, 1063693032u, 976661408u, 1063693031u, 0, NEXTAFTERF_TOLERANCE, 0},
{959, 3036026175u, 1251203998u, 3036026174u, 0, NEXTAFTERF_TOLERANCE, 0},
{960, 1102631663u, 3396951425u, 1102631662u, 0, NEXTAFTERF_TOLERANCE, 0},
{961, 968803479u, 992989712u, 968803480u, 0, NEXTAFTERF_TOLERANCE, 0},
{962, 3273080388u, 3109405906u, 3273080387u, 0, NEXTAFTERF_TOLERANCE, 0},
{963, 1172529774u, 3294550127u, 1172529773u, 0, NEXTAFTERF_TOLERANCE, 0},
{964, 1306695905u, 1292690378u, 1306695904u, 0, NEXTAFTERF_TOLERANCE, 0},
{965, 1003649752u, 1218792138u, 1003649753u, 0, NEXTAFTERF_TOLERANCE, 0},
{966, 1078478376u, 1326246424u, 1078478377u, 0, NEXTAFTERF_TOLERANCE, 0},
{967, 3158855023u, 3151283866u, 3158855022u, 0, NEXTAFTERF_TOLERANCE, 0},
{968, 1165177679u, 3276237026u, 1165177678u, 0, NEXTAFTERF_TOLERANCE, 0},
{969, 3403009513u, 3381966453u, 3403009512u, 0, NEXTAFTERF_TOLERANCE, 0},
{970, 952348506u, 3377573987u, 952348505u, 0, NEXTAFTERF_TOLERANCE, 0},
{971, 1222777442u, 1125769920u, 1222777441u, 0, NEXTAFTERF_TOLERANCE, 0},
{972, 1325324763u, 978336043u, 1325324762u, 0, NEXTAFTERF_TOLERANCE, 0},
{973, 3363524213u, 3202991311u, 3363524212u, 0, NEXTAFTERF_TOLERANCE, 0},
{974, 1158950321u, 1073578913u, 1158950320u, 0, NEXTAFTERF_TOLERANCE, 0},
{975, 903129873u, 3416864271u, 903129872u, 0, NEXTAFTERF_TOLERANCE, 0},
{976, 3078339944u, 988173985u, 3078339943u, 0, NEXTAFTERF_TOLERANCE, 0},
{977, 1208345407u, 1254181270u, 1208345408u, 0, NEXTAFTERF_TOLERANCE, 0},
{978, 1258634105u, 1247426200u, 1258634104u, 0, NEXTAFTERF_TOLERANCE, 0},
{979, 1248478509u, 1287895126u, 1248478510u, 0, NEXTAFTERF_TOLERANCE, 0},
{980, 1153863988u, 3430539165u, 1153863987u, 0, NEXTAFTERF_TOLERANCE, 0},
{981, 1097120930u, 3221726305u, 1097120929u, 0, NEXTAFTERF_TOLERANCE, 0},
{982, 3469778622u, 1200179013u, 3469778621u, 0, NEXTAFTERF_TOLERANCE, 0},
{983, 1147712200u, 931865525u, 1147712199u, 0, NEXTAFTERF_TOLERANCE, 0},
{984, 1124721745u, 3058969650u, 1124721744u, 0, NEXTAFTERF_TOLERANCE, 0},
{985, 3261744304u, 1043806501u, 3261744303u, 0, NEXTAFTERF_TOLERANCE, 0},
{986, 1064922416u, 1320485628u, 1064922417u, 0, NEXTAFTERF_TOLERANCE, 0},
{987, 3303160152u, 3075455322u, 3303160151u, 0, NEXTAFTERF_TOLERANCE, 0},
{988, 1315090496u, 3269683237u, 1315090495u, 0, NEXTAFTERF_TOLERANCE, 0},
{989, 3230403187u, 1322841992u, 3230403186u, 0, NEXTAFTERF_TOLERANCE, 0},
{990, 1335399673u, 974138676u, 1335399672u, 0, NEXTAFTERF_TOLERANCE, 0},
{991, 1072458508u, 3372833993u, 1072458507u, 0, NEXTAFTERF_TOLERANCE, 0},
{992, 3252139741u, 1059615003u, 3252139740u, 0, NEXTAFTERF_TOLERANCE, 0},
{993, 3468519966u, 3113982619u, 3468519965u, 0, NEXTAFTERF_TOLERANCE, 0},
{994, 1006231203u, 897530770u, 1006231202u, 0, NEXTAFTERF_TOLERANCE, 0},
{995, 951554138u, 1001144381u, 951554139u, 0, NEXTAFTERF_TOLERANCE, 0},
{996, 942046828u, 986341002u, 942046829u, 0, NEXTAFTERF_TOLERANCE, 0},
{997, 3319723279u, 3414482416u, 3319723280u, 0, NEXTAFTERF_TOLERANCE, 0},
{998, 3255104167u, 928827688u, 3255104166u, 0, NEXTAFTERF_TOLERANCE, 0},
{999, 1155477903u, 3104812800u, 1155477902u, 0, NEXTAFTERF_TOLERANCE, 0},
{1000, 3273889176u, 980486479u, 3273889175u, 0, NEXTAFTERF_TOLERANCE, 0},
{1001, 3237813668u, 3441016803u, 3237813669u, 0, NEXTAFTERF_TOLERANCE, 0},
{1002, 975349337u, 1311932596u, 975349338u, 0, NEXTAFTERF_TOLERANCE, 0},
{1003, 981908840u, 3314038398u, 981908839u, 0, NEXTAFTERF_TOLERANCE, 0},
{1004, 941187647u, 1107765599u, 941187648u, 0, NEXTAFTERF_TOLERANCE, 0},
{1005, 1214223128u, 3225536822u, 1214223127u, 0, NEXTAFTERF_TOLERANCE, 0},
{1006, 3422922584u, 1086391131u, 3422922583u, 0, NEXTAFTERF_TOLERANCE, 0},
{1007, 1315857601u, 3487600045u, 1315857600u, 0, NEXTAFTERF_TOLERANCE, 0},
{1008, 3453226030u, 3233768835u, 3453226029u, 0, NEXTAFTERF_TOLERANCE, 0},
{1009, 1078359574u, 3199175230u, 1078359573u, 0, NEXTAFTERF_TOLERANCE, 0},
{1010, 1029557624u, 3302959071u, 1029557623u, 0, NEXTAFTERF_TOLERANCE, 0},
{1011, 1207675424u, 3042692550u, 1207675423u, 0, NEXTAFTERF_TOLERANCE, 0},
{1012, 1028355074u, 3442294040u, 1028355073u, 0, NEXTAFTERF_TOLERANCE, 0},
{1013, 3119299090u, 1187096397u, 3119299089u, 0, NEXTAFTERF_TOLERANCE, 0},
{1014, 1248421894u, 3367769132u, 1248421893u, 0, NEXTAFTERF_TOLERANCE, 0},
{1015, 3353251994u, 1095517730u, 3353251993u, 0, NEXTAFTERF_TOLERANCE, 0},
{1016, 876926659u, 3288089977u, 876926658u, 0, NEXTAFTERF_TOLERANCE, 0},
{1017, 1076752219u, 876236939u, 1076752218u, 0, NEXTAFTERF_TOLERANCE, 0},
{1018, 1273395082u, 3031189261u, 1273395081u, 0, NEXTAFTERF_TOLERANCE, 0},
{1019, 3385588183u, 3258252464u, 3385588182u, 0, NEXTAFTERF_TOLERANCE, 0},
{1020, 3192315328u, 3289489214u, 3192315329u, 0, NEXTAFTERF_TOLERANCE, 0},
{1021, 3441804648u, 3274638356u, 3441804647u, 0, NEXTAFTERF_TOLERANCE, 0},
{1022, 3392827417u, 1277961150u, 3392827416u, 0, NEXTAFTERF_TOLERANCE, 0},
{1023, 1161241793u, 1328003707u, 1161241794u, 0, NEXTAFTERF_TOLERANCE, 0},
{1024, 3034494183u, 3041579130u, 3034494184u, 0, NEXTAFTERF_TOLERANCE, 0},
{1025, 1171318485u, 3374409104u, 1171318484u, 0, NEXTAFTERF_TOLERANCE, 0},
{1026, 1001216371u, 3052357038u, 1001216370u, 0, NEXTAFTERF_TOLERANCE, 0},
{1027, 912515889u, 1074635609u, 912515890u, 0, NEXTAFTERF_TOLERANCE, 0},
{1028, 3391452505u, 897989232u, 3391452504u, 0, NEXTAFTERF_TOLERANCE, 0},
{1029, 3249603369u, 3147662248u, 3249603368u, 0, NEXTAFTERF_TOLERANCE, 0},
{1030, 3169816394u, 988430929u, 3169816393u, 0, NEXTAFTERF_TOLERANCE, 0},
{1031, 3282212423u, 3174079140u, 3282212422u, 0, NEXTAFTERF_TOLERANCE, 0},
{1032, 3352293320u, 3247843425u, 3352293319u, 0, NEXTAFTERF_TOLERANCE, 0},
{1033, 3296358441u, 875645354u, 3296358440u, 0, NEXTAFTERF_TOLERANCE, 0},
{1034, 1197828352u, 3245614728u, 1197828351u, 0, NEXTAFTERF_TOLERANCE, 0},
{1035, 3340510371u, 914930263u, 3340510370u, 0, NEXTAFTERF_TOLERANCE, 0},
{1036, 1127109339u, 3368125489u, 1127109338u, 0, NEXTAFTERF_TOLERANCE, 0},
{1037, 909467381u, 1232375752u, 909467382u, 0, NEXTAFTERF_TOLERANCE, 0},
{1038, 3192887808u, 3191848339u, 3192887807u, 0, NEXTAFTERF_TOLERANCE, 0},
{1039, 3237183876u, 3179379969u, 3237183875u, 0, NEXTAFTERF_TOLERANCE, 0},
{1040, 939285924u, 3056079386u, 939285923u, 0, NEXTAFTERF_TOLERANCE, 0},
{1041, 944050180u, 3452557879u, 944050179u, 0, NEXTAFTERF_TOLERANCE, 0},
{1042, 3058135703u, 3090284601u, 3058135704u, 0, NEXTAFTERF_TOLERANCE, 0},
{1043, 3480592662u, 3261728191u, 3480592661u, 0, NEXTAFTERF_TOLERANCE, 0},
{1044, 3061939312u, 3274418540u, 3061939313u, 0, NEXTAFTERF_TOLERANCE, 0},
{1045, 1155775526u, 1255814444u, 1155775527u, 0, NEXTAFTERF_TOLERANCE, 0},
{1046, 1234491880u, 3408568717u, 1234491879u, 0, NEXTAFTERF_TOLERANCE, 0}

// AUTOMATICALLY GENERATED VECTORS STOP

};

#endif // CYGONCE_LIBM_NEXTAFTERF_H multiple inclusion protection

// EOF nextafterf.h
