#ifndef CYGONCE_LIBM_MODFF_H
#define CYGONCE_LIBM_MODFF_H
//===========================================================================
//
//      modff.h
//
//      Test vectors for testing of modff() math library function
//
//===========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####
// -------------------------------------------
// This file is part of eCos, the Embedded Configurable Operating System.
// Copyright (C) 2012 Free Software Foundation, Inc.
//
// eCos is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 or (at your option) any later
// version.
//
// eCos is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
// for more details.
//
// You should have received a copy of the GNU General Public License
// along with eCos; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//
// As a special exception, if other files instantiate templates or use
// macros or inline functions from this file, or you compile this file
// and link it with other works to produce a work based on this file,
// this file does not by itself cause the resulting work to be covered by
// the GNU General Public License. However the source code for this file
// must still be made available in accordance with section (3) of the GNU
// General Public License v2.
//
// This exception does not invalidate any other reasons why a work based
// on this file might be covered by the GNU General Public License.
// -------------------------------------------
// ####ECOSGPLCOPYRIGHTEND####
//===========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):
// Contributors:  visar, ilijak
// Date:        1998-02-13
// Purpose:
// Description:
// Usage:       #include "vectors/modff.h"
//
//####DESCRIPTIONEND####
//
//===========================================================================


// CONFIGURATION

#include <pkgconf/libm.h>   // Configuration header


// INCLUDES

#include <cyg/infra/cyg_type.h>    // Common type definitions and support
#include "vectors/vector_support_float.h"// extra support for math tests

#define MODFF_TOLERANCE 1.0E-04

static const Cyg_libm_test_float_vec_t modff_vec[] = {

// AUTOMATICALLY GENERATED VECTORS START

{0, 1107800421u, 1107558400u, 1064065344u, 0, MODFF_TOLERANCE, 0},
{1, 1203999711u, 1203999616u, 1061027840u, 0, MODFF_TOLERANCE, 0},
{2, 896005582u, 0u, 896005582u, 0, MODFF_TOLERANCE, 0},
{3, 3368700125u, 3368700096u, 3211264000u, 0, MODFF_TOLERANCE, 0},
{4, 3308232444u, 3308228608u, 3211771904u, 0, MODFF_TOLERANCE, 0},
{5, 1224242132u, 1224242112u, 1059061760u, 0, MODFF_TOLERANCE, 0},
{6, 3221027117u, 3212836864u, 3212440154u, 0, MODFF_TOLERANCE, 0},
{7, 1284201705u, 1284201705u, 0u, 0, MODFF_TOLERANCE, 0},
{8, 1198712763u, 1198712576u, 1060831232u, 0, MODFF_TOLERANCE, 0},
{9, 919636942u, 0u, 919636942u, 0, MODFF_TOLERANCE, 0},
{10, 954173073u, 0u, 954173073u, 0, MODFF_TOLERANCE, 0},
{11, 1035260608u, 0u, 1035260608u, 0, MODFF_TOLERANCE, 0},
{12, 966554515u, 0u, 966554515u, 0, MODFF_TOLERANCE, 0},
{13, 3234538174u, 3233808384u, 3199347680u, 0, MODFF_TOLERANCE, 0},
{14, 1312607135u, 1312607135u, 0u, 0, MODFF_TOLERANCE, 0},
{15, 1194999402u, 1194999296u, 1054081024u, 0, MODFF_TOLERANCE, 0},
{16, 1166191415u, 1166190592u, 1053671424u, 0, MODFF_TOLERANCE, 0},
{17, 1018661564u, 0u, 1018661564u, 0, MODFF_TOLERANCE, 0},
{18, 1130472166u, 1130430464u, 1059251712u, 0, MODFF_TOLERANCE, 0},
{19, 1234419246u, 1234419240u, 1061158912u, 0, MODFF_TOLERANCE, 0},
{20, 1302107128u, 1302107128u, 0u, 0, MODFF_TOLERANCE, 0},
{21, 3370647675u, 3370647648u, 3210215424u, 0, MODFF_TOLERANCE, 0},
{22, 1052801068u, 0u, 1052801068u, 0, MODFF_TOLERANCE, 0},
{23, 1060849628u, 0u, 1060849628u, 0, MODFF_TOLERANCE, 0},
{24, 3446630737u, 3446630737u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{25, 3484320003u, 3484320003u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{26, 3305392896u, 3305390080u, 3207593984u, 0, MODFF_TOLERANCE, 0},
{27, 882596369u, 0u, 882596369u, 0, MODFF_TOLERANCE, 0},
{28, 1256676590u, 1256676590u, 0u, 0, MODFF_TOLERANCE, 0},
{29, 1167223673u, 1167222784u, 1054752768u, 0, MODFF_TOLERANCE, 0},
{30, 968192794u, 0u, 968192794u, 0, MODFF_TOLERANCE, 0},
{31, 878547432u, 0u, 878547432u, 0, MODFF_TOLERANCE, 0},
{32, 1111584337u, 1111490560u, 1052190848u, 0, MODFF_TOLERANCE, 0},
{33, 1052361612u, 0u, 1052361612u, 0, MODFF_TOLERANCE, 0},
{34, 1280025214u, 1280025214u, 0u, 0, MODFF_TOLERANCE, 0},
{35, 906701409u, 0u, 906701409u, 0, MODFF_TOLERANCE, 0},
{36, 3471653172u, 3471653172u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{37, 1154138102u, 1154129920u, 1065332736u, 0, MODFF_TOLERANCE, 0},
{38, 3231467496u, 3229614080u, 3210886976u, 0, MODFF_TOLERANCE, 0},
{39, 934336592u, 0u, 934336592u, 0, MODFF_TOLERANCE, 0},
{40, 1341514497u, 1341514497u, 0u, 0, MODFF_TOLERANCE, 0},
{41, 3466051188u, 3466051188u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{42, 1272351391u, 1272351391u, 0u, 0, MODFF_TOLERANCE, 0},
{43, 3373485062u, 3373485056u, 3200253952u, 0, MODFF_TOLERANCE, 0},
{44, 3319724992u, 3319724032u, 3203399680u, 0, MODFF_TOLERANCE, 0},
{45, 3354615790u, 3354615680u, 3210477568u, 0, MODFF_TOLERANCE, 0},
{46, 3266377514u, 3266314240u, 3203869184u, 0, MODFF_TOLERANCE, 0},
{47, 917622040u, 0u, 917622040u, 0, MODFF_TOLERANCE, 0},
{48, 1334966485u, 1334966485u, 0u, 0, MODFF_TOLERANCE, 0},
{49, 940236348u, 0u, 940236348u, 0, MODFF_TOLERANCE, 0},
{50, 3304072663u, 3304071168u, 3191529472u, 0, MODFF_TOLERANCE, 0},
{51, 977028681u, 0u, 977028681u, 0, MODFF_TOLERANCE, 0},
{52, 3251541546u, 3251109888u, 3209872704u, 0, MODFF_TOLERANCE, 0},
{53, 3355962282u, 3355962240u, 3207069696u, 0, MODFF_TOLERANCE, 0},
{54, 3371863479u, 3371863456u, 3208118272u, 0, MODFF_TOLERANCE, 0},
{55, 1014861921u, 0u, 1014861921u, 0, MODFF_TOLERANCE, 0},
{56, 966573255u, 0u, 966573255u, 0, MODFF_TOLERANCE, 0},
{57, 1306460502u, 1306460502u, 0u, 0, MODFF_TOLERANCE, 0},
{58, 903489435u, 0u, 903489435u, 0, MODFF_TOLERANCE, 0},
{59, 1197542187u, 1197542144u, 1043070976u, 0, MODFF_TOLERANCE, 0},
{60, 922888249u, 0u, 922888249u, 0, MODFF_TOLERANCE, 0},
{61, 1139392309u, 1139376128u, 1056756736u, 0, MODFF_TOLERANCE, 0},
{62, 1184239996u, 1184239616u, 1061027840u, 0, MODFF_TOLERANCE, 0},
{63, 3224098462u, 3221225472u, 3207551608u, 0, MODFF_TOLERANCE, 0},
{64, 1252490238u, 1252490238u, 0u, 0, MODFF_TOLERANCE, 0},
{65, 1173619825u, 1173618688u, 1057890304u, 0, MODFF_TOLERANCE, 0},
{66, 1001673627u, 0u, 1001673627u, 0, MODFF_TOLERANCE, 0},
{67, 3462631271u, 3462631271u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{68, 976098044u, 0u, 976098044u, 0, MODFF_TOLERANCE, 0},
{69, 1151967422u, 1151967232u, 1019084800u, 0, MODFF_TOLERANCE, 0},
{70, 941796645u, 0u, 941796645u, 0, MODFF_TOLERANCE, 0},
{71, 886451963u, 0u, 886451963u, 0, MODFF_TOLERANCE, 0},
{72, 1103058486u, 1102577664u, 1063962304u, 0, MODFF_TOLERANCE, 0},
{73, 3217259624u, 3212836864u, 3204905168u, 0, MODFF_TOLERANCE, 0},
{74, 3287199470u, 3287187456u, 3199973376u, 0, MODFF_TOLERANCE, 0},
{75, 893184329u, 0u, 893184329u, 0, MODFF_TOLERANCE, 0},
{76, 1243067084u, 1243067084u, 0u, 0, MODFF_TOLERANCE, 0},
{77, 1143233714u, 1143226368u, 1055232000u, 0, MODFF_TOLERANCE, 0},
{78, 1007268238u, 0u, 1007268238u, 0, MODFF_TOLERANCE, 0},
{79, 1139941253u, 1139933184u, 1048324096u, 0, MODFF_TOLERANCE, 0},
{80, 1147688821u, 1147682816u, 1052485632u, 0, MODFF_TOLERANCE, 0},
{81, 3234638157u, 3233808384u, 3200947408u, 0, MODFF_TOLERANCE, 0},
{82, 3449209899u, 3449209899u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{83, 3240298487u, 3240099840u, 3191995840u, 0, MODFF_TOLERANCE, 0},
{84, 1020260821u, 0u, 1020260821u, 0, MODFF_TOLERANCE, 0},
{85, 1288902137u, 1288902137u, 0u, 0, MODFF_TOLERANCE, 0},
{86, 1333134799u, 1333134799u, 0u, 0, MODFF_TOLERANCE, 0},
{87, 1338107877u, 1338107877u, 0u, 0, MODFF_TOLERANCE, 0},
{88, 1187847971u, 1187847680u, 1058111488u, 0, MODFF_TOLERANCE, 0},
{89, 1317663644u, 1317663644u, 0u, 0, MODFF_TOLERANCE, 0},
{90, 1038851706u, 0u, 1038851706u, 0, MODFF_TOLERANCE, 0},
{91, 1327544110u, 1327544110u, 0u, 0, MODFF_TOLERANCE, 0},
{92, 3329354473u, 3329353728u, 3208265728u, 0, MODFF_TOLERANCE, 0},
{93, 1308397879u, 1308397879u, 0u, 0, MODFF_TOLERANCE, 0},
{94, 1309289088u, 1309289088u, 0u, 0, MODFF_TOLERANCE, 0},
{95, 1019883016u, 0u, 1019883016u, 0, MODFF_TOLERANCE, 0},
{96, 1294782875u, 1294782875u, 0u, 0, MODFF_TOLERANCE, 0},
{97, 3444653659u, 3444653659u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{98, 1279248024u, 1279248024u, 0u, 0, MODFF_TOLERANCE, 0},
{99, 3405585402u, 3405585402u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{100, 1106778573u, 1106771968u, 1011771392u, 0, MODFF_TOLERANCE, 0},
{101, 3304487767u, 3304480768u, 3210393600u, 0, MODFF_TOLERANCE, 0},
{102, 1140567947u, 1140555776u, 1052650496u, 0, MODFF_TOLERANCE, 0},
{103, 1238569473u, 1238569472u, 1040187392u, 0, MODFF_TOLERANCE, 0},
{104, 873035665u, 0u, 873035665u, 0, MODFF_TOLERANCE, 0},
{105, 3223983207u, 3221225472u, 3207090588u, 0, MODFF_TOLERANCE, 0},
{106, 1276671061u, 1276671061u, 0u, 0, MODFF_TOLERANCE, 0},
{107, 1261071232u, 1261071232u, 0u, 0, MODFF_TOLERANCE, 0},
{108, 1182202773u, 1182201856u, 1063600128u, 0, MODFF_TOLERANCE, 0},
{109, 1175011025u, 1175010304u, 1060388864u, 0, MODFF_TOLERANCE, 0},
{110, 1082692850u, 1082130432u, 1049186080u, 0, MODFF_TOLERANCE, 0},
{111, 1211581107u, 1211581056u, 1061945344u, 0, MODFF_TOLERANCE, 0},
{112, 974547519u, 0u, 974547519u, 0, MODFF_TOLERANCE, 0},
{113, 3475164509u, 3475164509u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{114, 1071134451u, 1065353216u, 1060138470u, 0, MODFF_TOLERANCE, 0},
{115, 3403348556u, 3403348556u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{116, 3373011130u, 3373011120u, 3206545408u, 0, MODFF_TOLERANCE, 0},
{117, 3460764044u, 3460764044u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{118, 1136411063u, 1136394240u, 1057189376u, 0, MODFF_TOLERANCE, 0},
{119, 1118097422u, 1118044160u, 1053822464u, 0, MODFF_TOLERANCE, 0},
{120, 3239231622u, 3239051264u, 3190825344u, 0, MODFF_TOLERANCE, 0},
{121, 3302723069u, 3302719488u, 3202338816u, 0, MODFF_TOLERANCE, 0},
{122, 3340615780u, 3340615680u, 3200778240u, 0, MODFF_TOLERANCE, 0},
{123, 998567360u, 0u, 998567360u, 0, MODFF_TOLERANCE, 0},
{124, 3417964312u, 3417964312u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{125, 1321337529u, 1321337529u, 0u, 0, MODFF_TOLERANCE, 0},
{126, 1143864063u, 1143848960u, 1064041472u, 0, MODFF_TOLERANCE, 0},
{127, 1148867223u, 1148862464u, 1049933824u, 0, MODFF_TOLERANCE, 0},
{128, 1256486202u, 1256486202u, 0u, 0, MODFF_TOLERANCE, 0},
{129, 1314196594u, 1314196594u, 0u, 0, MODFF_TOLERANCE, 0},
{130, 989687421u, 0u, 989687421u, 0, MODFF_TOLERANCE, 0},
{131, 3372681320u, 3372681312u, 3204448256u, 0, MODFF_TOLERANCE, 0},
{132, 1152956913u, 1152950272u, 1062176768u, 0, MODFF_TOLERANCE, 0},
{133, 892922651u, 0u, 892922651u, 0, MODFF_TOLERANCE, 0},
{134, 3373029087u, 3373029072u, 3211788288u, 0, MODFF_TOLERANCE, 0},
{135, 1109627625u, 1109393408u, 1063565888u, 0, MODFF_TOLERANCE, 0},
{136, 1314158257u, 1314158257u, 0u, 0, MODFF_TOLERANCE, 0},
{137, 1307091856u, 1307091856u, 0u, 0, MODFF_TOLERANCE, 0},
{138, 1103202538u, 1103101952u, 1044673792u, 0, MODFF_TOLERANCE, 0},
{139, 1077234132u, 1073741824u, 1062545232u, 0, MODFF_TOLERANCE, 0},
{140, 3272167130u, 3272146944u, 3198006272u, 0, MODFF_TOLERANCE, 0},
{141, 1142167709u, 1142161408u, 1053091840u, 0, MODFF_TOLERANCE, 0},
{142, 1096445242u, 1095761920u, 1059509152u, 0, MODFF_TOLERANCE, 0},
{143, 3426232834u, 3426232834u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{144, 1036705270u, 0u, 1036705270u, 0, MODFF_TOLERANCE, 0},
{145, 3368566779u, 3368566752u, 3210215424u, 0, MODFF_TOLERANCE, 0},
{146, 967249167u, 0u, 967249167u, 0, MODFF_TOLERANCE, 0},
{147, 3349013503u, 3349013376u, 3212705792u, 0, MODFF_TOLERANCE, 0},
{148, 1138741813u, 1138720768u, 1059351040u, 0, MODFF_TOLERANCE, 0},
{149, 982950501u, 0u, 982950501u, 0, MODFF_TOLERANCE, 0},
{150, 982549888u, 0u, 982549888u, 0, MODFF_TOLERANCE, 0},
{151, 1142981585u, 1142980608u, 1031028736u, 0, MODFF_TOLERANCE, 0},
{152, 1015602236u, 0u, 1015602236u, 0, MODFF_TOLERANCE, 0},
{153, 3365560001u, 3365560000u, 3170893824u, 0, MODFF_TOLERANCE, 0},
{154, 3347165962u, 3347165952u, 3181379584u, 0, MODFF_TOLERANCE, 0},
{155, 1009535440u, 0u, 1009535440u, 0, MODFF_TOLERANCE, 0},
{156, 3381353228u, 3381353224u, 3204448256u, 0, MODFF_TOLERANCE, 0},
{157, 3402950505u, 3402950504u, 3204448256u, 0, MODFF_TOLERANCE, 0},
{158, 1077903063u, 1073741824u, 1065220956u, 0, MODFF_TOLERANCE, 0},
{159, 3473956030u, 3473956030u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{160, 976891930u, 0u, 976891930u, 0, MODFF_TOLERANCE, 0},
{161, 3349098349u, 3349098240u, 3210346496u, 0, MODFF_TOLERANCE, 0},
{162, 1055327704u, 0u, 1055327704u, 0, MODFF_TOLERANCE, 0},
{163, 1060398533u, 0u, 1060398533u, 0, MODFF_TOLERANCE, 0},
{164, 945568720u, 0u, 945568720u, 0, MODFF_TOLERANCE, 0},
{165, 3313485084u, 3313483776u, 3198386176u, 0, MODFF_TOLERANCE, 0},
{166, 3345489836u, 3345489664u, 3207331840u, 0, MODFF_TOLERANCE, 0},
{167, 1108392401u, 1108344832u, 1043976448u, 0, MODFF_TOLERANCE, 0},
{168, 940893161u, 0u, 940893161u, 0, MODFF_TOLERANCE, 0},
{169, 1137000140u, 1136984064u, 1056649216u, 0, MODFF_TOLERANCE, 0},
{170, 976791751u, 0u, 976791751u, 0, MODFF_TOLERANCE, 0},
{171, 3230678102u, 3229614080u, 3204571824u, 0, MODFF_TOLERANCE, 0},
{172, 1324802687u, 1324802687u, 0u, 0, MODFF_TOLERANCE, 0},
{173, 1004442355u, 0u, 1004442355u, 0, MODFF_TOLERANCE, 0},
{174, 1108485380u, 1108344832u, 1057571072u, 0, MODFF_TOLERANCE, 0},
{175, 1061834641u, 0u, 1061834641u, 0, MODFF_TOLERANCE, 0},
{176, 972388096u, 0u, 972388096u, 0, MODFF_TOLERANCE, 0},
{177, 3381268392u, 3381268392u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{178, 1146976802u, 1146961920u, 1063815168u, 0, MODFF_TOLERANCE, 0},
{179, 1087189715u, 1086324736u, 1054027056u, 0, MODFF_TOLERANCE, 0},
{180, 3212952285u, 3212836864u, 3160501888u, 0, MODFF_TOLERANCE, 0},
{181, 3329407365u, 3329406976u, 3200417792u, 0, MODFF_TOLERANCE, 0},
{182, 1000611335u, 0u, 1000611335u, 0, MODFF_TOLERANCE, 0},
{183, 1227905777u, 1227905776u, 1031798784u, 0, MODFF_TOLERANCE, 0},
{184, 3466188568u, 3466188568u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{185, 1041678304u, 0u, 1041678304u, 0, MODFF_TOLERANCE, 0},
{186, 3319315516u, 3319314432u, 3204939776u, 0, MODFF_TOLERANCE, 0},
{187, 3422089012u, 3422089012u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{188, 935938416u, 0u, 935938416u, 0, MODFF_TOLERANCE, 0},
{189, 1146676692u, 1146667008u, 1058492416u, 0, MODFF_TOLERANCE, 0},
{190, 1152633030u, 1152630784u, 1049387008u, 0, MODFF_TOLERANCE, 0},
{191, 1315030230u, 1315030230u, 0u, 0, MODFF_TOLERANCE, 0},
{192, 3336225884u, 3336225792u, 3191341056u, 0, MODFF_TOLERANCE, 0},
{193, 898402905u, 0u, 898402905u, 0, MODFF_TOLERANCE, 0},
{194, 1134593658u, 1134592000u, 1028603904u, 0, MODFF_TOLERANCE, 0},
{195, 3456812581u, 3456812581u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{196, 977281449u, 0u, 977281449u, 0, MODFF_TOLERANCE, 0},
{197, 879922831u, 0u, 879922831u, 0, MODFF_TOLERANCE, 0},
{198, 1086198791u, 1084227584u, 1064345656u, 0, MODFF_TOLERANCE, 0},
{199, 920125958u, 0u, 920125958u, 0, MODFF_TOLERANCE, 0},
{200, 1255152035u, 1255152034u, 1056964608u, 0, MODFF_TOLERANCE, 0},
{201, 1135271264u, 1135247360u, 1060814848u, 0, MODFF_TOLERANCE, 0},
{202, 3284878412u, 3284860928u, 3205011456u, 0, MODFF_TOLERANCE, 0},
{203, 1094190727u, 1093664768u, 1056991344u, 0, MODFF_TOLERANCE, 0},
{204, 1056854532u, 0u, 1056854532u, 0, MODFF_TOLERANCE, 0},
{205, 1294665325u, 1294665325u, 0u, 0, MODFF_TOLERANCE, 0},
{206, 991185677u, 0u, 991185677u, 0, MODFF_TOLERANCE, 0},
{207, 1036608591u, 0u, 1036608591u, 0, MODFF_TOLERANCE, 0},
{208, 1296239160u, 1296239160u, 0u, 0, MODFF_TOLERANCE, 0},
{209, 3229998064u, 3229614080u, 3191569920u, 0, MODFF_TOLERANCE, 0},
{210, 3439134022u, 3439134022u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{211, 1043829691u, 0u, 1043829691u, 0, MODFF_TOLERANCE, 0},
{212, 1317170485u, 1317170485u, 0u, 0, MODFF_TOLERANCE, 0},
{213, 1325668223u, 1325668223u, 0u, 0, MODFF_TOLERANCE, 0},
{214, 970681762u, 0u, 970681762u, 0, MODFF_TOLERANCE, 0},
{215, 1092037607u, 1091567616u, 1055227104u, 0, MODFF_TOLERANCE, 0},
{216, 1027330835u, 0u, 1027330835u, 0, MODFF_TOLERANCE, 0},
{217, 3343511749u, 3343511552u, 3208970240u, 0, MODFF_TOLERANCE, 0},
{218, 3316278408u, 3316277248u, 3205562368u, 0, MODFF_TOLERANCE, 0},
{219, 3455589207u, 3455589207u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{220, 3295436768u, 3295428608u, 3204382720u, 0, MODFF_TOLERANCE, 0},
{221, 1151984049u, 1151983616u, 1029210112u, 0, MODFF_TOLERANCE, 0},
{222, 1129287043u, 1129250816u, 1057850112u, 0, MODFF_TOLERANCE, 0},
{223, 1243664530u, 1243664528u, 1056964608u, 0, MODFF_TOLERANCE, 0},
{224, 972879810u, 0u, 972879810u, 0, MODFF_TOLERANCE, 0},
{225, 950829092u, 0u, 950829092u, 0, MODFF_TOLERANCE, 0},
{226, 929114193u, 0u, 929114193u, 0, MODFF_TOLERANCE, 0},
{227, 1115471979u, 1115422720u, 1044409088u, 0, MODFF_TOLERANCE, 0},
{228, 3351092088u, 3351091968u, 3211788288u, 0, MODFF_TOLERANCE, 0},
{229, 3424479544u, 3424479544u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{230, 3312047722u, 3312046080u, 3201122304u, 0, MODFF_TOLERANCE, 0},
{231, 3241193975u, 3241148416u, 3174168320u, 0, MODFF_TOLERANCE, 0},
{232, 884465785u, 0u, 884465785u, 0, MODFF_TOLERANCE, 0},
{233, 3478509398u, 3478509398u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{234, 1030934236u, 0u, 1030934236u, 0, MODFF_TOLERANCE, 0},
{235, 1045139240u, 0u, 1045139240u, 0, MODFF_TOLERANCE, 0},
{236, 3408392958u, 3408392958u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{237, 1025254314u, 0u, 1025254314u, 0, MODFF_TOLERANCE, 0},
{238, 1110545760u, 1110441984u, 1053470720u, 0, MODFF_TOLERANCE, 0},
{239, 3240144177u, 3240099840u, 3173855488u, 0, MODFF_TOLERANCE, 0},
{240, 1091496527u, 1090519040u, 1064215792u, 0, MODFF_TOLERANCE, 0},
{241, 1108793820u, 1108606976u, 1060534016u, 0, MODFF_TOLERANCE, 0},
{242, 3361976590u, 3361976576u, 3193962496u, 0, MODFF_TOLERANCE, 0},
{243, 881280146u, 0u, 881280146u, 0, MODFF_TOLERANCE, 0},
{244, 3421884736u, 3421884736u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{245, 1304154705u, 1304154705u, 0u, 0, MODFF_TOLERANCE, 0},
{246, 3264443610u, 3264348160u, 3208277248u, 0, MODFF_TOLERANCE, 0},
{247, 3222916705u, 3221225472u, 3201200904u, 0, MODFF_TOLERANCE, 0},
{248, 3374550627u, 3374550624u, 3191865344u, 0, MODFF_TOLERANCE, 0},
{249, 3365394784u, 3365394784u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{250, 899599265u, 0u, 899599265u, 0, MODFF_TOLERANCE, 0},
{251, 3240118211u, 3240099840u, 3163522560u, 0, MODFF_TOLERANCE, 0},
{252, 3452685905u, 3452685905u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{253, 1268194719u, 1268194719u, 0u, 0, MODFF_TOLERANCE, 0},
{254, 1332489410u, 1332489410u, 0u, 0, MODFF_TOLERANCE, 0},
{255, 1133420220u, 1133412352u, 1047912448u, 0, MODFF_TOLERANCE, 0},
{256, 1245770860u, 1245770860u, 0u, 0, MODFF_TOLERANCE, 0},
{257, 1161858787u, 1161854976u, 1064185856u, 0, MODFF_TOLERANCE, 0},
{258, 1263529646u, 1263529646u, 0u, 0, MODFF_TOLERANCE, 0},
{259, 3295996963u, 3295985664u, 3207629824u, 0, MODFF_TOLERANCE, 0},
{260, 3453334307u, 3453334307u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{261, 1270887389u, 1270887389u, 0u, 0, MODFF_TOLERANCE, 0},
{262, 1156123987u, 1156120576u, 1054158848u, 0, MODFF_TOLERANCE, 0},
{263, 3325193181u, 3325192192u, 3212263424u, 0, MODFF_TOLERANCE, 0},
{264, 993979179u, 0u, 993979179u, 0, MODFF_TOLERANCE, 0},
{265, 925657343u, 0u, 925657343u, 0, MODFF_TOLERANCE, 0},
{266, 1315159742u, 1315159742u, 0u, 0, MODFF_TOLERANCE, 0},
{267, 3224327456u, 3221225472u, 3208467584u, 0, MODFF_TOLERANCE, 0},
{268, 1189120494u, 1189120000u, 1064763392u, 0, MODFF_TOLERANCE, 0},
{269, 978961471u, 0u, 978961471u, 0, MODFF_TOLERANCE, 0},
{270, 889030794u, 0u, 889030794u, 0, MODFF_TOLERANCE, 0},
{271, 1323529208u, 1323529208u, 0u, 0, MODFF_TOLERANCE, 0},
{272, 940445933u, 0u, 940445933u, 0, MODFF_TOLERANCE, 0},
{273, 3465768388u, 3465768388u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{274, 3426099899u, 3426099899u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{275, 1118756120u, 1118699520u, 1054676992u, 0, MODFF_TOLERANCE, 0},
{276, 3224857113u, 3221225472u, 3210586212u, 0, MODFF_TOLERANCE, 0},
{277, 3398166843u, 3398166842u, 3204448256u, 0, MODFF_TOLERANCE, 0},
{278, 1065798296u, 1065353216u, 1029264128u, 0, MODFF_TOLERANCE, 0},
{279, 3328989444u, 3328989184u, 3196190720u, 0, MODFF_TOLERANCE, 0},
{280, 3357819026u, 3357819008u, 3197108224u, 0, MODFF_TOLERANCE, 0},
{281, 1273397670u, 1273397670u, 0u, 0, MODFF_TOLERANCE, 0},
{282, 901308750u, 0u, 901308750u, 0, MODFF_TOLERANCE, 0},
{283, 3424831780u, 3424831780u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{284, 1304806106u, 1304806106u, 0u, 0, MODFF_TOLERANCE, 0},
{285, 1257596246u, 1257596246u, 0u, 0, MODFF_TOLERANCE, 0},
{286, 3420832544u, 3420832544u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{287, 1051773536u, 0u, 1051773536u, 0, MODFF_TOLERANCE, 0},
{288, 896271348u, 0u, 896271348u, 0, MODFF_TOLERANCE, 0},
{289, 3294752507u, 3294740480u, 3208375296u, 0, MODFF_TOLERANCE, 0},
{290, 3424848725u, 3424848725u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{291, 1090870906u, 1090519040u, 1051447104u, 0, MODFF_TOLERANCE, 0},
{292, 3294742905u, 3294740480u, 3189215232u, 0, MODFF_TOLERANCE, 0},
{293, 1227582289u, 1227582288u, 1031798784u, 0, MODFF_TOLERANCE, 0},
{294, 1208979668u, 1208979648u, 1050673152u, 0, MODFF_TOLERANCE, 0},
{295, 1272325814u, 1272325814u, 0u, 0, MODFF_TOLERANCE, 0},
{296, 3359508271u, 3359508224u, 3208380416u, 0, MODFF_TOLERANCE, 0},
{297, 1137854355u, 1137836032u, 1057957376u, 0, MODFF_TOLERANCE, 0},
{298, 3335041917u, 3335041536u, 3208544256u, 0, MODFF_TOLERANCE, 0},
{299, 3440773058u, 3440773058u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{300, 3451216836u, 3451216836u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{301, 3347783723u, 3347783680u, 3198943232u, 0, MODFF_TOLERANCE, 0},
{302, 3437062994u, 3437062994u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{303, 1131196082u, 1131151360u, 1060024832u, 0, MODFF_TOLERANCE, 0},
{304, 1164573183u, 1164570624u, 1059057664u, 0, MODFF_TOLERANCE, 0},
{305, 1282436638u, 1282436638u, 0u, 0, MODFF_TOLERANCE, 0},
{306, 3258097678u, 3257925632u, 3207070592u, 0, MODFF_TOLERANCE, 0},
{307, 1305882290u, 1305882290u, 0u, 0, MODFF_TOLERANCE, 0},
{308, 3460915348u, 3460915348u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{309, 1219372260u, 1219372256u, 1040187392u, 0, MODFF_TOLERANCE, 0},
{310, 1256074626u, 1256074626u, 0u, 0, MODFF_TOLERANCE, 0},
{311, 3303035472u, 3303030784u, 3205660672u, 0, MODFF_TOLERANCE, 0},
{312, 1053698677u, 0u, 1053698677u, 0, MODFF_TOLERANCE, 0},
{313, 3284313107u, 3284303872u, 3197127680u, 0, MODFF_TOLERANCE, 0},
{314, 3396166221u, 3396166220u, 3196059648u, 0, MODFF_TOLERANCE, 0},
{315, 1201894512u, 1201894400u, 1063256064u, 0, MODFF_TOLERANCE, 0},
{316, 1085398440u, 1084227584u, 1057942848u, 0, MODFF_TOLERANCE, 0},
{317, 3458934263u, 3458934263u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{318, 1005577835u, 0u, 1005577835u, 0, MODFF_TOLERANCE, 0},
{319, 1065761827u, 1065353216u, 1028097120u, 0, MODFF_TOLERANCE, 0},
{320, 3333928591u, 3333928448u, 3197042688u, 0, MODFF_TOLERANCE, 0},
{321, 926665223u, 0u, 926665223u, 0, MODFF_TOLERANCE, 0},
{322, 3383521344u, 3383521344u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{323, 1199816046u, 1199815936u, 1062993920u, 0, MODFF_TOLERANCE, 0},
{324, 3333779015u, 3333778944u, 3188588544u, 0, MODFF_TOLERANCE, 0},
{325, 952421041u, 0u, 952421041u, 0, MODFF_TOLERANCE, 0},
{326, 948398145u, 0u, 948398145u, 0, MODFF_TOLERANCE, 0},
{327, 3238273189u, 3238002688u, 3196327072u, 0, MODFF_TOLERANCE, 0},
{328, 1270257895u, 1270257895u, 0u, 0, MODFF_TOLERANCE, 0},
{329, 1080781593u, 1077936128u, 1059957860u, 0, MODFF_TOLERANCE, 0},
{330, 1213908300u, 1213908288u, 1044381696u, 0, MODFF_TOLERANCE, 0},
{331, 1014754300u, 0u, 1014754300u, 0, MODFF_TOLERANCE, 0},
{332, 3235326590u, 3233808384u, 3208205296u, 0, MODFF_TOLERANCE, 0},
{333, 1271705594u, 1271705594u, 0u, 0, MODFF_TOLERANCE, 0},
{334, 1051802647u, 0u, 1051802647u, 0, MODFF_TOLERANCE, 0},
{335, 965378004u, 0u, 965378004u, 0, MODFF_TOLERANCE, 0},
{336, 1292594138u, 1292594138u, 0u, 0, MODFF_TOLERANCE, 0},
{337, 3226990408u, 3225419776u, 3200236096u, 0, MODFF_TOLERANCE, 0},
{338, 1110755136u, 1110704128u, 1044856832u, 0, MODFF_TOLERANCE, 0},
{339, 3293953199u, 3293937664u, 3211967488u, 0, MODFF_TOLERANCE, 0},
{340, 1122474770u, 1122369536u, 1062045952u, 0, MODFF_TOLERANCE, 0},
{341, 1283624229u, 1283624229u, 0u, 0, MODFF_TOLERANCE, 0},
{342, 906796922u, 0u, 906796922u, 0, MODFF_TOLERANCE, 0},
{343, 1163935062u, 1163931648u, 1062559744u, 0, MODFF_TOLERANCE, 0},
{344, 970649315u, 0u, 970649315u, 0, MODFF_TOLERANCE, 0},
{345, 1078286437u, 1077936128u, 1034620064u, 0, MODFF_TOLERANCE, 0},
{346, 959776291u, 0u, 959776291u, 0, MODFF_TOLERANCE, 0},
{347, 3280345347u, 3280338944u, 3192395776u, 0, MODFF_TOLERANCE, 0},
{348, 3341117305u, 3341117184u, 3203530752u, 0, MODFF_TOLERANCE, 0},
{349, 3294559023u, 3294543872u, 3211574272u, 0, MODFF_TOLERANCE, 0},
{350, 1270734970u, 1270734970u, 0u, 0, MODFF_TOLERANCE, 0},
{351, 3355874874u, 3355874816u, 3211264000u, 0, MODFF_TOLERANCE, 0},
{352, 3454816067u, 3454816067u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{353, 917206623u, 0u, 917206623u, 0, MODFF_TOLERANCE, 0},
{354, 1172710814u, 1172709376u, 1060356096u, 0, MODFF_TOLERANCE, 0},
{355, 1106502045u, 1106247680u, 1056466752u, 0, MODFF_TOLERANCE, 0},
{356, 1290849316u, 1290849316u, 0u, 0, MODFF_TOLERANCE, 0},
{357, 1157598381u, 1157595136u, 1053478912u, 0, MODFF_TOLERANCE, 0},
{358, 3309023746u, 3309023232u, 3187703808u, 0, MODFF_TOLERANCE, 0},
{359, 1092590501u, 1091567616u, 1064942160u, 0, MODFF_TOLERANCE, 0},
{360, 3335234513u, 3335234048u, 3211296768u, 0, MODFF_TOLERANCE, 0},
{361, 1002337336u, 0u, 1002337336u, 0, MODFF_TOLERANCE, 0},
{362, 1279489061u, 1279489061u, 0u, 0, MODFF_TOLERANCE, 0},
{363, 1006049444u, 0u, 1006049444u, 0, MODFF_TOLERANCE, 0},
{364, 1110992491u, 1110966272u, 1036834304u, 0, MODFF_TOLERANCE, 0},
{365, 1309984610u, 1309984610u, 0u, 0, MODFF_TOLERANCE, 0},
{366, 1165036009u, 1165033472u, 1058967552u, 0, MODFF_TOLERANCE, 0},
{367, 1233171235u, 1233171232u, 1052770304u, 0, MODFF_TOLERANCE, 0},
{368, 1148920078u, 1148911616u, 1057241088u, 0, MODFF_TOLERANCE, 0},
{369, 1007674793u, 0u, 1007674793u, 0, MODFF_TOLERANCE, 0},
{370, 3230867340u, 3229614080u, 3206085728u, 0, MODFF_TOLERANCE, 0},
{371, 1159415661u, 1159413760u, 1055760384u, 0, MODFF_TOLERANCE, 0},
{372, 1109198803u, 1109131264u, 1048832384u, 0, MODFF_TOLERANCE, 0},
{373, 1221754614u, 1221754592u, 1060110336u, 0, MODFF_TOLERANCE, 0},
{374, 3219949483u, 3212836864u, 3210284886u, 0, MODFF_TOLERANCE, 0},
{375, 1056167693u, 0u, 1056167693u, 0, MODFF_TOLERANCE, 0},
{376, 3361149474u, 3361149440u, 3204972544u, 0, MODFF_TOLERANCE, 0},
{377, 3387342069u, 3387342064u, 3206545408u, 0, MODFF_TOLERANCE, 0},
{378, 1118474231u, 1118437376u, 1049622272u, 0, MODFF_TOLERANCE, 0},
{379, 1207502108u, 1207502080u, 1046478848u, 0, MODFF_TOLERANCE, 0},
{380, 3388073586u, 3388073584u, 3196059648u, 0, MODFF_TOLERANCE, 0},
{381, 1000014431u, 0u, 1000014431u, 0, MODFF_TOLERANCE, 0},
{382, 3382954009u, 3382954008u, 3187671040u, 0, MODFF_TOLERANCE, 0},
{383, 1234530539u, 1234530536u, 1052770304u, 0, MODFF_TOLERANCE, 0},
{384, 1079988872u, 1077936128u, 1056609344u, 0, MODFF_TOLERANCE, 0},
{385, 1017843965u, 0u, 1017843965u, 0, MODFF_TOLERANCE, 0},
{386, 1193076204u, 1193075968u, 1064042496u, 0, MODFF_TOLERANCE, 0},
{387, 3248194237u, 3247964160u, 3202395968u, 0, MODFF_TOLERANCE, 0},
{388, 951862956u, 0u, 951862956u, 0, MODFF_TOLERANCE, 0},
{389, 1173464654u, 1173463040u, 1061797888u, 0, MODFF_TOLERANCE, 0},
{390, 3306328852u, 3306328064u, 3192193024u, 0, MODFF_TOLERANCE, 0},
{391, 1118701064u, 1118699520u, 1010892800u, 0, MODFF_TOLERANCE, 0},
{392, 1291910469u, 1291910469u, 0u, 0, MODFF_TOLERANCE, 0},
{393, 1211303367u, 1211303360u, 1038090240u, 0, MODFF_TOLERANCE, 0},
{394, 1173894400u, 1173893120u, 1059061760u, 0, MODFF_TOLERANCE, 0},
{395, 1131927531u, 1131872256u, 1062726400u, 0, MODFF_TOLERANCE, 0},
{396, 3449879391u, 3449879391u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{397, 991614550u, 0u, 991614550u, 0, MODFF_TOLERANCE, 0},
{398, 970094304u, 0u, 970094304u, 0, MODFF_TOLERANCE, 0},
{399, 3344590506u, 3344590336u, 3207200768u, 0, MODFF_TOLERANCE, 0},
{400, 1125551064u, 1125515264u, 1057740800u, 0, MODFF_TOLERANCE, 0},
{401, 3331248076u, 3331247616u, 3211132928u, 0, MODFF_TOLERANCE, 0},
{402, 3427296372u, 3427296372u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{403, 3455289118u, 3455289118u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{404, 1198917460u, 1198917376u, 1051197440u, 0, MODFF_TOLERANCE, 0},
{405, 1327195159u, 1327195159u, 0u, 0, MODFF_TOLERANCE, 0},
{406, 3476082461u, 3476082461u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{407, 921940707u, 0u, 921940707u, 0, MODFF_TOLERANCE, 0},
{408, 1091906532u, 1091567616u, 1051032704u, 0, MODFF_TOLERANCE, 0},
{409, 3393557778u, 3393557776u, 3204448256u, 0, MODFF_TOLERANCE, 0},
{410, 3383396815u, 3383396808u, 3210739712u, 0, MODFF_TOLERANCE, 0},
{411, 1276853215u, 1276853215u, 0u, 0, MODFF_TOLERANCE, 0},
{412, 873199561u, 0u, 873199561u, 0, MODFF_TOLERANCE, 0},
{413, 3462778440u, 3462778440u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{414, 3349284325u, 3349284224u, 3209297920u, 0, MODFF_TOLERANCE, 0},
{415, 3470358002u, 3470358002u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{416, 3360170117u, 3360170112u, 3181379584u, 0, MODFF_TOLERANCE, 0},
{417, 3224245428u, 3221225472u, 3208139472u, 0, MODFF_TOLERANCE, 0},
{418, 3271307999u, 3271294976u, 3184229376u, 0, MODFF_TOLERANCE, 0},
{419, 1120124467u, 1120010240u, 1063197056u, 0, MODFF_TOLERANCE, 0},
{420, 1135619937u, 1135607808u, 1052607488u, 0, MODFF_TOLERANCE, 0},
{421, 1064364381u, 0u, 1064364381u, 0, MODFF_TOLERANCE, 0},
{422, 1268744779u, 1268744779u, 0u, 0, MODFF_TOLERANCE, 0},
{423, 3328452652u, 3328452608u, 3174039552u, 0, MODFF_TOLERANCE, 0},
{424, 1165195428u, 1165193216u, 1057636352u, 0, MODFF_TOLERANCE, 0},
{425, 3390323168u, 3390323168u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{426, 1106497311u, 1106247680u, 1056163776u, 0, MODFF_TOLERANCE, 0},
{427, 1278465842u, 1278465842u, 0u, 0, MODFF_TOLERANCE, 0},
{428, 3247790039u, 3247439872u, 3207264992u, 0, MODFF_TOLERANCE, 0},
{429, 909788142u, 0u, 909788142u, 0, MODFF_TOLERANCE, 0},
{430, 3215244648u, 3212836864u, 3197302176u, 0, MODFF_TOLERANCE, 0},
{431, 1083988595u, 1082130432u, 1063441304u, 0, MODFF_TOLERANCE, 0},
{432, 989153382u, 0u, 989153382u, 0, MODFF_TOLERANCE, 0},
{433, 1117455718u, 1117388800u, 1057141504u, 0, MODFF_TOLERANCE, 0},
{434, 1061714285u, 0u, 1061714285u, 0, MODFF_TOLERANCE, 0},
{435, 1212717473u, 1212717440u, 1057226752u, 0, MODFF_TOLERANCE, 0},
{436, 3275973009u, 3275948032u, 3200459264u, 0, MODFF_TOLERANCE, 0},
{437, 3450721670u, 3450721670u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{438, 3391162308u, 3391162308u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{439, 1291220039u, 1291220039u, 0u, 0, MODFF_TOLERANCE, 0},
{440, 1044867873u, 0u, 1044867873u, 0, MODFF_TOLERANCE, 0},
{441, 3369493273u, 3369493248u, 3209166848u, 0, MODFF_TOLERANCE, 0},
{442, 1089986803u, 1088421888u, 1061095320u, 0, MODFF_TOLERANCE, 0},
{443, 3462160118u, 3462160118u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{444, 1296314700u, 1296314700u, 0u, 0, MODFF_TOLERANCE, 0},
{445, 1251462432u, 1251462432u, 0u, 0, MODFF_TOLERANCE, 0},
{446, 3485236902u, 3485236902u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{447, 980772835u, 0u, 980772835u, 0, MODFF_TOLERANCE, 0},
{448, 3262169538u, 3262119936u, 3191980544u, 0, MODFF_TOLERANCE, 0},
{449, 1268270462u, 1268270462u, 0u, 0, MODFF_TOLERANCE, 0},
{450, 994641495u, 0u, 994641495u, 0, MODFF_TOLERANCE, 0},
{451, 1022211242u, 0u, 1022211242u, 0, MODFF_TOLERANCE, 0},
{452, 922124181u, 0u, 922124181u, 0, MODFF_TOLERANCE, 0},
{453, 884661176u, 0u, 884661176u, 0, MODFF_TOLERANCE, 0},
{454, 3271100396u, 3271032832u, 3204707840u, 0, MODFF_TOLERANCE, 0},
{455, 989762529u, 0u, 989762529u, 0, MODFF_TOLERANCE, 0},
{456, 3362011135u, 3362011072u, 3212574720u, 0, MODFF_TOLERANCE, 0},
{457, 1295475718u, 1295475718u, 0u, 0, MODFF_TOLERANCE, 0},
{458, 1002632518u, 0u, 1002632518u, 0, MODFF_TOLERANCE, 0},
{459, 3330388441u, 3330387968u, 3211558912u, 0, MODFF_TOLERANCE, 0},
{460, 3404372005u, 3404372004u, 3204448256u, 0, MODFF_TOLERANCE, 0},
{461, 3450484255u, 3450484255u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{462, 1218447414u, 1218447392u, 1060110336u, 0, MODFF_TOLERANCE, 0},
{463, 1125800069u, 1125777408u, 1051789824u, 0, MODFF_TOLERANCE, 0},
{464, 3256265749u, 3256090624u, 3207267648u, 0, MODFF_TOLERANCE, 0},
{465, 1300246663u, 1300246663u, 0u, 0, MODFF_TOLERANCE, 0},
{466, 999985470u, 0u, 999985470u, 0, MODFF_TOLERANCE, 0},
{467, 3409354318u, 3409354318u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{468, 1189421739u, 1189421568u, 1051394048u, 0, MODFF_TOLERANCE, 0},
{469, 1056599002u, 0u, 1056599002u, 0, MODFF_TOLERANCE, 0},
{470, 3391513557u, 3391513556u, 3196059648u, 0, MODFF_TOLERANCE, 0},
{471, 3467473756u, 3467473756u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{472, 3444521949u, 3444521949u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{473, 1164046161u, 1164042240u, 1064636416u, 0, MODFF_TOLERANCE, 0},
{474, 3440635788u, 3440635788u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{475, 1292596266u, 1292596266u, 0u, 0, MODFF_TOLERANCE, 0},
{476, 3469748379u, 3469748379u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{477, 3412765608u, 3412765608u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{478, 1314644642u, 1314644642u, 0u, 0, MODFF_TOLERANCE, 0},
{479, 3399813173u, 3399813172u, 3204448256u, 0, MODFF_TOLERANCE, 0},
{480, 948775569u, 0u, 948775569u, 0, MODFF_TOLERANCE, 0},
{481, 3485444126u, 3485444126u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{482, 1034611395u, 0u, 1034611395u, 0, MODFF_TOLERANCE, 0},
{483, 882288581u, 0u, 882288581u, 0, MODFF_TOLERANCE, 0},
{484, 3489122735u, 3489122735u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{485, 3372450889u, 3372450880u, 3205496832u, 0, MODFF_TOLERANCE, 0},
{486, 1181604787u, 1181603840u, 1064091648u, 0, MODFF_TOLERANCE, 0},
{487, 3363067409u, 3363067392u, 3196583936u, 0, MODFF_TOLERANCE, 0},
{488, 1043691622u, 0u, 1043691622u, 0, MODFF_TOLERANCE, 0},
{489, 3402603223u, 3402603222u, 3204448256u, 0, MODFF_TOLERANCE, 0},
{490, 1314588083u, 1314588083u, 0u, 0, MODFF_TOLERANCE, 0},
{491, 3442525943u, 3442525943u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{492, 3451674717u, 3451674717u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{493, 3400949680u, 3400949680u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{494, 3365581801u, 3365581792u, 3197108224u, 0, MODFF_TOLERANCE, 0},
{495, 1175843167u, 1175842816u, 1051688960u, 0, MODFF_TOLERANCE, 0},
{496, 1110424755u, 1110179840u, 1064250560u, 0, MODFF_TOLERANCE, 0},
{497, 927278934u, 0u, 927278934u, 0, MODFF_TOLERANCE, 0},
{498, 969804941u, 0u, 969804941u, 0, MODFF_TOLERANCE, 0},
{499, 3355439348u, 3355439232u, 3211264000u, 0, MODFF_TOLERANCE, 0},
{500, 1139120919u, 1139113984u, 1046001664u, 0, MODFF_TOLERANCE, 0},
{501, 3270515074u, 3270508544u, 3175878656u, 0, MODFF_TOLERANCE, 0},
{502, 3325199970u, 3325199360u, 3206053888u, 0, MODFF_TOLERANCE, 0},
{503, 934308144u, 0u, 934308144u, 0, MODFF_TOLERANCE, 0},
{504, 1220524226u, 1220524224u, 1031798784u, 0, MODFF_TOLERANCE, 0},
{505, 1152648002u, 1152647168u, 1037074432u, 0, MODFF_TOLERANCE, 0},
{506, 3461790298u, 3461790298u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{507, 3382391700u, 3382391696u, 3204448256u, 0, MODFF_TOLERANCE, 0},
{508, 3296962745u, 3296960512u, 3196817408u, 0, MODFF_TOLERANCE, 0},
{509, 1156767533u, 1156759552u, 1064921088u, 0, MODFF_TOLERANCE, 0},
{510, 1088986462u, 1088421888u, 1049220576u, 0, MODFF_TOLERANCE, 0},
{511, 3312324949u, 3312324608u, 3182067712u, 0, MODFF_TOLERANCE, 0},
{512, 994934087u, 0u, 994934087u, 0, MODFF_TOLERANCE, 0},
{513, 967678094u, 0u, 967678094u, 0, MODFF_TOLERANCE, 0},
{514, 1123403720u, 1123287040u, 1063511040u, 0, MODFF_TOLERANCE, 0},
{515, 1093936408u, 1093664768u, 1048879872u, 0, MODFF_TOLERANCE, 0},
{516, 3287317742u, 3287285760u, 3212434432u, 0, MODFF_TOLERANCE, 0},
{517, 3479873563u, 3479873563u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{518, 1246277393u, 1246277392u, 1048576000u, 0, MODFF_TOLERANCE, 0},
{519, 3424264117u, 3424264117u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{520, 3434026174u, 3434026174u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{521, 3228365887u, 3225419776u, 3207844092u, 0, MODFF_TOLERANCE, 0},
{522, 1216775310u, 1216775296u, 1054867456u, 0, MODFF_TOLERANCE, 0},
{523, 1035909900u, 0u, 1035909900u, 0, MODFF_TOLERANCE, 0},
{524, 1249532942u, 1249532940u, 1056964608u, 0, MODFF_TOLERANCE, 0},
{525, 1274271338u, 1274271338u, 0u, 0, MODFF_TOLERANCE, 0},
{526, 1247632131u, 1247632128u, 1061158912u, 0, MODFF_TOLERANCE, 0},
{527, 1212129651u, 1212129600u, 1061945344u, 0, MODFF_TOLERANCE, 0},
{528, 955826310u, 0u, 955826310u, 0, MODFF_TOLERANCE, 0},
{529, 1037464105u, 0u, 1037464105u, 0, MODFF_TOLERANCE, 0},
{530, 1311706596u, 1311706596u, 0u, 0, MODFF_TOLERANCE, 0},
{531, 1254918706u, 1254918706u, 0u, 0, MODFF_TOLERANCE, 0},
{532, 918212457u, 0u, 918212457u, 0, MODFF_TOLERANCE, 0},
{533, 1017468331u, 0u, 1017468331u, 0, MODFF_TOLERANCE, 0},
{534, 1337315179u, 1337315179u, 0u, 0, MODFF_TOLERANCE, 0},
{535, 3461361185u, 3461361185u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{536, 1131358407u, 1131347968u, 1042488320u, 0, MODFF_TOLERANCE, 0},
{537, 3325958870u, 3325958144u, 3207954432u, 0, MODFF_TOLERANCE, 0},
{538, 1156517523u, 1156513792u, 1055469568u, 0, MODFF_TOLERANCE, 0},
{539, 3343716230u, 3343716096u, 3204841472u, 0, MODFF_TOLERANCE, 0},
{540, 3337499209u, 3337499136u, 3188850688u, 0, MODFF_TOLERANCE, 0},
{541, 1226297264u, 1226297264u, 0u, 0, MODFF_TOLERANCE, 0},
{542, 3468429030u, 3468429030u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{543, 3253874001u, 3253731328u, 3196802112u, 0, MODFF_TOLERANCE, 0},
{544, 3253515800u, 3253207040u, 3205939968u, 0, MODFF_TOLERANCE, 0},
{545, 1189005947u, 1189005824u, 1047920640u, 0, MODFF_TOLERANCE, 0},
{546, 959956547u, 0u, 959956547u, 0, MODFF_TOLERANCE, 0},
{547, 876324728u, 0u, 876324728u, 0, MODFF_TOLERANCE, 0},
{548, 3425290480u, 3425290480u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{549, 1139193797u, 1139179520u, 1054807040u, 0, MODFF_TOLERANCE, 0},
{550, 1039917375u, 0u, 1039917375u, 0, MODFF_TOLERANCE, 0},
{551, 1122740999u, 1122631680u, 1062568832u, 0, MODFF_TOLERANCE, 0},
{552, 3220979495u, 3212836864u, 3212344910u, 0, MODFF_TOLERANCE, 0},
{553, 3429223871u, 3429223871u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{554, 1311016004u, 1311016004u, 0u, 0, MODFF_TOLERANCE, 0},
{555, 3334899880u, 3334899712u, 3198681088u, 0, MODFF_TOLERANCE, 0},
{556, 1128016396u, 1128005632u, 1042821120u, 0, MODFF_TOLERANCE, 0},
{557, 1105151547u, 1104674816u, 1063831392u, 0, MODFF_TOLERANCE, 0},
{558, 3404762495u, 3404762494u, 3204448256u, 0, MODFF_TOLERANCE, 0},
{559, 1206054701u, 1206054656u, 1051983872u, 0, MODFF_TOLERANCE, 0},
{560, 1162227076u, 1162223616u, 1062748160u, 0, MODFF_TOLERANCE, 0},
{561, 970745811u, 0u, 970745811u, 0, MODFF_TOLERANCE, 0},
{562, 3313826904u, 3313825792u, 3205169152u, 0, MODFF_TOLERANCE, 0},
{563, 1213609983u, 1213609920u, 1065091072u, 0, MODFF_TOLERANCE, 0},
{564, 919983950u, 0u, 919983950u, 0, MODFF_TOLERANCE, 0},
{565, 1246902946u, 1246902944u, 1056964608u, 0, MODFF_TOLERANCE, 0},
{566, 995850843u, 0u, 995850843u, 0, MODFF_TOLERANCE, 0},
{567, 1332031130u, 1332031130u, 0u, 0, MODFF_TOLERANCE, 0},
{568, 3362082828u, 3362082816u, 3191865344u, 0, MODFF_TOLERANCE, 0},
{569, 3374056268u, 3374056256u, 3208642560u, 0, MODFF_TOLERANCE, 0},
{570, 1029480631u, 0u, 1029480631u, 0, MODFF_TOLERANCE, 0},
{571, 3384988527u, 3384988520u, 3210739712u, 0, MODFF_TOLERANCE, 0},
{572, 1317696241u, 1317696241u, 0u, 0, MODFF_TOLERANCE, 0},
{573, 3235395924u, 3233808384u, 3208759968u, 0, MODFF_TOLERANCE, 0},
{574, 1132055244u, 1132003328u, 1061866496u, 0, MODFF_TOLERANCE, 0},
{575, 3341877624u, 3341877504u, 3203399680u, 0, MODFF_TOLERANCE, 0},
{576, 1228636133u, 1228636128u, 1050673152u, 0, MODFF_TOLERANCE, 0},
{577, 886552820u, 0u, 886552820u, 0, MODFF_TOLERANCE, 0},
{578, 3335899347u, 3335899136u, 3201499136u, 0, MODFF_TOLERANCE, 0},
{579, 3307203982u, 3307200512u, 3210272768u, 0, MODFF_TOLERANCE, 0},
{580, 1207246237u, 1207246208u, 1047003136u, 0, MODFF_TOLERANCE, 0},
{581, 1165476654u, 1165475840u, 1045135360u, 0, MODFF_TOLERANCE, 0},
{582, 3350219111u, 3350219008u, 3209560064u, 0, MODFF_TOLERANCE, 0},
{583, 1215278023u, 1215278016u, 1038090240u, 0, MODFF_TOLERANCE, 0},
{584, 1017239798u, 0u, 1017239798u, 0, MODFF_TOLERANCE, 0},
{585, 3438501281u, 3438501281u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{586, 1149651309u, 1149648896u, 1050071040u, 0, MODFF_TOLERANCE, 0},
{587, 970030475u, 0u, 970030475u, 0, MODFF_TOLERANCE, 0},
{588, 1111943722u, 1111752704u, 1060801152u, 0, MODFF_TOLERANCE, 0},
{589, 1158358450u, 1158356992u, 1052131328u, 0, MODFF_TOLERANCE, 0},
{590, 1189849849u, 1189849600u, 1056505856u, 0, MODFF_TOLERANCE, 0},
{591, 3382739134u, 3382739128u, 3208642560u, 0, MODFF_TOLERANCE, 0},
{592, 1249758327u, 1249758324u, 1061158912u, 0, MODFF_TOLERANCE, 0},
{593, 3445282331u, 3445282331u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{594, 1168098747u, 1168097280u, 1060593664u, 0, MODFF_TOLERANCE, 0},
{595, 1316854744u, 1316854744u, 0u, 0, MODFF_TOLERANCE, 0},
{596, 892549317u, 0u, 892549317u, 0, MODFF_TOLERANCE, 0},
{597, 1179637545u, 1179636736u, 1061830656u, 0, MODFF_TOLERANCE, 0},
{598, 3301009024u, 3301007360u, 3192913920u, 0, MODFF_TOLERANCE, 0},
{599, 3406174560u, 3406174560u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{600, 3233089227u, 3231711232u, 3207083608u, 0, MODFF_TOLERANCE, 0},
{601, 1212652543u, 1212652480u, 1065091072u, 0, MODFF_TOLERANCE, 0},
{602, 3218245284u, 3212836864u, 3206876488u, 0, MODFF_TOLERANCE, 0},
{603, 1238873830u, 1238873824u, 1061158912u, 0, MODFF_TOLERANCE, 0},
{604, 3215981890u, 3212836864u, 3200251144u, 0, MODFF_TOLERANCE, 0},
{605, 3240474694u, 3240099840u, 3199666368u, 0, MODFF_TOLERANCE, 0},
{606, 1266687209u, 1266687209u, 0u, 0, MODFF_TOLERANCE, 0},
{607, 3410090781u, 3410090781u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{608, 3487959775u, 3487959775u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{609, 3331372071u, 3331372032u, 3181117440u, 0, MODFF_TOLERANCE, 0},
{610, 943645710u, 0u, 943645710u, 0, MODFF_TOLERANCE, 0},
{611, 3345065699u, 3345065472u, 3210936320u, 0, MODFF_TOLERANCE, 0},
{612, 3282620725u, 3282599936u, 3206703616u, 0, MODFF_TOLERANCE, 0},
{613, 935847271u, 0u, 935847271u, 0, MODFF_TOLERANCE, 0},
{614, 1067255804u, 1065353216u, 1047019488u, 0, MODFF_TOLERANCE, 0},
{615, 3410336089u, 3410336089u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{616, 1111437780u, 1111228416u, 1061975296u, 0, MODFF_TOLERANCE, 0},
{617, 1336840432u, 1336840432u, 0u, 0, MODFF_TOLERANCE, 0},
{618, 1141063391u, 1141047296u, 1065057280u, 0, MODFF_TOLERANCE, 0},
{619, 1168908072u, 1168906240u, 1063583744u, 0, MODFF_TOLERANCE, 0},
{620, 3289799763u, 3289792512u, 3202521088u, 0, MODFF_TOLERANCE, 0},
{621, 3353679791u, 3353679744u, 3199991808u, 0, MODFF_TOLERANCE, 0},
{622, 897158391u, 0u, 897158391u, 0, MODFF_TOLERANCE, 0},
{623, 1001823878u, 0u, 1001823878u, 0, MODFF_TOLERANCE, 0},
{624, 1016826861u, 0u, 1016826861u, 0, MODFF_TOLERANCE, 0},
{625, 1009130212u, 0u, 1009130212u, 0, MODFF_TOLERANCE, 0},
{626, 1004302940u, 0u, 1004302940u, 0, MODFF_TOLERANCE, 0},
{627, 3367127535u, 3367127520u, 3203399680u, 0, MODFF_TOLERANCE, 0},
{628, 943136342u, 0u, 943136342u, 0, MODFF_TOLERANCE, 0},
{629, 1032920919u, 0u, 1032920919u, 0, MODFF_TOLERANCE, 0},
{630, 3449126417u, 3449126417u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{631, 3281952870u, 3281944576u, 3196164096u, 0, MODFF_TOLERANCE, 0},
{632, 1237868497u, 1237868496u, 1040187392u, 0, MODFF_TOLERANCE, 0},
{633, 1153753924u, 1153753088u, 1037107200u, 0, MODFF_TOLERANCE, 0},
{634, 3322269242u, 3322268672u, 3205398528u, 0, MODFF_TOLERANCE, 0},
{635, 1120261759u, 1120141312u, 1063993216u, 0, MODFF_TOLERANCE, 0},
{636, 892210998u, 0u, 892210998u, 0, MODFF_TOLERANCE, 0},
{637, 3226328360u, 3225419776u, 3193819776u, 0, MODFF_TOLERANCE, 0},
{638, 3366432856u, 3366432832u, 3208642560u, 0, MODFF_TOLERANCE, 0},
{639, 3349595986u, 3349595904u, 3206807552u, 0, MODFF_TOLERANCE, 0},
{640, 3251588707u, 3251109888u, 3211381856u, 0, MODFF_TOLERANCE, 0},
{641, 3306023523u, 3306020864u, 3206950912u, 0, MODFF_TOLERANCE, 0},
{642, 1087750238u, 1086324736u, 1059980016u, 0, MODFF_TOLERANCE, 0},
{643, 1099325523u, 1098907648u, 1061948000u, 0, MODFF_TOLERANCE, 0},
{644, 3359488363u, 3359488320u, 3207331840u, 0, MODFF_TOLERANCE, 0},
{645, 1066116543u, 1065353216u, 1035623408u, 0, MODFF_TOLERANCE, 0},
{646, 3364074347u, 3364074336u, 3199205376u, 0, MODFF_TOLERANCE, 0},
{647, 1030612298u, 0u, 1030612298u, 0, MODFF_TOLERANCE, 0},
{648, 3345396001u, 3345395968u, 3187933184u, 0, MODFF_TOLERANCE, 0},
{649, 989161453u, 0u, 989161453u, 0, MODFF_TOLERANCE, 0},
{650, 1186234578u, 1186234368u, 1053949952u, 0, MODFF_TOLERANCE, 0},
{651, 1331680743u, 1331680743u, 0u, 0, MODFF_TOLERANCE, 0},
{652, 1009396165u, 0u, 1009396165u, 0, MODFF_TOLERANCE, 0},
{653, 894661023u, 0u, 894661023u, 0, MODFF_TOLERANCE, 0},
{654, 1326067357u, 1326067357u, 0u, 0, MODFF_TOLERANCE, 0},
{655, 887589411u, 0u, 887589411u, 0, MODFF_TOLERANCE, 0},
{656, 1292305693u, 1292305693u, 0u, 0, MODFF_TOLERANCE, 0},
{657, 1045232522u, 0u, 1045232522u, 0, MODFF_TOLERANCE, 0},
{658, 3234993273u, 3233808384u, 3205538760u, 0, MODFF_TOLERANCE, 0},
{659, 962515365u, 0u, 962515365u, 0, MODFF_TOLERANCE, 0},
{660, 3349432725u, 3349432704u, 3190292480u, 0, MODFF_TOLERANCE, 0},
{661, 928848003u, 0u, 928848003u, 0, MODFF_TOLERANCE, 0},
{662, 912423027u, 0u, 912423027u, 0, MODFF_TOLERANCE, 0},
{663, 3228795133u, 3225419776u, 3209561076u, 0, MODFF_TOLERANCE, 0},
{664, 3273940030u, 3273916416u, 3199761408u, 0, MODFF_TOLERANCE, 0},
{665, 3296784303u, 3296780288u, 3204116480u, 0, MODFF_TOLERANCE, 0},
{666, 3276182352u, 3276144640u, 3205713920u, 0, MODFF_TOLERANCE, 0},
{667, 965402291u, 0u, 965402291u, 0, MODFF_TOLERANCE, 0},
{668, 3388153589u, 3388153584u, 3206545408u, 0, MODFF_TOLERANCE, 0},
{669, 3426245389u, 3426245389u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{670, 1133410485u, 1133379584u, 1064397312u, 0, MODFF_TOLERANCE, 0},
{671, 3329658993u, 3329658880u, 3185704960u, 0, MODFF_TOLERANCE, 0},
{672, 1088652637u, 1088421888u, 1038178112u, 0, MODFF_TOLERANCE, 0},
{673, 3369970587u, 3369970560u, 3210215424u, 0, MODFF_TOLERANCE, 0},
{674, 959121458u, 0u, 959121458u, 0, MODFF_TOLERANCE, 0},
{675, 1270451568u, 1270451568u, 0u, 0, MODFF_TOLERANCE, 0},
{676, 928393353u, 0u, 928393353u, 0, MODFF_TOLERANCE, 0},
{677, 989498922u, 0u, 989498922u, 0, MODFF_TOLERANCE, 0},
{678, 1280215674u, 1280215674u, 0u, 0, MODFF_TOLERANCE, 0},
{679, 1171873518u, 1171871744u, 1063108608u, 0, MODFF_TOLERANCE, 0},
{680, 954709738u, 0u, 954709738u, 0, MODFF_TOLERANCE, 0},
{681, 3298258100u, 3298254848u, 3200991232u, 0, MODFF_TOLERANCE, 0},
{682, 935525182u, 0u, 935525182u, 0, MODFF_TOLERANCE, 0},
{683, 3415208824u, 3415208824u, 2147483648u, 0, MODFF_TOLERANCE, 0},
{684, 1001897182u, 0u, 1001897182u, 0, MODFF_TOLERANCE, 0},
{685, 3245830463u, 3245342720u, 3203278816u, 0, MODFF_TOLERANCE, 0},
{686, 985903305u, 0u, 985903305u, 0, MODFF_TOLERANCE, 0},
{687, 3333087577u, 3333087232u, 3207364608u, 0, MODFF_TOLERANCE, 0},
{688, 3357328848u, 3357328832u, 3196059648u, 0, MODFF_TOLERANCE, 0},
{689, 982612185u, 0u, 982612185u, 0, MODFF_TOLERANCE, 0},
{690, 923582663u, 0u, 923582663u, 0, MODFF_TOLERANCE, 0},
{691, 3267868136u, 3267756032u, 3210408960u, 0, MODFF_TOLERANCE, 0},
{692, 1208301947u, 1208301888u, 1064042496u, 0, MODFF_TOLERANCE, 0},
{693, 3319048157u, 3319046144u, 3212550144u, 0, MODFF_TOLERANCE, 0},
{694, 1172271145u, 1172271104u, 1017380864u, 0, MODFF_TOLERANCE, 0},
{695, 1144755661u, 1144750080u, 1051617280u, 0, MODFF_TOLERANCE, 0},
{696, 1051585760u, 0u, 1051585760u, 0, MODFF_TOLERANCE, 0},
{697, 898467286u, 0u, 898467286u, 0, MODFF_TOLERANCE, 0}

// AUTOMATICALLY GENERATED VECTORS STOP

};

#endif // CYGONCE_LIBM_MODFF_H multiple inclusion protection

// EOF modff.h
