#ifndef CYGONCE_LIBM_LOG_H
#define CYGONCE_LIBM_LOG_H
//===========================================================================
//
//      log.h
//
//      Test vectors for testing of log() math library function
//
//===========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####
// -------------------------------------------
// This file is part of eCos, the Embedded Configurable Operating System.
// Copyright (C) 2012 Free Software Foundation, Inc.
//
// eCos is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 or (at your option) any later
// version.
//
// eCos is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
// for more details.
//
// You should have received a copy of the GNU General Public License
// along with eCos; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//
// As a special exception, if other files instantiate templates or use
// macros or inline functions from this file, or you compile this file
// and link it with other works to produce a work based on this file,
// this file does not by itself cause the resulting work to be covered by
// the GNU General Public License. However the source code for this file
// must still be made available in accordance with section (3) of the GNU
// General Public License v2.
//
// This exception does not invalidate any other reasons why a work based
// on this file might be covered by the GNU General Public License.
// -------------------------------------------
// ####ECOSGPLCOPYRIGHTEND####
//===========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):
// Contributors:  visar, ilijak
// Date:        1998-02-13
// Purpose:
// Description:
// Usage:       #include "vectors/log.h"
//
//####DESCRIPTIONEND####
//
//===========================================================================


// CONFIGURATION

#include <pkgconf/libm.h>   // Configuration header


// INCLUDES

#include <cyg/infra/cyg_type.h>    // Common type definitions and support
#include "vectors/vector_support_float.h"// extra support for math tests

#define LOG_TOLERANCE 1.0E-04

static const Cyg_libm_test_float_vec_t logf_vec[] = {

// AUTOMATICALLY GENERATED VECTORS START
{0, 3214514586u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{1, 3214430700u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{2, 3214346813u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{3, 3214262927u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{4, 3214179041u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{5, 3214095155u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{6, 3214011269u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{7, 3213927383u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{8, 3213843497u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{9, 3213759611u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{10, 3213675725u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{11, 3213591839u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{12, 3213507953u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{13, 3213424067u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{14, 3213340180u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{15, 3213256294u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{16, 3213172408u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{17, 3213088522u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{18, 3213004636u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{19, 3212920750u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{20, 3212836864u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{21, 3212669092u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{22, 3212501320u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{23, 3212333548u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{24, 3212165775u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{25, 3211998003u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{26, 3211830231u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{27, 3211662459u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{28, 3211494687u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{29, 3211326915u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{30, 3211159142u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{31, 3210991370u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{32, 3210823598u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{33, 3210655826u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{34, 3210488054u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{35, 3210320282u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{36, 3210152509u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{37, 3209984737u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{38, 3209816965u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{39, 3209649193u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{40, 3209481421u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{41, 3209313649u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{42, 3209145876u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{43, 3208978104u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{44, 3208810332u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{45, 3208642560u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{46, 3208474788u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{47, 3208307016u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{48, 3208139244u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{49, 3207971471u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{50, 3207803699u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{51, 3207635927u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{52, 3207468155u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{53, 3207300383u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{54, 3207132611u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{55, 3206964838u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{56, 3206797066u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{57, 3206629294u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{58, 3206461522u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{59, 3206293750u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{60, 3206125978u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{61, 3205958205u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{62, 3205790433u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{63, 3205622661u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{64, 3205454889u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{65, 3205287117u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{66, 3205119345u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{67, 3204951572u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{68, 3204783800u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{69, 3204616028u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{70, 3204448256u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{71, 3204112712u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{72, 3203777167u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{73, 3203441623u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{74, 3203106079u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{75, 3202770534u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{76, 3202434990u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{77, 3202099446u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{78, 3201763901u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{79, 3201428357u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{80, 3201092813u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{81, 3200757268u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{82, 3200421724u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{83, 3200086180u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{84, 3199750636u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{85, 3199415091u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{86, 3199079547u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{87, 3198744003u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{88, 3198408458u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{89, 3198072914u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{90, 3197737370u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{91, 3197401825u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{92, 3197066281u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{93, 3196730737u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{94, 3196395192u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{95, 3196059648u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{96, 3195388559u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{97, 3194717471u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{98, 3194046382u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{99, 3193375293u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{100, 3192704205u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{101, 3192033116u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{102, 3191362028u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{103, 3190690939u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{104, 3190019850u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{105, 3189348762u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{106, 3188677673u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{107, 3188006584u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{108, 3186999951u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{109, 3185657774u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{110, 3184315597u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{111, 3182973420u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{112, 3181631242u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{113, 3180289065u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{114, 3178611343u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{115, 3175926989u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{116, 3173242634u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{117, 3170222735u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{118, 3164854026u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{119, 3156465418u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{120, 646742016u, 3255452089u, 3255452089u, 0, LOG_TOLERANCE, 0},
{121, 1008981770u, 3230883214u, 3230883214u, 0, LOG_TOLERANCE, 0},
{122, 1017370378u, 3229245078u, 3229245078u, 0, LOG_TOLERANCE, 0},
{123, 1022739087u, 3227544434u, 3227544434u, 0, LOG_TOLERANCE, 0},
{124, 1025758986u, 3226337808u, 3226337808u, 0, LOG_TOLERANCE, 0},
{125, 1028443341u, 3225401876u, 3225401876u, 0, LOG_TOLERANCE, 0},
{126, 1031127695u, 3224637164u, 3224637164u, 0, LOG_TOLERANCE, 0},
{127, 1032805417u, 3223990609u, 3223990609u, 0, LOG_TOLERANCE, 0},
{128, 1034147594u, 3223430538u, 3223430538u, 0, LOG_TOLERANCE, 0},
{129, 1035489772u, 3222936520u, 3222936520u, 0, LOG_TOLERANCE, 0},
{130, 1036831949u, 3222494606u, 3222494606u, 0, LOG_TOLERANCE, 0},
{131, 1038174126u, 3222094846u, 3222094846u, 0, LOG_TOLERANCE, 0},
{132, 1039516303u, 3221729894u, 3221729894u, 0, LOG_TOLERANCE, 0},
{133, 1040522936u, 3221394171u, 3221394171u, 0, LOG_TOLERANCE, 0},
{134, 1041194025u, 3220941206u, 3220941206u, 0, LOG_TOLERANCE, 0},
{135, 1041865114u, 3220362452u, 3220362452u, 0, LOG_TOLERANCE, 0},
{136, 1042536202u, 3219821064u, 3219821064u, 0, LOG_TOLERANCE, 0},
{137, 1043207291u, 3219312507u, 3219312507u, 0, LOG_TOLERANCE, 0},
{138, 1043878380u, 3218833027u, 3218833027u, 0, LOG_TOLERANCE, 0},
{139, 1044549468u, 3218379479u, 3218379479u, 0, LOG_TOLERANCE, 0},
{140, 1045220557u, 3217949200u, 3217949200u, 0, LOG_TOLERANCE, 0},
{141, 1045891645u, 3217539918u, 3217539918u, 0, LOG_TOLERANCE, 0},
{142, 1046562734u, 3217149680u, 3217149680u, 0, LOG_TOLERANCE, 0},
{143, 1047233823u, 3216776791u, 3216776791u, 0, LOG_TOLERANCE, 0},
{144, 1047904911u, 3216419776u, 3216419776u, 0, LOG_TOLERANCE, 0},
{145, 1048576000u, 3216077336u, 3216077336u, 0, LOG_TOLERANCE, 0},
{146, 1048911544u, 3215748329u, 3215748329u, 0, LOG_TOLERANCE, 0},
{147, 1049247089u, 3215431740u, 3215431740u, 0, LOG_TOLERANCE, 0},
{148, 1049582633u, 3215126666u, 3215126666u, 0, LOG_TOLERANCE, 0},
{149, 1049918177u, 3214832299u, 3214832299u, 0, LOG_TOLERANCE, 0},
{150, 1050253722u, 3214547912u, 3214547912u, 0, LOG_TOLERANCE, 0},
{151, 1050589266u, 3214272851u, 3214272851u, 0, LOG_TOLERANCE, 0},
{152, 1050924810u, 3214006524u, 3214006524u, 0, LOG_TOLERANCE, 0},
{153, 1051260355u, 3213748392u, 3213748392u, 0, LOG_TOLERANCE, 0},
{154, 1051595899u, 3213497967u, 3213497967u, 0, LOG_TOLERANCE, 0},
{155, 1051931443u, 3213254802u, 3213254802u, 0, LOG_TOLERANCE, 0},
{156, 1052266988u, 3213018487u, 3213018487u, 0, LOG_TOLERANCE, 0},
{157, 1052602532u, 3212740433u, 3212740433u, 0, LOG_TOLERANCE, 0},
{158, 1052938076u, 3212293014u, 3212293014u, 0, LOG_TOLERANCE, 0},
{159, 1053273620u, 3211857218u, 3211857218u, 0, LOG_TOLERANCE, 0},
{160, 1053609165u, 3211432455u, 3211432455u, 0, LOG_TOLERANCE, 0},
{161, 1053944709u, 3211018182u, 3211018182u, 0, LOG_TOLERANCE, 0},
{162, 1054280253u, 3210613893u, 3210613893u, 0, LOG_TOLERANCE, 0},
{163, 1054615798u, 3210219116u, 3210219116u, 0, LOG_TOLERANCE, 0},
{164, 1054951342u, 3209833416u, 3209833416u, 0, LOG_TOLERANCE, 0},
{165, 1055286886u, 3209456384u, 3209456384u, 0, LOG_TOLERANCE, 0},
{166, 1055622431u, 3209087639u, 3209087639u, 0, LOG_TOLERANCE, 0},
{167, 1055957975u, 3208726825u, 3208726825u, 0, LOG_TOLERANCE, 0},
{168, 1056293519u, 3208373608u, 3208373608u, 0, LOG_TOLERANCE, 0},
{169, 1056629064u, 3208027673u, 3208027673u, 0, LOG_TOLERANCE, 0},
{170, 1056964608u, 3207688728u, 3207688728u, 0, LOG_TOLERANCE, 0},
{171, 1057132380u, 3207356495u, 3207356495u, 0, LOG_TOLERANCE, 0},
{172, 1057300152u, 3207030714u, 3207030714u, 0, LOG_TOLERANCE, 0},
{173, 1057467924u, 3206711139u, 3206711139u, 0, LOG_TOLERANCE, 0},
{174, 1057635697u, 3206397535u, 3206397535u, 0, LOG_TOLERANCE, 0},
{175, 1057803469u, 3206089688u, 3206089688u, 0, LOG_TOLERANCE, 0},
{176, 1057971241u, 3205787388u, 3205787388u, 0, LOG_TOLERANCE, 0},
{177, 1058139013u, 3205490438u, 3205490438u, 0, LOG_TOLERANCE, 0},
{178, 1058306785u, 3205198654u, 3205198654u, 0, LOG_TOLERANCE, 0},
{179, 1058474557u, 3204911857u, 3204911857u, 0, LOG_TOLERANCE, 0},
{180, 1058642330u, 3204629879u, 3204629879u, 0, LOG_TOLERANCE, 0},
{181, 1058810102u, 3204256872u, 3204256872u, 0, LOG_TOLERANCE, 0},
{182, 1058977874u, 3203711260u, 3203711260u, 0, LOG_TOLERANCE, 0},
{183, 1059145646u, 3203174378u, 3203174378u, 0, LOG_TOLERANCE, 0},
{184, 1059313418u, 3202645951u, 3202645951u, 0, LOG_TOLERANCE, 0},
{185, 1059481190u, 3202125717u, 3202125717u, 0, LOG_TOLERANCE, 0},
{186, 1059648963u, 3201613424u, 3201613424u, 0, LOG_TOLERANCE, 0},
{187, 1059816735u, 3201108837u, 3201108837u, 0, LOG_TOLERANCE, 0},
{188, 1059984507u, 3200611726u, 3200611726u, 0, LOG_TOLERANCE, 0},
{189, 1060152279u, 3200121872u, 3200121872u, 0, LOG_TOLERANCE, 0},
{190, 1060320051u, 3199639066u, 3199639066u, 0, LOG_TOLERANCE, 0},
{191, 1060487823u, 3199163108u, 3199163108u, 0, LOG_TOLERANCE, 0},
{192, 1060655596u, 3198693806u, 3198693806u, 0, LOG_TOLERANCE, 0},
{193, 1060823368u, 3198230980u, 3198230980u, 0, LOG_TOLERANCE, 0},
{194, 1060991140u, 3197774450u, 3197774450u, 0, LOG_TOLERANCE, 0},
{195, 1061158912u, 3197324049u, 3197324049u, 0, LOG_TOLERANCE, 0},
{196, 1061326684u, 3196879613u, 3196879613u, 0, LOG_TOLERANCE, 0},
{197, 1061494456u, 3196440987u, 3196440987u, 0, LOG_TOLERANCE, 0},
{198, 1061662228u, 3195956394u, 3195956394u, 0, LOG_TOLERANCE, 0},
{199, 1061830001u, 3195101489u, 3195101489u, 0, LOG_TOLERANCE, 0},
{200, 1061997773u, 3194257341u, 3194257341u, 0, LOG_TOLERANCE, 0},
{201, 1062165545u, 3193423681u, 3193423681u, 0, LOG_TOLERANCE, 0},
{202, 1062333317u, 3192600250u, 3192600250u, 0, LOG_TOLERANCE, 0},
{203, 1062501089u, 3191786800u, 3191786800u, 0, LOG_TOLERANCE, 0},
{204, 1062668861u, 3190983092u, 3190983092u, 0, LOG_TOLERANCE, 0},
{205, 1062836634u, 3190188891u, 3190188891u, 0, LOG_TOLERANCE, 0},
{206, 1063004406u, 3189403984u, 3189403984u, 0, LOG_TOLERANCE, 0},
{207, 1063172178u, 3188628151u, 3188628151u, 0, LOG_TOLERANCE, 0},
{208, 1063339950u, 3187861184u, 3187861184u, 0, LOG_TOLERANCE, 0},
{209, 1063507722u, 3186534730u, 3186534730u, 0, LOG_TOLERANCE, 0},
{210, 1063675494u, 3185035076u, 3185035076u, 0, LOG_TOLERANCE, 0},
{211, 1063843267u, 3183551985u, 3183551985u, 0, LOG_TOLERANCE, 0},
{212, 1064011039u, 3182085111u, 3182085111u, 0, LOG_TOLERANCE, 0},
{213, 1064178811u, 3180634097u, 3180634097u, 0, LOG_TOLERANCE, 0},
{214, 1064346583u, 3179114768u, 3179114768u, 0, LOG_TOLERANCE, 0},
{215, 1064514355u, 3176274158u, 3176274158u, 0, LOG_TOLERANCE, 0},
{216, 1064682127u, 3173463292u, 3173463292u, 0, LOG_TOLERANCE, 0},
{217, 1064849900u, 3170469255u, 3170469255u, 0, LOG_TOLERANCE, 0},
{218, 1065017672u, 3164962844u, 3164962844u, 0, LOG_TOLERANCE, 0},
{219, 1065185444u, 3156519456u, 3156519456u, 0, LOG_TOLERANCE, 0},
{220, 1065353216u, 0u, 0u, 0, LOG_TOLERANCE, 0},
{221, 1065437102u, 1008928428u, 1008928428u, 0, LOG_TOLERANCE, 0},
{222, 1065520988u, 1017264404u, 1017264404u, 0, LOG_TOLERANCE, 0},
{223, 1065604874u, 1022502206u, 1022502206u, 0, LOG_TOLERANCE, 0},
{224, 1065688760u, 1025549788u, 1025549788u, 0, LOG_TOLERANCE, 0},
{225, 1065772646u, 1028118565u, 1028118565u, 0, LOG_TOLERANCE, 0},
{226, 1065856532u, 1030662994u, 1030662994u, 0, LOG_TOLERANCE, 0},
{227, 1065940419u, 1032491173u, 1032491173u, 0, LOG_TOLERANCE, 0},
{228, 1066024305u, 1033739718u, 1033739718u, 0, LOG_TOLERANCE, 0},
{229, 1066108191u, 1034976754u, 1034976754u, 0, LOG_TOLERANCE, 0},
{230, 1066192077u, 1036202495u, 1036202495u, 0, LOG_TOLERANCE, 0},
{231, 1066275963u, 1037417141u, 1037417141u, 0, LOG_TOLERANCE, 0},
{232, 1066359849u, 1038620896u, 1038620896u, 0, LOG_TOLERANCE, 0},
{233, 1066443735u, 1039813947u, 1039813947u, 0, LOG_TOLERANCE, 0},
{234, 1066527621u, 1040591942u, 1040591942u, 0, LOG_TOLERANCE, 0},
{235, 1066611507u, 1041178048u, 1041178048u, 0, LOG_TOLERANCE, 0},
{236, 1066695393u, 1041759081u, 1041759081u, 0, LOG_TOLERANCE, 0},
{237, 1066779279u, 1042335124u, 1042335124u, 0, LOG_TOLERANCE, 0},
{238, 1066863165u, 1042906267u, 1042906267u, 0, LOG_TOLERANCE, 0},
{239, 1066947052u, 1043472596u, 1043472596u, 0, LOG_TOLERANCE, 0},
{240, 3234402267u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{241, 3231108068u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{242, 3226013659u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{243, 3217625051u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{244, 0u, 1115684864u, 4286578688u, EDOM, LOG_TOLERANCE, 0},
{245, 1070141403u, 1055339994u, 1055339994u, 0, LOG_TOLERANCE, 0},
{246, 1078530011u, 1066567299u, 1066567299u, 0, LOG_TOLERANCE, 0},
{247, 1083624420u, 1069968586u, 1069968586u, 0, LOG_TOLERANCE, 0},
{248, 3253731328u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{249, 3252840038u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{250, 3251948749u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{251, 3251057459u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{252, 3250166170u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{253, 3249274880u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{254, 3248383590u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{255, 3247492301u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{256, 3246601011u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{257, 3245028147u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{258, 3243245568u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{259, 3241462989u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{260, 3239680410u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{261, 3237792973u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{262, 3234227814u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{263, 3230662656u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{264, 3224580915u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{265, 3213675725u, 1115684864u, 2143289344u, EDOM, LOG_TOLERANCE, 0},
{266, 1058642330u, 3204629879u, 3204629879u, 0, LOG_TOLERANCE, 0},
{267, 1075000115u, 1062549896u, 1062549896u, 0, LOG_TOLERANCE, 0},
{268, 1082130432u, 1068593688u, 1068593688u, 0, LOG_TOLERANCE, 0},
{269, 1085695590u, 1071564696u, 1071564696u, 0, LOG_TOLERANCE, 0},
{270, 1089260749u, 1073748032u, 1073748032u, 0, LOG_TOLERANCE, 0},
{271, 1091672474u, 1074615390u, 1074615390u, 0, LOG_TOLERANCE, 0},
{272, 1093455053u, 1075333756u, 1075333756u, 0, LOG_TOLERANCE, 0},
{273, 1095237632u, 1075946890u, 1075946890u, 0, LOG_TOLERANCE, 0},
{274, 1097020211u, 1076481719u, 1076481719u, 0, LOG_TOLERANCE, 0},
{275, 1098802790u, 1076955999u, 1076955999u, 0, LOG_TOLERANCE, 0},
{276, 1099746509u, 1077382056u, 1077382056u, 0, LOG_TOLERANCE, 0},
{277, 1100637798u, 1077768796u, 1077768796u, 0, LOG_TOLERANCE, 0},
{278, 1101529088u, 1078122869u, 1078122869u, 0, LOG_TOLERANCE, 0},
{279, 1102420378u, 1078449364u, 1078449364u, 0, LOG_TOLERANCE, 0},
{280, 1103311667u, 1078752269u, 1078752269u, 0, LOG_TOLERANCE, 0},
{281, 1104202957u, 1079034764u, 1079034764u, 0, LOG_TOLERANCE, 0},
{282, 1105094246u, 1079299428u, 1079299428u, 0, LOG_TOLERANCE, 0},
{283, 1105985536u, 1079548378u, 1079548378u, 0, LOG_TOLERANCE, 0},
{284, 1107800421u, 1080134364u, 1080134364u, 0, LOG_TOLERANCE, 0},
{285, 1221216477u, 1095693023u, 1095693023u, 0, LOG_TOLERANCE, 0},
{286, 1224242132u, 1095908585u, 1095908585u, 0, LOG_TOLERANCE, 0},
{287, 1073543469u, 1060005543u, 1060005543u, 0, LOG_TOLERANCE, 0},
{288, 1198712763u, 1093704455u, 1093704455u, 0, LOG_TOLERANCE, 0},
{289, 1312607135u, 1101261650u, 1101261650u, 0, LOG_TOLERANCE, 0},
{290, 1166191415u, 1090873880u, 1090873880u, 0, LOG_TOLERANCE, 0},
{291, 1234419246u, 1096817193u, 1096817193u, 0, LOG_TOLERANCE, 0},
{292, 1302107128u, 1100800142u, 1100800142u, 0, LOG_TOLERANCE, 0},
{293, 1336836355u, 1102310606u, 1102310606u, 0, LOG_TOLERANCE, 0},
{294, 1167223673u, 1090993221u, 1090993221u, 0, LOG_TOLERANCE, 0},
{295, 1324169524u, 1101744774u, 1101744774u, 0, LOG_TOLERANCE, 0},
{296, 1083983848u, 1070268261u, 1070268261u, 0, LOG_TOLERANCE, 0},
{297, 1341514497u, 1102490397u, 1102490397u, 0, LOG_TOLERANCE, 0},
{298, 1272351391u, 1099511630u, 1099511630u, 0, LOG_TOLERANCE, 0},
{299, 1172241344u, 1091434272u, 1091434272u, 0, LOG_TOLERANCE, 0},
{300, 1104057898u, 1078990065u, 1078990065u, 0, LOG_TOLERANCE, 0},
{301, 1224379831u, 1095917415u, 1095917415u, 0, LOG_TOLERANCE, 0},
{302, 1306460502u, 1100985551u, 1100985551u, 0, LOG_TOLERANCE, 0},
{303, 1197542187u, 1093624368u, 1093624368u, 0, LOG_TOLERANCE, 0},
{304, 1184239996u, 1092472664u, 1092472664u, 0, LOG_TOLERANCE, 0},
{305, 1252490238u, 1098402337u, 1098402337u, 0, LOG_TOLERANCE, 0},
{306, 1139715822u, 1086677655u, 1086677655u, 0, LOG_TOLERANCE, 0},
{307, 1143233714u, 1087348914u, 1087348914u, 0, LOG_TOLERANCE, 0},
{308, 1139941253u, 1086707662u, 1086707662u, 0, LOG_TOLERANCE, 0},
{309, 1092814839u, 1075089673u, 1075089673u, 0, LOG_TOLERANCE, 0},
{310, 1288902137u, 1100229934u, 1100229934u, 0, LOG_TOLERANCE, 0},
{311, 1333134799u, 1102127278u, 1102127278u, 0, LOG_TOLERANCE, 0},
{312, 1187847971u, 1092800357u, 1092800357u, 0, LOG_TOLERANCE, 0},
{313, 1181870825u, 1092246548u, 1092246548u, 0, LOG_TOLERANCE, 0},
{314, 1309289088u, 1101097963u, 1101097963u, 0, LOG_TOLERANCE, 0},
{315, 1297170011u, 1100588747u, 1100588747u, 0, LOG_TOLERANCE, 0},
{316, 1258101754u, 1098835327u, 1098835327u, 0, LOG_TOLERANCE, 0},
{317, 1106778573u, 1079758106u, 1079758106u, 0, LOG_TOLERANCE, 0},
{318, 1140567947u, 1086788895u, 1086788895u, 0, LOG_TOLERANCE, 0},
{319, 1238569473u, 1097191239u, 1097191239u, 0, LOG_TOLERANCE, 0},
{320, 1261071232u, 1099027511u, 1099027511u, 0, LOG_TOLERANCE, 0},
{321, 1175011025u, 1091652187u, 1091652187u, 0, LOG_TOLERANCE, 0},
{322, 1082692850u, 1069138055u, 1069138055u, 0, LOG_TOLERANCE, 0},
{323, 1255864908u, 1098683439u, 1098683439u, 0, LOG_TOLERANCE, 0},
{324, 1136411063u, 1086179935u, 1086179935u, 0, LOG_TOLERANCE, 0},
{325, 1091747974u, 1074648446u, 1074648446u, 0, LOG_TOLERANCE, 0},
{326, 1193132132u, 1093251837u, 1093251837u, 0, LOG_TOLERANCE, 0},
{327, 1270480664u, 1099436775u, 1099436775u, 0, LOG_TOLERANCE, 0},
{328, 1148867223u, 1088231141u, 1088231141u, 0, LOG_TOLERANCE, 0},
{329, 1152956913u, 1089047504u, 1089047504u, 0, LOG_TOLERANCE, 0},
{330, 1109627625u, 1080918154u, 1080918154u, 0, LOG_TOLERANCE, 0},
{331, 1307091856u, 1101007725u, 1101007725u, 0, LOG_TOLERANCE, 0},
{332, 1077234132u, 1065698877u, 1065698877u, 0, LOG_TOLERANCE, 0},
{333, 1142167709u, 1087130370u, 1087130370u, 0, LOG_TOLERANCE, 0},
{334, 1278749186u, 1099794993u, 1099794993u, 0, LOG_TOLERANCE, 0},
{335, 1221083131u, 1095682422u, 1095682422u, 0, LOG_TOLERANCE, 0},
{336, 1138741813u, 1086542828u, 1086542828u, 0, LOG_TOLERANCE, 0},
{337, 1142981585u, 1087299243u, 1087299243u, 0, LOG_TOLERANCE, 0},
{338, 1199682314u, 1093773342u, 1093773342u, 0, LOG_TOLERANCE, 0},
{339, 1326472382u, 1101847781u, 1101847781u, 0, LOG_TOLERANCE, 0},
{340, 1201614701u, 1093988142u, 1093988142u, 0, LOG_TOLERANCE, 0},
{341, 1198006188u, 1093656849u, 1093656849u, 0, LOG_TOLERANCE, 0},
{342, 1108485380u, 1080445589u, 1080445589u, 0, LOG_TOLERANCE, 0},
{343, 1233784744u, 1096746124u, 1096746124u, 0, LOG_TOLERANCE, 0},
{344, 1087189715u, 1072552672u, 1072552672u, 0, LOG_TOLERANCE, 0},
{345, 1065468637u, 1012917463u, 1012917463u, 0, LOG_TOLERANCE, 0},
{346, 1318704920u, 1101517711u, 1101517711u, 0, LOG_TOLERANCE, 0},
{347, 1171831868u, 1091404471u, 1091404471u, 0, LOG_TOLERANCE, 0},
{348, 1315030230u, 1101355418u, 1101355418u, 0, LOG_TOLERANCE, 0},
{349, 1134593658u, 1085845744u, 1085845744u, 0, LOG_TOLERANCE, 0},
{350, 1086198791u, 1071910589u, 1071910589u, 0, LOG_TOLERANCE, 0},
{351, 1255152035u, 1098630014u, 1098630014u, 0, LOG_TOLERANCE, 0},
{352, 1135271264u, 1085976650u, 1085976650u, 0, LOG_TOLERANCE, 0},
{353, 1094190727u, 1075597743u, 1075597743u, 0, LOG_TOLERANCE, 0},
{354, 1294665325u, 1100483004u, 1100483004u, 0, LOG_TOLERANCE, 0},
{355, 1082514416u, 1068969143u, 1068969143u, 0, LOG_TOLERANCE, 0},
{356, 1291650374u, 1100324939u, 1100324939u, 0, LOG_TOLERANCE, 0},
{357, 1325668223u, 1101801209u, 1101801209u, 0, LOG_TOLERANCE, 0},
{358, 1092037607u, 1074772894u, 1074772894u, 0, LOG_TOLERANCE, 0},
{359, 1168794760u, 1091152214u, 1091152214u, 0, LOG_TOLERANCE, 0},
{360, 1147953120u, 1088110905u, 1088110905u, 0, LOG_TOLERANCE, 0},
{361, 1151984049u, 1088871818u, 1088871818u, 0, LOG_TOLERANCE, 0},
{362, 1129287043u, 1084930939u, 1084930939u, 0, LOG_TOLERANCE, 0},
{363, 1243664530u, 1097632908u, 1097632908u, 0, LOG_TOLERANCE, 0},
{364, 1115471979u, 1082436853u, 1082436853u, 0, LOG_TOLERANCE, 0},
{365, 1203608440u, 1094171523u, 1094171523u, 0, LOG_TOLERANCE, 0},
{366, 1276995896u, 1099712697u, 1099712697u, 0, LOG_TOLERANCE, 0},
{367, 1093710327u, 1075427252u, 1075427252u, 0, LOG_TOLERANCE, 0},
{368, 1110545760u, 1081262826u, 1081262826u, 0, LOG_TOLERANCE, 0},
{369, 1214492942u, 1095090269u, 1095090269u, 0, LOG_TOLERANCE, 0},
{370, 1304154705u, 1100895530u, 1100895530u, 0, LOG_TOLERANCE, 0},
{371, 1116959962u, 1082760387u, 1082760387u, 0, LOG_TOLERANCE, 0},
{372, 1227066979u, 1096196998u, 1096196998u, 0, LOG_TOLERANCE, 0},
{373, 1268194719u, 1099327890u, 1099327890u, 0, LOG_TOLERANCE, 0},
{374, 1133420220u, 1085597719u, 1085597719u, 0, LOG_TOLERANCE, 0},
{375, 1161858787u, 1090553629u, 1090553629u, 0, LOG_TOLERANCE, 0},
{376, 1148513315u, 1088185404u, 1088185404u, 0, LOG_TOLERANCE, 0},
{377, 1270887389u, 1099453983u, 1099453983u, 0, LOG_TOLERANCE, 0},
{378, 1177709533u, 1091927310u, 1091927310u, 0, LOG_TOLERANCE, 0},
{379, 1189120494u, 1092895196u, 1092895196u, 0, LOG_TOLERANCE, 0},
{380, 1323529208u, 1101722723u, 1101722723u, 0, LOG_TOLERANCE, 0},
{381, 1318284740u, 1101495392u, 1101495392u, 0, LOG_TOLERANCE, 0},
{382, 1278616251u, 1099789186u, 1099789186u, 0, LOG_TOLERANCE, 0},
{383, 1077373465u, 1065796682u, 1065796682u, 0, LOG_TOLERANCE, 0},
{384, 1065798296u, 1028899151u, 1028899151u, 0, LOG_TOLERANCE, 0},
{385, 1181505796u, 1092222124u, 1092222124u, 0, LOG_TOLERANCE, 0},
{386, 1210335378u, 1094747816u, 1094747816u, 0, LOG_TOLERANCE, 0},
{387, 1273397670u, 1099549262u, 1099549262u, 0, LOG_TOLERANCE, 0},
{388, 1277348132u, 1099730300u, 1099730300u, 0, LOG_TOLERANCE, 0},
{389, 1257596246u, 1098802875u, 1098802875u, 0, LOG_TOLERANCE, 0},
{390, 1147268859u, 1088016163u, 1088016163u, 0, LOG_TOLERANCE, 0},
{391, 1277365077u, 1099731132u, 1099731132u, 0, LOG_TOLERANCE, 0},
{392, 1090870906u, 1074247369u, 1074247369u, 0, LOG_TOLERANCE, 0},
{393, 1227582289u, 1096246234u, 1096246234u, 0, LOG_TOLERANCE, 0},
{394, 1272325814u, 1099510676u, 1099510676u, 0, LOG_TOLERANCE, 0},
{395, 1212024623u, 1094900665u, 1094900665u, 0, LOG_TOLERANCE, 0},
{396, 1137854355u, 1086411946u, 1086411946u, 0, LOG_TOLERANCE, 0},
{397, 1293289410u, 1100414337u, 1100414337u, 0, LOG_TOLERANCE, 0},
{398, 1303733188u, 1100877261u, 1100877261u, 0, LOG_TOLERANCE, 0},
{399, 1289579346u, 1100254992u, 1100254992u, 0, LOG_TOLERANCE, 0},
{400, 1131196082u, 1085206365u, 1085206365u, 0, LOG_TOLERANCE, 0},
{401, 1110614030u, 1081287358u, 1081287358u, 0, LOG_TOLERANCE, 0},
{402, 1313431700u, 1101295475u, 1101295475u, 0, LOG_TOLERANCE, 0},
{403, 1155551824u, 1089454781u, 1089454781u, 0, LOG_TOLERANCE, 0},
{404, 1248682573u, 1098041251u, 1098041251u, 0, LOG_TOLERANCE, 0},
{405, 1311450615u, 1101210199u, 1101210199u, 0, LOG_TOLERANCE, 0},
{406, 1065761827u, 1027788653u, 1027788653u, 0, LOG_TOLERANCE, 0},
{407, 1199816046u, 1093789711u, 1093789711u, 0, LOG_TOLERANCE, 0},
{408, 1186295367u, 1092671666u, 1092671666u, 0, LOG_TOLERANCE, 0},
{409, 1080781593u, 1067890611u, 1067890611u, 0, LOG_TOLERANCE, 0},
{410, 1087842942u, 1072950559u, 1072950559u, 0, LOG_TOLERANCE, 0},
{411, 1079506760u, 1067167149u, 1067167149u, 0, LOG_TOLERANCE, 0},
{412, 1283624229u, 1099978015u, 1099978015u, 0, LOG_TOLERANCE, 0},
{413, 1193633657u, 1093301509u, 1093301509u, 0, LOG_TOLERANCE, 0},
{414, 1270734970u, 1099447601u, 1099447601u, 0, LOG_TOLERANCE, 0},
{415, 1307332419u, 1101015933u, 1101015933u, 0, LOG_TOLERANCE, 0},
{416, 1106502045u, 1079686160u, 1079686160u, 0, LOG_TOLERANCE, 0},
{417, 1157598381u, 1089728115u, 1089728115u, 0, LOG_TOLERANCE, 0},
{418, 1187750865u, 1092792755u, 1092792755u, 0, LOG_TOLERANCE, 0},
{419, 1279489061u, 1099826186u, 1099826186u, 0, LOG_TOLERANCE, 0},
{420, 1233171235u, 1096672499u, 1096672499u, 0, LOG_TOLERANCE, 0},
{421, 1148920078u, 1088237887u, 1088237887u, 0, LOG_TOLERANCE, 0},
{422, 1109198803u, 1080746924u, 1080746924u, 0, LOG_TOLERANCE, 0},
{423, 1072465835u, 1058877958u, 1058877958u, 0, LOG_TOLERANCE, 0},
{424, 1213665826u, 1095030475u, 1095030475u, 0, LOG_TOLERANCE, 0},
{425, 1207502108u, 1094457342u, 1094457342u, 0, LOG_TOLERANCE, 0},
{426, 1234530539u, 1096829177u, 1096829177u, 0, LOG_TOLERANCE, 0},
{427, 1158845204u, 1090015981u, 1090015981u, 0, LOG_TOLERANCE, 0},
{428, 1291910469u, 1100335113u, 1100335113u, 0, LOG_TOLERANCE, 0},
{429, 1131927531u, 1085302998u, 1085302998u, 0, LOG_TOLERANCE, 0},
{430, 1302395743u, 1100814684u, 1100814684u, 0, LOG_TOLERANCE, 0},
{431, 1125551064u, 1084257511u, 1084257511u, 0, LOG_TOLERANCE, 0},
{432, 1279812724u, 1099839269u, 1099839269u, 0, LOG_TOLERANCE, 0},
{433, 1198917460u, 1093717853u, 1093717853u, 0, LOG_TOLERANCE, 0},
{434, 1091906532u, 1074717032u, 1074717032u, 0, LOG_TOLERANCE, 0},
{435, 1246074130u, 1097848812u, 1097848812u, 0, LOG_TOLERANCE, 0},
{436, 1276853215u, 1099705395u, 1099705395u, 0, LOG_TOLERANCE, 0},
{437, 1315294792u, 1101364709u, 1101364709u, 0, LOG_TOLERANCE, 0},
{438, 1212686469u, 1094954961u, 1094954961u, 0, LOG_TOLERANCE, 0},
{439, 1076761780u, 1065358559u, 1065358559u, 0, LOG_TOLERANCE, 0},
{440, 1120124467u, 1083354446u, 1083354446u, 0, LOG_TOLERANCE, 0},
{441, 1268744779u, 1099356230u, 1099356230u, 0, LOG_TOLERANCE, 0},
{442, 1165195428u, 1090799626u, 1090799626u, 0, LOG_TOLERANCE, 0},
{443, 1100306391u, 1077629126u, 1077629126u, 0, LOG_TOLERANCE, 0},
{444, 1067761000u, 1048654430u, 1048654430u, 0, LOG_TOLERANCE, 0},
{445, 1212717473u, 1094957437u, 1094957437u, 0, LOG_TOLERANCE, 0},
{446, 1128489361u, 1084804200u, 1084804200u, 0, LOG_TOLERANCE, 0},
{447, 1243678660u, 1097634313u, 1097634313u, 0, LOG_TOLERANCE, 0},
{448, 1089986803u, 1073939811u, 1073939811u, 0, LOG_TOLERANCE, 0},
{449, 1296314700u, 1100554982u, 1100554982u, 0, LOG_TOLERANCE, 0},
{450, 1251462432u, 1098299243u, 1098299243u, 0, LOG_TOLERANCE, 0},
{451, 1337753254u, 1102351040u, 1102351040u, 0, LOG_TOLERANCE, 0},
{452, 1114685890u, 1082334890u, 1082334890u, 0, LOG_TOLERANCE, 0},
{453, 1295475718u, 1100519604u, 1100519604u, 0, LOG_TOLERANCE, 0},
{454, 1256888357u, 1098755673u, 1098755673u, 0, LOG_TOLERANCE, 0},
{455, 1125800069u, 1084309783u, 1084309783u, 0, LOG_TOLERANCE, 0},
{456, 1189421739u, 1092916445u, 1092916445u, 0, LOG_TOLERANCE, 0},
{457, 1164046161u, 1090721242u, 1090721242u, 0, LOG_TOLERANCE, 0},
{458, 1292596266u, 1100376009u, 1100376009u, 0, LOG_TOLERANCE, 0},
{459, 1322264731u, 1101676248u, 1101676248u, 0, LOG_TOLERANCE, 0},
{460, 1314644642u, 1101341573u, 1101341573u, 0, LOG_TOLERANCE, 0},
{461, 1252329525u, 1098386870u, 1098386870u, 0, LOG_TOLERANCE, 0},
{462, 1341639087u, 1102494435u, 1102494435u, 0, LOG_TOLERANCE, 0},
{463, 1181604787u, 1092228804u, 1092228804u, 0, LOG_TOLERANCE, 0},
{464, 1314588083u, 1101339511u, 1101339511u, 0, LOG_TOLERANCE, 0},
{465, 1253466032u, 1098491642u, 1098491642u, 0, LOG_TOLERANCE, 0},
{466, 1218098153u, 1095411826u, 1095411826u, 0, LOG_TOLERANCE, 0},
{467, 1110424755u, 1081218988u, 1081218988u, 0, LOG_TOLERANCE, 0},
{468, 1139120919u, 1086596341u, 1086596341u, 0, LOG_TOLERANCE, 0},
{469, 1220524226u, 1095636787u, 1095636787u, 0, LOG_TOLERANCE, 0},
{470, 1234908052u, 1096868836u, 1096868836u, 0, LOG_TOLERANCE, 0},
{471, 1156767533u, 1089621407u, 1089621407u, 0, LOG_TOLERANCE, 0},
{472, 1332389915u, 1102102479u, 1102102479u, 0, LOG_TOLERANCE, 0},
{473, 1276780469u, 1099701633u, 1099701633u, 0, LOG_TOLERANCE, 0},
{474, 1080882239u, 1067945156u, 1067945156u, 0, LOG_TOLERANCE, 0},
{475, 1212129651u, 1094909471u, 1094909471u, 0, LOG_TOLERANCE, 0},
{476, 1311706596u, 1101222030u, 1101222030u, 0, LOG_TOLERANCE, 0},
{477, 1337315179u, 1102332110u, 1102332110u, 0, LOG_TOLERANCE, 0},
{478, 1131358407u, 1085228198u, 1085228198u, 0, LOG_TOLERANCE, 0},
{479, 1156517523u, 1089588205u, 1089588205u, 0, LOG_TOLERANCE, 0},
{480, 1190015561u, 1092957111u, 1092957111u, 0, LOG_TOLERANCE, 0},
{481, 1320945382u, 1101622920u, 1101622920u, 0, LOG_TOLERANCE, 0},
{482, 1106032152u, 1079561000u, 1079561000u, 0, LOG_TOLERANCE, 0},
{483, 1277806832u, 1099752371u, 1099752371u, 0, LOG_TOLERANCE, 0},
{484, 1073495847u, 1059957282u, 1059957282u, 0, LOG_TOLERANCE, 0},
{485, 1311016004u, 1101189480u, 1101189480u, 0, LOG_TOLERANCE, 0},
{486, 1128016396u, 1084725270u, 1084725270u, 0, LOG_TOLERANCE, 0},
{487, 1206054701u, 1094359958u, 1094359958u, 0, LOG_TOLERANCE, 0},
{488, 1213609983u, 1095026312u, 1095026312u, 0, LOG_TOLERANCE, 0},
{489, 1246902946u, 1097913869u, 1097913869u, 0, LOG_TOLERANCE, 0},
{490, 1214599180u, 1095097708u, 1095097708u, 0, LOG_TOLERANCE, 0},
{491, 1237504879u, 1097107264u, 1097107264u, 0, LOG_TOLERANCE, 0},
{492, 1317696241u, 1101462444u, 1101462444u, 0, LOG_TOLERANCE, 0},
{493, 1087912276u, 1072991704u, 1072991704u, 0, LOG_TOLERANCE, 0},
{494, 1194393976u, 1093372592u, 1093372592u, 0, LOG_TOLERANCE, 0},
{495, 1228636133u, 1096340255u, 1096340255u, 0, LOG_TOLERANCE, 0},
{496, 1207246237u, 1094440772u, 1094440772u, 0, LOG_TOLERANCE, 0},
{497, 1165476654u, 1090817946u, 1090817946u, 0, LOG_TOLERANCE, 0},
{498, 1215278023u, 1095144035u, 1095144035u, 0, LOG_TOLERANCE, 0},
{499, 1149651309u, 1088378728u, 1088378728u, 0, LOG_TOLERANCE, 0},
{500, 1111943722u, 1081738608u, 1081738608u, 0, LOG_TOLERANCE, 0},
{501, 1189849849u, 1092945921u, 1092945921u, 0, LOG_TOLERANCE, 0},
{502, 1249758327u, 1098111361u, 1098111361u, 0, LOG_TOLERANCE, 0},
{503, 1168098747u, 1091084732u, 1091084732u, 0, LOG_TOLERANCE, 0},
{504, 1153525376u, 1089143736u, 1089143736u, 0, LOG_TOLERANCE, 0},
{505, 1085605579u, 1071501292u, 1071501292u, 0, LOG_TOLERANCE, 0},
{506, 1070761636u, 1056883359u, 1056883359u, 0, LOG_TOLERANCE, 0},
{507, 1068498242u, 1050870884u, 1050870884u, 0, LOG_TOLERANCE, 0},
{508, 1266687209u, 1099241312u, 1099241312u, 0, LOG_TOLERANCE, 0},
{509, 1340476127u, 1102455475u, 1102455475u, 0, LOG_TOLERANCE, 0},
{510, 1197582051u, 1093627199u, 1093627199u, 0, LOG_TOLERANCE, 0},
{511, 1262852441u, 1099105092u, 1099105092u, 0, LOG_TOLERANCE, 0},
{512, 1141063391u, 1086877052u, 1086877052u, 0, LOG_TOLERANCE, 0},
{513, 1206196143u, 1094369884u, 1094369884u, 0, LOG_TOLERANCE, 0},
{514, 1219643887u, 1095560618u, 1095560618u, 0, LOG_TOLERANCE, 0},
{515, 1134469222u, 1085820790u, 1085820790u, 0, LOG_TOLERANCE, 0},
{516, 1237868497u, 1097136708u, 1097136708u, 0, LOG_TOLERANCE, 0},
{517, 1153753924u, 1089181215u, 1089181215u, 0, LOG_TOLERANCE, 0},
{518, 1120261759u, 1083376771u, 1083376771u, 0, LOG_TOLERANCE, 0},
{519, 1078844712u, 1066765289u, 1066765289u, 0, LOG_TOLERANCE, 0},
{520, 1202112338u, 1094037004u, 1094037004u, 0, LOG_TOLERANCE, 0},
{521, 1087750238u, 1072895228u, 1072895228u, 0, LOG_TOLERANCE, 0},
{522, 1066116543u, 1035099299u, 1035099299u, 0, LOG_TOLERANCE, 0},
{523, 1186234578u, 1092666292u, 1092666292u, 0, LOG_TOLERANCE, 0},
{524, 1331680743u, 1102077726u, 1102077726u, 0, LOG_TOLERANCE, 0},
{525, 1201949077u, 1094021223u, 1094021223u, 0, LOG_TOLERANCE, 0},
{526, 1081311485u, 1068173883u, 1068173883u, 0, LOG_TOLERANCE, 0},
{527, 1149300655u, 1088293458u, 1088293458u, 0, LOG_TOLERANCE, 0},
{528, 1240669941u, 1097339474u, 1097339474u, 0, LOG_TOLERANCE, 0},
{529, 1133410485u, 1085595534u, 1085595534u, 0, LOG_TOLERANCE, 0},
{530, 1222486939u, 1095788984u, 1095788984u, 0, LOG_TOLERANCE, 0},
{531, 1270451568u, 1099435522u, 1099435522u, 0, LOG_TOLERANCE, 0},
{532, 1280215674u, 1099855114u, 1099855114u, 0, LOG_TOLERANCE, 0},
{533, 1171873518u, 1091407541u, 1091407541u, 0, LOG_TOLERANCE, 0},
{534, 1150774452u, 1088630616u, 1088630616u, 0, LOG_TOLERANCE, 0},
{535, 1267725176u, 1099302424u, 1099302424u, 0, LOG_TOLERANCE, 0},
{536, 1209845200u, 1094698946u, 1094698946u, 0, LOG_TOLERANCE, 0},
{537, 1120384488u, 1083396529u, 1083396529u, 0, LOG_TOLERANCE, 0},
{538, 1171564509u, 1091384546u, 1091384546u, 0, LOG_TOLERANCE, 0},
{539, 1144755661u, 1087626076u, 1087626076u, 0, LOG_TOLERANCE, 0},
{540, 1153978024u, 1089217325u, 1089217325u, 0, LOG_TOLERANCE, 0},
{541, 1217042030u, 1095296480u, 1095296480u, 0, LOG_TOLERANCE, 0},
{542, 1319638151u, 1101564124u, 1101564124u, 0, LOG_TOLERANCE, 0},
{543, 1151257041u, 1088730198u, 1088730198u, 0, LOG_TOLERANCE, 0},
{544, 1258369714u, 1098857003u, 1098857003u, 0, LOG_TOLERANCE, 0},
{545, 1216602683u, 1095244489u, 1095244489u, 0, LOG_TOLERANCE, 0},
{546, 1149782091u, 1088409663u, 1088409663u, 0, LOG_TOLERANCE, 0},
{547, 1071940738u, 1058299789u, 1058299789u, 0, LOG_TOLERANCE, 0},
{548, 1314801987u, 1101347267u, 1101347267u, 0, LOG_TOLERANCE, 0},
{549, 1209694157u, 1094683416u, 1094683416u, 0, LOG_TOLERANCE, 0},
{550, 1153863660u, 1089198975u, 1089198975u, 0, LOG_TOLERANCE, 0},
{551, 1249365132u, 1098086276u, 1098086276u, 0, LOG_TOLERANCE, 0},
{552, 1074612637u, 1061862115u, 1061862115u, 0, LOG_TOLERANCE, 0},
{553, 1297708818u, 1100608953u, 1100608953u, 0, LOG_TOLERANCE, 0},
{554, 1198049074u, 1093659801u, 1093659801u, 0, LOG_TOLERANCE, 0},
{555, 1271269588u, 1099469655u, 1099469655u, 0, LOG_TOLERANCE, 0},
{556, 1277417964u, 1099733721u, 1099733721u, 0, LOG_TOLERANCE, 0},
{557, 1173439580u, 1091516907u, 1091516907u, 0, LOG_TOLERANCE, 0},
{558, 1337400405u, 1102335847u, 1102335847u, 0, LOG_TOLERANCE, 0},
{559, 1252864992u, 1098437540u, 1098437540u, 0, LOG_TOLERANCE, 0},
{560, 1250249095u, 1098162859u, 1098162859u, 0, LOG_TOLERANCE, 0},
{561, 1136927585u, 1086265946u, 1086265946u, 0, LOG_TOLERANCE, 0},
{562, 1215968622u, 1095189153u, 1095189153u, 0, LOG_TOLERANCE, 0},
{563, 1215264594u, 1095143138u, 1095143138u, 0, LOG_TOLERANCE, 0},
{564, 1252237719u, 1098377931u, 1098377931u, 0, LOG_TOLERANCE, 0},
{565, 1180411946u, 1092145329u, 1092145329u, 0, LOG_TOLERANCE, 0},
{566, 1248677856u, 1098040933u, 1098040933u, 0, LOG_TOLERANCE, 0},
{567, 1099710167u, 1077365504u, 1077365504u, 0, LOG_TOLERANCE, 0},
{568, 1157186482u, 1089675892u, 1089675892u, 0, LOG_TOLERANCE, 0},
{569, 1282110851u, 1099923816u, 1099923816u, 0, LOG_TOLERANCE, 0},
{570, 1329524465u, 1101994371u, 1101994371u, 0, LOG_TOLERANCE, 0},
{571, 1144643646u, 1087606880u, 1087606880u, 0, LOG_TOLERANCE, 0},
{572, 1123357102u, 1083825755u, 1083825755u, 0, LOG_TOLERANCE, 0},
{573, 1106837025u, 1079773158u, 1079773158u, 0, LOG_TOLERANCE, 0},
{574, 1253017688u, 1098451551u, 1098451551u, 0, LOG_TOLERANCE, 0},
{575, 1108543194u, 1080470831u, 1080470831u, 0, LOG_TOLERANCE, 0},
{576, 1160162706u, 1090285527u, 1090285527u, 0, LOG_TOLERANCE, 0},
{577, 1158231377u, 1089877497u, 1089877497u, 0, LOG_TOLERANCE, 0},
{578, 1266928623u, 1099256175u, 1099256175u, 0, LOG_TOLERANCE, 0},
{579, 1290596379u, 1100290507u, 1100290507u, 0, LOG_TOLERANCE, 0},
{580, 1197091103u, 1093591797u, 1093591797u, 0, LOG_TOLERANCE, 0},
{581, 1152416724u, 1088951776u, 1088951776u, 0, LOG_TOLERANCE, 0},
{582, 1218239308u, 1095426324u, 1095426324u, 0, LOG_TOLERANCE, 0},
{583, 1115826919u, 1082498850u, 1082498850u, 0, LOG_TOLERANCE, 0},
{584, 1142780964u, 1087258861u, 1087258861u, 0, LOG_TOLERANCE, 0},
{585, 1074622936u, 1061880764u, 1061880764u, 0, LOG_TOLERANCE, 0},
{586, 1278946388u, 1099803490u, 1099803490u, 0, LOG_TOLERANCE, 0},
{587, 1098530298u, 1076886881u, 1076886881u, 0, LOG_TOLERANCE, 0},
{588, 1085242388u, 1071240474u, 1071240474u, 0, LOG_TOLERANCE, 0},
{589, 1297190916u, 1100589546u, 1100589546u, 0, LOG_TOLERANCE, 0},
{590, 1277649137u, 1099744888u, 1099744888u, 0, LOG_TOLERANCE, 0},
{591, 1096548368u, 1076346654u, 1076346654u, 0, LOG_TOLERANCE, 0},
{592, 1096155623u, 1076230816u, 1076230816u, 0, LOG_TOLERANCE, 0},
{593, 1091245957u, 1074423591u, 1074423591u, 0, LOG_TOLERANCE, 0},
{594, 1169713169u, 1091235090u, 1091235090u, 0, LOG_TOLERANCE, 0},
{595, 1227264862u, 1096216180u, 1096216180u, 0, LOG_TOLERANCE, 0},
{596, 1198151302u, 1093666804u, 1093666804u, 0, LOG_TOLERANCE, 0},
{597, 1249433635u, 1098090690u, 1098090690u, 0, LOG_TOLERANCE, 0},
{598, 1169549089u, 1091220756u, 1091220756u, 0, LOG_TOLERANCE, 0},
{599, 1200051436u, 1093817916u, 1093817916u, 0, LOG_TOLERANCE, 0},
{600, 1306520561u, 1100987701u, 1100987701u, 0, LOG_TOLERANCE, 0},
{601, 1314936356u, 1101352081u, 1101352081u, 0, LOG_TOLERANCE, 0},
{602, 1327568571u, 1101905258u, 1101905258u, 0, LOG_TOLERANCE, 0},
{603, 1245744060u, 1097821737u, 1097821737u, 0, LOG_TOLERANCE, 0},
{604, 1201521756u, 1093978758u, 1093978758u, 0, LOG_TOLERANCE, 0},
{605, 1262863321u, 1099105532u, 1099105532u, 0, LOG_TOLERANCE, 0},
{606, 1240170043u, 1097306048u, 1097306048u, 0, LOG_TOLERANCE, 0},
{607, 1338680611u, 1102388991u, 1102388991u, 0, LOG_TOLERANCE, 0},
{608, 1112891928u, 1082033104u, 1082033104u, 0, LOG_TOLERANCE, 0},
{609, 1190105283u, 1092963121u, 1092963121u, 0, LOG_TOLERANCE, 0},
{610, 1263047389u, 1099112926u, 1099112926u, 0, LOG_TOLERANCE, 0},
{611, 1066141167u, 1035459935u, 1035459935u, 0, LOG_TOLERANCE, 0},
{612, 1120888322u, 1083475744u, 1083475744u, 0, LOG_TOLERANCE, 0},
{613, 1315217243u, 1101362003u, 1101362003u, 0, LOG_TOLERANCE, 0},
{614, 1168623062u, 1091135966u, 1091135966u, 0, LOG_TOLERANCE, 0},
{615, 1311186097u, 1101197687u, 1101197687u, 0, LOG_TOLERANCE, 0},
{616, 1180032668u, 1092117331u, 1092117331u, 0, LOG_TOLERANCE, 0},
{617, 1134528351u, 1085832685u, 1085832685u, 0, LOG_TOLERANCE, 0},
{618, 1266869190u, 1099252555u, 1099252555u, 0, LOG_TOLERANCE, 0},
{619, 1133689539u, 1085657293u, 1085657293u, 0, LOG_TOLERANCE, 0},
{620, 1308204830u, 1101044665u, 1101044665u, 0, LOG_TOLERANCE, 0},
{621, 1137634874u, 1086378277u, 1086378277u, 0, LOG_TOLERANCE, 0},
{622, 1268019014u, 1099318505u, 1099318505u, 0, LOG_TOLERANCE, 0},
{623, 1066157309u, 1035695818u, 1035695818u, 0, LOG_TOLERANCE, 0},
{624, 1288870027u, 1100228716u, 1100228716u, 0, LOG_TOLERANCE, 0},
{625, 1125177888u, 1084176650u, 1084176650u, 0, LOG_TOLERANCE, 0},
{626, 1170245333u, 1091280275u, 1091280275u, 0, LOG_TOLERANCE, 0},
{627, 1219052056u, 1095506114u, 1095506114u, 0, LOG_TOLERANCE, 0},
{628, 1171499971u, 1091379679u, 1091379679u, 0, LOG_TOLERANCE, 0},
{629, 1224634973u, 1095933583u, 1095933583u, 0, LOG_TOLERANCE, 0},
{630, 1299683827u, 1100676996u, 1100676996u, 0, LOG_TOLERANCE, 0},
{631, 1109740374u, 1080962038u, 1080962038u, 0, LOG_TOLERANCE, 0},
{632, 1229268598u, 1096392882u, 1096392882u, 0, LOG_TOLERANCE, 0},
{633, 1086717248u, 1072252652u, 1072252652u, 0, LOG_TOLERANCE, 0},
{634, 1287400959u, 1100169711u, 1100169711u, 0, LOG_TOLERANCE, 0},
{635, 1317471958u, 1101449322u, 1101449322u, 0, LOG_TOLERANCE, 0},
{636, 1242829722u, 1097546376u, 1097546376u, 0, LOG_TOLERANCE, 0},
{637, 1200927971u, 1093916741u, 1093916741u, 0, LOG_TOLERANCE, 0},
{638, 1179374444u, 1092066895u, 1092066895u, 0, LOG_TOLERANCE, 0},
{639, 1246019790u, 1097844403u, 1097844403u, 0, LOG_TOLERANCE, 0},
{640, 1136052740u, 1086118125u, 1086118125u, 0, LOG_TOLERANCE, 0},
{641, 1069009211u, 1052325441u, 1052325441u, 0, LOG_TOLERANCE, 0},
{642, 1169128344u, 1091183079u, 1091183079u, 0, LOG_TOLERANCE, 0},
{643, 1087942795u, 1073009751u, 1073009751u, 0, LOG_TOLERANCE, 0},
{644, 1278882065u, 1099800734u, 1099800734u, 0, LOG_TOLERANCE, 0},
{645, 1147842784u, 1088095915u, 1088095915u, 0, LOG_TOLERANCE, 0},
{646, 1171351660u, 1091368407u, 1091368407u, 0, LOG_TOLERANCE, 0},
{647, 1136072069u, 1086121506u, 1086121506u, 0, LOG_TOLERANCE, 0},
{648, 1233771772u, 1096744620u, 1096744620u, 0, LOG_TOLERANCE, 0},
{649, 1241288445u, 1097379408u, 1097379408u, 0, LOG_TOLERANCE, 0},
{650, 1319200415u, 1101542864u, 1101542864u, 0, LOG_TOLERANCE, 0},
{651, 1279324488u, 1099819407u, 1099819407u, 0, LOG_TOLERANCE, 0},
{652, 1070311776u, 1055771065u, 1055771065u, 0, LOG_TOLERANCE, 0},
{653, 1307648109u, 1101026512u, 1101026512u, 0, LOG_TOLERANCE, 0},
{654, 1246947517u, 1097917255u, 1097917255u, 0, LOG_TOLERANCE, 0},
{655, 1249239929u, 1098078160u, 1098078160u, 0, LOG_TOLERANCE, 0},
{656, 1286277377u, 1100119627u, 1100119627u, 0, LOG_TOLERANCE, 0},
{657, 1173247961u, 1091504122u, 1091504122u, 0, LOG_TOLERANCE, 0},
{658, 1101051030u, 1077936679u, 1077936679u, 0, LOG_TOLERANCE, 0},
{659, 1082862511u, 1069295568u, 1069295568u, 0, LOG_TOLERANCE, 0},
{660, 1341821683u, 1102500297u, 1102500297u, 0, LOG_TOLERANCE, 0},
{661, 1079061705u, 1066899135u, 1066899135u, 0, LOG_TOLERANCE, 0},
{662, 1105291533u, 1079355820u, 1079355820u, 0, LOG_TOLERANCE, 0},
{663, 1223207358u, 1095839735u, 1095839735u, 0, LOG_TOLERANCE, 0},
{664, 1156767169u, 1089621359u, 1089621359u, 0, LOG_TOLERANCE, 0},
{665, 1104284039u, 1079059544u, 1079059544u, 0, LOG_TOLERANCE, 0},
{666, 1187729253u, 1092791055u, 1092791055u, 0, LOG_TOLERANCE, 0},
{667, 1093697541u, 1075422618u, 1075422618u, 0, LOG_TOLERANCE, 0},
{668, 1119207537u, 1083198919u, 1083198919u, 0, LOG_TOLERANCE, 0},
{669, 1094115255u, 1075571413u, 1075571413u, 0, LOG_TOLERANCE, 0},
{670, 1276603160u, 1099692348u, 1099692348u, 0, LOG_TOLERANCE, 0},
{671, 1206125125u, 1094364912u, 1094364912u, 0, LOG_TOLERANCE, 0},
{672, 1098662266u, 1076920498u, 1076920498u, 0, LOG_TOLERANCE, 0},
{673, 1328600211u, 1101954140u, 1101954140u, 0, LOG_TOLERANCE, 0},
{674, 1317062968u, 1101424512u, 1101424512u, 0, LOG_TOLERANCE, 0},
{675, 1296068481u, 1100544845u, 1100544845u, 0, LOG_TOLERANCE, 0},
{676, 1287620154u, 1100178947u, 1100178947u, 0, LOG_TOLERANCE, 0},
{677, 1245702957u, 1097818316u, 1097818316u, 0, LOG_TOLERANCE, 0},
{678, 1268279353u, 1099332351u, 1099332351u, 0, LOG_TOLERANCE, 0},
{679, 1135988313u, 1086106816u, 1086106816u, 0, LOG_TOLERANCE, 0},
{680, 1163727179u, 1090698406u, 1090698406u, 0, LOG_TOLERANCE, 0},
{681, 1198307901u, 1093677442u, 1093677442u, 0, LOG_TOLERANCE, 0},
{682, 1288901567u, 1100229913u, 1100229913u, 0, LOG_TOLERANCE, 0},
{683, 1113104661u, 1082096428u, 1082096428u, 0, LOG_TOLERANCE, 0},
{684, 1136714348u, 1086230864u, 1086230864u, 0, LOG_TOLERANCE, 0},
{685, 1339423444u, 1102417526u, 1102417526u, 0, LOG_TOLERANCE, 0},
{686, 1162027071u, 1090567520u, 1090567520u, 0, LOG_TOLERANCE, 0},
{687, 1124131769u, 1083931793u, 1083931793u, 0, LOG_TOLERANCE, 0},
{688, 1177157787u, 1091876627u, 1091876627u, 0, LOG_TOLERANCE, 0},
{689, 1284600904u, 1100034688u, 1100034688u, 0, LOG_TOLERANCE, 0},
{690, 1309658335u, 1101118918u, 1101118918u, 0, LOG_TOLERANCE, 0},
{691, 1226494979u, 1096139493u, 1096139493u, 0, LOG_TOLERANCE, 0},
{692, 1228023365u, 1096286616u, 1096286616u, 0, LOG_TOLERANCE, 0},
{693, 1313215353u, 1101286809u, 1101286809u, 0, LOG_TOLERANCE, 0},
{694, 1320539530u, 1101605361u, 1101605361u, 0, LOG_TOLERANCE, 0},
{695, 1204196034u, 1094219971u, 1094219971u, 0, LOG_TOLERANCE, 0},
{696, 1312393763u, 1101252529u, 1101252529u, 0, LOG_TOLERANCE, 0},
{697, 1161439847u, 1090517416u, 1090517416u, 0, LOG_TOLERANCE, 0},
{698, 1084378658u, 1070585549u, 1070585549u, 0, LOG_TOLERANCE, 0},
{699, 1226473697u, 1096137292u, 1096137292u, 0, LOG_TOLERANCE, 0},
{700, 1123114742u, 1083793867u, 1083793867u, 0, LOG_TOLERANCE, 0},
{701, 1258114435u, 1098836128u, 1098836128u, 0, LOG_TOLERANCE, 0},
{702, 1320557197u, 1101606138u, 1101606138u, 0, LOG_TOLERANCE, 0},
{703, 1178825761u, 1092022914u, 1092022914u, 0, LOG_TOLERANCE, 0},
{704, 1075900364u, 1064046743u, 1064046743u, 0, LOG_TOLERANCE, 0},
{705, 1297778779u, 1100611521u, 1100611521u, 0, LOG_TOLERANCE, 0},
{706, 1125653081u, 1084279085u, 1084279085u, 0, LOG_TOLERANCE, 0},
{707, 1190169064u, 1092967372u, 1092967372u, 0, LOG_TOLERANCE, 0},
{708, 1184753508u, 1092526032u, 1092526032u, 0, LOG_TOLERANCE, 0},
{709, 1188439315u, 1092845498u, 1092845498u, 0, LOG_TOLERANCE, 0},
{710, 1314151417u, 1101323314u, 1101323314u, 0, LOG_TOLERANCE, 0},
{711, 1188167943u, 1092825023u, 1092825023u, 0, LOG_TOLERANCE, 0},
{712, 1142595790u, 1087220886u, 1087220886u, 0, LOG_TOLERANCE, 0},
{713, 1203206679u, 1094137061u, 1094137061u, 0, LOG_TOLERANCE, 0},
{714, 1102061604u, 1078320979u, 1078320979u, 0, LOG_TOLERANCE, 0},
{715, 1282351521u, 1099931930u, 1099931930u, 0, LOG_TOLERANCE, 0},
{716, 1311377417u, 1101206767u, 1101206767u, 0, LOG_TOLERANCE, 0},
{717, 1081309682u, 1068172935u, 1068172935u, 0, LOG_TOLERANCE, 0},
{718, 1274711085u, 1099592971u, 1099592971u, 0, LOG_TOLERANCE, 0},
{719, 1261940623u, 1099066812u, 1099066812u, 0, LOG_TOLERANCE, 0},
{720, 1253119433u, 1098460785u, 1098460785u, 0, LOG_TOLERANCE, 0},
{721, 1219411812u, 1095539582u, 1095539582u, 0, LOG_TOLERANCE, 0},
{722, 1149882378u, 1088433080u, 1088433080u, 0, LOG_TOLERANCE, 0},
{723, 1218488455u, 1095451435u, 1095451435u, 0, LOG_TOLERANCE, 0},
{724, 1283938137u, 1099996906u, 1099996906u, 0, LOG_TOLERANCE, 0},
{725, 1317098613u, 1101426722u, 1101426722u, 0, LOG_TOLERANCE, 0},
{726, 1284220009u, 1100013309u, 1100013309u, 0, LOG_TOLERANCE, 0},
{727, 1092245127u, 1074859842u, 1074859842u, 0, LOG_TOLERANCE, 0},
{728, 1165676440u, 1090830769u, 1090830769u, 0, LOG_TOLERANCE, 0},
{729, 1284174954u, 1100010721u, 1100010721u, 0, LOG_TOLERANCE, 0},
{730, 1102631663u, 1078523172u, 1078523172u, 0, LOG_TOLERANCE, 0},
{731, 1125596740u, 1084267198u, 1084267198u, 0, LOG_TOLERANCE, 0},
{732, 1172529774u, 1091454766u, 1091454766u, 0, LOG_TOLERANCE, 0},
{733, 1306695905u, 1100993929u, 1100993929u, 0, LOG_TOLERANCE, 0},
{734, 1078478376u, 1066534362u, 1066534362u, 0, LOG_TOLERANCE, 0},
{735, 1165177679u, 1090798459u, 1090798459u, 0, LOG_TOLERANCE, 0},
{736, 1255525865u, 1098658369u, 1098658369u, 0, LOG_TOLERANCE, 0},
{737, 1222777442u, 1095809745u, 1095809745u, 0, LOG_TOLERANCE, 0},
{738, 1325324763u, 1101782353u, 1101782353u, 0, LOG_TOLERANCE, 0},
{739, 1216040565u, 1095193744u, 1095193744u, 0, LOG_TOLERANCE, 0},
{740, 1158950321u, 1090038805u, 1090038805u, 0, LOG_TOLERANCE, 0},
{741, 1208345407u, 1094533485u, 1094533485u, 0, LOG_TOLERANCE, 0},
{742, 1258634105u, 1098889245u, 1098889245u, 0, LOG_TOLERANCE, 0},
{743, 1248478509u, 1098027406u, 1098027406u, 0, LOG_TOLERANCE, 0},
{744, 1153863988u, 1089199028u, 1089199028u, 0, LOG_TOLERANCE, 0},
{745, 1235620969u, 1096939871u, 1096939871u, 0, LOG_TOLERANCE, 0},
{746, 1097120930u, 1076509995u, 1076509995u, 0, LOG_TOLERANCE, 0},
{747, 1322294974u, 1101677409u, 1101677409u, 0, LOG_TOLERANCE, 0},
{748, 1147712200u, 1088078034u, 1088078034u, 0, LOG_TOLERANCE, 0},
{749, 1124721745u, 1084073380u, 1084073380u, 0, LOG_TOLERANCE, 0},
{750, 1114260656u, 1082277595u, 1082277595u, 0, LOG_TOLERANCE, 0},
{751, 1155676504u, 1089472492u, 1089472492u, 0, LOG_TOLERANCE, 0},
{752, 1315090496u, 1101357549u, 1101357549u, 0, LOG_TOLERANCE, 0},
{753, 1082919539u, 1069347855u, 1069347855u, 0, LOG_TOLERANCE, 0},
{754, 1335399673u, 1102240222u, 1102240222u, 0, LOG_TOLERANCE, 0},
{755, 1072458508u, 1058870026u, 1058870026u, 0, LOG_TOLERANCE, 0},
{756, 1155531601u, 1089451895u, 1089451895u, 0, LOG_TOLERANCE, 0},
{757, 1104656093u, 1079171407u, 1079171407u, 0, LOG_TOLERANCE, 0},
{758, 1321036318u, 1101626775u, 1101626775u, 0, LOG_TOLERANCE, 0},
{759, 1172239631u, 1091434149u, 1091434149u, 0, LOG_TOLERANCE, 0},
{760, 1107620519u, 1080048642u, 1080048642u, 0, LOG_TOLERANCE, 0},
{761, 1155477903u, 1089444210u, 1089444210u, 0, LOG_TOLERANCE, 0},
{762, 1126405528u, 1084431697u, 1084431697u, 0, LOG_TOLERANCE, 0},
{763, 1090330020u, 1074027503u, 1074027503u, 0, LOG_TOLERANCE, 0},
{764, 1228207362u, 1096303012u, 1096303012u, 0, LOG_TOLERANCE, 0},
{765, 1290175785u, 1100276110u, 1100276110u, 0, LOG_TOLERANCE, 0},
{766, 1214223128u, 1095071136u, 1095071136u, 0, LOG_TOLERANCE, 0},
{767, 1275438936u, 1099626919u, 1099626919u, 0, LOG_TOLERANCE, 0},
{768, 1315857601u, 1101383945u, 1101383945u, 0, LOG_TOLERANCE, 0},
{769, 1305742382u, 1100959135u, 1100959135u, 0, LOG_TOLERANCE, 0},
{770, 1078359574u, 1066458087u, 1066458087u, 0, LOG_TOLERANCE, 0},
{771, 1207675424u, 1094468419u, 1094468419u, 0, LOG_TOLERANCE, 0},
{772, 1248421894u, 1098023532u, 1098023532u, 0, LOG_TOLERANCE, 0},
{773, 1205768346u, 1094339572u, 1094339572u, 0, LOG_TOLERANCE, 0},
{774, 1076752219u, 1065349836u, 1065349836u, 0, LOG_TOLERANCE, 0},
{775, 1241048294u, 1097364082u, 1097364082u, 0, LOG_TOLERANCE, 0},
{776, 1273395082u, 1099549172u, 1099549172u, 0, LOG_TOLERANCE, 0},
{777, 1238104535u, 1097155389u, 1097155389u, 0, LOG_TOLERANCE, 0},
{778, 1294321000u, 1100466645u, 1100466645u, 0, LOG_TOLERANCE, 0},
{779, 1245343769u, 1097787935u, 1097787935u, 0, LOG_TOLERANCE, 0},
{780, 1161241793u, 1090483093u, 1090483093u, 0, LOG_TOLERANCE, 0},
{781, 1171318485u, 1091365870u, 1091365870u, 0, LOG_TOLERANCE, 0},
{782, 1243968857u, 1097662758u, 1097662758u, 0, LOG_TOLERANCE, 0},
{783, 1102119721u, 1078342044u, 1078342044u, 0, LOG_TOLERANCE, 0},
{784, 1220264047u, 1095614846u, 1095614846u, 0, LOG_TOLERANCE, 0},
{785, 1134728775u, 1085872507u, 1085872507u, 0, LOG_TOLERANCE, 0},
{786, 1204809672u, 1094268284u, 1094268284u, 0, LOG_TOLERANCE, 0},
{787, 1148874793u, 1088232109u, 1088232109u, 0, LOG_TOLERANCE, 0},
{788, 1197828352u, 1093644519u, 1093644519u, 0, LOG_TOLERANCE, 0},
{789, 1193026723u, 1093241091u, 1093241091u, 0, LOG_TOLERANCE, 0},
{790, 1127109339u, 1084565044u, 1084565044u, 0, LOG_TOLERANCE, 0},
{791, 1200599955u, 1093880840u, 1093880840u, 0, LOG_TOLERANCE, 0},
{792, 1089700228u, 1073865159u, 1073865159u, 0, LOG_TOLERANCE, 0},
{793, 1333109014u, 1102126438u, 1102126438u, 0, LOG_TOLERANCE, 0},
{794, 1155775526u, 1089486453u, 1089486453u, 0, LOG_TOLERANCE, 0},
{795, 1234491880u, 1096825030u, 1096825030u, 0, LOG_TOLERANCE, 0}

// AUTOMATICALLY GENERATED VECTORS STOP

};

#endif // CYGONCE_LIBM_LOG_H multiple inclusion protection

// EOF log.h
