#ifndef CYGONCE_LIBM_LOGBF_H
#define CYGONCE_LIBM_LOGBF_H
//===========================================================================
//
//      logbf.h
//
//      Test vectors for testing of logbf() math library function
//
//===========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####
// -------------------------------------------
// This file is part of eCos, the Embedded Configurable Operating System.
// Copyright (C) 2012 Free Software Foundation, Inc.
//
// eCos is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 or (at your option) any later
// version.
//
// eCos is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
// for more details.
//
// You should have received a copy of the GNU General Public License
// along with eCos; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//
// As a special exception, if other files instantiate templates or use
// macros or inline functions from this file, or you compile this file
// and link it with other works to produce a work based on this file,
// this file does not by itself cause the resulting work to be covered by
// the GNU General Public License. However the source code for this file
// must still be made available in accordance with section (3) of the GNU
// General Public License v2.
//
// This exception does not invalidate any other reasons why a work based
// on this file might be covered by the GNU General Public License.
// -------------------------------------------
// ####ECOSGPLCOPYRIGHTEND####
//===========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):
// Contributors:  visar, ilijak
// Date:        1998-02-13
// Purpose:
// Description:
// Usage:       #include "vectors/logbf.h"
//
//####DESCRIPTIONEND####
//
//===========================================================================


// CONFIGURATION

#include <pkgconf/libm.h>   // Configuration header


// INCLUDES

#include <cyg/infra/cyg_type.h>    // Common type definitions and support
#include "vectors/vector_support_float.h"// extra support for math tests

#define LOGBF_TOLERANCE 1.0E-04

static const Cyg_libm_test_float_vec_t logbf_vec[] = {

// AUTOMATICALLY GENERATED VECTORS START

{0, 3214514586u, 0u, 0u, 0, LOGBF_TOLERANCE, 0},
{1, 3214430700u, 0u, 0u, 0, LOGBF_TOLERANCE, 0},
{2, 3214346813u, 0u, 0u, 0, LOGBF_TOLERANCE, 0},
{3, 3214262927u, 0u, 0u, 0, LOGBF_TOLERANCE, 0},
{4, 3214179041u, 0u, 0u, 0, LOGBF_TOLERANCE, 0},
{5, 3214095155u, 0u, 0u, 0, LOGBF_TOLERANCE, 0},
{6, 3214011269u, 0u, 0u, 0, LOGBF_TOLERANCE, 0},
{7, 3213927383u, 0u, 0u, 0, LOGBF_TOLERANCE, 0},
{8, 3213843497u, 0u, 0u, 0, LOGBF_TOLERANCE, 0},
{9, 3213759611u, 0u, 0u, 0, LOGBF_TOLERANCE, 0},
{10, 3213675725u, 0u, 0u, 0, LOGBF_TOLERANCE, 0},
{11, 3213591839u, 0u, 0u, 0, LOGBF_TOLERANCE, 0},
{12, 3213507953u, 0u, 0u, 0, LOGBF_TOLERANCE, 0},
{13, 3213424067u, 0u, 0u, 0, LOGBF_TOLERANCE, 0},
{14, 3213340180u, 0u, 0u, 0, LOGBF_TOLERANCE, 0},
{15, 3213256294u, 0u, 0u, 0, LOGBF_TOLERANCE, 0},
{16, 3213172408u, 0u, 0u, 0, LOGBF_TOLERANCE, 0},
{17, 3213088522u, 0u, 0u, 0, LOGBF_TOLERANCE, 0},
{18, 3213004636u, 0u, 0u, 0, LOGBF_TOLERANCE, 0},
{19, 3212920750u, 0u, 0u, 0, LOGBF_TOLERANCE, 0},
{20, 3212836864u, 0u, 0u, 0, LOGBF_TOLERANCE, 0},
{21, 3212669092u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{22, 3212501320u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{23, 3212333548u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{24, 3212165775u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{25, 3211998003u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{26, 3211830231u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{27, 3211662459u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{28, 3211494687u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{29, 3211326915u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{30, 3211159142u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{31, 3210991370u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{32, 3210823598u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{33, 3210655826u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{34, 3210488054u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{35, 3210320282u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{36, 3210152509u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{37, 3209984737u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{38, 3209816965u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{39, 3209649193u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{40, 3209481421u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{41, 3209313649u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{42, 3209145876u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{43, 3208978104u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{44, 3208810332u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{45, 3208642560u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{46, 3208474788u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{47, 3208307016u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{48, 3208139244u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{49, 3207971471u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{50, 3207803699u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{51, 3207635927u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{52, 3207468155u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{53, 3207300383u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{54, 3207132611u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{55, 3206964838u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{56, 3206797066u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{57, 3206629294u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{58, 3206461522u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{59, 3206293750u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{60, 3206125978u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{61, 3205958205u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{62, 3205790433u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{63, 3205622661u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{64, 3205454889u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{65, 3205287117u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{66, 3205119345u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{67, 3204951572u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{68, 3204783800u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{69, 3204616028u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{70, 3204448256u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{71, 3204112712u, 0u, 3221225472u, 0, LOGBF_TOLERANCE, 0},
{72, 3203777167u, 0u, 3221225472u, 0, LOGBF_TOLERANCE, 0},
{73, 3203441623u, 0u, 3221225472u, 0, LOGBF_TOLERANCE, 0},
{74, 3203106079u, 0u, 3221225472u, 0, LOGBF_TOLERANCE, 0},
{75, 3202770534u, 0u, 3221225472u, 0, LOGBF_TOLERANCE, 0},
{76, 3202434990u, 0u, 3221225472u, 0, LOGBF_TOLERANCE, 0},
{77, 3202099446u, 0u, 3221225472u, 0, LOGBF_TOLERANCE, 0},
{78, 3201763901u, 0u, 3221225472u, 0, LOGBF_TOLERANCE, 0},
{79, 3201428357u, 0u, 3221225472u, 0, LOGBF_TOLERANCE, 0},
{80, 3201092813u, 0u, 3221225472u, 0, LOGBF_TOLERANCE, 0},
{81, 3200757268u, 0u, 3221225472u, 0, LOGBF_TOLERANCE, 0},
{82, 3200421724u, 0u, 3221225472u, 0, LOGBF_TOLERANCE, 0},
{83, 3200086180u, 0u, 3221225472u, 0, LOGBF_TOLERANCE, 0},
{84, 3199750636u, 0u, 3221225472u, 0, LOGBF_TOLERANCE, 0},
{85, 3199415091u, 0u, 3221225472u, 0, LOGBF_TOLERANCE, 0},
{86, 3199079547u, 0u, 3221225472u, 0, LOGBF_TOLERANCE, 0},
{87, 3198744003u, 0u, 3221225472u, 0, LOGBF_TOLERANCE, 0},
{88, 3198408458u, 0u, 3221225472u, 0, LOGBF_TOLERANCE, 0},
{89, 3198072914u, 0u, 3221225472u, 0, LOGBF_TOLERANCE, 0},
{90, 3197737370u, 0u, 3221225472u, 0, LOGBF_TOLERANCE, 0},
{91, 3197401825u, 0u, 3221225472u, 0, LOGBF_TOLERANCE, 0},
{92, 3197066281u, 0u, 3221225472u, 0, LOGBF_TOLERANCE, 0},
{93, 3196730737u, 0u, 3221225472u, 0, LOGBF_TOLERANCE, 0},
{94, 3196395192u, 0u, 3221225472u, 0, LOGBF_TOLERANCE, 0},
{95, 3196059648u, 0u, 3221225472u, 0, LOGBF_TOLERANCE, 0},
{96, 3195388559u, 0u, 3225419776u, 0, LOGBF_TOLERANCE, 0},
{97, 3194717471u, 0u, 3225419776u, 0, LOGBF_TOLERANCE, 0},
{98, 3194046382u, 0u, 3225419776u, 0, LOGBF_TOLERANCE, 0},
{99, 3193375293u, 0u, 3225419776u, 0, LOGBF_TOLERANCE, 0},
{100, 3192704205u, 0u, 3225419776u, 0, LOGBF_TOLERANCE, 0},
{101, 3192033116u, 0u, 3225419776u, 0, LOGBF_TOLERANCE, 0},
{102, 3191362028u, 0u, 3225419776u, 0, LOGBF_TOLERANCE, 0},
{103, 3190690939u, 0u, 3225419776u, 0, LOGBF_TOLERANCE, 0},
{104, 3190019850u, 0u, 3225419776u, 0, LOGBF_TOLERANCE, 0},
{105, 3189348762u, 0u, 3225419776u, 0, LOGBF_TOLERANCE, 0},
{106, 3188677673u, 0u, 3225419776u, 0, LOGBF_TOLERANCE, 0},
{107, 3188006584u, 0u, 3225419776u, 0, LOGBF_TOLERANCE, 0},
{108, 3186999951u, 0u, 3229614080u, 0, LOGBF_TOLERANCE, 0},
{109, 3185657774u, 0u, 3229614080u, 0, LOGBF_TOLERANCE, 0},
{110, 3184315597u, 0u, 3229614080u, 0, LOGBF_TOLERANCE, 0},
{111, 3182973420u, 0u, 3229614080u, 0, LOGBF_TOLERANCE, 0},
{112, 3181631242u, 0u, 3229614080u, 0, LOGBF_TOLERANCE, 0},
{113, 3180289065u, 0u, 3229614080u, 0, LOGBF_TOLERANCE, 0},
{114, 3178611343u, 0u, 3231711232u, 0, LOGBF_TOLERANCE, 0},
{115, 3175926989u, 0u, 3231711232u, 0, LOGBF_TOLERANCE, 0},
{116, 3173242634u, 0u, 3231711232u, 0, LOGBF_TOLERANCE, 0},
{117, 3170222735u, 0u, 3233808384u, 0, LOGBF_TOLERANCE, 0},
{118, 3164854026u, 0u, 3233808384u, 0, LOGBF_TOLERANCE, 0},
{119, 3156465418u, 0u, 3235905536u, 0, LOGBF_TOLERANCE, 0},
{120, 1008981770u, 0u, 3235905536u, 0, LOGBF_TOLERANCE, 0},
{121, 1017370378u, 0u, 3233808384u, 0, LOGBF_TOLERANCE, 0},
{122, 1022739087u, 0u, 3233808384u, 0, LOGBF_TOLERANCE, 0},
{123, 1025758986u, 0u, 3231711232u, 0, LOGBF_TOLERANCE, 0},
{124, 1028443341u, 0u, 3231711232u, 0, LOGBF_TOLERANCE, 0},
{125, 1031127695u, 0u, 3231711232u, 0, LOGBF_TOLERANCE, 0},
{126, 1032805417u, 0u, 3229614080u, 0, LOGBF_TOLERANCE, 0},
{127, 1034147594u, 0u, 3229614080u, 0, LOGBF_TOLERANCE, 0},
{128, 1035489772u, 0u, 3229614080u, 0, LOGBF_TOLERANCE, 0},
{129, 1036831949u, 0u, 3229614080u, 0, LOGBF_TOLERANCE, 0},
{130, 1038174126u, 0u, 3229614080u, 0, LOGBF_TOLERANCE, 0},
{131, 1039516303u, 0u, 3229614080u, 0, LOGBF_TOLERANCE, 0},
{132, 1040522936u, 0u, 3225419776u, 0, LOGBF_TOLERANCE, 0},
{133, 1041194025u, 0u, 3225419776u, 0, LOGBF_TOLERANCE, 0},
{134, 1041865114u, 0u, 3225419776u, 0, LOGBF_TOLERANCE, 0},
{135, 1042536202u, 0u, 3225419776u, 0, LOGBF_TOLERANCE, 0},
{136, 1043207291u, 0u, 3225419776u, 0, LOGBF_TOLERANCE, 0},
{137, 1043878380u, 0u, 3225419776u, 0, LOGBF_TOLERANCE, 0},
{138, 1044549468u, 0u, 3225419776u, 0, LOGBF_TOLERANCE, 0},
{139, 1045220557u, 0u, 3225419776u, 0, LOGBF_TOLERANCE, 0},
{140, 1045891645u, 0u, 3225419776u, 0, LOGBF_TOLERANCE, 0},
{141, 1046562734u, 0u, 3225419776u, 0, LOGBF_TOLERANCE, 0},
{142, 1047233823u, 0u, 3225419776u, 0, LOGBF_TOLERANCE, 0},
{143, 1047904911u, 0u, 3225419776u, 0, LOGBF_TOLERANCE, 0},
{144, 1048576000u, 0u, 3221225472u, 0, LOGBF_TOLERANCE, 0},
{145, 1048911544u, 0u, 3221225472u, 0, LOGBF_TOLERANCE, 0},
{146, 1049247089u, 0u, 3221225472u, 0, LOGBF_TOLERANCE, 0},
{147, 1049582633u, 0u, 3221225472u, 0, LOGBF_TOLERANCE, 0},
{148, 1049918177u, 0u, 3221225472u, 0, LOGBF_TOLERANCE, 0},
{149, 1050253722u, 0u, 3221225472u, 0, LOGBF_TOLERANCE, 0},
{150, 1050589266u, 0u, 3221225472u, 0, LOGBF_TOLERANCE, 0},
{151, 1050924810u, 0u, 3221225472u, 0, LOGBF_TOLERANCE, 0},
{152, 1051260355u, 0u, 3221225472u, 0, LOGBF_TOLERANCE, 0},
{153, 1051595899u, 0u, 3221225472u, 0, LOGBF_TOLERANCE, 0},
{154, 1051931443u, 0u, 3221225472u, 0, LOGBF_TOLERANCE, 0},
{155, 1052266988u, 0u, 3221225472u, 0, LOGBF_TOLERANCE, 0},
{156, 1052602532u, 0u, 3221225472u, 0, LOGBF_TOLERANCE, 0},
{157, 1052938076u, 0u, 3221225472u, 0, LOGBF_TOLERANCE, 0},
{158, 1053273620u, 0u, 3221225472u, 0, LOGBF_TOLERANCE, 0},
{159, 1053609165u, 0u, 3221225472u, 0, LOGBF_TOLERANCE, 0},
{160, 1053944709u, 0u, 3221225472u, 0, LOGBF_TOLERANCE, 0},
{161, 1054280253u, 0u, 3221225472u, 0, LOGBF_TOLERANCE, 0},
{162, 1054615798u, 0u, 3221225472u, 0, LOGBF_TOLERANCE, 0},
{163, 1054951342u, 0u, 3221225472u, 0, LOGBF_TOLERANCE, 0},
{164, 1055286886u, 0u, 3221225472u, 0, LOGBF_TOLERANCE, 0},
{165, 1055622431u, 0u, 3221225472u, 0, LOGBF_TOLERANCE, 0},
{166, 1055957975u, 0u, 3221225472u, 0, LOGBF_TOLERANCE, 0},
{167, 1056293519u, 0u, 3221225472u, 0, LOGBF_TOLERANCE, 0},
{168, 1056629064u, 0u, 3221225472u, 0, LOGBF_TOLERANCE, 0},
{169, 1056964608u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{170, 1057132380u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{171, 1057300152u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{172, 1057467924u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{173, 1057635697u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{174, 1057803469u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{175, 1057971241u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{176, 1058139013u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{177, 1058306785u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{178, 1058474557u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{179, 1058642330u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{180, 1058810102u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{181, 1058977874u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{182, 1059145646u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{183, 1059313418u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{184, 1059481190u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{185, 1059648963u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{186, 1059816735u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{187, 1059984507u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{188, 1060152279u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{189, 1060320051u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{190, 1060487823u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{191, 1060655596u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{192, 1060823368u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{193, 1060991140u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{194, 1061158912u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{195, 1061326684u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{196, 1061494456u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{197, 1061662228u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{198, 1061830001u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{199, 1061997773u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{200, 1062165545u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{201, 1062333317u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{202, 1062501089u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{203, 1062668861u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{204, 1062836634u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{205, 1063004406u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{206, 1063172178u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{207, 1063339950u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{208, 1063507722u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{209, 1063675494u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{210, 1063843267u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{211, 1064011039u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{212, 1064178811u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{213, 1064346583u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{214, 1064514355u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{215, 1064682127u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{216, 1064849900u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{217, 1065017672u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{218, 1065185444u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{219, 1065353216u, 0u, 0u, 0, LOGBF_TOLERANCE, 0},
{220, 1065437102u, 0u, 0u, 0, LOGBF_TOLERANCE, 0},
{221, 1065520988u, 0u, 0u, 0, LOGBF_TOLERANCE, 0},
{222, 1065604874u, 0u, 0u, 0, LOGBF_TOLERANCE, 0},
{223, 1065688760u, 0u, 0u, 0, LOGBF_TOLERANCE, 0},
{224, 1065772646u, 0u, 0u, 0, LOGBF_TOLERANCE, 0},
{225, 1065856532u, 0u, 0u, 0, LOGBF_TOLERANCE, 0},
{226, 1065940419u, 0u, 0u, 0, LOGBF_TOLERANCE, 0},
{227, 1066024305u, 0u, 0u, 0, LOGBF_TOLERANCE, 0},
{228, 1066108191u, 0u, 0u, 0, LOGBF_TOLERANCE, 0},
{229, 1066192077u, 0u, 0u, 0, LOGBF_TOLERANCE, 0},
{230, 1066275963u, 0u, 0u, 0, LOGBF_TOLERANCE, 0},
{231, 1066359849u, 0u, 0u, 0, LOGBF_TOLERANCE, 0},
{232, 1066443735u, 0u, 0u, 0, LOGBF_TOLERANCE, 0},
{233, 1066527621u, 0u, 0u, 0, LOGBF_TOLERANCE, 0},
{234, 1066611507u, 0u, 0u, 0, LOGBF_TOLERANCE, 0},
{235, 1066695393u, 0u, 0u, 0, LOGBF_TOLERANCE, 0},
{236, 1066779279u, 0u, 0u, 0, LOGBF_TOLERANCE, 0},
{237, 1066863165u, 0u, 0u, 0, LOGBF_TOLERANCE, 0},
{238, 1066947052u, 0u, 0u, 0, LOGBF_TOLERANCE, 0},
{239, 3234402267u, 0u, 1073741824u, 0, LOGBF_TOLERANCE, 0},
{240, 3231108068u, 0u, 1073741824u, 0, LOGBF_TOLERANCE, 0},
{241, 3226013659u, 0u, 1065353216u, 0, LOGBF_TOLERANCE, 0},
{242, 3217625051u, 0u, 0u, 0, LOGBF_TOLERANCE, 0},
{243, 1070141403u, 0u, 0u, 0, LOGBF_TOLERANCE, 0},
{244, 1078530011u, 0u, 1065353216u, 0, LOGBF_TOLERANCE, 0},
{245, 1083624420u, 0u, 1073741824u, 0, LOGBF_TOLERANCE, 0},
{246, 3253731328u, 0u, 1082130432u, 0, LOGBF_TOLERANCE, 0},
{247, 3252840038u, 0u, 1082130432u, 0, LOGBF_TOLERANCE, 0},
{248, 3251948749u, 0u, 1082130432u, 0, LOGBF_TOLERANCE, 0},
{249, 3251057459u, 0u, 1082130432u, 0, LOGBF_TOLERANCE, 0},
{250, 3250166170u, 0u, 1082130432u, 0, LOGBF_TOLERANCE, 0},
{251, 3249274880u, 0u, 1082130432u, 0, LOGBF_TOLERANCE, 0},
{252, 3248383590u, 0u, 1082130432u, 0, LOGBF_TOLERANCE, 0},
{253, 3247492301u, 0u, 1082130432u, 0, LOGBF_TOLERANCE, 0},
{254, 3246601011u, 0u, 1082130432u, 0, LOGBF_TOLERANCE, 0},
{255, 3245028147u, 0u, 1077936128u, 0, LOGBF_TOLERANCE, 0},
{256, 3243245568u, 0u, 1077936128u, 0, LOGBF_TOLERANCE, 0},
{257, 3241462989u, 0u, 1077936128u, 0, LOGBF_TOLERANCE, 0},
{258, 3239680410u, 0u, 1077936128u, 0, LOGBF_TOLERANCE, 0},
{259, 3237792973u, 0u, 1073741824u, 0, LOGBF_TOLERANCE, 0},
{260, 3234227814u, 0u, 1073741824u, 0, LOGBF_TOLERANCE, 0},
{261, 3230662656u, 0u, 1073741824u, 0, LOGBF_TOLERANCE, 0},
{262, 3224580915u, 0u, 1065353216u, 0, LOGBF_TOLERANCE, 0},
{263, 3213675725u, 0u, 0u, 0, LOGBF_TOLERANCE, 0},
{264, 1058642330u, 0u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{265, 1075000115u, 0u, 1065353216u, 0, LOGBF_TOLERANCE, 0},
{266, 1082130432u, 0u, 1073741824u, 0, LOGBF_TOLERANCE, 0},
{267, 1085695590u, 0u, 1073741824u, 0, LOGBF_TOLERANCE, 0},
{268, 1089260749u, 0u, 1073741824u, 0, LOGBF_TOLERANCE, 0},
{269, 1091672474u, 0u, 1077936128u, 0, LOGBF_TOLERANCE, 0},
{270, 1093455053u, 0u, 1077936128u, 0, LOGBF_TOLERANCE, 0},
{271, 1095237632u, 0u, 1077936128u, 0, LOGBF_TOLERANCE, 0},
{272, 1097020211u, 0u, 1077936128u, 0, LOGBF_TOLERANCE, 0},
{273, 1098802790u, 0u, 1077936128u, 0, LOGBF_TOLERANCE, 0},
{274, 1099746509u, 0u, 1082130432u, 0, LOGBF_TOLERANCE, 0},
{275, 1100637798u, 0u, 1082130432u, 0, LOGBF_TOLERANCE, 0},
{276, 1101529088u, 0u, 1082130432u, 0, LOGBF_TOLERANCE, 0},
{277, 1102420378u, 0u, 1082130432u, 0, LOGBF_TOLERANCE, 0},
{278, 1103311667u, 0u, 1082130432u, 0, LOGBF_TOLERANCE, 0},
{279, 1104202957u, 0u, 1082130432u, 0, LOGBF_TOLERANCE, 0},
{280, 1105094246u, 0u, 1082130432u, 0, LOGBF_TOLERANCE, 0},
{281, 1105985536u, 0u, 1082130432u, 0, LOGBF_TOLERANCE, 0},
{282, 1107800421u, 1203999711u, 1084227584u, 0, LOGBF_TOLERANCE, 0},
{283, 3196650934u, 896005582u, 3221225472u, 0, LOGBF_TOLERANCE, 0},
{284, 3368700125u, 3308232444u, 1099956224u, 0, LOGBF_TOLERANCE, 0},
{285, 1224242132u, 3061363425u, 1099956224u, 0, LOGBF_TOLERANCE, 0},
{286, 3221027117u, 1284201705u, 0u, 0, LOGBF_TOLERANCE, 0},
{287, 1198712763u, 919636942u, 1097859072u, 0, LOGBF_TOLERANCE, 0},
{288, 867432512u, 3067736756u, 3250585600u, 0, LOGBF_TOLERANCE, 0},
{289, 3159309973u, 852521077u, 3235905536u, 0, LOGBF_TOLERANCE, 0},
{290, 954173073u, 850531830u, 3244294144u, 0, LOGBF_TOLERANCE, 0},
{291, 3090780435u, 1035260608u, 3245342720u, 0, LOGBF_TOLERANCE, 0},
{292, 966554515u, 3234538174u, 3242196992u, 0, LOGBF_TOLERANCE, 0},
{293, 1312607135u, 1194999402u, 1105723392u, 0, LOGBF_TOLERANCE, 0},
{294, 1166191415u, 1018661564u, 1094713344u, 0, LOGBF_TOLERANCE, 0},
{295, 3111900019u, 1130472166u, 3243245568u, 0, LOGBF_TOLERANCE, 0},
{296, 1234419246u, 2984575812u, 1101004800u, 0, LOGBF_TOLERANCE, 0},
{297, 1302107128u, 3370647675u, 1105199104u, 0, LOGBF_TOLERANCE, 0},
{298, 1052801068u, 3039122570u, 3221225472u, 0, LOGBF_TOLERANCE, 0},
{299, 1060849628u, 3081357692u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{300, 3010214568u, 3446630737u, 3251109888u, 0, LOGBF_TOLERANCE, 0},
{301, 3484320003u, 3033957825u, 1107296256u, 0, LOGBF_TOLERANCE, 0},
{302, 3181522772u, 3305392896u, 3229614080u, 0, LOGBF_TOLERANCE, 0},
{303, 882596369u, 1256676590u, 3249537024u, 0, LOGBF_TOLERANCE, 0},
{304, 1167223673u, 846102364u, 1094713344u, 0, LOGBF_TOLERANCE, 0},
{305, 968192794u, 878547432u, 3242196992u, 0, LOGBF_TOLERANCE, 0},
{306, 3122346862u, 1111584337u, 3241148416u, 0, LOGBF_TOLERANCE, 0},
{307, 1052361612u, 1280025214u, 3221225472u, 0, LOGBF_TOLERANCE, 0},
{308, 906701409u, 2968301825u, 3247964160u, 0, LOGBF_TOLERANCE, 0},
{309, 3471653172u, 1154138102u, 1106247680u, 0, LOGBF_TOLERANCE, 0},
{310, 843024648u, 3166833184u, 3252158464u, 0, LOGBF_TOLERANCE, 0},
{311, 3231467496u, 934336592u, 1073741824u, 0, LOGBF_TOLERANCE, 0},
{312, 1341514497u, 3466051188u, 1107296256u, 0, LOGBF_TOLERANCE, 0},
{313, 1272351391u, 3373485062u, 1103101952u, 0, LOGBF_TOLERANCE, 0},
{314, 3319724992u, 3354615790u, 1094713344u, 0, LOGBF_TOLERANCE, 0},
{315, 3013402113u, 3266377514u, 3250585600u, 0, LOGBF_TOLERANCE, 0},
{316, 917622040u, 1334966485u, 3247439872u, 0, LOGBF_TOLERANCE, 0},
{317, 940236348u, 3304072663u, 3245342720u, 0, LOGBF_TOLERANCE, 0},
{318, 2963234879u, 977028681u, 3253731328u, 0, LOGBF_TOLERANCE, 0},
{319, 3251541546u, 3174764041u, 1082130432u, 0, LOGBF_TOLERANCE, 0},
{320, 3099843889u, 3355962282u, 3244294144u, 0, LOGBF_TOLERANCE, 0},
{321, 3110358400u, 851145088u, 3243245568u, 0, LOGBF_TOLERANCE, 0},
{322, 3371863479u, 1014861921u, 1099956224u, 0, LOGBF_TOLERANCE, 0},
{323, 3204069187u, 966573255u, 3221225472u, 0, LOGBF_TOLERANCE, 0},
{324, 1306460502u, 903489435u, 1105199104u, 0, LOGBF_TOLERANCE, 0},
{325, 1197542187u, 3024598921u, 1097859072u, 0, LOGBF_TOLERANCE, 0},
{326, 922888249u, 1139392309u, 3246915584u, 0, LOGBF_TOLERANCE, 0},
{327, 1184239996u, 3224098462u, 1096810496u, 0, LOGBF_TOLERANCE, 0},
{328, 1252490238u, 1173619825u, 1102053376u, 0, LOGBF_TOLERANCE, 0},
{329, 1001673627u, 3462631271u, 3238002688u, 0, LOGBF_TOLERANCE, 0},
{330, 976098044u, 1151967422u, 3241148416u, 0, LOGBF_TOLERANCE, 0},
{331, 941796645u, 886451963u, 3245342720u, 0, LOGBF_TOLERANCE, 0},
{332, 3006797923u, 1103058486u, 3251109888u, 0, LOGBF_TOLERANCE, 0},
{333, 855756273u, 3217259624u, 3251109888u, 0, LOGBF_TOLERANCE, 0},
{334, 3287199470u, 854245542u, 1090519040u, 0, LOGBF_TOLERANCE, 0},
{335, 893184329u, 1243067084u, 3249012736u, 0, LOGBF_TOLERANCE, 0},
{336, 1143233714u, 1007268238u, 1091567616u, 0, LOGBF_TOLERANCE, 0},
{337, 1139941253u, 1147688821u, 1090519040u, 0, LOGBF_TOLERANCE, 0},
{338, 3143717025u, 3234638157u, 3239051264u, 0, LOGBF_TOLERANCE, 0},
{339, 3048866608u, 3449209899u, 3248488448u, 0, LOGBF_TOLERANCE, 0},
{340, 3240298487u, 1020260821u, 1077936128u, 0, LOGBF_TOLERANCE, 0},
{341, 1288902137u, 3123875978u, 1104150528u, 0, LOGBF_TOLERANCE, 0},
{342, 1333134799u, 1338107877u, 1106771968u, 0, LOGBF_TOLERANCE, 0},
{343, 1187847971u, 1317663644u, 1096810496u, 0, LOGBF_TOLERANCE, 0},
{344, 1038851706u, 1327544110u, 3229614080u, 0, LOGBF_TOLERANCE, 0},
{345, 3329354473u, 3165437289u, 1095761920u, 0, LOGBF_TOLERANCE, 0},
{346, 3077218579u, 1308397879u, 3246915584u, 0, LOGBF_TOLERANCE, 0},
{347, 1309289088u, 1019883016u, 1105723392u, 0, LOGBF_TOLERANCE, 0},
{348, 2991550291u, 1294782875u, 3252158464u, 0, LOGBF_TOLERANCE, 0},
{349, 3444653659u, 1279248024u, 1104674816u, 0, LOGBF_TOLERANCE, 0},
{350, 3405585402u, 2962345057u, 1102053376u, 0, LOGBF_TOLERANCE, 0},
{351, 3106647724u, 853848387u, 3243245568u, 0, LOGBF_TOLERANCE, 0},
{352, 1106778573u, 3304487767u, 1082130432u, 0, LOGBF_TOLERANCE, 0},
{353, 1140567947u, 3069174149u, 1090519040u, 0, LOGBF_TOLERANCE, 0},
{354, 1238569473u, 873035665u, 1101004800u, 0, LOGBF_TOLERANCE, 0},
{355, 840375965u, 3223983207u, 3252158464u, 0, LOGBF_TOLERANCE, 0},
{356, 3154871957u, 1276671061u, 3235905536u, 0, LOGBF_TOLERANCE, 0},
{357, 1261071232u, 1182202773u, 1102577664u, 0, LOGBF_TOLERANCE, 0},
{358, 1175011025u, 3029705783u, 1095761920u, 0, LOGBF_TOLERANCE, 0},
{359, 1082692850u, 1211581107u, 1073741824u, 0, LOGBF_TOLERANCE, 0},
{360, 974547519u, 3475164509u, 3241148416u, 0, LOGBF_TOLERANCE, 0},
{361, 3058097085u, 3104309359u, 3247964160u, 0, LOGBF_TOLERANCE, 0},
{362, 3107252546u, 1071134451u, 3243245568u, 0, LOGBF_TOLERANCE, 0},
{363, 3096032662u, 2976848821u, 3244294144u, 0, LOGBF_TOLERANCE, 0},
{364, 3197942144u, 3094120030u, 3221225472u, 0, LOGBF_TOLERANCE, 0},
{365, 3403348556u, 3184653669u, 1102053376u, 0, LOGBF_TOLERANCE, 0},
{366, 2998032500u, 3373011130u, 3251634176u, 0, LOGBF_TOLERANCE, 0},
{367, 3182301130u, 3460764044u, 3229614080u, 0, LOGBF_TOLERANCE, 0},
{368, 1136411063u, 1118097422u, 1090519040u, 0, LOGBF_TOLERANCE, 0},
{369, 3239231622u, 3302723069u, 1077936128u, 0, LOGBF_TOLERANCE, 0},
{370, 3340615780u, 870350055u, 1097859072u, 0, LOGBF_TOLERANCE, 0},
{371, 998567360u, 2995278691u, 3238002688u, 0, LOGBF_TOLERANCE, 0},
{372, 3417964312u, 1321337529u, 1103101952u, 0, LOGBF_TOLERANCE, 0},
{373, 3109481038u, 1143864063u, 3243245568u, 0, LOGBF_TOLERANCE, 0},
{374, 1148867223u, 1256486202u, 1091567616u, 0, LOGBF_TOLERANCE, 0},
{375, 2960983878u, 1314196594u, 3254255616u, 0, LOGBF_TOLERANCE, 0},
{376, 989687421u, 3372681320u, 3240099840u, 0, LOGBF_TOLERANCE, 0},
{377, 1152956913u, 3166480640u, 1092616192u, 0, LOGBF_TOLERANCE, 0},
{378, 892922651u, 3373029087u, 3249012736u, 0, LOGBF_TOLERANCE, 0},
{379, 1109627625u, 1314158257u, 1084227584u, 0, LOGBF_TOLERANCE, 0},
{380, 1307091856u, 1103202538u, 1105199104u, 0, LOGBF_TOLERANCE, 0},
{381, 1077234132u, 3272167130u, 1065353216u, 0, LOGBF_TOLERANCE, 0},
{382, 1142167709u, 1096445242u, 1091567616u, 0, LOGBF_TOLERANCE, 0},
{383, 3426232834u, 1036705270u, 1103626240u, 0, LOGBF_TOLERANCE, 0},
{384, 3000726366u, 3172023300u, 3251634176u, 0, LOGBF_TOLERANCE, 0},
{385, 3368566779u, 967249167u, 1099956224u, 0, LOGBF_TOLERANCE, 0},
{386, 3030724760u, 3349013503u, 3249537024u, 0, LOGBF_TOLERANCE, 0},
{387, 1138741813u, 3073453199u, 1090519040u, 0, LOGBF_TOLERANCE, 0},
{388, 982950501u, 982549888u, 3240099840u, 0, LOGBF_TOLERANCE, 0},
{389, 1142981585u, 1015602236u, 1091567616u, 0, LOGBF_TOLERANCE, 0},
{390, 3016453868u, 3365560001u, 3250585600u, 0, LOGBF_TOLERANCE, 0},
{391, 3347165962u, 3135486696u, 1098907648u, 0, LOGBF_TOLERANCE, 0},
{392, 1009535440u, 3381353228u, 3235905536u, 0, LOGBF_TOLERANCE, 0},
{393, 3103736980u, 3402950505u, 3244294144u, 0, LOGBF_TOLERANCE, 0},
{394, 3126820946u, 1077903063u, 3241148416u, 0, LOGBF_TOLERANCE, 0},
{395, 3473956030u, 976891930u, 1106771968u, 0, LOGBF_TOLERANCE, 0},
{396, 3349098349u, 1055327704u, 1098907648u, 0, LOGBF_TOLERANCE, 0},
{397, 3152729489u, 1060398533u, 3238002688u, 0, LOGBF_TOLERANCE, 0},
{398, 945568720u, 3313485084u, 3245342720u, 0, LOGBF_TOLERANCE, 0},
{399, 3345489836u, 1108392401u, 1097859072u, 0, LOGBF_TOLERANCE, 0},
{400, 940893161u, 1137000140u, 3245342720u, 0, LOGBF_TOLERANCE, 0},
{401, 976791751u, 3230678102u, 3241148416u, 0, LOGBF_TOLERANCE, 0},
{402, 3013749677u, 1324802687u, 3250585600u, 0, LOGBF_TOLERANCE, 0},
{403, 1004442355u, 3036510596u, 3238002688u, 0, LOGBF_TOLERANCE, 0},
{404, 1108485380u, 3173536878u, 1084227584u, 0, LOGBF_TOLERANCE, 0},
{405, 1061834641u, 972388096u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{406, 3381268392u, 1146976802u, 1101004800u, 0, LOGBF_TOLERANCE, 0},
{407, 1087189715u, 2952822478u, 1073741824u, 0, LOGBF_TOLERANCE, 0},
{408, 3212952285u, 3329407365u, 0u, 0, LOGBF_TOLERANCE, 0},
{409, 1000611335u, 857599439u, 3238002688u, 0, LOGBF_TOLERANCE, 0},
{410, 847191250u, 1227905777u, 3252158464u, 0, LOGBF_TOLERANCE, 0},
{411, 3466188568u, 1041678304u, 1106247680u, 0, LOGBF_TOLERANCE, 0},
{412, 2968337765u, 3091399866u, 3253731328u, 0, LOGBF_TOLERANCE, 0},
{413, 3072456205u, 3160254633u, 3246915584u, 0, LOGBF_TOLERANCE, 0},
{414, 3319315516u, 3422089012u, 1094713344u, 0, LOGBF_TOLERANCE, 0},
{415, 935938416u, 1146676692u, 3246391296u, 0, LOGBF_TOLERANCE, 0},
{416, 3212614372u, 1152633030u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{417, 1315030230u, 3336225884u, 1105723392u, 0, LOGBF_TOLERANCE, 0},
{418, 822041816u, 898402905u, 3253731328u, 0, LOGBF_TOLERANCE, 0},
{419, 1134593658u, 3456812581u, 1090519040u, 0, LOGBF_TOLERANCE, 0},
{420, 977281449u, 879922831u, 3241148416u, 0, LOGBF_TOLERANCE, 0},
{421, 1086198791u, 920125958u, 1073741824u, 0, LOGBF_TOLERANCE, 0},
{422, 1255152035u, 851754050u, 1102053376u, 0, LOGBF_TOLERANCE, 0},
{423, 1135271264u, 3284878412u, 1090519040u, 0, LOGBF_TOLERANCE, 0},
{424, 1094190727u, 1056854532u, 1077936128u, 0, LOGBF_TOLERANCE, 0},
{425, 1294665325u, 991185677u, 1104674816u, 0, LOGBF_TOLERANCE, 0},
{426, 1036608591u, 805416536u, 3229614080u, 0, LOGBF_TOLERANCE, 0},
{427, 2960459834u, 1296239160u, 3254255616u, 0, LOGBF_TOLERANCE, 0},
{428, 3229998064u, 825237063u, 1073741824u, 0, LOGBF_TOLERANCE, 0},
{429, 3439134022u, 1043829691u, 1104150528u, 0, LOGBF_TOLERANCE, 0},
{430, 3073083133u, 1317170485u, 3246915584u, 0, LOGBF_TOLERANCE, 0},
{431, 1325668223u, 970681762u, 1106771968u, 0, LOGBF_TOLERANCE, 0},
{432, 1092037607u, 1027330835u, 1077936128u, 0, LOGBF_TOLERANCE, 0},
{433, 826457956u, 3343511749u, 3253207040u, 0, LOGBF_TOLERANCE, 0},
{434, 3316278408u, 3455589207u, 1094713344u, 0, LOGBF_TOLERANCE, 0},
{435, 3295436768u, 3129873731u, 1091567616u, 0, LOGBF_TOLERANCE, 0},
{436, 1151984049u, 3074547120u, 1092616192u, 0, LOGBF_TOLERANCE, 0},
{437, 1129287043u, 3076527544u, 1088421888u, 0, LOGBF_TOLERANCE, 0},
{438, 1243664530u, 972879810u, 1101529088u, 0, LOGBF_TOLERANCE, 0},
{439, 950829092u, 929114193u, 3244294144u, 0, LOGBF_TOLERANCE, 0},
{440, 1115471979u, 3047246262u, 1084227584u, 0, LOGBF_TOLERANCE, 0},
{441, 3351092088u, 3024661404u, 1098907648u, 0, LOGBF_TOLERANCE, 0},
{442, 3424479544u, 3312047722u, 1103626240u, 0, LOGBF_TOLERANCE, 0},
{443, 3241193975u, 884465785u, 1077936128u, 0, LOGBF_TOLERANCE, 0},
{444, 811700241u, 3478509398u, 3254255616u, 0, LOGBF_TOLERANCE, 0},
{445, 1030934236u, 1045139240u, 3231711232u, 0, LOGBF_TOLERANCE, 0},
{446, 3131791114u, 3408392958u, 3240099840u, 0, LOGBF_TOLERANCE, 0},
{447, 1025254314u, 3057812821u, 3231711232u, 0, LOGBF_TOLERANCE, 0},
{448, 1110545760u, 3240144177u, 1084227584u, 0, LOGBF_TOLERANCE, 0},
{449, 826998191u, 1091496527u, 3253207040u, 0, LOGBF_TOLERANCE, 0},
{450, 3180213739u, 1108793820u, 3229614080u, 0, LOGBF_TOLERANCE, 0},
{451, 3361976590u, 3138179993u, 1099431936u, 0, LOGBF_TOLERANCE, 0},
{452, 881280146u, 3421884736u, 3249537024u, 0, LOGBF_TOLERANCE, 0},
{453, 1304154705u, 2961937089u, 1105199104u, 0, LOGBF_TOLERANCE, 0},
{454, 3264443610u, 3222916705u, 1086324736u, 0, LOGBF_TOLERANCE, 0},
{455, 3374550627u, 3055856293u, 1100480512u, 0, LOGBF_TOLERANCE, 0},
{456, 2979664918u, 3365394784u, 3252682752u, 0, LOGBF_TOLERANCE, 0},
{457, 899599265u, 3240118211u, 3248488448u, 0, LOGBF_TOLERANCE, 0},
{458, 842476444u, 3452685905u, 3252158464u, 0, LOGBF_TOLERANCE, 0},
{459, 1268194719u, 1332489410u, 1103101952u, 0, LOGBF_TOLERANCE, 0},
{460, 1133420220u, 1245770860u, 1090519040u, 0, LOGBF_TOLERANCE, 0},
{461, 1161858787u, 815362075u, 1093664768u, 0, LOGBF_TOLERANCE, 0},
{462, 3184462258u, 1263529646u, 3229614080u, 0, LOGBF_TOLERANCE, 0},
{463, 3295996963u, 3453334307u, 1091567616u, 0, LOGBF_TOLERANCE, 0},
{464, 1270887389u, 1156123987u, 1103101952u, 0, LOGBF_TOLERANCE, 0},
{465, 3325193181u, 993979179u, 1095761920u, 0, LOGBF_TOLERANCE, 0},
{466, 925657343u, 1315159742u, 3246915584u, 0, LOGBF_TOLERANCE, 0},
{467, 3115275450u, 3008350271u, 3242196992u, 0, LOGBF_TOLERANCE, 0},
{468, 3116607482u, 3224327456u, 3242196992u, 0, LOGBF_TOLERANCE, 0},
{469, 3187892415u, 3118097315u, 3225419776u, 0, LOGBF_TOLERANCE, 0},
{470, 1189120494u, 978961471u, 1096810496u, 0, LOGBF_TOLERANCE, 0},
{471, 889030794u, 3129523970u, 3249537024u, 0, LOGBF_TOLERANCE, 0},
{472, 1323529208u, 3100744786u, 1106247680u, 0, LOGBF_TOLERANCE, 0},
{473, 2975945347u, 940445933u, 3253207040u, 0, LOGBF_TOLERANCE, 0},
{474, 3465768388u, 3190881451u, 1106247680u, 0, LOGBF_TOLERANCE, 0},
{475, 3426099899u, 1118756120u, 1103626240u, 0, LOGBF_TOLERANCE, 0},
{476, 3224857113u, 3398166843u, 1065353216u, 0, LOGBF_TOLERANCE, 0},
{477, 1065798296u, 816191940u, 0u, 0, LOGBF_TOLERANCE, 0},
{478, 3328989444u, 850266225u, 1095761920u, 0, LOGBF_TOLERANCE, 0},
{479, 3357819026u, 3148475462u, 1099431936u, 0, LOGBF_TOLERANCE, 0},
{480, 1273397670u, 901308750u, 1103101952u, 0, LOGBF_TOLERANCE, 0},
{481, 3424831780u, 1304806106u, 1103626240u, 0, LOGBF_TOLERANCE, 0},
{482, 1257596246u, 3420832544u, 1102053376u, 0, LOGBF_TOLERANCE, 0},
{483, 1051773536u, 896271348u, 3221225472u, 0, LOGBF_TOLERANCE, 0},
{484, 3294752507u, 3113225954u, 1091567616u, 0, LOGBF_TOLERANCE, 0},
{485, 3424848725u, 2973850350u, 1103626240u, 0, LOGBF_TOLERANCE, 0},
{486, 1090870906u, 3294742905u, 1077936128u, 0, LOGBF_TOLERANCE, 0},
{487, 1227582289u, 1208979668u, 1100480512u, 0, LOGBF_TOLERANCE, 0},
{488, 2996780709u, 852318215u, 3251634176u, 0, LOGBF_TOLERANCE, 0},
{489, 1272325814u, 3004311296u, 1103101952u, 0, LOGBF_TOLERANCE, 0},
{490, 3359508271u, 859974315u, 1099431936u, 0, LOGBF_TOLERANCE, 0},
{491, 2992737514u, 2999023943u, 3252158464u, 0, LOGBF_TOLERANCE, 0},
{492, 1137854355u, 3335041917u, 1090519040u, 0, LOGBF_TOLERANCE, 0},
{493, 3440773058u, 3204192793u, 1104674816u, 0, LOGBF_TOLERANCE, 0},
{494, 3101598400u, 3057760708u, 3244294144u, 0, LOGBF_TOLERANCE, 0},
{495, 3451216836u, 3347783723u, 1105199104u, 0, LOGBF_TOLERANCE, 0},
{496, 3437062994u, 3106834845u, 1104150528u, 0, LOGBF_TOLERANCE, 0},
{497, 1131196082u, 1164573183u, 1088421888u, 0, LOGBF_TOLERANCE, 0},
{498, 3177294154u, 1282436638u, 3231711232u, 0, LOGBF_TOLERANCE, 0},
{499, 3258097678u, 1305882290u, 1084227584u, 0, LOGBF_TOLERANCE, 0},
{500, 3460915348u, 1219372260u, 1105723392u, 0, LOGBF_TOLERANCE, 0},
{501, 3009547195u, 1256074626u, 3251109888u, 0, LOGBF_TOLERANCE, 0},
{502, 3303035472u, 3153013020u, 1092616192u, 0, LOGBF_TOLERANCE, 0},
{503, 1053698677u, 3284313107u, 3221225472u, 0, LOGBF_TOLERANCE, 0},
{504, 3396166221u, 1201894512u, 1101529088u, 0, LOGBF_TOLERANCE, 0},
{505, 3037541131u, 1085398440u, 3249012736u, 0, LOGBF_TOLERANCE, 0},
{506, 3458934263u, 1005577835u, 1105723392u, 0, LOGBF_TOLERANCE, 0},
{507, 1065761827u, 3333928591u, 0u, 0, LOGBF_TOLERANCE, 0},
{508, 3025843188u, 820250112u, 3250061312u, 0, LOGBF_TOLERANCE, 0},
{509, 3017430347u, 3009209071u, 3250585600u, 0, LOGBF_TOLERANCE, 0},
{510, 926665223u, 3150815797u, 3246915584u, 0, LOGBF_TOLERANCE, 0},
{511, 2970966181u, 3383521344u, 3253207040u, 0, LOGBF_TOLERANCE, 0},
{512, 1199816046u, 3143776186u, 1098907648u, 0, LOGBF_TOLERANCE, 0},
{513, 3333779015u, 952421041u, 1096810496u, 0, LOGBF_TOLERANCE, 0},
{514, 856234019u, 3091454180u, 3251109888u, 0, LOGBF_TOLERANCE, 0},
{515, 948398145u, 3238273189u, 3244294144u, 0, LOGBF_TOLERANCE, 0},
{516, 3054021468u, 1270257895u, 3247964160u, 0, LOGBF_TOLERANCE, 0},
{517, 1080781593u, 1213908300u, 1065353216u, 0, LOGBF_TOLERANCE, 0},
{518, 3164749613u, 3010837763u, 3233808384u, 0, LOGBF_TOLERANCE, 0},
{519, 2971341371u, 1014754300u, 3253207040u, 0, LOGBF_TOLERANCE, 0},
{520, 3235326590u, 1271705594u, 1073741824u, 0, LOGBF_TOLERANCE, 0},
{521, 3118883815u, 1051802647u, 3242196992u, 0, LOGBF_TOLERANCE, 0},
{522, 965378004u, 1292594138u, 3242196992u, 0, LOGBF_TOLERANCE, 0},
{523, 3226990408u, 1110755136u, 1065353216u, 0, LOGBF_TOLERANCE, 0},
{524, 2953069847u, 3293953199u, 3254255616u, 0, LOGBF_TOLERANCE, 0},
{525, 3117098218u, 1122474770u, 3242196992u, 0, LOGBF_TOLERANCE, 0},
{526, 1283624229u, 906796922u, 1104150528u, 0, LOGBF_TOLERANCE, 0},
{527, 860729004u, 1163935062u, 3251109888u, 0, LOGBF_TOLERANCE, 0},
{528, 970649315u, 1078286437u, 3242196992u, 0, LOGBF_TOLERANCE, 0},
{529, 959776291u, 3280345347u, 3243245568u, 0, LOGBF_TOLERANCE, 0},
{530, 3341117305u, 3294559023u, 1097859072u, 0, LOGBF_TOLERANCE, 0},
{531, 1270734970u, 3355874874u, 1103101952u, 0, LOGBF_TOLERANCE, 0},
{532, 3454816067u, 868771977u, 1105199104u, 0, LOGBF_TOLERANCE, 0},
{533, 917206623u, 1172710814u, 3247439872u, 0, LOGBF_TOLERANCE, 0},
{534, 1106502045u, 1290849316u, 1082130432u, 0, LOGBF_TOLERANCE, 0},
{535, 1157598381u, 3309023746u, 1092616192u, 0, LOGBF_TOLERANCE, 0},
{536, 835476614u, 1092590501u, 3252682752u, 0, LOGBF_TOLERANCE, 0},
{537, 3335234513u, 1002337336u, 1096810496u, 0, LOGBF_TOLERANCE, 0},
{538, 1279489061u, 1006049444u, 1103626240u, 0, LOGBF_TOLERANCE, 0},
{539, 807133892u, 1110992491u, 3254255616u, 0, LOGBF_TOLERANCE, 0},
{540, 3157416480u, 1309984610u, 3235905536u, 0, LOGBF_TOLERANCE, 0},
{541, 3143920719u, 3131608518u, 3239051264u, 0, LOGBF_TOLERANCE, 0},
{542, 2995340689u, 1165036009u, 3251634176u, 0, LOGBF_TOLERANCE, 0},
{543, 1233171235u, 826460580u, 1101004800u, 0, LOGBF_TOLERANCE, 0},
{544, 1148920078u, 1007674793u, 1091567616u, 0, LOGBF_TOLERANCE, 0},
{545, 3064988156u, 3230867340u, 3247439872u, 0, LOGBF_TOLERANCE, 0},
{546, 3083619260u, 1159415661u, 3246391296u, 0, LOGBF_TOLERANCE, 0},
{547, 1109198803u, 1221754614u, 1084227584u, 0, LOGBF_TOLERANCE, 0},
{548, 3219949483u, 1056167693u, 0u, 0, LOGBF_TOLERANCE, 0},
{549, 3361149474u, 3387342069u, 1099431936u, 0, LOGBF_TOLERANCE, 0},
{550, 827931800u, 1118474231u, 3253207040u, 0, LOGBF_TOLERANCE, 0},
{551, 1207502108u, 3388073586u, 1098907648u, 0, LOGBF_TOLERANCE, 0},
{552, 1000014431u, 831213088u, 3238002688u, 0, LOGBF_TOLERANCE, 0},
{553, 3161756316u, 3143659754u, 3235905536u, 0, LOGBF_TOLERANCE, 0},
{554, 3160728744u, 3382954009u, 3235905536u, 0, LOGBF_TOLERANCE, 0},
{555, 1234530539u, 1079988872u, 1101004800u, 0, LOGBF_TOLERANCE, 0},
{556, 1017843965u, 1193076204u, 3233808384u, 0, LOGBF_TOLERANCE, 0},
{557, 2965746635u, 3248194237u, 3253731328u, 0, LOGBF_TOLERANCE, 0},
{558, 951862956u, 1173464654u, 3244294144u, 0, LOGBF_TOLERANCE, 0},
{559, 3306328852u, 1118701064u, 1093664768u, 0, LOGBF_TOLERANCE, 0},
{560, 1291910469u, 1211303367u, 1104674816u, 0, LOGBF_TOLERANCE, 0},
{561, 3027442905u, 1173894400u, 3250061312u, 0, LOGBF_TOLERANCE, 0},
{562, 809646928u, 3006525025u, 3254255616u, 0, LOGBF_TOLERANCE, 0},
{563, 1131927531u, 3182962700u, 1088421888u, 0, LOGBF_TOLERANCE, 0},
{564, 3449879391u, 991614550u, 1105199104u, 0, LOGBF_TOLERANCE, 0},
{565, 970094304u, 3344590506u, 3242196992u, 0, LOGBF_TOLERANCE, 0},
{566, 1125551064u, 3331248076u, 1088421888u, 0, LOGBF_TOLERANCE, 0},
{567, 3427296372u, 3455289118u, 1103626240u, 0, LOGBF_TOLERANCE, 0},
{568, 1198917460u, 1327195159u, 1097859072u, 0, LOGBF_TOLERANCE, 0},
{569, 3201603336u, 820047343u, 3221225472u, 0, LOGBF_TOLERANCE, 0},
{570, 3114686212u, 3476082461u, 3242196992u, 0, LOGBF_TOLERANCE, 0},
{571, 921940707u, 2967544056u, 3247439872u, 0, LOGBF_TOLERANCE, 0},
{572, 1091906532u, 3011904455u, 1077936128u, 0, LOGBF_TOLERANCE, 0},
{573, 3393557778u, 3383396815u, 1101529088u, 0, LOGBF_TOLERANCE, 0},
{574, 1276853215u, 873199561u, 1103626240u, 0, LOGBF_TOLERANCE, 0},
{575, 3462778440u, 3349284325u, 1105723392u, 0, LOGBF_TOLERANCE, 0},
{576, 833132358u, 3470358002u, 3252682752u, 0, LOGBF_TOLERANCE, 0},
{577, 3360170117u, 3048354042u, 1099431936u, 0, LOGBF_TOLERANCE, 0},
{578, 3224245428u, 3271307999u, 1065353216u, 0, LOGBF_TOLERANCE, 0},
{579, 1120124467u, 1135619937u, 1086324736u, 0, LOGBF_TOLERANCE, 0},
{580, 1064364381u, 3180675544u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{581, 1268744779u, 3328452652u, 1103101952u, 0, LOGBF_TOLERANCE, 0},
{582, 1165195428u, 3390323168u, 1093664768u, 0, LOGBF_TOLERANCE, 0},
{583, 3044092739u, 1106497311u, 3249012736u, 0, LOGBF_TOLERANCE, 0},
{584, 3149469534u, 1278465842u, 3238002688u, 0, LOGBF_TOLERANCE, 0},
{585, 3247790039u, 909788142u, 1082130432u, 0, LOGBF_TOLERANCE, 0},
{586, 3215244648u, 1083988595u, 0u, 0, LOGBF_TOLERANCE, 0},
{587, 3095275931u, 989153382u, 3245342720u, 0, LOGBF_TOLERANCE, 0},
{588, 3059688264u, 1117455718u, 3247964160u, 0, LOGBF_TOLERANCE, 0},
{589, 2990022513u, 1061714285u, 3252158464u, 0, LOGBF_TOLERANCE, 0},
{590, 1212717473u, 837873779u, 1099431936u, 0, LOGBF_TOLERANCE, 0},
{591, 3275973009u, 3450721670u, 1088421888u, 0, LOGBF_TOLERANCE, 0},
{592, 3028857014u, 3188853813u, 3249537024u, 0, LOGBF_TOLERANCE, 0},
{593, 3391162308u, 1291220039u, 1101529088u, 0, LOGBF_TOLERANCE, 0},
{594, 1044867873u, 3369493273u, 3225419776u, 0, LOGBF_TOLERANCE, 0},
{595, 1089986803u, 3462160118u, 1073741824u, 0, LOGBF_TOLERANCE, 0},
{596, 1296314700u, 2957454177u, 1104674816u, 0, LOGBF_TOLERANCE, 0},
{597, 1251462432u, 3171021770u, 1102053376u, 0, LOGBF_TOLERANCE, 0},
{598, 3485236902u, 980772835u, 1107296256u, 0, LOGBF_TOLERANCE, 0},
{599, 3262169538u, 1268270462u, 1084227584u, 0, LOGBF_TOLERANCE, 0},
{600, 3080852256u, 994641495u, 3246391296u, 0, LOGBF_TOLERANCE, 0},
{601, 1022211242u, 922124181u, 3233808384u, 0, LOGBF_TOLERANCE, 0},
{602, 884661176u, 2985540645u, 3249537024u, 0, LOGBF_TOLERANCE, 0},
{603, 3071422941u, 3271100396u, 3246915584u, 0, LOGBF_TOLERANCE, 0},
{604, 989762529u, 3362011135u, 3240099840u, 0, LOGBF_TOLERANCE, 0},
{605, 1295475718u, 3212305413u, 1104674816u, 0, LOGBF_TOLERANCE, 0},
{606, 1002632518u, 3330388441u, 3238002688u, 0, LOGBF_TOLERANCE, 0},
{607, 3404372005u, 3450484255u, 1102053376u, 0, LOGBF_TOLERANCE, 0},
{608, 3158912530u, 3105501826u, 3235905536u, 0, LOGBF_TOLERANCE, 0},
{609, 2987029985u, 1218447414u, 3252158464u, 0, LOGBF_TOLERANCE, 0},
{610, 1125800069u, 3256265749u, 1088421888u, 0, LOGBF_TOLERANCE, 0},
{611, 3138037576u, 3103365227u, 3239051264u, 0, LOGBF_TOLERANCE, 0},
{612, 3108384823u, 1300246663u, 3243245568u, 0, LOGBF_TOLERANCE, 0},
{613, 999985470u, 3409354318u, 3238002688u, 0, LOGBF_TOLERANCE, 0},
{614, 1189421739u, 1056599002u, 1096810496u, 0, LOGBF_TOLERANCE, 0},
{615, 3075182644u, 3144159778u, 3246915584u, 0, LOGBF_TOLERANCE, 0},
{616, 3028099649u, 3391513557u, 3250061312u, 0, LOGBF_TOLERANCE, 0},
{617, 837703706u, 3467473756u, 3252682752u, 0, LOGBF_TOLERANCE, 0},
{618, 3132541814u, 3444521949u, 3240099840u, 0, LOGBF_TOLERANCE, 0},
{619, 1164046161u, 3440635788u, 1093664768u, 0, LOGBF_TOLERANCE, 0},
{620, 1292596266u, 3116569667u, 1104674816u, 0, LOGBF_TOLERANCE, 0},
{621, 3469748379u, 3412765608u, 1106247680u, 0, LOGBF_TOLERANCE, 0},
{622, 2968771722u, 3117531540u, 3253731328u, 0, LOGBF_TOLERANCE, 0},
{623, 1314644642u, 3123051784u, 1105723392u, 0, LOGBF_TOLERANCE, 0},
{624, 3399813173u, 828743798u, 1102053376u, 0, LOGBF_TOLERANCE, 0},
{625, 948775569u, 3485444126u, 3244294144u, 0, LOGBF_TOLERANCE, 0},
{626, 1034611395u, 882288581u, 3229614080u, 0, LOGBF_TOLERANCE, 0},
{627, 3489122735u, 3372450889u, 1107296256u, 0, LOGBF_TOLERANCE, 0},
{628, 1181604787u, 3363067409u, 1095761920u, 0, LOGBF_TOLERANCE, 0},
{629, 3059042077u, 3204983963u, 3247964160u, 0, LOGBF_TOLERANCE, 0},
{630, 1043691622u, 3402603223u, 3225419776u, 0, LOGBF_TOLERANCE, 0},
{631, 1314588083u, 856187848u, 1105723392u, 0, LOGBF_TOLERANCE, 0},
{632, 3141533334u, 3010142974u, 3239051264u, 0, LOGBF_TOLERANCE, 0},
{633, 3013416703u, 3442525943u, 3250585600u, 0, LOGBF_TOLERANCE, 0},
{634, 861266716u, 822172554u, 3251109888u, 0, LOGBF_TOLERANCE, 0},
{635, 3157534378u, 3451674717u, 3235905536u, 0, LOGBF_TOLERANCE, 0},
{636, 2976169000u, 3033697153u, 3253207040u, 0, LOGBF_TOLERANCE, 0},
{637, 3400949680u, 3073750220u, 1102053376u, 0, LOGBF_TOLERANCE, 0},
{638, 3365581801u, 1175843167u, 1099956224u, 0, LOGBF_TOLERANCE, 0},
{639, 1110424755u, 3011308654u, 1084227584u, 0, LOGBF_TOLERANCE, 0},
{640, 3189917167u, 927278934u, 3225419776u, 0, LOGBF_TOLERANCE, 0},
{641, 969804941u, 3355439348u, 3242196992u, 0, LOGBF_TOLERANCE, 0},
{642, 1139120919u, 3270515074u, 1090519040u, 0, LOGBF_TOLERANCE, 0},
{643, 816789141u, 3325199970u, 3253731328u, 0, LOGBF_TOLERANCE, 0},
{644, 934308144u, 3118191228u, 3246391296u, 0, LOGBF_TOLERANCE, 0},
{645, 1220524226u, 1152648002u, 1099956224u, 0, LOGBF_TOLERANCE, 0},
{646, 3162548604u, 3461790298u, 3233808384u, 0, LOGBF_TOLERANCE, 0},
{647, 3382391700u, 3296962745u, 1101004800u, 0, LOGBF_TOLERANCE, 0},
{648, 1156767533u, 1088986462u, 1092616192u, 0, LOGBF_TOLERANCE, 0},
{649, 3079222483u, 3312324949u, 3246391296u, 0, LOGBF_TOLERANCE, 0},
{650, 994934087u, 967678094u, 3239051264u, 0, LOGBF_TOLERANCE, 0},
{651, 840906467u, 3156591981u, 3252158464u, 0, LOGBF_TOLERANCE, 0},
{652, 3185240099u, 1123403720u, 3229614080u, 0, LOGBF_TOLERANCE, 0},
{653, 870026344u, 1093936408u, 3250585600u, 0, LOGBF_TOLERANCE, 0},
{654, 2996887005u, 3287317742u, 3251634176u, 0, LOGBF_TOLERANCE, 0},
{655, 3479873563u, 1246277393u, 1106771968u, 0, LOGBF_TOLERANCE, 0},
{656, 3424264117u, 3434026174u, 1103626240u, 0, LOGBF_TOLERANCE, 0},
{657, 3228365887u, 1216775310u, 1065353216u, 0, LOGBF_TOLERANCE, 0},
{658, 1035909900u, 1249532942u, 3229614080u, 0, LOGBF_TOLERANCE, 0},
{659, 2989750574u, 1274271338u, 3252158464u, 0, LOGBF_TOLERANCE, 0},
{660, 3024951184u, 1247632131u, 3250061312u, 0, LOGBF_TOLERANCE, 0},
{661, 1212129651u, 3017366784u, 1099431936u, 0, LOGBF_TOLERANCE, 0},
{662, 3125775254u, 955826310u, 3241148416u, 0, LOGBF_TOLERANCE, 0},
{663, 1037464105u, 3121544932u, 3229614080u, 0, LOGBF_TOLERANCE, 0},
{664, 1311706596u, 1254918706u, 1105723392u, 0, LOGBF_TOLERANCE, 0},
{665, 918212457u, 1017468331u, 3247439872u, 0, LOGBF_TOLERANCE, 0},
{666, 1337315179u, 3461361185u, 1107296256u, 0, LOGBF_TOLERANCE, 0},
{667, 1131358407u, 3325958870u, 1088421888u, 0, LOGBF_TOLERANCE, 0},
{668, 1156517523u, 3343716230u, 1092616192u, 0, LOGBF_TOLERANCE, 0},
{669, 3210802820u, 3207408574u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{670, 3337499209u, 1226297264u, 1096810496u, 0, LOGBF_TOLERANCE, 0},
{671, 3468429030u, 3253874001u, 1106247680u, 0, LOGBF_TOLERANCE, 0},
{672, 3253515800u, 1189005947u, 1082130432u, 0, LOGBF_TOLERANCE, 0},
{673, 3055299953u, 3047908678u, 3247964160u, 0, LOGBF_TOLERANCE, 0},
{674, 959956547u, 876324728u, 3243245568u, 0, LOGBF_TOLERANCE, 0},
{675, 3425290480u, 1139193797u, 1103626240u, 0, LOGBF_TOLERANCE, 0},
{676, 1039917375u, 1122740999u, 3229614080u, 0, LOGBF_TOLERANCE, 0},
{677, 3220979495u, 3429223871u, 0u, 0, LOGBF_TOLERANCE, 0},
{678, 1311016004u, 3334899880u, 1105723392u, 0, LOGBF_TOLERANCE, 0},
{679, 2995451172u, 2974546424u, 3251634176u, 0, LOGBF_TOLERANCE, 0},
{680, 1128016396u, 1105151547u, 1088421888u, 0, LOGBF_TOLERANCE, 0},
{681, 3210335769u, 3100646155u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{682, 3022705759u, 3404762495u, 3250061312u, 0, LOGBF_TOLERANCE, 0},
{683, 1206054701u, 826010009u, 1098907648u, 0, LOGBF_TOLERANCE, 0},
{684, 3144504834u, 1162227076u, 3239051264u, 0, LOGBF_TOLERANCE, 0},
{685, 822524010u, 970745811u, 3253207040u, 0, LOGBF_TOLERANCE, 0},
{686, 3016981460u, 3313826904u, 3250585600u, 0, LOGBF_TOLERANCE, 0},
{687, 1213609983u, 919983950u, 1099431936u, 0, LOGBF_TOLERANCE, 0},
{688, 1246902946u, 3064047808u, 1101529088u, 0, LOGBF_TOLERANCE, 0},
{689, 995850843u, 1332031130u, 3239051264u, 0, LOGBF_TOLERANCE, 0},
{690, 3362082828u, 3374056268u, 1099431936u, 0, LOGBF_TOLERANCE, 0},
{691, 1029480631u, 3047777170u, 3231711232u, 0, LOGBF_TOLERANCE, 0},
{692, 3153568584u, 3106514232u, 3238002688u, 0, LOGBF_TOLERANCE, 0},
{693, 3384988527u, 3109485565u, 1101004800u, 0, LOGBF_TOLERANCE, 0},
{694, 1317696241u, 870681806u, 1106247680u, 0, LOGBF_TOLERANCE, 0},
{695, 3235395924u, 1132055244u, 1073741824u, 0, LOGBF_TOLERANCE, 0},
{696, 3341877624u, 2969495570u, 1097859072u, 0, LOGBF_TOLERANCE, 0},
{697, 1228636133u, 886552820u, 1100480512u, 0, LOGBF_TOLERANCE, 0},
{698, 3161654634u, 3335899347u, 3235905536u, 0, LOGBF_TOLERANCE, 0},
{699, 3162655243u, 3307203982u, 3233808384u, 0, LOGBF_TOLERANCE, 0},
{700, 1207246237u, 859223639u, 1098907648u, 0, LOGBF_TOLERANCE, 0},
{701, 1165476654u, 3350219111u, 1093664768u, 0, LOGBF_TOLERANCE, 0},
{702, 1215278023u, 3019755242u, 1099431936u, 0, LOGBF_TOLERANCE, 0},
{703, 1017239798u, 3438501281u, 3233808384u, 0, LOGBF_TOLERANCE, 0},
{704, 1149651309u, 970030475u, 1092616192u, 0, LOGBF_TOLERANCE, 0},
{705, 1111943722u, 3122211334u, 1084227584u, 0, LOGBF_TOLERANCE, 0},
{706, 856374764u, 1158358450u, 3251109888u, 0, LOGBF_TOLERANCE, 0},
{707, 1189849849u, 3382739134u, 1096810496u, 0, LOGBF_TOLERANCE, 0},
{708, 3204848496u, 3141519085u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{709, 1249758327u, 3104759211u, 1101529088u, 0, LOGBF_TOLERANCE, 0},
{710, 3092982276u, 3445282331u, 3245342720u, 0, LOGBF_TOLERANCE, 0},
{711, 1168098747u, 1316854744u, 1094713344u, 0, LOGBF_TOLERANCE, 0},
{712, 892549317u, 1179637545u, 3249012736u, 0, LOGBF_TOLERANCE, 0},
{713, 3301009024u, 3406174560u, 1092616192u, 0, LOGBF_TOLERANCE, 0},
{714, 3233089227u, 1212652543u, 1073741824u, 0, LOGBF_TOLERANCE, 0},
{715, 3218245284u, 1238873830u, 0u, 0, LOGBF_TOLERANCE, 0},
{716, 3215981890u, 3240474694u, 0u, 0, LOGBF_TOLERANCE, 0},
{717, 1266687209u, 3092038122u, 1103101952u, 0, LOGBF_TOLERANCE, 0},
{718, 825230580u, 3410090781u, 3253207040u, 0, LOGBF_TOLERANCE, 0},
{719, 3487959775u, 3331372071u, 1107296256u, 0, LOGBF_TOLERANCE, 0},
{720, 943645710u, 852875779u, 3245342720u, 0, LOGBF_TOLERANCE, 0},
{721, 3345065699u, 3282620725u, 1097859072u, 0, LOGBF_TOLERANCE, 0},
{722, 935847271u, 1067255804u, 3246391296u, 0, LOGBF_TOLERANCE, 0},
{723, 3410336089u, 1111437780u, 1102577664u, 0, LOGBF_TOLERANCE, 0},
{724, 3082940740u, 1336840432u, 3246391296u, 0, LOGBF_TOLERANCE, 0},
{725, 1141063391u, 1168908072u, 1091567616u, 0, LOGBF_TOLERANCE, 0},
{726, 3059263153u, 3067795684u, 3247964160u, 0, LOGBF_TOLERANCE, 0},
{727, 849450947u, 3289799763u, 3251634176u, 0, LOGBF_TOLERANCE, 0},
{728, 3353679791u, 897158391u, 1098907648u, 0, LOGBF_TOLERANCE, 0},
{729, 1001823878u, 1016826861u, 3238002688u, 0, LOGBF_TOLERANCE, 0},
{730, 1009130212u, 1004302940u, 3235905536u, 0, LOGBF_TOLERANCE, 0},
{731, 3367127535u, 943136342u, 1099956224u, 0, LOGBF_TOLERANCE, 0},
{732, 1032920919u, 3449126417u, 3229614080u, 0, LOGBF_TOLERANCE, 0},
{733, 3281952870u, 3147012185u, 1090519040u, 0, LOGBF_TOLERANCE, 0},
{734, 1237868497u, 3048281802u, 1101004800u, 0, LOGBF_TOLERANCE, 0},
{735, 1153753924u, 3322269242u, 1092616192u, 0, LOGBF_TOLERANCE, 0},
{736, 1120261759u, 892210998u, 1086324736u, 0, LOGBF_TOLERANCE, 0},
{737, 3226328360u, 3366432856u, 1065353216u, 0, LOGBF_TOLERANCE, 0},
{738, 3349595986u, 3251588707u, 1098907648u, 0, LOGBF_TOLERANCE, 0},
{739, 3166889490u, 3306023523u, 3233808384u, 0, LOGBF_TOLERANCE, 0},
{740, 1087750238u, 1099325523u, 1073741824u, 0, LOGBF_TOLERANCE, 0},
{741, 3121620061u, 3359488363u, 3241148416u, 0, LOGBF_TOLERANCE, 0},
{742, 1066116543u, 3072159933u, 0u, 0, LOGBF_TOLERANCE, 0},
{743, 3210898034u, 2981803389u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{744, 3051923237u, 3364074347u, 3248488448u, 0, LOGBF_TOLERANCE, 0},
{745, 1030612298u, 3345396001u, 3231711232u, 0, LOGBF_TOLERANCE, 0},
{746, 3015019212u, 989161453u, 3250585600u, 0, LOGBF_TOLERANCE, 0},
{747, 1186234578u, 858134374u, 1096810496u, 0, LOGBF_TOLERANCE, 0},
{748, 1331680743u, 1009396165u, 1106771968u, 0, LOGBF_TOLERANCE, 0},
{749, 847857044u, 894661023u, 3251634176u, 0, LOGBF_TOLERANCE, 0},
{750, 3060774997u, 1326067357u, 3247964160u, 0, LOGBF_TOLERANCE, 0},
{751, 887589411u, 1292305693u, 3249537024u, 0, LOGBF_TOLERANCE, 0},
{752, 1045232522u, 3234993273u, 3225419776u, 0, LOGBF_TOLERANCE, 0},
{753, 3119858470u, 962515365u, 3242196992u, 0, LOGBF_TOLERANCE, 0},
{754, 3002873011u, 3188748064u, 3251634176u, 0, LOGBF_TOLERANCE, 0},
{755, 3349432725u, 928848003u, 1098907648u, 0, LOGBF_TOLERANCE, 0},
{756, 912423027u, 3184646319u, 3247964160u, 0, LOGBF_TOLERANCE, 0},
{757, 3228795133u, 3273940030u, 1065353216u, 0, LOGBF_TOLERANCE, 0},
{758, 3194674746u, 3112269709u, 3225419776u, 0, LOGBF_TOLERANCE, 0},
{759, 3296784303u, 3276182352u, 1092616192u, 0, LOGBF_TOLERANCE, 0},
{760, 965402291u, 3107104376u, 3242196992u, 0, LOGBF_TOLERANCE, 0},
{761, 3388153589u, 3426245389u, 1101004800u, 0, LOGBF_TOLERANCE, 0},
{762, 1133410485u, 3329658993u, 1090519040u, 0, LOGBF_TOLERANCE, 0},
{763, 3136790322u, 1088652637u, 3240099840u, 0, LOGBF_TOLERANCE, 0},
{764, 3369970587u, 959121458u, 1099956224u, 0, LOGBF_TOLERANCE, 0},
{765, 1270451568u, 928393353u, 1103101952u, 0, LOGBF_TOLERANCE, 0},
{766, 989498922u, 3088358419u, 3240099840u, 0, LOGBF_TOLERANCE, 0},
{767, 1280215674u, 3148135875u, 1103626240u, 0, LOGBF_TOLERANCE, 0},
{768, 1171873518u, 954709738u, 1094713344u, 0, LOGBF_TOLERANCE, 0},
{769, 3298258100u, 935525182u, 1092616192u, 0, LOGBF_TOLERANCE, 0},
{770, 3415208824u, 822843236u, 1103101952u, 0, LOGBF_TOLERANCE, 0},
{771, 1001897182u, 3191875320u, 3238002688u, 0, LOGBF_TOLERANCE, 0},
{772, 3152777939u, 3245830463u, 3238002688u, 0, LOGBF_TOLERANCE, 0},
{773, 985903305u, 3333087577u, 3240099840u, 0, LOGBF_TOLERANCE, 0},
{774, 3357328848u, 859306298u, 1099431936u, 0, LOGBF_TOLERANCE, 0},
{775, 2967395608u, 3077307650u, 3253731328u, 0, LOGBF_TOLERANCE, 0},
{776, 982612185u, 923582663u, 3240099840u, 0, LOGBF_TOLERANCE, 0},
{777, 3267868136u, 1208301947u, 1086324736u, 0, LOGBF_TOLERANCE, 0},
{778, 3319048157u, 1172271145u, 1094713344u, 0, LOGBF_TOLERANCE, 0},
{779, 1144755661u, 860947435u, 1091567616u, 0, LOGBF_TOLERANCE, 0},
{780, 840456845u, 1051585760u, 3252158464u, 0, LOGBF_TOLERANCE, 0},
{781, 898467286u, 839254959u, 3248488448u, 0, LOGBF_TOLERANCE, 0},
{782, 3301461672u, 1233693827u, 1092616192u, 0, LOGBF_TOLERANCE, 0},
{783, 3364525678u, 3089849671u, 1099956224u, 0, LOGBF_TOLERANCE, 0},
{784, 871130681u, 905123007u, 3250585600u, 0, LOGBF_TOLERANCE, 0},
{785, 931441127u, 1133424555u, 3246391296u, 0, LOGBF_TOLERANCE, 0},
{786, 3146660041u, 3143695961u, 3238002688u, 0, LOGBF_TOLERANCE, 0},
{787, 3467121799u, 3023584354u, 1106247680u, 0, LOGBF_TOLERANCE, 0},
{788, 1151257041u, 3084216427u, 1092616192u, 0, LOGBF_TOLERANCE, 0},
{789, 3097873255u, 3219266640u, 3244294144u, 0, LOGBF_TOLERANCE, 0},
{790, 3130670309u, 3192399254u, 3240099840u, 0, LOGBF_TOLERANCE, 0},
{791, 1017573824u, 3130901062u, 3233808384u, 0, LOGBF_TOLERANCE, 0},
{792, 1258369714u, 3462258576u, 1102577664u, 0, LOGBF_TOLERANCE, 0},
{793, 1216602683u, 3371396332u, 1099956224u, 0, LOGBF_TOLERANCE, 0},
{794, 2976429847u, 959973239u, 3253207040u, 0, LOGBF_TOLERANCE, 0},
{795, 3297265739u, 1214184410u, 1092616192u, 0, LOGBF_TOLERANCE, 0},
{796, 1071940738u, 3311731012u, 0u, 0, LOGBF_TOLERANCE, 0},
{797, 922601356u, 3337171870u, 3247439872u, 0, LOGBF_TOLERANCE, 0},
{798, 3462285635u, 3444030332u, 1105723392u, 0, LOGBF_TOLERANCE, 0},
{799, 3357177805u, 1085464241u, 1099431936u, 0, LOGBF_TOLERANCE, 0},
{800, 3049120080u, 900832851u, 3248488448u, 0, LOGBF_TOLERANCE, 0},
{801, 1153863660u, 1011991342u, 1092616192u, 0, LOGBF_TOLERANCE, 0},
{802, 3034243695u, 917098003u, 3249537024u, 0, LOGBF_TOLERANCE, 0},
{803, 809294662u, 3266461458u, 3254255616u, 0, LOGBF_TOLERANCE, 0},
{804, 822231182u, 3393408718u, 3253207040u, 0, LOGBF_TOLERANCE, 0},
{805, 845772797u, 3341109215u, 3252158464u, 0, LOGBF_TOLERANCE, 0},
{806, 1249365132u, 3278686216u, 1101529088u, 0, LOGBF_TOLERANCE, 0},
{807, 3046215730u, 3211219980u, 3248488448u, 0, LOGBF_TOLERANCE, 0},
{808, 3047251716u, 1090787353u, 3248488448u, 0, LOGBF_TOLERANCE, 0},
{809, 2980866154u, 1147012796u, 3252682752u, 0, LOGBF_TOLERANCE, 0},
{810, 3131219358u, 3471261157u, 3240099840u, 0, LOGBF_TOLERANCE, 0},
{811, 3222096285u, 1198013705u, 1065353216u, 0, LOGBF_TOLERANCE, 0},
{812, 1297708818u, 3079166173u, 1104674816u, 0, LOGBF_TOLERANCE, 0},
{813, 3345532722u, 3383708463u, 1097859072u, 0, LOGBF_TOLERANCE, 0},
{814, 3418753236u, 3481843070u, 1103101952u, 0, LOGBF_TOLERANCE, 0},
{815, 1277417964u, 3487506626u, 1103626240u, 0, LOGBF_TOLERANCE, 0},
{816, 987577257u, 1152077087u, 3240099840u, 0, LOGBF_TOLERANCE, 0},
{817, 3161606610u, 3190282989u, 3235905536u, 0, LOGBF_TOLERANCE, 0},
{818, 849056171u, 910674398u, 3251634176u, 0, LOGBF_TOLERANCE, 0},
{819, 888030585u, 3062367380u, 3249537024u, 0, LOGBF_TOLERANCE, 0},
{820, 1043442869u, 3311393817u, 3225419776u, 0, LOGBF_TOLERANCE, 0},
{821, 851189486u, 3007588581u, 3251634176u, 0, LOGBF_TOLERANCE, 0},
{822, 3320923228u, 3464544249u, 1094713344u, 0, LOGBF_TOLERANCE, 0},
{823, 1337400405u, 3488844154u, 1107296256u, 0, LOGBF_TOLERANCE, 0},
{824, 2964339884u, 3186563447u, 3253731328u, 0, LOGBF_TOLERANCE, 0},
{825, 3400348640u, 3129868490u, 1102053376u, 0, LOGBF_TOLERANCE, 0},
{826, 1250249095u, 1069023744u, 1102053376u, 0, LOGBF_TOLERANCE, 0},
{827, 3284411233u, 1173613526u, 1090519040u, 0, LOGBF_TOLERANCE, 0},
{828, 3020883322u, 2953622587u, 3250061312u, 0, LOGBF_TOLERANCE, 0},
{829, 1215968622u, 3469884568u, 1099431936u, 0, LOGBF_TOLERANCE, 0},
{830, 3202319550u, 819117302u, 3221225472u, 0, LOGBF_TOLERANCE, 0},
{831, 3061638260u, 3116222327u, 3247964160u, 0, LOGBF_TOLERANCE, 0},
{832, 1025404104u, 1066370251u, 3231711232u, 0, LOGBF_TOLERANCE, 0},
{833, 3138086437u, 3195983510u, 3239051264u, 0, LOGBF_TOLERANCE, 0},
{834, 3091024506u, 3456196859u, 3245342720u, 0, LOGBF_TOLERANCE, 0},
{835, 3362748242u, 3369843597u, 1099431936u, 0, LOGBF_TOLERANCE, 0},
{836, 3099671635u, 3218383623u, 3244294144u, 0, LOGBF_TOLERANCE, 0},
{837, 3068014841u, 2978226656u, 3247439872u, 0, LOGBF_TOLERANCE, 0},
{838, 1252237719u, 1121169249u, 1102053376u, 0, LOGBF_TOLERANCE, 0},
{839, 3327895594u, 1224511805u, 1095761920u, 0, LOGBF_TOLERANCE, 0},
{840, 3082454432u, 889268276u, 3246391296u, 0, LOGBF_TOLERANCE, 0},
{841, 3396161504u, 1182798837u, 1101529088u, 0, LOGBF_TOLERANCE, 0},
{842, 1099710167u, 887180181u, 1082130432u, 0, LOGBF_TOLERANCE, 0},
{843, 1157186482u, 1288722647u, 1092616192u, 0, LOGBF_TOLERANCE, 0},
{844, 1282110851u, 3176633124u, 1103626240u, 0, LOGBF_TOLERANCE, 0},
{845, 3477008113u, 1331845018u, 1106771968u, 0, LOGBF_TOLERANCE, 0},
{846, 3292127294u, 3409957764u, 1091567616u, 0, LOGBF_TOLERANCE, 0},
{847, 1123357102u, 3281307320u, 1086324736u, 0, LOGBF_TOLERANCE, 0},
{848, 1106837025u, 3088080674u, 1082130432u, 0, LOGBF_TOLERANCE, 0},
{849, 1049949008u, 1130799489u, 3221225472u, 0, LOGBF_TOLERANCE, 0},
{850, 1253017688u, 942062372u, 1102053376u, 0, LOGBF_TOLERANCE, 0},
{851, 1108543194u, 3281299199u, 1084227584u, 0, LOGBF_TOLERANCE, 0},
{852, 3087985411u, 1238341456u, 3245342720u, 0, LOGBF_TOLERANCE, 0},
{853, 3002187365u, 1073809054u, 3251634176u, 0, LOGBF_TOLERANCE, 0},
{854, 3163283126u, 1328636961u, 3233808384u, 0, LOGBF_TOLERANCE, 0},
{855, 1160162706u, 1264067367u, 1093664768u, 0, LOGBF_TOLERANCE, 0},
{856, 3305715025u, 3017496063u, 1093664768u, 0, LOGBF_TOLERANCE, 0},
{857, 1266928623u, 811778614u, 1103101952u, 0, LOGBF_TOLERANCE, 0},
{858, 3025340297u, 1193925540u, 3250061312u, 0, LOGBF_TOLERANCE, 0},
{859, 3438080027u, 3107114149u, 1104150528u, 0, LOGBF_TOLERANCE, 0},
{860, 3344574751u, 3111270744u, 1097859072u, 0, LOGBF_TOLERANCE, 0},
{861, 1152416724u, 962669179u, 1092616192u, 0, LOGBF_TOLERANCE, 0},
{862, 1218239308u, 1126238113u, 1099956224u, 0, LOGBF_TOLERANCE, 0},
{863, 3263310567u, 1030748197u, 1086324736u, 0, LOGBF_TOLERANCE, 0},
{864, 835770216u, 865469272u, 3252682752u, 0, LOGBF_TOLERANCE, 0},
{865, 3041998669u, 1160635263u, 3249012736u, 0, LOGBF_TOLERANCE, 0},
{866, 1000313118u, 2980130729u, 3238002688u, 0, LOGBF_TOLERANCE, 0},
{867, 972485427u, 1124312043u, 3242196992u, 0, LOGBF_TOLERANCE, 0},
{868, 3290264612u, 1124703898u, 1091567616u, 0, LOGBF_TOLERANCE, 0},
{869, 869072657u, 3150369767u, 3250585600u, 0, LOGBF_TOLERANCE, 0},
{870, 3222106584u, 1183748648u, 1065353216u, 0, LOGBF_TOLERANCE, 0},
{871, 1278946388u, 825129857u, 1103626240u, 0, LOGBF_TOLERANCE, 0},
{872, 947914771u, 3181847068u, 3244294144u, 0, LOGBF_TOLERANCE, 0},
{873, 3167730654u, 3195765940u, 3233808384u, 0, LOGBF_TOLERANCE, 0},
{874, 1098530298u, 3255870890u, 1077936128u, 0, LOGBF_TOLERANCE, 0},
{875, 3232726036u, 871038882u, 1073741824u, 0, LOGBF_TOLERANCE, 0},
{876, 1297190916u, 811863044u, 1104674816u, 0, LOGBF_TOLERANCE, 0},
{877, 1277649137u, 961171401u, 1103626240u, 0, LOGBF_TOLERANCE, 0},
{878, 3203377685u, 1306427476u, 3221225472u, 0, LOGBF_TOLERANCE, 0},
{879, 3090306474u, 3124785016u, 3245342720u, 0, LOGBF_TOLERANCE, 0},
{880, 3244032016u, 3045313345u, 1077936128u, 0, LOGBF_TOLERANCE, 0},
{881, 3033122376u, 3049877065u, 3249537024u, 0, LOGBF_TOLERANCE, 0},
{882, 3019221802u, 3329183205u, 3250585600u, 0, LOGBF_TOLERANCE, 0},
{883, 1096155623u, 1256423752u, 1077936128u, 0, LOGBF_TOLERANCE, 0},
{884, 873151908u, 3246562559u, 3250061312u, 0, LOGBF_TOLERANCE, 0},
{885, 3238729605u, 1298769842u, 1077936128u, 0, LOGBF_TOLERANCE, 0},
{886, 3317196817u, 989537151u, 1094713344u, 0, LOGBF_TOLERANCE, 0},
{887, 3374748510u, 834161190u, 1100480512u, 0, LOGBF_TOLERANCE, 0},
{888, 3345634950u, 959901149u, 1097859072u, 0, LOGBF_TOLERANCE, 0},
{889, 3189860276u, 883598767u, 3225419776u, 0, LOGBF_TOLERANCE, 0},
{890, 887311687u, 1175312255u, 3249537024u, 0, LOGBF_TOLERANCE, 0},
{891, 3396917283u, 3066326686u, 1101529088u, 0, LOGBF_TOLERANCE, 0},
{892, 3317032737u, 3143803722u, 1094713344u, 0, LOGBF_TOLERANCE, 0},
{893, 1200051436u, 1163802508u, 1098907648u, 0, LOGBF_TOLERANCE, 0},
{894, 3105291012u, 1194385202u, 3243245568u, 0, LOGBF_TOLERANCE, 0},
{895, 1306520561u, 957302464u, 1105199104u, 0, LOGBF_TOLERANCE, 0},
{896, 1314936356u, 2985592532u, 1105723392u, 0, LOGBF_TOLERANCE, 0},
{897, 3475052219u, 1284049853u, 1106771968u, 0, LOGBF_TOLERANCE, 0},
{898, 3085636260u, 1107682820u, 3246391296u, 0, LOGBF_TOLERANCE, 0},
{899, 2995058661u, 822977912u, 3251634176u, 0, LOGBF_TOLERANCE, 0},
{900, 3393227708u, 3271879112u, 1101529088u, 0, LOGBF_TOLERANCE, 0},
{901, 2983919425u, 3341426744u, 3252682752u, 0, LOGBF_TOLERANCE, 0},
{902, 3182540197u, 852580839u, 3229614080u, 0, LOGBF_TOLERANCE, 0},
{903, 3349005404u, 3080993030u, 1098907648u, 0, LOGBF_TOLERANCE, 0},
{904, 3154720153u, 3443720494u, 3235905536u, 0, LOGBF_TOLERANCE, 0},
{905, 1262863321u, 1219003129u, 1102577664u, 0, LOGBF_TOLERANCE, 0},
{906, 882902102u, 1224362550u, 3249537024u, 0, LOGBF_TOLERANCE, 0},
{907, 2995633678u, 828113666u, 3251634176u, 0, LOGBF_TOLERANCE, 0},
{908, 1053387478u, 3184880021u, 3221225472u, 0, LOGBF_TOLERANCE, 0},
{909, 3387653691u, 3347783852u, 1101004800u, 0, LOGBF_TOLERANCE, 0},
{910, 3136364836u, 1018492227u, 3240099840u, 0, LOGBF_TOLERANCE, 0},
{911, 808412264u, 941158192u, 3254255616u, 0, LOGBF_TOLERANCE, 0},
{912, 1338680611u, 1166078045u, 1107296256u, 0, LOGBF_TOLERANCE, 0},
{913, 1112891928u, 3074730425u, 1084227584u, 0, LOGBF_TOLERANCE, 0},
{914, 893449284u, 1052877339u, 3249012736u, 0, LOGBF_TOLERANCE, 0},
{915, 892311459u, 1097338393u, 3249012736u, 0, LOGBF_TOLERANCE, 0},
{916, 3105373037u, 3246705916u, 3243245568u, 0, LOGBF_TOLERANCE, 0},
{917, 1190105283u, 3033907262u, 1096810496u, 0, LOGBF_TOLERANCE, 0},
{918, 1011225926u, 1180485180u, 3235905536u, 0, LOGBF_TOLERANCE, 0},
{919, 1043025031u, 987068973u, 3225419776u, 0, LOGBF_TOLERANCE, 0},
{920, 3410531037u, 2953541915u, 1102577664u, 0, LOGBF_TOLERANCE, 0},
{921, 3125834184u, 896953754u, 3241148416u, 0, LOGBF_TOLERANCE, 0},
{922, 902318189u, 849277289u, 3248488448u, 0, LOGBF_TOLERANCE, 0},
{923, 835377647u, 3441354730u, 3252682752u, 0, LOGBF_TOLERANCE, 0},
{924, 2976308307u, 1286944060u, 3253207040u, 0, LOGBF_TOLERANCE, 0},
{925, 3213624815u, 2987148017u, 0u, 0, LOGBF_TOLERANCE, 0},
{926, 1120888322u, 1086209113u, 1086324736u, 0, LOGBF_TOLERANCE, 0},
{927, 1315217243u, 3396371713u, 1105723392u, 0, LOGBF_TOLERANCE, 0},
{928, 3137758475u, 1039403054u, 3239051264u, 0, LOGBF_TOLERANCE, 0},
{929, 1040617590u, 1034835971u, 3225419776u, 0, LOGBF_TOLERANCE, 0},
{930, 955384253u, 3344785562u, 3244294144u, 0, LOGBF_TOLERANCE, 0},
{931, 853063496u, 3317415965u, 3251634176u, 0, LOGBF_TOLERANCE, 0},
{932, 823111402u, 877253523u, 3253207040u, 0, LOGBF_TOLERANCE, 0},
{933, 3061417900u, 1172208065u, 3247964160u, 0, LOGBF_TOLERANCE, 0},
{934, 904255535u, 1019967545u, 3248488448u, 0, LOGBF_TOLERANCE, 0},
{935, 1022984119u, 3113891410u, 3233808384u, 0, LOGBF_TOLERANCE, 0},
{936, 997362368u, 3112875428u, 3239051264u, 0, LOGBF_TOLERANCE, 0},
{937, 900933520u, 1100589187u, 3248488448u, 0, LOGBF_TOLERANCE, 0},
{938, 1168623062u, 1143306482u, 1094713344u, 0, LOGBF_TOLERANCE, 0},
{939, 878737490u, 3269908326u, 3250061312u, 0, LOGBF_TOLERANCE, 0},
{940, 1039827284u, 1072928888u, 3229614080u, 0, LOGBF_TOLERANCE, 0},
{941, 1021564080u, 1064468397u, 3233808384u, 0, LOGBF_TOLERANCE, 0},
{942, 3458669745u, 3033299853u, 1105723392u, 0, LOGBF_TOLERANCE, 0},
{943, 3327516316u, 3405380971u, 1095761920u, 0, LOGBF_TOLERANCE, 0},
{944, 1040711112u, 3229444200u, 3225419776u, 0, LOGBF_TOLERANCE, 0},
{945, 1134528351u, 3365952513u, 1090519040u, 0, LOGBF_TOLERANCE, 0},
{946, 3039884464u, 1170612785u, 3249012736u, 0, LOGBF_TOLERANCE, 0},
{947, 3414352838u, 3350285760u, 1103101952u, 0, LOGBF_TOLERANCE, 0},
{948, 1133689539u, 1067460093u, 1090519040u, 0, LOGBF_TOLERANCE, 0},
{949, 3455688478u, 3333091960u, 1105199104u, 0, LOGBF_TOLERANCE, 0},
{950, 1137634874u, 1137038869u, 1090519040u, 0, LOGBF_TOLERANCE, 0},
{951, 3415502662u, 955510692u, 1103101952u, 0, LOGBF_TOLERANCE, 0},
{952, 954999730u, 969618597u, 3244294144u, 0, LOGBF_TOLERANCE, 0},
{953, 1066157309u, 3241712664u, 0u, 0, LOGBF_TOLERANCE, 0},
{954, 3436353675u, 1174967495u, 1104150528u, 0, LOGBF_TOLERANCE, 0},
{955, 940437609u, 860372396u, 3245342720u, 0, LOGBF_TOLERANCE, 0},
{956, 3108347547u, 3434003435u, 3243245568u, 0, LOGBF_TOLERANCE, 0},
{957, 3064200154u, 3158080507u, 3247439872u, 0, LOGBF_TOLERANCE, 0},
{958, 1023889593u, 2979304683u, 3231711232u, 0, LOGBF_TOLERANCE, 0},
{959, 3272661536u, 3461799138u, 1088421888u, 0, LOGBF_TOLERANCE, 0},
{960, 1170245333u, 1233406410u, 1094713344u, 0, LOGBF_TOLERANCE, 0},
{961, 1219052056u, 3369557946u, 1099956224u, 0, LOGBF_TOLERANCE, 0},
{962, 3318983619u, 3259663338u, 1094713344u, 0, LOGBF_TOLERANCE, 0},
{963, 3372118621u, 837597103u, 1099956224u, 0, LOGBF_TOLERANCE, 0},
{964, 3146190320u, 889646054u, 3238002688u, 0, LOGBF_TOLERANCE, 0},
{965, 1299683827u, 966031619u, 1104674816u, 0, LOGBF_TOLERANCE, 0},
{966, 3190796331u, 1320011850u, 3225419776u, 0, LOGBF_TOLERANCE, 0},
{967, 2965838479u, 805822032u, 3253731328u, 0, LOGBF_TOLERANCE, 0},
{968, 3086068902u, 3484245751u, 3246391296u, 0, LOGBF_TOLERANCE, 0},
{969, 3064155399u, 3176569312u, 3247439872u, 0, LOGBF_TOLERANCE, 0},
{970, 836858201u, 3132995403u, 3252682752u, 0, LOGBF_TOLERANCE, 0},
{971, 3040314717u, 1071290674u, 3249012736u, 0, LOGBF_TOLERANCE, 0},
{972, 3257224022u, 3361778245u, 1084227584u, 0, LOGBF_TOLERANCE, 0},
{973, 1229268598u, 1066965677u, 1100480512u, 0, LOGBF_TOLERANCE, 0},
{974, 3184078812u, 871003709u, 3229614080u, 0, LOGBF_TOLERANCE, 0},
{975, 871255076u, 3446104825u, 3250585600u, 0, LOGBF_TOLERANCE, 0},
{976, 1086717248u, 3423795374u, 1073741824u, 0, LOGBF_TOLERANCE, 0},
{977, 3434884607u, 3029593823u, 1104150528u, 0, LOGBF_TOLERANCE, 0},
{978, 3464955606u, 1017987696u, 1106247680u, 0, LOGBF_TOLERANCE, 0},
{979, 1025278524u, 3121856207u, 3231711232u, 0, LOGBF_TOLERANCE, 0},
{980, 1242829722u, 3233935671u, 1101529088u, 0, LOGBF_TOLERANCE, 0},
{981, 3075149137u, 1117325737u, 3246915584u, 0, LOGBF_TOLERANCE, 0},
{982, 1200927971u, 1317167489u, 1098907648u, 0, LOGBF_TOLERANCE, 0},
{983, 3326858092u, 3452602832u, 1095761920u, 0, LOGBF_TOLERANCE, 0},
{984, 2995203347u, 1021818696u, 3251634176u, 0, LOGBF_TOLERANCE, 0},
{985, 1246019790u, 850632217u, 1101529088u, 0, LOGBF_TOLERANCE, 0},
{986, 3184801644u, 1137974313u, 3229614080u, 0, LOGBF_TOLERANCE, 0},
{987, 1136052740u, 3244616020u, 1090519040u, 0, LOGBF_TOLERANCE, 0},
{988, 1069009211u, 3002507482u, 0u, 0, LOGBF_TOLERANCE, 0},
{989, 1015670780u, 1101217251u, 3233808384u, 0, LOGBF_TOLERANCE, 0},
{990, 1012543234u, 1116520440u, 3235905536u, 0, LOGBF_TOLERANCE, 0},
{991, 3316611992u, 3394732912u, 1094713344u, 0, LOGBF_TOLERANCE, 0},
{992, 3012101436u, 3307846870u, 3250585600u, 0, LOGBF_TOLERANCE, 0},
{993, 1087942795u, 3316660295u, 1073741824u, 0, LOGBF_TOLERANCE, 0},
{994, 3426365713u, 3069778532u, 1103626240u, 0, LOGBF_TOLERANCE, 0},
{995, 3066654389u, 3443934204u, 3247439872u, 0, LOGBF_TOLERANCE, 0},
{996, 3295326432u, 1313396175u, 1091567616u, 0, LOGBF_TOLERANCE, 0},
{997, 3318835308u, 3277583511u, 1094713344u, 0, LOGBF_TOLERANCE, 0},
{998, 3283555717u, 891875120u, 1090519040u, 0, LOGBF_TOLERANCE, 0},
{999, 3381255420u, 3015406047u, 1101004800u, 0, LOGBF_TOLERANCE, 0},
{1000, 3040485181u, 3375450886u, 3249012736u, 0, LOGBF_TOLERANCE, 0},
{1001, 3388772093u, 1032597076u, 1101004800u, 0, LOGBF_TOLERANCE, 0},
{1002, 954670189u, 1144923689u, 3244294144u, 0, LOGBF_TOLERANCE, 0},
{1003, 1319200415u, 3387555900u, 1106247680u, 0, LOGBF_TOLERANCE, 0},
{1004, 1279324488u, 3228401212u, 1103626240u, 0, LOGBF_TOLERANCE, 0},
{1005, 3217795424u, 865577227u, 0u, 0, LOGBF_TOLERANCE, 0},
{1006, 3455131757u, 1260217257u, 1105199104u, 0, LOGBF_TOLERANCE, 0},
{1007, 2982636375u, 3162157233u, 3252682752u, 0, LOGBF_TOLERANCE, 0},
{1008, 1246947517u, 1087951909u, 1101529088u, 0, LOGBF_TOLERANCE, 0},
{1009, 3396723577u, 869285240u, 1101529088u, 0, LOGBF_TOLERANCE, 0},
{1010, 3433761025u, 3060143904u, 1104150528u, 0, LOGBF_TOLERANCE, 0},
{1011, 3201187455u, 900233172u, 3221225472u, 0, LOGBF_TOLERANCE, 0},
{1012, 1173247961u, 1191127979u, 1094713344u, 0, LOGBF_TOLERANCE, 0},
{1013, 3037297123u, 3346394818u, 3249012736u, 0, LOGBF_TOLERANCE, 0},
{1014, 3248534678u, 1323683800u, 1082130432u, 0, LOGBF_TOLERANCE, 0},
{1015, 3083019343u, 3033309444u, 3246391296u, 0, LOGBF_TOLERANCE, 0},
{1016, 3042018375u, 3203882372u, 3249012736u, 0, LOGBF_TOLERANCE, 0},
{1017, 1082862511u, 3032804719u, 1073741824u, 0, LOGBF_TOLERANCE, 0},
{1018, 3157626955u, 3483653298u, 3235905536u, 0, LOGBF_TOLERANCE, 0},
{1019, 1341821683u, 3003675365u, 1107296256u, 0, LOGBF_TOLERANCE, 0},
{1020, 881101379u, 1190838126u, 3249537024u, 0, LOGBF_TOLERANCE, 0},
{1021, 1079061705u, 2960507663u, 1065353216u, 0, LOGBF_TOLERANCE, 0},
{1022, 3182695954u, 3256861672u, 3229614080u, 0, LOGBF_TOLERANCE, 0},
{1023, 1105291533u, 3482971524u, 1082130432u, 0, LOGBF_TOLERANCE, 0},
{1024, 1016023520u, 3227712090u, 3233808384u, 0, LOGBF_TOLERANCE, 0},
{1025, 3370691006u, 1295870514u, 1099956224u, 0, LOGBF_TOLERANCE, 0},
{1026, 1156767169u, 1049756240u, 1092616192u, 0, LOGBF_TOLERANCE, 0},
{1027, 3077020499u, 894671462u, 3246915584u, 0, LOGBF_TOLERANCE, 0},
{1028, 1104284039u, 3040211914u, 1082130432u, 0, LOGBF_TOLERANCE, 0},
{1029, 3335212901u, 3486414589u, 1096810496u, 0, LOGBF_TOLERANCE, 0},
{1030, 1093697541u, 3193708441u, 1077936128u, 0, LOGBF_TOLERANCE, 0},
{1031, 3266691185u, 1160074593u, 1086324736u, 0, LOGBF_TOLERANCE, 0},
{1032, 3179003144u, 1108615803u, 3231711232u, 0, LOGBF_TOLERANCE, 0},
{1033, 1094115255u, 3008610212u, 1077936128u, 0, LOGBF_TOLERANCE, 0},
{1034, 2994604730u, 973792195u, 3252158464u, 0, LOGBF_TOLERANCE, 0},
{1035, 3424086808u, 3260140004u, 1103626240u, 0, LOGBF_TOLERANCE, 0},
{1036, 2957266025u, 917932067u, 3254255616u, 0, LOGBF_TOLERANCE, 0},
{1037, 3353608773u, 1134068114u, 1098907648u, 0, LOGBF_TOLERANCE, 0},
{1038, 2985838945u, 3118475644u, 3252682752u, 0, LOGBF_TOLERANCE, 0},
{1039, 973664327u, 1319516167u, 3241148416u, 0, LOGBF_TOLERANCE, 0},
{1040, 882878091u, 3136970767u, 3249537024u, 0, LOGBF_TOLERANCE, 0},
{1041, 1098662266u, 833740182u, 1077936128u, 0, LOGBF_TOLERANCE, 0},
{1042, 927582555u, 947955456u, 3246915584u, 0, LOGBF_TOLERANCE, 0},
{1043, 3111440310u, 3067634077u, 3243245568u, 0, LOGBF_TOLERANCE, 0},
{1044, 3476083859u, 966439623u, 1106771968u, 0, LOGBF_TOLERANCE, 0},
{1045, 3038754840u, 932009686u, 3249012736u, 0, LOGBF_TOLERANCE, 0},
{1046, 979878744u, 1232482646u, 3241148416u, 0, LOGBF_TOLERANCE, 0},
{1047, 3464546616u, 3205527253u, 1106247680u, 0, LOGBF_TOLERANCE, 0},
{1048, 1002542205u, 3152136093u, 3238002688u, 0, LOGBF_TOLERANCE, 0},
{1049, 3443552129u, 3165561391u, 1104674816u, 0, LOGBF_TOLERANCE, 0},
{1050, 1287620154u, 3119707283u, 1104150528u, 0, LOGBF_TOLERANCE, 0},
{1051, 820906845u, 1196920413u, 3253731328u, 0, LOGBF_TOLERANCE, 0},
{1052, 860108361u, 921064349u, 3251109888u, 0, LOGBF_TOLERANCE, 0},
{1053, 946058434u, 1249928879u, 3245342720u, 0, LOGBF_TOLERANCE, 0},
{1054, 3073260205u, 3093124531u, 3246915584u, 0, LOGBF_TOLERANCE, 0},
{1055, 1245702957u, 894348966u, 1101529088u, 0, LOGBF_TOLERANCE, 0},
{1056, 989655126u, 1308376568u, 3240099840u, 0, LOGBF_TOLERANCE, 0},
{1057, 1002715618u, 1191006977u, 3238002688u, 0, LOGBF_TOLERANCE, 0},
{1058, 3087802274u, 897541752u, 3245342720u, 0, LOGBF_TOLERANCE, 0},
{1059, 1000863905u, 1196831314u, 3238002688u, 0, LOGBF_TOLERANCE, 0},
{1060, 3415763001u, 3032518431u, 1103101952u, 0, LOGBF_TOLERANCE, 0},
{1061, 2979924820u, 1100234812u, 3252682752u, 0, LOGBF_TOLERANCE, 0},
{1062, 3283471961u, 1260093226u, 1090519040u, 0, LOGBF_TOLERANCE, 0},
{1063, 3311210827u, 1192192264u, 1093664768u, 0, LOGBF_TOLERANCE, 0},
{1064, 3026311911u, 2968974374u, 3250061312u, 0, LOGBF_TOLERANCE, 0},
{1065, 1198307901u, 1116328249u, 1097859072u, 0, LOGBF_TOLERANCE, 0},
{1066, 1288901567u, 1296370667u, 1104150528u, 0, LOGBF_TOLERANCE, 0},
{1067, 922255363u, 958305289u, 3247439872u, 0, LOGBF_TOLERANCE, 0},
{1068, 1113104661u, 944376032u, 1084227584u, 0, LOGBF_TOLERANCE, 0},
{1069, 1136714348u, 828849087u, 1090519040u, 0, LOGBF_TOLERANCE, 0},
{1070, 3002059872u, 1136817970u, 3251634176u, 0, LOGBF_TOLERANCE, 0},
{1071, 948856035u, 1015466475u, 3244294144u, 0, LOGBF_TOLERANCE, 0},
{1072, 1062512367u, 3229559531u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{1073, 3486907092u, 823220784u, 1107296256u, 0, LOGBF_TOLERANCE, 0},
{1074, 3015049792u, 3078555978u, 3250585600u, 0, LOGBF_TOLERANCE, 0},
{1075, 1162027071u, 3308983387u, 1093664768u, 0, LOGBF_TOLERANCE, 0},
{1076, 1034561811u, 1054043114u, 3229614080u, 0, LOGBF_TOLERANCE, 0},
{1077, 853827378u, 898656161u, 3251634176u, 0, LOGBF_TOLERANCE, 0},
{1078, 3271615417u, 3209997200u, 1088421888u, 0, LOGBF_TOLERANCE, 0},
{1079, 1042014529u, 1146708584u, 3225419776u, 0, LOGBF_TOLERANCE, 0},
{1080, 1177157787u, 3090208179u, 1095761920u, 0, LOGBF_TOLERANCE, 0},
{1081, 3196144817u, 1056118717u, 3221225472u, 0, LOGBF_TOLERANCE, 0},
{1082, 3432084552u, 2997091781u, 1104150528u, 0, LOGBF_TOLERANCE, 0},
{1083, 1309658335u, 1010219988u, 1105723392u, 0, LOGBF_TOLERANCE, 0},
{1084, 3004373345u, 873739132u, 3251109888u, 0, LOGBF_TOLERANCE, 0},
{1085, 2997667929u, 1038223245u, 3251634176u, 0, LOGBF_TOLERANCE, 0},
{1086, 1226494979u, 2991604792u, 1100480512u, 0, LOGBF_TOLERANCE, 0},
{1087, 3100289712u, 3456334210u, 3244294144u, 0, LOGBF_TOLERANCE, 0},
{1088, 3375507013u, 1306310823u, 1100480512u, 0, LOGBF_TOLERANCE, 0},
{1089, 3460699001u, 3096700943u, 1105723392u, 0, LOGBF_TOLERANCE, 0},
{1090, 3079231719u, 1044386263u, 3246391296u, 0, LOGBF_TOLERANCE, 0},
{1091, 3093951884u, 1014115231u, 3245342720u, 0, LOGBF_TOLERANCE, 0},
{1092, 3468023178u, 1209565017u, 1106247680u, 0, LOGBF_TOLERANCE, 0},
{1093, 3008182310u, 1258900986u, 3251109888u, 0, LOGBF_TOLERANCE, 0},
{1094, 1204196034u, 3298625731u, 1098907648u, 0, LOGBF_TOLERANCE, 0},
{1095, 3459877411u, 2960476959u, 1105723392u, 0, LOGBF_TOLERANCE, 0},
{1096, 909696559u, 1163075690u, 3247964160u, 0, LOGBF_TOLERANCE, 0},
{1097, 1161439847u, 943449277u, 1093664768u, 0, LOGBF_TOLERANCE, 0},
{1098, 908663107u, 939489763u, 3247964160u, 0, LOGBF_TOLERANCE, 0},
{1099, 1055319316u, 3261813492u, 3221225472u, 0, LOGBF_TOLERANCE, 0},
{1100, 1084378658u, 1009650785u, 1073741824u, 0, LOGBF_TOLERANCE, 0},
{1101, 3053887750u, 3341786453u, 3247964160u, 0, LOGBF_TOLERANCE, 0},
{1102, 3022828828u, 881335251u, 3250061312u, 0, LOGBF_TOLERANCE, 0},
{1103, 2995476576u, 3194911588u, 3251634176u, 0, LOGBF_TOLERANCE, 0},
{1104, 1226473697u, 821025132u, 1100480512u, 0, LOGBF_TOLERANCE, 0},
{1105, 1123114742u, 1229815537u, 1086324736u, 0, LOGBF_TOLERANCE, 0},
{1106, 1258114435u, 1291336083u, 1102053376u, 0, LOGBF_TOLERANCE, 0},
{1107, 2983818103u, 3015402015u, 3252682752u, 0, LOGBF_TOLERANCE, 0},
{1108, 3468040845u, 3066966245u, 1106247680u, 0, LOGBF_TOLERANCE, 0},
{1109, 1178825761u, 1113195286u, 1095761920u, 0, LOGBF_TOLERANCE, 0},
{1110, 3059266302u, 878503862u, 3247964160u, 0, LOGBF_TOLERANCE, 0},
{1111, 3223384012u, 1130486973u, 1065353216u, 0, LOGBF_TOLERANCE, 0},
{1112, 1019964626u, 1235133609u, 3233808384u, 0, LOGBF_TOLERANCE, 0},
{1113, 3445262427u, 3465211174u, 1104674816u, 0, LOGBF_TOLERANCE, 0},
{1114, 1125653081u, 1207799746u, 1088421888u, 0, LOGBF_TOLERANCE, 0},
{1115, 3337652712u, 3025581813u, 1096810496u, 0, LOGBF_TOLERANCE, 0},
{1116, 1184753508u, 3147374485u, 1096810496u, 0, LOGBF_TOLERANCE, 0},
{1117, 996404791u, 3353251979u, 3239051264u, 0, LOGBF_TOLERANCE, 0},
{1118, 1188439315u, 1113484271u, 1096810496u, 0, LOGBF_TOLERANCE, 0},
{1119, 906557513u, 3006513432u, 3247964160u, 0, LOGBF_TOLERANCE, 0},
{1120, 916831283u, 999465787u, 3247439872u, 0, LOGBF_TOLERANCE, 0},
{1121, 996786317u, 3179221951u, 3239051264u, 0, LOGBF_TOLERANCE, 0},
{1122, 3461635065u, 1004690387u, 1105723392u, 0, LOGBF_TOLERANCE, 0},
{1123, 1188167943u, 1200744896u, 1096810496u, 0, LOGBF_TOLERANCE, 0},
{1124, 3036502395u, 1172597364u, 3249537024u, 0, LOGBF_TOLERANCE, 0},
{1125, 891257783u, 1267560050u, 3249012736u, 0, LOGBF_TOLERANCE, 0},
{1126, 3290079438u, 846519377u, 1091567616u, 0, LOGBF_TOLERANCE, 0},
{1127, 3350690327u, 2967953392u, 1098907648u, 0, LOGBF_TOLERANCE, 0},
{1128, 1102061604u, 3424449935u, 1082130432u, 0, LOGBF_TOLERANCE, 0},
{1129, 1282351521u, 3039376424u, 1103626240u, 0, LOGBF_TOLERANCE, 0},
{1130, 3458861065u, 3392466405u, 1105723392u, 0, LOGBF_TOLERANCE, 0},
{1131, 3095256878u, 1023623326u, 3245342720u, 0, LOGBF_TOLERANCE, 0},
{1132, 3163373610u, 843150426u, 3233808384u, 0, LOGBF_TOLERANCE, 0},
{1133, 3228793330u, 855146890u, 1065353216u, 0, LOGBF_TOLERANCE, 0},
{1134, 3422194733u, 893873945u, 1103101952u, 0, LOGBF_TOLERANCE, 0},
{1135, 3083885296u, 974543672u, 3246391296u, 0, LOGBF_TOLERANCE, 0},
{1136, 1261940623u, 3402349985u, 1102577664u, 0, LOGBF_TOLERANCE, 0},
{1137, 825039660u, 3426717554u, 3253207040u, 0, LOGBF_TOLERANCE, 0},
{1138, 3400603081u, 3234396843u, 1102053376u, 0, LOGBF_TOLERANCE, 0},
{1139, 1219411812u, 2961857939u, 1099956224u, 0, LOGBF_TOLERANCE, 0},
{1140, 3094833770u, 805351108u, 3245342720u, 0, LOGBF_TOLERANCE, 0},
{1141, 3139250800u, 3079109479u, 3239051264u, 0, LOGBF_TOLERANCE, 0},
{1142, 886201503u, 3272760705u, 3249537024u, 0, LOGBF_TOLERANCE, 0},
{1143, 3297366026u, 1089966380u, 1092616192u, 0, LOGBF_TOLERANCE, 0},
{1144, 1218488455u, 3309646450u, 1099956224u, 0, LOGBF_TOLERANCE, 0},
{1145, 3040358923u, 3093401553u, 3249012736u, 0, LOGBF_TOLERANCE, 0},
{1146, 862346861u, 3411853707u, 3251109888u, 0, LOGBF_TOLERANCE, 0},
{1147, 1283938137u, 1196383822u, 1104150528u, 0, LOGBF_TOLERANCE, 0},
{1148, 3182551696u, 3029982441u, 3229614080u, 0, LOGBF_TOLERANCE, 0},
{1149, 1317098613u, 949986176u, 1106247680u, 0, LOGBF_TOLERANCE, 0},
{1150, 3116209179u, 3303588342u, 3242196992u, 0, LOGBF_TOLERANCE, 0},
{1151, 3431703657u, 3014443710u, 1104150528u, 0, LOGBF_TOLERANCE, 0},
{1152, 3239728775u, 927815421u, 1077936128u, 0, LOGBF_TOLERANCE, 0},
{1153, 3207141672u, 933456504u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{1154, 3154378805u, 905462392u, 3235905536u, 0, LOGBF_TOLERANCE, 0},
{1155, 3069658155u, 1041452042u, 3247439872u, 0, LOGBF_TOLERANCE, 0},
{1156, 3313160088u, 2964063309u, 1093664768u, 0, LOGBF_TOLERANCE, 0},
{1157, 3207056527u, 3384206601u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{1158, 1284174954u, 3436881197u, 1104150528u, 0, LOGBF_TOLERANCE, 0},
{1159, 3156081645u, 3308839704u, 3235905536u, 0, LOGBF_TOLERANCE, 0},
{1160, 1063693032u, 976661408u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{1161, 3036026175u, 1251203998u, 3249537024u, 0, LOGBF_TOLERANCE, 0},
{1162, 1102631663u, 3396951425u, 1082130432u, 0, LOGBF_TOLERANCE, 0},
{1163, 968803479u, 992989712u, 3242196992u, 0, LOGBF_TOLERANCE, 0},
{1164, 3273080388u, 3109405906u, 1088421888u, 0, LOGBF_TOLERANCE, 0},
{1165, 1172529774u, 3294550127u, 1094713344u, 0, LOGBF_TOLERANCE, 0},
{1166, 1306695905u, 1292690378u, 1105199104u, 0, LOGBF_TOLERANCE, 0},
{1167, 1003649752u, 1218792138u, 3238002688u, 0, LOGBF_TOLERANCE, 0},
{1168, 1078478376u, 1326246424u, 1065353216u, 0, LOGBF_TOLERANCE, 0},
{1169, 3158855023u, 3151283866u, 3235905536u, 0, LOGBF_TOLERANCE, 0},
{1170, 1165177679u, 3276237026u, 1093664768u, 0, LOGBF_TOLERANCE, 0},
{1171, 870472127u, 3332532333u, 3250585600u, 0, LOGBF_TOLERANCE, 0},
{1172, 3403009513u, 3381966453u, 1102053376u, 0, LOGBF_TOLERANCE, 0},
{1173, 816825508u, 3032174124u, 3253731328u, 0, LOGBF_TOLERANCE, 0},
{1174, 952348506u, 3377573987u, 3244294144u, 0, LOGBF_TOLERANCE, 0},
{1175, 839544701u, 3419900937u, 3252158464u, 0, LOGBF_TOLERANCE, 0},
{1176, 2967454456u, 3313359047u, 3253731328u, 0, LOGBF_TOLERANCE, 0},
{1177, 1222777442u, 1125769920u, 1099956224u, 0, LOGBF_TOLERANCE, 0},
{1178, 1325324763u, 978336043u, 1106247680u, 0, LOGBF_TOLERANCE, 0},
{1179, 3363524213u, 3202991311u, 1099431936u, 0, LOGBF_TOLERANCE, 0},
{1180, 1158950321u, 1073578913u, 1093664768u, 0, LOGBF_TOLERANCE, 0},
{1181, 903129873u, 3416864271u, 3248488448u, 0, LOGBF_TOLERANCE, 0},
{1182, 2997685349u, 1123653663u, 3251634176u, 0, LOGBF_TOLERANCE, 0},
{1183, 3078339944u, 988173985u, 3246915584u, 0, LOGBF_TOLERANCE, 0},
{1184, 1208345407u, 1254181270u, 1099431936u, 0, LOGBF_TOLERANCE, 0},
{1185, 3003262042u, 1327277116u, 3251109888u, 0, LOGBF_TOLERANCE, 0},
{1186, 1258634105u, 1247426200u, 1102577664u, 0, LOGBF_TOLERANCE, 0},
{1187, 1248478509u, 1287895126u, 1101529088u, 0, LOGBF_TOLERANCE, 0},
{1188, 1153863988u, 3430539165u, 1092616192u, 0, LOGBF_TOLERANCE, 0},
{1189, 1235620969u, 866627358u, 1101004800u, 0, LOGBF_TOLERANCE, 0},
{1190, 1097120930u, 3221726305u, 1077936128u, 0, LOGBF_TOLERANCE, 0},
{1191, 3469778622u, 1200179013u, 1106247680u, 0, LOGBF_TOLERANCE, 0},
{1192, 1147712200u, 931865525u, 1091567616u, 0, LOGBF_TOLERANCE, 0},
{1193, 812694172u, 1136276190u, 3254255616u, 0, LOGBF_TOLERANCE, 0},
{1194, 862266739u, 3139447362u, 3251109888u, 0, LOGBF_TOLERANCE, 0},
{1195, 1124721745u, 3058969650u, 1088421888u, 0, LOGBF_TOLERANCE, 0},
{1196, 3261744304u, 1043806501u, 1084227584u, 0, LOGBF_TOLERANCE, 0},
{1197, 832324055u, 2954061156u, 3252682752u, 0, LOGBF_TOLERANCE, 0},
{1198, 805759679u, 903848557u, 3254255616u, 0, LOGBF_TOLERANCE, 0},
{1199, 2983396015u, 872299138u, 3252682752u, 0, LOGBF_TOLERANCE, 0},
{1200, 1064922416u, 1320485628u, 3212836864u, 0, LOGBF_TOLERANCE, 0},
{1201, 868114980u, 3213276361u, 3250585600u, 0, LOGBF_TOLERANCE, 0},
{1202, 3303160152u, 3075455322u, 1092616192u, 0, LOGBF_TOLERANCE, 0},
{1203, 1315090496u, 3269683237u, 1105723392u, 0, LOGBF_TOLERANCE, 0},
{1204, 850876090u, 3365795667u, 3251634176u, 0, LOGBF_TOLERANCE, 0},
{1205, 3230403187u, 1322841992u, 1073741824u, 0, LOGBF_TOLERANCE, 0},
{1206, 1335399673u, 974138676u, 1107296256u, 0, LOGBF_TOLERANCE, 0},
{1207, 1072458508u, 3372833993u, 0u, 0, LOGBF_TOLERANCE, 0},
{1208, 3303015249u, 3015039539u, 1092616192u, 0, LOGBF_TOLERANCE, 0},
{1209, 3252139741u, 1059615003u, 1082130432u, 0, LOGBF_TOLERANCE, 0},
{1210, 3468519966u, 3113982619u, 1106247680u, 0, LOGBF_TOLERANCE, 0},
{1211, 1006231203u, 897530770u, 3238002688u, 0, LOGBF_TOLERANCE, 0},
{1212, 951554138u, 1001144381u, 3244294144u, 0, LOGBF_TOLERANCE, 0},
{1213, 942046828u, 986341002u, 3245342720u, 0, LOGBF_TOLERANCE, 0},
{1214, 2968517146u, 951832467u, 3253731328u, 0, LOGBF_TOLERANCE, 0},
{1215, 3319723279u, 3414482416u, 1094713344u, 0, LOGBF_TOLERANCE, 0},
{1216, 3255104167u, 928827688u, 1084227584u, 0, LOGBF_TOLERANCE, 0},
{1217, 1155477903u, 3104812800u, 1092616192u, 0, LOGBF_TOLERANCE, 0},
{1218, 3273889176u, 980486479u, 1088421888u, 0, LOGBF_TOLERANCE, 0},
{1219, 3237813668u, 3441016803u, 1073741824u, 0, LOGBF_TOLERANCE, 0},
{1220, 1228207362u, 2985476579u, 1100480512u, 0, LOGBF_TOLERANCE, 0},
{1221, 975349337u, 1311932596u, 3241148416u, 0, LOGBF_TOLERANCE, 0},
{1222, 2982583196u, 3132904446u, 3252682752u, 0, LOGBF_TOLERANCE, 0},
{1223, 1290175785u, 3008182462u, 1104150528u, 0, LOGBF_TOLERANCE, 0},
{1224, 981908840u, 3314038398u, 3240099840u, 0, LOGBF_TOLERANCE, 0},
{1225, 941187647u, 1107765599u, 3245342720u, 0, LOGBF_TOLERANCE, 0},
{1226, 1214223128u, 3225536822u, 1099431936u, 0, LOGBF_TOLERANCE, 0},
{1227, 3422922584u, 1086391131u, 1103626240u, 0, LOGBF_TOLERANCE, 0},
{1228, 1315857601u, 3487600045u, 1105723392u, 0, LOGBF_TOLERANCE, 0},
{1229, 3453226030u, 3233768835u, 1105199104u, 0, LOGBF_TOLERANCE, 0},
{1230, 1078359574u, 3199175230u, 1065353216u, 0, LOGBF_TOLERANCE, 0},
{1231, 1029557624u, 3302959071u, 3231711232u, 0, LOGBF_TOLERANCE, 0},
{1232, 1207675424u, 3042692550u, 1098907648u, 0, LOGBF_TOLERANCE, 0},
{1233, 1028355074u, 3442294040u, 3231711232u, 0, LOGBF_TOLERANCE, 0},
{1234, 3119299090u, 1187096397u, 3242196992u, 0, LOGBF_TOLERANCE, 0},
{1235, 1248421894u, 3367769132u, 1101529088u, 0, LOGBF_TOLERANCE, 0},
{1236, 3353251994u, 1095517730u, 1098907648u, 0, LOGBF_TOLERANCE, 0},
{1237, 876926659u, 3288089977u, 3250061312u, 0, LOGBF_TOLERANCE, 0},
{1238, 1076752219u, 876236939u, 1065353216u, 0, LOGBF_TOLERANCE, 0},
{1239, 3388531942u, 2988520062u, 1101004800u, 0, LOGBF_TOLERANCE, 0},
{1240, 1273395082u, 3031189261u, 1103101952u, 0, LOGBF_TOLERANCE, 0},
{1241, 3385588183u, 3258252464u, 1101004800u, 0, LOGBF_TOLERANCE, 0},
{1242, 862047095u, 829323655u, 3251109888u, 0, LOGBF_TOLERANCE, 0},
{1243, 3192315328u, 3289489214u, 3225419776u, 0, LOGBF_TOLERANCE, 0},
{1244, 3441804648u, 3274638356u, 1104674816u, 0, LOGBF_TOLERANCE, 0},
{1245, 837368567u, 3228474927u, 3252682752u, 0, LOGBF_TOLERANCE, 0},
{1246, 3392827417u, 1277961150u, 1101529088u, 0, LOGBF_TOLERANCE, 0},
{1247, 1161241793u, 1328003707u, 1093664768u, 0, LOGBF_TOLERANCE, 0},
{1248, 856495732u, 3123041418u, 3251109888u, 0, LOGBF_TOLERANCE, 0},
{1249, 3034494183u, 3041579130u, 3249537024u, 0, LOGBF_TOLERANCE, 0},
{1250, 1171318485u, 3374409104u, 1094713344u, 0, LOGBF_TOLERANCE, 0},
{1251, 3047748143u, 831102792u, 3248488448u, 0, LOGBF_TOLERANCE, 0},
{1252, 1001216371u, 3052357038u, 3238002688u, 0, LOGBF_TOLERANCE, 0},
{1253, 2999541351u, 3085461799u, 3251634176u, 0, LOGBF_TOLERANCE, 0},
{1254, 912515889u, 1074635609u, 3247964160u, 0, LOGBF_TOLERANCE, 0},
{1255, 3391452505u, 897989232u, 1101529088u, 0, LOGBF_TOLERANCE, 0},
{1256, 3249603369u, 3147662248u, 1082130432u, 0, LOGBF_TOLERANCE, 0},
{1257, 1220264047u, 2960450369u, 1099956224u, 0, LOGBF_TOLERANCE, 0},
{1258, 3169816394u, 988430929u, 3233808384u, 0, LOGBF_TOLERANCE, 0},
{1259, 3098997418u, 3002162688u, 3244294144u, 0, LOGBF_TOLERANCE, 0},
{1260, 3282212423u, 3174079140u, 1090519040u, 0, LOGBF_TOLERANCE, 0},
{1261, 3352293320u, 3247843425u, 1098907648u, 0, LOGBF_TOLERANCE, 0},
{1262, 3296358441u, 875645354u, 1091567616u, 0, LOGBF_TOLERANCE, 0},
{1263, 1197828352u, 3245614728u, 1097859072u, 0, LOGBF_TOLERANCE, 0},
{1264, 3340510371u, 914930263u, 1097859072u, 0, LOGBF_TOLERANCE, 0},
{1265, 1127109339u, 3368125489u, 1088421888u, 0, LOGBF_TOLERANCE, 0},
{1266, 816173492u, 1083268662u, 3253731328u, 0, LOGBF_TOLERANCE, 0},
{1267, 909467381u, 1232375752u, 3247964160u, 0, LOGBF_TOLERANCE, 0},
{1268, 1200599955u, 2981200675u, 1098907648u, 0, LOGBF_TOLERANCE, 0},
{1269, 962230977u, 2988248037u, 3243245568u, 0, LOGBF_TOLERANCE, 0},
{1270, 2996667337u, 1068572835u, 3251634176u, 0, LOGBF_TOLERANCE, 0},
{1271, 3192887808u, 3191848339u, 3225419776u, 0, LOGBF_TOLERANCE, 0},
{1272, 3237183876u, 3179379969u, 1073741824u, 0, LOGBF_TOLERANCE, 0},
{1273, 939285924u, 3056079386u, 3246391296u, 0, LOGBF_TOLERANCE, 0},
{1274, 944050180u, 3452557879u, 3245342720u, 0, LOGBF_TOLERANCE, 0},
{1275, 3058135703u, 3090284601u, 3247964160u, 0, LOGBF_TOLERANCE, 0},
{1276, 3480592662u, 3261728191u, 1106771968u, 0, LOGBF_TOLERANCE, 0},
{1277, 3061939312u, 3274418540u, 3247439872u, 0, LOGBF_TOLERANCE, 0},
{1278, 1003299981u, 853295521u, 3238002688u, 0, LOGBF_TOLERANCE, 0},
{1279, 1155775526u, 1255814444u, 1092616192u, 0, LOGBF_TOLERANCE, 0},
{1280, 1234491880u, 3408568717u, 1101004800u, 0, LOGBF_TOLERANCE, 0}

// AUTOMATICALLY GENERATED VECTORS STOP

};

#endif // CYGONCE_LIBM_LOGBF_H multiple inclusion protection

// EOF logbf.h
