#ifndef CYGONCE_LIBM_LOG10_H
#define CYGONCE_LIBM_LOG10_H
//===========================================================================
//
//      log10.h
//
//      Test vectors for testing of log10() math library function
//
//===========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####
// -------------------------------------------
// This file is part of eCos, the Embedded Configurable Operating System.
// Copyright (C) 2012 Free Software Foundation, Inc.
//
// eCos is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 or (at your option) any later
// version.
//
// eCos is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
// for more details.
//
// You should have received a copy of the GNU General Public License
// along with eCos; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//
// As a special exception, if other files instantiate templates or use
// macros or inline functions from this file, or you compile this file
// and link it with other works to produce a work based on this file,
// this file does not by itself cause the resulting work to be covered by
// the GNU General Public License. However the source code for this file
// must still be made available in accordance with section (3) of the GNU
// General Public License v2.
//
// This exception does not invalidate any other reasons why a work based
// on this file might be covered by the GNU General Public License.
// -------------------------------------------
// ####ECOSGPLCOPYRIGHTEND####
//===========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):
// Contributors:  visar, ilijak
// Date:        1998-02-13
// Purpose:
// Description:
// Usage:       #include "vectors/log10.h"
//
//####DESCRIPTIONEND####
//
//===========================================================================


// CONFIGURATION

#include <pkgconf/libm.h>   // Configuration header


// INCLUDES

#include <cyg/infra/cyg_type.h>    // Common type definitions and support
#include "vectors/vector_support_float.h"// extra support for math tests

#define LOG10_TOLERANCE 1.0E-04

static const Cyg_libm_test_float_vec_t log10f_vec[] = {

// AUTOMATICALLY GENERATED VECTORS START

{0, 3214514586u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{1, 3214430700u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{2, 3214346813u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{3, 3214262927u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{4, 3214179041u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{5, 3214095155u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{6, 3214011269u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{7, 3213927383u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{8, 3213843497u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{9, 3213759611u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{10, 3213675725u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{11, 3213591839u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{12, 3213507953u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{13, 3213424067u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{14, 3213340180u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{15, 3213256294u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{16, 3213172408u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{17, 3213088522u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{18, 3213004636u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{19, 3212920750u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{20, 3212836864u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{21, 3212669092u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{22, 3212501320u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{23, 3212333548u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{24, 3212165775u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{25, 3211998003u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{26, 3211830231u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{27, 3211662459u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{28, 3211494687u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{29, 3211326915u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{30, 3211159142u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{31, 3210991370u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{32, 3210823598u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{33, 3210655826u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{34, 3210488054u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{35, 3210320282u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{36, 3210152509u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{37, 3209984737u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{38, 3209816965u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{39, 3209649193u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{40, 3209481421u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{41, 3209313649u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{42, 3209145876u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{43, 3208978104u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{44, 3208810332u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{45, 3208642560u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{46, 3208474788u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{47, 3208307016u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{48, 3208139244u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{49, 3207971471u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{50, 3207803699u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{51, 3207635927u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{52, 3207468155u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{53, 3207300383u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{54, 3207132611u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{55, 3206964838u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{56, 3206797066u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{57, 3206629294u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{58, 3206461522u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{59, 3206293750u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{60, 3206125978u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{61, 3205958205u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{62, 3205790433u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{63, 3205622661u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{64, 3205454889u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{65, 3205287117u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{66, 3205119345u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{67, 3204951572u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{68, 3204783800u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{69, 3204616028u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{70, 3204448256u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{71, 3204112712u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{72, 3203777167u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{73, 3203441623u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{74, 3203106079u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{75, 3202770534u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{76, 3202434990u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{77, 3202099446u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{78, 3201763901u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{79, 3201428357u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{80, 3201092813u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{81, 3200757268u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{82, 3200421724u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{83, 3200086180u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{84, 3199750636u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{85, 3199415091u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{86, 3199079547u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{87, 3198744003u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{88, 3198408458u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{89, 3198072914u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{90, 3197737370u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{91, 3197401825u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{92, 3197066281u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{93, 3196730737u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{94, 3196395192u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{95, 3196059648u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{96, 3195388559u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{97, 3194717471u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{98, 3194046382u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{99, 3193375293u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{100, 3192704205u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{101, 3192033116u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{102, 3191362028u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{103, 3190690939u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{104, 3190019850u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{105, 3189348762u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{106, 3188677673u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{107, 3188006584u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{108, 3186999951u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{109, 3185657774u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{110, 3184315597u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{111, 3182973420u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{112, 3181631242u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{113, 3180289065u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{114, 3178611343u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{115, 3175926989u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{116, 3173242634u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{117, 3170222735u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{118, 3164854026u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{119, 3156465418u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{120, 646742016u, 3245354289u, 3245354289u, 0, LOG10_TOLERANCE, 0},
{121, 1008981770u, 3221225472u, 3221225472u, 0, LOG10_TOLERANCE, 0},
{122, 1017370378u, 3218700250u, 3218700250u, 0, LOG10_TOLERANCE, 0},
{123, 1022739087u, 3217223089u, 3217223089u, 0, LOG10_TOLERANCE, 0},
{124, 1025758986u, 3216175027u, 3216175027u, 0, LOG10_TOLERANCE, 0},
{125, 1028443341u, 3215362087u, 3215362087u, 0, LOG10_TOLERANCE, 0},
{126, 1031127695u, 3214697866u, 3214697866u, 0, LOG10_TOLERANCE, 0},
{127, 1032805417u, 3214136276u, 3214136276u, 0, LOG10_TOLERANCE, 0},
{128, 1034147594u, 3213649804u, 3213649804u, 0, LOG10_TOLERANCE, 0},
{129, 1035489772u, 3213220706u, 3213220706u, 0, LOG10_TOLERANCE, 0},
{130, 1036831949u, 3212836864u, 3212836864u, 0, LOG10_TOLERANCE, 0},
{131, 1038174126u, 3212142410u, 3212142410u, 0, LOG10_TOLERANCE, 0},
{132, 1039516303u, 3211508423u, 3211508423u, 0, LOG10_TOLERANCE, 0},
{133, 1040522936u, 3210925212u, 3210925212u, 0, LOG10_TOLERANCE, 0},
{134, 1041194025u, 3210385242u, 3210385242u, 0, LOG10_TOLERANCE, 0},
{135, 1041865114u, 3209882543u, 3209882543u, 0, LOG10_TOLERANCE, 0},
{136, 1042536202u, 3209412299u, 3209412299u, 0, LOG10_TOLERANCE, 0},
{137, 1043207291u, 3208970573u, 3208970573u, 0, LOG10_TOLERANCE, 0},
{138, 1043878380u, 3208554102u, 3208554102u, 0, LOG10_TOLERANCE, 0},
{139, 1044549468u, 3208160155u, 3208160155u, 0, LOG10_TOLERANCE, 0},
{140, 1045220557u, 3207786419u, 3207786419u, 0, LOG10_TOLERANCE, 0},
{141, 1045891645u, 3207430922u, 3207430922u, 0, LOG10_TOLERANCE, 0},
{142, 1046562734u, 3207091965u, 3207091965u, 0, LOG10_TOLERANCE, 0},
{143, 1047233823u, 3206768078u, 3206768078u, 0, LOG10_TOLERANCE, 0},
{144, 1047904911u, 3206457978u, 3206457978u, 0, LOG10_TOLERANCE, 0},
{145, 1048576000u, 3206160539u, 3206160539u, 0, LOG10_TOLERANCE, 0},
{146, 1048911544u, 3205874767u, 3205874767u, 0, LOG10_TOLERANCE, 0},
{147, 1049247089u, 3205599781u, 3205599781u, 0, LOG10_TOLERANCE, 0},
{148, 1049582633u, 3205334797u, 3205334797u, 0, LOG10_TOLERANCE, 0},
{149, 1049918177u, 3205079113u, 3205079113u, 0, LOG10_TOLERANCE, 0},
{150, 1050253722u, 3204832097u, 3204832097u, 0, LOG10_TOLERANCE, 0},
{151, 1050589266u, 3204593183u, 3204593183u, 0, LOG10_TOLERANCE, 0},
{152, 1050924810u, 3204275452u, 3204275452u, 0, LOG10_TOLERANCE, 0},
{153, 1051260355u, 3203827031u, 3203827031u, 0, LOG10_TOLERANCE, 0},
{154, 1051595899u, 3203391999u, 3203391999u, 0, LOG10_TOLERANCE, 0},
{155, 1051931443u, 3202969578u, 3202969578u, 0, LOG10_TOLERANCE, 0},
{156, 1052266988u, 3202559057u, 3202559057u, 0, LOG10_TOLERANCE, 0},
{157, 1052602532u, 3202159786u, 3202159786u, 0, LOG10_TOLERANCE, 0},
{158, 1052938076u, 3201771163u, 3201771163u, 0, LOG10_TOLERANCE, 0},
{159, 1053273620u, 3201392635u, 3201392635u, 0, LOG10_TOLERANCE, 0},
{160, 1053609165u, 3201023691u, 3201023691u, 0, LOG10_TOLERANCE, 0},
{161, 1053944709u, 3200663858u, 3200663858u, 0, LOG10_TOLERANCE, 0},
{162, 1054280253u, 3200312697u, 3200312697u, 0, LOG10_TOLERANCE, 0},
{163, 1054615798u, 3199969798u, 3199969798u, 0, LOG10_TOLERANCE, 0},
{164, 1054951342u, 3199634783u, 3199634783u, 0, LOG10_TOLERANCE, 0},
{165, 1055286886u, 3199307297u, 3199307297u, 0, LOG10_TOLERANCE, 0},
{166, 1055622431u, 3198987009u, 3198987009u, 0, LOG10_TOLERANCE, 0},
{167, 1055957975u, 3198673610u, 3198673610u, 0, LOG10_TOLERANCE, 0},
{168, 1056293519u, 3198366810u, 3198366810u, 0, LOG10_TOLERANCE, 0},
{169, 1056629064u, 3198066334u, 3198066334u, 0, LOG10_TOLERANCE, 0},
{170, 1056964608u, 3197771931u, 3197771931u, 0, LOG10_TOLERANCE, 0},
{171, 1057132380u, 3197483357u, 3197483357u, 0, LOG10_TOLERANCE, 0},
{172, 1057300152u, 3197200387u, 3197200387u, 0, LOG10_TOLERANCE, 0},
{173, 1057467924u, 3196922807u, 3196922807u, 0, LOG10_TOLERANCE, 0},
{174, 1057635697u, 3196650415u, 3196650415u, 0, LOG10_TOLERANCE, 0},
{175, 1057803469u, 3196383022u, 3196383022u, 0, LOG10_TOLERANCE, 0},
{176, 1057971241u, 3196120448u, 3196120448u, 0, LOG10_TOLERANCE, 0},
{177, 1058139013u, 3195665393u, 3195665393u, 0, LOG10_TOLERANCE, 0},
{178, 1058306785u, 3195158511u, 3195158511u, 0, LOG10_TOLERANCE, 0},
{179, 1058474557u, 3194660294u, 3194660294u, 0, LOG10_TOLERANCE, 0},
{180, 1058642330u, 3194170449u, 3194170449u, 0, LOG10_TOLERANCE, 0},
{181, 1058810102u, 3193688703u, 3193688703u, 0, LOG10_TOLERANCE, 0},
{182, 1058977874u, 3193214790u, 3193214790u, 0, LOG10_TOLERANCE, 0},
{183, 1059145646u, 3192748460u, 3192748460u, 0, LOG10_TOLERANCE, 0},
{184, 1059313418u, 3192289475u, 3192289475u, 0, LOG10_TOLERANCE, 0},
{185, 1059481190u, 3191837605u, 3191837605u, 0, LOG10_TOLERANCE, 0},
{186, 1059648963u, 3191392633u, 3191392633u, 0, LOG10_TOLERANCE, 0},
{187, 1059816735u, 3190954354u, 3190954354u, 0, LOG10_TOLERANCE, 0},
{188, 1059984507u, 3190522569u, 3190522569u, 0, LOG10_TOLERANCE, 0},
{189, 1060152279u, 3190097087u, 3190097087u, 0, LOG10_TOLERANCE, 0},
{190, 1060320051u, 3189677727u, 3189677727u, 0, LOG10_TOLERANCE, 0},
{191, 1060487823u, 3189264315u, 3189264315u, 0, LOG10_TOLERANCE, 0},
{192, 1060655596u, 3188856685u, 3188856685u, 0, LOG10_TOLERANCE, 0},
{193, 1060823368u, 3188454679u, 3188454679u, 0, LOG10_TOLERANCE, 0},
{194, 1060991140u, 3188058142u, 3188058142u, 0, LOG10_TOLERANCE, 0},
{195, 1061158912u, 3187662818u, 3187662818u, 0, LOG10_TOLERANCE, 0},
{196, 1061326684u, 3186890754u, 3186890754u, 0, LOG10_TOLERANCE, 0},
{197, 1061494456u, 3186128782u, 3186128782u, 0, LOG10_TOLERANCE, 0},
{198, 1061662228u, 3185376643u, 3185376643u, 0, LOG10_TOLERANCE, 0},
{199, 1061830001u, 3184634082u, 3184634082u, 0, LOG10_TOLERANCE, 0},
{200, 1061997773u, 3183900865u, 3183900865u, 0, LOG10_TOLERANCE, 0},
{201, 1062165545u, 3183176757u, 3183176757u, 0, LOG10_TOLERANCE, 0},
{202, 1062333317u, 3182461534u, 3182461534u, 0, LOG10_TOLERANCE, 0},
{203, 1062501089u, 3181754980u, 3181754980u, 0, LOG10_TOLERANCE, 0},
{204, 1062668861u, 3181056888u, 3181056888u, 0, LOG10_TOLERANCE, 0},
{205, 1062836634u, 3180367054u, 3180367054u, 0, LOG10_TOLERANCE, 0},
{206, 1063004406u, 3179685292u, 3179685292u, 0, LOG10_TOLERANCE, 0},
{207, 1063172178u, 3178740393u, 3178740393u, 0, LOG10_TOLERANCE, 0},
{208, 1063339950u, 3177408035u, 3177408035u, 0, LOG10_TOLERANCE, 0},
{209, 1063507722u, 3176090734u, 3176090734u, 0, LOG10_TOLERANCE, 0},
{210, 1063675494u, 3174788151u, 3174788151u, 0, LOG10_TOLERANCE, 0},
{211, 1063843267u, 3173499955u, 3173499955u, 0, LOG10_TOLERANCE, 0},
{212, 1064011039u, 3172225844u, 3172225844u, 0, LOG10_TOLERANCE, 0},
{213, 1064178811u, 3170965510u, 3170965510u, 0, LOG10_TOLERANCE, 0},
{214, 1064346583u, 3168543482u, 3168543482u, 0, LOG10_TOLERANCE, 0},
{215, 1064514355u, 3166076159u, 3166076159u, 0, LOG10_TOLERANCE, 0},
{216, 1064682127u, 3163634672u, 3163634672u, 0, LOG10_TOLERANCE, 0},
{217, 1064849900u, 3159931729u, 3159931729u, 0, LOG10_TOLERANCE, 0},
{218, 1065017672u, 3155148921u, 3155148921u, 0, LOG10_TOLERANCE, 0},
{219, 1065185444u, 3146712732u, 3146712732u, 0, LOG10_TOLERANCE, 0},
{220, 1065353216u, 0u, 0u, 0, LOG10_TOLERANCE, 0},
{221, 1065437102u, 999135815u, 999135815u, 0, LOG10_TOLERANCE, 0},
{222, 1065520988u, 1007478707u, 1007478707u, 0, LOG10_TOLERANCE, 0},
{223, 1065604874u, 1012028204u, 1012028204u, 0, LOG10_TOLERANCE, 0},
{224, 1065688760u, 1015777656u, 1015777656u, 0, LOG10_TOLERANCE, 0},
{225, 1065772646u, 1018008867u, 1018008867u, 0, LOG10_TOLERANCE, 0},
{226, 1065856532u, 1020218930u, 1020218930u, 0, LOG10_TOLERANCE, 0},
{227, 1065940419u, 1022408268u, 1022408268u, 0, LOG10_TOLERANCE, 0},
{228, 1066024305u, 1023993694u, 1023993694u, 0, LOG10_TOLERANCE, 0},
{229, 1066108191u, 1025068170u, 1025068170u, 0, LOG10_TOLERANCE, 0},
{230, 1066192077u, 1026132835u, 1026132835u, 0, LOG10_TOLERANCE, 0},
{231, 1066275963u, 1027187863u, 1027187863u, 0, LOG10_TOLERANCE, 0},
{232, 1066359849u, 1028233432u, 1028233432u, 0, LOG10_TOLERANCE, 0},
{233, 1066443735u, 1029269702u, 1029269702u, 0, LOG10_TOLERANCE, 0},
{234, 1066527621u, 1030296848u, 1030296848u, 0, LOG10_TOLERANCE, 0},
{235, 1066611507u, 1031315018u, 1031315018u, 0, LOG10_TOLERANCE, 0},
{236, 1066695393u, 1032061580u, 1032061580u, 0, LOG10_TOLERANCE, 0},
{237, 1066779279u, 1032561925u, 1032561925u, 0, LOG10_TOLERANCE, 0},
{238, 1066863165u, 1033058013u, 1033058013u, 0, LOG10_TOLERANCE, 0},
{239, 1066947052u, 1033549920u, 1033549920u, 0, LOG10_TOLERANCE, 0},
{240, 3234402267u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{241, 3231108068u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{242, 3226013659u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{243, 3217625051u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{244, 0u, 1115684864u, 4286578688u, EDOM, LOG10_TOLERANCE, 0},
{245, 1070141403u, 1044960167u, 1044960167u, 0, LOG10_TOLERANCE, 0},
{246, 1078530011u, 1056868974u, 1056868974u, 0, LOG10_TOLERANCE, 0},
{247, 1083624420u, 1059871112u, 1059871112u, 0, LOG10_TOLERANCE, 0},
{248, 3253731328u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{249, 3252840038u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{250, 3251948749u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{251, 3251057459u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{252, 3250166170u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{253, 3249274880u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{254, 3248383590u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{255, 3247492301u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{256, 3246601011u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{257, 3245028147u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{258, 3243245568u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{259, 3241462989u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{260, 3239680410u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{261, 3237792973u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{262, 3234227814u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{263, 3230662656u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{264, 3224580915u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{265, 3213675725u, 1115684864u, 2143289344u, EDOM, LOG10_TOLERANCE, 0},
{266, 1058642330u, 3194170449u, 3194170449u, 0, LOG10_TOLERANCE, 0},
{267, 1075000115u, 1052324964u, 1052324964u, 0, LOG10_TOLERANCE, 0},
{268, 1082130432u, 1058676891u, 1058676891u, 0, LOG10_TOLERANCE, 0},
{269, 1085695590u, 1061257475u, 1061257475u, 0, LOG10_TOLERANCE, 0},
{270, 1089260749u, 1063159288u, 1063159288u, 0, LOG10_TOLERANCE, 0},
{271, 1091672474u, 1064666045u, 1064666045u, 0, LOG10_TOLERANCE, 0},
{272, 1093455053u, 1065633595u, 1065633595u, 0, LOG10_TOLERANCE, 0},
{273, 1095237632u, 1066166156u, 1066166156u, 0, LOG10_TOLERANCE, 0},
{274, 1097020211u, 1066630703u, 1066630703u, 0, LOG10_TOLERANCE, 0},
{275, 1098802790u, 1067042657u, 1067042657u, 0, LOG10_TOLERANCE, 0},
{276, 1099746509u, 1067412726u, 1067412726u, 0, LOG10_TOLERANCE, 0},
{277, 1100637798u, 1067748644u, 1067748644u, 0, LOG10_TOLERANCE, 0},
{278, 1101529088u, 1068056187u, 1068056187u, 0, LOG10_TOLERANCE, 0},
{279, 1102420378u, 1068339777u, 1068339777u, 0, LOG10_TOLERANCE, 0},
{280, 1103311667u, 1068602877u, 1068602877u, 0, LOG10_TOLERANCE, 0},
{281, 1104202957u, 1068848250u, 1068848250u, 0, LOG10_TOLERANCE, 0},
{282, 1105094246u, 1069078134u, 1069078134u, 0, LOG10_TOLERANCE, 0},
{283, 1105985536u, 1069294369u, 1069294369u, 0, LOG10_TOLERANCE, 0},
{284, 1107800421u, 1069803350u, 1069803350u, 0, LOG10_TOLERANCE, 0},
{285, 1221216477u, 1085522141u, 1085522141u, 0, LOG10_TOLERANCE, 0},
{286, 1224242132u, 1085709375u, 1085709375u, 0, LOG10_TOLERANCE, 0},
{287, 1073543469u, 1050114967u, 1050114967u, 0, LOG10_TOLERANCE, 0},
{288, 1198712763u, 1083794893u, 1083794893u, 0, LOG10_TOLERANCE, 0},
{289, 1312607135u, 1091461344u, 1091461344u, 0, LOG10_TOLERANCE, 0},
{290, 1166191415u, 1080542141u, 1080542141u, 0, LOG10_TOLERANCE, 0},
{291, 1234419246u, 1086498583u, 1086498583u, 0, LOG10_TOLERANCE, 0},
{292, 1302107128u, 1091060483u, 1091060483u, 0, LOG10_TOLERANCE, 0},
{293, 1336836355u, 1092372456u, 1092372456u, 0, LOG10_TOLERANCE, 0},
{294, 1167223673u, 1080749457u, 1080749457u, 0, LOG10_TOLERANCE, 0},
{295, 1324169524u, 1091880980u, 1091880980u, 0, LOG10_TOLERANCE, 0},
{296, 1083983848u, 1060131406u, 1060131406u, 0, LOG10_TOLERANCE, 0},
{297, 1341514497u, 1092528620u, 1092528620u, 0, LOG10_TOLERANCE, 0},
{298, 1272351391u, 1089363554u, 1089363554u, 0, LOG10_TOLERANCE, 0},
{299, 1172241344u, 1081515641u, 1081515641u, 0, LOG10_TOLERANCE, 0},
{300, 1104057898u, 1068809424u, 1068809424u, 0, LOG10_TOLERANCE, 0},
{301, 1224379831u, 1085717045u, 1085717045u, 0, LOG10_TOLERANCE, 0},
{302, 1306460502u, 1091221528u, 1091221528u, 0, LOG10_TOLERANCE, 0},
{303, 1197542187u, 1083725330u, 1083725330u, 0, LOG10_TOLERANCE, 0},
{304, 1184239996u, 1082724972u, 1082724972u, 0, LOG10_TOLERANCE, 0},
{305, 1252490238u, 1087875421u, 1087875421u, 0, LOG10_TOLERANCE, 0},
{306, 1139715822u, 1076589136u, 1076589136u, 0, LOG10_TOLERANCE, 0},
{307, 1143233714u, 1077172184u, 1077172184u, 0, LOG10_TOLERANCE, 0},
{308, 1139941253u, 1076615200u, 1076615200u, 0, LOG10_TOLERANCE, 0},
{309, 1092814839u, 1065421588u, 1065421588u, 0, LOG10_TOLERANCE, 0},
{310, 1288902137u, 1090565208u, 1090565208u, 0, LOG10_TOLERANCE, 0},
{311, 1333134799u, 1092213219u, 1092213219u, 0, LOG10_TOLERANCE, 0},
{312, 1187847971u, 1083009603u, 1083009603u, 0, LOG10_TOLERANCE, 0},
{313, 1181870825u, 1082528571u, 1082528571u, 0, LOG10_TOLERANCE, 0},
{314, 1309289088u, 1091319168u, 1091319168u, 0, LOG10_TOLERANCE, 0},
{315, 1297170011u, 1090876869u, 1090876869u, 0, LOG10_TOLERANCE, 0},
{316, 1258101754u, 1088251511u, 1088251511u, 0, LOG10_TOLERANCE, 0},
{317, 1106778573u, 1069476537u, 1069476537u, 0, LOG10_TOLERANCE, 0},
{318, 1140567947u, 1076685758u, 1076685758u, 0, LOG10_TOLERANCE, 0},
{319, 1238569473u, 1086823475u, 1086823475u, 0, LOG10_TOLERANCE, 0},
{320, 1261071232u, 1088522552u, 1088522552u, 0, LOG10_TOLERANCE, 0},
{321, 1175011025u, 1081894199u, 1081894199u, 0, LOG10_TOLERANCE, 0},
{322, 1082692850u, 1059149722u, 1059149722u, 0, LOG10_TOLERANCE, 0},
{323, 1255864908u, 1088119583u, 1088119583u, 0, LOG10_TOLERANCE, 0},
{324, 1136411063u, 1076156822u, 1076156822u, 0, LOG10_TOLERANCE, 0},
{325, 1091747974u, 1064723469u, 1064723469u, 0, LOG10_TOLERANCE, 0},
{326, 1193132132u, 1083401754u, 1083401754u, 0, LOG10_TOLERANCE, 0},
{327, 1270480664u, 1089233516u, 1089233516u, 0, LOG10_TOLERANCE, 0},
{328, 1148867223u, 1077938477u, 1077938477u, 0, LOG10_TOLERANCE, 0},
{329, 1152956913u, 1078647561u, 1078647561u, 0, LOG10_TOLERANCE, 0},
{330, 1109627625u, 1070484141u, 1070484141u, 0, LOG10_TOLERANCE, 0},
{331, 1307091856u, 1091240788u, 1091240788u, 0, LOG10_TOLERANCE, 0},
{332, 1077234132u, 1055360371u, 1055360371u, 0, LOG10_TOLERANCE, 0},
{333, 1142167709u, 1076982359u, 1076982359u, 0, LOG10_TOLERANCE, 0},
{334, 1278749186u, 1089855805u, 1089855805u, 0, LOG10_TOLERANCE, 0},
{335, 1221083131u, 1085512933u, 1085512933u, 0, LOG10_TOLERANCE, 0},
{336, 1138741813u, 1076472027u, 1076472027u, 0, LOG10_TOLERANCE, 0},
{337, 1142981585u, 1077129041u, 1077129041u, 0, LOG10_TOLERANCE, 0},
{338, 1199682314u, 1083854727u, 1083854727u, 0, LOG10_TOLERANCE, 0},
{339, 1326472382u, 1091970451u, 1091970451u, 0, LOG10_TOLERANCE, 0},
{340, 1201614701u, 1084041300u, 1084041300u, 0, LOG10_TOLERANCE, 0},
{341, 1198006188u, 1083753543u, 1083753543u, 0, LOG10_TOLERANCE, 0},
{342, 1108485380u, 1070073676u, 1070073676u, 0, LOG10_TOLERANCE, 0},
{343, 1233784744u, 1086436853u, 1086436853u, 0, LOG10_TOLERANCE, 0},
{344, 1087189715u, 1062115621u, 1062115621u, 0, LOG10_TOLERANCE, 0},
{345, 1065468637u, 1002600647u, 1002600647u, 0, LOG10_TOLERANCE, 0},
{346, 1318704920u, 1091683756u, 1091683756u, 0, LOG10_TOLERANCE, 0},
{347, 1171831868u, 1081463872u, 1081463872u, 0, LOG10_TOLERANCE, 0},
{348, 1315030230u, 1091542790u, 1091542790u, 0, LOG10_TOLERANCE, 0},
{349, 1134593658u, 1075866547u, 1075866547u, 0, LOG10_TOLERANCE, 0},
{350, 1086198791u, 1061557914u, 1061557914u, 0, LOG10_TOLERANCE, 0},
{351, 1255152035u, 1088073178u, 1088073178u, 0, LOG10_TOLERANCE, 0},
{352, 1135271264u, 1075980250u, 1075980250u, 0, LOG10_TOLERANCE, 0},
{353, 1094190727u, 1065862891u, 1065862891u, 0, LOG10_TOLERANCE, 0},
{354, 1294665325u, 1090785022u, 1090785022u, 0, LOG10_TOLERANCE, 0},
{355, 1082514416u, 1059003006u, 1059003006u, 0, LOG10_TOLERANCE, 0},
{356, 1291650374u, 1090647727u, 1090647727u, 0, LOG10_TOLERANCE, 0},
{357, 1325668223u, 1091929999u, 1091929999u, 0, LOG10_TOLERANCE, 0},
{358, 1092037607u, 1064939656u, 1064939656u, 0, LOG10_TOLERANCE, 0},
{359, 1168794760u, 1081025656u, 1081025656u, 0, LOG10_TOLERANCE, 0},
{360, 1147953120u, 1077834041u, 1077834041u, 0, LOG10_TOLERANCE, 0},
{361, 1151984049u, 1078494962u, 1078494962u, 0, LOG10_TOLERANCE, 0},
{362, 1129287043u, 1075071958u, 1075071958u, 0, LOG10_TOLERANCE, 0},
{363, 1243664530u, 1087207104u, 1087207104u, 0, LOG10_TOLERANCE, 0},
{364, 1115471979u, 1072069421u, 1072069421u, 0, LOG10_TOLERANCE, 0},
{365, 1203608440u, 1084200583u, 1084200583u, 0, LOG10_TOLERANCE, 0},
{366, 1276995896u, 1089712842u, 1089712842u, 0, LOG10_TOLERANCE, 0},
{367, 1093710327u, 1065714805u, 1065714805u, 0, LOG10_TOLERANCE, 0},
{368, 1110545760u, 1070783519u, 1070783519u, 0, LOG10_TOLERANCE, 0},
{369, 1214492942u, 1084998596u, 1084998596u, 0, LOG10_TOLERANCE, 0},
{370, 1304154705u, 1091143336u, 1091143336u, 0, LOG10_TOLERANCE, 0},
{371, 1116959962u, 1072631456u, 1072631456u, 0, LOG10_TOLERANCE, 0},
{372, 1227066979u, 1085959888u, 1085959888u, 0, LOG10_TOLERANCE, 0},
{373, 1268194719u, 1089044364u, 1089044364u, 0, LOG10_TOLERANCE, 0},
{374, 1133420220u, 1075651116u, 1075651116u, 0, LOG10_TOLERANCE, 0},
{375, 1161858787u, 1079985808u, 1079985808u, 0, LOG10_TOLERANCE, 0},
{376, 1148513315u, 1077898751u, 1077898751u, 0, LOG10_TOLERANCE, 0},
{377, 1270887389u, 1089263410u, 1089263410u, 0, LOG10_TOLERANCE, 0},
{378, 1177709533u, 1082251284u, 1082251284u, 0, LOG10_TOLERANCE, 0},
{379, 1189120494u, 1083091979u, 1083091979u, 0, LOG10_TOLERANCE, 0},
{380, 1323529208u, 1091861827u, 1091861827u, 0, LOG10_TOLERANCE, 0},
{381, 1318284740u, 1091664370u, 1091664370u, 0, LOG10_TOLERANCE, 0},
{382, 1278616251u, 1089845718u, 1089845718u, 0, LOG10_TOLERANCE, 0},
{383, 1077373465u, 1055530275u, 1055530275u, 0, LOG10_TOLERANCE, 0},
{384, 1065798296u, 1018686876u, 1018686876u, 0, LOG10_TOLERANCE, 0},
{385, 1181505796u, 1082507356u, 1082507356u, 0, LOG10_TOLERANCE, 0},
{386, 1210335378u, 1084701144u, 1084701144u, 0, LOG10_TOLERANCE, 0},
{387, 1273397670u, 1089428926u, 1089428926u, 0, LOG10_TOLERANCE, 0},
{388, 1277348132u, 1089743421u, 1089743421u, 0, LOG10_TOLERANCE, 0},
{389, 1257596246u, 1088223324u, 1088223324u, 0, LOG10_TOLERANCE, 0},
{390, 1147268859u, 1077751749u, 1077751749u, 0, LOG10_TOLERANCE, 0},
{391, 1277365077u, 1089744867u, 1089744867u, 0, LOG10_TOLERANCE, 0},
{392, 1090870906u, 1064026726u, 1064026726u, 0, LOG10_TOLERANCE, 0},
{393, 1227582289u, 1086002654u, 1086002654u, 0, LOG10_TOLERANCE, 0},
{394, 1272325814u, 1089361895u, 1089361895u, 0, LOG10_TOLERANCE, 0},
{395, 1212024623u, 1084833908u, 1084833908u, 0, LOG10_TOLERANCE, 0},
{396, 1137854355u, 1076358345u, 1076358345u, 0, LOG10_TOLERANCE, 0},
{397, 1293289410u, 1090725378u, 1090725378u, 0, LOG10_TOLERANCE, 0},
{398, 1303733188u, 1091127468u, 1091127468u, 0, LOG10_TOLERANCE, 0},
{399, 1289579346u, 1090586972u, 1090586972u, 0, LOG10_TOLERANCE, 0},
{400, 1131196082u, 1075311190u, 1075311190u, 0, LOG10_TOLERANCE, 0},
{401, 1110614030u, 1070804828u, 1070804828u, 0, LOG10_TOLERANCE, 0},
{402, 1313431700u, 1091490724u, 1091490724u, 0, LOG10_TOLERANCE, 0},
{403, 1155551824u, 1079001317u, 1079001317u, 0, LOG10_TOLERANCE, 0},
{404, 1248682573u, 1087561786u, 1087561786u, 0, LOG10_TOLERANCE, 0},
{405, 1311450615u, 1091416655u, 1091416655u, 0, LOG10_TOLERANCE, 0},
{406, 1065761827u, 1017722309u, 1017722309u, 0, LOG10_TOLERANCE, 0},
{407, 1199816046u, 1083868945u, 1083868945u, 0, LOG10_TOLERANCE, 0},
{408, 1186295367u, 1082897824u, 1082897824u, 0, LOG10_TOLERANCE, 0},
{409, 1080781593u, 1058066206u, 1058066206u, 0, LOG10_TOLERANCE, 0},
{410, 1087842942u, 1062461221u, 1062461221u, 0, LOG10_TOLERANCE, 0},
{411, 1079506760u, 1057437815u, 1057437815u, 0, LOG10_TOLERANCE, 0},
{412, 1283624229u, 1090173747u, 1090173747u, 0, LOG10_TOLERANCE, 0},
{413, 1193633657u, 1083444899u, 1083444899u, 0, LOG10_TOLERANCE, 0},
{414, 1270734970u, 1089252322u, 1089252322u, 0, LOG10_TOLERANCE, 0},
{415, 1307332419u, 1091247917u, 1091247917u, 0, LOG10_TOLERANCE, 0},
{416, 1106502045u, 1069414045u, 1069414045u, 0, LOG10_TOLERANCE, 0},
{417, 1157598381u, 1079238732u, 1079238732u, 0, LOG10_TOLERANCE, 0},
{418, 1187750865u, 1083003000u, 1083003000u, 0, LOG10_TOLERANCE, 0},
{419, 1279489061u, 1089909993u, 1089909993u, 0, LOG10_TOLERANCE, 0},
{420, 1233171235u, 1086372903u, 1086372903u, 0, LOG10_TOLERANCE, 0},
{421, 1148920078u, 1077944337u, 1077944337u, 0, LOG10_TOLERANCE, 0},
{422, 1109198803u, 1070335413u, 1070335413u, 0, LOG10_TOLERANCE, 0},
{423, 1072465835u, 1049135559u, 1049135559u, 0, LOG10_TOLERANCE, 0},
{424, 1213665826u, 1084946659u, 1084946659u, 0, LOG10_TOLERANCE, 0},
{425, 1207502108u, 1084448842u, 1084448842u, 0, LOG10_TOLERANCE, 0},
{426, 1234530539u, 1086508992u, 1086508992u, 0, LOG10_TOLERANCE, 0},
{427, 1158845204u, 1079488769u, 1079488769u, 0, LOG10_TOLERANCE, 0},
{428, 1291910469u, 1090656565u, 1090656565u, 0, LOG10_TOLERANCE, 0},
{429, 1131927531u, 1075395124u, 1075395124u, 0, LOG10_TOLERANCE, 0},
{430, 1302395743u, 1091073115u, 1091073115u, 0, LOG10_TOLERANCE, 0},
{431, 1125551064u, 1074487026u, 1074487026u, 0, LOG10_TOLERANCE, 0},
{432, 1279812724u, 1089932721u, 1089932721u, 0, LOG10_TOLERANCE, 0},
{433, 1198917460u, 1083806530u, 1083806530u, 0, LOG10_TOLERANCE, 0},
{434, 1091906532u, 1064842614u, 1064842614u, 0, LOG10_TOLERANCE, 0},
{435, 1246074130u, 1087394636u, 1087394636u, 0, LOG10_TOLERANCE, 0},
{436, 1276853215u, 1089700158u, 1089700158u, 0, LOG10_TOLERANCE, 0},
{437, 1315294792u, 1091550861u, 1091550861u, 0, LOG10_TOLERANCE, 0},
{438, 1212686469u, 1084881069u, 1084881069u, 0, LOG10_TOLERANCE, 0},
{439, 1076761780u, 1054769178u, 1054769178u, 0, LOG10_TOLERANCE, 0},
{440, 1120124467u, 1073663442u, 1073663442u, 0, LOG10_TOLERANCE, 0},
{441, 1268744779u, 1089093595u, 1089093595u, 0, LOG10_TOLERANCE, 0},
{442, 1165195428u, 1080413148u, 1080413148u, 0, LOG10_TOLERANCE, 0},
{443, 1100306391u, 1067627328u, 1067627328u, 0, LOG10_TOLERANCE, 0},
{444, 1067761000u, 1038118927u, 1038118927u, 0, LOG10_TOLERANCE, 0},
{445, 1212717473u, 1084883219u, 1084883219u, 0, LOG10_TOLERANCE, 0},
{446, 1128489361u, 1074961874u, 1074961874u, 0, LOG10_TOLERANCE, 0},
{447, 1243678660u, 1087208324u, 1087208324u, 0, LOG10_TOLERANCE, 0},
{448, 1089986803u, 1063492442u, 1063492442u, 0, LOG10_TOLERANCE, 0},
{449, 1296314700u, 1090847540u, 1090847540u, 0, LOG10_TOLERANCE, 0},
{450, 1251462432u, 1087785875u, 1087785875u, 0, LOG10_TOLERANCE, 0},
{451, 1337753254u, 1092407577u, 1092407577u, 0, LOG10_TOLERANCE, 0},
{452, 1114685890u, 1071892293u, 1071892293u, 0, LOG10_TOLERANCE, 0},
{453, 1295475718u, 1090816812u, 1090816812u, 0, LOG10_TOLERANCE, 0},
{454, 1256888357u, 1088182325u, 1088182325u, 0, LOG10_TOLERANCE, 0},
{455, 1125800069u, 1074532428u, 1074532428u, 0, LOG10_TOLERANCE, 0},
{456, 1189421739u, 1083110436u, 1083110436u, 0, LOG10_TOLERANCE, 0},
{457, 1164046161u, 1080276982u, 1080276982u, 0, LOG10_TOLERANCE, 0},
{458, 1292596266u, 1090692087u, 1090692087u, 0, LOG10_TOLERANCE, 0},
{459, 1322264731u, 1091821460u, 1091821460u, 0, LOG10_TOLERANCE, 0},
{460, 1314644642u, 1091530765u, 1091530765u, 0, LOG10_TOLERANCE, 0},
{461, 1252329525u, 1087861987u, 1087861987u, 0, LOG10_TOLERANCE, 0},
{462, 1341639087u, 1092532128u, 1092532128u, 0, LOG10_TOLERANCE, 0},
{463, 1181604787u, 1082513158u, 1082513158u, 0, LOG10_TOLERANCE, 0},
{464, 1314588083u, 1091528974u, 1091528974u, 0, LOG10_TOLERANCE, 0},
{465, 1253466032u, 1087952991u, 1087952991u, 0, LOG10_TOLERANCE, 0},
{466, 1218098153u, 1085277897u, 1085277897u, 0, LOG10_TOLERANCE, 0},
{467, 1110424755u, 1070745442u, 1070745442u, 0, LOG10_TOLERANCE, 0},
{468, 1139120919u, 1076518507u, 1076518507u, 0, LOG10_TOLERANCE, 0},
{469, 1220524226u, 1085473295u, 1085473295u, 0, LOG10_TOLERANCE, 0},
{470, 1234908052u, 1086543439u, 1086543439u, 0, LOG10_TOLERANCE, 0},
{471, 1156767533u, 1079146047u, 1079146047u, 0, LOG10_TOLERANCE, 0},
{472, 1332389915u, 1092191679u, 1092191679u, 0, LOG10_TOLERANCE, 0},
{473, 1276780469u, 1089693621u, 1089693621u, 0, LOG10_TOLERANCE, 0},
{474, 1080882239u, 1058113583u, 1058113583u, 0, LOG10_TOLERANCE, 0},
{475, 1212129651u, 1084841557u, 1084841557u, 0, LOG10_TOLERANCE, 0},
{476, 1311706596u, 1091426931u, 1091426931u, 0, LOG10_TOLERANCE, 0},
{477, 1337315179u, 1092391134u, 1092391134u, 0, LOG10_TOLERANCE, 0},
{478, 1131358407u, 1075330153u, 1075330153u, 0, LOG10_TOLERANCE, 0},
{479, 1156517523u, 1079117208u, 1079117208u, 0, LOG10_TOLERANCE, 0},
{480, 1190015561u, 1083145758u, 1083145758u, 0, LOG10_TOLERANCE, 0},
{481, 1320945382u, 1091775140u, 1091775140u, 0, LOG10_TOLERANCE, 0},
{482, 1106032152u, 1069305333u, 1069305333u, 0, LOG10_TOLERANCE, 0},
{483, 1277806832u, 1089781763u, 1089781763u, 0, LOG10_TOLERANCE, 0},
{484, 1073495847u, 1050073048u, 1050073048u, 0, LOG10_TOLERANCE, 0},
{485, 1311016004u, 1091398659u, 1091398659u, 0, LOG10_TOLERANCE, 0},
{486, 1128016396u, 1074893316u, 1074893316u, 0, LOG10_TOLERANCE, 0},
{487, 1206054701u, 1084364256u, 1084364256u, 0, LOG10_TOLERANCE, 0},
{488, 1213609983u, 1084943043u, 1084943043u, 0, LOG10_TOLERANCE, 0},
{489, 1246902946u, 1087451143u, 1087451143u, 0, LOG10_TOLERANCE, 0},
{490, 1214599180u, 1085005057u, 1085005057u, 0, LOG10_TOLERANCE, 0},
{491, 1237504879u, 1086750535u, 1086750535u, 0, LOG10_TOLERANCE, 0},
{492, 1317696241u, 1091635752u, 1091635752u, 0, LOG10_TOLERANCE, 0},
{493, 1087912276u, 1062496959u, 1062496959u, 0, LOG10_TOLERANCE, 0},
{494, 1194393976u, 1083506640u, 1083506640u, 0, LOG10_TOLERANCE, 0},
{495, 1228636133u, 1086084319u, 1086084319u, 0, LOG10_TOLERANCE, 0},
{496, 1207246237u, 1084434449u, 1084434449u, 0, LOG10_TOLERANCE, 0},
{497, 1165476654u, 1080444974u, 1080444974u, 0, LOG10_TOLERANCE, 0},
{498, 1215278023u, 1085045296u, 1085045296u, 0, LOG10_TOLERANCE, 0},
{499, 1149651309u, 1078066669u, 1078066669u, 0, LOG10_TOLERANCE, 0},
{500, 1111943722u, 1071196778u, 1071196778u, 0, LOG10_TOLERANCE, 0},
{501, 1189849849u, 1083136038u, 1083136038u, 0, LOG10_TOLERANCE, 0},
{502, 1249758327u, 1087622683u, 1087622683u, 0, LOG10_TOLERANCE, 0},
{503, 1168098747u, 1080908429u, 1080908429u, 0, LOG10_TOLERANCE, 0},
{504, 1153525376u, 1078731147u, 1078731147u, 0, LOG10_TOLERANCE, 0},
{505, 1085605579u, 1061202403u, 1061202403u, 0, LOG10_TOLERANCE, 0},
{506, 1070761636u, 1046300717u, 1046300717u, 0, LOG10_TOLERANCE, 0},
{507, 1068498242u, 1041078347u, 1041078347u, 0, LOG10_TOLERANCE, 0},
{508, 1266687209u, 1088893963u, 1088893963u, 0, LOG10_TOLERANCE, 0},
{509, 1340476127u, 1092498288u, 1092498288u, 0, LOG10_TOLERANCE, 0},
{510, 1197582051u, 1083727789u, 1083727789u, 0, LOG10_TOLERANCE, 0},
{511, 1262852441u, 1088657324u, 1088657324u, 0, LOG10_TOLERANCE, 0},
{512, 1141063391u, 1076762330u, 1076762330u, 0, LOG10_TOLERANCE, 0},
{513, 1206196143u, 1084372877u, 1084372877u, 0, LOG10_TOLERANCE, 0},
{514, 1219643887u, 1085407136u, 1085407136u, 0, LOG10_TOLERANCE, 0},
{515, 1134469222u, 1075844873u, 1075844873u, 0, LOG10_TOLERANCE, 0},
{516, 1237868497u, 1086776110u, 1086776110u, 0, LOG10_TOLERANCE, 0},
{517, 1153753924u, 1078763701u, 1078763701u, 0, LOG10_TOLERANCE, 0},
{518, 1120261759u, 1073702225u, 1073702225u, 0, LOG10_TOLERANCE, 0},
{519, 1078844712u, 1057088763u, 1057088763u, 0, LOG10_TOLERANCE, 0},
{520, 1202112338u, 1084083741u, 1084083741u, 0, LOG10_TOLERANCE, 0},
{521, 1087750238u, 1062413161u, 1062413161u, 0, LOG10_TOLERANCE, 0},
{522, 1066116543u, 1025174611u, 1025174611u, 0, LOG10_TOLERANCE, 0},
{523, 1186234578u, 1082893155u, 1082893155u, 0, LOG10_TOLERANCE, 0},
{524, 1331680743u, 1092170179u, 1092170179u, 0, LOG10_TOLERANCE, 0},
{525, 1201949077u, 1084070034u, 1084070034u, 0, LOG10_TOLERANCE, 0},
{526, 1081311485u, 1058312253u, 1058312253u, 0, LOG10_TOLERANCE, 0},
{527, 1149300655u, 1077992605u, 1077992605u, 0, LOG10_TOLERANCE, 0},
{528, 1240669941u, 1086952230u, 1086952230u, 0, LOG10_TOLERANCE, 0},
{529, 1133410485u, 1075649217u, 1075649217u, 0, LOG10_TOLERANCE, 0},
{530, 1222486939u, 1085605492u, 1085605492u, 0, LOG10_TOLERANCE, 0},
{531, 1270451568u, 1089231340u, 1089231340u, 0, LOG10_TOLERANCE, 0},
{532, 1280215674u, 1089960246u, 1089960246u, 0, LOG10_TOLERANCE, 0},
{533, 1171873518u, 1081469205u, 1081469205u, 0, LOG10_TOLERANCE, 0},
{534, 1150774452u, 1078285457u, 1078285457u, 0, LOG10_TOLERANCE, 0},
{535, 1267725176u, 1089000125u, 1089000125u, 0, LOG10_TOLERANCE, 0},
{536, 1209845200u, 1084658696u, 1084658696u, 0, LOG10_TOLERANCE, 0},
{537, 1120384488u, 1073736548u, 1073736548u, 0, LOG10_TOLERANCE, 0},
{538, 1171564509u, 1081429258u, 1081429258u, 0, LOG10_TOLERANCE, 0},
{539, 1144755661u, 1077412924u, 1077412924u, 0, LOG10_TOLERANCE, 0},
{540, 1153978024u, 1078795066u, 1078795066u, 0, LOG10_TOLERANCE, 0},
{541, 1217042030u, 1085177708u, 1085177708u, 0, LOG10_TOLERANCE, 0},
{542, 1319638151u, 1091724070u, 1091724070u, 0, LOG10_TOLERANCE, 0},
{543, 1151257041u, 1078371952u, 1078371952u, 0, LOG10_TOLERANCE, 0},
{544, 1258369714u, 1088270339u, 1088270339u, 0, LOG10_TOLERANCE, 0},
{545, 1216602683u, 1085132549u, 1085132549u, 0, LOG10_TOLERANCE, 0},
{546, 1149782091u, 1078093539u, 1078093539u, 0, LOG10_TOLERANCE, 0},
{547, 1071940738u, 1048633368u, 1048633368u, 0, LOG10_TOLERANCE, 0},
{548, 1314801987u, 1091535710u, 1091535710u, 0, LOG10_TOLERANCE, 0},
{549, 1209694157u, 1084645208u, 1084645208u, 0, LOG10_TOLERANCE, 0},
{550, 1153863660u, 1078779127u, 1078779127u, 0, LOG10_TOLERANCE, 0},
{551, 1249365132u, 1087600894u, 1087600894u, 0, LOG10_TOLERANCE, 0},
{552, 1074612637u, 1051727564u, 1051727564u, 0, LOG10_TOLERANCE, 0},
{553, 1297708818u, 1090894419u, 1090894419u, 0, LOG10_TOLERANCE, 0},
{554, 1198049074u, 1083756107u, 1083756107u, 0, LOG10_TOLERANCE, 0},
{555, 1271269588u, 1089290635u, 1089290635u, 0, LOG10_TOLERANCE, 0},
{556, 1277417964u, 1089749364u, 1089749364u, 0, LOG10_TOLERANCE, 0},
{557, 1173439580u, 1081659193u, 1081659193u, 0, LOG10_TOLERANCE, 0},
{558, 1337400405u, 1092394380u, 1092394380u, 0, LOG10_TOLERANCE, 0},
{559, 1252864992u, 1087905998u, 1087905998u, 0, LOG10_TOLERANCE, 0},
{560, 1250249095u, 1087667413u, 1087667413u, 0, LOG10_TOLERANCE, 0},
{561, 1136927585u, 1076231530u, 1076231530u, 0, LOG10_TOLERANCE, 0},
{562, 1215968622u, 1085084485u, 1085084485u, 0, LOG10_TOLERANCE, 0},
{563, 1215264594u, 1085044517u, 1085044517u, 0, LOG10_TOLERANCE, 0},
{564, 1252237719u, 1087854223u, 1087854223u, 0, LOG10_TOLERANCE, 0},
{565, 1180411946u, 1082440653u, 1082440653u, 0, LOG10_TOLERANCE, 0},
{566, 1248677856u, 1087561510u, 1087561510u, 0, LOG10_TOLERANCE, 0},
{567, 1099710167u, 1067398349u, 1067398349u, 0, LOG10_TOLERANCE, 0},
{568, 1157186482u, 1079193372u, 1079193372u, 0, LOG10_TOLERANCE, 0},
{569, 1282110851u, 1090079593u, 1090079593u, 0, LOG10_TOLERANCE, 0},
{570, 1329524465u, 1092097778u, 1092097778u, 0, LOG10_TOLERANCE, 0},
{571, 1144643646u, 1077396251u, 1077396251u, 0, LOG10_TOLERANCE, 0},
{572, 1123357102u, 1074112007u, 1074112007u, 0, LOG10_TOLERANCE, 0},
{573, 1106837025u, 1069489610u, 1069489610u, 0, LOG10_TOLERANCE, 0},
{574, 1253017688u, 1087918168u, 1087918168u, 0, LOG10_TOLERANCE, 0},
{575, 1108543194u, 1070095602u, 1070095602u, 0, LOG10_TOLERANCE, 0},
{576, 1160162706u, 1079722894u, 1079722894u, 0, LOG10_TOLERANCE, 0},
{577, 1158231377u, 1079368484u, 1079368484u, 0, LOG10_TOLERANCE, 0},
{578, 1266928623u, 1088919782u, 1088919782u, 0, LOG10_TOLERANCE, 0},
{579, 1290596379u, 1090617821u, 1090617821u, 0, LOG10_TOLERANCE, 0},
{580, 1197091103u, 1083697039u, 1083697039u, 0, LOG10_TOLERANCE, 0},
{581, 1152416724u, 1078564412u, 1078564412u, 0, LOG10_TOLERANCE, 0},
{582, 1218239308u, 1085290489u, 1085290489u, 0, LOG10_TOLERANCE, 0},
{583, 1115826919u, 1072177121u, 1072177121u, 0, LOG10_TOLERANCE, 0},
{584, 1142780964u, 1077093965u, 1077093965u, 0, LOG10_TOLERANCE, 0},
{585, 1074622936u, 1051743763u, 1051743763u, 0, LOG10_TOLERANCE, 0},
{586, 1278946388u, 1089870566u, 1089870566u, 0, LOG10_TOLERANCE, 0},
{587, 1098530298u, 1066982623u, 1066982623u, 0, LOG10_TOLERANCE, 0},
{588, 1085242388u, 1060975860u, 1060975860u, 0, LOG10_TOLERANCE, 0},
{589, 1297190916u, 1090877562u, 1090877562u, 0, LOG10_TOLERANCE, 0},
{590, 1277649137u, 1089768763u, 1089768763u, 0, LOG10_TOLERANCE, 0},
{591, 1096548368u, 1066513387u, 1066513387u, 0, LOG10_TOLERANCE, 0},
{592, 1096155623u, 1066412772u, 1066412772u, 0, LOG10_TOLERANCE, 0},
{593, 1091245957u, 1064332856u, 1064332856u, 0, LOG10_TOLERANCE, 0},
{594, 1169713169u, 1081169627u, 1081169627u, 0, LOG10_TOLERANCE, 0},
{595, 1227264862u, 1085976549u, 1085976549u, 0, LOG10_TOLERANCE, 0},
{596, 1198151302u, 1083762190u, 1083762190u, 0, LOG10_TOLERANCE, 0},
{597, 1249433635u, 1087604728u, 1087604728u, 0, LOG10_TOLERANCE, 0},
{598, 1169549089u, 1081144726u, 1081144726u, 0, LOG10_TOLERANCE, 0},
{599, 1200051436u, 1083893444u, 1083893444u, 0, LOG10_TOLERANCE, 0},
{600, 1306520561u, 1091223396u, 1091223396u, 0, LOG10_TOLERANCE, 0},
{601, 1314936356u, 1091539891u, 1091539891u, 0, LOG10_TOLERANCE, 0},
{602, 1327568571u, 1092020376u, 1092020376u, 0, LOG10_TOLERANCE, 0},
{603, 1245744060u, 1087371119u, 1087371119u, 0, LOG10_TOLERANCE, 0},
{604, 1201521756u, 1084033149u, 1084033149u, 0, LOG10_TOLERANCE, 0},
{605, 1262863321u, 1088658089u, 1088658089u, 0, LOG10_TOLERANCE, 0},
{606, 1240170043u, 1086923196u, 1086923196u, 0, LOG10_TOLERANCE, 0},
{607, 1338680611u, 1092440541u, 1092440541u, 0, LOG10_TOLERANCE, 0},
{608, 1112891928u, 1071452574u, 1071452574u, 0, LOG10_TOLERANCE, 0},
{609, 1190105283u, 1083150978u, 1083150978u, 0, LOG10_TOLERANCE, 0},
{610, 1263047389u, 1088670933u, 1088670933u, 0, LOG10_TOLERANCE, 0},
{611, 1066141167u, 1025487856u, 1025487856u, 0, LOG10_TOLERANCE, 0},
{612, 1120888322u, 1073807991u, 1073807991u, 0, LOG10_TOLERANCE, 0},
{613, 1315217243u, 1091548510u, 1091548510u, 0, LOG10_TOLERANCE, 0},
{614, 1168623062u, 1080997431u, 1080997431u, 0, LOG10_TOLERANCE, 0},
{615, 1311186097u, 1091405787u, 1091405787u, 0, LOG10_TOLERANCE, 0},
{616, 1180032668u, 1082416335u, 1082416335u, 0, LOG10_TOLERANCE, 0},
{617, 1134528351u, 1075855204u, 1075855204u, 0, LOG10_TOLERANCE, 0},
{618, 1266869190u, 1088913493u, 1088913493u, 0, LOG10_TOLERANCE, 0},
{619, 1133689539u, 1075702861u, 1075702861u, 0, LOG10_TOLERANCE, 0},
{620, 1308204830u, 1091272874u, 1091272874u, 0, LOG10_TOLERANCE, 0},
{621, 1137634874u, 1076329100u, 1076329100u, 0, LOG10_TOLERANCE, 0},
{622, 1268019014u, 1089028060u, 1089028060u, 0, LOG10_TOLERANCE, 0},
{623, 1066157309u, 1025692741u, 1025692741u, 0, LOG10_TOLERANCE, 0},
{624, 1288870027u, 1090564150u, 1090564150u, 0, LOG10_TOLERANCE, 0},
{625, 1125177888u, 1074416791u, 1074416791u, 0, LOG10_TOLERANCE, 0},
{626, 1170245333u, 1081248122u, 1081248122u, 0, LOG10_TOLERANCE, 0},
{627, 1219052056u, 1085359794u, 1085359794u, 0, LOG10_TOLERANCE, 0},
{628, 1171499971u, 1081420803u, 1081420803u, 0, LOG10_TOLERANCE, 0},
{629, 1224634973u, 1085731089u, 1085731089u, 0, LOG10_TOLERANCE, 0},
{630, 1299683827u, 1090953521u, 1090953521u, 0, LOG10_TOLERANCE, 0},
{631, 1109740374u, 1070522258u, 1070522258u, 0, LOG10_TOLERANCE, 0},
{632, 1229268598u, 1086130031u, 1086130031u, 0, LOG10_TOLERANCE, 0},
{633, 1086717248u, 1061855026u, 1061855026u, 0, LOG10_TOLERANCE, 0},
{634, 1287400959u, 1090506756u, 1090506756u, 0, LOG10_TOLERANCE, 0},
{635, 1317471958u, 1091624354u, 1091624354u, 0, LOG10_TOLERANCE, 0},
{636, 1242829722u, 1087131943u, 1087131943u, 0, LOG10_TOLERANCE, 0},
{637, 1200927971u, 1083979282u, 1083979282u, 0, LOG10_TOLERANCE, 0},
{638, 1179374444u, 1082372526u, 1082372526u, 0, LOG10_TOLERANCE, 0},
{639, 1246019790u, 1087390806u, 1087390806u, 0, LOG10_TOLERANCE, 0},
{640, 1136052740u, 1076103135u, 1076103135u, 0, LOG10_TOLERANCE, 0},
{641, 1069009211u, 1042341759u, 1042341759u, 0, LOG10_TOLERANCE, 0},
{642, 1169128344u, 1081079274u, 1081079274u, 0, LOG10_TOLERANCE, 0},
{643, 1087942795u, 1062512634u, 1062512634u, 0, LOG10_TOLERANCE, 0},
{644, 1278882065u, 1089865777u, 1089865777u, 0, LOG10_TOLERANCE, 0},
{645, 1147842784u, 1077821021u, 1077821021u, 0, LOG10_TOLERANCE, 0},
{646, 1171351660u, 1081401223u, 1081401223u, 0, LOG10_TOLERANCE, 0},
{647, 1136072069u, 1076106072u, 1076106072u, 0, LOG10_TOLERANCE, 0},
{648, 1233771772u, 1086435546u, 1086435546u, 0, LOG10_TOLERANCE, 0},
{649, 1241288445u, 1086986916u, 1086986916u, 0, LOG10_TOLERANCE, 0},
{650, 1319200415u, 1091705604u, 1091705604u, 0, LOG10_TOLERANCE, 0},
{651, 1279324488u, 1089898216u, 1089898216u, 0, LOG10_TOLERANCE, 0},
{652, 1070311776u, 1045334590u, 1045334590u, 0, LOG10_TOLERANCE, 0},
{653, 1307648109u, 1091257107u, 1091257107u, 0, LOG10_TOLERANCE, 0},
{654, 1246947517u, 1087454084u, 1087454084u, 0, LOG10_TOLERANCE, 0},
{655, 1249239929u, 1087593845u, 1087593845u, 0, LOG10_TOLERANCE, 0},
{656, 1286277377u, 1090419751u, 1090419751u, 0, LOG10_TOLERANCE, 0},
{657, 1173247961u, 1081636983u, 1081636983u, 0, LOG10_TOLERANCE, 0},
{658, 1101051030u, 1067894465u, 1067894465u, 0, LOG10_TOLERANCE, 0},
{659, 1082862511u, 1059286536u, 1059286536u, 0, LOG10_TOLERANCE, 0},
{660, 1341821683u, 1092537219u, 1092537219u, 0, LOG10_TOLERANCE, 0},
{661, 1079061705u, 1057205020u, 1057205020u, 0, LOG10_TOLERANCE, 0},
{662, 1105291533u, 1069127115u, 1069127115u, 0, LOG10_TOLERANCE, 0},
{663, 1223207358u, 1085649573u, 1085649573u, 0, LOG10_TOLERANCE, 0},
{664, 1156767169u, 1079146005u, 1079146005u, 0, LOG10_TOLERANCE, 0},
{665, 1104284039u, 1068869773u, 1068869773u, 0, LOG10_TOLERANCE, 0},
{666, 1187729253u, 1083001524u, 1083001524u, 0, LOG10_TOLERANCE, 0},
{667, 1093697541u, 1065710780u, 1065710780u, 0, LOG10_TOLERANCE, 0},
{668, 1119207537u, 1073393265u, 1073393265u, 0, LOG10_TOLERANCE, 0},
{669, 1094115255u, 1065840021u, 1065840021u, 0, LOG10_TOLERANCE, 0},
{670, 1276603160u, 1089677491u, 1089677491u, 0, LOG10_TOLERANCE, 0},
{671, 1206125125u, 1084368558u, 1084368558u, 0, LOG10_TOLERANCE, 0},
{672, 1098662266u, 1067011821u, 1067011821u, 0, LOG10_TOLERANCE, 0},
{673, 1328600211u, 1092062834u, 1092062834u, 0, LOG10_TOLERANCE, 0},
{674, 1317062968u, 1091602805u, 1091602805u, 0, LOG10_TOLERANCE, 0},
{675, 1296068481u, 1090838735u, 1090838735u, 0, LOG10_TOLERANCE, 0},
{676, 1287620154u, 1090520921u, 1090520921u, 0, LOG10_TOLERANCE, 0},
{677, 1245702957u, 1087368147u, 1087368147u, 0, LOG10_TOLERANCE, 0},
{678, 1268279353u, 1089052114u, 1089052114u, 0, LOG10_TOLERANCE, 0},
{679, 1135988313u, 1076093312u, 1076093312u, 0, LOG10_TOLERANCE, 0},
{680, 1163727179u, 1080237312u, 1080237312u, 0, LOG10_TOLERANCE, 0},
{681, 1198307901u, 1083771430u, 1083771430u, 0, LOG10_TOLERANCE, 0},
{682, 1288901567u, 1090565189u, 1090565189u, 0, LOG10_TOLERANCE, 0},
{683, 1113104661u, 1071507577u, 1071507577u, 0, LOG10_TOLERANCE, 0},
{684, 1136714348u, 1076201059u, 1076201059u, 0, LOG10_TOLERANCE, 0},
{685, 1339423444u, 1092465326u, 1092465326u, 0, LOG10_TOLERANCE, 0},
{686, 1162027071u, 1080009939u, 1080009939u, 0, LOG10_TOLERANCE, 0},
{687, 1124131769u, 1074204110u, 1074204110u, 0, LOG10_TOLERANCE, 0},
{688, 1177157787u, 1082207261u, 1082207261u, 0, LOG10_TOLERANCE, 0},
{689, 1284600904u, 1090272197u, 1090272197u, 0, LOG10_TOLERANCE, 0},
{690, 1309658335u, 1091337369u, 1091337369u, 0, LOG10_TOLERANCE, 0},
{691, 1226494979u, 1085909940u, 1085909940u, 0, LOG10_TOLERANCE, 0},
{692, 1228023365u, 1086037729u, 1086037729u, 0, LOG10_TOLERANCE, 0},
{693, 1313215353u, 1091483197u, 1091483197u, 0, LOG10_TOLERANCE, 0},
{694, 1320539530u, 1091759888u, 1091759888u, 0, LOG10_TOLERANCE, 0},
{695, 1204196034u, 1084242664u, 1084242664u, 0, LOG10_TOLERANCE, 0},
{696, 1312393763u, 1091453422u, 1091453422u, 0, LOG10_TOLERANCE, 0},
{697, 1161439847u, 1079924310u, 1079924310u, 0, LOG10_TOLERANCE, 0},
{698, 1084378658u, 1060406999u, 1060406999u, 0, LOG10_TOLERANCE, 0},
{699, 1226473697u, 1085908028u, 1085908028u, 0, LOG10_TOLERANCE, 0},
{700, 1123114742u, 1074084310u, 1074084310u, 0, LOG10_TOLERANCE, 0},
{701, 1258114435u, 1088252207u, 1088252207u, 0, LOG10_TOLERANCE, 0},
{702, 1320557197u, 1091760563u, 1091760563u, 0, LOG10_TOLERANCE, 0},
{703, 1178825761u, 1082334325u, 1082334325u, 0, LOG10_TOLERANCE, 0},
{704, 1075900364u, 1053625108u, 1053625108u, 0, LOG10_TOLERANCE, 0},
{705, 1297778779u, 1090896649u, 1090896649u, 0, LOG10_TOLERANCE, 0},
{706, 1125653081u, 1074505764u, 1074505764u, 0, LOG10_TOLERANCE, 0},
{707, 1190169064u, 1083154670u, 1083154670u, 0, LOG10_TOLERANCE, 0},
{708, 1184753508u, 1082771327u, 1082771327u, 0, LOG10_TOLERANCE, 0},
{709, 1188439315u, 1083048812u, 1083048812u, 0, LOG10_TOLERANCE, 0},
{710, 1314151417u, 1091514905u, 1091514905u, 0, LOG10_TOLERANCE, 0},
{711, 1188167943u, 1083031028u, 1083031028u, 0, LOG10_TOLERANCE, 0},
{712, 1142595790u, 1077060980u, 1077060980u, 0, LOG10_TOLERANCE, 0},
{713, 1203206679u, 1084170649u, 1084170649u, 0, LOG10_TOLERANCE, 0},
{714, 1102061604u, 1068228263u, 1068228263u, 0, LOG10_TOLERANCE, 0},
{715, 1282351521u, 1090093688u, 1090093688u, 0, LOG10_TOLERANCE, 0},
{716, 1311377417u, 1091413674u, 1091413674u, 0, LOG10_TOLERANCE, 0},
{717, 1081309682u, 1058311429u, 1058311429u, 0, LOG10_TOLERANCE, 0},
{718, 1274711085u, 1089504858u, 1089504858u, 0, LOG10_TOLERANCE, 0},
{719, 1261940623u, 1088590825u, 1088590825u, 0, LOG10_TOLERANCE, 0},
{720, 1253119433u, 1087926188u, 1087926188u, 0, LOG10_TOLERANCE, 0},
{721, 1219411812u, 1085388863u, 1085388863u, 0, LOG10_TOLERANCE, 0},
{722, 1149882378u, 1078113879u, 1078113879u, 0, LOG10_TOLERANCE, 0},
{723, 1218488455u, 1085312301u, 1085312301u, 0, LOG10_TOLERANCE, 0},
{724, 1283938137u, 1090206564u, 1090206564u, 0, LOG10_TOLERANCE, 0},
{725, 1317098613u, 1091604724u, 1091604724u, 0, LOG10_TOLERANCE, 0},
{726, 1284220009u, 1090235058u, 1090235058u, 0, LOG10_TOLERANCE, 0},
{727, 1092245127u, 1065090701u, 1065090701u, 0, LOG10_TOLERANCE, 0},
{728, 1165676440u, 1080467250u, 1080467250u, 0, LOG10_TOLERANCE, 0},
{729, 1284174954u, 1090230563u, 1090230563u, 0, LOG10_TOLERANCE, 0},
{730, 1102631663u, 1068403887u, 1068403887u, 0, LOG10_TOLERANCE, 0},
{731, 1125596740u, 1074495439u, 1074495439u, 0, LOG10_TOLERANCE, 0},
{732, 1172529774u, 1081551244u, 1081551244u, 0, LOG10_TOLERANCE, 0},
{733, 1306695905u, 1091228805u, 1091228805u, 0, LOG10_TOLERANCE, 0},
{734, 1078478376u, 1056811758u, 1056811758u, 0, LOG10_TOLERANCE, 0},
{735, 1165177679u, 1080411121u, 1080411121u, 0, LOG10_TOLERANCE, 0},
{736, 1255525865u, 1088097808u, 1088097808u, 0, LOG10_TOLERANCE, 0},
{737, 1222777442u, 1085623525u, 1085623525u, 0, LOG10_TOLERANCE, 0},
{738, 1325324763u, 1091913621u, 1091913621u, 0, LOG10_TOLERANCE, 0},
{739, 1216040565u, 1085088472u, 1085088472u, 0, LOG10_TOLERANCE, 0},
{740, 1158950321u, 1079508594u, 1079508594u, 0, LOG10_TOLERANCE, 0},
{741, 1208345407u, 1084514979u, 1084514979u, 0, LOG10_TOLERANCE, 0},
{742, 1258634105u, 1088298344u, 1088298344u, 0, LOG10_TOLERANCE, 0},
{743, 1248478509u, 1087549760u, 1087549760u, 0, LOG10_TOLERANCE, 0},
{744, 1153863988u, 1078779173u, 1078779173u, 0, LOG10_TOLERANCE, 0},
{745, 1235620969u, 1086605139u, 1086605139u, 0, LOG10_TOLERANCE, 0},
{746, 1097120930u, 1066655263u, 1066655263u, 0, LOG10_TOLERANCE, 0},
{747, 1322294974u, 1091822468u, 1091822468u, 0, LOG10_TOLERANCE, 0},
{748, 1147712200u, 1077805489u, 1077805489u, 0, LOG10_TOLERANCE, 0},
{749, 1124721745u, 1074327092u, 1074327092u, 0, LOG10_TOLERANCE, 0},
{750, 1114260656u, 1071792761u, 1071792761u, 0, LOG10_TOLERANCE, 0},
{751, 1155676504u, 1079016701u, 1079016701u, 0, LOG10_TOLERANCE, 0},
{752, 1315090496u, 1091544641u, 1091544641u, 0, LOG10_TOLERANCE, 0},
{753, 1082919539u, 1059331952u, 1059331952u, 0, LOG10_TOLERANCE, 0},
{754, 1335399673u, 1092311322u, 1092311322u, 0, LOG10_TOLERANCE, 0},
{755, 1072458508u, 1049128670u, 1049128670u, 0, LOG10_TOLERANCE, 0},
{756, 1155531601u, 1078998810u, 1078998810u, 0, LOG10_TOLERANCE, 0},
{757, 1104656093u, 1068966936u, 1068966936u, 0, LOG10_TOLERANCE, 0},
{758, 1321036318u, 1091778488u, 1091778488u, 0, LOG10_TOLERANCE, 0},
{759, 1172239631u, 1081515428u, 1081515428u, 0, LOG10_TOLERANCE, 0},
{760, 1107620519u, 1069728893u, 1069728893u, 0, LOG10_TOLERANCE, 0},
{761, 1155477903u, 1078992135u, 1078992135u, 0, LOG10_TOLERANCE, 0},
{762, 1126405528u, 1074638322u, 1074638322u, 0, LOG10_TOLERANCE, 0},
{763, 1090330020u, 1063644779u, 1063644779u, 0, LOG10_TOLERANCE, 0},
{764, 1228207362u, 1086051971u, 1086051971u, 0, LOG10_TOLERANCE, 0},
{765, 1290175785u, 1090605316u, 1090605316u, 0, LOG10_TOLERANCE, 0},
{766, 1214223128u, 1084981977u, 1084981977u, 0, LOG10_TOLERANCE, 0},
{767, 1275438936u, 1089563831u, 1089563831u, 0, LOG10_TOLERANCE, 0},
{768, 1315857601u, 1091567568u, 1091567568u, 0, LOG10_TOLERANCE, 0},
{769, 1305742382u, 1091198584u, 1091198584u, 0, LOG10_TOLERANCE, 0},
{770, 1078359574u, 1056679255u, 1056679255u, 0, LOG10_TOLERANCE, 0},
{771, 1207675424u, 1084458464u, 1084458464u, 0, LOG10_TOLERANCE, 0},
{772, 1248421894u, 1087546395u, 1087546395u, 0, LOG10_TOLERANCE, 0},
{773, 1205768346u, 1084346548u, 1084346548u, 0, LOG10_TOLERANCE, 0},
{774, 1076752219u, 1054756961u, 1054756961u, 0, LOG10_TOLERANCE, 0},
{775, 1241048294u, 1086973604u, 1086973604u, 0, LOG10_TOLERANCE, 0},
{776, 1273395082u, 1089428770u, 1089428770u, 0, LOG10_TOLERANCE, 0},
{777, 1238104535u, 1086792336u, 1086792336u, 0, LOG10_TOLERANCE, 0},
{778, 1294321000u, 1090770812u, 1090770812u, 0, LOG10_TOLERANCE, 0},
{779, 1245343769u, 1087341758u, 1087341758u, 0, LOG10_TOLERANCE, 0},
{780, 1161241793u, 1079894497u, 1079894497u, 0, LOG10_TOLERANCE, 0},
{781, 1171318485u, 1081396814u, 1081396814u, 0, LOG10_TOLERANCE, 0},
{782, 1243968857u, 1087233031u, 1087233031u, 0, LOG10_TOLERANCE, 0},
{783, 1102119721u, 1068246561u, 1068246561u, 0, LOG10_TOLERANCE, 0},
{784, 1220264047u, 1085454237u, 1085454237u, 0, LOG10_TOLERANCE, 0},
{785, 1134728775u, 1075889794u, 1075889794u, 0, LOG10_TOLERANCE, 0},
{786, 1204809672u, 1084284629u, 1084284629u, 0, LOG10_TOLERANCE, 0},
{787, 1148874793u, 1077939317u, 1077939317u, 0, LOG10_TOLERANCE, 0},
{788, 1197828352u, 1083742833u, 1083742833u, 0, LOG10_TOLERANCE, 0},
{789, 1193026723u, 1083392420u, 1083392420u, 0, LOG10_TOLERANCE, 0},
{790, 1127109339u, 1074754146u, 1074754146u, 0, LOG10_TOLERANCE, 0},
{791, 1200599955u, 1083948099u, 1083948099u, 0, LOG10_TOLERANCE, 0},
{792, 1089700228u, 1063362759u, 1063362759u, 0, LOG10_TOLERANCE, 0},
{793, 1333109014u, 1092212490u, 1092212490u, 0, LOG10_TOLERANCE, 0},
{794, 1155775526u, 1079028827u, 1079028827u, 0, LOG10_TOLERANCE, 0},
{795, 1234491880u, 1086505389u, 1086505389u, 0, LOG10_TOLERANCE, 0}

// AUTOMATICALLY GENERATED VECTORS STOP

};

#endif // CYGONCE_LIBM_LOG10_H multiple inclusion protection

// EOF log10.h
