#ifndef CYGONCE_LIBM_LOG10_H
#define CYGONCE_LIBM_LOG10_H
//===========================================================================
//
//      log10.h
//
//      Test vectors for testing of log10() math library function
//
//===========================================================================
//####ECOSGPLCOPYRIGHTBEGIN####
// -------------------------------------------
// This file is part of eCos, the Embedded Configurable Operating System.
// Copyright (C) 1998, 1999, 2000, 2001, 2002 Free Software Foundation, Inc.
//
// eCos is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 or (at your option) any later
// version.
//
// eCos is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
// for more details.
//
// You should have received a copy of the GNU General Public License
// along with eCos; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//
// As a special exception, if other files instantiate templates or use
// macros or inline functions from this file, or you compile this file
// and link it with other works to produce a work based on this file,
// this file does not by itself cause the resulting work to be covered by
// the GNU General Public License. However the source code for this file
// must still be made available in accordance with section (3) of the GNU
// General Public License v2.
//
// This exception does not invalidate any other reasons why a work based
// on this file might be covered by the GNU General Public License.
// -------------------------------------------
//####ECOSGPLCOPYRIGHTEND####
//===========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):   jlarmour
// Contributors:  jlarmour
// Date:        1998-02-13
// Purpose:
// Description:
// Usage:       #include "vectors/log10.h"
//
//####DESCRIPTIONEND####
//
//===========================================================================


// CONFIGURATION

#include <pkgconf/libm.h>   // Configuration header


// INCLUDES

#include <cyg/infra/cyg_type.h>    // Common type definitions and support
#include "vectors/vector_support.h"// extra support for math tests

#define LOG10_TOLERANCE 1.0E-04

static const Cyg_libm_test_double_vec_t log10_vec[] = {

// AUTOMATICALLY GENERATED VECTORS START

{ 1, 1077999148u, 2506787616u, 1090024059u, 3619148316u, 1073249514u, 3022418765u, 0, LOG10_TOLERANCE, 0},
{ 2, 1070670006u, 3176730980u, 1051524793u, 2993920299u, 3219280318u, 3521941528u, 0, LOG10_TOLERANCE, 0},
{ 3, 1092176155u, 2725707538u, 3232101343u, 2346810316u, 1075214363u, 2619608406u, 0, LOG10_TOLERANCE, 0},
{ 4, 1092554362u, 2088062470u, 3201242716u, 420891118u, 1075237767u, 4016913123u, 0, LOG10_TOLERANCE, 0},
{ 5, 1073717029u, 2636405208u, 1100049309u, 471635570u, 1070788466u, 3705390542u, 0, LOG10_TOLERANCE, 0},
{ 6, 1089363191u, 1746012320u, 1054478713u, 3333988501u, 1074998457u, 2601017037u, 0, LOG10_TOLERANCE, 0},
{ 7, 1047953160u, 183014794u, 3202039382u, 2016785810u, 3223080594u, 1773764437u, 0, LOG10_TOLERANCE, 0},
{ 8, 1066002386u, 2688957927u, 1046089230u, 2709029994u, 3221118451u, 837113105u, 0, LOG10_TOLERANCE, 0},
{ 9, 1058795730u, 624574473u, 1045840574u, 3473266330u, 3222259526u, 2374389383u, 0, LOG10_TOLERANCE, 0},
{ 10, 1057436194u, 1605286142u, 1068931671u, 4233776869u, 3222366888u, 3800128756u, 0, LOG10_TOLERANCE, 0},
{ 11, 1060343410u, 1857607719u, 3222889559u, 3417070006u, 3222025110u, 4113556665u, 0, LOG10_TOLERANCE, 0},
{ 12, 1103599987u, 3981151660u, 1088899021u, 1332651746u, 1075956764u, 108599875u, 0, LOG10_TOLERANCE, 0},
{ 13, 1085298022u, 3824988054u, 1066856791u, 2070129652u, 1074591863u, 2678403996u, 0, LOG10_TOLERANCE, 0},
{ 14, 1060076142u, 1372884064u, 1080833116u, 3229926662u, 3222074556u, 443298410u, 0, LOG10_TOLERANCE, 0},
{ 15, 1093826501u, 3217805330u, 3191644264u, 2014578707u, 1075336418u, 3557865346u, 0, LOG10_TOLERANCE, 0},
{ 16, 1102287487u, 265058758u, 3239903247u, 1630600647u, 1075906656u, 1833826044u, 0, LOG10_TOLERANCE, 0},
{ 17, 1071124229u, 1946677669u, 3198462609u, 926009897u, 3218813362u, 1296639386u, 0, LOG10_TOLERANCE, 0},
{ 18, 1072130299u, 2271884183u, 3203741999u, 2118617783u, 3217121319u, 3419458770u, 0, LOG10_TOLERANCE, 0},
{ 19, 1047365461u, 213658772u, 3249401130u, 314151656u, 3223128539u, 2168223691u, 0, LOG10_TOLERANCE, 0},
{ 20, 1106628640u, 1564829925u, 3197817016u, 497230814u, 1076070652u, 4249090498u, 0, LOG10_TOLERANCE, 0},
{ 21, 1068778986u, 2075329122u, 3231746400u, 169900577u, 3220283137u, 1319601517u, 0, LOG10_TOLERANCE, 0},
{ 22, 1049848642u, 541549344u, 1096608669u, 3119070100u, 3222939514u, 2468510095u, 0, LOG10_TOLERANCE, 0},
{ 23, 1085427055u, 567496114u, 1045286891u, 1969998540u, 1074617778u, 384099018u, 0, LOG10_TOLERANCE, 0},
{ 24, 1060548195u, 1299369769u, 1049342524u, 4167404066u, 3221991359u, 737986283u, 0, LOG10_TOLERANCE, 0},
{ 25, 1061381997u, 3348930841u, 1078472138u, 358457347u, 3221869066u, 249937911u, 0, LOG10_TOLERANCE, 0},
{ 26, 1071069297u, 2192461366u, 1099527247u, 3184735642u, 3218877956u, 3100951136u, 0, LOG10_TOLERANCE, 0},
{ 27, 1052861772u, 331696577u, 3189610016u, 793242270u, 3222715301u, 1774046932u, 0, LOG10_TOLERANCE, 0},
{ 28, 1105045286u, 2322696981u, 1083791358u, 3020766674u, 1076009218u, 2332151086u, 0, LOG10_TOLERANCE, 0},
{ 29, 1044902177u, 252085215u, 3214426435u, 4139068910u, 3223310243u, 930081556u, 0, LOG10_TOLERANCE, 0},
{ 30, 1075022077u, 105589263u, 1056316170u, 261630827u, 1072040521u, 3389720896u, 0, LOG10_TOLERANCE, 0},
{ 31, 1107213408u, 428765703u, 3251828686u, 2009972239u, 1076090173u, 2232985963u, 0, LOG10_TOLERANCE, 0},
{ 32, 1098568019u, 3517376586u, 3240257920u, 3304487302u, 1075694540u, 919239854u, 0, LOG10_TOLERANCE, 0},
{ 33, 1086054264u, 237004814u, 3237899261u, 3364008659u, 1074713551u, 803164225u, 0, LOG10_TOLERANCE, 0},
{ 34, 1047763904u, 472004928u, 3226869477u, 1186387580u, 3223096235u, 3622735061u, 0, LOG10_TOLERANCE, 0},
{ 35, 1054226850u, 4085763910u, 1106394906u, 2684738273u, 3222608495u, 1452762068u, 0, LOG10_TOLERANCE, 0},
{ 36, 1057053639u, 2055490142u, 3231581370u, 3879040079u, 3222399892u, 728588179u, 0, LOG10_TOLERANCE, 0},
{ 37, 1041492999u, 3725731239u, 1061652681u, 591292963u, 3223445266u, 1587892700u, 0, LOG10_TOLERANCE, 0},
{ 38, 1077531333u, 1147041027u, 3215417793u, 624695933u, 1073125274u, 89100982u, 0, LOG10_TOLERANCE, 0},
{ 39, 1058569126u, 705725219u, 3238067573u, 1116238321u, 3222281827u, 770742446u, 0, LOG10_TOLERANCE, 0},
{ 40, 1059883440u, 7287411u, 1045917232u, 116067742u, 3222096885u, 913481370u, 0, LOG10_TOLERANCE, 0},
{ 41, 1092571574u, 3604989074u, 1066381836u, 545298780u, 1075238726u, 2904656021u, 0, LOG10_TOLERANCE, 0},
{ 42, 1071597288u, 1681476121u, 1060345752u, 3553822398u, 3218335408u, 1174560309u, 0, LOG10_TOLERANCE, 0},
{ 43, 1102831658u, 3410480388u, 1052460275u, 1660607230u, 1075926787u, 102598250u, 0, LOG10_TOLERANCE, 0},
{ 44, 1089216869u, 1494984673u, 3196647153u, 287894723u, 1074989762u, 1122846966u, 0, LOG10_TOLERANCE, 0},
{ 45, 1054885127u, 644548665u, 1081948134u, 2442134629u, 3222565093u, 3817391420u, 0, LOG10_TOLERANCE, 0},
{ 46, 1087554095u, 2312530895u, 3221584595u, 3379665576u, 1074864717u, 2346974421u, 0, LOG10_TOLERANCE, 0},
{ 47, 1096085375u, 3018463866u, 1086226574u, 404012923u, 1075508523u, 2582069913u, 0, LOG10_TOLERANCE, 0},
{ 48, 1064733299u, 1710279345u, 3251401196u, 3528946000u, 3221361467u, 665183996u, 0, LOG10_TOLERANCE, 0},
{ 49, 1061536351u, 2164450219u, 1083520023u, 3312018966u, 3221842981u, 1511855102u, 0, LOG10_TOLERANCE, 0},
{ 50, 1057248676u, 2648986431u, 1050330591u, 1474376550u, 3222381877u, 571379592u, 0, LOG10_TOLERANCE, 0},
{ 51, 1046938380u, 1839068700u, 1077406406u, 3013052171u, 3223156927u, 1273004858u, 0, LOG10_TOLERANCE, 0},
{ 52, 1046493630u, 772102380u, 3220729740u, 4219039958u, 3223196708u, 1857276792u, 0, LOG10_TOLERANCE, 0},
{ 53, 1081988573u, 3058618779u, 1046304788u, 3338676024u, 1074097737u, 4237319426u, 0, LOG10_TOLERANCE, 0},
{ 54, 1051172137u, 506286854u, 1094907481u, 2217000199u, 3222838334u, 1971852126u, 0, LOG10_TOLERANCE, 0},
{ 55, 1082428310u, 1147428263u, 1065432625u, 3034786717u, 1074170619u, 220014801u, 0, LOG10_TOLERANCE, 0},
{ 56, 1082016752u, 2844125311u, 1082985198u, 2561492677u, 1074100996u, 107966054u, 0, LOG10_TOLERANCE, 0},
{ 57, 1064053268u, 704542600u, 3222902057u, 2762779203u, 3221468579u, 215530745u, 0, LOG10_TOLERANCE, 0},
{ 58, 1052196966u, 184131949u, 3249723525u, 1667366082u, 3222761181u, 3301049340u, 0, LOG10_TOLERANCE, 0},
{ 59, 1076125950u, 3904224140u, 1067056698u, 2942159914u, 1072701794u, 1892749236u, 0, LOG10_TOLERANCE, 0},
{ 60, 1100636863u, 426114282u, 3209056785u, 1083606355u, 1075844746u, 4158287464u, 0, LOG10_TOLERANCE, 0},
{ 61, 1106165945u, 3774123863u, 1106787580u, 2722107965u, 1076050748u, 1644090822u, 0, LOG10_TOLERANCE, 0},
{ 62, 1088005092u, 1377734762u, 1104232051u, 2377063483u, 1074900296u, 1620468150u, 0, LOG10_TOLERANCE, 0},
{ 63, 1069380559u, 1029739074u, 1105467109u, 3062201018u, 3220049220u, 1952021905u, 0, LOG10_TOLERANCE, 0},
{ 64, 1087257949u, 773857656u, 3214251949u, 335833884u, 1074840167u, 1626397392u, 0, LOG10_TOLERANCE, 0},
{ 65, 1055740962u, 1473865960u, 1103073830u, 4000427507u, 3222498007u, 2325532597u, 0, LOG10_TOLERANCE, 0},
{ 66, 1103185231u, 4242092620u, 1067009473u, 14539161u, 1075938991u, 4075535913u, 0, LOG10_TOLERANCE, 0},
{ 67, 1045032426u, 1732245037u, 1101371955u, 1533536108u, 3223301164u, 1695162079u, 0, LOG10_TOLERANCE, 0},
{ 68, 1101670347u, 1833841275u, 1099430098u, 4144145552u, 1075883704u, 2534133722u, 0, LOG10_TOLERANCE, 0},
{ 69, 1096786815u, 935007012u, 3188865420u, 604442938u, 1075555534u, 3856091931u, 0, LOG10_TOLERANCE, 0},
{ 70, 1059419605u, 2211464602u, 1046255144u, 1635910526u, 3222161784u, 2122038886u, 0, LOG10_TOLERANCE, 0},
{ 71, 1077871417u, 2549219008u, 3231633258u, 3733639385u, 1073208663u, 430860074u, 0, LOG10_TOLERANCE, 0},
{ 72, 1082095089u, 1819374372u, 3202219056u, 2617077637u, 1074109815u, 3246089147u, 0, LOG10_TOLERANCE, 0},
{ 73, 1094345280u, 546465680u, 1048653554u, 532401530u, 1075377030u, 1431910568u, 0, LOG10_TOLERANCE, 0},
{ 74, 1044571091u, 2759019783u, 3221570188u, 3554409630u, 3223329924u, 2544254508u, 0, LOG10_TOLERANCE, 0},
{ 75, 1065447634u, 2527221960u, 1099107978u, 2696971136u, 3221262049u, 1391120482u, 0, LOG10_TOLERANCE, 0},
{ 76, 1097158000u, 173134582u, 1087299442u, 2877794600u, 1075589414u, 4260456854u, 0, LOG10_TOLERANCE, 0},
{ 77, 1086400474u, 547642046u, 3197285510u, 3521286127u, 1074760870u, 3835447898u, 0, LOG10_TOLERANCE, 0},
{ 78, 1074860702u, 1231582831u, 1090971734u, 1653446832u, 1071917811u, 895223700u, 0, LOG10_TOLERANCE, 0},
{ 79, 1061342535u, 3762182190u, 3252967851u, 2615360375u, 3221876243u, 3440127565u, 0, LOG10_TOLERANCE, 0},
{ 80, 1053350775u, 2588067350u, 3206610957u, 3551059728u, 3222674665u, 3919675322u, 0, LOG10_TOLERANCE, 0},
{ 81, 1059495208u, 845263327u, 1073415902u, 1749010288u, 3222149862u, 1260690295u, 0, LOG10_TOLERANCE, 0},
{ 82, 1058092722u, 3092685191u, 3190678390u, 2872219490u, 3222321932u, 4078691992u, 0, LOG10_TOLERANCE, 0},
{ 83, 1070831407u, 4107255722u, 3205337291u, 3069068345u, 3219157958u, 2522023062u, 0, LOG10_TOLERANCE, 0},
{ 84, 1096507209u, 2294867524u, 3216653996u, 2860384670u, 1075539043u, 3909250401u, 0, LOG10_TOLERANCE, 0},
{ 85, 1045842702u, 2265437201u, 3240198679u, 1234948614u, 3223239452u, 4104182862u, 0, LOG10_TOLERANCE, 0},
{ 86, 1068876281u, 1186945904u, 3251167793u, 1896750851u, 3220250953u, 2361841191u, 0, LOG10_TOLERANCE, 0},
{ 87, 1081575478u, 3686084548u, 1079286273u, 3309277689u, 1074043698u, 3305889265u, 0, LOG10_TOLERANCE, 0},
{ 88, 1075992592u, 3006860614u, 3231412671u, 2504194724u, 1072614529u, 2742713680u, 0, LOG10_TOLERANCE, 0},
{ 89, 1088665612u, 1948717780u, 1048317852u, 3791803982u, 1074949315u, 1016144265u, 0, LOG10_TOLERANCE, 0},
{ 90, 1064345015u, 4272034420u, 3192982124u, 1526175922u, 3221430904u, 1575151155u, 0, LOG10_TOLERANCE, 0},
{ 91, 1098334178u, 4108948538u, 1104691287u, 640541190u, 1075678285u, 2376433274u, 0, LOG10_TOLERANCE, 0},
{ 92, 1059773769u, 3259274853u, 1082507103u, 3677038020u, 3222110644u, 2405648502u, 0, LOG10_TOLERANCE, 0},
{ 93, 1083132498u, 3781708548u, 1096584871u, 1207386447u, 1074266405u, 2767701991u, 0, LOG10_TOLERANCE, 0},
{ 94, 1041211624u, 3011191657u, 1103798670u, 1096124830u, 3223458410u, 3146895201u, 0, LOG10_TOLERANCE, 0},
{ 95, 1063235023u, 2540404725u, 3240157452u, 4122845725u, 3221599629u, 3004527711u, 0, LOG10_TOLERANCE, 0},
{ 96, 1083643710u, 311336721u, 3214382367u, 4212533768u, 1074355041u, 396212168u, 0, LOG10_TOLERANCE, 0},
{ 97, 1051139427u, 1769686293u, 3240200923u, 3538602249u, 3222840766u, 2455777040u, 0, LOG10_TOLERANCE, 0},
{ 98, 1078227549u, 508056696u, 1103793878u, 776520138u, 1073334613u, 2708912122u, 0, LOG10_TOLERANCE, 0},
{ 99, 1102910577u, 4064962760u, 1077424413u, 819766631u, 1075929194u, 1996503108u, 0, LOG10_TOLERANCE, 0},
{ 100, 1074178362u, 2112385259u, 3227593179u, 1187058516u, 1071444142u, 1729917169u, 0, LOG10_TOLERANCE, 0},
{ 101, 1082295059u, 2514398118u, 1076579751u, 870169764u, 1074146890u, 3718905266u, 0, LOG10_TOLERANCE, 0},
{ 102, 1099367744u, 1190259653u, 1069112254u, 3417249840u, 1075756071u, 2662850456u, 0, LOG10_TOLERANCE, 0},
{ 103, 1046179435u, 3467757357u, 3215075200u, 2168175352u, 3223215840u, 1799448942u, 0, LOG10_TOLERANCE, 0},
{ 104, 1092159487u, 1508888184u, 1060430241u, 3524949092u, 1075213212u, 2842956866u, 0, LOG10_TOLERANCE, 0},
{ 105, 1049929235u, 166402802u, 3237198975u, 3572369260u, 3222932523u, 4280265619u, 0, LOG10_TOLERANCE, 0},
{ 106, 1081866822u, 2441536203u, 3202753937u, 3658194573u, 1074083099u, 1451479062u, 0, LOG10_TOLERANCE, 0},
{ 107, 1062392908u, 2479742828u, 1062342831u, 4214154303u, 3221718085u, 2663279180u, 0, LOG10_TOLERANCE, 0},
{ 108, 1082396794u, 426896765u, 1066474375u, 2201754442u, 1074165226u, 294524756u, 0, LOG10_TOLERANCE, 0},
{ 109, 1048145373u, 2055773734u, 3239267288u, 291396537u, 3223066642u, 1899295311u, 0, LOG10_TOLERANCE, 0},
{ 110, 1089484385u, 874125203u, 3210508124u, 4091098764u, 1075005936u, 3628964044u, 0, LOG10_TOLERANCE, 0},
{ 111, 1065716026u, 120488169u, 3241241441u, 1985269424u, 3221202575u, 1575844383u, 0, LOG10_TOLERANCE, 0},
{ 112, 1059055762u, 2243036871u, 3243941101u, 740033495u, 3222229291u, 2093928209u, 0, LOG10_TOLERANCE, 0},
{ 113, 1061941258u, 1176656356u, 1074261978u, 3588756231u, 3221786072u, 706930159u, 0, LOG10_TOLERANCE, 0},
{ 114, 1105333143u, 3037249392u, 1061635587u, 1173102190u, 1076020402u, 1724289891u, 0, LOG10_TOLERANCE, 0},
{ 115, 1089725933u, 2882725208u, 1071440059u, 69225090u, 1075029258u, 2093829877u, 0, LOG10_TOLERANCE, 0},
{ 116, 1065179826u, 272319256u, 1072073912u, 2493997123u, 3221301330u, 1958636672u, 0, LOG10_TOLERANCE, 0},
{ 117, 1057720186u, 188610379u, 3232757923u, 2209647371u, 3222347389u, 2837231009u, 0, LOG10_TOLERANCE, 0},
{ 118, 1089274869u, 1990439193u, 1078073146u, 622849962u, 1074993288u, 3576763939u, 0, LOG10_TOLERANCE, 0},
{ 119, 1057135741u, 756052458u, 1081649113u, 2247475162u, 3222391958u, 2930228447u, 0, LOG10_TOLERANCE, 0},
{ 120, 1061623064u, 3878055211u, 3222407050u, 2979438623u, 3221829540u, 1096267203u, 0, LOG10_TOLERANCE, 0},
{ 121, 1047807349u, 2676398686u, 1105124431u, 3631096636u, 3223092450u, 2080967742u, 0, LOG10_TOLERANCE, 0},
{ 122, 1065079390u, 1697791764u, 3198136112u, 2299842819u, 3221313539u, 2223619642u, 0, LOG10_TOLERANCE, 0},
{ 123, 1078084768u, 1931502677u, 3215264397u, 3016456382u, 1073283305u, 2406385933u, 0, LOG10_TOLERANCE, 0},
{ 124, 1072253426u, 343404215u, 1061072607u, 4266232536u, 3216648998u, 239016280u, 0, LOG10_TOLERANCE, 0},
{ 125, 1093747188u, 4140316002u, 1082896196u, 868256971u, 1075328702u, 2557641593u, 0, LOG10_TOLERANCE, 0},
{ 126, 1075422810u, 1864139509u, 3187675097u, 3084482407u, 1072288548u, 2563126331u, 0, LOG10_TOLERANCE, 0},
{ 127, 1072707675u, 2427162817u, 3234748208u, 2715105792u, 1064849176u, 3587587979u, 0, LOG10_TOLERANCE, 0},
{ 128, 1064600512u, 3943389284u, 1046724025u, 3626825684u, 3221382913u, 1568343271u, 0, LOG10_TOLERANCE, 0},
{ 129, 1045423002u, 967350972u, 1093012318u, 448002663u, 3223277610u, 3114998281u, 0, LOG10_TOLERANCE, 0},
{ 130, 1104362211u, 105058217u, 1069733884u, 171786224u, 1075984565u, 2168621818u, 0, LOG10_TOLERANCE, 0},
{ 131, 1042130860u, 2863482262u, 3204997271u, 877784425u, 3223422621u, 3194788353u, 0, LOG10_TOLERANCE, 0},
{ 132, 1055145665u, 2801782962u, 3213604117u, 762347195u, 3222540205u, 780206140u, 0, LOG10_TOLERANCE, 0},
{ 133, 1086003079u, 2317950339u, 3246333414u, 2135700283u, 1074707079u, 4088703451u, 0, LOG10_TOLERANCE, 0},
{ 134, 1056516397u, 4171919805u, 1082858682u, 2180920863u, 3222436544u, 1603917460u, 0, LOG10_TOLERANCE, 0},
{ 135, 1072665436u, 1918836931u, 1083603224u, 3137821660u, 3212296090u, 3048145701u, 0, LOG10_TOLERANCE, 0},
{ 136, 1103902874u, 3456203663u, 3235600523u, 2335688936u, 1075966944u, 3184370032u, 0, LOG10_TOLERANCE, 0},
{ 137, 1042279322u, 4170235262u, 1051824459u, 521583737u, 3223418431u, 1706671790u, 0, LOG10_TOLERANCE, 0},
{ 138, 1081348303u, 1296623194u, 3250673860u, 2442872540u, 1074007414u, 1749941826u, 0, LOG10_TOLERANCE, 0},
{ 139, 1061684277u, 289979405u, 1049514449u, 3865737145u, 3221820508u, 669475419u, 0, LOG10_TOLERANCE, 0},
{ 140, 1075298944u, 3699090239u, 1054539840u, 3259249360u, 1072218835u, 1332264134u, 0, LOG10_TOLERANCE, 0},
{ 141, 1096418100u, 1619819023u, 1045993352u, 1022642459u, 1075533243u, 1299474792u, 0, LOG10_TOLERANCE, 0},
{ 142, 1081433004u, 19455098u, 3229182089u, 2096003654u, 1074021627u, 1335572803u, 0, LOG10_TOLERANCE, 0},
{ 143, 1076297936u, 3803689997u, 1071630912u, 2263729518u, 1072756957u, 1728113973u, 0, LOG10_TOLERANCE, 0},
{ 144, 1101357261u, 2816837387u, 1063422305u, 2597606398u, 1075872223u, 2982335179u, 0, LOG10_TOLERANCE, 0},
{ 145, 1069100169u, 3680967506u, 1040201163u, 179224723u, 3220184538u, 579581628u, 0, LOG10_TOLERANCE, 0},
{ 146, 1041146119u, 978126928u, 1101553990u, 4047893399u, 3223460238u, 2981887158u, 0, LOG10_TOLERANCE, 0},
{ 147, 1074838397u, 4059818629u, 1042678728u, 3640293589u, 1071899471u, 3330393492u, 0, LOG10_TOLERANCE, 0},
{ 148, 1100980392u, 3383497159u, 1070002807u, 1527313008u, 1075855061u, 3937649430u, 0, LOG10_TOLERANCE, 0},
{ 149, 1055224031u, 2599946514u, 1104170406u, 2738675352u, 3222533671u, 3949070241u, 0, LOG10_TOLERANCE, 0},
{ 150, 1105232623u, 3616571377u, 1060859316u, 1130603218u, 1076015345u, 3938672152u, 0, LOG10_TOLERANCE, 0},
{ 151, 1076028796u, 3859211180u, 1067940450u, 1744531824u, 1072641553u, 236826591u, 0, LOG10_TOLERANCE, 0},
{ 152, 1042831340u, 1958025850u, 3236511256u, 2472176453u, 3223394400u, 155360699u, 0, LOG10_TOLERANCE, 0},
{ 153, 1085623441u, 182132862u, 3250520938u, 3924356991u, 1074652303u, 227095142u, 0, LOG10_TOLERANCE, 0},
{ 154, 1083018236u, 35632886u, 3209806504u, 1453402523u, 1074253351u, 706658652u, 0, LOG10_TOLERANCE, 0},
{ 155, 1083522102u, 743225214u, 3202890678u, 142917400u, 1074335966u, 971180013u, 0, LOG10_TOLERANCE, 0},
{ 156, 1080684976u, 1472665012u, 3203138231u, 256588219u, 1073908090u, 2970356020u, 0, LOG10_TOLERANCE, 0},
{ 157, 1094982162u, 1062927000u, 1061134072u, 931677439u, 1075424983u, 4192261729u, 0, LOG10_TOLERANCE, 0},
{ 158, 1058377732u, 2320910576u, 1055663370u, 288059864u, 3222296288u, 615814715u, 0, LOG10_TOLERANCE, 0},
{ 159, 1078958093u, 1448349062u, 3199478070u, 3454027134u, 1073532773u, 2431650893u, 0, LOG10_TOLERANCE, 0},
{ 160, 1089975150u, 4215445172u, 3196654963u, 2231888973u, 1075049168u, 3858745282u, 0, LOG10_TOLERANCE, 0},
{ 161, 1099148583u, 40413554u, 3232578253u, 983832844u, 1075738201u, 1294348798u, 0, LOG10_TOLERANCE, 0},
{ 162, 1076237886u, 3995725873u, 1050082319u, 777231627u, 1072738446u, 2490660630u, 0, LOG10_TOLERANCE, 0},
{ 163, 1040986626u, 672789828u, 3253385962u, 2982787335u, 3223464951u, 2022959186u, 0, LOG10_TOLERANCE, 0},
{ 164, 1068390875u, 2075971825u, 1070166500u, 4034633931u, 3220415024u, 1453784302u, 0, LOG10_TOLERANCE, 0},
{ 165, 1062562529u, 1018222907u, 3244621407u, 3090050495u, 3221688759u, 3042080164u, 0, LOG10_TOLERANCE, 0},
{ 166, 1067680885u, 937732557u, 3200798890u, 2557898276u, 3220616089u, 2752657805u, 0, LOG10_TOLERANCE, 0},
{ 167, 1078342316u, 130346162u, 3223590310u, 275568693u, 1073372035u, 4013751462u, 0, LOG10_TOLERANCE, 0},
{ 168, 1042898869u, 3807416441u, 1075961161u, 3706820266u, 3223392040u, 625299453u, 0, LOG10_TOLERANCE, 0},
{ 169, 1068615357u, 1710131411u, 1078123323u, 1900790503u, 3220342988u, 1117943757u, 0, LOG10_TOLERANCE, 0},
{ 170, 1091335713u, 3420420033u, 3210844787u, 588423066u, 1075148920u, 1970986568u, 0, LOG10_TOLERANCE, 0},
{ 171, 1049684114u, 1160162008u, 3246307879u, 4265764460u, 3222955275u, 558478599u, 0, LOG10_TOLERANCE, 0},
{ 172, 1102543434u, 366653268u, 3188814424u, 466059202u, 1075917013u, 142658660u, 0, LOG10_TOLERANCE, 0},
{ 173, 1079144091u, 1325936170u, 3221436876u, 680097612u, 1073603027u, 4223503858u, 0, LOG10_TOLERANCE, 0},
{ 174, 1092907468u, 1827735934u, 3200554324u, 2875599271u, 1075269082u, 61509776u, 0, LOG10_TOLERANCE, 0},
{ 175, 1043546754u, 3117037091u, 3239246636u, 15838845u, 3223368277u, 1788507559u, 0, LOG10_TOLERANCE, 0},
{ 176, 1051974004u, 749718883u, 3223587064u, 1523766569u, 3222779192u, 499603616u, 0, LOG10_TOLERANCE, 0},
{ 177, 1044833651u, 1966536294u, 3250158026u, 699164258u, 3223315327u, 605213675u, 0, LOG10_TOLERANCE, 0},
{ 178, 1098048435u, 3759049394u, 1106085272u, 1183789499u, 1075654641u, 1976310585u, 0, LOG10_TOLERANCE, 0},
{ 179, 1081201623u, 1970107747u, 1095245453u, 2308233883u, 1073980485u, 1917090271u, 0, LOG10_TOLERANCE, 0},
{ 180, 1084756444u, 1491017852u, 1041444355u, 1723375725u, 1074522322u, 201295655u, 0, LOG10_TOLERANCE, 0},
{ 181, 1069146422u, 1141349287u, 1097465301u, 3403438584u, 3220166997u, 3273626097u, 0, LOG10_TOLERANCE, 0},
{ 182, 1083088260u, 1711085243u, 3250239076u, 1377484108u, 1074261439u, 3510689380u, 0, LOG10_TOLERANCE, 0},
{ 183, 1098385019u, 2880275004u, 1084039594u, 1611394950u, 1075682022u, 1318740231u, 0, LOG10_TOLERANCE, 0},
{ 184, 1086737787u, 2626629370u, 1063771493u, 1499080813u, 1074805506u, 2197894595u, 0, LOG10_TOLERANCE, 0},
{ 185, 1055231263u, 3936262414u, 1103919063u, 3175668759u, 3222533087u, 1926622946u, 0, LOG10_TOLERANCE, 0},
{ 186, 1060498071u, 1270950554u, 3194616071u, 3680565379u, 3221999169u, 3085134097u, 0, LOG10_TOLERANCE, 0},
{ 187, 1060664575u, 1066985223u, 3221613219u, 4089383168u, 3221974195u, 1363215594u, 0, LOG10_TOLERANCE, 0},
{ 188, 1069575191u, 4017329311u, 3208334452u, 1667591498u, 3219949937u, 482205278u, 0, LOG10_TOLERANCE, 0},
{ 189, 1088164157u, 3154656624u, 1061894279u, 3886344038u, 1074910593u, 1611552831u, 0, LOG10_TOLERANCE, 0},
{ 190, 1050652945u, 977586119u, 3209762784u, 953839852u, 3222883751u, 2710381229u, 0, LOG10_TOLERANCE, 0},
{ 191, 1104965247u, 143071571u, 3206165386u, 913097445u, 1076006824u, 1671790082u, 0, LOG10_TOLERANCE, 0},
{ 192, 1043081808u, 1371169579u, 1057079837u, 2594818628u, 3223386098u, 4205730324u, 0, LOG10_TOLERANCE, 0},
{ 193, 1104309688u, 2259342224u, 3217432469u, 1824221478u, 1075982142u, 1272387594u, 0, LOG10_TOLERANCE, 0},
{ 194, 1099351127u, 1576604497u, 1079368611u, 185078728u, 1075754810u, 3070984497u, 0, LOG10_TOLERANCE, 0},
{ 195, 1074195779u, 444800035u, 3243343143u, 1734989302u, 1071465380u, 1752264123u, 0, LOG10_TOLERANCE, 0},
{ 196, 1072748883u, 130452005u, 1041548088u, 2158433515u, 1066859955u, 2063338972u, 0, LOG10_TOLERANCE, 0},
{ 197, 1087212320u, 1941318385u, 1045807374u, 792193370u, 1074837515u, 2154594024u, 0, LOG10_TOLERANCE, 0},
{ 198, 1090816018u, 1299392207u, 3212131720u, 3205732280u, 1075111739u, 267565964u, 0, LOG10_TOLERANCE, 0},
{ 199, 1098698804u, 3035093505u, 1052187689u, 3287702190u, 1075702711u, 3041229296u, 0, LOG10_TOLERANCE, 0},
{ 200, 1099192612u, 2160225215u, 1102624859u, 836655570u, 1075742023u, 2852075512u, 0, LOG10_TOLERANCE, 0},
{ 201, 1096723626u, 3360816360u, 3246176356u, 172860634u, 1075552011u, 1964944288u, 0, LOG10_TOLERANCE, 0},
{ 202, 1070995788u, 146831910u, 1051558014u, 2340722078u, 3218968143u, 2381624297u, 0, LOG10_TOLERANCE, 0},
{ 203, 1082932703u, 1603798153u, 3207725532u, 1099413093u, 1074243064u, 2760597126u, 0, LOG10_TOLERANCE, 0},
{ 204, 1099194730u, 2429340443u, 3190303581u, 3223770005u, 1075742204u, 1481397550u, 0, LOG10_TOLERANCE, 0},
{ 205, 1075882959u, 955542166u, 3230415151u, 275583938u, 1072527436u, 3458072453u, 0, LOG10_TOLERANCE, 0},
{ 206, 1092971882u, 513397822u, 1090646554u, 2089321329u, 1075274427u, 3320030397u, 0, LOG10_TOLERANCE, 0},
{ 207, 1045686228u, 2782073372u, 1046063872u, 4023829068u, 3223252349u, 3038225778u, 0, LOG10_TOLERANCE, 0},
{ 208, 1098564822u, 3242223094u, 3194111199u, 4264674108u, 1075694332u, 3986486054u, 0, LOG10_TOLERANCE, 0},
{ 209, 1091027173u, 3506346169u, 1047020885u, 1742757458u, 1075128334u, 1994269532u, 0, LOG10_TOLERANCE, 0},
{ 210, 1045180829u, 1265459564u, 3193450280u, 3650514880u, 3223291632u, 1407815761u, 0, LOG10_TOLERANCE, 0},
{ 211, 1081755890u, 1525260440u, 3235452527u, 2612331392u, 1074068889u, 281483434u, 0, LOG10_TOLERANCE, 0},
{ 212, 1101185272u, 1263613754u, 3219096387u, 635677201u, 1075864768u, 886241666u, 0, LOG10_TOLERANCE, 0},
{ 213, 1058788439u, 4140947288u, 3200792376u, 2013265346u, 3222260434u, 3769645888u, 0, LOG10_TOLERANCE, 0},
{ 214, 1102490744u, 1912759945u, 3237045253u, 1351396825u, 1075915029u, 2362076341u, 0, LOG10_TOLERANCE, 0},
{ 215, 1100721514u, 1001433078u, 3206926643u, 2741676659u, 1075847467u, 2274933934u, 0, LOG10_TOLERANCE, 0},
{ 216, 1080923606u, 1088945233u, 1085095743u, 3986114865u, 1073937994u, 3131087463u, 0, LOG10_TOLERANCE, 0},
{ 217, 1068250409u, 831239754u, 1099828675u, 3071308141u, 3220448375u, 1593685882u, 0, LOG10_TOLERANCE, 0},
{ 218, 1078350849u, 3473592372u, 1102759382u, 1309576357u, 1073374699u, 2119873274u, 0, LOG10_TOLERANCE, 0},
{ 219, 1103703058u, 2042340367u, 1091945628u, 2062772374u, 1075960436u, 2286787906u, 0, LOG10_TOLERANCE, 0},
{ 220, 1047282039u, 1840632537u, 1096533424u, 807510337u, 3223133556u, 615461173u, 0, LOG10_TOLERANCE, 0},
{ 221, 1083968074u, 144814872u, 3212698915u, 2282965697u, 1074399260u, 2935967126u, 0, LOG10_TOLERANCE, 0},
{ 222, 1071236430u, 2552499583u, 3229111426u, 1470130815u, 3218688141u, 1735943305u, 0, LOG10_TOLERANCE, 0},
{ 223, 1095609417u, 2858583811u, 1089760910u, 6360994u, 1075469319u, 1031376135u, 0, LOG10_TOLERANCE, 0},
{ 224, 1050781281u, 1614537194u, 1075198900u, 4088705365u, 3222871476u, 124071926u, 0, LOG10_TOLERANCE, 0},
{ 225, 1103455422u, 3545570051u, 1065221325u, 1629217700u, 1075951177u, 3818828341u, 0, LOG10_TOLERANCE, 0},
{ 226, 1072744324u, 1813392963u, 3235313361u, 3772501596u, 1066739384u, 2622169306u, 0, LOG10_TOLERANCE, 0},
{ 227, 1049319038u, 2406734491u, 1042055360u, 89226663u, 3222979489u, 1549818103u, 0, LOG10_TOLERANCE, 0},
{ 228, 1048267433u, 1618759139u, 3194723421u, 3888234802u, 3223058595u, 943314679u, 0, LOG10_TOLERANCE, 0},
{ 229, 1055357248u, 3590035633u, 3212424262u, 2892456615u, 3222523359u, 3801211338u, 0, LOG10_TOLERANCE, 0},
{ 230, 1042459412u, 2431246964u, 3241512456u, 183850734u, 3223409509u, 3122860931u, 0, LOG10_TOLERANCE, 0},
{ 231, 1089501101u, 3088319870u, 3211544311u, 862225364u, 1075007714u, 397722947u, 0, LOG10_TOLERANCE, 0},
{ 232, 1087811016u, 3495352775u, 1058576726u, 596957268u, 1074886323u, 4156588618u, 0, LOG10_TOLERANCE, 0},
{ 233, 1046553348u, 1839214511u, 3205004060u, 1923240983u, 3223190487u, 3541347935u, 0, LOG10_TOLERANCE, 0},
{ 234, 1058073864u, 739619702u, 3223356436u, 2689885273u, 3222323852u, 918767008u, 0, LOG10_TOLERANCE, 0},
{ 235, 1052841323u, 2143376228u, 1098306332u, 3760236188u, 3222717361u, 4276298674u, 0, LOG10_TOLERANCE, 0},
{ 236, 1074621795u, 671680995u, 1091262633u, 2315535361u, 1071782371u, 3108716060u, 0, LOG10_TOLERANCE, 0},
{ 237, 1066682341u, 2493598049u, 3194927008u, 1689107592u, 3220914269u, 805960935u, 0, LOG10_TOLERANCE, 0},
{ 238, 1042506311u, 1578976988u, 1066368383u, 2117279163u, 3223407368u, 1831202447u, 0, LOG10_TOLERANCE, 0},
{ 239, 1075504463u, 3425290087u, 1098487295u, 1263412017u, 1072331748u, 2542659286u, 0, LOG10_TOLERANCE, 0},
{ 240, 1060949116u, 3635396812u, 1070999426u, 3965655689u, 3221936986u, 1317850179u, 0, LOG10_TOLERANCE, 0},
{ 241, 1060196346u, 2183973116u, 1101098363u, 1118613350u, 3222052862u, 2389008740u, 0, LOG10_TOLERANCE, 0},
{ 242, 1074462441u, 199516350u, 1078368488u, 164621458u, 1071703822u, 3497032431u, 0, LOG10_TOLERANCE, 0},
{ 243, 1040222370u, 3570940805u, 3230316437u, 3596080877u, 3223495334u, 3465764975u, 0, LOG10_TOLERANCE, 0},
{ 244, 1060725917u, 980880313u, 1079833442u, 884465057u, 3221965643u, 3063857904u, 0, LOG10_TOLERANCE, 0},
{ 245, 1099977124u, 2558179220u, 1052873711u, 1233598120u, 1075795814u, 1376180157u, 0, LOG10_TOLERANCE, 0},
{ 246, 1047115221u, 1909994277u, 1085015978u, 2991527452u, 3223144303u, 4009520900u, 0, LOG10_TOLERANCE, 0},
{ 247, 1060855260u, 1680290941u, 1074309900u, 2943870846u, 3221948600u, 2664673208u, 0, LOG10_TOLERANCE, 0},
{ 248, 1059496132u, 1451927357u, 3228615456u, 1502585517u, 3222149720u, 1522432661u, 0, LOG10_TOLERANCE, 0},
{ 249, 1088728303u, 751136990u, 3230392165u, 3493275472u, 1074954708u, 1362341029u, 0, LOG10_TOLERANCE, 0},
{ 250, 1098365967u, 1209623292u, 3238056647u, 979495322u, 1075680636u, 1289064744u, 0, LOG10_TOLERANCE, 0},
{ 251, 1102940648u, 1717672108u, 1048120593u, 531240316u, 1075930085u, 2703746266u, 0, LOG10_TOLERANCE, 0},
{ 252, 1054174923u, 3548721654u, 1086112947u, 3391817224u, 3222612628u, 946693516u, 0, LOG10_TOLERANCE, 0},
{ 253, 1077836851u, 2758195125u, 1100880260u, 2028440924u, 1073200851u, 2600416432u, 0, LOG10_TOLERANCE, 0},
{ 254, 1084223893u, 2750123373u, 3232200256u, 1086294931u, 1074428937u, 2273638036u, 0, LOG10_TOLERANCE, 0},
{ 255, 1043958672u, 2986160931u, 1076097908u, 2540046258u, 3223352200u, 2239843435u, 0, LOG10_TOLERANCE, 0},
{ 256, 1087992954u, 451471221u, 1064816262u, 4187644495u, 1074899471u, 12188310u, 0, LOG10_TOLERANCE, 0},
{ 257, 1099460228u, 2439500162u, 1065280276u, 1979490284u, 1075762845u, 559607440u, 0, LOG10_TOLERANCE, 0},
{ 258, 1040415832u, 2283342035u, 1078398157u, 1345997553u, 3223485983u, 1687818887u, 0, LOG10_TOLERANCE, 0},
{ 259, 1065765700u, 179066662u, 1103272172u, 1217337578u, 3221186823u, 1702896667u, 0, LOG10_TOLERANCE, 0},
{ 260, 1064078729u, 3779303391u, 3210023352u, 3115946280u, 3221465459u, 2407475467u, 0, LOG10_TOLERANCE, 0},
{ 261, 1045506226u, 286247089u, 1085153597u, 713645369u, 3223269253u, 3306334413u, 0, LOG10_TOLERANCE, 0},
{ 262, 1093670500u, 1468283899u, 1042831668u, 2022736418u, 1075320708u, 3563700741u, 0, LOG10_TOLERANCE, 0},
{ 263, 1083139105u, 3305564080u, 1065483445u, 482392433u, 1074267138u, 293554640u, 0, LOG10_TOLERANCE, 0},
{ 264, 1054212159u, 2256346551u, 3222430705u, 2071674991u, 3222609649u, 2107857682u, 0, LOG10_TOLERANCE, 0},
{ 265, 1056541047u, 2295269094u, 1084451053u, 2773103941u, 3222434855u, 394431272u, 0, LOG10_TOLERANCE, 0},
{ 266, 1078173946u, 1482721827u, 1092243422u, 3125409590u, 1073316022u, 2786091143u, 0, LOG10_TOLERANCE, 0},
{ 267, 1073582325u, 1381740563u, 1071545057u, 2918235653u, 1070666040u, 3869657815u, 0, LOG10_TOLERANCE, 0},
{ 268, 1091232324u, 1105857967u, 3241990046u, 2703723225u, 1075142428u, 1377220811u, 0, LOG10_TOLERANCE, 0},
{ 269, 1043015571u, 174689677u, 1079333374u, 3947057014u, 3223388179u, 951338253u, 0, LOG10_TOLERANCE, 0},
{ 270, 1090461859u, 2023082423u, 3242081486u, 1169047927u, 1075080201u, 1158479528u, 0, LOG10_TOLERANCE, 0},
{ 271, 1064525899u, 3742487766u, 1043425732u, 194972788u, 3221395913u, 4231239291u, 0, LOG10_TOLERANCE, 0},
{ 272, 1066308179u, 2136071361u, 3211529757u, 993675115u, 3221043032u, 1426615912u, 0, LOG10_TOLERANCE, 0},
{ 273, 1066179733u, 210772141u, 3241441539u, 580731413u, 3221073205u, 838397735u, 0, LOG10_TOLERANCE, 0},
{ 274, 1093840413u, 1751560711u, 1074522705u, 180987057u, 1075337719u, 4139891090u, 0, LOG10_TOLERANCE, 0},
{ 275, 1066754591u, 2552236599u, 1088658621u, 2112468655u, 3220890163u, 4138303096u, 0, LOG10_TOLERANCE, 0},
{ 276, 1041806969u, 1578223762u, 3224596567u, 2456166162u, 3223432999u, 2061892417u, 0, LOG10_TOLERANCE, 0},
{ 277, 1058506965u, 2110924310u, 1086207177u, 3161208323u, 3222286325u, 1989463349u, 0, LOG10_TOLERANCE, 0},
{ 278, 1084379746u, 2352173188u, 1079361728u, 4070222179u, 1074460192u, 606876331u, 0, LOG10_TOLERANCE, 0},
{ 279, 1101012904u, 2481562701u, 1090937016u, 3809489716u, 1075856166u, 2478468402u, 0, LOG10_TOLERANCE, 0},
{ 280, 1049519003u, 330905705u, 1086260896u, 90264431u, 3222967443u, 279221201u, 0, LOG10_TOLERANCE, 0},
{ 281, 1040729961u, 4162008079u, 3194387916u, 759522153u, 3223473464u, 1061077941u, 0, LOG10_TOLERANCE, 0},
{ 282, 1081015037u, 1839697482u, 3216442625u, 2211508949u, 1073948486u, 2112903132u, 0, LOG10_TOLERANCE, 0},
{ 283, 1102323563u, 3736863454u, 1063475914u, 3150741666u, 1075908235u, 1559267761u, 0, LOG10_TOLERANCE, 0},
{ 284, 1060785883u, 4200269406u, 3236646101u, 1061812176u, 3221957583u, 1023579949u, 0, LOG10_TOLERANCE, 0},
{ 285, 1080217979u, 106027290u, 3234978297u, 2245237549u, 1073834974u, 1053439998u, 0, LOG10_TOLERANCE, 0},
{ 286, 1099500686u, 2132131375u, 3250483427u, 3449276437u, 1075765686u, 359660823u, 0, LOG10_TOLERANCE, 0},
{ 287, 1089388778u, 2334440944u, 1105423490u, 4004336184u, 1074999912u, 857354786u, 0, LOG10_TOLERANCE, 0},
{ 288, 1071289056u, 4090088208u, 1042030013u, 3898658299u, 3218632247u, 4153299296u, 0, LOG10_TOLERANCE, 0},
{ 289, 1060424416u, 2272831437u, 3253082595u, 2639188641u, 3222011156u, 352494683u, 0, LOG10_TOLERANCE, 0},
{ 290, 1054766684u, 1856594168u, 3189515294u, 4101853676u, 3222572602u, 3831839253u, 0, LOG10_TOLERANCE, 0},
{ 291, 1076012412u, 2211699255u, 3195060344u, 3865018604u, 1072629422u, 3024843075u, 0, LOG10_TOLERANCE, 0},
{ 292, 1095283362u, 996259334u, 3241496889u, 3782673116u, 1075448425u, 2044469585u, 0, LOG10_TOLERANCE, 0},
{ 293, 1099130747u, 3840380763u, 1048674041u, 550040067u, 1075736615u, 2976904307u, 0, LOG10_TOLERANCE, 0},
{ 294, 1103935945u, 95874100u, 3237232828u, 2645647822u, 1075967953u, 2505472330u, 0, LOG10_TOLERANCE, 0},
{ 295, 1043665640u, 3441419500u, 3252367038u, 876710419u, 3223363153u, 2218871553u, 0, LOG10_TOLERANCE, 0},
{ 296, 1091109904u, 2560836004u, 3199616543u, 1180840586u, 1075134229u, 2422777408u, 0, LOG10_TOLERANCE, 0},
{ 297, 1074119318u, 2218230392u, 3227485787u, 3947214579u, 1071370243u, 1003595310u, 0, LOG10_TOLERANCE, 0},
{ 298, 1079539654u, 1447312532u, 1081476588u, 780366847u, 1073732026u, 1166483442u, 0, LOG10_TOLERANCE, 0},
{ 299, 1072569643u, 2842113832u, 3216156731u, 225159029u, 3214607349u, 2125764098u, 0, LOG10_TOLERANCE, 0},
{ 300, 1098117193u, 1601981129u, 3234628869u, 2236538344u, 1075660795u, 1772312193u, 0, LOG10_TOLERANCE, 0},
{ 301, 1085173524u, 2194185737u, 3242362684u, 87913366u, 1074575739u, 2341197873u, 0, LOG10_TOLERANCE, 0},
{ 302, 1051600232u, 1346862963u, 1077836259u, 3604666660u, 3222810530u, 2259775583u, 0, LOG10_TOLERANCE, 0},
{ 303, 1064772331u, 3115209742u, 1099332326u, 1325101950u, 3221355528u, 4174732436u, 0, LOG10_TOLERANCE, 0},
{ 304, 1077062394u, 3889223100u, 1053247613u, 3371396923u, 1072977511u, 4208845593u, 0, LOG10_TOLERANCE, 0},
{ 305, 1072994220u, 4163120793u, 1075022670u, 1387631215u, 1069288961u, 3741080239u, 0, LOG10_TOLERANCE, 0},
{ 306, 1057998131u, 1532426189u, 1063168268u, 3397022615u, 3222331077u, 31392221u, 0, LOG10_TOLERANCE, 0},
{ 307, 1053549673u, 89324166u, 1079206060u, 3429424710u, 3222661551u, 75523650u, 0, LOG10_TOLERANCE, 0},
{ 308, 1044841454u, 747591401u, 1072238381u, 2803213904u, 3223314736u, 2879315374u, 0, LOG10_TOLERANCE, 0},
{ 309, 1091113780u, 271904221u, 1044258318u, 1858545114u, 1075134498u, 1591765325u, 0, LOG10_TOLERANCE, 0},
{ 310, 1080585266u, 314958082u, 3249912496u, 2966213175u, 1073894330u, 1052667796u, 0, LOG10_TOLERANCE, 0},
{ 311, 1049695766u, 3119528953u, 3217179014u, 2908718240u, 3222954084u, 889232043u, 0, LOG10_TOLERANCE, 0},
{ 312, 1094983928u, 2018361566u, 1100926600u, 3985805054u, 1075425136u, 2185146546u, 0, LOG10_TOLERANCE, 0},
{ 313, 1070132580u, 409584884u, 3239758947u, 755795129u, 3219569843u, 63396861u, 0, LOG10_TOLERANCE, 0},
{ 314, 1075772446u, 1819156379u, 3251342302u, 2982669005u, 1072460651u, 1334807680u, 0, LOG10_TOLERANCE, 0},
{ 315, 1101563433u, 2080534280u, 3188254060u, 449171797u, 1075880038u, 2397039693u, 0, LOG10_TOLERANCE, 0},
{ 316, 1095956900u, 168744837u, 3214950009u, 1322217822u, 1075497330u, 1592384176u, 0, LOG10_TOLERANCE, 0},
{ 317, 1106743252u, 3250487255u, 1062120700u, 1876195180u, 1076075043u, 453333839u, 0, LOG10_TOLERANCE, 0},
{ 318, 1078859832u, 1336400247u, 1098057903u, 3314079581u, 1073510632u, 2598007896u, 0, LOG10_TOLERANCE, 0},
{ 319, 1056195172u, 265025555u, 1063854282u, 3779482256u, 3222461212u, 715876344u, 0, LOG10_TOLERANCE, 0},
{ 320, 1067300501u, 887044257u, 1054789618u, 2732056261u, 3220740348u, 2800315593u, 0, LOG10_TOLERANCE, 0},
{ 321, 1050106742u, 4027115185u, 3191764868u, 2940199511u, 3222918491u, 2931304212u, 0, LOG10_TOLERANCE, 0},
{ 322, 1055016507u, 2875684421u, 3227459837u, 2251967570u, 3222551865u, 301845783u, 0, LOG10_TOLERANCE, 0},
{ 323, 1063244412u, 284173546u, 3238823679u, 3557800647u, 3221598602u, 1501044995u, 0, LOG10_TOLERANCE, 0},
{ 324, 1101458560u, 3147771266u, 3220110464u, 2933364246u, 1075876197u, 2005169396u, 0, LOG10_TOLERANCE, 0},
{ 325, 1064853160u, 3366183281u, 3234870843u, 537442654u, 3221343703u, 2043034050u, 0, LOG10_TOLERANCE, 0},
{ 326, 1096635140u, 2529029548u, 3249882819u, 3781513577u, 1075546886u, 2627653749u, 0, LOG10_TOLERANCE, 0},
{ 327, 1065952706u, 1080845539u, 3206760016u, 911778687u, 3221131975u, 4072600242u, 0, LOG10_TOLERANCE, 0},
{ 328, 1044467388u, 469586759u, 1091830022u, 3080528840u, 3223334904u, 2876434309u, 0, LOG10_TOLERANCE, 0},
{ 329, 1080249104u, 2863108169u, 3225605506u, 2508274250u, 1073840649u, 2350580810u, 0, LOG10_TOLERANCE, 0},
{ 330, 1063343336u, 4080017377u, 3206492941u, 1470284690u, 3221579130u, 429178087u, 0, LOG10_TOLERANCE, 0},
{ 331, 1059636742u, 3867917386u, 1102054928u, 3504746045u, 3222129093u, 3443234884u, 0, LOG10_TOLERANCE, 0},
{ 332, 1064522279u, 2962134101u, 3244741577u, 3390537350u, 3221396564u, 215600004u, 0, LOG10_TOLERANCE, 0},
{ 333, 1088201813u, 1702237980u, 1071598971u, 1102587474u, 1074912900u, 2016435523u, 0, LOG10_TOLERANCE, 0},
{ 334, 1055486470u, 2180218657u, 3211592260u, 1206527853u, 3222514177u, 1109609194u, 0, LOG10_TOLERANCE, 0},
{ 335, 1049601096u, 394130786u, 3242511482u, 2437699868u, 3222962844u, 1703442430u, 0, LOG10_TOLERANCE, 0},
{ 336, 1044237059u, 849581558u, 3252006507u, 2008614943u, 3223343444u, 773913446u, 0, LOG10_TOLERANCE, 0},
{ 337, 1062656366u, 3128971673u, 3249137531u, 2773583059u, 3221674024u, 2531989598u, 0, LOG10_TOLERANCE, 0},
{ 338, 1085029866u, 590727700u, 3248651761u, 2183878539u, 1074558718u, 3417539816u, 0, LOG10_TOLERANCE, 0},
{ 339, 1101098629u, 820687580u, 3208143496u, 1402434664u, 1075860606u, 3565615010u, 0, LOG10_TOLERANCE, 0},
{ 340, 1104807187u, 1873709254u, 3245167989u, 44275991u, 1076001778u, 2036327596u, 0, LOG10_TOLERANCE, 0},
{ 341, 1042185105u, 1174874204u, 3208263730u, 2360372288u, 3223421054u, 2997287966u, 0, LOG10_TOLERANCE, 0},
{ 342, 1103854676u, 937573440u, 3208953761u, 211240241u, 1075965441u, 2636424733u, 0, LOG10_TOLERANCE, 0},
{ 343, 1096065286u, 2469774991u, 1043117070u, 3380071805u, 1075506844u, 1428213445u, 0, LOG10_TOLERANCE, 0},
{ 344, 1058121042u, 442507560u, 3254252803u, 3257889649u, 3222319110u, 1209148707u, 0, LOG10_TOLERANCE, 0},
{ 345, 1068850520u, 1854921625u, 1049810168u, 2729627545u, 3220259255u, 4115658190u, 0, LOG10_TOLERANCE, 0},
{ 346, 1107228981u, 4001809575u, 3240128649u, 278261523u, 1076090611u, 4040385013u, 0, LOG10_TOLERANCE, 0},
{ 347, 1087224694u, 1793907966u, 3238955714u, 398859249u, 1074838240u, 3371466190u, 0, LOG10_TOLERANCE, 0},
{ 348, 1053468899u, 2511916952u, 3219195283u, 1697158299u, 3222666696u, 1149559858u, 0, LOG10_TOLERANCE, 0},
{ 349, 1069985548u, 3230931724u, 3243897690u, 3508781585u, 3219655741u, 4077268049u, 0, LOG10_TOLERANCE, 0},
{ 350, 1103847606u, 1674254897u, 1046547577u, 217148561u, 1075965217u, 3250603014u, 0, LOG10_TOLERANCE, 0},
{ 351, 1063780306u, 3275604304u, 3194840159u, 2991205850u, 3221505017u, 3196065758u, 0, LOG10_TOLERANCE, 0},
{ 352, 1047765727u, 3509997278u, 3248888030u, 3897986511u, 3223096074u, 1672032697u, 0, LOG10_TOLERANCE, 0},
{ 353, 1047182435u, 2156824613u, 1042295665u, 1239257646u, 3223139850u, 2987274156u, 0, LOG10_TOLERANCE, 0},
{ 354, 1065780437u, 1073153314u, 3250031627u, 2567234990u, 3221182253u, 164395135u, 0, LOG10_TOLERANCE, 0},
{ 355, 1043109764u, 4261696995u, 3197784432u, 323702024u, 3223385243u, 1235045213u, 0, LOG10_TOLERANCE, 0},
{ 356, 1096207349u, 4075177615u, 3202791065u, 1919006082u, 1075518219u, 3567878508u, 0, LOG10_TOLERANCE, 0},
{ 357, 1091786365u, 386429966u, 1086504491u, 3698826164u, 1075183833u, 284065248u, 0, LOG10_TOLERANCE, 0},
{ 358, 1078327190u, 1681986446u, 3194985869u, 3072950140u, 1073367276u, 1317768853u, 0, LOG10_TOLERANCE, 0},
{ 359, 1069828285u, 3719038997u, 1055433962u, 3331415058u, 3219757577u, 883618285u, 0, LOG10_TOLERANCE, 0},
{ 360, 1060749713u, 2420250111u, 3238002206u, 1928661079u, 3221962410u, 3782338671u, 0, LOG10_TOLERANCE, 0},
{ 361, 1081914210u, 3679866727u, 3227386672u, 1273835792u, 1074088909u, 1763037434u, 0, LOG10_TOLERANCE, 0},
{ 362, 1041622738u, 2682092368u, 3234222284u, 1325425811u, 3223439873u, 2314570182u, 0, LOG10_TOLERANCE, 0},
{ 363, 1056312613u, 4175172697u, 3208346191u, 2130706153u, 3222451562u, 2646436590u, 0, LOG10_TOLERANCE, 0},
{ 364, 1092089624u, 1200784450u, 1083605096u, 1248595607u, 1075208257u, 3714920247u, 0, LOG10_TOLERANCE, 0},
{ 365, 1066407215u, 1897285171u, 3251296075u, 944966123u, 3221019887u, 2885684334u, 0, LOG10_TOLERANCE, 0},
{ 366, 1093887602u, 2270747330u, 3230692631u, 422503284u, 1075342025u, 3855534378u, 0, LOG10_TOLERANCE, 0},
{ 367, 1084120037u, 2857564741u, 1075647403u, 3308906709u, 1074417351u, 3495656636u, 0, LOG10_TOLERANCE, 0},
{ 368, 1055991450u, 1380066948u, 3232612906u, 2613634294u, 3222480175u, 4079753456u, 0, LOG10_TOLERANCE, 0},
{ 369, 1063890856u, 4022784584u, 1060483857u, 3264056381u, 3221489550u, 3947775592u, 0, LOG10_TOLERANCE, 0},
{ 370, 1044637404u, 1778509100u, 3213146285u, 2665833973u, 3223326954u, 1245976636u, 0, LOG10_TOLERANCE, 0},
{ 371, 1069243652u, 1859175955u, 1079949560u, 4258450607u, 3220116226u, 3853669976u, 0, LOG10_TOLERANCE, 0},
{ 372, 1048277388u, 4128020197u, 1076266146u, 4122840980u, 3223057963u, 1203658489u, 0, LOG10_TOLERANCE, 0},
{ 373, 1045699515u, 2454653987u, 3229487005u, 2977478685u, 3223251196u, 49172802u, 0, LOG10_TOLERANCE, 0},
{ 374, 1106072835u, 1355181872u, 1095308770u, 436846481u, 1076048055u, 3710853932u, 0, LOG10_TOLERANCE, 0},
{ 375, 1099121654u, 2592856453u, 3247825559u, 3195234082u, 1075735798u, 2943062101u, 0, LOG10_TOLERANCE, 0},
{ 376, 1074634375u, 3554670043u, 1091621009u, 3321236467u, 1071788293u, 3499163438u, 0, LOG10_TOLERANCE, 0},
{ 377, 1069012833u, 1936670355u, 1095715713u, 2958468553u, 3220209306u, 4000528649u, 0, LOG10_TOLERANCE, 0},
{ 378, 1044807461u, 2960339502u, 1098808013u, 1044068983u, 3223317331u, 3200692282u, 0, LOG10_TOLERANCE, 0},
{ 379, 1049207537u, 4093388677u, 1095478112u, 1735930261u, 3222986804u, 3051995548u, 0, LOG10_TOLERANCE, 0},
{ 380, 1091040302u, 1807398746u, 3195743135u, 4261616162u, 1075129290u, 2488942216u, 0, LOG10_TOLERANCE, 0},
{ 381, 1061810546u, 3250576797u, 1059002384u, 3043079652u, 3221802937u, 62615936u, 0, LOG10_TOLERANCE, 0},
{ 382, 1069207109u, 666051428u, 3208765404u, 1912684117u, 3220134978u, 1624219483u, 0, LOG10_TOLERANCE, 0},
{ 383, 1103487420u, 1949030179u, 1096388934u, 896459246u, 1075952462u, 1749306203u, 0, LOG10_TOLERANCE, 0},
{ 384, 1054300653u, 622499767u, 1066707637u, 1490260486u, 3222602868u, 625029866u, 0, LOG10_TOLERANCE, 0},
{ 385, 1106688493u, 1490616165u, 3251242436u, 795675736u, 1076072987u, 3348155444u, 0, LOG10_TOLERANCE, 0},
{ 386, 1080943896u, 3662877092u, 3234317146u, 3200513112u, 1073940365u, 763960603u, 0, LOG10_TOLERANCE, 0},
{ 387, 1084088786u, 1356101968u, 3236536816u, 3062844611u, 1074413746u, 4063861095u, 0, LOG10_TOLERANCE, 0},
{ 388, 1072438992u, 2284484846u, 3219498359u, 3240896015u, 3215768815u, 1046975407u, 0, LOG10_TOLERANCE, 0},
{ 389, 1088276041u, 494503287u, 1092811254u, 142673998u, 1074917315u, 3271366326u, 0, LOG10_TOLERANCE, 0},
{ 390, 1104642268u, 3394882641u, 3225306538u, 364852125u, 1075995988u, 1977096684u, 0, LOG10_TOLERANCE, 0},
{ 391, 1077778115u, 193885269u, 1088149839u, 1359805831u, 1073187262u, 2507279849u, 0, LOG10_TOLERANCE, 0},
{ 392, 1053001134u, 592580907u, 3199560872u, 3086438952u, 3222702171u, 1985550349u, 0, LOG10_TOLERANCE, 0},
{ 393, 1059518664u, 1778008540u, 1049064687u, 73581647u, 3222146286u, 3204633369u, 0, LOG10_TOLERANCE, 0},
{ 394, 1099249950u, 233240285u, 1081923320u, 2710903921u, 1075746816u, 1726081546u, 0, LOG10_TOLERANCE, 0},
{ 395, 1069513767u, 3719878805u, 1079866720u, 3615458228u, 3219988438u, 2477635424u, 0, LOG10_TOLERANCE, 0},
{ 396, 1073711076u, 3647632375u, 3247225271u, 3839959621u, 1070783226u, 4149591050u, 0, LOG10_TOLERANCE, 0},
{ 397, 1103401096u, 2232210456u, 3235434773u, 224271737u, 1075948928u, 1471690445u, 0, LOG10_TOLERANCE, 0},
{ 398, 1045520036u, 2134662911u, 3190390590u, 4239009051u, 3223267864u, 491395740u, 0, LOG10_TOLERANCE, 0},
{ 399, 1080526145u, 2305279897u, 1077668039u, 1854523320u, 1073885760u, 2209376105u, 0, LOG10_TOLERANCE, 0},
{ 400, 1072380611u, 538224650u, 3206153057u, 1379649610u, 3216110261u, 736404255u, 0, LOG10_TOLERANCE, 0},
{ 401, 1048926859u, 3683897920u, 3244167599u, 3647579469u, 3223007615u, 885924102u, 0, LOG10_TOLERANCE, 0},
{ 402, 1090280933u, 2694093608u, 1042775347u, 598406111u, 1075069627u, 4045261099u, 0, LOG10_TOLERANCE, 0},
{ 403, 1064151744u, 872706833u, 1084802480u, 2200602798u, 3221456744u, 108068407u, 0, LOG10_TOLERANCE, 0},
{ 404, 1042339597u, 904146293u, 1060867322u, 1729685598u, 3223415376u, 2814323454u, 0, LOG10_TOLERANCE, 0},
{ 405, 1048211322u, 1894173462u, 3232800651u, 191960416u, 3223062224u, 158689847u, 0, LOG10_TOLERANCE, 0},
{ 406, 1091225343u, 3521028551u, 1054522089u, 3287274359u, 1075141976u, 1561613401u, 0, LOG10_TOLERANCE, 0},
{ 407, 1095386964u, 959640601u, 3201578263u, 4136915018u, 1075455488u, 3662783481u, 0, LOG10_TOLERANCE, 0},
{ 408, 1064005451u, 1553716379u, 1106027987u, 984725765u, 3221474555u, 2065254288u, 0, LOG10_TOLERANCE, 0},
{ 409, 1091348993u, 2287646644u, 3240329321u, 2276183378u, 1075149728u, 564081412u, 0, LOG10_TOLERANCE, 0},
{ 410, 1068209174u, 3940225170u, 3199544434u, 997572161u, 3220458648u, 326066716u, 0, LOG10_TOLERANCE, 0},
{ 411, 1065284713u, 36116288u, 3206886566u, 4196602670u, 3221289242u, 3024728349u, 0, LOG10_TOLERANCE, 0},
{ 412, 1094212205u, 3550227562u, 3207257983u, 2747744117u, 1075367912u, 3605299668u, 0, LOG10_TOLERANCE, 0},
{ 413, 1104236126u, 507130047u, 1048359321u, 3229888373u, 1075978565u, 76478367u, 0, LOG10_TOLERANCE, 0},
{ 414, 1075513130u, 2210969014u, 1081031001u, 1946786091u, 1072336215u, 3594780710u, 0, LOG10_TOLERANCE, 0},
{ 415, 1088823342u, 4059150589u, 3189759234u, 1177045799u, 1074962426u, 203192711u, 0, LOG10_TOLERANCE, 0},
{ 416, 1093103612u, 2664812822u, 1050343198u, 2034180320u, 1075284635u, 3784608382u, 0, LOG10_TOLERANCE, 0},
{ 417, 1066295469u, 1175750283u, 3235559706u, 1424491340u, 3221045930u, 2066830035u, 0, LOG10_TOLERANCE, 0},
{ 418, 1066420545u, 1630036121u, 3231972785u, 3195479448u, 3221014164u, 1961979416u, 0, LOG10_TOLERANCE, 0},
{ 419, 1090429875u, 2527029044u, 1046927050u, 4000723255u, 1075078402u, 674977703u, 0, LOG10_TOLERANCE, 0},
{ 420, 1085208677u, 3335703647u, 3237349676u, 3869440059u, 1074579717u, 3053034379u, 0, LOG10_TOLERANCE, 0},
{ 421, 1091433848u, 3888398377u, 3196041693u, 1290567220u, 1075154757u, 4288752120u, 0, LOG10_TOLERANCE, 0},
{ 422, 1066679070u, 3242451480u, 3248384948u, 707431021u, 3220915391u, 1002013526u, 0, LOG10_TOLERANCE, 0},
{ 423, 1083230509u, 2739665123u, 1060777905u, 1733073225u, 1074282429u, 2639675714u, 0, LOG10_TOLERANCE, 0},
{ 424, 1078517061u, 1297274853u, 3208848704u, 3341639139u, 1073423693u, 1229342814u, 0, LOG10_TOLERANCE, 0},
{ 425, 1046570941u, 2228057309u, 1084318902u, 1317851136u, 3223188718u, 923854032u, 0, LOG10_TOLERANCE, 0},
{ 426, 1088255327u, 270039934u, 3241414679u, 3063626339u, 1074916100u, 3232618583u, 0, LOG10_TOLERANCE, 0},
{ 427, 1071694702u, 83062251u, 3211262173u, 2659016437u, 3218208877u, 4113528378u, 0, LOG10_TOLERANCE, 0},
{ 428, 1095743886u, 3833539373u, 3206667189u, 1567476111u, 1075476931u, 1567233076u, 0, LOG10_TOLERANCE, 0},
{ 429, 1057711424u, 2382776852u, 3249232579u, 1546622468u, 3222347943u, 3798670522u, 0, LOG10_TOLERANCE, 0},
{ 430, 1085536439u, 1714300821u, 1104130938u, 4167591598u, 1074637649u, 2509717948u, 0, LOG10_TOLERANCE, 0},
{ 431, 1051092760u, 2798720100u, 1086978789u, 449990704u, 3222844328u, 4037397167u, 0, LOG10_TOLERANCE, 0},
{ 432, 1083714767u, 4039516226u, 3244344107u, 4272932619u, 1074365489u, 1649510185u, 0, LOG10_TOLERANCE, 0},
{ 433, 1075224793u, 1683007544u, 1091105663u, 3805494321u, 1072174396u, 1609044821u, 0, LOG10_TOLERANCE, 0},
{ 434, 1073369300u, 2072627412u, 1094383324u, 3394151662u, 1070311685u, 2675194563u, 0, LOG10_TOLERANCE, 0},
{ 435, 1073086376u, 1120106427u, 3223631624u, 3404608264u, 1069658889u, 1776899808u, 0, LOG10_TOLERANCE, 0},
{ 436, 1097859997u, 559918757u, 3205077053u, 908100198u, 1075635841u, 1601462731u, 0, LOG10_TOLERANCE, 0},
{ 437, 1042677918u, 2026673913u, 3244833635u, 2844573214u, 3223400155u, 2734047538u, 0, LOG10_TOLERANCE, 0},
{ 438, 1107083611u, 3946837259u, 3234993796u, 3850406820u, 1076086381u, 4256303931u, 0, LOG10_TOLERANCE, 0},
{ 439, 1057479809u, 3139330994u, 1046133568u, 1539650690u, 3222363668u, 1863422807u, 0, LOG10_TOLERANCE, 0},
{ 440, 1089221852u, 1554593884u, 3228899878u, 2813752562u, 1074990069u, 2444290568u, 0, LOG10_TOLERANCE, 0},
{ 441, 1056505004u, 3804703138u, 1072931071u, 2053677923u, 3222437333u, 3070337480u, 0, LOG10_TOLERANCE, 0},
{ 442, 1097380651u, 289355864u, 1078453818u, 2143066338u, 1075606261u, 2210278777u, 0, LOG10_TOLERANCE, 0},
{ 443, 1056456232u, 2157691971u, 1106629150u, 110806409u, 3222440776u, 214047711u, 0, LOG10_TOLERANCE, 0},
{ 444, 1082157019u, 3570399481u, 1085637605u, 180265334u, 1074119387u, 950389812u, 0, LOG10_TOLERANCE, 0},
{ 445, 1053496534u, 558779875u, 3202046748u, 2338464653u, 3222664909u, 2840504692u, 0, LOG10_TOLERANCE, 0},
{ 446, 1045705464u, 1703969219u, 3229797258u, 1417521063u, 3223250683u, 1044693633u, 0, LOG10_TOLERANCE, 0},
{ 447, 1090298613u, 3917440951u, 1051668894u, 3736066983u, 1075070705u, 2421449516u, 0, LOG10_TOLERANCE, 0},
{ 448, 1064752080u, 3106613409u, 1066627453u, 2735392257u, 3221358590u, 2240418382u, 0, LOG10_TOLERANCE, 0},
{ 449, 1065665372u, 2229777605u, 1065061963u, 2405869925u, 3221219219u, 2002424062u, 0, LOG10_TOLERANCE, 0},
{ 450, 1091979581u, 3967957902u, 1057416138u, 3459188071u, 1075199987u, 4084035947u, 0, LOG10_TOLERANCE, 0},
{ 451, 1068639210u, 3699016825u, 3249713090u, 796144848u, 3220333758u, 815317634u, 0, LOG10_TOLERANCE, 0},
{ 452, 1081332748u, 3285165564u, 3211948811u, 401510871u, 1074004705u, 407550323u, 0, LOG10_TOLERANCE, 0},
{ 453, 1094257658u, 634857910u, 3199607513u, 914218057u, 1075371109u, 3260851721u, 0, LOG10_TOLERANCE, 0},
{ 454, 1083743336u, 2030735578u, 3233855943u, 965677531u, 1074369558u, 2483657024u, 0, LOG10_TOLERANCE, 0},
{ 455, 1079556815u, 3957229084u, 1051050470u, 3123776651u, 1073736874u, 648519445u, 0, LOG10_TOLERANCE, 0},
{ 456, 1074379685u, 162122081u, 3239376395u, 108064594u, 1071660191u, 1605034523u, 0, LOG10_TOLERANCE, 0},
{ 457, 1089788138u, 869031839u, 3225020876u, 1344301606u, 1075034563u, 2621266855u, 0, LOG10_TOLERANCE, 0},
{ 458, 1066949826u, 946696117u, 3231825228u, 1700703647u, 3220830768u, 223570193u, 0, LOG10_TOLERANCE, 0},
{ 459, 1075492875u, 3394168074u, 1076939786u, 1666995668u, 1072325741u, 565674172u, 0, LOG10_TOLERANCE, 0},
{ 460, 1061291147u, 2488789804u, 3238508333u, 1506943664u, 3221885943u, 1809033126u, 0, LOG10_TOLERANCE, 0},
{ 461, 1072788663u, 3844072288u, 3202592279u, 2630019853u, 1067670922u, 1855635741u, 0, LOG10_TOLERANCE, 0},
{ 462, 1072450894u, 1244307192u, 3191297711u, 2540916692u, 3215675005u, 4195715816u, 0, LOG10_TOLERANCE, 0},
{ 463, 1052579044u, 2871645739u, 3239081581u, 1440249115u, 3222735710u, 695871118u, 0, LOG10_TOLERANCE, 0},
{ 464, 1068350633u, 1231934926u, 3236746788u, 603977748u, 3220424332u, 277989641u, 0, LOG10_TOLERANCE, 0},
{ 465, 1047966041u, 2386312545u, 1063169277u, 2715234268u, 3223079604u, 49370105u, 0, LOG10_TOLERANCE, 0},
{ 466, 1087803418u, 915867083u, 1046790892u, 3347417612u, 1074885740u, 1843751208u, 0, LOG10_TOLERANCE, 0},
{ 467, 1105984188u, 3553288373u, 1065698616u, 2906680663u, 1076045368u, 1668255753u, 0, LOG10_TOLERANCE, 0},
{ 468, 1045506226u, 2342364630u, 1051356723u, 4019093203u, 3223269253u, 3098172626u, 0, LOG10_TOLERANCE, 0},
{ 469, 1053685514u, 2911548084u, 1105282515u, 2476735795u, 3222653390u, 710736245u, 0, LOG10_TOLERANCE, 0},
{ 470, 1050472772u, 1836216409u, 1101062307u, 2519592554u, 3222894082u, 2911135348u, 0, LOG10_TOLERANCE, 0},
{ 471, 1070178161u, 1235369496u, 3222946447u, 668087854u, 3219544778u, 3191775902u, 0, LOG10_TOLERANCE, 0},
{ 472, 1061070948u, 2981820811u, 1059838516u, 2845580478u, 3221922743u, 556163093u, 0, LOG10_TOLERANCE, 0},
{ 473, 1046447766u, 1565550570u, 3217165795u, 4162017137u, 3223200002u, 563369286u, 0, LOG10_TOLERANCE, 0},
{ 474, 1089767730u, 2808968027u, 1055630096u, 1782326814u, 1075032850u, 1073708672u, 0, LOG10_TOLERANCE, 0},
{ 475, 1053576974u, 1492622658u, 3216653077u, 3972512122u, 3222659863u, 923354108u, 0, LOG10_TOLERANCE, 0},
{ 476, 1074688031u, 2722693603u, 3227814791u, 3169731970u, 1071813127u, 2479854561u, 0, LOG10_TOLERANCE, 0},
{ 477, 1070422983u, 899763203u, 3207606001u, 2804747833u, 3219420822u, 1438062981u, 0, LOG10_TOLERANCE, 0},
{ 478, 1083186677u, 3789058912u, 3228095081u, 4135937628u, 1074273171u, 2472968060u, 0, LOG10_TOLERANCE, 0},
{ 479, 1060199382u, 1682808307u, 3206960335u, 232877759u, 3222052254u, 477899392u, 0, LOG10_TOLERANCE, 0},
{ 480, 1094607838u, 2851963139u, 3246852961u, 2590862592u, 1075393124u, 3038195584u, 0, LOG10_TOLERANCE, 0},
{ 481, 1081200406u, 2422232642u, 3234779662u, 290458310u, 1073980248u, 710172697u, 0, LOG10_TOLERANCE, 0},
{ 482, 1063187430u, 1082582386u, 1075605675u, 2602133689u, 3221604910u, 899954685u, 0, LOG10_TOLERANCE, 0},
{ 483, 1092334963u, 1789635787u, 1059414278u, 1048286093u, 1075224782u, 1925305273u, 0, LOG10_TOLERANCE, 0},
{ 484, 1098330542u, 231339448u, 1055573265u, 504907415u, 1075678013u, 2077150613u, 0, LOG10_TOLERANCE, 0},
{ 485, 1063211461u, 1153251200u, 3204617090u, 1772013857u, 3221602228u, 2787459030u, 0, LOG10_TOLERANCE, 0},
{ 486, 1099551055u, 1082898276u, 3212089272u, 1449080862u, 1075769126u, 2974900830u, 0, LOG10_TOLERANCE, 0},
{ 487, 1086008285u, 3177299045u, 1058862813u, 809400815u, 1074707746u, 2728274629u, 0, LOG10_TOLERANCE, 0},
{ 488, 1083370902u, 1924429710u, 1056464743u, 3349283177u, 1074309778u, 406273308u, 0, LOG10_TOLERANCE, 0},
{ 489, 1097989743u, 42238036u, 1042379500u, 2113559863u, 1075649111u, 2547563809u, 0, LOG10_TOLERANCE, 0},
{ 490, 1064761243u, 3304403230u, 3217556703u, 58952646u, 3221357200u, 642692340u, 0, LOG10_TOLERANCE, 0},
{ 491, 1065185882u, 1645486982u, 3224301095u, 3636267471u, 3221300614u, 3261785592u, 0, LOG10_TOLERANCE, 0},
{ 492, 1062762009u, 619402181u, 3235208235u, 557360557u, 3221658502u, 1916272264u, 0, LOG10_TOLERANCE, 0},
{ 493, 1090754746u, 110029735u, 1046937383u, 984375729u, 1075106433u, 221145856u, 0, LOG10_TOLERANCE, 0},
{ 494, 1042013090u, 4063688092u, 3203235744u, 1049950343u, 3223426180u, 584482441u, 0, LOG10_TOLERANCE, 0},
{ 495, 1062350619u, 650996069u, 1054971928u, 3953359826u, 3221726025u, 2801498591u, 0, LOG10_TOLERANCE, 0},
{ 496, 1079572157u, 66926332u, 1090561839u, 1379780888u, 1073741164u, 2195643118u, 0, LOG10_TOLERANCE, 0},
{ 497, 1085969659u, 2803378256u, 1086057989u, 498534626u, 1074702753u, 971413916u, 0, LOG10_TOLERANCE, 0},
{ 498, 1082618553u, 2846400785u, 1047142525u, 1375153550u, 1074200711u, 2221073810u, 0, LOG10_TOLERANCE, 0},
{ 499, 1044581201u, 2869128958u, 1070972315u, 4246440273u, 3223329461u, 2601691166u, 0, LOG10_TOLERANCE, 0},
{ 500, 1051832506u, 3112381207u, 1044430965u, 3981604561u, 3222792302u, 1546587034u, 0, LOG10_TOLERANCE, 0},
{ 501, 1083771349u, 243303420u, 1093735824u, 1575581926u, 1074373479u, 837776877u, 0, LOG10_TOLERANCE, 0},
{ 502, 1091654349u, 3218865041u, 3204803496u, 3840388050u, 1075171309u, 2088865965u, 0, LOG10_TOLERANCE, 0},
{ 503, 1048415431u, 336846959u, 1052664471u, 3798336786u, 3223049544u, 1357585448u, 0, LOG10_TOLERANCE, 0},
{ 504, 1055954236u, 3639240976u, 1081202165u, 1844741676u, 3222484009u, 242301978u, 0, LOG10_TOLERANCE, 0},
{ 505, 1064421145u, 717293069u, 3211534283u, 582401011u, 3221415517u, 3660346947u, 0, LOG10_TOLERANCE, 0},
{ 506, 1104478864u, 3766248610u, 3196520332u, 1174437546u, 1075989604u, 3365688656u, 0, LOG10_TOLERANCE, 0},
{ 507, 1083431226u, 756959182u, 3204099341u, 1581804034u, 1074320590u, 199117646u, 0, LOG10_TOLERANCE, 0},
{ 508, 1058322796u, 3560686300u, 3220980617u, 4277975772u, 3222300802u, 1449948266u, 0, LOG10_TOLERANCE, 0},
{ 509, 1062422428u, 2598148853u, 3217622194u, 3460421008u, 3221712702u, 3246720810u, 0, LOG10_TOLERANCE, 0},
{ 510, 1066720824u, 136600515u, 3209934920u, 3340653128u, 3220901271u, 1853785686u, 0, LOG10_TOLERANCE, 0},
{ 511, 1096820310u, 1045480938u, 3251354609u, 4133432965u, 1075557888u, 1620985468u, 0, LOG10_TOLERANCE, 0},
{ 512, 1091599431u, 1630207738u, 3239996829u, 2393354808u, 1075165664u, 2887122802u, 0, LOG10_TOLERANCE, 0},
{ 513, 1043142370u, 3739770117u, 1059520750u, 3959551225u, 3223384261u, 1189792801u, 0, LOG10_TOLERANCE, 0},
{ 514, 1083246857u, 1498861716u, 1091297147u, 847410798u, 1074285788u, 1667361171u, 0, LOG10_TOLERANCE, 0},
{ 515, 1073516688u, 983275314u, 3232538664u, 2244973629u, 1070603266u, 4232028352u, 0, LOG10_TOLERANCE, 0},
{ 516, 1054849265u, 2353103845u, 3235718771u, 2978889966u, 3222567988u, 1423369271u, 0, LOG10_TOLERANCE, 0},
{ 517, 1103874344u, 1546972125u, 3249076079u, 1987349196u, 1075966059u, 3386502820u, 0, LOG10_TOLERANCE, 0},
{ 518, 1090735865u, 2769161072u, 1075207126u, 292616282u, 1075104746u, 4031801740u, 0, LOG10_TOLERANCE, 0},
{ 519, 1052228650u, 36855311u, 1052128202u, 1479039342u, 3222758838u, 3692631126u, 0, LOG10_TOLERANCE, 0},
{ 520, 1083757053u, 2027463605u, 1066023013u, 3369686340u, 1074371486u, 3578986915u, 0, LOG10_TOLERANCE, 0},
{ 521, 1050369101u, 3808681655u, 1054161346u, 1821773119u, 3222900481u, 2925260558u, 0, LOG10_TOLERANCE, 0},
{ 522, 1040685928u, 3175490326u, 3226879970u, 845687760u, 3223475061u, 3266495528u, 0, LOG10_TOLERANCE, 0},
{ 523, 1042302993u, 3124482451u, 3242748377u, 3259417226u, 3223417296u, 2734516734u, 0, LOG10_TOLERANCE, 0},
{ 524, 1045245695u, 2751606436u, 3236210939u, 3923142740u, 3223287704u, 455537501u, 0, LOG10_TOLERANCE, 0},
{ 525, 1095694737u, 2016872044u, 3228408064u, 4201274408u, 1075474207u, 3162419511u, 0, LOG10_TOLERANCE, 0},
{ 526, 1051865606u, 1019916843u, 3219974785u, 1977881787u, 3222789097u, 2356936620u, 0, LOG10_TOLERANCE, 0},
{ 527, 1051995104u, 2060433318u, 1075872515u, 366073725u, 3222777360u, 1207606903u, 0, LOG10_TOLERANCE, 0},
{ 528, 1043696909u, 1098469906u, 1082900695u, 2349346832u, 3223361879u, 497752621u, 0, LOG10_TOLERANCE, 0},
{ 529, 1062491059u, 3011196295u, 3252479932u, 2459281672u, 3221700659u, 485236026u, 0, LOG10_TOLERANCE, 0},
{ 530, 1073850675u, 2843222682u, 1089275809u, 298982001u, 1070990041u, 2392858765u, 0, LOG10_TOLERANCE, 0},
{ 531, 1101737698u, 914741728u, 3203468059u, 2833809843u, 1075885898u, 1722473944u, 0, LOG10_TOLERANCE, 0},
{ 532, 1089280230u, 1274901962u, 3241535845u, 3759113509u, 1074993609u, 1453359696u, 0, LOG10_TOLERANCE, 0},
{ 533, 1098432794u, 2134927252u, 3253802671u, 3013731444u, 1075685425u, 1495574294u, 0, LOG10_TOLERANCE, 0},
{ 534, 1099201341u, 2230655177u, 3254510616u, 1249674366u, 1075742766u, 1948328827u, 0, LOG10_TOLERANCE, 0},
{ 535, 1062971253u, 717357389u, 1083533731u, 3746683362u, 3221630568u, 1379621049u, 0, LOG10_TOLERANCE, 0},
{ 536, 1066289466u, 834976849u, 3217357661u, 2465861779u, 3221047305u, 3116620001u, 0, LOG10_TOLERANCE, 0},
{ 537, 1045656117u, 1385714428u, 1053358395u, 3007113740u, 3223255008u, 1510643247u, 0, LOG10_TOLERANCE, 0},
{ 538, 1050527919u, 599268545u, 3201368210u, 2309854744u, 3222890819u, 3769637076u, 0, LOG10_TOLERANCE, 0},
{ 539, 1069954454u, 2840234388u, 3232496515u, 333365983u, 3219674994u, 294990716u, 0, LOG10_TOLERANCE, 0},
{ 540, 1045922781u, 3136078996u, 3194520860u, 2650572904u, 3223233377u, 3702336467u, 0, LOG10_TOLERANCE, 0},
{ 541, 1086204043u, 2405805086u, 3251640319u, 324233833u, 1074731495u, 762641516u, 0, LOG10_TOLERANCE, 0},
{ 542, 1106699146u, 2589598340u, 3254677807u, 952438812u, 1076073393u, 2118848003u, 0, LOG10_TOLERANCE, 0},
{ 543, 1041631125u, 1922837702u, 3216892718u, 3535907549u, 3223439541u, 3853212535u, 0, LOG10_TOLERANCE, 0},
{ 544, 1096132220u, 261447440u, 3209805849u, 1150571079u, 1075512345u, 3192258124u, 0, LOG10_TOLERANCE, 0},
{ 545, 1095805232u, 4026487528u, 1073152064u, 27340691u, 1075482522u, 2878242110u, 0, LOG10_TOLERANCE, 0},
{ 546, 1081640044u, 338765118u, 1086225786u, 3207238249u, 1074053037u, 1071781049u, 0, LOG10_TOLERANCE, 0},
{ 547, 1048699055u, 1085283176u, 3187775111u, 1601194210u, 3223027842u, 3327204206u, 0, LOG10_TOLERANCE, 0},
{ 548, 1091520173u, 3031712790u, 3252307859u, 170666844u, 1075159656u, 2834005504u, 0, LOG10_TOLERANCE, 0},
{ 549, 1071378583u, 3148395674u, 1041913758u, 3306391490u, 3218540934u, 3229024431u, 0, LOG10_TOLERANCE, 0},
{ 550, 1053793422u, 2205233857u, 3208100078u, 3993195511u, 3222647300u, 823279676u, 0, LOG10_TOLERANCE, 0},
{ 551, 1067699608u, 4282766727u, 1072820377u, 1874778218u, 3220609471u, 3451929701u, 0, LOG10_TOLERANCE, 0},
{ 552, 1063349444u, 2920860798u, 3218070226u, 3104066154u, 3221577909u, 33368404u, 0, LOG10_TOLERANCE, 0},
{ 553, 1057466703u, 969991373u, 3250596895u, 1734386152u, 3222364626u, 2782202392u, 0, LOG10_TOLERANCE, 0},
{ 554, 1091432170u, 1218740205u, 3239802737u, 2610078504u, 1075154660u, 2668667873u, 0, LOG10_TOLERANCE, 0},
{ 555, 1058547594u, 1485218325u, 3220870240u, 3591664613u, 3222283365u, 1294019716u, 0, LOG10_TOLERANCE, 0},
{ 556, 1054590495u, 690157417u, 3190850619u, 4192347699u, 3222583121u, 3272158420u, 0, LOG10_TOLERANCE, 0},
{ 557, 1096053810u, 4009839784u, 1079670252u, 394167192u, 1075505873u, 3602829947u, 0, LOG10_TOLERANCE, 0},
{ 558, 1087075589u, 961532417u, 1092588071u, 2923790239u, 1074829177u, 2571444864u, 0, LOG10_TOLERANCE, 0},
{ 559, 1056395443u, 4174125604u, 1050682630u, 2169701868u, 3222445217u, 2242909506u, 0, LOG10_TOLERANCE, 0},
{ 560, 1095608827u, 4146748230u, 1087373950u, 2481478351u, 1075469284u, 3055706006u, 0, LOG10_TOLERANCE, 0},
{ 561, 1076987866u, 3984715440u, 1050421618u, 2446142566u, 1072948889u, 2762932455u, 0, LOG10_TOLERANCE, 0},
{ 562, 1084172406u, 936290150u, 1100614426u, 3625806370u, 1074423267u, 2079190709u, 0, LOG10_TOLERANCE, 0},
{ 563, 1099787952u, 1866615265u, 3215651428u, 2337013350u, 1075784045u, 474803698u, 0, LOG10_TOLERANCE, 0},
{ 564, 1105714654u, 712227971u, 1106004723u, 973148499u, 1076036318u, 989663135u, 0, LOG10_TOLERANCE, 0},
{ 565, 1082604551u, 3409813738u, 3244817008u, 1933503498u, 1074198627u, 1392248798u, 0, LOG10_TOLERANCE, 0},
{ 566, 1079943733u, 3180389060u, 3228735703u, 83422217u, 1073788096u, 3723549429u, 0, LOG10_TOLERANCE, 0},
{ 567, 1077878724u, 556972671u, 3204582372u, 841555801u, 1073210297u, 1176943375u, 0, LOG10_TOLERANCE, 0},
{ 568, 1070767721u, 4189151332u, 1080874032u, 706326922u, 3219204296u, 8534901u, 0, LOG10_TOLERANCE, 0},
{ 569, 1096151307u, 198291836u, 1057281892u, 2188836928u, 1075513867u, 146400103u, 0, LOG10_TOLERANCE, 0},
{ 570, 1078091995u, 1219449298u, 3228734687u, 3504562743u, 1073286046u, 864376040u, 0, LOG10_TOLERANCE, 0},
{ 571, 1057086816u, 1776099219u, 1094316777u, 4188083896u, 3222396619u, 1866278910u, 0, LOG10_TOLERANCE, 0},
{ 572, 1046362060u, 2614400266u, 1073750227u, 3003203347u, 3223204825u, 2440192588u, 0, LOG10_TOLERANCE, 0},
{ 573, 1066499030u, 2959351406u, 1105603716u, 311851587u, 3220981851u, 2668005317u, 0, LOG10_TOLERANCE, 0},
{ 574, 1084544434u, 865443613u, 1097532516u, 3622237781u, 1074489457u, 3357453183u, 0, LOG10_TOLERANCE, 0},
{ 575, 1084303018u, 447506102u, 3195759295u, 3603669725u, 1074445156u, 2084524296u, 0, LOG10_TOLERANCE, 0},
{ 576, 1097890173u, 3934398273u, 1040996422u, 2968621268u, 1075639068u, 3042123355u, 0, LOG10_TOLERANCE, 0},
{ 577, 1049256177u, 784208771u, 1088764788u, 2182296421u, 3222983555u, 2711242300u, 0, LOG10_TOLERANCE, 0},
{ 578, 1100848643u, 1527590526u, 3206961556u, 2823164069u, 1075851323u, 2440914413u, 0, LOG10_TOLERANCE, 0},
{ 579, 1089160483u, 3876699591u, 3207481130u, 4028148535u, 1074986225u, 3667748993u, 0, LOG10_TOLERANCE, 0},
{ 580, 1083576186u, 2164249756u, 1059857743u, 1785169952u, 1074344647u, 2189652330u, 0, LOG10_TOLERANCE, 0},
{ 581, 1091804009u, 2079273665u, 1080303860u, 625760474u, 1075185407u, 788005775u, 0, LOG10_TOLERANCE, 0},
{ 582, 1079002460u, 3636214836u, 1068367620u, 2932621925u, 1073546236u, 450535769u, 0, LOG10_TOLERANCE, 0},
{ 583, 1043995372u, 4274131512u, 1047707755u, 92550763u, 3223350966u, 501020710u, 0, LOG10_TOLERANCE, 0},
{ 584, 1051338473u, 2648933384u, 1084603503u, 3534304873u, 3222826711u, 3279110674u, 0, LOG10_TOLERANCE, 0},
{ 585, 1064563235u, 3216750767u, 3191088629u, 547482628u, 3221389315u, 3385302547u, 0, LOG10_TOLERANCE, 0},
{ 586, 1061084774u, 1420360746u, 1080063101u, 1690029499u, 3221921181u, 2909345809u, 0, LOG10_TOLERANCE, 0},
{ 587, 1082371716u, 1908572179u, 1080112083u, 1228319033u, 1074160841u, 2860344817u, 0, LOG10_TOLERANCE, 0},
{ 588, 1048158178u, 500312015u, 3212368508u, 3864619086u, 3223065771u, 190787676u, 0, LOG10_TOLERANCE, 0},
{ 589, 1073851962u, 4211343447u, 1087492676u, 4272583781u, 1070992066u, 1791098782u, 0, LOG10_TOLERANCE, 0},
{ 590, 1099392394u, 2382118000u, 1042665328u, 567154882u, 1075757916u, 3223125935u, 0, LOG10_TOLERANCE, 0},
{ 591, 1058013442u, 1435344339u, 3216303171u, 2275988178u, 3222330228u, 3675387000u, 0, LOG10_TOLERANCE, 0},
{ 592, 1067054971u, 3403659753u, 3218043030u, 1926480488u, 3220801724u, 1053622215u, 0, LOG10_TOLERANCE, 0},
{ 593, 1076840383u, 1198845185u, 3225556149u, 1130089684u, 1072896923u, 3494913394u, 0, LOG10_TOLERANCE, 0},
{ 594, 1075179394u, 2183928090u, 1048403956u, 963834821u, 1072146078u, 1987142843u, 0, LOG10_TOLERANCE, 0},
{ 595, 1101672960u, 2120625396u, 1041006976u, 2137548527u, 1075883791u, 1290867319u, 0, LOG10_TOLERANCE, 0},
{ 596, 1099230238u, 586700956u, 1059670521u, 303891699u, 1075745191u, 1621757249u, 0, LOG10_TOLERANCE, 0},
{ 597, 1071510850u, 2509132460u, 1102827530u, 2205707903u, 3218413889u, 1739137714u, 0, LOG10_TOLERANCE, 0},
{ 598, 1057376949u, 1229308263u, 3209170414u, 4206576047u, 3222371414u, 2709365139u, 0, LOG10_TOLERANCE, 0},
{ 599, 1076592641u, 4078010749u, 3199236456u, 733478972u, 1072838269u, 1643379297u, 0, LOG10_TOLERANCE, 0},
{ 600, 1050228936u, 4277541051u, 3199806921u, 397102023u, 3222909748u, 524666777u, 0, LOG10_TOLERANCE, 0},
{ 601, 1048491365u, 900999594u, 3234720188u, 2530214248u, 3223045165u, 2583905845u, 0, LOG10_TOLERANCE, 0},
{ 602, 1076543548u, 4000609478u, 1096577064u, 4148592328u, 1072825692u, 1999101770u, 0, LOG10_TOLERANCE, 0},
{ 603, 1048668084u, 2154187873u, 3224392607u, 3957250362u, 3223030892u, 3009591096u, 0, LOG10_TOLERANCE, 0},
{ 604, 1075929840u, 2867079200u, 1101870326u, 921212001u, 1072565702u, 4157771188u, 0, LOG10_TOLERANCE, 0},
{ 605, 1085738242u, 674547716u, 1063216239u, 3929755226u, 1074670299u, 1605339823u, 0, LOG10_TOLERANCE, 0},
{ 606, 1092932203u, 3158182449u, 1043794244u, 3259056345u, 1075271164u, 2647804578u, 0, LOG10_TOLERANCE, 0},
{ 607, 1089293008u, 3002823940u, 1059511739u, 2832435794u, 1074994369u, 2987286299u, 0, LOG10_TOLERANCE, 0},
{ 608, 1069821174u, 2196511929u, 1049973941u, 3672092877u, 3219762462u, 2310326603u, 0, LOG10_TOLERANCE, 0},
{ 609, 1050438056u, 3655292191u, 1086438127u, 3567072906u, 3222896185u, 2892109320u, 0, LOG10_TOLERANCE, 0},
{ 610, 1095703300u, 1617573614u, 3201863123u, 3090723732u, 1075474686u, 4138813458u, 0, LOG10_TOLERANCE, 0},
{ 611, 1085717732u, 679893506u, 3211547753u, 824081024u, 1074667186u, 3466673869u, 0, LOG10_TOLERANCE, 0},
{ 612, 1089530525u, 2285242807u, 1084999409u, 2221731406u, 1075010776u, 2105373250u, 0, LOG10_TOLERANCE, 0},
{ 613, 1059250016u, 1935990727u, 1088822246u, 1058156518u, 3222191042u, 824662780u, 0, LOG10_TOLERANCE, 0},
{ 614, 1102839166u, 521023584u, 1059186903u, 4245163857u, 1075927020u, 2012019887u, 0, LOG10_TOLERANCE, 0},
{ 615, 1103891140u, 2312887617u, 3191771354u, 1885370807u, 1075966582u, 1863110785u, 0, LOG10_TOLERANCE, 0},
{ 616, 1105470167u, 1796441468u, 1100030327u, 2772711004u, 1076026642u, 4097068227u, 0, LOG10_TOLERANCE, 0},
{ 617, 1056793172u, 2095685003u, 1077984448u, 2100773742u, 3222418879u, 1210777557u, 0, LOG10_TOLERANCE, 0},
{ 618, 1045470972u, 2892538035u, 1042396334u, 4162200338u, 3223272879u, 4179986377u, 0, LOG10_TOLERANCE, 0},
{ 619, 1095242103u, 2177698116u, 3227557177u, 150832500u, 1075445485u, 3509591170u, 0, LOG10_TOLERANCE, 0},
{ 620, 1044078568u, 607966734u, 3236250630u, 4164600559u, 3223348263u, 823364156u, 0, LOG10_TOLERANCE, 0},
{ 621, 1068906164u, 2830122967u, 1046096700u, 3713346883u, 3220241508u, 1678342095u, 0, LOG10_TOLERANCE, 0},
{ 622, 1089714315u, 2314640506u, 3203696416u, 3276228872u, 1075028239u, 2744643937u, 0, LOG10_TOLERANCE, 0},
{ 623, 1065428659u, 469331883u, 3249037349u, 2999233437u, 3221265861u, 640249239u, 0, LOG10_TOLERANCE, 0},
{ 624, 1097382011u, 560886625u, 1091899487u, 748795120u, 1075606357u, 556919058u, 0, LOG10_TOLERANCE, 0},
{ 625, 1049886858u, 2958421324u, 1092569414u, 3235243477u, 3222936146u, 574940066u, 0, LOG10_TOLERANCE, 0},
{ 626, 1045542849u, 3221475559u, 1043038304u, 915608434u, 3223265605u, 331939149u, 0, LOG10_TOLERANCE, 0},
{ 627, 1071197530u, 3007808652u, 3216682290u, 2531019474u, 3218730587u, 1453925889u, 0, LOG10_TOLERANCE, 0},
{ 628, 1094545351u, 1767658578u, 3237045269u, 2313128318u, 1075389495u, 2316745533u, 0, LOG10_TOLERANCE, 0},
{ 629, 1063134244u, 1926845182u, 1066835624u, 1783256828u, 3221610959u, 3534398567u, 0, LOG10_TOLERANCE, 0},
{ 630, 1040575629u, 90378038u, 1057168870u, 164358218u, 3223479272u, 72744237u, 0, LOG10_TOLERANCE, 0},
{ 631, 1106859172u, 1610524680u, 1085283851u, 2903496007u, 1076079163u, 2555703719u, 0, LOG10_TOLERANCE, 0},
{ 632, 1078635586u, 4274321404u, 3202913591u, 720121831u, 1073455667u, 3464371112u, 0, LOG10_TOLERANCE, 0},
{ 633, 1051205256u, 2034778236u, 1071133763u, 1413236391u, 3222835923u, 3048532228u, 0, LOG10_TOLERANCE, 0},
{ 634, 1051063028u, 1489112261u, 1076691395u, 348210906u, 3222846658u, 610090266u, 0, LOG10_TOLERANCE, 0},
{ 635, 1059260269u, 2797651324u, 3224410527u, 2374818327u, 3222189162u, 1735176885u, 0, LOG10_TOLERANCE, 0},
{ 636, 1088287256u, 1823161666u, 3197810695u, 3119680047u, 1074917968u, 1025128902u, 0, LOG10_TOLERANCE, 0},
{ 637, 1065927336u, 3420950657u, 1087084743u, 2136638961u, 3221139040u, 2173692258u, 0, LOG10_TOLERANCE, 0},
{ 638, 1069902224u, 3554566429u, 1062907717u, 2736702589u, 3219708277u, 2349339026u, 0, LOG10_TOLERANCE, 0},
{ 639, 1097405019u, 2928437580u, 3187765027u, 1393427873u, 1075607962u, 2671382925u, 0, LOG10_TOLERANCE, 0},
{ 640, 1061817913u, 189447067u, 1051643315u, 828663513u, 3221801952u, 2742751743u, 0, LOG10_TOLERANCE, 0},
{ 641, 1052313869u, 2852350928u, 1045683757u, 673354280u, 3222752766u, 1944632537u, 0, LOG10_TOLERANCE, 0},
{ 642, 1043946301u, 3589563265u, 3248741629u, 812657927u, 3223352622u, 3084641287u, 0, LOG10_TOLERANCE, 0},
{ 643, 1043127178u, 1766416701u, 1100392103u, 2185373290u, 3223384716u, 3136906037u, 0, LOG10_TOLERANCE, 0},
{ 644, 1072791741u, 3763582673u, 3191965790u, 388374829u, 1067710078u, 40508173u, 0, LOG10_TOLERANCE, 0},
{ 645, 1079635136u, 1187403069u, 1075300235u, 336640304u, 1073750094u, 4012674593u, 0, LOG10_TOLERANCE, 0},
{ 646, 1103926251u, 1718795752u, 3243118752u, 683369237u, 1075967659u, 3079243747u, 0, LOG10_TOLERANCE, 0},
{ 647, 1063308449u, 1863545307u, 1069449477u, 3418627399u, 3221586233u, 1729396316u, 0, LOG10_TOLERANCE, 0},
{ 648, 1069601294u, 3295607249u, 1068878592u, 1633297809u, 3219928111u, 215617447u, 0, LOG10_TOLERANCE, 0},
{ 649, 1058947127u, 2585980994u, 3236670483u, 1286750688u, 3222241438u, 2254971432u, 0, LOG10_TOLERANCE, 0},
{ 650, 1046157033u, 15816845u, 3233249283u, 2491924775u, 3223217268u, 270679194u, 0, LOG10_TOLERANCE, 0},
{ 651, 1042413021u, 1051983351u, 1049180786u, 1474421917u, 3223411710u, 809174222u, 0, LOG10_TOLERANCE, 0},
{ 652, 1053765877u, 2003816032u, 1086050104u, 668090487u, 3222648824u, 225843921u, 0, LOG10_TOLERANCE, 0},
{ 653, 1052556037u, 3671484625u, 1067020039u, 430024694u, 3222737092u, 3550051201u, 0, LOG10_TOLERANCE, 0},
{ 654, 1067397110u, 3991830201u, 3207808714u, 1021245839u, 3220718298u, 624955348u, 0, LOG10_TOLERANCE, 0},
{ 655, 1064194391u, 4255801807u, 3207681716u, 1926756877u, 3221451803u, 1956260472u, 0, LOG10_TOLERANCE, 0},
{ 656, 1052140785u, 4167786896u, 1077097744u, 1775517981u, 3222765458u, 1900204384u, 0, LOG10_TOLERANCE, 0},
{ 657, 1085601978u, 3187518564u, 1082437406u, 944672491u, 1074648774u, 3776772173u, 0, LOG10_TOLERANCE, 0},
{ 658, 1049366282u, 953085192u, 3227310828u, 3459155777u, 3222976526u, 745195680u, 0, LOG10_TOLERANCE, 0},
{ 659, 1069502506u, 1908555460u, 1073640207u, 260441967u, 3219993422u, 4145662383u, 0, LOG10_TOLERANCE, 0},
{ 660, 1067219606u, 250762477u, 1072582645u, 2886742039u, 3220759670u, 3957488315u, 0, LOG10_TOLERANCE, 0},
{ 661, 1103422358u, 786180031u, 3197734769u, 2788918312u, 1075949819u, 1564374635u, 0, LOG10_TOLERANCE, 0},
{ 662, 1087028179u, 2055912467u, 3244244909u, 1394142937u, 1074826137u, 3517815416u, 0, LOG10_TOLERANCE, 0},
{ 663, 1069612985u, 91984146u, 3222252812u, 4126276047u, 3219918503u, 912342035u, 0, LOG10_TOLERANCE, 0},
{ 664, 1081340139u, 3942715706u, 3239316352u, 410676547u, 1074005996u, 2222873768u, 0, LOG10_TOLERANCE, 0},
{ 665, 1051074198u, 86296211u, 1085850694u, 649202596u, 3222845777u, 2242599693u, 0, LOG10_TOLERANCE, 0},
{ 666, 1097882744u, 3069064472u, 3237358008u, 23209276u, 1075638282u, 2668333231u, 0, LOG10_TOLERANCE, 0},
{ 667, 1081235288u, 1867297860u, 1072956607u, 2513414118u, 1073986953u, 2486525690u, 0, LOG10_TOLERANCE, 0},
{ 668, 1103049699u, 3171788768u, 3235208783u, 162138697u, 1075933205u, 994967552u, 0, LOG10_TOLERANCE, 0},
{ 669, 1081728455u, 1245110700u, 1081653954u, 2584994077u, 1074065233u, 2141915645u, 0, LOG10_TOLERANCE, 0},
{ 670, 1098026472u, 3347226587u, 1058962932u, 2291943376u, 1075652603u, 2069109495u, 0, LOG10_TOLERANCE, 0},
{ 671, 1058899062u, 966940828u, 1060726420u, 2798041096u, 3222247026u, 3985313909u, 0, LOG10_TOLERANCE, 0},
{ 672, 1072793759u, 2487340727u, 3223786370u, 4105954991u, 1067735688u, 2642613737u, 0, LOG10_TOLERANCE, 0},
{ 673, 1100632849u, 1671039260u, 1086395032u, 3745833360u, 1075844614u, 2953668257u, 0, LOG10_TOLERANCE, 0},
{ 674, 1057078797u, 651714217u, 1047070645u, 2130549237u, 3222397401u, 3928282362u, 0, LOG10_TOLERANCE, 0},
{ 675, 1059632083u, 1423000172u, 3247822717u, 1551488170u, 3222129748u, 947884649u, 0, LOG10_TOLERANCE, 0},
{ 676, 1054113659u, 921077236u, 3213332351u, 1431049019u, 3222617705u, 1746915195u, 0, LOG10_TOLERANCE, 0},
{ 677, 1067510295u, 655715547u, 3190985373u, 1527556471u, 3220681274u, 2767998108u, 0, LOG10_TOLERANCE, 0},
{ 678, 1080171331u, 4110878657u, 3251297180u, 879739345u, 1073826194u, 3666797281u, 0, LOG10_TOLERANCE, 0},
{ 679, 1085804762u, 2623955764u, 1093699897u, 1216444475u, 1074680111u, 1096100139u, 0, LOG10_TOLERANCE, 0},
{ 680, 1091905603u, 107442539u, 3239767031u, 1149813329u, 1075194070u, 876285134u, 0, LOG10_TOLERANCE, 0},
{ 681, 1085961592u, 1761361082u, 3226030205u, 1121849716u, 1074701696u, 1547721169u, 0, LOG10_TOLERANCE, 0},
{ 682, 1092603467u, 2534144722u, 1044223733u, 3512285706u, 1075240482u, 278021464u, 0, LOG10_TOLERANCE, 0},
{ 683, 1064362429u, 4073670723u, 1050729852u, 3034818849u, 3221427291u, 4242826412u, 0, LOG10_TOLERANCE, 0},
{ 684, 1101984574u, 1421423503u, 1060278048u, 1397153092u, 1075893286u, 292685601u, 0, LOG10_TOLERANCE, 0},
{ 685, 1069938181u, 1649206019u, 1104525577u, 1267104290u, 3219685234u, 1620636761u, 0, LOG10_TOLERANCE, 0},
{ 686, 1041818449u, 3775270392u, 1040251850u, 68667319u, 3223432597u, 1692181536u, 0, LOG10_TOLERANCE, 0},
{ 687, 1056847252u, 3099226694u, 3254103006u, 4020102648u, 3222415726u, 634949558u, 0, LOG10_TOLERANCE, 0},
{ 688, 1054108064u, 3718441177u, 3215643451u, 4032951536u, 3222618180u, 2193999680u, 0, LOG10_TOLERANCE, 0},
{ 689, 1044131371u, 508048351u, 3210196713u, 1707937896u, 3223346611u, 4088292437u, 0, LOG10_TOLERANCE, 0},
{ 690, 1051127979u, 2784738160u, 1073435430u, 1109346010u, 3222841630u, 809492040u, 0, LOG10_TOLERANCE, 0},
{ 691, 1078241642u, 3331916473u, 3238794568u, 2707019594u, 1073339378u, 1164696438u, 0, LOG10_TOLERANCE, 0},
{ 692, 1093182670u, 3093165197u, 1072894805u, 2853215019u, 1075290349u, 3560624908u, 0, LOG10_TOLERANCE, 0},
{ 693, 1069098491u, 2135797997u, 1048399559u, 2941926126u, 3220185001u, 2767205362u, 0, LOG10_TOLERANCE, 0},
{ 694, 1048430980u, 2083412145u, 3249335391u, 507212448u, 3223048633u, 3647005715u, 0, LOG10_TOLERANCE, 0},
{ 695, 1075363751u, 4270176401u, 3246546709u, 3288753319u, 1072255974u, 1254607273u, 0, LOG10_TOLERANCE, 0},
{ 696, 1100449215u, 3692175292u, 3197271515u, 3989064196u, 1075837440u, 2247367861u, 0, LOG10_TOLERANCE, 0},
{ 697, 1104208090u, 3111924274u, 1066772558u, 59281695u, 1075977140u, 1062472240u, 0, LOG10_TOLERANCE, 0},
{ 698, 1067683911u, 2135245466u, 3208804313u, 3846547392u, 3220615013u, 2056251939u, 0, LOG10_TOLERANCE, 0},
{ 699, 1094877811u, 972051266u, 3222814246u, 3539700586u, 1075415588u, 3736433495u, 0, LOG10_TOLERANCE, 0},
{ 700, 1055482282u, 330951080u, 1079189813u, 583922384u, 3222514463u, 2428577226u, 0, LOG10_TOLERANCE, 0},
{ 701, 1089640092u, 1711944085u, 1104170032u, 643991456u, 1075021506u, 849331440u, 0, LOG10_TOLERANCE, 0},
{ 702, 1086945901u, 2072550721u, 3250147641u, 4280263530u, 1074820661u, 3054767438u, 0, LOG10_TOLERANCE, 0},
{ 703, 1045489058u, 1566376352u, 1067251433u, 72984588u, 3223271005u, 1012625481u, 0, LOG10_TOLERANCE, 0},
{ 704, 1095276569u, 3103043079u, 1045853123u, 410067497u, 1075447946u, 3020783845u, 0, LOG10_TOLERANCE, 0},
{ 705, 1069188845u, 1910366299u, 1081770885u, 634683073u, 3220144496u, 3237120090u, 0, LOG10_TOLERANCE, 0},
{ 706, 1081530688u, 2226525875u, 3224149290u, 2126302825u, 1074036987u, 3618469334u, 0, LOG10_TOLERANCE, 0},
{ 707, 1073150247u, 1383818978u, 3193885723u, 1220372650u, 1069816815u, 3917580686u, 0, LOG10_TOLERANCE, 0},
{ 708, 1066482943u, 1953339096u, 1077176252u, 1476516558u, 3220988290u, 2638241953u, 0, LOG10_TOLERANCE, 0},
{ 709, 1066092000u, 1306277326u, 1079089150u, 4093716191u, 3221095026u, 3487752196u, 0, LOG10_TOLERANCE, 0},
{ 710, 1085665139u, 51750045u, 3242913901u, 4256866157u, 1074659005u, 1309342661u, 0, LOG10_TOLERANCE, 0},
{ 711, 1047601319u, 2163853087u, 3232053146u, 2962422808u, 3223111635u, 4105270447u, 0, LOG10_TOLERANCE, 0},
{ 712, 1075516945u, 1618388148u, 3233154824u, 3711953164u, 1072338175u, 1191839168u, 0, LOG10_TOLERANCE, 0},
{ 713, 1099384354u, 357108214u, 3202294604u, 2306775262u, 1075757318u, 784133138u, 0, LOG10_TOLERANCE, 0},
{ 714, 1054420438u, 2571356437u, 3249064063u, 2394851808u, 3222594288u, 2040763197u, 0, LOG10_TOLERANCE, 0},
{ 715, 1083004443u, 4273880094u, 1103698617u, 3578832032u, 1074251723u, 2507069390u, 0, LOG10_TOLERANCE, 0},
{ 716, 1085943053u, 2091068742u, 3228270226u, 3980489730u, 1074699248u, 3771564566u, 0, LOG10_TOLERANCE, 0},
{ 717, 1081533104u, 2772307714u, 1051008486u, 32546576u, 1074037354u, 4044977501u, 0, LOG10_TOLERANCE, 0},
{ 718, 1093745567u, 2143788498u, 3195498043u, 3630119231u, 1075328539u, 1114663423u, 0, LOG10_TOLERANCE, 0},
{ 719, 1051149287u, 2527385594u, 3240503648u, 3482095012u, 3222840027u, 4027782605u, 0, LOG10_TOLERANCE, 0},
{ 720, 1094685151u, 2690097362u, 1068598730u, 2360266862u, 1075397460u, 2132295436u, 0, LOG10_TOLERANCE, 0},
{ 721, 1058857869u, 2673272949u, 1082639557u, 522449749u, 3222251927u, 3783282647u, 0, LOG10_TOLERANCE, 0},
{ 722, 1104424147u, 3596379400u, 3242016775u, 2002293002u, 1075987296u, 2221010959u, 0, LOG10_TOLERANCE, 0},
{ 723, 1099439656u, 4113224369u, 3222122439u, 2152316893u, 1075761372u, 4041298882u, 0, LOG10_TOLERANCE, 0},
{ 724, 1073313068u, 31662602u, 1047721249u, 1747087514u, 1070190919u, 3275029946u, 0, LOG10_TOLERANCE, 0},
{ 725, 1102980109u, 2489659568u, 1097051253u, 277506957u, 1075931234u, 1381810110u, 0, LOG10_TOLERANCE, 0},
{ 726, 1043918186u, 3850162281u, 3213841942u, 438724093u, 3223353594u, 177091255u, 0, LOG10_TOLERANCE, 0},
{ 727, 1095392535u, 2431814052u, 1075518084u, 2672434118u, 1075455856u, 2397269078u, 0, LOG10_TOLERANCE, 0},
{ 728, 1095679087u, 391606792u, 1048184750u, 4168944276u, 1075473326u, 2611771655u, 0, LOG10_TOLERANCE, 0},
{ 729, 1100308768u, 457529672u, 3201090276u, 72407935u, 1075826564u, 3785081567u, 0, LOG10_TOLERANCE, 0},
{ 730, 1071237071u, 3954981400u, 1052053242u, 2411049585u, 3218687449u, 3595228211u, 0, LOG10_TOLERANCE, 0},
{ 731, 1086180091u, 485456950u, 1088415093u, 1655397424u, 1074728718u, 3913075270u, 0, LOG10_TOLERANCE, 0},
{ 732, 1050750780u, 1551748070u, 3236871640u, 1329701152u, 3222874518u, 1520295316u, 0, LOG10_TOLERANCE, 0},
{ 733, 1077155474u, 3099222537u, 1104984570u, 4293792842u, 1073010904u, 641483791u, 0, LOG10_TOLERANCE, 0},
{ 734, 1056466057u, 3603065260u, 3197735968u, 2402359253u, 3222440074u, 683949067u, 0, LOG10_TOLERANCE, 0},
{ 735, 1051340936u, 3961208159u, 3219057584u, 2340553876u, 3222826548u, 1086390675u, 0, LOG10_TOLERANCE, 0},
{ 736, 1074881909u, 4014841779u, 3197672877u, 3697233334u, 1071934912u, 4044893289u, 0, LOG10_TOLERANCE, 0},
{ 737, 1065792009u, 1403876392u, 3254028950u, 921363393u, 3221178696u, 593147272u, 0, LOG10_TOLERANCE, 0},
{ 738, 1107251806u, 1862576361u, 3194031708u, 2476290925u, 1076091248u, 1873492489u, 0, LOG10_TOLERANCE, 0},
{ 739, 1049661768u, 1454212851u, 1088378861u, 3400401866u, 3222957594u, 1787304246u, 0, LOG10_TOLERANCE, 0},
{ 740, 1074406809u, 552676385u, 3188635745u, 3778112968u, 1071674723u, 2258814163u, 0, LOG10_TOLERANCE, 0},
{ 741, 1068925634u, 1199568671u, 3225679997u, 46947405u, 3220235458u, 1823596182u, 0, LOG10_TOLERANCE, 0},
{ 742, 1077685537u, 2596231448u, 3253943728u, 2219151748u, 1073164985u, 1843863539u, 0, LOG10_TOLERANCE, 0},
{ 743, 1066527035u, 4119719558u, 3222036299u, 1275474618u, 3220970855u, 409206651u, 0, LOG10_TOLERANCE, 0},
{ 744, 1092425015u, 3347296825u, 1101507910u, 1254014794u, 1075230292u, 2900923068u, 0, LOG10_TOLERANCE, 0},
{ 745, 1084119992u, 673775040u, 1070743626u, 244126093u, 1074417346u, 2601619170u, 0, LOG10_TOLERANCE, 0},
{ 746, 1055716202u, 1832066983u, 1051358028u, 3262483417u, 3222499483u, 2726182442u, 0, LOG10_TOLERANCE, 0},
{ 747, 1077559600u, 3962610501u, 3198598777u, 849269178u, 1073132817u, 2760677315u, 0, LOG10_TOLERANCE, 0},
{ 748, 1087990252u, 2497516122u, 3254374111u, 2821429629u, 1074899286u, 2094551578u, 0, LOG10_TOLERANCE, 0},
{ 749, 1076236288u, 2805941787u, 3217785843u, 779131141u, 1072737943u, 2025392479u, 0, LOG10_TOLERANCE, 0},
{ 750, 1079425038u, 723423605u, 1084533420u, 627282213u, 1073698254u, 660177971u, 0, LOG10_TOLERANCE, 0},
{ 751, 1068464032u, 4292778869u, 1078101071u, 1676860147u, 3220398575u, 4080177346u, 0, LOG10_TOLERANCE, 0},
{ 752, 1076288502u, 3528118587u, 3194648564u, 2363260897u, 1072754098u, 2762983951u, 0, LOG10_TOLERANCE, 0},
{ 753, 1045414231u, 1307010018u, 1061248120u, 1468743108u, 3223278089u, 2286340052u, 0, LOG10_TOLERANCE, 0},
{ 754, 1099099491u, 107905661u, 3226089788u, 1943427674u, 1075733782u, 1870296517u, 0, LOG10_TOLERANCE, 0},
{ 755, 1040746893u, 760006940u, 1054265604u, 1749976597u, 3223472861u, 3121291541u, 0, LOG10_TOLERANCE, 0},
{ 756, 1090289736u, 2787503556u, 1081282610u, 1195841206u, 1075070165u, 3287006887u, 0, LOG10_TOLERANCE, 0},
{ 757, 1044318508u, 545462045u, 3208381743u, 1981311808u, 3223341117u, 3439509787u, 0, LOG10_TOLERANCE, 0},
{ 758, 1061232136u, 3657978397u, 1104463616u, 3501253426u, 3221897616u, 2613738871u, 0, LOG10_TOLERANCE, 0},
{ 759, 1049883857u, 1804177501u, 3210693633u, 3606766729u, 3222936407u, 395246601u, 0, LOG10_TOLERANCE, 0},
{ 760, 1076856879u, 1336278526u, 1043741618u, 3165279431u, 1072900573u, 2736825398u, 0, LOG10_TOLERANCE, 0},
{ 761, 1055471915u, 1599382075u, 1058018527u, 4212580517u, 3222515175u, 1334306044u, 0, LOG10_TOLERANCE, 0},
{ 762, 1060018678u, 3007589929u, 3202026547u, 2792028313u, 3222080988u, 2398873954u, 0, LOG10_TOLERANCE, 0},
{ 763, 1105599122u, 1866066996u, 1060329048u, 3727175322u, 1076031950u, 1117079653u, 0, LOG10_TOLERANCE, 0},
{ 764, 1050932995u, 150890940u, 1056025306u, 3082724735u, 3222857445u, 31357167u, 0, LOG10_TOLERANCE, 0},
{ 765, 1062008939u, 80400395u, 1093584426u, 3478941315u, 3221777807u, 656233594u, 0, LOG10_TOLERANCE, 0},
{ 766, 1104156966u, 4050954182u, 3219263194u, 2537475930u, 1075974446u, 2527925082u, 0, LOG10_TOLERANCE, 0},
{ 767, 1064841871u, 2881752155u, 3212589299u, 2559651278u, 3221345318u, 2837332410u, 0, LOG10_TOLERANCE, 0},
{ 768, 1101532656u, 440309030u, 3214267461u, 3788040806u, 1075878937u, 3943495913u, 0, LOG10_TOLERANCE, 0},
{ 769, 1100476615u, 918813144u, 3208535698u, 1607035904u, 1075839211u, 526175238u, 0, LOG10_TOLERANCE, 0},
{ 770, 1042137451u, 2497054124u, 1089139147u, 2549609010u, 3223422429u, 101990395u, 0, LOG10_TOLERANCE, 0},
{ 771, 1047037641u, 790219083u, 1054657139u, 2797979479u, 3223149670u, 1483771049u, 0, LOG10_TOLERANCE, 0},
{ 772, 1057781400u, 1149462078u, 1095765205u, 3879963182u, 3222343590u, 4037954969u, 0, LOG10_TOLERANCE, 0},
{ 773, 1055246165u, 2684353926u, 3205212854u, 1732474928u, 3222531892u, 2416203981u, 0, LOG10_TOLERANCE, 0},
{ 774, 1095236965u, 2742237025u, 1051317716u, 3386396147u, 1075445114u, 1609704394u, 0, LOG10_TOLERANCE, 0},
{ 775, 1063230986u, 3408320912u, 1103071166u, 4233059513u, 3221600072u, 3702924123u, 0, LOG10_TOLERANCE, 0},
{ 776, 1064863548u, 1077495917u, 1088399968u, 433115118u, 3221342227u, 1491358516u, 0, LOG10_TOLERANCE, 0},
{ 777, 1057063924u, 841366493u, 1051716814u, 4121125128u, 3222398867u, 2304669873u, 0, LOG10_TOLERANCE, 0},
{ 778, 1064632084u, 321857207u, 1089128010u, 1149988239u, 3221377628u, 1283733309u, 0, LOG10_TOLERANCE, 0},
{ 779, 1098059015u, 799866606u, 3197637091u, 3924438208u, 1075655610u, 1105734641u, 0, LOG10_TOLERANCE, 0},
{ 780, 1043579242u, 2002049816u, 1077053447u, 2240354761u, 3223366830u, 3458618238u, 0, LOG10_TOLERANCE, 0},
{ 781, 1081522635u, 478939968u, 1097035749u, 1066716440u, 1074035759u, 4035027600u, 0, LOG10_TOLERANCE, 0},
{ 782, 1084989993u, 1653104725u, 1088548129u, 81977716u, 1074553759u, 4216054447u, 0, LOG10_TOLERANCE, 0},
{ 783, 1049377628u, 3899475018u, 3189694084u, 3330093036u, 3222975825u, 3582530778u, 0, LOG10_TOLERANCE, 0},
{ 784, 1089312583u, 2612450289u, 1079065127u, 603380842u, 1074995524u, 3038824780u, 0, LOG10_TOLERANCE, 0},
{ 785, 1100636791u, 3962735564u, 1101570429u, 1372490825u, 1075844744u, 2684675728u, 0, LOG10_TOLERANCE, 0},
{ 786, 1054806016u, 1479841439u, 1059312257u, 541504905u, 3222570381u, 3085201785u, 0, LOG10_TOLERANCE, 0},
{ 787, 1078662178u, 2626148789u, 1057571099u, 4121656076u, 1073462543u, 772383770u, 0, LOG10_TOLERANCE, 0},
{ 788, 1081613389u, 1902560314u, 1043130231u, 3557671562u, 1074049228u, 1399281699u, 0, LOG10_TOLERANCE, 0},
{ 789, 1046346124u, 41779312u, 1081626342u, 831171823u, 3223205745u, 1896438613u, 0, LOG10_TOLERANCE, 0},
{ 790, 1058131100u, 1393168821u, 1066457405u, 1381616968u, 3222318124u, 1542994528u, 0, LOG10_TOLERANCE, 0},
{ 791, 1072338141u, 3756584649u, 3222267229u, 1423157432u, 3216285761u, 2951141520u, 0, LOG10_TOLERANCE, 0},
{ 792, 1106952026u, 1894912556u, 1042426694u, 155024547u, 1076082261u, 3040158092u, 0, LOG10_TOLERANCE, 0},
{ 793, 1047969864u, 35164295u, 3203391785u, 1037041084u, 3223079311u, 3308745497u, 0, LOG10_TOLERANCE, 0},
{ 794, 1084777479u, 3957875950u, 3232195211u, 1590756436u, 1074525338u, 1563349431u, 0, LOG10_TOLERANCE, 0},
{ 795, 1068844322u, 1447585080u, 1071279485u, 1107922438u, 3220261276u, 1394670376u, 0, LOG10_TOLERANCE, 0},
{ 796, 1046252518u, 981897615u, 1051856116u, 430357614u, 3223211303u, 3595460321u, 0, LOG10_TOLERANCE, 0},
{ 797, 1080040567u, 395145384u, 3219821938u, 50586510u, 1073799609u, 3433717707u, 0, LOG10_TOLERANCE, 0},
{ 798, 1069775912u, 750827797u, 1082862669u, 230466783u, 3219794186u, 1579634838u, 0, LOG10_TOLERANCE, 0},
{ 799, 1086668819u, 1365083575u, 3204848310u, 1700831722u, 1074800003u, 2681601635u, 0, LOG10_TOLERANCE, 0},
{ 800, 1070606742u, 344241827u, 1071538935u, 2715566077u, 3219333154u, 3754315639u, 0, LOG10_TOLERANCE, 0},
{ 801, 1100099208u, 4069301823u, 3193208760u, 2949125229u, 1075808120u, 2852921220u, 0, LOG10_TOLERANCE, 0},
{ 802, 1103231387u, 3585711710u, 1065801594u, 2302229267u, 1075941267u, 685999740u, 0, LOG10_TOLERANCE, 0},
{ 803, 1046635308u, 709803845u, 1048741487u, 2296910194u, 3223182468u, 2740202815u, 0, LOG10_TOLERANCE, 0},
{ 804, 1045797131u, 744421179u, 1069302001u, 2659232829u, 3223243060u, 2691168462u, 0, LOG10_TOLERANCE, 0},
{ 805, 1092835968u, 1799949903u, 3192522886u, 4212149209u, 1075262838u, 2250803774u, 0, LOG10_TOLERANCE, 0},
{ 806, 1058624854u, 145234164u, 3250614064u, 912384201u, 3222277940u, 674861709u, 0, LOG10_TOLERANCE, 0},
{ 807, 1093027016u, 2784620507u, 1102812948u, 3531481022u, 1075278812u, 696134292u, 0, LOG10_TOLERANCE, 0},
{ 808, 1103676015u, 383952592u, 3205659905u, 3633194728u, 1075959495u, 2755860393u, 0, LOG10_TOLERANCE, 0},
{ 809, 1055992604u, 3792395543u, 1070072378u, 3864816376u, 3222480059u, 283896494u, 0, LOG10_TOLERANCE, 0},
{ 810, 1057832625u, 2115553675u, 1066288499u, 3538377867u, 3222340506u, 3026544246u, 0, LOG10_TOLERANCE, 0},
{ 811, 1104591537u, 1230026762u, 1090719723u, 440819880u, 1075994082u, 260264377u, 0, LOG10_TOLERANCE, 0},
{ 812, 1047111428u, 2991290482u, 1096886719u, 1097971167u, 3223144560u, 2098613411u, 0, LOG10_TOLERANCE, 0},
{ 813, 1090048600u, 1098035020u, 3230900504u, 1479059095u, 1075054429u, 58159371u, 0, LOG10_TOLERANCE, 0},
{ 814, 1103573316u, 1719428427u, 3188631907u, 3707377409u, 1075955773u, 3449026054u, 0, LOG10_TOLERANCE, 0},
{ 815, 1053236165u, 3748932896u, 1084908557u, 1325384361u, 3222682971u, 1034783433u, 0, LOG10_TOLERANCE, 0},
{ 816, 1084704076u, 3979168763u, 1057455255u, 2454615952u, 1074514634u, 3185048229u, 0, LOG10_TOLERANCE, 0},
{ 817, 1053106984u, 1449164578u, 1056960316u, 1654931641u, 3222693121u, 3443010324u, 0, LOG10_TOLERANCE, 0},
{ 818, 1071439010u, 2120487381u, 3226298974u, 2364226633u, 3218481792u, 518227657u, 0, LOG10_TOLERANCE, 0},
{ 819, 1075071428u, 1074268944u, 1065730444u, 280016852u, 1072074970u, 3577897135u, 0, LOG10_TOLERANCE, 0},
{ 820, 1052824608u, 3315127889u, 3236295594u, 2900924954u, 3222719074u, 2027145852u, 0, LOG10_TOLERANCE, 0},
{ 821, 1048942243u, 2246037502u, 1049691002u, 1496066550u, 3223006370u, 2295288876u, 0, LOG10_TOLERANCE, 0},
{ 822, 1045523211u, 4191285446u, 3217936236u, 2382392789u, 3223267546u, 4168743981u, 0, LOG10_TOLERANCE, 0},
{ 823, 1092833308u, 640099844u, 1042152237u, 2064279383u, 1075262599u, 2090152878u, 0, LOG10_TOLERANCE, 0},
{ 824, 1079913438u, 3468560824u, 1093251038u, 310958750u, 1073784634u, 3165731196u, 0, LOG10_TOLERANCE, 0},
{ 825, 1096788400u, 1413568905u, 1100941106u, 1627289946u, 1075555621u, 3856793281u, 0, LOG10_TOLERANCE, 0},
{ 826, 1044065902u, 3797143370u, 3195497539u, 3843275034u, 3223348666u, 2069084644u, 0, LOG10_TOLERANCE, 0},
{ 827, 1104593745u, 2806642640u, 3201943068u, 2515980718u, 1075994166u, 1674516539u, 0, LOG10_TOLERANCE, 0},
{ 828, 1086877316u, 632580632u, 1078673506u, 3259601317u, 1074815886u, 2637883203u, 0, LOG10_TOLERANCE, 0},
{ 829, 1053496927u, 3309678799u, 1049337078u, 3056787074u, 3222664884u, 1775866686u, 0, LOG10_TOLERANCE, 0},
{ 830, 1074011641u, 2341164249u, 1080834967u, 2810890005u, 1071227234u, 2256181049u, 0, LOG10_TOLERANCE, 0},
{ 831, 1067019674u, 932124675u, 1093915797u, 662682630u, 3220811269u, 995473316u, 0, LOG10_TOLERANCE, 0},
{ 832, 1101746443u, 1367996113u, 3251723684u, 2974064663u, 1075886177u, 651743782u, 0, LOG10_TOLERANCE, 0},
{ 833, 1080230731u, 323437999u, 1090499064u, 901457511u, 1073837316u, 2251952976u, 0, LOG10_TOLERANCE, 0},
{ 834, 1088295228u, 4184941840u, 3196770014u, 2458988443u, 1074918429u, 3423367882u, 0, LOG10_TOLERANCE, 0},
{ 835, 1087618284u, 2023065054u, 3211994098u, 2734612965u, 1074870511u, 3963545637u, 0, LOG10_TOLERANCE, 0},
{ 836, 1064074694u, 3679267365u, 3237728785u, 1699558211u, 3221465951u, 335272041u, 0, LOG10_TOLERANCE, 0},
{ 837, 1088079010u, 1826799031u, 1078709629u, 3986905229u, 1074905197u, 1977171186u, 0, LOG10_TOLERANCE, 0},
{ 838, 1052843785u, 351061688u, 3194386466u, 4105857588u, 3222717111u, 4126660092u, 0, LOG10_TOLERANCE, 0},
{ 839, 1054128006u, 1365244058u, 1064457319u, 1452191426u, 3222616495u, 4099715943u, 0, LOG10_TOLERANCE, 0},
{ 840, 1064122385u, 2463030625u, 3215975031u, 3773488326u, 3221460208u, 2109408512u, 0, LOG10_TOLERANCE, 0},
{ 841, 1103793023u, 752664055u, 1065110394u, 1835931663u, 1075963459u, 685541286u, 0, LOG10_TOLERANCE, 0},
{ 842, 1088045088u, 3496172149u, 1089617208u, 109068701u, 1074902974u, 2047127981u, 0, LOG10_TOLERANCE, 0},
{ 843, 1050651439u, 1636966254u, 1086098766u, 2016598298u, 3222883834u, 875865810u, 0, LOG10_TOLERANCE, 0},
{ 844, 1050931318u, 3551516956u, 1097969102u, 1317953425u, 3222857590u, 4082108263u, 0, LOG10_TOLERANCE, 0},
{ 845, 1082348569u, 2977627788u, 1045339018u, 516058480u, 1074156718u, 2272896401u, 0, LOG10_TOLERANCE, 0},
{ 846, 1089924930u, 3901731263u, 3189566462u, 32272932u, 1075045427u, 671782915u, 0, LOG10_TOLERANCE, 0},
{ 847, 1077281796u, 1956025297u, 3246628529u, 3840733905u, 1073052628u, 3982968800u, 0, LOG10_TOLERANCE, 0},
{ 848, 1099818036u, 561057891u, 3198494340u, 4271027193u, 1075785807u, 113950622u, 0, LOG10_TOLERANCE, 0},
{ 849, 1103446273u, 692989850u, 3242630588u, 2492225971u, 1075950805u, 818111655u, 0, LOG10_TOLERANCE, 0},
{ 850, 1057995749u, 3439913962u, 1067477011u, 2973333638u, 3222331207u, 1303955608u, 0, LOG10_TOLERANCE, 0},
{ 851, 1066510341u, 877613377u, 1044917899u, 809672798u, 3220977378u, 1845075850u, 0, LOG10_TOLERANCE, 0},
{ 852, 1074687806u, 905426932u, 1046417457u, 1086320855u, 1071813024u, 2781073646u, 0, LOG10_TOLERANCE, 0},
{ 853, 1098862981u, 2645567288u, 1051258339u, 557182478u, 1075712203u, 812148340u, 0, LOG10_TOLERANCE, 0},
{ 854, 1056574302u, 186287752u, 1061342054u, 4054003419u, 3222432615u, 442298873u, 0, LOG10_TOLERANCE, 0},
{ 855, 1097266673u, 3506889716u, 3243866036u, 519056371u, 1075597949u, 538556539u, 0, LOG10_TOLERANCE, 0},
{ 856, 1042654053u, 2171898436u, 3246911982u, 1091500784u, 3223401105u, 2734375231u, 0, LOG10_TOLERANCE, 0},
{ 857, 1096164025u, 368493885u, 3222871893u, 1419055230u, 1075514869u, 2281844850u, 0, LOG10_TOLERANCE, 0},
{ 858, 1091950572u, 2010971245u, 3188804530u, 1518695799u, 1075197703u, 4020454285u, 0, LOG10_TOLERANCE, 0},
{ 859, 1057942861u, 1239207795u, 1040192984u, 2199481342u, 3222334139u, 4169715069u, 0, LOG10_TOLERANCE, 0},
{ 860, 1063494989u, 4264613432u, 3203460972u, 3558930895u, 3221550594u, 2166450280u, 0, LOG10_TOLERANCE, 0},
{ 861, 1050299283u, 3772748958u, 3227667376u, 309688336u, 3222905003u, 765066117u, 0, LOG10_TOLERANCE, 0},
{ 862, 1083259393u, 1077949160u, 1075769893u, 2405271377u, 1074288330u, 3619654319u, 0, LOG10_TOLERANCE, 0},
{ 863, 1091835152u, 3751608506u, 3232278094u, 930375071u, 1075188133u, 2430026858u, 0, LOG10_TOLERANCE, 0},
{ 864, 1051133505u, 1518334131u, 3205247482u, 791756713u, 3222841212u, 2201383808u, 0, LOG10_TOLERANCE, 0},
{ 865, 1047317453u, 2825203170u, 3245054001u, 1822981827u, 3223131399u, 1781924118u, 0, LOG10_TOLERANCE, 0},
{ 866, 1100016363u, 514474738u, 1089072073u, 3300845441u, 1075799916u, 2273546640u, 0, LOG10_TOLERANCE, 0},
{ 867, 1068907602u, 247369460u, 3197320093u, 687450958u, 3220241058u, 4195955112u, 0, LOG10_TOLERANCE, 0},
{ 868, 1104161422u, 2722237629u, 1058272368u, 90602316u, 1075974686u, 2110125726u, 0, LOG10_TOLERANCE, 0},
{ 869, 1060614787u, 1845900544u, 3231520830u, 3389751458u, 3221981380u, 1451399181u, 0, LOG10_TOLERANCE, 0},
{ 870, 1100051597u, 737689911u, 3195377751u, 3462616966u, 1075803478u, 929679035u, 0, LOG10_TOLERANCE, 0},
{ 871, 1076054736u, 3620285831u, 1055501023u, 2708056059u, 1072660433u, 2509134029u, 0, LOG10_TOLERANCE, 0},
{ 872, 1071981348u, 4073430285u, 1056206159u, 172017902u, 3217493387u, 977702324u, 0, LOG10_TOLERANCE, 0},
{ 873, 1065385990u, 2799176222u, 1052706894u, 4083892667u, 3221274672u, 4016902187u, 0, LOG10_TOLERANCE, 0},
{ 874, 1054795909u, 1562351330u, 1069705601u, 1247765260u, 3222570948u, 1552306542u, 0, LOG10_TOLERANCE, 0},
{ 875, 1085233651u, 51853475u, 3189080201u, 2783553144u, 1074582502u, 856854528u, 0, LOG10_TOLERANCE, 0},
{ 876, 1071970705u, 3851781549u, 3241598113u, 514064046u, 3217521485u, 3650940125u, 0, LOG10_TOLERANCE, 0},
{ 877, 1100045965u, 934745487u, 3248182437u, 2798581921u, 1075802916u, 1421123339u, 0, LOG10_TOLERANCE, 0},
{ 878, 1065598845u, 2948648757u, 3232177250u, 4278702895u, 3221233759u, 858150767u, 0, LOG10_TOLERANCE, 0},
{ 879, 1072485724u, 4259101461u, 1061606772u, 84229920u, 3215403890u, 4183169085u, 0, LOG10_TOLERANCE, 0},
{ 880, 1050591911u, 3891230598u, 1095924595u, 3049217547u, 3222887147u, 1338942792u, 0, LOG10_TOLERANCE, 0},
{ 881, 1077353053u, 3806018919u, 3243191216u, 280177341u, 1073074581u, 3592504291u, 0, LOG10_TOLERANCE, 0},
{ 882, 1060624530u, 3900344258u, 1063647809u, 4206745890u, 3221979956u, 1165041488u, 0, LOG10_TOLERANCE, 0},
{ 883, 1080223688u, 2126253040u, 3207248026u, 808507485u, 1073836025u, 4006752466u, 0, LOG10_TOLERANCE, 0},
{ 884, 1086090317u, 3465685634u, 3230391053u, 3754958214u, 1074718001u, 2173078304u, 0, LOG10_TOLERANCE, 0},
{ 885, 1102861084u, 461094531u, 1101110393u, 1316091396u, 1075927696u, 2549577293u, 0, LOG10_TOLERANCE, 0},
{ 886, 1064980314u, 4197635149u, 1091873113u, 1240127141u, 3221326260u, 3476238897u, 0, LOG10_TOLERANCE, 0},
{ 887, 1074333893u, 118603800u, 1105304898u, 4291425557u, 1071625565u, 3112805610u, 0, LOG10_TOLERANCE, 0},
{ 888, 1065945517u, 3744663425u, 3212482771u, 953662066u, 3221133966u, 2461525298u, 0, LOG10_TOLERANCE, 0},
{ 889, 1085171305u, 3564196690u, 3228101916u, 904305212u, 1074575486u, 506637444u, 0, LOG10_TOLERANCE, 0},
{ 890, 1048333111u, 3566257266u, 3235138829u, 2734275140u, 3223054489u, 2402197835u, 0, LOG10_TOLERANCE, 0},
{ 891, 1096464829u, 606044282u, 3241318094u, 2446416887u, 1075536321u, 4109023068u, 0, LOG10_TOLERANCE, 0},
{ 892, 1041627284u, 2336116589u, 3197594053u, 2296925138u, 3223439693u, 2314837685u, 0, LOG10_TOLERANCE, 0},
{ 893, 1058567659u, 907670625u, 3240769036u, 1827119006u, 3222281931u, 1348167011u, 0, LOG10_TOLERANCE, 0},
{ 894, 1044467183u, 2818710946u, 3246059905u, 553394170u, 3223334914u, 3999609662u, 0, LOG10_TOLERANCE, 0},
{ 895, 1042020446u, 4099522736u, 3232742168u, 3718083858u, 3223425951u, 1041051776u, 0, LOG10_TOLERANCE, 0},
{ 896, 1092371276u, 1059279404u, 1080245336u, 175941677u, 1075227036u, 2513130381u, 0, LOG10_TOLERANCE, 0},
{ 897, 1105189691u, 1650862428u, 1061816101u, 1723201723u, 1076013298u, 2773793754u, 0, LOG10_TOLERANCE, 0},
{ 898, 1091529166u, 2462163405u, 3218946201u, 3876535372u, 1075160155u, 262248220u, 0, LOG10_TOLERANCE, 0},
{ 899, 1084392886u, 495844137u, 1073721460u, 772777946u, 1074462670u, 1099362184u, 0, LOG10_TOLERANCE, 0},
{ 900, 1052415330u, 458757721u, 3245680321u, 3609892707u, 3222745935u, 1380494767u, 0, LOG10_TOLERANCE, 0},
{ 901, 1045799308u, 2533012202u, 1079980803u, 3592268374u, 3223242885u, 2684476530u, 0, LOG10_TOLERANCE, 0},
{ 902, 1055881132u, 4108274117u, 1063045844u, 571992389u, 3222489993u, 3494391159u, 0, LOG10_TOLERANCE, 0},
{ 903, 1090567271u, 3541110973u, 1096296754u, 3118427427u, 1075088468u, 1540713558u, 0, LOG10_TOLERANCE, 0},
{ 904, 1046496395u, 1213941007u, 1105433735u, 2172963370u, 3223196412u, 3319524204u, 0, LOG10_TOLERANCE, 0},
{ 905, 1096853359u, 272190288u, 1095452370u, 4026581530u, 1075561388u, 4126415854u, 0, LOG10_TOLERANCE, 0},
{ 906, 1095583909u, 2843638672u, 1100510986u, 3190536898u, 1075467816u, 74630356u, 0, LOG10_TOLERANCE, 0},
{ 907, 1083757094u, 2014317727u, 3247389683u, 2428462015u, 1074371492u, 2456721468u, 0, LOG10_TOLERANCE, 0},
{ 908, 1093976717u, 688442200u, 1047852515u, 3035186380u, 1075349738u, 1619572370u, 0, LOG10_TOLERANCE, 0},
{ 909, 1076664212u, 1010095511u, 3221288076u, 405287991u, 1072856003u, 3966425243u, 0, LOG10_TOLERANCE, 0},
{ 910, 1104810967u, 2983070435u, 1089546472u, 2907918480u, 1076001904u, 2260517137u, 0, LOG10_TOLERANCE, 0},
{ 911, 1082988121u, 81928569u, 1056007286u, 2740556321u, 1074249782u, 741500836u, 0, LOG10_TOLERANCE, 0},
{ 912, 1041110867u, 2076689028u, 1081558619u, 3039159031u, 3223461247u, 1110171873u, 0, LOG10_TOLERANCE, 0},
{ 913, 1047307438u, 1376882094u, 3211003208u, 1296286481u, 3223132005u, 933703128u, 0, LOG10_TOLERANCE, 0},
{ 914, 1080114314u, 744133164u, 3200943494u, 955832216u, 1073814982u, 1891659777u, 0, LOG10_TOLERANCE, 0},
{ 915, 1078806678u, 176522478u, 1069999908u, 2891249491u, 1073498191u, 442688633u, 0, LOG10_TOLERANCE, 0},
{ 916, 1043564602u, 3685851715u, 3187829932u, 2363997529u, 3223367478u, 557452820u, 0, LOG10_TOLERANCE, 0},
{ 917, 1040244055u, 3974431579u, 1052505165u, 2589067816u, 3223494206u, 3626267569u, 0, LOG10_TOLERANCE, 0},
{ 918, 1044013141u, 3819109588u, 1048561488u, 969143351u, 3223350377u, 4068494919u, 0, LOG10_TOLERANCE, 0},
{ 919, 1072639397u, 4246896124u, 1104584799u, 1940097860u, 3213304592u, 3497819754u, 0, LOG10_TOLERANCE, 0},
{ 920, 1048038468u, 2228686199u, 3220231833u, 777624847u, 3223074190u, 1541831713u, 0, LOG10_TOLERANCE, 0},
{ 921, 1083983658u, 4189906558u, 3203004203u, 854242364u, 1074401183u, 2633113722u, 0, LOG10_TOLERANCE, 0},
{ 922, 1103910407u, 4089051094u, 3227282692u, 2693170723u, 1075967176u, 539495337u, 0, LOG10_TOLERANCE, 0},
{ 923, 1045883607u, 1278581412u, 3239296746u, 1774588717u, 3223236309u, 1250724029u, 0, LOG10_TOLERANCE, 0},
{ 924, 1074889038u, 1794845306u, 1104879344u, 4135865182u, 1071940589u, 4081733314u, 0, LOG10_TOLERANCE, 0},
{ 925, 1106449055u, 754938390u, 1061291430u, 2010786993u, 1076063011u, 897095638u, 0, LOG10_TOLERANCE, 0},
{ 926, 1073581409u, 2034303731u, 3240176537u, 314147356u, 1070665179u, 3094080775u, 0, LOG10_TOLERANCE, 0},
{ 927, 1083965546u, 567588900u, 3195452230u, 1421366017u, 1074398947u, 1052576918u, 0, LOG10_TOLERANCE, 0},
{ 928, 1077606107u, 2708717091u, 1071975971u, 1364590470u, 1073144962u, 4187422802u, 0, LOG10_TOLERANCE, 0},
{ 929, 1104653635u, 3461956134u, 3207820115u, 1605709634u, 1075996406u, 4280267022u, 0, LOG10_TOLERANCE, 0},
{ 930, 1065302996u, 1497124553u, 1051715442u, 916736957u, 3221287199u, 3332961944u, 0, LOG10_TOLERANCE, 0},
{ 931, 1058468363u, 834914365u, 1064667143u, 2839166298u, 3222289211u, 514998812u, 0, LOG10_TOLERANCE, 0},
{ 932, 1057279949u, 2139295776u, 1062816721u, 914592523u, 3222379236u, 1543783481u, 0, LOG10_TOLERANCE, 0},
{ 933, 1042153283u, 851569132u, 1058503154u, 1399378677u, 3223421968u, 3228314542u, 0, LOG10_TOLERANCE, 0},
{ 934, 1086054049u, 3897202342u, 3245382590u, 246600375u, 1074713524u, 2112897030u, 0, LOG10_TOLERANCE, 0},
{ 935, 1077976660u, 3620429520u, 1055627557u, 229305u, 1073240207u, 2697183834u, 0, LOG10_TOLERANCE, 0},
{ 936, 1083958833u, 3641997865u, 3206673888u, 93720614u, 1074398112u, 3772639712u, 0, LOG10_TOLERANCE, 0},
{ 937, 1080324787u, 32766320u, 1062084905u, 3668443038u, 1073853886u, 1022794505u, 0, LOG10_TOLERANCE, 0},
{ 938, 1075815348u, 2039713492u, 3248699388u, 1346210821u, 1072479693u, 1831222428u, 0, LOG10_TOLERANCE, 0},
{ 939, 1093050016u, 1335820726u, 3191756860u, 1808427032u, 1075280592u, 1598478647u, 0, LOG10_TOLERANCE, 0},
{ 940, 1061442763u, 650692001u, 1103515670u, 2253348763u, 3221858437u, 3297267625u, 0, LOG10_TOLERANCE, 0},
{ 941, 1043911539u, 2372623300u, 3210185343u, 3200572848u, 3223353826u, 595580091u, 0, LOG10_TOLERANCE, 0},
{ 942, 1100796069u, 762317532u, 3194595095u, 3192607437u, 1075849760u, 1939640096u, 0, LOG10_TOLERANCE, 0},
{ 943, 1062262701u, 217775356u, 3232827087u, 2969367386u, 3221743475u, 3320081474u, 0, LOG10_TOLERANCE, 0},
{ 944, 1057172551u, 3621353969u, 1077994795u, 3873976266u, 3222388573u, 2581083904u, 0, LOG10_TOLERANCE, 0},
{ 945, 1091301987u, 268372152u, 3221764390u, 3216978962u, 1075146843u, 300857787u, 0, LOG10_TOLERANCE, 0},
{ 946, 1098953963u, 142942404u, 1075322987u, 1746449109u, 1075719574u, 3783378795u, 0, LOG10_TOLERANCE, 0},
{ 947, 1104006296u, 496534875u, 3254522293u, 2532372502u, 1075970042u, 121673326u, 0, LOG10_TOLERANCE, 0},
{ 948, 1102741893u, 2999955409u, 3222793392u, 1868977643u, 1075923918u, 4041909473u, 0, LOG10_TOLERANCE, 0},
{ 949, 1074319042u, 3353193428u, 3218469191u, 3326244297u, 1071609002u, 3568808289u, 0, LOG10_TOLERANCE, 0},
{ 950, 1068218799u, 73646871u, 3231442171u, 3711510104u, 3220456229u, 2608711226u, 0, LOG10_TOLERANCE, 0},
{ 951, 1090483524u, 218135177u, 3198908856u, 3082199105u, 1075081403u, 4130761195u, 0, LOG10_TOLERANCE, 0},
{ 952, 1068068480u, 1061628117u, 3248859043u, 86776158u, 3220495553u, 2350869612u, 0, LOG10_TOLERANCE, 0},
{ 953, 1061001026u, 938869114u, 1087911145u, 2416710759u, 3221930808u, 1742268548u, 0, LOG10_TOLERANCE, 0},
{ 954, 1095576832u, 2970853959u, 3239543429u, 1887505029u, 1075467395u, 1803897185u, 0, LOG10_TOLERANCE, 0},
{ 955, 1090245139u, 1337895935u, 1076463812u, 1172733328u, 1075067414u, 2255894230u, 0, LOG10_TOLERANCE, 0},
{ 956, 1049139928u, 1469010822u, 3229583535u, 551399515u, 3222991480u, 3413880326u, 0, LOG10_TOLERANCE, 0},
{ 957, 1074118123u, 1849711538u, 1049053713u, 1744276190u, 1071368716u, 319414877u, 0, LOG10_TOLERANCE, 0},
{ 958, 1094655132u, 2976596113u, 3192137295u, 3033242648u, 1075395796u, 2395640658u, 0, LOG10_TOLERANCE, 0},
{ 959, 1098698481u, 876810930u, 3197470945u, 2571587447u, 1075702692u, 868384370u, 0, LOG10_TOLERANCE, 0},
{ 960, 1094287162u, 4007797282u, 3225853845u, 4069319648u, 1075373137u, 4114988772u, 0, LOG10_TOLERANCE, 0},
{ 961, 1047279982u, 3840538373u, 1043189552u, 3668774580u, 3223133682u, 2793605649u, 0, LOG10_TOLERANCE, 0},
{ 962, 1070128056u, 200857661u, 3229758439u, 3359367736u, 3219572368u, 3230745583u, 0, LOG10_TOLERANCE, 0},
{ 963, 1101314221u, 111868139u, 3227902082u, 2366064003u, 1075870447u, 2315533989u, 0, LOG10_TOLERANCE, 0},
{ 964, 1044195166u, 3510904416u, 3222131653u, 3822770497u, 3223344678u, 3470538208u, 0, LOG10_TOLERANCE, 0},
{ 965, 1095192067u, 789151814u, 1099269239u, 2958956055u, 1075441815u, 3485815747u, 0, LOG10_TOLERANCE, 0},
{ 966, 1084679320u, 722163228u, 1105524559u, 1534462169u, 1074510908u, 798696848u, 0, LOG10_TOLERANCE, 0},
{ 967, 1046586062u, 2207037106u, 3208952465u, 1231254630u, 3223187218u, 4027511879u, 0, LOG10_TOLERANCE, 0},
{ 968, 1050400412u, 3838689849u, 3198769679u, 1302617170u, 3222898510u, 3604128999u, 0, LOG10_TOLERANCE, 0},
{ 969, 1085938906u, 2527556476u, 3240373426u, 124352692u, 1074698697u, 3398399993u, 0, LOG10_TOLERANCE, 0},
{ 970, 1052057157u, 3502371499u, 1043411944u, 4190072016u, 3222772137u, 3563735668u, 0, LOG10_TOLERANCE, 0},
{ 971, 1064676142u, 1798470077u, 3200116917u, 3421833729u, 3221370452u, 329675828u, 0, LOG10_TOLERANCE, 0},
{ 972, 1046031308u, 3653237931u, 3204255012u, 3683870669u, 3223225630u, 580955093u, 0, LOG10_TOLERANCE, 0},
{ 973, 1053588582u, 376530104u, 1073853547u, 565755892u, 3222659153u, 523959117u, 0, LOG10_TOLERANCE, 0},
{ 974, 1095020203u, 558292492u, 1051772749u, 4267873474u, 1075428224u, 3675331960u, 0, LOG10_TOLERANCE, 0},
{ 975, 1077289061u, 509637100u, 3212030069u, 215050379u, 1073054916u, 371002261u, 0, LOG10_TOLERANCE, 0},
{ 976, 1092057101u, 3571665665u, 3188628584u, 757824767u, 1075205875u, 2766467475u, 0, LOG10_TOLERANCE, 0},
{ 977, 1067315689u, 998858159u, 1063077962u, 436029885u, 3220736810u, 2451000458u, 0, LOG10_TOLERANCE, 0},
{ 978, 1058463317u, 996300405u, 3193842624u, 80548098u, 3222289593u, 3378863163u, 0, LOG10_TOLERANCE, 0},
{ 979, 1081365192u, 3876129407u, 3215332180u, 2226970413u, 1074010320u, 899697228u, 0, LOG10_TOLERANCE, 0},
{ 980, 1090125305u, 200013509u, 3224552716u, 414878724u, 1075059674u, 2493730227u, 0, LOG10_TOLERANCE, 0},
{ 981, 1083133445u, 309319541u, 1048979765u, 1261662434u, 1074266510u, 2927407487u, 0, LOG10_TOLERANCE, 0},
{ 982, 1089252639u, 4062255924u, 3224274128u, 4289485681u, 1074991950u, 404883066u, 0, LOG10_TOLERANCE, 0},
{ 983, 1088652436u, 1611969213u, 1053890378u, 3774617276u, 1074948148u, 2175758408u, 0, LOG10_TOLERANCE, 0},
{ 984, 1080412763u, 1752164782u, 3239587974u, 612223386u, 1073868364u, 979639357u, 0, LOG10_TOLERANCE, 0},
{ 985, 1041545782u, 2024044989u, 1074932678u, 3259111307u, 3223443010u, 1613812740u, 0, LOG10_TOLERANCE, 0},
{ 986, 1053207518u, 2564965629u, 1093571065u, 169360454u, 3222685145u, 1827889021u, 0, LOG10_TOLERANCE, 0},
{ 987, 1089599090u, 1860101737u, 3191222372u, 1676437468u, 1075017608u, 1612357925u, 0, LOG10_TOLERANCE, 0},
{ 988, 1059802968u, 588387057u, 3192103292u, 2495288012u, 3222106899u, 1393779995u, 0, LOG10_TOLERANCE, 0},
{ 989, 1045672057u, 659070058u, 1073095700u, 1393632068u, 3223253593u, 999146267u, 0, LOG10_TOLERANCE, 0},
{ 990, 1070199615u, 4276187829u, 3217553330u, 1868253275u, 3219533215u, 3230946523u, 0, LOG10_TOLERANCE, 0},
{ 991, 1075736624u, 2085481575u, 3215994784u, 800910002u, 1072444440u, 3989888399u, 0, LOG10_TOLERANCE, 0},
{ 992, 1056934836u, 1950570756u, 3200582211u, 941022151u, 3222410797u, 3829821005u, 0, LOG10_TOLERANCE, 0},
{ 993, 1057530368u, 2075610870u, 3250142022u, 3605152103u, 3222360045u, 3676911858u, 0, LOG10_TOLERANCE, 0},
{ 994, 1053355602u, 3792931748u, 3204857863u, 804393211u, 3222674329u, 223063370u, 0, LOG10_TOLERANCE, 0},
{ 995, 1106162722u, 3430071177u, 3226288311u, 3652522729u, 1076050657u, 1188151311u, 0, LOG10_TOLERANCE, 0},
{ 996, 1053831054u, 236884699u, 3227874605u, 2193269825u, 3222644595u, 2414521413u, 0, LOG10_TOLERANCE, 0},
{ 997, 1064936593u, 2744231849u, 1046186036u, 771053722u, 3221332108u, 3768168054u, 0, LOG10_TOLERANCE, 0},
{ 998, 1083996036u, 3000189819u, 1096500901u, 2057239777u, 1074402699u, 1446789637u, 0, LOG10_TOLERANCE, 0},
{ 999, 1093835581u, 205759408u, 3244643377u, 2702292618u, 1075337269u, 2939813565u, 0, LOG10_TOLERANCE, 0},


// AUTOMATICALLY GENERATED VECTORS STOP

};

#endif // CYGONCE_LIBM_LOG10_H multiple inclusion protection

// EOF log10.h
