#ifndef CYGONCE_LIBM_LOG_H
#define CYGONCE_LIBM_LOG_H
//===========================================================================
//
//      log.h
//
//      Test vectors for testing of log() math library function
//
//===========================================================================
//####ECOSGPLCOPYRIGHTBEGIN####
// -------------------------------------------
// This file is part of eCos, the Embedded Configurable Operating System.
// Copyright (C) 1998, 1999, 2000, 2001, 2002 Free Software Foundation, Inc.
//
// eCos is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 or (at your option) any later
// version.
//
// eCos is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
// for more details.
//
// You should have received a copy of the GNU General Public License
// along with eCos; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//
// As a special exception, if other files instantiate templates or use
// macros or inline functions from this file, or you compile this file
// and link it with other works to produce a work based on this file,
// this file does not by itself cause the resulting work to be covered by
// the GNU General Public License. However the source code for this file
// must still be made available in accordance with section (3) of the GNU
// General Public License v2.
//
// This exception does not invalidate any other reasons why a work based
// on this file might be covered by the GNU General Public License.
// -------------------------------------------
//####ECOSGPLCOPYRIGHTEND####
//===========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):   jlarmour
// Contributors:  jlarmour
// Date:        1998-02-13
// Purpose:
// Description:
// Usage:       #include "vectors/log.h"
//
//####DESCRIPTIONEND####
//
//===========================================================================


// CONFIGURATION

#include <pkgconf/libm.h>   // Configuration header


// INCLUDES

#include <cyg/infra/cyg_type.h>    // Common type definitions and support
#include "vectors/vector_support.h"// extra support for math tests

#define LOG_TOLERANCE 1.0E-04

static const Cyg_libm_test_double_vec_t log_vec[] = {

// AUTOMATICALLY GENERATED VECTORS START

{ 1, 1077999148u, 2506787616u, 1090024059u, 3619148316u, 1074540891u, 1903028788u, 0, LOG_TOLERANCE, 0},
{ 2, 1070670006u, 3176730980u, 1051524793u, 2993920299u, 3220510532u, 3615487687u, 0, LOG_TOLERANCE, 0},
{ 3, 1092176155u, 2725707538u, 3232101343u, 2346810316u, 1076485723u, 3768096846u, 0, LOG_TOLERANCE, 0},
{ 4, 1092554362u, 2088062470u, 3201242716u, 420891118u, 1076512669u, 440847476u, 0, LOG_TOLERANCE, 0},
{ 5, 1073717029u, 2636405208u, 1100049309u, 471635570u, 1072024788u, 3752333164u, 0, LOG_TOLERANCE, 0},
{ 6, 1089363191u, 1746012320u, 1054478713u, 3333988501u, 1076237152u, 3881795292u, 0, LOG_TOLERANCE, 0},
{ 7, 1047953160u, 183014794u, 3202039382u, 2016785810u, 3224390518u, 1303331829u, 0, LOG_TOLERANCE, 0},
{ 8, 1066002386u, 2688957927u, 1046089230u, 2709029994u, 3222371083u, 2601131004u, 0, LOG_TOLERANCE, 0},
{ 9, 1058795730u, 624574473u, 1045840574u, 3473266330u, 3223472906u, 2217450498u, 0, LOG_TOLERANCE, 0},
{ 10, 1057436194u, 1605286142u, 1068931671u, 4233776869u, 3223588152u, 3229387891u, 0, LOG_TOLERANCE, 0},
{ 11, 1060343410u, 1857607719u, 3222889559u, 3417070006u, 3223337966u, 225906160u, 0, LOG_TOLERANCE, 0},
{ 12, 1103599987u, 3981151660u, 1088899021u, 1332651746u, 1077181802u, 896846388u, 0, LOG_TOLERANCE, 0},
{ 13, 1085298022u, 3824988054u, 1066856791u, 2070129652u, 1075883331u, 34639343u, 0, LOG_TOLERANCE, 0},
{ 14, 1060076142u, 1372884064u, 1080833116u, 3229926662u, 3223366428u, 4150257867u, 0, LOG_TOLERANCE, 0},
{ 15, 1093826501u, 3217805330u, 3191644264u, 2014578707u, 1076626245u, 603858158u, 0, LOG_TOLERANCE, 0},
{ 16, 1102287487u, 265058758u, 3239903247u, 1630600647u, 1077124113u, 3025164482u, 0, LOG_TOLERANCE, 0},
{ 17, 1071124229u, 1946677669u, 3198462609u, 926009897u, 3220131571u, 69509414u, 0, LOG_TOLERANCE, 0},
{ 18, 1072130299u, 2271884183u, 3203741999u, 2118617783u, 3218342176u, 3539920578u, 0, LOG_TOLERANCE, 0},
{ 19, 1047365461u, 213658772u, 3249401130u, 314151656u, 3224418117u, 3079041052u, 0, LOG_TOLERANCE, 0},
{ 20, 1106628640u, 1564829925u, 3197817016u, 497230814u, 1077312921u, 3110556593u, 0, LOG_TOLERANCE, 0},
{ 21, 1068778986u, 2075329122u, 3231746400u, 169900577u, 3221506428u, 2398289983u, 0, LOG_TOLERANCE, 0},
{ 22, 1049848642u, 541549344u, 1096608669u, 3119070100u, 3224247412u, 1892715843u, 0, LOG_TOLERANCE, 0},
{ 23, 1085427055u, 567496114u, 1045286891u, 1969998540u, 1075898248u, 2464173132u, 0, LOG_TOLERANCE, 0},
{ 24, 1060548195u, 1299369769u, 1049342524u, 4167404066u, 3223314449u, 3975492231u, 0, LOG_TOLERANCE, 0},
{ 25, 1061381997u, 3348930841u, 1078472138u, 358457347u, 3223173654u, 3330331685u, 0, LOG_TOLERANCE, 0},
{ 26, 1071069297u, 2192461366u, 1099527247u, 3184735642u, 3220191417u, 194538985u, 0, LOG_TOLERANCE, 0},
{ 27, 1052861772u, 331696577u, 3189610016u, 793242270u, 3223989277u, 2142326960u, 0, LOG_TOLERANCE, 0},
{ 28, 1105045286u, 2322696981u, 1083791358u, 3020766674u, 1077242192u, 3024017455u, 0, LOG_TOLERANCE, 0},
{ 29, 1044902177u, 252085215u, 3214426435u, 4139068910u, 3224522714u, 3356017132u, 0, LOG_TOLERANCE, 0},
{ 30, 1075022077u, 105589263u, 1056316170u, 261630827u, 1073307628u, 2770724689u, 0, LOG_TOLERANCE, 0},
{ 31, 1107213408u, 428765703u, 3251828686u, 2009972239u, 1077335395u, 2429249706u, 0, LOG_TOLERANCE, 0},
{ 32, 1098568019u, 3517376586u, 3240257920u, 3304487302u, 1076963049u, 3484578711u, 0, LOG_TOLERANCE, 0},
{ 33, 1086054264u, 237004814u, 3237899261u, 3364008659u, 1075953380u, 1844071u, 0, LOG_TOLERANCE, 0},
{ 34, 1047763904u, 472004928u, 3226869477u, 1186387580u, 3224399522u, 1007725918u, 0, LOG_TOLERANCE, 0},
{ 35, 1054226850u, 4085763910u, 1106394906u, 2684738273u, 3223866312u, 1979790125u, 0, LOG_TOLERANCE, 0},
{ 36, 1057053639u, 2055490142u, 3231581370u, 3879040079u, 3223626149u, 806421346u, 0, LOG_TOLERANCE, 0},
{ 37, 1041492999u, 3725731239u, 1061652681u, 591292963u, 3224671038u, 4206351851u, 0, LOG_TOLERANCE, 0},
{ 38, 1077531333u, 1147041027u, 3215417793u, 624695933u, 1074397854u, 304138034u, 0, LOG_TOLERANCE, 0},
{ 39, 1058569126u, 705725219u, 3238067573u, 1116238321u, 3223490221u, 3627345304u, 0, LOG_TOLERANCE, 0},
{ 40, 1059883440u, 7287411u, 1045917232u, 116067742u, 3223379282u, 2727133729u, 0, LOG_TOLERANCE, 0},
{ 41, 1092571574u, 3604989074u, 1066381836u, 545298780u, 1076513772u, 3839904761u, 0, LOG_TOLERANCE, 0},
{ 42, 1071597288u, 1681476121u, 1060345752u, 3553822398u, 3219581306u, 453941245u, 0, LOG_TOLERANCE, 0},
{ 43, 1102831658u, 3410480388u, 1052460275u, 1660607230u, 1077147289u, 3910731824u, 0, LOG_TOLERANCE, 0},
{ 44, 1089216869u, 1494984673u, 3196647153u, 287894723u, 1076227142u, 81073844u, 0, LOG_TOLERANCE, 0},
{ 45, 1054885127u, 644548665u, 1081948134u, 2442134629u, 3223816344u, 2988035667u, 0, LOG_TOLERANCE, 0},
{ 46, 1087554095u, 2312530895u, 3221584595u, 3379665576u, 1076083178u, 4168414754u, 0, LOG_TOLERANCE, 0},
{ 47, 1096085375u, 3018463866u, 1086226574u, 404012923u, 1076824388u, 355380855u, 0, LOG_TOLERANCE, 0},
{ 48, 1064733299u, 1710279345u, 3251401196u, 3528946000u, 3222589259u, 4043295995u, 0, LOG_TOLERANCE, 0},
{ 49, 1061536351u, 2164450219u, 1083520023u, 3312018966u, 3223143623u, 2781389049u, 0, LOG_TOLERANCE, 0},
{ 50, 1057248676u, 2648986431u, 1050330591u, 1474376550u, 3223605408u, 2621621078u, 0, LOG_TOLERANCE, 0},
{ 51, 1046938380u, 1839068700u, 1077406406u, 3013052171u, 3224434459u, 186039155u, 0, LOG_TOLERANCE, 0},
{ 52, 1046493630u, 772102380u, 3220729740u, 4219039958u, 3224457358u, 3891328709u, 0, LOG_TOLERANCE, 0},
{ 53, 1081988573u, 3058618779u, 1046304788u, 3338676024u, 1075358802u, 3664366177u, 0, LOG_TOLERANCE, 0},
{ 54, 1051172137u, 506286854u, 1094907481u, 2217000199u, 3224130924u, 2266434652u, 0, LOG_TOLERANCE, 0},
{ 55, 1082428310u, 1147428263u, 1065432625u, 3034786717u, 1075442710u, 1201247296u, 0, LOG_TOLERANCE, 0},
{ 56, 1082016752u, 2844125311u, 1082985198u, 2561492677u, 1075362553u, 3473284473u, 0, LOG_TOLERANCE, 0},
{ 57, 1064053268u, 704542600u, 3222902057u, 2762779203u, 3222712577u, 292535648u, 0, LOG_TOLERANCE, 0},
{ 58, 1052196966u, 184131949u, 3249723525u, 1667366082u, 3224042099u, 902609229u, 0, LOG_TOLERANCE, 0},
{ 59, 1076125950u, 3904224140u, 1067056698u, 2942159914u, 1073910305u, 801875395u, 0, LOG_TOLERANCE, 0},
{ 60, 1100636863u, 426114282u, 3209056785u, 1083606355u, 1077052837u, 3461243802u, 0, LOG_TOLERANCE, 0},
{ 61, 1106165945u, 3774123863u, 1106787580u, 2722107965u, 1077290005u, 3002616544u, 0, LOG_TOLERANCE, 0},
{ 62, 1088005092u, 1377734762u, 1104232051u, 2377063483u, 1076124140u, 2634112070u, 0, LOG_TOLERANCE, 0},
{ 63, 1069380559u, 1029739074u, 1105467109u, 3062201018u, 3221310617u, 3355564135u, 0, LOG_TOLERANCE, 0},
{ 64, 1087257949u, 773857656u, 3214251949u, 335833884u, 1076054914u, 2342316503u, 0, LOG_TOLERANCE, 0},
{ 65, 1055740962u, 1473865960u, 1103073830u, 4000427507u, 3223739108u, 2937886411u, 0, LOG_TOLERANCE, 0},
{ 66, 1103185231u, 4242092620u, 1067009473u, 14539161u, 1077161341u, 1502148359u, 0, LOG_TOLERANCE, 0},
{ 67, 1045032426u, 1732245037u, 1101371955u, 1533536108u, 3224517488u, 2540091285u, 0, LOG_TOLERANCE, 0},
{ 68, 1101670347u, 1833841275u, 1099430098u, 4144145552u, 1077097689u, 1827704426u, 0, LOG_TOLERANCE, 0},
{ 69, 1096786815u, 935007012u, 3188865420u, 604442938u, 1076878511u, 3599854352u, 0, LOG_TOLERANCE, 0},
{ 70, 1059419605u, 2211464602u, 1046255144u, 1635910526u, 3223416641u, 2853698743u, 0, LOG_TOLERANCE, 0},
{ 71, 1077871417u, 2549219008u, 3231633258u, 3733639385u, 1074493859u, 1273814856u, 0, LOG_TOLERANCE, 0},
{ 72, 1082095089u, 1819374372u, 3202219056u, 2617077637u, 1075372707u, 3860522421u, 0, LOG_TOLERANCE, 0},
{ 73, 1094345280u, 546465680u, 1048653554u, 532401530u, 1076673000u, 3709218343u, 0, LOG_TOLERANCE, 0},
{ 74, 1044571091u, 2759019783u, 3221570188u, 3554409630u, 3224538246u, 3654279494u, 0, LOG_TOLERANCE, 0},
{ 75, 1065447634u, 2527221960u, 1099107978u, 2696971136u, 3222474800u, 4009812961u, 0, LOG_TOLERANCE, 0},
{ 76, 1097158000u, 173134582u, 1087299442u, 2877794600u, 1076902534u, 3732378643u, 0, LOG_TOLERANCE, 0},
{ 77, 1086400474u, 547642046u, 3197285510u, 3521286127u, 1075980619u, 1773153190u, 0, LOG_TOLERANCE, 0},
{ 78, 1074860702u, 1231582831u, 1090971734u, 1653446832u, 1073166352u, 3728304610u, 0, LOG_TOLERANCE, 0},
{ 79, 1061342535u, 3762182190u, 3252967851u, 2615360375u, 3223181918u, 1963485299u, 0, LOG_TOLERANCE, 0},
{ 80, 1053350775u, 2588067350u, 3206610957u, 3551059728u, 3223942494u, 644369098u, 0, LOG_TOLERANCE, 0},
{ 81, 1059495208u, 845263327u, 1073415902u, 1749010288u, 3223409778u, 2981196663u, 0, LOG_TOLERANCE, 0},
{ 82, 1058092722u, 3092685191u, 3190678390u, 2872219490u, 3223536395u, 1369453498u, 0, LOG_TOLERANCE, 0},
{ 83, 1070831407u, 4107255722u, 3205337291u, 3069068345u, 3220369660u, 1794319742u, 0, LOG_TOLERANCE, 0},
{ 84, 1096507209u, 2294867524u, 3216653996u, 2860384670u, 1076859525u, 3809728678u, 0, LOG_TOLERANCE, 0},
{ 85, 1045842702u, 2265437201u, 3240198679u, 1234948614u, 3224481964u, 2712155181u, 0, LOG_TOLERANCE, 0},
{ 86, 1068876281u, 1186945904u, 3251167793u, 1896750851u, 3221469375u, 2742155072u, 0, LOG_TOLERANCE, 0},
{ 87, 1081575478u, 3686084548u, 1079286273u, 3309277689u, 1075296587u, 3889440640u, 0, LOG_TOLERANCE, 0},
{ 88, 1075992592u, 3006860614u, 3231412671u, 2504194724u, 1073855151u, 3443930242u, 0, LOG_TOLERANCE, 0},
{ 89, 1088665612u, 1948717780u, 1048317852u, 3791803982u, 1076180575u, 2837452927u, 0, LOG_TOLERANCE, 0},
{ 90, 1064345015u, 4272034420u, 3192982124u, 1526175922u, 3222669202u, 2086824310u, 0, LOG_TOLERANCE, 0},
{ 91, 1098334178u, 4108948538u, 1104691287u, 640541190u, 1076953692u, 3764323674u, 0, LOG_TOLERANCE, 0},
{ 92, 1059773769u, 3259274853u, 1082507103u, 3677038020u, 3223387203u, 652947737u, 0, LOG_TOLERANCE, 0},
{ 93, 1083132498u, 3781708548u, 1096584871u, 1207386447u, 1075552988u, 2879643514u, 0, LOG_TOLERANCE, 0},
{ 94, 1041211624u, 3011191657u, 1103798670u, 1096124830u, 3224686171u, 4236981062u, 0, LOG_TOLERANCE, 0},
{ 95, 1063235023u, 2540404725u, 3240157452u, 4122845725u, 3222863454u, 3023388900u, 0, LOG_TOLERANCE, 0},
{ 96, 1083643710u, 311336721u, 3214382367u, 4212533768u, 1075655034u, 3985941u, 0, LOG_TOLERANCE, 0},
{ 97, 1051139427u, 1769686293u, 3240200923u, 3538602249u, 3224133724u, 2580792529u, 0, LOG_TOLERANCE, 0},
{ 98, 1078227549u, 508056696u, 1103793878u, 776520138u, 1074638865u, 873855649u, 0, LOG_TOLERANCE, 0},
{ 99, 1102910577u, 4064962760u, 1077424413u, 819766631u, 1077150061u, 2488377505u, 0, LOG_TOLERANCE, 0},
{ 100, 1074178362u, 2112385259u, 3227593179u, 1187058516u, 1072736455u, 2653940335u, 0, LOG_TOLERANCE, 0},
{ 101, 1082295059u, 2514398118u, 1076579751u, 870169764u, 1075415392u, 845037314u, 0, LOG_TOLERANCE, 0},
{ 102, 1099367744u, 1190259653u, 1069112254u, 3417249840u, 1076998470u, 583465987u, 0, LOG_TOLERANCE, 0},
{ 103, 1046179435u, 3467757357u, 3215075200u, 2168175352u, 3224468372u, 699090977u, 0, LOG_TOLERANCE, 0},
{ 104, 1092159487u, 1508888184u, 1060430241u, 3524949092u, 1076484398u, 3433728995u, 0, LOG_TOLERANCE, 0},
{ 105, 1049929235u, 166402802u, 3237198975u, 3572369260u, 3224239364u, 1031401866u, 0, LOG_TOLERANCE, 0},
{ 106, 1081866822u, 2441536203u, 3202753937u, 3658194573u, 1075341949u, 2087866809u, 0, LOG_TOLERANCE, 0},
{ 107, 1062392908u, 2479742828u, 1062342831u, 4214154303u, 3222999832u, 525496360u, 0, LOG_TOLERANCE, 0},
{ 108, 1082396794u, 426896765u, 1066474375u, 2201754442u, 1075436501u, 1627606965u, 0, LOG_TOLERANCE, 0},
{ 109, 1048145373u, 2055773734u, 3239267288u, 291396537u, 3224382486u, 3880399396u, 0, LOG_TOLERANCE, 0},
{ 110, 1089484385u, 874125203u, 3210508124u, 4091098764u, 1076245763u, 2990601621u, 0, LOG_TOLERANCE, 0},
{ 111, 1065716026u, 120488169u, 3241241441u, 1985269424u, 3222419509u, 1596544603u, 0, LOG_TOLERANCE, 0},
{ 112, 1059055762u, 2243036871u, 3243941101u, 740033495u, 3223455501u, 3494510298u, 0, LOG_TOLERANCE, 0},
{ 113, 1061941258u, 1176656356u, 1074261978u, 3588756231u, 3223078104u, 2251846605u, 0, LOG_TOLERANCE, 0},
{ 114, 1105333143u, 3037249392u, 1061635587u, 1173102190u, 1077255068u, 2564022463u, 0, LOG_TOLERANCE, 0},
{ 115, 1089725933u, 2882725208u, 1071440059u, 69225090u, 1076272613u, 3133483140u, 0, LOG_TOLERANCE, 0},
{ 116, 1065179826u, 272319256u, 1072073912u, 2493997123u, 3222520025u, 35444247u, 0, LOG_TOLERANCE, 0},
{ 117, 1057720186u, 188610379u, 3232757923u, 2209647371u, 3223565703u, 1891613632u, 0, LOG_TOLERANCE, 0},
{ 118, 1089274869u, 1990439193u, 1078073146u, 622849962u, 1076231202u, 576311790u, 0, LOG_TOLERANCE, 0},
{ 119, 1057135741u, 756052458u, 1081649113u, 2247475162u, 3223617015u, 1816165507u, 0, LOG_TOLERANCE, 0},
{ 120, 1061623064u, 3878055211u, 3222407050u, 2979438623u, 3223128149u, 56153389u, 0, LOG_TOLERANCE, 0},
{ 121, 1047807349u, 2676398686u, 1105124431u, 3631096636u, 3224397343u, 888392923u, 0, LOG_TOLERANCE, 0},
{ 122, 1065079390u, 1697791764u, 3198136112u, 2299842819u, 3222534081u, 901870173u, 0, LOG_TOLERANCE, 0},
{ 123, 1078084768u, 1931502677u, 3215264397u, 3016456382u, 1074579794u, 2595838239u, 0, LOG_TOLERANCE, 0},
{ 124, 1072253426u, 343404215u, 1061072607u, 4266232536u, 3217957038u, 249307172u, 0, LOG_TOLERANCE, 0},
{ 125, 1093747188u, 4140316002u, 1082896196u, 868256971u, 1076617361u, 2144012240u, 0, LOG_TOLERANCE, 0},
{ 126, 1075422810u, 1864139509u, 3187675097u, 3084482407u, 1073593180u, 257551340u, 0, LOG_TOLERANCE, 0},
{ 127, 1072707675u, 2427162817u, 3234748208u, 2715105792u, 1066138778u, 4007247913u, 0, LOG_TOLERANCE, 0},
{ 128, 1064600512u, 3943389284u, 1046724025u, 3626825684u, 3222613950u, 3450803557u, 0, LOG_TOLERANCE, 0},
{ 129, 1045423002u, 967350972u, 1093012318u, 448002663u, 3224503930u, 40325151u, 0, LOG_TOLERANCE, 0},
{ 130, 1104362211u, 105058217u, 1069733884u, 171786224u, 1077213809u, 3629677324u, 0, LOG_TOLERANCE, 0},
{ 131, 1042130860u, 2863482262u, 3204997271u, 877784425u, 3224644968u, 1676714437u, 0, LOG_TOLERANCE, 0},
{ 132, 1055145665u, 2801782962u, 3213604117u, 762347195u, 3223787690u, 2201912701u, 0, LOG_TOLERANCE, 0},
{ 133, 1086003079u, 2317950339u, 3246333414u, 2135700283u, 1075949654u, 3685526240u, 0, LOG_TOLERANCE, 0},
{ 134, 1056516397u, 4171919805u, 1082858682u, 2180920863u, 3223668346u, 2563284746u, 0, LOG_TOLERANCE, 0},
{ 135, 1072665436u, 1918836931u, 1083603224u, 3137821660u, 3213580135u, 893380042u, 0, LOG_TOLERANCE, 0},
{ 136, 1103902874u, 3456203663u, 3235600523u, 2335688936u, 1077193523u, 822124921u, 0, LOG_TOLERANCE, 0},
{ 137, 1042279322u, 4170235262u, 1051824459u, 521583737u, 3224640144u, 325222787u, 0, LOG_TOLERANCE, 0},
{ 138, 1081348303u, 1296623194u, 3250673860u, 2442872540u, 1075254813u, 4250911823u, 0, LOG_TOLERANCE, 0},
{ 139, 1061684277u, 289979405u, 1049514449u, 3865737145u, 3223117750u, 1822741563u, 0, LOG_TOLERANCE, 0},
{ 140, 1075298944u, 3699090239u, 1054539840u, 3259249360u, 1073512919u, 2889360534u, 0, LOG_TOLERANCE, 0},
{ 141, 1096418100u, 1619819023u, 1045993352u, 1022642459u, 1076852847u, 2966471226u, 0, LOG_TOLERANCE, 0},
{ 142, 1081433004u, 19455098u, 3229182089u, 2096003654u, 1075271177u, 857411703u, 0, LOG_TOLERANCE, 0},
{ 143, 1076297936u, 3803689997u, 1071630912u, 2263729518u, 1073973813u, 3836746166u, 0, LOG_TOLERANCE, 0},
{ 144, 1101357261u, 2816837387u, 1063422305u, 2597606398u, 1077084471u, 2387840489u, 0, LOG_TOLERANCE, 0},
{ 145, 1069100169u, 3680967506u, 1040201163u, 179224723u, 3221392912u, 284483311u, 0, LOG_TOLERANCE, 0},
{ 146, 1041146119u, 978126928u, 1101553990u, 4047893399u, 3224688276u, 2169141442u, 0, LOG_TOLERANCE, 0},
{ 147, 1074838397u, 4059818629u, 1042678728u, 3640293589u, 1073145238u, 3502645173u, 0, LOG_TOLERANCE, 0},
{ 148, 1100980392u, 3383497159u, 1070002807u, 1527313008u, 1077064713u, 1414579044u, 0, LOG_TOLERANCE, 0},
{ 149, 1055224031u, 2599946514u, 1104170406u, 2738675352u, 3223780168u, 3507302766u, 0, LOG_TOLERANCE, 0},
{ 150, 1105232623u, 3616571377u, 1060859316u, 1130603218u, 1077249247u, 447338991u, 0, LOG_TOLERANCE, 0},
{ 151, 1076028796u, 3859211180u, 1067940450u, 1744531824u, 1073870707u, 3139112125u, 0, LOG_TOLERANCE, 0},
{ 152, 1042831340u, 1958025850u, 3236511256u, 2472176453u, 3224612476u, 4074628725u, 0, LOG_TOLERANCE, 0},
{ 153, 1085623441u, 182132862u, 3250520938u, 3924356991u, 1075918122u, 3179461172u, 0, LOG_TOLERANCE, 0},
{ 154, 1083018236u, 35632886u, 3209806504u, 1453402523u, 1075537959u, 623164823u, 0, LOG_TOLERANCE, 0},
{ 155, 1083522102u, 743225214u, 3202890678u, 142917400u, 1075633073u, 1072570609u, 0, LOG_TOLERANCE, 0},
{ 156, 1080684976u, 1472665012u, 3203138231u, 256588219u, 1075140463u, 1443082546u, 0, LOG_TOLERANCE, 0},
{ 157, 1094982162u, 1062927000u, 1061134072u, 931677439u, 1076728209u, 2297940933u, 0, LOG_TOLERANCE, 0},
{ 158, 1058377732u, 2320910576u, 1055663370u, 288059864u, 3223506870u, 2768289813u, 0, LOG_TOLERANCE, 0},
{ 159, 1078958093u, 1448349062u, 3199478070u, 3454027134u, 1074828702u, 2706157180u, 0, LOG_TOLERANCE, 0},
{ 160, 1089975150u, 4215445172u, 3196654963u, 2231888973u, 1076295536u, 1878052368u, 0, LOG_TOLERANCE, 0},
{ 161, 1099148583u, 40413554u, 3232578253u, 983832844u, 1076988183u, 659398356u, 0, LOG_TOLERANCE, 0},
{ 162, 1076237886u, 3995725873u, 1050082319u, 777231627u, 1073952502u, 2239349650u, 0, LOG_TOLERANCE, 0},
{ 163, 1040986626u, 672789828u, 3253385962u, 2982787335u, 3224693702u, 1244542645u, 0, LOG_TOLERANCE, 0},
{ 164, 1068390875u, 2075971825u, 1070166500u, 4034633931u, 3221658269u, 491532286u, 0, LOG_TOLERANCE, 0},
{ 165, 1062562529u, 1018222907u, 3244621407u, 3090050495u, 3222966069u, 1798186974u, 0, LOG_TOLERANCE, 0},
{ 166, 1067680885u, 937732557u, 3200798890u, 2557898276u, 3221889754u, 422952393u, 0, LOG_TOLERANCE, 0},
{ 167, 1078342316u, 130346162u, 3223590310u, 275568693u, 1074681949u, 957372433u, 0, LOG_TOLERANCE, 0},
{ 168, 1042898869u, 3807416441u, 1075961161u, 3706820266u, 3224609760u, 104190259u, 0, LOG_TOLERANCE, 0},
{ 169, 1068615357u, 1710131411u, 1078123323u, 1900790503u, 3221575334u, 2209933262u, 0, LOG_TOLERANCE, 0},
{ 170, 1091335713u, 3420420033u, 3210844787u, 588423066u, 1076410379u, 2857617467u, 0, LOG_TOLERANCE, 0},
{ 171, 1049684114u, 1160162008u, 3246307879u, 4265764460u, 3224265557u, 1934933585u, 0, LOG_TOLERANCE, 0},
{ 172, 1102543434u, 366653268u, 3188814424u, 466059202u, 1077136037u, 807141120u, 0, LOG_TOLERANCE, 0},
{ 173, 1079144091u, 1325936170u, 3221436876u, 680097612u, 1074869144u, 1389489581u, 0, LOG_TOLERANCE, 0},
{ 174, 1092907468u, 1827735934u, 3200554324u, 2875599271u, 1076548720u, 3300536450u, 0, LOG_TOLERANCE, 0},
{ 175, 1043546754u, 3117037091u, 3239246636u, 15838845u, 3224582402u, 735648025u, 0, LOG_TOLERANCE, 0},
{ 176, 1051974004u, 749718883u, 3223587064u, 1523766569u, 3224062834u, 1671881275u, 0, LOG_TOLERANCE, 0},
{ 177, 1044833651u, 1966536294u, 3250158026u, 699164258u, 3224525641u, 1389402172u, 0, LOG_TOLERANCE, 0},
{ 178, 1098048435u, 3759049394u, 1106085272u, 1183789499u, 1076940082u, 1040831789u, 0, LOG_TOLERANCE, 0},
{ 179, 1081201623u, 1970107747u, 1095245453u, 2308233883u, 1075223810u, 3769104780u, 0, LOG_TOLERANCE, 0},
{ 180, 1084756444u, 1491017852u, 1041444355u, 1723375725u, 1075843299u, 2828558175u, 0, LOG_TOLERANCE, 0},
{ 181, 1069146422u, 1141349287u, 1097465301u, 3403438584u, 3221378415u, 3648723478u, 0, LOG_TOLERANCE, 0},
{ 182, 1083088260u, 1711085243u, 3250239076u, 1377484108u, 1075547271u, 2365864324u, 0, LOG_TOLERANCE, 0},
{ 183, 1098385019u, 2880275004u, 1084039594u, 1611394950u, 1076955843u, 3972039239u, 0, LOG_TOLERANCE, 0},
{ 184, 1086737787u, 2626629370u, 1063771493u, 1499080813u, 1076015009u, 3210927368u, 0, LOG_TOLERANCE, 0},
{ 185, 1055231263u, 3936262414u, 1103919063u, 3175668759u, 3223779495u, 3949784643u, 0, LOG_TOLERANCE, 0},
{ 186, 1060498071u, 1270950554u, 3194616071u, 3680565379u, 3223323033u, 321203519u, 0, LOG_TOLERANCE, 0},
{ 187, 1060664575u, 1066985223u, 3221613219u, 4089383168u, 3223294689u, 1322613376u, 0, LOG_TOLERANCE, 0},
{ 188, 1069575191u, 4017329311u, 3208334452u, 1667591498u, 3221253465u, 2986438966u, 0, LOG_TOLERANCE, 0},
{ 189, 1088164157u, 3154656624u, 1061894279u, 3886344038u, 1076135995u, 2019766276u, 0, LOG_TOLERANCE, 0},
{ 190, 1050652945u, 977586119u, 3209762784u, 953839852u, 3224183212u, 4205833787u, 0, LOG_TOLERANCE, 0},
{ 191, 1104965247u, 143071571u, 3206165386u, 913097445u, 1077239436u, 1428994741u, 0, LOG_TOLERANCE, 0},
{ 192, 1043081808u, 1371169579u, 1057079837u, 2594818628u, 3224602920u, 15908725u, 0, LOG_TOLERANCE, 0},
{ 193, 1104309688u, 2259342224u, 3217432469u, 1824221478u, 1077211020u, 98865074u, 0, LOG_TOLERANCE, 0},
{ 194, 1099351127u, 1576604497u, 1079368611u, 185078728u, 1076997744u, 1291065544u, 0, LOG_TOLERANCE, 0},
{ 195, 1074195779u, 444800035u, 3243343143u, 1734989302u, 1072748681u, 843810783u, 0, LOG_TOLERANCE, 0},
{ 196, 1072748883u, 130452005u, 1041548088u, 2158433515u, 1068136489u, 4008523687u, 0, LOG_TOLERANCE, 0},
{ 197, 1087212320u, 1941318385u, 1045807374u, 792193370u, 1076051861u, 1971888733u, 0, LOG_TOLERANCE, 0},
{ 198, 1090816018u, 1299392207u, 3212131720u, 3205732280u, 1076367573u, 2393072u, 0, LOG_TOLERANCE, 0},
{ 199, 1098698804u, 3035093505u, 1052187689u, 3287702190u, 1076967753u, 3012582896u, 0, LOG_TOLERANCE, 0},
{ 200, 1099192612u, 2160225215u, 1102624859u, 836655570u, 1076990383u, 2071736056u, 0, LOG_TOLERANCE, 0},
{ 201, 1096723626u, 3360816360u, 3246176356u, 172860634u, 1076874455u, 1406950864u, 0, LOG_TOLERANCE, 0},
{ 202, 1070995788u, 146831910u, 1051558014u, 2340722078u, 3220243332u, 3261297932u, 0, LOG_TOLERANCE, 0},
{ 203, 1082932703u, 1603798153u, 3207725532u, 1099413093u, 1075526116u, 1499961334u, 0, LOG_TOLERANCE, 0},
{ 204, 1099194730u, 2429340443u, 3190303581u, 3223770005u, 1076990487u, 2107238709u, 0, LOG_TOLERANCE, 0},
{ 205, 1075882959u, 955542166u, 3230415151u, 275583938u, 1073805017u, 587786177u, 0, LOG_TOLERANCE, 0},
{ 206, 1092971882u, 513397822u, 1090646554u, 2089321329u, 1076554875u, 1291039930u, 0, LOG_TOLERANCE, 0},
{ 207, 1045686228u, 2782073372u, 1046063872u, 4023829068u, 3224489388u, 2570927601u, 0, LOG_TOLERANCE, 0},
{ 208, 1098564822u, 3242223094u, 3194111199u, 4264674108u, 1076962930u, 2095896905u, 0, LOG_TOLERANCE, 0},
{ 209, 1091027173u, 3506346169u, 1047020885u, 1742757458u, 1076386679u, 701024000u, 0, LOG_TOLERANCE, 0},
{ 210, 1045180829u, 1265459564u, 3193450280u, 3650514880u, 3224512001u, 2115795402u, 0, LOG_TOLERANCE, 0},
{ 211, 1081755890u, 1525260440u, 3235452527u, 2612331392u, 1075325589u, 1311722038u, 0, LOG_TOLERANCE, 0},
{ 212, 1101185272u, 1263613754u, 3219096387u, 635677201u, 1077075888u, 464532810u, 0, LOG_TOLERANCE, 0},
{ 213, 1058788439u, 4140947288u, 3200792376u, 2013265346u, 3223473429u, 1675510139u, 0, LOG_TOLERANCE, 0},
{ 214, 1102490744u, 1912759945u, 3237045253u, 1351396825u, 1077133753u, 2656194917u, 0, LOG_TOLERANCE, 0},
{ 215, 1100721514u, 1001433078u, 3206926643u, 2741676659u, 1077055969u, 4157777791u, 0, LOG_TOLERANCE, 0},
{ 216, 1080923606u, 1088945233u, 1085095743u, 3986114865u, 1075174891u, 2711796576u, 0, LOG_TOLERANCE, 0},
{ 217, 1068250409u, 831239754u, 1099828675u, 3071308141u, 3221696665u, 3906974917u, 0, LOG_TOLERANCE, 0},
{ 218, 1078350849u, 3473592372u, 1102759382u, 1309576357u, 1074685015u, 3258092383u, 0, LOG_TOLERANCE, 0},
{ 219, 1103703058u, 2042340367u, 1091945628u, 2062772374u, 1077186030u, 1455653889u, 0, LOG_TOLERANCE, 0},
{ 220, 1047282039u, 1840632537u, 1096533424u, 807510337u, 3224421005u, 2259729181u, 0, LOG_TOLERANCE, 0},
{ 221, 1083968074u, 144814872u, 3212698915u, 2282965697u, 1075705943u, 2949949432u, 0, LOG_TOLERANCE, 0},
{ 222, 1071236430u, 2552499583u, 3229111426u, 1470130815u, 3219987405u, 558247611u, 0, LOG_TOLERANCE, 0},
{ 223, 1095609417u, 2858583811u, 1089760910u, 6360994u, 1076779252u, 1692550517u, 0, LOG_TOLERANCE, 0},
{ 224, 1050781281u, 1614537194u, 1075198900u, 4088705365u, 3224169080u, 729983519u, 0, LOG_TOLERANCE, 0},
{ 225, 1103455422u, 3545570051u, 1065221325u, 1629217700u, 1077175370u, 4002504631u, 0, LOG_TOLERANCE, 0},
{ 226, 1072744324u, 1813392963u, 3235313361u, 3772501596u, 1067997677u, 2531803269u, 0, LOG_TOLERANCE, 0},
{ 227, 1049319038u, 2406734491u, 1042055360u, 89226663u, 3224293435u, 489486239u, 0, LOG_TOLERANCE, 0},
{ 228, 1048267433u, 1618759139u, 3194723421u, 3888234802u, 3224377854u, 2361316317u, 0, LOG_TOLERANCE, 0},
{ 229, 1055357248u, 3590035633u, 3212424262u, 2892456615u, 3223768296u, 2784142069u, 0, LOG_TOLERANCE, 0},
{ 230, 1042459412u, 2431246964u, 3241512456u, 183850734u, 3224629872u, 2676796459u, 0, LOG_TOLERANCE, 0},
{ 231, 1089501101u, 3088319870u, 3211544311u, 862225364u, 1076247809u, 3557509436u, 0, LOG_TOLERANCE, 0},
{ 232, 1087811016u, 3495352775u, 1058576726u, 596957268u, 1076108054u, 1212781005u, 0, LOG_TOLERANCE, 0},
{ 233, 1046553348u, 1839214511u, 3205004060u, 1923240983u, 3224453778u, 155767862u, 0, LOG_TOLERANCE, 0},
{ 234, 1058073864u, 739619702u, 3223356436u, 2689885273u, 3223538604u, 4095262392u, 0, LOG_TOLERANCE, 0},
{ 235, 1052841323u, 2143376228u, 1098306332u, 3760236188u, 3223991649u, 3574225414u, 0, LOG_TOLERANCE, 0},
{ 236, 1074621795u, 671680995u, 1091262633u, 2315535361u, 1073010422u, 1713289607u, 0, LOG_TOLERANCE, 0},
{ 237, 1066682341u, 2493598049u, 3194927008u, 1689107592u, 3222233045u, 4244143336u, 0, LOG_TOLERANCE, 0},
{ 238, 1042506311u, 1578976988u, 1066368383u, 2117279163u, 3224627407u, 1544732865u, 0, LOG_TOLERANCE, 0},
{ 239, 1075504463u, 3425290087u, 1098487295u, 1263412017u, 1073642915u, 3833207621u, 0, LOG_TOLERANCE, 0},
{ 240, 1060949116u, 3635396812u, 1070999426u, 3965655689u, 3223251850u, 3656828940u, 0, LOG_TOLERANCE, 0},
{ 241, 1060196346u, 2183973116u, 1101098363u, 1118613350u, 3223353941u, 673602059u, 0, LOG_TOLERANCE, 0},
{ 242, 1074462441u, 199516350u, 1078368488u, 164621458u, 1072919989u, 2683332925u, 0, LOG_TOLERANCE, 0},
{ 243, 1040222370u, 3570940805u, 3230316437u, 3596080877u, 3224728682u, 1709229047u, 0, LOG_TOLERANCE, 0},
{ 244, 1060725917u, 980880313u, 1079833442u, 884465057u, 3223284843u, 3908226837u, 0, LOG_TOLERANCE, 0},
{ 245, 1099977124u, 2558179220u, 1052873711u, 1233598120u, 1077021347u, 3750522257u, 0, LOG_TOLERANCE, 0},
{ 246, 1047115221u, 1909994277u, 1085015978u, 2991527452u, 3224427192u, 1939315825u, 0, LOG_TOLERANCE, 0},
{ 247, 1060855260u, 1680290941u, 1074309900u, 2943870846u, 3223265222u, 1391917703u, 0, LOG_TOLERANCE, 0},
{ 248, 1059496132u, 1451927357u, 3228615456u, 1502585517u, 3223409696u, 4240953644u, 0, LOG_TOLERANCE, 0},
{ 249, 1088728303u, 751136990u, 3230392165u, 3493275472u, 1076186784u, 2895449770u, 0, LOG_TOLERANCE, 0},
{ 250, 1098365967u, 1209623292u, 3238056647u, 979495322u, 1076955046u, 322553682u, 0, LOG_TOLERANCE, 0},
{ 251, 1102940648u, 1717672108u, 1048120593u, 531240316u, 1077151087u, 2450752868u, 0, LOG_TOLERANCE, 0},
{ 252, 1054174923u, 3548721654u, 1086112947u, 3391817224u, 3223871070u, 2651694237u, 0, LOG_TOLERANCE, 0},
{ 253, 1077836851u, 2758195125u, 1100880260u, 2028440924u, 1074484865u, 4212387521u, 0, LOG_TOLERANCE, 0},
{ 254, 1084223893u, 2750123373u, 3232200256u, 1086294931u, 1075740110u, 1796153641u, 0, LOG_TOLERANCE, 0},
{ 255, 1043958672u, 2986160931u, 1076097908u, 2540046258u, 3224563892u, 4131735963u, 0, LOG_TOLERANCE, 0},
{ 256, 1087992954u, 451471221u, 1064816262u, 4187644495u, 1076123190u, 1571278527u, 0, LOG_TOLERANCE, 0},
{ 257, 1099460228u, 2439500162u, 1065280276u, 1979490284u, 1077002369u, 1210365152u, 0, LOG_TOLERANCE, 0},
{ 258, 1040415832u, 2283342035u, 1078398157u, 1345997553u, 3224717916u, 793577502u, 0, LOG_TOLERANCE, 0},
{ 259, 1065765700u, 179066662u, 1103272172u, 1217337578u, 3222410441u, 3473154820u, 0, LOG_TOLERANCE, 0},
{ 260, 1064078729u, 3779303391u, 3210023352u, 3115946280u, 3222708985u, 2675466261u, 0, LOG_TOLERANCE, 0},
{ 261, 1045506226u, 286247089u, 1085153597u, 713645369u, 3224499119u, 1542442198u, 0, LOG_TOLERANCE, 0},
{ 262, 1093670500u, 1468283899u, 1042831668u, 2022736418u, 1076608158u, 1444206071u, 0, LOG_TOLERANCE, 0},
{ 263, 1083139105u, 3305564080u, 1065483445u, 482392433u, 1075553831u, 3885636882u, 0, LOG_TOLERANCE, 0},
{ 264, 1054212159u, 2256346551u, 3222430705u, 2071674991u, 3223867641u, 979926413u, 0, LOG_TOLERANCE, 0},
{ 265, 1056541047u, 2295269094u, 1084451053u, 2773103941u, 3223666401u, 3176085154u, 0, LOG_TOLERANCE, 0},
{ 266, 1078173946u, 1482721827u, 1092243422u, 3125409590u, 1074617461u, 2338252184u, 0, LOG_TOLERANCE, 0},
{ 267, 1073582325u, 1381740563u, 1071545057u, 2918235653u, 1071883840u, 3334584948u, 0, LOG_TOLERANCE, 0},
{ 268, 1091232324u, 1105857967u, 3241990046u, 2703723225u, 1076402905u, 1352770697u, 0, LOG_TOLERANCE, 0},
{ 269, 1043015571u, 174689677u, 1079333374u, 3947057014u, 3224605314u, 4170986094u, 0, LOG_TOLERANCE, 0},
{ 270, 1090461859u, 2023082423u, 3242081486u, 1169047927u, 1076331263u, 3328774237u, 0, LOG_TOLERANCE, 0},
{ 271, 1064525899u, 3742487766u, 1043425732u, 194972788u, 3222628918u, 1375948702u, 0, LOG_TOLERANCE, 0},
{ 272, 1066308179u, 2136071361u, 3211529757u, 993675115u, 3222327669u, 78816142u, 0, LOG_TOLERANCE, 0},
{ 273, 1066179733u, 210772141u, 3241441539u, 580731413u, 3222345037u, 3927815368u, 0, LOG_TOLERANCE, 0},
{ 274, 1093840413u, 1751560711u, 1074522705u, 180987057u, 1076627743u, 550680420u, 0, LOG_TOLERANCE, 0},
{ 275, 1066754591u, 2552236599u, 1088658621u, 2112468655u, 3222205293u, 3536028076u, 0, LOG_TOLERANCE, 0},
{ 276, 1041806969u, 1578223762u, 3224596567u, 2456166162u, 3224656916u, 862250271u, 0, LOG_TOLERANCE, 0},
{ 277, 1058506965u, 2110924310u, 1086207177u, 3161208323u, 3223495400u, 2942554941u, 0, LOG_TOLERANCE, 0},
{ 278, 1084379746u, 2352173188u, 1079361728u, 4070222179u, 1075776093u, 2662684686u, 0, LOG_TOLERANCE, 0},
{ 279, 1101012904u, 2481562701u, 1090937016u, 3809489716u, 1077065985u, 500272335u, 0, LOG_TOLERANCE, 0},
{ 280, 1049519003u, 330905705u, 1086260896u, 90264431u, 3224279566u, 1302925296u, 0, LOG_TOLERANCE, 0},
{ 281, 1040729961u, 4162008079u, 3194387916u, 759522153u, 3224703502u, 4232165330u, 0, LOG_TOLERANCE, 0},
{ 282, 1081015037u, 1839697482u, 3216442625u, 2211508949u, 1075186970u, 3091760478u, 0, LOG_TOLERANCE, 0},
{ 283, 1102323563u, 3736863454u, 1063475914u, 3150741666u, 1077125931u, 2240619440u, 0, LOG_TOLERANCE, 0},
{ 284, 1060785883u, 4200269406u, 3236646101u, 1061812176u, 3223275563u, 4059264129u, 0, LOG_TOLERANCE, 0},
{ 285, 1080217979u, 106027290u, 3234978297u, 2245237549u, 1075056284u, 3935577174u, 0, LOG_TOLERANCE, 0},
{ 286, 1099500686u, 2132131375u, 3250483427u, 3449276437u, 1077004004u, 2860765758u, 0, LOG_TOLERANCE, 0},
{ 287, 1089388778u, 2334440944u, 1105423490u, 4004336184u, 1076238827u, 2435489549u, 0, LOG_TOLERANCE, 0},
{ 288, 1071289056u, 4090088208u, 1042030013u, 3898658299u, 3219923055u, 1857017027u, 0, LOG_TOLERANCE, 0},
{ 289, 1060424416u, 2272831437u, 3253082595u, 2639188641u, 3223329932u, 4210841791u, 0, LOG_TOLERANCE, 0},
{ 290, 1054766684u, 1856594168u, 3189515294u, 4101853676u, 3223824989u, 3244034946u, 0, LOG_TOLERANCE, 0},
{ 291, 1076012412u, 2211699255u, 3195060344u, 3865018604u, 1073863724u, 4035608178u, 0, LOG_TOLERANCE, 0},
{ 292, 1095283362u, 996259334u, 3241496889u, 3782673116u, 1076755197u, 2401647281u, 0, LOG_TOLERANCE, 0},
{ 293, 1099130747u, 3840380763u, 1048674041u, 550040067u, 1076987270u, 1735374993u, 0, LOG_TOLERANCE, 0},
{ 294, 1103935945u, 95874100u, 3237232828u, 2645647822u, 1077194684u, 2850194252u, 0, LOG_TOLERANCE, 0},
{ 295, 1043665640u, 3441419500u, 3252367038u, 876710419u, 3224576503u, 273309740u, 0, LOG_TOLERANCE, 0},
{ 296, 1091109904u, 2560836004u, 3199616543u, 1180840586u, 1076393466u, 634133261u, 0, LOG_TOLERANCE, 0},
{ 297, 1074119318u, 2218230392u, 3227485787u, 3947214579u, 1072693915u, 3593274056u, 0, LOG_TOLERANCE, 0},
{ 298, 1079539654u, 1447312532u, 1081476588u, 780366847u, 1074943401u, 3038225178u, 0, LOG_TOLERANCE, 0},
{ 299, 1072569643u, 2842113832u, 3216156731u, 225159029u, 3215923786u, 3238443975u, 0, LOG_TOLERANCE, 0},
{ 300, 1098117193u, 1601981129u, 3234628869u, 2236538344u, 1076943624u, 3187559764u, 0, LOG_TOLERANCE, 0},
{ 301, 1085173524u, 2194185737u, 3242362684u, 87913366u, 1075874049u, 1040928910u, 0, LOG_TOLERANCE, 0},
{ 302, 1051600232u, 1346862963u, 1077836259u, 3604666660u, 3224098914u, 287386136u, 0, LOG_TOLERANCE, 0},
{ 303, 1064772331u, 3115209742u, 1099332326u, 1325101950u, 3222582423u, 1527830367u, 0, LOG_TOLERANCE, 0},
{ 304, 1077062394u, 3889223100u, 1053247613u, 3371396923u, 1074227736u, 3155029876u, 0, LOG_TOLERANCE, 0},
{ 305, 1072994220u, 4163120793u, 1075022670u, 1387631215u, 1070605899u, 3048914167u, 0, LOG_TOLERANCE, 0},
{ 306, 1057998131u, 1532426189u, 1063168268u, 3397022615u, 3223546922u, 3454376569u, 0, LOG_TOLERANCE, 0},
{ 307, 1053549673u, 89324166u, 1079206060u, 3429424710u, 3223927395u, 296891673u, 0, LOG_TOLERANCE, 0},
{ 308, 1044841454u, 747591401u, 1072238381u, 2803213904u, 3224525301u, 1809647640u, 0, LOG_TOLERANCE, 0},
{ 309, 1091113780u, 271904221u, 1044258318u, 1858545114u, 1076393775u, 2673972484u, 0, LOG_TOLERANCE, 0},
{ 310, 1080585266u, 314958082u, 3249912496u, 2966213175u, 1075124621u, 156791433u, 0, LOG_TOLERANCE, 0},
{ 311, 1049695766u, 3119528953u, 3217179014u, 2908718240u, 3224264186u, 1502162494u, 0, LOG_TOLERANCE, 0},
{ 312, 1094983928u, 2018361566u, 1100926600u, 3985805054u, 1076728385u, 621786893u, 0, LOG_TOLERANCE, 0},
{ 313, 1070132580u, 409584884u, 3239758947u, 755795129u, 3220843859u, 3819242064u, 0, LOG_TOLERANCE, 0},
{ 314, 1075772446u, 1819156379u, 3251342302u, 2982669005u, 1073766572u, 1356860078u, 0, LOG_TOLERANCE, 0},
{ 315, 1101563433u, 2080534280u, 3188254060u, 449171797u, 1077093468u, 3222605176u, 0, LOG_TOLERANCE, 0},
{ 316, 1095956900u, 168744837u, 3214950009u, 1322217822u, 1076811501u, 1717897709u, 0, LOG_TOLERANCE, 0},
{ 317, 1106743252u, 3250487255u, 1062120700u, 1876195180u, 1077317976u, 138849911u, 0, LOG_TOLERANCE, 0},
{ 318, 1078859832u, 1336400247u, 1098057903u, 3314079581u, 1074815957u, 1152068432u, 0, LOG_TOLERANCE, 0},
{ 319, 1056195172u, 265025555u, 1063854282u, 3779482256u, 3223696746u, 1903973229u, 0, LOG_TOLERANCE, 0},
{ 320, 1067300501u, 887044257u, 1054789618u, 2732056261u, 3222032812u, 2455803958u, 0, LOG_TOLERANCE, 0},
{ 321, 1050106742u, 4027115185u, 3191764868u, 2940199511u, 3224223208u, 4043849432u, 0, LOG_TOLERANCE, 0},
{ 322, 1055016507u, 2875684421u, 3227459837u, 2251967570u, 3223801114u, 1956518469u, 0, LOG_TOLERANCE, 0},
{ 323, 1063244412u, 284173546u, 3238823679u, 3557800647u, 3222862271u, 3966292736u, 0, LOG_TOLERANCE, 0},
{ 324, 1101458560u, 3147771266u, 3220110464u, 2933364246u, 1077089046u, 2278939221u, 0, LOG_TOLERANCE, 0},
{ 325, 1064853160u, 3366183281u, 3234870843u, 537442654u, 3222568808u, 3221004128u, 0, LOG_TOLERANCE, 0},
{ 326, 1096635140u, 2529029548u, 3249882819u, 3781513577u, 1076868555u, 562313644u, 0, LOG_TOLERANCE, 0},
{ 327, 1065952706u, 1080845539u, 3206760016u, 911778687u, 3222378869u, 341314984u, 0, LOG_TOLERANCE, 0},
{ 328, 1044467388u, 469586759u, 1091830022u, 3080528840u, 3224543980u, 1618140319u, 0, LOG_TOLERANCE, 0},
{ 329, 1080249104u, 2863108169u, 3225605506u, 2508274250u, 1075062818u, 3647419175u, 0, LOG_TOLERANCE, 0},
{ 330, 1063343336u, 4080017377u, 3206492941u, 1470284690u, 3222839853u, 2867700472u, 0, LOG_TOLERANCE, 0},
{ 331, 1059636742u, 3867917386u, 1102054928u, 3504746045u, 3223397823u, 1671545983u, 0, LOG_TOLERANCE, 0},
{ 332, 1064522279u, 2962134101u, 3244741577u, 3390537350u, 3222629666u, 3158492516u, 0, LOG_TOLERANCE, 0},
{ 333, 1088201813u, 1702237980u, 1071598971u, 1102587474u, 1076138651u, 2622934639u, 0, LOG_TOLERANCE, 0},
{ 334, 1055486470u, 2180218657u, 3211592260u, 1206527853u, 3223757724u, 3258037863u, 0, LOG_TOLERANCE, 0},
{ 335, 1049601096u, 394130786u, 3242511482u, 2437699868u, 3224274271u, 3825574203u, 0, LOG_TOLERANCE, 0},
{ 336, 1044237059u, 849581558u, 3252006507u, 2008614943u, 3224553811u, 3657190491u, 0, LOG_TOLERANCE, 0},
{ 337, 1062656366u, 3128971673u, 3249137531u, 2773583059u, 3222949104u, 4235986512u, 0, LOG_TOLERANCE, 0},
{ 338, 1085029866u, 590727700u, 3248651761u, 2183878539u, 1075864251u, 1337466743u, 0, LOG_TOLERANCE, 0},
{ 339, 1101098629u, 820687580u, 3208143496u, 1402434664u, 1077071097u, 630507849u, 0, LOG_TOLERANCE, 0},
{ 340, 1104807187u, 1873709254u, 3245167989u, 44275991u, 1077233627u, 35393437u, 0, LOG_TOLERANCE, 0},
{ 341, 1042185105u, 1174874204u, 3208263730u, 2360372288u, 3224643164u, 1125405730u, 0, LOG_TOLERANCE, 0},
{ 342, 1103854676u, 937573440u, 3208953761u, 211240241u, 1077191792u, 2799624452u, 0, LOG_TOLERANCE, 0},
{ 343, 1096065286u, 2469774991u, 1043117070u, 3380071805u, 1076822454u, 3235225443u, 0, LOG_TOLERANCE, 0},
{ 344, 1058121042u, 442507560u, 3254252803u, 3257889649u, 3223533145u, 2585938391u, 0, LOG_TOLERANCE, 0},
{ 345, 1068850520u, 1854921625u, 1049810168u, 2729627545u, 3221478934u, 598289984u, 0, LOG_TOLERANCE, 0},
{ 346, 1107228981u, 4001809575u, 3240128649u, 278261523u, 1077335900u, 1358170156u, 0, LOG_TOLERANCE, 0},
{ 347, 1087224694u, 1793907966u, 3238955714u, 398859249u, 1076052696u, 2028953044u, 0, LOG_TOLERANCE, 0},
{ 348, 1053468899u, 2511916952u, 3219195283u, 1697158299u, 3223933318u, 3252060136u, 0, LOG_TOLERANCE, 0},
{ 349, 1069985548u, 3230931724u, 3243897690u, 3508781585u, 3220942754u, 2973571582u, 0, LOG_TOLERANCE, 0},
{ 350, 1103847606u, 1674254897u, 1046547577u, 217148561u, 1077191534u, 3981186583u, 0, LOG_TOLERANCE, 0},
{ 351, 1063780306u, 3275604304u, 3194840159u, 2991205850u, 3222754528u, 2855600771u, 0, LOG_TOLERANCE, 0},
{ 352, 1047765727u, 3509997278u, 3248888030u, 3897986511u, 3224399429u, 1263281156u, 0, LOG_TOLERANCE, 0},
{ 353, 1047182435u, 2156824613u, 1042295665u, 1239257646u, 3224424628u, 4130330871u, 0, LOG_TOLERANCE, 0},
{ 354, 1065780437u, 1073153314u, 3250031627u, 2567234990u, 3222407810u, 3861114186u, 0, LOG_TOLERANCE, 0},
{ 355, 1043109764u, 4261696995u, 3197784432u, 323702024u, 3224601934u, 3660455745u, 0, LOG_TOLERANCE, 0},
{ 356, 1096207349u, 4075177615u, 3202791065u, 1919006082u, 1076835551u, 1200557086u, 0, LOG_TOLERANCE, 0},
{ 357, 1091786365u, 386429966u, 1086504491u, 3698826164u, 1076450574u, 1244797795u, 0, LOG_TOLERANCE, 0},
{ 358, 1078327190u, 1681986446u, 3194985869u, 3072950140u, 1074676469u, 2143197479u, 0, LOG_TOLERANCE, 0},
{ 359, 1069828285u, 3719038997u, 1055433962u, 3331415058u, 3221059996u, 3710963779u, 0, LOG_TOLERANCE, 0},
{ 360, 1060749713u, 2420250111u, 3238002206u, 1928661079u, 3223281121u, 4182204469u, 0, LOG_TOLERANCE, 0},
{ 361, 1081914210u, 3679866727u, 3227386672u, 1273835792u, 1075348638u, 2488201983u, 0, LOG_TOLERANCE, 0},
{ 362, 1041622738u, 2682092368u, 3234222284u, 1325425811u, 3224664830u, 1088579835u, 0, LOG_TOLERANCE, 0},
{ 363, 1056312613u, 4175172697u, 3208346191u, 2130706153u, 3223685636u, 4242260445u, 0, LOG_TOLERANCE, 0},
{ 364, 1092089624u, 1200784450u, 1083605096u, 1248595607u, 1076478694u, 1626266244u, 0, LOG_TOLERANCE, 0},
{ 365, 1066407215u, 1897285171u, 3251296075u, 944966123u, 3222314345u, 3783490951u, 0, LOG_TOLERANCE, 0},
{ 366, 1093887602u, 2270747330u, 3230692631u, 422503284u, 1076632700u, 2223491330u, 0, LOG_TOLERANCE, 0},
{ 367, 1084120037u, 2857564741u, 1075647403u, 3308906709u, 1075726771u, 3738019719u, 0, LOG_TOLERANCE, 0},
{ 368, 1055991450u, 1380066948u, 3232612906u, 2613634294u, 3223718579u, 1312415733u, 0, LOG_TOLERANCE, 0},
{ 369, 1063890856u, 4022784584u, 1060483857u, 3264056381u, 3222736721u, 3541437472u, 0, LOG_TOLERANCE, 0},
{ 370, 1044637404u, 1778509100u, 3213146285u, 2665833973u, 3224534827u, 704175941u, 0, LOG_TOLERANCE, 0},
{ 371, 1069243652u, 1859175955u, 1079949560u, 4258450607u, 3221349189u, 3394474619u, 0, LOG_TOLERANCE, 0},
{ 372, 1048277388u, 4128020197u, 1076266146u, 4122840980u, 3224377490u, 3333906039u, 0, LOG_TOLERANCE, 0},
{ 373, 1045699515u, 2454653987u, 3229487005u, 2977478685u, 3224488724u, 2052223869u, 0, LOG_TOLERANCE, 0},
{ 374, 1106072835u, 1355181872u, 1095308770u, 436846481u, 1077286905u, 3531674556u, 0, LOG_TOLERANCE, 0},
{ 375, 1099121654u, 2592856453u, 3247825559u, 3195234082u, 1076986800u, 414496240u, 0, LOG_TOLERANCE, 0},
{ 376, 1074634375u, 3554670043u, 1091621009u, 3321236467u, 1073017240u, 1967217478u, 0, LOG_TOLERANCE, 0},
{ 377, 1069012833u, 1936670355u, 1095715713u, 2958468553u, 3221421428u, 846254916u, 0, LOG_TOLERANCE, 0},
{ 378, 1044807461u, 2960339502u, 1098808013u, 1044068983u, 3224526795u, 1144583180u, 0, LOG_TOLERANCE, 0},
{ 379, 1049207537u, 4093388677u, 1095478112u, 1735930261u, 3224301857u, 951820485u, 0, LOG_TOLERANCE, 0},
{ 380, 1091040302u, 1807398746u, 3195743135u, 4261616162u, 1076387779u, 4000737953u, 0, LOG_TOLERANCE, 0},
{ 381, 1061810546u, 3250576797u, 1059002384u, 3043079652u, 3223097520u, 3867116202u, 0, LOG_TOLERANCE, 0},
{ 382, 1069207109u, 666051428u, 3208765404u, 1912684117u, 3221359984u, 44859516u, 0, LOG_TOLERANCE, 0},
{ 383, 1103487420u, 1949030179u, 1096388934u, 896459246u, 1077176849u, 3384776839u, 0, LOG_TOLERANCE, 0},
{ 384, 1054300653u, 622499767u, 1066707637u, 1490260486u, 3223859833u, 3933837574u, 0, LOG_TOLERANCE, 0},
{ 385, 1106688493u, 1490616165u, 3251242436u, 795675736u, 1077315609u, 3224780635u, 0, LOG_TOLERANCE, 0},
{ 386, 1080943896u, 3662877092u, 3234317146u, 3200513112u, 1075177620u, 3055843857u, 0, LOG_TOLERANCE, 0},
{ 387, 1084088786u, 1356101968u, 3236536816u, 3062844611u, 1075722621u, 2632841302u, 0, LOG_TOLERANCE, 0},
{ 388, 1072438992u, 2284484846u, 3219498359u, 3240896015u, 3217066749u, 4038143420u, 0, LOG_TOLERANCE, 0},
{ 389, 1088276041u, 494503287u, 1092811254u, 142673998u, 1076143734u, 3881294548u, 0, LOG_TOLERANCE, 0},
{ 390, 1104642268u, 3394882641u, 3225306538u, 364852125u, 1077226961u, 36589885u, 0, LOG_TOLERANCE, 0},
{ 391, 1077778115u, 193885269u, 1088149839u, 1359805831u, 1074469221u, 177780347u, 0, LOG_TOLERANCE, 0},
{ 392, 1053001134u, 592580907u, 3199560872u, 3086438952u, 3223974161u, 362317677u, 0, LOG_TOLERANCE, 0},
{ 393, 1059518664u, 1778008540u, 1049064687u, 73581647u, 3223407720u, 1905177841u, 0, LOG_TOLERANCE, 0},
{ 394, 1099249950u, 233240285u, 1081923320u, 2710903921u, 1076993142u, 1735323538u, 0, LOG_TOLERANCE, 0},
{ 395, 1069513767u, 3719878805u, 1079866720u, 3615458228u, 3221275628u, 3951131729u, 0, LOG_TOLERANCE, 0},
{ 396, 1073711076u, 3647632375u, 3247225271u, 3839959621u, 1072018756u, 943970224u, 0, LOG_TOLERANCE, 0},
{ 397, 1103401096u, 2232210456u, 3235434773u, 224271737u, 1077172781u, 196725945u, 0, LOG_TOLERANCE, 0},
{ 398, 1045520036u, 2134662911u, 3190390590u, 4239009051u, 3224498319u, 1757386403u, 0, LOG_TOLERANCE, 0},
{ 399, 1080526145u, 2305279897u, 1077668039u, 1854523320u, 1075114754u, 3304741914u, 0, LOG_TOLERANCE, 0},
{ 400, 1072380611u, 538224650u, 3206153057u, 1379649610u, 3217336794u, 1283130523u, 0, LOG_TOLERANCE, 0},
{ 401, 1048926859u, 3683897920u, 3244167599u, 3647579469u, 3224325816u, 816770831u, 0, LOG_TOLERANCE, 0},
{ 402, 1090280933u, 2694093608u, 1042775347u, 598406111u, 1076319090u, 3356403737u, 0, LOG_TOLERANCE, 0},
{ 403, 1064151744u, 872706833u, 1084802480u, 2200602798u, 3222698951u, 2113199186u, 0, LOG_TOLERANCE, 0},
{ 404, 1042339597u, 904146293u, 1060867322u, 1729685598u, 3224636627u, 746916981u, 0, LOG_TOLERANCE, 0},
{ 405, 1048211322u, 1894173462u, 3232800651u, 191960416u, 3224379943u, 1996947825u, 0, LOG_TOLERANCE, 0},
{ 406, 1091225343u, 3521028551u, 1054522089u, 3287274359u, 1076402384u, 4209768157u, 0, LOG_TOLERANCE, 0},
{ 407, 1095386964u, 959640601u, 3201578263u, 4136915018u, 1076763329u, 2457717894u, 0, LOG_TOLERANCE, 0},
{ 408, 1064005451u, 1553716379u, 1106027987u, 984725765u, 3222719457u, 2955792047u, 0, LOG_TOLERANCE, 0},
{ 409, 1091348993u, 2287646644u, 3240329321u, 2276183378u, 1076411309u, 2287451717u, 0, LOG_TOLERANCE, 0},
{ 410, 1068209174u, 3940225170u, 3199544434u, 997572161u, 3221708492u, 3428245006u, 0, LOG_TOLERANCE, 0},
{ 411, 1065284713u, 36116288u, 3206886566u, 4196602670u, 3222506108u, 2017444572u, 0, LOG_TOLERANCE, 0},
{ 412, 1094212205u, 3550227562u, 3207257983u, 2747744117u, 1076662503u, 4126480558u, 0, LOG_TOLERANCE, 0},
{ 413, 1104236126u, 507130047u, 1048359321u, 3229888373u, 1077206901u, 2272076931u, 0, LOG_TOLERANCE, 0},
{ 414, 1075513130u, 2210969014u, 1081031001u, 1946786091u, 1073648058u, 4287756280u, 0, LOG_TOLERANCE, 0},
{ 415, 1088823342u, 4059150589u, 3189759234u, 1177045799u, 1076195670u, 168819796u, 0, LOG_TOLERANCE, 0},
{ 416, 1093103612u, 2664812822u, 1050343198u, 2034180320u, 1076566627u, 3519473592u, 0, LOG_TOLERANCE, 0},
{ 417, 1066295469u, 1175750283u, 3235559706u, 1424491340u, 3222329337u, 1404700686u, 0, LOG_TOLERANCE, 0},
{ 418, 1066420545u, 1630036121u, 3231972785u, 3195479448u, 3222311051u, 1432321875u, 0, LOG_TOLERANCE, 0},
{ 419, 1090429875u, 2527029044u, 1046927050u, 4000723255u, 1076329192u, 2019252442u, 0, LOG_TOLERANCE, 0},
{ 420, 1085208677u, 3335703647u, 3237349676u, 3869440059u, 1075876339u, 1110855580u, 0, LOG_TOLERANCE, 0},
{ 421, 1091433848u, 3888398377u, 3196041693u, 1290567220u, 1076417100u, 1637354096u, 0, LOG_TOLERANCE, 0},
{ 422, 1066679070u, 3242451480u, 3248384948u, 707431021u, 3222234337u, 3397134035u, 0, LOG_TOLERANCE, 0},
{ 423, 1083230509u, 2739665123u, 1060777905u, 1733073225u, 1075571436u, 4071268588u, 0, LOG_TOLERANCE, 0},
{ 424, 1078517061u, 1297274853u, 3208848704u, 3341639139u, 1074741421u, 4066881444u, 0, LOG_TOLERANCE, 0},
{ 425, 1046570941u, 2228057309u, 1084318902u, 1317851136u, 3224452759u, 1577079524u, 0, LOG_TOLERANCE, 0},
{ 426, 1088255327u, 270039934u, 3241414679u, 3063626339u, 1076142336u, 312904438u, 0, LOG_TOLERANCE, 0},
{ 427, 1071694702u, 83062251u, 3211262173u, 2659016437u, 3219435632u, 2990582226u, 0, LOG_TOLERANCE, 0},
{ 428, 1095743886u, 3833539373u, 3206667189u, 1567476111u, 1076788016u, 758411032u, 0, LOG_TOLERANCE, 0},
{ 429, 1057711424u, 2382776852u, 3249232579u, 1546622468u, 3223566341u, 2208541704u, 0, LOG_TOLERANCE, 0},
{ 430, 1085536439u, 1714300821u, 1104130938u, 4167591598u, 1075909687u, 2257964757u, 0, LOG_TOLERANCE, 0},
{ 431, 1051092760u, 2798720100u, 1086978789u, 449990704u, 3224137825u, 3989600554u, 0, LOG_TOLERANCE, 0},
{ 432, 1083714767u, 4039516226u, 3244344107u, 4272932619u, 1075667063u, 177846584u, 0, LOG_TOLERANCE, 0},
{ 433, 1075224793u, 1683007544u, 1091105663u, 3805494321u, 1073461757u, 1964735653u, 0, LOG_TOLERANCE, 0},
{ 434, 1073369300u, 2072627412u, 1094383324u, 3394151662u, 1071634515u, 3947641912u, 0, LOG_TOLERANCE, 0},
{ 435, 1073086376u, 1120106427u, 3223631624u, 3404608264u, 1070882956u, 2186806101u, 0, LOG_TOLERANCE, 0},
{ 436, 1097859997u, 559918757u, 3205077053u, 908100198u, 1076929260u, 181077198u, 0, LOG_TOLERANCE, 0},
{ 437, 1042677918u, 2026673913u, 3244833635u, 2844573214u, 3224619103u, 1411053414u, 0, LOG_TOLERANCE, 0},
{ 438, 1107083611u, 3946837259u, 3234993796u, 3850406820u, 1077331030u, 1746464057u, 0, LOG_TOLERANCE, 0},
{ 439, 1057479809u, 3139330994u, 1046133568u, 1539650690u, 3223584445u, 303889266u, 0, LOG_TOLERANCE, 0},
{ 440, 1089221852u, 1554593884u, 3228899878u, 2813752562u, 1076227495u, 3521483973u, 0, LOG_TOLERANCE, 0},
{ 441, 1056505004u, 3804703138u, 1072931071u, 2053677923u, 3223669255u, 1544957199u, 0, LOG_TOLERANCE, 0},
{ 442, 1097380651u, 289355864u, 1078453818u, 2143066338u, 1076912232u, 2177531595u, 0, LOG_TOLERANCE, 0},
{ 443, 1056456232u, 2157691971u, 1106629150u, 110806409u, 3223673218u, 2123023082u, 0, LOG_TOLERANCE, 0},
{ 444, 1082157019u, 3570399481u, 1085637605u, 180265334u, 1075383727u, 1957330776u, 0, LOG_TOLERANCE, 0},
{ 445, 1053496534u, 558779875u, 3202046748u, 2338464653u, 3223931261u, 3653586452u, 0, LOG_TOLERANCE, 0},
{ 446, 1045705464u, 1703969219u, 3229797258u, 1417521063u, 3224488429u, 1308720282u, 0, LOG_TOLERANCE, 0},
{ 447, 1090298613u, 3917440951u, 1051668894u, 3736066983u, 1076320331u, 1887921718u, 0, LOG_TOLERANCE, 0},
{ 448, 1064752080u, 3106613409u, 1066627453u, 2735392257u, 3222585948u, 408014405u, 0, LOG_TOLERANCE, 0},
{ 449, 1065665372u, 2229777605u, 1065061963u, 2405869925u, 3222429090u, 2085078273u, 0, LOG_TOLERANCE, 0},
{ 450, 1091979581u, 3967957902u, 1057416138u, 3459188071u, 1076469173u, 1237933408u, 0, LOG_TOLERANCE, 0},
{ 451, 1068639210u, 3699016825u, 3249713090u, 796144848u, 3221564708u, 13809233u, 0, LOG_TOLERANCE, 0},
{ 452, 1081332748u, 3285165564u, 3211948811u, 401510871u, 1075251694u, 3343192796u, 0, LOG_TOLERANCE, 0},
{ 453, 1094257658u, 634857910u, 3199607513u, 914218057u, 1076666184u, 2365285189u, 0, LOG_TOLERANCE, 0},
{ 454, 1083743336u, 2030735578u, 3233855943u, 965677531u, 1075671747u, 3755425130u, 0, LOG_TOLERANCE, 0},
{ 455, 1079556815u, 3957229084u, 1051050470u, 3123776651u, 1074946192u, 1593874845u, 0, LOG_TOLERANCE, 0},
{ 456, 1074379685u, 162122081u, 3239376395u, 108064594u, 1072869757u, 311403082u, 0, LOG_TOLERANCE, 0},
{ 457, 1089788138u, 869031839u, 3225020876u, 1344301606u, 1076278721u, 2052619875u, 0, LOG_TOLERANCE, 0},
{ 458, 1066949826u, 946696117u, 3231825228u, 1700703647u, 3222136911u, 3234660715u, 0, LOG_TOLERANCE, 0},
{ 459, 1075492875u, 3394168074u, 1076939786u, 1666995668u, 1073635999u, 2354579684u, 0, LOG_TOLERANCE, 0},
{ 460, 1061291147u, 2488789804u, 3238508333u, 1506943664u, 3223193085u, 2395026729u, 0, LOG_TOLERANCE, 0},
{ 461, 1072788663u, 3844072288u, 3202592279u, 2630019853u, 1068911508u, 1747838674u, 0, LOG_TOLERANCE, 0},
{ 462, 1072450894u, 1244307192u, 3191297711u, 2540916692u, 3216994329u, 4168950885u, 0, LOG_TOLERANCE, 0},
{ 463, 1052579044u, 2871645739u, 3239081581u, 1440249115u, 3224012773u, 4034559683u, 0, LOG_TOLERANCE, 0},
{ 464, 1068350633u, 1231934926u, 3236746788u, 603977748u, 3221668985u, 130084003u, 0, LOG_TOLERANCE, 0},
{ 465, 1047966041u, 2386312545u, 1063169277u, 2715234268u, 3224389948u, 783950888u, 0, LOG_TOLERANCE, 0},
{ 466, 1087803418u, 915867083u, 1046790892u, 3347417612u, 1076107382u, 1970735447u, 0, LOG_TOLERANCE, 0},
{ 467, 1105984188u, 3553288373u, 1065698616u, 2906680663u, 1077283811u, 3228434780u, 0, LOG_TOLERANCE, 0},
{ 468, 1045506226u, 2342364630u, 1051356723u, 4019093203u, 3224499119u, 1422614641u, 0, LOG_TOLERANCE, 0},
{ 469, 1053685514u, 2911548084u, 1105282515u, 2476735795u, 3223917999u, 2323260261u, 0, LOG_TOLERANCE, 0},
{ 470, 1050472772u, 1836216409u, 1101062307u, 2519592554u, 3224195107u, 156157416u, 0, LOG_TOLERANCE, 0},
{ 471, 1070178161u, 1235369496u, 3222946447u, 668087854u, 3220815003u, 2491682284u, 0, LOG_TOLERANCE, 0},
{ 472, 1061070948u, 2981820811u, 1059838516u, 2845580478u, 3223235452u, 3382317431u, 0, LOG_TOLERANCE, 0},
{ 473, 1046447766u, 1565550570u, 3217165795u, 4162017137u, 3224459254u, 3914539253u, 0, LOG_TOLERANCE, 0},
{ 474, 1089767730u, 2808968027u, 1055630096u, 1782326814u, 1076276748u, 3860952757u, 0, LOG_TOLERANCE, 0},
{ 475, 1053576974u, 1492622658u, 3216653077u, 3972512122u, 3223925451u, 3928061943u, 0, LOG_TOLERANCE, 0},
{ 476, 1074688031u, 2722693603u, 3227814791u, 3169731970u, 1073045831u, 1648821496u, 0, LOG_TOLERANCE, 0},
{ 477, 1070422983u, 899763203u, 3207606001u, 2804747833u, 3220672293u, 2109485257u, 0, LOG_TOLERANCE, 0},
{ 478, 1083186677u, 3789058912u, 3228095081u, 4135937628u, 1075560778u, 1017192561u, 0, LOG_TOLERANCE, 0},
{ 479, 1060199382u, 1682808307u, 3206960335u, 232877759u, 3223353590u, 3898794040u, 0, LOG_TOLERANCE, 0},
{ 480, 1094607838u, 2851963139u, 3246852961u, 2590862592u, 1076691530u, 843693284u, 0, LOG_TOLERANCE, 0},
{ 481, 1081200406u, 2422232642u, 3234779662u, 290458310u, 1075223537u, 2996632407u, 0, LOG_TOLERANCE, 0},
{ 482, 1063187430u, 1082582386u, 1075605675u, 2602133689u, 3222869534u, 497064377u, 0, LOG_TOLERANCE, 0},
{ 483, 1092334963u, 1789635787u, 1059414278u, 1048286093u, 1076497719u, 35468346u, 0, LOG_TOLERANCE, 0},
{ 484, 1098330542u, 231339448u, 1055573265u, 504907415u, 1076953536u, 1119059296u, 0, LOG_TOLERANCE, 0},
{ 485, 1063211461u, 1153251200u, 3204617090u, 1772013857u, 3222866446u, 3672537745u, 0, LOG_TOLERANCE, 0},
{ 486, 1099551055u, 1082898276u, 3212089272u, 1449080862u, 1077005985u, 1029802319u, 0, LOG_TOLERANCE, 0},
{ 487, 1086008285u, 3177299045u, 1058862813u, 809400815u, 1075950038u, 2713697878u, 0, LOG_TOLERANCE, 0},
{ 488, 1083370902u, 1924429710u, 1056464743u, 3349283177u, 1075602923u, 210852422u, 0, LOG_TOLERANCE, 0},
{ 489, 1097989743u, 42238036u, 1042379500u, 2113559863u, 1076936898u, 4273537346u, 0, LOG_TOLERANCE, 0},
{ 490, 1064761243u, 3304403230u, 3217556703u, 58952646u, 3222584347u, 1589474103u, 0, LOG_TOLERANCE, 0},
{ 491, 1065185882u, 1645486982u, 3224301095u, 3636267471u, 3222519201u, 137895691u, 0, LOG_TOLERANCE, 0},
{ 492, 1062762009u, 619402181u, 3235208235u, 557360557u, 3222931234u, 1968443211u, 0, LOG_TOLERANCE, 0},
{ 493, 1090754746u, 110029735u, 1046937383u, 984375729u, 1076361464u, 987250933u, 0, LOG_TOLERANCE, 0},
{ 494, 1042013090u, 4063688092u, 3203235744u, 1049950343u, 3224649065u, 604966936u, 0, LOG_TOLERANCE, 0},
{ 495, 1062350619u, 650996069u, 1054971928u, 3953359826u, 3223008973u, 1813427148u, 0, LOG_TOLERANCE, 0},
{ 496, 1079572157u, 66926332u, 1090561839u, 1379780888u, 1074948662u, 433676492u, 0, LOG_TOLERANCE, 0},
{ 497, 1085969659u, 2803378256u, 1086057989u, 498534626u, 1075947164u, 835461350u, 0, LOG_TOLERANCE, 0},
{ 498, 1082618553u, 2846400785u, 1047142525u, 1375153550u, 1075477355u, 2196414547u, 0, LOG_TOLERANCE, 0},
{ 499, 1044581201u, 2869128958u, 1070972315u, 4246440273u, 3224537713u, 3512318899u, 0, LOG_TOLERANCE, 0},
{ 500, 1051832506u, 3112381207u, 1044430965u, 3981604561u, 3224077928u, 494780876u, 0, LOG_TOLERANCE, 0},
{ 501, 1083771349u, 243303420u, 1093735824u, 1575581926u, 1075676261u, 2797159781u, 0, LOG_TOLERANCE, 0},
{ 502, 1091654349u, 3218865041u, 3204803496u, 3840388050u, 1076436155u, 4233818719u, 0, LOG_TOLERANCE, 0},
{ 503, 1048415431u, 336846959u, 1052664471u, 3798336786u, 3224372644u, 1850665100u, 0, LOG_TOLERANCE, 0},
{ 504, 1055954236u, 3639240976u, 1081202165u, 1844741676u, 3223722992u, 1428253868u, 0, LOG_TOLERANCE, 0},
{ 505, 1064421145u, 717293069u, 3211534283u, 582401011u, 3222651488u, 457041754u, 0, LOG_TOLERANCE, 0},
{ 506, 1104478864u, 3766248610u, 3196520332u, 1174437546u, 1077219611u, 2272566305u, 0, LOG_TOLERANCE, 0},
{ 507, 1083431226u, 756959182u, 3204099341u, 1581804034u, 1075615370u, 3301009964u, 0, LOG_TOLERANCE, 0},
{ 508, 1058322796u, 3560686300u, 3220980617u, 4277975772u, 3223512067u, 3447536936u, 0, LOG_TOLERANCE, 0},
{ 509, 1062422428u, 2598148853u, 3217622194u, 3460421008u, 3222993634u, 3740783369u, 0, LOG_TOLERANCE, 0},
{ 510, 1066720824u, 136600515u, 3209934920u, 3340653128u, 3222218081u, 3300781843u, 0, LOG_TOLERANCE, 0},
{ 511, 1096820310u, 1045480938u, 3251354609u, 4133432965u, 1076881221u, 1639289155u, 0, LOG_TOLERANCE, 0},
{ 512, 1091599431u, 1630207738u, 3239996829u, 2393354808u, 1076429657u, 658484818u, 0, LOG_TOLERANCE, 0},
{ 513, 1043142370u, 3739770117u, 1059520750u, 3959551225u, 3224600804u, 1163315162u, 0, LOG_TOLERANCE, 0},
{ 514, 1083246857u, 1498861716u, 1091297147u, 847410798u, 1075575303u, 3775039354u, 0, LOG_TOLERANCE, 0},
{ 515, 1073516688u, 983275314u, 3232538664u, 2244973629u, 1071811569u, 2728229451u, 0, LOG_TOLERANCE, 0},
{ 516, 1054849265u, 2353103845u, 3235718771u, 2978889966u, 3223819677u, 197121532u, 0, LOG_TOLERANCE, 0},
{ 517, 1103874344u, 1546972125u, 3249076079u, 1987349196u, 1077192504u, 1510519247u, 0, LOG_TOLERANCE, 0},
{ 518, 1090735865u, 2769161072u, 1075207126u, 292616282u, 1076359523u, 89361979u, 0, LOG_TOLERANCE, 0},
{ 519, 1052228650u, 36855311u, 1052128202u, 1479039342u, 3224039401u, 3593532843u, 0, LOG_TOLERANCE, 0},
{ 520, 1083757053u, 2027463605u, 1066023013u, 3369686340u, 1075673967u, 3693747671u, 0, LOG_TOLERANCE, 0},
{ 521, 1050369101u, 3808681655u, 1054161346u, 1821773119u, 3224202474u, 692132331u, 0, LOG_TOLERANCE, 0},
{ 522, 1040685928u, 3175490326u, 3226879970u, 845687760u, 3224705342u, 819266546u, 0, LOG_TOLERANCE, 0},
{ 523, 1042302993u, 3124482451u, 3242748377u, 3259417226u, 3224638837u, 2723875780u, 0, LOG_TOLERANCE, 0},
{ 524, 1045245695u, 2751606436u, 3236210939u, 3923142740u, 3224509740u, 972503631u, 0, LOG_TOLERANCE, 0},
{ 525, 1095694737u, 2016872044u, 3228408064u, 4201274408u, 1076784880u, 2075690093u, 0, LOG_TOLERANCE, 0},
{ 526, 1051865606u, 1019916843u, 3219974785u, 1977881787u, 3224074238u, 1888960312u, 0, LOG_TOLERANCE, 0},
{ 527, 1051995104u, 2060433318u, 1075872515u, 366073725u, 3224060725u, 1765681116u, 0, LOG_TOLERANCE, 0},
{ 528, 1043696909u, 1098469906u, 1082900695u, 2349346832u, 3224575035u, 3674662655u, 0, LOG_TOLERANCE, 0},
{ 529, 1062491059u, 3011196295u, 3252479932u, 2459281672u, 3222979769u, 492196641u, 0, LOG_TOLERANCE, 0},
{ 530, 1073850675u, 2843222682u, 1089275809u, 298982001u, 1072256860u, 1361015105u, 0, LOG_TOLERANCE, 0},
{ 531, 1101737698u, 914741728u, 3203468059u, 2833809843u, 1077100215u, 617711599u, 0, LOG_TOLERANCE, 0},
{ 532, 1089280230u, 1274901962u, 3241535845u, 3759113509u, 1076231571u, 557911230u, 0, LOG_TOLERANCE, 0},
{ 533, 1098432794u, 2134927252u, 3253802671u, 3013731444u, 1076957802u, 3748566065u, 0, LOG_TOLERANCE, 0},
{ 534, 1099201341u, 2230655177u, 3254510616u, 1249674366u, 1076990811u, 285259783u, 0, LOG_TOLERANCE, 0},
{ 535, 1062971253u, 717357389u, 1083533731u, 3746683362u, 3222899074u, 465863828u, 0, LOG_TOLERANCE, 0},
{ 536, 1066289466u, 834976849u, 3217357661u, 2465861779u, 3222330128u, 4215014023u, 0, LOG_TOLERANCE, 0},
{ 537, 1045656117u, 1385714428u, 1053358395u, 3007113740u, 3224490919u, 160169310u, 0, LOG_TOLERANCE, 0},
{ 538, 1050527919u, 599268545u, 3201368210u, 2309854744u, 3224191350u, 2572280436u, 0, LOG_TOLERANCE, 0},
{ 539, 1069954454u, 2840234388u, 3232496515u, 333365983u, 3220964919u, 2207069711u, 0, LOG_TOLERANCE, 0},
{ 540, 1045922781u, 3136078996u, 3194520860u, 2650572904u, 3224478467u, 2261318089u, 0, LOG_TOLERANCE, 0},
{ 541, 1086204043u, 2405805086u, 3251640319u, 324233833u, 1075963709u, 1682447551u, 0, LOG_TOLERANCE, 0},
{ 542, 1106699146u, 2589598340u, 3254677807u, 952438812u, 1077316076u, 3633878054u, 0, LOG_TOLERANCE, 0},
{ 543, 1041631125u, 1922837702u, 3216892718u, 3535907549u, 3224664448u, 1875921049u, 0, LOG_TOLERANCE, 0},
{ 544, 1096132220u, 261447440u, 3209805849u, 1150571079u, 1076828788u, 2089162237u, 0, LOG_TOLERANCE, 0},
{ 545, 1095805232u, 4026487528u, 1073152064u, 27340691u, 1076794453u, 1737884956u, 0, LOG_TOLERANCE, 0},
{ 546, 1081640044u, 338765118u, 1086225786u, 3207238249u, 1075307339u, 978420089u, 0, LOG_TOLERANCE, 0},
{ 547, 1048699055u, 1085283176u, 3187775111u, 1601194210u, 3224349104u, 167106457u, 0, LOG_TOLERANCE, 0},
{ 548, 1091520173u, 3031712790u, 3252307859u, 170666844u, 1076422740u, 744995018u, 0, LOG_TOLERANCE, 0},
{ 549, 1071378583u, 3148395674u, 1041913758u, 3306391490u, 3219817927u, 894704365u, 0, LOG_TOLERANCE, 0},
{ 550, 1053793422u, 2205233857u, 3208100078u, 3993195511u, 3223910988u, 856785751u, 0, LOG_TOLERANCE, 0},
{ 551, 1067699608u, 4282766727u, 1072820377u, 1874778218u, 3221882135u, 136784904u, 0, LOG_TOLERANCE, 0},
{ 552, 1063349444u, 2920860798u, 3218070226u, 3104066154u, 3222838447u, 3579382968u, 0, LOG_TOLERANCE, 0},
{ 553, 1057466703u, 969991373u, 3250596895u, 1734386152u, 3223585548u, 1096500115u, 0, LOG_TOLERANCE, 0},
{ 554, 1091432170u, 1218740205u, 3239802737u, 2610078504u, 1076416988u, 1166408302u, 0, LOG_TOLERANCE, 0},
{ 555, 1058547594u, 1485218325u, 3220870240u, 3591664613u, 3223491992u, 2889488052u, 0, LOG_TOLERANCE, 0},
{ 556, 1054590495u, 690157417u, 3190850619u, 4192347699u, 3223837100u, 221540590u, 0, LOG_TOLERANCE, 0},
{ 557, 1096053810u, 4009839784u, 1079670252u, 394167192u, 1076821337u, 1851630736u, 0, LOG_TOLERANCE, 0},
{ 558, 1087075589u, 961532417u, 1092588071u, 2923790239u, 1076042262u, 402021294u, 0, LOG_TOLERANCE, 0},
{ 559, 1056395443u, 4174125604u, 1050682630u, 2169701868u, 3223678331u, 3987244812u, 0, LOG_TOLERANCE, 0},
{ 560, 1095608827u, 4146748230u, 1087373950u, 2481478351u, 1076779212u, 2755104011u, 0, LOG_TOLERANCE, 0},
{ 561, 1076987866u, 3984715440u, 1050421618u, 2446142566u, 1074194784u, 222203740u, 0, LOG_TOLERANCE, 0},
{ 562, 1084172406u, 936290150u, 1100614426u, 3625806370u, 1075733582u, 2307849831u, 0, LOG_TOLERANCE, 0},
{ 563, 1099787952u, 1866615265u, 3215651428u, 2337013350u, 1077014572u, 4172289639u, 0, LOG_TOLERANCE, 0},
{ 564, 1105714654u, 712227971u, 1106004723u, 973148499u, 1077273392u, 1598723415u, 0, LOG_TOLERANCE, 0},
{ 565, 1082604551u, 3409813738u, 3244817008u, 1933503498u, 1075474955u, 4275872054u, 0, LOG_TOLERANCE, 0},
{ 566, 1079943733u, 3180389060u, 3228735703u, 83422217u, 1075002315u, 1460579331u, 0, LOG_TOLERANCE, 0},
{ 567, 1077878724u, 556972671u, 3204582372u, 841555801u, 1074495740u, 3043398158u, 0, LOG_TOLERANCE, 0},
{ 568, 1070767721u, 4189151332u, 1080874032u, 706326922u, 3220423008u, 1451854222u, 0, LOG_TOLERANCE, 0},
{ 569, 1096151307u, 198291836u, 1057281892u, 2188836928u, 1076830539u, 4025310681u, 0, LOG_TOLERANCE, 0},
{ 570, 1078091995u, 1219449298u, 3228734687u, 3504562743u, 1074582949u, 3796387511u, 0, LOG_TOLERANCE, 0},
{ 571, 1057086816u, 1776099219u, 1094316777u, 4188083896u, 3223622381u, 1340974487u, 0, LOG_TOLERANCE, 0},
{ 572, 1046362060u, 2614400266u, 1073750227u, 3003203347u, 3224462031u, 2168733507u, 0, LOG_TOLERANCE, 0},
{ 573, 1066499030u, 2959351406u, 1105603716u, 311851587u, 3222292450u, 2448510388u, 0, LOG_TOLERANCE, 0},
{ 574, 1084544434u, 865443613u, 1097532516u, 3622237781u, 1075809786u, 4009940215u, 0, LOG_TOLERANCE, 0},
{ 575, 1084303018u, 447506102u, 3195759295u, 3603669725u, 1075758783u, 778755463u, 0, LOG_TOLERANCE, 0},
{ 576, 1097890173u, 3934398273u, 1040996422u, 2968621268u, 1076931117u, 3632567756u, 0, LOG_TOLERANCE, 0},
{ 577, 1049256177u, 784208771u, 1088764788u, 2182296421u, 3224298116u, 2494467149u, 0, LOG_TOLERANCE, 0},
{ 578, 1100848643u, 1527590526u, 3206961556u, 2823164069u, 1077060409u, 1703424684u, 0, LOG_TOLERANCE, 0},
{ 579, 1089160483u, 3876699591u, 3207481130u, 4028148535u, 1076223070u, 2488144317u, 0, LOG_TOLERANCE, 0},
{ 580, 1083576186u, 2164249756u, 1059857743u, 1785169952u, 1075643067u, 4067087010u, 0, LOG_TOLERANCE, 0},
{ 581, 1091804009u, 2079273665u, 1080303860u, 625760474u, 1076452386u, 2402517231u, 0, LOG_TOLERANCE, 0},
{ 582, 1079002460u, 3636214836u, 1068367620u, 2932621925u, 1074836452u, 1246949188u, 0, LOG_TOLERANCE, 0},
{ 583, 1043995372u, 4274131512u, 1047707755u, 92550763u, 3224562471u, 3439797135u, 0, LOG_TOLERANCE, 0},
{ 584, 1051338473u, 2648933384u, 1084603503u, 3534304873u, 3224117543u, 1738801372u, 0, LOG_TOLERANCE, 0},
{ 585, 1064563235u, 3216750767u, 3191088629u, 547482628u, 3222621321u, 3716790217u, 0, LOG_TOLERANCE, 0},
{ 586, 1061084774u, 1420360746u, 1080063101u, 1690029499u, 3223233655u, 426639274u, 0, LOG_TOLERANCE, 0},
{ 587, 1082371716u, 1908572179u, 1080112083u, 1228319033u, 1075431453u, 2787108747u, 0, LOG_TOLERANCE, 0},
{ 588, 1048158178u, 500312015u, 3212368508u, 3864619086u, 3224381985u, 1230868351u, 0, LOG_TOLERANCE, 0},
{ 589, 1073851962u, 4211343447u, 1087492676u, 4272583781u, 1072259191u, 2246212895u, 0, LOG_TOLERANCE, 0},
{ 590, 1099392394u, 2382118000u, 1042665328u, 567154882u, 1076999532u, 1195356221u, 0, LOG_TOLERANCE, 0},
{ 591, 1058013442u, 1435344339u, 3216303171u, 2275988178u, 3223545946u, 1433265295u, 0, LOG_TOLERANCE, 0},
{ 592, 1067054971u, 3403659753u, 3218043030u, 1926480488u, 3222103473u, 3585903650u, 0, LOG_TOLERANCE, 0},
{ 593, 1076840383u, 1198845185u, 3225556149u, 1130089684u, 1074134956u, 770846098u, 0, LOG_TOLERANCE, 0},
{ 594, 1075179394u, 2183928090u, 1048403956u, 963834821u, 1073429155u, 1101532312u, 0, LOG_TOLERANCE, 0},
{ 595, 1101672960u, 2120625396u, 1041006976u, 2137548527u, 1077097789u, 1094065157u, 0, LOG_TOLERANCE, 0},
{ 596, 1099230238u, 586700956u, 1059670521u, 303891699u, 1076992206u, 4144042493u, 0, LOG_TOLERANCE, 0},
{ 597, 1071510850u, 2509132460u, 1102827530u, 2205707903u, 3219671660u, 3639433009u, 0, LOG_TOLERANCE, 0},
{ 598, 1057376949u, 1229308263u, 3209170414u, 4206576047u, 3223593363u, 900139131u, 0, LOG_TOLERANCE, 0},
{ 599, 1076592641u, 4078010749u, 3199236456u, 733478972u, 1074067427u, 3307722640u, 0, LOG_TOLERANCE, 0},
{ 600, 1050228936u, 4277541051u, 3199806921u, 397102023u, 3224213142u, 2343694908u, 0, LOG_TOLERANCE, 0},
{ 601, 1048491365u, 900999594u, 3234720188u, 2530214248u, 3224369047u, 2922487944u, 0, LOG_TOLERANCE, 0},
{ 602, 1076543548u, 4000609478u, 1096577064u, 4148592328u, 1074052948u, 253985069u, 0, LOG_TOLERANCE, 0},
{ 603, 1048668084u, 2154187873u, 3224392607u, 3957250362u, 3224352615u, 1700962361u, 0, LOG_TOLERANCE, 0},
{ 604, 1075929840u, 2867079200u, 1101870326u, 921212001u, 1073827044u, 3912397586u, 0, LOG_TOLERANCE, 0},
{ 605, 1085738242u, 674547716u, 1063216239u, 3929755226u, 1075928482u, 1096646355u, 0, LOG_TOLERANCE, 0},
{ 606, 1092932203u, 3158182449u, 1043794244u, 3259056345u, 1076551118u, 1944847734u, 0, LOG_TOLERANCE, 0},
{ 607, 1089293008u, 3002823940u, 1059511739u, 2832435794u, 1076232446u, 2248040348u, 0, LOG_TOLERANCE, 0},
{ 608, 1069821174u, 2196511929u, 1049973941u, 3672092877u, 3221065621u, 1333818035u, 0, LOG_TOLERANCE, 0},
{ 609, 1050438056u, 3655292191u, 1086438127u, 3567072906u, 3224197528u, 856774981u, 0, LOG_TOLERANCE, 0},
{ 610, 1095703300u, 1617573614u, 3201863123u, 3090723732u, 1076785432u, 919734899u, 0, LOG_TOLERANCE, 0},
{ 611, 1085717732u, 679893506u, 3211547753u, 824081024u, 1075926690u, 2224601098u, 0, LOG_TOLERANCE, 0},
{ 612, 1089530525u, 2285242807u, 1084999409u, 2221731406u, 1076251335u, 2335692597u, 0, LOG_TOLERANCE, 0},
{ 613, 1059250016u, 1935990727u, 1088822246u, 1058156518u, 3223433483u, 3217816881u, 0, LOG_TOLERANCE, 0},
{ 614, 1102839166u, 521023584u, 1059186903u, 4245163857u, 1077147558u, 2892805731u, 0, LOG_TOLERANCE, 0},
{ 615, 1103891140u, 2312887617u, 3191771354u, 1885370807u, 1077193106u, 297823039u, 0, LOG_TOLERANCE, 0},
{ 616, 1105470167u, 1796441468u, 1100030327u, 2772711004u, 1077262253u, 1282095196u, 0, LOG_TOLERANCE, 0},
{ 617, 1056793172u, 2095685003u, 1077984448u, 2100773742u, 3223648008u, 3902380592u, 0, LOG_TOLERANCE, 0},
{ 618, 1045470972u, 2892538035u, 1042396334u, 4162200338u, 3224501206u, 3305443403u, 0, LOG_TOLERANCE, 0},
{ 619, 1095242103u, 2177698116u, 3227557177u, 150832500u, 1076751813u, 652084626u, 0, LOG_TOLERANCE, 0},
{ 620, 1044078568u, 607966734u, 3236250630u, 4164600559u, 3224559359u, 4052486987u, 0, LOG_TOLERANCE, 0},
{ 621, 1068906164u, 2830122967u, 1046096700u, 3713346883u, 3221458501u, 2135199639u, 0, LOG_TOLERANCE, 0},
{ 622, 1089714315u, 2314640506u, 3203696416u, 3276228872u, 1076271440u, 3165050519u, 0, LOG_TOLERANCE, 0},
{ 623, 1065428659u, 469331883u, 3249037349u, 2999233437u, 3222479189u, 1973618642u, 0, LOG_TOLERANCE, 0},
{ 624, 1097382011u, 560886625u, 1091899487u, 748795120u, 1076912287u, 2351244050u, 0, LOG_TOLERANCE, 0},
{ 625, 1049886858u, 2958421324u, 1092569414u, 3235243477u, 3224243534u, 1631239268u, 0, LOG_TOLERANCE, 0},
{ 626, 1045542849u, 3221475559u, 1043038304u, 915608434u, 3224497019u, 12328601u, 0, LOG_TOLERANCE, 0},
{ 627, 1071197530u, 3007808652u, 3216682290u, 2531019474u, 3220036272u, 3512463986u, 0, LOG_TOLERANCE, 0},
{ 628, 1094545351u, 1767658578u, 3237045269u, 2313128318u, 1076687351u, 4133464776u, 0, LOG_TOLERANCE, 0},
{ 629, 1063134244u, 1926845182u, 1066835624u, 1783256828u, 3222876498u, 4254270569u, 0, LOG_TOLERANCE, 0},
{ 630, 1040575629u, 90378038u, 1057168870u, 164358218u, 3224710189u, 1836351366u, 0, LOG_TOLERANCE, 0},
{ 631, 1106859172u, 1610524680u, 1085283851u, 2903496007u, 1077322719u, 3956409329u, 0, LOG_TOLERANCE, 0},
{ 632, 1078635586u, 4274321404u, 3202913591u, 720121831u, 1074778233u, 4182823459u, 0, LOG_TOLERANCE, 0},
{ 633, 1051205256u, 2034778236u, 1071133763u, 1413236391u, 3224128149u, 214647840u, 0, LOG_TOLERANCE, 0},
{ 634, 1051063028u, 1489112261u, 1076691395u, 348210906u, 3224140507u, 2241216118u, 0, LOG_TOLERANCE, 0},
{ 635, 1059260269u, 2797651324u, 3224410527u, 2374818327u, 3223432401u, 2818559991u, 0, LOG_TOLERANCE, 0},
{ 636, 1088287256u, 1823161666u, 3197810695u, 3119680047u, 1076144486u, 410596024u, 0, LOG_TOLERANCE, 0},
{ 637, 1065927336u, 3420950657u, 1087084743u, 2136638961u, 3222382935u, 3289438458u, 0, LOG_TOLERANCE, 0},
{ 638, 1069902224u, 3554566429u, 1062907717u, 2736702589u, 3221003238u, 2295141582u, 0, LOG_TOLERANCE, 0},
{ 639, 1097405019u, 2928437580u, 3187765027u, 1393427873u, 1076913211u, 3191623646u, 0, LOG_TOLERANCE, 0},
{ 640, 1061817913u, 189447067u, 1051643315u, 828663513u, 3223096387u, 2558305145u, 0, LOG_TOLERANCE, 0},
{ 641, 1052313869u, 2852350928u, 1045683757u, 673354280u, 3224032410u, 3091433288u, 0, LOG_TOLERANCE, 0},
{ 642, 1043946301u, 3589563265u, 3248741629u, 812657927u, 3224564379u, 145610791u, 0, LOG_TOLERANCE, 0},
{ 643, 1043127178u, 1766416701u, 1100392103u, 2185373290u, 3224601328u, 2709694091u, 0, LOG_TOLERANCE, 0},
{ 644, 1072791741u, 3763582673u, 3191965790u, 388374829u, 1068956587u, 4000095759u, 0, LOG_TOLERANCE, 0},
{ 645, 1079635136u, 1187403069u, 1075300235u, 336640304u, 1074958563u, 4287311234u, 0, LOG_TOLERANCE, 0},
{ 646, 1103926251u, 1718795752u, 3243118752u, 683369237u, 1077194346u, 1449151468u, 0, LOG_TOLERANCE, 0},
{ 647, 1063308449u, 1863545307u, 1069449477u, 3418627399u, 3222848031u, 2779607712u, 0, LOG_TOLERANCE, 0},
{ 648, 1069601294u, 3295607249u, 1068878592u, 1633297809u, 3221240901u, 2594350627u, 0, LOG_TOLERANCE, 0},
{ 649, 1058947127u, 2585980994u, 3236670483u, 1286750688u, 3223462494u, 904067198u, 0, LOG_TOLERANCE, 0},
{ 650, 1046157033u, 15816845u, 3233249283u, 2491924775u, 3224469193u, 4212288781u, 0, LOG_TOLERANCE, 0},
{ 651, 1042413021u, 1051983351u, 1049180786u, 1474421917u, 3224632405u, 4286106996u, 0, LOG_TOLERANCE, 0},
{ 652, 1053765877u, 2003816032u, 1086050104u, 668090487u, 3223912742u, 2616410283u, 0, LOG_TOLERANCE, 0},
{ 653, 1052556037u, 3671484625u, 1067020039u, 430024694u, 3224014365u, 3396241137u, 0, LOG_TOLERANCE, 0},
{ 654, 1067397110u, 3991830201u, 3207808714u, 1021245839u, 3222007425u, 4243502376u, 0, LOG_TOLERANCE, 0},
{ 655, 1064194391u, 4255801807u, 3207681716u, 1926756877u, 3222693263u, 1936878201u, 0, LOG_TOLERANCE, 0},
{ 656, 1052140785u, 4167786896u, 1077097744u, 1775517981u, 3224047022u, 3920752385u, 0, LOG_TOLERANCE, 0},
{ 657, 1085601978u, 3187518564u, 1082437406u, 944672491u, 1075916091u, 3265610257u, 0, LOG_TOLERANCE, 0},
{ 658, 1049366282u, 953085192u, 3227310828u, 3459155777u, 3224290023u, 2656300300u, 0, LOG_TOLERANCE, 0},
{ 659, 1069502506u, 1908555460u, 1073640207u, 260441967u, 3221278498u, 706663362u, 0, LOG_TOLERANCE, 0},
{ 660, 1067219606u, 250762477u, 1072582645u, 2886742039u, 3222055058u, 672407782u, 0, LOG_TOLERANCE, 0},
{ 661, 1103422358u, 786180031u, 3197734769u, 2788918312u, 1077173806u, 3746531445u, 0, LOG_TOLERANCE, 0},
{ 662, 1087028179u, 2055912467u, 3244244909u, 1394142937u, 1076038762u, 1795047243u, 0, LOG_TOLERANCE, 0},
{ 663, 1069612985u, 91984146u, 3222252812u, 4126276047u, 3221235370u, 3814066775u, 0, LOG_TOLERANCE, 0},
{ 664, 1081340139u, 3942715706u, 3239316352u, 410676547u, 1075253181u, 2506903412u, 0, LOG_TOLERANCE, 0},
{ 665, 1051074198u, 86296211u, 1085850694u, 649202596u, 3224139493u, 2880611269u, 0, LOG_TOLERANCE, 0},
{ 666, 1097882744u, 3069064472u, 3237358008u, 23209276u, 1076930665u, 1450427370u, 0, LOG_TOLERANCE, 0},
{ 667, 1081235288u, 1867297860u, 1072956607u, 2513414118u, 1075231257u, 2535725157u, 0, LOG_TOLERANCE, 0},
{ 668, 1103049699u, 3171788768u, 3235208783u, 162138697u, 1077154679u, 624087679u, 0, LOG_TOLERANCE, 0},
{ 669, 1081728455u, 1245110700u, 1081653954u, 2584994077u, 1075321380u, 2914390661u, 0, LOG_TOLERANCE, 0},
{ 670, 1098026472u, 3347226587u, 1058962932u, 2291943376u, 1076938909u, 376541139u, 0, LOG_TOLERANCE, 0},
{ 671, 1058899062u, 966940828u, 1060726420u, 2798041096u, 3223465711u, 660497085u, 0, LOG_TOLERANCE, 0},
{ 672, 1072793759u, 2487340727u, 3223786370u, 4105954991u, 1068986073u, 992013529u, 0, LOG_TOLERANCE, 0},
{ 673, 1100632849u, 1671039260u, 1086395032u, 3745833360u, 1077052685u, 2200577415u, 0, LOG_TOLERANCE, 0},
{ 674, 1057078797u, 651714217u, 1047070645u, 2130549237u, 3223623282u, 754729227u, 0, LOG_TOLERANCE, 0},
{ 675, 1059632083u, 1423000172u, 3247822717u, 1551488170u, 3223398200u, 442592399u, 0, LOG_TOLERANCE, 0},
{ 676, 1054113659u, 921077236u, 3213332351u, 1431049019u, 3223876915u, 4055130359u, 0, LOG_TOLERANCE, 0},
{ 677, 1067510295u, 655715547u, 3190985373u, 1527556471u, 3221964801u, 460556857u, 0, LOG_TOLERANCE, 0},
{ 678, 1080171331u, 4110878657u, 3251297180u, 879739345u, 1075046177u, 1152302381u, 0, LOG_TOLERANCE, 0},
{ 679, 1085804762u, 2623955764u, 1093699897u, 1216444475u, 1075934130u, 1839592766u, 0, LOG_TOLERANCE, 0},
{ 680, 1091905603u, 107442539u, 3239767031u, 1149813329u, 1076462360u, 989447787u, 0, LOG_TOLERANCE, 0},
{ 681, 1085961592u, 1761361082u, 3226030205u, 1121849716u, 1075946555u, 3494606763u, 0, LOG_TOLERANCE, 0},
{ 682, 1092603467u, 2534144722u, 1044223733u, 3512285706u, 1076515793u, 3692269602u, 0, LOG_TOLERANCE, 0},
{ 683, 1064362429u, 4073670723u, 1050729852u, 3034818849u, 3222665043u, 2495345955u, 0, LOG_TOLERANCE, 0},
{ 684, 1101984574u, 1421423503u, 1060278048u, 1397153092u, 1077108720u, 2189969898u, 0, LOG_TOLERANCE, 0},
{ 685, 1069938181u, 1649206019u, 1104525577u, 1267104290u, 3220976709u, 450530095u, 0, LOG_TOLERANCE, 0},
{ 686, 1041818449u, 3775270392u, 1040251850u, 68667319u, 3224656453u, 1211401134u, 0, LOG_TOLERANCE, 0},
{ 687, 1056847252u, 3099226694u, 3254103006u, 4020102648u, 3223644378u, 3130345782u, 0, LOG_TOLERANCE, 0},
{ 688, 1054108064u, 3718441177u, 3215643451u, 4032951536u, 3223877462u, 3985566266u, 0, LOG_TOLERANCE, 0},
{ 689, 1044131371u, 508048351u, 3210196713u, 1707937896u, 3224557458u, 3794348307u, 0, LOG_TOLERANCE, 0},
{ 690, 1051127979u, 2784738160u, 1073435430u, 1109346010u, 3224134718u, 3763898383u, 0, LOG_TOLERANCE, 0},
{ 691, 1078241642u, 3331916473u, 3238794568u, 2707019594u, 1074644350u, 3000068445u, 0, LOG_TOLERANCE, 0},
{ 692, 1093182670u, 3093165197u, 1072894805u, 2853215019u, 1076573206u, 1052317797u, 0, LOG_TOLERANCE, 0},
{ 693, 1069098491u, 2135797997u, 1048399559u, 2941926126u, 3221393445u, 3011165202u, 0, LOG_TOLERANCE, 0},
{ 694, 1048430980u, 2083412145u, 3249335391u, 507212448u, 3224372120u, 1391497455u, 0, LOG_TOLERANCE, 0},
{ 695, 1075363751u, 4270176401u, 3246546709u, 3288753319u, 1073555677u, 2172392844u, 0, LOG_TOLERANCE, 0},
{ 696, 1100449215u, 3692175292u, 3197271515u, 3989064196u, 1077045309u, 3615376251u, 0, LOG_TOLERANCE, 0},
{ 697, 1104208090u, 3111924274u, 1066772558u, 59281695u, 1077205261u, 865144419u, 0, LOG_TOLERANCE, 0},
{ 698, 1067683911u, 2135245466u, 3208804313u, 3846547392u, 3221888515u, 519778435u, 0, LOG_TOLERANCE, 0},
{ 699, 1094877811u, 972051266u, 3222814246u, 3539700586u, 1076717393u, 83189865u, 0, LOG_TOLERANCE, 0},
{ 700, 1055482282u, 330951080u, 1079189813u, 583922384u, 3223758054u, 1639805153u, 0, LOG_TOLERANCE, 0},
{ 701, 1089640092u, 1711944085u, 1104170032u, 643991456u, 1076263688u, 2474566662u, 0, LOG_TOLERANCE, 0},
{ 702, 1086945901u, 2072550721u, 3250147641u, 4280263530u, 1076032457u, 3503982552u, 0, LOG_TOLERANCE, 0},
{ 703, 1045489058u, 1566376352u, 1067251433u, 72984588u, 3224500127u, 2508162584u, 0, LOG_TOLERANCE, 0},
{ 704, 1095276569u, 3103043079u, 1045853123u, 410067497u, 1076754646u, 1510773583u, 0, LOG_TOLERANCE, 0},
{ 705, 1069188845u, 1910366299u, 1081770885u, 634683073u, 3221365463u, 978597306u, 0, LOG_TOLERANCE, 0},
{ 706, 1081530688u, 2226525875u, 3224149290u, 2126302825u, 1075288861u, 2856541718u, 0, LOG_TOLERANCE, 0},
{ 707, 1073150247u, 1383818978u, 3193885723u, 1220372650u, 1071064776u, 471056163u, 0, LOG_TOLERANCE, 0},
{ 708, 1066482943u, 1953339096u, 1077176252u, 1476516558u, 3222296157u, 654778802u, 0, LOG_TOLERANCE, 0},
{ 709, 1066092000u, 1306277326u, 1079089150u, 4093716191u, 3222357599u, 1919559441u, 0, LOG_TOLERANCE, 0},
{ 710, 1085665139u, 51750045u, 3242913901u, 4256866157u, 1075921980u, 3722237157u, 0, LOG_TOLERANCE, 0},
{ 711, 1047601319u, 2163853087u, 3232053146u, 2962422808u, 3224408387u, 1081948641u, 0, LOG_TOLERANCE, 0},
{ 712, 1075516945u, 1618388148u, 3233154824u, 3711953164u, 1073650314u, 3812165070u, 0, LOG_TOLERANCE, 0},
{ 713, 1099384354u, 357108214u, 3202294604u, 2306775262u, 1076999187u, 3070689462u, 0, LOG_TOLERANCE, 0},
{ 714, 1054420438u, 2571356437u, 3249064063u, 2394851808u, 3223849956u, 882036239u, 0, LOG_TOLERANCE, 0},
{ 715, 1083004443u, 4273880094u, 1103698617u, 3578832032u, 1075536085u, 1389153068u, 0, LOG_TOLERANCE, 0},
{ 716, 1085943053u, 2091068742u, 3228270226u, 3980489730u, 1075945146u, 3992739543u, 0, LOG_TOLERANCE, 0},
{ 717, 1081533104u, 2772307714u, 1051008486u, 32546576u, 1075289284u, 1304738751u, 0, LOG_TOLERANCE, 0},
{ 718, 1093745567u, 2143788498u, 3195498043u, 3630119231u, 1076617173u, 1940068716u, 0, LOG_TOLERANCE, 0},
{ 719, 1051149287u, 2527385594u, 3240503648u, 3482095012u, 3224132874u, 932358108u, 0, LOG_TOLERANCE, 0},
{ 720, 1094685151u, 2690097362u, 1068598730u, 2360266862u, 1076696521u, 4114952864u, 0, LOG_TOLERANCE, 0},
{ 721, 1058857869u, 2673272949u, 1082639557u, 522449749u, 3223468532u, 1585235010u, 0, LOG_TOLERANCE, 0},
{ 722, 1104424147u, 3596379400u, 3242016775u, 2002293002u, 1077216954u, 167880927u, 0, LOG_TOLERANCE, 0},
{ 723, 1099439656u, 4113224369u, 3222122439u, 2152316893u, 1077001521u, 3528290140u, 0, LOG_TOLERANCE, 0},
{ 724, 1073313068u, 31662602u, 1047721249u, 1747087514u, 1071495479u, 361856717u, 0, LOG_TOLERANCE, 0},
{ 725, 1102980109u, 2489659568u, 1097051253u, 277506957u, 1077152410u, 220731815u, 0, LOG_TOLERANCE, 0},
{ 726, 1043918186u, 3850162281u, 3213841942u, 438724093u, 3224565497u, 1335181127u, 0, LOG_TOLERANCE, 0},
{ 727, 1095392535u, 2431814052u, 1075518084u, 2672434118u, 1076763752u, 3902665789u, 0, LOG_TOLERANCE, 0},
{ 728, 1095679087u, 391606792u, 1048184750u, 4168944276u, 1076783866u, 201632535u, 0, LOG_TOLERANCE, 0},
{ 729, 1100308768u, 457529672u, 3201090276u, 72407935u, 1077039049u, 1370091833u, 0, LOG_TOLERANCE, 0},
{ 730, 1071237071u, 3954981400u, 1052053242u, 2411049585u, 3219986608u, 4011189326u, 0, LOG_TOLERANCE, 0},
{ 731, 1086180091u, 485456950u, 1088415093u, 1655397424u, 1075962111u, 1049136648u, 0, LOG_TOLERANCE, 0},
{ 732, 1050750780u, 1551748070u, 3236871640u, 1329701152u, 3224172582u, 3333561594u, 0, LOG_TOLERANCE, 0},
{ 733, 1077155474u, 3099222537u, 1104984570u, 4293792842u, 1074266180u, 3823978682u, 0, LOG_TOLERANCE, 0},
{ 734, 1056466057u, 3603065260u, 3197735968u, 2402359253u, 3223672410u, 1773379774u, 0, LOG_TOLERANCE, 0},
{ 735, 1051340936u, 3961208159u, 3219057584u, 2340553876u, 3224117355u, 671685669u, 0, LOG_TOLERANCE, 0},
{ 736, 1074881909u, 4014841779u, 3197672877u, 3697233334u, 1073186041u, 4149752821u, 0, LOG_TOLERANCE, 0},
{ 737, 1065792009u, 1403876392u, 3254028950u, 921363393u, 3222405763u, 1643497528u, 0, LOG_TOLERANCE, 0},
{ 738, 1107251806u, 1862576361u, 3194031708u, 2476290925u, 1077336633u, 466978083u, 0, LOG_TOLERANCE, 0},
{ 739, 1049661768u, 1454212851u, 1088378861u, 3400401866u, 3224268227u, 2694325211u, 0, LOG_TOLERANCE, 0},
{ 740, 1074406809u, 552676385u, 3188635745u, 3778112968u, 1072886487u, 3569287692u, 0, LOG_TOLERANCE, 0},
{ 741, 1068925634u, 1199568671u, 3225679997u, 46947405u, 3221451536u, 928442461u, 0, LOG_TOLERANCE, 0},
{ 742, 1077685537u, 2596231448u, 3253943728u, 2219151748u, 1074443573u, 2231242182u, 0, LOG_TOLERANCE, 0},
{ 743, 1066527035u, 4119719558u, 3222036299u, 1275474618u, 3222286120u, 1979658371u, 0, LOG_TOLERANCE, 0},
{ 744, 1092425015u, 3347296825u, 1101507910u, 1254014794u, 1076504062u, 3829864000u, 0, LOG_TOLERANCE, 0},
{ 745, 1084119992u, 673775040u, 1070743626u, 244126093u, 1075726765u, 3754705647u, 0, LOG_TOLERANCE, 0},
{ 746, 1055716202u, 1832066983u, 1051358028u, 3262483417u, 3223740808u, 426169343u, 0, LOG_TOLERANCE, 0},
{ 747, 1077559600u, 3962610501u, 3198598777u, 849269178u, 1074406538u, 4237515409u, 0, LOG_TOLERANCE, 0},
{ 748, 1087990252u, 2497516122u, 3254374111u, 2821429629u, 1076122977u, 4015412349u, 0, LOG_TOLERANCE, 0},
{ 749, 1076236288u, 2805941787u, 3217785843u, 779131141u, 1073951923u, 1273545107u, 0, LOG_TOLERANCE, 0},
{ 750, 1079425038u, 723423605u, 1084533420u, 627282213u, 1074923960u, 3923850419u, 0, LOG_TOLERANCE, 0},
{ 751, 1068464032u, 4292778869u, 1078101071u, 1676860147u, 3221639332u, 890635976u, 0, LOG_TOLERANCE, 0},
{ 752, 1076288502u, 3528118587u, 3194648564u, 2363260897u, 1073970522u, 2685750176u, 0, LOG_TOLERANCE, 0},
{ 753, 1045414231u, 1307010018u, 1061248120u, 1468743108u, 3224504205u, 2718243292u, 0, LOG_TOLERANCE, 0},
{ 754, 1099099491u, 107905661u, 3226089788u, 1943427674u, 1076985639u, 1932047369u, 0, LOG_TOLERANCE, 0},
{ 755, 1040746893u, 760006940u, 1054265604u, 1749976597u, 3224702809u, 1323817312u, 0, LOG_TOLERANCE, 0},
{ 756, 1090289736u, 2787503556u, 1081282610u, 1195841206u, 1076319709u, 4181618500u, 0, LOG_TOLERANCE, 0},
{ 757, 1044318508u, 545462045u, 3208381743u, 1981311808u, 3224551133u, 2183045557u, 0, LOG_TOLERANCE, 0},
{ 758, 1061232136u, 3657978397u, 1104463616u, 3501253426u, 3223206524u, 3484237357u, 0, LOG_TOLERANCE, 0},
{ 759, 1049883857u, 1804177501u, 3210693633u, 3606766729u, 3224243834u, 3517531742u, 0, LOG_TOLERANCE, 0},
{ 760, 1076856879u, 1336278526u, 1043741618u, 3165279431u, 1074139158u, 833486214u, 0, LOG_TOLERANCE, 0},
{ 761, 1055471915u, 1599382075u, 1058018527u, 4212580517u, 3223758873u, 3473614230u, 0, LOG_TOLERANCE, 0},
{ 762, 1060018678u, 3007589929u, 3202026547u, 2792028313u, 3223370131u, 3372574984u, 0, LOG_TOLERANCE, 0},
{ 763, 1105599122u, 1866066996u, 1060329048u, 3727175322u, 1077268363u, 2407515951u, 0, LOG_TOLERANCE, 0},
{ 764, 1050932995u, 150890940u, 1056025306u, 3082724735u, 3224152926u, 1543567732u, 0, LOG_TOLERANCE, 0},
{ 765, 1062008939u, 80400395u, 1093584426u, 3478941315u, 3223068589u, 334202438u, 0, LOG_TOLERANCE, 0},
{ 766, 1104156966u, 4050954182u, 3219263194u, 2537475930u, 1077202160u, 52121861u, 0, LOG_TOLERANCE, 0},
{ 767, 1064841871u, 2881752155u, 3212589299u, 2559651278u, 3222570668u, 1289897413u, 0, LOG_TOLERANCE, 0},
{ 768, 1101532656u, 440309030u, 3214267461u, 3788040806u, 1077092201u, 2541610027u, 0, LOG_TOLERANCE, 0},
{ 769, 1100476615u, 918813144u, 3208535698u, 1607035904u, 1077046464u, 1838368906u, 0, LOG_TOLERANCE, 0},
{ 770, 1042137451u, 2497054124u, 1089139147u, 2549609010u, 3224644746u, 2204082529u, 0, LOG_TOLERANCE, 0},
{ 771, 1047037641u, 790219083u, 1054657139u, 2797979479u, 3224430281u, 2605152109u, 0, LOG_TOLERANCE, 0},
{ 772, 1057781400u, 1149462078u, 1095765205u, 3879963182u, 3223561330u, 8173155u, 0, LOG_TOLERANCE, 0},
{ 773, 1055246165u, 2684353926u, 3205212854u, 1732474928u, 3223778120u, 1100684416u, 0, LOG_TOLERANCE, 0},
{ 774, 1095236965u, 2742237025u, 1051317716u, 3386396147u, 1076751385u, 2203378921u, 0, LOG_TOLERANCE, 0},
{ 775, 1063230986u, 3408320912u, 1103071166u, 4233059513u, 3222863964u, 3924505576u, 0, LOG_TOLERANCE, 0},
{ 776, 1064863548u, 1077495917u, 1088399968u, 433115118u, 3222567109u, 1263879149u, 0, LOG_TOLERANCE, 0},
{ 777, 1057063924u, 841366493u, 1051716814u, 4121125128u, 3223624969u, 2299430516u, 0, LOG_TOLERANCE, 0},
{ 778, 1064632084u, 321857207u, 1089128010u, 1149988239u, 3222607866u, 627293357u, 0, LOG_TOLERANCE, 0},
{ 779, 1098059015u, 799866606u, 3197637091u, 3924438208u, 1076940639u, 3980982339u, 0, LOG_TOLERANCE, 0},
{ 780, 1043579242u, 2002049816u, 1077053447u, 2240354761u, 3224580736u, 3000679411u, 0, LOG_TOLERANCE, 0},
{ 781, 1081522635u, 478939968u, 1097035749u, 1066716440u, 1075287447u, 4249888900u, 0, LOG_TOLERANCE, 0},
{ 782, 1084989993u, 1653104725u, 1088548129u, 81977716u, 1075861396u, 3386829085u, 0, LOG_TOLERANCE, 0},
{ 783, 1049377628u, 3899475018u, 3189694084u, 3330093036u, 3224289217u, 1387095058u, 0, LOG_TOLERANCE, 0},
{ 784, 1089312583u, 2612450289u, 1079065127u, 603380842u, 1076233776u, 1203102347u, 0, LOG_TOLERANCE, 0},
{ 785, 1100636791u, 3962735564u, 1101570429u, 1372490825u, 1077052835u, 465092515u, 0, LOG_TOLERANCE, 0},
{ 786, 1054806016u, 1479841439u, 1059312257u, 541504905u, 3223822432u, 2295334392u, 0, LOG_TOLERANCE, 0},
{ 787, 1078662178u, 2626148789u, 1057571099u, 4121656076u, 1074786149u, 2318575113u, 0, LOG_TOLERANCE, 0},
{ 788, 1081613389u, 1902560314u, 1043130231u, 3557671562u, 1075302954u, 181613322u, 0, LOG_TOLERANCE, 0},
{ 789, 1046346124u, 41779312u, 1081626342u, 831171823u, 3224462561u, 114420931u, 0, LOG_TOLERANCE, 0},
{ 790, 1058131100u, 1393168821u, 1066457405u, 1381616968u, 3223532010u, 2221031919u, 0, LOG_TOLERANCE, 0},
{ 791, 1072338141u, 3756584649u, 3222267229u, 1423157432u, 3217538846u, 3153950627u, 0, LOG_TOLERANCE, 0},
{ 792, 1106952026u, 1894912556u, 1042426694u, 155024547u, 1077326286u, 3244175068u, 0, LOG_TOLERANCE, 0},
{ 793, 1047969864u, 35164295u, 3203391785u, 1037041084u, 3224389779u, 4101769333u, 0, LOG_TOLERANCE, 0},
{ 794, 1084777479u, 3957875950u, 3232195211u, 1590756436u, 1075845035u, 4253257181u, 0, LOG_TOLERANCE, 0},
{ 795, 1068844322u, 1447585080u, 1071279485u, 1107922438u, 3221481260u, 739417708u, 0, LOG_TOLERANCE, 0},
{ 796, 1046252518u, 981897615u, 1051856116u, 430357614u, 3224465760u, 2990774932u, 0, LOG_TOLERANCE, 0},
{ 797, 1080040567u, 395145384u, 3219821938u, 50586510u, 1075015570u, 401425942u, 0, LOG_TOLERANCE, 0},
{ 798, 1069775912u, 750827797u, 1082862669u, 230466783u, 3221102144u, 3089938357u, 0, LOG_TOLERANCE, 0},
{ 799, 1086668819u, 1365083575u, 3204848310u, 1700831722u, 1076008674u, 1350249998u, 0, LOG_TOLERANCE, 0},
{ 800, 1070606742u, 344241827u, 1071538935u, 2715566077u, 3220571362u, 2564406257u, 0, LOG_TOLERANCE, 0},
{ 801, 1100099208u, 4069301823u, 3193208760u, 2949125229u, 1077028431u, 4184156688u, 0, LOG_TOLERANCE, 0},
{ 802, 1103231387u, 3585711710u, 1065801594u, 2302229267u, 1077163960u, 3362941620u, 0, LOG_TOLERANCE, 0},
{ 803, 1046635308u, 709803845u, 1048741487u, 2296910194u, 3224449161u, 3527999523u, 0, LOG_TOLERANCE, 0},
{ 804, 1045797131u, 744421179u, 1069302001u, 2659232829u, 3224484041u, 1605643857u, 0, LOG_TOLERANCE, 0},
{ 805, 1092835968u, 1799949903u, 3192522886u, 4212149209u, 1076541532u, 2940590139u, 0, LOG_TOLERANCE, 0},
{ 806, 1058624854u, 145234164u, 3250614064u, 912384201u, 3223485746u, 3198580186u, 0, LOG_TOLERANCE, 0},
{ 807, 1093027016u, 2784620507u, 1102812948u, 3531481022u, 1076559923u, 64675630u, 0, LOG_TOLERANCE, 0},
{ 808, 1103676015u, 383952592u, 3205659905u, 3633194728u, 1077184947u, 422506066u, 0, LOG_TOLERANCE, 0},
{ 809, 1055992604u, 3792395543u, 1070072378u, 3864816376u, 3223718444u, 3170253965u, 0, LOG_TOLERANCE, 0},
{ 810, 1057832625u, 2115553675u, 1066288499u, 3538377867u, 3223557779u, 620943456u, 0, LOG_TOLERANCE, 0},
{ 811, 1104591537u, 1230026762u, 1090719723u, 440819880u, 1077224766u, 793358222u, 0, LOG_TOLERANCE, 0},
{ 812, 1047111428u, 2991290482u, 1096886719u, 1097971167u, 3224427340u, 586302082u, 0, LOG_TOLERANCE, 0},
{ 813, 1090048600u, 1098035020u, 3230900504u, 1479059095u, 1076301592u, 1583059249u, 0, LOG_TOLERANCE, 0},
{ 814, 1103573316u, 1719428427u, 3188631907u, 3707377409u, 1077180662u, 744410774u, 0, LOG_TOLERANCE, 0},
{ 815, 1053236165u, 3748932896u, 1084908557u, 1325384361u, 3223952056u, 54146495u, 0, LOG_TOLERANCE, 0},
{ 816, 1084704076u, 3979168763u, 1057455255u, 2454615952u, 1075838772u, 4208492007u, 0, LOG_TOLERANCE, 0},
{ 817, 1053106984u, 1449164578u, 1056960316u, 1654931641u, 3223963742u, 1191827742u, 0, LOG_TOLERANCE, 0},
{ 818, 1071439010u, 2120487381u, 3226298974u, 2364226633u, 3219749836u, 3169186900u, 0, LOG_TOLERANCE, 0},
{ 819, 1075071428u, 1074268944u, 1065730444u, 280016852u, 1073347289u, 2458807329u, 0, LOG_TOLERANCE, 0},
{ 820, 1052824608u, 3315127889u, 3236295594u, 2900924954u, 3223993621u, 1689734749u, 0, LOG_TOLERANCE, 0},
{ 821, 1048942243u, 2246037502u, 1049691002u, 1496066550u, 3224324383u, 896522170u, 0, LOG_TOLERANCE, 0},
{ 822, 1045523211u, 4191285446u, 3217936236u, 2382392789u, 3224498136u, 3635803563u, 0, LOG_TOLERANCE, 0},
{ 823, 1092833308u, 640099844u, 1042152237u, 2064279383u, 1076541257u, 2073083715u, 0, LOG_TOLERANCE, 0},
{ 824, 1079913438u, 3468560824u, 1093251038u, 310958750u, 1074998329u, 1785611289u, 0, LOG_TOLERANCE, 0},
{ 825, 1096788400u, 1413568905u, 1100941106u, 1627289946u, 1076878612u, 3418590u, 0, LOG_TOLERANCE, 0},
{ 826, 1044065902u, 3797143370u, 3195497539u, 3843275034u, 3224559824u, 1066708699u, 0, LOG_TOLERANCE, 0},
{ 827, 1104593745u, 2806642640u, 3201943068u, 2515980718u, 1077224863u, 1169910650u, 0, LOG_TOLERANCE, 0},
{ 828, 1086877316u, 632580632u, 1078673506u, 3259601317u, 1076026960u, 1211939235u, 0, LOG_TOLERANCE, 0},
{ 829, 1053496927u, 3309678799u, 1049337078u, 3056787074u, 3223931232u, 3362832351u, 0, LOG_TOLERANCE, 0},
{ 830, 1074011641u, 2341164249u, 1080834967u, 2810890005u, 1072529938u, 3492796186u, 0, LOG_TOLERANCE, 0},
{ 831, 1067019674u, 932124675u, 1093915797u, 662682630u, 3222114462u, 3894149768u, 0, LOG_TOLERANCE, 0},
{ 832, 1101746443u, 1367996113u, 3251723684u, 2974064663u, 1077100536u, 289595985u, 0, LOG_TOLERANCE, 0},
{ 833, 1080230731u, 323437999u, 1090499064u, 901457511u, 1075058981u, 2425521271u, 0, LOG_TOLERANCE, 0},
{ 834, 1088295228u, 4184941840u, 3196770014u, 2458988443u, 1076145017u, 2080164599u, 0, LOG_TOLERANCE, 0},
{ 835, 1087618284u, 2023065054u, 3211994098u, 2734612965u, 1076089849u, 4264391451u, 0, LOG_TOLERANCE, 0},
{ 836, 1064074694u, 3679267365u, 3237728785u, 1699558211u, 3222709551u, 2162071350u, 0, LOG_TOLERANCE, 0},
{ 837, 1088079010u, 1826799031u, 1078709629u, 3986905229u, 1076129783u, 831887257u, 0, LOG_TOLERANCE, 0},
{ 838, 1052843785u, 351061688u, 3194386466u, 4105857588u, 3223991361u, 4161570046u, 0, LOG_TOLERANCE, 0},
{ 839, 1054128006u, 1365244058u, 1064457319u, 1452191426u, 3223875523u, 2194127603u, 0, LOG_TOLERANCE, 0},
{ 840, 1064122385u, 2463030625u, 3215975031u, 3773488326u, 3222702940u, 454708982u, 0, LOG_TOLERANCE, 0},
{ 841, 1103793023u, 752664055u, 1065110394u, 1835931663u, 1077189510u, 1147034722u, 0, LOG_TOLERANCE, 0},
{ 842, 1088045088u, 3496172149u, 1089617208u, 109068701u, 1076127223u, 3818699807u, 0, LOG_TOLERANCE, 0},
{ 843, 1050651439u, 1636966254u, 1086098766u, 2016598298u, 3224183308u, 192307776u, 0, LOG_TOLERANCE, 0},
{ 844, 1050931318u, 3551516956u, 1097969102u, 1317953425u, 3224153094u, 1643417671u, 0, LOG_TOLERANCE, 0},
{ 845, 1082348569u, 2977627788u, 1045339018u, 516058480u, 1075426706u, 3059244798u, 0, LOG_TOLERANCE, 0},
{ 846, 1089924930u, 3901731263u, 3189566462u, 32272932u, 1076291228u, 2566529534u, 0, LOG_TOLERANCE, 0},
{ 847, 1077281796u, 1956025297u, 3246628529u, 3840733905u, 1074314218u, 1358305666u, 0, LOG_TOLERANCE, 0},
{ 848, 1099818036u, 561057891u, 3198494340u, 4271027193u, 1077015587u, 909699399u, 0, LOG_TOLERANCE, 0},
{ 849, 1103446273u, 692989850u, 3242630588u, 2492225971u, 1077174941u, 3636625117u, 0, LOG_TOLERANCE, 0},
{ 850, 1057995749u, 3439913962u, 1067477011u, 2973333638u, 3223547072u, 3493673504u, 0, LOG_TOLERANCE, 0},
{ 851, 1066510341u, 877613377u, 1044917899u, 809672798u, 3222289875u, 2551263584u, 0, LOG_TOLERANCE, 0},
{ 852, 1074687806u, 905426932u, 1046417457u, 1086320855u, 1073045712u, 3786045969u, 0, LOG_TOLERANCE, 0},
{ 853, 1098862981u, 2645567288u, 1051258339u, 557182478u, 1076973217u, 1877277898u, 0, LOG_TOLERANCE, 0},
{ 854, 1056574302u, 186287752u, 1061342054u, 4054003419u, 3223663822u, 3680860005u, 0, LOG_TOLERANCE, 0},
{ 855, 1097266673u, 3506889716u, 3243866036u, 519056371u, 1076907447u, 2195222634u, 0, LOG_TOLERANCE, 0},
{ 856, 1042654053u, 2171898436u, 3246911982u, 1091500784u, 3224620197u, 242852427u, 0, LOG_TOLERANCE, 0},
{ 857, 1096164025u, 368493885u, 3222871893u, 1419055230u, 1076831694u, 449968426u, 0, LOG_TOLERANCE, 0},
{ 858, 1091950572u, 2010971245u, 3188804530u, 1518695799u, 1076466543u, 3088120894u, 0, LOG_TOLERANCE, 0},
{ 859, 1057942861u, 1239207795u, 1040192984u, 2199481342u, 3223550449u, 736007617u, 0, LOG_TOLERANCE, 0},
{ 860, 1063494989u, 4264613432u, 3203460972u, 3558930895u, 3222807000u, 3647579418u, 0, LOG_TOLERANCE, 0},
{ 861, 1050299283u, 3772748958u, 3227667376u, 309688336u, 3224207679u, 3122404269u, 0, LOG_TOLERANCE, 0},
{ 862, 1083259393u, 1077949160u, 1075769893u, 2405271377u, 1075578230u, 4243093929u, 0, LOG_TOLERANCE, 0},
{ 863, 1091835152u, 3751608506u, 3232278094u, 930375071u, 1076455525u, 1816836840u, 0, LOG_TOLERANCE, 0},
{ 864, 1051133505u, 1518334131u, 3205247482u, 791756713u, 3224134238u, 39391912u, 0, LOG_TOLERANCE, 0},
{ 865, 1047317453u, 2825203170u, 3245054001u, 1822981827u, 3224419764u, 57817157u, 0, LOG_TOLERANCE, 0},
{ 866, 1100016363u, 514474738u, 1089072073u, 3300845441u, 1077023709u, 1264961045u, 0, LOG_TOLERANCE, 0},
{ 867, 1068907602u, 247369460u, 3197320093u, 687450958u, 3221457984u, 388074873u, 0, LOG_TOLERANCE, 0},
{ 868, 1104161422u, 2722237629u, 1058272368u, 90602316u, 1077202436u, 903459361u, 0, LOG_TOLERANCE, 0},
{ 869, 1060614787u, 1845900544u, 3231520830u, 3389751458u, 3223302961u, 1582822839u, 0, LOG_TOLERANCE, 0},
{ 870, 1100051597u, 737689911u, 3195377751u, 3462616966u, 1077025759u, 2432802595u, 0, LOG_TOLERANCE, 0},
{ 871, 1076054736u, 3620285831u, 1055501023u, 2708056059u, 1073881576u, 1018222756u, 0, LOG_TOLERANCE, 0},
{ 872, 1071981348u, 4073430285u, 1056206159u, 172017902u, 3218770535u, 1223482098u, 0, LOG_TOLERANCE, 0},
{ 873, 1065385990u, 2799176222u, 1052706894u, 4083892667u, 3222489334u, 1732069215u, 0, LOG_TOLERANCE, 0},
{ 874, 1054795909u, 1562351330u, 1069705601u, 1247765260u, 3223823084u, 3892941165u, 0, LOG_TOLERANCE, 0},
{ 875, 1085233651u, 51853475u, 3189080201u, 2783553144u, 1075877942u, 597698047u, 0, LOG_TOLERANCE, 0},
{ 876, 1071970705u, 3851781549u, 3241598113u, 514064046u, 3218802885u, 83380447u, 0, LOG_TOLERANCE, 0},
{ 877, 1100045965u, 934745487u, 3248182437u, 2798581921u, 1077025436u, 511499556u, 0, LOG_TOLERANCE, 0},
{ 878, 1065598845u, 2948648757u, 3232177250u, 4278702895u, 3222442230u, 3112138043u, 0, LOG_TOLERANCE, 0},
{ 879, 1072485724u, 4259101461u, 1061606772u, 84229920u, 3216682197u, 1239324620u, 0, LOG_TOLERANCE, 0},
{ 880, 1050591911u, 3891230598u, 1095924595u, 3049217547u, 3224187122u, 1722764368u, 0, LOG_TOLERANCE, 0},
{ 881, 1077353053u, 3806018919u, 3243191216u, 280177341u, 1074339492u, 2305804754u, 0, LOG_TOLERANCE, 0},
{ 882, 1060624530u, 3900344258u, 1063647809u, 4206745890u, 3223301321u, 3655805288u, 0, LOG_TOLERANCE, 0},
{ 883, 1080223688u, 2126253040u, 3207248026u, 808507485u, 1075057495u, 3077099285u, 0, LOG_TOLERANCE, 0},
{ 884, 1086090317u, 3465685634u, 3230391053u, 3754958214u, 1075955941u, 3478718566u, 0, LOG_TOLERANCE, 0},
{ 885, 1102861084u, 461094531u, 1101110393u, 1316091396u, 1077148337u, 392520667u, 0, LOG_TOLERANCE, 0},
{ 886, 1064980314u, 4197635149u, 1091873113u, 1240127141u, 3222548727u, 593733443u, 0, LOG_TOLERANCE, 0},
{ 887, 1074333893u, 118603800u, 1105304898u, 4291425557u, 1072840891u, 1190118690u, 0, LOG_TOLERANCE, 0},
{ 888, 1065945517u, 3744663425u, 3212482771u, 953662066u, 3222380014u, 4188749851u, 0, LOG_TOLERANCE, 0},
{ 889, 1085171305u, 3564196690u, 3228101916u, 904305212u, 1075873903u, 1537471083u, 0, LOG_TOLERANCE, 0},
{ 890, 1048333111u, 3566257266u, 3235138829u, 2734275140u, 3224375491u, 608683477u, 0, LOG_TOLERANCE, 0},
{ 891, 1096464829u, 606044282u, 3241318094u, 2446416887u, 1076856392u, 525104051u, 0, LOG_TOLERANCE, 0},
{ 892, 1041627284u, 2336116589u, 3197594053u, 2296925138u, 3224664623u, 89627721u, 0, LOG_TOLERANCE, 0},
{ 893, 1058567659u, 907670625u, 3240769036u, 1827119006u, 3223490341u, 3151493257u, 0, LOG_TOLERANCE, 0},
{ 894, 1044467183u, 2818710946u, 3246059905u, 553394170u, 3224543992u, 819274532u, 0, LOG_TOLERANCE, 0},
{ 895, 1042020446u, 4099522736u, 3232742168u, 3718083858u, 3224648801u, 2651059661u, 0, LOG_TOLERANCE, 0},
{ 896, 1092371276u, 1059279404u, 1080245336u, 175941677u, 1076500314u, 769778733u, 0, LOG_TOLERANCE, 0},
{ 897, 1105189691u, 1650862428u, 1061816101u, 1723201723u, 1077246890u, 412568919u, 0, LOG_TOLERANCE, 0},
{ 898, 1091529166u, 2462163405u, 3218946201u, 3876535372u, 1076423313u, 4205043249u, 0, LOG_TOLERANCE, 0},
{ 899, 1084392886u, 495844137u, 1073721460u, 772777946u, 1075778946u, 2812768446u, 0, LOG_TOLERANCE, 0},
{ 900, 1052415330u, 458757721u, 3245680321u, 3609892707u, 3224024546u, 383002261u, 0, LOG_TOLERANCE, 0},
{ 901, 1045799308u, 2533012202u, 1079980803u, 3592268374u, 3224483940u, 2726652976u, 0, LOG_TOLERANCE, 0},
{ 902, 1055881132u, 4108274117u, 1063045844u, 571992389u, 3223729882u, 2314481097u, 0, LOG_TOLERANCE, 0},
{ 903, 1090567271u, 3541110973u, 1096296754u, 3118427427u, 1076340781u, 2632740799u, 0, LOG_TOLERANCE, 0},
{ 904, 1046496395u, 1213941007u, 1105433735u, 2172963370u, 3224457188u, 3052458673u, 0, LOG_TOLERANCE, 0},
{ 905, 1096853359u, 272190288u, 1095452370u, 4026581530u, 1076885251u, 2478993271u, 0, LOG_TOLERANCE, 0},
{ 906, 1095583909u, 2843638672u, 1100510986u, 3190536898u, 1076777521u, 3199401103u, 0, LOG_TOLERANCE, 0},
{ 907, 1083757094u, 2014317727u, 3247389683u, 2428462015u, 1075673974u, 2005503768u, 0, LOG_TOLERANCE, 0},
{ 908, 1093976717u, 688442200u, 1047852515u, 3035186380u, 1076641579u, 3598085678u, 0, LOG_TOLERANCE, 0},
{ 909, 1076664212u, 1010095511u, 3221288076u, 405287991u, 1074087845u, 1781834194u, 0, LOG_TOLERANCE, 0},
{ 910, 1104810967u, 2983070435u, 1089546472u, 2907918480u, 1077233772u, 563486515u, 0, LOG_TOLERANCE, 0},
{ 911, 1082988121u, 81928569u, 1056007286u, 2740556321u, 1075533850u, 821769330u, 0, LOG_TOLERANCE, 0},
{ 912, 1041110867u, 2076689028u, 1081558619u, 3039159031u, 3224689437u, 2823928781u, 0, LOG_TOLERANCE, 0},
{ 913, 1047307438u, 1376882094u, 3211003208u, 1296286481u, 3224420112u, 3184365003u, 0, LOG_TOLERANCE, 0},
{ 914, 1080114314u, 744133164u, 3200943494u, 955832216u, 1075033268u, 2149302111u, 0, LOG_TOLERANCE, 0},
{ 915, 1078806678u, 176522478u, 1069999908u, 2891249491u, 1074808795u, 1563703192u, 0, LOG_TOLERANCE, 0},
{ 916, 1043564602u, 3685851715u, 3187829932u, 2363997529u, 3224581481u, 4116919064u, 0, LOG_TOLERANCE, 0},
{ 917, 1040244055u, 3974431579u, 1052505165u, 2589067816u, 3224727383u, 3362925734u, 0, LOG_TOLERANCE, 0},
{ 918, 1044013141u, 3819109588u, 1048561488u, 969143351u, 3224561794u, 2773963981u, 0, LOG_TOLERANCE, 0},
{ 919, 1072639397u, 4246896124u, 1104584799u, 1940097860u, 3214582574u, 1851284834u, 0, LOG_TOLERANCE, 0},
{ 920, 1048038468u, 2228686199u, 3220231833u, 777624847u, 3224386831u, 3580440236u, 0, LOG_TOLERANCE, 0},
{ 921, 1083983658u, 4189906558u, 3203004203u, 854242364u, 1075708157u, 2324538567u, 0, LOG_TOLERANCE, 0},
{ 922, 1103910407u, 4089051094u, 3227282692u, 2693170723u, 1077193789u, 2501009459u, 0, LOG_TOLERANCE, 0},
{ 923, 1045883607u, 1278581412u, 3239296746u, 1774588717u, 3224480154u, 4264010772u, 0, LOG_TOLERANCE, 0},
{ 924, 1074889038u, 1794845306u, 1104879344u, 4135865182u, 1073192577u, 3710212999u, 0, LOG_TOLERANCE, 0},
{ 925, 1106449055u, 754938390u, 1061291430u, 2010786993u, 1077304123u, 3433234321u, 0, LOG_TOLERANCE, 0},
{ 926, 1073581409u, 2034303731u, 3240176537u, 314147356u, 1071882849u, 1312596997u, 0, LOG_TOLERANCE, 0},
{ 927, 1083965546u, 567588900u, 3195452230u, 1421366017u, 1075705582u, 3553729720u, 0, LOG_TOLERANCE, 0},
{ 928, 1077606107u, 2708717091u, 1071975971u, 1364590470u, 1074420521u, 3509197008u, 0, LOG_TOLERANCE, 0},
{ 929, 1104653635u, 3461956134u, 3207820115u, 1605709634u, 1077227442u, 3720226522u, 0, LOG_TOLERANCE, 0},
{ 930, 1065302996u, 1497124553u, 1051715442u, 916736957u, 3222503756u, 1982876219u, 0, LOG_TOLERANCE, 0},
{ 931, 1058468363u, 834914365u, 1064667143u, 2839166298u, 3223498722u, 3952086370u, 0, LOG_TOLERANCE, 0},
{ 932, 1057279949u, 2139295776u, 1062816721u, 914592523u, 3223602368u, 1320433153u, 0, LOG_TOLERANCE, 0},
{ 933, 1042153283u, 851569132u, 1058503154u, 1399378677u, 3224644216u, 2599935008u, 0, LOG_TOLERANCE, 0},
{ 934, 1086054049u, 3897202342u, 3245382590u, 246600375u, 1075953364u, 2720951838u, 0, LOG_TOLERANCE, 0},
{ 935, 1077976660u, 3620429520u, 1055627557u, 229305u, 1074530176u, 1186149429u, 0, LOG_TOLERANCE, 0},
{ 936, 1083958833u, 3641997865u, 3206673888u, 93720614u, 1075704622u, 976119397u, 0, LOG_TOLERANCE, 0},
{ 937, 1080324787u, 32766320u, 1062084905u, 3668443038u, 1075078058u, 656045965u, 0, LOG_TOLERANCE, 0},
{ 938, 1075815348u, 2039713492u, 3248699388u, 1346210821u, 1073777533u, 3602564129u, 0, LOG_TOLERANCE, 0},
{ 939, 1093050016u, 1335820726u, 3191756860u, 1808427032u, 1076561972u, 2395175349u, 0, LOG_TOLERANCE, 0},
{ 940, 1061442763u, 650692001u, 1103515670u, 2253348763u, 3223161418u, 2163727770u, 0, LOG_TOLERANCE, 0},
{ 941, 1043911539u, 2372623300u, 3210185343u, 3200572848u, 3224565764u, 2245925970u, 0, LOG_TOLERANCE, 0},
{ 942, 1100796069u, 762317532u, 3194595095u, 3192607437u, 1077058609u, 3401569473u, 0, LOG_TOLERANCE, 0},
{ 943, 1062262701u, 217775356u, 3232827087u, 2969367386u, 3223029063u, 2646417681u, 0, LOG_TOLERANCE, 0},
{ 944, 1057172551u, 3621353969u, 1077994795u, 3873976266u, 3223613118u, 876167905u, 0, LOG_TOLERANCE, 0},
{ 945, 1091301987u, 268372152u, 3221764390u, 3216978962u, 1076407987u, 4222096695u, 0, LOG_TOLERANCE, 0},
{ 946, 1098953963u, 142942404u, 1075322987u, 1746449109u, 1076977460u, 3968533829u, 0, LOG_TOLERANCE, 0},
{ 947, 1104006296u, 496534875u, 3254522293u, 2532372502u, 1077197089u, 321049357u, 0, LOG_TOLERANCE, 0},
{ 948, 1102741893u, 2999955409u, 3222793392u, 1868977643u, 1077143987u, 3900599294u, 0, LOG_TOLERANCE, 0},
{ 949, 1074319042u, 3353193428u, 3218469191u, 3326244297u, 1072831356u, 3904079980u, 0, LOG_TOLERANCE, 0},
{ 950, 1068218799u, 73646871u, 3231442171u, 3711510104u, 3221705708u, 1861471009u, 0, LOG_TOLERANCE, 0},
{ 951, 1090483524u, 218135177u, 3198908856u, 3082199105u, 1076332648u, 1827165077u, 0, LOG_TOLERANCE, 0},
{ 952, 1068068480u, 1061628117u, 3248859043u, 86776158u, 3221750981u, 3403288718u, 0, LOG_TOLERANCE, 0},
{ 953, 1061001026u, 938869114u, 1087911145u, 2416710759u, 3223244738u, 1201893107u, 0, LOG_TOLERANCE, 0},
{ 954, 1095576832u, 2970853959u, 3239543429u, 1887505029u, 1076777037u, 2208889702u, 0, LOG_TOLERANCE, 0},
{ 955, 1090245139u, 1337895935u, 1076463812u, 1172733328u, 1076316542u, 2110621613u, 0, LOG_TOLERANCE, 0},
{ 956, 1049139928u, 1469010822u, 3229583535u, 551399515u, 3224307240u, 3275195384u, 0, LOG_TOLERANCE, 0},
{ 957, 1074118123u, 1849711538u, 1049053713u, 1744276190u, 1072692825u, 2002018797u, 0, LOG_TOLERANCE, 0},
{ 958, 1094655132u, 2976596113u, 3192137295u, 3033242648u, 1076694606u, 1193490101u, 0, LOG_TOLERANCE, 0},
{ 959, 1098698481u, 876810930u, 3197470945u, 2571587447u, 1076967742u, 2031176632u, 0, LOG_TOLERANCE, 0},
{ 960, 1094287162u, 4007797282u, 3225853845u, 4069319648u, 1076668519u, 2581068705u, 0, LOG_TOLERANCE, 0},
{ 961, 1047279982u, 3840538373u, 1043189552u, 3668774580u, 3224421078u, 1501078949u, 0, LOG_TOLERANCE, 0},
{ 962, 1070128056u, 200857661u, 3229758439u, 3359367736u, 3220846767u, 3229574488u, 0, LOG_TOLERANCE, 0},
{ 963, 1101314221u, 111868139u, 3227902082u, 2366064003u, 1077082426u, 2927706018u, 0, LOG_TOLERANCE, 0},
{ 964, 1044195166u, 3510904416u, 3222131653u, 3822770497u, 3224555233u, 1156872369u, 0, LOG_TOLERANCE, 0},
{ 965, 1095192067u, 789151814u, 1099269239u, 2958956055u, 1076747587u, 3873229381u, 0, LOG_TOLERANCE, 0},
{ 966, 1084679320u, 722163228u, 1105524559u, 1534462169u, 1075834482u, 2680752836u, 0, LOG_TOLERANCE, 0},
{ 967, 1046586062u, 2207037106u, 3208952465u, 1231254630u, 3224451896u, 1347588545u, 0, LOG_TOLERANCE, 0},
{ 968, 1050400412u, 3838689849u, 3198769679u, 1302617170u, 3224200205u, 624983689u, 0, LOG_TOLERANCE, 0},
{ 969, 1085938906u, 2527556476u, 3240373426u, 124352692u, 1075944829u, 3000124945u, 0, LOG_TOLERANCE, 0},
{ 970, 1052057157u, 3502371499u, 1043411944u, 4190072016u, 3224054712u, 3615113505u, 0, LOG_TOLERANCE, 0},
{ 971, 1064676142u, 1798470077u, 3200116917u, 3421833729u, 3222599604u, 923411291u, 0, LOG_TOLERANCE, 0},
{ 972, 1046031308u, 3653237931u, 3204255012u, 3683870669u, 3224474007u, 2475930530u, 0, LOG_TOLERANCE, 0},
{ 973, 1053588582u, 376530104u, 1073853547u, 565755892u, 3223924634u, 1674199212u, 0, LOG_TOLERANCE, 0},
{ 974, 1095020203u, 558292492u, 1051772749u, 4267873474u, 1076731940u, 3159412483u, 0, LOG_TOLERANCE, 0},
{ 975, 1077289061u, 509637100u, 3212030069u, 215050379u, 1074316851u, 2170640386u, 0, LOG_TOLERANCE, 0},
{ 976, 1092057101u, 3571665665u, 3188628584u, 757824767u, 1076475951u, 3202156800u, 0, LOG_TOLERANCE, 0},
{ 977, 1067315689u, 998858159u, 1063077962u, 436029885u, 3222028739u, 880987246u, 0, LOG_TOLERANCE, 0},
{ 978, 1058463317u, 996300405u, 3193842624u, 80548098u, 3223499163u, 2068439612u, 0, LOG_TOLERANCE, 0},
{ 979, 1081365192u, 3876129407u, 3215332180u, 2226970413u, 1075258159u, 1795164616u, 0, LOG_TOLERANCE, 0},
{ 980, 1090125305u, 200013509u, 3224552716u, 414878724u, 1076307631u, 2365929600u, 0, LOG_TOLERANCE, 0},
{ 981, 1083133445u, 309319541u, 1048979765u, 1261662434u, 1075553109u, 2572671155u, 0, LOG_TOLERANCE, 0},
{ 982, 1089252639u, 4062255924u, 3224274128u, 4289485681u, 1076229660u, 3670107739u, 0, LOG_TOLERANCE, 0},
{ 983, 1088652436u, 1611969213u, 1053890378u, 3774617276u, 1076179232u, 1774190741u, 0, LOG_TOLERANCE, 0},
{ 984, 1080412763u, 1752164782u, 3239587974u, 612223386u, 1075094726u, 2382279992u, 0, LOG_TOLERANCE, 0},
{ 985, 1041545782u, 2024044989u, 1074932678u, 3259111307u, 3224668441u, 2879048600u, 0, LOG_TOLERANCE, 0},
{ 986, 1053207518u, 2564965629u, 1093571065u, 169360454u, 3223954559u, 580679173u, 0, LOG_TOLERANCE, 0},
{ 987, 1089599090u, 1860101737u, 3191222372u, 1676437468u, 1076259201u, 181860389u, 0, LOG_TOLERANCE, 0},
{ 988, 1059802968u, 588387057u, 3192103292u, 2495288012u, 3223385047u, 949677917u, 0, LOG_TOLERANCE, 0},
{ 989, 1045672057u, 659070058u, 1073095700u, 1393632068u, 3224490104u, 1843660721u, 0, LOG_TOLERANCE, 0},
{ 990, 1070199615u, 4276187829u, 3217553330u, 1868253275u, 3220801691u, 837195521u, 0, LOG_TOLERANCE, 0},
{ 991, 1075736624u, 2085481575u, 3215994784u, 800910002u, 1073757240u, 3736786376u, 0, LOG_TOLERANCE, 0},
{ 992, 1056934836u, 1950570756u, 3200582211u, 941022151u, 3223638704u, 3712070612u, 0, LOG_TOLERANCE, 0},
{ 993, 1057530368u, 2075610870u, 3250142022u, 3605152103u, 3223580274u, 1820961897u, 0, LOG_TOLERANCE, 0},
{ 994, 1053355602u, 3792931748u, 3204857863u, 804393211u, 3223942106u, 1395149486u, 0, LOG_TOLERANCE, 0},
{ 995, 1106162722u, 3430071177u, 3226288311u, 3652522729u, 1077289900u, 3475753848u, 0, LOG_TOLERANCE, 0},
{ 996, 1053831054u, 236884699u, 3227874605u, 2193269825u, 3223907874u, 1630755670u, 0, LOG_TOLERANCE, 0},
{ 997, 1064936593u, 2744231849u, 1046186036u, 771053722u, 3222555459u, 4188901663u, 0, LOG_TOLERANCE, 0},
{ 998, 1083996036u, 3000189819u, 1096500901u, 2057239777u, 1075709902u, 2502775335u, 0, LOG_TOLERANCE, 0},
{ 999, 1093835581u, 205759408u, 3244643377u, 2702292618u, 1076627224u, 3113340835u, 0, LOG_TOLERANCE, 0},


// AUTOMATICALLY GENERATED VECTORS STOP

};

#endif // CYGONCE_LIBM_LOG_H multiple inclusion protection

// EOF log.h
