#ifndef CYGONCE_LIBM_LDEXPF_H
#define CYGONCE_LIBM_LDEXPF_H
//===========================================================================
//
//      ldexpf.h
//
//      Test vectors for testing of ldexpf() math library function
//
//===========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####
// -------------------------------------------
// This file is part of eCos, the Embedded Configurable Operating System.
// Copyright (C) 2012 Free Software Foundation, Inc.
//
// eCos is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 or (at your option) any later
// version.
//
// eCos is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
// for more details.
//
// You should have received a copy of the GNU General Public License
// along with eCos; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//
// As a special exception, if other files instantiate templates or use
// macros or inline functions from this file, or you compile this file
// and link it with other works to produce a work based on this file,
// this file does not by itself cause the resulting work to be covered by
// the GNU General Public License. However the source code for this file
// must still be made available in accordance with section (3) of the GNU
// General Public License v2.
//
// This exception does not invalidate any other reasons why a work based
// on this file might be covered by the GNU General Public License.
// -------------------------------------------
// ####ECOSGPLCOPYRIGHTEND####
//===========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):
// Contributors:  visar, ilijak
// Date:        1998-02-13
// Purpose:
// Description:
// Usage:       #include "vectors/ldexpf.h"
//
//####DESCRIPTIONEND####
//
//===========================================================================


// CONFIGURATION

#include <pkgconf/libm.h>   // Configuration header


// INCLUDES

#include <cyg/infra/cyg_type.h>    // Common type definitions and support
#include "vectors/vector_support_float.h"// extra support for math tests

#define LDEXPF_TOLERANCE 1.0E-04

static const Cyg_libm_test_float_vec_t ldexpf_vec[] = {

// AUTOMATICALLY GENERATED VECTORS START

{0, 3196650934u, 0u, 3196650934u, 0, LDEXPF_TOLERANCE, 0},
{1, 1224242132u, 0u, 1224242132u, 0, LDEXPF_TOLERANCE, 0},
{2, 1198712763u, 0u, 1198712763u, 0, LDEXPF_TOLERANCE, 0},
{3, 3159309973u, 0u, 3159309973u, 0, LDEXPF_TOLERANCE, 0},
{4, 954173073u, 0u, 954173073u, 0, LDEXPF_TOLERANCE, 0},
{5, 3090780435u, 0u, 3090780435u, 0, LDEXPF_TOLERANCE, 0},
{6, 966554515u, 4294967290u, 916222867u, 0, LDEXPF_TOLERANCE, 0},
{7, 1166191415u, 0u, 1166191415u, 0, LDEXPF_TOLERANCE, 0},
{8, 1234419246u, 0u, 1234419246u, 0, LDEXPF_TOLERANCE, 0},
{9, 1302107128u, 4294492157u, 0u, 0, LDEXPF_TOLERANCE, 0},
{10, 1052801068u, 0u, 1052801068u, 0, LDEXPF_TOLERANCE, 0},
{11, 1060849628u, 0u, 1060849628u, 0, LDEXPF_TOLERANCE, 0},
{12, 3484320003u, 0u, 3484320003u, 0, LDEXPF_TOLERANCE, 0},
{13, 1167223673u, 0u, 1167223673u, 0, LDEXPF_TOLERANCE, 0},
{14, 968192794u, 0u, 968192794u, 0, LDEXPF_TOLERANCE, 0},
{15, 3122346862u, 48u, 3525000046u, 0, LDEXPF_TOLERANCE, 0},
{16, 906701409u, 0u, 906701409u, 0, LDEXPF_TOLERANCE, 0},
{17, 3231467496u, 0u, 3231467496u, 0, LDEXPF_TOLERANCE, 0},
{18, 1341514497u, 3022046753u, 0u, 0, LDEXPF_TOLERANCE, 0},
{19, 1272351391u, 4294363968u, 0u, 0, LDEXPF_TOLERANCE, 0},
{20, 940236348u, 4294965375u, 0u, 0, LDEXPF_TOLERANCE, 0},
{21, 3251541546u, 0u, 3251541546u, 0, LDEXPF_TOLERANCE, 0},
{22, 3110358400u, 0u, 3110358400u, 0, LDEXPF_TOLERANCE, 0},
{23, 3371863479u, 0u, 3371863479u, 0, LDEXPF_TOLERANCE, 0},
{24, 3204069187u, 0u, 3204069187u, 0, LDEXPF_TOLERANCE, 0},
{25, 1306460502u, 0u, 1306460502u, 0, LDEXPF_TOLERANCE, 0},
{26, 1197542187u, 0u, 1197542187u, 0, LDEXPF_TOLERANCE, 0},
{27, 1184239996u, 4294967294u, 1167462780u, 0, LDEXPF_TOLERANCE, 0},
{28, 1001673627u, 3340510812u, 0u, 0, LDEXPF_TOLERANCE, 0},
{29, 941796645u, 0u, 941796645u, 0, LDEXPF_TOLERANCE, 0},
{30, 3287199470u, 0u, 3287199470u, 0, LDEXPF_TOLERANCE, 0},
{31, 1143233714u, 0u, 1143233714u, 0, LDEXPF_TOLERANCE, 0},
{32, 3143717025u, 4294967290u, 3093385377u, 0, LDEXPF_TOLERANCE, 0},
{33, 3240298487u, 0u, 3240298487u, 0, LDEXPF_TOLERANCE, 0},
{34, 1288902137u, 0u, 1288902137u, 0, LDEXPF_TOLERANCE, 0},
{35, 1333134799u, 2211432996u, 0u, 0, LDEXPF_TOLERANCE, 0},
{36, 1038851706u, 2696359348u, 0u, 0, LDEXPF_TOLERANCE, 0},
{37, 3329354473u, 0u, 3329354473u, 0, LDEXPF_TOLERANCE, 0},
{38, 1309289088u, 0u, 1309289088u, 0, LDEXPF_TOLERANCE, 0},
{39, 3405585402u, 0u, 3405585402u, 0, LDEXPF_TOLERANCE, 0},
{40, 3106647724u, 0u, 3106647724u, 0, LDEXPF_TOLERANCE, 0},
{41, 1106778573u, 4294965325u, 0u, 0, LDEXPF_TOLERANCE, 0},
{42, 1140567947u, 0u, 1140567947u, 0, LDEXPF_TOLERANCE, 0},
{43, 1238569473u, 0u, 1238569473u, 0, LDEXPF_TOLERANCE, 0},
{44, 1175011025u, 0u, 1175011025u, 0, LDEXPF_TOLERANCE, 0},
{45, 3058097085u, 0u, 3058097085u, 0, LDEXPF_TOLERANCE, 0},
{46, 3107252546u, 1u, 3115641154u, 0, LDEXPF_TOLERANCE, 0},
{47, 3096032662u, 0u, 3096032662u, 0, LDEXPF_TOLERANCE, 0},
{48, 3197942144u, 0u, 3197942144u, 0, LDEXPF_TOLERANCE, 0},
{49, 3403348556u, 0u, 3403348556u, 0, LDEXPF_TOLERANCE, 0},
{50, 1136411063u, 82u, 1824276919u, 0, LDEXPF_TOLERANCE, 0},
{51, 3340615780u, 0u, 3340615780u, 0, LDEXPF_TOLERANCE, 0},
{52, 998567360u, 0u, 998567360u, 0, LDEXPF_TOLERANCE, 0},
{53, 989687421u, 4294414202u, 0u, 0, LDEXPF_TOLERANCE, 0},
{54, 1152956913u, 0u, 1152956913u, 0, LDEXPF_TOLERANCE, 0},
{55, 892922651u, 4294392467u, 0u, 0, LDEXPF_TOLERANCE, 0},
{56, 1307091856u, 24u, 1508418448u, 0, LDEXPF_TOLERANCE, 0},
{57, 1142167709u, 13u, 1251219613u, 0, LDEXPF_TOLERANCE, 0},
{58, 3426232834u, 0u, 3426232834u, 0, LDEXPF_TOLERANCE, 0},
{59, 3368566779u, 0u, 3368566779u, 0, LDEXPF_TOLERANCE, 0},
{60, 1138741813u, 0u, 1138741813u, 0, LDEXPF_TOLERANCE, 0},
{61, 982950501u, 0u, 982950501u, 0, LDEXPF_TOLERANCE, 0},
{62, 1142981585u, 0u, 1142981585u, 0, LDEXPF_TOLERANCE, 0},
{63, 3347165962u, 0u, 3347165962u, 0, LDEXPF_TOLERANCE, 0},
{64, 1009535440u, 4293825695u, 0u, 0, LDEXPF_TOLERANCE, 0},
{65, 3126820946u, 2u, 3143598162u, 0, LDEXPF_TOLERANCE, 0},
{66, 3473956030u, 0u, 3473956030u, 0, LDEXPF_TOLERANCE, 0},
{67, 3349098349u, 0u, 3349098349u, 0, LDEXPF_TOLERANCE, 0},
{68, 3152729489u, 0u, 3152729489u, 0, LDEXPF_TOLERANCE, 0},
{69, 945568720u, 4294963204u, 0u, 0, LDEXPF_TOLERANCE, 0},
{70, 3345489836u, 36u, 3647479724u, 0, LDEXPF_TOLERANCE, 0},
{71, 976791751u, 4294967292u, 943237319u, 0, LDEXPF_TOLERANCE, 0},
{72, 1004442355u, 0u, 1004442355u, 0, LDEXPF_TOLERANCE, 0},
{73, 1108485380u, 0u, 1108485380u, 0, LDEXPF_TOLERANCE, 0},
{74, 1061834641u, 0u, 1061834641u, 0, LDEXPF_TOLERANCE, 0},
{75, 1087189715u, 0u, 1087189715u, 0, LDEXPF_TOLERANCE, 0},
{76, 1000611335u, 0u, 1000611335u, 0, LDEXPF_TOLERANCE, 0},
{77, 3466188568u, 0u, 3466188568u, 0, LDEXPF_TOLERANCE, 0},
{78, 3072456205u, 0u, 3072456205u, 0, LDEXPF_TOLERANCE, 0},
{79, 1315030230u, 4294939294u, 0u, 0, LDEXPF_TOLERANCE, 0},
{80, 1134593658u, 3712906973u, 0u, 0, LDEXPF_TOLERANCE, 0},
{81, 977281449u, 0u, 977281449u, 0, LDEXPF_TOLERANCE, 0},
{82, 1086198791u, 0u, 1086198791u, 0, LDEXPF_TOLERANCE, 0},
{83, 1255152035u, 0u, 1255152035u, 0, LDEXPF_TOLERANCE, 0},
{84, 1135271264u, 4294966890u, 0u, 0, LDEXPF_TOLERANCE, 0},
{85, 1094190727u, 0u, 1094190727u, 0, LDEXPF_TOLERANCE, 0},
{86, 1294665325u, 0u, 1294665325u, 0, LDEXPF_TOLERANCE, 0},
{87, 1036608591u, 0u, 1036608591u, 0, LDEXPF_TOLERANCE, 0},
{88, 3229998064u, 0u, 3229998064u, 0, LDEXPF_TOLERANCE, 0},
{89, 3439134022u, 0u, 3439134022u, 0, LDEXPF_TOLERANCE, 0},
{90, 1325668223u, 0u, 1325668223u, 0, LDEXPF_TOLERANCE, 0},
{91, 1092037607u, 0u, 1092037607u, 0, LDEXPF_TOLERANCE, 0},
{92, 3295436768u, 0u, 3295436768u, 0, LDEXPF_TOLERANCE, 0},
{93, 1151984049u, 0u, 1151984049u, 0, LDEXPF_TOLERANCE, 0},
{94, 1129287043u, 0u, 1129287043u, 0, LDEXPF_TOLERANCE, 0},
{95, 1243664530u, 0u, 1243664530u, 0, LDEXPF_TOLERANCE, 0},
{96, 950829092u, 0u, 950829092u, 0, LDEXPF_TOLERANCE, 0},
{97, 1115471979u, 0u, 1115471979u, 0, LDEXPF_TOLERANCE, 0},
{98, 3351092088u, 0u, 3351092088u, 0, LDEXPF_TOLERANCE, 0},
{99, 3241193975u, 0u, 3241193975u, 0, LDEXPF_TOLERANCE, 0},
{100, 1030934236u, 0u, 1030934236u, 0, LDEXPF_TOLERANCE, 0},
{101, 1025254314u, 0u, 1025254314u, 0, LDEXPF_TOLERANCE, 0},
{102, 1110545760u, 4294967286u, 1026659680u, 0, LDEXPF_TOLERANCE, 0},
{103, 3180213739u, 37u, 3490592235u, 0, LDEXPF_TOLERANCE, 0},
{104, 3361976590u, 0u, 3361976590u, 0, LDEXPF_TOLERANCE, 0},
{105, 881280146u, 4262747521u, 0u, 0, LDEXPF_TOLERANCE, 0},
{106, 1304154705u, 0u, 1304154705u, 0, LDEXPF_TOLERANCE, 0},
{107, 3264443610u, 4294967294u, 3247666394u, 0, LDEXPF_TOLERANCE, 0},
{108, 3374550627u, 0u, 3374550627u, 0, LDEXPF_TOLERANCE, 0},
{109, 1268194719u, 3962356276u, 0u, 0, LDEXPF_TOLERANCE, 0},
{110, 1161858787u, 0u, 1161858787u, 0, LDEXPF_TOLERANCE, 0},
{111, 3325193181u, 0u, 3325193181u, 0, LDEXPF_TOLERANCE, 0},
{112, 3115275450u, 0u, 3115275450u, 0, LDEXPF_TOLERANCE, 0},
{113, 3116607482u, 4294967294u, 3099830266u, 0, LDEXPF_TOLERANCE, 0},
{114, 3187892415u, 0u, 3187892415u, 0, LDEXPF_TOLERANCE, 0},
{115, 1189120494u, 0u, 1189120494u, 0, LDEXPF_TOLERANCE, 0},
{116, 889030794u, 0u, 889030794u, 0, LDEXPF_TOLERANCE, 0},
{117, 1323529208u, 0u, 1323529208u, 0, LDEXPF_TOLERANCE, 0},
{118, 3465768388u, 0u, 3465768388u, 0, LDEXPF_TOLERANCE, 0},
{119, 3426099899u, 87u, 4155908795u, 0, LDEXPF_TOLERANCE, 0},
{120, 1065798296u, 0u, 1065798296u, 0, LDEXPF_TOLERANCE, 0},
{121, 3328989444u, 0u, 3328989444u, 0, LDEXPF_TOLERANCE, 0},
{122, 3357819026u, 0u, 3357819026u, 0, LDEXPF_TOLERANCE, 0},
{123, 1273397670u, 0u, 1273397670u, 0, LDEXPF_TOLERANCE, 0},
{124, 1257596246u, 4264851904u, 0u, 0, LDEXPF_TOLERANCE, 0},
{125, 1051773536u, 0u, 1051773536u, 0, LDEXPF_TOLERANCE, 0},
{126, 3294752507u, 0u, 3294752507u, 0, LDEXPF_TOLERANCE, 0},
{127, 3424848725u, 0u, 3424848725u, 0, LDEXPF_TOLERANCE, 0},
{128, 1090870906u, 4294966393u, 0u, 0, LDEXPF_TOLERANCE, 0},
{129, 1272325814u, 0u, 1272325814u, 0, LDEXPF_TOLERANCE, 0},
{130, 3359508271u, 0u, 3359508271u, 0, LDEXPF_TOLERANCE, 0},
{131, 1137854355u, 4294941607u, 0u, 0, LDEXPF_TOLERANCE, 0},
{132, 3440773058u, 0u, 3440773058u, 0, LDEXPF_TOLERANCE, 0},
{133, 3101598400u, 0u, 3101598400u, 0, LDEXPF_TOLERANCE, 0},
{134, 3437062994u, 0u, 3437062994u, 0, LDEXPF_TOLERANCE, 0},
{135, 3303035472u, 0u, 3303035472u, 0, LDEXPF_TOLERANCE, 0},
{136, 1053698677u, 4294966907u, 0u, 0, LDEXPF_TOLERANCE, 0},
{137, 3037541131u, 5u, 3079484171u, 0, LDEXPF_TOLERANCE, 0},
{138, 3458934263u, 0u, 3458934263u, 0, LDEXPF_TOLERANCE, 0},
{139, 1065761827u, 4294943781u, 0u, 0, LDEXPF_TOLERANCE, 0},
{140, 3025843188u, 0u, 3025843188u, 0, LDEXPF_TOLERANCE, 0},
{141, 926665223u, 0u, 926665223u, 0, LDEXPF_TOLERANCE, 0},
{142, 1199816046u, 0u, 1199816046u, 0, LDEXPF_TOLERANCE, 0},
{143, 3333779015u, 0u, 3333779015u, 0, LDEXPF_TOLERANCE, 0},
{144, 948398145u, 4294967288u, 881289281u, 0, LDEXPF_TOLERANCE, 0},
{145, 3164749613u, 0u, 3164749613u, 0, LDEXPF_TOLERANCE, 0},
{146, 3118883815u, 0u, 3118883815u, 0, LDEXPF_TOLERANCE, 0},
{147, 3226990408u, 45u, 3604477768u, 0, LDEXPF_TOLERANCE, 0},
{148, 3117098218u, 115u, 4081788138u, 0, LDEXPF_TOLERANCE, 0},
{149, 1283624229u, 0u, 1283624229u, 0, LDEXPF_TOLERANCE, 0},
{150, 970649315u, 3u, 995815139u, 0, LDEXPF_TOLERANCE, 0},
{151, 959776291u, 4294967028u, 0u, 0, LDEXPF_TOLERANCE, 0},
{152, 1270734970u, 4294829480u, 0u, 0, LDEXPF_TOLERANCE, 0},
{153, 3454816067u, 0u, 3454816067u, 0, LDEXPF_TOLERANCE, 0},
{154, 1157598381u, 4294964293u, 0u, 0, LDEXPF_TOLERANCE, 0},
{155, 3335234513u, 0u, 3335234513u, 0, LDEXPF_TOLERANCE, 0},
{156, 1279489061u, 0u, 1279489061u, 0, LDEXPF_TOLERANCE, 0},
{157, 3143920719u, 0u, 3143920719u, 0, LDEXPF_TOLERANCE, 0},
{158, 1233171235u, 0u, 1233171235u, 0, LDEXPF_TOLERANCE, 0},
{159, 1148920078u, 0u, 1148920078u, 0, LDEXPF_TOLERANCE, 0},
{160, 3064988156u, 4294967292u, 3031433724u, 0, LDEXPF_TOLERANCE, 0},
{161, 3219949483u, 0u, 3219949483u, 0, LDEXPF_TOLERANCE, 0},
{162, 1207502108u, 4292985650u, 0u, 0, LDEXPF_TOLERANCE, 0},
{163, 1000014431u, 0u, 1000014431u, 0, LDEXPF_TOLERANCE, 0},
{164, 3161756316u, 0u, 3161756316u, 0, LDEXPF_TOLERANCE, 0},
{165, 1234530539u, 3u, 1259696363u, 0, LDEXPF_TOLERANCE, 0},
{166, 3306328852u, 87u, 4036137748u, 0, LDEXPF_TOLERANCE, 0},
{167, 1131927531u, 0u, 1131927531u, 0, LDEXPF_TOLERANCE, 0},
{168, 3449879391u, 0u, 3449879391u, 0, LDEXPF_TOLERANCE, 0},
{169, 970094304u, 4294911386u, 0u, 0, LDEXPF_TOLERANCE, 0},
{170, 1125551064u, 4294949017u, 0u, 0, LDEXPF_TOLERANCE, 0},
{171, 1198917460u, 2607028085u, 0u, 0, LDEXPF_TOLERANCE, 0},
{172, 3201603336u, 0u, 3201603336u, 0, LDEXPF_TOLERANCE, 0},
{173, 921940707u, 0u, 921940707u, 0, LDEXPF_TOLERANCE, 0},
{174, 1091906532u, 0u, 1091906532u, 0, LDEXPF_TOLERANCE, 0},
{175, 1276853215u, 0u, 1276853215u, 0, LDEXPF_TOLERANCE, 0},
{176, 3360170117u, 0u, 3360170117u, 0, LDEXPF_TOLERANCE, 0},
{177, 1064364381u, 0u, 1064364381u, 0, LDEXPF_TOLERANCE, 0},
{178, 1268744779u, 4294952694u, 0u, 0, LDEXPF_TOLERANCE, 0},
{179, 1165195428u, 4292538760u, 0u, 0, LDEXPF_TOLERANCE, 0},
{180, 3044092739u, 30u, 3295750979u, 0, LDEXPF_TOLERANCE, 0},
{181, 3247790039u, 0u, 3247790039u, 0, LDEXPF_TOLERANCE, 0},
{182, 3215244648u, 4u, 3248799080u, 0, LDEXPF_TOLERANCE, 0},
{183, 3095275931u, 0u, 3095275931u, 0, LDEXPF_TOLERANCE, 0},
{184, 3059688264u, 77u, 3705611080u, 0, LDEXPF_TOLERANCE, 0},
{185, 1212717473u, 0u, 1212717473u, 0, LDEXPF_TOLERANCE, 0},
{186, 3028857014u, 0u, 3028857014u, 0, LDEXPF_TOLERANCE, 0},
{187, 1044867873u, 4294528232u, 0u, 0, LDEXPF_TOLERANCE, 0},
{188, 1089986803u, 3370664605u, 0u, 0, LDEXPF_TOLERANCE, 0},
{189, 1296314700u, 0u, 1296314700u, 0, LDEXPF_TOLERANCE, 0},
{190, 1251462432u, 0u, 1251462432u, 0, LDEXPF_TOLERANCE, 0},
{191, 3485236902u, 0u, 3485236902u, 0, LDEXPF_TOLERANCE, 0},
{192, 3080852256u, 0u, 3080852256u, 0, LDEXPF_TOLERANCE, 0},
{193, 1022211242u, 0u, 1022211242u, 0, LDEXPF_TOLERANCE, 0},
{194, 884661176u, 0u, 884661176u, 0, LDEXPF_TOLERANCE, 0},
{195, 989762529u, 4294733601u, 0u, 0, LDEXPF_TOLERANCE, 0},
{196, 1295475718u, 0u, 1295475718u, 0, LDEXPF_TOLERANCE, 0},
{197, 1002632518u, 4294950696u, 0u, 0, LDEXPF_TOLERANCE, 0},
{198, 3158912530u, 0u, 3158912530u, 0, LDEXPF_TOLERANCE, 0},
{199, 3138037576u, 0u, 3138037576u, 0, LDEXPF_TOLERANCE, 0},
{200, 999985470u, 4282999218u, 0u, 0, LDEXPF_TOLERANCE, 0},
{201, 1189421739u, 0u, 1189421739u, 0, LDEXPF_TOLERANCE, 0},
{202, 3075182644u, 0u, 3075182644u, 0, LDEXPF_TOLERANCE, 0},
{203, 1164046161u, 4139845439u, 0u, 0, LDEXPF_TOLERANCE, 0},
{204, 1292596266u, 0u, 1292596266u, 0, LDEXPF_TOLERANCE, 0},
{205, 1314644642u, 0u, 1314644642u, 0, LDEXPF_TOLERANCE, 0},
{206, 3399813173u, 0u, 3399813173u, 0, LDEXPF_TOLERANCE, 0},
{207, 948775569u, 2159002590u, 0u, 0, LDEXPF_TOLERANCE, 0},
{208, 1034611395u, 0u, 1034611395u, 0, LDEXPF_TOLERANCE, 0},
{209, 1181604787u, 4294717096u, 0u, 0, LDEXPF_TOLERANCE, 0},
{210, 3059042077u, 0u, 3059042077u, 0, LDEXPF_TOLERANCE, 0},
{211, 1043691622u, 4288164501u, 0u, 0, LDEXPF_TOLERANCE, 0},
{212, 1314588083u, 0u, 1314588083u, 0, LDEXPF_TOLERANCE, 0},
{213, 3141533334u, 0u, 3141533334u, 0, LDEXPF_TOLERANCE, 0},
{214, 3400949680u, 0u, 3400949680u, 0, LDEXPF_TOLERANCE, 0},
{215, 1110424755u, 0u, 1110424755u, 0, LDEXPF_TOLERANCE, 0},
{216, 3189917167u, 0u, 3189917167u, 0, LDEXPF_TOLERANCE, 0},
{217, 969804941u, 4294836255u, 0u, 0, LDEXPF_TOLERANCE, 0},
{218, 934308144u, 0u, 934308144u, 0, LDEXPF_TOLERANCE, 0},
{219, 1156767533u, 7u, 1215487789u, 0, LDEXPF_TOLERANCE, 0},
{220, 994934087u, 0u, 994934087u, 0, LDEXPF_TOLERANCE, 0},
{221, 3185240099u, 122u, 4208650275u, 0, LDEXPF_TOLERANCE, 0},
{222, 1212129651u, 0u, 1212129651u, 0, LDEXPF_TOLERANCE, 0},
{223, 3125775254u, 0u, 3125775254u, 0, LDEXPF_TOLERANCE, 0},
{224, 1037464105u, 0u, 1037464105u, 0, LDEXPF_TOLERANCE, 0},
{225, 918212457u, 0u, 918212457u, 0, LDEXPF_TOLERANCE, 0},
{226, 1337315179u, 3421796258u, 0u, 0, LDEXPF_TOLERANCE, 0},
{227, 1131358407u, 4294955130u, 0u, 0, LDEXPF_TOLERANCE, 0},
{228, 1156517523u, 4294914801u, 0u, 0, LDEXPF_TOLERANCE, 0},
{229, 3210802820u, 0u, 3210802820u, 0, LDEXPF_TOLERANCE, 0},
{230, 3468429030u, 4294967266u, 3216770790u, 0, LDEXPF_TOLERANCE, 0},
{231, 3055299953u, 0u, 3055299953u, 0, LDEXPF_TOLERANCE, 0},
{232, 959956547u, 0u, 959956547u, 0, LDEXPF_TOLERANCE, 0},
{233, 1039917375u, 117u, 2021384511u, 0, LDEXPF_TOLERANCE, 0},
{234, 1311016004u, 4294941884u, 0u, 0, LDEXPF_TOLERANCE, 0},
{235, 1128016396u, 27u, 1354508812u, 0, LDEXPF_TOLERANCE, 0},
{236, 3210335769u, 0u, 3210335769u, 0, LDEXPF_TOLERANCE, 0},
{237, 1206054701u, 0u, 1206054701u, 0, LDEXPF_TOLERANCE, 0},
{238, 1213609983u, 0u, 1213609983u, 0, LDEXPF_TOLERANCE, 0},
{239, 1246902946u, 0u, 1246902946u, 0, LDEXPF_TOLERANCE, 0},
{240, 995850843u, 3845036501u, 0u, 0, LDEXPF_TOLERANCE, 0},
{241, 1029480631u, 0u, 1029480631u, 0, LDEXPF_TOLERANCE, 0},
{242, 3153568584u, 0u, 3153568584u, 0, LDEXPF_TOLERANCE, 0},
{243, 3384988527u, 0u, 3384988527u, 0, LDEXPF_TOLERANCE, 0},
{244, 1317696241u, 0u, 1317696241u, 0, LDEXPF_TOLERANCE, 0},
{245, 3341877624u, 0u, 3341877624u, 0, LDEXPF_TOLERANCE, 0},
{246, 1228636133u, 0u, 1228636133u, 0, LDEXPF_TOLERANCE, 0},
{247, 1207246237u, 0u, 1207246237u, 0, LDEXPF_TOLERANCE, 0},
{248, 1165476654u, 4294877038u, 0u, 0, LDEXPF_TOLERANCE, 0},
{249, 1215278023u, 0u, 1215278023u, 0, LDEXPF_TOLERANCE, 0},
{250, 1017239798u, 4167373558u, 0u, 0, LDEXPF_TOLERANCE, 0},
{251, 1149651309u, 0u, 1149651309u, 0, LDEXPF_TOLERANCE, 0},
{252, 1111943722u, 0u, 1111943722u, 0, LDEXPF_TOLERANCE, 0},
{253, 1189849849u, 4293652457u, 0u, 0, LDEXPF_TOLERANCE, 0},
{254, 3204848496u, 0u, 3204848496u, 0, LDEXPF_TOLERANCE, 0},
{255, 1249758327u, 0u, 1249758327u, 0, LDEXPF_TOLERANCE, 0},
{256, 3215981890u, 4294967286u, 3132095810u, 0, LDEXPF_TOLERANCE, 0},
{257, 1266687209u, 0u, 1266687209u, 0, LDEXPF_TOLERANCE, 0},
{258, 943645710u, 0u, 943645710u, 0, LDEXPF_TOLERANCE, 0},
{259, 935847271u, 1u, 944235879u, 0, LDEXPF_TOLERANCE, 0},
{260, 3410336089u, 47u, 3804600665u, 0, LDEXPF_TOLERANCE, 0},
{261, 3059263153u, 0u, 3059263153u, 0, LDEXPF_TOLERANCE, 0},
{262, 3353679791u, 0u, 3353679791u, 0, LDEXPF_TOLERANCE, 0},
{263, 1001823878u, 0u, 1001823878u, 0, LDEXPF_TOLERANCE, 0},
{264, 1009130212u, 0u, 1009130212u, 0, LDEXPF_TOLERANCE, 0},
{265, 3367127535u, 0u, 3367127535u, 0, LDEXPF_TOLERANCE, 0},
{266, 1032920919u, 3981458897u, 0u, 0, LDEXPF_TOLERANCE, 0},
{267, 3281952870u, 0u, 3281952870u, 0, LDEXPF_TOLERANCE, 0},
{268, 1237868497u, 0u, 1237868497u, 0, LDEXPF_TOLERANCE, 0},
{269, 1153753924u, 4294958733u, 0u, 0, LDEXPF_TOLERANCE, 0},
{270, 1120261759u, 0u, 1120261759u, 0, LDEXPF_TOLERANCE, 0},
{271, 3349595986u, 4294967271u, 3139880786u, 0, LDEXPF_TOLERANCE, 0},
{272, 1087750238u, 16u, 1221967966u, 0, LDEXPF_TOLERANCE, 0},
{273, 1066116543u, 0u, 1066116543u, 0, LDEXPF_TOLERANCE, 0},
{274, 3210898034u, 0u, 3210898034u, 0, LDEXPF_TOLERANCE, 0},
{275, 1030612298u, 4294908239u, 0u, 0, LDEXPF_TOLERANCE, 0},
{276, 1186234578u, 0u, 1186234578u, 0, LDEXPF_TOLERANCE, 0},
{277, 1331680743u, 0u, 1331680743u, 0, LDEXPF_TOLERANCE, 0},
{278, 1045232522u, 4294967290u, 994900874u, 0, LDEXPF_TOLERANCE, 0},
{279, 3119858470u, 0u, 3119858470u, 0, LDEXPF_TOLERANCE, 0},
{280, 3349432725u, 0u, 3349432725u, 0, LDEXPF_TOLERANCE, 0},
{281, 912423027u, 0u, 912423027u, 0, LDEXPF_TOLERANCE, 0},
{282, 3194674746u, 0u, 3194674746u, 0, LDEXPF_TOLERANCE, 0},
{283, 965402291u, 0u, 965402291u, 0, LDEXPF_TOLERANCE, 0},
{284, 1133410485u, 4294951516u, 0u, 0, LDEXPF_TOLERANCE, 0},
{285, 3136790322u, 7u, 3195510578u, 0, LDEXPF_TOLERANCE, 0},
{286, 3369970587u, 0u, 3369970587u, 0, LDEXPF_TOLERANCE, 0},
{287, 1270451568u, 0u, 1270451568u, 0, LDEXPF_TOLERANCE, 0},
{288, 989498922u, 0u, 989498922u, 0, LDEXPF_TOLERANCE, 0},
{289, 1280215674u, 0u, 1280215674u, 0, LDEXPF_TOLERANCE, 0},
{290, 1171873518u, 0u, 1171873518u, 0, LDEXPF_TOLERANCE, 0},
{291, 3298258100u, 0u, 3298258100u, 0, LDEXPF_TOLERANCE, 0},
{292, 3415208824u, 0u, 3415208824u, 0, LDEXPF_TOLERANCE, 0},
{293, 1001897182u, 0u, 1001897182u, 0, LDEXPF_TOLERANCE, 0},
{294, 3152777939u, 4294967281u, 3026948819u, 0, LDEXPF_TOLERANCE, 0},
{295, 985903305u, 4294945424u, 0u, 0, LDEXPF_TOLERANCE, 0},
{296, 3357328848u, 0u, 3357328848u, 0, LDEXPF_TOLERANCE, 0},
{297, 982612185u, 0u, 982612185u, 0, LDEXPF_TOLERANCE, 0},
{298, 1144755661u, 0u, 1144755661u, 0, LDEXPF_TOLERANCE, 0},
{299, 898467286u, 0u, 898467286u, 0, LDEXPF_TOLERANCE, 0},
{300, 3364525678u, 0u, 3364525678u, 0, LDEXPF_TOLERANCE, 0},
{301, 3146660041u, 0u, 3146660041u, 0, LDEXPF_TOLERANCE, 0},
{302, 3467121799u, 0u, 3467121799u, 0, LDEXPF_TOLERANCE, 0},
{303, 1151257041u, 0u, 1151257041u, 0, LDEXPF_TOLERANCE, 0},
{304, 3097873255u, 4294967295u, 3089484647u, 0, LDEXPF_TOLERANCE, 0},
{305, 3130670309u, 0u, 3130670309u, 0, LDEXPF_TOLERANCE, 0},
{306, 1017573824u, 0u, 1017573824u, 0, LDEXPF_TOLERANCE, 0},
{307, 1258369714u, 3364363284u, 0u, 0, LDEXPF_TOLERANCE, 0},
{308, 1216602683u, 4294468761u, 0u, 0, LDEXPF_TOLERANCE, 0},
{309, 1071940738u, 4294963632u, 0u, 0, LDEXPF_TOLERANCE, 0},
{310, 922601356u, 4294937447u, 0u, 0, LDEXPF_TOLERANCE, 0},
{311, 3357177805u, 5u, 3399120845u, 0, LDEXPF_TOLERANCE, 0},
{312, 3049120080u, 0u, 3049120080u, 0, LDEXPF_TOLERANCE, 0},
{313, 1153863660u, 0u, 1153863660u, 0, LDEXPF_TOLERANCE, 0},
{314, 3034243695u, 0u, 3034243695u, 0, LDEXPF_TOLERANCE, 0},
{315, 1249365132u, 4294967060u, 0u, 0, LDEXPF_TOLERANCE, 0},
{316, 3046215730u, 0u, 3046215730u, 0, LDEXPF_TOLERANCE, 0},
{317, 3047251716u, 8u, 3114360580u, 0, LDEXPF_TOLERANCE, 0},
{318, 1297708818u, 0u, 1297708818u, 0, LDEXPF_TOLERANCE, 0},
{319, 3161606610u, 0u, 3161606610u, 0, LDEXPF_TOLERANCE, 0},
{320, 888030585u, 0u, 888030585u, 0, LDEXPF_TOLERANCE, 0},
{321, 1043442869u, 4294963715u, 0u, 0, LDEXPF_TOLERANCE, 0},
{322, 3400348640u, 0u, 3400348640u, 0, LDEXPF_TOLERANCE, 0},
{323, 1250249095u, 1u, 1258637703u, 0, LDEXPF_TOLERANCE, 0},
{324, 3020883322u, 0u, 3020883322u, 0, LDEXPF_TOLERANCE, 0},
{325, 1215968622u, 2531374040u, 0u, 0, LDEXPF_TOLERANCE, 0},
{326, 3202319550u, 0u, 3202319550u, 0, LDEXPF_TOLERANCE, 0},
{327, 3061638260u, 0u, 3061638260u, 0, LDEXPF_TOLERANCE, 0},
{328, 1025404104u, 1u, 1033792712u, 0, LDEXPF_TOLERANCE, 0},
{329, 3138086437u, 0u, 3138086437u, 0, LDEXPF_TOLERANCE, 0},
{330, 3099671635u, 4294967295u, 3091283027u, 0, LDEXPF_TOLERANCE, 0},
{331, 3068014841u, 0u, 3068014841u, 0, LDEXPF_TOLERANCE, 0},
{332, 1252237719u, 105u, 2133041559u, 0, LDEXPF_TOLERANCE, 0},
{333, 3082454432u, 0u, 3082454432u, 0, LDEXPF_TOLERANCE, 0},
{334, 1099710167u, 0u, 1099710167u, 0, LDEXPF_TOLERANCE, 0},
{335, 1282110851u, 0u, 1282110851u, 0, LDEXPF_TOLERANCE, 0},
{336, 1123357102u, 4294966999u, 0u, 0, LDEXPF_TOLERANCE, 0},
{337, 1106837025u, 0u, 1106837025u, 0, LDEXPF_TOLERANCE, 0},
{338, 1253017688u, 0u, 1253017688u, 0, LDEXPF_TOLERANCE, 0},
{339, 1108543194u, 4294966999u, 0u, 0, LDEXPF_TOLERANCE, 0},
{340, 3305715025u, 0u, 3305715025u, 0, LDEXPF_TOLERANCE, 0},
{341, 1266928623u, 0u, 1266928623u, 0, LDEXPF_TOLERANCE, 0},
{342, 3438080027u, 0u, 3438080027u, 0, LDEXPF_TOLERANCE, 0},
{343, 3344574751u, 0u, 3344574751u, 0, LDEXPF_TOLERANCE, 0},
{344, 1152416724u, 0u, 1152416724u, 0, LDEXPF_TOLERANCE, 0},
{345, 3263310567u, 0u, 3263310567u, 0, LDEXPF_TOLERANCE, 0},
{346, 1000313118u, 0u, 1000313118u, 0, LDEXPF_TOLERANCE, 0},
{347, 972485427u, 131u, 2071393075u, 0, LDEXPF_TOLERANCE, 0},
{348, 1278946388u, 0u, 1278946388u, 0, LDEXPF_TOLERANCE, 0},
{349, 947914771u, 0u, 947914771u, 0, LDEXPF_TOLERANCE, 0},
{350, 3167730654u, 0u, 3167730654u, 0, LDEXPF_TOLERANCE, 0},
{351, 3232726036u, 0u, 3232726036u, 0, LDEXPF_TOLERANCE, 0},
{352, 1297190916u, 0u, 1297190916u, 0, LDEXPF_TOLERANCE, 0},
{353, 1277649137u, 0u, 1277649137u, 0, LDEXPF_TOLERANCE, 0},
{354, 3090306474u, 0u, 3090306474u, 0, LDEXPF_TOLERANCE, 0},
{355, 3244032016u, 0u, 3244032016u, 0, LDEXPF_TOLERANCE, 0},
{356, 3033122376u, 0u, 3033122376u, 0, LDEXPF_TOLERANCE, 0},
{357, 3317196817u, 0u, 3317196817u, 0, LDEXPF_TOLERANCE, 0},
{358, 3374748510u, 0u, 3374748510u, 0, LDEXPF_TOLERANCE, 0},
{359, 3345634950u, 0u, 3345634950u, 0, LDEXPF_TOLERANCE, 0},
{360, 3189860276u, 0u, 3189860276u, 0, LDEXPF_TOLERANCE, 0},
{361, 3396917283u, 0u, 3396917283u, 0, LDEXPF_TOLERANCE, 0},
{362, 3317032737u, 0u, 3317032737u, 0, LDEXPF_TOLERANCE, 0},
{363, 1306520561u, 0u, 1306520561u, 0, LDEXPF_TOLERANCE, 0},
{364, 1314936356u, 0u, 1314936356u, 0, LDEXPF_TOLERANCE, 0},
{365, 3085636260u, 33u, 3362460324u, 0, LDEXPF_TOLERANCE, 0},
{366, 3182540197u, 0u, 3182540197u, 0, LDEXPF_TOLERANCE, 0},
{367, 3349005404u, 0u, 3349005404u, 0, LDEXPF_TOLERANCE, 0},
{368, 1053387478u, 0u, 1053387478u, 0, LDEXPF_TOLERANCE, 0},
{369, 3136364836u, 0u, 3136364836u, 0, LDEXPF_TOLERANCE, 0},
{370, 1112891928u, 0u, 1112891928u, 0, LDEXPF_TOLERANCE, 0},
{371, 893449284u, 0u, 893449284u, 0, LDEXPF_TOLERANCE, 0},
{372, 892311459u, 14u, 1009751971u, 0, LDEXPF_TOLERANCE, 0},
{373, 1190105283u, 0u, 1190105283u, 0, LDEXPF_TOLERANCE, 0},
{374, 1043025031u, 0u, 1043025031u, 0, LDEXPF_TOLERANCE, 0},
{375, 3410531037u, 0u, 3410531037u, 0, LDEXPF_TOLERANCE, 0},
{376, 3125834184u, 0u, 3125834184u, 0, LDEXPF_TOLERANCE, 0},
{377, 902318189u, 0u, 902318189u, 0, LDEXPF_TOLERANCE, 0},
{378, 3213624815u, 0u, 3213624815u, 0, LDEXPF_TOLERANCE, 0},
{379, 1120888322u, 5u, 1162831362u, 0, LDEXPF_TOLERANCE, 0},
{380, 1315217243u, 4291026624u, 0u, 0, LDEXPF_TOLERANCE, 0},
{381, 3137758475u, 0u, 3137758475u, 0, LDEXPF_TOLERANCE, 0},
{382, 1040617590u, 0u, 1040617590u, 0, LDEXPF_TOLERANCE, 0},
{383, 955384253u, 4294910624u, 0u, 0, LDEXPF_TOLERANCE, 0},
{384, 904255535u, 0u, 904255535u, 0, LDEXPF_TOLERANCE, 0},
{385, 1022984119u, 0u, 1022984119u, 0, LDEXPF_TOLERANCE, 0},
{386, 997362368u, 0u, 997362368u, 0, LDEXPF_TOLERANCE, 0},
{387, 900933520u, 19u, 1060317072u, 0, LDEXPF_TOLERANCE, 0},
{388, 1039827284u, 1u, 1048215892u, 0, LDEXPF_TOLERANCE, 0},
{389, 1021564080u, 0u, 1021564080u, 0, LDEXPF_TOLERANCE, 0},
{390, 3458669745u, 0u, 3458669745u, 0, LDEXPF_TOLERANCE, 0},
{391, 1040711112u, 4294967293u, 1015545288u, 0, LDEXPF_TOLERANCE, 0},
{392, 1134528351u, 4294638880u, 0u, 0, LDEXPF_TOLERANCE, 0},
{393, 1133689539u, 1u, 1142078147u, 0, LDEXPF_TOLERANCE, 0},
{394, 3415502662u, 0u, 3415502662u, 0, LDEXPF_TOLERANCE, 0},
{395, 954999730u, 0u, 954999730u, 0, LDEXPF_TOLERANCE, 0},
{396, 1066157309u, 4294967285u, 973882621u, 0, LDEXPF_TOLERANCE, 0},
{397, 940437609u, 0u, 940437609u, 0, LDEXPF_TOLERANCE, 0},
{398, 3064200154u, 0u, 3064200154u, 0, LDEXPF_TOLERANCE, 0},
{399, 1023889593u, 0u, 1023889593u, 0, LDEXPF_TOLERANCE, 0},
{400, 1219052056u, 4294526211u, 0u, 0, LDEXPF_TOLERANCE, 0},
{401, 3372118621u, 0u, 3372118621u, 0, LDEXPF_TOLERANCE, 0},
{402, 3146190320u, 0u, 3146190320u, 0, LDEXPF_TOLERANCE, 0},
{403, 1299683827u, 0u, 1299683827u, 0, LDEXPF_TOLERANCE, 0},
{404, 3064155399u, 0u, 3064155399u, 0, LDEXPF_TOLERANCE, 0},
{405, 3040314717u, 1u, 3048703325u, 0, LDEXPF_TOLERANCE, 0},
{406, 1229268598u, 1u, 1237657206u, 0, LDEXPF_TOLERANCE, 0},
{407, 3184078812u, 0u, 3184078812u, 0, LDEXPF_TOLERANCE, 0},
{408, 1086717248u, 4256439624u, 0u, 0, LDEXPF_TOLERANCE, 0},
{409, 3434884607u, 0u, 3434884607u, 0, LDEXPF_TOLERANCE, 0},
{410, 3464955606u, 0u, 3464955606u, 0, LDEXPF_TOLERANCE, 0},
{411, 1025278524u, 0u, 1025278524u, 0, LDEXPF_TOLERANCE, 0},
{412, 1242829722u, 4294967290u, 1192498074u, 0, LDEXPF_TOLERANCE, 0},
{413, 3075149137u, 76u, 3712683345u, 0, LDEXPF_TOLERANCE, 0},
{414, 1246019790u, 0u, 1246019790u, 0, LDEXPF_TOLERANCE, 0},
{415, 1136052740u, 4294967282u, 1018612228u, 0, LDEXPF_TOLERANCE, 0},
{416, 1069009211u, 0u, 1069009211u, 0, LDEXPF_TOLERANCE, 0},
{417, 1015670780u, 20u, 1183442940u, 0, LDEXPF_TOLERANCE, 0},
{418, 1012543234u, 70u, 1599745794u, 0, LDEXPF_TOLERANCE, 0},
{419, 1087942795u, 4294961657u, 0u, 0, LDEXPF_TOLERANCE, 0},
{420, 3426365713u, 0u, 3426365713u, 0, LDEXPF_TOLERANCE, 0},
{421, 3283555717u, 0u, 3283555717u, 0, LDEXPF_TOLERANCE, 0},
{422, 3381255420u, 0u, 3381255420u, 0, LDEXPF_TOLERANCE, 0},
{423, 3388772093u, 0u, 3388772093u, 0, LDEXPF_TOLERANCE, 0},
{424, 1319200415u, 4293050361u, 0u, 0, LDEXPF_TOLERANCE, 0},
{425, 1279324488u, 4294967293u, 1254158664u, 0, LDEXPF_TOLERANCE, 0},
{426, 3217795424u, 0u, 3217795424u, 0, LDEXPF_TOLERANCE, 0},
{427, 1246947517u, 6u, 1297279165u, 0, LDEXPF_TOLERANCE, 0},
{428, 3396723577u, 0u, 3396723577u, 0, LDEXPF_TOLERANCE, 0},
{429, 3433761025u, 0u, 3433761025u, 0, LDEXPF_TOLERANCE, 0},
{430, 3201187455u, 0u, 3201187455u, 0, LDEXPF_TOLERANCE, 0},
{431, 3083019343u, 0u, 3083019343u, 0, LDEXPF_TOLERANCE, 0},
{432, 3042018375u, 0u, 3042018375u, 0, LDEXPF_TOLERANCE, 0},
{433, 1082862511u, 0u, 1082862511u, 0, LDEXPF_TOLERANCE, 0},
{434, 1341821683u, 0u, 1341821683u, 0, LDEXPF_TOLERANCE, 0},
{435, 1079061705u, 0u, 1079061705u, 0, LDEXPF_TOLERANCE, 0},
{436, 1105291533u, 3424974780u, 0u, 0, LDEXPF_TOLERANCE, 0},
{437, 1016023520u, 4294967293u, 990857696u, 0, LDEXPF_TOLERANCE, 0},
{438, 1156767169u, 0u, 1156767169u, 0, LDEXPF_TOLERANCE, 0},
{439, 3077020499u, 0u, 3077020499u, 0, LDEXPF_TOLERANCE, 0},
{440, 1104284039u, 0u, 1104284039u, 0, LDEXPF_TOLERANCE, 0},
{441, 1093697541u, 0u, 1093697541u, 0, LDEXPF_TOLERANCE, 0},
{442, 3179003144u, 37u, 3489381640u, 0, LDEXPF_TOLERANCE, 0},
{443, 1094115255u, 0u, 1094115255u, 0, LDEXPF_TOLERANCE, 0},
{444, 882878091u, 0u, 882878091u, 0, LDEXPF_TOLERANCE, 0},
{445, 1098662266u, 0u, 1098662266u, 0, LDEXPF_TOLERANCE, 0},
{446, 927582555u, 0u, 927582555u, 0, LDEXPF_TOLERANCE, 0},
{447, 3111440310u, 0u, 3111440310u, 0, LDEXPF_TOLERANCE, 0},
{448, 3476083859u, 0u, 3476083859u, 0, LDEXPF_TOLERANCE, 0},
{449, 3038754840u, 0u, 3038754840u, 0, LDEXPF_TOLERANCE, 0},
{450, 3464546616u, 0u, 3464546616u, 0, LDEXPF_TOLERANCE, 0},
{451, 1002542205u, 0u, 1002542205u, 0, LDEXPF_TOLERANCE, 0},
{452, 3443552129u, 0u, 3443552129u, 0, LDEXPF_TOLERANCE, 0},
{453, 1287620154u, 0u, 1287620154u, 0, LDEXPF_TOLERANCE, 0},
{454, 3073260205u, 0u, 3073260205u, 0, LDEXPF_TOLERANCE, 0},
{455, 1245702957u, 0u, 1245702957u, 0, LDEXPF_TOLERANCE, 0},
{456, 3087802274u, 0u, 3087802274u, 0, LDEXPF_TOLERANCE, 0},
{457, 3415763001u, 0u, 3415763001u, 0, LDEXPF_TOLERANCE, 0},
{458, 3026311911u, 0u, 3026311911u, 0, LDEXPF_TOLERANCE, 0},
{459, 1198307901u, 68u, 1768733245u, 0, LDEXPF_TOLERANCE, 0},
{460, 922255363u, 0u, 922255363u, 0, LDEXPF_TOLERANCE, 0},
{461, 1113104661u, 0u, 1113104661u, 0, LDEXPF_TOLERANCE, 0},
{462, 1136714348u, 0u, 1136714348u, 0, LDEXPF_TOLERANCE, 0},
{463, 948856035u, 0u, 948856035u, 0, LDEXPF_TOLERANCE, 0},
{464, 1062512367u, 4294967293u, 1037346543u, 0, LDEXPF_TOLERANCE, 0},
{465, 3486907092u, 0u, 3486907092u, 0, LDEXPF_TOLERANCE, 0},
{466, 1162027071u, 4294964303u, 0u, 0, LDEXPF_TOLERANCE, 0},
{467, 1034561811u, 0u, 1034561811u, 0, LDEXPF_TOLERANCE, 0},
{468, 3271615417u, 0u, 3271615417u, 0, LDEXPF_TOLERANCE, 0},
{469, 1177157787u, 0u, 1177157787u, 0, LDEXPF_TOLERANCE, 0},
{470, 3196144817u, 0u, 3196144817u, 0, LDEXPF_TOLERANCE, 0},
{471, 3432084552u, 0u, 3432084552u, 0, LDEXPF_TOLERANCE, 0},
{472, 1309658335u, 0u, 1309658335u, 0, LDEXPF_TOLERANCE, 0},
{473, 1226494979u, 0u, 1226494979u, 0, LDEXPF_TOLERANCE, 0},
{474, 3460699001u, 0u, 3460699001u, 0, LDEXPF_TOLERANCE, 0},
{475, 3079231719u, 0u, 3079231719u, 0, LDEXPF_TOLERANCE, 0},
{476, 3093951884u, 0u, 3093951884u, 0, LDEXPF_TOLERANCE, 0},
{477, 1204196034u, 4294966040u, 0u, 0, LDEXPF_TOLERANCE, 0},
{478, 3459877411u, 0u, 3459877411u, 0, LDEXPF_TOLERANCE, 0},
{479, 1161439847u, 0u, 1161439847u, 0, LDEXPF_TOLERANCE, 0},
{480, 908663107u, 0u, 908663107u, 0, LDEXPF_TOLERANCE, 0},
{481, 1084378658u, 0u, 1084378658u, 0, LDEXPF_TOLERANCE, 0},
{482, 3022828828u, 0u, 3022828828u, 0, LDEXPF_TOLERANCE, 0},
{483, 1226473697u, 0u, 1226473697u, 0, LDEXPF_TOLERANCE, 0},
{484, 3468040845u, 0u, 3468040845u, 0, LDEXPF_TOLERANCE, 0},
{485, 1178825761u, 54u, 1631810593u, 0, LDEXPF_TOLERANCE, 0},
{486, 3059266302u, 0u, 3059266302u, 0, LDEXPF_TOLERANCE, 0},
{487, 3337652712u, 0u, 3337652712u, 0, LDEXPF_TOLERANCE, 0},
{488, 1184753508u, 0u, 1184753508u, 0, LDEXPF_TOLERANCE, 0},
{489, 996404791u, 4294853343u, 0u, 0, LDEXPF_TOLERANCE, 0},
{490, 1188439315u, 55u, 1649812755u, 0, LDEXPF_TOLERANCE, 0},
{491, 906557513u, 0u, 906557513u, 0, LDEXPF_TOLERANCE, 0},
{492, 916831283u, 0u, 916831283u, 0, LDEXPF_TOLERANCE, 0},
{493, 996786317u, 0u, 996786317u, 0, LDEXPF_TOLERANCE, 0},
{494, 3461635065u, 0u, 3461635065u, 0, LDEXPF_TOLERANCE, 0},
{495, 3290079438u, 0u, 3290079438u, 0, LDEXPF_TOLERANCE, 0},
{496, 3350690327u, 0u, 3350690327u, 0, LDEXPF_TOLERANCE, 0},
{497, 1102061604u, 4253821380u, 0u, 0, LDEXPF_TOLERANCE, 0},
{498, 1282351521u, 0u, 1282351521u, 0, LDEXPF_TOLERANCE, 0},
{499, 3095256878u, 0u, 3095256878u, 0, LDEXPF_TOLERANCE, 0},
{500, 3163373610u, 0u, 3163373610u, 0, LDEXPF_TOLERANCE, 0},
{501, 3228793330u, 0u, 3228793330u, 0, LDEXPF_TOLERANCE, 0},
{502, 3422194733u, 0u, 3422194733u, 0, LDEXPF_TOLERANCE, 0},
{503, 3083885296u, 0u, 3083885296u, 0, LDEXPF_TOLERANCE, 0},
{504, 1261940623u, 4288291120u, 0u, 0, LDEXPF_TOLERANCE, 0},
{505, 3400603081u, 4294967290u, 3350271433u, 0, LDEXPF_TOLERANCE, 0},
{506, 1219411812u, 0u, 1219411812u, 0, LDEXPF_TOLERANCE, 0},
{507, 3094833770u, 0u, 3094833770u, 0, LDEXPF_TOLERANCE, 0},
{508, 3139250800u, 0u, 3139250800u, 0, LDEXPF_TOLERANCE, 0},
{509, 886201503u, 4294967150u, 0u, 0, LDEXPF_TOLERANCE, 0},
{510, 3297366026u, 7u, 3356086282u, 0, LDEXPF_TOLERANCE, 0},
{511, 1218488455u, 4294964141u, 0u, 0, LDEXPF_TOLERANCE, 0},
{512, 3040358923u, 0u, 3040358923u, 0, LDEXPF_TOLERANCE, 0},
{513, 3182551696u, 0u, 3182551696u, 0, LDEXPF_TOLERANCE, 0},
{514, 1317098613u, 0u, 1317098613u, 0, LDEXPF_TOLERANCE, 0},
{515, 3431703657u, 0u, 3431703657u, 0, LDEXPF_TOLERANCE, 0},
{516, 3239728775u, 0u, 3239728775u, 0, LDEXPF_TOLERANCE, 0},
{517, 3207141672u, 0u, 3207141672u, 0, LDEXPF_TOLERANCE, 0},
{518, 3154378805u, 0u, 3154378805u, 0, LDEXPF_TOLERANCE, 0},
{519, 3069658155u, 0u, 3069658155u, 0, LDEXPF_TOLERANCE, 0},
{520, 3313160088u, 0u, 3313160088u, 0, LDEXPF_TOLERANCE, 0},
{521, 1284174954u, 4180334231u, 0u, 0, LDEXPF_TOLERANCE, 0},
{522, 1063693032u, 0u, 1063693032u, 0, LDEXPF_TOLERANCE, 0},
{523, 1102631663u, 4290881696u, 0u, 0, LDEXPF_TOLERANCE, 0},
{524, 968803479u, 0u, 968803479u, 0, LDEXPF_TOLERANCE, 0},
{525, 3273080388u, 0u, 3273080388u, 0, LDEXPF_TOLERANCE, 0},
{526, 1172529774u, 4294966405u, 0u, 0, LDEXPF_TOLERANCE, 0},
{527, 1078478376u, 2364151806u, 0u, 0, LDEXPF_TOLERANCE, 0},
{528, 3158855023u, 0u, 3158855023u, 0, LDEXPF_TOLERANCE, 0},
{529, 1165177679u, 4294967097u, 0u, 0, LDEXPF_TOLERANCE, 0},
{530, 952348506u, 4294108410u, 0u, 0, LDEXPF_TOLERANCE, 0},
{531, 1325324763u, 0u, 1325324763u, 0, LDEXPF_TOLERANCE, 0},
{532, 3363524213u, 0u, 3363524213u, 0, LDEXPF_TOLERANCE, 0},
{533, 1158950321u, 1u, 1167338929u, 0, LDEXPF_TOLERANCE, 0},
{534, 903129873u, 4272788451u, 0u, 0, LDEXPF_TOLERANCE, 0},
{535, 3078339944u, 0u, 3078339944u, 0, LDEXPF_TOLERANCE, 0},
{536, 1153863988u, 4229464462u, 0u, 0, LDEXPF_TOLERANCE, 0},
{537, 1235620969u, 0u, 1235620969u, 0, LDEXPF_TOLERANCE, 0},
{538, 1097120930u, 4294967294u, 1080343714u, 0, LDEXPF_TOLERANCE, 0},
{539, 1147712200u, 0u, 1147712200u, 0, LDEXPF_TOLERANCE, 0},
{540, 1124721745u, 0u, 1124721745u, 0, LDEXPF_TOLERANCE, 0},
{541, 3261744304u, 0u, 3261744304u, 0, LDEXPF_TOLERANCE, 0},
{542, 3303160152u, 0u, 3303160152u, 0, LDEXPF_TOLERANCE, 0},
{543, 1335399673u, 0u, 1335399673u, 0, LDEXPF_TOLERANCE, 0},
{544, 1072458508u, 4294404660u, 0u, 0, LDEXPF_TOLERANCE, 0},
{545, 3303015249u, 0u, 3303015249u, 0, LDEXPF_TOLERANCE, 0},
{546, 3252139741u, 0u, 3252139741u, 0, LDEXPF_TOLERANCE, 0},
{547, 3468519966u, 0u, 3468519966u, 0, LDEXPF_TOLERANCE, 0},
{548, 1006231203u, 0u, 1006231203u, 0, LDEXPF_TOLERANCE, 0},
{549, 951554138u, 0u, 951554138u, 0, LDEXPF_TOLERANCE, 0},
{550, 942046828u, 0u, 942046828u, 0, LDEXPF_TOLERANCE, 0},
{551, 3255104167u, 0u, 3255104167u, 0, LDEXPF_TOLERANCE, 0},
{552, 1155477903u, 0u, 1155477903u, 0, LDEXPF_TOLERANCE, 0},
{553, 3273889176u, 0u, 3273889176u, 0, LDEXPF_TOLERANCE, 0},
{554, 1228207362u, 0u, 1228207362u, 0, LDEXPF_TOLERANCE, 0},
{555, 1290175785u, 0u, 1290175785u, 0, LDEXPF_TOLERANCE, 0},
{556, 981908840u, 4294962938u, 0u, 0, LDEXPF_TOLERANCE, 0},
{557, 941187647u, 33u, 1218011711u, 0, LDEXPF_TOLERANCE, 0},
{558, 1214223128u, 4294967293u, 1189057304u, 0, LDEXPF_TOLERANCE, 0},
{559, 3422922584u, 6u, 3473254232u, 0, LDEXPF_TOLERANCE, 0},
{560, 3453226030u, 4294967291u, 3411282990u, 0, LDEXPF_TOLERANCE, 0},
{561, 1078359574u, 0u, 1078359574u, 0, LDEXPF_TOLERANCE, 0},
{562, 1029557624u, 4294965511u, 0u, 0, LDEXPF_TOLERANCE, 0},
{563, 1207675424u, 0u, 1207675424u, 0, LDEXPF_TOLERANCE, 0},
{564, 1028355074u, 4113313406u, 0u, 0, LDEXPF_TOLERANCE, 0},
{565, 1248421894u, 4294582111u, 0u, 0, LDEXPF_TOLERANCE, 0},
{566, 3353251994u, 12u, 3453915290u, 0, LDEXPF_TOLERANCE, 0},
{567, 876926659u, 4294966792u, 0u, 0, LDEXPF_TOLERANCE, 0},
{568, 1076752219u, 0u, 1076752219u, 0, LDEXPF_TOLERANCE, 0},
{569, 3388531942u, 0u, 3388531942u, 0, LDEXPF_TOLERANCE, 0},
{570, 1273395082u, 0u, 1273395082u, 0, LDEXPF_TOLERANCE, 0},
{571, 1161241793u, 2814016219u, 0u, 0, LDEXPF_TOLERANCE, 0},
{572, 3034494183u, 0u, 3034494183u, 0, LDEXPF_TOLERANCE, 0},
{573, 1171318485u, 4294306215u, 0u, 0, LDEXPF_TOLERANCE, 0},
{574, 3047748143u, 0u, 3047748143u, 0, LDEXPF_TOLERANCE, 0},
{575, 1001216371u, 0u, 1001216371u, 0, LDEXPF_TOLERANCE, 0},
{576, 912515889u, 2u, 929293105u, 0, LDEXPF_TOLERANCE, 0},
{577, 3391452505u, 0u, 3391452505u, 0, LDEXPF_TOLERANCE, 0},
{578, 3249603369u, 0u, 3249603369u, 0, LDEXPF_TOLERANCE, 0},
{579, 1220264047u, 0u, 1220264047u, 0, LDEXPF_TOLERANCE, 0},
{580, 3169816394u, 0u, 3169816394u, 0, LDEXPF_TOLERANCE, 0},
{581, 3098997418u, 0u, 3098997418u, 0, LDEXPF_TOLERANCE, 0},
{582, 3282212423u, 0u, 3282212423u, 0, LDEXPF_TOLERANCE, 0},
{583, 3352293320u, 4294967278u, 3201298376u, 0, LDEXPF_TOLERANCE, 0},
{584, 3296358441u, 0u, 3296358441u, 0, LDEXPF_TOLERANCE, 0},
{585, 1197828352u, 4294967281u, 1071999232u, 0, LDEXPF_TOLERANCE, 0},
{586, 3340510371u, 0u, 3340510371u, 0, LDEXPF_TOLERANCE, 0},
{587, 1127109339u, 4294570975u, 0u, 0, LDEXPF_TOLERANCE, 0},
{588, 1200599955u, 0u, 1200599955u, 0, LDEXPF_TOLERANCE, 0},
{589, 962230977u, 0u, 962230977u, 0, LDEXPF_TOLERANCE, 0},
{590, 3192887808u, 0u, 3192887808u, 0, LDEXPF_TOLERANCE, 0},
{591, 3237183876u, 0u, 3237183876u, 0, LDEXPF_TOLERANCE, 0},
{592, 939285924u, 0u, 939285924u, 0, LDEXPF_TOLERANCE, 0},
{593, 944050180u, 3871652138u, 0u, 0, LDEXPF_TOLERANCE, 0},
{594, 3058135703u, 0u, 3058135703u, 0, LDEXPF_TOLERANCE, 0},
{595, 1003299981u, 0u, 1003299981u, 0, LDEXPF_TOLERANCE, 0},
{596, 1234491880u, 4283784819u, 0u, 0, LDEXPF_TOLERANCE, 0},
{597, 1107800421u, 0u, 1107800421u, 0, LDEXPF_TOLERANCE, 0},
{598, 3169600404u, 0u, 3169600404u, 0, LDEXPF_TOLERANCE, 0},
{599, 1059745845u, 0u, 1059745845u, 0, LDEXPF_TOLERANCE, 0},
{600, 3336642868u, 0u, 3336642868u, 0, LDEXPF_TOLERANCE, 0},
{601, 1143165709u, 0u, 1143165709u, 0, LDEXPF_TOLERANCE, 0},
{602, 3094884021u, 0u, 3094884021u, 0, LDEXPF_TOLERANCE, 0},
{603, 875429471u, 0u, 875429471u, 0, LDEXPF_TOLERANCE, 0},
{604, 1191396289u, 0u, 1191396289u, 0, LDEXPF_TOLERANCE, 0},
{605, 1228663872u, 0u, 1228663872u, 0, LDEXPF_TOLERANCE, 0},
{606, 1070971843u, 0u, 1070971843u, 0, LDEXPF_TOLERANCE, 0},
{607, 3364208877u, 0u, 3364208877u, 0, LDEXPF_TOLERANCE, 0},
{608, 3181522772u, 0u, 3181522772u, 0, LDEXPF_TOLERANCE, 0},
{609, 1243001035u, 0u, 1243001035u, 0, LDEXPF_TOLERANCE, 0},
{610, 1341514497u, 0u, 1341514497u, 0, LDEXPF_TOLERANCE, 0},
{611, 880168139u, 0u, 880168139u, 0, LDEXPF_TOLERANCE, 0},
{612, 3304288294u, 0u, 3304288294u, 0, LDEXPF_TOLERANCE, 0},
{613, 1026899743u, 0u, 1026899743u, 0, LDEXPF_TOLERANCE, 0},
{614, 999981605u, 0u, 999981605u, 0, LDEXPF_TOLERANCE, 0},
{615, 997294135u, 0u, 997294135u, 0, LDEXPF_TOLERANCE, 0},
{616, 1021132553u, 0u, 1021132553u, 0, LDEXPF_TOLERANCE, 0},
{617, 3209276375u, 0u, 3209276375u, 0, LDEXPF_TOLERANCE, 0},
{618, 1202227751u, 0u, 1202227751u, 0, LDEXPF_TOLERANCE, 0},
{619, 1009711807u, 0u, 1009711807u, 0, LDEXPF_TOLERANCE, 0},
{620, 1220134117u, 0u, 1220134117u, 0, LDEXPF_TOLERANCE, 0},
{621, 3479973529u, 0u, 3479973529u, 0, LDEXPF_TOLERANCE, 0},
{622, 1064880944u, 0u, 1064880944u, 0, LDEXPF_TOLERANCE, 0},
{623, 3155671716u, 0u, 3155671716u, 0, LDEXPF_TOLERANCE, 0},
{624, 998312904u, 0u, 998312904u, 0, LDEXPF_TOLERANCE, 0},
{625, 1001472780u, 0u, 1001472780u, 0, LDEXPF_TOLERANCE, 0},
{626, 1107406396u, 0u, 1107406396u, 0, LDEXPF_TOLERANCE, 0},
{627, 1261071232u, 0u, 1261071232u, 0, LDEXPF_TOLERANCE, 0},
{628, 3143571932u, 0u, 3143571932u, 0, LDEXPF_TOLERANCE, 0},
{629, 1118055178u, 0u, 1118055178u, 0, LDEXPF_TOLERANCE, 0},
{630, 3182301130u, 0u, 3182301130u, 0, LDEXPF_TOLERANCE, 0},
{631, 3368273682u, 0u, 3368273682u, 0, LDEXPF_TOLERANCE, 0},
{632, 3428016856u, 0u, 3428016856u, 0, LDEXPF_TOLERANCE, 0},
{633, 3417964312u, 0u, 3417964312u, 0, LDEXPF_TOLERANCE, 0},
{634, 3033865687u, 0u, 3033865687u, 0, LDEXPF_TOLERANCE, 0},
{635, 3254565724u, 0u, 3254565724u, 0, LDEXPF_TOLERANCE, 0},
{636, 1152956913u, 0u, 1152956913u, 0, LDEXPF_TOLERANCE, 0},
{637, 960907115u, 0u, 960907115u, 0, LDEXPF_TOLERANCE, 0},
{638, 3193128520u, 0u, 3193128520u, 0, LDEXPF_TOLERANCE, 0},
{639, 1342075843u, 0u, 1342075843u, 0, LDEXPF_TOLERANCE, 0},
{640, 1285620759u, 0u, 1285620759u, 0, LDEXPF_TOLERANCE, 0},
{641, 3194665484u, 0u, 3194665484u, 0, LDEXPF_TOLERANCE, 0},
{642, 3367275355u, 0u, 3367275355u, 0, LDEXPF_TOLERANCE, 0},
{643, 874952611u, 0u, 874952611u, 0, LDEXPF_TOLERANCE, 0},
{644, 3267754884u, 0u, 3267754884u, 0, LDEXPF_TOLERANCE, 0},
{645, 3152729489u, 0u, 3152729489u, 0, LDEXPF_TOLERANCE, 0},
{646, 889017820u, 0u, 889017820u, 0, LDEXPF_TOLERANCE, 0},
{647, 3299847679u, 0u, 3299847679u, 0, LDEXPF_TOLERANCE, 0},
{648, 1247838175u, 0u, 1247838175u, 0, LDEXPF_TOLERANCE, 0},
{649, 3320990807u, 0u, 3320990807u, 0, LDEXPF_TOLERANCE, 0},
{650, 3050540527u, 0u, 3050540527u, 0, LDEXPF_TOLERANCE, 0},
{651, 1201844223u, 0u, 1201844223u, 0, LDEXPF_TOLERANCE, 0},
{652, 918937712u, 0u, 918937712u, 0, LDEXPF_TOLERANCE, 0},
{653, 3123925950u, 0u, 3123925950u, 0, LDEXPF_TOLERANCE, 0},
{654, 3196511197u, 0u, 3196511197u, 0, LDEXPF_TOLERANCE, 0},
{655, 973211154u, 0u, 973211154u, 0, LDEXPF_TOLERANCE, 0},
{656, 1255152035u, 0u, 1255152035u, 0, LDEXPF_TOLERANCE, 0},
{657, 3232461888u, 0u, 3232461888u, 0, LDEXPF_TOLERANCE, 0},
{658, 1229904697u, 0u, 1229904697u, 0, LDEXPF_TOLERANCE, 0},
{659, 3190708309u, 0u, 3190708309u, 0, LDEXPF_TOLERANCE, 0},
{660, 1062714323u, 0u, 1062714323u, 0, LDEXPF_TOLERANCE, 0},
{661, 1266014197u, 0u, 1266014197u, 0, LDEXPF_TOLERANCE, 0},
{662, 3358918989u, 0u, 3358918989u, 0, LDEXPF_TOLERANCE, 0},
{663, 1197322308u, 0u, 1197322308u, 0, LDEXPF_TOLERANCE, 0},
{664, 896467500u, 0u, 896467500u, 0, LDEXPF_TOLERANCE, 0},
{665, 3375078440u, 0u, 3375078440u, 0, LDEXPF_TOLERANCE, 0},
{666, 3424479544u, 0u, 3424479544u, 0, LDEXPF_TOLERANCE, 0},
{667, 3187924230u, 0u, 3187924230u, 0, LDEXPF_TOLERANCE, 0},
{668, 1025254314u, 0u, 1025254314u, 0, LDEXPF_TOLERANCE, 0},
{669, 899599265u, 0u, 899599265u, 0, LDEXPF_TOLERANCE, 0},
{670, 1298319097u, 0u, 1298319097u, 0, LDEXPF_TOLERANCE, 0},
{671, 3211795254u, 0u, 3211795254u, 0, LDEXPF_TOLERANCE, 0},
{672, 3346354159u, 0u, 3346354159u, 0, LDEXPF_TOLERANCE, 0},
{673, 1200574709u, 0u, 1200574709u, 0, LDEXPF_TOLERANCE, 0},
{674, 1271583043u, 0u, 1271583043u, 0, LDEXPF_TOLERANCE, 0},
{675, 3082939266u, 0u, 3082939266u, 0, LDEXPF_TOLERANCE, 0},
{676, 1310205466u, 0u, 1310205466u, 0, LDEXPF_TOLERANCE, 0},
{677, 3363424163u, 0u, 3363424163u, 0, LDEXPF_TOLERANCE, 0},
{678, 3480831693u, 0u, 3480831693u, 0, LDEXPF_TOLERANCE, 0},
{679, 3076016307u, 0u, 3076016307u, 0, LDEXPF_TOLERANCE, 0},
{680, 3203273256u, 0u, 3203273256u, 0, LDEXPF_TOLERANCE, 0},
{681, 1015309679u, 0u, 1015309679u, 0, LDEXPF_TOLERANCE, 0},
{682, 1131196082u, 0u, 1131196082u, 0, LDEXPF_TOLERANCE, 0},
{683, 1045325026u, 0u, 1045325026u, 0, LDEXPF_TOLERANCE, 0},
{684, 1065479977u, 0u, 1065479977u, 0, LDEXPF_TOLERANCE, 0},
{685, 1189296917u, 0u, 1189296917u, 0, LDEXPF_TOLERANCE, 0},
{686, 3189815506u, 0u, 3189815506u, 0, LDEXPF_TOLERANCE, 0},
{687, 1080781593u, 0u, 1080781593u, 0, LDEXPF_TOLERANCE, 0},
{688, 1311096557u, 0u, 1311096557u, 0, LDEXPF_TOLERANCE, 0},
{689, 3038739020u, 0u, 3038739020u, 0, LDEXPF_TOLERANCE, 0},
{690, 3214499901u, 0u, 3214499901u, 0, LDEXPF_TOLERANCE, 0},
{691, 3138742876u, 0u, 3138742876u, 0, LDEXPF_TOLERANCE, 0},
{692, 1321846889u, 0u, 1321846889u, 0, LDEXPF_TOLERANCE, 0},
{693, 3271921642u, 0u, 3271921642u, 0, LDEXPF_TOLERANCE, 0},
{694, 3085495739u, 0u, 3085495739u, 0, LDEXPF_TOLERANCE, 0},
{695, 1109198803u, 0u, 1109198803u, 0, LDEXPF_TOLERANCE, 0},
{696, 1112304750u, 0u, 1112304750u, 0, LDEXPF_TOLERANCE, 0},
{697, 948750709u, 0u, 948750709u, 0, LDEXPF_TOLERANCE, 0},
{698, 1114296298u, 0u, 1114296298u, 0, LDEXPF_TOLERANCE, 0},
{699, 3020991237u, 0u, 3020991237u, 0, LDEXPF_TOLERANCE, 0},
{700, 922534144u, 0u, 922534144u, 0, LDEXPF_TOLERANCE, 0},
{701, 3310166637u, 0u, 3310166637u, 0, LDEXPF_TOLERANCE, 0},
{702, 3155722650u, 0u, 3155722650u, 0, LDEXPF_TOLERANCE, 0},
{703, 3427296372u, 0u, 3427296372u, 0, LDEXPF_TOLERANCE, 0},
{704, 1151399844u, 0u, 1151399844u, 0, LDEXPF_TOLERANCE, 0},
{705, 1120299263u, 0u, 1120299263u, 0, LDEXPF_TOLERANCE, 0},
{706, 3040459077u, 0u, 3040459077u, 0, LDEXPF_TOLERANCE, 0},
{707, 1103929401u, 0u, 1103929401u, 0, LDEXPF_TOLERANCE, 0},
{708, 1152548998u, 0u, 1152548998u, 0, LDEXPF_TOLERANCE, 0},
{709, 916942572u, 0u, 916942572u, 0, LDEXPF_TOLERANCE, 0},
{710, 3173458455u, 0u, 3173458455u, 0, LDEXPF_TOLERANCE, 0},
{711, 3238936406u, 0u, 3238936406u, 0, LDEXPF_TOLERANCE, 0},
{712, 3408617686u, 0u, 3408617686u, 0, LDEXPF_TOLERANCE, 0},
{713, 1021296799u, 0u, 1021296799u, 0, LDEXPF_TOLERANCE, 0},
{714, 969339922u, 0u, 969339922u, 0, LDEXPF_TOLERANCE, 0},
{715, 1314176876u, 0u, 1314176876u, 0, LDEXPF_TOLERANCE, 0},
{716, 1337612088u, 0u, 1337612088u, 0, LDEXPF_TOLERANCE, 0},
{717, 3332259981u, 0u, 3332259981u, 0, LDEXPF_TOLERANCE, 0},
{718, 3108384823u, 0u, 3108384823u, 0, LDEXPF_TOLERANCE, 0},
{719, 3220961947u, 0u, 3220961947u, 0, LDEXPF_TOLERANCE, 0},
{720, 3064419690u, 0u, 3064419690u, 0, LDEXPF_TOLERANCE, 0},
{721, 940691906u, 0u, 940691906u, 0, LDEXPF_TOLERANCE, 0},
{722, 1231810213u, 0u, 1231810213u, 0, LDEXPF_TOLERANCE, 0},
{723, 1287877759u, 0u, 1287877759u, 0, LDEXPF_TOLERANCE, 0},
{724, 3489122735u, 0u, 3489122735u, 0, LDEXPF_TOLERANCE, 0},
{725, 1093869145u, 0u, 1093869145u, 0, LDEXPF_TOLERANCE, 0},
{726, 3076769896u, 0u, 3076769896u, 0, LDEXPF_TOLERANCE, 0},
{727, 1103636269u, 0u, 1103636269u, 0, LDEXPF_TOLERANCE, 0},
{728, 1175158938u, 0u, 1175158938u, 0, LDEXPF_TOLERANCE, 0},
{729, 3300166369u, 0u, 3300166369u, 0, LDEXPF_TOLERANCE, 0},
{730, 1139120919u, 0u, 1139120919u, 0, LDEXPF_TOLERANCE, 0},
{731, 3164744879u, 0u, 3164744879u, 0, LDEXPF_TOLERANCE, 0},
{732, 1079206005u, 0u, 1079206005u, 0, LDEXPF_TOLERANCE, 0},
{733, 3274158582u, 0u, 3274158582u, 0, LDEXPF_TOLERANCE, 0},
{734, 1175743586u, 0u, 1175743586u, 0, LDEXPF_TOLERANCE, 0},
{735, 3260712581u, 0u, 3260712581u, 0, LDEXPF_TOLERANCE, 0},
{736, 3260874736u, 0u, 3260874736u, 0, LDEXPF_TOLERANCE, 0},
{737, 1021540545u, 0u, 1021540545u, 0, LDEXPF_TOLERANCE, 0},
{738, 938613078u, 0u, 938613078u, 0, LDEXPF_TOLERANCE, 0},
{739, 915371924u, 0u, 915371924u, 0, LDEXPF_TOLERANCE, 0},
{740, 3370829512u, 0u, 3370829512u, 0, LDEXPF_TOLERANCE, 0},
{741, 3042270922u, 0u, 3042270922u, 0, LDEXPF_TOLERANCE, 0},
{742, 935259591u, 0u, 935259591u, 0, LDEXPF_TOLERANCE, 0},
{743, 3022705759u, 0u, 3022705759u, 0, LDEXPF_TOLERANCE, 0},
{744, 1077763691u, 0u, 1077763691u, 0, LDEXPF_TOLERANCE, 0},
{745, 3479409116u, 0u, 3479409116u, 0, LDEXPF_TOLERANCE, 0},
{746, 3153568584u, 0u, 3153568584u, 0, LDEXPF_TOLERANCE, 0},
{747, 1023846821u, 0u, 1023846821u, 0, LDEXPF_TOLERANCE, 0},
{748, 930761742u, 0u, 930761742u, 0, LDEXPF_TOLERANCE, 0},
{749, 3041242545u, 0u, 3041242545u, 0, LDEXPF_TOLERANCE, 0},
{750, 1088950833u, 0u, 1088950833u, 0, LDEXPF_TOLERANCE, 0},
{751, 3404968330u, 0u, 3404968330u, 0, LDEXPF_TOLERANCE, 0},
{752, 3081647766u, 0u, 3081647766u, 0, LDEXPF_TOLERANCE, 0},
{753, 1215278023u, 0u, 1215278023u, 0, LDEXPF_TOLERANCE, 0},
{754, 1094198050u, 0u, 1094198050u, 0, LDEXPF_TOLERANCE, 0},
{755, 884566767u, 0u, 884566767u, 0, LDEXPF_TOLERANCE, 0},
{756, 1248601708u, 0u, 1248601708u, 0, LDEXPF_TOLERANCE, 0},
{757, 3392876913u, 0u, 3392876913u, 0, LDEXPF_TOLERANCE, 0},
{758, 892549317u, 0u, 892549317u, 0, LDEXPF_TOLERANCE, 0},
{759, 3093450711u, 0u, 3093450711u, 0, LDEXPF_TOLERANCE, 0},
{760, 3469899047u, 0u, 3469899047u, 0, LDEXPF_TOLERANCE, 0},
{761, 996220168u, 0u, 996220168u, 0, LDEXPF_TOLERANCE, 0},
{762, 3114161777u, 0u, 3114161777u, 0, LDEXPF_TOLERANCE, 0},
{763, 1253240637u, 0u, 1253240637u, 0, LDEXPF_TOLERANCE, 0},
{764, 3343677583u, 0u, 3343677583u, 0, LDEXPF_TOLERANCE, 0},
{765, 3179241204u, 0u, 3179241204u, 0, LDEXPF_TOLERANCE, 0},
{766, 3155113426u, 0u, 3155113426u, 0, LDEXPF_TOLERANCE, 0},
{767, 1031613223u, 0u, 1031613223u, 0, LDEXPF_TOLERANCE, 0},
{768, 1034712760u, 0u, 1034712760u, 0, LDEXPF_TOLERANCE, 0},
{769, 1066116543u, 0u, 1066116543u, 0, LDEXPF_TOLERANCE, 0},
{770, 1186234578u, 0u, 1186234578u, 0, LDEXPF_TOLERANCE, 0},
{771, 1036186976u, 0u, 1036186976u, 0, LDEXPF_TOLERANCE, 0},
{772, 3097296874u, 0u, 3097296874u, 0, LDEXPF_TOLERANCE, 0},
{773, 1045232522u, 0u, 1045232522u, 0, LDEXPF_TOLERANCE, 0},
{774, 1039321021u, 0u, 1039321021u, 0, LDEXPF_TOLERANCE, 0},
{775, 3173254520u, 0u, 3173254520u, 0, LDEXPF_TOLERANCE, 0},
{776, 932998692u, 0u, 932998692u, 0, LDEXPF_TOLERANCE, 0},
{777, 1171238338u, 0u, 1171238338u, 0, LDEXPF_TOLERANCE, 0},
{778, 1202333162u, 0u, 1202333162u, 0, LDEXPF_TOLERANCE, 0},
{779, 1280215674u, 0u, 1280215674u, 0, LDEXPF_TOLERANCE, 0},
{780, 3211934425u, 0u, 3211934425u, 0, LDEXPF_TOLERANCE, 0},
{781, 3194999530u, 0u, 3194999530u, 0, LDEXPF_TOLERANCE, 0},
{782, 3299927364u, 0u, 3299927364u, 0, LDEXPF_TOLERANCE, 0},
{783, 3250437226u, 0u, 3250437226u, 0, LDEXPF_TOLERANCE, 0},
{784, 3071118853u, 0u, 3071118853u, 0, LDEXPF_TOLERANCE, 0},
{785, 3267868136u, 0u, 3267868136u, 0, LDEXPF_TOLERANCE, 0},
{786, 3123250489u, 0u, 3123250489u, 0, LDEXPF_TOLERANCE, 0},
{787, 3122362353u, 0u, 3122362353u, 0, LDEXPF_TOLERANCE, 0},
{788, 3327511577u, 0u, 3327511577u, 0, LDEXPF_TOLERANCE, 0},
{789, 3020140395u, 0u, 3020140395u, 0, LDEXPF_TOLERANCE, 0},
{790, 1267995571u, 0u, 1267995571u, 0, LDEXPF_TOLERANCE, 0},
{791, 3446392517u, 0u, 3446392517u, 0, LDEXPF_TOLERANCE, 0},
{792, 3034243695u, 0u, 3034243695u, 0, LDEXPF_TOLERANCE, 0},
{793, 3482416423u, 0u, 3482416423u, 0, LDEXPF_TOLERANCE, 0},
{794, 3310269251u, 0u, 3310269251u, 0, LDEXPF_TOLERANCE, 0},
{795, 1058296319u, 0u, 1058296319u, 0, LDEXPF_TOLERANCE, 0},
{796, 3432295752u, 0u, 3432295752u, 0, LDEXPF_TOLERANCE, 0},
{797, 1087881449u, 0u, 1087881449u, 0, LDEXPF_TOLERANCE, 0},
{798, 3374929424u, 0u, 3374929424u, 0, LDEXPF_TOLERANCE, 0},
{799, 1191811948u, 0u, 1191811948u, 0, LDEXPF_TOLERANCE, 0},
{800, 3268693154u, 0u, 3268693154u, 0, LDEXPF_TOLERANCE, 0},
{801, 3366511856u, 0u, 3366511856u, 0, LDEXPF_TOLERANCE, 0},
{802, 3234857152u, 0u, 3234857152u, 0, LDEXPF_TOLERANCE, 0},
{803, 3394693181u, 0u, 3394693181u, 0, LDEXPF_TOLERANCE, 0},
{804, 3322380283u, 0u, 3322380283u, 0, LDEXPF_TOLERANCE, 0},
{805, 3176526828u, 0u, 3176526828u, 0, LDEXPF_TOLERANCE, 0},
{806, 962436491u, 0u, 962436491u, 0, LDEXPF_TOLERANCE, 0},
{807, 1016021534u, 0u, 1016021534u, 0, LDEXPF_TOLERANCE, 0}

// AUTOMATICALLY GENERATED VECTORS STOP

};

#endif // CYGONCE_LIBM_LDEXPF_H multiple inclusion protection

// EOF ldexpf.h
