#ifndef CYGONCE_LIBM_J0_H
#define CYGONCE_LIBM_J0_H
//===========================================================================
//
//      j0f.h
//
//      Test vectors for testing of j0f() math library function
//
//===========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####
// -------------------------------------------
// This file is part of eCos, the Embedded Configurable Operating System.
// Copyright (C) 2012 Free Software Foundation, Inc.
//
// eCos is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 or (at your option) any later
// version.
//
// eCos is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
// for more details.
//
// You should have received a copy of the GNU General Public License
// along with eCos; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//
// As a special exception, if other files instantiate templates or use
// macros or inline functions from this file, or you compile this file
// and link it with other works to produce a work based on this file,
// this file does not by itself cause the resulting work to be covered by
// the GNU General Public License. However the source code for this file
// must still be made available in accordance with section (3) of the GNU
// General Public License v2.
//
// This exception does not invalidate any other reasons why a work based
// on this file might be covered by the GNU General Public License.
// -------------------------------------------
// ####ECOSGPLCOPYRIGHTEND####
//===========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):
// Contributors:  visar, ilijak
// Date:        1998-02-13
// Purpose:
// Description:
// Usage:       #include "vectors/j0f.h"
//
//####DESCRIPTIONEND####
//
//===========================================================================


// CONFIGURATION

#include <pkgconf/libm.h>   // Configuration header


// INCLUDES

#include <cyg/infra/cyg_type.h>    // Common type definitions and support
#include "vectors/vector_support_float.h"// extra support for math tests

#define J0_TOLERANCE 1.0E-04

static const Cyg_libm_test_float_vec_t j0f_vec[] = {

// AUTOMATICALLY GENERATED VECTORS START

{0, 3214514586u, 1059835739u, 1059835739u, 0, J0_TOLERANCE, 0},
{1, 3214430700u, 1059919122u, 1059919122u, 0, J0_TOLERANCE, 0},
{2, 3214346813u, 1060002071u, 1060002071u, 0, J0_TOLERANCE, 0},
{3, 3214262927u, 1060084577u, 1060084577u, 0, J0_TOLERANCE, 0},
{4, 3214179041u, 1060166635u, 1060166635u, 0, J0_TOLERANCE, 0},
{5, 3214095155u, 1060248241u, 1060248241u, 0, J0_TOLERANCE, 0},
{6, 3214011269u, 1060329386u, 1060329386u, 0, J0_TOLERANCE, 0},
{7, 3213927383u, 1060410067u, 1060410067u, 0, J0_TOLERANCE, 0},
{8, 3213843497u, 1060490274u, 1060490274u, 0, J0_TOLERANCE, 0},
{9, 3213759611u, 1060570006u, 1060570006u, 0, J0_TOLERANCE, 0},
{10, 3213675725u, 1060649254u, 1060649254u, 0, J0_TOLERANCE, 0},
{11, 3213591839u, 1060728013u, 1060728013u, 0, J0_TOLERANCE, 0},
{12, 3213507953u, 1060806276u, 1060806276u, 0, J0_TOLERANCE, 0},
{13, 3213424067u, 1060884039u, 1060884039u, 0, J0_TOLERANCE, 0},
{14, 3213340180u, 1060961298u, 1060961298u, 0, J0_TOLERANCE, 0},
{15, 3213256294u, 1061038042u, 1061038042u, 0, J0_TOLERANCE, 0},
{16, 3213172408u, 1061114269u, 1061114269u, 0, J0_TOLERANCE, 0},
{17, 3213088522u, 1061189972u, 1061189972u, 0, J0_TOLERANCE, 0},
{18, 3213004636u, 1061265147u, 1061265147u, 0, J0_TOLERANCE, 0},
{19, 3212920750u, 1061339787u, 1061339787u, 0, J0_TOLERANCE, 0},
{20, 3212836864u, 1061413887u, 1061413887u, 0, J0_TOLERANCE, 0},
{21, 3212669092u, 1061487442u, 1061487442u, 0, J0_TOLERANCE, 0},
{22, 3212501320u, 1061560445u, 1061560445u, 0, J0_TOLERANCE, 0},
{23, 3212333548u, 1061632891u, 1061632891u, 0, J0_TOLERANCE, 0},
{24, 3212165775u, 1061704777u, 1061704777u, 0, J0_TOLERANCE, 0},
{25, 3211998003u, 1061776097u, 1061776097u, 0, J0_TOLERANCE, 0},
{26, 3211830231u, 1061846843u, 1061846843u, 0, J0_TOLERANCE, 0},
{27, 3211662459u, 1061917012u, 1061917012u, 0, J0_TOLERANCE, 0},
{28, 3211494687u, 1061986598u, 1061986598u, 0, J0_TOLERANCE, 0},
{29, 3211326915u, 1062055596u, 1062055596u, 0, J0_TOLERANCE, 0},
{30, 3211159142u, 1062124001u, 1062124001u, 0, J0_TOLERANCE, 0},
{31, 3210991370u, 1062191808u, 1062191808u, 0, J0_TOLERANCE, 0},
{32, 3210823598u, 1062259012u, 1062259012u, 0, J0_TOLERANCE, 0},
{33, 3210655826u, 1062325608u, 1062325608u, 0, J0_TOLERANCE, 0},
{34, 3210488054u, 1062391591u, 1062391591u, 0, J0_TOLERANCE, 0},
{35, 3210320282u, 1062456956u, 1062456956u, 0, J0_TOLERANCE, 0},
{36, 3210152509u, 1062521700u, 1062521700u, 0, J0_TOLERANCE, 0},
{37, 3209984737u, 1062585814u, 1062585814u, 0, J0_TOLERANCE, 0},
{38, 3209816965u, 1062649297u, 1062649297u, 0, J0_TOLERANCE, 0},
{39, 3209649193u, 1062712142u, 1062712142u, 0, J0_TOLERANCE, 0},
{40, 3209481421u, 1062774345u, 1062774345u, 0, J0_TOLERANCE, 0},
{41, 3209313649u, 1062835904u, 1062835904u, 0, J0_TOLERANCE, 0},
{42, 3209145876u, 1062896811u, 1062896811u, 0, J0_TOLERANCE, 0},
{43, 3208978104u, 1062957061u, 1062957061u, 0, J0_TOLERANCE, 0},
{44, 3208810332u, 1063016653u, 1063016653u, 0, J0_TOLERANCE, 0},
{45, 3208642560u, 1063075578u, 1063075578u, 0, J0_TOLERANCE, 0},
{46, 3208474788u, 1063133838u, 1063133838u, 0, J0_TOLERANCE, 0},
{47, 3208307016u, 1063191423u, 1063191423u, 0, J0_TOLERANCE, 0},
{48, 3208139244u, 1063248330u, 1063248330u, 0, J0_TOLERANCE, 0},
{49, 3207971471u, 1063304557u, 1063304557u, 0, J0_TOLERANCE, 0},
{50, 3207803699u, 1063360098u, 1063360098u, 0, J0_TOLERANCE, 0},
{51, 3207635927u, 1063414948u, 1063414948u, 0, J0_TOLERANCE, 0},
{52, 3207468155u, 1063469104u, 1063469104u, 0, J0_TOLERANCE, 0},
{53, 3207300383u, 1063522564u, 1063522564u, 0, J0_TOLERANCE, 0},
{54, 3207132611u, 1063575320u, 1063575320u, 0, J0_TOLERANCE, 0},
{55, 3206964838u, 1063627371u, 1063627371u, 0, J0_TOLERANCE, 0},
{56, 3206797066u, 1063678713u, 1063678713u, 0, J0_TOLERANCE, 0},
{57, 3206629294u, 1063729339u, 1063729339u, 0, J0_TOLERANCE, 0},
{58, 3206461522u, 1063779249u, 1063779249u, 0, J0_TOLERANCE, 0},
{59, 3206293750u, 1063828438u, 1063828438u, 0, J0_TOLERANCE, 0},
{60, 3206125978u, 1063876903u, 1063876903u, 0, J0_TOLERANCE, 0},
{61, 3205958205u, 1063924638u, 1063924638u, 0, J0_TOLERANCE, 0},
{62, 3205790433u, 1063971642u, 1063971642u, 0, J0_TOLERANCE, 0},
{63, 3205622661u, 1064017911u, 1064017911u, 0, J0_TOLERANCE, 0},
{64, 3205454889u, 1064063439u, 1064063439u, 0, J0_TOLERANCE, 0},
{65, 3205287117u, 1064108226u, 1064108226u, 0, J0_TOLERANCE, 0},
{66, 3205119345u, 1064152266u, 1064152266u, 0, J0_TOLERANCE, 0},
{67, 3204951572u, 1064195560u, 1064195560u, 0, J0_TOLERANCE, 0},
{68, 3204783800u, 1064238100u, 1064238100u, 0, J0_TOLERANCE, 0},
{69, 3204616028u, 1064279884u, 1064279884u, 0, J0_TOLERANCE, 0},
{70, 3204448256u, 1064320911u, 1064320911u, 0, J0_TOLERANCE, 0},
{71, 3204112712u, 1064361174u, 1064361174u, 0, J0_TOLERANCE, 0},
{72, 3203777167u, 1064400675u, 1064400675u, 0, J0_TOLERANCE, 0},
{73, 3203441623u, 1064439408u, 1064439408u, 0, J0_TOLERANCE, 0},
{74, 3203106079u, 1064477370u, 1064477370u, 0, J0_TOLERANCE, 0},
{75, 3202770534u, 1064514559u, 1064514559u, 0, J0_TOLERANCE, 0},
{76, 3202434990u, 1064550972u, 1064550972u, 0, J0_TOLERANCE, 0},
{77, 3202099446u, 1064586606u, 1064586606u, 0, J0_TOLERANCE, 0},
{78, 3201763901u, 1064621459u, 1064621459u, 0, J0_TOLERANCE, 0},
{79, 3201428357u, 1064655526u, 1064655526u, 0, J0_TOLERANCE, 0},
{80, 3201092813u, 1064688809u, 1064688809u, 0, J0_TOLERANCE, 0},
{81, 3200757268u, 1064721302u, 1064721302u, 0, J0_TOLERANCE, 0},
{82, 3200421724u, 1064753003u, 1064753003u, 0, J0_TOLERANCE, 0},
{83, 3200086180u, 1064783911u, 1064783911u, 0, J0_TOLERANCE, 0},
{84, 3199750636u, 1064814022u, 1064814022u, 0, J0_TOLERANCE, 0},
{85, 3199415091u, 1064843334u, 1064843334u, 0, J0_TOLERANCE, 0},
{86, 3199079547u, 1064871847u, 1064871847u, 0, J0_TOLERANCE, 0},
{87, 3198744003u, 1064899556u, 1064899556u, 0, J0_TOLERANCE, 0},
{88, 3198408458u, 1064926461u, 1064926461u, 0, J0_TOLERANCE, 0},
{89, 3198072914u, 1064952558u, 1064952558u, 0, J0_TOLERANCE, 0},
{90, 3197737370u, 1064977846u, 1064977846u, 0, J0_TOLERANCE, 0},
{91, 3197401825u, 1065002325u, 1065002325u, 0, J0_TOLERANCE, 0},
{92, 3197066281u, 1065025991u, 1065025991u, 0, J0_TOLERANCE, 0},
{93, 3196730737u, 1065048842u, 1065048842u, 0, J0_TOLERANCE, 0},
{94, 3196395192u, 1065070877u, 1065070877u, 0, J0_TOLERANCE, 0},
{95, 3196059648u, 1065092094u, 1065092094u, 0, J0_TOLERANCE, 0},
{96, 3195388559u, 1065112493u, 1065112493u, 0, J0_TOLERANCE, 0},
{97, 3194717471u, 1065132069u, 1065132069u, 0, J0_TOLERANCE, 0},
{98, 3194046382u, 1065150825u, 1065150825u, 0, J0_TOLERANCE, 0},
{99, 3193375293u, 1065168757u, 1065168757u, 0, J0_TOLERANCE, 0},
{100, 3192704205u, 1065185863u, 1065185863u, 0, J0_TOLERANCE, 0},
{101, 3192033116u, 1065202143u, 1065202143u, 0, J0_TOLERANCE, 0},
{102, 3191362028u, 1065217596u, 1065217596u, 0, J0_TOLERANCE, 0},
{103, 3190690939u, 1065232219u, 1065232219u, 0, J0_TOLERANCE, 0},
{104, 3190019850u, 1065246014u, 1065246014u, 0, J0_TOLERANCE, 0},
{105, 3189348762u, 1065258977u, 1065258977u, 0, J0_TOLERANCE, 0},
{106, 3188677673u, 1065271109u, 1065271109u, 0, J0_TOLERANCE, 0},
{107, 3188006584u, 1065282406u, 1065282406u, 0, J0_TOLERANCE, 0},
{108, 3186999951u, 1065292873u, 1065292873u, 0, J0_TOLERANCE, 0},
{109, 3185657774u, 1065302503u, 1065302503u, 0, J0_TOLERANCE, 0},
{110, 3184315597u, 1065311299u, 1065311299u, 0, J0_TOLERANCE, 0},
{111, 3182973420u, 1065319259u, 1065319259u, 0, J0_TOLERANCE, 0},
{112, 3181631242u, 1065326383u, 1065326383u, 0, J0_TOLERANCE, 0},
{113, 3180289065u, 1065332670u, 1065332670u, 0, J0_TOLERANCE, 0},
{114, 3178611343u, 1065338120u, 1065338120u, 0, J0_TOLERANCE, 0},
{115, 3175926989u, 1065342731u, 1065342731u, 0, J0_TOLERANCE, 0},
{116, 3173242634u, 1065346505u, 1065346505u, 0, J0_TOLERANCE, 0},
{117, 3170222735u, 1065349441u, 1065349441u, 0, J0_TOLERANCE, 0},
{118, 3164854026u, 1065351539u, 1065351539u, 0, J0_TOLERANCE, 0},
{119, 3156465418u, 1065352797u, 1065352797u, 0, J0_TOLERANCE, 0},
{120, 1008981770u, 1065352797u, 1065352797u, 0, J0_TOLERANCE, 0},
{121, 1017370378u, 1065351539u, 1065351539u, 0, J0_TOLERANCE, 0},
{122, 1022739087u, 1065349441u, 1065349441u, 0, J0_TOLERANCE, 0},
{123, 1025758986u, 1065346505u, 1065346505u, 0, J0_TOLERANCE, 0},
{124, 1028443341u, 1065342731u, 1065342731u, 0, J0_TOLERANCE, 0},
{125, 1031127695u, 1065338120u, 1065338120u, 0, J0_TOLERANCE, 0},
{126, 1032805417u, 1065332670u, 1065332670u, 0, J0_TOLERANCE, 0},
{127, 1034147594u, 1065326383u, 1065326383u, 0, J0_TOLERANCE, 0},
{128, 1035489772u, 1065319259u, 1065319259u, 0, J0_TOLERANCE, 0},
{129, 1036831949u, 1065311299u, 1065311299u, 0, J0_TOLERANCE, 0},
{130, 1038174126u, 1065302503u, 1065302503u, 0, J0_TOLERANCE, 0},
{131, 1039516303u, 1065292873u, 1065292873u, 0, J0_TOLERANCE, 0},
{132, 1040522936u, 1065282406u, 1065282406u, 0, J0_TOLERANCE, 0},
{133, 1041194025u, 1065271109u, 1065271109u, 0, J0_TOLERANCE, 0},
{134, 1041865114u, 1065258977u, 1065258977u, 0, J0_TOLERANCE, 0},
{135, 1042536202u, 1065246014u, 1065246014u, 0, J0_TOLERANCE, 0},
{136, 1043207291u, 1065232219u, 1065232219u, 0, J0_TOLERANCE, 0},
{137, 1043878380u, 1065217596u, 1065217596u, 0, J0_TOLERANCE, 0},
{138, 1044549468u, 1065202143u, 1065202143u, 0, J0_TOLERANCE, 0},
{139, 1045220557u, 1065185863u, 1065185863u, 0, J0_TOLERANCE, 0},
{140, 1045891645u, 1065168757u, 1065168757u, 0, J0_TOLERANCE, 0},
{141, 1046562734u, 1065150825u, 1065150825u, 0, J0_TOLERANCE, 0},
{142, 1047233823u, 1065132069u, 1065132069u, 0, J0_TOLERANCE, 0},
{143, 1047904911u, 1065112493u, 1065112493u, 0, J0_TOLERANCE, 0},
{144, 1048576000u, 1065092094u, 1065092094u, 0, J0_TOLERANCE, 0},
{145, 1048911544u, 1065070877u, 1065070877u, 0, J0_TOLERANCE, 0},
{146, 1049247089u, 1065048842u, 1065048842u, 0, J0_TOLERANCE, 0},
{147, 1049582633u, 1065025991u, 1065025991u, 0, J0_TOLERANCE, 0},
{148, 1049918177u, 1065002325u, 1065002325u, 0, J0_TOLERANCE, 0},
{149, 1050253722u, 1064977846u, 1064977846u, 0, J0_TOLERANCE, 0},
{150, 1050589266u, 1064952558u, 1064952558u, 0, J0_TOLERANCE, 0},
{151, 1050924810u, 1064926461u, 1064926461u, 0, J0_TOLERANCE, 0},
{152, 1051260355u, 1064899556u, 1064899556u, 0, J0_TOLERANCE, 0},
{153, 1051595899u, 1064871847u, 1064871847u, 0, J0_TOLERANCE, 0},
{154, 1051931443u, 1064843334u, 1064843334u, 0, J0_TOLERANCE, 0},
{155, 1052266988u, 1064814022u, 1064814022u, 0, J0_TOLERANCE, 0},
{156, 1052602532u, 1064783911u, 1064783911u, 0, J0_TOLERANCE, 0},
{157, 1052938076u, 1064753003u, 1064753003u, 0, J0_TOLERANCE, 0},
{158, 1053273620u, 1064721302u, 1064721302u, 0, J0_TOLERANCE, 0},
{159, 1053609165u, 1064688809u, 1064688809u, 0, J0_TOLERANCE, 0},
{160, 1053944709u, 1064655526u, 1064655526u, 0, J0_TOLERANCE, 0},
{161, 1054280253u, 1064621459u, 1064621459u, 0, J0_TOLERANCE, 0},
{162, 1054615798u, 1064586606u, 1064586606u, 0, J0_TOLERANCE, 0},
{163, 1054951342u, 1064550972u, 1064550972u, 0, J0_TOLERANCE, 0},
{164, 1055286886u, 1064514559u, 1064514559u, 0, J0_TOLERANCE, 0},
{165, 1055622431u, 1064477370u, 1064477370u, 0, J0_TOLERANCE, 0},
{166, 1055957975u, 1064439408u, 1064439408u, 0, J0_TOLERANCE, 0},
{167, 1056293519u, 1064400675u, 1064400675u, 0, J0_TOLERANCE, 0},
{168, 1056629064u, 1064361174u, 1064361174u, 0, J0_TOLERANCE, 0},
{169, 1056964608u, 1064320911u, 1064320911u, 0, J0_TOLERANCE, 0},
{170, 1057132380u, 1064279884u, 1064279884u, 0, J0_TOLERANCE, 0},
{171, 1057300152u, 1064238100u, 1064238100u, 0, J0_TOLERANCE, 0},
{172, 1057467924u, 1064195560u, 1064195560u, 0, J0_TOLERANCE, 0},
{173, 1057635697u, 1064152266u, 1064152266u, 0, J0_TOLERANCE, 0},
{174, 1057803469u, 1064108226u, 1064108226u, 0, J0_TOLERANCE, 0},
{175, 1057971241u, 1064063439u, 1064063439u, 0, J0_TOLERANCE, 0},
{176, 1058139013u, 1064017911u, 1064017911u, 0, J0_TOLERANCE, 0},
{177, 1058306785u, 1063971642u, 1063971642u, 0, J0_TOLERANCE, 0},
{178, 1058474557u, 1063924638u, 1063924638u, 0, J0_TOLERANCE, 0},
{179, 1058642330u, 1063876903u, 1063876903u, 0, J0_TOLERANCE, 0},
{180, 1058810102u, 1063828438u, 1063828438u, 0, J0_TOLERANCE, 0},
{181, 1058977874u, 1063779249u, 1063779249u, 0, J0_TOLERANCE, 0},
{182, 1059145646u, 1063729339u, 1063729339u, 0, J0_TOLERANCE, 0},
{183, 1059313418u, 1063678713u, 1063678713u, 0, J0_TOLERANCE, 0},
{184, 1059481190u, 1063627371u, 1063627371u, 0, J0_TOLERANCE, 0},
{185, 1059648963u, 1063575320u, 1063575320u, 0, J0_TOLERANCE, 0},
{186, 1059816735u, 1063522564u, 1063522564u, 0, J0_TOLERANCE, 0},
{187, 1059984507u, 1063469104u, 1063469104u, 0, J0_TOLERANCE, 0},
{188, 1060152279u, 1063414948u, 1063414948u, 0, J0_TOLERANCE, 0},
{189, 1060320051u, 1063360098u, 1063360098u, 0, J0_TOLERANCE, 0},
{190, 1060487823u, 1063304557u, 1063304557u, 0, J0_TOLERANCE, 0},
{191, 1060655596u, 1063248330u, 1063248330u, 0, J0_TOLERANCE, 0},
{192, 1060823368u, 1063191423u, 1063191423u, 0, J0_TOLERANCE, 0},
{193, 1060991140u, 1063133838u, 1063133838u, 0, J0_TOLERANCE, 0},
{194, 1061158912u, 1063075578u, 1063075578u, 0, J0_TOLERANCE, 0},
{195, 1061326684u, 1063016653u, 1063016653u, 0, J0_TOLERANCE, 0},
{196, 1061494456u, 1062957061u, 1062957061u, 0, J0_TOLERANCE, 0},
{197, 1061662228u, 1062896811u, 1062896811u, 0, J0_TOLERANCE, 0},
{198, 1061830001u, 1062835904u, 1062835904u, 0, J0_TOLERANCE, 0},
{199, 1061997773u, 1062774345u, 1062774345u, 0, J0_TOLERANCE, 0},
{200, 1062165545u, 1062712142u, 1062712142u, 0, J0_TOLERANCE, 0},
{201, 1062333317u, 1062649297u, 1062649297u, 0, J0_TOLERANCE, 0},
{202, 1062501089u, 1062585814u, 1062585814u, 0, J0_TOLERANCE, 0},
{203, 1062668861u, 1062521700u, 1062521700u, 0, J0_TOLERANCE, 0},
{204, 1062836634u, 1062456956u, 1062456956u, 0, J0_TOLERANCE, 0},
{205, 1063004406u, 1062391591u, 1062391591u, 0, J0_TOLERANCE, 0},
{206, 1063172178u, 1062325608u, 1062325608u, 0, J0_TOLERANCE, 0},
{207, 1063339950u, 1062259012u, 1062259012u, 0, J0_TOLERANCE, 0},
{208, 1063507722u, 1062191808u, 1062191808u, 0, J0_TOLERANCE, 0},
{209, 1063675494u, 1062124001u, 1062124001u, 0, J0_TOLERANCE, 0},
{210, 1063843267u, 1062055596u, 1062055596u, 0, J0_TOLERANCE, 0},
{211, 1064011039u, 1061986598u, 1061986598u, 0, J0_TOLERANCE, 0},
{212, 1064178811u, 1061917012u, 1061917012u, 0, J0_TOLERANCE, 0},
{213, 1064346583u, 1061846843u, 1061846843u, 0, J0_TOLERANCE, 0},
{214, 1064514355u, 1061776097u, 1061776097u, 0, J0_TOLERANCE, 0},
{215, 1064682127u, 1061704777u, 1061704777u, 0, J0_TOLERANCE, 0},
{216, 1064849900u, 1061632891u, 1061632891u, 0, J0_TOLERANCE, 0},
{217, 1065017672u, 1061560445u, 1061560445u, 0, J0_TOLERANCE, 0},
{218, 1065185444u, 1061487442u, 1061487442u, 0, J0_TOLERANCE, 0},
{219, 1065353216u, 1061413887u, 1061413887u, 0, J0_TOLERANCE, 0},
{220, 1065437102u, 1061339787u, 1061339787u, 0, J0_TOLERANCE, 0},
{221, 1065520988u, 1061265147u, 1061265147u, 0, J0_TOLERANCE, 0},
{222, 1065604874u, 1061189972u, 1061189972u, 0, J0_TOLERANCE, 0},
{223, 1065688760u, 1061114269u, 1061114269u, 0, J0_TOLERANCE, 0},
{224, 1065772646u, 1061038042u, 1061038042u, 0, J0_TOLERANCE, 0},
{225, 1065856532u, 1060961298u, 1060961298u, 0, J0_TOLERANCE, 0},
{226, 1065940419u, 1060884039u, 1060884039u, 0, J0_TOLERANCE, 0},
{227, 1066024305u, 1060806276u, 1060806276u, 0, J0_TOLERANCE, 0},
{228, 1066108191u, 1060728013u, 1060728013u, 0, J0_TOLERANCE, 0},
{229, 1066192077u, 1060649254u, 1060649254u, 0, J0_TOLERANCE, 0},
{230, 1066275963u, 1060570006u, 1060570006u, 0, J0_TOLERANCE, 0},
{231, 1066359849u, 1060490274u, 1060490274u, 0, J0_TOLERANCE, 0},
{232, 1066443735u, 1060410067u, 1060410067u, 0, J0_TOLERANCE, 0},
{233, 1066527621u, 1060329386u, 1060329386u, 0, J0_TOLERANCE, 0},
{234, 1066611507u, 1060248241u, 1060248241u, 0, J0_TOLERANCE, 0},
{235, 1066695393u, 1060166635u, 1060166635u, 0, J0_TOLERANCE, 0},
{236, 1066779279u, 1060084577u, 1060084577u, 0, J0_TOLERANCE, 0},
{237, 1066863165u, 1060002071u, 1060002071u, 0, J0_TOLERANCE, 0},
{238, 1066947052u, 1059919122u, 1059919122u, 0, J0_TOLERANCE, 0},
{239, 3234402267u, 1046581329u, 1046581329u, 0, J0_TOLERANCE, 0},
{240, 3231108068u, 3196591726u, 3196591726u, 0, J0_TOLERANCE, 0},
{241, 3226013659u, 3197879715u, 3197879715u, 0, J0_TOLERANCE, 0},
{242, 3217625051u, 1056025123u, 1056025123u, 0, J0_TOLERANCE, 0},
{243, 0u, 1065353216u, 1065353216u, 0, J0_TOLERANCE, 0},
{244, 1070141403u, 1056025123u, 1056025123u, 0, J0_TOLERANCE, 0},
{245, 1078530011u, 3197879715u, 3197879715u, 0, J0_TOLERANCE, 0},
{246, 1083624420u, 3196591726u, 3196591726u, 0, J0_TOLERANCE, 0},
{247, 3253731328u, 3182485944u, 3182485944u, 0, J0_TOLERANCE, 0},
{248, 3252840038u, 3185426433u, 3185426433u, 0, J0_TOLERANCE, 0},
{249, 3251948749u, 1039591153u, 1039591153u, 0, J0_TOLERANCE, 0},
{250, 3251057459u, 1034583247u, 1034583247u, 0, J0_TOLERANCE, 0},
{251, 3250166170u, 3189440518u, 3189440518u, 0, J0_TOLERANCE, 0},
{252, 3249274880u, 3175642986u, 3175642986u, 0, J0_TOLERANCE, 0},
{253, 3248383590u, 1043678978u, 1043678978u, 0, J0_TOLERANCE, 0},
{254, 3247492301u, 1001510262u, 1001510262u, 0, J0_TOLERANCE, 0},
{255, 3246601011u, 3192434080u, 3192434080u, 0, J0_TOLERANCE, 0},
{256, 3245028147u, 1027810392u, 1027810392u, 0, J0_TOLERANCE, 0},
{257, 3243245568u, 1045685354u, 1045685354u, 0, J0_TOLERANCE, 0},
{258, 3241462989u, 3185935415u, 3185935415u, 0, J0_TOLERANCE, 0},
{259, 3239680410u, 3193306751u, 3193306751u, 0, J0_TOLERANCE, 0},
{260, 3237792973u, 1044842218u, 1044842218u, 0, J0_TOLERANCE, 0},
{261, 3234227814u, 1045337775u, 1045337775u, 0, J0_TOLERANCE, 0},
{262, 3230662656u, 3198426660u, 3198426660u, 0, J0_TOLERANCE, 0},
{263, 3224580915u, 3191699990u, 3191699990u, 0, J0_TOLERANCE, 0},
{264, 3213675725u, 1060649254u, 1060649254u, 0, J0_TOLERANCE, 0},
{265, 1058642330u, 1063876903u, 1063876903u, 0, J0_TOLERANCE, 0},
{266, 1075000115u, 1029930430u, 1029930430u, 0, J0_TOLERANCE, 0},
{267, 1082130432u, 3200997175u, 3200997175u, 0, J0_TOLERANCE, 0},
{268, 1085695590u, 1031106245u, 1031106245u, 0, J0_TOLERANCE, 0},
{269, 1089260749u, 1049535541u, 1049535541u, 0, J0_TOLERANCE, 0},
{270, 1091672474u, 3186226740u, 3186226740u, 0, J0_TOLERANCE, 0},
{271, 1093455053u, 3192919090u, 3192919090u, 0, J0_TOLERANCE, 0},
{272, 1095237632u, 1041655994u, 1041655994u, 0, J0_TOLERANCE, 0},
{273, 1097020211u, 1041285935u, 1041285935u, 0, J0_TOLERANCE, 0},
{274, 1098802790u, 3190353411u, 3190353411u, 0, J0_TOLERANCE, 0},
{275, 1099746509u, 3182480552u, 3182480552u, 0, J0_TOLERANCE, 0},
{276, 1100637798u, 1043281599u, 1043281599u, 0, J0_TOLERANCE, 0},
{277, 1101529088u, 1024840698u, 1024840698u, 0, J0_TOLERANCE, 0},
{278, 1102420378u, 3190481736u, 3190481736u, 0, J0_TOLERANCE, 0},
{279, 1103311667u, 1006337519u, 1006337519u, 0, J0_TOLERANCE, 0},
{280, 1104202957u, 1042114878u, 1042114878u, 0, J0_TOLERANCE, 0},
{281, 1105094246u, 3174763439u, 3174763439u, 0, J0_TOLERANCE, 0},
{282, 1105985536u, 3188217836u, 3188217836u, 0, J0_TOLERANCE, 0}

// AUTOMATICALLY GENERATED VECTORS STOP

};

#endif // CYGONCE_LIBM_J0_H multiple inclusion protection

// EOF j0f.h
