#ifndef CYGONCE_LIBM_ISNANF_H
#define CYGONCE_LIBM_ISNANF_H
//===========================================================================
//
//      isnanf.h
//
//      Test vectors for testing of isnanf() math library function
//
//===========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####
// -------------------------------------------
// This file is part of eCos, the Embedded Configurable Operating System.
// Copyright (C) 2012 Free Software Foundation, Inc.
//
// eCos is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 or (at your option) any later
// version.
//
// eCos is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
// for more details.
//
// You should have received a copy of the GNU General Public License
// along with eCos; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//
// As a special exception, if other files instantiate templates or use
// macros or inline functions from this file, or you compile this file
// and link it with other works to produce a work based on this file,
// this file does not by itself cause the resulting work to be covered by
// the GNU General Public License. However the source code for this file
// must still be made available in accordance with section (3) of the GNU
// General Public License v2.
//
// This exception does not invalidate any other reasons why a work based
// on this file might be covered by the GNU General Public License.
// -------------------------------------------
// ####ECOSGPLCOPYRIGHTEND####
//===========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):
// Contributors:  visar, ilijak
// Date:        1998-02-13
// Purpose:
// Description:
// Usage:       #include "vectors/isnanf.h"
//
//####DESCRIPTIONEND####
//
//===========================================================================


// CONFIGURATION

#include <pkgconf/libm.h>   // Configuration header


// INCLUDES

#include <cyg/infra/cyg_type.h>    // Common type definitions and support
#include "vectors/vector_support_float.h"// extra support for math tests

#define ISNANF_TOLERANCE 1.0E-04

static const Cyg_libm_test_float_vec_t isnanf_vec[] = {

// AUTOMATICALLY GENERATED VECTORS START

{0, 3214514586u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{1, 3214430700u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{2, 3214346813u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{3, 3214262927u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{4, 3214179041u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{5, 3214095155u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{6, 3214011269u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{7, 3213927383u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{8, 3213843497u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{9, 3213759611u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{10, 3213675725u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{11, 3213591839u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{12, 3213507953u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{13, 3213424067u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{14, 3213340180u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{15, 3213256294u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{16, 3213172408u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{17, 3213088522u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{18, 3213004636u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{19, 3212920750u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{20, 3212836864u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{21, 3212669092u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{22, 3212501320u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{23, 3212333548u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{24, 3212165775u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{25, 3211998003u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{26, 3211830231u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{27, 3211662459u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{28, 3211494687u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{29, 3211326915u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{30, 3211159142u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{31, 3210991370u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{32, 3210823598u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{33, 3210655826u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{34, 3210488054u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{35, 3210320282u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{36, 3210152509u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{37, 3209984737u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{38, 3209816965u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{39, 3209649193u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{40, 3209481421u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{41, 3209313649u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{42, 3209145876u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{43, 3208978104u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{44, 3208810332u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{45, 3208642560u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{46, 3208474788u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{47, 3208307016u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{48, 3208139244u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{49, 3207971471u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{50, 3207803699u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{51, 3207635927u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{52, 3207468155u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{53, 3207300383u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{54, 3207132611u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{55, 3206964838u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{56, 3206797066u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{57, 3206629294u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{58, 3206461522u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{59, 3206293750u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{60, 3206125978u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{61, 3205958205u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{62, 3205790433u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{63, 3205622661u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{64, 3205454889u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{65, 3205287117u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{66, 3205119345u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{67, 3204951572u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{68, 3204783800u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{69, 3204616028u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{70, 3204448256u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{71, 3204112712u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{72, 3203777167u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{73, 3203441623u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{74, 3203106079u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{75, 3202770534u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{76, 3202434990u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{77, 3202099446u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{78, 3201763901u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{79, 3201428357u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{80, 3201092813u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{81, 3200757268u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{82, 3200421724u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{83, 3200086180u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{84, 3199750636u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{85, 3199415091u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{86, 3199079547u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{87, 3198744003u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{88, 3198408458u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{89, 3198072914u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{90, 3197737370u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{91, 3197401825u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{92, 3197066281u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{93, 3196730737u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{94, 3196395192u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{95, 3196059648u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{96, 3195388559u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{97, 3194717471u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{98, 3194046382u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{99, 3193375293u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{100, 3192704205u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{101, 3192033116u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{102, 3191362028u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{103, 3190690939u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{104, 3190019850u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{105, 3189348762u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{106, 3188677673u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{107, 3188006584u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{108, 3186999951u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{109, 3185657774u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{110, 3184315597u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{111, 3182973420u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{112, 3181631242u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{113, 3180289065u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{114, 3178611343u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{115, 3175926989u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{116, 3173242634u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{117, 3170222735u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{118, 3164854026u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{119, 3156465418u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{120, 1008981770u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{121, 1017370378u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{122, 1022739087u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{123, 1025758986u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{124, 1028443341u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{125, 1031127695u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{126, 1032805417u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{127, 1034147594u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{128, 1035489772u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{129, 1036831949u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{130, 1038174126u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{131, 1039516303u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{132, 1040522936u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{133, 1041194025u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{134, 1041865114u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{135, 1042536202u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{136, 1043207291u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{137, 1043878380u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{138, 1044549468u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{139, 1045220557u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{140, 1045891645u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{141, 1046562734u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{142, 1047233823u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{143, 1047904911u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{144, 1048576000u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{145, 1048911544u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{146, 1049247089u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{147, 1049582633u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{148, 1049918177u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{149, 1050253722u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{150, 1050589266u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{151, 1050924810u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{152, 1051260355u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{153, 1051595899u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{154, 1051931443u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{155, 1052266988u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{156, 1052602532u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{157, 1052938076u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{158, 1053273620u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{159, 1053609165u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{160, 1053944709u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{161, 1054280253u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{162, 1054615798u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{163, 1054951342u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{164, 1055286886u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{165, 1055622431u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{166, 1055957975u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{167, 1056293519u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{168, 1056629064u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{169, 1056964608u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{170, 1057132380u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{171, 1057300152u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{172, 1057467924u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{173, 1057635697u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{174, 1057803469u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{175, 1057971241u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{176, 1058139013u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{177, 1058306785u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{178, 1058474557u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{179, 1058642330u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{180, 1058810102u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{181, 1058977874u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{182, 1059145646u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{183, 1059313418u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{184, 1059481190u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{185, 1059648963u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{186, 1059816735u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{187, 1059984507u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{188, 1060152279u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{189, 1060320051u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{190, 1060487823u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{191, 1060655596u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{192, 1060823368u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{193, 1060991140u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{194, 1061158912u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{195, 1061326684u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{196, 1061494456u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{197, 1061662228u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{198, 1061830001u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{199, 1061997773u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{200, 1062165545u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{201, 1062333317u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{202, 1062501089u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{203, 1062668861u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{204, 1062836634u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{205, 1063004406u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{206, 1063172178u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{207, 1063339950u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{208, 1063507722u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{209, 1063675494u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{210, 1063843267u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{211, 1064011039u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{212, 1064178811u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{213, 1064346583u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{214, 1064514355u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{215, 1064682127u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{216, 1064849900u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{217, 1065017672u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{218, 1065185444u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{219, 1065353216u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{220, 1065437102u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{221, 1065520988u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{222, 1065604874u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{223, 1065688760u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{224, 1065772646u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{225, 1065856532u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{226, 1065940419u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{227, 1066024305u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{228, 1066108191u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{229, 1066192077u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{230, 1066275963u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{231, 1066359849u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{232, 1066443735u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{233, 1066527621u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{234, 1066611507u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{235, 1066695393u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{236, 1066779279u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{237, 1066863165u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{238, 1066947052u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{239, 3234402267u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{240, 3231108068u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{241, 3226013659u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{242, 3217625051u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{243, 0u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{244, 1070141403u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{245, 1078530011u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{246, 1083624420u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{247, 3253731328u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{248, 3252840038u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{249, 3251948749u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{250, 3251057459u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{251, 3250166170u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{252, 3249274880u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{253, 3248383590u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{254, 3247492301u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{255, 3246601011u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{256, 3245028147u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{257, 3243245568u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{258, 3241462989u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{259, 3239680410u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{260, 3237792973u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{261, 3234227814u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{262, 3230662656u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{263, 3224580915u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{264, 3213675725u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{265, 1058642330u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{266, 1075000115u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{267, 1082130432u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{268, 1085695590u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{269, 1089260749u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{270, 1091672474u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{271, 1093455053u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{272, 1095237632u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{273, 1097020211u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{274, 1098802790u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{275, 1099746509u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{276, 1100637798u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{277, 1101529088u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{278, 1102420378u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{279, 1103311667u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{280, 1104202957u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{281, 1105094246u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{282, 1105985536u, 0u, 0u, 0, ISNANF_TOLERANCE, 0},
{283, 1107800421u, 1203999711u, 0u, 0, ISNANF_TOLERANCE, 0},
{284, 3196650934u, 896005582u, 0u, 0, ISNANF_TOLERANCE, 0},
{285, 3368700125u, 3308232444u, 0u, 0, ISNANF_TOLERANCE, 0},
{286, 1224242132u, 3061363425u, 0u, 0, ISNANF_TOLERANCE, 0},
{287, 3221027117u, 1284201705u, 0u, 0, ISNANF_TOLERANCE, 0},
{288, 1198712763u, 919636942u, 0u, 0, ISNANF_TOLERANCE, 0},
{289, 867432512u, 3067736756u, 0u, 0, ISNANF_TOLERANCE, 0},
{290, 3159309973u, 852521077u, 0u, 0, ISNANF_TOLERANCE, 0},
{291, 954173073u, 850531830u, 0u, 0, ISNANF_TOLERANCE, 0},
{292, 3090780435u, 1035260608u, 0u, 0, ISNANF_TOLERANCE, 0},
{293, 966554515u, 3234538174u, 0u, 0, ISNANF_TOLERANCE, 0},
{294, 1312607135u, 1194999402u, 0u, 0, ISNANF_TOLERANCE, 0},
{295, 1166191415u, 1018661564u, 0u, 0, ISNANF_TOLERANCE, 0},
{296, 3111900019u, 1130472166u, 0u, 0, ISNANF_TOLERANCE, 0},
{297, 1234419246u, 2984575812u, 0u, 0, ISNANF_TOLERANCE, 0},
{298, 1302107128u, 3370647675u, 0u, 0, ISNANF_TOLERANCE, 0},
{299, 1052801068u, 3039122570u, 0u, 0, ISNANF_TOLERANCE, 0},
{300, 1060849628u, 3081357692u, 0u, 0, ISNANF_TOLERANCE, 0},
{301, 3010214568u, 3446630737u, 0u, 0, ISNANF_TOLERANCE, 0},
{302, 3484320003u, 3033957825u, 0u, 0, ISNANF_TOLERANCE, 0},
{303, 3181522772u, 3305392896u, 0u, 0, ISNANF_TOLERANCE, 0},
{304, 882596369u, 1256676590u, 0u, 0, ISNANF_TOLERANCE, 0},
{305, 1167223673u, 846102364u, 0u, 0, ISNANF_TOLERANCE, 0},
{306, 968192794u, 878547432u, 0u, 0, ISNANF_TOLERANCE, 0},
{307, 3122346862u, 1111584337u, 0u, 0, ISNANF_TOLERANCE, 0},
{308, 1052361612u, 1280025214u, 0u, 0, ISNANF_TOLERANCE, 0},
{309, 906701409u, 2968301825u, 0u, 0, ISNANF_TOLERANCE, 0},
{310, 3471653172u, 1154138102u, 0u, 0, ISNANF_TOLERANCE, 0},
{311, 843024648u, 3166833184u, 0u, 0, ISNANF_TOLERANCE, 0},
{312, 3231467496u, 934336592u, 0u, 0, ISNANF_TOLERANCE, 0},
{313, 1341514497u, 3466051188u, 0u, 0, ISNANF_TOLERANCE, 0},
{314, 1272351391u, 3373485062u, 0u, 0, ISNANF_TOLERANCE, 0},
{315, 3319724992u, 3354615790u, 0u, 0, ISNANF_TOLERANCE, 0},
{316, 3013402113u, 3266377514u, 0u, 0, ISNANF_TOLERANCE, 0},
{317, 917622040u, 1334966485u, 0u, 0, ISNANF_TOLERANCE, 0},
{318, 940236348u, 3304072663u, 0u, 0, ISNANF_TOLERANCE, 0},
{319, 2963234879u, 977028681u, 0u, 0, ISNANF_TOLERANCE, 0},
{320, 3251541546u, 3174764041u, 0u, 0, ISNANF_TOLERANCE, 0},
{321, 3099843889u, 3355962282u, 0u, 0, ISNANF_TOLERANCE, 0},
{322, 3110358400u, 851145088u, 0u, 0, ISNANF_TOLERANCE, 0},
{323, 3371863479u, 1014861921u, 0u, 0, ISNANF_TOLERANCE, 0},
{324, 3204069187u, 966573255u, 0u, 0, ISNANF_TOLERANCE, 0},
{325, 1306460502u, 903489435u, 0u, 0, ISNANF_TOLERANCE, 0},
{326, 1197542187u, 3024598921u, 0u, 0, ISNANF_TOLERANCE, 0},
{327, 922888249u, 1139392309u, 0u, 0, ISNANF_TOLERANCE, 0},
{328, 1184239996u, 3224098462u, 0u, 0, ISNANF_TOLERANCE, 0},
{329, 1252490238u, 1173619825u, 0u, 0, ISNANF_TOLERANCE, 0},
{330, 1001673627u, 3462631271u, 0u, 0, ISNANF_TOLERANCE, 0},
{331, 976098044u, 1151967422u, 0u, 0, ISNANF_TOLERANCE, 0},
{332, 941796645u, 886451963u, 0u, 0, ISNANF_TOLERANCE, 0},
{333, 3006797923u, 1103058486u, 0u, 0, ISNANF_TOLERANCE, 0},
{334, 855756273u, 3217259624u, 0u, 0, ISNANF_TOLERANCE, 0},
{335, 3287199470u, 854245542u, 0u, 0, ISNANF_TOLERANCE, 0},
{336, 893184329u, 1243067084u, 0u, 0, ISNANF_TOLERANCE, 0},
{337, 1143233714u, 1007268238u, 0u, 0, ISNANF_TOLERANCE, 0},
{338, 1139941253u, 1147688821u, 0u, 0, ISNANF_TOLERANCE, 0},
{339, 3143717025u, 3234638157u, 0u, 0, ISNANF_TOLERANCE, 0},
{340, 3048866608u, 3449209899u, 0u, 0, ISNANF_TOLERANCE, 0},
{341, 3240298487u, 1020260821u, 0u, 0, ISNANF_TOLERANCE, 0},
{342, 1288902137u, 3123875978u, 0u, 0, ISNANF_TOLERANCE, 0},
{343, 1333134799u, 1338107877u, 0u, 0, ISNANF_TOLERANCE, 0},
{344, 1187847971u, 1317663644u, 0u, 0, ISNANF_TOLERANCE, 0},
{345, 1038851706u, 1327544110u, 0u, 0, ISNANF_TOLERANCE, 0},
{346, 3329354473u, 3165437289u, 0u, 0, ISNANF_TOLERANCE, 0},
{347, 3077218579u, 1308397879u, 0u, 0, ISNANF_TOLERANCE, 0},
{348, 1309289088u, 1019883016u, 0u, 0, ISNANF_TOLERANCE, 0},
{349, 2991550291u, 1294782875u, 0u, 0, ISNANF_TOLERANCE, 0},
{350, 3444653659u, 1279248024u, 0u, 0, ISNANF_TOLERANCE, 0},
{351, 3405585402u, 2962345057u, 0u, 0, ISNANF_TOLERANCE, 0},
{352, 3106647724u, 853848387u, 0u, 0, ISNANF_TOLERANCE, 0},
{353, 1106778573u, 3304487767u, 0u, 0, ISNANF_TOLERANCE, 0},
{354, 1140567947u, 3069174149u, 0u, 0, ISNANF_TOLERANCE, 0},
{355, 1238569473u, 873035665u, 0u, 0, ISNANF_TOLERANCE, 0},
{356, 840375965u, 3223983207u, 0u, 0, ISNANF_TOLERANCE, 0},
{357, 3154871957u, 1276671061u, 0u, 0, ISNANF_TOLERANCE, 0},
{358, 1261071232u, 1182202773u, 0u, 0, ISNANF_TOLERANCE, 0},
{359, 1175011025u, 3029705783u, 0u, 0, ISNANF_TOLERANCE, 0},
{360, 1082692850u, 1211581107u, 0u, 0, ISNANF_TOLERANCE, 0},
{361, 974547519u, 3475164509u, 0u, 0, ISNANF_TOLERANCE, 0},
{362, 3058097085u, 3104309359u, 0u, 0, ISNANF_TOLERANCE, 0},
{363, 3107252546u, 1071134451u, 0u, 0, ISNANF_TOLERANCE, 0},
{364, 3096032662u, 2976848821u, 0u, 0, ISNANF_TOLERANCE, 0},
{365, 3197942144u, 3094120030u, 0u, 0, ISNANF_TOLERANCE, 0},
{366, 3403348556u, 3184653669u, 0u, 0, ISNANF_TOLERANCE, 0},
{367, 2998032500u, 3373011130u, 0u, 0, ISNANF_TOLERANCE, 0},
{368, 3182301130u, 3460764044u, 0u, 0, ISNANF_TOLERANCE, 0},
{369, 1136411063u, 1118097422u, 0u, 0, ISNANF_TOLERANCE, 0},
{370, 3239231622u, 3302723069u, 0u, 0, ISNANF_TOLERANCE, 0},
{371, 3340615780u, 870350055u, 0u, 0, ISNANF_TOLERANCE, 0},
{372, 998567360u, 2995278691u, 0u, 0, ISNANF_TOLERANCE, 0},
{373, 3417964312u, 1321337529u, 0u, 0, ISNANF_TOLERANCE, 0},
{374, 3109481038u, 1143864063u, 0u, 0, ISNANF_TOLERANCE, 0},
{375, 1148867223u, 1256486202u, 0u, 0, ISNANF_TOLERANCE, 0},
{376, 2960983878u, 1314196594u, 0u, 0, ISNANF_TOLERANCE, 0},
{377, 989687421u, 3372681320u, 0u, 0, ISNANF_TOLERANCE, 0},
{378, 1152956913u, 3166480640u, 0u, 0, ISNANF_TOLERANCE, 0},
{379, 892922651u, 3373029087u, 0u, 0, ISNANF_TOLERANCE, 0},
{380, 1109627625u, 1314158257u, 0u, 0, ISNANF_TOLERANCE, 0},
{381, 1307091856u, 1103202538u, 0u, 0, ISNANF_TOLERANCE, 0},
{382, 1077234132u, 3272167130u, 0u, 0, ISNANF_TOLERANCE, 0},
{383, 1142167709u, 1096445242u, 0u, 0, ISNANF_TOLERANCE, 0},
{384, 3426232834u, 1036705270u, 0u, 0, ISNANF_TOLERANCE, 0},
{385, 3000726366u, 3172023300u, 0u, 0, ISNANF_TOLERANCE, 0},
{386, 3368566779u, 967249167u, 0u, 0, ISNANF_TOLERANCE, 0},
{387, 3030724760u, 3349013503u, 0u, 0, ISNANF_TOLERANCE, 0},
{388, 1138741813u, 3073453199u, 0u, 0, ISNANF_TOLERANCE, 0},
{389, 982950501u, 982549888u, 0u, 0, ISNANF_TOLERANCE, 0},
{390, 1142981585u, 1015602236u, 0u, 0, ISNANF_TOLERANCE, 0},
{391, 3016453868u, 3365560001u, 0u, 0, ISNANF_TOLERANCE, 0},
{392, 3347165962u, 3135486696u, 0u, 0, ISNANF_TOLERANCE, 0},
{393, 1009535440u, 3381353228u, 0u, 0, ISNANF_TOLERANCE, 0},
{394, 3103736980u, 3402950505u, 0u, 0, ISNANF_TOLERANCE, 0},
{395, 3126820946u, 1077903063u, 0u, 0, ISNANF_TOLERANCE, 0},
{396, 3473956030u, 976891930u, 0u, 0, ISNANF_TOLERANCE, 0},
{397, 3349098349u, 1055327704u, 0u, 0, ISNANF_TOLERANCE, 0},
{398, 3152729489u, 1060398533u, 0u, 0, ISNANF_TOLERANCE, 0},
{399, 945568720u, 3313485084u, 0u, 0, ISNANF_TOLERANCE, 0},
{400, 3345489836u, 1108392401u, 0u, 0, ISNANF_TOLERANCE, 0},
{401, 940893161u, 1137000140u, 0u, 0, ISNANF_TOLERANCE, 0},
{402, 976791751u, 3230678102u, 0u, 0, ISNANF_TOLERANCE, 0},
{403, 3013749677u, 1324802687u, 0u, 0, ISNANF_TOLERANCE, 0},
{404, 1004442355u, 3036510596u, 0u, 0, ISNANF_TOLERANCE, 0},
{405, 1108485380u, 3173536878u, 0u, 0, ISNANF_TOLERANCE, 0},
{406, 1061834641u, 972388096u, 0u, 0, ISNANF_TOLERANCE, 0},
{407, 3381268392u, 1146976802u, 0u, 0, ISNANF_TOLERANCE, 0},
{408, 1087189715u, 2952822478u, 0u, 0, ISNANF_TOLERANCE, 0},
{409, 3212952285u, 3329407365u, 0u, 0, ISNANF_TOLERANCE, 0},
{410, 1000611335u, 857599439u, 0u, 0, ISNANF_TOLERANCE, 0},
{411, 847191250u, 1227905777u, 0u, 0, ISNANF_TOLERANCE, 0},
{412, 3466188568u, 1041678304u, 0u, 0, ISNANF_TOLERANCE, 0},
{413, 2968337765u, 3091399866u, 0u, 0, ISNANF_TOLERANCE, 0},
{414, 3072456205u, 3160254633u, 0u, 0, ISNANF_TOLERANCE, 0},
{415, 3319315516u, 3422089012u, 0u, 0, ISNANF_TOLERANCE, 0},
{416, 935938416u, 1146676692u, 0u, 0, ISNANF_TOLERANCE, 0},
{417, 3212614372u, 1152633030u, 0u, 0, ISNANF_TOLERANCE, 0},
{418, 1315030230u, 3336225884u, 0u, 0, ISNANF_TOLERANCE, 0},
{419, 822041816u, 898402905u, 0u, 0, ISNANF_TOLERANCE, 0},
{420, 1134593658u, 3456812581u, 0u, 0, ISNANF_TOLERANCE, 0},
{421, 977281449u, 879922831u, 0u, 0, ISNANF_TOLERANCE, 0},
{422, 1086198791u, 920125958u, 0u, 0, ISNANF_TOLERANCE, 0},
{423, 1255152035u, 851754050u, 0u, 0, ISNANF_TOLERANCE, 0},
{424, 1135271264u, 3284878412u, 0u, 0, ISNANF_TOLERANCE, 0},
{425, 1094190727u, 1056854532u, 0u, 0, ISNANF_TOLERANCE, 0},
{426, 1294665325u, 991185677u, 0u, 0, ISNANF_TOLERANCE, 0},
{427, 1036608591u, 805416536u, 0u, 0, ISNANF_TOLERANCE, 0},
{428, 2960459834u, 1296239160u, 0u, 0, ISNANF_TOLERANCE, 0},
{429, 3229998064u, 825237063u, 0u, 0, ISNANF_TOLERANCE, 0},
{430, 3439134022u, 1043829691u, 0u, 0, ISNANF_TOLERANCE, 0},
{431, 3073083133u, 1317170485u, 0u, 0, ISNANF_TOLERANCE, 0},
{432, 1325668223u, 970681762u, 0u, 0, ISNANF_TOLERANCE, 0},
{433, 1092037607u, 1027330835u, 0u, 0, ISNANF_TOLERANCE, 0},
{434, 826457956u, 3343511749u, 0u, 0, ISNANF_TOLERANCE, 0},
{435, 3316278408u, 3455589207u, 0u, 0, ISNANF_TOLERANCE, 0},
{436, 3295436768u, 3129873731u, 0u, 0, ISNANF_TOLERANCE, 0},
{437, 1151984049u, 3074547120u, 0u, 0, ISNANF_TOLERANCE, 0},
{438, 1129287043u, 3076527544u, 0u, 0, ISNANF_TOLERANCE, 0},
{439, 1243664530u, 972879810u, 0u, 0, ISNANF_TOLERANCE, 0},
{440, 950829092u, 929114193u, 0u, 0, ISNANF_TOLERANCE, 0},
{441, 1115471979u, 3047246262u, 0u, 0, ISNANF_TOLERANCE, 0},
{442, 3351092088u, 3024661404u, 0u, 0, ISNANF_TOLERANCE, 0},
{443, 3424479544u, 3312047722u, 0u, 0, ISNANF_TOLERANCE, 0},
{444, 3241193975u, 884465785u, 0u, 0, ISNANF_TOLERANCE, 0},
{445, 811700241u, 3478509398u, 0u, 0, ISNANF_TOLERANCE, 0},
{446, 1030934236u, 1045139240u, 0u, 0, ISNANF_TOLERANCE, 0},
{447, 3131791114u, 3408392958u, 0u, 0, ISNANF_TOLERANCE, 0},
{448, 1025254314u, 3057812821u, 0u, 0, ISNANF_TOLERANCE, 0},
{449, 1110545760u, 3240144177u, 0u, 0, ISNANF_TOLERANCE, 0},
{450, 826998191u, 1091496527u, 0u, 0, ISNANF_TOLERANCE, 0},
{451, 3180213739u, 1108793820u, 0u, 0, ISNANF_TOLERANCE, 0},
{452, 3361976590u, 3138179993u, 0u, 0, ISNANF_TOLERANCE, 0},
{453, 881280146u, 3421884736u, 0u, 0, ISNANF_TOLERANCE, 0},
{454, 1304154705u, 2961937089u, 0u, 0, ISNANF_TOLERANCE, 0},
{455, 3264443610u, 3222916705u, 0u, 0, ISNANF_TOLERANCE, 0},
{456, 3374550627u, 3055856293u, 0u, 0, ISNANF_TOLERANCE, 0},
{457, 2979664918u, 3365394784u, 0u, 0, ISNANF_TOLERANCE, 0},
{458, 899599265u, 3240118211u, 0u, 0, ISNANF_TOLERANCE, 0},
{459, 842476444u, 3452685905u, 0u, 0, ISNANF_TOLERANCE, 0},
{460, 1268194719u, 1332489410u, 0u, 0, ISNANF_TOLERANCE, 0},
{461, 1133420220u, 1245770860u, 0u, 0, ISNANF_TOLERANCE, 0},
{462, 1161858787u, 815362075u, 0u, 0, ISNANF_TOLERANCE, 0},
{463, 3184462258u, 1263529646u, 0u, 0, ISNANF_TOLERANCE, 0},
{464, 3295996963u, 3453334307u, 0u, 0, ISNANF_TOLERANCE, 0},
{465, 1270887389u, 1156123987u, 0u, 0, ISNANF_TOLERANCE, 0},
{466, 3325193181u, 993979179u, 0u, 0, ISNANF_TOLERANCE, 0},
{467, 925657343u, 1315159742u, 0u, 0, ISNANF_TOLERANCE, 0},
{468, 3115275450u, 3008350271u, 0u, 0, ISNANF_TOLERANCE, 0},
{469, 3116607482u, 3224327456u, 0u, 0, ISNANF_TOLERANCE, 0},
{470, 3187892415u, 3118097315u, 0u, 0, ISNANF_TOLERANCE, 0},
{471, 1189120494u, 978961471u, 0u, 0, ISNANF_TOLERANCE, 0},
{472, 889030794u, 3129523970u, 0u, 0, ISNANF_TOLERANCE, 0},
{473, 1323529208u, 3100744786u, 0u, 0, ISNANF_TOLERANCE, 0},
{474, 2975945347u, 940445933u, 0u, 0, ISNANF_TOLERANCE, 0},
{475, 3465768388u, 3190881451u, 0u, 0, ISNANF_TOLERANCE, 0},
{476, 3426099899u, 1118756120u, 0u, 0, ISNANF_TOLERANCE, 0},
{477, 3224857113u, 3398166843u, 0u, 0, ISNANF_TOLERANCE, 0},
{478, 1065798296u, 816191940u, 0u, 0, ISNANF_TOLERANCE, 0},
{479, 3328989444u, 850266225u, 0u, 0, ISNANF_TOLERANCE, 0},
{480, 3357819026u, 3148475462u, 0u, 0, ISNANF_TOLERANCE, 0},
{481, 1273397670u, 901308750u, 0u, 0, ISNANF_TOLERANCE, 0},
{482, 3424831780u, 1304806106u, 0u, 0, ISNANF_TOLERANCE, 0},
{483, 1257596246u, 3420832544u, 0u, 0, ISNANF_TOLERANCE, 0},
{484, 1051773536u, 896271348u, 0u, 0, ISNANF_TOLERANCE, 0},
{485, 3294752507u, 3113225954u, 0u, 0, ISNANF_TOLERANCE, 0},
{486, 3424848725u, 2973850350u, 0u, 0, ISNANF_TOLERANCE, 0},
{487, 1090870906u, 3294742905u, 0u, 0, ISNANF_TOLERANCE, 0},
{488, 1227582289u, 1208979668u, 0u, 0, ISNANF_TOLERANCE, 0},
{489, 2996780709u, 852318215u, 0u, 0, ISNANF_TOLERANCE, 0},
{490, 1272325814u, 3004311296u, 0u, 0, ISNANF_TOLERANCE, 0},
{491, 3359508271u, 859974315u, 0u, 0, ISNANF_TOLERANCE, 0},
{492, 2992737514u, 2999023943u, 0u, 0, ISNANF_TOLERANCE, 0},
{493, 1137854355u, 3335041917u, 0u, 0, ISNANF_TOLERANCE, 0},
{494, 3440773058u, 3204192793u, 0u, 0, ISNANF_TOLERANCE, 0},
{495, 3101598400u, 3057760708u, 0u, 0, ISNANF_TOLERANCE, 0},
{496, 3451216836u, 3347783723u, 0u, 0, ISNANF_TOLERANCE, 0},
{497, 3437062994u, 3106834845u, 0u, 0, ISNANF_TOLERANCE, 0},
{498, 1131196082u, 1164573183u, 0u, 0, ISNANF_TOLERANCE, 0},
{499, 3177294154u, 1282436638u, 0u, 0, ISNANF_TOLERANCE, 0},
{500, 3258097678u, 1305882290u, 0u, 0, ISNANF_TOLERANCE, 0},
{501, 3460915348u, 1219372260u, 0u, 0, ISNANF_TOLERANCE, 0},
{502, 3009547195u, 1256074626u, 0u, 0, ISNANF_TOLERANCE, 0},
{503, 3303035472u, 3153013020u, 0u, 0, ISNANF_TOLERANCE, 0},
{504, 1053698677u, 3284313107u, 0u, 0, ISNANF_TOLERANCE, 0},
{505, 3396166221u, 1201894512u, 0u, 0, ISNANF_TOLERANCE, 0},
{506, 3037541131u, 1085398440u, 0u, 0, ISNANF_TOLERANCE, 0},
{507, 3458934263u, 1005577835u, 0u, 0, ISNANF_TOLERANCE, 0},
{508, 1065761827u, 3333928591u, 0u, 0, ISNANF_TOLERANCE, 0},
{509, 3025843188u, 820250112u, 0u, 0, ISNANF_TOLERANCE, 0},
{510, 3017430347u, 3009209071u, 0u, 0, ISNANF_TOLERANCE, 0},
{511, 926665223u, 3150815797u, 0u, 0, ISNANF_TOLERANCE, 0},
{512, 2970966181u, 3383521344u, 0u, 0, ISNANF_TOLERANCE, 0},
{513, 1199816046u, 3143776186u, 0u, 0, ISNANF_TOLERANCE, 0},
{514, 3333779015u, 952421041u, 0u, 0, ISNANF_TOLERANCE, 0},
{515, 856234019u, 3091454180u, 0u, 0, ISNANF_TOLERANCE, 0},
{516, 948398145u, 3238273189u, 0u, 0, ISNANF_TOLERANCE, 0},
{517, 3054021468u, 1270257895u, 0u, 0, ISNANF_TOLERANCE, 0},
{518, 1080781593u, 1213908300u, 0u, 0, ISNANF_TOLERANCE, 0},
{519, 3164749613u, 3010837763u, 0u, 0, ISNANF_TOLERANCE, 0},
{520, 2971341371u, 1014754300u, 0u, 0, ISNANF_TOLERANCE, 0},
{521, 3235326590u, 1271705594u, 0u, 0, ISNANF_TOLERANCE, 0},
{522, 3118883815u, 1051802647u, 0u, 0, ISNANF_TOLERANCE, 0},
{523, 965378004u, 1292594138u, 0u, 0, ISNANF_TOLERANCE, 0},
{524, 3226990408u, 1110755136u, 0u, 0, ISNANF_TOLERANCE, 0},
{525, 2953069847u, 3293953199u, 0u, 0, ISNANF_TOLERANCE, 0},
{526, 3117098218u, 1122474770u, 0u, 0, ISNANF_TOLERANCE, 0},
{527, 1283624229u, 906796922u, 0u, 0, ISNANF_TOLERANCE, 0},
{528, 860729004u, 1163935062u, 0u, 0, ISNANF_TOLERANCE, 0},
{529, 970649315u, 1078286437u, 0u, 0, ISNANF_TOLERANCE, 0},
{530, 959776291u, 3280345347u, 0u, 0, ISNANF_TOLERANCE, 0},
{531, 3341117305u, 3294559023u, 0u, 0, ISNANF_TOLERANCE, 0},
{532, 1270734970u, 3355874874u, 0u, 0, ISNANF_TOLERANCE, 0},
{533, 3454816067u, 868771977u, 0u, 0, ISNANF_TOLERANCE, 0},
{534, 917206623u, 1172710814u, 0u, 0, ISNANF_TOLERANCE, 0},
{535, 1106502045u, 1290849316u, 0u, 0, ISNANF_TOLERANCE, 0},
{536, 1157598381u, 3309023746u, 0u, 0, ISNANF_TOLERANCE, 0},
{537, 835476614u, 1092590501u, 0u, 0, ISNANF_TOLERANCE, 0},
{538, 3335234513u, 1002337336u, 0u, 0, ISNANF_TOLERANCE, 0},
{539, 1279489061u, 1006049444u, 0u, 0, ISNANF_TOLERANCE, 0},
{540, 807133892u, 1110992491u, 0u, 0, ISNANF_TOLERANCE, 0},
{541, 3157416480u, 1309984610u, 0u, 0, ISNANF_TOLERANCE, 0},
{542, 3143920719u, 3131608518u, 0u, 0, ISNANF_TOLERANCE, 0},
{543, 2995340689u, 1165036009u, 0u, 0, ISNANF_TOLERANCE, 0},
{544, 1233171235u, 826460580u, 0u, 0, ISNANF_TOLERANCE, 0},
{545, 1148920078u, 1007674793u, 0u, 0, ISNANF_TOLERANCE, 0},
{546, 3064988156u, 3230867340u, 0u, 0, ISNANF_TOLERANCE, 0},
{547, 3083619260u, 1159415661u, 0u, 0, ISNANF_TOLERANCE, 0},
{548, 1109198803u, 1221754614u, 0u, 0, ISNANF_TOLERANCE, 0},
{549, 3219949483u, 1056167693u, 0u, 0, ISNANF_TOLERANCE, 0},
{550, 3361149474u, 3387342069u, 0u, 0, ISNANF_TOLERANCE, 0},
{551, 827931800u, 1118474231u, 0u, 0, ISNANF_TOLERANCE, 0},
{552, 1207502108u, 3388073586u, 0u, 0, ISNANF_TOLERANCE, 0},
{553, 1000014431u, 831213088u, 0u, 0, ISNANF_TOLERANCE, 0},
{554, 3161756316u, 3143659754u, 0u, 0, ISNANF_TOLERANCE, 0},
{555, 3160728744u, 3382954009u, 0u, 0, ISNANF_TOLERANCE, 0},
{556, 1234530539u, 1079988872u, 0u, 0, ISNANF_TOLERANCE, 0},
{557, 1017843965u, 1193076204u, 0u, 0, ISNANF_TOLERANCE, 0},
{558, 2965746635u, 3248194237u, 0u, 0, ISNANF_TOLERANCE, 0},
{559, 951862956u, 1173464654u, 0u, 0, ISNANF_TOLERANCE, 0},
{560, 3306328852u, 1118701064u, 0u, 0, ISNANF_TOLERANCE, 0},
{561, 1291910469u, 1211303367u, 0u, 0, ISNANF_TOLERANCE, 0},
{562, 3027442905u, 1173894400u, 0u, 0, ISNANF_TOLERANCE, 0},
{563, 809646928u, 3006525025u, 0u, 0, ISNANF_TOLERANCE, 0},
{564, 1131927531u, 3182962700u, 0u, 0, ISNANF_TOLERANCE, 0},
{565, 3449879391u, 991614550u, 0u, 0, ISNANF_TOLERANCE, 0},
{566, 970094304u, 3344590506u, 0u, 0, ISNANF_TOLERANCE, 0},
{567, 1125551064u, 3331248076u, 0u, 0, ISNANF_TOLERANCE, 0},
{568, 3427296372u, 3455289118u, 0u, 0, ISNANF_TOLERANCE, 0},
{569, 1198917460u, 1327195159u, 0u, 0, ISNANF_TOLERANCE, 0},
{570, 3201603336u, 820047343u, 0u, 0, ISNANF_TOLERANCE, 0},
{571, 3114686212u, 3476082461u, 0u, 0, ISNANF_TOLERANCE, 0},
{572, 921940707u, 2967544056u, 0u, 0, ISNANF_TOLERANCE, 0},
{573, 1091906532u, 3011904455u, 0u, 0, ISNANF_TOLERANCE, 0},
{574, 3393557778u, 3383396815u, 0u, 0, ISNANF_TOLERANCE, 0},
{575, 1276853215u, 873199561u, 0u, 0, ISNANF_TOLERANCE, 0},
{576, 3462778440u, 3349284325u, 0u, 0, ISNANF_TOLERANCE, 0},
{577, 833132358u, 3470358002u, 0u, 0, ISNANF_TOLERANCE, 0},
{578, 3360170117u, 3048354042u, 0u, 0, ISNANF_TOLERANCE, 0},
{579, 3224245428u, 3271307999u, 0u, 0, ISNANF_TOLERANCE, 0},
{580, 1120124467u, 1135619937u, 0u, 0, ISNANF_TOLERANCE, 0},
{581, 1064364381u, 3180675544u, 0u, 0, ISNANF_TOLERANCE, 0},
{582, 1268744779u, 3328452652u, 0u, 0, ISNANF_TOLERANCE, 0},
{583, 1165195428u, 3390323168u, 0u, 0, ISNANF_TOLERANCE, 0},
{584, 3044092739u, 1106497311u, 0u, 0, ISNANF_TOLERANCE, 0},
{585, 3149469534u, 1278465842u, 0u, 0, ISNANF_TOLERANCE, 0},
{586, 3247790039u, 909788142u, 0u, 0, ISNANF_TOLERANCE, 0},
{587, 3215244648u, 1083988595u, 0u, 0, ISNANF_TOLERANCE, 0},
{588, 3095275931u, 989153382u, 0u, 0, ISNANF_TOLERANCE, 0},
{589, 3059688264u, 1117455718u, 0u, 0, ISNANF_TOLERANCE, 0},
{590, 2990022513u, 1061714285u, 0u, 0, ISNANF_TOLERANCE, 0},
{591, 1212717473u, 837873779u, 0u, 0, ISNANF_TOLERANCE, 0},
{592, 3275973009u, 3450721670u, 0u, 0, ISNANF_TOLERANCE, 0},
{593, 3028857014u, 3188853813u, 0u, 0, ISNANF_TOLERANCE, 0},
{594, 3391162308u, 1291220039u, 0u, 0, ISNANF_TOLERANCE, 0},
{595, 1044867873u, 3369493273u, 0u, 0, ISNANF_TOLERANCE, 0},
{596, 1089986803u, 3462160118u, 0u, 0, ISNANF_TOLERANCE, 0},
{597, 1296314700u, 2957454177u, 0u, 0, ISNANF_TOLERANCE, 0},
{598, 1251462432u, 3171021770u, 0u, 0, ISNANF_TOLERANCE, 0},
{599, 3485236902u, 980772835u, 0u, 0, ISNANF_TOLERANCE, 0},
{600, 3262169538u, 1268270462u, 0u, 0, ISNANF_TOLERANCE, 0},
{601, 3080852256u, 994641495u, 0u, 0, ISNANF_TOLERANCE, 0},
{602, 1022211242u, 922124181u, 0u, 0, ISNANF_TOLERANCE, 0},
{603, 884661176u, 2985540645u, 0u, 0, ISNANF_TOLERANCE, 0},
{604, 3071422941u, 3271100396u, 0u, 0, ISNANF_TOLERANCE, 0},
{605, 989762529u, 3362011135u, 0u, 0, ISNANF_TOLERANCE, 0},
{606, 1295475718u, 3212305413u, 0u, 0, ISNANF_TOLERANCE, 0},
{607, 1002632518u, 3330388441u, 0u, 0, ISNANF_TOLERANCE, 0},
{608, 3404372005u, 3450484255u, 0u, 0, ISNANF_TOLERANCE, 0},
{609, 3158912530u, 3105501826u, 0u, 0, ISNANF_TOLERANCE, 0},
{610, 2987029985u, 1218447414u, 0u, 0, ISNANF_TOLERANCE, 0},
{611, 1125800069u, 3256265749u, 0u, 0, ISNANF_TOLERANCE, 0},
{612, 3138037576u, 3103365227u, 0u, 0, ISNANF_TOLERANCE, 0},
{613, 3108384823u, 1300246663u, 0u, 0, ISNANF_TOLERANCE, 0},
{614, 999985470u, 3409354318u, 0u, 0, ISNANF_TOLERANCE, 0},
{615, 1189421739u, 1056599002u, 0u, 0, ISNANF_TOLERANCE, 0},
{616, 3075182644u, 3144159778u, 0u, 0, ISNANF_TOLERANCE, 0},
{617, 3028099649u, 3391513557u, 0u, 0, ISNANF_TOLERANCE, 0},
{618, 837703706u, 3467473756u, 0u, 0, ISNANF_TOLERANCE, 0},
{619, 3132541814u, 3444521949u, 0u, 0, ISNANF_TOLERANCE, 0},
{620, 1164046161u, 3440635788u, 0u, 0, ISNANF_TOLERANCE, 0},
{621, 1292596266u, 3116569667u, 0u, 0, ISNANF_TOLERANCE, 0},
{622, 3469748379u, 3412765608u, 0u, 0, ISNANF_TOLERANCE, 0},
{623, 2968771722u, 3117531540u, 0u, 0, ISNANF_TOLERANCE, 0},
{624, 1314644642u, 3123051784u, 0u, 0, ISNANF_TOLERANCE, 0},
{625, 3399813173u, 828743798u, 0u, 0, ISNANF_TOLERANCE, 0},
{626, 948775569u, 3485444126u, 0u, 0, ISNANF_TOLERANCE, 0},
{627, 1034611395u, 882288581u, 0u, 0, ISNANF_TOLERANCE, 0},
{628, 3489122735u, 3372450889u, 0u, 0, ISNANF_TOLERANCE, 0},
{629, 1181604787u, 3363067409u, 0u, 0, ISNANF_TOLERANCE, 0},
{630, 3059042077u, 3204983963u, 0u, 0, ISNANF_TOLERANCE, 0},
{631, 1043691622u, 3402603223u, 0u, 0, ISNANF_TOLERANCE, 0},
{632, 1314588083u, 856187848u, 0u, 0, ISNANF_TOLERANCE, 0},
{633, 3141533334u, 3010142974u, 0u, 0, ISNANF_TOLERANCE, 0},
{634, 3013416703u, 3442525943u, 0u, 0, ISNANF_TOLERANCE, 0},
{635, 861266716u, 822172554u, 0u, 0, ISNANF_TOLERANCE, 0},
{636, 3157534378u, 3451674717u, 0u, 0, ISNANF_TOLERANCE, 0},
{637, 2976169000u, 3033697153u, 0u, 0, ISNANF_TOLERANCE, 0},
{638, 3400949680u, 3073750220u, 0u, 0, ISNANF_TOLERANCE, 0},
{639, 3365581801u, 1175843167u, 0u, 0, ISNANF_TOLERANCE, 0},
{640, 1110424755u, 3011308654u, 0u, 0, ISNANF_TOLERANCE, 0},
{641, 3189917167u, 927278934u, 0u, 0, ISNANF_TOLERANCE, 0},
{642, 969804941u, 3355439348u, 0u, 0, ISNANF_TOLERANCE, 0},
{643, 1139120919u, 3270515074u, 0u, 0, ISNANF_TOLERANCE, 0},
{644, 816789141u, 3325199970u, 0u, 0, ISNANF_TOLERANCE, 0},
{645, 934308144u, 3118191228u, 0u, 0, ISNANF_TOLERANCE, 0},
{646, 1220524226u, 1152648002u, 0u, 0, ISNANF_TOLERANCE, 0},
{647, 3162548604u, 3461790298u, 0u, 0, ISNANF_TOLERANCE, 0},
{648, 3382391700u, 3296962745u, 0u, 0, ISNANF_TOLERANCE, 0},
{649, 1156767533u, 1088986462u, 0u, 0, ISNANF_TOLERANCE, 0},
{650, 3079222483u, 3312324949u, 0u, 0, ISNANF_TOLERANCE, 0},
{651, 994934087u, 967678094u, 0u, 0, ISNANF_TOLERANCE, 0},
{652, 840906467u, 3156591981u, 0u, 0, ISNANF_TOLERANCE, 0},
{653, 3185240099u, 1123403720u, 0u, 0, ISNANF_TOLERANCE, 0},
{654, 870026344u, 1093936408u, 0u, 0, ISNANF_TOLERANCE, 0},
{655, 2996887005u, 3287317742u, 0u, 0, ISNANF_TOLERANCE, 0},
{656, 3479873563u, 1246277393u, 0u, 0, ISNANF_TOLERANCE, 0},
{657, 3424264117u, 3434026174u, 0u, 0, ISNANF_TOLERANCE, 0},
{658, 3228365887u, 1216775310u, 0u, 0, ISNANF_TOLERANCE, 0},
{659, 1035909900u, 1249532942u, 0u, 0, ISNANF_TOLERANCE, 0},
{660, 2989750574u, 1274271338u, 0u, 0, ISNANF_TOLERANCE, 0},
{661, 3024951184u, 1247632131u, 0u, 0, ISNANF_TOLERANCE, 0},
{662, 1212129651u, 3017366784u, 0u, 0, ISNANF_TOLERANCE, 0},
{663, 3125775254u, 955826310u, 0u, 0, ISNANF_TOLERANCE, 0},
{664, 1037464105u, 3121544932u, 0u, 0, ISNANF_TOLERANCE, 0},
{665, 1311706596u, 1254918706u, 0u, 0, ISNANF_TOLERANCE, 0},
{666, 918212457u, 1017468331u, 0u, 0, ISNANF_TOLERANCE, 0},
{667, 1337315179u, 3461361185u, 0u, 0, ISNANF_TOLERANCE, 0},
{668, 1131358407u, 3325958870u, 0u, 0, ISNANF_TOLERANCE, 0},
{669, 1156517523u, 3343716230u, 0u, 0, ISNANF_TOLERANCE, 0},
{670, 3210802820u, 3207408574u, 0u, 0, ISNANF_TOLERANCE, 0},
{671, 3337499209u, 1226297264u, 0u, 0, ISNANF_TOLERANCE, 0},
{672, 3468429030u, 3253874001u, 0u, 0, ISNANF_TOLERANCE, 0},
{673, 3253515800u, 1189005947u, 0u, 0, ISNANF_TOLERANCE, 0},
{674, 3055299953u, 3047908678u, 0u, 0, ISNANF_TOLERANCE, 0},
{675, 959956547u, 876324728u, 0u, 0, ISNANF_TOLERANCE, 0},
{676, 3425290480u, 1139193797u, 0u, 0, ISNANF_TOLERANCE, 0},
{677, 1039917375u, 1122740999u, 0u, 0, ISNANF_TOLERANCE, 0},
{678, 3220979495u, 3429223871u, 0u, 0, ISNANF_TOLERANCE, 0},
{679, 1311016004u, 3334899880u, 0u, 0, ISNANF_TOLERANCE, 0},
{680, 2995451172u, 2974546424u, 0u, 0, ISNANF_TOLERANCE, 0},
{681, 1128016396u, 1105151547u, 0u, 0, ISNANF_TOLERANCE, 0},
{682, 3210335769u, 3100646155u, 0u, 0, ISNANF_TOLERANCE, 0},
{683, 3022705759u, 3404762495u, 0u, 0, ISNANF_TOLERANCE, 0},
{684, 1206054701u, 826010009u, 0u, 0, ISNANF_TOLERANCE, 0},
{685, 3144504834u, 1162227076u, 0u, 0, ISNANF_TOLERANCE, 0},
{686, 822524010u, 970745811u, 0u, 0, ISNANF_TOLERANCE, 0},
{687, 3016981460u, 3313826904u, 0u, 0, ISNANF_TOLERANCE, 0},
{688, 1213609983u, 919983950u, 0u, 0, ISNANF_TOLERANCE, 0},
{689, 1246902946u, 3064047808u, 0u, 0, ISNANF_TOLERANCE, 0},
{690, 995850843u, 1332031130u, 0u, 0, ISNANF_TOLERANCE, 0},
{691, 3362082828u, 3374056268u, 0u, 0, ISNANF_TOLERANCE, 0},
{692, 1029480631u, 3047777170u, 0u, 0, ISNANF_TOLERANCE, 0},
{693, 3153568584u, 3106514232u, 0u, 0, ISNANF_TOLERANCE, 0},
{694, 3384988527u, 3109485565u, 0u, 0, ISNANF_TOLERANCE, 0},
{695, 1317696241u, 870681806u, 0u, 0, ISNANF_TOLERANCE, 0},
{696, 3235395924u, 1132055244u, 0u, 0, ISNANF_TOLERANCE, 0},
{697, 3341877624u, 2969495570u, 0u, 0, ISNANF_TOLERANCE, 0},
{698, 1228636133u, 886552820u, 0u, 0, ISNANF_TOLERANCE, 0},
{699, 3161654634u, 3335899347u, 0u, 0, ISNANF_TOLERANCE, 0},
{700, 3162655243u, 3307203982u, 0u, 0, ISNANF_TOLERANCE, 0},
{701, 1207246237u, 859223639u, 0u, 0, ISNANF_TOLERANCE, 0},
{702, 1165476654u, 3350219111u, 0u, 0, ISNANF_TOLERANCE, 0},
{703, 1215278023u, 3019755242u, 0u, 0, ISNANF_TOLERANCE, 0},
{704, 1017239798u, 3438501281u, 0u, 0, ISNANF_TOLERANCE, 0},
{705, 1149651309u, 970030475u, 0u, 0, ISNANF_TOLERANCE, 0},
{706, 1111943722u, 3122211334u, 0u, 0, ISNANF_TOLERANCE, 0},
{707, 856374764u, 1158358450u, 0u, 0, ISNANF_TOLERANCE, 0},
{708, 1189849849u, 3382739134u, 0u, 0, ISNANF_TOLERANCE, 0},
{709, 3204848496u, 3141519085u, 0u, 0, ISNANF_TOLERANCE, 0},
{710, 1249758327u, 3104759211u, 0u, 0, ISNANF_TOLERANCE, 0},
{711, 3092982276u, 3445282331u, 0u, 0, ISNANF_TOLERANCE, 0},
{712, 1168098747u, 1316854744u, 0u, 0, ISNANF_TOLERANCE, 0},
{713, 892549317u, 1179637545u, 0u, 0, ISNANF_TOLERANCE, 0},
{714, 3301009024u, 3406174560u, 0u, 0, ISNANF_TOLERANCE, 0},
{715, 3233089227u, 1212652543u, 0u, 0, ISNANF_TOLERANCE, 0},
{716, 3218245284u, 1238873830u, 0u, 0, ISNANF_TOLERANCE, 0},
{717, 3215981890u, 3240474694u, 0u, 0, ISNANF_TOLERANCE, 0},
{718, 1266687209u, 3092038122u, 0u, 0, ISNANF_TOLERANCE, 0},
{719, 825230580u, 3410090781u, 0u, 0, ISNANF_TOLERANCE, 0},
{720, 3487959775u, 3331372071u, 0u, 0, ISNANF_TOLERANCE, 0},
{721, 943645710u, 852875779u, 0u, 0, ISNANF_TOLERANCE, 0},
{722, 3345065699u, 3282620725u, 0u, 0, ISNANF_TOLERANCE, 0},
{723, 935847271u, 1067255804u, 0u, 0, ISNANF_TOLERANCE, 0},
{724, 3410336089u, 1111437780u, 0u, 0, ISNANF_TOLERANCE, 0},
{725, 3082940740u, 1336840432u, 0u, 0, ISNANF_TOLERANCE, 0},
{726, 1141063391u, 1168908072u, 0u, 0, ISNANF_TOLERANCE, 0},
{727, 3059263153u, 3067795684u, 0u, 0, ISNANF_TOLERANCE, 0},
{728, 849450947u, 3289799763u, 0u, 0, ISNANF_TOLERANCE, 0},
{729, 3353679791u, 897158391u, 0u, 0, ISNANF_TOLERANCE, 0},
{730, 1001823878u, 1016826861u, 0u, 0, ISNANF_TOLERANCE, 0},
{731, 1009130212u, 1004302940u, 0u, 0, ISNANF_TOLERANCE, 0},
{732, 3367127535u, 943136342u, 0u, 0, ISNANF_TOLERANCE, 0},
{733, 1032920919u, 3449126417u, 0u, 0, ISNANF_TOLERANCE, 0},
{734, 3281952870u, 3147012185u, 0u, 0, ISNANF_TOLERANCE, 0},
{735, 1237868497u, 3048281802u, 0u, 0, ISNANF_TOLERANCE, 0},
{736, 1153753924u, 3322269242u, 0u, 0, ISNANF_TOLERANCE, 0},
{737, 1120261759u, 892210998u, 0u, 0, ISNANF_TOLERANCE, 0},
{738, 3226328360u, 3366432856u, 0u, 0, ISNANF_TOLERANCE, 0},
{739, 3349595986u, 3251588707u, 0u, 0, ISNANF_TOLERANCE, 0},
{740, 3166889490u, 3306023523u, 0u, 0, ISNANF_TOLERANCE, 0},
{741, 1087750238u, 1099325523u, 0u, 0, ISNANF_TOLERANCE, 0},
{742, 3121620061u, 3359488363u, 0u, 0, ISNANF_TOLERANCE, 0},
{743, 1066116543u, 3072159933u, 0u, 0, ISNANF_TOLERANCE, 0},
{744, 3210898034u, 2981803389u, 0u, 0, ISNANF_TOLERANCE, 0},
{745, 3051923237u, 3364074347u, 0u, 0, ISNANF_TOLERANCE, 0},
{746, 1030612298u, 3345396001u, 0u, 0, ISNANF_TOLERANCE, 0},
{747, 3015019212u, 989161453u, 0u, 0, ISNANF_TOLERANCE, 0},
{748, 1186234578u, 858134374u, 0u, 0, ISNANF_TOLERANCE, 0},
{749, 1331680743u, 1009396165u, 0u, 0, ISNANF_TOLERANCE, 0},
{750, 847857044u, 894661023u, 0u, 0, ISNANF_TOLERANCE, 0},
{751, 3060774997u, 1326067357u, 0u, 0, ISNANF_TOLERANCE, 0},
{752, 887589411u, 1292305693u, 0u, 0, ISNANF_TOLERANCE, 0},
{753, 1045232522u, 3234993273u, 0u, 0, ISNANF_TOLERANCE, 0},
{754, 3119858470u, 962515365u, 0u, 0, ISNANF_TOLERANCE, 0},
{755, 3002873011u, 3188748064u, 0u, 0, ISNANF_TOLERANCE, 0},
{756, 3349432725u, 928848003u, 0u, 0, ISNANF_TOLERANCE, 0},
{757, 912423027u, 3184646319u, 0u, 0, ISNANF_TOLERANCE, 0},
{758, 3228795133u, 3273940030u, 0u, 0, ISNANF_TOLERANCE, 0},
{759, 3194674746u, 3112269709u, 0u, 0, ISNANF_TOLERANCE, 0},
{760, 3296784303u, 3276182352u, 0u, 0, ISNANF_TOLERANCE, 0},
{761, 965402291u, 3107104376u, 0u, 0, ISNANF_TOLERANCE, 0},
{762, 3388153589u, 3426245389u, 0u, 0, ISNANF_TOLERANCE, 0},
{763, 1133410485u, 3329658993u, 0u, 0, ISNANF_TOLERANCE, 0},
{764, 3136790322u, 1088652637u, 0u, 0, ISNANF_TOLERANCE, 0},
{765, 3369970587u, 959121458u, 0u, 0, ISNANF_TOLERANCE, 0},
{766, 1270451568u, 928393353u, 0u, 0, ISNANF_TOLERANCE, 0},
{767, 989498922u, 3088358419u, 0u, 0, ISNANF_TOLERANCE, 0},
{768, 1280215674u, 3148135875u, 0u, 0, ISNANF_TOLERANCE, 0},
{769, 1171873518u, 954709738u, 0u, 0, ISNANF_TOLERANCE, 0},
{770, 3298258100u, 935525182u, 0u, 0, ISNANF_TOLERANCE, 0},
{771, 3415208824u, 822843236u, 0u, 0, ISNANF_TOLERANCE, 0},
{772, 1001897182u, 3191875320u, 0u, 0, ISNANF_TOLERANCE, 0},
{773, 3152777939u, 3245830463u, 0u, 0, ISNANF_TOLERANCE, 0},
{774, 985903305u, 3333087577u, 0u, 0, ISNANF_TOLERANCE, 0},
{775, 3357328848u, 859306298u, 0u, 0, ISNANF_TOLERANCE, 0},
{776, 2967395608u, 3077307650u, 0u, 0, ISNANF_TOLERANCE, 0},
{777, 982612185u, 923582663u, 0u, 0, ISNANF_TOLERANCE, 0},
{778, 3267868136u, 1208301947u, 0u, 0, ISNANF_TOLERANCE, 0},
{779, 3319048157u, 1172271145u, 0u, 0, ISNANF_TOLERANCE, 0},
{780, 1144755661u, 860947435u, 0u, 0, ISNANF_TOLERANCE, 0},
{781, 840456845u, 1051585760u, 0u, 0, ISNANF_TOLERANCE, 0},
{782, 898467286u, 839254959u, 0u, 0, ISNANF_TOLERANCE, 0},
{783, 3301461672u, 1233693827u, 0u, 0, ISNANF_TOLERANCE, 0},
{784, 3364525678u, 3089849671u, 0u, 0, ISNANF_TOLERANCE, 0},
{785, 871130681u, 905123007u, 0u, 0, ISNANF_TOLERANCE, 0},
{786, 931441127u, 1133424555u, 0u, 0, ISNANF_TOLERANCE, 0},
{787, 3146660041u, 3143695961u, 0u, 0, ISNANF_TOLERANCE, 0},
{788, 3467121799u, 3023584354u, 0u, 0, ISNANF_TOLERANCE, 0},
{789, 1151257041u, 3084216427u, 0u, 0, ISNANF_TOLERANCE, 0},
{790, 3097873255u, 3219266640u, 0u, 0, ISNANF_TOLERANCE, 0},
{791, 3130670309u, 3192399254u, 0u, 0, ISNANF_TOLERANCE, 0},
{792, 1017573824u, 3130901062u, 0u, 0, ISNANF_TOLERANCE, 0},
{793, 1258369714u, 3462258576u, 0u, 0, ISNANF_TOLERANCE, 0},
{794, 1216602683u, 3371396332u, 0u, 0, ISNANF_TOLERANCE, 0},
{795, 2976429847u, 959973239u, 0u, 0, ISNANF_TOLERANCE, 0},
{796, 3297265739u, 1214184410u, 0u, 0, ISNANF_TOLERANCE, 0},
{797, 1071940738u, 3311731012u, 0u, 0, ISNANF_TOLERANCE, 0},
{798, 922601356u, 3337171870u, 0u, 0, ISNANF_TOLERANCE, 0},
{799, 3462285635u, 3444030332u, 0u, 0, ISNANF_TOLERANCE, 0},
{800, 3357177805u, 1085464241u, 0u, 0, ISNANF_TOLERANCE, 0},
{801, 3049120080u, 900832851u, 0u, 0, ISNANF_TOLERANCE, 0},
{802, 1153863660u, 1011991342u, 0u, 0, ISNANF_TOLERANCE, 0},
{803, 3034243695u, 917098003u, 0u, 0, ISNANF_TOLERANCE, 0},
{804, 809294662u, 3266461458u, 0u, 0, ISNANF_TOLERANCE, 0},
{805, 822231182u, 3393408718u, 0u, 0, ISNANF_TOLERANCE, 0},
{806, 845772797u, 3341109215u, 0u, 0, ISNANF_TOLERANCE, 0},
{807, 1249365132u, 3278686216u, 0u, 0, ISNANF_TOLERANCE, 0},
{808, 3046215730u, 3211219980u, 0u, 0, ISNANF_TOLERANCE, 0},
{809, 3047251716u, 1090787353u, 0u, 0, ISNANF_TOLERANCE, 0},
{810, 2980866154u, 1147012796u, 0u, 0, ISNANF_TOLERANCE, 0},
{811, 3131219358u, 3471261157u, 0u, 0, ISNANF_TOLERANCE, 0},
{812, 3222096285u, 1198013705u, 0u, 0, ISNANF_TOLERANCE, 0},
{813, 1297708818u, 3079166173u, 0u, 0, ISNANF_TOLERANCE, 0},
{814, 3345532722u, 3383708463u, 0u, 0, ISNANF_TOLERANCE, 0},
{815, 3418753236u, 3481843070u, 0u, 0, ISNANF_TOLERANCE, 0},
{816, 1277417964u, 3487506626u, 0u, 0, ISNANF_TOLERANCE, 0},
{817, 987577257u, 1152077087u, 0u, 0, ISNANF_TOLERANCE, 0},
{818, 3161606610u, 3190282989u, 0u, 0, ISNANF_TOLERANCE, 0},
{819, 849056171u, 910674398u, 0u, 0, ISNANF_TOLERANCE, 0},
{820, 888030585u, 3062367380u, 0u, 0, ISNANF_TOLERANCE, 0},
{821, 1043442869u, 3311393817u, 0u, 0, ISNANF_TOLERANCE, 0},
{822, 851189486u, 3007588581u, 0u, 0, ISNANF_TOLERANCE, 0},
{823, 3320923228u, 3464544249u, 0u, 0, ISNANF_TOLERANCE, 0},
{824, 1337400405u, 3488844154u, 0u, 0, ISNANF_TOLERANCE, 0},
{825, 2964339884u, 3186563447u, 0u, 0, ISNANF_TOLERANCE, 0},
{826, 3400348640u, 3129868490u, 0u, 0, ISNANF_TOLERANCE, 0},
{827, 1250249095u, 1069023744u, 0u, 0, ISNANF_TOLERANCE, 0},
{828, 3284411233u, 1173613526u, 0u, 0, ISNANF_TOLERANCE, 0},
{829, 3020883322u, 2953622587u, 0u, 0, ISNANF_TOLERANCE, 0},
{830, 1215968622u, 3469884568u, 0u, 0, ISNANF_TOLERANCE, 0},
{831, 3202319550u, 819117302u, 0u, 0, ISNANF_TOLERANCE, 0},
{832, 3061638260u, 3116222327u, 0u, 0, ISNANF_TOLERANCE, 0},
{833, 1025404104u, 1066370251u, 0u, 0, ISNANF_TOLERANCE, 0},
{834, 3138086437u, 3195983510u, 0u, 0, ISNANF_TOLERANCE, 0},
{835, 3091024506u, 3456196859u, 0u, 0, ISNANF_TOLERANCE, 0},
{836, 3362748242u, 3369843597u, 0u, 0, ISNANF_TOLERANCE, 0},
{837, 3099671635u, 3218383623u, 0u, 0, ISNANF_TOLERANCE, 0},
{838, 3068014841u, 2978226656u, 0u, 0, ISNANF_TOLERANCE, 0},
{839, 1252237719u, 1121169249u, 0u, 0, ISNANF_TOLERANCE, 0},
{840, 3327895594u, 1224511805u, 0u, 0, ISNANF_TOLERANCE, 0},
{841, 3082454432u, 889268276u, 0u, 0, ISNANF_TOLERANCE, 0},
{842, 3396161504u, 1182798837u, 0u, 0, ISNANF_TOLERANCE, 0},
{843, 1099710167u, 887180181u, 0u, 0, ISNANF_TOLERANCE, 0},
{844, 1157186482u, 1288722647u, 0u, 0, ISNANF_TOLERANCE, 0},
{845, 1282110851u, 3176633124u, 0u, 0, ISNANF_TOLERANCE, 0},
{846, 3477008113u, 1331845018u, 0u, 0, ISNANF_TOLERANCE, 0},
{847, 3292127294u, 3409957764u, 0u, 0, ISNANF_TOLERANCE, 0},
{848, 1123357102u, 3281307320u, 0u, 0, ISNANF_TOLERANCE, 0},
{849, 1106837025u, 3088080674u, 0u, 0, ISNANF_TOLERANCE, 0},
{850, 1049949008u, 1130799489u, 0u, 0, ISNANF_TOLERANCE, 0},
{851, 1253017688u, 942062372u, 0u, 0, ISNANF_TOLERANCE, 0},
{852, 1108543194u, 3281299199u, 0u, 0, ISNANF_TOLERANCE, 0},
{853, 3087985411u, 1238341456u, 0u, 0, ISNANF_TOLERANCE, 0},
{854, 3002187365u, 1073809054u, 0u, 0, ISNANF_TOLERANCE, 0},
{855, 3163283126u, 1328636961u, 0u, 0, ISNANF_TOLERANCE, 0},
{856, 1160162706u, 1264067367u, 0u, 0, ISNANF_TOLERANCE, 0},
{857, 3305715025u, 3017496063u, 0u, 0, ISNANF_TOLERANCE, 0},
{858, 1266928623u, 811778614u, 0u, 0, ISNANF_TOLERANCE, 0},
{859, 3025340297u, 1193925540u, 0u, 0, ISNANF_TOLERANCE, 0},
{860, 3438080027u, 3107114149u, 0u, 0, ISNANF_TOLERANCE, 0},
{861, 3344574751u, 3111270744u, 0u, 0, ISNANF_TOLERANCE, 0},
{862, 1152416724u, 962669179u, 0u, 0, ISNANF_TOLERANCE, 0},
{863, 1218239308u, 1126238113u, 0u, 0, ISNANF_TOLERANCE, 0},
{864, 3263310567u, 1030748197u, 0u, 0, ISNANF_TOLERANCE, 0},
{865, 835770216u, 865469272u, 0u, 0, ISNANF_TOLERANCE, 0},
{866, 3041998669u, 1160635263u, 0u, 0, ISNANF_TOLERANCE, 0},
{867, 1000313118u, 2980130729u, 0u, 0, ISNANF_TOLERANCE, 0},
{868, 972485427u, 1124312043u, 0u, 0, ISNANF_TOLERANCE, 0},
{869, 3290264612u, 1124703898u, 0u, 0, ISNANF_TOLERANCE, 0},
{870, 869072657u, 3150369767u, 0u, 0, ISNANF_TOLERANCE, 0},
{871, 3222106584u, 1183748648u, 0u, 0, ISNANF_TOLERANCE, 0},
{872, 1278946388u, 825129857u, 0u, 0, ISNANF_TOLERANCE, 0},
{873, 947914771u, 3181847068u, 0u, 0, ISNANF_TOLERANCE, 0},
{874, 3167730654u, 3195765940u, 0u, 0, ISNANF_TOLERANCE, 0},
{875, 1098530298u, 3255870890u, 0u, 0, ISNANF_TOLERANCE, 0},
{876, 3232726036u, 871038882u, 0u, 0, ISNANF_TOLERANCE, 0},
{877, 1297190916u, 811863044u, 0u, 0, ISNANF_TOLERANCE, 0},
{878, 1277649137u, 961171401u, 0u, 0, ISNANF_TOLERANCE, 0},
{879, 3203377685u, 1306427476u, 0u, 0, ISNANF_TOLERANCE, 0},
{880, 3090306474u, 3124785016u, 0u, 0, ISNANF_TOLERANCE, 0},
{881, 3244032016u, 3045313345u, 0u, 0, ISNANF_TOLERANCE, 0},
{882, 3033122376u, 3049877065u, 0u, 0, ISNANF_TOLERANCE, 0},
{883, 3019221802u, 3329183205u, 0u, 0, ISNANF_TOLERANCE, 0},
{884, 1096155623u, 1256423752u, 0u, 0, ISNANF_TOLERANCE, 0},
{885, 873151908u, 3246562559u, 0u, 0, ISNANF_TOLERANCE, 0},
{886, 3238729605u, 1298769842u, 0u, 0, ISNANF_TOLERANCE, 0},
{887, 3317196817u, 989537151u, 0u, 0, ISNANF_TOLERANCE, 0},
{888, 3374748510u, 834161190u, 0u, 0, ISNANF_TOLERANCE, 0},
{889, 3345634950u, 959901149u, 0u, 0, ISNANF_TOLERANCE, 0},
{890, 3189860276u, 883598767u, 0u, 0, ISNANF_TOLERANCE, 0},
{891, 887311687u, 1175312255u, 0u, 0, ISNANF_TOLERANCE, 0},
{892, 3396917283u, 3066326686u, 0u, 0, ISNANF_TOLERANCE, 0},
{893, 3317032737u, 3143803722u, 0u, 0, ISNANF_TOLERANCE, 0},
{894, 1200051436u, 1163802508u, 0u, 0, ISNANF_TOLERANCE, 0},
{895, 3105291012u, 1194385202u, 0u, 0, ISNANF_TOLERANCE, 0},
{896, 1306520561u, 957302464u, 0u, 0, ISNANF_TOLERANCE, 0},
{897, 1314936356u, 2985592532u, 0u, 0, ISNANF_TOLERANCE, 0},
{898, 3475052219u, 1284049853u, 0u, 0, ISNANF_TOLERANCE, 0},
{899, 3085636260u, 1107682820u, 0u, 0, ISNANF_TOLERANCE, 0},
{900, 2995058661u, 822977912u, 0u, 0, ISNANF_TOLERANCE, 0},
{901, 3393227708u, 3271879112u, 0u, 0, ISNANF_TOLERANCE, 0},
{902, 2983919425u, 3341426744u, 0u, 0, ISNANF_TOLERANCE, 0},
{903, 3182540197u, 852580839u, 0u, 0, ISNANF_TOLERANCE, 0},
{904, 3349005404u, 3080993030u, 0u, 0, ISNANF_TOLERANCE, 0},
{905, 3154720153u, 3443720494u, 0u, 0, ISNANF_TOLERANCE, 0},
{906, 1262863321u, 1219003129u, 0u, 0, ISNANF_TOLERANCE, 0},
{907, 882902102u, 1224362550u, 0u, 0, ISNANF_TOLERANCE, 0},
{908, 2995633678u, 828113666u, 0u, 0, ISNANF_TOLERANCE, 0},
{909, 1053387478u, 3184880021u, 0u, 0, ISNANF_TOLERANCE, 0},
{910, 3387653691u, 3347783852u, 0u, 0, ISNANF_TOLERANCE, 0},
{911, 3136364836u, 1018492227u, 0u, 0, ISNANF_TOLERANCE, 0},
{912, 808412264u, 941158192u, 0u, 0, ISNANF_TOLERANCE, 0},
{913, 1338680611u, 1166078045u, 0u, 0, ISNANF_TOLERANCE, 0},
{914, 1112891928u, 3074730425u, 0u, 0, ISNANF_TOLERANCE, 0},
{915, 893449284u, 1052877339u, 0u, 0, ISNANF_TOLERANCE, 0},
{916, 892311459u, 1097338393u, 0u, 0, ISNANF_TOLERANCE, 0},
{917, 3105373037u, 3246705916u, 0u, 0, ISNANF_TOLERANCE, 0},
{918, 1190105283u, 3033907262u, 0u, 0, ISNANF_TOLERANCE, 0},
{919, 1011225926u, 1180485180u, 0u, 0, ISNANF_TOLERANCE, 0},
{920, 1043025031u, 987068973u, 0u, 0, ISNANF_TOLERANCE, 0},
{921, 3410531037u, 2953541915u, 0u, 0, ISNANF_TOLERANCE, 0},
{922, 3125834184u, 896953754u, 0u, 0, ISNANF_TOLERANCE, 0},
{923, 902318189u, 849277289u, 0u, 0, ISNANF_TOLERANCE, 0},
{924, 835377647u, 3441354730u, 0u, 0, ISNANF_TOLERANCE, 0},
{925, 2976308307u, 1286944060u, 0u, 0, ISNANF_TOLERANCE, 0},
{926, 3213624815u, 2987148017u, 0u, 0, ISNANF_TOLERANCE, 0},
{927, 1120888322u, 1086209113u, 0u, 0, ISNANF_TOLERANCE, 0},
{928, 1315217243u, 3396371713u, 0u, 0, ISNANF_TOLERANCE, 0},
{929, 3137758475u, 1039403054u, 0u, 0, ISNANF_TOLERANCE, 0},
{930, 1040617590u, 1034835971u, 0u, 0, ISNANF_TOLERANCE, 0},
{931, 955384253u, 3344785562u, 0u, 0, ISNANF_TOLERANCE, 0},
{932, 853063496u, 3317415965u, 0u, 0, ISNANF_TOLERANCE, 0},
{933, 823111402u, 877253523u, 0u, 0, ISNANF_TOLERANCE, 0},
{934, 3061417900u, 1172208065u, 0u, 0, ISNANF_TOLERANCE, 0},
{935, 904255535u, 1019967545u, 0u, 0, ISNANF_TOLERANCE, 0},
{936, 1022984119u, 3113891410u, 0u, 0, ISNANF_TOLERANCE, 0},
{937, 997362368u, 3112875428u, 0u, 0, ISNANF_TOLERANCE, 0},
{938, 900933520u, 1100589187u, 0u, 0, ISNANF_TOLERANCE, 0},
{939, 1168623062u, 1143306482u, 0u, 0, ISNANF_TOLERANCE, 0},
{940, 878737490u, 3269908326u, 0u, 0, ISNANF_TOLERANCE, 0},
{941, 1039827284u, 1072928888u, 0u, 0, ISNANF_TOLERANCE, 0},
{942, 1021564080u, 1064468397u, 0u, 0, ISNANF_TOLERANCE, 0},
{943, 3458669745u, 3033299853u, 0u, 0, ISNANF_TOLERANCE, 0},
{944, 3327516316u, 3405380971u, 0u, 0, ISNANF_TOLERANCE, 0},
{945, 1040711112u, 3229444200u, 0u, 0, ISNANF_TOLERANCE, 0},
{946, 1134528351u, 3365952513u, 0u, 0, ISNANF_TOLERANCE, 0},
{947, 3039884464u, 1170612785u, 0u, 0, ISNANF_TOLERANCE, 0},
{948, 3414352838u, 3350285760u, 0u, 0, ISNANF_TOLERANCE, 0},
{949, 1133689539u, 1067460093u, 0u, 0, ISNANF_TOLERANCE, 0},
{950, 3455688478u, 3333091960u, 0u, 0, ISNANF_TOLERANCE, 0},
{951, 1137634874u, 1137038869u, 0u, 0, ISNANF_TOLERANCE, 0},
{952, 3415502662u, 955510692u, 0u, 0, ISNANF_TOLERANCE, 0},
{953, 954999730u, 969618597u, 0u, 0, ISNANF_TOLERANCE, 0},
{954, 1066157309u, 3241712664u, 0u, 0, ISNANF_TOLERANCE, 0},
{955, 3436353675u, 1174967495u, 0u, 0, ISNANF_TOLERANCE, 0},
{956, 940437609u, 860372396u, 0u, 0, ISNANF_TOLERANCE, 0},
{957, 3108347547u, 3434003435u, 0u, 0, ISNANF_TOLERANCE, 0},
{958, 3064200154u, 3158080507u, 0u, 0, ISNANF_TOLERANCE, 0},
{959, 1023889593u, 2979304683u, 0u, 0, ISNANF_TOLERANCE, 0},
{960, 3272661536u, 3461799138u, 0u, 0, ISNANF_TOLERANCE, 0},
{961, 1170245333u, 1233406410u, 0u, 0, ISNANF_TOLERANCE, 0},
{962, 1219052056u, 3369557946u, 0u, 0, ISNANF_TOLERANCE, 0},
{963, 3318983619u, 3259663338u, 0u, 0, ISNANF_TOLERANCE, 0},
{964, 3372118621u, 837597103u, 0u, 0, ISNANF_TOLERANCE, 0},
{965, 3146190320u, 889646054u, 0u, 0, ISNANF_TOLERANCE, 0},
{966, 1299683827u, 966031619u, 0u, 0, ISNANF_TOLERANCE, 0},
{967, 3190796331u, 1320011850u, 0u, 0, ISNANF_TOLERANCE, 0},
{968, 2965838479u, 805822032u, 0u, 0, ISNANF_TOLERANCE, 0},
{969, 3086068902u, 3484245751u, 0u, 0, ISNANF_TOLERANCE, 0},
{970, 3064155399u, 3176569312u, 0u, 0, ISNANF_TOLERANCE, 0},
{971, 836858201u, 3132995403u, 0u, 0, ISNANF_TOLERANCE, 0},
{972, 3040314717u, 1071290674u, 0u, 0, ISNANF_TOLERANCE, 0},
{973, 3257224022u, 3361778245u, 0u, 0, ISNANF_TOLERANCE, 0},
{974, 1229268598u, 1066965677u, 0u, 0, ISNANF_TOLERANCE, 0},
{975, 3184078812u, 871003709u, 0u, 0, ISNANF_TOLERANCE, 0},
{976, 871255076u, 3446104825u, 0u, 0, ISNANF_TOLERANCE, 0},
{977, 1086717248u, 3423795374u, 0u, 0, ISNANF_TOLERANCE, 0},
{978, 3434884607u, 3029593823u, 0u, 0, ISNANF_TOLERANCE, 0},
{979, 3464955606u, 1017987696u, 0u, 0, ISNANF_TOLERANCE, 0},
{980, 1025278524u, 3121856207u, 0u, 0, ISNANF_TOLERANCE, 0},
{981, 1242829722u, 3233935671u, 0u, 0, ISNANF_TOLERANCE, 0},
{982, 3075149137u, 1117325737u, 0u, 0, ISNANF_TOLERANCE, 0},
{983, 1200927971u, 1317167489u, 0u, 0, ISNANF_TOLERANCE, 0},
{984, 3326858092u, 3452602832u, 0u, 0, ISNANF_TOLERANCE, 0},
{985, 2995203347u, 1021818696u, 0u, 0, ISNANF_TOLERANCE, 0},
{986, 1246019790u, 850632217u, 0u, 0, ISNANF_TOLERANCE, 0},
{987, 3184801644u, 1137974313u, 0u, 0, ISNANF_TOLERANCE, 0},
{988, 1136052740u, 3244616020u, 0u, 0, ISNANF_TOLERANCE, 0},
{989, 1069009211u, 3002507482u, 0u, 0, ISNANF_TOLERANCE, 0},
{990, 1015670780u, 1101217251u, 0u, 0, ISNANF_TOLERANCE, 0},
{991, 1012543234u, 1116520440u, 0u, 0, ISNANF_TOLERANCE, 0},
{992, 3316611992u, 3394732912u, 0u, 0, ISNANF_TOLERANCE, 0},
{993, 3012101436u, 3307846870u, 0u, 0, ISNANF_TOLERANCE, 0},
{994, 1087942795u, 3316660295u, 0u, 0, ISNANF_TOLERANCE, 0},
{995, 3426365713u, 3069778532u, 0u, 0, ISNANF_TOLERANCE, 0},
{996, 3066654389u, 3443934204u, 0u, 0, ISNANF_TOLERANCE, 0},
{997, 3295326432u, 1313396175u, 0u, 0, ISNANF_TOLERANCE, 0},
{998, 3318835308u, 3277583511u, 0u, 0, ISNANF_TOLERANCE, 0},
{999, 3283555717u, 891875120u, 0u, 0, ISNANF_TOLERANCE, 0},
{1000, 3381255420u, 3015406047u, 0u, 0, ISNANF_TOLERANCE, 0},
{1001, 3040485181u, 3375450886u, 0u, 0, ISNANF_TOLERANCE, 0},
{1002, 3388772093u, 1032597076u, 0u, 0, ISNANF_TOLERANCE, 0},
{1003, 954670189u, 1144923689u, 0u, 0, ISNANF_TOLERANCE, 0},
{1004, 1319200415u, 3387555900u, 0u, 0, ISNANF_TOLERANCE, 0},
{1005, 1279324488u, 3228401212u, 0u, 0, ISNANF_TOLERANCE, 0},
{1006, 3217795424u, 865577227u, 0u, 0, ISNANF_TOLERANCE, 0},
{1007, 3455131757u, 1260217257u, 0u, 0, ISNANF_TOLERANCE, 0},
{1008, 2982636375u, 3162157233u, 0u, 0, ISNANF_TOLERANCE, 0},
{1009, 1246947517u, 1087951909u, 0u, 0, ISNANF_TOLERANCE, 0},
{1010, 3396723577u, 869285240u, 0u, 0, ISNANF_TOLERANCE, 0},
{1011, 3433761025u, 3060143904u, 0u, 0, ISNANF_TOLERANCE, 0},
{1012, 3201187455u, 900233172u, 0u, 0, ISNANF_TOLERANCE, 0},
{1013, 1173247961u, 1191127979u, 0u, 0, ISNANF_TOLERANCE, 0},
{1014, 3037297123u, 3346394818u, 0u, 0, ISNANF_TOLERANCE, 0},
{1015, 3248534678u, 1323683800u, 0u, 0, ISNANF_TOLERANCE, 0},
{1016, 3083019343u, 3033309444u, 0u, 0, ISNANF_TOLERANCE, 0},
{1017, 3042018375u, 3203882372u, 0u, 0, ISNANF_TOLERANCE, 0},
{1018, 1082862511u, 3032804719u, 0u, 0, ISNANF_TOLERANCE, 0},
{1019, 3157626955u, 3483653298u, 0u, 0, ISNANF_TOLERANCE, 0},
{1020, 1341821683u, 3003675365u, 0u, 0, ISNANF_TOLERANCE, 0},
{1021, 881101379u, 1190838126u, 0u, 0, ISNANF_TOLERANCE, 0},
{1022, 1079061705u, 2960507663u, 0u, 0, ISNANF_TOLERANCE, 0},
{1023, 3182695954u, 3256861672u, 0u, 0, ISNANF_TOLERANCE, 0},
{1024, 1105291533u, 3482971524u, 0u, 0, ISNANF_TOLERANCE, 0},
{1025, 1016023520u, 3227712090u, 0u, 0, ISNANF_TOLERANCE, 0},
{1026, 3370691006u, 1295870514u, 0u, 0, ISNANF_TOLERANCE, 0},
{1027, 1156767169u, 1049756240u, 0u, 0, ISNANF_TOLERANCE, 0},
{1028, 3077020499u, 894671462u, 0u, 0, ISNANF_TOLERANCE, 0},
{1029, 1104284039u, 3040211914u, 0u, 0, ISNANF_TOLERANCE, 0},
{1030, 3335212901u, 3486414589u, 0u, 0, ISNANF_TOLERANCE, 0},
{1031, 1093697541u, 3193708441u, 0u, 0, ISNANF_TOLERANCE, 0},
{1032, 3266691185u, 1160074593u, 0u, 0, ISNANF_TOLERANCE, 0},
{1033, 3179003144u, 1108615803u, 0u, 0, ISNANF_TOLERANCE, 0},
{1034, 1094115255u, 3008610212u, 0u, 0, ISNANF_TOLERANCE, 0},
{1035, 2994604730u, 973792195u, 0u, 0, ISNANF_TOLERANCE, 0},
{1036, 3424086808u, 3260140004u, 0u, 0, ISNANF_TOLERANCE, 0},
{1037, 2957266025u, 917932067u, 0u, 0, ISNANF_TOLERANCE, 0},
{1038, 3353608773u, 1134068114u, 0u, 0, ISNANF_TOLERANCE, 0},
{1039, 2985838945u, 3118475644u, 0u, 0, ISNANF_TOLERANCE, 0},
{1040, 973664327u, 1319516167u, 0u, 0, ISNANF_TOLERANCE, 0},
{1041, 882878091u, 3136970767u, 0u, 0, ISNANF_TOLERANCE, 0},
{1042, 1098662266u, 833740182u, 0u, 0, ISNANF_TOLERANCE, 0},
{1043, 927582555u, 947955456u, 0u, 0, ISNANF_TOLERANCE, 0},
{1044, 3111440310u, 3067634077u, 0u, 0, ISNANF_TOLERANCE, 0},
{1045, 3476083859u, 966439623u, 0u, 0, ISNANF_TOLERANCE, 0},
{1046, 3038754840u, 932009686u, 0u, 0, ISNANF_TOLERANCE, 0},
{1047, 979878744u, 1232482646u, 0u, 0, ISNANF_TOLERANCE, 0},
{1048, 3464546616u, 3205527253u, 0u, 0, ISNANF_TOLERANCE, 0},
{1049, 1002542205u, 3152136093u, 0u, 0, ISNANF_TOLERANCE, 0},
{1050, 3443552129u, 3165561391u, 0u, 0, ISNANF_TOLERANCE, 0},
{1051, 1287620154u, 3119707283u, 0u, 0, ISNANF_TOLERANCE, 0},
{1052, 820906845u, 1196920413u, 0u, 0, ISNANF_TOLERANCE, 0},
{1053, 860108361u, 921064349u, 0u, 0, ISNANF_TOLERANCE, 0},
{1054, 946058434u, 1249928879u, 0u, 0, ISNANF_TOLERANCE, 0},
{1055, 3073260205u, 3093124531u, 0u, 0, ISNANF_TOLERANCE, 0},
{1056, 1245702957u, 894348966u, 0u, 0, ISNANF_TOLERANCE, 0},
{1057, 989655126u, 1308376568u, 0u, 0, ISNANF_TOLERANCE, 0},
{1058, 1002715618u, 1191006977u, 0u, 0, ISNANF_TOLERANCE, 0},
{1059, 3087802274u, 897541752u, 0u, 0, ISNANF_TOLERANCE, 0},
{1060, 1000863905u, 1196831314u, 0u, 0, ISNANF_TOLERANCE, 0},
{1061, 3415763001u, 3032518431u, 0u, 0, ISNANF_TOLERANCE, 0},
{1062, 2979924820u, 1100234812u, 0u, 0, ISNANF_TOLERANCE, 0},
{1063, 3283471961u, 1260093226u, 0u, 0, ISNANF_TOLERANCE, 0},
{1064, 3311210827u, 1192192264u, 0u, 0, ISNANF_TOLERANCE, 0},
{1065, 3026311911u, 2968974374u, 0u, 0, ISNANF_TOLERANCE, 0},
{1066, 1198307901u, 1116328249u, 0u, 0, ISNANF_TOLERANCE, 0},
{1067, 1288901567u, 1296370667u, 0u, 0, ISNANF_TOLERANCE, 0},
{1068, 922255363u, 958305289u, 0u, 0, ISNANF_TOLERANCE, 0},
{1069, 1113104661u, 944376032u, 0u, 0, ISNANF_TOLERANCE, 0},
{1070, 1136714348u, 828849087u, 0u, 0, ISNANF_TOLERANCE, 0},
{1071, 3002059872u, 1136817970u, 0u, 0, ISNANF_TOLERANCE, 0},
{1072, 948856035u, 1015466475u, 0u, 0, ISNANF_TOLERANCE, 0},
{1073, 1062512367u, 3229559531u, 0u, 0, ISNANF_TOLERANCE, 0},
{1074, 3486907092u, 823220784u, 0u, 0, ISNANF_TOLERANCE, 0},
{1075, 3015049792u, 3078555978u, 0u, 0, ISNANF_TOLERANCE, 0},
{1076, 1162027071u, 3308983387u, 0u, 0, ISNANF_TOLERANCE, 0},
{1077, 1034561811u, 1054043114u, 0u, 0, ISNANF_TOLERANCE, 0},
{1078, 853827378u, 898656161u, 0u, 0, ISNANF_TOLERANCE, 0},
{1079, 3271615417u, 3209997200u, 0u, 0, ISNANF_TOLERANCE, 0},
{1080, 1042014529u, 1146708584u, 0u, 0, ISNANF_TOLERANCE, 0},
{1081, 1177157787u, 3090208179u, 0u, 0, ISNANF_TOLERANCE, 0},
{1082, 3196144817u, 1056118717u, 0u, 0, ISNANF_TOLERANCE, 0},
{1083, 3432084552u, 2997091781u, 0u, 0, ISNANF_TOLERANCE, 0},
{1084, 1309658335u, 1010219988u, 0u, 0, ISNANF_TOLERANCE, 0},
{1085, 3004373345u, 873739132u, 0u, 0, ISNANF_TOLERANCE, 0},
{1086, 2997667929u, 1038223245u, 0u, 0, ISNANF_TOLERANCE, 0},
{1087, 1226494979u, 2991604792u, 0u, 0, ISNANF_TOLERANCE, 0},
{1088, 3100289712u, 3456334210u, 0u, 0, ISNANF_TOLERANCE, 0},
{1089, 3375507013u, 1306310823u, 0u, 0, ISNANF_TOLERANCE, 0},
{1090, 3460699001u, 3096700943u, 0u, 0, ISNANF_TOLERANCE, 0},
{1091, 3079231719u, 1044386263u, 0u, 0, ISNANF_TOLERANCE, 0},
{1092, 3093951884u, 1014115231u, 0u, 0, ISNANF_TOLERANCE, 0},
{1093, 3468023178u, 1209565017u, 0u, 0, ISNANF_TOLERANCE, 0},
{1094, 3008182310u, 1258900986u, 0u, 0, ISNANF_TOLERANCE, 0},
{1095, 1204196034u, 3298625731u, 0u, 0, ISNANF_TOLERANCE, 0},
{1096, 3459877411u, 2960476959u, 0u, 0, ISNANF_TOLERANCE, 0},
{1097, 909696559u, 1163075690u, 0u, 0, ISNANF_TOLERANCE, 0},
{1098, 1161439847u, 943449277u, 0u, 0, ISNANF_TOLERANCE, 0},
{1099, 908663107u, 939489763u, 0u, 0, ISNANF_TOLERANCE, 0},
{1100, 1055319316u, 3261813492u, 0u, 0, ISNANF_TOLERANCE, 0},
{1101, 1084378658u, 1009650785u, 0u, 0, ISNANF_TOLERANCE, 0},
{1102, 3053887750u, 3341786453u, 0u, 0, ISNANF_TOLERANCE, 0},
{1103, 3022828828u, 881335251u, 0u, 0, ISNANF_TOLERANCE, 0},
{1104, 2995476576u, 3194911588u, 0u, 0, ISNANF_TOLERANCE, 0},
{1105, 1226473697u, 821025132u, 0u, 0, ISNANF_TOLERANCE, 0},
{1106, 1123114742u, 1229815537u, 0u, 0, ISNANF_TOLERANCE, 0},
{1107, 1258114435u, 1291336083u, 0u, 0, ISNANF_TOLERANCE, 0},
{1108, 2983818103u, 3015402015u, 0u, 0, ISNANF_TOLERANCE, 0},
{1109, 3468040845u, 3066966245u, 0u, 0, ISNANF_TOLERANCE, 0},
{1110, 1178825761u, 1113195286u, 0u, 0, ISNANF_TOLERANCE, 0},
{1111, 3059266302u, 878503862u, 0u, 0, ISNANF_TOLERANCE, 0},
{1112, 3223384012u, 1130486973u, 0u, 0, ISNANF_TOLERANCE, 0},
{1113, 1019964626u, 1235133609u, 0u, 0, ISNANF_TOLERANCE, 0},
{1114, 3445262427u, 3465211174u, 0u, 0, ISNANF_TOLERANCE, 0},
{1115, 1125653081u, 1207799746u, 0u, 0, ISNANF_TOLERANCE, 0},
{1116, 3337652712u, 3025581813u, 0u, 0, ISNANF_TOLERANCE, 0},
{1117, 1184753508u, 3147374485u, 0u, 0, ISNANF_TOLERANCE, 0},
{1118, 996404791u, 3353251979u, 0u, 0, ISNANF_TOLERANCE, 0},
{1119, 1188439315u, 1113484271u, 0u, 0, ISNANF_TOLERANCE, 0},
{1120, 906557513u, 3006513432u, 0u, 0, ISNANF_TOLERANCE, 0},
{1121, 916831283u, 999465787u, 0u, 0, ISNANF_TOLERANCE, 0},
{1122, 996786317u, 3179221951u, 0u, 0, ISNANF_TOLERANCE, 0},
{1123, 3461635065u, 1004690387u, 0u, 0, ISNANF_TOLERANCE, 0},
{1124, 1188167943u, 1200744896u, 0u, 0, ISNANF_TOLERANCE, 0},
{1125, 3036502395u, 1172597364u, 0u, 0, ISNANF_TOLERANCE, 0},
{1126, 891257783u, 1267560050u, 0u, 0, ISNANF_TOLERANCE, 0},
{1127, 3290079438u, 846519377u, 0u, 0, ISNANF_TOLERANCE, 0},
{1128, 3350690327u, 2967953392u, 0u, 0, ISNANF_TOLERANCE, 0},
{1129, 1102061604u, 3424449935u, 0u, 0, ISNANF_TOLERANCE, 0},
{1130, 1282351521u, 3039376424u, 0u, 0, ISNANF_TOLERANCE, 0},
{1131, 3458861065u, 3392466405u, 0u, 0, ISNANF_TOLERANCE, 0},
{1132, 3095256878u, 1023623326u, 0u, 0, ISNANF_TOLERANCE, 0},
{1133, 3163373610u, 843150426u, 0u, 0, ISNANF_TOLERANCE, 0},
{1134, 3228793330u, 855146890u, 0u, 0, ISNANF_TOLERANCE, 0},
{1135, 3422194733u, 893873945u, 0u, 0, ISNANF_TOLERANCE, 0},
{1136, 3083885296u, 974543672u, 0u, 0, ISNANF_TOLERANCE, 0},
{1137, 1261940623u, 3402349985u, 0u, 0, ISNANF_TOLERANCE, 0},
{1138, 825039660u, 3426717554u, 0u, 0, ISNANF_TOLERANCE, 0},
{1139, 3400603081u, 3234396843u, 0u, 0, ISNANF_TOLERANCE, 0},
{1140, 1219411812u, 2961857939u, 0u, 0, ISNANF_TOLERANCE, 0},
{1141, 3094833770u, 805351108u, 0u, 0, ISNANF_TOLERANCE, 0},
{1142, 3139250800u, 3079109479u, 0u, 0, ISNANF_TOLERANCE, 0},
{1143, 886201503u, 3272760705u, 0u, 0, ISNANF_TOLERANCE, 0},
{1144, 3297366026u, 1089966380u, 0u, 0, ISNANF_TOLERANCE, 0},
{1145, 1218488455u, 3309646450u, 0u, 0, ISNANF_TOLERANCE, 0},
{1146, 3040358923u, 3093401553u, 0u, 0, ISNANF_TOLERANCE, 0},
{1147, 862346861u, 3411853707u, 0u, 0, ISNANF_TOLERANCE, 0},
{1148, 1283938137u, 1196383822u, 0u, 0, ISNANF_TOLERANCE, 0},
{1149, 3182551696u, 3029982441u, 0u, 0, ISNANF_TOLERANCE, 0},
{1150, 1317098613u, 949986176u, 0u, 0, ISNANF_TOLERANCE, 0},
{1151, 3116209179u, 3303588342u, 0u, 0, ISNANF_TOLERANCE, 0},
{1152, 3431703657u, 3014443710u, 0u, 0, ISNANF_TOLERANCE, 0},
{1153, 3239728775u, 927815421u, 0u, 0, ISNANF_TOLERANCE, 0},
{1154, 3207141672u, 933456504u, 0u, 0, ISNANF_TOLERANCE, 0},
{1155, 3154378805u, 905462392u, 0u, 0, ISNANF_TOLERANCE, 0},
{1156, 3069658155u, 1041452042u, 0u, 0, ISNANF_TOLERANCE, 0},
{1157, 3313160088u, 2964063309u, 0u, 0, ISNANF_TOLERANCE, 0},
{1158, 3207056527u, 3384206601u, 0u, 0, ISNANF_TOLERANCE, 0},
{1159, 1284174954u, 3436881197u, 0u, 0, ISNANF_TOLERANCE, 0},
{1160, 3156081645u, 3308839704u, 0u, 0, ISNANF_TOLERANCE, 0},
{1161, 1063693032u, 976661408u, 0u, 0, ISNANF_TOLERANCE, 0},
{1162, 3036026175u, 1251203998u, 0u, 0, ISNANF_TOLERANCE, 0},
{1163, 1102631663u, 3396951425u, 0u, 0, ISNANF_TOLERANCE, 0},
{1164, 968803479u, 992989712u, 0u, 0, ISNANF_TOLERANCE, 0},
{1165, 3273080388u, 3109405906u, 0u, 0, ISNANF_TOLERANCE, 0},
{1166, 1172529774u, 3294550127u, 0u, 0, ISNANF_TOLERANCE, 0},
{1167, 1306695905u, 1292690378u, 0u, 0, ISNANF_TOLERANCE, 0},
{1168, 1003649752u, 1218792138u, 0u, 0, ISNANF_TOLERANCE, 0},
{1169, 1078478376u, 1326246424u, 0u, 0, ISNANF_TOLERANCE, 0},
{1170, 3158855023u, 3151283866u, 0u, 0, ISNANF_TOLERANCE, 0},
{1171, 1165177679u, 3276237026u, 0u, 0, ISNANF_TOLERANCE, 0},
{1172, 870472127u, 3332532333u, 0u, 0, ISNANF_TOLERANCE, 0},
{1173, 3403009513u, 3381966453u, 0u, 0, ISNANF_TOLERANCE, 0},
{1174, 816825508u, 3032174124u, 0u, 0, ISNANF_TOLERANCE, 0},
{1175, 952348506u, 3377573987u, 0u, 0, ISNANF_TOLERANCE, 0},
{1176, 839544701u, 3419900937u, 0u, 0, ISNANF_TOLERANCE, 0},
{1177, 2967454456u, 3313359047u, 0u, 0, ISNANF_TOLERANCE, 0},
{1178, 1222777442u, 1125769920u, 0u, 0, ISNANF_TOLERANCE, 0},
{1179, 1325324763u, 978336043u, 0u, 0, ISNANF_TOLERANCE, 0},
{1180, 3363524213u, 3202991311u, 0u, 0, ISNANF_TOLERANCE, 0},
{1181, 1158950321u, 1073578913u, 0u, 0, ISNANF_TOLERANCE, 0},
{1182, 903129873u, 3416864271u, 0u, 0, ISNANF_TOLERANCE, 0},
{1183, 2997685349u, 1123653663u, 0u, 0, ISNANF_TOLERANCE, 0},
{1184, 3078339944u, 988173985u, 0u, 0, ISNANF_TOLERANCE, 0},
{1185, 1208345407u, 1254181270u, 0u, 0, ISNANF_TOLERANCE, 0},
{1186, 3003262042u, 1327277116u, 0u, 0, ISNANF_TOLERANCE, 0},
{1187, 1258634105u, 1247426200u, 0u, 0, ISNANF_TOLERANCE, 0},
{1188, 1248478509u, 1287895126u, 0u, 0, ISNANF_TOLERANCE, 0},
{1189, 1153863988u, 3430539165u, 0u, 0, ISNANF_TOLERANCE, 0},
{1190, 1235620969u, 866627358u, 0u, 0, ISNANF_TOLERANCE, 0},
{1191, 1097120930u, 3221726305u, 0u, 0, ISNANF_TOLERANCE, 0},
{1192, 3469778622u, 1200179013u, 0u, 0, ISNANF_TOLERANCE, 0},
{1193, 1147712200u, 931865525u, 0u, 0, ISNANF_TOLERANCE, 0},
{1194, 812694172u, 1136276190u, 0u, 0, ISNANF_TOLERANCE, 0},
{1195, 862266739u, 3139447362u, 0u, 0, ISNANF_TOLERANCE, 0},
{1196, 1124721745u, 3058969650u, 0u, 0, ISNANF_TOLERANCE, 0},
{1197, 3261744304u, 1043806501u, 0u, 0, ISNANF_TOLERANCE, 0},
{1198, 832324055u, 2954061156u, 0u, 0, ISNANF_TOLERANCE, 0},
{1199, 805759679u, 903848557u, 0u, 0, ISNANF_TOLERANCE, 0},
{1200, 2983396015u, 872299138u, 0u, 0, ISNANF_TOLERANCE, 0},
{1201, 1064922416u, 1320485628u, 0u, 0, ISNANF_TOLERANCE, 0},
{1202, 868114980u, 3213276361u, 0u, 0, ISNANF_TOLERANCE, 0},
{1203, 3303160152u, 3075455322u, 0u, 0, ISNANF_TOLERANCE, 0},
{1204, 1315090496u, 3269683237u, 0u, 0, ISNANF_TOLERANCE, 0},
{1205, 850876090u, 3365795667u, 0u, 0, ISNANF_TOLERANCE, 0},
{1206, 3230403187u, 1322841992u, 0u, 0, ISNANF_TOLERANCE, 0},
{1207, 1335399673u, 974138676u, 0u, 0, ISNANF_TOLERANCE, 0},
{1208, 1072458508u, 3372833993u, 0u, 0, ISNANF_TOLERANCE, 0},
{1209, 3303015249u, 3015039539u, 0u, 0, ISNANF_TOLERANCE, 0},
{1210, 3252139741u, 1059615003u, 0u, 0, ISNANF_TOLERANCE, 0},
{1211, 3468519966u, 3113982619u, 0u, 0, ISNANF_TOLERANCE, 0},
{1212, 1006231203u, 897530770u, 0u, 0, ISNANF_TOLERANCE, 0},
{1213, 951554138u, 1001144381u, 0u, 0, ISNANF_TOLERANCE, 0},
{1214, 942046828u, 986341002u, 0u, 0, ISNANF_TOLERANCE, 0},
{1215, 2968517146u, 951832467u, 0u, 0, ISNANF_TOLERANCE, 0},
{1216, 3319723279u, 3414482416u, 0u, 0, ISNANF_TOLERANCE, 0},
{1217, 3255104167u, 928827688u, 0u, 0, ISNANF_TOLERANCE, 0},
{1218, 1155477903u, 3104812800u, 0u, 0, ISNANF_TOLERANCE, 0},
{1219, 3273889176u, 980486479u, 0u, 0, ISNANF_TOLERANCE, 0},
{1220, 3237813668u, 3441016803u, 0u, 0, ISNANF_TOLERANCE, 0},
{1221, 1228207362u, 2985476579u, 0u, 0, ISNANF_TOLERANCE, 0},
{1222, 975349337u, 1311932596u, 0u, 0, ISNANF_TOLERANCE, 0},
{1223, 2982583196u, 3132904446u, 0u, 0, ISNANF_TOLERANCE, 0},
{1224, 1290175785u, 3008182462u, 0u, 0, ISNANF_TOLERANCE, 0},
{1225, 981908840u, 3314038398u, 0u, 0, ISNANF_TOLERANCE, 0},
{1226, 941187647u, 1107765599u, 0u, 0, ISNANF_TOLERANCE, 0},
{1227, 1214223128u, 3225536822u, 0u, 0, ISNANF_TOLERANCE, 0},
{1228, 3422922584u, 1086391131u, 0u, 0, ISNANF_TOLERANCE, 0},
{1229, 1315857601u, 3487600045u, 0u, 0, ISNANF_TOLERANCE, 0},
{1230, 3453226030u, 3233768835u, 0u, 0, ISNANF_TOLERANCE, 0},
{1231, 1078359574u, 3199175230u, 0u, 0, ISNANF_TOLERANCE, 0},
{1232, 1029557624u, 3302959071u, 0u, 0, ISNANF_TOLERANCE, 0},
{1233, 1207675424u, 3042692550u, 0u, 0, ISNANF_TOLERANCE, 0},
{1234, 1028355074u, 3442294040u, 0u, 0, ISNANF_TOLERANCE, 0},
{1235, 3119299090u, 1187096397u, 0u, 0, ISNANF_TOLERANCE, 0},
{1236, 1248421894u, 3367769132u, 0u, 0, ISNANF_TOLERANCE, 0},
{1237, 3353251994u, 1095517730u, 0u, 0, ISNANF_TOLERANCE, 0},
{1238, 876926659u, 3288089977u, 0u, 0, ISNANF_TOLERANCE, 0},
{1239, 1076752219u, 876236939u, 0u, 0, ISNANF_TOLERANCE, 0},
{1240, 3388531942u, 2988520062u, 0u, 0, ISNANF_TOLERANCE, 0},
{1241, 1273395082u, 3031189261u, 0u, 0, ISNANF_TOLERANCE, 0},
{1242, 3385588183u, 3258252464u, 0u, 0, ISNANF_TOLERANCE, 0},
{1243, 862047095u, 829323655u, 0u, 0, ISNANF_TOLERANCE, 0},
{1244, 3192315328u, 3289489214u, 0u, 0, ISNANF_TOLERANCE, 0},
{1245, 3441804648u, 3274638356u, 0u, 0, ISNANF_TOLERANCE, 0},
{1246, 837368567u, 3228474927u, 0u, 0, ISNANF_TOLERANCE, 0},
{1247, 3392827417u, 1277961150u, 0u, 0, ISNANF_TOLERANCE, 0},
{1248, 1161241793u, 1328003707u, 0u, 0, ISNANF_TOLERANCE, 0},
{1249, 856495732u, 3123041418u, 0u, 0, ISNANF_TOLERANCE, 0},
{1250, 3034494183u, 3041579130u, 0u, 0, ISNANF_TOLERANCE, 0},
{1251, 1171318485u, 3374409104u, 0u, 0, ISNANF_TOLERANCE, 0},
{1252, 3047748143u, 831102792u, 0u, 0, ISNANF_TOLERANCE, 0},
{1253, 1001216371u, 3052357038u, 0u, 0, ISNANF_TOLERANCE, 0},
{1254, 2999541351u, 3085461799u, 0u, 0, ISNANF_TOLERANCE, 0},
{1255, 912515889u, 1074635609u, 0u, 0, ISNANF_TOLERANCE, 0},
{1256, 3391452505u, 897989232u, 0u, 0, ISNANF_TOLERANCE, 0},
{1257, 3249603369u, 3147662248u, 0u, 0, ISNANF_TOLERANCE, 0},
{1258, 1220264047u, 2960450369u, 0u, 0, ISNANF_TOLERANCE, 0},
{1259, 3169816394u, 988430929u, 0u, 0, ISNANF_TOLERANCE, 0},
{1260, 3098997418u, 3002162688u, 0u, 0, ISNANF_TOLERANCE, 0},
{1261, 3282212423u, 3174079140u, 0u, 0, ISNANF_TOLERANCE, 0},
{1262, 3352293320u, 3247843425u, 0u, 0, ISNANF_TOLERANCE, 0},
{1263, 3296358441u, 875645354u, 0u, 0, ISNANF_TOLERANCE, 0},
{1264, 1197828352u, 3245614728u, 0u, 0, ISNANF_TOLERANCE, 0},
{1265, 3340510371u, 914930263u, 0u, 0, ISNANF_TOLERANCE, 0},
{1266, 1127109339u, 3368125489u, 0u, 0, ISNANF_TOLERANCE, 0},
{1267, 816173492u, 1083268662u, 0u, 0, ISNANF_TOLERANCE, 0},
{1268, 909467381u, 1232375752u, 0u, 0, ISNANF_TOLERANCE, 0},
{1269, 1200599955u, 2981200675u, 0u, 0, ISNANF_TOLERANCE, 0},
{1270, 962230977u, 2988248037u, 0u, 0, ISNANF_TOLERANCE, 0},
{1271, 2996667337u, 1068572835u, 0u, 0, ISNANF_TOLERANCE, 0},
{1272, 3192887808u, 3191848339u, 0u, 0, ISNANF_TOLERANCE, 0},
{1273, 3237183876u, 3179379969u, 0u, 0, ISNANF_TOLERANCE, 0},
{1274, 939285924u, 3056079386u, 0u, 0, ISNANF_TOLERANCE, 0},
{1275, 944050180u, 3452557879u, 0u, 0, ISNANF_TOLERANCE, 0},
{1276, 3058135703u, 3090284601u, 0u, 0, ISNANF_TOLERANCE, 0},
{1277, 3480592662u, 3261728191u, 0u, 0, ISNANF_TOLERANCE, 0},
{1278, 3061939312u, 3274418540u, 0u, 0, ISNANF_TOLERANCE, 0},
{1279, 1003299981u, 853295521u, 0u, 0, ISNANF_TOLERANCE, 0},
{1280, 1155775526u, 1255814444u, 0u, 0, ISNANF_TOLERANCE, 0},
{1281, 1234491880u, 3408568717u, 0u, 0, ISNANF_TOLERANCE, 0},
{1282, 2143289344u, 2143289344u, 1065353216u, 0, ISNANF_TOLERANCE, 0},
{1283, 4290772992u, 4290772992u, 1065353216u, 0, ISNANF_TOLERANCE, 0},
{1284, 2139095040u, 2139095040u, 0u, 0, ISNANF_TOLERANCE, 0},
{1285, 4286578688u, 4286578688u, 0u, 0, ISNANF_TOLERANCE, 0},
{1286, 2143289344u, 2143289344u, 1065353216u, 0, ISNANF_TOLERANCE, 0},
{1287, 4290772992u, 4290772992u, 1065353216u, 0, ISNANF_TOLERANCE, 0},
{1288, 2139095040u, 2139095040u, 0u, 0, ISNANF_TOLERANCE, 0},
{1289, 4286578688u, 4286578688u, 0u, 0, ISNANF_TOLERANCE, 0},
{1290, 2143289344u, 2143289344u, 1065353216u, 0, ISNANF_TOLERANCE, 0},
{1291, 4290772992u, 4290772992u, 1065353216u, 0, ISNANF_TOLERANCE, 0},
{1292, 2139095040u, 2139095040u, 0u, 0, ISNANF_TOLERANCE, 0},
{1293, 4286578688u, 4286578688u, 0u, 0, ISNANF_TOLERANCE, 0},
{1294, 2143289344u, 2143289344u, 1065353216u, 0, ISNANF_TOLERANCE, 0},
{1295, 4290772992u, 4290772992u, 1065353216u, 0, ISNANF_TOLERANCE, 0},
{1296, 2139095040u, 2139095040u, 0u, 0, ISNANF_TOLERANCE, 0},
{1297, 4286578688u, 4286578688u, 0u, 0, ISNANF_TOLERANCE, 0},
{1298, 2143289344u, 2143289344u, 1065353216u, 0, ISNANF_TOLERANCE, 0},
{1299, 4290772992u, 4290772992u, 1065353216u, 0, ISNANF_TOLERANCE, 0},
{1300, 2139095040u, 2139095040u, 0u, 0, ISNANF_TOLERANCE, 0},
{1301, 4286578688u, 4286578688u, 0u, 0, ISNANF_TOLERANCE, 0},
{1302, 2143289344u, 2143289344u, 1065353216u, 0, ISNANF_TOLERANCE, 0},
{1303, 4290772992u, 4290772992u, 1065353216u, 0, ISNANF_TOLERANCE, 0},
{1304, 2139095040u, 2139095040u, 0u, 0, ISNANF_TOLERANCE, 0},
{1305, 4286578688u, 4286578688u, 0u, 0, ISNANF_TOLERANCE, 0},
{1306, 2143289344u, 2143289344u, 1065353216u, 0, ISNANF_TOLERANCE, 0},
{1307, 4290772992u, 4290772992u, 1065353216u, 0, ISNANF_TOLERANCE, 0},
{1308, 2139095040u, 2139095040u, 0u, 0, ISNANF_TOLERANCE, 0},
{1309, 4286578688u, 4286578688u, 0u, 0, ISNANF_TOLERANCE, 0},
{1310, 2143289344u, 2143289344u, 1065353216u, 0, ISNANF_TOLERANCE, 0},
{1311, 4290772992u, 4290772992u, 1065353216u, 0, ISNANF_TOLERANCE, 0},
{1312, 2139095040u, 2139095040u, 0u, 0, ISNANF_TOLERANCE, 0},
{1313, 4286578688u, 4286578688u, 0u, 0, ISNANF_TOLERANCE, 0},
{1314, 2143289344u, 2143289344u, 1065353216u, 0, ISNANF_TOLERANCE, 0},
{1315, 4290772992u, 4290772992u, 1065353216u, 0, ISNANF_TOLERANCE, 0},
{1316, 2139095040u, 2139095040u, 0u, 0, ISNANF_TOLERANCE, 0},
{1317, 4286578688u, 4286578688u, 0u, 0, ISNANF_TOLERANCE, 0},
{1318, 2143289344u, 2143289344u, 1065353216u, 0, ISNANF_TOLERANCE, 0},
{1319, 4290772992u, 4290772992u, 1065353216u, 0, ISNANF_TOLERANCE, 0},
{1320, 2139095040u, 2139095040u, 0u, 0, ISNANF_TOLERANCE, 0},
{1321, 4286578688u, 4286578688u, 0u, 0, ISNANF_TOLERANCE, 0}

// AUTOMATICALLY GENERATED VECTORS STOP

};

#endif // CYGONCE_LIBM_ISNANF_H multiple inclusion protection

// EOF isnanf.h
