#ifndef CYGONCE_LIBM_GAMMA_H
#define CYGONCE_LIBM_GAMMA_H
//===========================================================================
//
//      gammaf.h
//
//      Test vectors for testing of gammaf() math library function
//
//===========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####
// -------------------------------------------
// This file is part of eCos, the Embedded Configurable Operating System.
// Copyright (C) 2012 Free Software Foundation, Inc.
//
// eCos is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 or (at your option) any later
// version.
//
// eCos is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
// for more details.
//
// You should have received a copy of the GNU General Public License
// along with eCos; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//
// As a special exception, if other files instantiate templates or use
// macros or inline functions from this file, or you compile this file
// and link it with other works to produce a work based on this file,
// this file does not by itself cause the resulting work to be covered by
// the GNU General Public License. However the source code for this file
// must still be made available in accordance with section (3) of the GNU
// General Public License v2.
//
// This exception does not invalidate any other reasons why a work based
// on this file might be covered by the GNU General Public License.
// -------------------------------------------
// ####ECOSGPLCOPYRIGHTEND####
//===========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):
// Contributors:  visar, ilijak
// Date:        1998-02-13
// Purpose:
// Description:
// Usage:       #include "vectors/gammaf.h"
//
//####DESCRIPTIONEND####
//
//===========================================================================


// CONFIGURATION

#include <pkgconf/libm.h>   // Configuration header


// INCLUDES

#include <cyg/infra/cyg_type.h>    // Common type definitions and support
#include "vectors/vector_support_float.h"// extra support for math tests

#define GAMMA_TOLERANCE 1.0E-04

static const Cyg_libm_test_float_vec_t gammaf_vec[] = {

// AUTOMATICALLY GENERATED VECTORS START

{0, 3214514586u, 2147508200u, 3182352542u, 0, GAMMA_TOLERANCE, 0},
{1, 3214430700u, 2147508200u, 3181956062u, 0, GAMMA_TOLERANCE, 0},
{2, 3214346813u, 2147508200u, 3181542364u, 0, GAMMA_TOLERANCE, 0},
{3, 3214262927u, 2147508200u, 3181111256u, 0, GAMMA_TOLERANCE, 0},
{4, 3214179041u, 2147508200u, 3180662520u, 0, GAMMA_TOLERANCE, 0},
{5, 3214095155u, 2147508200u, 3180195945u, 0, GAMMA_TOLERANCE, 0},
{6, 3214011269u, 2147508200u, 3179711309u, 0, GAMMA_TOLERANCE, 0},
{7, 3213927383u, 2147508200u, 3179134344u, 0, GAMMA_TOLERANCE, 0},
{8, 3213843497u, 2147508200u, 3178091474u, 0, GAMMA_TOLERANCE, 0},
{9, 3213759611u, 2147508200u, 3177011103u, 0, GAMMA_TOLERANCE, 0},
{10, 3213675725u, 2147508200u, 3175892750u, 0, GAMMA_TOLERANCE, 0},
{11, 3213591839u, 2147508200u, 3174735922u, 0, GAMMA_TOLERANCE, 0},
{12, 3213507953u, 2147508200u, 3173540112u, 0, GAMMA_TOLERANCE, 0},
{13, 3213424067u, 2147508200u, 3172304802u, 0, GAMMA_TOLERANCE, 0},
{14, 3213340180u, 2147508200u, 3171029445u, 0, GAMMA_TOLERANCE, 0},
{15, 3213256294u, 2147508200u, 3168533229u, 0, GAMMA_TOLERANCE, 0},
{16, 3213172408u, 2147508200u, 3165819122u, 0, GAMMA_TOLERANCE, 0},
{17, 3213088522u, 2147508200u, 3163021599u, 0, GAMMA_TOLERANCE, 0},
{18, 3213004636u, 2147508200u, 3157773750u, 0, GAMMA_TOLERANCE, 0},
{19, 3212920750u, 2147508200u, 3149559224u, 0, GAMMA_TOLERANCE, 0},
{20, 3212836864u, 2147508200u, 0u, 0, GAMMA_TOLERANCE, 0},
{21, 3212669092u, 2147508200u, 1002428834u, 0, GAMMA_TOLERANCE, 0},
{22, 3212501320u, 2147508200u, 1010996688u, 0, GAMMA_TOLERANCE, 0},
{23, 3212333548u, 2147508200u, 1016332991u, 0, GAMMA_TOLERANCE, 0},
{24, 3212165775u, 2147508200u, 1019749225u, 0, GAMMA_TOLERANCE, 0},
{25, 3211998003u, 2147508200u, 1023259210u, 0, GAMMA_TOLERANCE, 0},
{26, 3211830231u, 2147508200u, 1025137303u, 0, GAMMA_TOLERANCE, 0},
{27, 3211662459u, 2147508200u, 1026988282u, 0, GAMMA_TOLERANCE, 0},
{28, 3211494687u, 2147508200u, 1028888405u, 0, GAMMA_TOLERANCE, 0},
{29, 3211326915u, 2147508200u, 1030838469u, 0, GAMMA_TOLERANCE, 0},
{30, 3211159142u, 2147508200u, 1032319047u, 0, GAMMA_TOLERANCE, 0},
{31, 3210991370u, 2147508200u, 1033345266u, 0, GAMMA_TOLERANCE, 0},
{32, 3210823598u, 2147508200u, 1034397726u, 0, GAMMA_TOLERANCE, 0},
{33, 3210655826u, 2147508200u, 1035476878u, 0, GAMMA_TOLERANCE, 0},
{34, 3210488054u, 2147508200u, 1036583185u, 0, GAMMA_TOLERANCE, 0},
{35, 3210320282u, 2147508200u, 1037717128u, 0, GAMMA_TOLERANCE, 0},
{36, 3210152509u, 2147508200u, 1038879207u, 0, GAMMA_TOLERANCE, 0},
{37, 3209984737u, 2147508200u, 1040069921u, 0, GAMMA_TOLERANCE, 0},
{38, 3209816965u, 2147508200u, 1040738598u, 0, GAMMA_TOLERANCE, 0},
{39, 3209649193u, 2147508200u, 1041363397u, 0, GAMMA_TOLERANCE, 0},
{40, 3209481421u, 2147508200u, 1042003336u, 0, GAMMA_TOLERANCE, 0},
{41, 3209313649u, 2147508200u, 1042658707u, 0, GAMMA_TOLERANCE, 0},
{42, 3209145876u, 2147508200u, 1043329818u, 0, GAMMA_TOLERANCE, 0},
{43, 3208978104u, 2147508200u, 1044016973u, 0, GAMMA_TOLERANCE, 0},
{44, 3208810332u, 2147508200u, 1044720500u, 0, GAMMA_TOLERANCE, 0},
{45, 3208642560u, 2147508200u, 1045440738u, 0, GAMMA_TOLERANCE, 0},
{46, 3208474788u, 2147508200u, 1046178035u, 0, GAMMA_TOLERANCE, 0},
{47, 3208307016u, 2147508200u, 1046932755u, 0, GAMMA_TOLERANCE, 0},
{48, 3208139244u, 2147508200u, 1047705272u, 0, GAMMA_TOLERANCE, 0},
{49, 3207971471u, 2147508200u, 1048495986u, 0, GAMMA_TOLERANCE, 0},
{50, 3207803699u, 2147508200u, 1048940645u, 0, GAMMA_TOLERANCE, 0},
{51, 3207635927u, 2147508200u, 1049354808u, 0, GAMMA_TOLERANCE, 0},
{52, 3207468155u, 2147508200u, 1049778702u, 0, GAMMA_TOLERANCE, 0},
{53, 3207300383u, 2147508200u, 1050212555u, 0, GAMMA_TOLERANCE, 0},
{54, 3207132611u, 2147508200u, 1050656608u, 0, GAMMA_TOLERANCE, 0},
{55, 3206964838u, 2147508200u, 1051111112u, 0, GAMMA_TOLERANCE, 0},
{56, 3206797066u, 2147508200u, 1051576324u, 0, GAMMA_TOLERANCE, 0},
{57, 3206629294u, 2147508200u, 1052052518u, 0, GAMMA_TOLERANCE, 0},
{58, 3206461522u, 2147508200u, 1052539978u, 0, GAMMA_TOLERANCE, 0},
{59, 3206293750u, 2147508200u, 1053039002u, 0, GAMMA_TOLERANCE, 0},
{60, 3206125978u, 2147508200u, 1053549901u, 0, GAMMA_TOLERANCE, 0},
{61, 3205958205u, 2147508200u, 1054073007u, 0, GAMMA_TOLERANCE, 0},
{62, 3205790433u, 2147508200u, 1054608655u, 0, GAMMA_TOLERANCE, 0},
{63, 3205622661u, 2147508200u, 1055157205u, 0, GAMMA_TOLERANCE, 0},
{64, 3205454889u, 2147508200u, 1055719041u, 0, GAMMA_TOLERANCE, 0},
{65, 3205287117u, 2147508200u, 1056294554u, 0, GAMMA_TOLERANCE, 0},
{66, 3205119345u, 2147508200u, 1056884165u, 0, GAMMA_TOLERANCE, 0},
{67, 3204951572u, 2147508200u, 1057226463u, 0, GAMMA_TOLERANCE, 0},
{68, 3204783800u, 2147508200u, 1057536039u, 0, GAMMA_TOLERANCE, 0},
{69, 3204616028u, 2147508200u, 1057853361u, 0, GAMMA_TOLERANCE, 0},
{70, 3204448256u, 2147508200u, 1058178690u, 0, GAMMA_TOLERANCE, 0},
{71, 3204112712u, 2147508200u, 1058512300u, 0, GAMMA_TOLERANCE, 0},
{72, 3203777167u, 2147508200u, 1058854482u, 0, GAMMA_TOLERANCE, 0},
{73, 3203441623u, 2147508200u, 1059205542u, 0, GAMMA_TOLERANCE, 0},
{74, 3203106079u, 2147508200u, 1059565811u, 0, GAMMA_TOLERANCE, 0},
{75, 3202770534u, 2147508200u, 1059935636u, 0, GAMMA_TOLERANCE, 0},
{76, 3202434990u, 2147508200u, 1060315390u, 0, GAMMA_TOLERANCE, 0},
{77, 3202099446u, 2147508200u, 1060705468u, 0, GAMMA_TOLERANCE, 0},
{78, 3201763901u, 2147508200u, 1061106295u, 0, GAMMA_TOLERANCE, 0},
{79, 3201428357u, 2147508200u, 1061518321u, 0, GAMMA_TOLERANCE, 0},
{80, 3201092813u, 2147508200u, 1061942035u, 0, GAMMA_TOLERANCE, 0},
{81, 3200757268u, 2147508200u, 1062377960u, 0, GAMMA_TOLERANCE, 0},
{82, 3200421724u, 2147508200u, 1062826654u, 0, GAMMA_TOLERANCE, 0},
{83, 3200086180u, 2147508200u, 1063288726u, 0, GAMMA_TOLERANCE, 0},
{84, 3199750636u, 2147508200u, 1063764827u, 0, GAMMA_TOLERANCE, 0},
{85, 3199415091u, 2147508200u, 1064255670u, 0, GAMMA_TOLERANCE, 0},
{86, 3199079547u, 2147508200u, 1064762021u, 0, GAMMA_TOLERANCE, 0},
{87, 3198744003u, 2147508200u, 1065284717u, 0, GAMMA_TOLERANCE, 0},
{88, 3198408458u, 2147508200u, 1065588944u, 0, GAMMA_TOLERANCE, 0},
{89, 3198072914u, 2147508200u, 1065868048u, 0, GAMMA_TOLERANCE, 0},
{90, 3197737370u, 2147508200u, 1066156828u, 0, GAMMA_TOLERANCE, 0},
{91, 3197401825u, 2147508200u, 1066455885u, 0, GAMMA_TOLERANCE, 0},
{92, 3197066281u, 2147508200u, 1066765884u, 0, GAMMA_TOLERANCE, 0},
{93, 3196730737u, 2147508200u, 1067087562u, 0, GAMMA_TOLERANCE, 0},
{94, 3196395192u, 2147508200u, 1067421737u, 0, GAMMA_TOLERANCE, 0},
{95, 3196059648u, 2147508200u, 1067769324u, 0, GAMMA_TOLERANCE, 0},
{96, 3195388559u, 2147508200u, 1068131348u, 0, GAMMA_TOLERANCE, 0},
{97, 3194717471u, 2147508200u, 1068508963u, 0, GAMMA_TOLERANCE, 0},
{98, 3194046382u, 2147508200u, 1068903479u, 0, GAMMA_TOLERANCE, 0},
{99, 3193375293u, 2147508200u, 1069316383u, 0, GAMMA_TOLERANCE, 0},
{100, 3192704205u, 2147508200u, 1069749382u, 0, GAMMA_TOLERANCE, 0},
{101, 3192033116u, 2147508200u, 1070204441u, 0, GAMMA_TOLERANCE, 0},
{102, 3191362028u, 2147508200u, 1070683845u, 0, GAMMA_TOLERANCE, 0},
{103, 3190690939u, 2147508200u, 1071190269u, 0, GAMMA_TOLERANCE, 0},
{104, 3190019850u, 2147508200u, 1071726872u, 0, GAMMA_TOLERANCE, 0},
{105, 3189348762u, 2147508200u, 1072297421u, 0, GAMMA_TOLERANCE, 0},
{106, 3188677673u, 2147508200u, 1072906465u, 0, GAMMA_TOLERANCE, 0},
{107, 3188006584u, 2147508200u, 1073559562u, 0, GAMMA_TOLERANCE, 0},
{108, 3186999951u, 2147508200u, 1074002711u, 0, GAMMA_TOLERANCE, 0},
{109, 3185657774u, 2147508200u, 1074384544u, 0, GAMMA_TOLERANCE, 0},
{110, 3184315597u, 2147508200u, 1074801778u, 0, GAMMA_TOLERANCE, 0},
{111, 3182973420u, 2147508200u, 1075261767u, 0, GAMMA_TOLERANCE, 0},
{112, 3181631242u, 2147508200u, 1075774470u, 0, GAMMA_TOLERANCE, 0},
{113, 3180289065u, 2147508200u, 1076353843u, 0, GAMMA_TOLERANCE, 0},
{114, 3178611343u, 2147508200u, 1077020325u, 0, GAMMA_TOLERANCE, 0},
{115, 3175926989u, 2147508200u, 1077805598u, 0, GAMMA_TOLERANCE, 0},
{116, 3173242634u, 2147508200u, 1078762734u, 0, GAMMA_TOLERANCE, 0},
{117, 3170222735u, 2147508200u, 1079991216u, 0, GAMMA_TOLERANCE, 0},
{118, 3164854026u, 2147508200u, 1081714376u, 0, GAMMA_TOLERANCE, 0},
{119, 3156465418u, 2147508200u, 1083387633u, 0, GAMMA_TOLERANCE, 0},
{120, 646742016u, 2147508200u, 1107968441u, 0, GAMMA_TOLERANCE, 0},
{121, 1008981770u, 2147508200u, 1083387633u, 0, GAMMA_TOLERANCE, 0},
{122, 1017370378u, 2147508200u, 1081714376u, 0, GAMMA_TOLERANCE, 0},
{123, 1022739087u, 2147508200u, 1079991216u, 0, GAMMA_TOLERANCE, 0},
{124, 1025758986u, 2147508200u, 1078762734u, 0, GAMMA_TOLERANCE, 0},
{125, 1028443341u, 2147508200u, 1077805598u, 0, GAMMA_TOLERANCE, 0},
{126, 1031127695u, 2147508200u, 1077020325u, 0, GAMMA_TOLERANCE, 0},
{127, 1032805417u, 2147508200u, 1076353843u, 0, GAMMA_TOLERANCE, 0},
{128, 1034147594u, 2147508200u, 1075774470u, 0, GAMMA_TOLERANCE, 0},
{129, 1035489772u, 2147508200u, 1075261767u, 0, GAMMA_TOLERANCE, 0},
{130, 1036831949u, 2147508200u, 1074801778u, 0, GAMMA_TOLERANCE, 0},
{131, 1038174126u, 2147508200u, 1074384544u, 0, GAMMA_TOLERANCE, 0},
{132, 1039516303u, 2147508200u, 1074002711u, 0, GAMMA_TOLERANCE, 0},
{133, 1040522936u, 2147508200u, 1073559562u, 0, GAMMA_TOLERANCE, 0},
{134, 1041194025u, 2147508200u, 1072906465u, 0, GAMMA_TOLERANCE, 0},
{135, 1041865114u, 2147508200u, 1072297421u, 0, GAMMA_TOLERANCE, 0},
{136, 1042536202u, 2147508200u, 1071726872u, 0, GAMMA_TOLERANCE, 0},
{137, 1043207291u, 2147508200u, 1071190269u, 0, GAMMA_TOLERANCE, 0},
{138, 1043878380u, 2147508200u, 1070683845u, 0, GAMMA_TOLERANCE, 0},
{139, 1044549468u, 2147508200u, 1070204441u, 0, GAMMA_TOLERANCE, 0},
{140, 1045220557u, 2147508200u, 1069749382u, 0, GAMMA_TOLERANCE, 0},
{141, 1045891645u, 2147508200u, 1069316383u, 0, GAMMA_TOLERANCE, 0},
{142, 1046562734u, 2147508200u, 1068903479u, 0, GAMMA_TOLERANCE, 0},
{143, 1047233823u, 2147508200u, 1068508963u, 0, GAMMA_TOLERANCE, 0},
{144, 1047904911u, 2147508200u, 1068131348u, 0, GAMMA_TOLERANCE, 0},
{145, 1048576000u, 2147508200u, 1067769324u, 0, GAMMA_TOLERANCE, 0},
{146, 1048911544u, 2147508200u, 1067421737u, 0, GAMMA_TOLERANCE, 0},
{147, 1049247089u, 2147508200u, 1067087562u, 0, GAMMA_TOLERANCE, 0},
{148, 1049582633u, 2147508200u, 1066765884u, 0, GAMMA_TOLERANCE, 0},
{149, 1049918177u, 2147508200u, 1066455885u, 0, GAMMA_TOLERANCE, 0},
{150, 1050253722u, 2147508200u, 1066156828u, 0, GAMMA_TOLERANCE, 0},
{151, 1050589266u, 2147508200u, 1065868048u, 0, GAMMA_TOLERANCE, 0},
{152, 1050924810u, 2147508200u, 1065588944u, 0, GAMMA_TOLERANCE, 0},
{153, 1051260355u, 2147508200u, 1065284717u, 0, GAMMA_TOLERANCE, 0},
{154, 1051595899u, 2147508200u, 1064762021u, 0, GAMMA_TOLERANCE, 0},
{155, 1051931443u, 2147508200u, 1064255670u, 0, GAMMA_TOLERANCE, 0},
{156, 1052266988u, 2147508200u, 1063764827u, 0, GAMMA_TOLERANCE, 0},
{157, 1052602532u, 2147508200u, 1063288726u, 0, GAMMA_TOLERANCE, 0},
{158, 1052938076u, 2147508200u, 1062826654u, 0, GAMMA_TOLERANCE, 0},
{159, 1053273620u, 2147508200u, 1062377960u, 0, GAMMA_TOLERANCE, 0},
{160, 1053609165u, 2147508200u, 1061942035u, 0, GAMMA_TOLERANCE, 0},
{161, 1053944709u, 2147508200u, 1061518321u, 0, GAMMA_TOLERANCE, 0},
{162, 1054280253u, 2147508200u, 1061106295u, 0, GAMMA_TOLERANCE, 0},
{163, 1054615798u, 2147508200u, 1060705468u, 0, GAMMA_TOLERANCE, 0},
{164, 1054951342u, 2147508200u, 1060315390u, 0, GAMMA_TOLERANCE, 0},
{165, 1055286886u, 2147508200u, 1059935636u, 0, GAMMA_TOLERANCE, 0},
{166, 1055622431u, 2147508200u, 1059565811u, 0, GAMMA_TOLERANCE, 0},
{167, 1055957975u, 2147508200u, 1059205542u, 0, GAMMA_TOLERANCE, 0},
{168, 1056293519u, 2147508200u, 1058854482u, 0, GAMMA_TOLERANCE, 0},
{169, 1056629064u, 2147508200u, 1058512300u, 0, GAMMA_TOLERANCE, 0},
{170, 1056964608u, 2147508200u, 1058178690u, 0, GAMMA_TOLERANCE, 0},
{171, 1057132380u, 2147508200u, 1057853361u, 0, GAMMA_TOLERANCE, 0},
{172, 1057300152u, 2147508200u, 1057536039u, 0, GAMMA_TOLERANCE, 0},
{173, 1057467924u, 2147508200u, 1057226463u, 0, GAMMA_TOLERANCE, 0},
{174, 1057635697u, 2147508200u, 1056884165u, 0, GAMMA_TOLERANCE, 0},
{175, 1057803469u, 2147508200u, 1056294554u, 0, GAMMA_TOLERANCE, 0},
{176, 1057971241u, 2147508200u, 1055719041u, 0, GAMMA_TOLERANCE, 0},
{177, 1058139013u, 2147508200u, 1055157205u, 0, GAMMA_TOLERANCE, 0},
{178, 1058306785u, 2147508200u, 1054608655u, 0, GAMMA_TOLERANCE, 0},
{179, 1058474557u, 2147508200u, 1054073007u, 0, GAMMA_TOLERANCE, 0},
{180, 1058642330u, 2147508200u, 1053549901u, 0, GAMMA_TOLERANCE, 0},
{181, 1058810102u, 2147508200u, 1053039002u, 0, GAMMA_TOLERANCE, 0},
{182, 1058977874u, 2147508200u, 1052539978u, 0, GAMMA_TOLERANCE, 0},
{183, 1059145646u, 2147508200u, 1052052518u, 0, GAMMA_TOLERANCE, 0},
{184, 1059313418u, 2147508200u, 1051576324u, 0, GAMMA_TOLERANCE, 0},
{185, 1059481190u, 2147508200u, 1051111112u, 0, GAMMA_TOLERANCE, 0},
{186, 1059648963u, 2147508200u, 1050656608u, 0, GAMMA_TOLERANCE, 0},
{187, 1059816735u, 2147508200u, 1050212555u, 0, GAMMA_TOLERANCE, 0},
{188, 1059984507u, 2147508200u, 1049778702u, 0, GAMMA_TOLERANCE, 0},
{189, 1060152279u, 2147508200u, 1049354808u, 0, GAMMA_TOLERANCE, 0},
{190, 1060320051u, 2147508200u, 1048940645u, 0, GAMMA_TOLERANCE, 0},
{191, 1060487823u, 2147508200u, 1048495986u, 0, GAMMA_TOLERANCE, 0},
{192, 1060655596u, 2147508200u, 1047705272u, 0, GAMMA_TOLERANCE, 0},
{193, 1060823368u, 2147508200u, 1046932755u, 0, GAMMA_TOLERANCE, 0},
{194, 1060991140u, 2147508200u, 1046178035u, 0, GAMMA_TOLERANCE, 0},
{195, 1061158912u, 2147508200u, 1045440738u, 0, GAMMA_TOLERANCE, 0},
{196, 1061326684u, 2147508200u, 1044720500u, 0, GAMMA_TOLERANCE, 0},
{197, 1061494456u, 2147508200u, 1044016973u, 0, GAMMA_TOLERANCE, 0},
{198, 1061662228u, 2147508200u, 1043329818u, 0, GAMMA_TOLERANCE, 0},
{199, 1061830001u, 2147508200u, 1042658707u, 0, GAMMA_TOLERANCE, 0},
{200, 1061997773u, 2147508200u, 1042003336u, 0, GAMMA_TOLERANCE, 0},
{201, 1062165545u, 2147508200u, 1041363397u, 0, GAMMA_TOLERANCE, 0},
{202, 1062333317u, 2147508200u, 1040738598u, 0, GAMMA_TOLERANCE, 0},
{203, 1062501089u, 2147508200u, 1040069921u, 0, GAMMA_TOLERANCE, 0},
{204, 1062668861u, 2147508200u, 1038879207u, 0, GAMMA_TOLERANCE, 0},
{205, 1062836634u, 2147508200u, 1037717128u, 0, GAMMA_TOLERANCE, 0},
{206, 1063004406u, 2147508200u, 1036583185u, 0, GAMMA_TOLERANCE, 0},
{207, 1063172178u, 2147508200u, 1035476878u, 0, GAMMA_TOLERANCE, 0},
{208, 1063339950u, 2147508200u, 1034397726u, 0, GAMMA_TOLERANCE, 0},
{209, 1063507722u, 2147508200u, 1033345266u, 0, GAMMA_TOLERANCE, 0},
{210, 1063675494u, 2147508200u, 1032319047u, 0, GAMMA_TOLERANCE, 0},
{211, 1063843267u, 2147508200u, 1030838469u, 0, GAMMA_TOLERANCE, 0},
{212, 1064011039u, 2147508200u, 1028888405u, 0, GAMMA_TOLERANCE, 0},
{213, 1064178811u, 2147508200u, 1026988282u, 0, GAMMA_TOLERANCE, 0},
{214, 1064346583u, 2147508200u, 1025137303u, 0, GAMMA_TOLERANCE, 0},
{215, 1064514355u, 2147508200u, 1023259210u, 0, GAMMA_TOLERANCE, 0},
{216, 1064682127u, 2147508200u, 1019749225u, 0, GAMMA_TOLERANCE, 0},
{217, 1064849900u, 2147508200u, 1016332991u, 0, GAMMA_TOLERANCE, 0},
{218, 1065017672u, 2147508200u, 1010996688u, 0, GAMMA_TOLERANCE, 0},
{219, 1065185444u, 2147508200u, 1002428834u, 0, GAMMA_TOLERANCE, 0},
{220, 1065353216u, 2147508200u, 0u, 0, GAMMA_TOLERANCE, 0},
{221, 1065437102u, 2147508200u, 3149559224u, 0, GAMMA_TOLERANCE, 0},
{222, 1065520988u, 2147508200u, 3157773750u, 0, GAMMA_TOLERANCE, 0},
{223, 1065604874u, 2147508200u, 3163021599u, 0, GAMMA_TOLERANCE, 0},
{224, 1065688760u, 2147508200u, 3165819122u, 0, GAMMA_TOLERANCE, 0},
{225, 1065772646u, 2147508200u, 3168533229u, 0, GAMMA_TOLERANCE, 0},
{226, 1065856532u, 2147508200u, 3171029445u, 0, GAMMA_TOLERANCE, 0},
{227, 1065940419u, 2147508200u, 3172304802u, 0, GAMMA_TOLERANCE, 0},
{228, 1066024305u, 2147508200u, 3173540112u, 0, GAMMA_TOLERANCE, 0},
{229, 1066108191u, 2147508200u, 3174735922u, 0, GAMMA_TOLERANCE, 0},
{230, 1066192077u, 2147508200u, 3175892750u, 0, GAMMA_TOLERANCE, 0},
{231, 1066275963u, 2147508200u, 3177011103u, 0, GAMMA_TOLERANCE, 0},
{232, 1066359849u, 2147508200u, 3178091474u, 0, GAMMA_TOLERANCE, 0},
{233, 1066443735u, 2147508200u, 3179134344u, 0, GAMMA_TOLERANCE, 0},
{234, 1066527621u, 2147508200u, 3179711309u, 0, GAMMA_TOLERANCE, 0},
{235, 1066611507u, 2147508200u, 3180195945u, 0, GAMMA_TOLERANCE, 0},
{236, 1066695393u, 2147508200u, 3180662520u, 0, GAMMA_TOLERANCE, 0},
{237, 1066779279u, 2147508200u, 3181111256u, 0, GAMMA_TOLERANCE, 0},
{238, 1066863165u, 2147508200u, 3181542364u, 0, GAMMA_TOLERANCE, 0},
{239, 1066947052u, 2147508200u, 3181956062u, 0, GAMMA_TOLERANCE, 0},
{240, 3234402267u, 2147508200u, 1084810150u, 0, GAMMA_TOLERANCE, 0},
{241, 3231108068u, 2147508200u, 1076905300u, 0, GAMMA_TOLERANCE, 0},
{242, 3226013659u, 2147508200u, 1062462412u, 0, GAMMA_TOLERANCE, 0},
{243, 3217625051u, 2147508200u, 3186450168u, 0, GAMMA_TOLERANCE, 0},
{244, 0u, 2147508200u, 1115684864u, 0, GAMMA_TOLERANCE, 0},
{245, 1070141403u, 2147508200u, 3186450168u, 0, GAMMA_TOLERANCE, 0},
{246, 1078530011u, 2147508200u, 1062462412u, 0, GAMMA_TOLERANCE, 0},
{247, 1083624420u, 2147508200u, 1076905300u, 0, GAMMA_TOLERANCE, 0},
{248, 3253731328u, 2147508200u, 1116636059u, 0, GAMMA_TOLERANCE, 0},
{249, 3252840038u, 2147508200u, 1115888477u, 0, GAMMA_TOLERANCE, 0},
{250, 3251948749u, 2147508200u, 1114624191u, 0, GAMMA_TOLERANCE, 0},
{251, 3251057459u, 2147508200u, 1113185337u, 0, GAMMA_TOLERANCE, 0},
{252, 3250166170u, 2147508200u, 1111777553u, 0, GAMMA_TOLERANCE, 0},
{253, 3249274880u, 2147508200u, 1110403168u, 0, GAMMA_TOLERANCE, 0},
{254, 3248383590u, 2147508200u, 1109064891u, 0, GAMMA_TOLERANCE, 0},
{255, 3247492301u, 2147508200u, 1107765911u, 0, GAMMA_TOLERANCE, 0},
{256, 3246601011u, 2147508200u, 1105723807u, 0, GAMMA_TOLERANCE, 0},
{257, 3245028147u, 2147508200u, 1103307493u, 0, GAMMA_TOLERANCE, 0},
{258, 3243245568u, 2147508200u, 1100998096u, 0, GAMMA_TOLERANCE, 0},
{259, 3241462989u, 2147508200u, 1098712804u, 0, GAMMA_TOLERANCE, 0},
{260, 3239680410u, 2147508200u, 1094618617u, 0, GAMMA_TOLERANCE, 0},
{261, 3237792973u, 2147508200u, 1090859057u, 0, GAMMA_TOLERANCE, 0},
{262, 3234227814u, 2147508200u, 1084505034u, 0, GAMMA_TOLERANCE, 0},
{263, 3230662656u, 2147508200u, 1075644933u, 0, GAMMA_TOLERANCE, 0},
{264, 3224580915u, 2147508200u, 1057244834u, 0, GAMMA_TOLERANCE, 0},
{265, 3213675725u, 2147508200u, 3175892750u, 0, GAMMA_TOLERANCE, 0},
{266, 1058642330u, 2147508200u, 1053549901u, 0, GAMMA_TOLERANCE, 0},
{267, 1075000115u, 2147508200u, 1042146261u, 0, GAMMA_TOLERANCE, 0},
{268, 1082130432u, 2147508200u, 1071994976u, 0, GAMMA_TOLERANCE, 0},
{269, 1085695590u, 2147508200u, 1082725955u, 0, GAMMA_TOLERANCE, 0},
{270, 1089260749u, 2147508200u, 1089135769u, 0, GAMMA_TOLERANCE, 0},
{271, 1091672474u, 2147508200u, 1093475241u, 0, GAMMA_TOLERANCE, 0},
{272, 1093455053u, 2147508200u, 1097477367u, 0, GAMMA_TOLERANCE, 0},
{273, 1095237632u, 2147508200u, 1100341234u, 0, GAMMA_TOLERANCE, 0},
{274, 1097020211u, 2147508200u, 1102616576u, 0, GAMMA_TOLERANCE, 0},
{275, 1098802790u, 2147508200u, 1105002754u, 0, GAMMA_TOLERANCE, 0},
{276, 1099746509u, 2147508200u, 1107391872u, 0, GAMMA_TOLERANCE, 0},
{277, 1100637798u, 2147508200u, 1108678601u, 0, GAMMA_TOLERANCE, 0},
{278, 1101529088u, 2147508200u, 1110005676u, 0, GAMMA_TOLERANCE, 0},
{279, 1102420378u, 2147508200u, 1111369741u, 0, GAMMA_TOLERANCE, 0},
{280, 1103311667u, 2147508200u, 1112767959u, 0, GAMMA_TOLERANCE, 0},
{281, 1104202957u, 2147508200u, 1114197898u, 0, GAMMA_TOLERANCE, 0},
{282, 1105094246u, 2147508200u, 1115657449u, 0, GAMMA_TOLERANCE, 0},
{283, 1105985536u, 2147508200u, 1116414815u, 0, GAMMA_TOLERANCE, 0}

// AUTOMATICALLY GENERATED VECTORS STOP

};

#endif // CYGONCE_LIBM_GAMMA_H multiple inclusion protection

// EOF gammaf.h
